## Build with iOS pickers, menus and actions

https://developer.apple.com/wwdc20/10052

Presenters: _Eric Dudiac, David Duncan_

- **UISlider and UIProgressView:** More consistent across platforms now
- **UIActivityIndicatorView:** New simpler design, Use color API and modern styles, Updates "pull-to-refresh"
- **UIPickerView:** Updated styling
- **UIPageControl** 
  - New interactions (scrubbing, scrolling)
  - Unlimited pages
  - Optional custom indicator icons: `.preferredIndicatorImage(UIImage())` to set all or `.setIndicatorImage(UIImage(), forPage: 0)` for a specific image
  - Multiple styles: `.backgroundStyle = .prominent` to highlight the background
- **UIColorPickerViewController**
  - New view controller for picking colors
  - Eyedropper, Favorites, Hex specification
- **UIDatePicker**
  - New compact style to select date and time
  - In-line style on iOS - great for iPad or if date picking is primary UI (matches modal presentation)
  - Useful when you have space constraints
  - Full modal calendar when selecting dates
  - Keyboard for selecting times
  - New macOS style (10.15.4)
    - Compact, modal calendar presentation
    - Supported in Catalyst apps
- **Menus**
  - Provided on `UIControl`
  - Directly supported by UIButton and UIBarButtonItem by `button.menu = UIMenu(...)`
  - Triggered via long-press by default
  - Show the menu by a simple tap by setting `button.showsMenuAsPrimaryAction = true` and don't provide a primary action
  - Back buttons implement menus to quickly jump back in navigation stack
  - Take action when the menu action is recognized, register for `UIControl.Event.menuActionTriggered`
  - `UIDeferredMenuElement` to async provide menu items
  - `UIContextMenuInteraction` to modify or replace provided menu `updateVisibleMenu(_ block menu: (UIMenu) -> UIMenu)`
    - Use `UIContextMenuInteraction.rich` to display previews and `.compact` to only show a menu
  - New `UIBarButtonItem` initializers `init(systemItem:primaryAction:menu:)`, `init(title:image:primaryAction:menu:)`
  - New `UIBarButtonItem` `.fixedSpace()` and `.flexibleSpace`
  - `UIButton` can finally be initialized using an `UIAction`: `init(type:primaryAction:)` -> **native block based API**
  - `UISegmentedControls` can now finally be initialized using `UIActions` -> **native block based API**