# 🛰️ Hyper Fetch Sockets

<p>
  <a href="https://bettertyped.com/">
    <img src="https://custom-icon-badges.demolab.com/static/v1?label=&message=BetterTyped&color=333&logo=BT" />
  </a>
  <a href="https://github.com/BetterTyped/hyper-fetch">
    <img src="https://custom-icon-badges.demolab.com/github/stars/BetterTyped/hyper-fetch?logo=star&color=118ab2" />
  </a>
  <a href="https://github.com/BetterTyped/hyper-fetch/blob/main/License.md">
    <img src="https://custom-icon-badges.demolab.com/github/license/BetterTyped/hyper-fetch?logo=law&color=yellow" />
  </a>
  <a href="https://www.npmjs.com/package/@hyper-fetch/sockets">
    <img src="https://custom-icon-badges.demolab.com/npm/v/@hyper-fetch/sockets.svg?logo=npm&color=e76f51" />
  </a>
  <a href="https://api.codeclimate.com/v1/badges/eade9435e75ecea0c004/test_coverage">
    <img src="https://api.codeclimate.com/v1/badges/eade9435e75ecea0c004/test_coverage" />
  </a>
  <a href="https://github.com/BetterTyped/hyper-fetch">
    <img src="https://custom-icon-badges.demolab.com/badge/typescript-%23007ACC.svg?logo=typescript&logoColor=white" />
  </a>
  <a href="https://www.npmjs.com/package/@hyper-fetch/sockets">
    <img src="https://custom-icon-badges.demolab.com/bundlephobia/minzip/@hyper-fetch/sockets?color=64BC4B&logo=package" />
  </a>
</p>

## About

**`Hyper Fetch Sockets`** is a library for handling `web sockets` and `server sent events`. Thanks to it, we get a
**neutral layer of control** to which we can easily integrate any available solution for dynamic two-way communication.

## Features

🔮 **Simple setup** - [Read more](https://hyperfetch.bettertyped.com/docs/guides/sockets/setup)

🎯 **Web Sockets** - [Read more](https://hyperfetch.bettertyped.com/docs/documentation/sockets/overview#Websockets)

✨ **Server sent events** - [Read more](https://hyperfetch.bettertyped.com/docs/documentation/sockets/overview#Sockets)

🚀 **Type safe** - [Read more](https://hyperfetch.bettertyped.com/docs/guides/sockets/typescript)

🎊 **SSR Support** - [Read more](https://hyperfetch.bettertyped.com/docs/documentation/getting-started/environment)

🔋 **Offline First** - [Read more](https://hyperfetch.bettertyped.com/docs/guides/sockets/offline)

📡 **Built-in adapter** - [Read more](https://hyperfetch.bettertyped.com/docs/documentation/sockets/adapter)

🎟 **Authentication** - [Read more](https://hyperfetch.bettertyped.com/docs/guides/sockets/authentication)

## Help me keep working on this project ❤️

- [Become a Sponsor on GitHub](https://github.com/sponsors/prc5)

## React

We have specially created hooks to support sockets.

[Check it out](https://hyperfetch.bettertyped.com/react/websockets)

## Sources

- #### [Installation](https://hyperfetch.bettertyped.com/docs/documentation/getting-started/installation)
- #### [Docs](https://hyperfetch.bettertyped.com/docs/documentation/sockets/overview)
- #### [API](https://hyperfetch.bettertyped.com/api/)
- #### [NPM](https://www.npmjs.com/package/@hyper-fetch/sockets)
- #### [Guides](https://hyperfetch.bettertyped.com/docs/guides/sockets/setup)

## Other Packages

- #### [Hyper Fetch](https://github.com/BetterTyped/hyper-fetch/tree/main/packages/core)
- #### [React Hyper Fetch](https://github.com/BetterTyped/hyper-fetch/tree/main/packages/react)
