---
slug: hyper-fetch-3-0
title: 🎉 Announcing Hyper Fetch 3.0
authors: [maciej, kacper]
tags: [Release]
image: ./img/release.png
date: 2022-12-29
---

## Hyper Fetch 3.0 is out! 🎉🎉

It has been exactly **one year since the first version of Hyper Fetch** was presented, and two years since work on the
tool began. The initial scope, which was ambitious in its assumptions, has been extended. We are proud to announce that
today, Hyper Fetch supports `HTTP`, `GraphQL`, `WebSockets`, `Server-Sent Events`, `React Hooks`, `persistence`, and
`offline-first` functionality, among many other features.

> Let's take a look on the 3.0 highlights and sum up 2022 together with plans for an even better 2023!

![Hyper Fetch 3.0](./img/release.png)

<!--truncate-->

We are proud to announce that apart from **achieving all major milestones** planned for this year, we've also
implemented complete support for `WebSockets and Server-Sent Events`!

## Highlights

Overview of the most important changes for Hyper Fetch 3.0 (and some of 2.0 features worth mentioning)

✨ **New and polished API** - better naming conventions and API easier to use.

🏏 **Better bouncing** - more control over debounce and throttle.

🗑️ **Improved garbage collector** - more control over garbage collecting.

📡 **Server http adapter** - http adapter for environment without XHR available.

🛰️ **Sockets** - added support for Websockets and Server Sent Events.

⛓️ **Reconnecting** - Smart reconnecting for sockets.

🫀 **Heartbeat** - Built-in heartbeat functionality for sockets.

🎊 **New Documentation** - Improved and redacted documentation (new guides part coming soon!)

---

## The most important features of `2022`

Here are a few of the most noteworthy changes we made this year:

### Type safety 🔒

We believe that TypeScript is a must-have for new libraries and systems. In Hyper Fetch, we strive to utilize TypeScript
to its full potential, such as the automatic **generation of parameter types from the endpoint string**. This may seem
like a small detail, but it is incredibly powerful and gives developer great confidence when implementing new requests
or making changes to existing ones.

[**Read More**](/docs/guides/typescript/url-parameters)

### Queues ➡️ ➡️ ➡️

One of the most important elements of Hyper Fetch, **Dispatcher-driven queues**, plays a crucial role in making this
library work so smoothly. This idea is based on a standard queuing system, but items don't have to be handled one by
one. The most interesting aspect of the queues in our system is the **efficient grouping of sent requests in isolated
pipelines**, which gives us access to repeated requests and their groups for easy interactions.

[**Read More**](/docs/guides/advanced/queueing)

### Persistence 💎

Seemingly a very typical thing, i.e. saving data to localstorage, indexedDb or other persisting storages. However, in
order to properly manage the cache, you need to properly prepare our system for interactions with asynchronous data on
the client side (for example with indexedDB) and appropriate tools for cleaning them. When we raise the bar even higher,
we will face the challenge of **persisting entire Requests**. To achieve this,
`we need to ensure communication between browser tabs/windows and hopefully we will achieve this goal next year`!

[**Read More**](/docs/guides/advanced/persistence)

### Sockets 🛰️

**_WebSockets and Server-Sent Events_** are a completely different approach to communication than traditional HTTP
requests. When we need to listen to events or emit them dynamically, the Hyper Fetch logic becomes irrelevant. We've
created a separate dedicated package that, thanks to our partly opinionated architecture, should efficiently enable to
easily handle these events. It's an early version of this package, but we're excited about continuing to work on it!

[**Read More**](/docs/documentation/sockets/overview)

### Events Architecture ✨

At first, we were not sure about basing our logic on events, but in the end **it turned out to be a hit**, because it
not only facilitated access to data from various dispersed places in our system, but also **allowed us to implement a
full lifecycle observation of our requests and incredible control over them** -
**`we can stop, resume, delete and abort our requests`**! In addition, thanks to this,
`we do not have to use Providers in the React` implementation and wrap our application in them, quickly, cleanly and
efficiently, while maintaining full isolation!

[**Read More**](/docs/documentation/core/overview#full-flow)

---

## What's next?

⚙️ Persistence of Requests in browsers and a fully prepared description of the implementation.

⚙️ Commands to help generate Hyper Fetch client schemas, code and types.

⚙️ Hyper Fetch backend implementation with controllers layer.

⚙️ Support for more and better features around queueing and feature requests from issues.

⚙️ More and better guides and examples.

⚙️ ...and few more surprises!

---

## See you in 2023! 🎉🎉

We have come this way, and we are fully ready to show what we are capable of next year!

See you soon!
