# Generated by Django 2.1.5 on 2020-03-12 07:39

from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Api',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=500, verbose_name='名称')),
                ('price', models.DecimalField(decimal_places=1, max_digits=9, verbose_name='总价')),
                ('unit_price', models.DecimalField(decimal_places=1, max_digits=9, verbose_name='单价')),
                ('community_name', models.CharField(max_length=100, verbose_name='小区名')),
                ('region', models.CharField(max_length=50, verbose_name='区域')),
                ('type', models.CharField(max_length=50, verbose_name='户型')),
                ('construction_area', models.CharField(max_length=20, verbose_name='建筑面积')),
                ('orientation', models.CharField(max_length=10, verbose_name='朝向')),
                ('decoration', models.CharField(max_length=10, verbose_name='装修情况')),
                ('floor', models.CharField(max_length=15, verbose_name='楼层')),
                ('elevator', models.CharField(max_length=10, verbose_name='电梯')),
                ('purposes', models.CharField(max_length=15, verbose_name='房屋类型')),
                ('release_date', models.DateField(verbose_name='挂牌时间')),
                ('house_structure', models.CharField(max_length=20, verbose_name='建筑类型')),
                ('image_urls', models.CharField(max_length=1500, verbose_name='房屋详情图')),
                ('from_url', models.CharField(max_length=100, verbose_name='房屋链接')),
                ('idi', models.IntegerField()),
                ('lat', models.DecimalField(decimal_places=9, max_digits=12, verbose_name='纬度')),
                ('lng', models.DecimalField(decimal_places=9, max_digits=12, verbose_name='经度')),
            ],
            options={
                'verbose_name': 'house',
                'verbose_name_plural': 'house',
            },
        ),
        migrations.CreateModel(
            name='Constructure',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('version', models.CharField(max_length=8, verbose_name='接口版本')),
                ('title', models.CharField(max_length=12, verbose_name='接口info')),
                ('layout', models.CharField(max_length=10, verbose_name='建筑类型')),
                ('num', models.IntegerField(verbose_name='数量')),
            ],
            options={
                'verbose_name': 'constructureinfo',
                'verbose_name_plural': 'constructureinfo',
            },
        ),
        migrations.CreateModel(
            name='Decortion',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('version', models.CharField(max_length=8, verbose_name='接口版本')),
                ('title', models.CharField(max_length=12, verbose_name='接口info')),
                ('layout', models.CharField(max_length=10, verbose_name='装修情况')),
                ('num', models.IntegerField(verbose_name='数量')),
                ('mean_price', models.DecimalField(decimal_places=3, max_digits=8, verbose_name='总价均价')),
                ('mean_unit_price', models.DecimalField(decimal_places=3, max_digits=8, verbose_name='单价均价')),
            ],
            options={
                'verbose_name': 'decorationinfo',
                'verbose_name_plural': 'decorationinfo',
            },
        ),
        migrations.CreateModel(
            name='Elevator',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('version', models.CharField(max_length=8, verbose_name='接口版本')),
                ('title', models.CharField(max_length=12, verbose_name='接口info')),
                ('has_el_num', models.IntegerField(verbose_name='存在电梯的房源数')),
                ('no_el_num', models.IntegerField(verbose_name='不存在电梯的房源数')),
                ('has_mean_price', models.DecimalField(decimal_places=3, max_digits=8, verbose_name='总价均价')),
                ('has_mean_unit_price', models.DecimalField(decimal_places=3, max_digits=8, verbose_name='单价均价')),
                ('no_mean_price', models.DecimalField(decimal_places=3, max_digits=8, verbose_name='总价均价')),
                ('no_mean_unit_price', models.DecimalField(decimal_places=3, max_digits=8, verbose_name='单价均价')),
            ],
            options={
                'verbose_name': 'elevatorinfo',
                'verbose_name_plural': 'elevatorinfo',
            },
        ),
        migrations.CreateModel(
            name='Floor',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('version', models.CharField(max_length=8, verbose_name='接口版本')),
                ('title', models.CharField(max_length=12, verbose_name='接口info')),
                ('floor', models.CharField(max_length=20, verbose_name='楼层')),
                ('num', models.IntegerField(verbose_name='数量')),
            ],
            options={
                'verbose_name': 'floorinfo',
                'verbose_name_plural': 'floorinfo',
            },
        ),
        migrations.CreateModel(
            name='Layout',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('version', models.CharField(max_length=8, verbose_name='接口版本')),
                ('title', models.CharField(max_length=12, verbose_name='接口info')),
                ('layout', models.CharField(max_length=20, verbose_name='户型')),
                ('num', models.IntegerField(verbose_name='数量')),
            ],
            options={
                'verbose_name': 'layoutinfo',
                'verbose_name_plural': 'layoutinfo',
            },
        ),
        migrations.CreateModel(
            name='Orientation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('version', models.CharField(max_length=8, verbose_name='接口版本')),
                ('title', models.CharField(max_length=12, verbose_name='接口info')),
                ('layout', models.CharField(max_length=15, verbose_name='房屋朝向')),
                ('num', models.IntegerField(verbose_name='数量')),
            ],
            options={
                'verbose_name': 'orientationinfo',
                'verbose_name_plural': 'orientationinfo',
            },
        ),
        migrations.CreateModel(
            name='Purposes',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('version', models.CharField(max_length=8, verbose_name='接口版本')),
                ('title', models.CharField(max_length=12, verbose_name='接口info')),
                ('layout', models.CharField(max_length=10, verbose_name='房屋用途')),
                ('num', models.IntegerField(verbose_name='数量')),
            ],
            options={
                'verbose_name': 'purposesinfo',
                'verbose_name_plural': 'purposesinfo',
            },
        ),
        migrations.CreateModel(
            name='Region',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('version', models.CharField(max_length=8, verbose_name='接口版本')),
                ('title', models.CharField(max_length=12, verbose_name='接口info')),
                ('layout', models.CharField(max_length=10, verbose_name='行政区划')),
                ('num', models.IntegerField(verbose_name='数量')),
                ('mean_price', models.DecimalField(decimal_places=3, max_digits=8, verbose_name='总价均价')),
                ('mean_unit_price', models.DecimalField(decimal_places=3, max_digits=8, verbose_name='单价均价')),
            ],
            options={
                'verbose_name': 'regioninfo',
                'verbose_name_plural': 'regioninfo',
            },
        ),
    ]
