/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.youtube.player;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import com.google.android.youtube.player.YouTubeBaseActivity;
import com.google.android.youtube.player.YouTubeInitializationResult;
import com.google.android.youtube.player.YouTubePlayer;
import com.google.android.youtube.player.internal.aa;
import com.google.android.youtube.player.internal.ab;
import com.google.android.youtube.player.internal.d;
import com.google.android.youtube.player.internal.n;
import com.google.android.youtube.player.internal.s;
import com.google.android.youtube.player.internal.t;
import com.google.android.youtube.player.internal.w;
import com.google.android.youtube.player.internal.y;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public final class YouTubePlayerView
extends ViewGroup
implements YouTubePlayer.Provider {
    private final a a;
    private final Set<View> b;
    private final b c;
    private com.google.android.youtube.player.internal.b d;
    private s e;
    private View f;
    private n g;
    private YouTubePlayer.Provider h;
    private Bundle i;
    private YouTubePlayer.OnInitializedListener j;
    private boolean k;
    private boolean l;

    public YouTubePlayerView(Context context) {
        this(context, null);
    }

    public YouTubePlayerView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public YouTubePlayerView(Context context, AttributeSet attributeSet, int n2) {
        Context context2 = context;
        if (!(context instanceof YouTubeBaseActivity)) {
            throw new IllegalStateException("A YouTubePlayerView can only be created with an Activity  which extends YouTubeBaseActivity as its context.");
        }
        this(context2, attributeSet, n2, ((YouTubeBaseActivity)context).a());
    }

    YouTubePlayerView(Context context, AttributeSet attributeSet, int n2, b b2) {
        super(ab.a(context, (Object)"context cannot be null"), attributeSet, n2);
        this.c = ab.a(b2, (Object)"listener cannot be null");
        if (this.getBackground() == null) {
            this.setBackgroundColor(-16777216);
        }
        this.setClipToPadding(false);
        this.g = new n(context);
        this.requestTransparentRegion((View)this.g);
        this.addView((View)this.g);
        this.b = new HashSet<View>();
        this.a = new a(0);
    }

    @Override
    public final void initialize(String string, YouTubePlayer.OnInitializedListener onInitializedListener) {
        ab.a(string, (Object)"Developer key cannot be null or empty");
        this.c.a(this, string, onInitializedListener);
    }

    final void a(boolean bl) {
        if (bl && Build.VERSION.SDK_INT < 14) {
            y.a("Could not enable TextureView because API level is lower than 14", new Object[0]);
            this.k = false;
            return;
        }
        this.k = bl;
    }

    final void a(final Activity activity, YouTubePlayer.Provider provider, String string, YouTubePlayer.OnInitializedListener onInitializedListener, Bundle bundle) {
        if (this.e != null || this.j != null) {
            return;
        }
        ab.a(activity, (Object)"activity cannot be null");
        this.h = ab.a(provider, (Object)"provider cannot be null");
        this.j = ab.a(onInitializedListener, (Object)"listener cannot be null");
        this.i = bundle;
        this.g.b();
        this.d = aa.a().a(this.getContext(), string, new t.a(){

            @Override
            public final void a() {
                if (YouTubePlayerView.this.d != null) {
                    YouTubePlayerView.a(YouTubePlayerView.this, activity);
                }
                YouTubePlayerView.b(YouTubePlayerView.this);
            }

            @Override
            public final void b() {
                if (!YouTubePlayerView.this.l && YouTubePlayerView.this.e != null) {
                    YouTubePlayerView.this.e.f();
                }
                YouTubePlayerView.this.g.a();
                if (YouTubePlayerView.this.indexOfChild((View)YouTubePlayerView.this.g) < 0) {
                    YouTubePlayerView.this.addView((View)YouTubePlayerView.this.g);
                    YouTubePlayerView.this.removeView(YouTubePlayerView.this.f);
                }
                YouTubePlayerView.g(YouTubePlayerView.this);
                YouTubePlayerView.h(YouTubePlayerView.this);
                YouTubePlayerView.b(YouTubePlayerView.this);
            }
        }, new t.b(){

            @Override
            public final void a(YouTubeInitializationResult youTubeInitializationResult) {
                YouTubePlayerView.this.a(youTubeInitializationResult);
                YouTubePlayerView.b(YouTubePlayerView.this);
            }
        });
        this.d.e();
    }

    private void a(YouTubeInitializationResult youTubeInitializationResult) {
        this.e = null;
        this.g.c();
        if (this.j != null) {
            this.j.onInitializationFailure(this.h, youTubeInitializationResult);
            this.j = null;
        }
    }

    final void a() {
        if (this.e != null) {
            this.e.b();
        }
    }

    final void b() {
        if (this.e != null) {
            this.e.c();
        }
    }

    final void c() {
        if (this.e != null) {
            this.e.d();
        }
    }

    final void d() {
        if (this.e != null) {
            this.e.e();
        }
    }

    final void b(boolean bl) {
        if (this.e != null) {
            this.e.b(bl);
            this.c(bl);
        }
    }

    final void c(boolean bl) {
        this.l = true;
        if (this.e != null) {
            this.e.a(bl);
        }
    }

    private void a(View view) {
        if (!(view == this.g || this.e != null && view == this.f)) {
            throw new UnsupportedOperationException("No views can be added on top of the player");
        }
    }

    public final void setPadding(int n2, int n3, int n4, int n5) {
    }

    public final void setClipToPadding(boolean bl) {
    }

    public final void addView(View view) {
        this.a(view);
        super.addView(view);
    }

    public final void addView(View view, int n2) {
        this.a(view);
        super.addView(view, n2);
    }

    public final void addView(View view, int n2, ViewGroup.LayoutParams layoutParams) {
        this.a(view);
        super.addView(view, n2, layoutParams);
    }

    public final void addView(View view, int n2, int n3) {
        this.a(view);
        super.addView(view, n2, n3);
    }

    public final void addView(View view, ViewGroup.LayoutParams layoutParams) {
        this.a(view);
        super.addView(view, layoutParams);
    }

    protected final void onMeasure(int n2, int n3) {
        if (this.getChildCount() > 0) {
            View view = this.getChildAt(0);
            view.measure(n2, n3);
            this.setMeasuredDimension(view.getMeasuredWidth(), view.getMeasuredHeight());
            return;
        }
        this.setMeasuredDimension(0, 0);
    }

    protected final void onLayout(boolean bl, int n2, int n3, int n4, int n5) {
        if (this.getChildCount() > 0) {
            this.getChildAt(0).layout(0, 0, n4 - n2, n5 - n3);
        }
    }

    public final void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        if (this.e != null) {
            this.e.a(configuration);
        }
    }

    protected final void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.getViewTreeObserver().addOnGlobalFocusChangeListener((ViewTreeObserver.OnGlobalFocusChangeListener)this.a);
    }

    protected final void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.getViewTreeObserver().removeOnGlobalFocusChangeListener((ViewTreeObserver.OnGlobalFocusChangeListener)this.a);
    }

    public final void clearChildFocus(View view) {
        if (this.hasFocusable()) {
            this.requestFocus();
            return;
        }
        super.clearChildFocus(view);
    }

    public final void requestChildFocus(View view, View view2) {
        super.requestChildFocus(view, view2);
        this.b.add(view2);
    }

    public final void focusableViewAvailable(View view) {
        super.focusableViewAvailable(view);
        this.b.add(view);
    }

    public final void addFocusables(ArrayList<View> arrayList, int n2) {
        ArrayList arrayList2 = new ArrayList();
        super.addFocusables(arrayList2, n2);
        arrayList.addAll(arrayList2);
        this.b.clear();
        this.b.addAll(arrayList2);
    }

    public final void addFocusables(ArrayList<View> arrayList, int n2, int n3) {
        ArrayList arrayList2 = new ArrayList();
        super.addFocusables(arrayList2, n2, n3);
        arrayList.addAll(arrayList2);
        this.b.clear();
        this.b.addAll(arrayList2);
    }

    public final boolean onTouchEvent(MotionEvent motionEvent) {
        super.onTouchEvent(motionEvent);
        return true;
    }

    public final boolean dispatchKeyEvent(KeyEvent keyEvent) {
        if (this.e != null) {
            if (keyEvent.getAction() == 0) {
                return this.e.a(keyEvent.getKeyCode(), keyEvent) || super.dispatchKeyEvent(keyEvent);
            }
            if (keyEvent.getAction() == 1) {
                return this.e.b(keyEvent.getKeyCode(), keyEvent) || super.dispatchKeyEvent(keyEvent);
            }
        }
        return super.dispatchKeyEvent(keyEvent);
    }

    final Bundle e() {
        if (this.e == null) {
            return this.i;
        }
        return this.e.h();
    }

    static /* synthetic */ void a(YouTubePlayerView youTubePlayerView, Activity object) {
        try {
            object = aa.a().a((Activity)object, youTubePlayerView.d, youTubePlayerView.k);
        }
        catch (w.a a2) {
            y.a("Error creating YouTubePlayerView", a2);
            youTubePlayerView.a(YouTubeInitializationResult.INTERNAL_ERROR);
            return;
        }
        youTubePlayerView.e = new s(youTubePlayerView.d, (d)object);
        youTubePlayerView.f = youTubePlayerView.e.a();
        youTubePlayerView.addView(youTubePlayerView.f);
        youTubePlayerView.removeView((View)youTubePlayerView.g);
        youTubePlayerView.c.a(youTubePlayerView);
        if (youTubePlayerView.j != null) {
            boolean bl = false;
            if (youTubePlayerView.i != null) {
                bl = youTubePlayerView.e.a(youTubePlayerView.i);
                youTubePlayerView.i = null;
            }
            youTubePlayerView.j.onInitializationSuccess(youTubePlayerView.h, youTubePlayerView.e, bl);
            youTubePlayerView.j = null;
        }
    }

    static /* synthetic */ com.google.android.youtube.player.internal.b b(YouTubePlayerView youTubePlayerView) {
        youTubePlayerView.d = null;
        return null;
    }

    static /* synthetic */ View g(YouTubePlayerView youTubePlayerView) {
        youTubePlayerView.f = null;
        return null;
    }

    static /* synthetic */ s h(YouTubePlayerView youTubePlayerView) {
        youTubePlayerView.e = null;
        return null;
    }

    private final class a
    implements ViewTreeObserver.OnGlobalFocusChangeListener {
        private a() {
        }

        public final void onGlobalFocusChanged(View view, View view2) {
            if (YouTubePlayerView.this.e != null && YouTubePlayerView.this.b.contains(view2) && !YouTubePlayerView.this.b.contains(view)) {
                YouTubePlayerView.this.e.g();
            }
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }

    static interface b {
        public void a(YouTubePlayerView var1, String var2, YouTubePlayer.OnInitializedListener var3);

        public void a(YouTubePlayerView var1);
    }
}

