/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.youtube.player;

import com.google.android.youtube.player.YouTubeInitializationResult;
import java.util.List;

public interface YouTubePlayer {
    public static final int FULLSCREEN_FLAG_CONTROL_ORIENTATION = 1;
    public static final int FULLSCREEN_FLAG_CONTROL_SYSTEM_UI = 2;
    public static final int FULLSCREEN_FLAG_ALWAYS_FULLSCREEN_IN_LANDSCAPE = 4;
    public static final int FULLSCREEN_FLAG_CUSTOM_LAYOUT = 8;

    public void release();

    public void cueVideo(String var1);

    public void cueVideo(String var1, int var2);

    public void loadVideo(String var1);

    public void loadVideo(String var1, int var2);

    public void cuePlaylist(String var1);

    public void cuePlaylist(String var1, int var2, int var3);

    public void loadPlaylist(String var1);

    public void loadPlaylist(String var1, int var2, int var3);

    public void cueVideos(List<String> var1);

    public void cueVideos(List<String> var1, int var2, int var3);

    public void loadVideos(List<String> var1);

    public void loadVideos(List<String> var1, int var2, int var3);

    public void play();

    public void pause();

    public boolean isPlaying();

    public boolean hasNext();

    public boolean hasPrevious();

    public void next();

    public void previous();

    public int getCurrentTimeMillis();

    public int getDurationMillis();

    public void seekToMillis(int var1);

    public void seekRelativeMillis(int var1);

    public void setFullscreen(boolean var1);

    public void setOnFullscreenListener(OnFullscreenListener var1);

    public void setFullscreenControlFlags(int var1);

    public int getFullscreenControlFlags();

    public void addFullscreenControlFlag(int var1);

    public void setPlayerStyle(PlayerStyle var1);

    public void setShowFullscreenButton(boolean var1);

    public void setManageAudioFocus(boolean var1);

    public void setPlaylistEventListener(PlaylistEventListener var1);

    public void setPlayerStateChangeListener(PlayerStateChangeListener var1);

    public void setPlaybackEventListener(PlaybackEventListener var1);

    public static enum ErrorReason {
        EMBEDDING_DISABLED,
        BLOCKED_FOR_APP,
        NOT_PLAYABLE,
        NETWORK_ERROR,
        UNAUTHORIZED_OVERLAY,
        PLAYER_VIEW_TOO_SMALL,
        PLAYER_VIEW_NOT_VISIBLE,
        EMPTY_PLAYLIST,
        AUTOPLAY_DISABLED,
        USER_DECLINED_RESTRICTED_CONTENT,
        USER_DECLINED_HIGH_BANDWIDTH,
        UNEXPECTED_SERVICE_DISCONNECTION,
        INTERNAL_ERROR,
        UNKNOWN;

    }

    public static enum PlayerStyle {
        DEFAULT,
        MINIMAL,
        CHROMELESS;

    }

    public static interface OnFullscreenListener {
        public void onFullscreen(boolean var1);
    }

    public static interface PlaybackEventListener {
        public void onPlaying();

        public void onPaused();

        public void onStopped();

        public void onBuffering(boolean var1);

        public void onSeekTo(int var1);
    }

    public static interface PlayerStateChangeListener {
        public void onLoading();

        public void onLoaded(String var1);

        public void onAdStarted();

        public void onVideoStarted();

        public void onVideoEnded();

        public void onError(ErrorReason var1);
    }

    public static interface PlaylistEventListener {
        public void onPrevious();

        public void onNext();

        public void onPlaylistEnded();
    }

    public static interface OnInitializedListener {
        public void onInitializationSuccess(Provider var1, YouTubePlayer var2, boolean var3);

        public void onInitializationFailure(Provider var1, YouTubeInitializationResult var2);
    }

    public static interface Provider {
        public void initialize(String var1, OnInitializedListener var2);
    }
}

