/*
 * Copyright (c) 2020
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* The following code was generated by JFlex 1.7.0 tweaked for IntelliJ platform */

package com.tang.intellij.lua.lexer;

import com.intellij.lexer.FlexLexer;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.tang.intellij.lua.lang.LuaLanguageLevel;

import java.io.Reader;

import static com.tang.intellij.lua.psi.LuaTypes.*;


/**
 * This class is a scanner generated by
 * <a href="http://www.jflex.de/">JFlex</a> 1.7.0
 * from the specification file <tt>lua.flex</tt>
 */
public class _LuaLexer implements FlexLexer {

  /** This character denotes the end of file */
  public static final int YYEOF = -1;

  /** initial size of the lookahead buffer */
  private static final int ZZ_BUFFERSIZE = 16384;

  /** lexical states */
  public static final int YYINITIAL = 0;
  public static final int xSHEBANG = 2;
  public static final int xDOUBLE_QUOTED_STRING = 4;
  public static final int xSINGLE_QUOTED_STRING = 6;
  public static final int xBLOCK_STRING = 8;
  public static final int xCOMMENT = 10;
  public static final int xBLOCK_COMMENT = 12;

  /**
   * ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
   * ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
   *                  at the beginning of a line
   * l is of the form l = 2*k, k a non negative integer
   */
  private static final int ZZ_LEXSTATE[] = {
     0,  0,  1,  1,  2,  2,  3,  3,  4,  4,  5,  5,  4, 4
  };

  /**
   * Translates characters to character classes
   * Chosen bits are [8, 6, 7]
   * Total runtime size is 2320 bytes
   */
  public static int ZZ_CMAP(int ch) {
    return ZZ_CMAP_A[(ZZ_CMAP_Y[ZZ_CMAP_Z[ch>>13]|((ch>>7)&0x3f)]<<7)|(ch&0x7f)];
  }

  /* The ZZ_CMAP_Z table has 136 entries */
  static final char ZZ_CMAP_Z[] = zzUnpackCMap(
    "\1\0\1\100\6\200\200\300");

  /* The ZZ_CMAP_Y table has 256 entries */
  static final char ZZ_CMAP_Y[] = zzUnpackCMap(
    "\1\0\1\1\53\2\1\3\22\2\1\4\37\2\1\3\137\2\100\5");

  /* The ZZ_CMAP_A table has 768 entries */
  static final char ZZ_CMAP_A[] = zzUnpackCMap(
    "\11\36\1\3\1\2\1\0\1\3\1\1\22\36\1\3\1\56\1\34\1\55\1\36\1\63\1\73\1\40\1"+
    "\65\1\66\1\62\1\10\1\67\1\17\1\16\1\64\1\12\11\5\1\71\1\70\1\60\1\32\1\57"+
    "\2\36\4\6\1\7\1\6\5\37\1\15\3\37\1\11\4\37\1\14\2\37\1\13\2\37\1\31\1\35\1"+
    "\33\1\72\1\37\1\36\1\41\1\42\1\50\1\27\1\21\1\46\1\22\1\53\1\23\1\37\1\43"+
    "\1\44\1\37\1\25\1\24\1\52\1\37\1\20\1\45\1\51\1\47\1\37\1\54\1\13\2\37\1\26"+
    "\1\74\1\30\1\61\6\36\1\0\32\36\1\0\136\36\201\37\1\4\177\37\13\4\35\37\2\4"+
    "\5\37\1\4\57\37\1\4\40\37\200\36");

  /**
   * Translates DFA states to action switch labels.
   */
  private static final int [] ZZ_ACTION = zzUnpackAction();

  private static final String ZZ_ACTION_PACKED_0 =
    "\1\0\1\1\4\0\1\2\1\3\1\4\1\5\1\6"+
    "\1\5\1\7\1\10\6\4\1\11\1\4\1\12\1\13"+
    "\1\14\1\15\1\16\1\17\7\4\1\20\1\21\1\22"+
    "\1\23\1\24\1\25\1\26\1\27\1\30\1\31\1\32"+
    "\1\33\1\34\1\35\1\36\2\37\1\0\1\5\2\0"+
    "\1\5\1\0\1\5\1\40\1\41\4\4\1\42\1\43"+
    "\1\44\2\4\1\45\1\46\12\4\1\47\1\50\1\51"+
    "\1\52\1\53\1\54\1\55\1\56\1\37\2\0\1\57"+
    "\1\0\3\5\1\60\4\0\2\4\1\61\2\4\1\62"+
    "\1\63\1\64\2\4\1\65\6\4\1\57\1\66\1\5"+
    "\6\0\2\4\1\67\1\70\5\4\1\71\1\72\1\4"+
    "\2\0\1\5\2\0\1\73\1\74\3\4\1\75\1\76"+
    "\1\77\1\4\1\100\1\101\1\0\1\5\2\0\1\102"+
    "\1\103\1\104\1\4\3\0\1\4\1\0\1\105\2\0";

  private static int [] zzUnpackAction() {
    int [] result = new int[173];
    int offset = 0;
    offset = zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAction(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /**
   * Translates a state to a row index in the transition table
   */
  private static final int [] ZZ_ROWMAP = zzUnpackRowMap();

  private static final String ZZ_ROWMAP_PACKED_0 =
    "\0\0\0\75\0\172\0\267\0\364\0\u0131\0\364\0\u016e"+
    "\0\u01ab\0\u01e8\0\364\0\u0225\0\u0262\0\u029f\0\u02dc\0\u0319"+
    "\0\u0356\0\u0393\0\u03d0\0\u040d\0\364\0\u044a\0\364\0\364"+
    "\0\u0487\0\364\0\364\0\364\0\u04c4\0\u0501\0\u053e\0\u057b"+
    "\0\u05b8\0\u05f5\0\u0632\0\u066f\0\u06ac\0\u06e9\0\u0726\0\364"+
    "\0\364\0\u0763\0\364\0\364\0\364\0\364\0\u07a0\0\364"+
    "\0\364\0\364\0\u07dd\0\u081a\0\u0857\0\u0894\0\u08d1\0\u090e"+
    "\0\u094b\0\u0988\0\u09c5\0\u0a02\0\u0a3f\0\u0a7c\0\u0ab9\0\u0af6"+
    "\0\u0b33\0\u01ab\0\u01ab\0\u01ab\0\u0b70\0\u0bad\0\u01ab\0\364"+
    "\0\u0bea\0\u0c27\0\u0c64\0\u0ca1\0\u0cde\0\u0d1b\0\u0d58\0\u0d95"+
    "\0\u0dd2\0\u0e0f\0\364\0\364\0\364\0\364\0\364\0\364"+
    "\0\364\0\364\0\364\0\u0e4c\0\u0e89\0\u0ec6\0\u09c5\0\364"+
    "\0\u0f03\0\u0f40\0\364\0\u0f7d\0\u0fba\0\u0ff7\0\u1034\0\u1071"+
    "\0\u10ae\0\u01ab\0\u10eb\0\u1128\0\u01ab\0\u01ab\0\u01ab\0\u1165"+
    "\0\u11a2\0\u01ab\0\u11df\0\u121c\0\u1259\0\u1296\0\u12d3\0\u1310"+
    "\0\u134d\0\u138a\0\u13c7\0\u1404\0\u1441\0\u147e\0\u14bb\0\u14f8"+
    "\0\u1535\0\u1572\0\u15af\0\u15ec\0\u01ab\0\u1629\0\u1666\0\u16a3"+
    "\0\u16e0\0\u171d\0\u01ab\0\u01ab\0\u175a\0\u1797\0\u17d4\0\u1811"+
    "\0\u184e\0\u188b\0\u18c8\0\u1905\0\u1942\0\u197f\0\u19bc\0\u01ab"+
    "\0\u01ab\0\u01ab\0\u19f9\0\u01ab\0\u01ab\0\u1a36\0\u1a73\0\u1ab0"+
    "\0\u1aed\0\u01ab\0\u01ab\0\u01ab\0\u1b2a\0\u1b67\0\u1ba4\0\u1be1"+
    "\0\u1c1e\0\u1c5b\0\u01ab\0\u1c98\0\u1cd5";

  private static int [] zzUnpackRowMap() {
    int [] result = new int[173];
    int offset = 0;
    offset = zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackRowMap(String packed, int offset, int [] result) {
    int i = 0;  /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int high = packed.charAt(i++) << 16;
      result[j++] = high | packed.charAt(i++);
    }
    return j;
  }

  /**
   * The transition table of the DFA
   */
  private static final int [] ZZ_TRANS = zzUnpackTrans();

  private static final String ZZ_TRANS_PACKED_0 =
    "\1\7\3\10\1\11\1\12\2\11\1\13\1\11\1\14"+
    "\3\11\1\15\1\16\1\17\1\20\1\21\1\22\1\23"+
    "\1\24\1\25\1\26\1\27\1\30\1\31\1\32\1\33"+
    "\2\7\1\11\1\34\1\35\1\36\1\11\1\37\1\11"+
    "\1\40\1\41\1\11\1\42\2\11\1\43\1\44\1\7"+
    "\1\45\1\46\1\47\1\50\1\51\1\52\1\53\1\54"+
    "\1\55\1\56\1\57\1\60\1\61\1\62\1\2\2\0"+
    "\72\2\34\0\1\63\100\0\1\64\150\0\1\65\56\0"+
    "\3\10\75\0\4\11\1\0\5\11\2\0\6\11\1\0"+
    "\1\11\7\0\1\11\1\0\14\11\25\0\1\12\1\0"+
    "\1\66\2\0\1\12\1\0\1\67\1\70\1\71\2\0"+
    "\1\66\60\0\1\12\1\0\1\66\2\0\1\12\1\72"+
    "\1\67\1\70\1\71\2\0\1\66\60\0\1\73\4\0"+
    "\1\73\3\0\1\74\75\0\1\75\61\0\4\11\1\0"+
    "\5\11\2\0\1\11\1\76\4\11\1\0\1\11\7\0"+
    "\1\11\1\0\14\11\24\0\4\11\1\0\5\11\2\0"+
    "\5\11\1\77\1\0\1\11\7\0\1\11\1\0\3\11"+
    "\1\100\10\11\24\0\4\11\1\0\5\11\2\0\4\11"+
    "\1\101\1\11\1\0\1\11\7\0\1\11\1\0\14\11"+
    "\24\0\4\11\1\0\5\11\2\0\5\11\1\102\1\0"+
    "\1\11\7\0\1\11\1\0\5\11\1\103\6\11\24\0"+
    "\4\11\1\0\5\11\2\0\1\104\5\11\1\0\1\11"+
    "\7\0\1\11\1\0\14\11\24\0\4\11\1\0\5\11"+
    "\2\0\3\11\1\105\1\106\1\11\1\0\1\11\7\0"+
    "\1\11\1\0\14\11\24\0\4\11\1\0\5\11\2\0"+
    "\4\11\1\107\1\11\1\0\1\11\7\0\1\11\1\0"+
    "\14\11\52\0\1\110\46\0\4\11\1\0\5\11\2\0"+
    "\5\11\1\111\1\0\1\11\7\0\1\11\1\0\14\11"+
    "\24\0\4\11\1\0\5\11\2\0\1\112\5\11\1\0"+
    "\1\11\7\0\1\11\1\0\14\11\24\0\4\11\1\0"+
    "\5\11\2\0\4\11\1\113\1\11\1\0\1\11\7\0"+
    "\1\11\1\0\14\11\24\0\4\11\1\0\5\11\2\0"+
    "\4\11\1\114\1\11\1\0\1\11\7\0\1\11\1\0"+
    "\1\115\5\11\1\116\5\11\24\0\4\11\1\0\5\11"+
    "\2\0\5\11\1\117\1\0\1\11\7\0\1\11\1\0"+
    "\14\11\24\0\4\11\1\0\5\11\2\0\1\120\5\11"+
    "\1\0\1\11\7\0\1\11\1\0\12\11\1\121\1\11"+
    "\24\0\4\11\1\0\5\11\2\0\6\11\1\0\1\11"+
    "\7\0\1\11\1\0\12\11\1\122\1\11\76\0\1\123"+
    "\50\0\1\124\24\0\1\125\47\0\1\126\25\0\1\127"+
    "\46\0\1\130\126\0\1\131\101\0\1\132\3\0\34\63"+
    "\1\133\1\134\37\63\35\64\1\135\2\64\1\133\34\64"+
    "\17\0\1\136\62\0\1\73\2\0\1\137\1\0\1\73"+
    "\4\0\1\137\72\0\1\70\74\0\1\140\64\0\1\141"+
    "\4\0\1\141\67\0\3\142\2\0\1\142\6\0\1\142"+
    "\5\0\1\142\11\0\2\142\3\0\1\142\1\0\1\142"+
    "\31\0\1\73\4\0\1\73\100\0\1\143\76\0\1\144"+
    "\1\145\4\0\1\146\1\0\1\147\50\0\4\11\1\0"+
    "\5\11\2\0\6\11\1\0\1\11\7\0\1\11\1\0"+
    "\10\11\1\150\1\151\2\11\24\0\4\11\1\0\5\11"+
    "\2\0\6\11\1\0\1\152\7\0\1\11\1\0\14\11"+
    "\24\0\4\11\1\0\5\11\2\0\6\11\1\0\1\11"+
    "\7\0\1\11\1\0\4\11\1\153\7\11\24\0\4\11"+
    "\1\0\5\11\2\0\6\11\1\0\1\11\7\0\1\11"+
    "\1\0\10\11\1\154\3\11\24\0\4\11\1\0\5\11"+
    "\2\0\6\11\1\0\1\11\7\0\1\11\1\0\3\11"+
    "\1\155\10\11\24\0\4\11\1\0\5\11\2\0\6\11"+
    "\1\0\1\11\7\0\1\11\1\0\10\11\1\156\3\11"+
    "\24\0\4\11\1\0\5\11\2\0\6\11\1\0\1\157"+
    "\7\0\1\11\1\0\14\11\24\0\4\11\1\0\5\11"+
    "\2\0\1\11\1\160\4\11\1\0\1\11\7\0\1\11"+
    "\1\0\14\11\24\0\4\11\1\0\5\11\2\0\6\11"+
    "\1\0\1\11\7\0\1\11\1\0\7\11\1\161\4\11"+
    "\24\0\4\11\1\0\5\11\2\0\1\162\5\11\1\0"+
    "\1\11\7\0\1\11\1\0\14\11\24\0\4\11\1\0"+
    "\5\11\2\0\6\11\1\0\1\11\7\0\1\11\1\0"+
    "\3\11\1\163\10\11\24\0\4\11\1\0\5\11\2\0"+
    "\5\11\1\164\1\0\1\11\7\0\1\11\1\0\14\11"+
    "\24\0\4\11\1\0\5\11\2\0\6\11\1\0\1\11"+
    "\7\0\1\11\1\0\10\11\1\165\3\11\24\0\4\11"+
    "\1\0\5\11\2\0\6\11\1\0\1\11\7\0\1\11"+
    "\1\0\6\11\1\166\5\11\24\0\4\11\1\0\5\11"+
    "\2\0\1\11\1\167\4\11\1\0\1\11\7\0\1\11"+
    "\1\0\14\11\24\0\4\11\1\0\5\11\2\0\3\11"+
    "\1\170\2\11\1\0\1\11\7\0\1\11\1\0\14\11"+
    "\21\0\2\63\2\0\70\63\1\0\2\64\2\0\70\64"+
    "\1\171\2\0\14\171\1\172\55\171\5\0\1\141\1\0"+
    "\1\66\2\0\1\141\6\0\1\66\60\0\2\142\1\173"+
    "\1\0\1\174\1\142\1\0\1\67\1\70\1\175\2\0"+
    "\1\173\5\0\1\142\11\0\2\142\3\0\1\142\1\0"+
    "\1\142\1\0\1\174\43\0\1\176\100\0\1\177\75\0"+
    "\1\200\76\0\1\201\50\0\4\11\1\0\5\11\2\0"+
    "\6\11\1\0\1\11\7\0\1\11\1\0\6\11\1\202"+
    "\5\11\24\0\4\11\1\0\5\11\2\0\1\11\1\203"+
    "\4\11\1\0\1\11\7\0\1\11\1\0\14\11\24\0"+
    "\4\11\1\0\5\11\2\0\1\11\1\204\4\11\1\0"+
    "\1\11\7\0\1\11\1\0\14\11\24\0\4\11\1\0"+
    "\5\11\2\0\4\11\1\205\1\11\1\0\1\11\7\0"+
    "\1\11\1\0\14\11\24\0\4\11\1\0\5\11\2\0"+
    "\6\11\1\0\1\11\7\0\1\11\1\0\1\206\13\11"+
    "\24\0\4\11\1\0\5\11\2\0\6\11\1\0\1\11"+
    "\7\0\1\11\1\0\1\207\13\11\24\0\4\11\1\0"+
    "\5\11\2\0\6\11\1\0\1\11\7\0\1\11\1\0"+
    "\4\11\1\210\7\11\24\0\4\11\1\0\5\11\2\0"+
    "\6\11\1\0\1\11\7\0\1\11\1\0\7\11\1\211"+
    "\4\11\24\0\4\11\1\0\5\11\2\0\3\11\1\212"+
    "\2\11\1\0\1\11\7\0\1\11\1\0\14\11\24\0"+
    "\4\11\1\0\5\11\2\0\1\11\1\213\4\11\1\0"+
    "\1\11\7\0\1\11\1\0\14\11\24\0\4\11\1\0"+
    "\5\11\2\0\5\11\1\214\1\0\1\11\7\0\1\11"+
    "\1\0\14\11\24\0\4\11\1\0\5\11\2\0\6\11"+
    "\1\0\1\11\7\0\1\11\1\0\3\11\1\215\10\11"+
    "\20\0\1\171\2\0\72\171\1\172\1\216\1\217\72\172"+
    "\5\0\2\142\1\173\1\137\1\174\1\142\1\0\1\67"+
    "\1\70\1\175\1\137\1\0\1\173\5\0\1\142\11\0"+
    "\2\142\3\0\1\142\1\0\1\142\1\0\1\174\32\0"+
    "\1\137\6\0\1\137\62\0\3\220\2\0\1\220\6\0"+
    "\1\220\5\0\1\220\11\0\2\220\3\0\1\220\1\0"+
    "\1\220\46\0\1\221\101\0\1\222\73\0\1\223\76\0"+
    "\1\224\50\0\4\11\1\0\5\11\2\0\1\225\5\11"+
    "\1\0\1\11\7\0\1\11\1\0\14\11\24\0\4\11"+
    "\1\0\5\11\2\0\6\11\1\0\1\11\7\0\1\11"+
    "\1\0\1\226\13\11\24\0\4\11\1\0\5\11\2\0"+
    "\3\11\1\227\2\11\1\0\1\11\7\0\1\11\1\0"+
    "\14\11\24\0\4\11\1\0\5\11\2\0\6\11\1\0"+
    "\1\11\7\0\1\11\1\0\2\11\1\230\11\11\24\0"+
    "\4\11\1\0\5\11\2\0\6\11\1\0\1\11\7\0"+
    "\1\11\1\0\3\11\1\231\10\11\24\0\4\11\1\0"+
    "\5\11\2\0\1\11\1\232\4\11\1\0\1\11\7\0"+
    "\1\11\1\0\14\11\24\0\4\11\1\0\5\11\2\0"+
    "\6\11\1\0\1\11\7\0\1\11\1\0\10\11\1\233"+
    "\3\11\24\0\4\11\1\0\5\11\2\0\6\11\1\0"+
    "\1\11\7\0\1\11\1\0\3\11\1\234\10\11\24\0"+
    "\4\11\1\0\5\11\2\0\1\11\1\235\4\11\1\0"+
    "\1\11\7\0\1\11\1\0\14\11\22\0\1\217\75\0"+
    "\1\217\13\0\1\236\62\0\2\220\1\237\1\0\1\174"+
    "\1\220\6\0\1\237\5\0\1\220\11\0\2\220\3\0"+
    "\1\220\1\0\1\220\1\0\1\174\45\0\1\240\71\0"+
    "\1\241\54\0\1\223\2\0\72\223\1\224\2\0\72\224"+
    "\4\0\4\11\1\0\5\11\2\0\5\11\1\242\1\0"+
    "\1\11\7\0\1\11\1\0\14\11\24\0\4\11\1\0"+
    "\5\11\2\0\6\11\1\0\1\11\7\0\1\11\1\0"+
    "\10\11\1\243\3\11\24\0\4\11\1\0\5\11\2\0"+
    "\6\11\1\0\1\11\7\0\1\11\1\0\5\11\1\244"+
    "\6\11\24\0\4\11\1\0\5\11\2\0\3\11\1\245"+
    "\2\11\1\0\1\11\7\0\1\11\1\0\14\11\37\0"+
    "\1\246\62\0\2\220\1\237\1\137\1\174\1\220\4\0"+
    "\1\137\1\0\1\237\5\0\1\220\11\0\2\220\3\0"+
    "\1\220\1\0\1\220\1\0\1\174\46\0\1\247\71\0"+
    "\1\250\57\0\4\11\1\0\5\11\2\0\4\11\1\251"+
    "\1\11\1\0\1\11\7\0\1\11\1\0\14\11\37\0"+
    "\1\172\102\0\1\223\71\0\1\252\56\0\4\11\1\0"+
    "\5\11\2\0\5\11\1\253\1\0\1\11\7\0\1\11"+
    "\1\0\14\11\43\0\1\254\75\0\1\255\75\0\1\224"+
    "\47\0";

  private static int [] zzUnpackTrans() {
    int [] result = new int[7442];
    int offset = 0;
    offset = zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackTrans(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      value--;
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }


  /* error codes */
  private static final int ZZ_UNKNOWN_ERROR = 0;
  private static final int ZZ_NO_MATCH = 1;
  private static final int ZZ_PUSHBACK_2BIG = 2;

  /* error messages for the codes above */
  private static final String[] ZZ_ERROR_MSG = {
    "Unknown internal scanner error",
    "Error: could not match input",
    "Error: pushback value was too large"
  };

  /**
   * ZZ_ATTRIBUTE[aState] contains the attributes of state <code>aState</code>
   */
  private static final int [] ZZ_ATTRIBUTE = zzUnpackAttribute();

  private static final String ZZ_ATTRIBUTE_PACKED_0 =
    "\1\0\1\1\2\0\1\10\1\0\1\11\3\1\1\11"+
    "\11\1\1\11\1\1\2\11\1\1\3\11\13\1\2\11"+
    "\1\1\4\11\1\1\3\11\2\1\1\0\1\1\2\0"+
    "\1\1\1\0\15\1\1\11\12\1\11\11\2\0\1\1"+
    "\1\0\1\11\2\1\1\11\4\0\24\1\6\0\14\1"+
    "\2\0\1\1\2\0\13\1\1\0\1\1\2\0\4\1"+
    "\3\0\1\1\1\0\1\1\2\0";

  private static int [] zzUnpackAttribute() {
    int [] result = new int[173];
    int offset = 0;
    offset = zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
    return result;
  }

  private static int zzUnpackAttribute(String packed, int offset, int [] result) {
    int i = 0;       /* index in packed string  */
    int j = offset;  /* index in unpacked array */
    int l = packed.length();
    while (i < l) {
      int count = packed.charAt(i++);
      int value = packed.charAt(i++);
      do result[j++] = value; while (--count > 0);
    }
    return j;
  }

  /** the input device */
  private java.io.Reader zzReader;

  /** the current state of the DFA */
  private int zzState;

  /** the current lexical state */
  private int zzLexicalState = YYINITIAL;

  /** this buffer contains the current text to be matched and is
      the source of the yytext() string */
  private CharSequence zzBuffer = "";

  /** the textposition at the last accepting state */
  private int zzMarkedPos;

  /** the current text position in the buffer */
  private int zzCurrentPos;

  /** startRead marks the beginning of the yytext() string in the buffer */
  private int zzStartRead;

  /** endRead marks the last character in the buffer, that has been read
      from input */
  private int zzEndRead;

  /**
   * zzAtBOL == true <=> the scanner is currently at the beginning of a line
   */
  private boolean zzAtBOL = true;

  /** zzAtEOF == true <=> the scanner is at the EOF */
  private boolean zzAtEOF;

  /** denotes if the user-EOF-code has already been executed */
  private boolean zzEOFDone;

  /* user code: */
    private LuaLanguageLevel level = LuaLanguageLevel.LUA54;
    public _LuaLexer(LuaLanguageLevel level) {
        this((Reader) null);
        this.level = level;
    }

    private int nBrackets = 0;
    private boolean checkAhead(char c, int offset) {
        return this.zzMarkedPos + offset < this.zzBuffer.length() && this.zzBuffer.charAt(this.zzMarkedPos + offset) == c;
    }

    private boolean checkBlock() {
        nBrackets = 0;
        if (checkAhead('[', 0)) {
            int n = 0;
            while (checkAhead('=', n + 1)) n++;
            if (checkAhead('[', n + 1)) {
                nBrackets = n;
                return true;
            }
        }
        return false;
    }

    private boolean checkDocBlock() {
        return checkAhead('-', nBrackets + 2)
            && checkAhead('-', nBrackets + 3)
            && checkAhead('-', nBrackets + 4);
    }

    private int checkBlockEnd() {
        int pos = zzMarkedPos;
        int end = zzEndRead;
        while(pos < end) {
            char c = zzBuffer.charAt(pos);
            if (c == ']') {
                pos++;
                int size = 0;
                while (pos < zzEndRead && zzBuffer.charAt(pos) == '=') {
                    size++;
                    pos++;
                }
                if (size == nBrackets && pos < zzEndRead && zzBuffer.charAt(pos) == ']') {
                    pos++;
                    break;
                }
                continue;
            }
            pos++;
        }
        return pos - zzMarkedPos;
    }


  /**
   * Creates a new scanner
   *
   * @param   in  the java.io.Reader to read input from.
   */
  public _LuaLexer(java.io.Reader in) {
    this.zzReader = in;
  }


  /**
   * Unpacks the compressed character translation table.
   *
   * @param packed   the packed character translation table
   * @return         the unpacked character translation table
   */
  private static char [] zzUnpackCMap(String packed) {
    int size = 0;
    for (int i = 0, length = packed.length(); i < length; i += 2) {
      size += packed.charAt(i);
    }
    char[] map = new char[size];
    int i = 0;  /* index in packed string  */
    int j = 0;  /* index in unpacked array */
    while (i < packed.length()) {
      int  count = packed.charAt(i++);
      char value = packed.charAt(i++);
      do map[j++] = value; while (--count > 0);
    }
    return map;
  }

  public final int getTokenStart() {
    return zzStartRead;
  }

  public final int getTokenEnd() {
    return getTokenStart() + yylength();
  }

  public void reset(CharSequence buffer, int start, int end, int initialState) {
    zzBuffer = buffer;
    zzCurrentPos = zzMarkedPos = zzStartRead = start;
    zzAtEOF  = false;
    zzAtBOL = true;
    zzEndRead = end;
    yybegin(initialState);
  }

  /**
   * Refills the input buffer.
   *
   * @return      {@code false}, iff there was new input.
   *
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  private boolean zzRefill() throws java.io.IOException {
    return true;
  }


  /**
   * Returns the current lexical state.
   */
  public final int yystate() {
    return zzLexicalState;
  }


  /**
   * Enters a new lexical state
   *
   * @param newState the new lexical state
   */
  public final void yybegin(int newState) {
    zzLexicalState = newState;
  }


  /**
   * Returns the text matched by the current regular expression.
   */
  public final CharSequence yytext() {
    return zzBuffer.subSequence(zzStartRead, zzMarkedPos);
  }


  /**
   * Returns the character at position {@code pos} from the
   * matched text.
   *
   * It is equivalent to yytext().charAt(pos), but faster
   *
   * @param pos the position of the character to fetch.
   *            A value from 0 to yylength()-1.
   *
   * @return the character at position pos
   */
  public final char yycharat(int pos) {
    return zzBuffer.charAt(zzStartRead+pos);
  }


  /**
   * Returns the length of the matched text region.
   */
  public final int yylength() {
    return zzMarkedPos-zzStartRead;
  }


  /**
   * Reports an error that occurred while scanning.
   *
   * In a wellformed scanner (no or only correct usage of
   * yypushback(int) and a match-all fallback rule) this method
   * will only be called with things that "Can't Possibly Happen".
   * If this method is called, something is seriously wrong
   * (e.g. a JFlex bug producing a faulty scanner etc.).
   *
   * Usual syntax/scanner level error handling should be done
   * in error fallback rules.
   *
   * @param   errorCode  the code of the errormessage to display
   */
  private void zzScanError(int errorCode) {
    String message;
    try {
      message = ZZ_ERROR_MSG[errorCode];
    }
    catch (ArrayIndexOutOfBoundsException e) {
      message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
    }

    throw new Error(message);
  }


  /**
   * Pushes the specified amount of characters back into the input stream.
   *
   * They will be read again by then next call of the scanning method
   *
   * @param number  the number of characters to be read again.
   *                This number must not be greater than yylength()!
   */
  public void yypushback(int number)  {
    if ( number > yylength() )
      zzScanError(ZZ_PUSHBACK_2BIG);

    zzMarkedPos -= number;
  }


  /**
   * Resumes scanning until the next regular expression is matched,
   * the end of input is encountered or an I/O-Error occurs.
   *
   * @return      the next token
   * @exception   java.io.IOException  if any I/O-Error occurs
   */
  public IElementType advance() throws java.io.IOException {
    int zzInput;
    int zzAction;

    // cached fields:
    int zzCurrentPosL;
    int zzMarkedPosL;
    int zzEndReadL = zzEndRead;
    CharSequence zzBufferL = zzBuffer;

    int [] zzTransL = ZZ_TRANS;
    int [] zzRowMapL = ZZ_ROWMAP;
    int [] zzAttrL = ZZ_ATTRIBUTE;

    while (true) {
      zzMarkedPosL = zzMarkedPos;

      zzAction = -1;

      zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

      zzState = ZZ_LEXSTATE[zzLexicalState];

      // set up zzAction for empty match case:
      int zzAttributes = zzAttrL[zzState];
      if ( (zzAttributes & 1) == 1 ) {
        zzAction = zzState;
      }


      zzForAction: {
        while (true) {

          if (zzCurrentPosL < zzEndReadL) {
            zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL/*, zzEndReadL*/);
            zzCurrentPosL += Character.charCount(zzInput);
          }
          else if (zzAtEOF) {
            zzInput = YYEOF;
            break zzForAction;
          }
          else {
            // store back cached positions
            zzCurrentPos  = zzCurrentPosL;
            zzMarkedPos   = zzMarkedPosL;
            boolean eof = zzRefill();
            // get translated positions and possibly new buffer
            zzCurrentPosL  = zzCurrentPos;
            zzMarkedPosL   = zzMarkedPos;
            zzBufferL      = zzBuffer;
            zzEndReadL     = zzEndRead;
            if (eof) {
              zzInput = YYEOF;
              break zzForAction;
            }
            else {
              zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL/*, zzEndReadL*/);
              zzCurrentPosL += Character.charCount(zzInput);
            }
          }
          int zzNext = zzTransL[ zzRowMapL[zzState] + ZZ_CMAP(zzInput) ];
          if (zzNext == -1) break zzForAction;
          zzState = zzNext;

          zzAttributes = zzAttrL[zzState];
          if ( (zzAttributes & 1) == 1 ) {
            zzAction = zzState;
            zzMarkedPosL = zzCurrentPosL;
            if ( (zzAttributes & 8) == 8 ) break zzForAction;
          }

        }
      }

      // store back cached position
      zzMarkedPos = zzMarkedPosL;

      if (zzInput == YYEOF && zzStartRead == zzCurrentPos) {
        zzAtEOF = true;
        return null;
      }
      else {
        switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
          case 1:
            { yybegin(YYINITIAL); return SHEBANG_CONTENT;
            }
            // fall through
          case 70: break;
          case 2:
            { return TokenType.BAD_CHARACTER;
            }
            // fall through
          case 71: break;
          case 3:
            { return TokenType.WHITE_SPACE;
            }
            // fall through
          case 72: break;
          case 4:
            { return ID;
            }
            // fall through
          case 73: break;
          case 5:
            { return NUMBER;
            }
            // fall through
          case 74: break;
          case 6:
            { return PLUS;
            }
            // fall through
          case 75: break;
          case 7:
            { return DOT;
            }
            // fall through
          case 76: break;
          case 8:
            { return MINUS;
            }
            // fall through
          case 77: break;
          case 9:
            { return LCURLY;
            }
            // fall through
          case 78: break;
          case 10:
            { return RCURLY;
            }
            // fall through
          case 79: break;
          case 11:
            { if (checkAhead('=', 0) || checkAhead('[', 0)) {
          yypushback(yylength());
          checkBlock();
          zzMarkedPos += checkBlockEnd();
          return STRING;
      } else {
          return LBRACK;
      }
            }
            // fall through
          case 80: break;
          case 12:
            { return ASSIGN;
            }
            // fall through
          case 81: break;
          case 13:
            { return RBRACK;
            }
            // fall through
          case 82: break;
          case 14:
            { yybegin(xDOUBLE_QUOTED_STRING); yypushback(yylength());
            }
            // fall through
          case 83: break;
          case 15:
            { yybegin(xSINGLE_QUOTED_STRING); yypushback(yylength());
            }
            // fall through
          case 84: break;
          case 16:
            { return GETN;
            }
            // fall through
          case 85: break;
          case 17:
            { return GT;
            }
            // fall through
          case 86: break;
          case 18:
            { return LT;
            }
            // fall through
          case 87: break;
          case 19:
            { return BIT_TILDE;
            }
            // fall through
          case 88: break;
          case 20:
            { return MULT;
            }
            // fall through
          case 89: break;
          case 21:
            { return MOD;
            }
            // fall through
          case 90: break;
          case 22:
            { return DIV;
            }
            // fall through
          case 91: break;
          case 23:
            { return LPAREN;
            }
            // fall through
          case 92: break;
          case 24:
            { return RPAREN;
            }
            // fall through
          case 93: break;
          case 25:
            { return COMMA;
            }
            // fall through
          case 94: break;
          case 26:
            { return SEMI;
            }
            // fall through
          case 95: break;
          case 27:
            { return COLON;
            }
            // fall through
          case 96: break;
          case 28:
            { return EXP;
            }
            // fall through
          case 97: break;
          case 29:
            { return BIT_AND;
            }
            // fall through
          case 98: break;
          case 30:
            { return BIT_OR;
            }
            // fall through
          case 99: break;
          case 31:
            { yybegin(YYINITIAL); return STRING;
            }
            // fall through
          case 100: break;
          case 32:
            { return CONCAT;
            }
            // fall through
          case 101: break;
          case 33:
            { boolean block = checkBlock();
        if (block) {
            boolean docBlock = checkDocBlock();
            yypushback(yylength());
            zzMarkedPos += checkBlockEnd();
            return docBlock ? DOC_BLOCK_COMMENT : BLOCK_COMMENT;
        }
        else { yypushback(yylength()); yybegin(xCOMMENT); }
            }
            // fall through
          case 102: break;
          case 34:
            { return IN;
            }
            // fall through
          case 103: break;
          case 35:
            { return IF;
            }
            // fall through
          case 104: break;
          case 36:
            { return OR;
            }
            // fall through
          case 105: break;
          case 37:
            { return DO;
            }
            // fall through
          case 106: break;
          case 38:
            { return EQ;
            }
            // fall through
          case 107: break;
          case 39:
            { yybegin(xSHEBANG); return SHEBANG;
            }
            // fall through
          case 108: break;
          case 40:
            { return GE;
            }
            // fall through
          case 109: break;
          case 41:
            { return BIT_RTRT;
            }
            // fall through
          case 110: break;
          case 42:
            { return LE;
            }
            // fall through
          case 111: break;
          case 43:
            { return BIT_LTLT;
            }
            // fall through
          case 112: break;
          case 44:
            { return NE;
            }
            // fall through
          case 113: break;
          case 45:
            { return DOUBLE_DIV;
            }
            // fall through
          case 114: break;
          case 46:
            { return DOUBLE_COLON;
            }
            // fall through
          case 115: break;
          case 47:
            { yybegin(YYINITIAL);return SHORT_COMMENT;
            }
            // fall through
          case 116: break;
          case 48:
            { return ELLIPSIS;
            }
            // fall through
          case 117: break;
          case 49:
            { return END;
            }
            // fall through
          case 118: break;
          case 50:
            { return NIL;
            }
            // fall through
          case 119: break;
          case 51:
            { return NOT;
            }
            // fall through
          case 120: break;
          case 52:
            { return AND;
            }
            // fall through
          case 121: break;
          case 53:
            { return FOR;
            }
            // fall through
          case 122: break;
          case 54:
            { yybegin(YYINITIAL);return DOC_COMMENT;
            }
            // fall through
          case 123: break;
          case 55:
            { return ELSE;
            }
            // fall through
          case 124: break;
          case 56:
            { if (level.getVersion() < LuaLanguageLevel.LUA52.getVersion()) return ID; else return GOTO;
            }
            // fall through
          case 125: break;
          case 57:
            { return TRUE;
            }
            // fall through
          case 126: break;
          case 58:
            { return THEN;
            }
            // fall through
          case 127: break;
          case 59:
            { return REGION;
            }
            // fall through
          case 128: break;
          case 60:
            { return ENDREGION;
            }
            // fall through
          case 129: break;
          case 61:
            { return BREAK;
            }
            // fall through
          case 130: break;
          case 62:
            { return LOCAL;
            }
            // fall through
          case 131: break;
          case 63:
            { return FALSE;
            }
            // fall through
          case 132: break;
          case 64:
            { return UNTIL;
            }
            // fall through
          case 133: break;
          case 65:
            { return WHILE;
            }
            // fall through
          case 134: break;
          case 66:
            { return RETURN;
            }
            // fall through
          case 135: break;
          case 67:
            { return REPEAT;
            }
            // fall through
          case 136: break;
          case 68:
            { return ELSEIF;
            }
            // fall through
          case 137: break;
          case 69:
            { return FUNCTION;
            }
            // fall through
          case 138: break;
          default:
            zzScanError(ZZ_NO_MATCH);
          }
      }
    }
  }


}
