#
# Copyright (C) 2020 Assured Information Security, Inc.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

if(NOT EXISTS ${CMAKE_BINARY_DIR}/include/constants.h)
    file(MAKE_DIRECTORY ${CMAKE_BINARY_DIR}/include)
    set(HYPERVISOR_CONSTANTS ${CMAKE_BINARY_DIR}/include/constants.h)

    file(WRITE ${HYPERVISOR_CONSTANTS} "/* ---- AUTO GENERATED ---- */\n")
    file(APPEND ${HYPERVISOR_CONSTANTS} "\n")

    file(APPEND ${HYPERVISOR_CONSTANTS} "#ifndef CONSTANTS_H\n")
    file(APPEND ${HYPERVISOR_CONSTANTS} "#define CONSTANTS_H\n")
    file(APPEND ${HYPERVISOR_CONSTANTS} "\n")

    if(HYPERVISOR_TARGET_ARCH STREQUAL "AuthenticAMD" OR HYPERVISOR_TARGET_ARCH STREQUAL "GenuineIntel")
        file(APPEND ${HYPERVISOR_CONSTANTS} "#define HYPERVISOR_SERIAL_PORT ${HYPERVISOR_SERIAL_PORT}\n")
    else()
        file(APPEND ${HYPERVISOR_CONSTANTS} "#define HYPERVISOR_SERIAL_PORTH ${HYPERVISOR_SERIAL_PORTH}\n")
        file(APPEND ${HYPERVISOR_CONSTANTS} "#define HYPERVISOR_SERIAL_PORTL ${HYPERVISOR_SERIAL_PORTL}\n")
    endif()

    file(APPEND ${HYPERVISOR_CONSTANTS} "#ifndef ASSEMBLY\n")
    file(APPEND ${HYPERVISOR_CONSTANTS} "#include <stdint.h>\n")
    file(APPEND ${HYPERVISOR_CONSTANTS} "\n")

    file(APPEND ${HYPERVISOR_CONSTANTS} "#define BSL_DEBUG_LEVEL ((uint64_t)(${BSL_DEBUG_LEVEL}))\n")
    file(APPEND ${HYPERVISOR_CONSTANTS} "#define BSL_PAGE_SIZE ((uint64_t)(${BSL_PAGE_SIZE}))\n")
    file(APPEND ${HYPERVISOR_CONSTANTS} "#define HYPERVISOR_PAGE_SIZE ((uint64_t)(${HYPERVISOR_PAGE_SIZE}))\n")
    file(APPEND ${HYPERVISOR_CONSTANTS} "#define HYPERVISOR_PAGE_SHIFT ((uint64_t)(${HYPERVISOR_PAGE_SHIFT}))\n")
    file(APPEND ${HYPERVISOR_CONSTANTS} "#define HYPERVISOR_DEBUG_RING_SIZE ((uint64_t)(${HYPERVISOR_DEBUG_RING_SIZE}))\n")
    file(APPEND ${HYPERVISOR_CONSTANTS} "#define HYPERVISOR_VMEXIT_LOG_SIZE ((uint64_t)(${HYPERVISOR_VMEXIT_LOG_SIZE}))\n")
    file(APPEND ${HYPERVISOR_CONSTANTS} "#define HYPERVISOR_MAX_ELF_FILE_SIZE ((uint64_t)(${HYPERVISOR_MAX_ELF_FILE_SIZE}))\n")
    file(APPEND ${HYPERVISOR_CONSTANTS} "#define HYPERVISOR_MAX_SEGMENTS ((uint64_t)(${HYPERVISOR_MAX_SEGMENTS}))\n")
    file(APPEND ${HYPERVISOR_CONSTANTS} "#define HYPERVISOR_MAX_EXTENSIONS ((uint64_t)(${HYPERVISOR_MAX_EXTENSIONS}))\n")
    file(APPEND ${HYPERVISOR_CONSTANTS} "#define HYPERVISOR_MAX_PPS ((uint64_t)(${HYPERVISOR_MAX_PPS}))\n")
    file(APPEND ${HYPERVISOR_CONSTANTS} "#define HYPERVISOR_MAX_VMS ((uint64_t)(${HYPERVISOR_MAX_VMS}))\n")
    file(APPEND ${HYPERVISOR_CONSTANTS} "#define HYPERVISOR_MAX_VPS ((uint64_t)(${HYPERVISOR_MAX_VPS}))\n")
    file(APPEND ${HYPERVISOR_CONSTANTS} "#define HYPERVISOR_MAX_VSS ((uint64_t)(${HYPERVISOR_MAX_VSS}))\n")
    file(APPEND ${HYPERVISOR_CONSTANTS} "#define HYPERVISOR_MAX_HUGE_ALLOCS ((uint64_t)(${HYPERVISOR_MAX_HUGE_ALLOCS}))\n")
    file(APPEND ${HYPERVISOR_CONSTANTS} "#define HYPERVISOR_MK_DIRECT_MAP_ADDR ((uint64_t)(${HYPERVISOR_MK_DIRECT_MAP_ADDR}))\n")
    file(APPEND ${HYPERVISOR_CONSTANTS} "#define HYPERVISOR_MK_DIRECT_MAP_SIZE ((uint64_t)(${HYPERVISOR_MK_DIRECT_MAP_SIZE}))\n")
    file(APPEND ${HYPERVISOR_CONSTANTS} "#define HYPERVISOR_MK_STACK_ADDR ((uint64_t)(${HYPERVISOR_MK_STACK_ADDR}))\n")
    file(APPEND ${HYPERVISOR_CONSTANTS} "#define HYPERVISOR_MK_STACK_SIZE ((uint64_t)(${HYPERVISOR_MK_STACK_SIZE}))\n")
    file(APPEND ${HYPERVISOR_CONSTANTS} "#define HYPERVISOR_MK_CODE_ADDR ((uint64_t)(${HYPERVISOR_MK_CODE_ADDR}))\n")
    file(APPEND ${HYPERVISOR_CONSTANTS} "#define HYPERVISOR_MK_CODE_SIZE ((uint64_t)(${HYPERVISOR_MK_CODE_SIZE}))\n")
    file(APPEND ${HYPERVISOR_CONSTANTS} "#define HYPERVISOR_MK_PAGE_POOL_ADDR ((uint64_t)(${HYPERVISOR_MK_PAGE_POOL_ADDR}))\n")
    file(APPEND ${HYPERVISOR_CONSTANTS} "#define HYPERVISOR_MK_PAGE_POOL_SIZE ((uint64_t)(${HYPERVISOR_MK_PAGE_POOL_SIZE}))\n")
    file(APPEND ${HYPERVISOR_CONSTANTS} "#define HYPERVISOR_MK_HUGE_POOL_ADDR ((uint64_t)(${HYPERVISOR_MK_HUGE_POOL_ADDR}))\n")
    file(APPEND ${HYPERVISOR_CONSTANTS} "#define HYPERVISOR_MK_HUGE_POOL_SIZE ((uint64_t)(${HYPERVISOR_MK_HUGE_POOL_SIZE}))\n")
    file(APPEND ${HYPERVISOR_CONSTANTS} "#define HYPERVISOR_EXT_DIRECT_MAP_ADDR ((uint64_t)(${HYPERVISOR_EXT_DIRECT_MAP_ADDR}))\n")
    file(APPEND ${HYPERVISOR_CONSTANTS} "#define HYPERVISOR_EXT_DIRECT_MAP_SIZE ((uint64_t)(${HYPERVISOR_EXT_DIRECT_MAP_SIZE}))\n")
    file(APPEND ${HYPERVISOR_CONSTANTS} "#define HYPERVISOR_EXT_STACK_ADDR ((uint64_t)(${HYPERVISOR_EXT_STACK_ADDR}))\n")
    file(APPEND ${HYPERVISOR_CONSTANTS} "#define HYPERVISOR_EXT_STACK_SIZE ((uint64_t)(${HYPERVISOR_EXT_STACK_SIZE}))\n")
    file(APPEND ${HYPERVISOR_CONSTANTS} "#define HYPERVISOR_EXT_FAIL_STACK_ADDR ((uint64_t)(${HYPERVISOR_EXT_FAIL_STACK_ADDR}))\n")
    file(APPEND ${HYPERVISOR_CONSTANTS} "#define HYPERVISOR_EXT_FAIL_STACK_SIZE ((uint64_t)(${HYPERVISOR_EXT_FAIL_STACK_SIZE}))\n")
    file(APPEND ${HYPERVISOR_CONSTANTS} "#define HYPERVISOR_EXT_CODE_ADDR ((uint64_t)(${HYPERVISOR_EXT_CODE_ADDR}))\n")
    file(APPEND ${HYPERVISOR_CONSTANTS} "#define HYPERVISOR_EXT_CODE_SIZE ((uint64_t)(${HYPERVISOR_EXT_CODE_SIZE}))\n")
    file(APPEND ${HYPERVISOR_CONSTANTS} "#define HYPERVISOR_EXT_TLS_ADDR ((uint64_t)(${HYPERVISOR_EXT_TLS_ADDR}))\n")
    file(APPEND ${HYPERVISOR_CONSTANTS} "#define HYPERVISOR_EXT_TLS_SIZE ((uint64_t)(${HYPERVISOR_EXT_TLS_SIZE}))\n")
    file(APPEND ${HYPERVISOR_CONSTANTS} "#define HYPERVISOR_EXT_PAGE_POOL_ADDR ((uint64_t)(${HYPERVISOR_EXT_PAGE_POOL_ADDR}))\n")
    file(APPEND ${HYPERVISOR_CONSTANTS} "#define HYPERVISOR_EXT_PAGE_POOL_SIZE ((uint64_t)(${HYPERVISOR_EXT_PAGE_POOL_SIZE}))\n")
    file(APPEND ${HYPERVISOR_CONSTANTS} "#define HYPERVISOR_EXT_HUGE_POOL_ADDR ((uint64_t)(${HYPERVISOR_EXT_HUGE_POOL_ADDR}))\n")
    file(APPEND ${HYPERVISOR_CONSTANTS} "#define HYPERVISOR_EXT_HUGE_POOL_SIZE ((uint64_t)(${HYPERVISOR_EXT_HUGE_POOL_SIZE}))\n")
    file(APPEND ${HYPERVISOR_CONSTANTS} "\n")

    file(APPEND ${HYPERVISOR_CONSTANTS} "#endif\n")
    file(APPEND ${HYPERVISOR_CONSTANTS} "#endif\n")
endif()

if(NOT EXISTS ${CMAKE_BINARY_DIR}/include/constants_masm.h)
    file(MAKE_DIRECTORY ${CMAKE_BINARY_DIR}/include)
    set(HYPERVISOR_CONSTANTS ${CMAKE_BINARY_DIR}/include/constants_masm.h)

    file(WRITE ${HYPERVISOR_CONSTANTS} "; ---- AUTO GENERATED ---- \n")
    file(APPEND ${HYPERVISOR_CONSTANTS} "\n")

    string(REPLACE "0x" "" HYPERVISOR_SERIAL_PORT_MASM "${HYPERVISOR_SERIAL_PORT}")
    file(APPEND ${HYPERVISOR_CONSTANTS} "HYPERVISOR_SERIAL_PORT EQU ${HYPERVISOR_SERIAL_PORT_MASM}h\n")
endif()
