#
# Copyright (C) 2020 Assured Information Security, Inc.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

add_library(hypervisor INTERFACE)

if(HYPERVISOR_TARGET_ARCH STREQUAL "AuthenticAMD" OR HYPERVISOR_TARGET_ARCH STREQUAL "GenuineIntel")
    target_compile_definitions(hypervisor INTERFACE
        HYPERVISOR_SERIAL_PORT=${HYPERVISOR_SERIAL_PORT}
    )
else()
    target_compile_definitions(hypervisor INTERFACE
        HYPERVISOR_SERIAL_PORTH=${HYPERVISOR_SERIAL_PORTH}
        HYPERVISOR_SERIAL_PORTL=${HYPERVISOR_SERIAL_PORTL}
    )
endif()

target_compile_definitions(hypervisor INTERFACE
    HYPERVISOR_PAGE_SIZE=${HYPERVISOR_PAGE_SIZE}_umx
    HYPERVISOR_PAGE_SHIFT=${HYPERVISOR_PAGE_SHIFT}_umx
    HYPERVISOR_DEBUG_RING_SIZE=${HYPERVISOR_DEBUG_RING_SIZE}
    HYPERVISOR_VMEXIT_LOG_SIZE=${HYPERVISOR_VMEXIT_LOG_SIZE}_umx
    HYPERVISOR_MAX_ELF_FILE_SIZE=${HYPERVISOR_MAX_ELF_FILE_SIZE}_umx
    HYPERVISOR_MAX_SEGMENTS=${HYPERVISOR_MAX_SEGMENTS}_umx
    HYPERVISOR_MAX_EXTENSIONS=${HYPERVISOR_MAX_EXTENSIONS}_umx
    HYPERVISOR_MAX_PPS=${HYPERVISOR_MAX_PPS}_umx
    HYPERVISOR_MAX_VMS=${HYPERVISOR_MAX_VMS}_umx
    HYPERVISOR_MAX_VPS=${HYPERVISOR_MAX_VPS}_umx
    HYPERVISOR_MAX_VSS=${HYPERVISOR_MAX_VSS}_umx
    HYPERVISOR_MAX_HUGE_ALLOCS=${HYPERVISOR_MAX_HUGE_ALLOCS}_umx
    HYPERVISOR_MK_DIRECT_MAP_ADDR=${HYPERVISOR_MK_DIRECT_MAP_ADDR}_umx
    HYPERVISOR_MK_DIRECT_MAP_SIZE=${HYPERVISOR_MK_DIRECT_MAP_SIZE}_umx
    HYPERVISOR_MK_STACK_ADDR=${HYPERVISOR_MK_STACK_ADDR}_umx
    HYPERVISOR_MK_STACK_SIZE=${HYPERVISOR_MK_STACK_SIZE}_umx
    HYPERVISOR_MK_CODE_ADDR=${HYPERVISOR_MK_CODE_ADDR}_umx
    HYPERVISOR_MK_CODE_SIZE=${HYPERVISOR_MK_CODE_SIZE}_umx
    HYPERVISOR_MK_PAGE_POOL_ADDR=${HYPERVISOR_MK_PAGE_POOL_ADDR}_umx
    HYPERVISOR_MK_PAGE_POOL_SIZE=${HYPERVISOR_MK_PAGE_POOL_SIZE}_umx
    HYPERVISOR_MK_HUGE_POOL_ADDR=${HYPERVISOR_MK_HUGE_POOL_ADDR}_umx
    HYPERVISOR_MK_HUGE_POOL_SIZE=${HYPERVISOR_MK_HUGE_POOL_SIZE}_umx
    HYPERVISOR_EXT_DIRECT_MAP_ADDR=${HYPERVISOR_EXT_DIRECT_MAP_ADDR}_umx
    HYPERVISOR_EXT_DIRECT_MAP_SIZE=${HYPERVISOR_EXT_DIRECT_MAP_SIZE}_umx
    HYPERVISOR_EXT_STACK_ADDR=${HYPERVISOR_EXT_STACK_ADDR}_umx
    HYPERVISOR_EXT_STACK_SIZE=${HYPERVISOR_EXT_STACK_SIZE}_umx
    HYPERVISOR_EXT_FAIL_STACK_ADDR=${HYPERVISOR_EXT_FAIL_STACK_ADDR}_umx
    HYPERVISOR_EXT_FAIL_STACK_SIZE=${HYPERVISOR_EXT_FAIL_STACK_SIZE}_umx
    HYPERVISOR_EXT_CODE_ADDR=${HYPERVISOR_EXT_CODE_ADDR}_umx
    HYPERVISOR_EXT_CODE_SIZE=${HYPERVISOR_EXT_CODE_SIZE}_umx
    HYPERVISOR_EXT_TLS_ADDR=${HYPERVISOR_EXT_TLS_ADDR}_umx
    HYPERVISOR_EXT_TLS_SIZE=${HYPERVISOR_EXT_TLS_SIZE}_umx
    HYPERVISOR_EXT_PAGE_POOL_ADDR=${HYPERVISOR_EXT_PAGE_POOL_ADDR}_umx
    HYPERVISOR_EXT_PAGE_POOL_SIZE=${HYPERVISOR_EXT_PAGE_POOL_SIZE}_umx
    HYPERVISOR_EXT_HUGE_POOL_ADDR=${HYPERVISOR_EXT_HUGE_POOL_ADDR}_umx
    HYPERVISOR_EXT_HUGE_POOL_SIZE=${HYPERVISOR_EXT_HUGE_POOL_SIZE}_umx
)
