// Copyright (c) 2012 Leonhard Gruenschloss (leonhard@gruenschloss.org)
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights to
// use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
// of the Software, and to permit persons to whom the Software is furnished to do
// so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

// These matrices are based on the following publication:
//
// S. Joe and F. Y. Kuo: "Constructing Sobol sequences with better
// two-dimensional projections", SIAM J. Sci. Comput. 30, 2635-2654 (2008).
//
// The tabulated direction numbers are available here:
// http://web.maths.unsw.edu.au/~fkuo/sobol/new-joe-kuo-6.21201

#pragma once

namespace sobol {

const unsigned num_dimensions = 1024;
const unsigned size = 52;

const uint64_t matrices_[num_dimensions * size] =
{
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0x1000000000000ULL,
    0x800000000000ULL,
    0x400000000000ULL,
    0x200000000000ULL,
    0x100000000000ULL,
    0x80000000000ULL,
    0x40000000000ULL,
    0x20000000000ULL,
    0x10000000000ULL,
    0x8000000000ULL,
    0x4000000000ULL,
    0x2000000000ULL,
    0x1000000000ULL,
    0x800000000ULL,
    0x400000000ULL,
    0x200000000ULL,
    0x100000000ULL,
    0x80000000ULL,
    0x40000000ULL,
    0x20000000ULL,
    0x10000000ULL,
    0x8000000ULL,
    0x4000000ULL,
    0x2000000ULL,
    0x1000000ULL,
    0x800000ULL,
    0x400000ULL,
    0x200000ULL,
    0x100000ULL,
    0x80000ULL,
    0x40000ULL,
    0x20000ULL,
    0x10000ULL,
    0x8000ULL,
    0x4000ULL,
    0x2000ULL,
    0x1000ULL,
    0x800ULL,
    0x400ULL,
    0x200ULL,
    0x100ULL,
    0x80ULL,
    0x40ULL,
    0x20ULL,
    0x10ULL,
    0x8ULL,
    0x4ULL,
    0x2ULL,
    0x1ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0xf000000000000ULL,
    0x8800000000000ULL,
    0xcc00000000000ULL,
    0xaa00000000000ULL,
    0xff00000000000ULL,
    0x8080000000000ULL,
    0xc0c0000000000ULL,
    0xa0a0000000000ULL,
    0xf0f0000000000ULL,
    0x8888000000000ULL,
    0xcccc000000000ULL,
    0xaaaa000000000ULL,
    0xffff000000000ULL,
    0x8000800000000ULL,
    0xc000c00000000ULL,
    0xa000a00000000ULL,
    0xf000f00000000ULL,
    0x8800880000000ULL,
    0xcc00cc0000000ULL,
    0xaa00aa0000000ULL,
    0xff00ff0000000ULL,
    0x8080808000000ULL,
    0xc0c0c0c000000ULL,
    0xa0a0a0a000000ULL,
    0xf0f0f0f000000ULL,
    0x8888888800000ULL,
    0xcccccccc00000ULL,
    0xaaaaaaaa00000ULL,
    0xffffffff00000ULL,
    0x8000000080000ULL,
    0xc0000000c0000ULL,
    0xa0000000a0000ULL,
    0xf0000000f0000ULL,
    0x8800000088000ULL,
    0xcc000000cc000ULL,
    0xaa000000aa000ULL,
    0xff000000ff000ULL,
    0x8080000080800ULL,
    0xc0c00000c0c00ULL,
    0xa0a00000a0a00ULL,
    0xf0f00000f0f00ULL,
    0x8888000088880ULL,
    0xcccc0000cccc0ULL,
    0xaaaa0000aaaa0ULL,
    0xffff0000ffff0ULL,
    0x8000800080008ULL,
    0xc000c000c000cULL,
    0xa000a000a000aULL,
    0xf000f000f000fULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x9000000000000ULL,
    0xe800000000000ULL,
    0x5c00000000000ULL,
    0x8e00000000000ULL,
    0xc500000000000ULL,
    0x6880000000000ULL,
    0x9cc0000000000ULL,
    0xee60000000000ULL,
    0x5590000000000ULL,
    0x8068000000000ULL,
    0xc09c000000000ULL,
    0x60ee000000000ULL,
    0x9055000000000ULL,
    0xe880800000000ULL,
    0x5cc0c00000000ULL,
    0x8e60600000000ULL,
    0xc590900000000ULL,
    0x6868e80000000ULL,
    0x9c9c5c0000000ULL,
    0xeeee8e0000000ULL,
    0x5555c50000000ULL,
    0x8000e88000000ULL,
    0xc0005cc000000ULL,
    0x60008e6000000ULL,
    0x9000c59000000ULL,
    0xe800686800000ULL,
    0x5c009c9c00000ULL,
    0x8e00eeee00000ULL,
    0xc500555500000ULL,
    0x6880800080000ULL,
    0x9cc0c000c0000ULL,
    0xee60600060000ULL,
    0x5590900090000ULL,
    0x8068e800e8000ULL,
    0xc09c5c005c000ULL,
    0x60ee8e008e000ULL,
    0x9055c500c5000ULL,
    0xe880e88068800ULL,
    0x5cc05cc09cc00ULL,
    0x8e608e60ee600ULL,
    0xc590c59055900ULL,
    0x6868686880680ULL,
    0x9c9c9c9cc09c0ULL,
    0xeeeeeeee60ee0ULL,
    0x5555555590550ULL,
    0x8000000068808ULL,
    0xc00000009cc0cULL,
    0x60000000ee606ULL,
    0x9000000055909ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x5000000000000ULL,
    0xf800000000000ULL,
    0x7400000000000ULL,
    0xa200000000000ULL,
    0x9300000000000ULL,
    0xd880000000000ULL,
    0x2540000000000ULL,
    0x59e0000000000ULL,
    0xe6d0000000000ULL,
    0x7808000000000ULL,
    0xb40c000000000ULL,
    0x8202000000000ULL,
    0xc305000000000ULL,
    0x208f800000000ULL,
    0x5147400000000ULL,
    0xfbea200000000ULL,
    0x75d9300000000ULL,
    0xa085880000000ULL,
    0x914e540000000ULL,
    0xdbe79e0000000ULL,
    0x25db6d0000000ULL,
    0x5880008000000ULL,
    0xe54000c000000ULL,
    0x79e0002000000ULL,
    0xb6d0005000000ULL,
    0x800800f800000ULL,
    0xc00c007400000ULL,
    0x200200a200000ULL,
    0x5005009300000ULL,
    0xf80f80d880000ULL,
    0x7407402540000ULL,
    0xa20a2059e0000ULL,
    0x930930e6d0000ULL,
    0xd88d887808000ULL,
    0x254254b40c000ULL,
    0x59e59e8202000ULL,
    0xe6de6dc305000ULL,
    0x780f80a08f800ULL,
    0xb407409147400ULL,
    0x820a20dbea200ULL,
    0xc3093025d9300ULL,
    0x208d885885880ULL,
    0x514254e54e540ULL,
    0xfbe59e79e79e0ULL,
    0x75de6db6db6d0ULL,
    0xa08f800000008ULL,
    0x914740000000cULL,
    0xdbea200000002ULL,
    0x25d9300000005ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0xb000000000000ULL,
    0xf800000000000ULL,
    0xdc00000000000ULL,
    0x7a00000000000ULL,
    0x9d00000000000ULL,
    0x5a80000000000ULL,
    0x2fc0000000000ULL,
    0xa160000000000ULL,
    0xf0b0000000000ULL,
    0xda88000000000ULL,
    0x6fc4000000000ULL,
    0x8162000000000ULL,
    0x40bb000000000ULL,
    0x2287800000000ULL,
    0xb3c9c00000000ULL,
    0xfb65a00000000ULL,
    0xddb2d00000000ULL,
    0x7802280000000ULL,
    0x9c0b3c0000000ULL,
    0x5a0fb60000000ULL,
    0x2d0ddb0000000ULL,
    0xa287808000000ULL,
    0xf3c9c04000000ULL,
    0xdb65a02000000ULL,
    0x6db2d0b000000ULL,
    0x800228f800000ULL,
    0x400b3cdc00000ULL,
    0x200fb67a00000ULL,
    0xb00ddb9d00000ULL,
    0xf80780da80000ULL,
    0xdc09c06fc0000ULL,
    0x7a05a08160000ULL,
    0x9d02d040b0000ULL,
    0x5a8a282288000ULL,
    0x2fcf3cb3c4000ULL,
    0xa16db6fb62000ULL,
    0xf0b6dbddbb000ULL,
    0xda8000f807800ULL,
    0x6fc000dc09c00ULL,
    0x8160007a05a00ULL,
    0x40b0009d02d00ULL,
    0x2288005a8a280ULL,
    0xb3c4002fcf3c0ULL,
    0xfb6200a16db60ULL,
    0xddbb00f0b6db0ULL,
    0x780780da80008ULL,
    0x9c09c06fc0004ULL,
    0x5a05a08160002ULL,
    0x2d02d040b000bULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x3000000000000ULL,
    0xc800000000000ULL,
    0x2400000000000ULL,
    0x5600000000000ULL,
    0xfb00000000000ULL,
    0xe080000000000ULL,
    0x7040000000000ULL,
    0xa860000000000ULL,
    0x1430000000000ULL,
    0x9ec8000000000ULL,
    0xdf24000000000ULL,
    0xb6d6000000000ULL,
    0x8bbb000000000ULL,
    0x4800800000000ULL,
    0x6400400000000ULL,
    0x3600600000000ULL,
    0xcb00300000000ULL,
    0x2880c80000000ULL,
    0x5440240000000ULL,
    0xfe60560000000ULL,
    0xef30fb0000000ULL,
    0x7e48e08000000ULL,
    0xaf64704000000ULL,
    0x1eb6a86000000ULL,
    0x9f8b143000000ULL,
    0xd6c81ec800000ULL,
    0xbb249f2400000ULL,
    0x80d6d6d600000ULL,
    0x40bbbbbb00000ULL,
    0x6080000080000ULL,
    0x3040000040000ULL,
    0xc860000060000ULL,
    0x2430000030000ULL,
    0x56c80000c8000ULL,
    0xfb24000024000ULL,
    0xe0d6000056000ULL,
    0x70bb0000fb000ULL,
    0xa8808000e0800ULL,
    0x1440400070400ULL,
    0x9e606000a8600ULL,
    0xdf30300014300ULL,
    0xb648c8009ec80ULL,
    0x8b642400df240ULL,
    0x48b65600b6d60ULL,
    0x648bfb008bbb0ULL,
    0x3648608048008ULL,
    0xcb64304064004ULL,
    0x28b6c86036006ULL,
    0x548b2430cb003ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0xd000000000000ULL,
    0x5800000000000ULL,
    0x9400000000000ULL,
    0x3e00000000000ULL,
    0xe300000000000ULL,
    0xbe80000000000ULL,
    0x23c0000000000ULL,
    0x1e20000000000ULL,
    0xf310000000000ULL,
    0x4678000000000ULL,
    0x6784000000000ULL,
    0x7846000000000ULL,
    0x8467000000000ULL,
    0xc678800000000ULL,
    0xa784c00000000ULL,
    0xd846a00000000ULL,
    0x5467d00000000ULL,
    0x9e78d80000000ULL,
    0x3384540000000ULL,
    0xe6469e0000000ULL,
    0xb767330000000ULL,
    0x20f8668000000ULL,
    0x104477c000000ULL,
    0xf866802000000ULL,
    0x4477c01000000ULL,
    0x668020f800000ULL,
    0x77c0104400000ULL,
    0x8020f86600000ULL,
    0xc010447700000ULL,
    0xa0f8668080000ULL,
    0xd04477c0c0000ULL,
    0x58668020a0000ULL,
    0x9477c010d0000ULL,
    0x3e8020f858000ULL,
    0xe3c0104494000ULL,
    0xbe20f8663e000ULL,
    0x23104477e3000ULL,
    0x1e7866803e800ULL,
    0xf38477c0e3c00ULL,
    0x46468020be200ULL,
    0x6767c01023100ULL,
    0x78f820f81e780ULL,
    0x84441044f3840ULL,
    0xc666f86646460ULL,
    0xa777447767670ULL,
    0xd800e680f8f88ULL,
    0x5400b7c04444cULL,
    0x9e0020206666aULL,
    0x330010107777dULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x5000000000000ULL,
    0x8800000000000ULL,
    0x2400000000000ULL,
    0x1200000000000ULL,
    0x2d00000000000ULL,
    0x7680000000000ULL,
    0x9e40000000000ULL,
    0x820000000000ULL,
    0x6410000000000ULL,
    0xb228000000000ULL,
    0x7d14000000000ULL,
    0xfea2000000000ULL,
    0xba49000000000ULL,
    0x1a24800000000ULL,
    0x491b400000000ULL,
    0xc4b5a00000000ULL,
    0xe373900000000ULL,
    0xf680080000000ULL,
    0xde40040000000ULL,
    0xa8200a0000000ULL,
    0x3410050000000ULL,
    0x3a28088000000ULL,
    0x5914024000000ULL,
    0xeca2012000000ULL,
    0x974902d000000ULL,
    0x6ca4876800000ULL,
    0xd75b49e400000ULL,
    0xcc95a08200000ULL,
    0x8763964100000ULL,
    0x44a8032280000ULL,
    0xa35403d140000ULL,
    0x568205ea20000ULL,
    0x8e590ea490000ULL,
    0x200c892248000ULL,
    0x100f46d1b4000ULL,
    0x2817ad6b5a000ULL,
    0x743a9ce739000ULL,
    0x9a24800000800ULL,
    0x91b400000400ULL,
    0x64b5a00000a00ULL,
    0xb373900000500ULL,
    0x7e80080000880ULL,
    0xfa40040000240ULL,
    0xba200a0000120ULL,
    0x19100500002d0ULL,
    0x4ca8088000768ULL,
    0xc7540240009e4ULL,
    0xe482012000082ULL,
    0xf35902d000641ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x5000000000000ULL,
    0x2800000000000ULL,
    0xd400000000000ULL,
    0x6a00000000000ULL,
    0x7100000000000ULL,
    0x3880000000000ULL,
    0x5840000000000ULL,
    0xea20000000000ULL,
    0x3110000000000ULL,
    0x98a8000000000ULL,
    0x854000000000ULL,
    0xc22a000000000ULL,
    0xe525000000000ULL,
    0xf2b2800000000ULL,
    0x7948400000000ULL,
    0xfaa4200000000ULL,
    0xbd73100000000ULL,
    0x18a8080000000ULL,
    0x4854040000000ULL,
    0x622a0a0000000ULL,
    0xb525050000000ULL,
    0xdab2828000000ULL,
    0xad484d4000000ULL,
    0x90a426a000000ULL,
    0xcc73171000000ULL,
    0x20280b8800000ULL,
    0x1014018400000ULL,
    0x880a04a200000ULL,
    0x8435061100000ULL,
    0x421a8b0a80000ULL,
    0xa51c4dc540000ULL,
    0x528e2a82a0000ULL,
    0x2956194250000ULL,
    0xd29a84a328000ULL,
    0x695c461084000ULL,
    0x72ae2b0842000ULL,
    0x39461dc631000ULL,
    0x5ab2828000800ULL,
    0xed484d4000400ULL,
    0x30a426a000a00ULL,
    0x9c73171000500ULL,
    0x8280b8800280ULL,
    0xc414018400d40ULL,
    0xe20a04a2006a0ULL,
    0xf535061100710ULL,
    0x7a9a8b0a80388ULL,
    0xfd5c4dc540584ULL,
    0xb8ae2a82a0ea2ULL,
    0x1846194250311ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0xb000000000000ULL,
    0x9800000000000ULL,
    0x9400000000000ULL,
    0x8a00000000000ULL,
    0x5b00000000000ULL,
    0x3380000000000ULL,
    0xd9c0000000000ULL,
    0x7220000000000ULL,
    0x3f10000000000ULL,
    0xc1b8000000000ULL,
    0xa6ec000000000ULL,
    0x5386000000000ULL,
    0x29f5000000000ULL,
    0xa3a800000000ULL,
    0x1b2ac00000000ULL,
    0xd392e00000000ULL,
    0x69ff700000000ULL,
    0xea38080000000ULL,
    0xab2c040000000ULL,
    0x4ba60e0000000ULL,
    0xfde50b0000000ULL,
    0x6002898000000ULL,
    0xf006c94000000ULL,
    0x7834e8a000000ULL,
    0x241a75b000000ULL,
    0x123a8b3800000ULL,
    0xcf2ac99c00000ULL,
    0xb992e92200000ULL,
    0x82ff78f100000ULL,
    0x41b80d9b80000ULL,
    0xe6ec072ec0000ULL,
    0xb386039860000ULL,
    0x99f50c2f50000ULL,
    0x923a8a1ba8000ULL,
    0x8f2ac56eac000ULL,
    0x5992e2bb2e000ULL,
    0x32ff70def7000ULL,
    0xd9b8098000800ULL,
    0x72ec094000400ULL,
    0x398608a000e00ULL,
    0xc2f505b000b00ULL,
    0xa1ba833800980ULL,
    0x56eacd9c00940ULL,
    0x2bb2e722008a0ULL,
    0xdef73f1005b0ULL,
    0x1800041b80338ULL,
    0xd4000e6ec0d9cULL,
    0x6a000b3860722ULL,
    0xeb00099f503f1ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x1000000000000ULL,
    0x800000000000ULL,
    0x6c00000000000ULL,
    0x9e00000000000ULL,
    0x2300000000000ULL,
    0x5780000000000ULL,
    0xadc0000000000ULL,
    0x7fa0000000000ULL,
    0x91d0000000000ULL,
    0x4988000000000ULL,
    0xced4000000000ULL,
    0x880a000000000ULL,
    0x2c0f000000000ULL,
    0x3e0d800000000ULL,
    0x3317c00000000ULL,
    0x5fb0600000000ULL,
    0xc1f8b00000000ULL,
    0xe18d880000000ULL,
    0xb2d7c40000000ULL,
    0x1e106a0000000ULL,
    0x6328b10000000ULL,
    0xf785888000000ULL,
    0xbdc3c2c000000ULL,
    0x77ba63e000000ULL,
    0xfdf7b33000000ULL,
    0xd7800df800000ULL,
    0xedc0081c00000ULL,
    0xdfa0041a00000ULL,
    0x81d00a2d00000ULL,
    0x4188016080000ULL,
    0xa2d400f140000ULL,
    0x160a069aa0000ULL,
    0xf0f09edf0000ULL,
    0x698d820058000ULL,
    0x9ed7c5003c000ULL,
    0x20106a81a6000ULL,
    0x5028b7c27b000ULL,
    0xa805816080800ULL,
    0x7c03c0f140400ULL,
    0x961a669aa0a00ULL,
    0x4f27b9edf0100ULL,
    0xc9880a0058080ULL,
    0x8ed401003c6c0ULL,
    0x280a0081a69e0ULL,
    0x3c0f06c27b230ULL,
    0x360d89e080d78ULL,
    0x5f17c23140edcULL,
    0xc1b0657aa0dfaULL,
    0xe2f8baddf081dULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0x3000000000000ULL,
    0x5800000000000ULL,
    0xac00000000000ULL,
    0x9600000000000ULL,
    0x2b00000000000ULL,
    0xd480000000000ULL,
    0x940000000000ULL,
    0xe2a0000000000ULL,
    0x5250000000000ULL,
    0x4e28000000000ULL,
    0xc71c000000000ULL,
    0x629e000000000ULL,
    0x1267000000000ULL,
    0x6e13800000000ULL,
    0xf731c00000000ULL,
    0x3a98a00000000ULL,
    0xbe44900000000ULL,
    0xf83b880000000ULL,
    0xdc2dc40000000ULL,
    0xee06a20000000ULL,
    0xb723930000000ULL,
    0x1aa80d8000000ULL,
    0x8e5c0ec000000ULL,
    0xa03e0b6000000ULL,
    0x703701b000000ULL,
    0x783b88c800000ULL,
    0x9c2dca5400000ULL,
    0xce06a74a00000ULL,
    0x8723979500000ULL,
    0x42a801aa80000ULL,
    0x225c08e5c0000ULL,
    0x363e0a03e0000ULL,
    0x5b37070370000ULL,
    0xacbb8783b8000ULL,
    0x956dc9c2dc000ULL,
    0x2ca6ace06a000ULL,
    0xd573987239000ULL,
    0xc800c2a80800ULL,
    0xe5400625c0400ULL,
    0x54a00163e0200ULL,
    0x495006b370300ULL,
    0xc2a80f4bb8580ULL,
    0x625c0396dcac0ULL,
    0x163e0baa6a960ULL,
    0x6b370fe7392b0ULL,
    0xf4bb8d8000548ULL,
    0x396dcec000494ULL,
    0xbaa6ab6000c2aULL,
    0xfe7391b000625ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x5000000000000ULL,
    0xf800000000000ULL,
    0x8c00000000000ULL,
    0xe200000000000ULL,
    0x3300000000000ULL,
    0xf80000000000ULL,
    0x2140000000000ULL,
    0x95a0000000000ULL,
    0x5e70000000000ULL,
    0xd808000000000ULL,
    0x1c24000000000ULL,
    0xba16000000000ULL,
    0xef37000000000ULL,
    0x1586800000000ULL,
    0x9e6fc00000000ULL,
    0x781b600000000ULL,
    0x4c34900000000ULL,
    0x420e880000000ULL,
    0x630bcc0000000ULL,
    0xf7ad6a0000000ULL,
    0xad73950000000ULL,
    0x7780078000000ULL,
    0x6d4004c000000ULL,
    0xd7a0042000000ULL,
    0x3d70063000000ULL,
    0x2f880f7800000ULL,
    0xb1640ad400000ULL,
    0xcdb6077a00000ULL,
    0x824706d700000ULL,
    0xc20e8d7880000ULL,
    0xa30bc3d640000ULL,
    0x57ad62fb60000ULL,
    0xfd739b1470000ULL,
    0x8f8004d8e8000ULL,
    0xe1400424bc000ULL,
    0x35a00620d6000ULL,
    0xe700f3039000ULL,
    0x20080af880800ULL,
    0x9024071640c00ULL,
    0x581606db60a00ULL,
    0xdc370d2470500ULL,
    0x1a0683a0e8f80ULL,
    0xbf2fc2f0bc8c0ULL,
    0xedbb6b5ad6e20ULL,
    0x12449ce739330ULL,
    0x9a068000008f8ULL,
    0x7f2fc00000e14ULL,
    0x4dbb60000035aULL,
    0x42449000000e7ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x9000000000000ULL,
    0x3800000000000ULL,
    0xc400000000000ULL,
    0x4200000000000ULL,
    0xa300000000000ULL,
    0xf180000000000ULL,
    0xaa40000000000ULL,
    0xfce0000000000ULL,
    0x8510000000000ULL,
    0xe008000000000ULL,
    0x500c000000000ULL,
    0x5806000000000ULL,
    0x5409000000000ULL,
    0x7a03800000000ULL,
    0x670c400000000ULL,
    0xb384200000000ULL,
    0x94a300000000ULL,
    0xd6f180000000ULL,
    0x2f5aa40000000ULL,
    0x1ce7ce0000000ULL,
    0xd514510000000ULL,
    0xb800008000000ULL,
    0x40000c000000ULL,
    0x2200006000000ULL,
    0x3300009000000ULL,
    0xc980003800000ULL,
    0x6e4000c400000ULL,
    0xbee0004200000ULL,
    0x261000a300000ULL,
    0x118800f180000ULL,
    0xfa4c00aa40000ULL,
    0xa4e600fce0000ULL,
    0xd119008510000ULL,
    0x9a0b80e008000ULL,
    0x370040500c000ULL,
    0xeb82205806000ULL,
    0x5d43305409000ULL,
    0x776c987a03800ULL,
    0x4856e4670c400ULL,
    0xaf63eeb384200ULL,
    0xdc5e61094a300ULL,
    0xb56f188d6f180ULL,
    0x2b5aa4ef5aa40ULL,
    0x3ee7ce7ce7ce0ULL,
    0xe614514514510ULL,
    0x7180000000008ULL,
    0x6a4000000000cULL,
    0x9ce0000000006ULL,
    0x1510000000009ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0xf000000000000ULL,
    0xa800000000000ULL,
    0x5400000000000ULL,
    0x9a00000000000ULL,
    0x9d00000000000ULL,
    0x1e80000000000ULL,
    0x5cc0000000000ULL,
    0x7d20000000000ULL,
    0x8d10000000000ULL,
    0x2488000000000ULL,
    0x71c4000000000ULL,
    0xeba2000000000ULL,
    0x75df000000000ULL,
    0x6ba2800000000ULL,
    0x35d1400000000ULL,
    0x4ba3a00000000ULL,
    0xc5d2d00000000ULL,
    0xe3a1680000000ULL,
    0x91db8c0000000ULL,
    0x79aef20000000ULL,
    0xcdf410000000ULL,
    0x672a808000000ULL,
    0x5015404000000ULL,
    0x1a01a02000000ULL,
    0xdd0dd0f000000ULL,
    0x3e83e8a800000ULL,
    0xaccacc5400000ULL,
    0xd52d529a00000ULL,
    0xd91d919d00000ULL,
    0xbe83e89e80000ULL,
    0xeccacc1cc0000ULL,
    0xf52d525d20000ULL,
    0x291d917d10000ULL,
    0x1683e80c88000ULL,
    0xb8cacc65c4000ULL,
    0x6f2d5251a2000ULL,
    0xb41d9118df000ULL,
    0x803e85d22800ULL,
    0xe40acc7d11400ULL,
    0x120d528c83a00ULL,
    0x390d9125c2d00ULL,
    0x2c8be8f1a9680ULL,
    0x95cecca8df8c0ULL,
    0xf9af52552cf20ULL,
    0x4cd2919910410ULL,
    0x4729681e80008ULL,
    0xa01f8c5cc0004ULL,
    0xb20cf27d20002ULL,
    0x8900418d1000fULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0xd000000000000ULL,
    0xd800000000000ULL,
    0xc400000000000ULL,
    0x4600000000000ULL,
    0x8500000000000ULL,
    0xa580000000000ULL,
    0x76c0000000000ULL,
    0xada0000000000ULL,
    0x6ab0000000000ULL,
    0x2da8000000000ULL,
    0xaabc000000000ULL,
    0xdaa000000000ULL,
    0x7ab1000000000ULL,
    0xd5a7800000000ULL,
    0xbebd400000000ULL,
    0x93a3e00000000ULL,
    0x3bb5100000000ULL,
    0x3629b80000000ULL,
    0x4d727c0000000ULL,
    0x9b83620000000ULL,
    0x27c4d70000000ULL,
    0xb629b88000000ULL,
    0x8d727cc000000ULL,
    0xbb83622000000ULL,
    0xf7c4d7d000000ULL,
    0x6e29b85800000ULL,
    0x49727c0400000ULL,
    0xfd83626600000ULL,
    0x72c4d75500000ULL,
    0xcba9b8fd80000ULL,
    0x3fb27c72c0000ULL,
    0x502362cba0000ULL,
    0x1874d73fb0000ULL,
    0xe601b8d028000ULL,
    0x950e7cd87c000ULL,
    0x5d8962c60a000ULL,
    0x62c5d74501000ULL,
    0x33a638058f800ULL,
    0x2bb33c66c1400ULL,
    0xce2a8255a9e00ULL,
    0x5970c77eb4100ULL,
    0x58f8033a6380ULL,
    0x66c1402bb33c0ULL,
    0x55a9e0ce2a820ULL,
    0x7eb4105970c70ULL,
    0xb3a638058f808ULL,
    0xebb33c66c140cULL,
    0xee2a8255a9e02ULL,
    0x8970c77eb410dULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0xf000000000000ULL,
    0x3800000000000ULL,
    0x1400000000000ULL,
    0xf600000000000ULL,
    0x6700000000000ULL,
    0x8f80000000000ULL,
    0x5040000000000ULL,
    0x8aa0000000000ULL,
    0xff0000000000ULL,
    0x12a8000000000ULL,
    0xabf4000000000ULL,
    0xfcaa000000000ULL,
    0x28fb000000000ULL,
    0xbd29800000000ULL,
    0xbba400000000ULL,
    0x4e06e00000000ULL,
    0x330c300000000ULL,
    0x5986180000000ULL,
    0xc74d340000000ULL,
    0x3d2cb20000000ULL,
    0x4bb2cb0000000ULL,
    0x6e06188000000ULL,
    0xc30d344000000ULL,
    0x618cb22000000ULL,
    0xd342cbf000000ULL,
    0xcb2e18b800000ULL,
    0x2cb9345400000ULL,
    0xe186b2d600000ULL,
    0x9349cb9700000ULL,
    0xeb2f983780000ULL,
    0xdcb7740440000ULL,
    0xd98a525ca0000ULL,
    0x874efb98f0000ULL,
    0x1d28002528000ULL,
    0xbbb400afb4000ULL,
    0x560a00a00a000ULL,
    0xd70b00b00b000ULL,
    0x9781801801800ULL,
    0xb44e40e40e400ULL,
    0x44ace0ce0ce00ULL,
    0x7cf7307307300ULL,
    0x6b2f987987980ULL,
    0x9cb7743743740ULL,
    0xf98a520520520ULL,
    0x774efb5fb5fb0ULL,
    0x2528001801808ULL,
    0xafb400e40e404ULL,
    0xa00a00ce0ce02ULL,
    0xb00b00730730fULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0xf000000000000ULL,
    0x6800000000000ULL,
    0x6400000000000ULL,
    0x3600000000000ULL,
    0x6d00000000000ULL,
    0x4180000000000ULL,
    0xe040000000000ULL,
    0xd2e0000000000ULL,
    0x9bf0000000000ULL,
    0xce8000000000ULL,
    0x52fc000000000ULL,
    0x5b6a000000000ULL,
    0x2fb3000000000ULL,
    0xa00c800000000ULL,
    0x3005400000000ULL,
    0x4807e00000000ULL,
    0x940f900000000ULL,
    0x5e01f80000000ULL,
    0x90e940000000ULL,
    0x778a560000000ULL,
    0x8d416b0000000ULL,
    0x9369f88000000ULL,
    0x7bb294c000000ULL,
    0xde00562000000ULL,
    0xc9026bf000000ULL,
    0x578d78e800000ULL,
    0x7d4bd4a400000ULL,
    0xfb6db61600000ULL,
    0x1fbefb9d00000ULL,
    0xe80000a980000ULL,
    0xa400004440000ULL,
    0x160000c4e0000ULL,
    0x9d000006f0000ULL,
    0x2980002568000ULL,
    0x844000d6bc000ULL,
    0xe4e000bf8a000ULL,
    0xf6f000d943000ULL,
    0x4d6800ed64800ULL,
    0xb2bc0082b9400ULL,
    0x898a00c18de00ULL,
    0xb44300204c900ULL,
    0xace480f2e5780ULL,
    0x62f9406bf7d40ULL,
    0x136de064e7b60ULL,
    0xbbbc9036fdfb0ULL,
    0xfe0d786d64808ULL,
    0x390bd442b940cULL,
    0x3f8db6e18de02ULL,
    0x194efbd04c90fULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x5000000000000ULL,
    0x9800000000000ULL,
    0xf400000000000ULL,
    0xae00000000000ULL,
    0xbb00000000000ULL,
    0xe780000000000ULL,
    0x95c0000000000ULL,
    0x1c20000000000ULL,
    0xd030000000000ULL,
    0xdba8000000000ULL,
    0x55f4000000000ULL,
    0xff82000000000ULL,
    0x21c1000000000ULL,
    0x1223800000000ULL,
    0x3b3a400000000ULL,
    0xa42b600000000ULL,
    0x3430f00000000ULL,
    0x4da6980000000ULL,
    0x4af3ec0000000ULL,
    0x2e043a0000000ULL,
    0xfb0a1f0000000ULL,
    0x4785188000000ULL,
    0xc5c9ac4000000ULL,
    0x842f5aa000000ULL,
    0x243aef5000000ULL,
    0x75a3801800000ULL,
    0xeefa40b400000ULL,
    0x180b600e00000ULL,
    0xb400f0eb00000ULL,
    0xe0e987f80000ULL,
    0xeb07ec61c0000ULL,
    0x7f863ab220000ULL,
    0x61cb1f6b30000ULL,
    0xb22698bc28000ULL,
    0x6b33ec8034000ULL,
    0x3c243a43a2000ULL,
    0xc03a1fa1f1000ULL,
    0xe3ad18d18b800ULL,
    0xf1fdacdace400ULL,
    0xc98d5a55a9600ULL,
    0x6ecbeffef1f00ULL,
    0x5ba800a005180ULL,
    0x15f4005009ac0ULL,
    0x5f8200980f5a0ULL,
    0x71c100f40aef0ULL,
    0x8a2380ae0b808ULL,
    0xcf3a40bb0e404ULL,
    0xa2b60e78960aULL,
    0x8f30f095c1f05ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0xb000000000000ULL,
    0xb800000000000ULL,
    0x3c00000000000ULL,
    0xce00000000000ULL,
    0x4100000000000ULL,
    0x2180000000000ULL,
    0x51c0000000000ULL,
    0x960000000000ULL,
    0x8570000000000ULL,
    0xf278000000000ULL,
    0x8e9c000000000ULL,
    0x6002000000000ULL,
    0x7003000000000ULL,
    0x5803800000000ULL,
    0x8c02c00000000ULL,
    0x7602e00000000ULL,
    0x7d00f00000000ULL,
    0xef83380000000ULL,
    0x10c1040000000ULL,
    0x28e0860000000ULL,
    0xd4b1470000000ULL,
    0xfb18258000000ULL,
    0xbee15c000000ULL,
    0x9279c9e000000ULL,
    0xfe9d3a7000000ULL,
    0x3800000800000ULL,
    0xfc00000c00000ULL,
    0x2e00000e00000ULL,
    0xf100000b00000ULL,
    0x9980000b80000ULL,
    0x6dc00003c0000ULL,
    0xc760000ce0000ULL,
    0xc470000410000ULL,
    0xd3f8000218000ULL,
    0xdf5c00051c000ULL,
    0x6962000096000ULL,
    0xf573000857000ULL,
    0xaa7b800f27800ULL,
    0x29ec008e9c00ULL,
    0x1600e00600200ULL,
    0xd03f00700300ULL,
    0xb780b80580380ULL,
    0x9cc3c408c02c0ULL,
    0x5ee26607602e0ULL,
    0xa9b1b707d00f0ULL,
    0x149b1d8ef8338ULL,
    0x1b2f11c10c104ULL,
    0xba994fe28e086ULL,
    0x2a2c7d7d4b147ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0xd000000000000ULL,
    0x6800000000000ULL,
    0x3c00000000000ULL,
    0x8a00000000000ULL,
    0x5100000000000ULL,
    0xa980000000000ULL,
    0xddc0000000000ULL,
    0x5ba0000000000ULL,
    0x39d0000000000ULL,
    0x95f8000000000ULL,
    0x56d4000000000ULL,
    0xa02000000000ULL,
    0x9103000000000ULL,
    0x4983800000000ULL,
    0xdc3400000000ULL,
    0x33a1a00000000ULL,
    0x5d0f00000000ULL,
    0x1ffa280000000ULL,
    0x7d5440000000ULL,
    0xa380a60000000ULL,
    0x4cc0770000000ULL,
    0x1222ee8000000ULL,
    0x3413a74000000ULL,
    0xa65bf7e000000ULL,
    0x5305ab5000000ULL,
    0x15f8000800000ULL,
    0x96d4000c00000ULL,
    0xea02000e00000ULL,
    0x4103000d00000ULL,
    0x2183800680000ULL,
    0x31c34003c0000ULL,
    0xb9a1a008a0000ULL,
    0x54d0f00510000ULL,
    0xb67a280a98000ULL,
    0xda15440ddc000ULL,
    0xf820a605ba000ULL,
    0x751077039d000ULL,
    0x87daee895f800ULL,
    0x62c7a7456d400ULL,
    0xac59f7e0a0200ULL,
    0xc206ab5910300ULL,
    0x5c7b800c98380ULL,
    0x9b17400cdc340ULL,
    0xd9a3a00d3a1a0ULL,
    0x44d3f00d5d0f0ULL,
    0x3e79a8077fa28ULL,
    0x36160403bd544ULL,
    0x1a210602980a6ULL,
    0x18108701dc077ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0xd000000000000ULL,
    0x3800000000000ULL,
    0x8c00000000000ULL,
    0x7e00000000000ULL,
    0x7100000000000ULL,
    0xc880000000000ULL,
    0x4c0000000000ULL,
    0x1ba0000000000ULL,
    0xbb70000000000ULL,
    0x4a98000000000ULL,
    0xc3bc000000000ULL,
    0xa602000000000ULL,
    0x6d01000000000ULL,
    0xee81800000000ULL,
    0x29c3400000000ULL,
    0x9520e00000000ULL,
    0x42b2300000000ULL,
    0xe7b9f80000000ULL,
    0xd0dc40000000ULL,
    0x3fb9220000000ULL,
    0x110d130000000ULL,
    0x19bbee8000000ULL,
    0x3c0cadc000000ULL,
    0x973a4a6000000ULL,
    0xc5cf7ef000000ULL,
    0x3a18000800000ULL,
    0xb7c000400000ULL,
    0xa3a2000600000ULL,
    0x7771000d00000ULL,
    0x5499800380000ULL,
    0x62bf4008c0000ULL,
    0x5682e007e0000ULL,
    0xe5c3300710000ULL,
    0x8b20780c88000ULL,
    0xe3b284004c000ULL,
    0x173bc201ba000ULL,
    0x85ce230bb7000ULL,
    0x5a1b9684a9800ULL,
    0xdb7e29cc3bc00ULL,
    0x9ba1886a60200ULL,
    0xfb715df6d0100ULL,
    0x2a9b9686e8180ULL,
    0x13be29c69c340ULL,
    0x9e01886f520e0ULL,
    0xe1015df92b230ULL,
    0x90839685fb9f8ULL,
    0x58c229cc10dc4ULL,
    0x5da388621b922ULL,
    0x46705dfb00d13ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x9000000000000ULL,
    0x800000000000ULL,
    0x6400000000000ULL,
    0x6a00000000000ULL,
    0x8900000000000ULL,
    0xa580000000000ULL,
    0xcb40000000000ULL,
    0x1820000000000ULL,
    0xad90000000000ULL,
    0xaf88000000000ULL,
    0x72f4000000000ULL,
    0x2582000000000ULL,
    0xb43000000000ULL,
    0xb822800000000ULL,
    0x3d92400000000ULL,
    0xa788200000000ULL,
    0x16f5900000000ULL,
    0x4f83a80000000ULL,
    0x8241240000000ULL,
    0x1da0160000000ULL,
    0xf6d16d0000000ULL,
    0xbfa8408000000ULL,
    0xbb67264000000ULL,
    0xe009162000000ULL,
    0xf0b4efd000000ULL,
    0x3822800800000ULL,
    0xfd92400c00000ULL,
    0x788200a00000ULL,
    0x86f5900900000ULL,
    0x4783a80080000ULL,
    0xe641240640000ULL,
    0x77a01606a0000ULL,
    0x7fd16d0890000ULL,
    0x1a28408a58000ULL,
    0x7027264cb4000ULL,
    0xf829162182000ULL,
    0x5d24efdad9000ULL,
    0x97aa8002f8800ULL,
    0x8f66400b2f400ULL,
    0x220a200858200ULL,
    0x8db69009b4300ULL,
    0xffa1280b02280ULL,
    0xdbd3640599240ULL,
    0xd028360cd8820ULL,
    0x6924fd09ff590ULL,
    0x55abe88ea03a8ULL,
    0xf266024490124ULL,
    0xe589002058016ULL,
    0xabf582d5b416dULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0xd000000000000ULL,
    0x4800000000000ULL,
    0x8c00000000000ULL,
    0xd600000000000ULL,
    0x3900000000000ULL,
    0xd580000000000ULL,
    0x3240000000000ULL,
    0xb2a0000000000ULL,
    0x7210000000000ULL,
    0x53d8000000000ULL,
    0x82cc000000000ULL,
    0xcb82000000000ULL,
    0x4743000000000ULL,
    0x9120800000000ULL,
    0xa953400000000ULL,
    0x7cf9200000000ULL,
    0x4e9e300000000ULL,
    0xfcf9580000000ULL,
    0x8e9fe40000000ULL,
    0xdcf9d60000000ULL,
    0x5e9c890000000ULL,
    0x94f96a8000000ULL,
    0xd29fb84000000ULL,
    0x42f9b76000000ULL,
    0xeb9c9f3000000ULL,
    0x9778800800000ULL,
    0xd9df400c00000ULL,
    0x25db200200000ULL,
    0xabcd300d00000ULL,
    0x7601d80480000ULL,
    0x2900a408c0000ULL,
    0xbd82f60d60000ULL,
    0x6e41b90390000ULL,
    0x2ca0b28d58000ULL,
    0xc7131c4324000ULL,
    0x5059416b2a000ULL,
    0x898e263721000ULL,
    0xaca0b28d3d800ULL,
    0x7131c442cc00ULL,
    0x7059416eb8200ULL,
    0x598e263974300ULL,
    0xe4a0b28592080ULL,
    0x8b131c4e55340ULL,
    0xa6594168af920ULL,
    0x608e263a79e30ULL,
    0x3120b28e17958ULL,
    0xb9531c4f0dfe4ULL,
    0x14f94169859d6ULL,
    0x129e263c58c89ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x5000000000000ULL,
    0xd800000000000ULL,
    0xf400000000000ULL,
    0x3e00000000000ULL,
    0x9500000000000ULL,
    0x8f80000000000ULL,
    0x3d40000000000ULL,
    0xf320000000000ULL,
    0x2ef0000000000ULL,
    0xadc8000000000ULL,
    0xa0c000000000ULL,
    0x8b22000000000ULL,
    0x4af3000000000ULL,
    0x6bc8800000000ULL,
    0x3b0d400000000ULL,
    0xe2a1600000000ULL,
    0x16b0d00000000ULL,
    0x2968780000000ULL,
    0xbdbf140000000ULL,
    0x33cb5e0000000ULL,
    0xf0c250000000ULL,
    0xfca1b48000000ULL,
    0xd3b0afc000000ULL,
    0x7eeb692000000ULL,
    0x74fe4d3000000ULL,
    0xfee8780800000ULL,
    0xb4ff140c00000ULL,
    0xdeeb5e0200000ULL,
    0xe4fc250500000ULL,
    0x6e9b48d80000ULL,
    0x10fcafcf40000ULL,
    0x38e96923e0000ULL,
    0x85fd4d3950000ULL,
    0xb768f800f8000ULL,
    0xb8be540fd4000ULL,
    0x44483e0d32000ULL,
    0x964ff507ef000ULL,
    0xe9814c875c800ULL,
    0x9c42fbcfe0c00ULL,
    0x62a1572b52200ULL,
    0xd6b2b83dff300ULL,
    0x969b48644880ULL,
    0xedbcafcc64d40ULL,
    0xebc9692318160ULL,
    0xfb0d4d36840d0ULL,
    0xc2a0f80dca078ULL,
    0x46b254083b314ULL,
    0xf16a3e0a6e95eULL,
    0x49bcf5080ff25ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0xb000000000000ULL,
    0x9800000000000ULL,
    0xa400000000000ULL,
    0x7a00000000000ULL,
    0xd500000000000ULL,
    0x280000000000ULL,
    0x6040000000000ULL,
    0x51e0000000000ULL,
    0x8870000000000ULL,
    0x8c28000000000ULL,
    0x47c4000000000ULL,
    0xbe2000000000ULL,
    0xad71000000000ULL,
    0xb6aa800000000ULL,
    0x3386c00000000ULL,
    0xb800600000000ULL,
    0x5403900000000ULL,
    0x4203680000000ULL,
    0xc101940000000ULL,
    0xe0826a0000000ULL,
    0x1143110000000ULL,
    0x2960af8000000ULL,
    0x3d3175c000000ULL,
    0xdf4a3aa000000ULL,
    0xaff49e1000000ULL,
    0xd62b680800000ULL,
    0x62c5940400000ULL,
    0x31606a0a00000ULL,
    0xd932110b00000ULL,
    0x54a2f8980000ULL,
    0xcaf7b5ca40000ULL,
    0x4caa5aa7a0000ULL,
    0xa6870e1d50000ULL,
    0x1a80000828000ULL,
    0x8440000204000ULL,
    0x8be0000f1e000ULL,
    0xed70000387000ULL,
    0x16a8000142800ULL,
    0x8384000e3c400ULL,
    0x200200071e200ULL,
    0xf001000787100ULL,
    0x3802800b42a80ULL,
    0x1402c0053c6c0ULL,
    0xe202600e9e060ULL,
    0x7102900dc7390ULL,
    0x7881e80ce2b68ULL,
    0xb54354086c594ULL,
    0x53600a0eb606aULL,
    0xe831810bc3211ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x3000000000000ULL,
    0x1800000000000ULL,
    0x3400000000000ULL,
    0x8a00000000000ULL,
    0x9d00000000000ULL,
    0x6780000000000ULL,
    0x8240000000000ULL,
    0x40e0000000000ULL,
    0x60f0000000000ULL,
    0x9148000000000ULL,
    0x2944000000000ULL,
    0x2d62000000000ULL,
    0xbfb3000000000ULL,
    0x162a800000000ULL,
    0xfbf4c00000000ULL,
    0xe4ca600000000ULL,
    0xc207d00000000ULL,
    0x2002a80000000ULL,
    0xf001b40000000ULL,
    0xb8037e0000000ULL,
    0x402190000000ULL,
    0x92034b8000000ULL,
    0xa90327c000000ULL,
    0xed81f32000000ULL,
    0x1f40d81000000ULL,
    0x2760280800000ULL,
    0xe2b1740c00000ULL,
    0xd1ab1e0a00000ULL,
    0x49b6c90300000ULL,
    0xbc2b638180000ULL,
    0x96f653c340000ULL,
    0x3b48ed28a0000ULL,
    0x44451119d0000ULL,
    0xf2e1cb8e78000ULL,
    0x39f3e7c424000ULL,
    0xc4c9932e0e000ULL,
    0x320408150f000ULL,
    0x9800000094800ULL,
    0xf400000dd4400ULL,
    0x2a00000076200ULL,
    0xad0000012b300ULL,
    0x7f8000069aa80ULL,
    0xb6400004db4c0ULL,
    0xcae00002e2a60ULL,
    0xfdf00003ff7d0ULL,
    0xf6c8000d6caa8ULL,
    0xab040005b05b4ULL,
    0x6d82000d5817eULL,
    0xdf43000db4119ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0xd000000000000ULL,
    0x800000000000ULL,
    0x4c00000000000ULL,
    0x200000000000ULL,
    0xb500000000000ULL,
    0x3680000000000ULL,
    0xc2c0000000000ULL,
    0x1420000000000ULL,
    0x750000000000ULL,
    0x1bf8000000000ULL,
    0x5034000000000ULL,
    0x48a2000000000ULL,
    0xac91000000000ULL,
    0xd35b800000000ULL,
    0xbca7400000000ULL,
    0x7bfa200000000ULL,
    0xc034300000000ULL,
    0xa0a1880000000ULL,
    0x3090940000000ULL,
    0xd95b7a0000000ULL,
    0x45a57b0000000ULL,
    0x4f7a788000000ULL,
    0xb7f6f94000000ULL,
    0x82013de000000ULL,
    0xf502dfd000000ULL,
    0xd682080800000ULL,
    0x12c3d40400000ULL,
    0x1c235a0e00000ULL,
    0x4b504b0d00000ULL,
    0x19f8708080000ULL,
    0xe5352d44c0000ULL,
    0x7e2267e020000ULL,
    0x6e5294db50000ULL,
    0xc77a788b68000ULL,
    0xbbf6f9482c000ULL,
    0x60013def42000ULL,
    0x9002dfdd75000ULL,
    0xe80208093f800ULL,
    0x9c03d405c3400ULL,
    0xa035a0aaa200ULL,
    0xf9004b0c99100ULL,
    0x3480708eddb80ULL,
    0x77c12d4326740ULL,
    0x22a067e6dda20ULL,
    0xc59394d726430ULL,
    0xfd9f880dd988ULL,
    0x5765b94e26494ULL,
    0x53591de65d97aULL,
    0xfca7efd3e647bULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x5000000000000ULL,
    0x6800000000000ULL,
    0x4c00000000000ULL,
    0x7600000000000ULL,
    0xf700000000000ULL,
    0x3680000000000ULL,
    0xd740000000000ULL,
    0x87e0000000000ULL,
    0xef30000000000ULL,
    0xa3a8000000000ULL,
    0xd544000000000ULL,
    0x23aa000000000ULL,
    0x1547000000000ULL,
    0xc3a9800000000ULL,
    0x4546400000000ULL,
    0xaba8200000000ULL,
    0x947700000000ULL,
    0xdda9f80000000ULL,
    0xfe44ac0000000ULL,
    0xeb29220000000ULL,
    0x2907f10000000ULL,
    0x6ccb3d8000000ULL,
    0xc6344dc000000ULL,
    0xcf61b32000000ULL,
    0x137318d000000ULL,
    0xeccb3d8800000ULL,
    0x6344dcc00000ULL,
    0x2f61b32e00000ULL,
    0x437318d500000ULL,
    0x84cb3d8e80000ULL,
    0x4a344dc8c0000ULL,
    0x5961b32960000ULL,
    0xb47318da70000ULL,
    0xb24b3d8de8000ULL,
    0x9d744dc5b4000ULL,
    0xde81b3211e000ULL,
    0x5b4318d483000ULL,
    0x11e33d87d2800ULL,
    0x48304dc8e0400ULL,
    0xfd2bb32324a00ULL,
    0x4e0418d5d7700ULL,
    0xd24abd8be8180ULL,
    0xd760dccb4240ULL,
    0x568393299e220ULL,
    0x474368d543070ULL,
    0xfe3458632878ULL,
    0xf332a1c3506ecULL,
    0xbdaab1272cb02ULL,
    0x6e4499d7d3781ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x9000000000000ULL,
    0xc800000000000ULL,
    0x7400000000000ULL,
    0x5200000000000ULL,
    0x300000000000ULL,
    0xeb80000000000ULL,
    0x6f40000000000ULL,
    0x6460000000000ULL,
    0xdaf0000000000ULL,
    0x1798000000000ULL,
    0x297c000000000ULL,
    0xa59a000000000ULL,
    0xfa7d000000000ULL,
    0xe61b800000000ULL,
    0x713f400000000ULL,
    0x1878a00000000ULL,
    0xdcce900000000ULL,
    0xb661e80000000ULL,
    0x99f29c0000000ULL,
    0x9c18460000000ULL,
    0xd63e210000000ULL,
    0x9fa578000000ULL,
    0x548e0ac000000ULL,
    0xa380a9e000000ULL,
    0x5b413f3000000ULL,
    0x5662578800000ULL,
    0x49f20ac400000ULL,
    0x341aa9e600000ULL,
    0x323c3f3900000ULL,
    0x93f9d78480000ULL,
    0x238d4ac340000ULL,
    0x1a0209e320000ULL,
    0x3702af3930000ULL,
    0xd9803f8a38000ULL,
    0xfc43d6c5b4000ULL,
    0x47e04fe566000ULL,
    0xc1b18e349f000ULL,
    0x21f9e80b41800ULL,
    0xf08e9c0723c00ULL,
    0x5982460f3fa00ULL,
    0xbc43210b38d00ULL,
    0x27e1d78d20380ULL,
    0x51b14ac430340ULL,
    0xe9f809e8b82a0ULL,
    0x848faf3ff4390ULL,
    0xb83bf82c6268ULL,
    0xbf4096ceef1dcULL,
    0xcc62efe259ae6ULL,
    0x3ef21e3ba7db1ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0xd000000000000ULL,
    0xb800000000000ULL,
    0x400000000000ULL,
    0x6e00000000000ULL,
    0x9700000000000ULL,
    0xf280000000000ULL,
    0xedc0000000000ULL,
    0x1360000000000ULL,
    0x5c90000000000ULL,
    0xdb58000000000ULL,
    0x31e4000000000ULL,
    0x9da000000000ULL,
    0xcc27000000000ULL,
    0x2b8800000000ULL,
    0x44b4400000000ULL,
    0xfe2600000000ULL,
    0xe650500000000ULL,
    0x9ab9d80000000ULL,
    0x50b50c0000000ULL,
    0x79e2920000000ULL,
    0xa552fb0000000ULL,
    0xbe38bf8000000ULL,
    0x2e77d94000000ULL,
    0xf6000ae000000ULL,
    0x830112d000000ULL,
    0x84803f8800000ULL,
    0xaec3994c00000ULL,
    0x37e26aea00000ULL,
    0x225142dd00000ULL,
    0x54b9e78380000ULL,
    0x17b6954c40000ULL,
    0x3360f8ece0000ULL,
    0x4c93b9d470000ULL,
    0xc359580ca8000ULL,
    0xe5e54c029c000ULL,
    0xdfdaf20dd6000ULL,
    0x5f25ab01b9000ULL,
    0x9e39e7891d800ULL,
    0x3e76954d82400ULL,
    0xee00f8e74ba00ULL,
    0x5703b9d07b700ULL,
    0x5281580ab6080ULL,
    0x3dc14c0589040ULL,
    0xab60f20b55860ULL,
    0x5892ab0a6e750ULL,
    0xb559678fb5958ULL,
    0xa6e6d5421e54cULL,
    0xfb5898e11daf2ULL,
    0x21e4e9d1825abULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x3000000000000ULL,
    0x6800000000000ULL,
    0xec00000000000ULL,
    0x2200000000000ULL,
    0x2b00000000000ULL,
    0x3680000000000ULL,
    0x9d40000000000ULL,
    0x6a20000000000ULL,
    0x1670000000000ULL,
    0x4de8000000000ULL,
    0x330c000000000ULL,
    0x936a000000000ULL,
    0x824f000000000ULL,
    0x3b49800000000ULL,
    0x8f3fc00000000ULL,
    0x2820200000000ULL,
    0xcd70700000000ULL,
    0xf36aa80000000ULL,
    0x724fdc0000000ULL,
    0xb34bf20000000ULL,
    0x533e690000000ULL,
    0x62207a8000000ULL,
    0xa7140c000000ULL,
    0xe7ea652000000ULL,
    0xc40d90f000000ULL,
    0xefe9fa8800000ULL,
    0xd80e80cc00000ULL,
    0x45ea452e00000ULL,
    0x2f0de0f300000ULL,
    0x396b528e80000ULL,
    0x754d5cc2c0000ULL,
    0x47cbb72c20000ULL,
    0xd57c89f1b0000ULL,
    0x5682a80de8000ULL,
    0x6d43dc0b14000ULL,
    0xe221f20a82000ULL,
    0xca716900d7000ULL,
    0x7e9fa8136800ULL,
    0xf40e80c424c00ULL,
    0x87ea452db4a00ULL,
    0x340de0fbf3f00ULL,
    0x67eb528c02180ULL,
    0x40d5cce173c0ULL,
    0xfebb72316a20ULL,
    0xe80c89f694f70ULL,
    0x2deaa806dcb28ULL,
    0xc30fdc0e27c1cULL,
    0x1b6bf20ca01d2ULL,
    0x5e4e690070119ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x3000000000000ULL,
    0x2800000000000ULL,
    0xd400000000000ULL,
    0x8a00000000000ULL,
    0xff00000000000ULL,
    0x8480000000000ULL,
    0x73c0000000000ULL,
    0x1320000000000ULL,
    0xc2b0000000000ULL,
    0xfb38000000000ULL,
    0x361c000000000ULL,
    0x401a000000000ULL,
    0xe0af000000000ULL,
    0x1122800000000ULL,
    0x19b3c00000000ULL,
    0xfdb8200000000ULL,
    0x5edf900000000ULL,
    0x75b8880000000ULL,
    0x7adfac0000000ULL,
    0xf7baba0000000ULL,
    0x61ddf30000000ULL,
    0xd1387e8000000ULL,
    0x391e55c000000ULL,
    0xcc9ba86000000ULL,
    0x776cbeb000000ULL,
    0xa000f68800000ULL,
    0xf001f9cc00000ULL,
    0x801126200000ULL,
    0xe4014db300000ULL,
    0xa200880a80000ULL,
    0x2b03ac0140000ULL,
    0xe80ba0aa0000ULL,
    0x8cc2f30cf0000ULL,
    0x97a2fe8ac8000ULL,
    0xb17195ca7c000ULL,
    0xe819886992000ULL,
    0xf4ac2eb3db000ULL,
    0xbb22fe8ffb800ULL,
    0xd6b195c85dc00ULL,
    0x5139886733a00ULL,
    0xf91c2eb121f00ULL,
    0xec9afe8421a80ULL,
    0x476d95c3bafc0ULL,
    0x880388617a220ULL,
    0x24032eb717090ULL,
    0x82007e8481a08ULL,
    0x1b0255c04ac6cULL,
    0x2681a86b3229aULL,
    0x58c3beb32b263ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x5000000000000ULL,
    0xb800000000000ULL,
    0x8400000000000ULL,
    0x1a00000000000ULL,
    0xaf00000000000ULL,
    0xbd80000000000ULL,
    0xdfc0000000000ULL,
    0x14e0000000000ULL,
    0x4350000000000ULL,
    0xda38000000000ULL,
    0x4e1c000000000ULL,
    0x4cda000000000ULL,
    0x364d000000000ULL,
    0x2960800000000ULL,
    0xdc90400000000ULL,
    0x6ed8600000000ULL,
    0x5d4f500000000ULL,
    0x2ee0880000000ULL,
    0xfc51ac0000000ULL,
    0x7fb81e0000000ULL,
    0x45dc830000000ULL,
    0xfa3a458000000ULL,
    0x5e1d624000000ULL,
    0x54dbd36000000ULL,
    0xe24ec93000000ULL,
    0x8b62cd8800000ULL,
    0xf790ce4400000ULL,
    0xc959cd6a00000ULL,
    0x2d8f4a3500000ULL,
    0x8780080380000ULL,
    0x60c1ec0c40000ULL,
    0xb1607e0ba0000ULL,
    0x4893d30ff0000ULL,
    0x6cdacd8058000ULL,
    0x264cce45bc000ULL,
    0x3163cd60ee000ULL,
    0x8924a3ec5000ULL,
    0xccd8880e7b800ULL,
    0x764dac0d1dc00ULL,
    0x89621e0f83a00ULL,
    0x8c91830251d00ULL,
    0xd6dac584b5880ULL,
    0xd94d224168c40ULL,
    0x34e3b36380260ULL,
    0x5351993c40250ULL,
    0xc23a4583a0008ULL,
    0x9a1d624bf01ecULL,
    0xeedbd36a5807eULL,
    0x1d4ec930bc3d3ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x7000000000000ULL,
    0x800000000000ULL,
    0xf400000000000ULL,
    0xf600000000000ULL,
    0x8b00000000000ULL,
    0xc980000000000ULL,
    0x5540000000000ULL,
    0x6720000000000ULL,
    0xf3f0000000000ULL,
    0x3478000000000ULL,
    0x5744000000000ULL,
    0x1ada000000000ULL,
    0xb1f5000000000ULL,
    0xa981800000000ULL,
    0x6540c00000000ULL,
    0x8f23a00000000ULL,
    0x77f2100000000ULL,
    0xca7bf80000000ULL,
    0x2845fc0000000ULL,
    0x255afe0000000ULL,
    0x6fb6790000000ULL,
    0x7233a8000000ULL,
    0xc3f25ac000000ULL,
    0xdc7aed6000000ULL,
    0xd34482d000000ULL,
    0xe4d9428800000ULL,
    0xcef766c400000ULL,
    0x9603b36e00000ULL,
    0xbb00ebd700000ULL,
    0x2181800880000ULL,
    0xd140c00b40000ULL,
    0x9923a00160000ULL,
    0x8cf2100fb0000ULL,
    0xbfbf80c18000ULL,
    0x8905fc0a14000ULL,
    0xb47afe0912000ULL,
    0x174679078f000ULL,
    0xfadb3a8fdf800ULL,
    0xc1f65ac020400ULL,
    0xa180ed67dfa00ULL,
    0x914182d420500ULL,
    0x7920c281df980ULL,
    0xfcf3a6c7204c0ULL,
    0x3fa13675f9a0ULL,
    0x7d07fbdb60710ULL,
    0x427bf80ebfa78ULL,
    0x9c45fc0f9053cULL,
    0x335afe0bc795eULL,
    0x94b6790e34469ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x9000000000000ULL,
    0x6800000000000ULL,
    0xf400000000000ULL,
    0x6200000000000ULL,
    0xdf00000000000ULL,
    0x7980000000000ULL,
    0xdd40000000000ULL,
    0x76e0000000000ULL,
    0x2cf0000000000ULL,
    0xcfb8000000000ULL,
    0x51ec000000000ULL,
    0xc8da000000000ULL,
    0x845d000000000ULL,
    0x9b81800000000ULL,
    0x4243400000000ULL,
    0xef62200000000ULL,
    0x61b1900000000ULL,
    0xd158280000000ULL,
    0x891cac0000000ULL,
    0x65626e0000000ULL,
    0xab1090000000ULL,
    0x2adbbd8000000ULL,
    0x1b5d86c000000ULL,
    0x201456000000ULL,
    0xf03247000000ULL,
    0xf182158800000ULL,
    0xb9426ac400000ULL,
    0x7ce10b6e00000ULL,
    0x7f3bd7900000ULL,
    0xd439800e80000ULL,
    0x53af400b40000ULL,
    0xc7b8200820000ULL,
    0x75ec9004f0000ULL,
    0x22d9a80118000ULL,
    0x3f5fec0294000ULL,
    0xe8004e014e000ULL,
    0xb400990f3f000ULL,
    0x8203958b63800ULL,
    0x4f012ac8cac00ULL,
    0x11832b6be3a00ULL,
    0x29422d7a8ad00ULL,
    0x14e1a80d43980ULL,
    0xf3f3ec053af40ULL,
    0xb63a4e0c7b820ULL,
    0x8cad99075ec90ULL,
    0xbe3a15822d9a8ULL,
    0xa8ae6ac3f5fecULL,
    0x543b0b6e8004eULL,
    0x13aebd7b40099ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x5000000000000ULL,
    0x1800000000000ULL,
    0xdc00000000000ULL,
    0x4200000000000ULL,
    0x3700000000000ULL,
    0x2080000000000ULL,
    0xf140000000000ULL,
    0x2860000000000ULL,
    0x9490000000000ULL,
    0x8788000000000ULL,
    0xa83c000000000ULL,
    0x556a000000000ULL,
    0xe6ef000000000ULL,
    0xf803800000000ULL,
    0x4c02400000000ULL,
    0x3a01e00000000ULL,
    0xbb02300000000ULL,
    0x7a81680000000ULL,
    0x1a43ac0000000ULL,
    0x4ae18a0000000ULL,
    0x52d3190000000ULL,
    0x8f68238000000ULL,
    0xcded974000000ULL,
    0xfa80bfa000000ULL,
    0xda43f2b000000ULL,
    0x2ae2cb8800000ULL,
    0x2d07b4c00000ULL,
    0x976ad5a600000ULL,
    0x11eddbb500000ULL,
    0xb880000980000ULL,
    0xed400001c0000ULL,
    0xa60000220000ULL,
    0xf390000670000ULL,
    0xbf08000388000ULL,
    0x857c0002d4000ULL,
    0x3f0a0006a6000ULL,
    0x457f000a39000ULL,
    0x5f0b800a70800ULL,
    0x157e400597c00ULL,
    0x470be007d0a00ULL,
    0xc97d300727f00ULL,
    0x50ae807f8b80ULL,
    0xfe7dec0e43e40ULL,
    0x258a6a06f6be0ULL,
    0xf3e2905ded30ULL,
    0xdeacb88282e8ULL,
    0x9bac7b45641ecULL,
    0x8a60d5a70e06aULL,
    0x3392dbbe9d129ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0xf000000000000ULL,
    0xf800000000000ULL,
    0x3400000000000ULL,
    0x6200000000000ULL,
    0xf500000000000ULL,
    0xa880000000000ULL,
    0xfcc0000000000ULL,
    0x8e20000000000ULL,
    0x53f0000000000ULL,
    0xc778000000000ULL,
    0x9574000000000ULL,
    0xb802000000000ULL,
    0xd4e5000000000ULL,
    0xb280800000000ULL,
    0xfdc0c00000000ULL,
    0x64a0200000000ULL,
    0xaa30f00000000ULL,
    0x19d8f80000000ULL,
    0xe44340000000ULL,
    0x935a620000000ULL,
    0xe761f50000000ULL,
    0x657a288000000ULL,
    0x40913cc000000ULL,
    0xe0022e2000000ULL,
    0xd0e563f000000ULL,
    0x8809f7800000ULL,
    0xccc0917400000ULL,
    0x5620020200000ULL,
    0x97f0e5e500000ULL,
    0x5d78800080000ULL,
    0x5474c000c0000ULL,
    0x7282200020000ULL,
    0xdd25f000f0000ULL,
    0x94207800f8000ULL,
    0x52f0f40034000ULL,
    0x2df8420062000ULL,
    0x6cb40500f5000ULL,
    0x66a25080a8800ULL,
    0x4fd5c8c0fcc00ULL,
    0x99d86c208e200ULL,
    0xce4466f053f00ULL,
    0xb35a4ff8c7780ULL,
    0x176199b495740ULL,
    0x9d7a4e22b8020ULL,
    0x74917315d4e50ULL,
    0x8202b7f832808ULL,
    0x25e5adb43dc0cULL,
    0xa0002c2244a02ULL,
    0x300086155a30fULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0xf000000000000ULL,
    0xf800000000000ULL,
    0xec00000000000ULL,
    0x7e00000000000ULL,
    0x6100000000000ULL,
    0x5c80000000000ULL,
    0xe6c0000000000ULL,
    0xdda0000000000ULL,
    0x2a70000000000ULL,
    0x9338000000000ULL,
    0x13cc000000000ULL,
    0xd3ce000000000ULL,
    0x7379000000000ULL,
    0x83a0800000000ULL,
    0x7b70c00000000ULL,
    0x97b8a00000000ULL,
    0xe90cf00000000ULL,
    0x886ef80000000ULL,
    0xd409ec0000000ULL,
    0x3218fe0000000ULL,
    0xef7ca10000000ULL,
    0xc556fc8000000ULL,
    0x56c516c000000ULL,
    0x4556a5a000000ULL,
    0x96c5067000000ULL,
    0xe556cd3800000ULL,
    0x66c542cc00000ULL,
    0x1d56574e00000ULL,
    0x8ac549b900000ULL,
    0x6356f80080000ULL,
    0xebc5ec00c0000ULL,
    0x3fd6fe00a0000ULL,
    0xd05a100f0000ULL,
    0xe2767c80f8000ULL,
    0x2775d6c0ec000ULL,
    0x714e05a07e000ULL,
    0x34b9f67061000ULL,
    0xa28035385c800ULL,
    0x47c0aecce6c00ULL,
    0x2120a94edda00ULL,
    0x3cb0e8b92a700ULL,
    0xb698848013380ULL,
    0xd5bc3ac0d3cc0ULL,
    0x3ef6fba073ce0ULL,
    0x1b5577083790ULL,
    0xceec9b87ba08ULL,
    0xeec9b80c9770cULL,
    0xc9b80ceee9b8aULL,
    0xb80ceec9880cfULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0xb000000000000ULL,
    0x5800000000000ULL,
    0x2c00000000000ULL,
    0x9a00000000000ULL,
    0xf900000000000ULL,
    0x3c80000000000ULL,
    0xb2c0000000000ULL,
    0xad20000000000ULL,
    0x3a30000000000ULL,
    0x8998000000000ULL,
    0x448c000000000ULL,
    0x2eea000000000ULL,
    0x6f81000000000ULL,
    0xef20800000000ULL,
    0x2f30c00000000ULL,
    0xf18200000000ULL,
    0xbf4cb00000000ULL,
    0xe74a580000000ULL,
    0xcb712c0000000ULL,
    0x51981a0000000ULL,
    0xa88c390000000ULL,
    0x94ea1c8000000ULL,
    0x268102c000000ULL,
    0x8ba0752000000ULL,
    0xb1f0d63000000ULL,
    0x3838339800000ULL,
    0x7c7c0d8c00000ULL,
    0x52524a6a00000ULL,
    0x3d3df14100000ULL,
    0xd252580080000ULL,
    0xfd3d2c00c0000ULL,
    0xf2521a0020000ULL,
    0x4d3d3900b0000ULL,
    0xaa529c8058000ULL,
    0x613dc2c02c000ULL,
    0x305255209a000ULL,
    0x983d6630f9000ULL,
    0xcd2eb983c800ULL,
    0x2afde18cb2c00ULL,
    0xa1f2706aad200ULL,
    0x10cd78413a300ULL,
    0x286a1c8009980ULL,
    0x544102c0848c0ULL,
    0x68075200eea0ULL,
    0x3bc0d630df810ULL,
    0xe9a03398b7208ULL,
    0x14f00d8c0330cULL,
    0xe6b84a6a95182ULL,
    0xabbcf141464cbULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0xb000000000000ULL,
    0xd800000000000ULL,
    0xac00000000000ULL,
    0x8e00000000000ULL,
    0x900000000000ULL,
    0x9e80000000000ULL,
    0xa1c0000000000ULL,
    0xcaa0000000000ULL,
    0x3370000000000ULL,
    0x9578000000000ULL,
    0x85c000000000ULL,
    0x24b6000000000ULL,
    0x6a35000000000ULL,
    0x4378800000000ULL,
    0x6d5cc00000000ULL,
    0x1436200000000ULL,
    0x72f5b00000000ULL,
    0xcf58580000000ULL,
    0x53ec6c0000000ULL,
    0xc5eeae0000000ULL,
    0x40d9b90000000ULL,
    0xe016c68000000ULL,
    0x9045cdc000000ULL,
    0x6880e4a000000ULL,
    0x74c04a7000000ULL,
    0x2220f3f800000ULL,
    0x87b0b59c00000ULL,
    0x9758b81600000ULL,
    0x3fecfc4500000ULL,
    0x6beec68080000ULL,
    0xf9d9cdc0c0000ULL,
    0xa696e4a020000ULL,
    0x9d854a70b0000ULL,
    0x2c2073f8d8000ULL,
    0x4eb0759cac000ULL,
    0x29d898168e000ULL,
    0x2e2c4c4509000ULL,
    0x794e1e801e800ULL,
    0x66a961c061c00ULL,
    0xbdee6aa0eaa00ULL,
    0x9cd9437083700ULL,
    0x9616ed784d780ULL,
    0x8545d45ca45c0ULL,
    0xa000d2b6aab60ULL,
    0x7000bf3563350ULL,
    0xf800abf85df88ULL,
    0x1c00d99c0c9ccULL,
    0x56001616fe962ULL,
    0xa5004545f185bULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0xf000000000000ULL,
    0xa800000000000ULL,
    0x2c00000000000ULL,
    0xa200000000000ULL,
    0x2d00000000000ULL,
    0xda80000000000ULL,
    0xf940000000000ULL,
    0xec60000000000ULL,
    0x2b0000000000ULL,
    0x3d48000000000ULL,
    0x825c000000000ULL,
    0x7d4a000000000ULL,
    0x6261000000000ULL,
    0x8dc8800000000ULL,
    0xca1c400000000ULL,
    0xa1aae00000000ULL,
    0x6891f00000000ULL,
    0x8c60280000000ULL,
    0xb2b06c0000000ULL,
    0x7548420000000ULL,
    0x5e5cdd0000000ULL,
    0x774a728000000ULL,
    0x6361d54000000ULL,
    0xf548ce6000000ULL,
    0x1e5c6fb000000ULL,
    0x974a07c800000ULL,
    0x93618b1c00000ULL,
    0x5d48b92a00000ULL,
    0x325c0cd100000ULL,
    0x354af28080000ULL,
    0xbe61954040000ULL,
    0x87c82e60e0000ULL,
    0xcb1c9fb0f0000ULL,
    0xd92aafc8a8000ULL,
    0xbcd1a71c2c000ULL,
    0xba801b2aa2000ULL,
    0x494021d12d000ULL,
    0xa46028005a800ULL,
    0xdeb06c00b9400ULL,
    0x374842000c600ULL,
    0x835cdd00f2b00ULL,
    0x5ca728095480ULL,
    0xb621d540ae5c0ULL,
    0xbb28ce60df4a0ULL,
    0x31ec6fb04f610ULL,
    0x708207c857488ULL,
    0xe87d8b1c335c4ULL,
    0xcc62b92a4dcaeULL,
    0x528d0cd16a21fULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x3000000000000ULL,
    0xc800000000000ULL,
    0x7c00000000000ULL,
    0x8200000000000ULL,
    0x4f00000000000ULL,
    0xbe80000000000ULL,
    0xedc0000000000ULL,
    0x2160000000000ULL,
    0xab70000000000ULL,
    0x7868000000000ULL,
    0x746c000000000ULL,
    0x1e9a000000000ULL,
    0xfdcb000000000ULL,
    0x3908800000000ULL,
    0x2f1cc00000000ULL,
    0x4ef2e00000000ULL,
    0xc5a7300000000ULL,
    0x6d92480000000ULL,
    0xe1d7bc0000000ULL,
    0x4b7ae20000000ULL,
    0x487bbf0000000ULL,
    0xbc80168000000ULL,
    0x62c061c000000ULL,
    0x7fe08b6000000ULL,
    0x76b0a87000000ULL,
    0x91088ce800000ULL,
    0xa31caaac00000ULL,
    0xe4f2037a00000ULL,
    0xc6a7f47b00000ULL,
    0x99125e8080000ULL,
    0x3f17ddc0c0000ULL,
    0x569a6960e0000ULL,
    0x41cb177030000ULL,
    0x5b089a68c8000ULL,
    0x501ccb6c7c000ULL,
    0x3872881a82000ULL,
    0x54675c0b4f000ULL,
    0xcef2d2683e800ULL,
    0x5a7776c2dc00ULL,
    0x8d926a1ac1600ULL,
    0xd1d7e30b9b700ULL,
    0x837a44e830680ULL,
    0x347bd6acc86c0ULL,
    0x3e80017a7c9a0ULL,
    0x2dc07b7b82cb0ULL,
    0xc1608000cf888ULL,
    0x9b70c0007edccULL,
    0xb068e0000d92eULL,
    0x86c300011d73ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x1000000000000ULL,
    0x9800000000000ULL,
    0x2c00000000000ULL,
    0x600000000000ULL,
    0xcd00000000000ULL,
    0x8a80000000000ULL,
    0x1bc0000000000ULL,
    0xffa0000000000ULL,
    0xad50000000000ULL,
    0x7af8000000000ULL,
    0xb3dc000000000ULL,
    0x5b2e000000000ULL,
    0x1f29000000000ULL,
    0x9d58800000000ULL,
    0xf28cc00000000ULL,
    0x7d6200000000ULL,
    0x71f5100000000ULL,
    0xd4f6180000000ULL,
    0xda65ec0000000ULL,
    0x632ea60000000ULL,
    0xe3291d0000000ULL,
    0x2358b28000000ULL,
    0x38ce7c000000ULL,
    0x135641a000000ULL,
    0x8b355c5000000ULL,
    0xa7d6ee7800000ULL,
    0xa1f5891c00000ULL,
    0x6cf6880e00000ULL,
    0xe665b4b900000ULL,
    0xfd2eaa8080000ULL,
    0x2290bc0c0000ULL,
    0xafd8e7a020000ULL,
    0xd54c415010000ULL,
    0x66765cf898000ULL,
    0x3da56edc2c000ULL,
    0x228ec9ae06000ULL,
    0xbf79e8e9cd000ULL,
    0x4d20c4f80a800ULL,
    0x4a9042dcdbc00ULL,
    0x3b584faedfa00ULL,
    0xef8ce5e9bd500ULL,
    0x3556ee7862f80ULL,
    0x5635891c5fdc0ULL,
    0xb556880e7d2e0ULL,
    0x9635b4b9c2290ULL,
    0x9556aa800fd88ULL,
    0x86350bc0054ccULL,
    0xd56e7a0de762ULL,
    0xaa35415001a51ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x9000000000000ULL,
    0x9800000000000ULL,
    0x5400000000000ULL,
    0x3a00000000000ULL,
    0x9d00000000000ULL,
    0x7e80000000000ULL,
    0x7f40000000000ULL,
    0x1720000000000ULL,
    0xab50000000000ULL,
    0x6df8000000000ULL,
    0x96a4000000000ULL,
    0x83d2000000000ULL,
    0x71e1000000000ULL,
    0xc0d8800000000ULL,
    0xe0f4400000000ULL,
    0x30aaa00000000ULL,
    0x805900000000ULL,
    0xcc2a180000000ULL,
    0x6e45140000000ULL,
    0xa78a1a0000000ULL,
    0xe3554d0000000ULL,
    0x1d2c68000000ULL,
    0x68e1fb4000000ULL,
    0xbc58952000000ULL,
    0xc6b4b25000000ULL,
    0xfb0a117800000ULL,
    0x1515b0e400000ULL,
    0xf272c87200000ULL,
    0xb1f12cf100000ULL,
    0x2000de8080000ULL,
    0xd000ef4040000ULL,
    0x38008f20a0000ULL,
    0xc400ff5090000ULL,
    0xa20057f898000ULL,
    0xc9000ba454000ULL,
    0x4480fd523a000ULL,
    0xe2400ea19d000ULL,
    0x69a0d7f8fe800ULL,
    0xd4104ba43f400ULL,
    0x7ad85d52b7200ULL,
    0x3df49ea13b500ULL,
    0xee2a4ff875f80ULL,
    0xe7451fa482a40ULL,
    0x430ae75219d20ULL,
    0x911543a17ce10ULL,
    0xf0721178a6588ULL,
    0xe8f1b0e48bb44ULL,
    0xfc80c872bd8aaULL,
    0x66402cf1ae559ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0xb000000000000ULL,
    0x800000000000ULL,
    0x8400000000000ULL,
    0xb200000000000ULL,
    0xb900000000000ULL,
    0xbe80000000000ULL,
    0x4fc0000000000ULL,
    0x5560000000000ULL,
    0xf8f0000000000ULL,
    0xac28000000000ULL,
    0x66d4000000000ULL,
    0xb30a000000000ULL,
    0x8bb5000000000ULL,
    0xc7c8800000000ULL,
    0x11e4c00000000ULL,
    0xaa42e00000000ULL,
    0xa591b00000000ULL,
    0xd0ea880000000ULL,
    0x7885440000000ULL,
    0x6c80d20000000ULL,
    0x86c0c90000000ULL,
    0x3e0568000000ULL,
    0x83307bc000000ULL,
    0x4348ef6000000ULL,
    0xa324c5f000000ULL,
    0x13a2a0a800000ULL,
    0x1ba1901400000ULL,
    0x9f22d8ea00000ULL,
    0x2d61fc8500000ULL,
    0x94c25e8080000ULL,
    0x2a51ffc0c0000ULL,
    0x658add60e0000ULL,
    0x3075bcf0b0000ULL,
    0xc8a87e2808000ULL,
    0x6414afd484000ULL,
    0x2eae58ab2000ULL,
    0xb185f075b9000ULL,
    0x3a00a8a83e800ULL,
    0xfd0014148fc00ULL,
    0xec80eaeab5600ULL,
    0x46c0858548f00ULL,
    0xe3e0800024280ULL,
    0x3330c00022d40ULL,
    0x4b48e000e10a0ULL,
    0x2724b00082b50ULL,
    0xa1a2080071488ULL,
    0xa2a18400da24cULL,
    0x21a232004d22eULL,
    0x62a17900e461bULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x3000000000000ULL,
    0x7800000000000ULL,
    0x2400000000000ULL,
    0x9e00000000000ULL,
    0x4700000000000ULL,
    0x6780000000000ULL,
    0xf740000000000ULL,
    0xdf20000000000ULL,
    0xb310000000000ULL,
    0x7168000000000ULL,
    0x8c4c000000000ULL,
    0x3252000000000ULL,
    0xe5d5000000000ULL,
    0xaa52800000000ULL,
    0x31d5c00000000ULL,
    0x2c52e00000000ULL,
    0x62d5f00000000ULL,
    0xadd2980000000ULL,
    0xf695d40000000ULL,
    0x8b72060000000ULL,
    0xf5c5930000000ULL,
    0x42ba618000000ULL,
    0x3dd9644000000ULL,
    0xdea0bea000000ULL,
    0xe750d75000000ULL,
    0x37c84fc800000ULL,
    0xbf1c9b1c00000ULL,
    0x839a1d9a00000ULL,
    0x9c94ec900000ULL,
    0xa8484fc880000ULL,
    0xac5c9b1cc0000ULL,
    0xa2ba1d9a60000ULL,
    0xcdd94ec930000ULL,
    0xc6a04fc8f8000ULL,
    0xf3509b1ce4000ULL,
    0xd1c81d9afe000ULL,
    0xdc1c4ec977000ULL,
    0x7a1acfc89f800ULL,
    0xb9895b1c13400ULL,
    0x10e8fd9a21200ULL,
    0xe80cbec9c4100ULL,
    0xcf2d7c8eee80ULL,
    0xf2854f1c9f0c0ULL,
    0x859a1b9a13720ULL,
    0x9ac9ddc921c50ULL,
    0x49c8ae4844ba8ULL,
    0x81c3f5caed9cULL,
    0xfc1a433a3f20eULL,
    0xea8969994310fULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0xb000000000000ULL,
    0x7800000000000ULL,
    0x9c00000000000ULL,
    0xee00000000000ULL,
    0x1b00000000000ULL,
    0xcb80000000000ULL,
    0xc340000000000ULL,
    0xc7a0000000000ULL,
    0x510000000000ULL,
    0x8868000000000ULL,
    0xc474000000000ULL,
    0x225a000000000ULL,
    0x3da1000000000ULL,
    0x345a800000000ULL,
    0x7aa1c00000000ULL,
    0xf1da600000000ULL,
    0x12e1700000000ULL,
    0x85fa180000000ULL,
    0x48b1ec0000000ULL,
    0x2432f60000000ULL,
    0x92d5f70000000ULL,
    0x45803d8000000ULL,
    0xa840344000000ULL,
    0x94207a2000000ULL,
    0xea50f15000000ULL,
    0xd9c8124800000ULL,
    0x4664852400000ULL,
    0x8fb2481200000ULL,
    0x2195248500000ULL,
    0x1a20124880000ULL,
    0x81508524c0000ULL,
    0x8a484812e0000ULL,
    0xa9242485b0000ULL,
    0xde129248f8000ULL,
    0xa38545245c000ULL,
    0xb7c828120e000ULL,
    0x9d645485ab000ULL,
    0xa4320a4833800ULL,
    0x52d569249f400ULL,
    0xa580be12c9a00ULL,
    0x1840d385ae100ULL,
    0xec202fc8bbe80ULL,
    0x7650b1645b340ULL,
    0x37c83232ebfa0ULL,
    0x5d64d5d593b10ULL,
    0x443280008fb28ULL,
    0xe2d5c0002195cULL,
    0xdd8060001a206ULL,
    0x8440700081507ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x1000000000000ULL,
    0x5800000000000ULL,
    0x7c00000000000ULL,
    0xc200000000000ULL,
    0xe100000000000ULL,
    0xd80000000000ULL,
    0xd7c0000000000ULL,
    0x2aa0000000000ULL,
    0xf530000000000ULL,
    0x9ba8000000000ULL,
    0xc0f4000000000ULL,
    0x20c6000000000ULL,
    0x702f000000000ULL,
    0x4866800000000ULL,
    0x241f400000000ULL,
    0xbe4ee00000000ULL,
    0x232b500000000ULL,
    0xec28b80000000ULL,
    0xda342c0000000ULL,
    0xfde6fa0000000ULL,
    0xdfdf8d0000000ULL,
    0x6eee178000000ULL,
    0x5b1b0ac000000ULL,
    0xe000052000000ULL,
    0x500093f000000ULL,
    0x3800848800000ULL,
    0x6c008e0400000ULL,
    0x9a000bce00000ULL,
    0x9d00d8eb00000ULL,
    0xcf803c8880000ULL,
    0x36c0a20440000ULL,
    0x2720f1ce60000ULL,
    0x22f055eb10000ULL,
    0xb108ab08d8000ULL,
    0x35c4e8c43c000ULL,
    0xbb6e14eea2000ULL,
    0xb0db961bf1000ULL,
    0x68a09780d5800ULL,
    0x54304ac0ebc00ULL,
    0xf628e52088a00ULL,
    0x734c3f004300ULL,
    0x5266bc88ce280ULL,
    0xf91fe2046b340ULL,
    0x11ce11cec8660ULL,
    0x5eb05eb641f0ULL,
    0x930813085e4e8ULL,
    0x84c4c4c4732b4ULL,
    0x8eeeeeeed428eULL,
    0xb1b1b1bb6345ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0x3000000000000ULL,
    0xb800000000000ULL,
    0xac00000000000ULL,
    0x7200000000000ULL,
    0xb100000000000ULL,
    0x380000000000ULL,
    0xd2c0000000000ULL,
    0xc160000000000ULL,
    0x9b90000000000ULL,
    0x4e48000000000ULL,
    0xb74000000000ULL,
    0x864e000000000ULL,
    0x3f0b000000000ULL,
    0x6806800000000ULL,
    0x447f400000000ULL,
    0x7648a00000000ULL,
    0xe774700000000ULL,
    0xd44e980000000ULL,
    0xbe0b9c0000000ULL,
    0xd3864a0000000ULL,
    0x3abf5d0000000ULL,
    0xc528d18000000ULL,
    0xcde413c000000ULL,
    0x99865ae000000ULL,
    0x67bfd55000000ULL,
    0x94a8c52800000ULL,
    0x9e24cde400000ULL,
    0xe366998600000ULL,
    0x82ef67bf00000ULL,
    0x698014a880000ULL,
    0xbfc0de2440000ULL,
    0x28e0c36620000ULL,
    0x6450b2ef30000ULL,
    0x46a8d18038000ULL,
    0x5f2413c0ec000ULL,
    0x78e65ae052000ULL,
    0xcc2fd55081000ULL,
    0x62e0c528bb800ULL,
    0x3950cde47ec00ULL,
    0x17289986b3600ULL,
    0xce467bf2a900ULL,
    0x20694a8cdc80ULL,
    0x297f9e2499b40ULL,
    0x9fc86366672e0ULL,
    0x18b4c2ef949b0ULL,
    0xdcae49801e4e8ULL,
    0xea5b8fc0a30b4ULL,
    0x2d2e10e0a206aULL,
    0xc99b8850597f7ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x7000000000000ULL,
    0x8800000000000ULL,
    0x4400000000000ULL,
    0x4a00000000000ULL,
    0x4700000000000ULL,
    0xdd80000000000ULL,
    0x4240000000000ULL,
    0xc320000000000ULL,
    0x7710000000000ULL,
    0x75b8000000000ULL,
    0x966c000000000ULL,
    0x715e000000000ULL,
    0xfc95000000000ULL,
    0xa6e6800000000ULL,
    0xd9f9c00000000ULL,
    0x2838600000000ULL,
    0x142cb00000000ULL,
    0x527e680000000ULL,
    0xfb85340000000ULL,
    0x5b5e420000000ULL,
    0xb95c30000000ULL,
    0x1366f78000000ULL,
    0xafb9b54000000ULL,
    0x2918f6a000000ULL,
    0x603cc15000000ULL,
    0xb046949800000ULL,
    0x68a9927c00000ULL,
    0x34a09b6600000ULL,
    0xc250ebb900000ULL,
    0x318631880000ULL,
    0x973c273cc0000ULL,
    0x5c66dc6e0000ULL,
    0x1ee92ae970000ULL,
    0x3580778008000ULL,
    0xb640754084000ULL,
    0xe12096a0aa000ULL,
    0x410715037000ULL,
    0x6a38fc9855800ULL,
    0xd72ca67c06400ULL,
    0x25fed96689200ULL,
    0x8ec528b930100ULL,
    0xcdfe949828380ULL,
    0x7ac5927c142c0ULL,
    0xeffe9b66527e0ULL,
    0x9c5ebb9fb850ULL,
    0xf07ee318db5e8ULL,
    0x4885e73ccb95cULL,
    0xa4de0dc6f3666ULL,
    0x3ad59ae9dfb9bULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x5000000000000ULL,
    0xd800000000000ULL,
    0xfc00000000000ULL,
    0xf600000000000ULL,
    0xd500000000000ULL,
    0xbf80000000000ULL,
    0x2c40000000000ULL,
    0xeee0000000000ULL,
    0x970000000000ULL,
    0x1908000000000ULL,
    0x2164000000000ULL,
    0xad6a000000000ULL,
    0xd313000000000ULL,
    0x2282800000000ULL,
    0x9707c00000000ULL,
    0x98e0a00000000ULL,
    0x1c70900000000ULL,
    0x8688f80000000ULL,
    0x5d24ac0000000ULL,
    0x9b8a2e0000000ULL,
    0x2663290000000ULL,
    0xcd8ac98000000ULL,
    0x6363394000000ULL,
    0x8a0af16000000ULL,
    0xe323b53000000ULL,
    0x4aea8fe800000ULL,
    0xc353441400000ULL,
    0x1a623a6200000ULL,
    0x1b774b7700000ULL,
    0xe668be6880000ULL,
    0xed54d154c0000ULL,
    0x3302e50220000ULL,
    0x5247d74750000ULL,
    0x1f80f80058000ULL,
    0xbc40ac003c000ULL,
    0x16e02e00d6000ULL,
    0xa570290085000ULL,
    0x3708498067800ULL,
    0x864f940d0400ULL,
    0xe4ea516018e00ULL,
    0x2a532530dc700ULL,
    0x73e277e8a6880ULL,
    0xb237e8140d240ULL,
    0x6f081462438a0ULL,
    0x34646277da630ULL,
    0x32ea77e8bb8a8ULL,
    0xaf53e8147663cULL,
    0x14621462158aaULL,
    0x627762779f639ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x5000000000000ULL,
    0x5800000000000ULL,
    0xac00000000000ULL,
    0x6a00000000000ULL,
    0x8500000000000ULL,
    0xfb80000000000ULL,
    0xa8c0000000000ULL,
    0x8420000000000ULL,
    0xae30000000000ULL,
    0x4b08000000000ULL,
    0xe074000000000ULL,
    0x1086000000000ULL,
    0x388f000000000ULL,
    0xfc2e800000000ULL,
    0x320b400000000ULL,
    0x2980e00000000ULL,
    0x91c0100000000ULL,
    0x2da0380000000ULL,
    0x7ff0fc0000000ULL,
    0x6a8320000000ULL,
    0xcf84290000000ULL,
    0x4e2e918000000ULL,
    0x5b0b2dc000000ULL,
    0xd800ffa000000ULL,
    0xec0046f000000ULL,
    0xa00af2800000ULL,
    0xd5001e4400000ULL,
    0xa380038e00000ULL,
    0x4c074fb00000ULL,
    0xee2086a880000ULL,
    0x2b308f8440000ULL,
    0xb0882e2e60000ULL,
    0x48b40b0b50000ULL,
    0x94a68000d8000ULL,
    0x96bf4000ec000ULL,
    0xb726e0000a000ULL,
    0xd27f1000d5000ULL,
    0x3906b800a3800ULL,
    0xa94fbc0004c00ULL,
    0xd18ed200ee200ULL,
    0x4dfb39002b300ULL,
    0x2f282980b0880ULL,
    0x5e4491c048b40ULL,
    0x638e2da094a60ULL,
    0x24fb7ff096bf0ULL,
    0xdea886a8b7268ULL,
    0x23848f84d27f4ULL,
    0x442e2e2e3906eULL,
    0x8e0b0b0ba94f1ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x5000000000000ULL,
    0xe800000000000ULL,
    0x4400000000000ULL,
    0x5e00000000000ULL,
    0xad00000000000ULL,
    0xef80000000000ULL,
    0x6840000000000ULL,
    0x8460000000000ULL,
    0xfe50000000000ULL,
    0xfd28000000000ULL,
    0x7f4000000000ULL,
    0x2c62000000000ULL,
    0xda4f000000000ULL,
    0x5306800000000ULL,
    0x12dfc00000000ULL,
    0x6f80200000000ULL,
    0xa840300000000ULL,
    0x2460280000000ULL,
    0xae50140000000ULL,
    0x15283a0000000ULL,
    0x43f4110000000ULL,
    0x7262178000000ULL,
    0x774f2b4000000ULL,
    0xbc86bbe000000ULL,
    0x7a9fda1000000ULL,
    0xebe0011800000ULL,
    0x56100f9400000ULL,
    0xd948174a00000ULL,
    0xa9a415fd00000ULL,
    0x394a311880000ULL,
    0x99bb2793c0000ULL,
    0x21648341a0000ULL,
    0x6590eff7f0000ULL,
    0xd306800008000ULL,
    0xd2dfc0000c000ULL,
    0xcf8020000a000ULL,
    0xf840300005000ULL,
    0xcc6028000e800ULL,
    0xea50140004400ULL,
    0x4b283a0005e00ULL,
    0xeef411000ad00ULL,
    0x9de217800ef80ULL,
    0x1f0f2b4006840ULL,
    0x38e6bbe008460ULL,
    0x84cfda100fe50ULL,
    0x16c801180fd28ULL,
    0x51e40f94007f4ULL,
    0xf52a174a02c62ULL,
    0x73eb15fd0da4fULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0xb000000000000ULL,
    0x1800000000000ULL,
    0x400000000000ULL,
    0xda00000000000ULL,
    0x900000000000ULL,
    0x2280000000000ULL,
    0xe840000000000ULL,
    0xbc60000000000ULL,
    0xe30000000000ULL,
    0x7b58000000000ULL,
    0x378c000000000ULL,
    0x14c2000000000ULL,
    0x874d000000000ULL,
    0x99d4800000000ULL,
    0xbfb9400000000ULL,
    0x1880200000000ULL,
    0x9140300000000ULL,
    0xe6e0180000000ULL,
    0x52702c0000000ULL,
    0x538060000000ULL,
    0x34bc010000000ULL,
    0x971a368000000ULL,
    0x5181024000000ULL,
    0x13f688a000000ULL,
    0xde847a1000000ULL,
    0x466c8f1800000ULL,
    0x1745738c00000ULL,
    0x91fa26d600000ULL,
    0x73f111e300000ULL,
    0x6ece9b3080000ULL,
    0x5e384cd340000ULL,
    0x1376b6f520000ULL,
    0x4bc45cae50000ULL,
    0x7a8c800008000ULL,
    0x4c3540000c000ULL,
    0xb642200006000ULL,
    0xaf0d30000b000ULL,
    0x45b4980001800ULL,
    0x1896c0000400ULL,
    0x7bd826000da00ULL,
    0xa2cc310000900ULL,
    0x28222e8002280ULL,
    0xdc3d2e400e840ULL,
    0xbe6c8ea00bc60ULL,
    0x63457b1000e30ULL,
    0x33fa399807b58ULL,
    0xcef131cc0378cULL,
    0x8e4e8e76014c2ULL,
    0xbb785bf30874dULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0x5000000000000ULL,
    0x8800000000000ULL,
    0x9c00000000000ULL,
    0x2e00000000000ULL,
    0x500000000000ULL,
    0xab80000000000ULL,
    0x1c40000000000ULL,
    0x6e20000000000ULL,
    0x2510000000000ULL,
    0xfba8000000000ULL,
    0x9404000000000ULL,
    0xf26e000000000ULL,
    0xb07000000000ULL,
    0xfeaa800000000ULL,
    0x3fd1c00000000ULL,
    0xee20200000000ULL,
    0x6510100000000ULL,
    0xdba8080000000ULL,
    0xc404140000000ULL,
    0x7a6e220000000ULL,
    0x9707270000000ULL,
    0xd0aa8b8000000ULL,
    0x3ad1c14000000ULL,
    0x45a00ae000000ULL,
    0x7950171000000ULL,
    0xb588138800000ULL,
    0xe1141d4400000ULL,
    0x81c61cea00000ULL,
    0x303020100000ULL,
    0x22c4b71b80000ULL,
    0x31d6c381c0000ULL,
    0xbb0ab54aa0000ULL,
    0x4681d8e470000ULL,
    0x5ba8080008000ULL,
    0x8404140004000ULL,
    0x5a6e220002000ULL,
    0xc707270005000ULL,
    0x58aa8b8008800ULL,
    0xa6d1c14009c00ULL,
    0x6ba00ae002e00ULL,
    0x7c50171000500ULL,
    0x1e0813880ab80ULL,
    0xfd541d4401c40ULL,
    0xefe61cea06e20ULL,
    0x2613020102510ULL,
    0xd96cb71b8fba8ULL,
    0xa5d2c381c9404ULL,
    0x4964b54aaf26eULL,
    0x4d86d8e470b07ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x5000000000000ULL,
    0xc800000000000ULL,
    0x3c00000000000ULL,
    0x3e00000000000ULL,
    0x6700000000000ULL,
    0xf980000000000ULL,
    0xcc40000000000ULL,
    0x6660000000000ULL,
    0xb310000000000ULL,
    0xaba8000000000ULL,
    0x5d24000000000ULL,
    0xc4fe000000000ULL,
    0xb8cf000000000ULL,
    0x66bb800000000ULL,
    0x71a8c00000000ULL,
    0x1060200000000ULL,
    0x2810300000000ULL,
    0x4c28080000000ULL,
    0xa664140000000ULL,
    0x931e320000000ULL,
    0xfb9f0f0000000ULL,
    0x95738f8000000ULL,
    0xf89cd9c000000ULL,
    0x86b61e6000000ULL,
    0x1bb031000000ULL,
    0x880d919800000ULL,
    0xdc13f8c400000ULL,
    0x4e6db8ea00000ULL,
    0xff03e84900000ULL,
    0xdc596bf80000ULL,
    0xce27d3f3c0000ULL,
    0x3f3bbdcee0000ULL,
    0x2de8c47a30000ULL,
    0x9e00080008000ULL,
    0xf70014000c000ULL,
    0x1180320002000ULL,
    0xa0400f0005000ULL,
    0x90600f800c800ULL,
    0xe81019c003c00ULL,
    0x6c283e6003e00ULL,
    0xf664331006700ULL,
    0x5b1e19980f980ULL,
    0xc79f2cc40cc40ULL,
    0xab73aaea06660ULL,
    0x9f9cd7490b310ULL,
    0x7f36113f8aba8ULL,
    0xcdfb1e33c5d24ULL,
    0xee6d91aeec4feULL,
    0x6f03c86a3b8cfULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0xb000000000000ULL,
    0x5800000000000ULL,
    0x4400000000000ULL,
    0x7e00000000000ULL,
    0x6900000000000ULL,
    0x5b80000000000ULL,
    0xdc40000000000ULL,
    0x5a20000000000ULL,
    0x8710000000000ULL,
    0xdad8000000000ULL,
    0x9bec000000000ULL,
    0xbc42000000000ULL,
    0xca0f000000000ULL,
    0x6f7c800000000ULL,
    0xc6d9c00000000ULL,
    0xa1a0200000000ULL,
    0xab50100000000ULL,
    0xf8f8080000000ULL,
    0xe8fc2c0000000ULL,
    0x409a160000000ULL,
    0x7ce3110000000ULL,
    0xf6be9f8000000ULL,
    0xb996da4000000ULL,
    0xcf7cb6e000000ULL,
    0x36d9e71000000ULL,
    0xd9a03e8800000ULL,
    0x5f501dc400000ULL,
    0xdef828b600000ULL,
    0xc5fc1bfb00000ULL,
    0x651a269080000ULL,
    0xc9a339c3c0000ULL,
    0xf71e92bf20000ULL,
    0xe2c6dce670000ULL,
    0x4f84880008000ULL,
    0x2a25ec0004000ULL,
    0xbf3a360002000ULL,
    0xeb301000b000ULL,
    0xdc6978005800ULL,
    0xc92af64004400ULL,
    0xabc6a0e007e00ULL,
    0xa42af61006900ULL,
    0xae46a10805b80ULL,
    0xa16ac7840dc40ULL,
    0xf7e69e5605a20ULL,
    0xbe3afceb08710ULL,
    0x91e98188dad8ULL,
    0xcbc6e407c9becULL,
    0x34049a092bc42ULL,
    0x4665d71d7ca0fULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0xb000000000000ULL,
    0x4800000000000ULL,
    0x7400000000000ULL,
    0xc200000000000ULL,
    0xe700000000000ULL,
    0xb580000000000ULL,
    0xba40000000000ULL,
    0x9b20000000000ULL,
    0xa3d0000000000ULL,
    0x2f18000000000ULL,
    0x8184000000000ULL,
    0xd82a000000000ULL,
    0xcc19000000000ULL,
    0x5e07800000000ULL,
    0xe138c00000000ULL,
    0xd898200000000ULL,
    0x9cc4100000000ULL,
    0x568a280000000ULL,
    0x65892c0000000ULL,
    0xa23f920000000ULL,
    0xb76cdd0000000ULL,
    0xedaa108000000ULL,
    0x365929c000000ULL,
    0x6527856000000ULL,
    0xf2e8c29000000ULL,
    0xbf8014c800000ULL,
    0x694025f400000ULL,
    0x4ca0134600000ULL,
    0x4e9035a100000ULL,
    0x49b8096a80000ULL,
    0xec14009640000ULL,
    0xae1201c9e0000ULL,
    0x94d297a30000ULL,
    0x1cb5908008000ULL,
    0x16e5e9c004000ULL,
    0xc595a5600a000ULL,
    0x1235d2900b000ULL,
    0xff0dbcc804800ULL,
    0x99f1c9f407400ULL,
    0xf407a1460c200ULL,
    0x8238f8a10e700ULL,
    0x471831ea8b580ULL,
    0x58405564ba40ULL,
    0xf22a16a9e9b20ULL,
    0xef1936ea3a3d0ULL,
    0x618794c80af18ULL,
    0xc878e5f40c184ULL,
    0x343833460782aULL,
    0x625425a107c19ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0xf000000000000ULL,
    0x9800000000000ULL,
    0xb400000000000ULL,
    0x5200000000000ULL,
    0x700000000000ULL,
    0xbf80000000000ULL,
    0x5a40000000000ULL,
    0x3b20000000000ULL,
    0x91d0000000000ULL,
    0xd338000000000ULL,
    0xfdec000000000ULL,
    0x954a000000000ULL,
    0x58f1000000000ULL,
    0xb5df800000000ULL,
    0x91dc00000000ULL,
    0x86b8200000000ULL,
    0xa4ac100000000ULL,
    0x7bea280000000ULL,
    0xd0613c0000000ULL,
    0x2847a60000000ULL,
    0x8c61ed0000000ULL,
    0x166a348000000ULL,
    0xcd2111c000000ULL,
    0xce787e000000ULL,
    0xb7f1ea9000000ULL,
    0x667208c800000ULL,
    0x151d197400000ULL,
    0x1895884e00000ULL,
    0x15ecc2bb00000ULL,
    0xf9678cb280000ULL,
    0x1eb1fdac40000ULL,
    0x10d23f3fe0000ULL,
    0x298d0bf370000ULL,
    0xd70db48008000ULL,
    0x9790d1c004000ULL,
    0xd635a7e00a000ULL,
    0x2d7cfa900f000ULL,
    0x5cffa0c809800ULL,
    0xdfcde5740b400ULL,
    0x4a000e4e05200ULL,
    0xf3003fbb00700ULL,
    0x4d8010328bf80ULL,
    0xad40106c45a40ULL,
    0x1ca03edfe3b20ULL,
    0x7f901c63791d0ULL,
    0xba1820c805338ULL,
    0x6b3c25740bdecULL,
    0xf9f22e4e0354aULL,
    0xff5d2fbb0a8f1ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x7000000000000ULL,
    0xf800000000000ULL,
    0x4c00000000000ULL,
    0xa600000000000ULL,
    0x8900000000000ULL,
    0x6e80000000000ULL,
    0x1a40000000000ULL,
    0x1760000000000ULL,
    0x4bf0000000000ULL,
    0xa2f8000000000ULL,
    0x7c5c000000000ULL,
    0x7e36000000000ULL,
    0x551b000000000ULL,
    0x4080800000000ULL,
    0x272d400000000ULL,
    0x9398200000000ULL,
    0x7eac300000000ULL,
    0x524e380000000ULL,
    0x43071c0000000ULL,
    0xd1d6be0000000ULL,
    0x75c6530000000ULL,
    0xd7e0898000000ULL,
    0xacdd524000000ULL,
    0xd16003a000000ULL,
    0x72f02a9000000ULL,
    0xd47803d800000ULL,
    0x5a1c1dfc00000ULL,
    0x37563f3e00000ULL,
    0xdbeb2e5700000ULL,
    0x2af8adad80000ULL,
    0xc8317196c0000ULL,
    0x944e2e5820000ULL,
    0x7a072da750000ULL,
    0xa756b18008000ULL,
    0x53864e400c000ULL,
    0x9e80bda00e000ULL,
    0x222d799007000ULL,
    0xbb180a580f800ULL,
    0x9dec0fbc04c00ULL,
    0xd3ae1c9e0a600ULL,
    0x5eb734c708900ULL,
    0xc24e967586e80ULL,
    0xcb6a706ac1a40ULL,
    0x65aeaf6621760ULL,
    0x9fda50f054bf0ULL,
    0xf8b695ad822f8ULL,
    0x4b366d96cbc5cULL,
    0xa598905829e36ULL,
    0x7fc17ea75251bULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0x3000000000000ULL,
    0xb800000000000ULL,
    0x3c00000000000ULL,
    0xde00000000000ULL,
    0xdf00000000000ULL,
    0x2980000000000ULL,
    0x3240000000000ULL,
    0xe920000000000ULL,
    0x6290000000000ULL,
    0x71d8000000000ULL,
    0x5e3c000000000ULL,
    0x9f2e000000000ULL,
    0x9e7000000000ULL,
    0x26b800000000ULL,
    0x5176c00000000ULL,
    0x5ef8200000000ULL,
    0xafac100000000ULL,
    0x8176080000000ULL,
    0xb69b0c0000000ULL,
    0x3be5ae0000000ULL,
    0xeb41cf0000000ULL,
    0x33eb978000000ULL,
    0x2f36e7c000000ULL,
    0xf1d8226000000ULL,
    0x1e3c109000000ULL,
    0xbf2e1c4800000ULL,
    0x39e71ba400000ULL,
    0xba6b85f600000ULL,
    0x6d76ef4f00000ULL,
    0x80f83a2b80000ULL,
    0x70ac2929c0000ULL,
    0xa8f638b2e0000ULL,
    0x84db0c69b0000ULL,
    0xd2c59f8008000ULL,
    0x89d1ebc004000ULL,
    0x42338c6002000ULL,
    0x710adf9003000ULL,
    0x6ef60bc80b800ULL,
    0x17db3c6403c00ULL,
    0xbd4587960de00ULL,
    0x6891efdf0df00ULL,
    0xe493ae6382980ULL,
    0xc2dafe8dc3240ULL,
    0x18e3344ee920ULL,
    0xc6373c26b6290ULL,
    0x9313ba2b8f1d8ULL,
    0x6f9ae929c1e3cULL,
    0xe12e18b2ebf2eULL,
    0xa6e71c69b39e7ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0xd000000000000ULL,
    0xf800000000000ULL,
    0x3c00000000000ULL,
    0x6e00000000000ULL,
    0x1900000000000ULL,
    0x5080000000000ULL,
    0xca40000000000ULL,
    0x7b20000000000ULL,
    0xafd0000000000ULL,
    0x97a8000000000ULL,
    0x4b9c000000000ULL,
    0x55ae000000000ULL,
    0x64ef000000000ULL,
    0xf028800000000ULL,
    0x6852400000000ULL,
    0x6408200000000ULL,
    0x820c100000000ULL,
    0x8f26280000000ULL,
    0x75a3340000000ULL,
    0xf4aebe0000000ULL,
    0xa8614f0000000ULL,
    0x842ebb8000000ULL,
    0xf221564000000ULL,
    0xa70e9c2000000ULL,
    0xb1f1569000000ULL,
    0xa6a6a8c800000ULL,
    0xdf6d40f400000ULL,
    0xcd88886a00000ULL,
    0x68c27fa700000ULL,
    0x16002ccb80000ULL,
    0x650006ebc0000ULL,
    0x9e803b6220000ULL,
    0x3403e3090000ULL,
    0xd3a0138008000ULL,
    0x5990224004000ULL,
    0x828802200a000ULL,
    0xfd4c09900d000ULL,
    0x92863b480f800ULL,
    0xe53322b403c00ULL,
    0xdea6aa4a06e00ULL,
    0xa36d663701900ULL,
    0x388bf8385080ULL,
    0xa1c2505fcca40ULL,
    0xbe800f2827b20ULL,
    0x934007079afd0ULL,
    0x8ba03f83817a8ULL,
    0xb590105fc0b9cULL,
    0x14882f282f5aeULL,
    0xd84c17079b4efULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0xd000000000000ULL,
    0xc800000000000ULL,
    0xbc00000000000ULL,
    0x4e00000000000ULL,
    0x5700000000000ULL,
    0x8080000000000ULL,
    0xa40000000000ULL,
    0xfd20000000000ULL,
    0x8db0000000000ULL,
    0xffa8000000000ULL,
    0xa684000000000ULL,
    0x110e000000000ULL,
    0x4bdf000000000ULL,
    0x74d7800000000ULL,
    0xb872400000000ULL,
    0x8408200000000ULL,
    0x8a74100000000ULL,
    0xbd06180000000ULL,
    0xedab340000000ULL,
    0x2fd1b20000000ULL,
    0x6ed96f0000000ULL,
    0xad59b38000000ULL,
    0x5ed45c000000ULL,
    0x23ff982000000ULL,
    0x38b6669000000ULL,
    0x8e26354800000ULL,
    0x771b286c00000ULL,
    0x30f9866a00000ULL,
    0x121d676100000ULL,
    0x8977a5e380000ULL,
    0x7f827aa7c0000ULL,
    0xe68029dde0000ULL,
    0x71403e2090000ULL,
    0x9ba02b8008000ULL,
    0xbcf031c004000ULL,
    0x4080a2006000ULL,
    0xca7419900d000ULL,
    0xdd061ec80c800ULL,
    0x3dab19ac0bc00ULL,
    0xe7d18c4a04e00ULL,
    0xd2d97ef105700ULL,
    0xe359bb2b88080ULL,
    0x52ed630bc0a40ULL,
    0xa37fa597efd20ULL,
    0x32f640d198db0ULL,
    0x730610ab87fa8ULL,
    0xfaab12cbce684ULL,
    0xcf518fb7e710eULL,
    0xb499494199bdfULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0xb000000000000ULL,
    0xa800000000000ULL,
    0xd400000000000ULL,
    0xfa00000000000ULL,
    0xf900000000000ULL,
    0x9280000000000ULL,
    0x1940000000000ULL,
    0x42a0000000000ULL,
    0x2150000000000ULL,
    0x8ef8000000000ULL,
    0xa704000000000ULL,
    0x5992000000000ULL,
    0x36f9000000000ULL,
    0x2b2e800000000ULL,
    0xffd0400000000ULL,
    0x5192200000000ULL,
    0x12f9100000000ULL,
    0x592e880000000ULL,
    0x62d06c0000000ULL,
    0x91120a0000000ULL,
    0x26b9250000000ULL,
    0x730eb68000000ULL,
    0xa3c0524000000ULL,
    0xcfca2ea000000ULL,
    0xb9ad235000000ULL,
    0xe6c4a62800000ULL,
    0x136d5a1400000ULL,
    0x338e8d1e00000ULL,
    0xd7804a9100000ULL,
    0xc5ea104c80000ULL,
    0xc8bd07aa40000ULL,
    0x101cafd5a0000ULL,
    0x5879496510000ULL,
    0x5c44a62808000ULL,
    0x9e2d5a1404000ULL,
    0xab2e8d1e02000ULL,
    0xbfd04a910b000ULL,
    0x7192104c8a800ULL,
    0xa2f907aa4d400ULL,
    0xf12eafd5afa00ULL,
    0xb6d049651f900ULL,
    0x6b12262801280ULL,
    0xdfb91a1405940ULL,
    0xe18ead1e062a0ULL,
    0xba805a9109150ULL,
    0x8d6a184c826f8ULL,
    0x98fd2baa47304ULL,
    0x683c85d5aa392ULL,
    0xb4697c651cff9ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0xb000000000000ULL,
    0x5800000000000ULL,
    0x1c00000000000ULL,
    0x7200000000000ULL,
    0x4f00000000000ULL,
    0xa180000000000ULL,
    0x7740000000000ULL,
    0x4da0000000000ULL,
    0xbd30000000000ULL,
    0xaef8000000000ULL,
    0x369c000000000ULL,
    0x8ab6000000000ULL,
    0xa885000000000ULL,
    0xfe1800000000ULL,
    0xea0dc00000000ULL,
    0xf336200000000ULL,
    0x83c5100000000ULL,
    0xd041b80000000ULL,
    0xa83dec0000000ULL,
    0xa44e360000000ULL,
    0xde19170000000ULL,
    0x6557a48000000ULL,
    0xf288ffc000000ULL,
    0xa4d79e6000000ULL,
    0x75c8cad000000ULL,
    0x517797e800000ULL,
    0x64f8c08c00000ULL,
    0xd58f8dde00000ULL,
    0x164eb7700000ULL,
    0x8cb9a34580000ULL,
    0x91a1edad40000ULL,
    0x6f7812a660000ULL,
    0xb1dc023470000ULL,
    0x7f1617e808000ULL,
    0xb9b5008c04000ULL,
    0x8b19adde0e000ULL,
    0x8f91fb770b000ULL,
    0xaa001b4585800ULL,
    0x130001ad41c00ULL,
    0x338024a667200ULL,
    0x8840153474f00ULL,
    0xb420336802180ULL,
    0xd6703f4c03740ULL,
    0x915813be0ada0ULL,
    0xc4ac21a700d30ULL,
    0x85ce34ad8f6f8ULL,
    0xe9592d2142a9cULL,
    0xc8f79f786f8b6ULL,
    0xffb8e9437e785ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x5000000000000ULL,
    0x8800000000000ULL,
    0x3400000000000ULL,
    0xa200000000000ULL,
    0x300000000000ULL,
    0x4180000000000ULL,
    0xf740000000000ULL,
    0x3a0000000000ULL,
    0x410000000000ULL,
    0x9a08000000000ULL,
    0x4f14000000000ULL,
    0xfb2000000000ULL,
    0xea55000000000ULL,
    0xd73b800000000ULL,
    0x13a1c00000000ULL,
    0x2c12200000000ULL,
    0xfe45100000000ULL,
    0x6533a80000000ULL,
    0x38b5d40000000ULL,
    0x9a0020000000ULL,
    0x23101d0000000ULL,
    0x5188008000000ULL,
    0xdf5414c000000ULL,
    0x6792326000000ULL,
    0x2e0530d000000ULL,
    0xad13a86800000ULL,
    0xace5c1c400000ULL,
    0xfb8816e200000ULL,
    0xa8543e1500000ULL,
    0x24122b0480000ULL,
    0x8a452f9140000ULL,
    0x6733b14ce0000ULL,
    0x6bb5da2d70000ULL,
    0xc020006808000ULL,
    0xe05015c404000ULL,
    0xf02814e20a000ULL,
    0xd844231505000ULL,
    0xbc1a2b8488800ULL,
    0x96513b5143400ULL,
    0xa101832cea200ULL,
    0x42a0eafd70300ULL,
    0xb6bba8000c180ULL,
    0xf4e1d4000b740ULL,
    0x7b202000a3a0ULL,
    0x9e551d0005410ULL,
    0xd53b808001208ULL,
    0x40a1d4c007b14ULL,
    0xe59212600adb2ULL,
    0x3d0520d00e955ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0xd000000000000ULL,
    0xb800000000000ULL,
    0x1c00000000000ULL,
    0x8200000000000ULL,
    0xfb00000000000ULL,
    0xed80000000000ULL,
    0x8740000000000ULL,
    0xffa0000000000ULL,
    0x2430000000000ULL,
    0xde48000000000ULL,
    0x992c000000000ULL,
    0xc6e6000000000ULL,
    0xd2dd000000000ULL,
    0x6493800000000ULL,
    0x59a7c00000000ULL,
    0x146200000000ULL,
    0xaaed100000000ULL,
    0xd8dbb80000000ULL,
    0xeb8bf40000000ULL,
    0x92200e0000000ULL,
    0xe370170000000ULL,
    0xc1e8188000000ULL,
    0x6d1c0ac000000ULL,
    0xa0ae156000000ULL,
    0x57f126d000000ULL,
    0x20759f6800000ULL,
    0x707af7cc00000ULL,
    0x8855acf200000ULL,
    0x740ad79b00000ULL,
    0x263d965180000ULL,
    0x6556d9bb40000ULL,
    0x94b398b6e0000ULL,
    0x91d7d322f0000ULL,
    0x952e276808000ULL,
    0x5cb103cc04000ULL,
    0x5d5a2f20e000ULL,
    0x634ac09b0d000ULL,
    0x819d8ed18b800ULL,
    0x8d66d37b41c00ULL,
    0x70fb8dd6e8200ULL,
    0xeffbf5f2ffb00ULL,
    0x3c48380006d80ULL,
    0xf22c34000c740ULL,
    0x73662e0001fa0ULL,
    0x999d07000f430ULL,
    0xa133a08006648ULL,
    0x9a97fec00852cULL,
    0xb08e1b60044e6ULL,
    0x4f8131d0029ddULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x1000000000000ULL,
    0x4800000000000ULL,
    0xac00000000000ULL,
    0x600000000000ULL,
    0x9500000000000ULL,
    0x580000000000ULL,
    0xc940000000000ULL,
    0x3be0000000000ULL,
    0x810000000000ULL,
    0xcc68000000000ULL,
    0xb674000000000ULL,
    0xcd5e000000000ULL,
    0xe1a7000000000ULL,
    0x635c800000000ULL,
    0xa8e1c00000000ULL,
    0x98be200000000ULL,
    0xb7300000000ULL,
    0x44b4a80000000ULL,
    0xfed5c40000000ULL,
    0x2580320000000ULL,
    0x19401b0000000ULL,
    0xd3e0298000000ULL,
    0xb410214000000ULL,
    0x8268136000000ULL,
    0x8f74195000000ULL,
    0xcede0f7800000ULL,
    0xbde7274400000ULL,
    0x5d3cb27a00000ULL,
    0x69b1dfcd00000ULL,
    0x6f361daf80000ULL,
    0xbed30a6dc0000ULL,
    0x458283cd20000ULL,
    0xa906c3a570000ULL,
    0x8b82a77808000ULL,
    0x5006e3440c000ULL,
    0x2802807a0a000ULL,
    0x1c46c4cd01000ULL,
    0x5e62b42f84800ULL,
    0x7116eb2dcac00ULL,
    0xafeab0ad20600ULL,
    0x5a72eaf579500ULL,
    0xab5c800008580ULL,
    0xc4e1c00000940ULL,
    0x3ebe200009be0ULL,
    0x85b7300001810ULL,
    0x934a80008468ULL,
    0x9b95c40001a74ULL,
    0x186032000cb5eULL,
    0x84501b00074a7ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0xd000000000000ULL,
    0xf800000000000ULL,
    0x3400000000000ULL,
    0x1a00000000000ULL,
    0xff00000000000ULL,
    0xf380000000000ULL,
    0x9340000000000ULL,
    0x2da0000000000ULL,
    0x3e70000000000ULL,
    0x3d48000000000ULL,
    0x88cc000000000ULL,
    0x52b2000000000ULL,
    0x8d91000000000ULL,
    0xce35800000000ULL,
    0x750cc00000000ULL,
    0x9492200000000ULL,
    0x84a1100000000ULL,
    0x5cdd980000000ULL,
    0xd8b0f40000000ULL,
    0xeae81e0000000ULL,
    0xd9bc1d0000000ULL,
    0x47a1e8000000ULL,
    0x721d0bc000000ULL,
    0x532782e000000ULL,
    0xdede9d000000ULL,
    0x8e6fade800000ULL,
    0x1521e05c00000ULL,
    0x44dd8bb200000ULL,
    0x7cb0e2e300000ULL,
    0x68e819c480000ULL,
    0xc2bc05f840000ULL,
    0x15fa1c5f60000ULL,
    0x2a5d39b030000ULL,
    0x9707b5e808000ULL,
    0x5fddd45c04000ULL,
    0x6d07b5b206000ULL,
    0x30ddefe30d000ULL,
    0x6879f448f800ULL,
    0x479dfa3843400ULL,
    0xc92780bf61a00ULL,
    0xb2edcd603ff00ULL,
    0x1def868007380ULL,
    0x5661ffc00d340ULL,
    0x917d9ce004da0ULL,
    0x76c0f4d00ee70ULL,
    0x4fa033680c548ULL,
    0xb5702b9c0bcccULL,
    0xb4c82952048b2ULL,
    0x348c1b3307291ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x1000000000000ULL,
    0x2800000000000ULL,
    0xfc00000000000ULL,
    0xb200000000000ULL,
    0x5b00000000000ULL,
    0x3f80000000000ULL,
    0x7f40000000000ULL,
    0x89e0000000000ULL,
    0x2270000000000ULL,
    0xb368000000000ULL,
    0xa3a4000000000ULL,
    0xdd36000000000ULL,
    0xfaad000000000ULL,
    0xe1a3800000000ULL,
    0x7e6ec00000000ULL,
    0x7156200000000ULL,
    0xc09d300000000ULL,
    0x36ab980000000ULL,
    0xcbfac40000000ULL,
    0x81682a0000000ULL,
    0x38a40f0000000ULL,
    0x82b6348000000ULL,
    0x95ed12c000000ULL,
    0x404385e000000ULL,
    0xa01ee0d000000ULL,
    0x703e2ef800000ULL,
    0x38392e5c00000ULL,
    0xd41dbb3a00000ULL,
    0x4e17f33900000ULL,
    0xe92bbf3580000ULL,
    0x64baf93740000ULL,
    0x40880032e0000ULL,
    0xf6d415b2b0000ULL,
    0xabde36f808000ULL,
    0x91492a5c0c000ULL,
    0x10f5b13a06000ULL,
    0x7ef3cc3901000ULL,
    0x27fd93b582800ULL,
    0x1b67eff74fc00ULL,
    0x9fc38fd2eb200ULL,
    0xf5eca62b5b00ULL,
    0xb1de34800bf80ULL,
    0xf64912c00bf40ULL,
    0xfd7585e00e9e0ULL,
    0x4ab3e0d003270ULL,
    0xb99daef809b68ULL,
    0xba57ee5c05fa4ULL,
    0x174b9b3a06f36ULL,
    0xd58ac3390a1adULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x3000000000000ULL,
    0x800000000000ULL,
    0x4c00000000000ULL,
    0xf600000000000ULL,
    0x7f00000000000ULL,
    0x7680000000000ULL,
    0x1940000000000ULL,
    0x11a0000000000ULL,
    0x7bf0000000000ULL,
    0x8af8000000000ULL,
    0xa754000000000ULL,
    0x42ae000000000ULL,
    0xcb17000000000ULL,
    0xe4a5800000000ULL,
    0x8c12400000000ULL,
    0xd656200000000ULL,
    0x2f43100000000ULL,
    0x4e8b980000000ULL,
    0x5d454c0000000ULL,
    0xabd3a20000000ULL,
    0xf2e1430000000ULL,
    0x8305858000000ULL,
    0xc8e243c000000ULL,
    0x4a2e27a000000ULL,
    0xa157095000000ULL,
    0x1585a3e800000ULL,
    0xa1a25e3c00000ULL,
    0x338e209e00000ULL,
    0xa6a7334500000ULL,
    0x617dace380000ULL,
    0x35f679a9c0000ULL,
    0xf1a0205f60000ULL,
    0xbf0117d90000ULL,
    0xe2f8266808000ULL,
    0xdb541dfc04000ULL,
    0xbcae073e06000ULL,
    0xf8173a1503000ULL,
    0x64258f0b80800ULL,
    0xea526795c4c00ULL,
    0xb17620c16f600ULL,
    0x4df3323897f00ULL,
    0xd5d3928b8f680ULL,
    0x81e16855c5940ULL,
    0x6385a561671a0ULL,
    0x9ea2786894bf0ULL,
    0x250e34e3802f8ULL,
    0x8fe735a9cab54ULL,
    0x78dd825f6d4aeULL,
    0x206527d98417ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x7000000000000ULL,
    0xb800000000000ULL,
    0x7c00000000000ULL,
    0x4a00000000000ULL,
    0xf300000000000ULL,
    0x9080000000000ULL,
    0x8140000000000ULL,
    0x5fa0000000000ULL,
    0xfb90000000000ULL,
    0x5dd8000000000ULL,
    0x8cec000000000ULL,
    0x5b36000000000ULL,
    0xc4b1000000000ULL,
    0xdf33800000000ULL,
    0x5297400000000ULL,
    0x166e200000000ULL,
    0x891d100000000ULL,
    0x7ba5a80000000ULL,
    0x1db65c0000000ULL,
    0x2c858e0000000ULL,
    0x2b664f0000000ULL,
    0x7cfd9a8000000ULL,
    0xa31a70c000000ULL,
    0x1893822000000ULL,
    0xe507735000000ULL,
    0x19b6236800000ULL,
    0xfaf1112400000ULL,
    0x4213a7d600000ULL,
    0xd7477cab00000ULL,
    0x7696398580000ULL,
    0xf0211c5840000ULL,
    0xf86ba9f2e0000ULL,
    0xdc3b49ead0000ULL,
    0x3a7839e808000ULL,
    0x4b7c21e404000ULL,
    0xecee05f60a000ULL,
    0xcb5d1ffb07000ULL,
    0xac85b2ed8b800ULL,
    0x6b66517c47c00ULL,
    0xdcfd8024e4a00ULL,
    0xd31a7a41df300ULL,
    0xa0939aed81080ULL,
    0x99074d7c4c140ULL,
    0x53b62e24effa0ULL,
    0x9f12541d8b90ULL,
    0xd293a86d865d8ULL,
    0x560761bc4b0ecULL,
    0x29362204eb136ULL,
    0xbb11911d47b1ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0xb000000000000ULL,
    0x8800000000000ULL,
    0xd400000000000ULL,
    0xea00000000000ULL,
    0xb700000000000ULL,
    0xf580000000000ULL,
    0xa540000000000ULL,
    0xfea0000000000ULL,
    0x7e90000000000ULL,
    0x3eb8000000000ULL,
    0x9ef4000000000ULL,
    0x2e82000000000ULL,
    0xa6d9000000000ULL,
    0x729d800000000ULL,
    0x98c9c00000000ULL,
    0x2fba200000000ULL,
    0xda6d100000000ULL,
    0x7f3fa80000000ULL,
    0x81c0ec0000000ULL,
    0xff3f820000000ULL,
    0xc1c0e50000000ULL,
    0x5f3fb28000000ULL,
    0x71c0d1c000000ULL,
    0xd73f976000000ULL,
    0xa5c0e05000000ULL,
    0x3d3faf2800000ULL,
    0x12c0fb6400000ULL,
    0xc8bfa24e00000ULL,
    0xb780ea2d00000ULL,
    0x361f99e880000ULL,
    0xc910fb8240000ULL,
    0x8a7814160000ULL,
    0x57e4d3bb70000ULL,
    0x26259da808000ULL,
    0xf13deaa404000ULL,
    0x54b8152e0a000ULL,
    0x69f41a7d0b000ULL,
    0x7b021ec088800ULL,
    0xb3992ce64d400ULL,
    0x43d810f6ea00ULL,
    0x3259cc967b700ULL,
    0xfb021ec087580ULL,
    0xf3992ce64e540ULL,
    0xa43d810f65ea0ULL,
    0x8259cc967ce90ULL,
    0x73021ec0836b8ULL,
    0x27992ce640af4ULL,
    0x4e3d810f66482ULL,
    0x3559cc967a1d9ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0x5000000000000ULL,
    0x800000000000ULL,
    0x3400000000000ULL,
    0x1a00000000000ULL,
    0xd100000000000ULL,
    0xac80000000000ULL,
    0x5740000000000ULL,
    0x43a0000000000ULL,
    0x18d0000000000ULL,
    0xd48000000000ULL,
    0xb2b4000000000ULL,
    0xe462000000000ULL,
    0x5201000000000ULL,
    0xc566800000000ULL,
    0xe6e9400000000ULL,
    0x8e0a200000000ULL,
    0xdb25100000000ULL,
    0x55ec880000000ULL,
    0x9f8c540000000ULL,
    0x6c6a20000000ULL,
    0xbe395d0000000ULL,
    0xa3422e8000000ULL,
    0x3991304000000ULL,
    0xb98ea12000000ULL,
    0xf98d4cd000000ULL,
    0xd9a0346800000ULL,
    0x89d02f7400000ULL,
    0x81c826f200000ULL,
    0xb5f4193d00000ULL,
    0xafc200d080000ULL,
    0x7ed10a6440000ULL,
    0xd22ea463a0000ULL,
    0x855d676350000ULL,
    0xc6e812e808000ULL,
    0xde640b3404000ULL,
    0xd32a05d202000ULL,
    0x61b518ed05000ULL,
    0x8584923880800ULL,
    0xd7a8415043400ULL,
    0x12cc81b1a1a00ULL,
    0xf41c6f8e5d100ULL,
    0x7a2e88d082c80ULL,
    0xa15d5e6441740ULL,
    0xf4e80663a63a0ULL,
    0x6b643a63548d0ULL,
    0x6daa3c6808548ULL,
    0xd3f53b740c6b4ULL,
    0x70a4a4f20de62ULL,
    0x4938543d0d301ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0xf000000000000ULL,
    0x800000000000ULL,
    0xe400000000000ULL,
    0xe600000000000ULL,
    0x700000000000ULL,
    0x1080000000000ULL,
    0x7d40000000000ULL,
    0x5da0000000000ULL,
    0x8f0000000000ULL,
    0x2118000000000ULL,
    0x3794000000000ULL,
    0xfdfa000000000ULL,
    0xd8ef000000000ULL,
    0xb925800000000ULL,
    0x2be1400000000ULL,
    0xf7c2200000000ULL,
    0xddcb100000000ULL,
    0x48e7980000000ULL,
    0x412a7c0000000ULL,
    0xc7a5a20000000ULL,
    0xf5a1690000000ULL,
    0x3ce2018000000ULL,
    0x5f7b2dc000000ULL,
    0x2cdf9e2000000ULL,
    0xe70e5a5000000ULL,
    0xa0e78ce800000ULL,
    0x152a6afc00000ULL,
    0x49a58de600000ULL,
    0xe6a17f7500000ULL,
    0xc262163680000ULL,
    0xc13b3e57c0000ULL,
    0x87ff92e760000ULL,
    0x95be41e150000ULL,
    0xccdf956808000ULL,
    0x570e7b3c04000ULL,
    0xc8e791c606000ULL,
    0x12a5c250f000ULL,
    0xa7a5835e80800ULL,
    0x5a1456bce400ULL,
    0x34e203216e600ULL,
    0xbb7b1dc450700ULL,
    0xcadf963689080ULL,
    0xe00e7e57c3d40ULL,
    0xb067b2e763da0ULL,
    0x686a51e15f8f0ULL,
    0x14058d680a918ULL,
    0xee51473c09394ULL,
    0xe37a13c607bfaULL,
    0xf6af252502fefULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0xb000000000000ULL,
    0x3800000000000ULL,
    0xac00000000000ULL,
    0xa200000000000ULL,
    0xcf00000000000ULL,
    0x5780000000000ULL,
    0x2fc0000000000ULL,
    0x63a0000000000ULL,
    0x51b0000000000ULL,
    0x16e8000000000ULL,
    0xd574000000000ULL,
    0xf4e2000000000ULL,
    0xfa13000000000ULL,
    0x3344800000000ULL,
    0x5dc7400000000ULL,
    0xc4c4a00000000ULL,
    0x207700000000ULL,
    0xbf64a80000000ULL,
    0x4fb75c0000000ULL,
    0x338ca60000000ULL,
    0xf9c3770000000ULL,
    0x32ee8e8000000ULL,
    0xe31044c000000ULL,
    0x358a1b6000000ULL,
    0xc0a70f3000000ULL,
    0x8406a38800000ULL,
    0x46646b5c00000ULL,
    0xd9680e3200000ULL,
    0x26b4020100000ULL,
    0x2d42150a80000ULL,
    0x78a30b85c0000ULL,
    0xe82cb75ba0000ULL,
    0xc473683410000ULL,
    0xa606950a88000ULL,
    0x49644b85cc000ULL,
    0xaee8175ba2000ULL,
    0xb97418341b000ULL,
    0x76e23d0a8b800ULL,
    0x85131785c6c00ULL,
    0x5cc4b15ba8200ULL,
    0xde076f3417f00ULL,
    0x564b38a8ef80ULL,
    0x9cb75345c43c0ULL,
    0xfe0caa3bae1a0ULL,
    0xb503600412eb0ULL,
    0xa4ce90028f968ULL,
    0x52607819c96b4ULL,
    0x17420409a1542ULL,
    0x6ba312051d4a3ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x1000000000000ULL,
    0x7800000000000ULL,
    0x6c00000000000ULL,
    0x7e00000000000ULL,
    0xff00000000000ULL,
    0x1880000000000ULL,
    0xc0c0000000000ULL,
    0x7ca0000000000ULL,
    0x5ab0000000000ULL,
    0xd9b8000000000ULL,
    0xc704000000000ULL,
    0x94f2000000000ULL,
    0x8eed000000000ULL,
    0xebe2800000000ULL,
    0x5676c00000000ULL,
    0xb62a00000000ULL,
    0x3ab6f00000000ULL,
    0x29c2a80000000ULL,
    0x8f06f40000000ULL,
    0x90fab60000000ULL,
    0xe4c2ef0000000ULL,
    0x6a8a98000000ULL,
    0xcf9fd0c000000ULL,
    0x2c722fa000000ULL,
    0x9e2d20f000000ULL,
    0xcf42908800000ULL,
    0x70c6c65c00000ULL,
    0xd4da8ee600000ULL,
    0x6eb2c39d00000ULL,
    0xdbb0bdda80000ULL,
    0x3e2bff2640000ULL,
    0x1f3806a220000ULL,
    0x28c40e7bf0000ULL,
    0xa8d23dda88000ULL,
    0x689d3f264c000ULL,
    0x48faa6a222000ULL,
    0x58c2fe7bf1000ULL,
    0x20a895da8f800ULL,
    0x4c9fcb264ac00ULL,
    0x32f210a225e00ULL,
    0xcded117bfef00ULL,
    0xd562bc5a8e080ULL,
    0x15b6dbe646cc0ULL,
    0x69429f02222a0ULL,
    0x33c6c18bfb5b0ULL,
    0xea5a84d283938ULL,
    0x2d72e9ba4abc4ULL,
    0xb990a7e42b652ULL,
    0x375bed16f3b5dULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x3000000000000ULL,
    0xd800000000000ULL,
    0xf400000000000ULL,
    0xd200000000000ULL,
    0xab00000000000ULL,
    0x9880000000000ULL,
    0x90c0000000000ULL,
    0xeca0000000000ULL,
    0x82f0000000000ULL,
    0xe7e8000000000ULL,
    0x2a04000000000ULL,
    0xaf3e000000000ULL,
    0x32b7000000000ULL,
    0xfff2800000000ULL,
    0x7e46c00000000ULL,
    0x4d72a00000000ULL,
    0x4186f00000000ULL,
    0x9352880000000ULL,
    0x3cb6fc0000000ULL,
    0xa9abe0000000ULL,
    0x5b82c10000000ULL,
    0xe46c8a8000000ULL,
    0xfa01ebc000000ULL,
    0x27682ca000000ULL,
    0x8ec40ff000000ULL,
    0x319e378800000ULL,
    0x2b471f4c00000ULL,
    0x589aa67200000ULL,
    0x3082d9cd00000ULL,
    0xdcec9bbd80000ULL,
    0x5ac1d860c0000ULL,
    0x13c838c120000ULL,
    0xf834213170000ULL,
    0x4761bbd88000ULL,
    0xaa431860cc000ULL,
    0x6f2498c12a000ULL,
    0x92f5d13173000ULL,
    0xcfbe13bd85800ULL,
    0xa6772460c3400ULL,
    0xb95286c127200ULL,
    0x93b6e03179b00ULL,
    0x381a913d8c080ULL,
    0xa442f3a0ca4c0ULL,
    0x9a4cb46129ea0ULL,
    0xb731dec1719f0ULL,
    0x66a0243582768ULL,
    0x1df03b2cc8ec4ULL,
    0xd6820b32319eULL,
    0x21c439fc72b47ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x3000000000000ULL,
    0x800000000000ULL,
    0xc00000000000ULL,
    0x7200000000000ULL,
    0xf900000000000ULL,
    0x4a80000000000ULL,
    0x86c0000000000ULL,
    0x14e0000000000ULL,
    0x7db0000000000ULL,
    0xf28000000000ULL,
    0x8dec000000000ULL,
    0xe70a000000000ULL,
    0x1183000000000ULL,
    0xad57800000000ULL,
    0xecdec00000000ULL,
    0x99b7a00000000ULL,
    0xe16ed00000000ULL,
    0x3e9f880000000ULL,
    0x5082dc0000000ULL,
    0xa3958a0000000ULL,
    0xb401df0000000ULL,
    0x3642168000000ULL,
    0x271f214000000ULL,
    0xf195a42000000ULL,
    0x3d01d0f000000ULL,
    0xd4c2291800000ULL,
    0x9ddf139c00000ULL,
    0x9f75a0d200000ULL,
    0xb5b1efe700000ULL,
    0xe36a0f9080000ULL,
    0x6ff30ac7c0000ULL,
    0x261fa0e560000ULL,
    0x5f42f10070000ULL,
    0x55f5879088000ULL,
    0x7371d6c7c4000ULL,
    0x578a2ae56a000ULL,
    0x22432e0073000ULL,
    0x2137911088800ULL,
    0xdeaef787c4c00ULL,
    0xc0ff8ec56d200ULL,
    0x9bf2fef07c900ULL,
    0xb05db8088c280ULL,
    0x485de41bccac0ULL,
    0xac602e176c6e0ULL,
    0x427011177b4b0ULL,
    0xf14837980cda8ULL,
    0x469c2edc0472cULL,
    0xf4c22ef2021eaULL,
    0xeddf30170a533ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x5000000000000ULL,
    0x2800000000000ULL,
    0xe400000000000ULL,
    0x1e00000000000ULL,
    0xd00000000000ULL,
    0x4f80000000000ULL,
    0x3c0000000000ULL,
    0xb9e0000000000ULL,
    0xcad0000000000ULL,
    0xd878000000000ULL,
    0xbc2c000000000ULL,
    0xe27e000000000ULL,
    0x8f41000000000ULL,
    0x90ef800000000ULL,
    0xbb1c400000000ULL,
    0xe68fa00000000ULL,
    0x320c500000000ULL,
    0xe717b80000000ULL,
    0x14f0440000000ULL,
    0xf511b20000000ULL,
    0xc39d7d0000000ULL,
    0x9980358000000ULL,
    0xfac03e4000000ULL,
    0xa060066000000ULL,
    0x70102eb000000ULL,
    0x1818301800000ULL,
    0x9c3c080400000ULL,
    0xd2660c0600000ULL,
    0xf77d1e0f00000ULL,
    0x5c89b31980000ULL,
    0x41617e9f40000ULL,
    0xf58624c260000ULL,
    0x70ad00a850000ULL,
    0xab718b1988000ULL,
    0xae8d7a9f44000ULL,
    0x861836c266000ULL,
    0xd13c2da855000ULL,
    0xfde606998a800ULL,
    0xa4bd00df4a400ULL,
    0xcd6982a267e00ULL,
    0x6fb17e1855d00ULL,
    0x33fe03018e780ULL,
    0xc181369b4a7c0ULL,
    0x68f88c46c7e0ULL,
    0x220c4ea7597d0ULL,
    0xaf17800003ff8ULL,
    0xa0f0400001becULL,
    0xc311a0000259eULL,
    0x2a9d500001891ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0xb000000000000ULL,
    0x3800000000000ULL,
    0x2c00000000000ULL,
    0xd200000000000ULL,
    0x8d00000000000ULL,
    0x7080000000000ULL,
    0x14c0000000000ULL,
    0xb2e0000000000ULL,
    0x51f0000000000ULL,
    0xf628000000000ULL,
    0xb74000000000ULL,
    0x23c2000000000ULL,
    0x8b7b000000000ULL,
    0x6385800000000ULL,
    0xab51c00000000ULL,
    0xd3e5a00000000ULL,
    0x9361d00000000ULL,
    0xffada80000000ULL,
    0x4125fc0000000ULL,
    0x72a7a60000000ULL,
    0x31daf70000000ULL,
    0x6648128000000ULL,
    0x8344144000000ULL,
    0x378a2ea000000ULL,
    0x753f017000000ULL,
    0x3c8f8a1800000ULL,
    0x56aef90c00000ULL,
    0xb78a199200000ULL,
    0x353f20d100000ULL,
    0x1c8f8de280000ULL,
    0xe6aedd4fc0000ULL,
    0x8f8a2f23e0000ULL,
    0x193f05abb0000ULL,
    0xce8fa5e288000ULL,
    0x6baee14fc4000ULL,
    0xff0a2923e2000ULL,
    0xdff22abbb000ULL,
    0x7c6f9f628b800ULL,
    0x3a5ec90fc6c00ULL,
    0x9220183ef200ULL,
    0x68b04dbb3d00ULL,
    0x5fadaffa8c880ULL,
    0xb125d843c78c0ULL,
    0x6aa790b1e40e0ULL,
    0xaddad27ab6cf0ULL,
    0x8c483a8003ea8ULL,
    0x22442840073b4ULL,
    0x950a28a006322ULL,
    0xecff26700e78bULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x5000000000000ULL,
    0xd800000000000ULL,
    0xec00000000000ULL,
    0xf200000000000ULL,
    0x6500000000000ULL,
    0x8780000000000ULL,
    0x5c0000000000ULL,
    0x48a0000000000ULL,
    0xcb10000000000ULL,
    0x58f8000000000ULL,
    0xb334000000000ULL,
    0x84d2000000000ULL,
    0xc913000000000ULL,
    0xd5f5800000000ULL,
    0x5094400000000ULL,
    0x470da00000000ULL,
    0xfaa0700000000ULL,
    0xe5fb80000000ULL,
    0xef73640000000ULL,
    0x3e8a0e0000000ULL,
    0xf8371f0000000ULL,
    0x1c5f928000000ULL,
    0x1a73764000000ULL,
    0x10a0b6000000ULL,
    0x41f7133000000ULL,
    0x7eff974800000ULL,
    0x58637ef400000ULL,
    0x2c7233f600000ULL,
    0x9203147900000ULL,
    0x350d81a280000ULL,
    0x5fa0610dc0000ULL,
    0xe9dfb597e0000ULL,
    0xbab340dcd0000ULL,
    0xae2a132288000ULL,
    0xdf27174dcc000ULL,
    0xb6a7bef7e6000ULL,
    0xcc4753ecd5000ULL,
    0x258046a85800ULL,
    0x8d2429b9c2c00ULL,
    0xe3aa2d01e9200ULL,
    0xc3e73795d3500ULL,
    0x3387bdc80df80ULL,
    0xdb976cb4029c0ULL,
    0xbf8036960daa0ULL,
    0x79c018490fe10ULL,
    0x2a0046a80778ULL,
    0x121029b9c5af4ULL,
    0xf5782d01e3e72ULL,
    0x3ff43795d6703ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x9000000000000ULL,
    0x5800000000000ULL,
    0xc400000000000ULL,
    0x6600000000000ULL,
    0x3b00000000000ULL,
    0x3980000000000ULL,
    0xd7c0000000000ULL,
    0x10a0000000000ULL,
    0xbb70000000000ULL,
    0xf9f8000000000ULL,
    0x77f4000000000ULL,
    0x80a6000000000ULL,
    0xe30d000000000ULL,
    0x3db4800000000ULL,
    0x11c6400000000ULL,
    0xbbcca00000000ULL,
    0xdaf2700000000ULL,
    0xea4a880000000ULL,
    0x14f540000000ULL,
    0xa61e0000000ULL,
    0x230d250000000ULL,
    0x9db4a78000000ULL,
    0x81c65bc000000ULL,
    0xe3cca1e000000ULL,
    0x1ef27a3000000ULL,
    0x8c4a9bc800000ULL,
    0x3a4f41ec00000ULL,
    0x39262a3600000ULL,
    0xf4cd23d100000ULL,
    0x8d14bdff80000ULL,
    0x3ab6502240000ULL,
    0x1a34b0daa0000ULL,
    0x69065b7fd0000ULL,
    0xcec9a7f88000ULL,
    0xd9424be24c000ULL,
    0x492b13aaa000ULL,
    0xe50b514fd9000ULL,
    0x36d809b78d800ULL,
    0xe0441e0e40400ULL,
    0xf07e250cac600ULL,
    0x6849279edab00ULL,
    0xc4a9bc80e180ULL,
    0xfa4f41ec0d3c0ULL,
    0x99262a360d6a0ULL,
    0x64cd23d101070ULL,
    0xd514bdff89878ULL,
    0xfeb6502246434ULL,
    0x7c34b0daaf606ULL,
    0x52065b7fd637dULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x1000000000000ULL,
    0xb800000000000ULL,
    0xb400000000000ULL,
    0xfa00000000000ULL,
    0x4700000000000ULL,
    0xd180000000000ULL,
    0x1fc0000000000ULL,
    0xe2e0000000000ULL,
    0x9410000000000ULL,
    0x4a58000000000ULL,
    0xf24000000000ULL,
    0xcd8e000000000ULL,
    0xe9bb000000000ULL,
    0xebe4800000000ULL,
    0xf8a6400000000ULL,
    0xc35ca00000000ULL,
    0x2392500000000ULL,
    0xa48a980000000ULL,
    0xd50d540000000ULL,
    0x3ae0360000000ULL,
    0x7010390000000ULL,
    0xe858288000000ULL,
    0xec2438c000000ULL,
    0x5e0e24e000000ULL,
    0x57b3b3000000ULL,
    0x2284b25800000ULL,
    0x3476733400000ULL,
    0xba64be4e00000ULL,
    0xa766713d00000ULL,
    0xc1bc814d80000ULL,
    0xa78248a3c0000ULL,
    0x56d2ad0ca0000ULL,
    0x6e297e8e50000ULL,
    0xd6e31cd88000ULL,
    0xdeab2463c4000ULL,
    0xd23cbfecae000ULL,
    0xb427cbe51000ULL,
    0x7fb2ab1583800ULL,
    0xb2f96f97cf400ULL,
    0xcc562542a1a00ULL,
    0xee5f36b355700ULL,
    0x4d0a98000e980ULL,
    0x3ecd54000ebc0ULL,
    0xc20036000f8e0ULL,
    0xb30039000c310ULL,
    0xcb802880023d8ULL,
    0x48c038c00a4e4ULL,
    0x8b6024e00d56eULL,
    0x3fd03b3003aabULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x5000000000000ULL,
    0xb800000000000ULL,
    0x1400000000000ULL,
    0xd200000000000ULL,
    0x6d00000000000ULL,
    0x2580000000000ULL,
    0x73c0000000000ULL,
    0x54e0000000000ULL,
    0x3850000000000ULL,
    0x5438000000000ULL,
    0xb244000000000ULL,
    0x3d7e000000000ULL,
    0x9dbf000000000ULL,
    0x6795800000000ULL,
    0x86ad400000000ULL,
    0x554da00000000ULL,
    0x71b9500000000ULL,
    0xc18bb80000000ULL,
    0x6982440000000ULL,
    0xa580160000000ULL,
    0x33c0010000000ULL,
    0x34e0028000000ULL,
    0x68500a4000000ULL,
    0xec3813e000000ULL,
    0xa64402b000000ULL,
    0xef7e28d800000ULL,
    0xf0bf09a400000ULL,
    0x4215895600000ULL,
    0xf56d7e7500000ULL,
    0x1adaf6980000ULL,
    0x49e955eac0000ULL,
    0x95b3bbb4e0000ULL,
    0xdbc66e5590000ULL,
    0x98fe15e988000ULL,
    0xae7f1baac4000ULL,
    0x5375be54e6000ULL,
    0xeefd6de595000ULL,
    0xb975bfb183800ULL,
    0xd7fd584ec5400ULL,
    0x2ef584e2eb200ULL,
    0x993d412093d00ULL,
    0xe795800001d80ULL,
    0xc6ad4000027c0ULL,
    0x354da0000e6e0ULL,
    0x21b9500000550ULL,
    0x798bb8000c9b8ULL,
    0x7d8244000d584ULL,
    0x778016000bb9eULL,
    0x5ec001000c8efULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0xf000000000000ULL,
    0x3800000000000ULL,
    0x2c00000000000ULL,
    0x8600000000000ULL,
    0x7900000000000ULL,
    0xe280000000000ULL,
    0xd8c0000000000ULL,
    0xafe0000000000ULL,
    0xc010000000000ULL,
    0xa028000000000ULL,
    0x1014000000000ULL,
    0xc872000000000ULL,
    0x1449000000000ULL,
    0xaa69800000000ULL,
    0xff0ec00000000ULL,
    0x9ba1a00000000ULL,
    0x3a0ad00000000ULL,
    0x777b980000000ULL,
    0x6f97ec0000000ULL,
    0x6000160000000ULL,
    0xb000270000000ULL,
    0xd800178000000ULL,
    0xdc00294000000ULL,
    0xbe00172000000ULL,
    0x5500237000000ULL,
    0x648032d800000ULL,
    0xa1c0187400000ULL,
    0x4d603b5200000ULL,
    0x18d0023100000ULL,
    0xfc831ee80000ULL,
    0xd004311340000ULL,
    0x685a308ce0000ULL,
    0x45d3ed4f0000ULL,
    0x621bbe6e88000ULL,
    0xeb47f45344000ULL,
    0x31c831acee000ULL,
    0xc5043aa4ff000ULL,
    0xecda1b368b800ULL,
    0x559d056746c00ULL,
    0x177bbddee6600ULL,
    0xdf97cbe5f8900ULL,
    0xb800000005a80ULL,
    0x6c0000000b4c0ULL,
    0x660000000c9e0ULL,
    0x8900000004910ULL,
    0xda80000007aa8ULL,
    0xf4c000000e4d4ULL,
    0x29e000000e192ULL,
    0xb91000000ad59ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x3000000000000ULL,
    0x4800000000000ULL,
    0x3400000000000ULL,
    0x3e00000000000ULL,
    0x1b00000000000ULL,
    0xe080000000000ULL,
    0xe2c0000000000ULL,
    0xd3a0000000000ULL,
    0xc650000000000ULL,
    0xa708000000000ULL,
    0xacc000000000ULL,
    0xf7e6000000000ULL,
    0x6001000000000ULL,
    0xf018800000000ULL,
    0xa80ac00000000ULL,
    0x430a00000000ULL,
    0x7656f00000000ULL,
    0x2f7e980000000ULL,
    0xdecbfc0000000ULL,
    0xf9880a0000000ULL,
    0x330c310000000ULL,
    0x24c6258000000ULL,
    0x749107c000000ULL,
    0xccb0a5a000000ULL,
    0x5096f37000000ULL,
    0x6adea34800000ULL,
    0x79bffe400000ULL,
    0xc8003d0a00000ULL,
    0xf400379700000ULL,
    0xde000ad380000ULL,
    0x2b002a2740000ULL,
    0xa88035bda0000ULL,
    0xd6c03b71f0000ULL,
    0xeda0375388000ULL,
    0xdd5011e74c000ULL,
    0x47883a1dae000ULL,
    0xe80c0901f3000ULL,
    0x2446299b8c800ULL,
    0xa65115c34f400ULL,
    0x5710a8b7ade00ULL,
    0xa2c6fce6f2b00ULL,
    0xf3d6a58002880ULL,
    0x1657c7c0016c0ULL,
    0xdf6605a000da0ULL,
    0x76c103700ed50ULL,
    0xfdb8bb4800f88ULL,
    0x455ac3e40dc0cULL,
    0xbb8970a01a46ULL,
    0xaa5af6970bd51ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0xf000000000000ULL,
    0x9800000000000ULL,
    0x9c00000000000ULL,
    0x4e00000000000ULL,
    0x5900000000000ULL,
    0x780000000000ULL,
    0xddc0000000000ULL,
    0xdea0000000000ULL,
    0x1a30000000000ULL,
    0x2308000000000ULL,
    0x34a4000000000ULL,
    0xa13a000000000ULL,
    0x8bc5000000000ULL,
    0xdb95800000000ULL,
    0x73d0400000000ULL,
    0x57bda00000000ULL,
    0x7584700000000ULL,
    0xfaafa80000000ULL,
    0x38154c0000000ULL,
    0xac280e0000000ULL,
    0xf6542b0000000ULL,
    0x35123d8000000ULL,
    0xd1910d4000000ULL,
    0x1887b46000000ULL,
    0x9741463000000ULL,
    0x9eba05c800000ULL,
    0xfa0517bc00000ULL,
    0xf335b68a00000ULL,
    0x5ce040d500000ULL,
    0xa535912480000ULL,
    0x59e07e5440000ULL,
    0xccb5ade9e0000ULL,
    0x2d20696c50000ULL,
    0x8d9584a488000ULL,
    0x76d07f144c000ULL,
    0x3e3db789e2000ULL,
    0x144745c5f000ULL,
    0xbb8f94ec81800ULL,
    0x63e569e845c00ULL,
    0x1f801b63e6e00ULL,
    0x81c029b95a900ULL,
    0xb0a0158001f80ULL,
    0xb3300140081c0ULL,
    0xbc881a600b0a0ULL,
    0x75641d300b330ULL,
    0x319a10480bc88ULL,
    0xc8f516fc07564ULL,
    0xff1dacea0319aULL,
    0x9ab45de50c8f5ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0x1000000000000ULL,
    0x800000000000ULL,
    0x8400000000000ULL,
    0x9200000000000ULL,
    0x9100000000000ULL,
    0xbd80000000000ULL,
    0x8cc0000000000ULL,
    0x6160000000000ULL,
    0xc5b0000000000ULL,
    0x30d8000000000ULL,
    0x6f6c000000000ULL,
    0x4af6000000000ULL,
    0xa53000000000ULL,
    0x5d2d800000000ULL,
    0x8bc0400000000ULL,
    0x9fdba00000000ULL,
    0x4593500000000ULL,
    0x70f6280000000ULL,
    0x4f53140000000ULL,
    0x5aad8a0000000ULL,
    0x200650000000ULL,
    0xd93b868000000ULL,
    0x19e3554000000ULL,
    0xece23e000000ULL,
    0xf84f137000000ULL,
    0xfc63bd3800000ULL,
    0x2e4f775c00000ULL,
    0x9f5812ee00000ULL,
    0x32ac3ff700000ULL,
    0xb6161d6b80000ULL,
    0x53231a3fc0000ULL,
    0x495b0cee0000ULL,
    0xa51c5338d0000ULL,
    0x77f5a05388000ULL,
    0xb1ac6d63c4000ULL,
    0xdaada220e2000ULL,
    0x42006ccfd1000ULL,
    0xf93bbd3808800ULL,
    0x9e3775c0c400ULL,
    0x6ce12ee0b200ULL,
    0x7c4f3ff708100ULL,
    0x6e639d6b8b580ULL,
    0xbf4f5a3fc08c0ULL,
    0x22d810ceef360ULL,
    0xbe6c0338d54b0ULL,
    0xd776085380d58ULL,
    0x96933963ca3acULL,
    0x344d8820e0b96ULL,
    0xca7059cfddfe3ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0xf000000000000ULL,
    0x7800000000000ULL,
    0xac00000000000ULL,
    0x3a00000000000ULL,
    0xd00000000000ULL,
    0xf180000000000ULL,
    0x6cc0000000000ULL,
    0xf520000000000ULL,
    0x9df0000000000ULL,
    0x76a8000000000ULL,
    0x864000000000ULL,
    0x141a000000000ULL,
    0xb623000000000ULL,
    0xc75f800000000ULL,
    0x8494400000000ULL,
    0x3145a00000000ULL,
    0xa3b7700000000ULL,
    0x659a280000000ULL,
    0x1ae30c0000000ULL,
    0x127f960000000ULL,
    0xe964570000000ULL,
    0x3fedb08000000ULL,
    0x7d3584000000ULL,
    0x4b801ae000000ULL,
    0xa1c0147000000ULL,
    0x24a0172800000ULL,
    0x1302b4c00000ULL,
    0xfb88306200000ULL,
    0x39940d2500000ULL,
    0x58b22a4c80000ULL,
    0xb34737e1c0000ULL,
    0x22c5b5f960000ULL,
    0x5e7770e1d0000ULL,
    0x33a3d6488000ULL,
    0xbad31cadcc000ULL,
    0x2277859b62000ULL,
    0xb1307dc4df000ULL,
    0x63ff97280f800ULL,
    0x45a46b4c06c00ULL,
    0xeacd906201a00ULL,
    0x6a237d250fd00ULL,
    0x4528024c88980ULL,
    0x5a43be1cc0c0ULL,
    0xaba23f96cf20ULL,
    0xba1327e1d90f0ULL,
    0xcd578de480728ULL,
    0xd1c044edca4a4ULL,
    0x9cd79f7b6c13aULL,
    0x8d0069b4ddbd3ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x3000000000000ULL,
    0x9800000000000ULL,
    0x6c00000000000ULL,
    0xaa00000000000ULL,
    0x8300000000000ULL,
    0xd780000000000ULL,
    0xc0c0000000000ULL,
    0xa160000000000ULL,
    0x30d0000000000ULL,
    0x9928000000000ULL,
    0x8cf4000000000ULL,
    0x9b4a000000000ULL,
    0xfbdb000000000ULL,
    0x8ae8800000000ULL,
    0x1264400000000ULL,
    0x7f42a00000000ULL,
    0x35af500000000ULL,
    0x87e2180000000ULL,
    0x28ef1c0000000ULL,
    0xb5429e0000000ULL,
    0xc6af570000000ULL,
    0x28622c8000000ULL,
    0xb42f2bc000000ULL,
    0x2622a76000000ULL,
    0x197f5cf000000ULL,
    0xccca1bb800000ULL,
    0x7b1b370400000ULL,
    0xcb889c9200000ULL,
    0x12b443c900000ULL,
    0x7e6ab37880000ULL,
    0xd55b66fbc0000ULL,
    0xb6a81eb0a0000ULL,
    0x50340a9bd0000ULL,
    0xe82a30c088000ULL,
    0x140b0dffc4000ULL,
    0xf640bc22ae000ULL,
    0xb1504e52d3000ULL,
    0x38e8b73801800ULL,
    0xbd645cc402c00ULL,
    0xe2c29bf204a00ULL,
    0x466f4f390b300ULL,
    0x690230c084f80ULL,
    0xb4ff0dffcacc0ULL,
    0x270abc22a0b60ULL,
    0xf98b4e52db3d0ULL,
    0xfd8037380cea8ULL,
    0x3c01cc400c34ULL,
    0x96e03bf20da2aULL,
    0xc0101f390fb0bULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x3000000000000ULL,
    0x2800000000000ULL,
    0x8c00000000000ULL,
    0x2e00000000000ULL,
    0xc300000000000ULL,
    0xae80000000000ULL,
    0x79c0000000000ULL,
    0x9d20000000000ULL,
    0xe5d0000000000ULL,
    0xb68000000000ULL,
    0xd2ec000000000ULL,
    0x1fa2000000000ULL,
    0xe269000000000ULL,
    0x4d32800000000ULL,
    0x3dd8c00000000ULL,
    0xcf30a00000000ULL,
    0x40a1f00000000ULL,
    0xdaca380000000ULL,
    0x3853c0000000ULL,
    0xb410920000000ULL,
    0x1a71ef0000000ULL,
    0x1922218000000ULL,
    0xd7a923c000000ULL,
    0x9e12b82000000ULL,
    0x2b08e2b000000ULL,
    0x42d8a6e800000ULL,
    0x678df40400000ULL,
    0x7648161200000ULL,
    0xc73c010f00000ULL,
    0x5cca3c9280000ULL,
    0x8c853d5140000ULL,
    0x5490b26c20000ULL,
    0x90b1dd5870000ULL,
    0x282227a88000ULL,
    0xc7b935554c000ULL,
    0x265a967e26000ULL,
    0xdf34c35773000ULL,
    0xf89287680a800ULL,
    0x2ec8d7c404c00ULL,
    0xb9f8ae3204e00ULL,
    0xfd5de3bf0f300ULL,
    0xd5a01a7a88680ULL,
    0x231009554f5c0ULL,
    0x5ec8047e2b320ULL,
    0x31fc2c57726d0ULL,
    0x216a26e8025e8ULL,
    0xe395340406b2cULL,
    0x4458b6120e282ULL,
    0x524df10f037b9ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x7000000000000ULL,
    0x4800000000000ULL,
    0x6c00000000000ULL,
    0x4e00000000000ULL,
    0x3b00000000000ULL,
    0x9480000000000ULL,
    0xc1c0000000000ULL,
    0xbe20000000000ULL,
    0xb350000000000ULL,
    0x9888000000000ULL,
    0xffdc000000000ULL,
    0xcd32000000000ULL,
    0x4bc1000000000ULL,
    0x1772800000000ULL,
    0x7aabc00000000ULL,
    0xeac8a00000000ULL,
    0x12b6f00000000ULL,
    0x5688380000000ULL,
    0x4dc2c0000000ULL,
    0x39b20a0000000ULL,
    0xfa01070000000ULL,
    0xe152818000000ULL,
    0xa5fbd5c000000ULL,
    0x3c4096a000000ULL,
    0xd66aceb000000ULL,
    0xf3a32a800000ULL,
    0x8edd30a400000ULL,
    0x90e083aa00000ULL,
    0x33fad42300000ULL,
    0x931234ee80000ULL,
    0x489108c740000ULL,
    0xa7fa983020000ULL,
    0x9977eeeab0000ULL,
    0x21fa87c688000ULL,
    0xe77eda34c000ULL,
    0x9b7a8d3a26000ULL,
    0x84b7f479b7000ULL,
    0xf9da81800c800ULL,
    0x9a27d5c00ac00ULL,
    0x917296a002e00ULL,
    0xedabceb004b00ULL,
    0x5048b2a80dc80ULL,
    0x9876f0a40adc0ULL,
    0x342823aa0f020ULL,
    0x1a4c242308850ULL,
    0x511a0cee80c08ULL,
    0x8d8d24c743e1cULL,
    0x2068923027312ULL,
    0xd026e9eabf891ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x9000000000000ULL,
    0x5800000000000ULL,
    0x4400000000000ULL,
    0x1a00000000000ULL,
    0xf100000000000ULL,
    0x4e80000000000ULL,
    0xf5c0000000000ULL,
    0x3260000000000ULL,
    0x3d10000000000ULL,
    0x28f8000000000ULL,
    0xcaa4000000000ULL,
    0xcfee000000000ULL,
    0x337f000000000ULL,
    0xbbad800000000ULL,
    0xc14bc00000000ULL,
    0xa6bba00000000ULL,
    0x1990d00000000ULL,
    0xa478380000000ULL,
    0xca64340000000ULL,
    0xc90e0e0000000ULL,
    0x9aaf350000000ULL,
    0xb7b5908000000ULL,
    0x873fed4000000ULL,
    0x69cdb52000000ULL,
    0x2c5bd13000000ULL,
    0xb643a73800000ULL,
    0x734c63400000ULL,
    0x299628a600000ULL,
    0x4c1b18ed00000ULL,
    0x2623b14580000ULL,
    0x5f24f736c0000ULL,
    0x6dee3e30e0000ULL,
    0x567f3cbd30000ULL,
    0xd72d86fd88000ULL,
    0x118bdc42c4000ULL,
    0x985ba3b6e6000ULL,
    0x6440f56039000ULL,
    0xea6010800d800ULL,
    0x39102d4000400ULL,
    0x52f8152007a00ULL,
    0xaba4013006100ULL,
    0xd96e1f3801680ULL,
    0x82bf32340b1c0ULL,
    0x93cd86a602860ULL,
    0xd5bfded0cc10ULL,
    0xc0c399c586678ULL,
    0x26f4ee76c3f64ULL,
    0x59f62510efd8eULL,
    0xc40b088d30e6fULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0xf000000000000ULL,
    0xc800000000000ULL,
    0xe400000000000ULL,
    0x4200000000000ULL,
    0xbd00000000000ULL,
    0x6a80000000000ULL,
    0x5c0000000000ULL,
    0x2a20000000000ULL,
    0x8910000000000ULL,
    0xf088000000000ULL,
    0x64dc000000000ULL,
    0x2eb6000000000ULL,
    0x9783000000000ULL,
    0x4f57800000000ULL,
    0x3fe7c00000000ULL,
    0x9b69a00000000ULL,
    0x55b8f00000000ULL,
    0x3208180000000ULL,
    0xb51c0c0000000ULL,
    0x6e960a0000000ULL,
    0xb793050000000ULL,
    0x5f5fa28000000ULL,
    0x7fbd64000000ULL,
    0xb77faa2000000ULL,
    0xf3ebde3000000ULL,
    0xcd77882800000ULL,
    0x62f7ef3400000ULL,
    0x1e19caa00000ULL,
    0x9864ce7300000ULL,
    0xfc3e0d0f80000ULL,
    0x7e5f2697c0000ULL,
    0x2361985860000ULL,
    0xb9a4c12930000ULL,
    0x741e27a788000ULL,
    0xba4f1fe3cc000ULL,
    0x7169aed26e000ULL,
    0x3cb8d16a3f000ULL,
    0x3288228004800ULL,
    0x19dc164002400ULL,
    0xa4360a200a200ULL,
    0x62432e3004d00ULL,
    0xad7790280a280ULL,
    0x52f7e3340e1c0ULL,
    0x29e196aa06820ULL,
    0x8c64cb7303410ULL,
    0x763e2f8f89a08ULL,
    0x275f30d7c611cULL,
    0xbe1927860496ULL,
    0x164ef1931e93ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x1000000000000ULL,
    0x4800000000000ULL,
    0xdc00000000000ULL,
    0x9200000000000ULL,
    0x5300000000000ULL,
    0x6c80000000000ULL,
    0x85c0000000000ULL,
    0x3660000000000ULL,
    0xe550000000000ULL,
    0xc9f8000000000ULL,
    0xac6c000000000ULL,
    0x8a6a000000000ULL,
    0x2757000000000ULL,
    0x32e8800000000ULL,
    0xcfbc00000000ULL,
    0xd5faa00000000ULL,
    0x9e00d00000000ULL,
    0x2918180000000ULL,
    0x13fc140000000ULL,
    0x23722a0000000ULL,
    0x74ab330000000ULL,
    0xf19ab68000000ULL,
    0x6850e3c000000ULL,
    0x6c601fa000000ULL,
    0x2a5025b000000ULL,
    0xd7782eb800000ULL,
    0x6aac1c2400000ULL,
    0x988a2de600000ULL,
    0x9bc7254f00000ULL,
    0x5f70b46480000ULL,
    0x16c7f60ec0000ULL,
    0xfae89500a0000ULL,
    0x90fbfb9b30000ULL,
    0xa7faac5c88000ULL,
    0xdd00c9eac4000ULL,
    0xd980746ae000ULL,
    0x4a3c2b6431000ULL,
    0x87122e800c800ULL,
    0xc2fb37c009c00ULL,
    0x54e295a007200ULL,
    0x41fcc6b004300ULL,
    0xd06a003802480ULL,
    0xe8572be4059c0ULL,
    0x2c68b8460a460ULL,
    0xca3be3ff0b650ULL,
    0xc71ab45c8a578ULL,
    0x2290ddeac29acULL,
    0x44802d46abc0aULL,
    0x9c018643c207ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0xd000000000000ULL,
    0x9800000000000ULL,
    0x6c00000000000ULL,
    0x2e00000000000ULL,
    0x7100000000000ULL,
    0x7c80000000000ULL,
    0xebc0000000000ULL,
    0xd220000000000ULL,
    0x6750000000000ULL,
    0xd1d8000000000ULL,
    0xf164000000000ULL,
    0xbc9a000000000ULL,
    0x8bd1000000000ULL,
    0x267800000000ULL,
    0xff1ac00000000ULL,
    0xbda5a00000000ULL,
    0xdf6ff00000000ULL,
    0xcdf8380000000ULL,
    0xf734040000000ULL,
    0xe9c23e0000000ULL,
    0x2d752f0000000ULL,
    0xdaddad8000000ULL,
    0xe9bc74000000ULL,
    0x3c9a34a000000ULL,
    0x4bd116b000000ULL,
    0x6267b3a800000ULL,
    0x2f1ad72400000ULL,
    0x25a586fe00000ULL,
    0xb36fce8d00000ULL,
    0xe3f828d080000ULL,
    0x863406ed40000ULL,
    0x95420e9f60000ULL,
    0xc6b508c2f0000ULL,
    0x8fdb6f888000ULL,
    0x69cbd6894c000ULL,
    0xed421cc166000ULL,
    0xbab520fffd000ULL,
    0xdefd958001800ULL,
    0xa4cbc3400ac00ULL,
    0x27c20aa004e00ULL,
    0x4c7539b00a100ULL,
    0x5e5d9e280e480ULL,
    0x595bd064087c0ULL,
    0x58ba125e0fc20ULL,
    0x3181283d01650ULL,
    0xe13fa3788ad58ULL,
    0x44bed5c941aa4ULL,
    0x379fb66166ebaULL,
    0xb42ee94ffec81ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x3000000000000ULL,
    0xb800000000000ULL,
    0xac00000000000ULL,
    0x600000000000ULL,
    0xfd00000000000ULL,
    0xef80000000000ULL,
    0xf8c0000000000ULL,
    0x8c20000000000ULL,
    0xf630000000000ULL,
    0xe548000000000ULL,
    0x73c4000000000ULL,
    0x46ca000000000ULL,
    0xdd75000000000ULL,
    0x1fcd800000000ULL,
    0xe081400000000ULL,
    0x106fa00000000ULL,
    0x4800700000000ULL,
    0xb420080000000ULL,
    0x9a303c0000000ULL,
    0x4348060000000ULL,
    0xbec4270000000ULL,
    0x114a2f8000000ULL,
    0x89b5144000000ULL,
    0x95edba6000000ULL,
    0xebb1417000000ULL,
    0x1aa7b8e800000ULL,
    0xc30473bc00000ULL,
    0x7eca125a00000ULL,
    0xb1751d7d00000ULL,
    0xb9cdaee080000ULL,
    0x2d814cac40000ULL,
    0x47ef99c1e0000ULL,
    0x1cc06b3d10000ULL,
    0x3e00318888000ULL,
    0x910017504c000ULL,
    0x498037fbea000ULL,
    0x35c0103013000ULL,
    0xdba0080003800ULL,
    0xa2f03c0006c00ULL,
    0x6f6806000a600ULL,
    0x78f427000cd00ULL,
    0x4c022f8005780ULL,
    0x56711440054c0ULL,
    0xd527ba6008a20ULL,
    0xcbc4417000b30ULL,
    0xeaea38e800ac8ULL,
    0xdb4533bc08b04ULL,
    0xe285b25a0caeaULL,
    0xf456d7d02b45ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x5000000000000ULL,
    0x5800000000000ULL,
    0x1400000000000ULL,
    0x5a00000000000ULL,
    0x7500000000000ULL,
    0x6c80000000000ULL,
    0x87c0000000000ULL,
    0xdc60000000000ULL,
    0xf670000000000ULL,
    0xcb78000000000ULL,
    0x4b84000000000ULL,
    0xd266000000000ULL,
    0x7907000000000ULL,
    0x82c7800000000ULL,
    0xf8e4c00000000ULL,
    0x9db9a00000000ULL,
    0x917d00000000ULL,
    0xcae0080000000ULL,
    0x14b0040000000ULL,
    0x83983e0000000ULL,
    0x7e34110000000ULL,
    0xc77e008000000ULL,
    0xa5f3184000000ULL,
    0xad598da000000ULL,
    0x38a7fcb000000ULL,
    0x7df80c3800000ULL,
    0xf9440c6c00000ULL,
    0xc2862dc600000ULL,
    0x58b73b7d00000ULL,
    0xcddf904780000ULL,
    0x5110c9a0c0000ULL,
    0xdea7a2a860000ULL,
    0x4e94ed38f0000ULL,
    0xf6c194ff88000ULL,
    0x1293d98cc4000ULL,
    0x40863cce6a000ULL,
    0x79b73bf5f5000ULL,
    0x5b5f88000d800ULL,
    0xf3d0c40005400ULL,
    0x36479e000fa00ULL,
    0x2b24c10002500ULL,
    0xbbd9888003480ULL,
    0xda67dc40093c0ULL,
    0x351813a008660ULL,
    0xccf43db008370ULL,
    0xd79e04b80a7f8ULL,
    0x8443102c0cc44ULL,
    0xe2419e6600e06ULL,
    0x9153d6cd08f77ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x7000000000000ULL,
    0xe800000000000ULL,
    0x9400000000000ULL,
    0x4200000000000ULL,
    0x7b00000000000ULL,
    0x4980000000000ULL,
    0x3cc0000000000ULL,
    0x9020000000000ULL,
    0x5850000000000ULL,
    0x1c08000000000ULL,
    0xa64c000000000ULL,
    0xd13e000000000ULL,
    0xa6eb000000000ULL,
    0x375c800000000ULL,
    0xd7f9400000000ULL,
    0x81caa00000000ULL,
    0x78ce700000000ULL,
    0x2a00380000000ULL,
    0x2f002c0000000ULL,
    0x6b80220000000ULL,
    0x37c0390000000ULL,
    0x31a02a8000000ULL,
    0xf0903bc000000ULL,
    0xce2802e000000ULL,
    0x851c11f000000ULL,
    0x84b6366800000ULL,
    0x3c67192400000ULL,
    0x7642a30a00000ULL,
    0x29427f8700000ULL,
    0xaa9e134d80000ULL,
    0x97b3029c0000ULL,
    0x7af4a198a0000ULL,
    0xf125404490000ULL,
    0x76dcb7a588000ULL,
    0xcf397ecdcc000ULL,
    0xdbea8272a6000ULL,
    0xbf9e673397000ULL,
    0xd588000006800ULL,
    0x5a8c000005400ULL,
    0x211e000002200ULL,
    0x8ebb000000b00ULL,
    0xc35480000a180ULL,
    0xe5b540000a8c0ULL,
    0x12f4a0000d220ULL,
    0xa525700002350ULL,
    0x54dcb80005588ULL,
    0xc4396c0009a8cULL,
    0x7a6a82000411eULL,
    0x175e49000febbULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0xf000000000000ULL,
    0x2800000000000ULL,
    0x1400000000000ULL,
    0x4a00000000000ULL,
    0xe300000000000ULL,
    0x6f80000000000ULL,
    0x72c0000000000ULL,
    0x7020000000000ULL,
    0xe830000000000ULL,
    0x3408000000000ULL,
    0xba3c000000000ULL,
    0xcb0a000000000ULL,
    0x7b85000000000ULL,
    0x38d2800000000ULL,
    0x9318c00000000ULL,
    0x87abe00000000ULL,
    0x46d4b00000000ULL,
    0xca00080000000ULL,
    0x23000c0000000ULL,
    0x4f80020000000ULL,
    0x82c00f0000000ULL,
    0x5820028000000ULL,
    0xfc30014000000ULL,
    0x7e0804a000000ULL,
    0x593c0e3000000ULL,
    0xa48a06f800000ULL,
    0x945072c00000ULL,
    0x48f2870200000ULL,
    0x7b28ce8300000ULL,
    0xb3a3e34080000ULL,
    0xfce8bba3c0000ULL,
    0x10a04b0a0000ULL,
    0x58850bb850000ULL,
    0x7752818d28000ULL,
    0x11d8c6318c000ULL,
    0xdf8beafabe000ULL,
    0xbae4b52d4b000ULL,
    0xb408000000800ULL,
    0x7a3c000000c00ULL,
    0xeb0a000000200ULL,
    0x8b85000000f00ULL,
    0x10d2800000280ULL,
    0x8718c00000140ULL,
    0xcdabe000004a0ULL,
    0xa5d4b00000e30ULL,
    0xa5800800006f8ULL,
    0x51c00c000072cULL,
    0x3fa0020000702ULL,
    0x6af00f0000e83ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x5000000000000ULL,
    0x2800000000000ULL,
    0x9c00000000000ULL,
    0x7e00000000000ULL,
    0xff00000000000ULL,
    0x4380000000000ULL,
    0x79c0000000000ULL,
    0xb820000000000ULL,
    0x1410000000000ULL,
    0x5238000000000ULL,
    0xf914000000000ULL,
    0x88a000000000ULL,
    0xd867000000000ULL,
    0x40ff800000000ULL,
    0x108fc00000000ULL,
    0x7c78e00000000ULL,
    0x6ad2700000000ULL,
    0x5d80080000000ULL,
    0x96c0040000000ULL,
    0x33a00e0000000ULL,
    0xa1d0050000000ULL,
    0xbc18028000000ULL,
    0x8e0409c000000ULL,
    0x673207e000000ULL,
    0xa7b30ff000000ULL,
    0xb3d5843800000ULL,
    0xa538c79c00000ULL,
    0xd69f6b8200000ULL,
    0x9759b14100000ULL,
    0x7b4aed2380000ULL,
    0xdd617b9140000ULL,
    0x26558688a0000ULL,
    0xfff8cc8670000ULL,
    0xb33f688ff8000ULL,
    0x5589bdc8fc000ULL,
    0xfad2eaa78e000ULL,
    0xd5a5749d27000ULL,
    0xbac7800000800ULL,
    0x359bc00000400ULL,
    0xeaf2e00000e00ULL,
    0x1db5700000500ULL,
    0x76ff880000280ULL,
    0x638fc400009c0ULL,
    0x89f8ee00007e0ULL,
    0x2012750000ff0ULL,
    0xf0200a8000438ULL,
    0x98100dc00079cULL,
    0xe43809e000b82ULL,
    0xca140af000141ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x7000000000000ULL,
    0x4800000000000ULL,
    0x1c00000000000ULL,
    0xae00000000000ULL,
    0xf900000000000ULL,
    0x6c80000000000ULL,
    0x95c0000000000ULL,
    0x7c20000000000ULL,
    0x3e30000000000ULL,
    0xe108000000000ULL,
    0x489c000000000ULL,
    0x6fd2000000000ULL,
    0x3727000000000ULL,
    0x59b800000000ULL,
    0xe176400000000ULL,
    0xcde7200000000ULL,
    0xb827700000000ULL,
    0x9420080000000ULL,
    0x92300c0000000ULL,
    0x2708020000000ULL,
    0xdd9c070000000ULL,
    0xe552048000000ULL,
    0x47e701c000000ULL,
    0xbb3b8ae000000ULL,
    0xb3864f9000000ULL,
    0x3c4f26c800000ULL,
    0x5b4b795c00000ULL,
    0x66da0fc200000ULL,
    0xd3bb0fe300000ULL,
    0xac498c1080000ULL,
    0x43514389c0000ULL,
    0x42fca27d20000ULL,
    0x299132b270000ULL,
    0xe76722b9b8000ULL,
    0x78e77d8764000ULL,
    0x4280001672000ULL,
    0xacc009de77000ULL,
    0x30a0080000800ULL,
    0xdbf00c0000c00ULL,
    0xd528020000200ULL,
    0x6aac070000700ULL,
    0x20da048000480ULL,
    0x86bb01c0001c0ULL,
    0x6c98ae000ae0ULL,
    0x43914f9000f90ULL,
    0xb45ca6c8006c8ULL,
    0x6761395c0095cULL,
    0xb8cf2fc2007c2ULL,
    0x628b7fe3003e3ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0xd000000000000ULL,
    0x4800000000000ULL,
    0xbc00000000000ULL,
    0xe00000000000ULL,
    0xe100000000000ULL,
    0xb580000000000ULL,
    0x3dc0000000000ULL,
    0x8c20000000000ULL,
    0xd610000000000ULL,
    0x7518000000000ULL,
    0xd7b4000000000ULL,
    0x9ad2000000000ULL,
    0x648f000000000ULL,
    0x5053800000000ULL,
    0x25c0400000000ULL,
    0x3829600000000ULL,
    0x415700000000ULL,
    0x4a20080000000ULL,
    0xcb10040000000ULL,
    0xae98060000000ULL,
    0xdb740d0000000ULL,
    0xeb72048000000ULL,
    0x335f0bc000000ULL,
    0xa76b80e000000ULL,
    0xc5644e1000000ULL,
    0x62636b5800000ULL,
    0x8aee73dc00000ULL,
    0xc8180c200000ULL,
    0x5c4f496100000ULL,
    0xb3fae15180000ULL,
    0x2d15307b40000ULL,
    0x3a9652d20000ULL,
    0x98d57988f0000ULL,
    0x13800be538000ULL,
    0xf0c0054c04000ULL,
    0x1fa00a5a96000ULL,
    0x66d0055d57000ULL,
    0xab8080000800ULL,
    0x6164040000400ULL,
    0xd86a060000600ULL,
    0xb9eb0d0000d00ULL,
    0x8639848000480ULL,
    0x7d2b4bc000bc0ULL,
    0xb90e0e0000e0ULL,
    0x44fe3e1000e10ULL,
    0xcd90e35800b58ULL,
    0x59fe37dc003dcULL,
    0x1610e6c2008c2ULL,
    0x553e346100d61ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0xd000000000000ULL,
    0x9800000000000ULL,
    0x3400000000000ULL,
    0x1200000000000ULL,
    0x4300000000000ULL,
    0x480000000000ULL,
    0xb840000000000ULL,
    0x4620000000000ULL,
    0x4130000000000ULL,
    0x3fb8000000000ULL,
    0x58f4000000000ULL,
    0x7446000000000ULL,
    0x701d000000000ULL,
    0x680c800000000ULL,
    0x9c1cc00000000ULL,
    0x6e13200000000ULL,
    0xfd05100000000ULL,
    0x6198080000000ULL,
    0xedc40c0000000ULL,
    0xb9fe0e0000000ULL,
    0xbbe90d0000000ULL,
    0x80ca898000000ULL,
    0x6041c34000000ULL,
    0x523fa12000000ULL,
    0x6329d43000000ULL,
    0x34b3284800000ULL,
    0xf075178400000ULL,
    0xea00026200000ULL,
    0x6700051300000ULL,
    0x6e80047b80000ULL,
    0x1f400bcf40000ULL,
    0xc8a00fe460000ULL,
    0x8e700071d0000ULL,
    0x6f1807e8c8000ULL,
    0xe2840675cc000ULL,
    0x95e02cb32000ULL,
    0xd199004751000ULL,
    0x65d2818000800ULL,
    0xf5c5cf4000c00ULL,
    0x4de1af2000e00ULL,
    0x49f0d93000d00ULL,
    0x13c1a1c800980ULL,
    0xfcc0d4c400340ULL,
    0xde79a34200120ULL,
    0x3734d12300430ULL,
    0x36bfac3380048ULL,
    0xcb69dc4b40b84ULL,
    0xa932d8660462ULL,
    0x55451562d0413ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x5000000000000ULL,
    0x9800000000000ULL,
    0xec00000000000ULL,
    0xe00000000000ULL,
    0x2900000000000ULL,
    0x9f80000000000ULL,
    0xa940000000000ULL,
    0x5220000000000ULL,
    0x8f30000000000ULL,
    0x32a8000000000ULL,
    0x1cd4000000000ULL,
    0xa846000000000ULL,
    0x89ab000000000ULL,
    0xac5b800000000ULL,
    0x6396400000000ULL,
    0x5f65e00000000ULL,
    0x673f500000000ULL,
    0xd688080000000ULL,
    0xc6e40c0000000ULL,
    0x336e0a0000000ULL,
    0xa93f050000000ULL,
    0x5fbd898000000ULL,
    0x94d4ec000000ULL,
    0x23660e000000ULL,
    0x170d129000000ULL,
    0xdea3e1f800000ULL,
    0x12d4569400000ULL,
    0x8173872200000ULL,
    0x160241f300000ULL,
    0x503e0aa80000ULL,
    0x31a45a0d40000ULL,
    0xd07b8be460000ULL,
    0x55a648cab0000ULL,
    0xca4de9ddb8000ULL,
    0x6eab5b3d64000ULL,
    0xbaee08ac5e000ULL,
    0x57f06d4f5000ULL,
    0x3c1d818000800ULL,
    0x563d42c000c00ULL,
    0x653e6ae000a00ULL,
    0xc1a9179000500ULL,
    0x186de87800980ULL,
    0x219b585400ec0ULL,
    0x284607c2000e0ULL,
    0x49ab036300290ULL,
    0xc5b8952809f8ULL,
    0x3396409940a94ULL,
    0xc765e6c660522ULL,
    0x8b3f5c39b08f3ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x3000000000000ULL,
    0xf800000000000ULL,
    0xfc00000000000ULL,
    0x1e00000000000ULL,
    0x2b00000000000ULL,
    0x6780000000000ULL,
    0xc540000000000ULL,
    0xab20000000000ULL,
    0x2790000000000ULL,
    0x6568000000000ULL,
    0x9b2c000000000ULL,
    0xdfae000000000ULL,
    0x9957000000000ULL,
    0x852b800000000ULL,
    0xf4a4c00000000ULL,
    0xfecee00000000ULL,
    0x405ad00000000ULL,
    0x5fae080000000ULL,
    0xd957040000000ULL,
    0x252b8a0000000ULL,
    0xc4a4c30000000ULL,
    0x6ceef8000000ULL,
    0xbc5adfc000000ULL,
    0x41ae09e000000ULL,
    0xf25706b000000ULL,
    0x42ab8c7800000ULL,
    0x1e4cf5400000ULL,
    0xadeee53200000ULL,
    0x9bcaddb900000ULL,
    0x24c60fb680000ULL,
    0x697b0f02c0000ULL,
    0x9d058182e0000ULL,
    0x98b3c6c170000ULL,
    0x28c56d60b8000ULL,
    0x6f6e12f34c000ULL,
    0xda08e05a6e000ULL,
    0x2921db076d000ULL,
    0xc2ab8c7800800ULL,
    0x41e4cf5400400ULL,
    0xdeee53200a00ULL,
    0xabcaddb900300ULL,
    0xdcc60fb680f80ULL,
    0x957b0f02c0fc0ULL,
    0x83058182e01e0ULL,
    0xb3b3c6c1702b0ULL,
    0x4f456d60b8678ULL,
    0xaa2e12f34cc54ULL,
    0x7128e05a6eab2ULL,
    0xeb1db076d279ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x9000000000000ULL,
    0x6800000000000ULL,
    0x9c00000000000ULL,
    0x600000000000ULL,
    0x2f00000000000ULL,
    0xf880000000000ULL,
    0x2a40000000000ULL,
    0x7f20000000000ULL,
    0x3090000000000ULL,
    0xc678000000000ULL,
    0x8104000000000ULL,
    0xeb8a000000000ULL,
    0xa4df000000000ULL,
    0x8245800000000ULL,
    0x4321c00000000ULL,
    0x46b1200000000ULL,
    0x1157100000000ULL,
    0x8d8a080000000ULL,
    0x5bdf040000000ULL,
    0xf2c58e0000000ULL,
    0x6561c90000000ULL,
    0x5791268000000ULL,
    0x92c719c000000ULL,
    0xb572086000000ULL,
    0xdf9b06f000000ULL,
    0x9eef818800000ULL,
    0xdb6ecba400000ULL,
    0x6c8ca17200000ULL,
    0x6072dac900000ULL,
    0xde31240780000ULL,
    0xeb171ee040000ULL,
    0x7aaa0730a0000ULL,
    0x674f05e9f0000ULL,
    0x5abd875658000ULL,
    0x5765c7fb1c000ULL,
    0x429b2eec92000ULL,
    0x3358123531000ULL,
    0xb097818800800ULL,
    0x866acba400400ULL,
    0x6106a17200e00ULL,
    0x7baddac900900ULL,
    0xccf4a40780680ULL,
    0x1e76dee0409c0ULL,
    0x453b2730a0060ULL,
    0x698815e9f02f0ULL,
    0xe9cf8f5658f88ULL,
    0xa7fec3fb1c2a4ULL,
    0x24f4a0ec927f2ULL,
    0xc276db3531309ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x7000000000000ULL,
    0xa800000000000ULL,
    0x4400000000000ULL,
    0xc200000000000ULL,
    0x1300000000000ULL,
    0xcf80000000000ULL,
    0xe240000000000ULL,
    0x7120000000000ULL,
    0x6cb0000000000ULL,
    0xa5c8000000000ULL,
    0xa77c000000000ULL,
    0x77ba000000000ULL,
    0x9e69000000000ULL,
    0xf04800000000ULL,
    0x2182c00000000ULL,
    0x5740e00000000ULL,
    0x1fa5100000000ULL,
    0xfa72080000000ULL,
    0xbd150c0000000ULL,
    0x9abe820000000ULL,
    0xdcebc70000000ULL,
    0x3fc46a8000000ULL,
    0x9867d44000000ULL,
    0x1e12e42000000ULL,
    0xdd001d3000000ULL,
    0xa8486f800000ULL,
    0x24c2c52400000ULL,
    0xa3e0ef9200000ULL,
    0xb655158b00000ULL,
    0x8b1a04fc80000ULL,
    0xc3990307c0000ULL,
    0x346c85a3a0000ULL,
    0x780ec1f290000ULL,
    0x5c12e19a48000ULL,
    0xe001eb72c000ULL,
    0xe5048c1a8e000ULL,
    0xb682c07691000ULL,
    0x7ac0ec7800800ULL,
    0x9ee5116400c00ULL,
    0xecd20bb200200ULL,
    0x77e508bb00700ULL,
    0x8c56820480a80ULL,
    0x427c623c0440ULL,
    0x22366a31a0c20ULL,
    0x4332d47990130ULL,
    0x178c6566c8cf8ULL,
    0xe5bddb0ece24ULL,
    0xf708e9b92e712ULL,
    0xbd991184016cbULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x1000000000000ULL,
    0x1800000000000ULL,
    0x7c00000000000ULL,
    0x8e00000000000ULL,
    0x6f00000000000ULL,
    0x5280000000000ULL,
    0x1fc0000000000ULL,
    0x5920000000000ULL,
    0x71b0000000000ULL,
    0x2b78000000000ULL,
    0x5de4000000000ULL,
    0x9016000000000ULL,
    0xd817000000000ULL,
    0x9c1f800000000ULL,
    0x9e19c00000000ULL,
    0x770da00000000ULL,
    0x2ebb700000000ULL,
    0x91ee080000000ULL,
    0x36330c0000000ULL,
    0x23298e0000000ULL,
    0x34bec10000000ULL,
    0x4ea218000000ULL,
    0xe186b7c000000ULL,
    0xf355a0e000000ULL,
    0xc1ef7af000000ULL,
    0xe00032800000ULL,
    0xaf000cfc00000ULL,
    0xb2800a1200000ULL,
    0xfc001db00000ULL,
    0x41200bd780000ULL,
    0xdb004ee40000ULL,
    0xa57804c960000ULL,
    0x32e40a8d70000ULL,
    0xc296097bf8000ULL,
    0xc7d70f069c000ULL,
    0xc53f80555a000ULL,
    0xefa9c02ef7000ULL,
    0x5c75a2a800800ULL,
    0x735f7b3c00c00ULL,
    0x1f80af200e00ULL,
    0xee240b2b00100ULL,
    0xbf3600ff80180ULL,
    0xaaa70412407c0ULL,
    0x73e780db608e0ULL,
    0xcf3dca56706f0ULL,
    0x62bba32c78528ULL,
    0xf7dc7c28dc1fcULL,
    0x2d29847c3a592ULL,
    0x9bbec0538771bULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0xb000000000000ULL,
    0x800000000000ULL,
    0xf400000000000ULL,
    0xa600000000000ULL,
    0x7700000000000ULL,
    0x6580000000000ULL,
    0xd3c0000000000ULL,
    0x4520000000000ULL,
    0xe490000000000ULL,
    0xd968000000000ULL,
    0xbf4c000000000ULL,
    0x2872000000000ULL,
    0x5de5000000000ULL,
    0x361d800000000ULL,
    0x8f0bc00000000ULL,
    0x39a2600000000ULL,
    0x31ce700000000ULL,
    0x9c3a080000000ULL,
    0x239040000000ULL,
    0xc9078a0000000ULL,
    0x5ea2cb0000000ULL,
    0xec4de08000000ULL,
    0xb3e0bf4000000ULL,
    0x1525e26000000ULL,
    0xfcacb37000000ULL,
    0x9557e45800000ULL,
    0xe549b23c00000ULL,
    0xd4a66d200000ULL,
    0xe9427e0900000ULL,
    0xf768057680000ULL,
    0x7c4c0cc4c0000ULL,
    0x4bf2043f20000ULL,
    0x49250bd250000ULL,
    0x1ebd8b8bd8000ULL,
    0x4c5bc3b5bc000ULL,
    0x3ea6666a6000ULL,
    0x1d127ced27000ULL,
    0x8a00cd800800ULL,
    0x3350097c00400ULL,
    0x92480eb200a00ULL,
    0x68dc067900b00ULL,
    0x3a9a01ae80080ULL,
    0xb26901b8c0f40ULL,
    0x98cf808d20a60ULL,
    0x92bec6ab50770ULL,
    0xf677eaa558658ULL,
    0x36d9bd4d7cd3cULL,
    0x11a2648b86452ULL,
    0x35ce793677e49ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0xd000000000000ULL,
    0x4800000000000ULL,
    0xf400000000000ULL,
    0x2600000000000ULL,
    0x6100000000000ULL,
    0x1780000000000ULL,
    0x8c0000000000ULL,
    0xbb20000000000ULL,
    0x4b0000000000ULL,
    0xe858000000000ULL,
    0x5d54000000000ULL,
    0x1cc2000000000ULL,
    0x8d35000000000ULL,
    0x4d95800000000ULL,
    0xdbe6400000000ULL,
    0x3bbee00000000ULL,
    0x32d4b00000000ULL,
    0xb83a080000000ULL,
    0xcc110c0000000ULL,
    0x2a2f860000000ULL,
    0x2b374d0000000ULL,
    0xecb1648000000ULL,
    0xac53ff4000000ULL,
    0xe3536a6000000ULL,
    0xc1d6fa1000000ULL,
    0x489eef7800000ULL,
    0x264b18c00000ULL,
    0x1662013200000ULL,
    0x20450e0b00000ULL,
    0x696d8e6580000ULL,
    0x5ac2418540000ULL,
    0x3c04e65420000ULL,
    0x1205b10f50000ULL,
    0x2735847358000ULL,
    0xa696476964000ULL,
    0x5746e1f46e000ULL,
    0x47f0bb3f0b000ULL,
    0x998003f800800ULL,
    0x8dc002cc00c00ULL,
    0xa2a00d5200600ULL,
    0x4970091b00d00ULL,
    0x2af80d9d80480ULL,
    0xc424034940f40ULL,
    0x7e3a0b0620260ULL,
    0xbd11081450610ULL,
    0x15af81eed8178ULL,
    0x7f748202408cULL,
    0x39916cf24ebb2ULL,
    0x3de3fe2b5b04bULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x7000000000000ULL,
    0x7800000000000ULL,
    0x7400000000000ULL,
    0x7e00000000000ULL,
    0x5f00000000000ULL,
    0xd080000000000ULL,
    0x7540000000000ULL,
    0x7d20000000000ULL,
    0x2d90000000000ULL,
    0x18f8000000000ULL,
    0x85fc000000000ULL,
    0xd86e000000000ULL,
    0xb895000000000ULL,
    0x496b800000000ULL,
    0xef0dc00000000ULL,
    0x8bb200000000ULL,
    0x9179d00000000ULL,
    0xb36080000000ULL,
    0x7eb9040000000ULL,
    0xc25d8e0000000ULL,
    0xd1b4c70000000ULL,
    0x2ae6a78000000ULL,
    0x30cd174000000ULL,
    0x59d0afe000000ULL,
    0x3a7411f000000ULL,
    0xe58d2b0800000ULL,
    0xb4c0d45400000ULL,
    0x1feb865200000ULL,
    0xf14dc69900000ULL,
    0x3b1b2fef80000ULL,
    0xe6a9ddefc0000ULL,
    0xc66e08eee0000ULL,
    0xd7950a6d50000ULL,
    0x1eb87acb8000ULL,
    0x9e4dc98ddc000ULL,
    0x739b2c5e32000ULL,
    0x97e9d3855d000ULL,
    0xbd4e048800800ULL,
    0xd105071400400ULL,
    0xb79387b200e00ULL,
    0x31f1c06900700ULL,
    0x6552b6780780ULL,
    0x77acdafbc0740ULL,
    0x91fd8f5ce07e0ULL,
    0x9664ca04505f0ULL,
    0x7fbeaccb38d08ULL,
    0x9de113761c754ULL,
    0x9c66a302d27d2ULL,
    0x5e8d19810d2d9ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x9000000000000ULL,
    0xc800000000000ULL,
    0x2400000000000ULL,
    0x8e00000000000ULL,
    0x3900000000000ULL,
    0x6a80000000000ULL,
    0x6040000000000ULL,
    0x5aa0000000000ULL,
    0xf870000000000ULL,
    0x96a8000000000ULL,
    0xc254000000000ULL,
    0xe99a000000000ULL,
    0xb5dd000000000ULL,
    0x6d79800000000ULL,
    0xb633400000000ULL,
    0xa533200000000ULL,
    0xb8b3500000000ULL,
    0xab79880000000ULL,
    0x6b334c0000000ULL,
    0x61b3220000000ULL,
    0x71f3590000000ULL,
    0x5359848000000ULL,
    0xd7034e4000000ULL,
    0x23bb2ae000000ULL,
    0x72d75a9000000ULL,
    0x46eb822800000ULL,
    0xc0ca484400000ULL,
    0xfdf8af4a00000ULL,
    0x8949151700000ULL,
    0x18092b4280000ULL,
    0xc1e546140000ULL,
    0x1a2809d3a0000ULL,
    0xef14024ad0000ULL,
    0xbfba079518000ULL,
    0xa0ed0a0274000ULL,
    0x8df1850092000ULL,
    0xf1574e81e5000ULL,
    0x64212b4280800ULL,
    0x6e0a546140c00ULL,
    0x891209d3a0200ULL,
    0x32b9024ad0900ULL,
    0x8c6b879518c80ULL,
    0xf08a4a0274240ULL,
    0x4f58a500928e0ULL,
    0xc5391e81e5390ULL,
    0xc8a1234280ea8ULL,
    0xd34a586140a04ULL,
    0x17320bd3a07aaULL,
    0x3890b4ad0687ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0xd000000000000ULL,
    0xf800000000000ULL,
    0xbc00000000000ULL,
    0xca00000000000ULL,
    0x3900000000000ULL,
    0x1380000000000ULL,
    0x5540000000000ULL,
    0xbba0000000000ULL,
    0xd170000000000ULL,
    0x6d88000000000ULL,
    0xf244000000000ULL,
    0xbf36000000000ULL,
    0x8ab000000000ULL,
    0x9be4800000000ULL,
    0x5b75400000000ULL,
    0x3498600000000ULL,
    0x91ec100000000ULL,
    0xc264880000000ULL,
    0xf7354c0000000ULL,
    0x3cb86a0000000ULL,
    0xc5dc1d0000000ULL,
    0xec4c878000000ULL,
    0x680147c000000ULL,
    0x240666a000000ULL,
    0x6331e9000000ULL,
    0xdb1e06b800000ULL,
    0x6e9f029400000ULL,
    0x30da8d1a00000ULL,
    0x1dda438700000ULL,
    0x406ae86080000ULL,
    0xfa0251b040000ULL,
    0x713064e960000ULL,
    0x2798120db0000ULL,
    0xb7a8c5ec8000ULL,
    0xcaa4ec714000ULL,
    0x8de2e680e6000ULL,
    0xd846524371000ULL,
    0x3606686080800ULL,
    0x933311b040c00ULL,
    0x5a9e04e960a00ULL,
    0x6edf020db0d00ULL,
    0xaafa845ec8f80ULL,
    0x1cea42c714bc0ULL,
    0x4fc2ec80e6ca0ULL,
    0xb5765f4371390ULL,
    0xbae67e080938ULL,
    0x59471a7040954ULL,
    0xf9800849601baULL,
    0x7c40019db0017ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x3000000000000ULL,
    0xf800000000000ULL,
    0xe400000000000ULL,
    0xfa00000000000ULL,
    0xad00000000000ULL,
    0xb680000000000ULL,
    0x89c0000000000ULL,
    0x92a0000000000ULL,
    0x53d0000000000ULL,
    0x6fb8000000000ULL,
    0x2d5c000000000ULL,
    0xfa46000000000ULL,
    0xa1c5000000000ULL,
    0xfea8800000000ULL,
    0xd5d6400000000ULL,
    0xec99200000000ULL,
    0x34d2300000000ULL,
    0x8c08880000000ULL,
    0xf606440000000ULL,
    0x1b21260000000ULL,
    0xcd8e330000000ULL,
    0x744e878000000ULL,
    0x1ec34a4000000ULL,
    0xa909a9a000000ULL,
    0x3c9879d000000ULL,
    0xbcf7ace800000ULL,
    0xf00172dc00000ULL,
    0xd819288a00000ULL,
    0xb41238ed00000ULL,
    0x32288c1380000ULL,
    0xb1164309c0000ULL,
    0xa8b920ae60000ULL,
    0xdec238b150000ULL,
    0x89108a5908000ULL,
    0x6c8a4784a4000ULL,
    0x74df2a8ff2000ULL,
    0xec173d2073000ULL,
    0xc620041380800ULL,
    0xe3100709c0400ULL,
    0x299806ae60600ULL,
    0x8e4c0bb150300ULL,
    0xb3de0dd908f80ULL,
    0x1f890dc4a4e40ULL,
    0xb576832ff2fa0ULL,
    0x2e5f44f073ad0ULL,
    0xa3efa8fb80368ULL,
    0xb78d75d5c0c9cULL,
    0x99672e2460f2aULL,
    0xc84b335c5063dULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x1000000000000ULL,
    0x6800000000000ULL,
    0xe400000000000ULL,
    0x8600000000000ULL,
    0x9d00000000000ULL,
    0xe180000000000ULL,
    0xb0c0000000000ULL,
    0xeda0000000000ULL,
    0x12f0000000000ULL,
    0x1698000000000ULL,
    0x7e74000000000ULL,
    0x2fc2000000000ULL,
    0xc72d000000000ULL,
    0x56b3800000000ULL,
    0x5e62400000000ULL,
    0xdfe7e00000000ULL,
    0xbf38700000000ULL,
    0xda93880000000ULL,
    0x3c524c0000000ULL,
    0xc4dfee0000000ULL,
    0xc3bc710000000ULL,
    0x8bc98e8000000ULL,
    0x610b424000000ULL,
    0x3bae666000000ULL,
    0xc7f338d000000ULL,
    0xe31de09800000ULL,
    0x3091794c00000ULL,
    0xd37a00ba00000ULL,
    0x566905ff00000ULL,
    0xebc987f180000ULL,
    0xb10b43ab40000ULL,
    0xb3ae62c620000ULL,
    0x33f33acdd0000ULL,
    0xd1dea7ab8000ULL,
    0x49917cdd64000ULL,
    0xb4fa09c05e000ULL,
    0x7ba900a257000ULL,
    0xe7e98ff180800ULL,
    0x133b4fab40c00ULL,
    0x48966cc620e00ULL,
    0x5f773bcdd0100ULL,
    0x3447ecfab8680ULL,
    0xf0c8729d64e40ULL,
    0xcd8b81a05e860ULL,
    0xe2e64972579d0ULL,
    0x6ebde1e980618ULL,
    0xf26174a74070cULL,
    0x4de20a1c200daULL,
    0xdc1d06e2d002fULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0x7000000000000ULL,
    0xa800000000000ULL,
    0x3400000000000ULL,
    0xd200000000000ULL,
    0x5900000000000ULL,
    0xd680000000000ULL,
    0xf140000000000ULL,
    0x9aa0000000000ULL,
    0x8f50000000000ULL,
    0xada8000000000ULL,
    0x96cc000000000ULL,
    0xa942000000000ULL,
    0x46a1000000000ULL,
    0x4946800000000ULL,
    0x56af400000000ULL,
    0xb167200000000ULL,
    0xbaa5100000000ULL,
    0xff66880000000ULL,
    0x5bf440000000ULL,
    0xa2ef220000000ULL,
    0x7b79170000000ULL,
    0x1fac828000000ULL,
    0x9fc2474000000ULL,
    0xa7e3af2000000ULL,
    0x2beb529000000ULL,
    0x35e72fe800000ULL,
    0x52e5185400000ULL,
    0x93468e8a00000ULL,
    0xbaf4e6500000ULL,
    0x3de72f3280000ULL,
    0x56e51238c0000ULL,
    0xc9468c9e20000ULL,
    0x16af4e4f10000ULL,
    0x91672c06e8000ULL,
    0xcaa5118234000ULL,
    0x576687c052000ULL,
    0x31bf4f6141000ULL,
    0x70ef273280800ULL,
    0x22791638c0400ULL,
    0xc92c8e9e20200ULL,
    0x6e82494f10700ULL,
    0x3d43a686e8a80ULL,
    0xa4bb52c234340ULL,
    0x984f2ae052d20ULL,
    0xc4291af141590ULL,
    0x3a04825a80568ULL,
    0x4d0e4d2cc0b14ULL,
    0x74a1ad3420baaULL,
    0x4a52ba10ff5ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x9000000000000ULL,
    0x8800000000000ULL,
    0xcc00000000000ULL,
    0x5a00000000000ULL,
    0x7700000000000ULL,
    0x4e80000000000ULL,
    0x2340000000000ULL,
    0xd4a0000000000ULL,
    0xb450000000000ULL,
    0xaa08000000000ULL,
    0x8f34000000000ULL,
    0x3a8a000000000ULL,
    0xad57000000000ULL,
    0xbd94800000000ULL,
    0x1bfec00000000ULL,
    0xeacd200000000ULL,
    0x4141100000000ULL,
    0x379c880000000ULL,
    0x44cac40000000ULL,
    0xf8472a0000000ULL,
    0xb016190000000ULL,
    0x5808008000000ULL,
    0xe43408c000000ULL,
    0x60a0fa000000ULL,
    0xa5170e7000000ULL,
    0xf5b48c6800000ULL,
    0x37eecef400000ULL,
    0x80e528ea00000ULL,
    0x2e651c3500000ULL,
    0x3d3e864880000ULL,
    0xf1b9cec740000ULL,
    0x1f1a4e2a0000ULL,
    0x3ddbd89070000ULL,
    0x9fd3a1f9c8000ULL,
    0x9ce8d18cac000ULL,
    0x5c452aa472000ULL,
    0x163514b161000ULL,
    0x6d3686c880800ULL,
    0x998dc60740400ULL,
    0xfdfbab42a0a00ULL,
    0x7fccd6e070900ULL,
    0xace72d91c8880ULL,
    0x44461f78accc0ULL,
    0x5200024e725a0ULL,
    0xfb00088461770ULL,
    0xb480008000ce8ULL,
    0xc44008c000634ULL,
    0x12200fa00074aULL,
    0x5b100e7000245ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x7000000000000ULL,
    0x6800000000000ULL,
    0xb400000000000ULL,
    0xb600000000000ULL,
    0x900000000000ULL,
    0x4080000000000ULL,
    0xb940000000000ULL,
    0x3ea0000000000ULL,
    0x5470000000000ULL,
    0x3018000000000ULL,
    0x482c000000000ULL,
    0x2422000000000ULL,
    0xae31000000000ULL,
    0xd537800000000ULL,
    0x42af400000000ULL,
    0x67da00000000ULL,
    0x770c100000000ULL,
    0xadaf880000000ULL,
    0xb7c34c0000000ULL,
    0x22ffae0000000ULL,
    0x404d170000000ULL,
    0xd6000e8000000ULL,
    0xb900074000000ULL,
    0xc880056000000ULL,
    0x7d40079000000ULL,
    0xe0a0028800000ULL,
    0xe97000d400000ULL,
    0xc698088a00000ULL,
    0xf86c05d700000ULL,
    0x5a02070980000ULL,
    0x43010f16c0000ULL,
    0xdb8f81a820000ULL,
    0x5ef34fa410000ULL,
    0x1247ae52f8000ULL,
    0x911110a834000ULL,
    0x5cba0a25fa000ULL,
    0x5b5d0193d1000ULL,
    0xf1b5898980800ULL,
    0x75ee4856c0c00ULL,
    0x7dd224c820e00ULL,
    0x79cf583410700ULL,
    0x47d024daf8680ULL,
    0x8ace5c7c34b40ULL,
    0x145facaffab60ULL,
    0x103d1344d1090ULL,
    0xd818000000c08ULL,
    0x3c2c000000794ULL,
    0x7222000000deaULL,
    0xd731000000247ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x1000000000000ULL,
    0xb800000000000ULL,
    0xe400000000000ULL,
    0x8600000000000ULL,
    0x8d00000000000ULL,
    0x4b80000000000ULL,
    0x8ec0000000000ULL,
    0x79a0000000000ULL,
    0x1df0000000000ULL,
    0xab18000000000ULL,
    0xf6b4000000000ULL,
    0x8d56000000000ULL,
    0xbb5d000000000ULL,
    0xbe5f800000000ULL,
    0x59f2400000000ULL,
    0x1d1f600000000ULL,
    0x33a2f00000000ULL,
    0x8ae7880000000ULL,
    0xefb64c0000000ULL,
    0x28d16e0000000ULL,
    0x48bf10000000ULL,
    0xfe4e038000000ULL,
    0x79e9024000000ULL,
    0xed09866000000ULL,
    0x9baf49d000000ULL,
    0xd6c0ef3800000ULL,
    0x8d90b6ac00000ULL,
    0x23d8e7fa00000ULL,
    0xc224b50f00000ULL,
    0x3b0ee80980000ULL,
    0x8eb9ba8740000ULL,
    0x897162cf60000ULL,
    0x2d7bf92ad0000ULL,
    0x8b5604b478000ULL,
    0xf65d016464000ULL,
    0x15df805c96000ULL,
    0xc73247f3ff000ULL,
    0xdcbf638980800ULL,
    0xca52f4c740c00ULL,
    0xa7ff8aaf60e00ULL,
    0x940241fad0100ULL,
    0xee07680c78b80ULL,
    0x3116f58864e40ULL,
    0x39b181c696860ULL,
    0x3deb4b2cff8d0ULL,
    0x5b0eecb800cb8ULL,
    0x5eb9b4ec004ecULL,
    0xd171619a0099aULL,
    0xd97bfcdf000dfULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0xb000000000000ULL,
    0x8800000000000ULL,
    0xbc00000000000ULL,
    0xba00000000000ULL,
    0x6b00000000000ULL,
    0xbb80000000000ULL,
    0x2740000000000ULL,
    0x30a0000000000ULL,
    0x6cd0000000000ULL,
    0xfff8000000000ULL,
    0x505c000000000ULL,
    0xa10a000000000ULL,
    0x788b000000000ULL,
    0xf0f8800000000ULL,
    0x95dbc00000000ULL,
    0x37d600000000ULL,
    0x2eba900000000ULL,
    0x59f2880000000ULL,
    0x1150c40000000ULL,
    0x2985e60000000ULL,
    0x60615b0000000ULL,
    0x690fe08000000ULL,
    0xa4aa5fc000000ULL,
    0xfad765a000000ULL,
    0x76e199b000000ULL,
    0x4f20d3800000ULL,
    0xb3d706b400000ULL,
    0x272862a00000ULL,
    0xc610c0bd00000ULL,
    0xf125e76780000ULL,
    0xb15a01c0000ULL,
    0xa4f7e102a0000ULL,
    0x23f65181b0000ULL,
    0x5a5d664208000ULL,
    0x422a97e17c000ULL,
    0x7f2a8052f6000ULL,
    0x6d9cc26bd9000ULL,
    0xce57ea5f80800ULL,
    0xd4265cb5c0400ULL,
    0xf6256728a0600ULL,
    0x3936913cb0b00ULL,
    0xdc80812588880ULL,
    0xaec7cde0bcbc0ULL,
    0xc0d7615056ba0ULL,
    0x5de193ea696b0ULL,
    0xdf720c1d883b8ULL,
    0x24970b54bc674ULL,
    0xbad2877a5650aULL,
    0x16c0c35769dcdULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x5000000000000ULL,
    0x5800000000000ULL,
    0x5400000000000ULL,
    0x5600000000000ULL,
    0x3300000000000ULL,
    0x5480000000000ULL,
    0xe4c0000000000ULL,
    0x17a0000000000ULL,
    0x1870000000000ULL,
    0xcf78000000000ULL,
    0x5c4000000000ULL,
    0xbe1e000000000ULL,
    0xaf29000000000ULL,
    0x6e8f800000000ULL,
    0x85dbc00000000ULL,
    0x7e23a00000000ULL,
    0xcf05700000000ULL,
    0x3e91880000000ULL,
    0xddf2cc0000000ULL,
    0x2a2c260000000ULL,
    0x991eb50000000ULL,
    0xd922d8000000ULL,
    0x8947b94000000ULL,
    0xcee5ab6000000ULL,
    0x8e987a3000000ULL,
    0x15f80ec800000ULL,
    0x4604020c00000ULL,
    0xcb3e079a00000ULL,
    0x309902f700000ULL,
    0xbad7895f80000ULL,
    0x28afc86040000ULL,
    0x4ee5aab3e0000ULL,
    0x4e98760990000ULL,
    0x75f8062d78000ULL,
    0x16040bcafc000ULL,
    0x933e078e5a000ULL,
    0x649902d987000ULL,
    0xecd7879780800ULL,
    0x1bafca6c40c00ULL,
    0x1a65ad29e0600ULL,
    0xaa5874fe90500ULL,
    0x62580f72f8580ULL,
    0xe7403aabc540ULL,
    0x5c460d3dba560ULL,
    0x615d04d017330ULL,
    0x52c989baf8d48ULL,
    0xb486cda6bc24cULL,
    0x74ea2ca7ba77aULL,
    0x2f83b32717487ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x3000000000000ULL,
    0x7800000000000ULL,
    0xdc00000000000ULL,
    0xca00000000000ULL,
    0x4300000000000ULL,
    0xe380000000000ULL,
    0x9c40000000000ULL,
    0xb8a0000000000ULL,
    0x73d0000000000ULL,
    0x6c8000000000ULL,
    0x1c7c000000000ULL,
    0xf886000000000ULL,
    0xd3c3000000000ULL,
    0x36e8800000000ULL,
    0x6445c00000000ULL,
    0x24bb600000000ULL,
    0x19c6500000000ULL,
    0x75ee880000000ULL,
    0x87c6c40000000ULL,
    0xb8f3ea0000000ULL,
    0xa153930000000ULL,
    0x61def8000000ULL,
    0x813c99c000000ULL,
    0xa4bb6ea000000ULL,
    0x59c6533000000ULL,
    0xd5ee8bb800000ULL,
    0xb7c6c30400000ULL,
    0xc0f3eaaa00000ULL,
    0x7d539dcd00000ULL,
    0xcc1ded7480000ULL,
    0xc23c95f3c0000ULL,
    0x473b649a60000ULL,
    0xc58650f530000ULL,
    0x6d4e833008000ULL,
    0xc416c3ba9c000ULL,
    0xc63be70556000ULL,
    0x612f90aa95000ULL,
    0x349be6cc80800ULL,
    0x11ff96f7c0400ULL,
    0x71d3ee3060a00ULL,
    0xa1c39d3830300ULL,
    0x49f5e64488780ULL,
    0xddd092495cdc0ULL,
    0xb3d5699f36ca0ULL,
    0xe6e9535fa5430ULL,
    0x8c680a7c88638ULL,
    0xb0ac0c8d5cdc4ULL,
    0x77ce07953618aULL,
    0x20ff0ea2a543dULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x9000000000000ULL,
    0x800000000000ULL,
    0x5c00000000000ULL,
    0x3a00000000000ULL,
    0x2f00000000000ULL,
    0xac80000000000ULL,
    0x94c0000000000ULL,
    0x5fa0000000000ULL,
    0xc270000000000ULL,
    0x4448000000000ULL,
    0xa174000000000ULL,
    0x1afa000000000ULL,
    0xe68b000000000ULL,
    0x43f0800000000ULL,
    0x9732c00000000ULL,
    0xa8a4a00000000ULL,
    0x5add700000000ULL,
    0x86aa880000000ULL,
    0x73c9cc0000000ULL,
    0xf1c2a0000000ULL,
    0xfc9bb90000000ULL,
    0x3cf4288000000ULL,
    0x939fb9c000000ULL,
    0xf04621a000000ULL,
    0x3760b7f000000ULL,
    0x37cca84800000ULL,
    0xa119798c00000ULL,
    0x15b884da00000ULL,
    0x1546ce1700000ULL,
    0x8cdea7ac80000ULL,
    0xcb967d6b40000ULL,
    0x47a05bda0000ULL,
    0xc14b0033b0000ULL,
    0x2ad086e988000ULL,
    0x7e82cdff6c000ULL,
    0x17cca0d36a000ULL,
    0xf119717927000ULL,
    0xbdb887e480800ULL,
    0xd946c8e740c00ULL,
    0xbedeab67a0a00ULL,
    0xb8967724b0900ULL,
    0x92fa09c508080ULL,
    0x7a8b09542c5c0ULL,
    0xd9f084ceca3a0ULL,
    0x2832c6ba972f0ULL,
    0xc24a945082c8ULL,
    0x921d7c942c54cULL,
    0xe30a8f6ecaffaULL,
    0x9eb9c84a97527ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x7000000000000ULL,
    0x2800000000000ULL,
    0xc400000000000ULL,
    0x3a00000000000ULL,
    0x9b00000000000ULL,
    0xa180000000000ULL,
    0x9340000000000ULL,
    0xa0a0000000000ULL,
    0xf9f0000000000ULL,
    0x2a58000000000ULL,
    0x560c000000000ULL,
    0xa502000000000ULL,
    0xe095000000000ULL,
    0xd9d8800000000ULL,
    0xba7dc00000000ULL,
    0xe07e00000000ULL,
    0x4904900000000ULL,
    0x1e82880000000ULL,
    0x78e4cc0000000ULL,
    0x80dd6e0000000ULL,
    0x3cec570000000ULL,
    0x7addea8000000ULL,
    0x47dd904000000ULL,
    0xab7805a000000ULL,
    0xfcbc02b000000ULL,
    0xcffa069800000ULL,
    0x3f69027400000ULL,
    0x7e828b2a00000ULL,
    0xc8e4ca6f00000ULL,
    0x48dd6b1d80000ULL,
    0x88ec55e4c0000ULL,
    0x68dde24220000ULL,
    0x18dd94a250000ULL,
    0x30f8033208000ULL,
    0xf4fc0a581c000ULL,
    0xceda0495de000ULL,
    0x55d904b9d9000ULL,
    0xf47a870580800ULL,
    0x6718c7d0c0c00ULL,
    0xc7876cc820e00ULL,
    0x3e755c7d50700ULL,
    0x14076eb788280ULL,
    0x42355dc8dcc40ULL,
    0xe7276dfdfe3a0ULL,
    0x7855a74899b0ULL,
    0xde5f6f2a08218ULL,
    0x6439586c1c534ULL,
    0x6a256a1fde40aULL,
    0x23105c66d989fULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x7000000000000ULL,
    0x2800000000000ULL,
    0xa400000000000ULL,
    0xfe00000000000ULL,
    0x3d00000000000ULL,
    0x8280000000000ULL,
    0xb340000000000ULL,
    0x5a0000000000ULL,
    0x42f0000000000ULL,
    0x4178000000000ULL,
    0xa28c000000000ULL,
    0x6362000000000ULL,
    0x3d8d000000000ULL,
    0xbed9800000000ULL,
    0x3354400000000ULL,
    0xc5ba200000000ULL,
    0x22fe100000000ULL,
    0x3163880000000ULL,
    0x8aa54c0000000ULL,
    0xc779a60000000ULL,
    0xc3ab570000000ULL,
    0x83e22a8000000ULL,
    0xb1c2164000000ULL,
    0x76d981e000000ULL,
    0x275448d000000ULL,
    0x73ba2ca800000ULL,
    0xcbfe167400000ULL,
    0x65e3853a00000ULL,
    0xa0e541bf00000ULL,
    0xbe59a5df80000ULL,
    0xf1b55ccc0000ULL,
    0x45ba24c420000ULL,
    0xe2fe1a83d0000ULL,
    0x51638e4018000ULL,
    0xfaa545e284000ULL,
    0xef79a2d202000ULL,
    0x67ab5dabf1000ULL,
    0x7de22bf780800ULL,
    0x8cc219f8c0c00ULL,
    0xf459861e20600ULL,
    0x941444ecd0700ULL,
    0x761a2db798280ULL,
    0x890e101a44a40ULL,
    0x249b82cc22fe0ULL,
    0x2694e47213d0ULL,
    0xdd3bacc018028ULL,
    0x32965fa284734ULL,
    0xfb63a5320265aULL,
    0xd1aa527bf132fULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x7000000000000ULL,
    0x8800000000000ULL,
    0x5c00000000000ULL,
    0xea00000000000ULL,
    0x4300000000000ULL,
    0x4080000000000ULL,
    0xfc40000000000ULL,
    0x9da0000000000ULL,
    0x19f0000000000ULL,
    0x9058000000000ULL,
    0xdf8c000000000ULL,
    0x96ea000000000ULL,
    0xc2d3000000000ULL,
    0xb4d4800000000ULL,
    0xfdcdc00000000ULL,
    0x8e49a00000000ULL,
    0xba83500000000ULL,
    0x8746880000000ULL,
    0xe922cc0000000ULL,
    0x238f2e0000000ULL,
    0x2ce1970000000ULL,
    0x99e9a08000000ULL,
    0x507359c000000ULL,
    0x3f9e88a000000ULL,
    0xe6eecf3000000ULL,
    0x4ac5228800000ULL,
    0xe8c29d0400000ULL,
    0x17e527fa00000ULL,
    0xcd729c6f00000ULL,
    0xfa1d25ad80000ULL,
    0x7b0e9d0cc0000ULL,
    0x74af2a3ca0000ULL,
    0x3a519cb630000ULL,
    0xbc91abb2c8000ULL,
    0x464f594b1c000ULL,
    0xc68c8ca7ba000ULL,
    0xfd41cf49c5000ULL,
    0x5223afa580800ULL,
    0xb71055c8c0c00ULL,
    0x66b20b66a0e00ULL,
    0xad5f08e930700ULL,
    0x4a3e841748880ULL,
    0x131ecc83dc5c0ULL,
    0x589d27c11aea0ULL,
    0x584e97a0f5430ULL,
    0xa38f23b2c8c08ULL,
    0xece1954b1c3c4ULL,
    0x79e9a2a7ba7daULL,
    0x20735849c569fULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0xd000000000000ULL,
    0x5800000000000ULL,
    0x9c00000000000ULL,
    0x2a00000000000ULL,
    0xcf00000000000ULL,
    0x3d80000000000ULL,
    0x4c40000000000ULL,
    0xca0000000000ULL,
    0x70d0000000000ULL,
    0xb478000000000ULL,
    0x6084000000000ULL,
    0xb2de000000000ULL,
    0x6f6b000000000ULL,
    0xb318800000000ULL,
    0x878ac00000000ULL,
    0xbb4ee00000000ULL,
    0x7d28500000000ULL,
    0x4e9e880000000ULL,
    0xebf5c40000000ULL,
    0x7d0660000000ULL,
    0x85dd9d0000000ULL,
    0x3eceed8000000ULL,
    0x3d685dc000000ULL,
    0x503e8ca000000ULL,
    0x1825c5f000000ULL,
    0xfc28605800000ULL,
    0xfa19900400000ULL,
    0x9730efea00000ULL,
    0xa193563d00000ULL,
    0x667e043f80000ULL,
    0xc3bb073c40000ULL,
    0x4d608bbfe0000ULL,
    0xf80ec1ffb0000ULL,
    0x6c10e79c08000ULL,
    0xc2035c4dec000ULL,
    0xdb2602a68e000ULL,
    0xd3af0b1875000ULL,
    0x356681e780800ULL,
    0xd431cef840400ULL,
    0xce2e6ef5e0600ULL,
    0xc9269f32b0d00ULL,
    0x508e667b88580ULL,
    0x7af692b5ac9c0ULL,
    0xcb766c536e2a0ULL,
    0xd532942ac5cf0ULL,
    0x3a88679c08bd8ULL,
    0xd5c99c4dec0c4ULL,
    0x26c8e2a68e6caULL,
    0xc1575b1875a0dULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x9000000000000ULL,
    0xe800000000000ULL,
    0xc00000000000ULL,
    0xbe00000000000ULL,
    0x2f00000000000ULL,
    0x7380000000000ULL,
    0x1240000000000ULL,
    0x3a60000000000ULL,
    0x1670000000000ULL,
    0x5868000000000ULL,
    0xf4c000000000ULL,
    0x98f6000000000ULL,
    0x38b5000000000ULL,
    0x93fa800000000ULL,
    0xd901400000000ULL,
    0xe0b5a00000000ULL,
    0xc7dd300000000ULL,
    0x7335a80000000ULL,
    0x59d340000000ULL,
    0xc155ae0000000ULL,
    0x8fed3d0000000ULL,
    0xcf3da08000000ULL,
    0xa3a13dc000000ULL,
    0x9a4bab6000000ULL,
    0xa6543f3000000ULL,
    0x40512c5800000ULL,
    0x7b657e1400000ULL,
    0xc2ec8ffe00000ULL,
    0xa5844f7300000ULL,
    0x7147227880000ULL,
    0x97e07b87c0000ULL,
    0xbb1e05f7e0000ULL,
    0xf9b9050c90000ULL,
    0x76c8c4848000ULL,
    0x44c4455c84000ULL,
    0xea7212312000ULL,
    0x20d0721157000ULL,
    0xfc960c4848800ULL,
    0xd1c5055c84400ULL,
    0x3012812312600ULL,
    0x580d421157900ULL,
    0x1423a44848680ULL,
    0xca18315c844c0ULL,
    0x75272f2312de0ULL,
    0xee907f1157bf0ULL,
    0xf0f604c8481b8ULL,
    0x74b50c9c845e4ULL,
    0x4dfa844312e46ULL,
    0x6601402157a97ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x9000000000000ULL,
    0x800000000000ULL,
    0x7400000000000ULL,
    0xea00000000000ULL,
    0x1500000000000ULL,
    0xdc80000000000ULL,
    0x40c0000000000ULL,
    0xe8e0000000000ULL,
    0xccd0000000000ULL,
    0xed8000000000ULL,
    0xfffc000000000ULL,
    0xc17e000000000ULL,
    0xe0a3000000000ULL,
    0x3ef9800000000ULL,
    0xa7ecc00000000ULL,
    0x9d63e00000000ULL,
    0xee9fd00000000ULL,
    0xc9e3e80000000ULL,
    0x1a5fdc0000000ULL,
    0xeb03ea0000000ULL,
    0x538fd50000000ULL,
    0x315bea8000000ULL,
    0x98b3d24000000ULL,
    0xf2c5e42000000ULL,
    0xa1c0d31000000ULL,
    0x1e6469e800000ULL,
    0xb910171c00000ULL,
    0xaa99876600000ULL,
    0x7bfccbd100000ULL,
    0x535bef8b80000ULL,
    0x39b3d82ec0000ULL,
    0xe445e99c60000ULL,
    0x6400d324f0000ULL,
    0x220468f3f8000ULL,
    0x4100171a3c000ULL,
    0xa6a18f05c6000ULL,
    0x5dd0cfe3c1000ULL,
    0x407de8f3f8800ULL,
    0x662cd71a3cc00ULL,
    0xf3226f05c6200ULL,
    0xef9f1fe3c1900ULL,
    0x8f4600f3f8880ULL,
    0xf78f0b1a3cb40ULL,
    0x335f8505c6ca0ULL,
    0x49b3cae3c1850ULL,
    0x5c646a73f8548ULL,
    0x8810195a3cf4cULL,
    0xb4198125c622eULL,
    0xca3cc9f3c149dULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0xd000000000000ULL,
    0xa800000000000ULL,
    0x9c00000000000ULL,
    0xfa00000000000ULL,
    0xd300000000000ULL,
    0xdb80000000000ULL,
    0xb4c0000000000ULL,
    0x88e0000000000ULL,
    0x62d0000000000ULL,
    0x39d8000000000ULL,
    0xae6c000000000ULL,
    0x4886000000000ULL,
    0x8f41000000000ULL,
    0xcc2f800000000ULL,
    0x9203400000000ULL,
    0x6f39a00000000ULL,
    0xf182900000000ULL,
    0xcfd9a80000000ULL,
    0xcf529c0000000ULL,
    0x2c01aa0000000ULL,
    0x623e910000000ULL,
    0x1707a08000000ULL,
    0xc5bf98c000000ULL,
    0xa9c82f2000000ULL,
    0xe66cd5f000000ULL,
    0x24a9829800000ULL,
    0xd424ebc00000ULL,
    0x2b16221600000ULL,
    0x2f81d49100000ULL,
    0xf2e00b8b80000ULL,
    0x71d00f77c0000ULL,
    0xc2580f83e0000ULL,
    0xcaac0f43d0000ULL,
    0x6866046118000ULL,
    0x71910f93e4000ULL,
    0xff78a0a82000ULL,
    0xef6f4f37cd000ULL,
    0xfc3fac6118800ULL,
    0xca039393e4c00ULL,
    0x8b16200a82200ULL,
    0x3f81de37cdd00ULL,
    0x7ae00ce118280ULL,
    0x3dd00b53e45c0ULL,
    0x90580f2a82da0ULL,
    0x85ac0bc7cd030ULL,
    0x49e60e7918f38ULL,
    0x165105efe4e8cULL,
    0x5c978d3c8252eULL,
    0x397f4f56cd61dULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x3000000000000ULL,
    0x8800000000000ULL,
    0xfc00000000000ULL,
    0xe600000000000ULL,
    0x5900000000000ULL,
    0x1880000000000ULL,
    0xc140000000000ULL,
    0x9560000000000ULL,
    0x1f70000000000ULL,
    0xf848000000000ULL,
    0xfdc4000000000ULL,
    0xb626000000000ULL,
    0xa139000000000ULL,
    0x8c90800000000ULL,
    0xeb7ec00000000ULL,
    0xa254e00000000ULL,
    0xa2d6b00000000ULL,
    0xc7b4e80000000ULL,
    0xf0e6b40000000ULL,
    0x249ce60000000ULL,
    0x8752b70000000ULL,
    0x1c72ee8000000ULL,
    0xbfefb8c000000ULL,
    0x4d2460e000000ULL,
    0x72987d5000000ULL,
    0x1648016800000ULL,
    0x18c4014400000ULL,
    0xa8a6003e00000ULL,
    0x97904b300000ULL,
    0x897081ba80000ULL,
    0xc94ec86f40000ULL,
    0x297ce258e0000ULL,
    0x1962bdbcd0000ULL,
    0x915aecf1e8000ULL,
    0x6d5bb29b3c000ULL,
    0x8b4a695ca6000ULL,
    0xd26577a257000ULL,
    0xcafe84f1e8800ULL,
    0xb83c69b3c400ULL,
    0x9ee26f5ca6e00ULL,
    0x819170a257300ULL,
    0x79f08271e8080ULL,
    0x840eca5b3cbc0ULL,
    0x321ce9bca6060ULL,
    0x9312baf257690ULL,
    0x1f92ed99e8108ULL,
    0xf4dfb3df3c7d4ULL,
    0x568c6962a6936ULL,
    0xf46c731157767ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0xd000000000000ULL,
    0x5800000000000ULL,
    0x8400000000000ULL,
    0xca00000000000ULL,
    0x6b00000000000ULL,
    0x1f80000000000ULL,
    0x1240000000000ULL,
    0x9860000000000ULL,
    0xd350000000000ULL,
    0xfce8000000000ULL,
    0x669c000000000ULL,
    0x22ea000000000ULL,
    0xbf9b000000000ULL,
    0xe241800000000ULL,
    0xf047400000000ULL,
    0xdf6aa00000000ULL,
    0xead5300000000ULL,
    0x4382a80000000ULL,
    0x9c493c0000000ULL,
    0xd968a60000000ULL,
    0x77d2310000000ULL,
    0xa929238000000ULL,
    0x6895794000000ULL,
    0xa3c38f2000000ULL,
    0xfb004ff000000ULL,
    0x67a126d800000ULL,
    0xa65972d400000ULL,
    0xda41895e00000ULL,
    0x64474ee100000ULL,
    0xad6aa51080000ULL,
    0xd5d531c8c0000ULL,
    0xce02a81e20000ULL,
    0x610935c170000ULL,
    0x9488a0e238000ULL,
    0xddc2381104000ULL,
    0xd2212c4a92000ULL,
    0xcf19745d57000ULL,
    0xe5a1836238800ULL,
    0xf157415104c00ULL,
    0x5be2a36a92e00ULL,
    0x8f193bad57d00ULL,
    0xc580a5ba38d80ULL,
    0xc14e338504440ULL,
    0xd3c32a34922a0ULL,
    0x530e754c57bb0ULL,
    0x8b8200aab8c78ULL,
    0x6047024dc4564ULL,
    0xa74b822ab2b26ULL,
    0x5ecc408d27685ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x5000000000000ULL,
    0x6800000000000ULL,
    0xe400000000000ULL,
    0x7e00000000000ULL,
    0x8700000000000ULL,
    0xda80000000000ULL,
    0x2c40000000000ULL,
    0x6260000000000ULL,
    0x3d70000000000ULL,
    0x9bd8000000000ULL,
    0x158c000000000ULL,
    0x2f6000000000ULL,
    0xf83f000000000ULL,
    0x6c38800000000ULL,
    0x6a35400000000ULL,
    0xc125e00000000ULL,
    0xd199f00000000ULL,
    0x6cfde80000000ULL,
    0xb715f40000000ULL,
    0x28be20000000ULL,
    0x506af10000000ULL,
    0xc053648000000ULL,
    0x486fbf4000000ULL,
    0x5c4e836000000ULL,
    0x1a4a473000000ULL,
    0x117d66c800000ULL,
    0x51dcb1f400000ULL,
    0x848002ee00000ULL,
    0xbb40032300000ULL,
    0x70e00fd380000ULL,
    0xa5300d3bc0000ULL,
    0xefb8049ce0000ULL,
    0x4bfc018830000ULL,
    0x3dae0e9768000ULL,
    0x46f303df64000ULL,
    0xd62e8eeb36000ULL,
    0x833a47a5fb000ULL,
    0x54a56a1768800ULL,
    0x9350bc9f64400ULL,
    0x34f60d8b36a00ULL,
    0x8b3f0095fb500ULL,
    0xb88cdf68e80ULL,
    0x75754d6b64a40ULL,
    0x6fc5ef6536de0ULL,
    0xa3a9f3b6fbd70ULL,
    0x31c5eb0ce8328ULL,
    0x34a9f450a4884ULL,
    0x2345e9f9d6bc6ULL,
    0xace9f33ecbea7ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x7000000000000ULL,
    0xd800000000000ULL,
    0xfc00000000000ULL,
    0xba00000000000ULL,
    0x2f00000000000ULL,
    0xd080000000000ULL,
    0x78c0000000000ULL,
    0xaae0000000000ULL,
    0x81f0000000000ULL,
    0x768000000000ULL,
    0x42b4000000000ULL,
    0x33e2000000000ULL,
    0x5c6d000000000ULL,
    0x1c0b800000000ULL,
    0x8a24400000000ULL,
    0x972a600000000ULL,
    0x5ca5500000000ULL,
    0x1ac2680000000ULL,
    0x79d1540000000ULL,
    0xeb406e0000000ULL,
    0x508c530000000ULL,
    0x38c3e38000000ULL,
    0xcaec1cc000000ULL,
    0xf1e3882000000ULL,
    0xdf504e3000000ULL,
    0xbea86d2800000ULL,
    0x89f85dbc00000ULL,
    0x7341e98600000ULL,
    0xccb116a300000ULL,
    0xf2e0027080000ULL,
    0x3df00a4840000ULL,
    0xdd680f6ea0000ULL,
    0x1db406be90000ULL,
    0x3b620e0618000ULL,
    0xd8ad0c60d4000ULL,
    0xceb8d52be000ULL,
    0x24d449f981000ULL,
    0x40c26d8618800ULL,
    0x66d150a0d4400ULL,
    0x83c06572be600ULL,
    0xa44c57c981700ULL,
    0xf023e8ae18580ULL,
    0x981c191cd4bc0ULL,
    0x9c0b82f4beda0ULL,
    0xca24426a815f0ULL,
    0xf72a615e98888ULL,
    0x2ca55b9494c4cULL,
    0xc2c26bba1e70eULL,
    0x85d159e411defULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x1000000000000ULL,
    0xb800000000000ULL,
    0x7400000000000ULL,
    0x200000000000ULL,
    0xbf00000000000ULL,
    0x1880000000000ULL,
    0x5c0000000000ULL,
    0x5be0000000000ULL,
    0x6af0000000000ULL,
    0xdb68000000000ULL,
    0x6b2c000000000ULL,
    0x2aa2000000000ULL,
    0x72ef000000000ULL,
    0x9f57800000000ULL,
    0xa12c400000000ULL,
    0x49bc600000000ULL,
    0xa474100000000ULL,
    0x53b4680000000ULL,
    0x5f68140000000ULL,
    0x811e6e0000000ULL,
    0x399b150000000ULL,
    0xc63e58000000ULL,
    0x9f84524000000ULL,
    0x294205a000000ULL,
    0x3c1f09b000000ULL,
    0x9e3f8c2800000ULL,
    0x11004dec00000ULL,
    0xc19e6f9600000ULL,
    0x185b1a4300000ULL,
    0x8d83e1a080000ULL,
    0x2e745fb1c0000ULL,
    0x50aa052aa0000ULL,
    0x99f3026f30000ULL,
    0xf5fd8ed7d8000ULL,
    0xb3df4b61f4000ULL,
    0xc6c1e9d21e000ULL,
    0xbd6b5d79b5000ULL,
    0x6e158357d8800ULL,
    0xf9334d21f4400ULL,
    0x6d83e2721e600ULL,
    0x7e7451c9b5100ULL,
    0x88aa02ffd8380ULL,
    0xfdf3068df4340ULL,
    0x4ffd86441e620ULL,
    0x78df473ab5af0ULL,
    0xdc41e2f758208ULL,
    0x7ab52903431cULL,
    0x2d758758be39eULL,
    0x960343a685c5fULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0xf000000000000ULL,
    0xc800000000000ULL,
    0xdc00000000000ULL,
    0x1200000000000ULL,
    0x6500000000000ULL,
    0x6d80000000000ULL,
    0x97c0000000000ULL,
    0xc1e0000000000ULL,
    0x72f0000000000ULL,
    0xec68000000000ULL,
    0x8514000000000ULL,
    0xdd86000000000ULL,
    0x3fe1000000000ULL,
    0xeddd800000000ULL,
    0xa8e8c00000000ULL,
    0x5559a00000000ULL,
    0xfab7500000000ULL,
    0x2f51a80000000ULL,
    0x9393540000000ULL,
    0x8dfae0000000ULL,
    0x85565b0000000ULL,
    0xa28c228000000ULL,
    0xcb7b96c000000ULL,
    0x958603a000000ULL,
    0xa3e1009000000ULL,
    0x9fdd8d7800000ULL,
    0x3de8cdec00000ULL,
    0xf0d9a76600000ULL,
    0xb17755c300000ULL,
    0xfcb1ad2080000ULL,
    0x8463545240000ULL,
    0x8937a7d8e0000ULL,
    0x97825efc50000ULL,
    0xbeea235d38000ULL,
    0x866a90cedc000ULL,
    0x94338b36a2000ULL,
    0x8e1dce1aa9000ULL,
    0x170229dd38800ULL,
    0xf8be920edc400ULL,
    0x32558696a2600ULL,
    0x8a0cc58aa9f00ULL,
    0xa137ae2538480ULL,
    0xfb825d22dc9c0ULL,
    0x4ea2c50a2720ULL,
    0xcf6a9bd9a9950ULL,
    0x23b384fdb8258ULL,
    0xa0ddc65c9c0bcULL,
    0xa962214e42b3eULL,
    0x788e9b76f9e7fULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x7000000000000ULL,
    0x3800000000000ULL,
    0x4c00000000000ULL,
    0x6600000000000ULL,
    0xfb00000000000ULL,
    0xc480000000000ULL,
    0x4cc0000000000ULL,
    0x47e0000000000ULL,
    0x7b50000000000ULL,
    0x5b98000000000ULL,
    0xa64000000000ULL,
    0xb23a000000000ULL,
    0x6131000000000ULL,
    0x418c800000000ULL,
    0x4f68400000000ULL,
    0x91b8600000000ULL,
    0xc77fd00000000ULL,
    0xc582680000000ULL,
    0x9d4edc0000000ULL,
    0x608eea0000000ULL,
    0xeee69b0000000ULL,
    0x8ed6898000000ULL,
    0x1ec94fc000000ULL,
    0x76cce7e000000ULL,
    0x72e39c7000000ULL,
    0x60f801a800000ULL,
    0xb1f403bc00000ULL,
    0xe8420c5600000ULL,
    0x9b050bc900000ULL,
    0x54ae8e0f80000ULL,
    0x24fd471f40000ULL,
    0x43eeec8420000ULL,
    0x69769eb050000ULL,
    0x8aae8ecae8000ULL,
    0x53fd4a8fd4000ULL,
    0xc16ee05eee000ULL,
    0xaeb69e2769000ULL,
    0x31ce8f62e8800ULL,
    0x286d4933d4c00ULL,
    0xbb16ec08ee200ULL,
    0x248295ee69700ULL,
    0x1cec816d68b80ULL,
    0xff84e2c948c0ULL,
    0xf40608cce460ULL,
    0x718bdb5e398b0ULL,
    0x974067a7807c8ULL,
    0x8d8bd8a340c0cULL,
    0xe9406ad22001eULL,
    0x4a8bde7950f05ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x3000000000000ULL,
    0xc800000000000ULL,
    0xdc00000000000ULL,
    0x2200000000000ULL,
    0x4b00000000000ULL,
    0xa880000000000ULL,
    0xc0000000000ULL,
    0xbfe0000000000ULL,
    0x1950000000000ULL,
    0xd888000000000ULL,
    0x68e4000000000ULL,
    0x33c6000000000ULL,
    0xc359000000000ULL,
    0x8785800000000ULL,
    0x3e49400000000ULL,
    0x5a36600000000ULL,
    0x9f01d00000000ULL,
    0x3690680000000ULL,
    0x59c8dc0000000ULL,
    0x947dee0000000ULL,
    0x6d359f0000000ULL,
    0x4585828000000ULL,
    0x854942c000000ULL,
    0x5ab668a000000ULL,
    0x73c1da7000000ULL,
    0x63706c2800000ULL,
    0xd798d57c00000ULL,
    0xc675ed5600000ULL,
    0x4e119a2900000ULL,
    0x61238e7e80000ULL,
    0x5f8045d740000ULL,
    0xba5bedeae0000ULL,
    0x3c3c915ed0000ULL,
    0xd2080ae4b8000ULL,
    0xe3240c2344000ULL,
    0x44a60bb15e000ULL,
    0xeac9000819000ULL,
    0x28ed8eccb8800ULL,
    0x93fd455f44c00ULL,
    0x937868e75e600ULL,
    0x7fbcd52119300ULL,
    0x2a53ea3238480ULL,
    0xa4189e48041c0ULL,
    0xf62e03adbe420ULL,
    0xd52d010fc97b0ULL,
    0xf1ab8e7e80e08ULL,
    0x2b6445d7401ccULL,
    0xcb9dedeae0fdeULL,
    0x8465915ed0625ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0xd000000000000ULL,
    0xc800000000000ULL,
    0x4400000000000ULL,
    0x8200000000000ULL,
    0x2d00000000000ULL,
    0xef80000000000ULL,
    0x6740000000000ULL,
    0x4860000000000ULL,
    0xcaf0000000000ULL,
    0x6238000000000ULL,
    0x9d2c000000000ULL,
    0xd78e000000000ULL,
    0x3b57000000000ULL,
    0x4663800000000ULL,
    0x21cac00000000ULL,
    0x22a8200000000ULL,
    0x38c5700000000ULL,
    0x171e280000000ULL,
    0xdebe740000000ULL,
    0xa6f3aa0000000ULL,
    0x1423b90000000ULL,
    0xa38068000000ULL,
    0x492c0d4000000ULL,
    0xbd8e06a000000ULL,
    0x82570b9000000ULL,
    0xe3e38a5800000ULL,
    0x2f8ac0e400000ULL,
    0x748225e00000ULL,
    0xb875780b00000ULL,
    0xd2c6245d80000ULL,
    0xee227709c0000ULL,
    0x5b25a5dd60000ULL,
    0x78a8bfc8b0000ULL,
    0xf9ed89bd58000ULL,
    0xce9dc53b1c000ULL,
    0xecbad945a000ULL,
    0xa00fb9b58b000ULL,
    0x9036056558800ULL,
    0xe83b089f1c400ULL,
    0x940d896a5a200ULL,
    0x4a2dca2e8bd00ULL,
    0x6913ab60d8480ULL,
    0x6d93bf72dc040ULL,
    0x4a600ee93aa20ULL,
    0xa7f00ded3bfd0ULL,
    0xadb8068000a78ULL,
    0x2a6c0d4000634ULL,
    0x57ee06a000ea6ULL,
    0xb5a70b900037fULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x7000000000000ULL,
    0xd800000000000ULL,
    0xc400000000000ULL,
    0xc600000000000ULL,
    0xa100000000000ULL,
    0x6a80000000000ULL,
    0xb5c0000000000ULL,
    0xcae0000000000ULL,
    0x6570000000000ULL,
    0xec08000000000ULL,
    0x9a34000000000ULL,
    0x4312000000000ULL,
    0x7d9b000000000ULL,
    0xa676800000000ULL,
    0xd188c00000000ULL,
    0xdc53600000000ULL,
    0xe287900000000ULL,
    0x79c9680000000ULL,
    0x80e8940000000ULL,
    0x6e4de60000000ULL,
    0xfd8b530000000ULL,
    0xe6600b8000000ULL,
    0x31b00f4000000ULL,
    0xac680fe000000ULL,
    0x3a84015000000ULL,
    0xbdfa074800000ULL,
    0x46df0d0c00000ULL,
    0xcf6c866600000ULL,
    0x9727c71b00000ULL,
    0x53b7e4c680000ULL,
    0xfb5454a840000ULL,
    0xc90c8e5fa0000ULL,
    0xd697cc2df0000ULL,
    0x27dfee96c8000ULL,
    0x5d054627c000ULL,
    0xb2f686137e000ULL,
    0x3148cca945000ULL,
    0x8233625ec8800ULL,
    0x2737962e7c400ULL,
    0x2ba16f957ee00ULL,
    0xaf6c9ae245700ULL,
    0xa737e9d048580ULL,
    0x6b945b8a3c840ULL,
    0x4f6c81acde260ULL,
    0xd727c2d4b5d10ULL,
    0xb3b7e80000328ULL,
    0x8b5454000031cULL,
    0x110c860000eceULL,
    0x1297c30000b47ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x1000000000000ULL,
    0xb800000000000ULL,
    0x1400000000000ULL,
    0x5600000000000ULL,
    0x2900000000000ULL,
    0x7d80000000000ULL,
    0xd640000000000ULL,
    0xe160000000000ULL,
    0x69d0000000000ULL,
    0x8838000000000ULL,
    0x7c1c000000000ULL,
    0x5a02000000000ULL,
    0x7b2f000000000ULL,
    0xbabe800000000ULL,
    0x96dac00000000ULL,
    0x1ca0a00000000ULL,
    0x77d0b00000000ULL,
    0x7d1aa80000000ULL,
    0x4ba3bc0000000ULL,
    0x4f46220000000ULL,
    0x34c67d0000000ULL,
    0x1380098000000ULL,
    0x2b400c4000000ULL,
    0x6ae004e000000ULL,
    0x869002d000000ULL,
    0xacd8093800000ULL,
    0xd78c0eb400000ULL,
    0x655a0cae00000ULL,
    0x47e3096900000ULL,
    0x1504814d80000ULL,
    0x47a9cc38c0000ULL,
    0x1d7c2335a0000ULL,
    0xf3f576ee30000ULL,
    0x533c8e8848000ULL,
    0xd6b5c51e9c000ULL,
    0x74fe25c1c2000ULL,
    0x739a78a257000ULL,
    0x9b620e3048800ULL,
    0xc2ff07ea9cc00ULL,
    0x2a868d8fc2a00ULL,
    0xeec6c31b57100ULL,
    0xa8a2ae45c8380ULL,
    0x31ffb9665cd40ULL,
    0xec24201462f60ULL,
    0x2239719c67390ULL,
    0xcf06800000458ULL,
    0xfc86c00000024ULL,
    0x7c2a00000176ULL,
    0x752fb0000050dULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x7000000000000ULL,
    0x5800000000000ULL,
    0xf400000000000ULL,
    0x4e00000000000ULL,
    0x5700000000000ULL,
    0xbf80000000000ULL,
    0xd0c0000000000ULL,
    0xf5e0000000000ULL,
    0x4f50000000000ULL,
    0xf508000000000ULL,
    0xf2b4000000000ULL,
    0x6652000000000ULL,
    0xe597000000000ULL,
    0x79c8800000000ULL,
    0x2543400000000ULL,
    0xa425a00000000ULL,
    0xc630100000000ULL,
    0xeb1fa80000000ULL,
    0x2d831c0000000ULL,
    0x65ed2e0000000ULL,
    0xa7735b0000000ULL,
    0x393a0b8000000ULL,
    0x38b3044000000ULL,
    0x2772876000000ULL,
    0xf9304d3000000ULL,
    0x58b72a9800000ULL,
    0x5750573c00000ULL,
    0xa120884600000ULL,
    0xaca7408900000ULL,
    0x197fadf680000ULL,
    0xf61311d240000ULL,
    0x13052beba0000ULL,
    0xc99756c730000ULL,
    0x3e0044928000ULL,
    0x5c500d5604000ULL,
    0x3c8803c3f2000ULL,
    0xf174052245000ULL,
    0x3a320d5128800ULL,
    0xd907022a04c00ULL,
    0x88a082e5f2600ULL,
    0x1f67439b45700ULL,
    0x7d1fa9bfa8d80ULL,
    0x4e831c8444340ULL,
    0xf46d2828522e0ULL,
    0x50b353e575270ULL,
    0x2b5a091800678ULL,
    0x53230f7c00e4cULL,
    0x699a812600dbeULL,
    0x13d446b900685ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0xf000000000000ULL,
    0x6800000000000ULL,
    0x1c00000000000ULL,
    0x3a00000000000ULL,
    0x700000000000ULL,
    0xfc80000000000ULL,
    0xe6c0000000000ULL,
    0xd260000000000ULL,
    0xf8b0000000000ULL,
    0xe8c8000000000ULL,
    0x9344000000000ULL,
    0xc916000000000ULL,
    0x9d95000000000ULL,
    0x476d800000000ULL,
    0x3f09400000000ULL,
    0x58b3e00000000ULL,
    0x38d7100000000ULL,
    0x6b5e680000000ULL,
    0x4d1e540000000ULL,
    0xd38d8e0000000ULL,
    0x66794b0000000ULL,
    0xfe9be08000000ULL,
    0x45e31ec000000ULL,
    0xf0e06d2000000ULL,
    0xa77f55b000000ULL,
    0x8f3e026800000ULL,
    0x50a1051c00000ULL,
    0xd4d3826e00000ULL,
    0x39684f2700000ULL,
    0x5600668a80000ULL,
    0x150f570f40000ULL,
    0x87960675e0000ULL,
    0xd0550af110000ULL,
    0x5b8d8c09b8000ULL,
    0xca7944cec4000ULL,
    0xcc9be4d766000ULL,
    0xaee31702a5000ULL,
    0x5e606a8338800ULL,
    0x5abf53c184400ULL,
    0x9bde02a286600ULL,
    0x49d10df3b5f00ULL,
    0x12fb8e8a80e80ULL,
    0xb45c430f405c0ULL,
    0xa5be6875e05a0ULL,
    0xe36e51f110f70ULL,
    0xe1258489b8948ULL,
    0xe18d4e0ec4facULL,
    0x8d45e7f766e86ULL,
    0x503219b2a5ffbULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x1000000000000ULL,
    0x2800000000000ULL,
    0x7c00000000000ULL,
    0x5e00000000000ULL,
    0x9d00000000000ULL,
    0xde80000000000ULL,
    0x7d40000000000ULL,
    0xfbe0000000000ULL,
    0x290000000000ULL,
    0x1348000000000ULL,
    0xbedc000000000ULL,
    0x981e000000000ULL,
    0x641d000000000ULL,
    0xfa34800000000ULL,
    0x873ec00000000ULL,
    0x4985e00000000ULL,
    0x1ce0700000000ULL,
    0x9b31680000000ULL,
    0xc79ebc0000000ULL,
    0x49d4860000000ULL,
    0x29aecd0000000ULL,
    0xcccdec8000000ULL,
    0x533c76c000000ULL,
    0xabaf6f6000000ULL,
    0x3fc3b21000000ULL,
    0xc8800e0800000ULL,
    0x4c40030400000ULL,
    0xb3600ed600000ULL,
    0x8ed0013d00000ULL,
    0x402809ea80000ULL,
    0x200c05d4c0000ULL,
    0xf03600bd60000ULL,
    0x381103a810000ULL,
    0x54028474a8000ULL,
    0x222fc9cf3c000ULL,
    0xc30765b196000ULL,
    0x438fb2792b000ULL,
    0xa3d60d9e28800ULL,
    0x86810c1bfcc00ULL,
    0xf94a850cf6e00ULL,
    0x11f3c1d13b100ULL,
    0xad9961ea80a80ULL,
    0x26d2b9d4c0bc0ULL,
    0xfc0286bd60be0ULL,
    0x9e2fcea8108d0ULL,
    0x7d0768f4a8f68ULL,
    0xce8fbf0f3c014ULL,
    0x55560ad196a5eULL,
    0x87c100692b9f9ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x7000000000000ULL,
    0x800000000000ULL,
    0xac00000000000ULL,
    0x1200000000000ULL,
    0x9300000000000ULL,
    0x3980000000000ULL,
    0x9740000000000ULL,
    0x82e0000000000ULL,
    0x47b0000000000ULL,
    0x3648000000000ULL,
    0x3864000000000ULL,
    0x916e000000000ULL,
    0x87c1000000000ULL,
    0x431b800000000ULL,
    0x61b6400000000ULL,
    0x2347a00000000ULL,
    0x44fa300000000ULL,
    0x62bc280000000ULL,
    0x22fc740000000ULL,
    0x17b38e0000000ULL,
    0x2e62430000000ULL,
    0xec61a68000000ULL,
    0x275f3dc000000ULL,
    0xaac9a9a000000ULL,
    0xfb8b37f000000ULL,
    0x5c6facb800000ULL,
    0xf6e334400000ULL,
    0x16fa253600000ULL,
    0x91a974cf00000ULL,
    0x6b6e04ea80000ULL,
    0x88c1070d40000ULL,
    0x9b8e4a60000ULL,
    0xb9f6467e50000ULL,
    0x8227a73158000ULL,
    0xab0a309874000ULL,
    0xfd9427f742000ULL,
    0x596871ed87000ULL,
    0xbf58bdbd8800ULL,
    0x4137439534400ULL,
    0x8abc27bd22600ULL,
    0xbefc7493d7700ULL,
    0x6db38a6a80880ULL,
    0x61624ecd40ec0ULL,
    0xcfe1a9ea60720ULL,
    0x8f1f328e50e30ULL,
    0x3a9ad0958318ULL,
    0xb87b3e1c743b4ULL,
    0xd147ab614290eULL,
    0xe7fa32d287d4bULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0xd000000000000ULL,
    0x2800000000000ULL,
    0x400000000000ULL,
    0xee00000000000ULL,
    0xd300000000000ULL,
    0xe380000000000ULL,
    0xfa40000000000ULL,
    0x65e0000000000ULL,
    0x9d90000000000ULL,
    0xa168000000000ULL,
    0x324c000000000ULL,
    0x71ee000000000ULL,
    0x3b83000000000ULL,
    0xa666800000000ULL,
    0x17c9400000000ULL,
    0x5ca3200000000ULL,
    0x53def00000000ULL,
    0x12a5a80000000ULL,
    0x30c7bc0000000ULL,
    0x90e8e0000000ULL,
    0xe685410000000ULL,
    0x86cd248000000ULL,
    0x461dfd4000000ULL,
    0x1723246000000ULL,
    0x6d9ef17000000ULL,
    0xf945aed800000ULL,
    0xae57b39400000ULL,
    0x63e684e600000ULL,
    0x2a89473d00000ULL,
    0x7cc3262880000ULL,
    0x330efa8dc0000ULL,
    0xf3ada75060000ULL,
    0xb25bbe48f0000ULL,
    0xb1e885fe88000ULL,
    0x5b9a4889a4000ULL,
    0x764da95cda000ULL,
    0x3fcbbc58bb000ULL,
    0x58808bd608800ULL,
    0xbdd64e0464c00ULL,
    0xc1a3a00cba600ULL,
    0xd348b3104bd00ULL,
    0xf36602a880a80ULL,
    0x835f07cdc0c40ULL,
    0x1b608330608e0ULL,
    0xe7464f38f0030ULL,
    0x254bab2688cb8ULL,
    0x1c44bb1da4fe4ULL,
    0xc2e80dbada8beULL,
    0x80c0b65bb4e9ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x5000000000000ULL,
    0x6800000000000ULL,
    0x4c00000000000ULL,
    0x600000000000ULL,
    0xf300000000000ULL,
    0x2580000000000ULL,
    0xd2c0000000000ULL,
    0x5160000000000ULL,
    0xb0000000000ULL,
    0x2c48000000000ULL,
    0x8a2c000000000ULL,
    0xd51e000000000ULL,
    0xe691000000000ULL,
    0xcf46800000000ULL,
    0xa787400000000ULL,
    0x1bf6a00000000ULL,
    0xd9c4500000000ULL,
    0x70f8280000000ULL,
    0xa86f140000000ULL,
    0xb0108e0000000ULL,
    0x783a410000000ULL,
    0x442e208000000ULL,
    0x1a1211c000000ULL,
    0x9d280ee000000ULL,
    0x9a9c0ff000000ULL,
    0xf156043800000ULL,
    0x70bd071c00000ULL,
    0x745881ce00000ULL,
    0xfe1649e700000ULL,
    0xf73027b280000ULL,
    0x5f831799c0000ULL,
    0x1fee85cd60000ULL,
    0xa3db4fe7d0000ULL,
    0xbdc0a2b388000ULL,
    0x5ac9511a64000ULL,
    0xd68a10f82000ULL,
    0xe955f86f1000ULL,
    0xc35ea58108800ULL,
    0xc1985743a4400ULL,
    0xb8ce2a22e2600ULL,
    0x94621f9121500ULL,
    0xee00030a80e80ULL,
    0xff000145c00c0ULL,
    0x43800ae360660ULL,
    0x71c009f0d0a30ULL,
    0x1ce00139084d8ULL,
    0x9e70019fa49ecULL,
    0x7b28050ce2576ULL,
    0x799c098621f3bULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x7000000000000ULL,
    0x800000000000ULL,
    0x4c00000000000ULL,
    0xb600000000000ULL,
    0xf900000000000ULL,
    0xb280000000000ULL,
    0x9340000000000ULL,
    0x87e0000000000ULL,
    0x5590000000000ULL,
    0xc4c8000000000ULL,
    0x8804000000000ULL,
    0x8c2e000000000ULL,
    0x5629000000000ULL,
    0x8922800000000ULL,
    0xba91c00000000ULL,
    0xdf41e00000000ULL,
    0x31c5f00000000ULL,
    0xacab680000000ULL,
    0x76503c0000000ULL,
    0x1b44860000000ULL,
    0xbfccb0000000ULL,
    0x3ad6e8000000ULL,
    0x4ded33c000000ULL,
    0x328003e000000ULL,
    0x5340075000000ULL,
    0x67e00e4800000ULL,
    0x259001a400000ULL,
    0xccc803d600000ULL,
    0xc40408ad00000ULL,
    0x3a2e0f5280000ULL,
    0xaf29024940000ULL,
    0x3ba28fa660000ULL,
    0x29d1c4d6d0000ULL,
    0x58a1e82ec8000ULL,
    0x6455fb928c000ULL,
    0x6863612ab6000ULL,
    0xfe543c3503000ULL,
    0x976a89fc48800ULL,
    0x5dd5ca1bccc00ULL,
    0x8a8fed6cd6e00ULL,
    0xf77cffb3d3700ULL,
    0xedc1ef9a80880ULL,
    0x6285f02d408c0ULL,
    0xcb4b6f9060560ULL,
    0x53c03b2bd0890ULL,
    0xd78c813448ba8ULL,
    0xcff8c47fccdf4ULL,
    0x39836b5ad631eULL,
    0xe2c43b4ed3ac9ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0x9000000000000ULL,
    0x800000000000ULL,
    0x6400000000000ULL,
    0xda00000000000ULL,
    0xc500000000000ULL,
    0x8b80000000000ULL,
    0x66c0000000000ULL,
    0x9f60000000000ULL,
    0x88b0000000000ULL,
    0x6e58000000000ULL,
    0xb10c000000000ULL,
    0x19b6000000000ULL,
    0xe7d3000000000ULL,
    0x5eeb800000000ULL,
    0x2375c00000000ULL,
    0x1eb2a00000000ULL,
    0x8571d00000000ULL,
    0x2d81280000000ULL,
    0x55c8140000000ULL,
    0x4fe58a0000000ULL,
    0xeadacd0000000ULL,
    0xd157228000000ULL,
    0x2fab1f4000000ULL,
    0xdcd6052000000ULL,
    0xea630e1000000ULL,
    0x9b33871800000ULL,
    0x64b9c33c00000ULL,
    0x9064a1ce00000ULL,
    0x8e12d8a700000ULL,
    0xc732aab380000ULL,
    0x2b1dbcbc0000ULL,
    0xc36125c6e0000ULL,
    0xeeb81e01f0000ULL,
    0x3d5d8703d8000ULL,
    0xd1a6cf816c000ULL,
    0xe3d92dc012000ULL,
    0x34c4126081000ULL,
    0x7e538f3058800ULL,
    0xf909cb0aac400ULL,
    0x5dbcad26f2200ULL,
    0xadded27171900ULL,
    0x93e4a72b80880ULL,
    0xccd2d3b7c0240ULL,
    0xa252ab28e0fa0ULL,
    0xdf01d5b6f0550ULL,
    0x2eb9202858838ULL,
    0x5d741c36ac02cULL,
    0x618b86e8f2456ULL,
    0x7bc5c7d6714dbULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0xf000000000000ULL,
    0xb800000000000ULL,
    0xe400000000000ULL,
    0x7600000000000ULL,
    0x8700000000000ULL,
    0x5f80000000000ULL,
    0x12c0000000000ULL,
    0xf360000000000ULL,
    0xfa90000000000ULL,
    0xe478000000000ULL,
    0xd14000000000ULL,
    0x7aa2000000000ULL,
    0x245f000000000ULL,
    0x2d38800000000ULL,
    0x8aa2400000000ULL,
    0x9c47200000000ULL,
    0xc912d00000000ULL,
    0xfc87a80000000ULL,
    0x1b649c0000000ULL,
    0x96828a0000000ULL,
    0xee79430000000ULL,
    0xe825a98000000ULL,
    0x6c3b914000000ULL,
    0xa3a04e000000ULL,
    0xe51b0a3000000ULL,
    0x1682809800000ULL,
    0x2e79465c00000ULL,
    0xc825a14e00000ULL,
    0x9c3b90c500000ULL,
    0xb23a0e1180000ULL,
    0x11b0b0840000ULL,
    0x60828e15a0000ULL,
    0xa9794cb8b0000ULL,
    0x97a5a1cfa8000ULL,
    0x8efb9b06d4000ULL,
    0x415a0a307a000ULL,
    0xfb8b009a49000ULL,
    0x84fa865e28800ULL,
    0xa46d414e94c00ULL,
    0xed07a0c5da200ULL,
    0xaaa49612f9f00ULL,
    0x6c628f0980380ULL,
    0x7129401440240ULL,
    0x18bda1bba0560ULL,
    0x6d7f954db0770ULL,
    0x118006c628e78ULL,
    0xb1c0071294f6cULL,
    0xfae0018bda856ULL,
    0x9f5006d7f97d9ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0xf000000000000ULL,
    0xe800000000000ULL,
    0x5400000000000ULL,
    0x4e00000000000ULL,
    0xfd00000000000ULL,
    0xbf80000000000ULL,
    0x5740000000000ULL,
    0x32e0000000000ULL,
    0x36b0000000000ULL,
    0x16f8000000000ULL,
    0xd0b4000000000ULL,
    0x1fd6000000000ULL,
    0xd127000000000ULL,
    0x5daa800000000ULL,
    0x87ec00000000ULL,
    0x7259a00000000ULL,
    0xd163b00000000ULL,
    0x2beb280000000ULL,
    0x8f19740000000ULL,
    0x189c820000000ULL,
    0xfbe9cb0000000ULL,
    0xd70b248000000ULL,
    0x4a97a4000000ULL,
    0x11e4826000000ULL,
    0x8c1dce9000000ULL,
    0x123d251800000ULL,
    0xb73e75a400000ULL,
    0x14b60e5600000ULL,
    0xa9d7075f00000ULL,
    0xc0328ca180000ULL,
    0xe03aceb040000ULL,
    0x5017a5eae0000ULL,
    0x1800b02d30000ULL,
    0xbc0fabe9c8000ULL,
    0x1a04b52e9c000ULL,
    0xb321aa68b2000ULL,
    0x4297beee97000ULL,
    0xe8dd2bc848800ULL,
    0x658e75dedc400ULL,
    0x44e0fe252a00ULL,
    0x20630b53a7f00ULL,
    0xc66481b980680ULL,
    0xcf5dcf1440140ULL,
    0xcedd29bce0ee0ULL,
    0x8c8e7c72300d0ULL,
    0x55ce03c848578ULL,
    0x7a2301dedc034ULL,
    0xa3048de2527ceULL,
    0xfaadc053a7cbbULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x5000000000000ULL,
    0x9800000000000ULL,
    0xb400000000000ULL,
    0x7a00000000000ULL,
    0x9700000000000ULL,
    0x6380000000000ULL,
    0xf540000000000ULL,
    0x70e0000000000ULL,
    0xd490000000000ULL,
    0x66e8000000000ULL,
    0x2dac000000000ULL,
    0xd842000000000ULL,
    0xe473000000000ULL,
    0x1277800000000ULL,
    0x7b55400000000ULL,
    0x3dcc200000000ULL,
    0x1001300000000ULL,
    0x3833a80000000ULL,
    0x84287c0000000ULL,
    0xb2358e0000000ULL,
    0xbb26490000000ULL,
    0xadbbaf8000000ULL,
    0x18547e4000000ULL,
    0x847f862000000ULL,
    0x42694e3000000ULL,
    0xe366279800000ULL,
    0x89de332400000ULL,
    0x6a0620b600000ULL,
    0xaf0e355d00000ULL,
    0xe78e28c080000ULL,
    0x47723fe3c0000ULL,
    0xcbc42a52a0000ULL,
    0x793d3189f0000ULL,
    0x7e99ab8d58000ULL,
    0xa9f77f8b64000ULL,
    0x9a00028d3a000ULL,
    0x700000b87000ULL,
    0x9b8004cdd8800ULL,
    0x11400228a4c00ULL,
    0x92e000ff9a600ULL,
    0xf79006b277500ULL,
    0x7f680f5880180ULL,
    0x4fec0cc7c0740ULL,
    0xcb220ae4a01a0ULL,
    0xc5a304d4f0c70ULL,
    0x47f834dd8fb8ULL,
    0x82694068a4414ULL,
    0x836628df9a0aeULL,
    0xd9de318277439ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0xd000000000000ULL,
    0x4800000000000ULL,
    0xf400000000000ULL,
    0xd600000000000ULL,
    0x8d00000000000ULL,
    0x4680000000000ULL,
    0x40000000000ULL,
    0x3be0000000000ULL,
    0x2510000000000ULL,
    0x298000000000ULL,
    0xee5c000000000ULL,
    0xdac6000000000ULL,
    0x9bf000000000ULL,
    0xadd0800000000ULL,
    0xc82ac00000000ULL,
    0x3424e00000000ULL,
    0x7616b00000000ULL,
    0x5d32680000000ULL,
    0xe837c0000000ULL,
    0xf446020000000ULL,
    0xedff010000000ULL,
    0xa8308e8000000ULL,
    0x443ac24000000ULL,
    0xee3ce9e000000ULL,
    0xe10ab79000000ULL,
    0x2c94610800000ULL,
    0xaf6c74d400000ULL,
    0x266e85d600000ULL,
    0xeed9c35500000ULL,
    0x7faa6d1780000ULL,
    0xf0df7ef4c0000ULL,
    0xc6800c65e0000ULL,
    0xc04005ee30000ULL,
    0x9be0047968000ULL,
    0xf51009cd5c000ULL,
    0x4a980ac946000ULL,
    0x1a5c06f6c7000ULL,
    0xcc60866e8800ULL,
    0x84bf03ed9cc00ULL,
    0xeb50837aa6a00ULL,
    0xc86ac04df7d00ULL,
    0xfc4e10800c80ULL,
    0x5306b4d400340ULL,
    0x5faa65d600760ULL,
    0xe0df7355005d0ULL,
    0x2e800517800e8ULL,
    0xe44002f4c0f44ULL,
    0x5e00e65e0edeULL,
    0x8c1004ee30a81ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0xb000000000000ULL,
    0xd800000000000ULL,
    0x6400000000000ULL,
    0xaa00000000000ULL,
    0x6900000000000ULL,
    0x9a80000000000ULL,
    0xf4c0000000000ULL,
    0x9f60000000000ULL,
    0x7510000000000ULL,
    0x24b8000000000ULL,
    0xcfe4000000000ULL,
    0xb8fa000000000ULL,
    0x697f000000000ULL,
    0x422b800000000ULL,
    0x1524c00000000ULL,
    0x74aee00000000ULL,
    0x87d8900000000ULL,
    0xb4ff680000000ULL,
    0x7f435c0000000ULL,
    0xe51a0a0000000ULL,
    0x4caf070000000ULL,
    0x73f38f8000000ULL,
    0x76d0cd4000000ULL,
    0xaa6ce72000000ULL,
    0xb18390d000000ULL,
    0x7b4eeb0800000ULL,
    0x1f0895dc00000ULL,
    0x6da76a5e00000ULL,
    0xe5775f1d00000ULL,
    0x94380c3d80000ULL,
    0x92240aef40000ULL,
    0x9d1a0ce420000ULL,
    0x58af01b9b0000ULL,
    0x21f3812518000ULL,
    0xcbd0c859bc000ULL,
    0x42ece99656000ULL,
    0x484397a2c5000ULL,
    0xd4aee61098800ULL,
    0xf7d8976afcc00ULL,
    0x4cff6f2c76200ULL,
    0xab43590675b00ULL,
    0x971a030800580ULL,
    0x41af09dc00a40ULL,
    0x4373805e008a0ULL,
    0xeb10c81d00d90ULL,
    0xaf8cebbd80428ULL,
    0x30539baf4090cULL,
    0xc096e1c420356ULL,
    0xa5fc9669b01c1ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0xb000000000000ULL,
    0x9800000000000ULL,
    0x1c00000000000ULL,
    0xe600000000000ULL,
    0xdf00000000000ULL,
    0xae80000000000ULL,
    0xac0000000000ULL,
    0x7f60000000000ULL,
    0xe110000000000ULL,
    0xcda8000000000ULL,
    0x9274000000000ULL,
    0x82aa000000000ULL,
    0xb4d1000000000ULL,
    0xdc46800000000ULL,
    0x19b2400000000ULL,
    0x8052600000000ULL,
    0x5fba100000000ULL,
    0x8f5ee80000000ULL,
    0xd9095c0000000ULL,
    0x1820e0000000ULL,
    0x5c65070000000ULL,
    0xd98c8f8000000ULL,
    0xe0734ac000000ULL,
    0xefbce7e000000ULL,
    0x177c5c3000000ULL,
    0xc5268c8800000ULL,
    0xe7a2415c00000ULL,
    0x837a6b1e00000ULL,
    0x770e15bd00000ULL,
    0xea94eaac80000ULL,
    0x90c85af640000ULL,
    0xf66c849020000ULL,
    0x8a3489a50000ULL,
    0x75f4e086c8000ULL,
    0x1d850ba34000ULL,
    0xc3c48dd74e000ULL,
    0x36d74a4185000ULL,
    0x895eeea248800ULL,
    0x7609571074c00ULL,
    0x57020c596e600ULL,
    0xfaa50066d5b00ULL,
    0xd8ec830800180ULL,
    0xc2634b9c00dc0ULL,
    0x6a94ecfe00860ULL,
    0x50c8598d006f0ULL,
    0x966c8e2480368ULL,
    0xb8a347aa4016cULL,
    0xedf4e18e20996ULL,
    0x1dd85a27503e1ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x9000000000000ULL,
    0xa800000000000ULL,
    0x9c00000000000ULL,
    0xf600000000000ULL,
    0x1500000000000ULL,
    0x8980000000000ULL,
    0xe7c0000000000ULL,
    0x7560000000000ULL,
    0x9a30000000000ULL,
    0x9b28000000000ULL,
    0x489c000000000ULL,
    0x944e000000000ULL,
    0xd9ad000000000ULL,
    0xefca800000000ULL,
    0x9960c00000000ULL,
    0x5433200000000ULL,
    0xba19900000000ULL,
    0xab1fa80000000ULL,
    0x9088540000000ULL,
    0x3048060000000ULL,
    0x1bac0d0000000ULL,
    0x90e6048000000ULL,
    0xf3f100c000000ULL,
    0x2f6485e000000ULL,
    0xa13dc89000000ULL,
    0xa3b1a7f800000ULL,
    0xe4d55f2c00000ULL,
    0x79ca87ce00000ULL,
    0x5c60c3df00000ULL,
    0x95b320e480000ULL,
    0x51d9942ac0000ULL,
    0x807fa27660000ULL,
    0x83b854d310000ULL,
    0xd4e00ed848000ULL,
    0xa1f0085cdc000ULL,
    0xf84807a79a000ULL,
    0x57ac0c8b95000ULL,
    0x2ee60d44c8800ULL,
    0xeaf1039a1c400ULL,
    0xf8e487fffae00ULL,
    0xcffdc31785900ULL,
    0xa951ac8000280ULL,
    0x8c2554c000dc0ULL,
    0x1e0283e000160ULL,
    0x690cc59000850ULL,
    0xefb5237800218ULL,
    0x5ad89fec007bcULL,
    0x60d3222e00836ULL,
    0x8be99b4f008f3ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0xd000000000000ULL,
    0x7800000000000ULL,
    0xa400000000000ULL,
    0x5e00000000000ULL,
    0xf300000000000ULL,
    0x9780000000000ULL,
    0x6d40000000000ULL,
    0x4be0000000000ULL,
    0x1830000000000ULL,
    0x3428000000000ULL,
    0xc60c000000000ULL,
    0x872a000000000ULL,
    0xb1b7000000000ULL,
    0x3a7e800000000ULL,
    0x824b400000000ULL,
    0x8669200000000ULL,
    0xe876b00000000ULL,
    0xb375a80000000ULL,
    0xf8f6f40000000ULL,
    0x6f80060000000ULL,
    0x8940090000000ULL,
    0xf5e0098000000ULL,
    0x3b30074000000ULL,
    0xdba8026000000ULL,
    0xf4c057000000ULL,
    0x92ca0c9800000ULL,
    0x5a8709e400000ULL,
    0x99d68dc600000ULL,
    0x2907475700000ULL,
    0x4aa327fc80000ULL,
    0x41f1bde3c0000ULL,
    0xbd23233020000ULL,
    0xbcb1b37bb0000ULL,
    0x6ec32dd548000ULL,
    0xd081ba3fc4000ULL,
    0x7ceb2a417a000ULL,
    0x418db5e3df000ULL,
    0x32412731c8800ULL,
    0x6e7abd7804400ULL,
    0xd45fa0d75ae00ULL,
    0x9941fdbf6fd00ULL,
    0x2dfe800000f80ULL,
    0xaf0b400000e40ULL,
    0x2d89200000be0ULL,
    0x2046b00000230ULL,
    0xff5da80000ef8ULL,
    0x9afaf40000c94ULL,
    0xb6aa06000015eULL,
    0xcbf7090000eb3ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0x7000000000000ULL,
    0x3800000000000ULL,
    0xc00000000000ULL,
    0x1e00000000000ULL,
    0x6300000000000ULL,
    0xcc80000000000ULL,
    0xb3c0000000000ULL,
    0xc660000000000ULL,
    0xb030000000000ULL,
    0x5818000000000ULL,
    0x5c14000000000ULL,
    0x5612000000000ULL,
    0x570d000000000ULL,
    0xde84800000000ULL,
    0xcedf400000000ULL,
    0x69cbe00000000ULL,
    0xcf6fd00000000ULL,
    0x2da5680000000ULL,
    0x2a59940000000ULL,
    0xbe000a0000000ULL,
    0x5300030000000ULL,
    0xd480018000000ULL,
    0xcfc007c000000ULL,
    0xe060026000000ULL,
    0xdf3006f000000ULL,
    0x8a980d2800000ULL,
    0x8cd40d0c00000ULL,
    0x5cf200ae00000ULL,
    0x54fd003f00000ULL,
    0x40fc89e780000ULL,
    0x22fb4ec240000ULL,
    0x67c1e0e0a0000ULL,
    0xc476d0b190000ULL,
    0xa533e08968000ULL,
    0xb38bdd9d24000ULL,
    0x94f6174f6000ULL,
    0x52b0931b09000ULL,
    0x90ee8dc6e8800ULL,
    0x2af64d9364400ULL,
    0x73c5695a56200ULL,
    0xa669966599700ULL,
    0xe018000000b80ULL,
    0x10140000004c0ULL,
    0x68120000003e0ULL,
    0x440d000000130ULL,
    0x2a04800000f48ULL,
    0x711f400000bfcULL,
    0xb1abe00000d86ULL,
    0x1c5fd00000d33ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0xf000000000000ULL,
    0xd800000000000ULL,
    0xc400000000000ULL,
    0xe200000000000ULL,
    0x7b00000000000ULL,
    0x3880000000000ULL,
    0x10c0000000000ULL,
    0x3aa0000000000ULL,
    0xe010000000000ULL,
    0x3018000000000ULL,
    0xb80c000000000ULL,
    0x341e000000000ULL,
    0x3a1b000000000ULL,
    0xbf18800000000ULL,
    0xda9c400000000ULL,
    0x6bcf600000000ULL,
    0x227100000000ULL,
    0xf0d2180000000ULL,
    0xabf540000000ULL,
    0x5800020000000ULL,
    0x400030000000ULL,
    0x8200018000000ULL,
    0x8b0003c000000ULL,
    0xe080036000000ULL,
    0xd4c0031000000ULL,
    0xd8a0038800000ULL,
    0x9b1001ec00000ULL,
    0x89800e200000ULL,
    0xa8cc004300000ULL,
    0xebe00ea80000ULL,
    0xda0b038040000ULL,
    0x8f0080c060000ULL,
    0x629042e030000ULL,
    0x5fd160d078000ULL,
    0x383c10e86c000ULL,
    0x4fca9afc62000ULL,
    0xd023176a71000ULL,
    0x33cf63af3d800ULL,
    0x62713089c400ULL,
    0x72d21a4348600ULL,
    0x81bf57eafd500ULL,
    0xb880000000080ULL,
    0xd0c00000000c0ULL,
    0x5aa0000000060ULL,
    0x10100000000f0ULL,
    0xe8180000000d8ULL,
    0x7c0c0000000c4ULL,
    0xd61e0000000e2ULL,
    0x411b00000007bULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0xb000000000000ULL,
    0x1800000000000ULL,
    0x5c00000000000ULL,
    0xae00000000000ULL,
    0xa900000000000ULL,
    0x3b80000000000ULL,
    0x78c0000000000ULL,
    0x18e0000000000ULL,
    0xb810000000000ULL,
    0xcc18000000000ULL,
    0xe61c000000000ULL,
    0x5d16000000000ULL,
    0xd183000000000ULL,
    0x23cb800000000ULL,
    0x2475c00000000ULL,
    0x5245200000000ULL,
    0x97bf700000000ULL,
    0x3e23180000000ULL,
    0x31fd1c0000000ULL,
    0x4380020000000ULL,
    0x54c0030000000ULL,
    0x4ee0038000000ULL,
    0xfd1002c000000ULL,
    0x4198006000000ULL,
    0x6bdc017000000ULL,
    0xd07602b800000ULL,
    0xb85302a400000ULL,
    0xccb380ee00000ULL,
    0x2b9c1e300000ULL,
    0xdbab206380000ULL,
    0x183072e040000ULL,
    0x8ce69b3060000ULL,
    0x2217df9870000ULL,
    0x6f18a37458000ULL,
    0x3689b0460c000ULL,
    0x14dbb0f2e000ULL,
    0x7f27ae51d7000ULL,
    0x6e7e3b2914800ULL,
    0x995e6c2efdc00ULL,
    0xe3351bc08c600ULL,
    0x207e1fa3f4700ULL,
    0x804b800000080ULL,
    0xc0b5c000000c0ULL,
    0x4a52000000e0ULL,
    0x36af7000000b0ULL,
    0xd1bb180000018ULL,
    0xf3211c000005cULL,
    0xa8760200000aeULL,
    0x94530300000a9ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0xf000000000000ULL,
    0x3800000000000ULL,
    0x4400000000000ULL,
    0xda00000000000ULL,
    0xe500000000000ULL,
    0x5980000000000ULL,
    0x3540000000000ULL,
    0x5ca0000000000ULL,
    0x7410000000000ULL,
    0x208000000000ULL,
    0xf114000000000ULL,
    0x4b9e000000000ULL,
    0xac47000000000ULL,
    0x9b28800000000ULL,
    0x7e4b400000000ULL,
    0xe234a00000000ULL,
    0xe9cf300000000ULL,
    0x2070a80000000ULL,
    0x75e8940000000ULL,
    0xa6a0020000000ULL,
    0x2110010000000ULL,
    0xc388028000000ULL,
    0x705403c000000ULL,
    0xf53e00e000000ULL,
    0x7957011000000ULL,
    0x1aa0836800000ULL,
    0x5f1f439400000ULL,
    0xac8aa16600000ULL,
    0x4d830d500000ULL,
    0xe5f0297280000ULL,
    0x8ea7d5d040000ULL,
    0xd02a20820000ULL,
    0x958c32c450000ULL,
    0x334e2bae78000ULL,
    0xd7b0d5711c000ULL,
    0x2a82208ca2000ULL,
    0xcfc371e92d000ULL,
    0x1b6c8a60d2800ULL,
    0xb36ce7f33cc00ULL,
    0xdf640b07c2a00ULL,
    0x2977a512a2500ULL,
    0x9a78a80000080ULL,
    0x80fc940000040ULL,
    0x973e0200000a0ULL,
    0x98570100000f0ULL,
    0x3920828000038ULL,
    0x7f5f43c000044ULL,
    0x91aaa0e0000daULL,
    0x1883110000e5ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0xd000000000000ULL,
    0x5800000000000ULL,
    0x4400000000000ULL,
    0x3200000000000ULL,
    0x8700000000000ULL,
    0xc980000000000ULL,
    0x8b40000000000ULL,
    0xb320000000000ULL,
    0xb410000000000ULL,
    0xfa08000000000ULL,
    0x3b14000000000ULL,
    0x6f9a000000000ULL,
    0x664b000000000ULL,
    0xb9a8800000000ULL,
    0xc4d6400000000ULL,
    0x4578e00000000ULL,
    0xf5bd300000000ULL,
    0xaad3680000000ULL,
    0x1461640000000ULL,
    0x5920020000000ULL,
    0x3710010000000ULL,
    0xa188028000000ULL,
    0xe754034000000ULL,
    0x4d3a016000000ULL,
    0x1d1b011000000ULL,
    0xc28080c800000ULL,
    0xccd2421c00000ULL,
    0x196ae32600000ULL,
    0x23a2322d00000ULL,
    0xcfc1eacc80000ULL,
    0x2ec26d040000ULL,
    0x5ff861e820000ULL,
    0x3d6f71ec50000ULL,
    0x21b98b3e68000ULL,
    0x60c356d92c000ULL,
    0x761e986a2000ULL,
    0xfabc270359000ULL,
    0x7f50615de3800ULL,
    0xe92b738af4c00ULL,
    0x5f0b8a6d4da00ULL,
    0xcd8c542c85900ULL,
    0x195b680000080ULL,
    0xe435640000040ULL,
    0x259a0200000a0ULL,
    0x354b0100000d0ULL,
    0xba28828000058ULL,
    0x5c96434000044ULL,
    0x55d8e16000032ULL,
    0x9ed311000087ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x1000000000000ULL,
    0x800000000000ULL,
    0xf400000000000ULL,
    0x8600000000000ULL,
    0xd700000000000ULL,
    0x5e80000000000ULL,
    0xec40000000000ULL,
    0x9b60000000000ULL,
    0xe610000000000ULL,
    0x2718000000000ULL,
    0x6684000000000ULL,
    0x42000000000ULL,
    0xe161000000000ULL,
    0x430e800000000ULL,
    0x2888c00000000ULL,
    0x35ee00000000ULL,
    0x29e9d00000000ULL,
    0x704c880000000ULL,
    0x1975ec0000000ULL,
    0x8f18020000000ULL,
    0x4284030000000ULL,
    0xae42008000000ULL,
    0xd261004000000ULL,
    0x938e802000000ULL,
    0xe7c8c3d000000ULL,
    0x40bee21800000ULL,
    0xf4b9d35c00000ULL,
    0x92b4897a00000ULL,
    0x75a1efb100000ULL,
    0x3322006d80000ULL,
    0x2371009840000ULL,
    0xca16801c60000ULL,
    0x7d0cc1da10000ULL,
    0xd39ce02108000ULL,
    0x7c8d05584000ULL,
    0x70a20b143a000ULL,
    0xecad2ffe23000ULL,
    0x6ebee3777b800ULL,
    0x7b9d016a7400ULL,
    0x62348b2cb2200ULL,
    0xaae1efbd97b00ULL,
    0x78c2008000080ULL,
    0xa210040000c0ULL,
    0xaeee802000020ULL,
    0xc6d8c3d000010ULL,
    0x3126e21800008ULL,
    0x8a7dd35c000f4ULL,
    0x8f96897a00086ULL,
    0xa5d0efb1000d7ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0xd000000000000ULL,
    0x8800000000000ULL,
    0x8400000000000ULL,
    0x1200000000000ULL,
    0xdd00000000000ULL,
    0xd680000000000ULL,
    0x3640000000000ULL,
    0xd1e0000000000ULL,
    0x5610000000000ULL,
    0x6f08000000000ULL,
    0x3b9c000000000ULL,
    0xb8da000000000ULL,
    0xebb1000000000ULL,
    0x11e0800000000ULL,
    0xf61a400000000ULL,
    0x5f0fa00000000ULL,
    0x639cd00000000ULL,
    0xb4cdc80000000ULL,
    0x7dbbbc0000000ULL,
    0xdee8020000000ULL,
    0xfd8c010000000ULL,
    0xbfd2038000000ULL,
    0x842d034000000ULL,
    0x333a822000000ULL,
    0x44ab421000000ULL,
    0x8a6f204800000ULL,
    0x7ec6937400000ULL,
    0xeca26b5a00000ULL,
    0x7e776cd900000ULL,
    0xd4cdc94780000ULL,
    0xedbbbc5840000ULL,
    0xb6e8003c20000ULL,
    0xa98c02ae70000ULL,
    0x25d2034368000ULL,
    0xdd2d02fec4000ULL,
    0xf7ba822f82000ULL,
    0xafeb42bc69000ULL,
    0x8d0f226e3e800ULL,
    0x1e96922373400ULL,
    0x524a6aceb7200ULL,
    0x13fb6c77aef00ULL,
    0x31fcb8000080ULL,
    0x3d96bf4000040ULL,
    0x1fd28020000e0ULL,
    0xb4274310000d0ULL,
    0x6b3d23c800088ULL,
    0x48ab903400084ULL,
    0x1c78e97a00012ULL,
    0xb1cc2ec9000ddULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0xb000000000000ULL,
    0xd800000000000ULL,
    0xc00000000000ULL,
    0x1e00000000000ULL,
    0x5d00000000000ULL,
    0x2e80000000000ULL,
    0xd840000000000ULL,
    0x8320000000000ULL,
    0xf210000000000ULL,
    0xb308000000000ULL,
    0xcb8c000000000ULL,
    0x4ad6000000000ULL,
    0x9d7b000000000ULL,
    0x2031800000000ULL,
    0x719bc00000000ULL,
    0xfdcfa00000000ULL,
    0x2cffd00000000ULL,
    0xfde6080000000ULL,
    0x8d72e40000000ULL,
    0x6828020000000ULL,
    0x759c010000000ULL,
    0x87de018000000ULL,
    0xbbf702c000000ULL,
    0x9c67836000000ULL,
    0x38a0c03000000ULL,
    0x40de207800000ULL,
    0xf274117400000ULL,
    0x9da1a8ba00000ULL,
    0xb241376100000ULL,
    0x5c38080c80000ULL,
    0x9785e6c840000ULL,
    0x7ccf814c20000ULL,
    0x747cc0ee30000ULL,
    0xaca023cb58000ULL,
    0x32d31085ec000ULL,
    0x16e2b98c6000ULL,
    0x363df4826f000ULL,
    0x489829353e800ULL,
    0x1956f7a6ff400ULL,
    0xbba1aac118200ULL,
    0x1341355c8b900ULL,
    0xd4b8098000080ULL,
    0xaec5e6c000040ULL,
    0x176f816000060ULL,
    0xf2cc130000b0ULL,
    0xac0821f8000d8ULL,
    0x8e0f13b40000cULL,
    0x55102bda0001eULL,
    0x4a9af7510005dULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x7000000000000ULL,
    0xc800000000000ULL,
    0xa400000000000ULL,
    0xf200000000000ULL,
    0x2300000000000ULL,
    0xba80000000000ULL,
    0x5ec0000000000ULL,
    0xc160000000000ULL,
    0x1e10000000000ULL,
    0xb518000000000ULL,
    0x8b9c000000000ULL,
    0xb74e000000000ULL,
    0xed39000000000ULL,
    0x25a4800000000ULL,
    0x9876400000000ULL,
    0x390600000000ULL,
    0x335d500000000ULL,
    0x8f20d80000000ULL,
    0xbeabac0000000ULL,
    0x4ef8020000000ULL,
    0xb4c030000000ULL,
    0x2336038000000ULL,
    0x8b501c000000ULL,
    0xeff2832000000ULL,
    0x5ad3429000000ULL,
    0x637ae3c800000ULL,
    0x6512108c00000ULL,
    0x13943aea00000ULL,
    0x4b40bd7b00000ULL,
    0x328b90580000ULL,
    0x98aaff7840000ULL,
    0x57f6db5460000ULL,
    0x36ceacee70000ULL,
    0x3572807d38000ULL,
    0xb41343e4e4000ULL,
    0x8a1ae3fe92000ULL,
    0xaf0211bdd9000ULL,
    0x9c8c3a0c41800ULL,
    0x47dcbfaa75400ULL,
    0xfce6ba1b03600ULL,
    0x853fc75eeb00ULL,
    0x9b25b8000080ULL,
    0xee68edc0000c0ULL,
    0x429ae120000e0ULL,
    0x12c2119000070ULL,
    0x76c3848000c8ULL,
    0x770cbd4c000a4ULL,
    0x409ebbca000f2ULL,
    0x39dffceb00023ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x9000000000000ULL,
    0x5800000000000ULL,
    0x8c00000000000ULL,
    0x5a00000000000ULL,
    0xcd00000000000ULL,
    0x7880000000000ULL,
    0x240000000000ULL,
    0x760000000000ULL,
    0x5e10000000000ULL,
    0xe318000000000ULL,
    0x938c000000000ULL,
    0x25d2000000000ULL,
    0x64ab000000000ULL,
    0xf5a1800000000ULL,
    0x2f23400000000ULL,
    0x9c7da00000000ULL,
    0x7199100000000ULL,
    0x34cd480000000ULL,
    0x7e246c0000000ULL,
    0x26f8020000000ULL,
    0x52dc030000000ULL,
    0x812a018000000ULL,
    0xb777024000000ULL,
    0x360b816000000ULL,
    0xc714423000000ULL,
    0x8d96216800000ULL,
    0x66dd533400000ULL,
    0x72369e200000ULL,
    0x18653c0900000ULL,
    0x9f916a1d80000ULL,
    0xbfde3e7840000ULL,
    0xc9a8e80c60000ULL,
    0x1d317f0e30000ULL,
    0x75674a7748000ULL,
    0x17136ee2ac000ULL,
    0x7593805e86000ULL,
    0x1ad840f88d000ULL,
    0x9524221bf6800ULL,
    0x166528b64400ULL,
    0x311ae924b5200ULL,
    0x2a8a7d8dd1b00ULL,
    0x7b5ec98000080ULL,
    0x39fc2e40000c0ULL,
    0x935c236000060ULL,
    0xddfa513000090ULL,
    0xed50e8e800058ULL,
    0xeed7d740008cULL,
    0xd6cd4a820005aULL,
    0x6f246d39000cdULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x7000000000000ULL,
    0x1800000000000ULL,
    0xcc00000000000ULL,
    0xe00000000000ULL,
    0xb100000000000ULL,
    0x1a80000000000ULL,
    0xf3c0000000000ULL,
    0xb20000000000ULL,
    0x6110000000000ULL,
    0xb298000000000ULL,
    0x7c4000000000ULL,
    0xb92e000000000ULL,
    0xc613000000000ULL,
    0xd501800000000ULL,
    0xe085c00000000ULL,
    0xf0d8200000000ULL,
    0xb6a0500000000ULL,
    0xf557f80000000ULL,
    0x5ef8a40000000ULL,
    0x2f2e020000000ULL,
    0x7b13030000000ULL,
    0xe181808000000ULL,
    0xd245c1c000000ULL,
    0xf978206000000ULL,
    0xe870533000000ULL,
    0x42eff83800000ULL,
    0x892ca6c400000ULL,
    0x3e18026a00000ULL,
    0x490400cf00000ULL,
    0x868e00ac80000ULL,
    0x95c3004440000ULL,
    0x6e3982aa60000ULL,
    0xb991c32f10000ULL,
    0xfe4e22dcb8000ULL,
    0xa76751dc4c000ULL,
    0x31607b3e06000ULL,
    0x8c6a644d17000ULL,
    0xb8f9a1efe0800ULL,
    0x8a35905ec1400ULL,
    0x8397d99f3fe00ULL,
    0xdd5cf4a4f2900ULL,
    0x6af7f83800080ULL,
    0xbd28a6c4000c0ULL,
    0xac16026a00020ULL,
    0x9e0700cf00070ULL,
    0xf91780ac80018ULL,
    0xbe82c044400ccULL,
    0x29cfa2aa6000eULL,
    0x7822932f100b1ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x5000000000000ULL,
    0xd800000000000ULL,
    0x400000000000ULL,
    0xe200000000000ULL,
    0xe700000000000ULL,
    0x9580000000000ULL,
    0xbdc0000000000ULL,
    0x6ba0000000000ULL,
    0xdf10000000000ULL,
    0x8188000000000ULL,
    0xe7cc000000000ULL,
    0xd8aa000000000ULL,
    0x708b000000000ULL,
    0xdf48800000000ULL,
    0xfbf0400000000ULL,
    0x5d66e00000000ULL,
    0xf31b00000000ULL,
    0x5a43380000000ULL,
    0xc97f340000000ULL,
    0x152a020000000ULL,
    0x894b010000000ULL,
    0x36e8818000000ULL,
    0x93e0414000000ULL,
    0x916ee36000000ULL,
    0x513db01000000ULL,
    0xb493b8800000ULL,
    0x81e4379c00000ULL,
    0xde6a805600000ULL,
    0x28b743f700000ULL,
    0xd884602e80000ULL,
    0x334af23c40000ULL,
    0x95ed596620000ULL,
    0x847ec78f30000ULL,
    0x9bafdaeaa8000ULL,
    0x7715875e2c000ULL,
    0x6d89baab22000ULL,
    0x89d87558c1000ULL,
    0x1a6603b1b800ULL,
    0xe40df31086c00ULL,
    0xf20fda072ce00ULL,
    0x5f058676ccd00ULL,
    0xc181bb8800080ULL,
    0x87d4779c00040ULL,
    0x88ac605600060ULL,
    0xa896f3f700050ULL,
    0xdb4f582e800d8ULL,
    0x19f9c63c40004ULL,
    0xba6d5b66200e2ULL,
    0x9abec68f300e7ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0xf000000000000ULL,
    0xc800000000000ULL,
    0x7400000000000ULL,
    0xa00000000000ULL,
    0xff00000000000ULL,
    0x4580000000000ULL,
    0xdec0000000000ULL,
    0xfde0000000000ULL,
    0xe710000000000ULL,
    0xa998000000000ULL,
    0xf8cc000000000ULL,
    0x44fe000000000ULL,
    0xeb89000000000ULL,
    0xb3d6800000000ULL,
    0x6b6d400000000ULL,
    0x3a51e00000000ULL,
    0xc3a9b00000000ULL,
    0x26a9580000000ULL,
    0x6428fc0000000ULL,
    0x237e020000000ULL,
    0x8e49030000000ULL,
    0xa9b6818000000ULL,
    0x29bd43c000000ULL,
    0xe9a9e32000000ULL,
    0x89b5b1d000000ULL,
    0x79af582800000ULL,
    0xb1bdfffc00000ULL,
    0xc5ae831600000ULL,
    0xcfb1407b00000ULL,
    0x30b7e27780000ULL,
    0x752cb05c40000ULL,
    0xabe1d98660000ULL,
    0x561cbe3330000ULL,
    0xb101633bf8000ULL,
    0x1891f35224000ULL,
    0xe0483a595a000ULL,
    0xa4a90d16b5000ULL,
    0x4f2e3a3ec7800ULL,
    0xfcec0e42e6c00ULL,
    0x9786b994c5600ULL,
    0xadc84d4f93f00ULL,
    0x6e61d82800080ULL,
    0x48dcbffc000c0ULL,
    0x2ce1631600060ULL,
    0xf81f07b000f0ULL,
    0x81d03a77800c8ULL,
    0x28650c5c40074ULL,
    0x1d03b866000aULL,
    0xe8650d33300ffULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x1000000000000ULL,
    0x6800000000000ULL,
    0x2400000000000ULL,
    0xda00000000000ULL,
    0xc100000000000ULL,
    0xd180000000000ULL,
    0x17c0000000000ULL,
    0x220000000000ULL,
    0x7510000000000ULL,
    0xa398000000000ULL,
    0xd2c4000000000ULL,
    0x19a2000000000ULL,
    0xcbdd000000000ULL,
    0x543c800000000ULL,
    0x6a0f400000000ULL,
    0x7902200000000ULL,
    0xbd93300000000ULL,
    0xf9c4780000000ULL,
    0x7136040000000ULL,
    0x4182020000000ULL,
    0xbfcd030000000ULL,
    0x624808000000ULL,
    0xbf0b404000000ULL,
    0xa8021a000000ULL,
    0x275e309000000ULL,
    0xd460fb6800000ULL,
    0x8fd470400000ULL,
    0xf0a2214600000ULL,
    0xde43335f00000ULL,
    0xa9fc788880000ULL,
    0xd122059440000ULL,
    0x9198012e60000ULL,
    0xf7c400db10000ULL,
    0x3222038e88000ULL,
    0xd1d006b74000ULL,
    0xef9c83b6f2000ULL,
    0x2cdf41673d000ULL,
    0x2ba228488800ULL,
    0xdb4730260cc00ULL,
    0x927e7a2f71e00ULL,
    0x7fef06d0c8100ULL,
    0xe3c836800080ULL,
    0x6b0f4304000c0ULL,
    0x8882234600020ULL,
    0xba53305f00010ULL,
    0x93e4780880068ULL,
    0x202605d440024ULL,
    0x381a008e600daULL,
    0xac09004b100c1ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x9000000000000ULL,
    0x1800000000000ULL,
    0x1c00000000000ULL,
    0x3a00000000000ULL,
    0x2900000000000ULL,
    0x4380000000000ULL,
    0xd1c0000000000ULL,
    0x6c60000000000ULL,
    0xad10000000000ULL,
    0x2588000000000ULL,
    0x22dc000000000ULL,
    0x96f2000000000ULL,
    0x2753000000000ULL,
    0x842b800000000ULL,
    0xd9ab400000000ULL,
    0x376f200000000ULL,
    0x638f700000000ULL,
    0xe1dfb80000000ULL,
    0x467cc0000000ULL,
    0x3912020000000ULL,
    0x1b83010000000ULL,
    0x2dc3838000000ULL,
    0xc667424000000ULL,
    0x9c15206000000ULL,
    0x7a00707000000ULL,
    0xc90638e800000ULL,
    0xd39f8ca400000ULL,
    0xc9d6a30e00000ULL,
    0x7067324700000ULL,
    0x97131a3180000ULL,
    0xc9ffcf440000ULL,
    0x61509af620000ULL,
    0x4738bdfb70000ULL,
    0x4b25bb33c8000ULL,
    0x2928cf794c000ULL,
    0xfc2b82feae000ULL,
    0x15ab4311ad000ULL,
    0xf56f22643c800ULL,
    0xc68f71ae7dc00ULL,
    0x805fba975ee00ULL,
    0xe0a7cf09ef300ULL,
    0x2cf200e800080ULL,
    0x4e5300a400040ULL,
    0x27ab810e000e0ULL,
    0x986b434700090ULL,
    0x430f21b180018ULL,
    0xd29f72b44001cULL,
    0xfe57b8962003aULL,
    0xfbbcc8b70029ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x9000000000000ULL,
    0xc800000000000ULL,
    0xc400000000000ULL,
    0xf600000000000ULL,
    0xd900000000000ULL,
    0x3880000000000ULL,
    0xe340000000000ULL,
    0x1ae0000000000ULL,
    0x9f10000000000ULL,
    0x1988000000000ULL,
    0xa7dc000000000ULL,
    0x93b2000000000ULL,
    0xa6e9000000000ULL,
    0x5500800000000ULL,
    0x4a8ac00000000ULL,
    0x2c55200000000ULL,
    0x6b6c100000000ULL,
    0x8ccde80000000ULL,
    0x242d1c0000000ULL,
    0xd43a020000000ULL,
    0xcc35010000000ULL,
    0x2032838000000ULL,
    0x8223c24000000ULL,
    0x6535a32000000ULL,
    0x40b6d31000000ULL,
    0x6d70cbd800000ULL,
    0x4dcd0f6400000ULL,
    0xf0adeae200000ULL,
    0x957d1e8d00000ULL,
    0x31d201eb80000ULL,
    0x9ab9013c40000ULL,
    0xb66880c620000ULL,
    0xe246c3cf70000ULL,
    0x6e6f22b6c8000ULL,
    0xae5912efa4000ULL,
    0xbc7f6a6e02000ULL,
    0x114eddc32b000ULL,
    0x95efa238d4800ULL,
    0xe93d15cf0400ULL,
    0x9a4a49be97a00ULL,
    0x5272ce3384700ULL,
    0x244a485800080ULL,
    0xf72cd2400040ULL,
    0xaca49c2000e0ULL,
    0xa532cd9d00090ULL,
    0xe0aa4a33800c8ULL,
    0x1d62ce58400c4ULL,
    0x15c24a24200f6ULL,
    0xfcaecd42700d9ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x3000000000000ULL,
    0xb800000000000ULL,
    0x3c00000000000ULL,
    0x5600000000000ULL,
    0x8500000000000ULL,
    0x6c80000000000ULL,
    0x51c0000000000ULL,
    0x70a0000000000ULL,
    0xeb10000000000ULL,
    0x9588000000000ULL,
    0x8b5c000000000ULL,
    0x9466000000000ULL,
    0x4f27000000000ULL,
    0x135f800000000ULL,
    0x387ec00000000ULL,
    0x713aa00000000ULL,
    0x2244900000000ULL,
    0x86eeb80000000ULL,
    0xcfe9540000000ULL,
    0xed6e020000000ULL,
    0xd5bb010000000ULL,
    0x1799838000000ULL,
    0xac49c0c000000ULL,
    0x4fed22e000000ULL,
    0xad6650f000000ULL,
    0x35b2195800000ULL,
    0x278ac61400000ULL,
    0x145f3bb200000ULL,
    0x73ec944700000ULL,
    0xfb6d204280000ULL,
    0xb0a6526c40000ULL,
    0x4b121b3620000ULL,
    0x459ac61d70000ULL,
    0x3573be998000ULL,
    0x107096d89c000ULL,
    0x252b21277e000ULL,
    0xc0515272fb000ULL,
    0xd1e598d46a800ULL,
    0x4c68065252400ULL,
    0x32398371ae00ULL,
    0x1d5f055a95500ULL,
    0xb1741ad800080ULL,
    0xf3bdc6d400040ULL,
    0xca88b952000e0ULL,
    0xccce54b700030ULL,
    0xf031811a800b8ULL,
    0x64c5c0784003cULL,
    0xe423228420056ULL,
    0x66cd535a70085ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x3000000000000ULL,
    0x6800000000000ULL,
    0xd400000000000ULL,
    0x7e00000000000ULL,
    0x7b00000000000ULL,
    0xee80000000000ULL,
    0xb1c0000000000ULL,
    0xad60000000000ULL,
    0x5110000000000ULL,
    0xab88000000000ULL,
    0x444c000000000ULL,
    0xc226000000000ULL,
    0x25bd000000000ULL,
    0x83e2800000000ULL,
    0xc0dbc00000000ULL,
    0x56ed600000000ULL,
    0x4d4ad00000000ULL,
    0xd5afb80000000ULL,
    0xcbf1ec0000000ULL,
    0x44ce020000000ULL,
    0x70e1010000000ULL,
    0x8a4c818000000ULL,
    0x912ac0c000000ULL,
    0x7f29e1a000000ULL,
    0x7c2c135000000ULL,
    0x7ea059f800000ULL,
    0x3d60fdec00000ULL,
    0x290cd9ba00000ULL,
    0x479a3fc700000ULL,
    0xb64d393580000ULL,
    0x7b2a2c8440000ULL,
    0x1a23608e20000ULL,
    0xd9abd38130000ULL,
    0x49e33ad098000ULL,
    0xf5db2eeaf4000ULL,
    0xab67e3ed8a000ULL,
    0xc60d12786f000ULL,
    0xb70cd82c35800ULL,
    0x4c9a3f9a6b400ULL,
    0x50cd3b571ee00ULL,
    0x2eea2fedb7b00ULL,
    0xa143607800080ULL,
    0x27bbd12c00040ULL,
    0x72eb3a1a00060ULL,
    0x7b572d9700030ULL,
    0x2aa1e14d80068ULL,
    0x36011a8400d4ULL,
    0x320658942007eULL,
    0x991dff163007bULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0xf000000000000ULL,
    0x3800000000000ULL,
    0x7400000000000ULL,
    0x9600000000000ULL,
    0x7700000000000ULL,
    0x5a80000000000ULL,
    0xef40000000000ULL,
    0x1ee0000000000ULL,
    0x3510000000000ULL,
    0x6b88000000000ULL,
    0x6acc000000000ULL,
    0x173e000000000ULL,
    0x1eb7000000000ULL,
    0xd576800000000ULL,
    0x8fc6c00000000ULL,
    0xd4b4e00000000ULL,
    0xc86e500000000ULL,
    0x1852680000000ULL,
    0x47c9c0000000ULL,
    0xba56020000000ULL,
    0x856b010000000ULL,
    0x67c0818000000ULL,
    0x8bdc3c000000ULL,
    0xe27c60e000000ULL,
    0xb55f91d000000ULL,
    0xcbf00a5800000ULL,
    0xee840ddc00000ULL,
    0x59588b6a00000ULL,
    0xf9e5cebd00000ULL,
    0xa792ebfb80000ULL,
    0xc8c15e1440000ULL,
    0x962a62ce20000ULL,
    0xc33492bb30000ULL,
    0x58b08b64f8000ULL,
    0xa79cfb6dc000ULL,
    0x6944ea87da000ULL,
    0xe1ea5c8e1b000ULL,
    0x438ae39b53800ULL,
    0x96d95354f9400ULL,
    0xad24e9bee9a00ULL,
    0x7bba5cc382700ULL,
    0x56e2e3d800080ULL,
    0x3905521c00040ULL,
    0xe992e98a00060ULL,
    0x7bc15e6d000f0ULL,
    0x2aa602380038ULL,
    0xdf74900840074ULL,
    0xb2d0894420096ULL,
    0xd329cdd630077ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0xb000000000000ULL,
    0xd800000000000ULL,
    0x6400000000000ULL,
    0xda00000000000ULL,
    0x9700000000000ULL,
    0x8580000000000ULL,
    0x18c0000000000ULL,
    0xb6a0000000000ULL,
    0x5910000000000ULL,
    0x7088000000000ULL,
    0xfe44000000000ULL,
    0x99f6000000000ULL,
    0xdc6b000000000ULL,
    0xa4b4800000000ULL,
    0x8207400000000ULL,
    0xb308e00000000ULL,
    0x7f99b00000000ULL,
    0x3fc2980000000ULL,
    0xeb3a140000000ULL,
    0x25de020000000ULL,
    0x1c3f010000000ULL,
    0x304a808000000ULL,
    0x6ce842c000000ULL,
    0x3aea636000000ULL,
    0x8be5f19000000ULL,
    0x776fb6800000ULL,
    0x6720e65c00000ULL,
    0x3c2781600000ULL,
    0x1527a56300000ULL,
    0x48ca985a80000ULL,
    0xbebe16a440000ULL,
    0x7508002220000ULL,
    0xa68401a910000ULL,
    0xf5602efd8000ULL,
    0x357b027dac000ULL,
    0xc3c808cd2000ULL,
    0x184341a71d000ULL,
    0xf0fee168a3800ULL,
    0x34f2b2a526c00ULL,
    0x1ef619f1aa600ULL,
    0x71fd5552b8500ULL,
    0x2076e3e800080ULL,
    0x3ab6b09c00040ULL,
    0x7f00197600020ULL,
    0x799655f3000b0ULL,
    0x86c263b2800d8ULL,
    0x4bb1f23840064ULL,
    0x9388fb54200daULL,
    0x89cfe55a10097ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0xf000000000000ULL,
    0x2800000000000ULL,
    0x1400000000000ULL,
    0x6a00000000000ULL,
    0x9100000000000ULL,
    0x580000000000ULL,
    0xb540000000000ULL,
    0xbba0000000000ULL,
    0xa710000000000ULL,
    0xda98000000000ULL,
    0x83dc000000000ULL,
    0x7e7e000000000ULL,
    0xee75000000000ULL,
    0xf66a800000000ULL,
    0x2a79400000000ULL,
    0xa478200000000ULL,
    0x776fb00000000ULL,
    0xf7fb280000000ULL,
    0x2d37b40000000ULL,
    0xb2c6020000000ULL,
    0xabf9030000000ULL,
    0x632c838000000ULL,
    0x81c043c000000ULL,
    0xdb74a0a000000ULL,
    0x91fff05000000ULL,
    0xa3789a800000ULL,
    0xa844464400000ULL,
    0xc8378a1600000ULL,
    0xed4445d500000ULL,
    0x47b78b6e80000ULL,
    0x3904465c40000ULL,
    0xd1978a4a60000ULL,
    0x3f54469f70000ULL,
    0xdaaf8971f8000ULL,
    0x8a98456dd4000ULL,
    0x7bc98b47aa000ULL,
    0x527144a8e5000ULL,
    0x487d08e160800ULL,
    0x316d0740fec00ULL,
    0xc0f7aac50ca00ULL,
    0xefa7f426eed00ULL,
    0xed0aa22800080ULL,
    0x5b8af184000c0ULL,
    0x5e5d08b6000e0ULL,
    0xf73d0685000f0ULL,
    0x2bcfa94680028ULL,
    0xaa6bf7d840014ULL,
    0x646ca2fc6006aULL,
    0x9763f01a70091ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x1000000000000ULL,
    0x4800000000000ULL,
    0xac00000000000ULL,
    0x8e00000000000ULL,
    0xe500000000000ULL,
    0x4e80000000000ULL,
    0x97c0000000000ULL,
    0xe560000000000ULL,
    0x3e90000000000ULL,
    0xfd8000000000ULL,
    0xe17c000000000ULL,
    0xc92000000000ULL,
    0x2cd1000000000ULL,
    0xe6e9800000000ULL,
    0x5bc3c00000000ULL,
    0xbb6da00000000ULL,
    0x7390500000000ULL,
    0xfd59380000000ULL,
    0xb0b50c0000000ULL,
    0xa0e9820000000ULL,
    0xd2c3c30000000ULL,
    0x9beda38000000ULL,
    0x1150504000000ULL,
    0x1eb9392000000ULL,
    0xb5e50eb000000ULL,
    0xc451803800000ULL,
    0xe82fc09400000ULL,
    0xd627a2ba00000ULL,
    0x4b3d521f00000ULL,
    0x11a2bab580000ULL,
    0xfc67ce4a40000ULL,
    0x960da00760000ULL,
    0x21005311f0000ULL,
    0x9c813a8848000ULL,
    0xa4c90eac44000ULL,
    0xaafb832e26000ULL,
    0xc5d2c0254f000ULL,
    0x1664236ad6800ULL,
    0x9103919fb1400ULL,
    0xe48c9bdd2ce00ULL,
    0xb0c95e9e90300ULL,
    0xd0fabab580080ULL,
    0x4adbce4a400c0ULL,
    0x9fffa007600e0ULL,
    0x23415311f0010ULL,
    0x3db0ba8848048ULL,
    0xb276ceac440acULL,
    0x9304232e2608eULL,
    0x7f9390254f0e5ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0xd000000000000ULL,
    0xc800000000000ULL,
    0x400000000000ULL,
    0xa00000000000ULL,
    0x1b00000000000ULL,
    0xeb80000000000ULL,
    0x5740000000000ULL,
    0xfe0000000000ULL,
    0x6390000000000ULL,
    0xf358000000000ULL,
    0xb5ec000000000ULL,
    0x608a000000000ULL,
    0xd4c1000000000ULL,
    0xecac800000000ULL,
    0x7e6b400000000ULL,
    0x47d2600000000ULL,
    0xa329f00000000ULL,
    0x932da80000000ULL,
    0x4b299c0000000ULL,
    0xe72c820000000ULL,
    0x392b430000000ULL,
    0xe032618000000ULL,
    0x14b9f34000000ULL,
    0xa275ab2000000ULL,
    0xe1c59c1000000ULL,
    0x6626822800000ULL,
    0xa1aa436c00000ULL,
    0xe8fee22e00000ULL,
    0x5e02b21d00000ULL,
    0x191fcb1f80000ULL,
    0x94906d9e40000ULL,
    0x66d929e560000ULL,
    0x8baeddbbb0000ULL,
    0x83f4e1ac28000ULL,
    0xcd83b24e04000ULL,
    0x5253492d32000ULL,
    0x5d6b2f27ed000ULL,
    0x10534bda29800ULL,
    0x826b2f2717c00ULL,
    0x91d34bc89ea00ULL,
    0x1e2b2f0ea2700ULL,
    0xbdb34b1f80080ULL,
    0x2efb2d9e400c0ULL,
    0x4b0b49e560060ULL,
    0xe3872dbbb00d0ULL,
    0x335949ac280c8ULL,
    0xd5ea2e4e04004ULL,
    0xb09fcb2d3200aULL,
    0x1cd06c27ed01bULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0x1000000000000ULL,
    0xb800000000000ULL,
    0x9400000000000ULL,
    0x1200000000000ULL,
    0xdd00000000000ULL,
    0x8680000000000ULL,
    0xe040000000000ULL,
    0xd2a0000000000ULL,
    0xb290000000000ULL,
    0xa248000000000ULL,
    0x97a4000000000ULL,
    0xb012000000000ULL,
    0xe81f000000000ULL,
    0xc16800000000ULL,
    0x9600400000000ULL,
    0x770ca00000000ULL,
    0xcf82500000000ULL,
    0x74de480000000ULL,
    0xefe1f40000000ULL,
    0xe6b6820000000ULL,
    0xf090410000000ULL,
    0xe744a08000000ULL,
    0x9526504000000ULL,
    0xfa4c4ae000000ULL,
    0x73bef65000000ULL,
    0x2a00024800000ULL,
    0x900027400000ULL,
    0xb480029a00000ULL,
    0x2d4003c100000ULL,
    0xec2001aa80000ULL,
    0xc6d0009a40000ULL,
    0x62e802c120000ULL,
    0xf834012a90000ULL,
    0x94da00da48000ULL,
    0x9ffb00217c000ULL,
    0x6ea4837ada000ULL,
    0xcc8f409241000ULL,
    0xd952235512800ULL,
    0xce26116099400ULL,
    0xb3c0eb1331200ULL,
    0xc87ca41ffbd00ULL,
    0x9e7e49aa80080ULL,
    0x8971f49a40040ULL,
    0x76fe80c120020ULL,
    0xaa34402a90010ULL,
    0x69d6a05a480b8ULL,
    0x97950617c094ULL,
    0x36fac99ada012ULL,
    0x8a2eb6c2410ddULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x3000000000000ULL,
    0xf800000000000ULL,
    0x7400000000000ULL,
    0x6600000000000ULL,
    0x1300000000000ULL,
    0x9b80000000000ULL,
    0x8a40000000000ULL,
    0xf620000000000ULL,
    0x5f90000000000ULL,
    0x5448000000000ULL,
    0xf12c000000000ULL,
    0x9216000000000ULL,
    0x3517000000000ULL,
    0xe882800000000ULL,
    0x21cac00000000ULL,
    0x847d600000000ULL,
    0xddadf00000000ULL,
    0x6dc5880000000ULL,
    0xb678a40000000ULL,
    0xf8a2820000000ULL,
    0x2d5ac10000000ULL,
    0x2bb5618000000ULL,
    0x96c1f0c000000ULL,
    0xf1f38be000000ULL,
    0xa8ffa5d000000ULL,
    0x2268039800000ULL,
    0xeebc014c00000ULL,
    0xa65e03ee00000ULL,
    0xf43b02e900000ULL,
    0x8294803880000ULL,
    0x60ddc0ae40000ULL,
    0xaffe0c920000ULL,
    0xef673388b0000ULL,
    0x7238e82658000ULL,
    0xe19556fd5c000ULL,
    0x63470a7a8a000ULL,
    0xc4b264f96b000ULL,
    0x875fe0c0d5800ULL,
    0x4ab7317207c00ULL,
    0x4850e99f4e200ULL,
    0xb29571dbe900ULL,
    0x3b19083880080ULL,
    0x678964ae40040ULL,
    0x4b62c920060ULL,
    0xc72af288b0030ULL,
    0x490f09a6580f8ULL,
    0x229e663d5c074ULL,
    0x70c9e19a8a066ULL,
    0xa2e031296b013ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x5000000000000ULL,
    0x2800000000000ULL,
    0xdc00000000000ULL,
    0x2200000000000ULL,
    0x2700000000000ULL,
    0xed80000000000ULL,
    0xa7c0000000000ULL,
    0xbf20000000000ULL,
    0x990000000000ULL,
    0x51d8000000000ULL,
    0xd63c000000000ULL,
    0x991a000000000ULL,
    0xc89d000000000ULL,
    0xdd47800000000ULL,
    0x8d6e400000000ULL,
    0xe571e00000000ULL,
    0x196e300000000ULL,
    0x8b64b80000000ULL,
    0xd46d040000000ULL,
    0xcde7820000000ULL,
    0x943e430000000ULL,
    0x2e09e38000000ULL,
    0xed02314000000ULL,
    0xf686b8a000000ULL,
    0x385c077000000ULL,
    0x17e2028800000ULL,
    0x8731039c00000ULL,
    0xdd85803600000ULL,
    0x1fcf43df00000ULL,
    0xab2c625c80000ULL,
    0xa79d735640000ULL,
    0x7cd2d9cf60000ULL,
    0xc0ad77c4f0000ULL,
    0xf152dbd268000ULL,
    0xf76d76bd74000ULL,
    0x8672d8099e000ULL,
    0x72fd7453f9000ULL,
    0xddaadbf2a7800ULL,
    0x5fc1760d48c00ULL,
    0x8b30d9e1fae00ULL,
    0x179c75dfc0100ULL,
    0x4d75a5c80080ULL,
    0x34a23756400c0ULL,
    0xf5ebbcf600e0ULL,
    0xf26004c4f0050ULL,
    0x4cf8005268028ULL,
    0x38ac03fd740dcULL,
    0xc54202a99e022ULL,
    0xe9610023f9027ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x1000000000000ULL,
    0x800000000000ULL,
    0x8c00000000000ULL,
    0x5e00000000000ULL,
    0x1b00000000000ULL,
    0xda80000000000ULL,
    0x62c0000000000ULL,
    0xcc60000000000ULL,
    0x2e90000000000ULL,
    0xe8c8000000000ULL,
    0xed7c000000000ULL,
    0x2d12000000000ULL,
    0x1d89000000000ULL,
    0xe4d800000000ULL,
    0x29a9c00000000ULL,
    0x6e72600000000ULL,
    0x3392d00000000ULL,
    0x4d53980000000ULL,
    0x9724ec0000000ULL,
    0xcead820000000ULL,
    0xb2f9c10000000ULL,
    0x2e5a638000000ULL,
    0x99bed04000000ULL,
    0x9669982000000ULL,
    0xa781ee3000000ULL,
    0x975a037800000ULL,
    0x5e35016c00000ULL,
    0x513f80ea00000ULL,
    0x11b0c1cb00000ULL,
    0x5a77e31180000ULL,
    0x1987128a40000ULL,
    0x9c53fadb20000ULL,
    0x8caf3fd9f0000ULL,
    0xbffb99de48000ULL,
    0x83c8ecfd24000ULL,
    0x6ff78288b6000ULL,
    0x2bccc15ce7000ULL,
    0x13e5e1bae9800ULL,
    0x6dce110bbb400ULL,
    0x8cfe78d906600ULL,
    0x6556fc76b7b00ULL,
    0xab21fb1180080ULL,
    0x68b63e8a40040ULL,
    0x3dfe18db200e0ULL,
    0x2edd2ed9f0010ULL,
    0x3277e25e48008ULL,
    0xc58710bd2408cULL,
    0x2a53f8a8b605eULL,
    0xbaf3e6ce701bULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x3000000000000ULL,
    0x6800000000000ULL,
    0x5c00000000000ULL,
    0x5600000000000ULL,
    0x8700000000000ULL,
    0xa380000000000ULL,
    0x22c0000000000ULL,
    0x30a0000000000ULL,
    0x9590000000000ULL,
    0xd5c8000000000ULL,
    0x1b3c000000000ULL,
    0xdb56000000000ULL,
    0xdb65000000000ULL,
    0x55a7800000000ULL,
    0xfb14c00000000ULL,
    0x6589e00000000ULL,
    0x1dc5f00000000ULL,
    0x9725980000000ULL,
    0xd540740000000ULL,
    0x686f820000000ULL,
    0xfc28c10000000ULL,
    0x8dfe38000000ULL,
    0x71a0f0c000000ULL,
    0x90219a000000ULL,
    0x5094b57000000ULL,
    0x6b46635800000ULL,
    0xf37d331c00000ULL,
    0xe9b2790e00000ULL,
    0x9d1c844b00000ULL,
    0x8a9b9b6280000ULL,
    0xe249762640000ULL,
    0xe3f6038f20000ULL,
    0x62f503b0f0000ULL,
    0x5e6f83c358000ULL,
    0xb28c25694000ULL,
    0x235fe16c1e000ULL,
    0x3f60f2d613000ULL,
    0x7a2191707800ULL,
    0x1e04b68ce7c00ULL,
    0x4b0e617d4e600ULL,
    0x4d8133e5d5d00ULL,
    0xa1c478e280080ULL,
    0xf12986e640040ULL,
    0x3a541a2f200e0ULL,
    0x97f1b6c0f0030ULL,
    0x88e1e09b58068ULL,
    0xbf69f14a9405cULL,
    0x47bb98621e056ULL,
    0xfe19769d13087ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x3000000000000ULL,
    0x4800000000000ULL,
    0x6400000000000ULL,
    0xb600000000000ULL,
    0x1900000000000ULL,
    0xd680000000000ULL,
    0x36c0000000000ULL,
    0x4020000000000ULL,
    0xd090000000000ULL,
    0xa7d8000000000ULL,
    0x12bc000000000ULL,
    0x6056000000000ULL,
    0xb6f1000000000ULL,
    0x70a0800000000ULL,
    0x4758c00000000ULL,
    0xfd6e200000000ULL,
    0x16fc500000000ULL,
    0x60b7180000000ULL,
    0xdf5aa40000000ULL,
    0xe178820000000ULL,
    0x8ce4c30000000ULL,
    0xabb8238000000ULL,
    0xa6cd50c000000ULL,
    0x1837992000000ULL,
    0x2c92659000000ULL,
    0xdcea0d800000ULL,
    0x91a4936400000ULL,
    0x7dd938da00000ULL,
    0xf9a6f41b00000ULL,
    0xc9cf9a2080000ULL,
    0x37be65d240000ULL,
    0xfcc0a1c760000ULL,
    0x332993eef0000ULL,
    0x650fb87b58000ULL,
    0xbc9f3750c4000ULL,
    0x55d9393a02000ULL,
    0x6da6f4ab23000ULL,
    0xd7cf9968d8800ULL,
    0x7abe676e01400ULL,
    0xd440a2f904600ULL,
    0x78e9906fee900ULL,
    0x45afb9a080080ULL,
    0x43cf3512400c0ULL,
    0x64a138e7600e0ULL,
    0x994af67ef0030ULL,
    0x506198a358048ULL,
    0xe636434c4064ULL,
    0x636e21e0020b6ULL,
    0x9bfc50b023019ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x5000000000000ULL,
    0x6800000000000ULL,
    0x7400000000000ULL,
    0xee00000000000ULL,
    0xc900000000000ULL,
    0x8a80000000000ULL,
    0x2740000000000ULL,
    0xff60000000000ULL,
    0x8c90000000000ULL,
    0xda48000000000ULL,
    0xfbec000000000ULL,
    0x32da000000000ULL,
    0xc7a5000000000ULL,
    0x2432800000000ULL,
    0xf9efc00000000ULL,
    0x79c0200000000ULL,
    0x4631d00000000ULL,
    0xe2e2280000000ULL,
    0x90574c0000000ULL,
    0xf4fa820000000ULL,
    0x6543c10000000ULL,
    0xd47a218000000ULL,
    0x5d04d14000000ULL,
    0x7498a9a000000ULL,
    0xe6548dd000000ULL,
    0x51e0a1b800000ULL,
    0x2dd7122400000ULL,
    0x982a8baa00000ULL,
    0x13fc5ddd00000ULL,
    0x6c2085d80000ULL,
    0x49b69ee240000ULL,
    0xbd30ab5120000ULL,
    0x1b688c8bb0000ULL,
    0x2a92a0c168000ULL,
    0x574e121394000ULL,
    0xa76a08f54a000ULL,
    0xc08a9e61ff000ULL,
    0x2842a8bc20800ULL,
    0xa8f18d9e77400ULL,
    0x9f5222af60a00ULL,
    0xa378d09489300ULL,
    0x768aa9dd80080ULL,
    0xad5d8fa240040ULL,
    0xd06822f120060ULL,
    0xeb0dd15bb0050ULL,
    0xf190297968068ULL,
    0x9ece4c3794074ULL,
    0x25ba015f4a0eeULL,
    0x7f3502bcff0c9ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x3000000000000ULL,
    0xe800000000000ULL,
    0xe400000000000ULL,
    0x1a00000000000ULL,
    0x1100000000000ULL,
    0x5380000000000ULL,
    0xb8c0000000000ULL,
    0x80e0000000000ULL,
    0xd190000000000ULL,
    0xc5d8000000000ULL,
    0xbd74000000000ULL,
    0xba56000000000ULL,
    0xba5000000000ULL,
    0x79b8800000000ULL,
    0x4cad400000000ULL,
    0xa523200000000ULL,
    0x3cecf00000000ULL,
    0x793580000000ULL,
    0x8ad9bc0000000ULL,
    0xd5e0820000000ULL,
    0xa819430000000ULL,
    0x8415228000000ULL,
    0x8a19f0c000000ULL,
    0xc913dba000000ULL,
    0x5f90ff9000000ULL,
    0x46cda26800000ULL,
    0x8be4b34400000ULL,
    0x9308fbce00000ULL,
    0x2e980e2300000ULL,
    0x8550fba380000ULL,
    0xeb2c0fd640000ULL,
    0x1fe6fbff60000ULL,
    0x1190d71d0000ULL,
    0x4b86788758000ULL,
    0x14c04e9d94000ULL,
    0x4ef358ad62000ULL,
    0x3289be60f5000ULL,
    0x63588385ec800ULL,
    0x4c3d40f163c00ULL,
    0x937b20f295600ULL,
    0x958f0b4b2f00ULL,
    0xd525592380080ULL,
    0xb4ecbf16400c0ULL,
    0x7380005f600a0ULL,
    0x48c002e1d0030ULL,
    0xc8e002ef580e8ULL,
    0x59001d9940e4ULL,
    0x37d801636201aULL,
    0x48740343f5011ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x5000000000000ULL,
    0xe800000000000ULL,
    0x5400000000000ULL,
    0xbe00000000000ULL,
    0x1b00000000000ULL,
    0x7f80000000000ULL,
    0xa9c0000000000ULL,
    0xbf60000000000ULL,
    0x3d90000000000ULL,
    0xf8d8000000000ULL,
    0x55ec000000000ULL,
    0x48da000000000ULL,
    0x2de5000000000ULL,
    0x94d6800000000ULL,
    0x97e5c00000000ULL,
    0xd9c2600000000ULL,
    0xa777700000000ULL,
    0xb183f80000000ULL,
    0xaacc0c0000000ULL,
    0x4cee820000000ULL,
    0xc659c30000000ULL,
    0x5ea0618000000ULL,
    0xe6ee714000000ULL,
    0xc3577ba000000ULL,
    0xa20cd5000000ULL,
    0x88a060f800000ULL,
    0x69ee736c00000ULL,
    0x62d7787e00000ULL,
    0xe8e0cfe700000ULL,
    0xa040635d80000ULL,
    0xa9be72a640000ULL,
    0x9b6f789b60000ULL,
    0x9b9ccc7bb0000ULL,
    0x6fc2617d68000ULL,
    0x7877704094000ULL,
    0xf803fbd6da000ULL,
    0x1c0c0f85d7000ULL,
    0xda0e80da69800ULL,
    0x1d09c33d6dc00ULL,
    0xd8986260e7e00ULL,
    0x3c5273c6e4300ULL,
    0xb3b57add80080ULL,
    0xe679cfe6400c0ULL,
    0x1314e13b60060ULL,
    0xbb92b22bb0050ULL,
    0x9fc19805680e8ULL,
    0xa07b7e6c94054ULL,
    0x140d7a08da0beULL,
    0x1e05ce32d701bULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0xf000000000000ULL,
    0x4800000000000ULL,
    0x1400000000000ULL,
    0x2a00000000000ULL,
    0x4700000000000ULL,
    0x1e80000000000ULL,
    0xf040000000000ULL,
    0x9620000000000ULL,
    0x890000000000ULL,
    0xb958000000000ULL,
    0x4dbc000000000ULL,
    0x454e000000000ULL,
    0xa3b1000000000ULL,
    0x704e800000000ULL,
    0x5623400000000ULL,
    0xe88de00000000ULL,
    0x4947500000000ULL,
    0x5ae480000000ULL,
    0x5156a40000000ULL,
    0x89b6820000000ULL,
    0x374f430000000ULL,
    0x48bbe38000000ULL,
    0x18da53c000000ULL,
    0xdf76c92000000ULL,
    0xd38e45000000ULL,
    0xe81be2a800000ULL,
    0xc40a521c00000ULL,
    0x720ecbfa00000ULL,
    0xeb14e40100000ULL,
    0x688de17880000ULL,
    0x8947537240000ULL,
    0xe5ae49cd60000ULL,
    0xa156a7eaf0000ULL,
    0xc1b6824f38000ULL,
    0x234f421fc4000ULL,
    0x62bbe0b1ba000ULL,
    0x5fda53a6cd000ULL,
    0xc1f6c81d57800ULL,
    0xfd78e782ed400ULL,
    0x7e3be1f301200ULL,
    0xcc9a51f5de900ULL,
    0xcb56caf880080ULL,
    0xa6a8e4b2400c0ULL,
    0x2dc3e2ed600e0ULL,
    0x2af650baf00f0ULL,
    0x95e0cb6738048ULL,
    0xf775e7c3c4014ULL,
    0x293b606bba02aULL,
    0x6a0810f7cd047ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0xd000000000000ULL,
    0x7800000000000ULL,
    0xe400000000000ULL,
    0x4200000000000ULL,
    0x5d00000000000ULL,
    0xe580000000000ULL,
    0xd8c0000000000ULL,
    0x1be0000000000ULL,
    0xb90000000000ULL,
    0xebd8000000000ULL,
    0xd74000000000ULL,
    0x65ca000000000ULL,
    0x4e77000000000ULL,
    0xdb58800000000ULL,
    0xbc2a400000000ULL,
    0xd8e0a00000000ULL,
    0x7512300000000ULL,
    0xb990580000000ULL,
    0xdeda5c0000000ULL,
    0xd4e0820000000ULL,
    0xcb0e430000000ULL,
    0x3292a28000000ULL,
    0x8c41334000000ULL,
    0x28bad9e000000ULL,
    0x4ba31f9000000ULL,
    0xe52aa30800000ULL,
    0xcf65327400000ULL,
    0xf8c8d91600000ULL,
    0xbf01c2300000ULL,
    0xd380238f80000ULL,
    0xdfdc70be40000ULL,
    0x3762f82760000ULL,
    0xdccb6e01d0000ULL,
    0xe9e259e128000ULL,
    0x5e895ecadc000ULL,
    0x424a028ae2000ULL,
    0xbb703eae9000ULL,
    0x8538803ae2800ULL,
    0xbf7a425298c00ULL,
    0x50d8a3f6e9600ULL,
    0x97f63088f5700ULL,
    0x7582590f80080ULL,
    0xc0d95ffe400c0ULL,
    0x8ff203c7600a0ULL,
    0xe1930291d00d0ULL,
    0x2aca806928078ULL,
    0x4ee943fedc0e4ULL,
    0xa212207ce2042ULL,
    0xed1f7359e905dULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0xf000000000000ULL,
    0x8800000000000ULL,
    0xac00000000000ULL,
    0xfe00000000000ULL,
    0xbf00000000000ULL,
    0x2180000000000ULL,
    0x2c40000000000ULL,
    0x8620000000000ULL,
    0x5e90000000000ULL,
    0x6dc8000000000ULL,
    0x7a64000000000ULL,
    0xa0ae000000000ULL,
    0x1749000000000ULL,
    0x45b9800000000ULL,
    0x9bd5c00000000ULL,
    0x2970e00000000ULL,
    0x5f34b00000000ULL,
    0x7409c80000000ULL,
    0x6a05e40000000ULL,
    0x4517820000000ULL,
    0x3c9cc10000000ULL,
    0xc4c9608000000ULL,
    0x98e173c000000ULL,
    0x2b792a2000000ULL,
    0x263156b000000ULL,
    0xee9e49f800000ULL,
    0xc5d927fc00000ULL,
    0x267ee20600000ULL,
    0xd6adb27100000ULL,
    0x45848b880000ULL,
    0x9a24240a40000ULL,
    0x881626f20000ULL,
    0x8ec570a590000ULL,
    0x2df7297cb8000ULL,
    0x9fe855d024000ULL,
    0x4eefcba866000ULL,
    0x8868e41417000ULL,
    0x51a0027263800ULL,
    0x21d001d302c00ULL,
    0x146800c3bf200ULL,
    0x47b401dda3900ULL,
    0xe2c6014080080ULL,
    0xb3fd03f640040ULL,
    0xf0ff806920020ULL,
    0x1768c2d4900f0ULL,
    0x802f61c438088ULL,
    0x858c71da640acULL,
    0x3e4ea9c7460feULL,
    0xe73d94b1870bfULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0xf000000000000ULL,
    0xb800000000000ULL,
    0x1c00000000000ULL,
    0x2a00000000000ULL,
    0xc700000000000ULL,
    0x2580000000000ULL,
    0x4940000000000ULL,
    0xc960000000000ULL,
    0xf290000000000ULL,
    0x44c8000000000ULL,
    0xf424000000000ULL,
    0x45ee000000000ULL,
    0xff4f000000000ULL,
    0x646f800000000ULL,
    0x300f400000000ULL,
    0xd819e00000000ULL,
    0xcc14300000000ULL,
    0x6211e80000000ULL,
    0x63138c0000000ULL,
    0x1381820000000ULL,
    0xa440410000000ULL,
    0x2bf6608000000ULL,
    0x9e5b73c000000ULL,
    0xc4e80ae000000ULL,
    0xcfd7bc7000000ULL,
    0xf3b86aa800000ULL,
    0x4fa7ce1c00000ULL,
    0xd5b1e21600000ULL,
    0x8aa033e500000ULL,
    0x4337e94580000ULL,
    0x98788c7a40000ULL,
    0x8a00015b20000ULL,
    0x770001bc90000ULL,
    0xbd8001a9b8000ULL,
    0xa54002043c000ULL,
    0x5b6000c23e000ULL,
    0x2990025f7d000ULL,
    0x4b4801fec7800ULL,
    0x7a64003680c00ULL,
    0xa90e011adfa00ULL,
    0x449f0084e2300ULL,
    0xe9c783ed80080ULL,
    0x36bb426640040ULL,
    0xd93fe34d20020ULL,
    0xc77f3259900f0ULL,
    0x439068ec380b8ULL,
    0xac53ce7e7c01cULL,
    0xaff7e1991e02aULL,
    0x585b33e3ed0c7ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0xd000000000000ULL,
    0x7800000000000ULL,
    0x9c00000000000ULL,
    0x2a00000000000ULL,
    0x9500000000000ULL,
    0x2080000000000ULL,
    0xb940000000000ULL,
    0x27e0000000000ULL,
    0xb990000000000ULL,
    0xebd8000000000ULL,
    0xa7bc000000000ULL,
    0x3cea000000000ULL,
    0x9a07000000000ULL,
    0xfd17800000000ULL,
    0x2483400000000ULL,
    0xdf47a00000000ULL,
    0xe0f8900000000ULL,
    0x9011e80000000ULL,
    0x580b1c0000000ULL,
    0xac1d820000000ULL,
    0x8214430000000ULL,
    0x7108238000000ULL,
    0x9687d34000000ULL,
    0x65c49e000000ULL,
    0x92648e7000000ULL,
    0x2043eaa800000ULL,
    0x75601d5400000ULL,
    0x39d8010200000ULL,
    0x6ebc02a500000ULL,
    0xd66a02ff80000ULL,
    0x664703d640000ULL,
    0x827782e760000ULL,
    0xb85342baf0000ULL,
    0x397fa0d9a8000ULL,
    0x6bd492d91c000ULL,
    0x67a3ebe9de000ULL,
    0xdcf01c914d000ULL,
    0x4a00024dfe800ULL,
    0x850000fb52400ULL,
    0xb880029c8fa00ULL,
    0xf54002d6c0700ULL,
    0x75e0005780080ULL,
    0xb0900282400c0ULL,
    0xe15801e5600e0ULL,
    0x8bfc031ff00d0ULL,
    0x3b8a01a628078ULL,
    0x9ad7024f5c09cULL,
    0x312f80eebe02aULL,
    0x3aaf405bbd095ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0xb000000000000ULL,
    0xb800000000000ULL,
    0x3400000000000ULL,
    0xca00000000000ULL,
    0x5900000000000ULL,
    0x8a80000000000ULL,
    0x81c0000000000ULL,
    0x58e0000000000ULL,
    0x3790000000000ULL,
    0x958000000000ULL,
    0xec3c000000000ULL,
    0xabe6000000000ULL,
    0x941f000000000ULL,
    0x5a02800000000ULL,
    0xb113400000000ULL,
    0xb68a200000000ULL,
    0xc7c0d00000000ULL,
    0xffeff80000000ULL,
    0x2e097c0000000ULL,
    0x5b04820000000ULL,
    0xbf9c430000000ULL,
    0x4550a38000000ULL,
    0xf22f92c000000ULL,
    0x88e3dae000000ULL,
    0xff86acd000000ULL,
    0x6551f92800000ULL,
    0xa22a7e6400000ULL,
    0x80e003aa00000ULL,
    0x739003c700000ULL,
    0x9b58000380000ULL,
    0x313c02ce40000ULL,
    0x536601ed60000ULL,
    0x78df0204f0000ULL,
    0x426283ad98000ULL,
    0x5e4341337c000ULL,
    0x6db222218a000ULL,
    0x9dacd01d0d000ULL,
    0x5b1fb9cc8800ULL,
    0x61ba7c71b3400ULL,
    0xa3b8037547e00ULL,
    0x76ac0258a9f00ULL,
    0x23e012b80080ULL,
    0x10e300aa400c0ULL,
    0x9b848047600e0ULL,
    0xa75c42c3f00b0ULL,
    0x7730a02e180b8ULL,
    0xf47f913d3c034ULL,
    0x615bd92cea0caULL,
    0x102aaec9fd059ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0xf000000000000ULL,
    0x9800000000000ULL,
    0x6c00000000000ULL,
    0xaa00000000000ULL,
    0xcb00000000000ULL,
    0xdc80000000000ULL,
    0x1840000000000ULL,
    0xece0000000000ULL,
    0x9390000000000ULL,
    0x5ad8000000000ULL,
    0x19bc000000000ULL,
    0x32ee000000000ULL,
    0x5e9b000000000ULL,
    0x749800000000ULL,
    0xe677400000000ULL,
    0x82c4600000000ULL,
    0x55bd100000000ULL,
    0x88f7c80000000ULL,
    0xfd87bc0000000ULL,
    0x2fc7820000000ULL,
    0x383c430000000ULL,
    0xf35e38000000ULL,
    0xd1a653c000000ULL,
    0x16e5aa6000000ULL,
    0x108dadb000000ULL,
    0x624fc8a800000ULL,
    0xafebbc2c00000ULL,
    0x4b1182f200000ULL,
    0x1c8b40a100000ULL,
    0xf84a625380000ULL,
    0x1cf6103e40000ULL,
    0xb8649a360000ULL,
    0x36dcfefaf0000ULL,
    0xb3b5e311b8000ULL,
    0xf9e651376c000ULL,
    0x8205ab5ca6000ULL,
    0x1f1dae769d000ULL,
    0xa97c8b3f1800ULL,
    0x1157bdce44400ULL,
    0xf7f80ab07200ULL,
    0x9150410682f00ULL,
    0xcf63e2fb80080ULL,
    0x71515012400c0ULL,
    0x3f7a2951600e0ULL,
    0xe94ded5bf00f0ULL,
    0x53742ac238098ULL,
    0x4346eec92c06cULL,
    0x9865aa9fc60aaULL,
    0x9fcdae3c6d0cbULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x3000000000000ULL,
    0xe800000000000ULL,
    0x6400000000000ULL,
    0x2a00000000000ULL,
    0x9b00000000000ULL,
    0x580000000000ULL,
    0x2fc0000000000ULL,
    0x18a0000000000ULL,
    0xd490000000000ULL,
    0x6158000000000ULL,
    0xcae4000000000ULL,
    0x5ff6000000000ULL,
    0xb75000000000ULL,
    0xaa20800000000ULL,
    0x40cf400000000ULL,
    0x2f34600000000ULL,
    0xcc43300000000ULL,
    0x26f380000000ULL,
    0x68b0b40000000ULL,
    0xdc8e820000000ULL,
    0x155e430000000ULL,
    0x38e2e08000000ULL,
    0x48f970c000000ULL,
    0x40fbdba000000ULL,
    0x34fcc59000000ULL,
    0xc6f5daa800000ULL,
    0xd1fdc56c00000ULL,
    0x9a7b5a9600000ULL,
    0x4a3877f00000ULL,
    0x8299b94280000ULL,
    0x7c5af50240000ULL,
    0x2a62600d60000ULL,
    0x2ca6331790000ULL,
    0xc697bae1d8000ULL,
    0x665bf7aed4000ULL,
    0x596ce3d402000ULL,
    0x4d3872127d000ULL,
    0xc355596531800ULL,
    0xe5f2855bdcc00ULL,
    0x886f392784e00ULL,
    0x3b0b7d9c6d00ULL,
    0x110e836a80080ULL,
    0x6e9e40ae400c0ULL,
    0xe242e13b60020ULL,
    0x636971f890030ULL,
    0xe23d90b580e8ULL,
    0x4ad8c7c094064ULL,
    0x8423d94f6202aULL,
    0x21d8c67aed09bULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x5000000000000ULL,
    0xd800000000000ULL,
    0x2c00000000000ULL,
    0xa200000000000ULL,
    0x6500000000000ULL,
    0xe480000000000ULL,
    0xa8c0000000000ULL,
    0xd2e0000000000ULL,
    0x2b90000000000ULL,
    0x9d48000000000ULL,
    0xf0bc000000000ULL,
    0xc6ba000000000ULL,
    0x3da3000000000ULL,
    0x2621800000000ULL,
    0x737a400000000ULL,
    0x97d9a00000000ULL,
    0x8f7c100000000ULL,
    0xadd9d80000000ULL,
    0x267e3c0000000ULL,
    0xbb53820000000ULL,
    0x33a5410000000ULL,
    0xa122238000000ULL,
    0x12f5514000000ULL,
    0x8b89fb6000000ULL,
    0x2d546cb000000ULL,
    0x78a1f88800000ULL,
    0x32b86c9400000ULL,
    0xb3b3fa1200000ULL,
    0xe1376ee300000ULL,
    0xf2e079ab80000ULL,
    0xdb922c5e40000ULL,
    0xf5425a1d20000ULL,
    0x54a77ea6f0000ULL,
    0x90aba0e0e8000ULL,
    0xd6a313318c000ULL,
    0x5a25a2906000ULL,
    0x5a377fa4a9000ULL,
    0x963a31bc6800ULL,
    0xdedf13d640400ULL,
    0xc9f85a092f600ULL,
    0x60047d74c4f00ULL,
    0x100a22a380080ULL,
    0x3819518a40040ULL,
    0x7c1bfb6f200e0ULL,
    0x7a1b6cf5f0050ULL,
    0x491279c3680d8ULL,
    0x468d2ffbcc02cULL,
    0xcdd9d826260a2ULL,
    0x367e3ee159065ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x5000000000000ULL,
    0xc800000000000ULL,
    0x1400000000000ULL,
    0x8200000000000ULL,
    0xc100000000000ULL,
    0x1480000000000ULL,
    0x8dc0000000000ULL,
    0x61a0000000000ULL,
    0xe390000000000ULL,
    0x4a58000000000ULL,
    0xd1e4000000000ULL,
    0x5f7a000000000ULL,
    0xfb1000000000ULL,
    0xcc8e800000000ULL,
    0xb1c6400000000ULL,
    0x87af200000000ULL,
    0x3883100000000ULL,
    0x43c2780000000ULL,
    0xdea2d40000000ULL,
    0xf00c820000000ULL,
    0x5803430000000ULL,
    0xfc03a08000000ULL,
    0xc610514000000ULL,
    0x8b19db2000000ULL,
    0xc196845000000ULL,
    0x1b4f580800000ULL,
    0x2d74c40400000ULL,
    0x96ba7ad200000ULL,
    0x2416d47700000ULL,
    0xfa0e802680000ULL,
    0x6d06419e40000ULL,
    0x1a8f208160000ULL,
    0x12d3115390000ULL,
    0x223a7807e8000ULL,
    0x39d6d55dc4000ULL,
    0x73ae82eeba000ULL,
    0xca96437a59000ULL,
    0x1ad722635c800ULL,
    0x1637135cdc400ULL,
    0xebc07bfd01e00ULL,
    0x7aa7d7dd9f500ULL,
    0xca0000ae80080ULL,
    0x150000da400c0ULL,
    0xb680037360020ULL,
    0x1cc0027490050ULL,
    0xbd2000a9680c8ULL,
    0x7a50018784014ULL,
    0xa9f8039dda082ULL,
    0xf374020ec90c1ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x5000000000000ULL,
    0x5800000000000ULL,
    0x3c00000000000ULL,
    0xe200000000000ULL,
    0x4d00000000000ULL,
    0xcd80000000000ULL,
    0xadc0000000000ULL,
    0x8ae0000000000ULL,
    0x6690000000000ULL,
    0x4358000000000ULL,
    0x6da4000000000ULL,
    0xf53a000000000ULL,
    0x4963000000000ULL,
    0xfc4b800000000ULL,
    0x552a400000000ULL,
    0xd97ca00000000ULL,
    0x8457300000000ULL,
    0x3939780000000ULL,
    0x637d3c0000000ULL,
    0xf549820000000ULL,
    0x16bd430000000ULL,
    0x83b5208000000ULL,
    0xb22a714000000ULL,
    0xddec596000000ULL,
    0x4a074cf000000ULL,
    0xb91dd98800000ULL,
    0x6b8e0e3400000ULL,
    0x6ecaf9b600000ULL,
    0xb0637cf700000ULL,
    0x77d721cb80000ULL,
    0x4bed732a40000ULL,
    0x611ddb6560000ULL,
    0x978e0d3290000ULL,
    0xaccaf80ae8000ULL,
    0xad637d568c000ULL,
    0xe25723e4ae000ULL,
    0xda2d710de9000ULL,
    0x9fdda9512800ULL,
    0xbc1e0d3a8cc00ULL,
    0x2212f8feede00ULL,
    0x6d077e40a8f00ULL,
    0x9d8d20c380080ULL,
    0xf5de705e400c0ULL,
    0xb6ee59b360020ULL,
    0x84904e3590050ULL,
    0xe5458c968058ULL,
    0xa0334d08cc03cULL,
    0x58ffda57ce0e2ULL,
    0xc3890f387904dULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x9000000000000ULL,
    0x5800000000000ULL,
    0xd400000000000ULL,
    0xee00000000000ULL,
    0xab00000000000ULL,
    0x1b80000000000ULL,
    0x4a40000000000ULL,
    0x3fa0000000000ULL,
    0xca50000000000ULL,
    0x7fa8000000000ULL,
    0xaa5c000000000ULL,
    0xefba000000000ULL,
    0xf257000000000ULL,
    0x3ba0800000000ULL,
    0x1c4ac00000000ULL,
    0x90b5e00000000ULL,
    0x7c9b00000000ULL,
    0xdafca80000000ULL,
    0x386e440000000ULL,
    0x10b5e20000000ULL,
    0x47c9b10000000ULL,
    0xbafca98000000ULL,
    0xa86e464000000ULL,
    0x48b5e36000000ULL,
    0x93c9b25000000ULL,
    0x54fcaa3800000ULL,
    0x36e44ec00000ULL,
    0x5335e30e00000ULL,
    0xd989b37900000ULL,
    0x6b5caac680000ULL,
    0xc93e47c540000ULL,
    0x2c9de2f0a0000ULL,
    0x73d5b1d070000ULL,
    0x84e6a97868000ULL,
    0x3b69440c1c000ULL,
    0x173d621e22000ULL,
    0x6f9f71a15b000ULL,
    0x14534b3abf800ULL,
    0x3ca0f4133ac00ULL,
    0xcdc1c975d0a00ULL,
    0x57f13540e2100ULL,
    0x4e6a97868080ULL,
    0x7b69440c1c040ULL,
    0x773d621e22060ULL,
    0xff9f71a15b090ULL,
    0x4c534b3abf858ULL,
    0xe8a0f4133acd4ULL,
    0x23c1c975d0aeeULL,
    0xfcf13540e21abULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0x1000000000000ULL,
    0x5800000000000ULL,
    0x9c00000000000ULL,
    0xe200000000000ULL,
    0x8b00000000000ULL,
    0x5280000000000ULL,
    0x56c0000000000ULL,
    0x4a60000000000ULL,
    0xb6d0000000000ULL,
    0x3a68000000000ULL,
    0xded4000000000ULL,
    0xee6a000000000ULL,
    0xf8df000000000ULL,
    0x1b79800000000ULL,
    0xc343400000000ULL,
    0x9428e00000000ULL,
    0x8d69100000000ULL,
    0x3e52380000000ULL,
    0x4bb85c0000000ULL,
    0x6c28e20000000ULL,
    0x4169110000000ULL,
    0xa452388000000ULL,
    0x4cb85c4000000ULL,
    0x84a8e36000000ULL,
    0xa9137000000ULL,
    0x5eb23b0800000ULL,
    0x27a85e6c00000ULL,
    0xa620e22a00000ULL,
    0x3e6d122b00000ULL,
    0xc0d03a2180000ULL,
    0xb7735cb740000ULL,
    0x695b62c3a0000ULL,
    0xdb25515050000ULL,
    0xa1eb599828000ULL,
    0x1860f543c000ULL,
    0xd8583aae46000ULL,
    0xdeb75e5d5d000ULL,
    0x67b961c88b800ULL,
    0x863e506198400ULL,
    0x2e70d8d70ee00ULL,
    0x98de4e33bc700ULL,
    0x2b6b599828080ULL,
    0x8b460f543c040ULL,
    0x50383aae46020ULL,
    0xf3675e5d5d010ULL,
    0x575161c88b858ULL,
    0x922a50619849cULL,
    0x687ad8d70eee2ULL,
    0x5dd14e33bc78bULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0xb000000000000ULL,
    0x4800000000000ULL,
    0x4400000000000ULL,
    0xca00000000000ULL,
    0xd00000000000ULL,
    0x2880000000000ULL,
    0x5140000000000ULL,
    0xd8a0000000000ULL,
    0x5950000000000ULL,
    0xbcb8000000000ULL,
    0xc34c000000000ULL,
    0x49ae000000000ULL,
    0xe7c5000000000ULL,
    0x96e6800000000ULL,
    0xf87c400000000ULL,
    0xea37200000000ULL,
    0x3d01500000000ULL,
    0xa091080000000ULL,
    0xf544440000000ULL,
    0xa2b7220000000ULL,
    0x1c41530000000ULL,
    0xd0310b8000000ULL,
    0x581446c000000ULL,
    0x9c0f232000000ULL,
    0x960d521000000ULL,
    0x7b1f08a800000ULL,
    0xe39146f400000ULL,
    0xfac9a38200000ULL,
    0x6661135500000ULL,
    0xf5302bca80000ULL,
    0x448c179140000ULL,
    0xaf4ea970e0000ULL,
    0xb7ac545830000ULL,
    0x88cf88ec38000ULL,
    0x4774070e54000ULL,
    0x3ae00ab7a000ULL,
    0x2ac50179c1000ULL,
    0x5e668064e4800ULL,
    0x193c41ea51400ULL,
    0x7a9720813e200ULL,
    0x20515358d0100ULL,
    0xd62908ec38080ULL,
    0x3b08470e540c0ULL,
    0xc39920ab7a0e0ULL,
    0xaac45179c10b0ULL,
    0x9e778864e4848ULL,
    0xf93805ea51444ULL,
    0xca8002813e2caULL,
    0x68400058d010dULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x1000000000000ULL,
    0xa800000000000ULL,
    0xac00000000000ULL,
    0xe600000000000ULL,
    0x900000000000ULL,
    0x3880000000000ULL,
    0xe2c0000000000ULL,
    0x50a0000000000ULL,
    0xead0000000000ULL,
    0x2cb8000000000ULL,
    0x84d4000000000ULL,
    0x99ba000000000ULL,
    0xf241000000000ULL,
    0xde6f800000000ULL,
    0x7c7dc00000000ULL,
    0xdf7ea00000000ULL,
    0x38e2d00000000ULL,
    0x53a6f80000000ULL,
    0xdd4ac40000000ULL,
    0xcffea20000000ULL,
    0xb622d30000000ULL,
    0xc506f88000000ULL,
    0x2e9ac44000000ULL,
    0x73c6a0a000000ULL,
    0x7c36d1b000000ULL,
    0xea1cfb1800000ULL,
    0x3f0bc46400000ULL,
    0xb991204200000ULL,
    0x665f123b00000ULL,
    0xfc785a5a80000ULL,
    0x1f7817cf40000ULL,
    0x18e058f0e0000ULL,
    0x43bc142850000ULL,
    0x75425a3c68000ULL,
    0x63f9170644000ULL,
    0x502fdb095e000ULL,
    0xcc11d599a7000ULL,
    0x1604fbe192800ULL,
    0x910fc555cf400ULL,
    0x2c9321dfc5e00ULL,
    0xca12c88c100ULL,
    0x13adda3c68080ULL,
    0x3d44d706440c0ULL,
    0xfff17b095e020ULL,
    0xe230599a7010ULL,
    0xc11a03e1928a8ULL,
    0x64910155cf4acULL,
    0x9cd783dfc5ee6ULL,
    0x4da9c1c88c109ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x3000000000000ULL,
    0x4800000000000ULL,
    0x6400000000000ULL,
    0xea00000000000ULL,
    0xc500000000000ULL,
    0x4f80000000000ULL,
    0x75c0000000000ULL,
    0x3b60000000000ULL,
    0xa1d0000000000ULL,
    0xd968000000000ULL,
    0xe0cc000000000ULL,
    0x4cee000000000ULL,
    0x1805000000000ULL,
    0x5c02800000000ULL,
    0x2608400000000ULL,
    0x7b12200000000ULL,
    0x289db00000000ULL,
    0x9b5a980000000ULL,
    0xeb33dc0000000ULL,
    0x2a72220000000ULL,
    0xc4db10000000ULL,
    0xedb29b8000000ULL,
    0x4e3fdcc000000ULL,
    0x15fc232000000ULL,
    0xd198b09000000ULL,
    0x82d8182800000ULL,
    0x4dfb9fd400000ULL,
    0x6d80021e00000ULL,
    0x94c0014700000ULL,
    0x7ee000c580000ULL,
    0x2110015340000ULL,
    0xe588037ba0000ULL,
    0x50dc03c430000ULL,
    0x44e6027638000ULL,
    0x9c1901f354000ULL,
    0x8604832baa000ULL,
    0xab0142cc11000ULL,
    0x509ea03270800ULL,
    0xb740f24522c00ULL,
    0x65223878c0600ULL,
    0x56a2cb7de700ULL,
    0x86d49a7638080ULL,
    0xd7e6ddf354040ULL,
    0x98a12baa0e0ULL,
    0x8f49f3cc11030ULL,
    0xa92ebbb270848ULL,
    0xbb776e8522c64ULL,
    0xe1cc3b58c06eaULL,
    0x396f2c27de7c5ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x9000000000000ULL,
    0x5800000000000ULL,
    0x5400000000000ULL,
    0x7200000000000ULL,
    0xcf00000000000ULL,
    0xf280000000000ULL,
    0x9940000000000ULL,
    0xcfa0000000000ULL,
    0xfb50000000000ULL,
    0x98b8000000000ULL,
    0x7dd4000000000ULL,
    0xe3ea000000000ULL,
    0x257f000000000ULL,
    0xbe30800000000ULL,
    0x5689400000000ULL,
    0xc35d600000000ULL,
    0xbcad100000000ULL,
    0xe7c9480000000ULL,
    0xb0f0640000000ULL,
    0xa9e5620000000ULL,
    0xce79130000000ULL,
    0xd6a3488000000ULL,
    0x9ccf664000000ULL,
    0x8075e36000000ULL,
    0x37a0525000000ULL,
    0xff46294800000ULL,
    0x92b6757c00000ULL,
    0x76d6a8aa00000ULL,
    0x3b6f343500000ULL,
    0x2733c87680000ULL,
    0xf116259140000ULL,
    0xfb908248e0000ULL,
    0x66d9438250000ULL,
    0xa365609928000ULL,
    0x53391354bc000ULL,
    0x13034bf822000ULL,
    0x6c9f64a475000ULL,
    0xc04de3be5d800ULL,
    0x483453d308400ULL,
    0x538c2b7187200ULL,
    0x1ad975a6f4900ULL,
    0x6d7e281928080ULL,
    0x72227514bc0c0ULL,
    0x509ca89822020ULL,
    0xee4036f475090ULL,
    0xd93b4af65d858ULL,
    0xd80b66af08454ULL,
    0x9407e3db87272ULL,
    0x521b5193f49cfULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x7000000000000ULL,
    0xd800000000000ULL,
    0xdc00000000000ULL,
    0x6200000000000ULL,
    0xdf00000000000ULL,
    0x2c80000000000ULL,
    0x1540000000000ULL,
    0xbe60000000000ULL,
    0x2b50000000000ULL,
    0x4368000000000ULL,
    0x38cc000000000ULL,
    0xaa6000000000ULL,
    0x4bf7000000000ULL,
    0x438d800000000ULL,
    0x41c3400000000ULL,
    0xe732600000000ULL,
    0x5f2cd00000000ULL,
    0xb321c80000000ULL,
    0xe9219c0000000ULL,
    0x9a3a620000000ULL,
    0xcb0d10000000ULL,
    0x1aefcb8000000ULL,
    0xea1a9dc000000ULL,
    0xb11e16000000ULL,
    0xda84927000000ULL,
    0xdc502a0800000ULL,
    0x2bf50ebc00000ULL,
    0x738249d200000ULL,
    0x79c9de2500000ULL,
    0x4b2b82f180000ULL,
    0xe534431140000ULL,
    0xb03fe15fa0000ULL,
    0xa7af920630000ULL,
    0x5073a83b18000ULL,
    0x9e5d4d8e9c000ULL,
    0x24f3ab3996000ULL,
    0x171d4fcd3d000ULL,
    0x1893a87dd1800ULL,
    0x934d4c6b2f400ULL,
    0xaf7baad691200ULL,
    0x62c14d5dfb700ULL,
    0x79bdabbb18080ULL,
    0xdd664c4e9c040ULL,
    0x55d82859960e0ULL,
    0xb1290cbd3d070ULL,
    0x62c49f5d18d8ULL,
    0x8ea2df172f4dcULL,
    0xb5e8026491262ULL,
    0x1e8c0108fb7dfULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x3000000000000ULL,
    0x9800000000000ULL,
    0xa400000000000ULL,
    0x5a00000000000ULL,
    0x3300000000000ULL,
    0xdf80000000000ULL,
    0x4ac0000000000ULL,
    0xa960000000000ULL,
    0xa4d0000000000ULL,
    0x2868000000000ULL,
    0xd444000000000ULL,
    0x732e000000000ULL,
    0xc6f7000000000ULL,
    0x360a800000000ULL,
    0x8504400000000ULL,
    0x1a80e00000000ULL,
    0xf045b00000000ULL,
    0x6928b80000000ULL,
    0x55e11c0000000ULL,
    0xd988e20000000ULL,
    0x57d1b10000000ULL,
    0x17eeba8000000ULL,
    0xe921cc000000ULL,
    0x724c606000000ULL,
    0x5e32f39000000ULL,
    0xe06cdbe800000ULL,
    0x3847ec0c00000ULL,
    0x85223b1e00000ULL,
    0xa3e55ebb00000ULL,
    0xbc88034d80000ULL,
    0xdd54039f40000ULL,
    0x4fa6033fa0000ULL,
    0x5ba3002a10000ULL,
    0xd9ac806138000ULL,
    0xeea743d49c000ULL,
    0x5b2c626f8a000ULL,
    0xbae2f0a201000ULL,
    0x6804d87d3b800ULL,
    0xdc03ef628ac00ULL,
    0x6e0c3978a8e00ULL,
    0xc1125f81c5700ULL,
    0xd08282e138080ULL,
    0x6b5043149c040ULL,
    0x8aa6e00f8a0a0ULL,
    0xe126b23201030ULL,
    0x19e439153b898ULL,
    0x1f965fae8aca4ULL,
    0xaacc8206a8e5aULL,
    0x397742aac5733ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0xd000000000000ULL,
    0x800000000000ULL,
    0x8400000000000ULL,
    0xea00000000000ULL,
    0x8f00000000000ULL,
    0x9c80000000000ULL,
    0x2ec0000000000ULL,
    0x8620000000000ULL,
    0x18d0000000000ULL,
    0xaf38000000000ULL,
    0x4554000000000ULL,
    0xa862000000000ULL,
    0xf635000000000ULL,
    0xc2800000000ULL,
    0x320400000000ULL,
    0xfb4f600000000ULL,
    0xc56dd00000000ULL,
    0x61b1b80000000ULL,
    0x589c940000000ULL,
    0x24d7620000000ULL,
    0xf929d30000000ULL,
    0x5c4bb88000000ULL,
    0xded974000000ULL,
    0xad6fe22000000ULL,
    0xd5b8911000000ULL,
    0x4a9c5b2800000ULL,
    0xf7c1057c00000ULL,
    0x3b1b85200000ULL,
    0x939c95ab00000ULL,
    0x7257633080000ULL,
    0x88e9d21f40000ULL,
    0x4eebb86ee0000ULL,
    0xbffd94fe50000ULL,
    0x6e77e13108000ULL,
    0x73c909794000ULL,
    0xd1465be5ea000ULL,
    0x6a6004ded1000ULL,
    0x2d313b0635800ULL,
    0x7e59d50523400ULL,
    0x26e28009ace00ULL,
    0xbf04264e3500ULL,
    0x7c7761b108080ULL,
    0xd439d3d7940c0ULL,
    0x2bd3bbc5ea020ULL,
    0xa5a996ced10d0ULL,
    0x5295e0ae35808ULL,
    0x5bc9933923484ULL,
    0xbda4d87baceeaULL,
    0xfe9045dfe358fULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x7000000000000ULL,
    0x2800000000000ULL,
    0x2c00000000000ULL,
    0x8200000000000ULL,
    0x6100000000000ULL,
    0xbc80000000000ULL,
    0x5e40000000000ULL,
    0xbba0000000000ULL,
    0x8850000000000ULL,
    0x8ca8000000000ULL,
    0x43cc000000000ULL,
    0xf966000000000ULL,
    0xfda9000000000ULL,
    0xe753800000000ULL,
    0x4321400000000ULL,
    0x980ba00000000ULL,
    0xa404d00000000ULL,
    0x3e1b680000000ULL,
    0xbb1b240000000ULL,
    0xd983a20000000ULL,
    0x4cd8d10000000ULL,
    0x6f56b8000000ULL,
    0xee6e25c000000ULL,
    0xe63e22a000000ULL,
    0x2a8c91b000000ULL,
    0x8943498800000ULL,
    0x3eb44400000ULL,
    0xd593685200000ULL,
    0x1ec724c900000ULL,
    0xdfeda16680000ULL,
    0x26edd36540000ULL,
    0x3e68ebe0a0000ULL,
    0x5e2a650630000ULL,
    0x5e8001a318000ULL,
    0xf4001e3e4000ULL,
    0xcf2002d5ee000ULL,
    0x8a10013eb5000ULL,
    0x9d08013936800ULL,
    0x869c028ef7400ULL,
    0x4b4e01b103a00ULL,
    0x8125014a99900ULL,
    0x1915822318080ULL,
    0x68984023e4040ULL,
    0x48502275ee0e0ULL,
    0x2cb9918eb5070ULL,
    0xd3decb3136828ULL,
    0xa17af70af742cULL,
    0xf9ad494303a82ULL,
    0x494bb53399961ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x1000000000000ULL,
    0xa800000000000ULL,
    0x8c00000000000ULL,
    0xbe00000000000ULL,
    0x4100000000000ULL,
    0x3180000000000ULL,
    0x5c0000000000ULL,
    0x9ae0000000000ULL,
    0xe4d0000000000ULL,
    0x7b78000000000ULL,
    0x6914000000000ULL,
    0x7d9a000000000ULL,
    0x9bd1000000000ULL,
    0xcbf3800000000ULL,
    0x7d52c00000000ULL,
    0xf2a1a00000000ULL,
    0x4de5f00000000ULL,
    0xd842980000000ULL,
    0xd13c6c0000000ULL,
    0xa73ba20000000ULL,
    0x9a34f30000000ULL,
    0x8db1188000000ULL,
    0xfd6eac4000000ULL,
    0xcc1a00a000000ULL,
    0x5e11013000000ULL,
    0x7113827800000ULL,
    0x8982c14400000ULL,
    0x21d9a26600000ULL,
    0xa8f1f22700000ULL,
    0x1bd8989380000ULL,
    0xbed6e9740000ULL,
    0x5d48232be0000ULL,
    0xe2a632b350000ULL,
    0xe5f0bb1de8000ULL,
    0x545b5dbc04000ULL,
    0x6f209a622e000ULL,
    0xe6396d611b000ULL,
    0xabb22244ee800ULL,
    0x8867311cd3c00ULL,
    0x679b3aa8c4600ULL,
    0x28cd9cd6bab00ULL,
    0x25633965e8080ULL,
    0x18199cf8040c0ULL,
    0xf41938042e020ULL,
    0xba189f461b010ULL,
    0x6312bad76e8a8ULL,
    0x669e5f8b93c8cULL,
    0xf9491983246beULL,
    0x10baae65eab41ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x9000000000000ULL,
    0x1800000000000ULL,
    0x9400000000000ULL,
    0xbe00000000000ULL,
    0xa700000000000ULL,
    0x3980000000000ULL,
    0x6a40000000000ULL,
    0x6c60000000000ULL,
    0x5550000000000ULL,
    0x81e8000000000ULL,
    0x2104000000000ULL,
    0xda9a000000000ULL,
    0x55d7000000000ULL,
    0xa520800000000ULL,
    0xa6a4c00000000ULL,
    0x8dfe600000000ULL,
    0x4b1cf00000000ULL,
    0x6397a80000000ULL,
    0x5b4fbc0000000ULL,
    0xeee4620000000ULL,
    0x348bf10000000ULL,
    0xad72a8000000ULL,
    0x38bb7e4000000ULL,
    0xfaf2026000000ULL,
    0xca93035000000ULL,
    0xdda807800000ULL,
    0x9123c0dc00000ULL,
    0x88b6e08600000ULL,
    0x32fc33f900000ULL,
    0xe693cb4980000ULL,
    0xb7d44fc940000ULL,
    0x903b48e1a0000ULL,
    0x82248c2d10000ULL,
    0xdf372a5be8000ULL,
    0x47ab7f421c000ULL,
    0xb77a007322000ULL,
    0x2ec7030e83000ULL,
    0x4ea8814591800ULL,
    0x71f0c2f72fc00ULL,
    0x490c6164dca00ULL,
    0x668ff292adf00ULL,
    0xf7cd2a23e8080ULL,
    0x302c7f9e1c040ULL,
    0x123280f5220a0ULL,
    0xc727c0f783090ULL,
    0xd3ace20c11818ULL,
    0x96b313e6fc94ULL,
    0x89d34b857cabeULL,
    0x77208fbfbdfa7ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0xd000000000000ULL,
    0x800000000000ULL,
    0x9400000000000ULL,
    0x3600000000000ULL,
    0xbd00000000000ULL,
    0x2880000000000ULL,
    0xa9c0000000000ULL,
    0x60a0000000000ULL,
    0x2cd0000000000ULL,
    0xc438000000000ULL,
    0x4f1c000000000ULL,
    0x6b82000000000ULL,
    0xc84d000000000ULL,
    0x7e8800000000ULL,
    0x50b7c00000000ULL,
    0x34cd200000000ULL,
    0x3837d00000000ULL,
    0x3d04980000000ULL,
    0xe88a040000000ULL,
    0xc9cf220000000ULL,
    0xb0bad30000000ULL,
    0x24cc198000000ULL,
    0x502dc74000000ULL,
    0x791a022000000ULL,
    0xd681015000000ULL,
    0xe0d2815800000ULL,
    0xae26c1b400000ULL,
    0x3007a08200000ULL,
    0x181d10f700000ULL,
    0xfc19395a80000ULL,
    0x7216164740000ULL,
    0x830499b2e0000ULL,
    0x18a049b70000ULL,
    0xb74f23ac88000ULL,
    0x747ad3d274000ULL,
    0x64ec1aaf42000ULL,
    0x413dc56eaf000ULL,
    0xeb8203853c800ULL,
    0x84d0065eb400ULL,
    0x67e88111b0600ULL,
    0x80b7c1f3f7100ULL,
    0x3ccd22f488080ULL,
    0xac37d266740c0ULL,
    0xb049a2d42060ULL,
    0x558a0599af0d0ULL,
    0xe14f22dfbc808ULL,
    0x197ad222ab494ULL,
    0x446c1aa350636ULL,
    0x7cfdc668871bdULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0xb000000000000ULL,
    0x800000000000ULL,
    0xf400000000000ULL,
    0xc600000000000ULL,
    0xe900000000000ULL,
    0xd680000000000ULL,
    0xf240000000000ULL,
    0x620000000000ULL,
    0x4f50000000000ULL,
    0x86a8000000000ULL,
    0x8c1c000000000ULL,
    0x1a1e000000000ULL,
    0xb0d000000000ULL,
    0x4188800000000ULL,
    0x31d9c00000000ULL,
    0x10e3a00000000ULL,
    0x9432100000000ULL,
    0xf05b680000000ULL,
    0x613e140000000ULL,
    0xe4dda20000000ULL,
    0xd46f110000000ULL,
    0x997be98000000ULL,
    0x71fbd6c000000ULL,
    0xf6a0022000000ULL,
    0xa41002d000000ULL,
    0x3e08029800000ULL,
    0x750c016400000ULL,
    0x5496037a00000ULL,
    0xd541001900000ULL,
    0xcdbe830080000ULL,
    0xad88c29940000ULL,
    0x9bd52140a0000ULL,
    0x13f6d1f970000ULL,
    0x21b84870f8000ULL,
    0x799c51174000ULL,
    0x98d3691c82000ULL,
    0xa67217f717000ULL,
    0xd66ba3abf6800ULL,
    0xfe7e11bcfc400ULL,
    0xda6d6b674fa00ULL,
    0xa46f14539f500ULL,
    0xb16b22e8f8080ULL,
    0x55ebd07574040ULL,
    0x88b8c86682060ULL,
    0xb10c06ee170b0ULL,
    0xda86c92b76808ULL,
    0xa85105e5bc4f4ULL,
    0x6d264807efac6ULL,
    0xbed4c77aef5e9ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0x7000000000000ULL,
    0xc800000000000ULL,
    0xfc00000000000ULL,
    0xc600000000000ULL,
    0xa500000000000ULL,
    0x7a80000000000ULL,
    0xc640000000000ULL,
    0x8ee0000000000ULL,
    0x2f50000000000ULL,
    0x9a68000000000ULL,
    0xe014000000000ULL,
    0x1006000000000ULL,
    0x981d000000000ULL,
    0x4411800000000ULL,
    0xf201c00000000ULL,
    0x9f0b200000000ULL,
    0x1997900000000ULL,
    0x19cc680000000ULL,
    0x323e8c0000000ULL,
    0x67ed220000000ULL,
    0x3bda910000000ULL,
    0x5535e88000000ULL,
    0x6a6b4dc000000ULL,
    0x6800012000000ULL,
    0xcc0002f000000ULL,
    0x2e00039800000ULL,
    0x2900035400000ULL,
    0x748002ca00000ULL,
    0x9f4000e900000ULL,
    0x3260012380000ULL,
    0x4c10022940000ULL,
    0x6e080383a0000ULL,
    0x904009950000ULL,
    0x48e027b98000ULL,
    0x575902dd34000ULL,
    0xce7f8379e6000ULL,
    0x8a08c04857000ULL,
    0xcb1ca23c34800ULL,
    0x738b52062a400ULL,
    0xc2d6c97777a00ULL,
    0xd9a8df00fd300ULL,
    0xe12a69e398080ULL,
    0x10738d8934040ULL,
    0x2b14a3b3e6020ULL,
    0x638f51a157070ULL,
    0x5ad8cb9fb48c8ULL,
    0x9db1ddef6a4fcULL,
    0x1335ebd4d7ac6ULL,
    0x8f6b4d69ad3a5ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0xb000000000000ULL,
    0x5800000000000ULL,
    0xac00000000000ULL,
    0x6e00000000000ULL,
    0x4100000000000ULL,
    0x2380000000000ULL,
    0x46c0000000000ULL,
    0x2220000000000ULL,
    0x33d0000000000ULL,
    0x23a8000000000ULL,
    0x4a04000000000ULL,
    0x8b1e000000000ULL,
    0xe89f000000000ULL,
    0xe43800000000ULL,
    0x9c66c00000000ULL,
    0xf7ada00000000ULL,
    0x7811b00000000ULL,
    0x5c1cf80000000ULL,
    0x9602340000000ULL,
    0x5d13a20000000ULL,
    0x159eb10000000ULL,
    0xabd77a8000000ULL,
    0x6fb0f6c000000ULL,
    0x3408036000000ULL,
    0x221403b000000ULL,
    0x3f16033800000ULL,
    0x8a8b03c400000ULL,
    0x915581ee00000ULL,
    0xa6edc3ab00000ULL,
    0x3ef8213080000ULL,
    0x72fc71cb40000ULL,
    0xce4d800a0000ULL,
    0xa5fe443310000ULL,
    0x727778a4f8000ULL,
    0xf6a0f66d3c000ULL,
    0xfb800037ae000ULL,
    0xaac000998b000ULL,
    0xec200212ce800ULL,
    0xc2d002323ac00ULL,
    0x582801917de00ULL,
    0xa0c4039d93d00ULL,
    0xc73e039cf8080ULL,
    0x9a4f01a93c040ULL,
    0xe6b83d9ae0a0ULL,
    0x90a2c2328b0b0ULL,
    0x5e93a1a24e858ULL,
    0xa35eb1397acacULL,
    0x71f778f1dde6eULL,
    0x4060f51e83d41ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x5000000000000ULL,
    0x4800000000000ULL,
    0xc00000000000ULL,
    0xca00000000000ULL,
    0xfb00000000000ULL,
    0xb180000000000ULL,
    0x5ec0000000000ULL,
    0xc960000000000ULL,
    0xc1d0000000000ULL,
    0xaee8000000000ULL,
    0x4604000000000ULL,
    0x7102000000000ULL,
    0xea9d000000000ULL,
    0xbf4b800000000ULL,
    0xdfb0400000000ULL,
    0x4aee00000000ULL,
    0xa537700000000ULL,
    0x13f8b80000000ULL,
    0x86891c0000000ULL,
    0xc54ce20000000ULL,
    0x9cba710000000ULL,
    0xa13b3a8000000ULL,
    0x75ed5d4000000ULL,
    0xe788032000000ULL,
    0xc7d4013000000ULL,
    0x7fea01a800000ULL,
    0xfc9902ac00000ULL,
    0x864983e600000ULL,
    0x392d414b00000ULL,
    0x71e5600d80000ULL,
    0x818730eb40000ULL,
    0xa6d6587da0000ULL,
    0x7d7e6c6310000ULL,
    0x1fd458e188000ULL,
    0xdbe36dad34000ULL,
    0xca9fd8c68e000ULL,
    0xaf532e26d1000ULL,
    0x37b13876b3800ULL,
    0x58a45d4ea9c00ULL,
    0x2729803acce00ULL,
    0xe4fd42f8e5700ULL,
    0xfd0d614988080ULL,
    0x6083330134040ULL,
    0xe45459208e0a0ULL,
    0x3e236e6dd1050ULL,
    0x127fdafb33848ULL,
    0x60432ce5e9c0cULL,
    0x183939676cecaULL,
    0xd3705eabf57fbULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0xf000000000000ULL,
    0xa800000000000ULL,
    0xfc00000000000ULL,
    0xaa00000000000ULL,
    0x6300000000000ULL,
    0x1880000000000ULL,
    0xbb40000000000ULL,
    0xa6e0000000000ULL,
    0x7a50000000000ULL,
    0x9168000000000ULL,
    0xfb94000000000ULL,
    0xe3d6000000000ULL,
    0x3db1000000000ULL,
    0x2cb1800000000ULL,
    0x4338400000000ULL,
    0x96efe00000000ULL,
    0xb254500000000ULL,
    0xbd7c080000000ULL,
    0x9974c0000000ULL,
    0xd4d1e20000000ULL,
    0x7331510000000ULL,
    0x5efb888000000ULL,
    0x9e4e0fc000000ULL,
    0x4f6780a000000ULL,
    0x3e8942f000000ULL,
    0x9a5e622800000ULL,
    0x16c124c00000ULL,
    0x8393eac200000ULL,
    0x47c31d1d00000ULL,
    0xc3adea3380000ULL,
    0x19a61d6540000ULL,
    0x92aa68a7a0000ULL,
    0x563f5fc350000ULL,
    0xb77c0934d8000ULL,
    0xda974c2f84000ULL,
    0x4451e07f66000ULL,
    0xc471525eb1000ULL,
    0xfa1b893ee7800ULL,
    0x7b1e0d6e95400ULL,
    0x6c8f82b6b6200ULL,
    0x1d5d4152fc300ULL,
    0xc7e8639cd8080ULL,
    0xfdcd11a384040ULL,
    0x98aa6a1d66020ULL,
    0x853f5db3b10f0ULL,
    0x27fc0925678a8ULL,
    0x6dd74e47d54fcULL,
    0xe0b1e2d3162aaULL,
    0x2121528cac363ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0xd000000000000ULL,
    0xd800000000000ULL,
    0x2400000000000ULL,
    0xf200000000000ULL,
    0x2b00000000000ULL,
    0x7f80000000000ULL,
    0xb2c0000000000ULL,
    0x2420000000000ULL,
    0x3d0000000000ULL,
    0xbca8000000000ULL,
    0xb084000000000ULL,
    0xdf52000000000ULL,
    0xcdef000000000ULL,
    0x506e800000000ULL,
    0xf1bd400000000ULL,
    0xfe0de00000000ULL,
    0xb517b00000000ULL,
    0xfa86380000000ULL,
    0xe04ef40000000ULL,
    0xe877e20000000ULL,
    0xe5bcb10000000ULL,
    0xa41aba8000000ULL,
    0xb20cb74000000ULL,
    0x8b1c816000000ULL,
    0xaf82419000000ULL,
    0x6acb614800000ULL,
    0x2ef3ec00000ULL,
    0xf1d9da9e00000ULL,
    0x97b6465b00000ULL,
    0xcf1f595880000ULL,
    0x6d8f05a340000ULL,
    0xe9c0bb8ca0000ULL,
    0x53b7b64910000ULL,
    0x4d08000dc8000ULL,
    0x4e9401e8fc000ULL,
    0x6a5a019b1a000ULL,
    0x377b0278e5000ULL,
    0xb03481d37f800ULL,
    0x19c64314e2c00ULL,
    0x1bb9600d22e00ULL,
    0x1111f22f8ed00ULL,
    0x489f5bc5c8080ULL,
    0x6b4f0544fc040ULL,
    0x47e0ba651a0a0ULL,
    0x8f67b5b3e50d0ULL,
    0xa42001c3ff8d8ULL,
    0x43d0015ba2c24ULL,
    0x1ca8031f82ef2ULL,
    0x6084033d9ed2bULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x5000000000000ULL,
    0xd800000000000ULL,
    0x4c00000000000ULL,
    0x2200000000000ULL,
    0xdf00000000000ULL,
    0x2680000000000ULL,
    0x8ec0000000000ULL,
    0xb0e0000000000ULL,
    0xefd0000000000ULL,
    0x7378000000000ULL,
    0xf494000000000ULL,
    0x19d2000000000ULL,
    0x227f000000000ULL,
    0x5f13800000000ULL,
    0xe687400000000ULL,
    0xaed6600000000ULL,
    0xe0ea900000000ULL,
    0x37c1380000000ULL,
    0x3f634c0000000ULL,
    0xd69c620000000ULL,
    0xc6d1930000000ULL,
    0x4f8b88000000ULL,
    0xd1cf0d4000000ULL,
    0x566b816000000ULL,
    0x4113423000000ULL,
    0x9384600800000ULL,
    0xc355923c00000ULL,
    0x26b2bbfa00000ULL,
    0xf4f40f0b00000ULL,
    0x99d2004b80000ULL,
    0xe27f03c340000ULL,
    0x7f1381d7e0000ULL,
    0xb68740a950000ULL,
    0x76d661c4c8000ULL,
    0xacea9206bc000ULL,
    0x15c13839ae000ULL,
    0xe0634f344d000ULL,
    0xf01c604611800ULL,
    0x4811923156400ULL,
    0xb418bbe0cae00ULL,
    0x3e1f0d98d0300ULL,
    0x2513814cc8080ULL,
    0xb587417abc0c0ULL,
    0x8a5660a3ae020ULL,
    0xe12a910f4d050ULL,
    0x79a13885918d8ULL,
    0x12734e8e1644cULL,
    0x370460ad2ae22ULL,
    0x295900a803dfULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x3000000000000ULL,
    0x6800000000000ULL,
    0xec00000000000ULL,
    0xfa00000000000ULL,
    0xfb00000000000ULL,
    0x6180000000000ULL,
    0x89c0000000000ULL,
    0xd920000000000ULL,
    0x34d0000000000ULL,
    0x1a8000000000ULL,
    0x3384000000000ULL,
    0x7ece000000000ULL,
    0xd2b9000000000ULL,
    0x1e0b800000000ULL,
    0x3d1a400000000ULL,
    0x9896e00000000ULL,
    0xa755700000000ULL,
    0x4f63580000000ULL,
    0x893a940000000ULL,
    0x8cd0e20000000ULL,
    0x15b8710000000ULL,
    0x7d8eda8000000ULL,
    0xfbddd4c000000ULL,
    0x5e2383a000000ULL,
    0xf75e42b000000ULL,
    0xf778e16800000ULL,
    0x9d3c732c00000ULL,
    0xc2c0d82600000ULL,
    0x90a4d59700000ULL,
    0xf108028c80000ULL,
    0x1294023f40000ULL,
    0x94460300a0000ULL,
    0xf2ed022910000ULL,
    0x92ed833fb8000ULL,
    0x42e74029a4000ULL,
    0xbaf363968e000ULL,
    0xee633d679000ULL,
    0x70f63a1f63800ULL,
    0x9de1a7f0b1c00ULL,
    0xfd63582123600ULL,
    0xee3a9703c3500ULL,
    0xdf50e0d7b8080ULL,
    0xbb7873c5a4040ULL,
    0x572eda108e0a0ULL,
    0x51cdd5f179030ULL,
    0x1d2b837be3868ULL,
    0x82ca4223f1cecULL,
    0x30bee0a7836faULL,
    0xc111720dd35fbULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0xf000000000000ULL,
    0x6800000000000ULL,
    0x6c00000000000ULL,
    0x6200000000000ULL,
    0x6900000000000ULL,
    0xc280000000000ULL,
    0xf2c0000000000ULL,
    0x5e60000000000ULL,
    0x7dd0000000000ULL,
    0x3bf8000000000ULL,
    0x269c000000000ULL,
    0xccc6000000000ULL,
    0x5d61000000000ULL,
    0x4a43800000000ULL,
    0x1b9400000000ULL,
    0x8f3ca00000000ULL,
    0x4fe2100000000ULL,
    0x809a780000000ULL,
    0xcbd41c0000000ULL,
    0x64e2a20000000ULL,
    0x7b0f130000000ULL,
    0x387f98000000ULL,
    0x3c405fc000000ULL,
    0x3ea383a000000ULL,
    0x22a942b000000ULL,
    0xe8a4a00800000ULL,
    0x8dae126400000ULL,
    0xdd247aaa00000ULL,
    0x2ee91e7b00000ULL,
    0xde0722f180000ULL,
    0x3307535340000ULL,
    0x3f80da65e0000ULL,
    0xa6470c9170000ULL,
    0xa3a359ea98000ULL,
    0x862e4e32c4000ULL,
    0x7d67fbceee000ULL,
    0x1a505df895000ULL,
    0xf9bb8025ea800ULL,
    0x7b2542f10c400ULL,
    0x29faa3fae7e00ULL,
    0xe783110af5700ULL,
    0x259f86298080ULL,
    0x3dad5f96c40c0ULL,
    0x153e00c4ee060ULL,
    0xd2fd0233950f0ULL,
    0x2405835c6a868ULL,
    0x5e1840064c46cULL,
    0xf31f229507e62ULL,
    0x5f8b525085769ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0xf000000000000ULL,
    0xb800000000000ULL,
    0xac00000000000ULL,
    0x4600000000000ULL,
    0x6b00000000000ULL,
    0xdf80000000000ULL,
    0xbec0000000000ULL,
    0x1fa0000000000ULL,
    0x37d0000000000ULL,
    0x9938000000000ULL,
    0x8784000000000ULL,
    0x82c6000000000ULL,
    0xb1a3000000000ULL,
    0xb8db800000000ULL,
    0x14a7c00000000ULL,
    0xb85ce00000000ULL,
    0x6ff5300000000ULL,
    0x8c29b80000000ULL,
    0x5f1b840000000ULL,
    0x582e20000000ULL,
    0x8bc2330000000ULL,
    0xf72c3a8000000ULL,
    0xa88b47c000000ULL,
    0xff5b80e000000ULL,
    0x3667c1b000000ULL,
    0xf9fce39800000ULL,
    0x6f25326c00000ULL,
    0x3491b99e00000ULL,
    0xa15f844b00000ULL,
    0x164e36680000ULL,
    0xd871327340000ULL,
    0x16efbb9ae0000ULL,
    0xb2b8872510000ULL,
    0x4359629598000ULL,
    0x5865f3a9cc000ULL,
    0xd6f0db1f8e000ULL,
    0x12be74208f000ULL,
    0xb3523b746b800ULL,
    0xe06c443258c00ULL,
    0x7ae6013548e00ULL,
    0x54b3009db1100ULL,
    0xd843838d98080ULL,
    0x3ff3c205cc0c0ULL,
    0xc422e0618e0a0ULL,
    0x4b1232db8f0f0ULL,
    0xef94390aeb8b8ULL,
    0xa6cf47ed18cacULL,
    0x43bd81d1a8e46ULL,
    0xc9d4c143a116bULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0xb000000000000ULL,
    0xa800000000000ULL,
    0xc00000000000ULL,
    0x2200000000000ULL,
    0x2700000000000ULL,
    0xf880000000000ULL,
    0x65c0000000000ULL,
    0x4c60000000000ULL,
    0xdd50000000000ULL,
    0x49b8000000000ULL,
    0x8124000000000ULL,
    0x8cfe000000000ULL,
    0x6c89000000000ULL,
    0x23db800000000ULL,
    0xe573400000000ULL,
    0x90d6600000000ULL,
    0x5bf7d00000000ULL,
    0x5c09980000000ULL,
    0x5a183c0000000ULL,
    0x930de20000000ULL,
    0xce84930000000ULL,
    0xc4dffa8000000ULL,
    0xbdefeec000000ULL,
    0x450478a000000ULL,
    0xbf9caf3000000ULL,
    0x8d52180800000ULL,
    0x31ab7d5c00000ULL,
    0x353b81c200000ULL,
    0xbae3406700000ULL,
    0xcd8e619980000ULL,
    0xd243d11940000ULL,
    0x7d2f98ece0000ULL,
    0x66e53f3f90000ULL,
    0x5790626878000ULL,
    0xe15ad0cc64000ULL,
    0x3ac19fa0e000ULL,
    0xa227db31d000ULL,
    0xe66000c7c1800ULL,
    0x8650029c2b400ULL,
    0x9b3800e250600ULL,
    0x7fe4031719f00ULL,
    0xb21e03f1f8080ULL,
    0xff1901d5240c0ULL,
    0xfc838116ee0a0ULL,
    0xfbc7428c8d0b0ULL,
    0xe17062afb98a8ULL,
    0xecad2504f40cULL,
    0xf6f419185e622ULL,
    0x8f967ea404f27ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0xd000000000000ULL,
    0x7800000000000ULL,
    0x7c00000000000ULL,
    0xe200000000000ULL,
    0x1100000000000ULL,
    0xb80000000000ULL,
    0x7ec0000000000ULL,
    0xf960000000000ULL,
    0x2550000000000ULL,
    0xbfa8000000000ULL,
    0x402c000000000ULL,
    0xa8e2000000000ULL,
    0x968b000000000ULL,
    0x9f41800000000ULL,
    0xa2b5400000000ULL,
    0xe1a8a00000000ULL,
    0x1325b00000000ULL,
    0x827a380000000ULL,
    0x4bde3c0000000ULL,
    0x1ce9220000000ULL,
    0xe090f10000000ULL,
    0x88529b8000000ULL,
    0xf63b8f4000000ULL,
    0x1ff31be000000ULL,
    0xf21eccf000000ULL,
    0xc913ba0800000ULL,
    0x47877e0400000ULL,
    0x34c3804e00000ULL,
    0xec6e424b00000ULL,
    0xb0c1220d80000ULL,
    0x327cf26140000ULL,
    0xa3d098b8a0000ULL,
    0xf8e08d4fb0000ULL,
    0xae9a98e008000ULL,
    0x3478e706c000ULL,
    0x90b91ac826000ULL,
    0x88b9cca425000ULL,
    0x64b0385e0a800ULL,
    0x1eb93c334ac00ULL,
    0xa3aaa3c1c6e00ULL,
    0x323eb30b31f00ULL,
    0x21f3baed88080ULL,
    0x31177c112c040ULL,
    0x7b8b8270860e0ULL,
    0x36d241eb950d0ULL,
    0x2d6b20be02878ULL,
    0xc34bf24326c7cULL,
    0x30bb1909e0ee2ULL,
    0xb8a2cfaf14f11ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0xf000000000000ULL,
    0x1800000000000ULL,
    0x3c00000000000ULL,
    0x3e00000000000ULL,
    0x9900000000000ULL,
    0xd380000000000ULL,
    0x13c0000000000ULL,
    0x3ee0000000000ULL,
    0x5850000000000ULL,
    0x5128000000000ULL,
    0xb8ac000000000ULL,
    0x6066000000000ULL,
    0x2207000000000ULL,
    0xf70d800000000ULL,
    0x4286c00000000ULL,
    0x1449a00000000ULL,
    0x3739300000000ULL,
    0xfda1180000000ULL,
    0x7df14c0000000ULL,
    0xb0c4220000000ULL,
    0x267ff10000000ULL,
    0x3708bb8000000ULL,
    0xe2987fc000000ULL,
    0x44d3a6000000ULL,
    0xdf22bdf000000ULL,
    0xd9aa997800000ULL,
    0x7fe08ca400000ULL,
    0x17c802ae00000ULL,
    0x6cfc027f00000ULL,
    0xf74e03e380000ULL,
    0xcfab003540000ULL,
    0x62eb8292a0000ULL,
    0xd641c039b0000ULL,
    0x302422cc18000ULL,
    0xa72ff3c25c000ULL,
    0x55a0b92d16000ULL,
    0xb9f47ec6eb000ULL,
    0x42cb3a6f9e800ULL,
    0x9975bed708c00ULL,
    0x418f196f8a600ULL,
    0x1cca4c5772300ULL,
    0xb067a12f98080ULL,
    0x6a0233f71c040ULL,
    0xc3029bbfb60e0ULL,
    0xa88c8eff5b0f0ULL,
    0x974e00a386818ULL,
    0x7fab011554c3cULL,
    0x9aeb82429c63eULL,
    0x1a41c39199399ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x9000000000000ULL,
    0x9800000000000ULL,
    0x6400000000000ULL,
    0x2e00000000000ULL,
    0xab00000000000ULL,
    0xfc80000000000ULL,
    0xe6c0000000000ULL,
    0xf8a0000000000ULL,
    0x2650000000000ULL,
    0xf468000000000ULL,
    0x2bec000000000ULL,
    0x8daa000000000ULL,
    0x39d7000000000ULL,
    0xf22a800000000ULL,
    0xef88c00000000ULL,
    0x4e50e00000000ULL,
    0xd879d00000000ULL,
    0x19e2f80000000ULL,
    0xfcbb240000000ULL,
    0xd85a620000000ULL,
    0x2761110000000ULL,
    0x237a1b8000000ULL,
    0xdd7ef64000000ULL,
    0xe7a986000000ULL,
    0x6e1349000000ULL,
    0x5620f93800000ULL,
    0x618025ec00000ULL,
    0x955ae01200000ULL,
    0x2cfed14b00000ULL,
    0x3207aba80000ULL,
    0x4e1fe5e540000ULL,
    0x7b0080fba0000ULL,
    0x849fc108b0000ULL,
    0x12da611e28000ULL,
    0x4ea113091c000ULL,
    0xe95a1a698a000ULL,
    0x26eef583d3000ULL,
    0x66329984cb800ULL,
    0x899d341c4b400ULL,
    0xf942f83a29e00ULL,
    0xfeeb24df23900ULL,
    0xe23263a4a8080ULL,
    0x378d12ec5c040ULL,
    0xca5018922a0e0ULL,
    0x6669f58b63090ULL,
    0x2af01b1ae3898ULL,
    0x6439f55557464ULL,
    0x10981833a3e2eULL,
    0x74d5f4ccf09abULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x9000000000000ULL,
    0xa800000000000ULL,
    0x6c00000000000ULL,
    0xf200000000000ULL,
    0xdf00000000000ULL,
    0x4280000000000ULL,
    0x15c0000000000ULL,
    0x5720000000000ULL,
    0x6350000000000ULL,
    0x4e8000000000ULL,
    0xed64000000000ULL,
    0x5c2a000000000ULL,
    0x57d9000000000ULL,
    0xf023800000000ULL,
    0x45dd400000000ULL,
    0x1f39600000000ULL,
    0x3f4a900000000ULL,
    0xcef0980000000ULL,
    0xf676140000000ULL,
    0x80bae20000000ULL,
    0x6f07d10000000ULL,
    0x3a81fa8000000ULL,
    0x71c8864000000ULL,
    0x592878a000000ULL,
    0xe65cc4b000000ULL,
    0xf57a9b4800000ULL,
    0x483f143c00000ULL,
    0xc1d1632a00000ULL,
    0x212e92a700000ULL,
    0x825a9ab480000ULL,
    0xfb6f150140000ULL,
    0xcd396271a0000ULL,
    0x304a902e90000ULL,
    0x8470986e28000ULL,
    0x1fb615b924000ULL,
    0x8d9ae325ae000ULL,
    0xbf57d3c8a5000ULL,
    0x8ee9f90b6d800ULL,
    0x566c86a69e400ULL,
    0x10a2783244600ULL,
    0xc715c4c359500ULL,
    0x56911adaa8080ULL,
    0x83d654b864040ULL,
    0x862a03540e0a0ULL,
    0xa4d902e635090ULL,
    0xe0a383e5458a8ULL,
    0x1f1d415fba46cULL,
    0xa29961b7ea6f2ULL,
    0x25da92bbfc5dfULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x5000000000000ULL,
    0x4800000000000ULL,
    0x4c00000000000ULL,
    0xd600000000000ULL,
    0x6300000000000ULL,
    0x9f80000000000ULL,
    0xbf40000000000ULL,
    0xb6a0000000000ULL,
    0x76d0000000000ULL,
    0x2ae8000000000ULL,
    0xffe4000000000ULL,
    0xb372000000000ULL,
    0x2ba5000000000ULL,
    0x764f800000000ULL,
    0x6425c00000000ULL,
    0xc102e00000000ULL,
    0x3e8bb00000000ULL,
    0x31d5c80000000ULL,
    0x3f70040000000ULL,
    0x1da5620000000ULL,
    0xe54a710000000ULL,
    0xe3a52a8000000ULL,
    0x7a5eb54000000ULL,
    0x123f2b2000000ULL,
    0xf21fb43000000ULL,
    0xe902abd800000ULL,
    0xc29f75cc00000ULL,
    0x5fcfcbde00000ULL,
    0x871078d00000ULL,
    0x5038e02280000ULL,
    0xa31ab12740000ULL,
    0x7f804a2da0000ULL,
    0x4f54c4fe90000ULL,
    0xaeba021148000ULL,
    0x72d10234d4000ULL,
    0xb0f5800e1e000ULL,
    0x4af4c18547000ULL,
    0x4ff760e6e3800ULL,
    0xb7f71bd6ac00ULL,
    0x7fa2aafa81200ULL,
    0xa44f766b13100ULL,
    0x9d27c8b3c8080ULL,
    0xeb95065394040ULL,
    0x7d4ae103be0a0ULL,
    0xa7bfb14bd7050ULL,
    0x404fc92fab848ULL,
    0xf7310645bec4cULL,
    0x4698e12a9f2d6ULL,
    0x85cab06354163ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x3000000000000ULL,
    0x9800000000000ULL,
    0x6400000000000ULL,
    0x600000000000ULL,
    0x6500000000000ULL,
    0x5580000000000ULL,
    0xb640000000000ULL,
    0x1760000000000ULL,
    0x15d0000000000ULL,
    0x7c28000000000ULL,
    0x633c000000000ULL,
    0x71be000000000ULL,
    0x9167000000000ULL,
    0x30de800000000ULL,
    0x49b1c00000000ULL,
    0xe569200000000ULL,
    0xfecbf00000000ULL,
    0xe0a1280000000ULL,
    0x4af2bc0000000ULL,
    0x4f9fa20000000ULL,
    0xc146310000000ULL,
    0xd9f6098000000ULL,
    0xc71e4cc000000ULL,
    0x1680086000000ULL,
    0xd6d54c9000000ULL,
    0x5ca88b9800000ULL,
    0x48ef8c5400000ULL,
    0x1c8928b600000ULL,
    0x69cebe8900000ULL,
    0x5e21a1a580000ULL,
    0x6021319340000ULL,
    0x71288b5ea0000ULL,
    0xeaaf8f91f0000ULL,
    0xf5e928b578000ULL,
    0x4d1ebdcfdc000ULL,
    0xe989a3a05a000ULL,
    0xb45d327077000ULL,
    0x447689487c800ULL,
    0xbd588fec03c00ULL,
    0xfbffab5226a00ULL,
    0xc4037e9721f00ULL,
    0x16168090f8080ULL,
    0xad1dc09c9c040ULL,
    0x999f209efa060ULL,
    0x4c40f17187030ULL,
    0x1069aa6504898ULL,
    0x23587e77dfc64ULL,
    0xfaf600447ca06ULL,
    0x978b026e56f65ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x1000000000000ULL,
    0x6800000000000ULL,
    0x5c00000000000ULL,
    0xaa00000000000ULL,
    0x5d00000000000ULL,
    0x9180000000000ULL,
    0x3440000000000ULL,
    0x4a0000000000ULL,
    0xf7d0000000000ULL,
    0x19e8000000000ULL,
    0xf4fc000000000ULL,
    0x3d7a000000000ULL,
    0x4d39000000000ULL,
    0xc79d800000000ULL,
    0xf35e400000000ULL,
    0xd023200000000ULL,
    0x7613f00000000ULL,
    0xb716e80000000ULL,
    0xac8bc40000000ULL,
    0xb5d6a20000000ULL,
    0x58f1b10000000ULL,
    0xaf6fc98000000ULL,
    0x4431344000000ULL,
    0xb015cba000000ULL,
    0x5808347000000ULL,
    0x4408492800000ULL,
    0x8e16743400000ULL,
    0xc30b686600000ULL,
    0x3a9584e100000ULL,
    0x52d5809a80000ULL,
    0xfc72429b40000ULL,
    0x56b120a9a0000ULL,
    0xded6f346f0000ULL,
    0x1e7169a968000ULL,
    0x27ac863ea4000ULL,
    0x9d48018556000ULL,
    0x432c0364c9000ULL,
    0x4492000644800ULL,
    0xa9c500711bc00ULL,
    0x92e780e2e5a00ULL,
    0xe267413702100ULL,
    0xbdbea0b3e8080ULL,
    0xd84db0e5e4040ULL,
    0xf6b5ca8cf6060ULL,
    0xeed8345239010ULL,
    0x66048872c868ULL,
    0x3aa767bbfc5cULL,
    0x3516b01b3aaaULL,
    0xe83c87b2cb15dULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0xf000000000000ULL,
    0xc800000000000ULL,
    0x6400000000000ULL,
    0x9a00000000000ULL,
    0xfd00000000000ULL,
    0xa680000000000ULL,
    0xecc0000000000ULL,
    0x8620000000000ULL,
    0x850000000000ULL,
    0xabe8000000000ULL,
    0xcef4000000000ULL,
    0x7466000000000ULL,
    0x8ea5000000000ULL,
    0xfb8e800000000ULL,
    0xfa58400000000ULL,
    0x82f0200000000ULL,
    0x1a7c100000000ULL,
    0xf1bcf80000000ULL,
    0xfc18740000000ULL,
    0x8616a20000000ULL,
    0xeb10510000000ULL,
    0x558ad88000000ULL,
    0xe55167c000000ULL,
    0x556cd92000000ULL,
    0x5e34649000000ULL,
    0x344258e800000ULL,
    0x4dfc253400000ULL,
    0xf5fa7b3a00000ULL,
    0x19e434e300000ULL,
    0xc7e881d080000ULL,
    0x50fd408540000ULL,
    0xc37ea1fda0000ULL,
    0xed24512cd0000ULL,
    0x1dccd81b18000ULL,
    0x6ea467ccd4000ULL,
    0x6b8a59ab1a000ULL,
    0xe25825b4f1000ULL,
    0xdef47b7778800ULL,
    0x2c75343af4400ULL,
    0xf2a000ee71e00ULL,
    0x3d90026904d00ULL,
    0x3148014b98080ULL,
    0x2764008994040ULL,
    0x372e0176ba020ULL,
    0xc0c10008210f0ULL,
    0x38208384608c8ULL,
    0x4f5942c220464ULL,
    0x70a07f6be9aULL,
    0x4cb5523ef5dfdULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x9000000000000ULL,
    0x8800000000000ULL,
    0x7400000000000ULL,
    0x6e00000000000ULL,
    0x2f00000000000ULL,
    0x7f80000000000ULL,
    0x4c40000000000ULL,
    0xfea0000000000ULL,
    0xc9d0000000000ULL,
    0x23e8000000000ULL,
    0x8ffc000000000ULL,
    0x3dea000000000ULL,
    0xf8e5000000000ULL,
    0xde68800000000ULL,
    0x3ebac00000000ULL,
    0xe9dc600000000ULL,
    0xd3ebb00000000ULL,
    0x97f0280000000ULL,
    0xc1ed840000000ULL,
    0xe2fce20000000ULL,
    0x9f7d710000000ULL,
    0x6e2e498000000ULL,
    0xda1f364000000ULL,
    0x610e482000000ULL,
    0xa08f34d000000ULL,
    0x2bc64a3800000ULL,
    0x4ee337fc00000ULL,
    0x2d64485e00000ULL,
    0xab2a37a100000ULL,
    0xfc8ecbe280000ULL,
    0x81c9f50b40000ULL,
    0x77f02969a0000ULL,
    0x11ed8522f0000ULL,
    0xafce2eb28000ULL,
    0x7b7d73d9d4000ULL,
    0x882e4bea82000ULL,
    0x811f37ff5b000ULL,
    0x708e4843f9800ULL,
    0xc3cf34e98ac00ULL,
    0xaae64962eaa00ULL,
    0xcb7337cb79100ULL,
    0xf02c4889a8080ULL,
    0xed06349294040ULL,
    0xe28cc8a322060ULL,
    0xf6d0f70dab090ULL,
    0x9472a910d1888ULL,
    0xd7b2468c5ec74ULL,
    0x3d4802f668a6eULL,
    0x962c03452212fULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x9000000000000ULL,
    0xe800000000000ULL,
    0xfc00000000000ULL,
    0x1200000000000ULL,
    0x6700000000000ULL,
    0xf480000000000ULL,
    0xeac0000000000ULL,
    0xbe60000000000ULL,
    0x4050000000000ULL,
    0xf9b8000000000ULL,
    0x89bc000000000ULL,
    0x31ba000000000ULL,
    0x45b9000000000ULL,
    0x3ba9800000000ULL,
    0xa6a9400000000ULL,
    0xc938600000000ULL,
    0xc568500000000ULL,
    0xf6c7780000000ULL,
    0xfc637c0000000ULL,
    0xaf49e20000000ULL,
    0x612d130000000ULL,
    0x997d198000000ULL,
    0x14ce2e4000000ULL,
    0xe37d19a000000ULL,
    0x4fce2cf000000ULL,
    0x65fd1bc800000ULL,
    0x520e2cdc00000ULL,
    0xc71d1bf200000ULL,
    0x49e2d1b00000ULL,
    0x92c51a9180000ULL,
    0xaa722e2d40000ULL,
    0xae47185ce0000ULL,
    0x8cb72ea1f0000ULL,
    0x1a34998568000ULL,
    0x2ff76c90a4000ULL,
    0x111d7a4bc6000ULL,
    0xc58a7d3a15000ULL,
    0x1f58614769800ULL,
    0xb93851a3f5400ULL,
    0x7d7f7b5633e00ULL,
    0x82df7cdd7cf00ULL,
    0x8273e294e8080ULL,
    0x325410fde40c0ULL,
    0xeb499b726060ULL,
    0x95376c6be5090ULL,
    0x277d7a8a018e8ULL,
    0xe9da7faf514fcULL,
    0x1ce0634ff5e12ULL,
    0xab84500c69f67ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0xf000000000000ULL,
    0x3800000000000ULL,
    0x7c00000000000ULL,
    0xb200000000000ULL,
    0xaf00000000000ULL,
    0xb880000000000ULL,
    0x54c0000000000ULL,
    0x4a60000000000ULL,
    0x8a50000000000ULL,
    0x77b8000000000ULL,
    0xc1ac000000000ULL,
    0x80b6000000000ULL,
    0x3533000000000ULL,
    0xbe65800000000ULL,
    0x5c5b400000000ULL,
    0x6a7600000000ULL,
    0xac3bd00000000ULL,
    0x87f7b80000000ULL,
    0x5d017c0000000ULL,
    0x379ae20000000ULL,
    0xfc5c930000000ULL,
    0xd6bedb8000000ULL,
    0x8435afc000000ULL,
    0x33e6dae000000ULL,
    0xab09aef000000ULL,
    0x5688db4800000ULL,
    0x59c6ae7c00000ULL,
    0x95e35b8200000ULL,
    0x2202ec6300000ULL,
    0xa717ba8180000ULL,
    0x1c917da540000ULL,
    0x6ac2e094e0000ULL,
    0x6f6091d9b0000ULL,
    0xe1d0d86158000ULL,
    0x29faaf228c000ULL,
    0x700d58c4f6000ULL,
    0xf80ded419d000ULL,
    0x9c1c3b4525800ULL,
    0x42053c64d3400ULL,
    0x970e0191f0e00ULL,
    0xc49f019d54f00ULL,
    0xe6d38160d8080ULL,
    0xe5684147cc0c0ULL,
    0x32c2e0b0160e0ULL,
    0x236091682d0f0ULL,
    0x8bd0dbec7d838ULL,
    0xafaaefa5f47cULL,
    0x428d5a3706eb2ULL,
    0x7fcded4fc9fafULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0xd000000000000ULL,
    0xc800000000000ULL,
    0x1400000000000ULL,
    0x8e00000000000ULL,
    0xcf00000000000ULL,
    0x7d80000000000ULL,
    0x5bc0000000000ULL,
    0x5320000000000ULL,
    0x4950000000000ULL,
    0x8578000000000ULL,
    0xb9ac000000000ULL,
    0x9312000000000ULL,
    0x279d000000000ULL,
    0xfac4800000000ULL,
    0x31b2c00000000ULL,
    0xa712600000000ULL,
    0x9984f00000000ULL,
    0x2ddf580000000ULL,
    0x9026340000000ULL,
    0x66c4e20000000ULL,
    0x8bab330000000ULL,
    0xd609bb8000000ULL,
    0x3310074000000ULL,
    0xd789d92000000ULL,
    0x2c9f75000000ULL,
    0x3db203b800000ULL,
    0xf50d037c00000ULL,
    0xcc9c815600000ULL,
    0x114ec27f00000ULL,
    0x7978605480000ULL,
    0x13b5f24940000ULL,
    0xca09d9dbe0000ULL,
    0x4909f4b5b0000ULL,
    0x469200f6c8000ULL,
    0x785d03d434000ULL,
    0xfe4833272000ULL,
    0x73e2c0453b000ULL,
    0x19ea61e5e1800ULL,
    0xa0e8f04ed7c00ULL,
    0x1e6d5b2827600ULL,
    0x6a2b352427d00ULL,
    0x37d8631a48080ULL,
    0x1125f2e1740c0ULL,
    0x3451dbbf920e0ULL,
    0x7df5f68f8b0d0ULL,
    0x16f80147a98c8ULL,
    0x3d6c01d3a3c14ULL,
    0x95b201c1b568eULL,
    0xf10d01d4acdcfULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x3000000000000ULL,
    0xa800000000000ULL,
    0x6400000000000ULL,
    0x9600000000000ULL,
    0x2300000000000ULL,
    0xf80000000000ULL,
    0x5040000000000ULL,
    0xc860000000000ULL,
    0xcd0000000000ULL,
    0x9fb8000000000ULL,
    0xa0fc000000000ULL,
    0x550e000000000ULL,
    0xdc81000000000ULL,
    0x97c6800000000ULL,
    0xcc21c00000000ULL,
    0xfaade00000000ULL,
    0xd477b00000000ULL,
    0xa6d8a80000000ULL,
    0x86ae9c0000000ULL,
    0x4e65620000000ULL,
    0x17d7730000000ULL,
    0xc33c98000000ULL,
    0x9ab8ecc000000ULL,
    0xe47028a000000ULL,
    0xede5e9000000ULL,
    0xe2b601d800000ULL,
    0xd87d034c00000ULL,
    0x34c8831e00000ULL,
    0x3a0c01100000ULL,
    0xcaeb63d980000ULL,
    0x2c16712f40000ULL,
    0x2154818e0000ULL,
    0x7d092f4ef0000ULL,
    0x7885c84bb8000ULL,
    0x61c5ed0044000ULL,
    0xdf38a8807a000ULL,
    0x5d3e9e4037000ULL,
    0xe03d61e06f800ULL,
    0xf8bb70f02ac00ULL,
    0xa965c8e840a00ULL,
    0xde55ef8439700ULL,
    0xe760aa4a38080ULL,
    0x91529f63040c0ULL,
    0x4aeb63869a060ULL,
    0xec16711fc7030ULL,
    0x62154a72578a8ULL,
    0x4d092cdf2ec64ULL,
    0xd085c870daa96ULL,
    0x5c5ee8afe723ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0x9000000000000ULL,
    0x5800000000000ULL,
    0x400000000000ULL,
    0x8200000000000ULL,
    0x500000000000ULL,
    0x580000000000ULL,
    0x5240000000000ULL,
    0x42e0000000000ULL,
    0xcad0000000000ULL,
    0x7128000000000ULL,
    0xe874000000000ULL,
    0x340a000000000ULL,
    0xa07000000000ULL,
    0x7916800000000ULL,
    0x1389400000000ULL,
    0x8d4b200000000ULL,
    0x4670700000000ULL,
    0x1f0aa80000000ULL,
    0x64804c0000000ULL,
    0x65d7a20000000ULL,
    0xddbe310000000ULL,
    0xd1b7088000000ULL,
    0x6fa97e4000000ULL,
    0x5cbe2b6000000ULL,
    0x163a0d1000000ULL,
    0x18e0008800000ULL,
    0x8bd0035400000ULL,
    0xd6a801f600000ULL,
    0x2f34031900000ULL,
    0x2b6a026380000ULL,
    0x9697032f40000ULL,
    0xc8de83daa0000ULL,
    0x342d42fcd0000ULL,
    0xcde921cda8000ULL,
    0xf643724a5c000ULL,
    0x10f6292b7a000ULL,
    0xb7de0cc4b5000ULL,
    0xe0a20121a4800ULL,
    0x603303900dc00ULL,
    0x77fc81c858a00ULL,
    0x475e43b438300ULL,
    0x5f75a32628080ULL,
    0xbc8d32311c040ULL,
    0x21cb8b07da020ULL,
    0x7fb73d2165090ULL,
    0x44ab8a8f8c858ULL,
    0x32273ef511c04ULL,
    0xae3893982a82ULL,
    0xd6c33c8c5d305ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x3000000000000ULL,
    0x9800000000000ULL,
    0x3400000000000ULL,
    0x2200000000000ULL,
    0x2b00000000000ULL,
    0xbd80000000000ULL,
    0x7940000000000ULL,
    0x2fe0000000000ULL,
    0x57d0000000000ULL,
    0xaf28000000000ULL,
    0x1b64000000000ULL,
    0xf81e000000000ULL,
    0xe40f000000000ULL,
    0x2a14800000000ULL,
    0xb711400000000ULL,
    0x3390e00000000ULL,
    0x4455700000000ULL,
    0x9b6e080000000ULL,
    0xb8072c0000000ULL,
    0x441a620000000ULL,
    0x1a0b310000000ULL,
    0x2f0a6a8000000ULL,
    0x7931cc000000ULL,
    0x664c886000000ULL,
    0xb07d6dd000000ULL,
    0x580000800000ULL,
    0x3d40016c00000ULL,
    0x35e0021600000ULL,
    0x78d001f500000ULL,
    0xa8a8025780000ULL,
    0x7d24012340000ULL,
    0x487e00c2a0000ULL,
    0xe19f012490000ULL,
    0x175c81a9f8000ULL,
    0x82e5432a7c000ULL,
    0x4b46e2ab72000ULL,
    0xecee73ee95000ULL,
    0xe64c89929b800ULL,
    0xf07d6eecf9c00ULL,
    0xa580032592200ULL,
    0xd4002ac65b00ULL,
    0xade003f678080ULL,
    0x4cd003653c040ULL,
    0x8aa8007fd20a0ULL,
    0x5624033f05030ULL,
    0xf5fe026ce3898ULL,
    0x98df00e5c5c34ULL,
    0x38bc834c40222ULL,
    0xd535416660b2bULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0xd000000000000ULL,
    0x6800000000000ULL,
    0x2400000000000ULL,
    0xaa00000000000ULL,
    0x9300000000000ULL,
    0xf480000000000ULL,
    0xc4c0000000000ULL,
    0x8da0000000000ULL,
    0xb750000000000ULL,
    0xcff8000000000ULL,
    0x5124000000000ULL,
    0x3792000000000ULL,
    0x9841000000000ULL,
    0xcd6a800000000ULL,
    0x40f2400000000ULL,
    0x83b3e00000000ULL,
    0x4e53500000000ULL,
    0x869b80000000ULL,
    0xb16e440000000ULL,
    0x16eb620000000ULL,
    0x86b0130000000ULL,
    0x1fc8da8000000ULL,
    0x4d2b574000000ULL,
    0x11833ba000000ULL,
    0x255c079000000ULL,
    0xd0f8822800000ULL,
    0x8bb3420c00000ULL,
    0x1a5960f200000ULL,
    0x1a6110c300000ULL,
    0x6e7a593e80000ULL,
    0x6c6d140140000ULL,
    0x7b7ad845e0000ULL,
    0xf5fa571b90000ULL,
    0xca31b9bac8000ULL,
    0x971a47ef44000ULL,
    0x4e81631cca000ULL,
    0x9fd5124a19000ULL,
    0x8d30586767800ULL,
    0xb1981780d9400ULL,
    0xf55a591044e00ULL,
    0xb8fd176874100ULL,
    0xafa2daac48080ULL,
    0xb04e55e2040c0ULL,
    0x897bb9ab2a0a0ULL,
    0x9aef4692890d0ULL,
    0xa8a1e2632f868ULL,
    0xf6d2532edd424ULL,
    0x42a339e96eeaaULL,
    0x5cc05a9fd193ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x1000000000000ULL,
    0x2800000000000ULL,
    0xcc00000000000ULL,
    0x4a00000000000ULL,
    0x8100000000000ULL,
    0x6180000000000ULL,
    0x4a40000000000ULL,
    0xdee0000000000ULL,
    0x2ed0000000000ULL,
    0x8338000000000ULL,
    0x6974000000000ULL,
    0x678a000000000ULL,
    0x4159000000000ULL,
    0x1e7f800000000ULL,
    0x151e400000000ULL,
    0x3f94a00000000ULL,
    0x5558f00000000ULL,
    0x8072280000000ULL,
    0x2a12cc0000000ULL,
    0x7101220000000ULL,
    0x798fb30000000ULL,
    0xbe41088000000ULL,
    0x70f07c4000000ULL,
    0x29d5aaa000000ULL,
    0x29a88c3000000ULL,
    0xc3a783a800000ULL,
    0x92ba414400000ULL,
    0xfb26a1a600000ULL,
    0x6d75f25900000ULL,
    0xd187aaf380000ULL,
    0xb2558d8f40000ULL,
    0x1aea00a2e0000ULL,
    0xb8c90188d0000ULL,
    0x602783e3a8000ULL,
    0x45fa40d724000ULL,
    0x646a1ae9e000ULL,
    0x54e5f27ae9000ULL,
    0x8fdfaa449a800ULL,
    0xf2b18ff1d7c00ULL,
    0xb3800601ea00ULL,
    0x757403d056300ULL,
    0x258a02b828080ULL,
    0x1c59001c640c0ULL,
    0x1dff82aa7e020ULL,
    0x125e42ab39010ULL,
    0xcaf4a3d4b2828ULL,
    0xb0c8f2e9b3cccULL,
    0xbc2a29cc60a4aULL,
    0x27f6cf126f381ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0xf000000000000ULL,
    0x9800000000000ULL,
    0xe400000000000ULL,
    0x7600000000000ULL,
    0xb500000000000ULL,
    0xe380000000000ULL,
    0xae40000000000ULL,
    0xfe20000000000ULL,
    0x94d0000000000ULL,
    0x9e8000000000ULL,
    0x1bbc000000000ULL,
    0x5786000000000ULL,
    0x9057000000000ULL,
    0xa72e800000000ULL,
    0x8d53c00000000ULL,
    0x18b1200000000ULL,
    0x2112300000000ULL,
    0x4d9ba80000000ULL,
    0x9f4a140000000ULL,
    0x9bb9a20000000ULL,
    0x1786f10000000ULL,
    0xf04c098000000ULL,
    0x5727e7c000000ULL,
    0x155d286000000ULL,
    0xfca5d69000000ULL,
    0x570e825800000ULL,
    0xf883c01400000ULL,
    0x7cd9206e00000ULL,
    0x35ee32e900000ULL,
    0xe9bda84080000ULL,
    0x648d171740000ULL,
    0x5edf2071a0000ULL,
    0xef93103f0000ULL,
    0xab3328a898000ULL,
    0xc74ed56b1c000ULL,
    0x5fa601239a000ULL,
    0xf1870298ff000ULL,
    0x2d4681437c800ULL,
    0xc8afc3bfe4c00ULL,
    0x2917231acca00ULL,
    0xc19533203b500ULL,
    0x955d2ab018080ULL,
    0xbca5d6685c040ULL,
    0x370e833c3a060ULL,
    0x883c0720f0f0ULL,
    0xe4d9202b64898ULL,
    0xd1ee3203b8ce4ULL,
    0x9fbda828f6a76ULL,
    0xd18d172b345b5ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x1000000000000ULL,
    0xd800000000000ULL,
    0x2400000000000ULL,
    0x8200000000000ULL,
    0x9100000000000ULL,
    0xa280000000000ULL,
    0x2f40000000000ULL,
    0x1920000000000ULL,
    0xed0000000000ULL,
    0x1df8000000000ULL,
    0x5e2c000000000ULL,
    0xb74a000000000ULL,
    0x1d3f000000000ULL,
    0x7cca800000000ULL,
    0x44f1400000000ULL,
    0xa1a00000000ULL,
    0x3e0a900000000ULL,
    0x1718880000000ULL,
    0x419fd40000000ULL,
    0xd4d9220000000ULL,
    0x68e8d30000000ULL,
    0x9eb9ab8000000ULL,
    0x191b044000000ULL,
    0x7e8a896000000ULL,
    0x795cd79000000ULL,
    0xc221a38800000ULL,
    0xc14a910400000ULL,
    0x36388a6a00000ULL,
    0x7b4fd46d00000ULL,
    0x9321230c80000ULL,
    0x83c4d1ef40000ULL,
    0x973ab75e0000ULL,
    0xba6407c1b0000ULL,
    0xb9e00953a8000ULL,
    0x1c3d9762bc000ULL,
    0xc65802684a000ULL,
    0xafbc015435000ULL,
    0x8b9200c24e800ULL,
    0x79c3019966400ULL,
    0x8c78827ee0200ULL,
    0xb2e2428e06500ULL,
    0xeba1225728080ULL,
    0xd984d3c9fc0c0ULL,
    0xd0d3aa17aa0e0ULL,
    0x1af4056885010ULL,
    0xc7b80915668d8ULL,
    0x478196109a424ULL,
    0xf7ca01094a282ULL,
    0x737f007683591ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0xf000000000000ULL,
    0xf800000000000ULL,
    0x5c00000000000ULL,
    0x2600000000000ULL,
    0x500000000000ULL,
    0xf280000000000ULL,
    0x9140000000000ULL,
    0x4360000000000ULL,
    0x8d0000000000ULL,
    0x61b8000000000ULL,
    0x8274000000000ULL,
    0x9056000000000ULL,
    0xfbe3000000000ULL,
    0x6281800000000ULL,
    0x795dc00000000ULL,
    0x3770200000000ULL,
    0x7adf100000000ULL,
    0xe6b1480000000ULL,
    0xfe91c0000000ULL,
    0xd09fa20000000ULL,
    0xde55d30000000ULL,
    0x4af6e88000000ULL,
    0xc218cfc000000ULL,
    0x9f0749e000000ULL,
    0x19a1e7000000ULL,
    0x6ec6221800000ULL,
    0x84ac10d400000ULL,
    0xa0e8c8aa00000ULL,
    0x910dcf500000ULL,
    0x1c81807580000ULL,
    0x105dc24740000ULL,
    0x3bf02254e0000ULL,
    0x429f1398d0000ULL,
    0x89514b66d8000ULL,
    0xcf791cf9cc000ULL,
    0x26c7a39966000ULL,
    0xc0b1d0dbe7000ULL,
    0xaf8e85078800ULL,
    0x221fcd8820400ULL,
    0x4f08c8bc1b200ULL,
    0x980dc661f700ULL,
    0xcad9818b58080ULL,
    0xfeb9c1aa8c0c0ULL,
    0x83fe208786020ULL,
    0xfe9811c6370f0ULL,
    0x7f5ec95b208f8ULL,
    0xc263dfe2ac45cULL,
    0x705803db9d226ULL,
    0x2be400d028705ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0xd000000000000ULL,
    0x5800000000000ULL,
    0x3c00000000000ULL,
    0x8200000000000ULL,
    0x5300000000000ULL,
    0x5c80000000000ULL,
    0xd3c0000000000ULL,
    0x67e0000000000ULL,
    0xb650000000000ULL,
    0x4fa8000000000ULL,
    0x58ec000000000ULL,
    0x70c2000000000ULL,
    0x137f000000000ULL,
    0x3191800000000ULL,
    0x1e49400000000ULL,
    0x5bbae00000000ULL,
    0x8ef6500000000ULL,
    0x15d3580000000ULL,
    0xfafe8c0000000ULL,
    0x53c1620000000ULL,
    0x27ec110000000ULL,
    0x565a3b8000000ULL,
    0x9fae9f4000000ULL,
    0xf15b6000000ULL,
    0x4cd18df000000ULL,
    0x9178e38800000ULL,
    0x6289530c00000ULL,
    0x42c2db9200000ULL,
    0x8877ccff00000ULL,
    0xe91b80f780000ULL,
    0xa38a426540000ULL,
    0xb54161c4a0000ULL,
    0xb2c1020b0000ULL,
    0x573a384e88000ULL,
    0x453e9d2bbc000ULL,
    0xae39586f66000ULL,
    0x1ead8f8fd5000ULL,
    0x1772e16143800ULL,
    0x1f8a521a95400ULL,
    0x77595a2d83600ULL,
    0xb83d8eb663300ULL,
    0xdbbae0b108080ULL,
    0xcef65302fc040ULL,
    0xf5d35959c60e0ULL,
    0x2afe8ea0650d0ULL,
    0xbc162504b858ULL,
    0x1bec12586943cULL,
    0xd45a3a1445682ULL,
    0xccae9ce606353ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x7000000000000ULL,
    0x3800000000000ULL,
    0xdc00000000000ULL,
    0x9200000000000ULL,
    0xf00000000000ULL,
    0x9780000000000ULL,
    0x7fc0000000000ULL,
    0xee20000000000ULL,
    0x4950000000000ULL,
    0x8b78000000000ULL,
    0xa824000000000ULL,
    0x5046000000000ULL,
    0x8deb000000000ULL,
    0x9571800000000ULL,
    0xbd33400000000ULL,
    0x8cc1600000000ULL,
    0x5bb9300000000ULL,
    0xa191580000000ULL,
    0x5ec4540000000ULL,
    0x34aee20000000ULL,
    0xe615730000000ULL,
    0x691fba8000000ULL,
    0x3e8125c000000ULL,
    0xe1495ae000000ULL,
    0x7f70547000000ULL,
    0xe30e2c800000ULL,
    0x594a72fc00000ULL,
    0x6370383e00000ULL,
    0x3c2d674f00000ULL,
    0x2647bb1080000ULL,
    0xccf5256940000ULL,
    0x9ff75abbe0000ULL,
    0x5a7f55a390000ULL,
    0x8aa760c798000ULL,
    0x8302335dec000ULL,
    0x8d98dbe8a6000ULL,
    0x34d317fd1d000ULL,
    0x47a983a9fd800ULL,
    0x9387404ad8c00ULL,
    0x21df60bc1b600ULL,
    0x9b26309e30500ULL,
    0x45dedb9f18080ULL,
    0x15381508ac0c0ULL,
    0x78d8018d460a0ULL,
    0xfdb402618d070ULL,
    0xa89e0036e5838ULL,
    0xb05f014274cdcULL,
    0x9def83315d692ULL,
    0x7d6c41ffbd50fULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x9000000000000ULL,
    0x3800000000000ULL,
    0x5400000000000ULL,
    0x5a00000000000ULL,
    0xf00000000000ULL,
    0xc680000000000ULL,
    0x6040000000000ULL,
    0x4aa0000000000ULL,
    0x17d0000000000ULL,
    0xd178000000000ULL,
    0x38a4000000000ULL,
    0xb4da000000000ULL,
    0xb9eb000000000ULL,
    0x9dfc800000000ULL,
    0xff6400000000ULL,
    0x5cf0600000000ULL,
    0x3c77100000000ULL,
    0x652fa80000000ULL,
    0xe813e40000000ULL,
    0xc0ee20000000ULL,
    0x3e1e530000000ULL,
    0xfd014a8000000ULL,
    0xa59db64000000ULL,
    0xa8d7aae000000ULL,
    0x7ff7e65000000ULL,
    0x94f4e1e800000ULL,
    0x6065517c00000ULL,
    0xc325c97a00000ULL,
    0xd11ff69100000ULL,
    0xcb85caa280000ULL,
    0xcdcff63340000ULL,
    0x1e7dc9b7e0000ULL,
    0x5e2bf41f90000ULL,
    0x4487c883e8000ULL,
    0xcb50f729ec000ULL,
    0xde23491092000ULL,
    0x8492b4ae09000ULL,
    0x6b512af749800ULL,
    0x4e3aa759e0400ULL,
    0xbc800208a4a00ULL,
    0x3f40008a7a900ULL,
    0x1420014968080ULL,
    0xb3900226ac0c0ULL,
    0xf9d8013d720a0ULL,
    0x7474037099090ULL,
    0xf92203be21838ULL,
    0xee0f017f4c454ULL,
    0xa5068135d6a5aULL,
    0xc18d40fae390fULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x3000000000000ULL,
    0xb800000000000ULL,
    0x3400000000000ULL,
    0x9200000000000ULL,
    0xdd00000000000ULL,
    0xff80000000000ULL,
    0xdcc0000000000ULL,
    0x9e20000000000ULL,
    0xee30000000000ULL,
    0x7628000000000ULL,
    0x9234000000000ULL,
    0x8832000000000ULL,
    0xd925000000000ULL,
    0x80a3800000000ULL,
    0x1371c00000000ULL,
    0xafca600000000ULL,
    0x62a5900000000ULL,
    0x5676080000000ULL,
    0xb441cc0000000ULL,
    0xa4760a0000000ULL,
    0x9941cf0000000ULL,
    0x3f6098000000ULL,
    0x4181cfc000000ULL,
    0xb7d60b6000000ULL,
    0x46b1cf1000000ULL,
    0xac7e092800000ULL,
    0xd545cc6400000ULL,
    0x45ec0ad600000ULL,
    0x3e90cf1700000ULL,
    0x2d4788ae80000ULL,
    0x51e50cafc0000ULL,
    0x7c97e97620000ULL,
    0x78519ee710000ULL,
    0x22706356e8000ULL,
    0x644918384000ULL,
    0xa96f8b5466000ULL,
    0xeed10ece43000ULL,
    0x5325e86b4f800ULL,
    0x79b49c84d5400ULL,
    0x16f3e05297a00ULL,
    0x12055245d2700ULL,
    0x1d0de86b4f880ULL,
    0x1f809c84d54c0ULL,
    0xecc1e05297ae0ULL,
    0x26205245d2730ULL,
    0xda2e686b4f838ULL,
    0xe4315c84d54f4ULL,
    0x4f2b805297a72ULL,
    0x77b5c245d27edULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0xb000000000000ULL,
    0x800000000000ULL,
    0xcc00000000000ULL,
    0x9200000000000ULL,
    0xb900000000000ULL,
    0x1080000000000ULL,
    0xf3c0000000000ULL,
    0xb420000000000ULL,
    0xe430000000000ULL,
    0x1c38000000000ULL,
    0xb834000000000ULL,
    0x5622000000000ULL,
    0x7523000000000ULL,
    0x10ba800000000ULL,
    0x61e8c00000000ULL,
    0x9f1fe00000000ULL,
    0xdf8df00000000ULL,
    0xd45b880000000ULL,
    0xc4610c0000000ULL,
    0xce5b8a0000000ULL,
    0xf1610d0000000ULL,
    0x2cdb8b8000000ULL,
    0xba10fc000000ULL,
    0x807b8ba000000ULL,
    0xd0510cf000000ULL,
    0xba6389e800000ULL,
    0x35550e1400000ULL,
    0xe0f989aa00000ULL,
    0xb820ddb00000ULL,
    0x12410b7a80000ULL,
    0xfb79ce4bc0000ULL,
    0x81dc6b0a60000ULL,
    0xfd28fcab10000ULL,
    0x9cba0252e8000ULL,
    0x93e7017f9c000ULL,
    0x9600801002000ULL,
    0xc70fc1f83f000ULL,
    0xeb9f63ec7d800ULL,
    0xe242304608c00ULL,
    0x9364e89d13a00ULL,
    0xfdd33c678cf00ULL,
    0x672763ec7d880ULL,
    0xe9b6304608c40ULL,
    0x1166e89d13a60ULL,
    0xdcc03c678cfb0ULL,
    0x63a5e3ec7d888ULL,
    0xfc6af04608c8cULL,
    0x4a5b089d13af2ULL,
    0xcf6ecc678cf09ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x9000000000000ULL,
    0x9800000000000ULL,
    0xec00000000000ULL,
    0x2a00000000000ULL,
    0x2700000000000ULL,
    0xa980000000000ULL,
    0x940000000000ULL,
    0x11e0000000000ULL,
    0x99f0000000000ULL,
    0x2de8000000000ULL,
    0x8be4000000000ULL,
    0x16f6000000000ULL,
    0x65000000000ULL,
    0x4cb8800000000ULL,
    0x7e1dc00000000ULL,
    0xd109200000000ULL,
    0xcc84100000000ULL,
    0x63c9380000000ULL,
    0xef39040000000ULL,
    0x60493a0000000ULL,
    0x179070000000ULL,
    0xb8293b8000000ULL,
    0x1c9054000000ULL,
    0x1c2139e000000ULL,
    0xffdd06f000000ULL,
    0xd3f394800000ULL,
    0x535c066c00000ULL,
    0xfef1bbee00000ULL,
    0x2464c64900000ULL,
    0x72a01ba980000ULL,
    0xf0d142ec0000ULL,
    0xed88031e20000ULL,
    0xa754020150000ULL,
    0xf8fe0145f8000ULL,
    0x49710100c4000ULL,
    0x6c2681f71a000ULL,
    0x37dcc2b8b3000ULL,
    0x1927a0d33e800ULL,
    0x54cd23aa3400ULL,
    0x6bf099f41a600ULL,
    0x46f4d51a47500ULL,
    0xf87720d33e880ULL,
    0x30b5123aa34c0ULL,
    0xcc0fb9f41a660ULL,
    0x1a15c51a47590ULL,
    0x4f0698d33e818ULL,
    0x4d91d63aa342cULL,
    0x574fa3f41a64aULL,
    0xf0e8d21a475b7ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x1000000000000ULL,
    0xf800000000000ULL,
    0x8400000000000ULL,
    0x2600000000000ULL,
    0xa700000000000ULL,
    0x3a80000000000ULL,
    0x9ec0000000000ULL,
    0x4fe0000000000ULL,
    0x87f0000000000ULL,
    0x4bf8000000000ULL,
    0xe1e4000000000ULL,
    0xce6000000000ULL,
    0xcb79000000000ULL,
    0x6a29800000000ULL,
    0x8d400000000ULL,
    0xcbc9a00000000ULL,
    0xec66f00000000ULL,
    0x10b9280000000ULL,
    0x7e5ad40000000ULL,
    0x94392a0000000ULL,
    0x939ad50000000ULL,
    0xdf59298000000ULL,
    0xb9aad54000000ULL,
    0x3fc12a6000000ULL,
    0x627ed75000000ULL,
    0x2bbf2af800000ULL,
    0xf6d3d5cc00000ULL,
    0x73e8aa1200000ULL,
    0xc5f397b700000ULL,
    0xdaf68b2d80000ULL,
    0x847525a8c0000ULL,
    0x2cb1820260000ULL,
    0x3c59422f50000ULL,
    0x537a031f8000ULL,
    0xf60bf002b4000ULL,
    0xff0eaa195e000ULL,
    0x4e8a944081000ULL,
    0x50df08d678800ULL,
    0x94f864e11ac00ULL,
    0x1f78238c9c200ULL,
    0x543fb3c471900ULL,
    0x338e88d678880ULL,
    0x2f5124e11ac40ULL,
    0x51b7838c9c2e0ULL,
    0x43d043c471910ULL,
    0xc06620d678878ULL,
    0xaaa2b0e11acc4ULL,
    0x6b41098c9c2c6ULL,
    0xd7a566c4719b7ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0x3000000000000ULL,
    0x2800000000000ULL,
    0x3400000000000ULL,
    0x7600000000000ULL,
    0x5300000000000ULL,
    0xb180000000000ULL,
    0x5740000000000ULL,
    0xf5e0000000000ULL,
    0x4bf0000000000ULL,
    0x7cf8000000000ULL,
    0x837c000000000ULL,
    0xab3a000000000ULL,
    0x855f000000000ULL,
    0x88e9800000000ULL,
    0x957f400000000ULL,
    0xe839200000000ULL,
    0x2ccd100000000ULL,
    0xc3b4f80000000ULL,
    0x2291c40000000ULL,
    0x86ccfa0000000ULL,
    0xb2adc50000000ULL,
    0xa616fa8000000ULL,
    0x2b02c5c000000ULL,
    0xbd877a2000000ULL,
    0xd41851000000ULL,
    0xcce45bf800000ULL,
    0xeb63945c00000ULL,
    0xbf21213e00000ULL,
    0xc341110100000ULL,
    0xf3f6f8e980000ULL,
    0x10f2c52ec0000ULL,
    0xc97f7b9a60000ULL,
    0x8a3d86e330000ULL,
    0x39de591688000ULL,
    0x93c94e64c000ULL,
    0xf048a24d2e000ULL,
    0x527e532fb1000ULL,
    0x5fafd8f3ca800ULL,
    0x208fd68d85400ULL,
    0x83d3806c99600ULL,
    0x602043b502500ULL,
    0x68d0a273ca880ULL,
    0xbdb2534d85440ULL,
    0x758dda4c99620ULL,
    0x695cd6a502530ULL,
    0x82f8018bca8a8ULL,
    0x947c031185474ULL,
    0x64ba017299656ULL,
    0x851f02a402563ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0x5000000000000ULL,
    0x9800000000000ULL,
    0xc00000000000ULL,
    0x6a00000000000ULL,
    0x8500000000000ULL,
    0x3080000000000ULL,
    0xd7c0000000000ULL,
    0x7ae0000000000ULL,
    0x9cf0000000000ULL,
    0x33f8000000000ULL,
    0xa67c000000000ULL,
    0x1136000000000ULL,
    0x2405000000000ULL,
    0xce14800000000ULL,
    0xb11c00000000ULL,
    0x1b85600000000ULL,
    0x9c49700000000ULL,
    0x7ea0880000000ULL,
    0xee5e540000000ULL,
    0xb7b88a0000000ULL,
    0x94d2550000000ULL,
    0xb5768a8000000ULL,
    0x46ab544000000ULL,
    0xf25408e000000ULL,
    0x65bf947000000ULL,
    0x4dc5e94800000ULL,
    0x77e7266400000ULL,
    0x1860018a00000ULL,
    0xd230013b00000ULL,
    0xab98026180000ULL,
    0x344c0248c0000ULL,
    0x9aae022e60000ULL,
    0x4049019130000ULL,
    0xccba800ab8000ULL,
    0x4758c13124000ULL,
    0xbd3fe29aea000ULL,
    0x5e11b30963000ULL,
    0xf31f6a36ff800ULL,
    0x678fe62746c00ULL,
    0x3e47e027fda00ULL,
    0x6fadb2edff900ULL,
    0xb8c968b6ff880ULL,
    0x8f7ae66746c40ULL,
    0x5bab62c7fda20ULL,
    0xcec0739dff950ULL,
    0xd87a0b7eff818ULL,
    0xb236944346c4cULL,
    0xdb9f6badfda4aULL,
    0xfc4fe6d6ff9d5ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0xd000000000000ULL,
    0x4800000000000ULL,
    0xa400000000000ULL,
    0xb600000000000ULL,
    0x6900000000000ULL,
    0x5680000000000ULL,
    0x1840000000000ULL,
    0x4e20000000000ULL,
    0xcc30000000000ULL,
    0xbb28000000000ULL,
    0xd0ac000000000ULL,
    0xb076000000000ULL,
    0x631f000000000ULL,
    0xa59b800000000ULL,
    0x15d5400000000ULL,
    0xffc600000000ULL,
    0xeddcb00000000ULL,
    0xd3feb80000000ULL,
    0x47cffc0000000ULL,
    0x30f6ba0000000ULL,
    0x2253ff0000000ULL,
    0x528ba8000000ULL,
    0xfda0fc4000000ULL,
    0xa0e53ba000000ULL,
    0x8a5abed000000ULL,
    0x512ad97800000ULL,
    0xd3bf4f7400000ULL,
    0x25fe002200000ULL,
    0xcec3031500000ULL,
    0x9665831a80000ULL,
    0xa2164325c0000ULL,
    0xa719e17620000ULL,
    0x238af32770000ULL,
    0xc4c75a97f8000ULL,
    0x65750c3b0c000ULL,
    0xaf99e0d996000ULL,
    0xe6caf2c859000ULL,
    0x2675b3c67800ULL,
    0xac050d5e2bc00ULL,
    0xf211e2eb1d600ULL,
    0x2f16f1a1d4300ULL,
    0xa79959bc67880ULL,
    0xa2c60d1e2bcc0ULL,
    0x4474634b1d620ULL,
    0x5d00b071d43d0ULL,
    0x4880ba44678c8ULL,
    0x254cfe2a2bc64ULL,
    0x36b338c91d696ULL,
    0x5175bdb4d43b9ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x3000000000000ULL,
    0x3800000000000ULL,
    0xc400000000000ULL,
    0xe600000000000ULL,
    0x8500000000000ULL,
    0x2380000000000ULL,
    0x39c0000000000ULL,
    0x84e0000000000ULL,
    0x5ef0000000000ULL,
    0x19f8000000000ULL,
    0xc96c000000000ULL,
    0x5e2a000000000ULL,
    0x3c8d000000000ULL,
    0xfd45800000000ULL,
    0x5db1400000000ULL,
    0x7545e00000000ULL,
    0xe1bf900000000ULL,
    0xf753a80000000ULL,
    0xb2b1b40000000ULL,
    0x69cbaa0000000ULL,
    0x6cedb50000000ULL,
    0x32f9a88000000ULL,
    0x33fcb5c000000ULL,
    0x566e286000000ULL,
    0xdaacf6d000000ULL,
    0x45c44bf800000ULL,
    0xe6ef24c400000ULL,
    0x9df7837600000ULL,
    0x8f60402300000ULL,
    0xeb32636580000ULL,
    0x271fd058c0000ULL,
    0x81c98260000ULL,
    0x3f5e67bd70000ULL,
    0xaeb2621ac8000ULL,
    0xdbdfd15f44000ULL,
    0x7e1caf7de000ULL,
    0x686e67fd81000ULL,
    0xbaa63ccc9800ULL,
    0x8843d24c7f400ULL,
    0xa633c9fa07200ULL,
    0x188f653979900ULL,
    0x8b45e34cc9880ULL,
    0xd0bf938c7f440ULL,
    0xaad3ab9a072a0ULL,
    0xfa71b6e979930ULL,
    0x10aba834c98b8ULL,
    0x4addb6887f484ULL,
    0x6a61aa8c07246ULL,
    0x18a0b51a799b5ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x5000000000000ULL,
    0x8800000000000ULL,
    0xac00000000000ULL,
    0x5e00000000000ULL,
    0x2d00000000000ULL,
    0xf880000000000ULL,
    0x88c0000000000ULL,
    0x5ea0000000000ULL,
    0x13b0000000000ULL,
    0xfb38000000000ULL,
    0x1be4000000000ULL,
    0xb94e000000000ULL,
    0x7cef000000000ULL,
    0x6c2800000000ULL,
    0xbbad400000000ULL,
    0xa726e00000000ULL,
    0x7df6f00000000ULL,
    0xe055680000000ULL,
    0xfe6bfc0000000ULL,
    0x511b6a0000000ULL,
    0x6e84fd0000000ULL,
    0xe9d9e98000000ULL,
    0xa829bc4000000ULL,
    0x3e7f0ba000000ULL,
    0xf11f4ef000000ULL,
    0xde8a62d800000ULL,
    0x31c4b24400000ULL,
    0x8c290b3a00000ULL,
    0xcc644d6700000ULL,
    0x821ee3c080000ULL,
    0xb12f169c0000ULL,
    0x419b6b8c60000ULL,
    0x5a44fff650000ULL,
    0x8179ebb158000ULL,
    0x6a99bc41ec000ULL,
    0xebc7089052000ULL,
    0xe33b4fc859000ULL,
    0x9fe463cc49800ULL,
    0xfb5bb25642c00ULL,
    0xd7f38a417c200ULL,
    0xf75d0e19bd300ULL,
    0x39ee011449880ULL,
    0x25f001242c40ULL,
    0xe57a817b7c2e0ULL,
    0x7889437ebd350ULL,
    0xc8c8e2d4c9808ULL,
    0xbea9f17b82cecULL,
    0x43afeaf71c2beULL,
    0x7322bc88ed37dULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0xf000000000000ULL,
    0xa800000000000ULL,
    0xf400000000000ULL,
    0xf600000000000ULL,
    0xbf00000000000ULL,
    0x7c80000000000ULL,
    0x7c0000000000ULL,
    0x4ee0000000000ULL,
    0x81f0000000000ULL,
    0x9568000000000ULL,
    0xc6bc000000000ULL,
    0x8e42000000000ULL,
    0x18a7000000000ULL,
    0x551800000000ULL,
    0x3233400000000ULL,
    0x4d86a00000000ULL,
    0xa85e300000000ULL,
    0x3fa7480000000ULL,
    0x85c1d40000000ULL,
    0xc7e54a0000000ULL,
    0xe266d70000000ULL,
    0x1e34c88000000ULL,
    0x279594c000000ULL,
    0xb5526a2000000ULL,
    0xfa3ba71000000ULL,
    0xe99d21f800000ULL,
    0x64671ec00000ULL,
    0xdcba6a0a00000ULL,
    0xfb47a6f300000ULL,
    0x893f23b180000ULL,
    0x6f117034c0000ULL,
    0xe483ebc420000ULL,
    0xfbc8e43e30000ULL,
    0xbcfb800528000ULL,
    0x60e841b0ac000ULL,
    0xa2f5201a6e000ULL,
    0x4bfa708b61000ULL,
    0x78786a1df4800ULL,
    0xab20a6ded9c00ULL,
    0x160ea30749a00ULL,
    0x2f1233e7ee900ULL,
    0x848d4be5f4880ULL,
    0xabdad732d9cc0ULL,
    0xe4f6c90d49aa0ULL,
    0x3cf29514ee9f0ULL,
    0xa0e3e85474828ULL,
    0x2f8e70619c34ULL,
    0xbbf382c969a56ULL,
    0xd064412ade94fULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x9000000000000ULL,
    0x8800000000000ULL,
    0x1c00000000000ULL,
    0x1600000000000ULL,
    0xb900000000000ULL,
    0x3f80000000000ULL,
    0x2a40000000000ULL,
    0xf3e0000000000ULL,
    0x62f0000000000ULL,
    0xf168000000000ULL,
    0x3534000000000ULL,
    0x7bc6000000000ULL,
    0xa4a7000000000ULL,
    0xcc8c800000000ULL,
    0x9ada400000000ULL,
    0x2f3b600000000ULL,
    0x9cd3900000000ULL,
    0xde3e580000000ULL,
    0x5f44640000000ULL,
    0x72785a0000000ULL,
    0x9da3670000000ULL,
    0x3314d98000000ULL,
    0x5089254000000ULL,
    0x4cc7bba000000ULL,
    0x762eb53000000ULL,
    0x335fe3f800000ULL,
    0x7c7dd3d400000ULL,
    0xb0a3390600000ULL,
    0x680f47d00000ULL,
    0xd5c2834980000ULL,
    0x39b940b6c0000ULL,
    0x119e32c20000ULL,
    0x1b9ad15210000ULL,
    0xd84fbb3b38000ULL,
    0x58eab7148c000ULL,
    0x6671e08f0a000ULL,
    0x57aed042e5000ULL,
    0x7c09bada67800ULL,
    0x460db4b76b400ULL,
    0xd11d62f6bee00ULL,
    0xb384910c6ad00ULL,
    0xb45ad92267880ULL,
    0x56ea27636b4c0ULL,
    0x4b653bf0beee0ULL,
    0x6227f5716ad90ULL,
    0xf94e026be7808ULL,
    0x336303d5ab4dcULL,
    0xa62282dc9eef6ULL,
    0x9b4943237ad29ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0xd000000000000ULL,
    0x5800000000000ULL,
    0x2c00000000000ULL,
    0x1200000000000ULL,
    0x3100000000000ULL,
    0xe80000000000ULL,
    0x1f40000000000ULL,
    0x62e0000000000ULL,
    0x1bf0000000000ULL,
    0x8178000000000ULL,
    0xd02c000000000ULL,
    0x19d6000000000ULL,
    0x49ad000000000ULL,
    0xe710800000000ULL,
    0x699ec00000000ULL,
    0x36dee00000000ULL,
    0xf43a300000000ULL,
    0x3fdd580000000ULL,
    0xe6a5c40000000ULL,
    0x1a8b5a0000000ULL,
    0x1148c50000000ULL,
    0x69fbd88000000ULL,
    0x8066064000000ULL,
    0xf6bd39e000000ULL,
    0xa28036f000000ULL,
    0x4d4e61a800000ULL,
    0xf3e4f23400000ULL,
    0xc563bb9200000ULL,
    0xc62ff74900000ULL,
    0x9ece029980000ULL,
    0x10310166c0000ULL,
    0xf9de817c60000ULL,
    0x39afc0d670000ULL,
    0x6f0062b338000ULL,
    0x1d95f2c4c4000ULL,
    0x8dd383d7a000ULL,
    0xd730376bbf000ULL,
    0x56631f81800ULL,
    0xf778f16d97c00ULL,
    0x672db8d494e00ULL,
    0x685ef7e570d00ULL,
    0xf37082b781880ULL,
    0xd12ec35997c40ULL,
    0x3f46e34694ea0ULL,
    0xf2e630ac70dd0ULL,
    0xe3f3582e018d8ULL,
    0x7d64c63f57c6cULL,
    0x9a2dd83af4eb2ULL,
    0x4cb057a00de1ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0xf000000000000ULL,
    0xf800000000000ULL,
    0xa400000000000ULL,
    0x1a00000000000ULL,
    0xa700000000000ULL,
    0x8880000000000ULL,
    0x6b40000000000ULL,
    0x720000000000ULL,
    0x830000000000ULL,
    0x6cb8000000000ULL,
    0x61fc000000000ULL,
    0x8fc2000000000ULL,
    0x4a6d000000000ULL,
    0xc601800000000ULL,
    0x591ec00000000ULL,
    0x1598200000000ULL,
    0xb4cc300000000ULL,
    0x1cf4d80000000ULL,
    0xc04cfc0000000ULL,
    0x79b6da0000000ULL,
    0xa261fd0000000ULL,
    0xa175a8000000ULL,
    0xcf0f3ec000000ULL,
    0x497796000000ULL,
    0xdd4f0c5000000ULL,
    0xe639a10800000ULL,
    0x99a2f2cc00000ULL,
    0x3274f92a00000ULL,
    0x220cce6100000ULL,
    0x631803b680000ULL,
    0x428c0081c0000ULL,
    0xc45a036460000ULL,
    0xd3a1015630000ULL,
    0xdd7b825368000ULL,
    0xd68fc3b384000ULL,
    0x465ba0e16e000ULL,
    0xbff376ff000ULL,
    0x47ed7ae18e800ULL,
    0x46de0eb40fc00ULL,
    0x77fa231e3de00ULL,
    0xded130bf0c300ULL,
    0x3ed5be98e880ULL,
    0xccde3c780fc40ULL,
    0xf8f4fa343de20ULL,
    0xfa4ccede0c3f0ULL,
    0x2eb8005f0e878ULL,
    0xd2fc00f9cfce4ULL,
    0xc54203505de3aULL,
    0xd22d02883c357ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x3000000000000ULL,
    0xd800000000000ULL,
    0x1c00000000000ULL,
    0x4600000000000ULL,
    0xd100000000000ULL,
    0x2080000000000ULL,
    0x4240000000000ULL,
    0xae20000000000ULL,
    0xfb30000000000ULL,
    0xe1a8000000000ULL,
    0xa4fc000000000ULL,
    0x135a000000000ULL,
    0x4eb1000000000ULL,
    0x197a800000000ULL,
    0x7f9e400000000ULL,
    0x87c6600000000ULL,
    0xeee7700000000ULL,
    0xac53b80000000ULL,
    0xdb233c0000000ULL,
    0x11a9ba0000000ULL,
    0xdce23f0000000ULL,
    0x3f5b388000000ULL,
    0xd0b07fc000000ULL,
    0xd46f5be000000ULL,
    0x191a0fb000000ULL,
    0x149c62f800000ULL,
    0x605670f400000ULL,
    0x1529387a00000ULL,
    0x94bd7efd00000ULL,
    0x4e6fda4280000ULL,
    0x2e054ed1c0000ULL,
    0xd508802420000ULL,
    0xda9340f230000ULL,
    0xe546e01148000ULL,
    0x87b831fcf4000ULL,
    0x85e75b6ea2000ULL,
    0x4bd60e8f8d000ULL,
    0x20ee622b3b800ULL,
    0x295b70a1d0c00ULL,
    0x49a9b83c55600ULL,
    0xe23e366c300ULL,
    0xd95b38d33b880ULL,
    0x31b07c55d0cc0ULL,
    0x2cef5a46556a0ULL,
    0x475a0fcb6c330ULL,
    0xfcbc6211bb858ULL,
    0x4a66714410cdcULL,
    0xd4013b82756e6ULL,
    0x72017f895c3e1ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0xd000000000000ULL,
    0xf800000000000ULL,
    0x4c00000000000ULL,
    0x6a00000000000ULL,
    0x8f00000000000ULL,
    0x4380000000000ULL,
    0x240000000000ULL,
    0x7fa0000000000ULL,
    0xf4b0000000000ULL,
    0x5928000000000ULL,
    0xfa6c000000000ULL,
    0x4756000000000ULL,
    0xa339000000000ULL,
    0x6d78800000000ULL,
    0xb8c9c00000000ULL,
    0xe376200000000ULL,
    0x29d3500000000ULL,
    0x29e9980000000ULL,
    0x5d14ac0000000ULL,
    0x609f9a0000000ULL,
    0xdbddaf0000000ULL,
    0xdaef1a8000000ULL,
    0x7c886c4000000ULL,
    0x89c7396000000ULL,
    0x39fe3d7000000ULL,
    0x850820c800000ULL,
    0xfc86534c00000ULL,
    0x49c71bc600000ULL,
    0x19e46c4500000ULL,
    0x551138b880000ULL,
    0x4873fd7c0000ULL,
    0x5d0a2bc20000ULL,
    0x73ff924e70000ULL,
    0xda193be978000ULL,
    0x471b3cce94000ULL,
    0x78ea07a9a000ULL,
    0xc5a9058b3000ULL,
    0x2ebfba67c2800ULL,
    0x1e37fe543e400ULL,
    0xfdfe029244e00ULL,
    0x4b1500571cf00ULL,
    0x8d8e82afc2880ULL,
    0x7340c1183e4c0ULL,
    0x4526a35444e20ULL,
    0xa87693121cfd0ULL,
    0xa449b89742878ULL,
    0x5abefe8ffe48cULL,
    0x182e828864e4aULL,
    0xc8f0c32c6cf5fULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0xd000000000000ULL,
    0xf800000000000ULL,
    0x1400000000000ULL,
    0xe600000000000ULL,
    0x9900000000000ULL,
    0x4780000000000ULL,
    0xef40000000000ULL,
    0x4de0000000000ULL,
    0x12f0000000000ULL,
    0xbc78000000000ULL,
    0xdca4000000000ULL,
    0x421e000000000ULL,
    0x1711000000000ULL,
    0xd29b800000000ULL,
    0x8adb400000000ULL,
    0x25b2600000000ULL,
    0x9595900000000ULL,
    0xe052f80000000ULL,
    0x5b73840000000ULL,
    0x8634fa0000000ULL,
    0x14c6850000000ULL,
    0xe8b1798000000ULL,
    0xd40cc64000000ULL,
    0x46189a6000000ULL,
    0xa902161000000ULL,
    0x6f9801f800000ULL,
    0x354007400000ULL,
    0xbfe602e600000ULL,
    0x6df502c900000ULL,
    0x62e5805180000ULL,
    0x747a41c2c0000ULL,
    0xe0b1e14060000ULL,
    0x481ad2e050000ULL,
    0x7c069bd018000ULL,
    0xea1314d814000ULL,
    0xbb03838476000ULL,
    0xc08f404e79000ULL,
    0x25d463a53f800ULL,
    0x3209013ef400ULL,
    0x29577ab594600ULL,
    0xa4f9c51cb1500ULL,
    0x9d7d1bdd3f880ULL,
    0x6f385627ef440ULL,
    0x9b49e233946e0ULL,
    0x3bfed1c5b15d0ULL,
    0x93f89a74bf878ULL,
    0x3ff217912f454ULL,
    0x2de00195f4606ULL,
    0x82f001ece1549ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0xb000000000000ULL,
    0xc800000000000ULL,
    0x4c00000000000ULL,
    0x3a00000000000ULL,
    0x1f00000000000ULL,
    0x9480000000000ULL,
    0xebc0000000000ULL,
    0x3760000000000ULL,
    0x8270000000000ULL,
    0x31f8000000000ULL,
    0x6aac000000000ULL,
    0x701a000000000ULL,
    0x2813000000000ULL,
    0x5c12800000000ULL,
    0x4201c00000000ULL,
    0x9b14200000000ULL,
    0xe29fb00000000ULL,
    0xcecb480000000ULL,
    0xbceae40000000ULL,
    0xfd294a0000000ULL,
    0xed55e50000000ULL,
    0xdfa1c88000000ULL,
    0xc38727c000000ULL,
    0x73476ba000000ULL,
    0x46a956f000000ULL,
    0x1a00034800000ULL,
    0xef00028c00000ULL,
    0xfc80031a00000ULL,
    0x17c0002300000ULL,
    0xc560014780000ULL,
    0xd17000eac0000ULL,
    0x9f7802a060000ULL,
    0x9e6c007070000ULL,
    0xd3fa038808000ULL,
    0x41a300ac3c000ULL,
    0x5a8a80aa42000ULL,
    0xaaddc20b3b000ULL,
    0xdaf6221b92800ULL,
    0xa020b38885c00ULL,
    0xe2c3c9e75fa00ULL,
    0xd6f824d19e500ULL,
    0x3a2fe9d392880ULL,
    0x4dcb96c485c40ULL,
    0x8a7ea15d5faa0ULL,
    0x9df272029e5b0ULL,
    0x40a56bdc12848ULL,
    0x171654a245c0cULL,
    0x388880e73fa9aULL,
    0xc1d2c251ee5afULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x5000000000000ULL,
    0xa800000000000ULL,
    0x2c00000000000ULL,
    0xfe00000000000ULL,
    0x5100000000000ULL,
    0xef80000000000ULL,
    0x640000000000ULL,
    0x5760000000000ULL,
    0x1070000000000ULL,
    0x22e8000000000ULL,
    0x524000000000ULL,
    0xfd0e000000000ULL,
    0xd18b000000000ULL,
    0x3756800000000ULL,
    0xe8e5400000000ULL,
    0xbe35600000000ULL,
    0x5985900000000ULL,
    0xeb5cd80000000ULL,
    0x8efbf40000000ULL,
    0x3b3ada0000000ULL,
    0xcc14f70000000ULL,
    0x6e025b8000000ULL,
    0x990ab64000000ULL,
    0x9389b92000000ULL,
    0x504e66f000000ULL,
    0x2a6e02d800000ULL,
    0x1fb03b400000ULL,
    0x75be836600000ULL,
    0xbdc140ad00000ULL,
    0xeb3b63bb80000ULL,
    0xa40e91acc0000ULL,
    0x220a599020000ULL,
    0x371eb50850000ULL,
    0x6a8fbb9c18000ULL,
    0x93d1640a7c000ULL,
    0xd23e817f42000ULL,
    0x78142f0e9000ULL,
    0x8a5b627a17800ULL,
    0x997e90673f400ULL,
    0xb9625b24c4e00ULL,
    0x497ab64c40900ULL,
    0xd161bb2217880ULL,
    0x56a65933f4c0ULL,
    0x7f600162c4e60ULL,
    0xfc70001140950ULL,
    0xbce8024197828ULL,
    0x424038bff4ecULL,
    0xba8e0194e4e9eULL,
    0xfbcb02b410901ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0xb000000000000ULL,
    0xc800000000000ULL,
    0x7c00000000000ULL,
    0xc200000000000ULL,
    0x1300000000000ULL,
    0x6180000000000ULL,
    0xc340000000000ULL,
    0x5820000000000ULL,
    0xa130000000000ULL,
    0x5fb8000000000ULL,
    0x9774000000000ULL,
    0xd302000000000ULL,
    0x418b000000000ULL,
    0x134c800000000ULL,
    0x2038c00000000ULL,
    0x153ca00000000ULL,
    0xe1a1900000000ULL,
    0x467a780000000ULL,
    0xa19f3c0000000ULL,
    0xe3407a0000000ULL,
    0x88203d0000000ULL,
    0xd92efb8000000ULL,
    0xeba3ffc000000ULL,
    0x2966d8a000000ULL,
    0x20eae3000000ULL,
    0x330203a800000ULL,
    0xb18b027c00000ULL,
    0xbb4c802e00000ULL,
    0xec38c07100000ULL,
    0x1f3ca0ce80000ULL,
    0x8ea19035c0000ULL,
    0xe5fa7a9060000ULL,
    0x71df3f9810000ULL,
    0xdae078d468000ULL,
    0xea503fd23c000ULL,
    0xdeb6f89f5a000ULL,
    0xdde7fe9fdf000ULL,
    0xa5dcda8b28800ULL,
    0xd4f1ae6d99400ULL,
    0xf34c81e421600ULL,
    0xd038c2fa35b00ULL,
    0xbd3ca2a328880ULL,
    0x2da193d199440ULL,
    0x4c7a796a21660ULL,
    0xce9f3cbb35bb0ULL,
    0x40c079c5a8848ULL,
    0x58603d985943cULL,
    0xe08ef9d4416a2ULL,
    0x89d3fe5225ba3ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x5000000000000ULL,
    0xf800000000000ULL,
    0x2c00000000000ULL,
    0x9600000000000ULL,
    0xcf00000000000ULL,
    0x6280000000000ULL,
    0xdd40000000000ULL,
    0xfea0000000000ULL,
    0x4bb0000000000ULL,
    0x9038000000000ULL,
    0x10ec000000000ULL,
    0xf986000000000ULL,
    0x45c9000000000ULL,
    0xdae4800000000ULL,
    0x4892400000000ULL,
    0x9c59a00000000ULL,
    0x8f36f00000000ULL,
    0xca66d80000000ULL,
    0xa8d6cc0000000ULL,
    0x7d78da0000000ULL,
    0xa643cd0000000ULL,
    0x9622588000000ULL,
    0xc7f48c4000000ULL,
    0x47197b6000000ULL,
    0xa6993cf000000ULL,
    0x3f42813800000ULL,
    0xdbab43cc00000ULL,
    0x882522b200000ULL,
    0xccf8b1b900000ULL,
    0xc7817bc880000ULL,
    0x5ec53dd7c0000ULL,
    0x27c806860000ULL,
    0xccce402470000ULL,
    0xcf67a15678000ULL,
    0x7b53f24f54000ULL,
    0x79a45ad7ea000ULL,
    0xd3d8de81d000ULL,
    0x5f7df8e40c800ULL,
    0x634b7c7606c00ULL,
    0xa5bb20df77e00ULL,
    0x332db39fedf00ULL,
    0x447bf95c0c880ULL,
    0xbbc27ffa06c40ULL,
    0x21ffa30d77ea0ULL,
    0x600ff3d6edf50ULL,
    0xb01a5b2c8c878ULL,
    0x8188da1c6c6cULL,
    0x841f7ab717e36ULL,
    0x42103ebb9df9fULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0xb000000000000ULL,
    0x4800000000000ULL,
    0x5c00000000000ULL,
    0x3a00000000000ULL,
    0xe700000000000ULL,
    0x9980000000000ULL,
    0x440000000000ULL,
    0xbb20000000000ULL,
    0xa30000000000ULL,
    0x46b8000000000ULL,
    0x407c000000000ULL,
    0xec8a000000000ULL,
    0xf6d3000000000ULL,
    0xc4f0800000000ULL,
    0xf643c00000000ULL,
    0x4031200000000ULL,
    0x89b7100000000ULL,
    0x15e6180000000ULL,
    0x2acd3c0000000ULL,
    0xbef41a0000000ULL,
    0x31523d0000000ULL,
    0x69b69a8000000ULL,
    0xc5feffc000000ULL,
    0xf2dd3ba000000ULL,
    0x1ae92eb000000ULL,
    0x1f42834800000ULL,
    0xe8acc12c00000ULL,
    0x816ba32e00000ULL,
    0x8817d03d00000ULL,
    0x3c1fb94280000ULL,
    0xaa05eed5c0000ULL,
    0x1f09237860000ULL,
    0x8d8b13a430000ULL,
    0x624c1aa248000ULL,
    0x662e3c237c000ULL,
    0x74bc98778a000ULL,
    0xdb6dfd5b73000ULL,
    0xff0dbad3ce800ULL,
    0x5d9aef796f400ULL,
    0xba4ba030b6e00ULL,
    0xc227d02eabb00ULL,
    0x5aa7bb1bce880ULL,
    0x5a79ed956f440ULL,
    0xbb8322beb6e20ULL,
    0x275813a3abbb0ULL,
    0x9cbc9b914e8c8ULL,
    0x776dfdacaf41cULL,
    0xad0db948d6e1aULL,
    0x569aee8a9bb57ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0xb000000000000ULL,
    0x5800000000000ULL,
    0xac00000000000ULL,
    0xde00000000000ULL,
    0xe900000000000ULL,
    0x9980000000000ULL,
    0x82c0000000000ULL,
    0x9d60000000000ULL,
    0x3e70000000000ULL,
    0x6cf8000000000ULL,
    0x8ac000000000ULL,
    0x239a000000000ULL,
    0xb1c1000000000ULL,
    0x67fc800000000ULL,
    0xe23400000000ULL,
    0x85c0600000000ULL,
    0xf5fc500000000ULL,
    0x2937880000000ULL,
    0x1d48e40000000ULL,
    0x1ab58a0000000ULL,
    0x4495e50000000ULL,
    0x894b088000000ULL,
    0x38aba7c000000ULL,
    0x3b95e9e000000ULL,
    0xbdd9b57000000ULL,
    0x9e4829800000ULL,
    0xbf3f42d400000ULL,
    0xb04262fe00000ULL,
    0xa92151df00000ULL,
    0x5d490a0b80000ULL,
    0xbab6a7e6c0000ULL,
    0xf48b68d860000ULL,
    0xd157f47470000ULL,
    0x94a261ae08000ULL,
    0xe59153d774000ULL,
    0x54d10937fa000ULL,
    0x906aa654f9000ULL,
    0x3de96aad7b800ULL,
    0x2d3af51ec8400ULL,
    0x9744e23c45a00ULL,
    0x31b313325bd00ULL,
    0xb20de8b57b880ULL,
    0xd705b40ac8440ULL,
    0x6086832245aa0ULL,
    0xf352429d5bdb0ULL,
    0xeba4e0a6fb8d8ULL,
    0xd10312f8084ecULL,
    0x6595eae425a7eULL,
    0x14d9b7462bd59ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x5000000000000ULL,
    0x800000000000ULL,
    0x5400000000000ULL,
    0xd600000000000ULL,
    0xe500000000000ULL,
    0xab80000000000ULL,
    0xe940000000000ULL,
    0x1b20000000000ULL,
    0x70b0000000000ULL,
    0x39f8000000000ULL,
    0x92c4000000000ULL,
    0xba7e000000000ULL,
    0xdf87000000000ULL,
    0xcf49800000000ULL,
    0x462d400000000ULL,
    0xd736e00000000ULL,
    0x5aaa100000000ULL,
    0xeefa780000000ULL,
    0x525ffc0000000ULL,
    0x41b3fa0000000ULL,
    0x472bd0000000ULL,
    0x7e85198000000ULL,
    0x5ad8ac4000000ULL,
    0x4e7f61a000000ULL,
    0xb987511000000ULL,
    0x724c98f800000ULL,
    0xb1b5ef8400000ULL,
    0xbc6983d600000ULL,
    0x729d406100000ULL,
    0xd0cee21a80000ULL,
    0x296e10b3c0000ULL,
    0x21047a0560000ULL,
    0xd598fd7cd0000ULL,
    0xe85a7b3a98000ULL,
    0x3eaffe63cc000ULL,
    0x20ebfa1d3e000ULL,
    0xb46bfc8b9000ULL,
    0x38231b4485800ULL,
    0xd62bafdec1400ULL,
    0x7f30e1c5f4600ULL,
    0xbea911f472b00ULL,
    0x60edf95e05880ULL,
    0xeb45bf6d01440ULL,
    0x68349bc0946e0ULL,
    0xde31ec88a2b50ULL,
    0x2b3782649d888ULL,
    0x68aa410ecd414ULL,
    0x85ff61ddaa636ULL,
    0x40c753401bbb5ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0xb000000000000ULL,
    0x1800000000000ULL,
    0x5400000000000ULL,
    0xfa00000000000ULL,
    0x8300000000000ULL,
    0xca80000000000ULL,
    0x95c0000000000ULL,
    0xb7a0000000000ULL,
    0x2d30000000000ULL,
    0x70f8000000000ULL,
    0x1b5c000000000ULL,
    0x307a000000000ULL,
    0x7581000000000ULL,
    0x8957800000000ULL,
    0x9f72c00000000ULL,
    0x8103a00000000ULL,
    0xcd9d700000000ULL,
    0x2d55080000000ULL,
    0x5d745c0000000ULL,
    0xe6028a0000000ULL,
    0xe5069d0000000ULL,
    0x6f812a8000000ULL,
    0xda5befc000000ULL,
    0xddf422e000000ULL,
    0xe8dfb29000000ULL,
    0xcc2eab0800000ULL,
    0x2d752d9c00000ULL,
    0x9e0d82a200000ULL,
    0x2103c00b00000ULL,
    0x3d8c229c80000ULL,
    0x1543b22fc0000ULL,
    0xb974a85760000ULL,
    0x4042fdeb0000ULL,
    0x3202023488000ULL,
    0x5f1d0203b4000ULL,
    0xcc8d808d56000ULL,
    0xa0c3c351bf000ULL,
    0x502c225e38800ULL,
    0xb73b1797ac00ULL,
    0x1b0caabfe4a00ULL,
    0xde982e5f1fb00ULL,
    0x4fd800c2b8880ULL,
    0x84ac0356bac40ULL,
    0xffa202e884a20ULL,
    0xb12d0181afbb0ULL,
    0x56f582f630898ULL,
    0x9e5fc1550ec14ULL,
    0xcff62265d2adaULL,
    0x7c2b2d010b33ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x5000000000000ULL,
    0x4800000000000ULL,
    0x9c00000000000ULL,
    0x4200000000000ULL,
    0x5100000000000ULL,
    0xc280000000000ULL,
    0x25c0000000000ULL,
    0x6560000000000ULL,
    0x9ff0000000000ULL,
    0xfe28000000000ULL,
    0xad5c000000000ULL,
    0xeda6000000000ULL,
    0x8a07000000000ULL,
    0xd08800000000ULL,
    0x2086c00000000ULL,
    0x24dbe00000000ULL,
    0xeff3300000000ULL,
    0x2635480000000ULL,
    0xd950040000000ULL,
    0x63bdca0000000ULL,
    0xd116c70000000ULL,
    0x286288000000ULL,
    0x85d5f64000000ULL,
    0x357b61a000000ULL,
    0xd7e9f03000000ULL,
    0x6228aaa800000ULL,
    0xef54367400000ULL,
    0xbca8012200000ULL,
    0x489c00a300000ULL,
    0x28c6011780000ULL,
    0x45f702ecc0000ULL,
    0xbb20804720000ULL,
    0x11dac22db0000ULL,
    0x8b7de0d3b8000ULL,
    0x34f433a6ac000ULL,
    0xe9bdcb701a000ULL,
    0xdc16c48877000ULL,
    0x2206288455800ULL,
    0xa115f46a0bc00ULL,
    0xda9b634738a00ULL,
    0xf1d9f0ade7d00ULL,
    0xbb60a993d5880ULL,
    0x8cf83686cbcc0ULL,
    0x6da6030018aa0ULL,
    0x4a07028057d50ULL,
    0xad0881406d8c8ULL,
    0x7086c12067c5cULL,
    0x6cdbe27002ae2ULL,
    0x73f3310820d01ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x7000000000000ULL,
    0x3800000000000ULL,
    0x400000000000ULL,
    0x7600000000000ULL,
    0xdf00000000000ULL,
    0x8480000000000ULL,
    0x8440000000000ULL,
    0xfca0000000000ULL,
    0x5c30000000000ULL,
    0x7e78000000000ULL,
    0xf5c4000000000ULL,
    0x617a000000000ULL,
    0xd145000000000ULL,
    0x7521800000000ULL,
    0x65e5400000000ULL,
    0x1503a00000000ULL,
    0x6996b00000000ULL,
    0x49c9780000000ULL,
    0x53784c0000000ULL,
    0x9848fa0000000ULL,
    0x5ead0d0000000ULL,
    0x5d33598000000ULL,
    0x69ffbcc000000ULL,
    0xbf00216000000ULL,
    0xb482f0d000000ULL,
    0x5c495ab800000ULL,
    0x88babeac00000ULL,
    0x1221a12a00000ULL,
    0xa567b07d00000ULL,
    0x74afbb880000ULL,
    0x3a2c0dddc0000ULL,
    0xa968daf960000ULL,
    0xad5ffda6d0000ULL,
    0xe72203d688000ULL,
    0xbcf1025ec4000ULL,
    0x768380da8e000ULL,
    0x6d5442c491000ULL,
    0x472022cfe0800ULL,
    0x2cf2f1681bc00ULL,
    0x3e915a944d600ULL,
    0x514ebfc63ef00ULL,
    0x3523a17760880ULL,
    0x85e6b0b5dbc40ULL,
    0x65117a6d2d6e0ULL,
    0x518c4f60eef70ULL,
    0x4dcafb21e88b8ULL,
    0x256c0e2b1fc44ULL,
    0x4748dbd7a3696ULL,
    0xda2ffd747ffafULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x3000000000000ULL,
    0x4800000000000ULL,
    0x5c00000000000ULL,
    0xaa00000000000ULL,
    0xb500000000000ULL,
    0x1780000000000ULL,
    0x4240000000000ULL,
    0x620000000000ULL,
    0xddb0000000000ULL,
    0x8de8000000000ULL,
    0xacc000000000ULL,
    0x6fa000000000ULL,
    0x9e5b000000000ULL,
    0x6c3c800000000ULL,
    0x48a3c00000000ULL,
    0xaa66600000000ULL,
    0x84100000000ULL,
    0x5ccd980000000ULL,
    0xe9f43c0000000ULL,
    0x54d11a0000000ULL,
    0x55e7ff0000000ULL,
    0xeedf7a8000000ULL,
    0x98efefc000000ULL,
    0xed48e3a000000ULL,
    0x2cb0d2b000000ULL,
    0xf46d7b0800000ULL,
    0x5388ef6400000ULL,
    0x2c4661d600000ULL,
    0x1d3411ad00000ULL,
    0xf1259a6e80000ULL,
    0xd3383c6bc0000ULL,
    0x1a2b195120000ULL,
    0x97bcfc24f0000ULL,
    0x28e3fa1cc8000ULL,
    0x654c2c309c000ULL,
    0x50ae8062ba000ULL,
    0x6e74c0c9d3000ULL,
    0xae80e01203800ULL,
    0x67ccd34b33400ULL,
    0xf57f7b8bfde00ULL,
    0x421fec017fb00ULL,
    0x1900e27c83880ULL,
    0xd58cd320f34c0ULL,
    0x9b5f78dadde20ULL,
    0xf3afef258fb30ULL,
    0x76e8e2e04b8c8ULL,
    0x3640d0d06f49cULL,
    0x20257b1867e8aULL,
    0x9ab4ed5c5cb85ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0xb000000000000ULL,
    0x9800000000000ULL,
    0x5c00000000000ULL,
    0x1200000000000ULL,
    0x700000000000ULL,
    0x4e80000000000ULL,
    0x4ac0000000000ULL,
    0xf7e0000000000ULL,
    0x2b70000000000ULL,
    0xa6a8000000000ULL,
    0xbfdc000000000ULL,
    0x6e7a000000000ULL,
    0xa721000000000ULL,
    0x6f86800000000ULL,
    0xb556c00000000ULL,
    0xaaab200000000ULL,
    0xe5de700000000ULL,
    0xbd60e80000000ULL,
    0x8fb3b40000000ULL,
    0xf44e6a0000000ULL,
    0x4539770000000ULL,
    0x909f488000000ULL,
    0xb7c605c000000ULL,
    0xda7922e000000ULL,
    0xd12370b000000ULL,
    0x969c68a800000ULL,
    0x76c477ac00000ULL,
    0xf5e3c91200000ULL,
    0x471c74700000ULL,
    0x2c34822d80000ULL,
    0xbb1bc05ac0000ULL,
    0x8c9fa09f20000ULL,
    0xc5c5b0c9b0000ULL,
    0xcd7f4ad4c8000ULL,
    0xb7b605a234000ULL,
    0x185121ef52000ULL,
    0xcf3f7081af000ULL,
    0xcb866ac8de800ULL,
    0xeb55749866c00ULL,
    0x97ad48c415200ULL,
    0x684b075e5c100ULL,
    0xf72da0655e880ULL,
    0x2788b102a6cc0ULL,
    0x614bcabb352a0ULL,
    0xccadc727ec1b0ULL,
    0x34ce821996818ULL,
    0xbafac30c92c9cULL,
    0x9ef92246672b2ULL,
    0xe370e1431b7ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x5000000000000ULL,
    0x7800000000000ULL,
    0x1400000000000ULL,
    0x2a00000000000ULL,
    0x6900000000000ULL,
    0xe80000000000ULL,
    0x54c0000000000ULL,
    0x8220000000000ULL,
    0xc6b0000000000ULL,
    0x4b68000000000ULL,
    0xcfcc000000000ULL,
    0x61b6000000000ULL,
    0xeef1000000000ULL,
    0xb08f800000000ULL,
    0xd7d4c00000000ULL,
    0xc5a4e00000000ULL,
    0xccfcb00000000ULL,
    0xe583e80000000ULL,
    0x9f40cc0000000ULL,
    0xc6646a0000000ULL,
    0x3580f0000000ULL,
    0x10768a8000000ULL,
    0xc55be4000000ULL,
    0x19fae36000000ULL,
    0x6d01b21000000ULL,
    0xbc9a69c800000ULL,
    0x59d50cb400000ULL,
    0x8ea70b7200000ULL,
    0x977c7fa700000ULL,
    0xf9c7801a80000ULL,
    0x1ea8c1adc0000ULL,
    0xcf7ae27f20000ULL,
    0xbdc1b066f0000ULL,
    0x4cba6bebf8000ULL,
    0xb2650e6a34000ULL,
    0x994f08fb46000ULL,
    0x71707c2ca7000ULL,
    0x3ed180e0f5800ULL,
    0xb29c3dea5c00ULL,
    0xb83d600782200ULL,
    0x37a9732452f00ULL,
    0x21e08a7a75880ULL,
    0x9914bc3365cc0ULL,
    0xe69d6118a2220ULL,
    0x18d97152a2f50ULL,
    0xec2888598d8f8ULL,
    0xfda8beed51cd4ULL,
    0x38e36291e420aULL,
    0xbf9472d905f39ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0x1000000000000ULL,
    0x2800000000000ULL,
    0x8400000000000ULL,
    0x8200000000000ULL,
    0x5500000000000ULL,
    0x3780000000000ULL,
    0xb040000000000ULL,
    0x3be0000000000ULL,
    0x670000000000ULL,
    0x3738000000000ULL,
    0xb15c000000000ULL,
    0xc66e000000000ULL,
    0x5733000000000ULL,
    0x814f800000000ULL,
    0xfe69c00000000ULL,
    0xfb3c600000000ULL,
    0x8743100000000ULL,
    0x2963d80000000ULL,
    0x99a1440000000ULL,
    0x945a0000000ULL,
    0xa2d4850000000ULL,
    0xa4263a8000000ULL,
    0x31d4954000000ULL,
    0x24b2622000000ULL,
    0xd300135000000ULL,
    0xa0945a2800000ULL,
    0xf2d4870400000ULL,
    0xac26387600000ULL,
    0xa5d4948500000ULL,
    0x8eb260b980000ULL,
    0x20012ccc0000ULL,
    0x151458cd60000ULL,
    0x1794864db0000ULL,
    0xa0463b82d8000ULL,
    0x13e495c47c000ULL,
    0x826a619666000ULL,
    0xb52c12b51b000ULL,
    0xe4425ae1f7800ULL,
    0xf1fb8430a7400ULL,
    0xe767b9d720e00ULL,
    0xbabe571a9e500ULL,
    0xf81980d877880ULL,
    0xcc06c3bc67440ULL,
    0x361de33a40e20ULL,
    0xef19d2072e510ULL,
    0xce903972af8a8ULL,
    0x81cb957c1b4c4ULL,
    0x5cabe0da26ea2ULL,
    0x5f06d13735545ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0x7000000000000ULL,
    0x4800000000000ULL,
    0x8c00000000000ULL,
    0x9a00000000000ULL,
    0x5700000000000ULL,
    0x4b80000000000ULL,
    0x5040000000000ULL,
    0xca0000000000ULL,
    0x6530000000000ULL,
    0xe678000000000ULL,
    0x975c000000000ULL,
    0x1f22000000000ULL,
    0xa173000000000ULL,
    0xc4ce800000000ULL,
    0xfb67c00000000ULL,
    0xf3d2200000000ULL,
    0xe0ffd00000000ULL,
    0x9b85180000000ULL,
    0x28462c0000000ULL,
    0xe8b39a0000000ULL,
    0x33ded0000000ULL,
    0x6363ba8000000ULL,
    0x7c13cc000000ULL,
    0x9ef023a000000ULL,
    0xaa8cd2f000000ULL,
    0xe6cb9bc800000ULL,
    0x2861eeac00000ULL,
    0x8e41b86600000ULL,
    0xdb23f2d00000ULL,
    0xc3bea1f480000ULL,
    0xdaab1149c0000ULL,
    0xc839bb2560000ULL,
    0xaaee3d78b0000ULL,
    0xb49ca29fe8000ULL,
    0x87d813207c000ULL,
    0xdef73b3052000ULL,
    0x8a89fee823000ULL,
    0x96ce829c7a800ULL,
    0x6067c10e6c400ULL,
    0x25223f106e00ULL,
    0x97bfd39ac8f00ULL,
    0x94a519e8fa880ULL,
    0x91362c87ac440ULL,
    0x986b9b7466e20ULL,
    0xa651ec1278f70ULL,
    0xd1b9b8bf128c8ULL,
    0x61ae3d0bd04ccULL,
    0x49bca22234ebaULL,
    0x95a810d75bf27ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x7000000000000ULL,
    0x8800000000000ULL,
    0x400000000000ULL,
    0x6600000000000ULL,
    0xc500000000000ULL,
    0x5780000000000ULL,
    0xcac0000000000ULL,
    0x99a0000000000ULL,
    0x6c30000000000ULL,
    0xe5f8000000000ULL,
    0x3ecc000000000ULL,
    0x37b2000000000ULL,
    0xd3b000000000ULL,
    0xa467800000000ULL,
    0xb911400000000ULL,
    0xfd86e00000000ULL,
    0xcdd5900000000ULL,
    0x1d34880000000ULL,
    0xbc6ddc0000000ULL,
    0xe50b0a0000000ULL,
    0x67809d0000000ULL,
    0xe2c7e88000000ULL,
    0xeda20cc000000ULL,
    0x8226e2a000000ULL,
    0x24e590d000000ULL,
    0xf4c893800000ULL,
    0x3861dec400000ULL,
    0xc31908e600000ULL,
    0x28b9d2f00000ULL,
    0xc5586a2080000ULL,
    0xaf7f4d4fc0000ULL,
    0x1f92020f60000ULL,
    0x2ecb02b0f0000ULL,
    0x2fbf8017a8000ULL,
    0x512d43bb1c000ULL,
    0x3e6ce33eb6000ULL,
    0x9612920499000ULL,
    0xd190b19cd800ULL,
    0xf38b9c683f400ULL,
    0xdcd86bbc37a00ULL,
    0xd4bf4c4254300ULL,
    0x3fb201b94d880ULL,
    0x493b01e7ff440ULL,
    0x6267811357aa0ULL,
    0xc114322a4370ULL,
    0x2206e016e5808ULL,
    0x3159058e3444ULL,
    0xe294886be1ac6ULL,
    0x155ddcd93d3b5ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0xf000000000000ULL,
    0xb800000000000ULL,
    0x9400000000000ULL,
    0xaa00000000000ULL,
    0xb900000000000ULL,
    0x7780000000000ULL,
    0x87c0000000000ULL,
    0x5b60000000000ULL,
    0xc2f0000000000ULL,
    0xbe28000000000ULL,
    0x97c4000000000ULL,
    0xd36a000000000ULL,
    0x8ef5000000000ULL,
    0x7033800000000ULL,
    0x3cd4c00000000ULL,
    0x89fae00000000ULL,
    0xd4b9900000000ULL,
    0x159aa80000000ULL,
    0xd2d1a40000000ULL,
    0x72e12a0000000ULL,
    0xa631670000000ULL,
    0x93d9cb8000000ULL,
    0x3179f4c000000ULL,
    0x1bfae16000000ULL,
    0x39b9929000000ULL,
    0xa81aa9c800000ULL,
    0x1c11a77400000ULL,
    0xe6012b9600000ULL,
    0x770165ab00000ULL,
    0xdc91c99b80000ULL,
    0xdd4df730c0000ULL,
    0x138e32b20000ULL,
    0xa74891dbd0000ULL,
    0x5023291088000ULL,
    0x6cc0641b04000ULL,
    0xa1e04be3c6000ULL,
    0x8a8353c97000ULL,
    0x939b81310d800ULL,
    0x55d0c2aaa1400ULL,
    0x1670e29a6f200ULL,
    0xef7c923123d00ULL,
    0x38e12b2a8d880ULL,
    0x2f31655a614c0ULL,
    0x3c59cad14f260ULL,
    0xd2b9f67af3df0ULL,
    0x529ae07205838ULL,
    0xd64992f565454ULL,
    0xcbb2abc4892caULL,
    0xb515a47d64d49ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x7000000000000ULL,
    0x3800000000000ULL,
    0xdc00000000000ULL,
    0xde00000000000ULL,
    0x6d00000000000ULL,
    0x9080000000000ULL,
    0x6dc0000000000ULL,
    0x1e60000000000ULL,
    0x34f0000000000ULL,
    0xf628000000000ULL,
    0xebcc000000000ULL,
    0x3f72000000000ULL,
    0x127d000000000ULL,
    0x62fa800000000ULL,
    0x5f2b400000000ULL,
    0x94fe00000000ULL,
    0xd9b1700000000ULL,
    0x2d94880000000ULL,
    0x754d240000000ULL,
    0xb7a60a0000000ULL,
    0x589a670000000ULL,
    0x49d3ea8000000ULL,
    0x3c6a16c000000ULL,
    0xf7e7e26000000ULL,
    0x33bd71b000000ULL,
    0xca868b1800000ULL,
    0x92c0270400000ULL,
    0x55f48bda00000ULL,
    0x30bd247300000ULL,
    0x2f0e0bc380000ULL,
    0xc3966610c0000ULL,
    0xc041eb8320000ULL,
    0xab27177bf0000ULL,
    0xa3556244e8000ULL,
    0xdeaa333104000ULL,
    0x9a136bf482000ULL,
    0xdf00542969000ULL,
    0x3b8882f09d800ULL,
    0x3c5642f35cc00ULL,
    0x5356303a7a00ULL,
    0xf65a3170ac500ULL,
    0x923b6bb31d880ULL,
    0x29cc56239ccc0ULL,
    0xac7a80e087a20ULL,
    0x9feb40bb5c570ULL,
    0xa7afe06ff58b8ULL,
    0xf08170d698c1cULL,
    0xfddc88ae05afeULL,
    0x767126513551dULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0xb000000000000ULL,
    0x8800000000000ULL,
    0xd400000000000ULL,
    0x4600000000000ULL,
    0xd900000000000ULL,
    0x8180000000000ULL,
    0xd540000000000ULL,
    0xd060000000000ULL,
    0xc0f0000000000ULL,
    0xe038000000000ULL,
    0xf304000000000ULL,
    0x282000000000ULL,
    0xffdb000000000ULL,
    0xabbd800000000ULL,
    0x1553400000000ULL,
    0x7061600000000ULL,
    0x90efd00000000ULL,
    0xd83fb80000000ULL,
    0xaf05940000000ULL,
    0x90803a0000000ULL,
    0x60cdd50000000ULL,
    0xf33cd98000000ULL,
    0x418147c000000ULL,
    0x755a03a000000ULL,
    0x806f009000000ULL,
    0xf8e780b800000ULL,
    0xbc3c42f400000ULL,
    0x6106e13e00000ULL,
    0x9d93936100000ULL,
    0xa759585f80000ULL,
    0xff660732c0000ULL,
    0x106160c760000ULL,
    0x60efd29ad0000ULL,
    0xb03fbb4b68000ULL,
    0xcb0595f0bc000ULL,
    0x5e8039041e000ULL,
    0x6dcdd63631000ULL,
    0x34bcdbfd7b800ULL,
    0x4dc1454d9e400ULL,
    0x24ba01a98d600ULL,
    0x95df036fe4100ULL,
    0xc8bf831afb880ULL,
    0x8fc8408b5e440ULL,
    0x83bce050ed6e0ULL,
    0x914c9294341b0ULL,
    0xe66d80e13808ULL,
    0x15ee464922494ULL,
    0xcbbd8393936a6ULL,
    0xe5534338d5169ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x9000000000000ULL,
    0x800000000000ULL,
    0xfc00000000000ULL,
    0xae00000000000ULL,
    0x1100000000000ULL,
    0x2480000000000ULL,
    0x8d40000000000ULL,
    0x8860000000000ULL,
    0x45f0000000000ULL,
    0x6828000000000ULL,
    0x870c000000000ULL,
    0x918e000000000ULL,
    0xd3d7000000000ULL,
    0xd62c800000000ULL,
    0x5e1b400000000ULL,
    0x6910600000000ULL,
    0x6097700000000ULL,
    0x4745180000000ULL,
    0xc365340000000ULL,
    0x22679a0000000ULL,
    0x7ee9770000000ULL,
    0xb7bb7a8000000ULL,
    0xf5d5454000000ULL,
    0xfb2602a000000ULL,
    0xf49b02b000000ULL,
    0x6542821800000ULL,
    0xc47c41f400000ULL,
    0x73f4e20a00000ULL,
    0x8d30318100000ULL,
    0xf193780b80000ULL,
    0xa3d94766c0000ULL,
    0x6e28011320000ULL,
    0x3a0c023ef0000ULL,
    0x330e014718000ULL,
    0x23970204ac000ULL,
    0xdccc809e2a000ULL,
    0x7bab43db01000ULL,
    0x3d86202cb800ULL,
    0x3e2b73f16cc00ULL,
    0x12031b73e7e00ULL,
    0x5f0e35c2a4100ULL,
    0x858d18114b880ULL,
    0x31d93563accc0ULL,
    0xf121986ac7e20ULL,
    0x9f82767d54190ULL,
    0x92d1f95dd3888ULL,
    0xdaa50401c0c3cULL,
    0xbf5ce3e7cde8eULL,
    0x477c3098a5181ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x3000000000000ULL,
    0x5800000000000ULL,
    0xa400000000000ULL,
    0x200000000000ULL,
    0x3900000000000ULL,
    0x9380000000000ULL,
    0x41c0000000000ULL,
    0x80a0000000000ULL,
    0x3e30000000000ULL,
    0xf678000000000ULL,
    0xca14000000000ULL,
    0xd502000000000ULL,
    0x3d81000000000ULL,
    0xb6d9800000000ULL,
    0xd43fc00000000ULL,
    0x7363e00000000ULL,
    0x9f8d100000000ULL,
    0x9fd9680000000ULL,
    0x4fa05c0000000ULL,
    0xfea2ea0000000ULL,
    0xe12e9d0000000ULL,
    0x3ee08b8000000ULL,
    0x11484dc000000ULL,
    0xdff802e000000ULL,
    0x66d4035000000ULL,
    0xfc2200e800000ULL,
    0xef7102b400000ULL,
    0x981832600000ULL,
    0xfcdbc37300000ULL,
    0x4139e04480000ULL,
    0x2ee8111bc0000ULL,
    0x195aeb9560000ULL,
    0x13fa9ed790000ULL,
    0x98c2888f68000ULL,
    0x63394e2694000ULL,
    0x47f981d68e000ULL,
    0xe2cfc14eab000ULL,
    0xae3be0a2e1800ULL,
    0xbe691388cf400ULL,
    0x660368018c200ULL,
    0x1b055e644a300ULL,
    0xfa81680e61880ULL,
    0xba445c270f440ULL,
    0x3d78eab2ec260ULL,
    0x188b9ec0da330ULL,
    0xf3430b45898d8ULL,
    0x96e28eda5b4e4ULL,
    0xcd40621102262ULL,
    0x29e7d209e1309ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x1000000000000ULL,
    0xd800000000000ULL,
    0xb400000000000ULL,
    0xda00000000000ULL,
    0xa100000000000ULL,
    0xcd80000000000ULL,
    0x6940000000000ULL,
    0xae60000000000ULL,
    0x7ef0000000000ULL,
    0x8c38000000000ULL,
    0x340c000000000ULL,
    0x9a1e000000000ULL,
    0x10d000000000ULL,
    0xdd8f800000000ULL,
    0xb156c00000000ULL,
    0x1a79e00000000ULL,
    0xa4e6d00000000ULL,
    0x2d38b80000000ULL,
    0xf98d540000000ULL,
    0xf3493a0000000ULL,
    0xaf66950000000ULL,
    0xa367588000000ULL,
    0x3d6a854000000ULL,
    0x2e6003e000000ULL,
    0x3ef0039000000ULL,
    0x2c38028800000ULL,
    0x240c001400000ULL,
    0x421e033e00000ULL,
    0xb50d01f100000ULL,
    0x78f82e780000ULL,
    0x1056c2dac0000ULL,
    0xd7f9e3bf60000ULL,
    0xcda6d08ef0000ULL,
    0x8358bae118000ULL,
    0x877d552fc4000ULL,
    0x7f71392ea6000ULL,
    0x9b6a97115f000ULL,
    0x397959f7a1800ULL,
    0x3c678512f4400ULL,
    0xf3ef804b3b600ULL,
    0x8fa6c020f5100ULL,
    0x3641e19821880ULL,
    0x80ead3dc34440ULL,
    0x6f26baca5b6a0ULL,
    0x4c80545f05110ULL,
    0xf4c6b91eb9858ULL,
    0xbf305569304f4ULL,
    0x749eb9bb9d67aULL,
    0xf0cc5550aa1b1ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0xb000000000000ULL,
    0xc800000000000ULL,
    0x8c00000000000ULL,
    0x5e00000000000ULL,
    0xbf00000000000ULL,
    0xa980000000000ULL,
    0x6840000000000ULL,
    0xd7e0000000000ULL,
    0x1570000000000ULL,
    0xbea8000000000ULL,
    0x41c000000000ULL,
    0xb21a000000000ULL,
    0xf11b000000000ULL,
    0x6e9e800000000ULL,
    0x85c3400000000ULL,
    0x6dada00000000ULL,
    0x2399100000000ULL,
    0xbd57d80000000ULL,
    0x7b76c40000000ULL,
    0x9b35a0000000ULL,
    0x819e870000000ULL,
    0x3448788000000ULL,
    0x51e8d5c000000ULL,
    0x5e6003a000000ULL,
    0xd3003f000000ULL,
    0x14800d800000ULL,
    0x2d6c020c00000ULL,
    0x9ab200fe00000ULL,
    0xc607016d00000ULL,
    0x2b04808180000ULL,
    0xa3984308c0000ULL,
    0x7d53230320000ULL,
    0xdb6a51e4b0000ULL,
    0xb9b27b6d48000ULL,
    0x4983d781dc000ULL,
    0xb8568388b2000ULL,
    0xfef42c311000ULL,
    0xe17fa044a4800ULL,
    0xa4ae139d05400ULL,
    0x691b59d993e00ULL,
    0xfa828544b2500ULL,
    0x8fd2781d24880ULL,
    0x78b3d699c54c0ULL,
    0x2f1e8024b3ea0ULL,
    0x118342cd025b0ULL,
    0x8c4da371ec848ULL,
    0xb5e913d0d944cULL,
    0x3c7fd90f21efeULL,
    0x242ac51aa350fULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0xf000000000000ULL,
    0xa800000000000ULL,
    0x400000000000ULL,
    0xba00000000000ULL,
    0xfb00000000000ULL,
    0xaf80000000000ULL,
    0x3640000000000ULL,
    0xdce0000000000ULL,
    0x4270000000000ULL,
    0xc8b8000000000ULL,
    0x298c000000000ULL,
    0xcb42000000000ULL,
    0xce7f000000000ULL,
    0xc6bb800000000ULL,
    0x609ac00000000ULL,
    0x6bd4a00000000ULL,
    0x45b7d00000000ULL,
    0xd317580000000ULL,
    0xeb95240000000ULL,
    0x2c56da0000000ULL,
    0xd7fce50000000ULL,
    0x45fbf88000000ULL,
    0xfaeef6c000000ULL,
    0x4f63822000000ULL,
    0x7226c2d000000ULL,
    0xa94ea2c800000ULL,
    0xd974d03c00000ULL,
    0x7736daf600000ULL,
    0xe7cce72500000ULL,
    0x4ba3f92580000ULL,
    0x9a12f73cc0000ULL,
    0x4b19826f60000ULL,
    0xa795c3b6f0000ULL,
    0xc257235c68000ULL,
    0xcee111460c000ULL,
    0xbd61fb5d06000ULL,
    0xdd2df5e1a7000ULL,
    0xe4c203ceb4800ULL,
    0xb83f019848400ULL,
    0xba5b82b461e00ULL,
    0xd2eac12a20d00ULL,
    0xb6ca0a334880ULL,
    0x683bd05888440ULL,
    0xa255580d01ea0ULL,
    0xdeea2769d0df0ULL,
    0x456d5812dc828ULL,
    0x8126261e44444ULL,
    0xf2cf5bc967e1aULL,
    0xfd29261b87d0bULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0xb000000000000ULL,
    0x1800000000000ULL,
    0x1c00000000000ULL,
    0x9600000000000ULL,
    0x9b00000000000ULL,
    0x9c80000000000ULL,
    0x34c0000000000ULL,
    0x3d60000000000ULL,
    0x94f0000000000ULL,
    0xaba8000000000ULL,
    0x6084000000000ULL,
    0xd2c2000000000ULL,
    0xde79000000000ULL,
    0xa466800000000ULL,
    0x117a400000000ULL,
    0xdae6200000000ULL,
    0x4ca0300000000ULL,
    0xda17680000000ULL,
    0x6510240000000ULL,
    0x639bea0000000ULL,
    0x9257670000000ULL,
    0x1cb94b8000000ULL,
    0xb20415c000000ULL,
    0x10683e000000ULL,
    0x598a41b000000ULL,
    0x874e23b800000ULL,
    0x72430dc00000ULL,
    0x8c55684a00000ULL,
    0x93a926cf00000ULL,
    0x6c9d6adf80000ULL,
    0x8cdd27ecc0000ULL,
    0xf1776ba920000ULL,
    0xaae026c2d0000ULL,
    0x34b3eaf028000ULL,
    0x7613651834000ULL,
    0xeb1b4acc32000ULL,
    0xe48d15621d000ULL,
    0x98c8017b0a800ULL,
    0xb37401018dc00ULL,
    0x13ea03addf200ULL,
    0xa13d02bfe9500ULL,
    0xcf44839c8a880ULL,
    0x733343f14dcc0ULL,
    0x7e48a3aeff260ULL,
    0x32ae7302395b0ULL,
    0xe51b480b22898ULL,
    0xa38d15d9b9cdcULL,
    0xf2480081ed2f6ULL,
    0xacb4016df452bULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x5000000000000ULL,
    0x5800000000000ULL,
    0x2400000000000ULL,
    0xca00000000000ULL,
    0xa100000000000ULL,
    0xe280000000000ULL,
    0xe440000000000ULL,
    0x8560000000000ULL,
    0x44f0000000000ULL,
    0x3f28000000000ULL,
    0x6284000000000ULL,
    0x245e000000000ULL,
    0xe56d000000000ULL,
    0x14f5800000000ULL,
    0x673ec00000000ULL,
    0x468de00000000ULL,
    0xee4f300000000ULL,
    0x4479f80000000ULL,
    0xf665f40000000ULL,
    0x837a7a0000000ULL,
    0xc3f2370000000ULL,
    0xaabc1b8000000ULL,
    0x7b5ec64000000ULL,
    0x94f582e000000ULL,
    0xa73ec2d000000ULL,
    0x268de3c800000ULL,
    0xbe4f335400000ULL,
    0x1c79f9c200000ULL,
    0xd265f58500000ULL,
    0x497a78b780000ULL,
    0x62f23706c0000ULL,
    0x483c1ae320000ULL,
    0x9f1ec548d0000ULL,
    0x1195809858000ULL,
    0xe3cec1dc64000ULL,
    0x19a5e3f60e000ULL,
    0xdccb30d75f000ULL,
    0x3827f81a99800ULL,
    0x3708f43573c00ULL,
    0x5d8ff8ef86600ULL,
    0x5ccf6fa90100ULL,
    0xeb1f8e519880ULL,
    0x7151f627b3cc0ULL,
    0x55ec792ea6660ULL,
    0x15ab34e740150ULL,
    0x9adf9b02c18d8ULL,
    0x1f3907a917ce4ULL,
    0x929be3f9886aaULL,
    0x4c5633fdcf1f1ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x1000000000000ULL,
    0x7800000000000ULL,
    0xb400000000000ULL,
    0xfe00000000000ULL,
    0x8d00000000000ULL,
    0x5180000000000ULL,
    0xb5c0000000000ULL,
    0xc7a0000000000ULL,
    0xd130000000000ULL,
    0x678000000000ULL,
    0xc894000000000ULL,
    0x2a46000000000ULL,
    0xf761000000000ULL,
    0x9b0b800000000ULL,
    0x508e400000000ULL,
    0xce54e00000000ULL,
    0x1166500000000ULL,
    0xb212280000000ULL,
    0x871afc0000000ULL,
    0x4287aa0000000ULL,
    0x7951bd0000000ULL,
    0x5be6cb8000000ULL,
    0x174cad4000000ULL,
    0xeeed826000000ULL,
    0x92df439000000ULL,
    0xb527639800000ULL,
    0xa07c10a400000ULL,
    0x8180cb5e00000ULL,
    0xedddae3300000ULL,
    0x3be03a080000ULL,
    0x473502a7c0000ULL,
    0x476d83c160000ULL,
    0xd31f42f190000ULL,
    0xec87624e78000ULL,
    0xec4c116b14000ULL,
    0xae78c924d6000ULL,
    0x2489af89ed000ULL,
    0x105802ba65800ULL,
    0xec64010d24400ULL,
    0x8b9e0103b5200ULL,
    0xfec5001f0bb00ULL,
    0xcf358102e5880ULL,
    0xdb7b424ee4440ULL,
    0x811961fcd5260ULL,
    0x3b89124d9bb10ULL,
    0xb6cd48f41d8f8ULL,
    0x7332ec66304f4ULL,
    0xf96162276329eULL,
    0x3e1d1296e6b9dULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x7000000000000ULL,
    0x800000000000ULL,
    0x8400000000000ULL,
    0x7e00000000000ULL,
    0x4900000000000ULL,
    0x2480000000000ULL,
    0x5540000000000ULL,
    0xd360000000000ULL,
    0x64f0000000000ULL,
    0xf228000000000ULL,
    0x184000000000ULL,
    0x3bda000000000ULL,
    0xd923000000000ULL,
    0x2e0f800000000ULL,
    0x9106400000000ULL,
    0xb89a600000000ULL,
    0xd74c700000000ULL,
    0x6866180000000ULL,
    0xf374d40000000ULL,
    0xb4fb9a0000000ULL,
    0xea25970000000ULL,
    0xfd9c7b8000000ULL,
    0xc9c8a6c000000ULL,
    0x6a3583a000000ULL,
    0x3d9540d000000ULL,
    0xa9dde05800000ULL,
    0x1a3e32f400000ULL,
    0x358e794a00000ULL,
    0x2ddfa66100000ULL,
    0x6428002780000ULL,
    0x7c8402e2c0000ULL,
    0x95a019720000ULL,
    0x31630100d0000ULL,
    0xafef804a48000ULL,
    0x6db640e15c000ULL,
    0xc3526267f6000ULL,
    0xae78700285000ULL,
    0x56741a273f800ULL,
    0x1a63d728a4c00ULL,
    0x80661ab64fe00ULL,
    0xc774d4473b900ULL,
    0xa2fb99d8bf880ULL,
    0x572595fe64cc0ULL,
    0xaf1c7bcb6fe60ULL,
    0x5188a4f6eb970ULL,
    0xe3d5826d77888ULL,
    0x452543c9f8c44ULL,
    0xac15e2d1b9e1eULL,
    0x2a0a3345be939ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0xd000000000000ULL,
    0x7800000000000ULL,
    0x9c00000000000ULL,
    0x6a00000000000ULL,
    0xeb00000000000ULL,
    0x2680000000000ULL,
    0x18c0000000000ULL,
    0x76a0000000000ULL,
    0x1530000000000ULL,
    0x2668000000000ULL,
    0x379c000000000ULL,
    0xcd56000000000ULL,
    0xa4e1000000000ULL,
    0xb956800000000ULL,
    0x4ae9c00000000ULL,
    0xd447a00000000ULL,
    0x4576f00000000ULL,
    0xe511a80000000ULL,
    0xfb989c0000000ULL,
    0x1f592a0000000ULL,
    0x73fc5f0000000ULL,
    0x25d6088000000ULL,
    0xc12e6c4000000ULL,
    0x1868816000000ULL,
    0x2294c23000000ULL,
    0x5ec722c800000ULL,
    0xffbe329c00000ULL,
    0xeca088d200000ULL,
    0x9637adbf00000ULL,
    0x44e722e880000ULL,
    0x94e309bc0000ULL,
    0x42e88b5920000ULL,
    0xe05bafa9b0000ULL,
    0xcb79219678000ULL,
    0xf803336934000ULL,
    0x5c000a61a2000ULL,
    0xca0f6f8a53000ULL,
    0x3b1e01fb1c800ULL,
    0x5e8d03bef8c00ULL,
    0x84c880d282200ULL,
    0x1ca4c368deb00ULL,
    0xfe2f215b9c880ULL,
    0xe231f938cc0ULL,
    0x2f568839a22a0ULL,
    0xbbe6ac4e6ebd0ULL,
    0xb1d9a06d648f8ULL,
    0x9f3bf0d7ccc5cULL,
    0x7d792ab3202caULL,
    0x190c5ce28db3bULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0xd000000000000ULL,
    0xf800000000000ULL,
    0x4400000000000ULL,
    0xc200000000000ULL,
    0xd00000000000ULL,
    0x6b80000000000ULL,
    0x4b40000000000ULL,
    0xf0e0000000000ULL,
    0x9bb0000000000ULL,
    0xfb58000000000ULL,
    0x38fc000000000ULL,
    0x57be000000000ULL,
    0x555d000000000ULL,
    0x4beb800000000ULL,
    0xb72ec00000000ULL,
    0xba84e00000000ULL,
    0x96c7500000000ULL,
    0xfcbad80000000ULL,
    0x61db940000000ULL,
    0x3e3e3a0000000ULL,
    0xf31cc50000000ULL,
    0xa084e08000000ULL,
    0x4fc7524000000ULL,
    0xd3ad96000000ULL,
    0xb39b965000000ULL,
    0x9f5e3ae800000ULL,
    0x6aecc42400000ULL,
    0x2bce22600000ULL,
    0xaacb535900000ULL,
    0x3abcdb0d80000ULL,
    0xeca9513c0000ULL,
    0x88b3bac6e0000ULL,
    0x2bd306a930000ULL,
    0x5f35809598000ULL,
    0xe683c2ef84000ULL,
    0x60d7637cd6000ULL,
    0x1ba5929a0f000ULL,
    0xbb583b035d800ULL,
    0x98fdc72e96400ULL,
    0x87b1630d60e00ULL,
    0xad449273f7100ULL,
    0xfedbb96c5880ULL,
    0x753e05c112440ULL,
    0xb7860071b6ea0ULL,
    0xfd5100e9f81d0ULL,
    0xb7ed809598078ULL,
    0x913fc2ef84004ULL,
    0xa589637cd6062ULL,
    0x848929a0f0ddULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x1000000000000ULL,
    0x800000000000ULL,
    0x9400000000000ULL,
    0xb600000000000ULL,
    0x5d00000000000ULL,
    0xdc80000000000ULL,
    0x3ec0000000000ULL,
    0x8d60000000000ULL,
    0xcbb0000000000ULL,
    0x8ad8000000000ULL,
    0x8b74000000000ULL,
    0x6eae000000000ULL,
    0xda5b000000000ULL,
    0x9fa7800000000ULL,
    0x9cca400000000ULL,
    0x2676600000000ULL,
    0xaa2fb00000000ULL,
    0x7882080000000ULL,
    0x30de140000000ULL,
    0xbc746a0000000ULL,
    0x2d31a50000000ULL,
    0xc316618000000ULL,
    0xa59fb14000000ULL,
    0xac5a0ba000000ULL,
    0x62aa161000000ULL,
    0xb05a68f800000ULL,
    0xaaa62400000ULL,
    0xbb51e02a00000ULL,
    0x9125f0cf00000ULL,
    0x51146ae780000ULL,
    0xb681a5c5c0000ULL,
    0xa1ce60e6e0000ULL,
    0xaaebb32710000ULL,
    0x7cf409bbd8000ULL,
    0x71f1148bbc000ULL,
    0x457de8a3a6000ULL,
    0xffa0e59f85000ULL,
    0xccc781a1a7800ULL,
    0xce7a41ec87c00ULL,
    0x2e2e623809a00ULL,
    0xc69bb1c47a900ULL,
    0xf9cc081a7f880ULL,
    0xd6f515673bc40ULL,
    0x4eebea9bafae0ULL,
    0x92ffe45bff910ULL,
    0x50f601bbd8088ULL,
    0xabef008bbc0d4ULL,
    0x226982a3a6056ULL,
    0x5421409f8504dULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x9000000000000ULL,
    0xc800000000000ULL,
    0x1400000000000ULL,
    0xd200000000000ULL,
    0x4500000000000ULL,
    0x2880000000000ULL,
    0xebc0000000000ULL,
    0xb660000000000ULL,
    0xc9b0000000000ULL,
    0x6dc8000000000ULL,
    0x164000000000ULL,
    0xd43e000000000ULL,
    0xf683000000000ULL,
    0x80df800000000ULL,
    0x6df6c00000000ULL,
    0xc5e9e00000000ULL,
    0x81fe300000000ULL,
    0x7bf4a80000000ULL,
    0xbaff540000000ULL,
    0x887d4a0000000ULL,
    0x32b1670000000ULL,
    0x7e41e18000000ULL,
    0x192a314000000ULL,
    0xea02a8a000000ULL,
    0xc918561000000ULL,
    0xc69cca6800000ULL,
    0xf8c4a64400000ULL,
    0xc1f7826a00000ULL,
    0x5be2c3fb00000ULL,
    0xcaffe2db80000ULL,
    0xd0693299c0000ULL,
    0xeebd2b06a0000ULL,
    0xb85e966750000ULL,
    0x8e3d2b0dd8000ULL,
    0x879e96649c000ULL,
    0xa5d2aa806000ULL,
    0x9b2e97a417000ULL,
    0x871528da79800ULL,
    0x658a958373c00ULL,
    0x374b29f7ad200ULL,
    0x1fb9973799900ULL,
    0xf2dcabd7a1880ULL,
    0x98eb57e7efcc0ULL,
    0x556b495fab2e0ULL,
    0x262667938e990ULL,
    0xc388628dd8048ULL,
    0xf04bf3249c0d4ULL,
    0x5a22c80806032ULL,
    0xb587a6b4170d5ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0xb000000000000ULL,
    0xf800000000000ULL,
    0xac00000000000ULL,
    0x1a00000000000ULL,
    0xd100000000000ULL,
    0xd80000000000ULL,
    0xfe40000000000ULL,
    0x3ea0000000000ULL,
    0xccf0000000000ULL,
    0x7848000000000ULL,
    0xcda4000000000ULL,
    0x5c7a000000000ULL,
    0x2181000000000ULL,
    0x244e800000000ULL,
    0xfbcc00000000ULL,
    0x7160600000000ULL,
    0x7e19100000000ULL,
    0x5f0cb80000000ULL,
    0x8a8b7c0000000ULL,
    0x88ccda0000000ULL,
    0xe4626f0000000ULL,
    0xad88618000000ULL,
    0x6e4d11c000000ULL,
    0x96beb86000000ULL,
    0x28ee7c7000000ULL,
    0x3658598800000ULL,
    0xaaafaef400000ULL,
    0x9aee81de00000ULL,
    0x34cc17d00000ULL,
    0xe92860ac80000ULL,
    0x3bd10bac0000ULL,
    0xfb76ba93a0000ULL,
    0x70a7df150000ULL,
    0xb6825acec8000ULL,
    0x3adeac0d94000ULL,
    0xd16800ac52000ULL,
    0xee1401b237000ULL,
    0xf712002f1b800ULL,
    0x6e9501b3c7400ULL,
    0xc6dc83a17b600ULL,
    0x8369c196ddb00ULL,
    0x6b1ce2e1d3880ULL,
    0x4c80d1be534c0ULL,
    0x5bd8590d296e0ULL,
    0x24efaf24eabb0ULL,
    0xbc4e834ec8078ULL,
    0xd3bcc1cd9406cULL,
    0x736062cc520faULL,
    0xb31912c237061ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0xf000000000000ULL,
    0x800000000000ULL,
    0x8400000000000ULL,
    0x3e00000000000ULL,
    0xe900000000000ULL,
    0x5080000000000ULL,
    0x7ec0000000000ULL,
    0x3060000000000ULL,
    0xfab0000000000ULL,
    0x5cd8000000000ULL,
    0xdb74000000000ULL,
    0x1132000000000ULL,
    0xd187000000000ULL,
    0x1a45800000000ULL,
    0x98b5400000000ULL,
    0x57d5e00000000ULL,
    0xc0eeb00000000ULL,
    0x947e880000000ULL,
    0x94b5340000000ULL,
    0xadcb6a0000000ULL,
    0xf7eb850000000ULL,
    0xddede18000000ULL,
    0xb2eab2c000000ULL,
    0x67748ba000000ULL,
    0x33635d000000ULL,
    0x9284ead800000ULL,
    0x65ddc4b400000ULL,
    0xd3f7803a00000ULL,
    0xf3f2409f00000ULL,
    0xa3f0622380000ULL,
    0xbbebf3c1c0000ULL,
    0xc7f3696ae0000ULL,
    0x75ef853310000ULL,
    0x26e7e28da8000ULL,
    0xa169b374cc000ULL,
    0x663b0a2e5e000ULL,
    0x780074f509000ULL,
    0xcc1e8aa4a1800ULL,
    0x5a0536f67fc00ULL,
    0x27136b4105a00ULL,
    0xb19f841ea2100ULL,
    0xaa5fe02909880ULL,
    0x70adb182b3c40ULL,
    0x23d10b6f5bae0ULL,
    0xf6f375ebab1f0ULL,
    0xf9690b0da8088ULL,
    0xfa3775b4cc0c4ULL,
    0x3a030b8e5e0deULL,
    0x9704742509019ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x5000000000000ULL,
    0x2800000000000ULL,
    0xd400000000000ULL,
    0x4200000000000ULL,
    0xb100000000000ULL,
    0xfb80000000000ULL,
    0x9cc0000000000ULL,
    0xf0e0000000000ULL,
    0xd030000000000ULL,
    0x16c8000000000ULL,
    0x5f4000000000ULL,
    0x21b6000000000ULL,
    0xbf07000000000ULL,
    0x648b800000000ULL,
    0x854c00000000ULL,
    0xe0b1600000000ULL,
    0x9c86d00000000ULL,
    0x3446280000000ULL,
    0x16bfe40000000ULL,
    0x3f974a0000000ULL,
    0x56c9370000000ULL,
    0xa5f9638000000ULL,
    0x11b2d24000000ULL,
    0xc710292000000ULL,
    0x9888e61000000ULL,
    0x9e54cba800000ULL,
    0x13a9f69400000ULL,
    0xd61e016600000ULL,
    0x530302f700000ULL,
    0x7a95810d80000ULL,
    0x1f57c323c0000ULL,
    0x9024e230a0000ULL,
    0xb6d112c310000ULL,
    0x35e2ca3bf8000ULL,
    0x59aef65ccc000ULL,
    0x4315833976000ULL,
    0xf297c0ee8f000ULL,
    0xfb44e0084b800ULL,
    0xaa21104458400ULL,
    0xfbcacb2e25200ULL,
    0x586af79328d00ULL,
    0x366b8233b3880ULL,
    0xf964c218944c0ULL,
    0x45f9621753260ULL,
    0x81b2d07da7d50ULL,
    0x8f1029bbf80a8ULL,
    0x1c88e41ccc014ULL,
    0xf454ca1976022ULL,
    0x76a9f6fe8f0e1ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0xb000000000000ULL,
    0x3800000000000ULL,
    0xf400000000000ULL,
    0xee00000000000ULL,
    0x1f00000000000ULL,
    0xe480000000000ULL,
    0x3940000000000ULL,
    0xea60000000000ULL,
    0x2f30000000000ULL,
    0xa758000000000ULL,
    0x6d74000000000ULL,
    0x6fba000000000ULL,
    0xf809000000000ULL,
    0x540d800000000ULL,
    0xbe09400000000ULL,
    0x970f200000000ULL,
    0x2886f00000000ULL,
    0x2358f80000000ULL,
    0x1b64440000000ULL,
    0xd4b7da0000000ULL,
    0x7a92b50000000ULL,
    0xbe57218000000ULL,
    0xaaf2f3c000000ULL,
    0x7062fb6000000ULL,
    0x9e2d451000000ULL,
    0xbcda595800000ULL,
    0xabf6ac00000ULL,
    0x848001aa00000ULL,
    0xc940035900000ULL,
    0x3260035b80000ULL,
    0x6b300149c0000ULL,
    0x7158026ce0000ULL,
    0x867402a510000ULL,
    0x653a030988000ULL,
    0xde4902ccf4000ULL,
    0x5aed80d55e000ULL,
    0xa8794141c1000ULL,
    0xda372238ea800ULL,
    0x6ac2f3532ec00ULL,
    0xebbaf9f2d7600ULL,
    0x8e19469a7ed00ULL,
    0xef00593162880ULL,
    0x3c92f59fdac40ULL,
    0x7d558327896e0ULL,
    0x3c7d42dbbfdb0ULL,
    0xc4352289880b8ULL,
    0xadcff10cf40b4ULL,
    0x4b357bb55e00eULL,
    0x615d0451c10afULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0xf000000000000ULL,
    0x9800000000000ULL,
    0x1400000000000ULL,
    0x6a00000000000ULL,
    0xc900000000000ULL,
    0x4e80000000000ULL,
    0xdd40000000000ULL,
    0x8420000000000ULL,
    0x5370000000000ULL,
    0xe58000000000ULL,
    0xdbbc000000000ULL,
    0x74ba000000000ULL,
    0xcd35000000000ULL,
    0x5dfd800000000ULL,
    0x731dc00000000ULL,
    0xaf85600000000ULL,
    0xbfcb700000000ULL,
    0xd770b80000000ULL,
    0xec5ecc0000000ULL,
    0xceadda0000000ULL,
    0x2c29bd0000000ULL,
    0x3f67608000000ULL,
    0x204272c000000ULL,
    0x10b738e000000ULL,
    0x7f360f9000000ULL,
    0x20f539c800000ULL,
    0xa78f0e7400000ULL,
    0x23cab81200000ULL,
    0x616bce9100000ULL,
    0x335059ca80000ULL,
    0xaf347ca8c0000ULL,
    0x8e20161e0000ULL,
    0x8b89039730000ULL,
    0xadc7819988000ULL,
    0x5a68c39b24000ULL,
    0xa0d8e0479e000ULL,
    0x56e6b3b463000ULL,
    0x988dd97203800ULL,
    0x1259bd416ac00ULL,
    0x2dbf6122df600ULL,
    0xbbe722cb2f00ULL,
    0x5cad386b8b880ULL,
    0xe1330c1a4ec40ULL,
    0xd3f0b985416a0ULL,
    0x481ece08d1ff0ULL,
    0x3c0dd8d188018ULL,
    0x4619bf2f24054ULL,
    0x471f60b59e0caULL,
    0x758e72b563039ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x9000000000000ULL,
    0x800000000000ULL,
    0x8c00000000000ULL,
    0x6600000000000ULL,
    0x7100000000000ULL,
    0x7c80000000000ULL,
    0x6a40000000000ULL,
    0x7e20000000000ULL,
    0xa270000000000ULL,
    0x8548000000000ULL,
    0xa7a4000000000ULL,
    0xb6be000000000ULL,
    0x9a3b000000000ULL,
    0x1864800000000ULL,
    0x7a5b400000000ULL,
    0xb635e00000000ULL,
    0xce6f300000000ULL,
    0x7344980000000ULL,
    0xdeb4ec0000000ULL,
    0x46397a0000000ULL,
    0x967fdf0000000ULL,
    0x1743e18000000ULL,
    0xa4b0314000000ULL,
    0x593e1ba000000ULL,
    0x17e4ac7000000ULL,
    0x67801bb800000ULL,
    0xc1dfacf400000ULL,
    0xf9e499ea00000ULL,
    0x5a84ed2d00000ULL,
    0x3b5179aa80000ULL,
    0x72abdc50c0000ULL,
    0x5035e3d5a0000ULL,
    0x7f6f32a350000ULL,
    0xefc49b05d8000ULL,
    0x24f4eceb7c000ULL,
    0x30197909ea000ULL,
    0xb80fdc5541000ULL,
    0xf40be0bee5800ULL,
    0x721433ea81c00ULL,
    0x930018709de00ULL,
    0xe79fafe5d3700ULL,
    0x1c49a3b3d880ULL,
    0x19f4ee41fdcc0ULL,
    0xca997ad977ee0ULL,
    0x334fdfc092790ULL,
    0xfeabe13dd8088ULL,
    0x3624315f7c04cULL,
    0xe681b43ea086ULL,
    0x934bad08410e1ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x7000000000000ULL,
    0xa800000000000ULL,
    0xd400000000000ULL,
    0x4a00000000000ULL,
    0x9b00000000000ULL,
    0x3b80000000000ULL,
    0x5640000000000ULL,
    0x4ee0000000000ULL,
    0xdab0000000000ULL,
    0x6b48000000000ULL,
    0xc86c000000000ULL,
    0xca6a000000000ULL,
    0x9573000000000ULL,
    0x9cf3800000000ULL,
    0x5da1c00000000ULL,
    0x1edd200000000ULL,
    0x9739900000000ULL,
    0x5801780000000ULL,
    0xbc00b40000000ULL,
    0x3e145a0000000ULL,
    0xa115270000000ULL,
    0x89f208000000ULL,
    0xb9d692c000000ULL,
    0x52b0f82000000ULL,
    0xf4e769000000ULL,
    0x8a78f98800000ULL,
    0xf562763c00000ULL,
    0x4cf2f94600000ULL,
    0x85a175f500000ULL,
    0x62c97bf580000ULL,
    0x92cb7a3c0000ULL,
    0x891e5b9ea0000ULL,
    0x1c9627b770000ULL,
    0x53c4a16288000ULL,
    0xb9ab53d17c000ULL,
    0x9ccfd987e6000ULL,
    0x828e5ec8b000ULL,
    0xf18003f81a800ULL,
    0xd40000411400ULL,
    0xd56001e279600ULL,
    0xfcf0004758900ULL,
    0x8da8021a92880ULL,
    0xc6dc01156d4c0ULL,
    0xeb2200459f6a0ULL,
    0xc61f033bd3970ULL,
    0x6d19806a88028ULL,
    0x9e92c32d7c014ULL,
    0xcccea2e1e60eaULL,
    0x102851898b0ebULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x7000000000000ULL,
    0x7800000000000ULL,
    0x7c00000000000ULL,
    0xda00000000000ULL,
    0x4500000000000ULL,
    0xfb80000000000ULL,
    0x94c0000000000ULL,
    0xeae0000000000ULL,
    0x4c30000000000ULL,
    0xf7c8000000000ULL,
    0x4e6c000000000ULL,
    0xc66a000000000ULL,
    0x269000000000ULL,
    0x47c800000000ULL,
    0xeb66c00000000ULL,
    0x2deee00000000ULL,
    0x3ea5500000000ULL,
    0x9a84280000000ULL,
    0x795ea40000000ULL,
    0x3922ca0000000ULL,
    0x1457f70000000ULL,
    0x76ace08000000ULL,
    0xfe9052c000000ULL,
    0xf5aab6000000ULL,
    0xae3d643000000ULL,
    0xaedaa88800000ULL,
    0xbffd67e400000ULL,
    0x1fbaa80600000ULL,
    0x170d658700000ULL,
    0x7a92a92580000ULL,
    0x69516453c0000ULL,
    0x9130aa7ca0000ULL,
    0x6054662d70000ULL,
    0xa8a6292088000ULL,
    0x1d9ba54714000ULL,
    0x6bd44945da000ULL,
    0x846836e3ff000ULL,
    0x2b768134e9800ULL,
    0x8dffc3297e400ULL,
    0x4eba6256a3200ULL,
    0xe29f92683bd00ULL,
    0x548c89461880ULL,
    0xe33ef4ae6a4c0ULL,
    0x51506073792a0ULL,
    0x8d3690bbc4d70ULL,
    0x6a544928880f8ULL,
    0xe5a83463140bcULL,
    0xe2168023da07aULL,
    0x590fc054ff035ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x1000000000000ULL,
    0xc800000000000ULL,
    0x8c00000000000ULL,
    0x8200000000000ULL,
    0x8300000000000ULL,
    0xc980000000000ULL,
    0xb040000000000ULL,
    0x3ee0000000000ULL,
    0xc8b0000000000ULL,
    0xbb48000000000ULL,
    0xdb74000000000ULL,
    0x8afe000000000ULL,
    0xdeb3000000000ULL,
    0x9e4c800000000ULL,
    0x8ff7c00000000ULL,
    0x3a27200000000ULL,
    0x968bd00000000ULL,
    0x93c3f80000000ULL,
    0xf1ae740000000ULL,
    0x65ccda0000000ULL,
    0x4a1a70000000ULL,
    0x9959238000000ULL,
    0x2878d34000000ULL,
    0x9b6f7aa000000ULL,
    0x2ae9b67000000ULL,
    0xaea3fb2800000ULL,
    0x465e773c00000ULL,
    0xcbe4daae00000ULL,
    0x3425a78d00000ULL,
    0x978f237d80000ULL,
    0xd94fd093c0000ULL,
    0x8875fabea0000ULL,
    0xeb69743310000ULL,
    0xf2fe58c8d8000ULL,
    0xeaa565ea1c000ULL,
    0x485282074a000ULL,
    0xcaf4c1ead3000ULL,
    0x7ea3a1010e800ULL,
    0xee48109be0400ULL,
    0x57fadbb2cb600ULL,
    0x7e26a6954a900ULL,
    0x988ba249d6880ULL,
    0x92cc1231fc4c0ULL,
    0xbb2cd91581660ULL,
    0x1c11a60f99910ULL,
    0x8a1123e0d8048ULL,
    0x6f0cd2d61c04cULL,
    0x5b9178a94a0e2ULL,
    0xfb5ab667d3093ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x7000000000000ULL,
    0x9800000000000ULL,
    0x8400000000000ULL,
    0x1600000000000ULL,
    0x9900000000000ULL,
    0x1680000000000ULL,
    0x9e40000000000ULL,
    0x3e60000000000ULL,
    0x9a30000000000ULL,
    0x1748000000000ULL,
    0xe4000000000ULL,
    0xf862000000000ULL,
    0xcb35000000000ULL,
    0x8dd7800000000ULL,
    0xe4b8400000000ULL,
    0x5500e00000000ULL,
    0x4c84700000000ULL,
    0x9d4c580000000ULL,
    0xcbfb640000000ULL,
    0x81e4ba0000000ULL,
    0xaaeb170000000ULL,
    0xa362e18000000ULL,
    0x5ab172c000000ULL,
    0xf01bd9e000000ULL,
    0x580327d000000ULL,
    0x6404583800000ULL,
    0x661f677400000ULL,
    0x106b98200000ULL,
    0x929e16dd00000ULL,
    0x8855634380000ULL,
    0xa77930c1c0000ULL,
    0x8cb3391ca0000ULL,
    0x891357df50000ULL,
    0x3e8203dea8000ULL,
    0x6245022244000ULL,
    0xdc7f82ad56000ULL,
    0x8d2c430bf5000ULL,
    0x1ccae1fdfd800ULL,
    0x9e2570a2a0c00ULL,
    0xc151d83c1ae00ULL,
    0x79e2253e78500ULL,
    0x9ef9dba355880ULL,
    0xcd762440e4cc0ULL,
    0x37b3d9714cee0ULL,
    0x689726e58d570ULL,
    0xdb4e5be6a8018ULL,
    0x5afe655644044ULL,
    0xfb7b3b2f560f6ULL,
    0x3eb755d6f50e9ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x5000000000000ULL,
    0x5800000000000ULL,
    0xc00000000000ULL,
    0x3a00000000000ULL,
    0x5d00000000000ULL,
    0xf380000000000ULL,
    0x840000000000ULL,
    0x57e0000000000ULL,
    0x81b0000000000ULL,
    0x7548000000000ULL,
    0x5474000000000ULL,
    0xe1f6000000000ULL,
    0x26a9000000000ULL,
    0xbbce800000000ULL,
    0xffb8c00000000ULL,
    0xe651e00000000ULL,
    0xfced500000000ULL,
    0x752eb80000000ULL,
    0x8384940000000ULL,
    0xa0575a0000000ULL,
    0x33edc70000000ULL,
    0xbfa7e38000000ULL,
    0x4644524000000ULL,
    0xcce038e000000ULL,
    0x7d3c557000000ULL,
    0xd786bb8800000ULL,
    0x9640964400000ULL,
    0x54e958a600000ULL,
    0x1130c71500000ULL,
    0xbd9f607180000ULL,
    0x93559057c0000ULL,
    0xab7f5882a0000ULL,
    0x2369c75310000ULL,
    0xb779e214f8000ULL,
    0xe16953ae74000ULL,
    0xd670ba9162000ULL,
    0x20e9957787000ULL,
    0xd727d952dd800ULL,
    0xb288044b46400ULL,
    0x39ce822885600ULL,
    0x3eb8c10413100ULL,
    0x17d1e0c625880ULL,
    0xf5ad51a5324c0ULL,
    0xb34eba59e7660ULL,
    0x5b74960394150ULL,
    0x4b7f599cf80d8ULL,
    0xb369c5ea740ccULL,
    0x8f79e2376205aULL,
    0xbd6952628700dULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0xf000000000000ULL,
    0xa800000000000ULL,
    0xd400000000000ULL,
    0xd600000000000ULL,
    0xb300000000000ULL,
    0xc180000000000ULL,
    0xe7c0000000000ULL,
    0xdba0000000000ULL,
    0xf70000000000ULL,
    0x5558000000000ULL,
    0xdde4000000000ULL,
    0xa302000000000ULL,
    0xd983000000000ULL,
    0xfbc3800000000ULL,
    0x29be400000000ULL,
    0xc269a00000000ULL,
    0xf3ccd00000000ULL,
    0x2dba080000000ULL,
    0x2c73ec0000000ULL,
    0xccd1aa0000000ULL,
    0x463c3d0000000ULL,
    0x7aa8238000000ULL,
    0xb3f192c000000ULL,
    0xdc102b2000000ULL,
    0xd2017c9000000ULL,
    0x5d0203f800000ULL,
    0xfe83009c00000ULL,
    0x8c4381de00000ULL,
    0x8d7e429300000ULL,
    0x7049a2c880000ULL,
    0xcf7cd0f2c0000ULL,
    0x75420963e0000ULL,
    0x4de7ed8650000ULL,
    0xfb0baadf68000ULL,
    0xa59b3e8e9c000ULL,
    0xf9c9a18d86000ULL,
    0x4cbcd13d35000ULL,
    0xb0e20a93c8800ULL,
    0xd597ec8e5a400ULL,
    0x11d3aacb46a00ULL,
    0xf8bf3c84f0f00ULL,
    0x96eba3b4a0880ULL,
    0xce8fd29cc6440ULL,
    0x4598a98c0a60ULL,
    0xc97daf2ac5ff0ULL,
    0xfe400befe8028ULL,
    0x64eee05c094ULL,
    0xb6c82930660b6ULL,
    0xcf257e2865043ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x7000000000000ULL,
    0xa800000000000ULL,
    0xb400000000000ULL,
    0x6600000000000ULL,
    0x9300000000000ULL,
    0x5780000000000ULL,
    0x4f40000000000ULL,
    0x2d20000000000ULL,
    0x9970000000000ULL,
    0x77d8000000000ULL,
    0xd7e4000000000ULL,
    0xc612000000000ULL,
    0xc313000000000ULL,
    0xef8f800000000ULL,
    0x2354400000000ULL,
    0x572ba00000000ULL,
    0xd87e100000000ULL,
    0xd557d80000000ULL,
    0x5c3a2c0000000ULL,
    0xf3ee7a0000000ULL,
    0x38173d0000000ULL,
    0x2c16238000000ULL,
    0x1a0950c000000ULL,
    0x310bfb2000000ULL,
    0xa847f1000000ULL,
    0x3fd8013800000ULL,
    0x53e4019c00000ULL,
    0x6812014600000ULL,
    0x941302b100000ULL,
    0x760f834a80000ULL,
    0x4b144188c0000ULL,
    0x4b8ba0f3e0000ULL,
    0x9d4e137650000ULL,
    0xd82fdb9928000ULL,
    0x5dee2d6edc000ULL,
    0x6f047a12f6000ULL,
    0xb5903ce4dd000ULL,
    0x7253a0bdf0800ULL,
    0x2daa107339400ULL,
    0x4fbdda31b9e00ULL,
    0x32bd2e0d5cf00ULL,
    0x522bfa1cd8880ULL,
    0xf4f47c81e5440ULL,
    0x198001654fe60ULL,
    0x2840005881f70ULL,
    0x7ca001eba8028ULL,
    0x3530017a1c0f4ULL,
    0xa57801a716006ULL,
    0xb5d400238d0e3ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0x7000000000000ULL,
    0x3800000000000ULL,
    0x3400000000000ULL,
    0x1e00000000000ULL,
    0xf300000000000ULL,
    0x8680000000000ULL,
    0xc6c0000000000ULL,
    0xf5a0000000000ULL,
    0x6870000000000ULL,
    0x758000000000ULL,
    0xebec000000000ULL,
    0x881a000000000ULL,
    0x6c01000000000ULL,
    0x7a05800000000ULL,
    0xa50b400000000ULL,
    0x799aa00000000ULL,
    0x6a48300000000ULL,
    0xde6bc80000000ULL,
    0xe8480c0000000ULL,
    0x2f6b6a0000000ULL,
    0xdfc13d0000000ULL,
    0xfe25228000000ULL,
    0x8b3270c000000ULL,
    0xfaace86000000ULL,
    0xbce77d1000000ULL,
    0x3880029800000ULL,
    0x5c0021c00000ULL,
    0x6b2002e200000ULL,
    0xeab0011700000ULL,
    0xd4f8012c80000ULL,
    0x449c026ac0000ULL,
    0x17c203b3e0000ULL,
    0xb22d01c270000ULL,
    0x813f802708000ULL,
    0x67ba4104b4000ULL,
    0xf167201efe000ULL,
    0x4cdf7285e9000ULL,
    0x28b368131c800ULL,
    0x5ed3c92bdc00ULL,
    0x31f22bfada00ULL,
    0xfe8372b804f00ULL,
    0xd2d16aac14880ULL,
    0x9bb03f8a09c40ULL,
    0xa378a04353a20ULL,
    0xb5d5312aedf70ULL,
    0x332c4b93880b8ULL,
    0x8eae4d7274074ULL,
    0x82ee4b4f1e03eULL,
    0xbb834f5099083ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x5000000000000ULL,
    0x9800000000000ULL,
    0x8400000000000ULL,
    0x7200000000000ULL,
    0x7300000000000ULL,
    0xdd80000000000ULL,
    0x8640000000000ULL,
    0x4e60000000000ULL,
    0xff30000000000ULL,
    0x3ed8000000000ULL,
    0x4a4000000000ULL,
    0x6196000000000ULL,
    0x51000000000ULL,
    0xe76f800000000ULL,
    0x1da4c00000000ULL,
    0xb0b200000000ULL,
    0x4981500000000ULL,
    0xc43380000000ULL,
    0xe96e640000000ULL,
    0xc8be1a0000000ULL,
    0x4f8e350000000ULL,
    0xe54aa38000000ULL,
    0x6be0904000000ULL,
    0xad699be000000ULL,
    0x9abef75000000ULL,
    0xc8f81a800000ULL,
    0xf0d4c2dc00000ULL,
    0xf1b3233e00000ULL,
    0x1515529500000ULL,
    0x648d382f80000ULL,
    0x9cdb67f5c0000ULL,
    0xafa79a0ae0000ULL,
    0x580bf72250000ULL,
    0xa416018b38000ULL,
    0x4211024ad4000ULL,
    0xbb0f80c266000ULL,
    0xc194c0db17000ULL,
    0x705320e2f2800ULL,
    0x4f65529e06400ULL,
    0x51b53b2578600ULL,
    0x650f6557f8d00ULL,
    0xcc8998c1ca880ULL,
    0xd0cef608d2440ULL,
    0xc1b782d91e660ULL,
    0xdd00c219efd50ULL,
    0x789d238cb8018ULL,
    0x6ad05323140c4ULL,
    0xaeacb81686012ULL,
    0xf68aa73c47023ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x9000000000000ULL,
    0x1800000000000ULL,
    0x9c00000000000ULL,
    0x3200000000000ULL,
    0x3d00000000000ULL,
    0x5c80000000000ULL,
    0xb340000000000ULL,
    0x8320000000000ULL,
    0x5970000000000ULL,
    0x90c8000000000ULL,
    0x19f4000000000ULL,
    0xd18e000000000ULL,
    0xc7c9000000000ULL,
    0x447c800000000ULL,
    0xfc57c00000000ULL,
    0x42bae00000000ULL,
    0x46a3b00000000ULL,
    0x28a1b80000000ULL,
    0x47a6ac0000000ULL,
    0xb6355a0000000ULL,
    0x41fc1f0000000ULL,
    0xed80638000000ULL,
    0x5c9714000000ULL,
    0xf169d9e000000ULL,
    0x24dbdc3000000ULL,
    0x5ff282a800000ULL,
    0xca9ec18400000ULL,
    0x1046603a00000ULL,
    0x38b4707900000ULL,
    0x9fbb5b1e80000ULL,
    0x4a351dd8c0000ULL,
    0xe3fce287a0000ULL,
    0xc89eb2f610000ULL,
    0xc55339f718000ULL,
    0x70386ff5f4000ULL,
    0x9af33a3b4a000ULL,
    0x5a086cfbbb000ULL,
    0xe91b391039800ULL,
    0x8a8c6f3801c00ULL,
    0xb05d387c55600ULL,
    0xc8b16ee630700ULL,
    0x17afba4f21880ULL,
    0xce2fad49f5cc0ULL,
    0x4de9d87d1f660ULL,
    0xc79bdd648b790ULL,
    0xa4d283c198098ULL,
    0x9feec2e93405cULL,
    0xaa8e6166ea052ULL,
    0x80407244ab0adULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x3000000000000ULL,
    0x3800000000000ULL,
    0x9400000000000ULL,
    0xd600000000000ULL,
    0x9900000000000ULL,
    0x380000000000ULL,
    0x4340000000000ULL,
    0xc5a0000000000ULL,
    0x59f0000000000ULL,
    0x2ec8000000000ULL,
    0x4be4000000000ULL,
    0xa9ca000000000ULL,
    0x9d79000000000ULL,
    0x9b19800000000ULL,
    0x6c96400000000ULL,
    0x9d2e00000000ULL,
    0x8d67d00000000ULL,
    0x7305d80000000ULL,
    0xf0897c0000000ULL,
    0x73d53a0000000ULL,
    0x5673af0000000ULL,
    0x3f83618000000ULL,
    0x295593c000000ULL,
    0xf6bd3b6000000ULL,
    0x8967ae9000000ULL,
    0x8d0161b800000ULL,
    0x1588933400000ULL,
    0x3a4eb8d600000ULL,
    0xf638efa900000ULL,
    0x22a201f880000ULL,
    0x7f6d013ac0000ULL,
    0xc41b8375a0000ULL,
    0x1e0b42ec50000ULL,
    0xd50162f208000ULL,
    0x7188900774000ULL,
    0x344eb885ce000ULL,
    0xcb38ecc47d000ULL,
    0xcf2200fe0d800ULL,
    0x312d00a556400ULL,
    0xd43b83daf4e00ULL,
    0x9dbb42259eb00ULL,
    0x3de9623405880ULL,
    0x20dc9056224c0ULL,
    0x76ecb8e93aee0ULL,
    0x4455efd8e3b30ULL,
    0xd339828a880b8ULL,
    0x8b2642fdb4054ULL,
    0xef3ae0906e036ULL,
    0xe133d0b82d0a9ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x3000000000000ULL,
    0x3800000000000ULL,
    0xa400000000000ULL,
    0xb600000000000ULL,
    0x2900000000000ULL,
    0x4880000000000ULL,
    0x7a40000000000ULL,
    0x9ba0000000000ULL,
    0x16f0000000000ULL,
    0xd8000000000ULL,
    0xeef4000000000ULL,
    0x4ca000000000ULL,
    0x88e9000000000ULL,
    0x25df800000000ULL,
    0x5c6c400000000ULL,
    0x4d98e00000000ULL,
    0x58d6b00000000ULL,
    0x3aeb980000000ULL,
    0x6adb9c0000000ULL,
    0x35e17a0000000ULL,
    0xe3502d0000000ULL,
    0xab3f618000000ULL,
    0x28bef1c000000ULL,
    0x1d617b6000000ULL,
    0xe9102e5000000ULL,
    0xe89f603800000ULL,
    0xaa4ef33400000ULL,
    0x93b9787a00000ULL,
    0x8ae42d8d00000ULL,
    0x12d561ac80000ULL,
    0x71e7f222c0000ULL,
    0x6546fb35e0000ULL,
    0xba386f8410000ULL,
    0xc43583d248000ULL,
    0xd13543e174000ULL,
    0x5bbf63b2d6000ULL,
    0xb6fef36dd5000ULL,
    0xd0c178607d800ULL,
    0xe6e02cd03bc00ULL,
    0x98c7637865e00ULL,
    0x9afaf31450b00ULL,
    0xbad37a0a35880ULL,
    0x3dfd2dc54fc40ULL,
    0x7f52e3d0b3ee0ULL,
    0xb93fb3a485b30ULL,
    0xb7b41bfec80b8ULL,
    0x7cf7dc03b40e4ULL,
    0xdbd999e736056ULL,
    0x9769fb9c5019ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x9000000000000ULL,
    0x3800000000000ULL,
    0x1c00000000000ULL,
    0xd200000000000ULL,
    0x5100000000000ULL,
    0xc980000000000ULL,
    0x65c0000000000ULL,
    0x2360000000000ULL,
    0x21b0000000000ULL,
    0xb458000000000ULL,
    0x8abc000000000ULL,
    0x48d6000000000ULL,
    0x48fd000000000ULL,
    0x1d60800000000ULL,
    0xeab3c00000000ULL,
    0x38db600000000ULL,
    0x40fe900000000ULL,
    0xa97ec80000000ULL,
    0x1cac740000000ULL,
    0xa7cbaa0000000ULL,
    0xa63e50000000ULL,
    0x543be08000000ULL,
    0x938d534000000ULL,
    0xc0c5aa6000000ULL,
    0xbce2e63000000ULL,
    0x4b6d61a800000ULL,
    0xe5b3903400000ULL,
    0x4a464aee00000ULL,
    0xa1a3b69300000ULL,
    0xf446c94b80000ULL,
    0x2aa07461c0000ULL,
    0xd8c5a994e0000ULL,
    0x70e2e4a830000ULL,
    0x16d60b438000ULL,
    0x38b391ae04000ULL,
    0x69c648f35a000ULL,
    0x8963b57bfb000ULL,
    0xcca6c8c98f800ULL,
    0x3fd07520c5400ULL,
    0x867dab064ea00ULL,
    0xbe2ee7477f900ULL,
    0xde836155b7880ULL,
    0xdb4293fac1440ULL,
    0x8828c97b14aa0ULL,
    0xa191779f84990ULL,
    0xa1cb29ffb80b8ULL,
    0xdd6025cfc405cULL,
    0xab88167ba072ULL,
    0x8cfc1d3cb0c1ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x9000000000000ULL,
    0xd800000000000ULL,
    0xdc00000000000ULL,
    0x3a00000000000ULL,
    0x4d00000000000ULL,
    0x6080000000000ULL,
    0xf0c0000000000ULL,
    0x76a0000000000ULL,
    0xe570000000000ULL,
    0xc058000000000ULL,
    0xfe74000000000ULL,
    0x3fde000000000ULL,
    0x5721000000000ULL,
    0x772c800000000ULL,
    0x4736c00000000ULL,
    0xef31e00000000ULL,
    0x7b28300000000ULL,
    0x4538480000000ULL,
    0xee2fec0000000ULL,
    0xf9afaa0000000ULL,
    0x24e2dd0000000ULL,
    0xc21d618000000ULL,
    0xa11ef34000000ULL,
    0xf289a8e000000ULL,
    0x29c7dd3000000ULL,
    0x2837e18800000ULL,
    0xbebd334400000ULL,
    0xa16acaea00000ULL,
    0xc6482cb700000ULL,
    0x196ac93880000ULL,
    0xca482e26c0000ULL,
    0x1b6acbb3e0000ULL,
    0xcb482e1810000ULL,
    0x99eac89c18000ULL,
    0xaa882d5654000ULL,
    0xb5cacaf14a000ULL,
    0xf2382ed19f000ULL,
    0x63b2caeb15800ULL,
    0x19fc2dceabc00ULL,
    0xea94c807dea00ULL,
    0x55d92e5a5b700ULL,
    0x623e4a7f0d880ULL,
    0xbbbaec9cffc40ULL,
    0xc5fd2afc94ae0ULL,
    0xd0851c0cc4790ULL,
    0x18d801a498058ULL,
    0x2b403709409cULL,
    0x4b7e0142aa0daULL,
    0xb35100c98f0ddULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x3000000000000ULL,
    0xc800000000000ULL,
    0xcc00000000000ULL,
    0xd600000000000ULL,
    0x3f00000000000ULL,
    0xc980000000000ULL,
    0xe540000000000ULL,
    0x65e0000000000ULL,
    0xb930000000000ULL,
    0x1198000000000ULL,
    0x915c000000000ULL,
    0x17f2000000000ULL,
    0xac2f000000000ULL,
    0xf918800000000ULL,
    0x4e9f400000000ULL,
    0x88cf200000000ULL,
    0xaaa1d00000000ULL,
    0xfdd5180000000ULL,
    0x923b540000000ULL,
    0x7a02ba0000000ULL,
    0x3905c50000000ULL,
    0xae98808000000ULL,
    0x18df41c000000ULL,
    0x52af21a000000ULL,
    0xf9d1d3f000000ULL,
    0x882d187800000ULL,
    0x931757cc00000ULL,
    0xcf88ba7e00000ULL,
    0x8246c66900000ULL,
    0x986a023180000ULL,
    0x8e7300b1c0000ULL,
    0x516a8071e0000ULL,
    0x8f04351b0000ULL,
    0x15b7a061a8000ULL,
    0x744e9339cc000ULL,
    0xd7623bc5aa000ULL,
    0x2ff684e3c1000ULL,
    0x483da176de800ULL,
    0x730d93e13a400ULL,
    0x5f90ba8588e00ULL,
    0x7a5ac483da100ULL,
    0x9c780326f6880ULL,
    0x946c006936440ULL,
    0xb86a0131c2ea0ULL,
    0xfe730331ab130ULL,
    0x396a823180048ULL,
    0xf4f040b1c008cULL,
    0xbb7a071e0076ULL,
    0x874e9351b000fULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x3000000000000ULL,
    0x3800000000000ULL,
    0xf400000000000ULL,
    0x2600000000000ULL,
    0x3300000000000ULL,
    0xe480000000000ULL,
    0x95c0000000000ULL,
    0x42e0000000000ULL,
    0xbbb0000000000ULL,
    0xe098000000000ULL,
    0x2bd4000000000ULL,
    0x55fa000000000ULL,
    0x7131000000000ULL,
    0x8a41800000000ULL,
    0x5fae400000000ULL,
    0x6e88a00000000ULL,
    0x4d3f00000000ULL,
    0x6b6ba80000000ULL,
    0x3df6a40000000ULL,
    0xcd228a0000000ULL,
    0x804b150000000ULL,
    0x8ea1818000000ULL,
    0xa71e41c000000ULL,
    0xb290a36000000ULL,
    0x7ec7f31000000ULL,
    0x6271a87800000ULL,
    0x3077a71c00000ULL,
    0x657b090a00000ULL,
    0x52f1579b00000ULL,
    0x13b3231980000ULL,
    0xfc8cb179c0000ULL,
    0xf1c289e9e0000ULL,
    0x8cfb155190000ULL,
    0x74b980ad88000ULL,
    0xee0a437794000ULL,
    0x5f0aa3f4ee000ULL,
    0xe686f2e17d000ULL,
    0x88c829eaa4800ULL,
    0x597de60436c00ULL,
    0x18f1a8066c200ULL,
    0x22b7a76905500ULL,
    0x51b0a5eac880ULL,
    0x7f81540a62c40ULL,
    0x6d4b221b622e0ULL,
    0xd28b0d9e8530ULL,
    0x20408b19800b8ULL,
    0x5eae1579c00b4ULL,
    0xaf1a03e9e00c6ULL,
    0x7e81005190003ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x1000000000000ULL,
    0xb800000000000ULL,
    0xcc00000000000ULL,
    0xd200000000000ULL,
    0x9900000000000ULL,
    0x7780000000000ULL,
    0x35c0000000000ULL,
    0xe6e0000000000ULL,
    0x50b0000000000ULL,
    0x5d88000000000ULL,
    0x40c4000000000ULL,
    0xb37e000000000ULL,
    0x5465000000000ULL,
    0xb8e6800000000ULL,
    0x3bb7c00000000ULL,
    0x431f600000000ULL,
    0xaa8cd00000000ULL,
    0x1458c80000000ULL,
    0xfc2ca40000000ULL,
    0xfec12a0000000ULL,
    0xc867b70000000ULL,
    0xf2ee818000000ULL,
    0x9eb3c34000000ULL,
    0x4e81616000000ULL,
    0x7259d37000000ULL,
    0x9b3649a800000ULL,
    0xd25f655400000ULL,
    0xab20489600000ULL,
    0x9a4e65b300000ULL,
    0xcf30cbc580000ULL,
    0x3c58a6d5c0000ULL,
    0x4837298da0000ULL,
    0xc6b431d0000ULL,
    0x93760393d8000ULL,
    0xa461024684000ULL,
    0x10f883d862000ULL,
    0x4fa2c07c4b000ULL,
    0x5d11e00267800ULL,
    0xe18f12852c400ULL,
    0xfad1a926bea00ULL,
    0xbe7177a851d00ULL,
    0x2de960543f880ULL,
    0x7e2dd216684c0ULL,
    0xffc049737cae0ULL,
    0x83fe64e5cad10ULL,
    0xbd38ca4580038ULL,
    0x955ca595c000cULL,
    0x77a928eda0032ULL,
    0x5113b741d0089ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x5000000000000ULL,
    0xd800000000000ULL,
    0x5c00000000000ULL,
    0x9e00000000000ULL,
    0x3100000000000ULL,
    0xf780000000000ULL,
    0xb40000000000ULL,
    0xf1e0000000000ULL,
    0x2930000000000ULL,
    0x6198000000000ULL,
    0xfe44000000000ULL,
    0xa466000000000ULL,
    0xdd61000000000ULL,
    0x8ee8800000000ULL,
    0x77ac400000000ULL,
    0xa14be00000000ULL,
    0xcaedd00000000ULL,
    0x95b9180000000ULL,
    0x3e4e140000000ULL,
    0x847a7a0000000ULL,
    0xed7f850000000ULL,
    0x6f0838000000ULL,
    0xf3a8404000000ULL,
    0x634de2e000000ULL,
    0x65fcd03000000ULL,
    0x5329991800000ULL,
    0xc29655b400000ULL,
    0x7ecf9ba600000ULL,
    0x35b755e900000ULL,
    0x4e471b9980000ULL,
    0x6c6b14c9c0000ULL,
    0x3974faa1e0000ULL,
    0x1cf2c66dd0000ULL,
    0xb3e18ff8000ULL,
    0x3bd9d17894000ULL,
    0xa8271bec3a000ULL,
    0x5e1b167235000ULL,
    0x110cfbbf0d800ULL,
    0xc786c6c8c6400ULL,
    0x834de0b42be00ULL,
    0x75fcd0265f100ULL,
    0xeb2999a975880ULL,
    0xce96577992440ULL,
    0x38cf9bf9f1e60ULL,
    0x58b75539ba150ULL,
    0x27c7181980058ULL,
    0x562b1489c001cULL,
    0x3f14f841e00feULL,
    0x3e82c65dd0061ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0xb000000000000ULL,
    0x5800000000000ULL,
    0xbc00000000000ULL,
    0x6e00000000000ULL,
    0x8500000000000ULL,
    0xf780000000000ULL,
    0xf9c0000000000ULL,
    0xb6a0000000000ULL,
    0x9ef0000000000ULL,
    0x4098000000000ULL,
    0x354c000000000ULL,
    0xf5f2000000000ULL,
    0x720d000000000ULL,
    0x1b14800000000ULL,
    0xa9e400000000ULL,
    0x24b600000000ULL,
    0x7965500000000ULL,
    0x1146480000000ULL,
    0x47ec2c0000000ULL,
    0x901aa0000000ULL,
    0x819b3d0000000ULL,
    0xe0de828000000ULL,
    0x9f2f43c000000ULL,
    0xba35e1e000000ULL,
    0xbdba103000000ULL,
    0x3c6ba8d800000ULL,
    0x86da3ce400000ULL,
    0x2e38006600000ULL,
    0x57bc00f300000ULL,
    0xfb6a018480000ULL,
    0x7241035cc0000ULL,
    0x416682b8e0000ULL,
    0x3d53405ef0000ULL,
    0xc1ffe36da8000ULL,
    0x680b130904000ULL,
    0xa41528659a000ULL,
    0xf2057e054d000ULL,
    0x5b15e0bfff800ULL,
    0x2a8a12b42c400ULL,
    0xb253a9ce54a00ULL,
    0x21663eef15f00ULL,
    0xad5200d6d7880ULL,
    0x29fd0121e8440ULL,
    0x8c0c82f32ea20ULL,
    0x76124084a8fb0ULL,
    0x191963dc800d8ULL,
    0x29985078c00fcULL,
    0x24cac93ee004eULL,
    0xfd3e6d9df0035ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0xf000000000000ULL,
    0xd800000000000ULL,
    0xcc00000000000ULL,
    0xba00000000000ULL,
    0x1100000000000ULL,
    0xb180000000000ULL,
    0xbec0000000000ULL,
    0xd160000000000ULL,
    0x9830000000000ULL,
    0xa498000000000ULL,
    0x1144000000000ULL,
    0xb0b2000000000ULL,
    0x6fd5000000000ULL,
    0x40ea800000000ULL,
    0xb6f2c00000000ULL,
    0x5df3600000000ULL,
    0x9d7b100000000ULL,
    0x6232680000000ULL,
    0xd58bb40000000ULL,
    0x50d38a0000000ULL,
    0xd676650000000ULL,
    0x72b8838000000ULL,
    0x62d7c2c000000ULL,
    0x361e2e000000ULL,
    0xfd3dd0f000000ULL,
    0x930b098800000ULL,
    0xdc91a77400000ULL,
    0xd41622e00000ULL,
    0x42ae13bf00000ULL,
    0x9ad8e80380000ULL,
    0x5f79775bc0000ULL,
    0x6f20e8b7e0000ULL,
    0x960d7415d0000ULL,
    0x1b0ae938a8000ULL,
    0x189c777e44000ULL,
    0x335269e762000ULL,
    0xdbbb46f9f000ULL,
    0x944b8939e7800ULL,
    0x3732677ae7400ULL,
    0x1a0a82a364200ULL,
    0xc102c229d2900ULL,
    0xf98b6382cf880ULL,
    0x5acf119f63440ULL,
    0x7f786b13e6260ULL,
    0xff2ab7a39d9f0ULL,
    0xbe13098b80058ULL,
    0xf15a42fc008cULL,
    0x6e936099e00daULL,
    0x984b12aad00e1ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x3000000000000ULL,
    0x800000000000ULL,
    0xc00000000000ULL,
    0x9e00000000000ULL,
    0x7700000000000ULL,
    0xf980000000000ULL,
    0x440000000000ULL,
    0x7c60000000000ULL,
    0x83b0000000000ULL,
    0xea88000000000ULL,
    0xbfdc000000000ULL,
    0x8922000000000ULL,
    0x4557000000000ULL,
    0xef8800000000ULL,
    0xc866400000000ULL,
    0xd9b3200000000ULL,
    0x2f9cd00000000ULL,
    0x9f44380000000ULL,
    0xbffc40000000ULL,
    0xc8e79a0000000ULL,
    0x6b69570000000ULL,
    0xaa3a828000000ULL,
    0xf6c143c000000ULL,
    0xf7a3a0a000000ULL,
    0x909690f000000ULL,
    0x4add1a5800000ULL,
    0xa1a815ec00000ULL,
    0xcb99239e00000ULL,
    0x1d57d2cd00000ULL,
    0xdafeba9780000ULL,
    0x427e86dfc0000ULL,
    0x4a4387ba0000ULL,
    0x3b0fc7c1b0000ULL,
    0x878f9976a8000ULL,
    0x634555f62c000ULL,
    0xbdf083596a000ULL,
    0x83fa41d5c5000ULL,
    0x4f12074ae800ULL,
    0xd57bd0bd2a400ULL,
    0xed34bb0ffc600ULL,
    0x7458793fc500ULL,
    0xfff6b91586880ULL,
    0x72e28454c64c0ULL,
    0xbe663a8d36620ULL,
    0xb2a8c67789530ULL,
    0x701f18cf80088ULL,
    0xe80f1733c00ccULL,
    0x1c09a1e5a00beULL,
    0xa61d920cb0047ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0x1000000000000ULL,
    0x7800000000000ULL,
    0xac00000000000ULL,
    0x5a00000000000ULL,
    0x1100000000000ULL,
    0x5380000000000ULL,
    0xf340000000000ULL,
    0x63e0000000000ULL,
    0xed30000000000ULL,
    0xca98000000000ULL,
    0x4cc000000000ULL,
    0x2ea6000000000ULL,
    0x1dd000000000ULL,
    0xeb32800000000ULL,
    0x898ac00000000ULL,
    0xa243600000000ULL,
    0x1063500000000ULL,
    0xe73980000000ULL,
    0xd16e540000000ULL,
    0x45fa7a0000000ULL,
    0xbe3bc50000000ULL,
    0x1414828000000ULL,
    0x9617c14000000ULL,
    0x7b11e16000000ULL,
    0x2a9992f000000ULL,
    0x74c8f88800000ULL,
    0x66b106f400000ULL,
    0xc5d7e22600000ULL,
    0x6534928900000ULL,
    0x6e82784180000ULL,
    0xbac7c439c0000ULL,
    0xa1aa8145e0000ULL,
    0xcd46c017f0000ULL,
    0xace56278f8000ULL,
    0x1be501044000ULL,
    0x9d411bb852000ULL,
    0xf4e4975c5f000ULL,
    0xbdb91bc247800ULL,
    0xbf58949766400ULL,
    0x49e71a54a3e00ULL,
    0xb439959a04100ULL,
    0x5d0b9b7b3f880ULL,
    0x799255fee2440ULL,
    0xaa447bc911e20ULL,
    0xf46ac521ab110ULL,
    0x906000c9800f8ULL,
    0x4e7002cdc00ecULL,
    0xf1780363e007aULL,
    0x55fc029ef0001ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0x3000000000000ULL,
    0xd800000000000ULL,
    0xc400000000000ULL,
    0xb200000000000ULL,
    0x1d00000000000ULL,
    0xf180000000000ULL,
    0xe440000000000ULL,
    0xfce0000000000ULL,
    0x3430000000000ULL,
    0xbd18000000000ULL,
    0x818c000000000ULL,
    0x1c42000000000ULL,
    0x8fd000000000ULL,
    0x5e33800000000ULL,
    0x6416c00000000ULL,
    0xc219e00000000ULL,
    0xe51f900000000ULL,
    0x59fb80000000ULL,
    0x8e40940000000ULL,
    0x25f7da0000000ULL,
    0x77b4c50000000ULL,
    0x4442028000000ULL,
    0x8cfd01c000000ULL,
    0xcc3383e000000ULL,
    0x4916c3d000000ULL,
    0xeb99e1a800000ULL,
    0xc55f936400000ULL,
    0x4b7fb90e00000ULL,
    0xa77097e500000ULL,
    0x696fda3580000ULL,
    0x1278c641c0000ULL,
    0xa4e00387e0000ULL,
    0xb0300316f0000ULL,
    0x2f18016568000ULL,
    0xac8c01f5c4000ULL,
    0x35c200a1c6000ULL,
    0x28bd02d7af000ULL,
    0x10d3837ea9800ULL,
    0x4d26c1e125400ULL,
    0x8e81e32b99600ULL,
    0x80d392ecbc100ULL,
    0xe53db98641880ULL,
    0xb28d953121440ULL,
    0xc6dc5903bf620ULL,
    0x922e04c8e3130ULL,
    0x9a19e1a800058ULL,
    0x611f936400084ULL,
    0x979fb90e00092ULL,
    0xa34097e50002dULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x3000000000000ULL,
    0x2800000000000ULL,
    0x2c00000000000ULL,
    0x9600000000000ULL,
    0x700000000000ULL,
    0x1480000000000ULL,
    0xd4c0000000000ULL,
    0x4c60000000000ULL,
    0x2330000000000ULL,
    0xc318000000000ULL,
    0x8e84000000000ULL,
    0x15ca000000000ULL,
    0x47e3000000000ULL,
    0xe770800000000ULL,
    0xe1af400000000ULL,
    0x70c6200000000ULL,
    0xe660700000000ULL,
    0xca27080000000ULL,
    0xe48d940000000ULL,
    0xdcdbaa0000000ULL,
    0x3061a50000000ULL,
    0xad2a038000000ULL,
    0xc01301c000000ULL,
    0x2008812000000ULL,
    0x501b407000000ULL,
    0x181422f800000ULL,
    0x40770ac00000ULL,
    0xba1d8a0a00000ULL,
    0x9101d74f00000ULL,
    0x138d0b6380000ULL,
    0xc05e96dfc0000ULL,
    0x98b329bde0000ULL,
    0x6f4ae776d0000ULL,
    0xe026207b48000ULL,
    0x4d9072559c000ULL,
    0x9b5f08b2ea000ULL,
    0x523996f531000ULL,
    0xa089aaf4da800ULL,
    0x6c6a6e03cc00ULL,
    0x9170825004a00ULL,
    0x96af420877900ULL,
    0x2c46231412880ULL,
    0x2ea072c660c40ULL,
    0x384709550ea60ULL,
    0xecbd94c496930ULL,
    0x9d43aaf8000a8ULL,
    0x6d25a4ac0006cULL,
    0xe000000a000f6ULL,
    0x7000024f00037ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x3000000000000ULL,
    0x3800000000000ULL,
    0xe400000000000ULL,
    0x4e00000000000ULL,
    0x7b00000000000ULL,
    0x8080000000000ULL,
    0x46c0000000000ULL,
    0x3f60000000000ULL,
    0xda30000000000ULL,
    0x1708000000000ULL,
    0xd29c000000000ULL,
    0xb7c2000000000ULL,
    0xbae1000000000ULL,
    0x5f6b800000000ULL,
    0xa3d400000000ULL,
    0x3f0aa00000000ULL,
    0x3e85700000000ULL,
    0x25ddc80000000ULL,
    0x6bf2b40000000ULL,
    0xeafeea0000000ULL,
    0xb76b870000000ULL,
    0xc622028000000ULL,
    0x9d1103c000000ULL,
    0xd783806000000ULL,
    0x7451435000000ULL,
    0x98a0a1d800000ULL,
    0x68c8727c00000ULL,
    0x947c4b3a00000ULL,
    0x72b2f4f700000ULL,
    0xbdddc8ff80000ULL,
    0x7ff2b573c0000ULL,
    0xbcfeea21a0000ULL,
    0x186b87e2b0000ULL,
    0x30a200e328000ULL,
    0x44d101f1f4000ULL,
    0x266382faa6000ULL,
    0x93a1407f71000ULL,
    0x3048a25b84800ULL,
    0x26a473b5e0c00ULL,
    0xbd64bacdda00ULL,
    0xc0fff6ca1f100ULL,
    0x427c4b9f2c880ULL,
    0x1db2f54bd4cc0ULL,
    0x6b5dc84ddba20ULL,
    0x9632b5a0de130ULL,
    0x751ee9d8000b8ULL,
    0x1b9b867c00024ULL,
    0xd64a013a0006eULL,
    0x71bd03f70004bULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0xb000000000000ULL,
    0xd800000000000ULL,
    0x5c00000000000ULL,
    0xe200000000000ULL,
    0xe500000000000ULL,
    0x5d80000000000ULL,
    0x4ac0000000000ULL,
    0x10a0000000000ULL,
    0xcaf0000000000ULL,
    0xe908000000000ULL,
    0x1794000000000ULL,
    0x4bda000000000ULL,
    0x432d000000000ULL,
    0x5f20800000000ULL,
    0x1d3fc00000000ULL,
    0x2824e00000000ULL,
    0x1da5100000000ULL,
    0xd36be80000000ULL,
    0x7dc9cc0000000ULL,
    0xb0358a0000000ULL,
    0xe1be1f0000000ULL,
    0xe17a038000000ULL,
    0xf0dd01c000000ULL,
    0x69a882e000000ULL,
    0x156bc3b000000ULL,
    0xf6dee0e800000ULL,
    0x82b812e400000ULL,
    0x97e36afe00000ULL,
    0x58920ebf00000ULL,
    0x67436b3480000ULL,
    0xe2620d00c0000ULL,
    0x364b6866a0000ULL,
    0x19f60eb590000ULL,
    0x47916a6b48000ULL,
    0xe3db0de2e4000ULL,
    0xa731eb3bea000ULL,
    0x5124ce5c4b000ULL,
    0xc2350bc211800ULL,
    0xccb1de0d6b400ULL,
    0xe8f6e1b1bc200ULL,
    0x6c1c10a573700ULL,
    0xfa116a75d9880ULL,
    0xd91b0c0b4f4c0ULL,
    0xf91e812f6260ULL,
    0x77d4cef3a87b0ULL,
    0x113d08e800058ULL,
    0x6225dee40009cULL,
    0x1cace0fe00082ULL,
    0x80f111bf00055ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0xd000000000000ULL,
    0x4800000000000ULL,
    0xfc00000000000ULL,
    0xca00000000000ULL,
    0x4d00000000000ULL,
    0xe180000000000ULL,
    0x2a40000000000ULL,
    0x2a20000000000ULL,
    0xf0f0000000000ULL,
    0x2b18000000000ULL,
    0x6e84000000000ULL,
    0x1ad6000000000ULL,
    0xfbf3000000000ULL,
    0xf586800000000ULL,
    0xec4ec00000000ULL,
    0x553ce00000000ULL,
    0x387f900000000ULL,
    0x9ec8780000000ULL,
    0x15fb8c0000000ULL,
    0xa6841a0000000ULL,
    0xa6c9dd0000000ULL,
    0x51ee038000000ULL,
    0x6887024000000ULL,
    0x45c880a000000ULL,
    0x8379c0b000000ULL,
    0xd84c620800000ULL,
    0x233252c400000ULL,
    0xdf6a18ae00000ULL,
    0xe24edd9d00000ULL,
    0x9626812e80000ULL,
    0x5afec26ac0000ULL,
    0xb604e184e0000ULL,
    0xc70b9139d0000ULL,
    0xcc8679e738000ULL,
    0x1bcc8da5dc000ULL,
    0x48749a9542000ULL,
    0x26c41c6af7000ULL,
    0x11ec6284e9800ULL,
    0x88251b9c5400ULL,
    0x95d21b2752600ULL,
    0xcb7adfc5d0700ULL,
    0x2448804551880ULL,
    0xe939c0b2d9440ULL,
    0x926c6298f0660ULL,
    0x3c2520bf77d0ULL,
    0xbc721988000c8ULL,
    0x70cadc84000bcULL,
    0x46f0820e000aaULL,
    0xec0dc02d0009dULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x3000000000000ULL,
    0x1800000000000ULL,
    0xec00000000000ULL,
    0x5a00000000000ULL,
    0xc300000000000ULL,
    0x7280000000000ULL,
    0x67c0000000000ULL,
    0x3320000000000ULL,
    0x5970000000000ULL,
    0xcd08000000000ULL,
    0x1784000000000ULL,
    0x445a000000000ULL,
    0x2165000000000ULL,
    0xd10e800000000ULL,
    0xb58ec00000000ULL,
    0x5b4f200000000ULL,
    0x11f0300000000ULL,
    0x99d1a80000000ULL,
    0xae2f1c0000000ULL,
    0xa6ea0a0000000ULL,
    0x9d44ef0000000ULL,
    0xb0f2018000000ULL,
    0x145103c000000ULL,
    0xc97c83e000000ULL,
    0xc51fc37000000ULL,
    0x3393a10800000ULL,
    0xda5ff0bc00000ULL,
    0x4c6a08a200000ULL,
    0xd684ee9300000ULL,
    0x39d2030680000ULL,
    0xbe2103fac0000ULL,
    0x6ef48078a0000ULL,
    0x595bc1fbd0000ULL,
    0x1ee9a24548000ULL,
    0x614af36b84000ULL,
    0x22ec8b3d52000ULL,
    0x134e2d5faf000ULL,
    0x15e721e306800ULL,
    0xd7c4300efbc00ULL,
    0xeb23a846fa200ULL,
    0x557e1f5abcb00ULL,
    0xa71689a8ce880ULL,
    0xcc9b2c23bfcc0ULL,
    0xdac1a1a1082e0ULL,
    0x1cbef26dc3b30ULL,
    0x213e888800098ULL,
    0x9e6f2f7c0002cULL,
    0xf193a142000baULL,
    0x355ff2e3000f3ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x3000000000000ULL,
    0x5800000000000ULL,
    0x4c00000000000ULL,
    0x8e00000000000ULL,
    0x5d00000000000ULL,
    0x1580000000000ULL,
    0xd640000000000ULL,
    0x2e20000000000ULL,
    0x84f0000000000ULL,
    0x5b08000000000ULL,
    0xc8c000000000ULL,
    0xc9d2000000000ULL,
    0xf6d000000000ULL,
    0x7852800000000ULL,
    0x8320400000000ULL,
    0x697e600000000ULL,
    0xf147100000000ULL,
    0xf4bf780000000ULL,
    0x5c348c0000000ULL,
    0xcfe19a0000000ULL,
    0xff8edf0000000ULL,
    0x715a008000000ULL,
    0x34a103c000000ULL,
    0xfc2083e000000ULL,
    0xfffd41f000000ULL,
    0xa784e35800000ULL,
    0x3d5b504400000ULL,
    0xbabb1a6e00000ULL,
    0xa1229e2d00000ULL,
    0xea7662ee80000ULL,
    0x71cb124ac0000ULL,
    0x136d7b54a0000ULL,
    0x3e598ee1f0000ULL,
    0xfa33192b68000ULL,
    0xe6ee9e3f84000ULL,
    0xb804607e02000ULL,
    0x1c16108535000ULL,
    0x4617fbf2b3800ULL,
    0x7905cf609d400ULL,
    0x8f977b9784600ULL,
    0x49488fe20e700ULL,
    0xe8bb9b6f5b880ULL,
    0x1a2fdf51d94c0ULL,
    0xb6fa80d3266a0ULL,
    0x701c40abcb730ULL,
    0x380463d8000d8ULL,
    0xdc1613840008cULL,
    0xe617f98e0002eULL,
    0x4905cfdd0006dULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x9000000000000ULL,
    0x9800000000000ULL,
    0x8400000000000ULL,
    0xe600000000000ULL,
    0x1300000000000ULL,
    0x7880000000000ULL,
    0xafc0000000000ULL,
    0x1ee0000000000ULL,
    0xccb0000000000ULL,
    0xde08000000000ULL,
    0x2704000000000ULL,
    0x768e000000000ULL,
    0x30c1000000000ULL,
    0x9c63800000000ULL,
    0x127c400000000ULL,
    0x4d76a00000000ULL,
    0x2ff9700000000ULL,
    0x613ce80000000ULL,
    0x6a43240000000ULL,
    0xe6afca0000000ULL,
    0x1703170000000ULL,
    0x5e88018000000ULL,
    0x5cc4014000000ULL,
    0xf66e01e000000ULL,
    0xfb71005000000ULL,
    0x44eb81f800000ULL,
    0xdb8425c00000ULL,
    0xbb98a27a00000ULL,
    0x6f4872f300000ULL,
    0x4537699980000ULL,
    0x3c4b658dc0000ULL,
    0x1dbf6903a0000ULL,
    0xe38f64aed0000ULL,
    0xb516b2218000ULL,
    0x333e651f14000ULL,
    0xb75ae84bb6000ULL,
    0xe13627daf5000ULL,
    0xaa4a4b3c54800ULL,
    0x6ba57ea14c00ULL,
    0x8713212b29200ULL,
    0xc68030b5e9500ULL,
    0xd8c7c9ffcc880ULL,
    0x10771464c0cc0ULL,
    0xe86e03f93f2e0ULL,
    0x3c710162cc590ULL,
    0xa26b818000018ULL,
    0xa578414000044ULL,
    0xa3f8a1e000006ULL,
    0x9b38705000083ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0xb000000000000ULL,
    0x2800000000000ULL,
    0x8c00000000000ULL,
    0x2a00000000000ULL,
    0x9b00000000000ULL,
    0xe780000000000ULL,
    0xfb40000000000ULL,
    0x8620000000000ULL,
    0x43f0000000000ULL,
    0xae08000000000ULL,
    0x4d0c000000000ULL,
    0xde82000000000ULL,
    0xbbd3000000000ULL,
    0x98f4800000000ULL,
    0x2984c00000000ULL,
    0xa64e200000000ULL,
    0xc0bb900000000ULL,
    0x5c25980000000ULL,
    0x90e2ac0000000ULL,
    0xd5953a0000000ULL,
    0x442ff0000000ULL,
    0x67a8008000000ULL,
    0xb9bc01c000000ULL,
    0x7caa022000000ULL,
    0x9e2f00f000000ULL,
    0x27fe800800000ULL,
    0xa81bc05c00000ULL,
    0x4c18a33600000ULL,
    0x8a1c518100000ULL,
    0x2b17398680000ULL,
    0xcf91fee2c0000ULL,
    0x775c82a0a0000ULL,
    0xac38c33bf0000ULL,
    0xd8e4234228000ULL,
    0x4994911b7c000ULL,
    0xb65b19b9da000ULL,
    0x58b96c795f000ULL,
    0xf82d9a52ea800ULL,
    0x36eeaec8fd400ULL,
    0x649738f7aee00ULL,
    0x78d1ff6c64f00ULL,
    0x7b7c801e42880ULL,
    0xc4c8c0ad414c0ULL,
    0xb96c22f8d4ea0ULL,
    0x73d8915fcbfb0ULL,
    0xc4f91880000a8ULL,
    0x3b9a6dc00004cULL,
    0x295118200008aULL,
    0xa9266ff00002bULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x3000000000000ULL,
    0xc800000000000ULL,
    0x3c00000000000ULL,
    0xda00000000000ULL,
    0x5300000000000ULL,
    0x2e80000000000ULL,
    0x1140000000000ULL,
    0x94a0000000000ULL,
    0x7e70000000000ULL,
    0xac08000000000ULL,
    0x204000000000ULL,
    0x771a000000000ULL,
    0x309f000000000ULL,
    0x6c5e800000000ULL,
    0xf3cc00000000ULL,
    0xc8a1200000000ULL,
    0x5467b00000000ULL,
    0xd713f80000000ULL,
    0x2092bc0000000ULL,
    0x745e5a0000000ULL,
    0xcb22cf0000000ULL,
    0xe6a0018000000ULL,
    0xe17003c000000ULL,
    0x708800a000000ULL,
    0x4c44003000000ULL,
    0xdf3a004800000ULL,
    0x30af01bc00000ULL,
    0xa07683d200000ULL,
    0x3108c10900000ULL,
    0xa99322e880000ULL,
    0x9ccb1bcc0000ULL,
    0xf4ff78e2a0000ULL,
    0x63457df1d0000ULL,
    0xbb3f96c48000ULL,
    0xa2e2bfca6c000ULL,
    0xe25659ed12000ULL,
    0xaa26cf3e8f000ULL,
    0x773a0033fe800ULL,
    0xfcaf025d6dc00ULL,
    0x527683b6cb600ULL,
    0x6e08c0afd4300ULL,
    0x9513227f36880ULL,
    0x778cb257c1cc0ULL,
    0x94df7bcb796e0ULL,
    0x5f757c598b330ULL,
    0x1d9bf80000048ULL,
    0xcfd6bc00000fcULL,
    0xade45a000003aULL,
    0xe6cdcf0000063ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x7000000000000ULL,
    0x2800000000000ULL,
    0x5400000000000ULL,
    0xba00000000000ULL,
    0x8500000000000ULL,
    0x4380000000000ULL,
    0x29c0000000000ULL,
    0x70e0000000000ULL,
    0x81b0000000000ULL,
    0x4c08000000000ULL,
    0xa60c000000000ULL,
    0xbb1a000000000ULL,
    0x248b000000000ULL,
    0x934f800000000ULL,
    0xf4bdc00000000ULL,
    0xe797e00000000ULL,
    0x7bc0d00000000ULL,
    0x1f9480000000ULL,
    0x835240000000ULL,
    0xc8d32a0000000ULL,
    0xc17f370000000ULL,
    0xa960008000000ULL,
    0x9d7002c000000ULL,
    0xf768022000000ULL,
    0x2a7c009000000ULL,
    0x15f2024800000ULL,
    0xd237034400000ULL,
    0x9ddd83e600000ULL,
    0xdafac2b300000ULL,
    0xfca260cd80000ULL,
    0x38612a1c0000ULL,
    0x49c928f3a0000ULL,
    0xa0f4349ef0000ULL,
    0xd9af81dc48000ULL,
    0x300dc10a1c000ULL,
    0x481fe22156000ULL,
    0x840cd280db000ULL,
    0xe203497361800ULL,
    0xf90e276df4400ULL,
    0xad94ab71baa00ULL,
    0x16cef4dbd7d00ULL,
    0xb66de2aaa9880ULL,
    0xebfbd142284c0ULL,
    0x153eca654caa0ULL,
    0x5744e7e6fcd70ULL,
    0x76bec800000a8ULL,
    0xce84e40000094ULL,
    0x8e5eca000001aULL,
    0x6b34e700000f5ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x7000000000000ULL,
    0x1800000000000ULL,
    0xec00000000000ULL,
    0xf200000000000ULL,
    0xa100000000000ULL,
    0x8e80000000000ULL,
    0xcbc0000000000ULL,
    0xdd20000000000ULL,
    0xe790000000000ULL,
    0x2a08000000000ULL,
    0xed04000000000ULL,
    0xec8e000000000ULL,
    0x2c7000000000ULL,
    0xa7a1800000000ULL,
    0x325ec00000000ULL,
    0xa427200000000ULL,
    0x251e100000000ULL,
    0x83cee80000000ULL,
    0xf92fbc0000000ULL,
    0x7192520000000ULL,
    0xfd0fb90000000ULL,
    0xc488008000000ULL,
    0x16c4004000000ULL,
    0xc9ae00e000000ULL,
    0x7957007000000ULL,
    0x67a9801800000ULL,
    0x925ac0ec00000ULL,
    0x342920f200000ULL,
    0x4d1910a100000ULL,
    0x77cf688e80000ULL,
    0xe7217ccbc0000ULL,
    0x229d72dd20000ULL,
    0xd285a9e790000ULL,
    0x81c0e8aa08000ULL,
    0x28bcad04000ULL,
    0xf313d20c8e000ULL,
    0xb4c17972c7000ULL,
    0xa0a7203fa1800ULL,
    0x93de109e5ec00ULL,
    0xda6ee8b627200ULL,
    0xe87fbcf41e100ULL,
    0xe23a52154ee80ULL,
    0x715bb9deefbc0ULL,
    0xa3ae00deb2520ULL,
    0x745700fb9fb90ULL,
    0xfb29808000008ULL,
    0x889ac04000004ULL,
    0x7f8920e00000eULL,
    0x8d49107000007ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x1000000000000ULL,
    0x1800000000000ULL,
    0xbc00000000000ULL,
    0xce00000000000ULL,
    0xab00000000000ULL,
    0xbe80000000000ULL,
    0x9840000000000ULL,
    0x1720000000000ULL,
    0x1750000000000ULL,
    0xe208000000000ULL,
    0xbd0c000000000ULL,
    0x8982000000000ULL,
    0xf8c1000000000ULL,
    0x3c61800000000ULL,
    0x2fbc00000000ULL,
    0xa314e00000000ULL,
    0xe32eb00000000ULL,
    0x9d55e80000000ULL,
    0xb02840000000ULL,
    0x6e8df20000000ULL,
    0xa049350000000ULL,
    0xbb28008000000ULL,
    0xc15c00c000000ULL,
    0xf50a002000000ULL,
    0xcd8d001000000ULL,
    0xbac3801800000ULL,
    0x516ac0bc00000ULL,
    0xb37d60ce00000ULL,
    0xf7d970ab00000ULL,
    0x94308be80000ULL,
    0x88ad349840000ULL,
    0xd8999a1720000ULL,
    0xbee0711750000ULL,
    0x94b9126208000ULL,
    0x3f37857d0c000ULL,
    0x5af5e82982000ULL,
    0xff128428c1000ULL,
    0x1d25f20461800ULL,
    0x3e5535aefbc00ULL,
    0x118200f514e00ULL,
    0x84c100342eb00ULL,
    0xd26180cdd5e80ULL,
    0xb9fbc02842840ULL,
    0x594e0df2df20ULL,
    0xc76eb09359350ULL,
    0x4475e88000008ULL,
    0xb75284c00000cULL,
    0x3205f22000002ULL,
    0x8505351000001ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0xf000000000000ULL,
    0xb800000000000ULL,
    0x8400000000000ULL,
    0xd600000000000ULL,
    0x8300000000000ULL,
    0xdc80000000000ULL,
    0x6f40000000000ULL,
    0x5620000000000ULL,
    0x80b0000000000ULL,
    0x5a08000000000ULL,
    0xc90c000000000ULL,
    0x9d86000000000ULL,
    0xaecf000000000ULL,
    0x5aeb800000000ULL,
    0x3758400000000ULL,
    0xb6d5600000000ULL,
    0x1a1c300000000ULL,
    0x3dffc80000000ULL,
    0x992bf40000000ULL,
    0x763be20000000ULL,
    0x844acb0000000ULL,
    0xe6a8008000000ULL,
    0x95fc00c000000ULL,
    0x952e006000000ULL,
    0xfc3300f000000ULL,
    0xa54580b800000ULL,
    0xd72b408400000ULL,
    0x2130e0d600000ULL,
    0xa6c7708300000ULL,
    0xc6e728dc80000ULL,
    0xf550846f40000ULL,
    0xabd2ca5620000ULL,
    0x79994f80b0000ULL,
    0xdc374ada08000ULL,
    0xf5420f090c000ULL,
    0xff2faa7d86000ULL,
    0xed397f9ecf000ULL,
    0x4cc68202eb800ULL,
    0x17eafb8358400ULL,
    0x7cd9c838d5600ULL,
    0x9b14f42d1c300ULL,
    0x9c7862ef7fc80ULL,
    0x65ee8b016bf40ULL,
    0x79d360129be20ULL,
    0xec9330acbacb0ULL,
    0xe3b4488000008ULL,
    0xb683b4c00000cULL,
    0x7e46826000006ULL,
    0xbfaafbf00000fULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0xb000000000000ULL,
    0x3800000000000ULL,
    0xd400000000000ULL,
    0xca00000000000ULL,
    0xa700000000000ULL,
    0xd980000000000ULL,
    0xc8c0000000000ULL,
    0x9ce0000000000ULL,
    0xec50000000000ULL,
    0x7608000000000ULL,
    0xf10c000000000ULL,
    0x3886000000000ULL,
    0x184b000000000ULL,
    0xd8a3800000000ULL,
    0x12fd400000000ULL,
    0xddf4a00000000ULL,
    0x987e700000000ULL,
    0x16bf980000000ULL,
    0x83558c0000000ULL,
    0xe3834e0000000ULL,
    0xf7c1050000000ULL,
    0x4168008000000ULL,
    0x669c00c000000ULL,
    0xa1ee006000000ULL,
    0xdad700b000000ULL,
    0xeb4d803800000ULL,
    0xb2a40d400000ULL,
    0x1d3920ca00000ULL,
    0x289430a700000ULL,
    0x84e6b8d980000ULL,
    0x2851bcc8c0000ULL,
    0x540df69ce0000ULL,
    0xa0cb9ec50000ULL,
    0xc70bf6f608000ULL,
    0x6987b9310c000ULL,
    0xf0c876d886000ULL,
    0x48eaf9684b000ULL,
    0x2654d600a3800ULL,
    0xd10889b6fd400ULL,
    0x28854ecff4a00ULL,
    0xf04a059b7e700ULL,
    0x84ab80dd3f980ULL,
    0x34f14048958c0ULL,
    0x64f2a034e34e0ULL,
    0x2cf5701051050ULL,
    0xa0fc188000008ULL,
    0xef8ccc00000cULL,
    0x5bffee6000006ULL,
    0xf17375b00000bULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0xb000000000000ULL,
    0x7800000000000ULL,
    0xec00000000000ULL,
    0x5200000000000ULL,
    0x1300000000000ULL,
    0x4380000000000ULL,
    0xd0c0000000000ULL,
    0x9de0000000000ULL,
    0x1f90000000000ULL,
    0x5b08000000000ULL,
    0x9784000000000ULL,
    0xceca000000000ULL,
    0x6ceb000000000ULL,
    0x3717800000000ULL,
    0x2446c00000000ULL,
    0x88a1200000000ULL,
    0x5fbb300000000ULL,
    0x6bf7380000000ULL,
    0x2b568c0000000ULL,
    0xe0e11e0000000ULL,
    0x3511d90000000ULL,
    0x5f4a008000000ULL,
    0xef2b004000000ULL,
    0x497780a000000ULL,
    0x5b16c0b000000ULL,
    0x3649207800000ULL,
    0x3baf30ec00000ULL,
    0xac35385200000ULL,
    0xc3398c1300000ULL,
    0x5abc9e4380000ULL,
    0xad7c19d0c0000ULL,
    0x7d1ca01de0000ULL,
    0x8b46f05f90000ULL,
    0xf12998fb08000ULL,
    0xb87f7c2784000ULL,
    0x739506b6ca000ULL,
    0x49036580eb000ULL,
    0x2489a6e517800ULL,
    0x3d45957746c00ULL,
    0xc4203eeb21200ULL,
    0x46fae97f7b300ULL,
    0x69d538ae17380ULL,
    0xc0a98c28c68c0ULL,
    0x8bb49e31e91e0ULL,
    0x75f819ed95d90ULL,
    0xda56a07800008ULL,
    0xc86df0ec00004ULL,
    0x4a5e18520000aULL,
    0x4069bc130000bULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0xb000000000000ULL,
    0xa800000000000ULL,
    0xc400000000000ULL,
    0x2e00000000000ULL,
    0xdb00000000000ULL,
    0x3f80000000000ULL,
    0xf040000000000ULL,
    0x8520000000000ULL,
    0x1810000000000ULL,
    0xdd08000000000ULL,
    0x6084000000000ULL,
    0x1ce000000000ULL,
    0x1e6b000000000ULL,
    0xaba800000000ULL,
    0xf154400000000ULL,
    0x16aee00000000ULL,
    0xa257b00000000ULL,
    0xfd2ef80000000ULL,
    0x841a840000000ULL,
    0x7f08920000000ULL,
    0xe180210000000ULL,
    0x6346008000000ULL,
    0xceaf004000000ULL,
    0x6e5480e000000ULL,
    0x472f40b000000ULL,
    0x691c60a800000ULL,
    0xf787f0c400000ULL,
    0xc44e182e00000ULL,
    0xe32634db00000ULL,
    0xb71cea3f80000ULL,
    0x648ee5f040000ULL,
    0x8fc0720520000ULL,
    0x9568915810000ULL,
    0x2d3478bd08000ULL,
    0x6d1ec49084000ULL,
    0x798e7249ce000ULL,
    0x4f43916a6b000ULL,
    0xc4aef80cba800ULL,
    0x2b5a84ae54400ULL,
    0xba892e72ee00ULL,
    0x62d0213917b00ULL,
    0xacee006f8ef80ULL,
    0x827b00e84a840ULL,
    0x19b280e920920ULL,
    0xfad040f214210ULL,
    0x80e0e02800008ULL,
    0x887cb08400004ULL,
    0x5cb478ce0000eULL,
    0xb65ec46b0000bULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0xf000000000000ULL,
    0x3800000000000ULL,
    0xbc00000000000ULL,
    0xea00000000000ULL,
    0xd900000000000ULL,
    0x1680000000000ULL,
    0xb6c0000000000ULL,
    0xcce0000000000ULL,
    0x2dd0000000000ULL,
    0x3f08000000000ULL,
    0x7d8c000000000ULL,
    0x954a000000000ULL,
    0x4eaf000000000ULL,
    0xaf3800000000ULL,
    0x9eb3c00000000ULL,
    0xea9aa00000000ULL,
    0xd4a3900000000ULL,
    0x2bf8680000000ULL,
    0x9435ec0000000ULL,
    0x465f8e0000000ULL,
    0xf94a3d0000000ULL,
    0xaca2008000000ULL,
    0xf7f300c000000ULL,
    0x2e3180a000000ULL,
    0x5750c0f000000ULL,
    0x6bc3203800000ULL,
    0x4c6f50bc00000ULL,
    0x81948ea00000ULL,
    0xcc69bcd900000ULL,
    0xc817461680000ULL,
    0x6c6341b6c0000ULL,
    0x381e664ce0000ULL,
    0x546311edd0000ULL,
    0x8414ae1f08000ULL,
    0xbe696d4d8c000ULL,
    0x5d11488d4a000ULL,
    0xa8e5bcc2af000ULL,
    0xebdd4678f3800ULL,
    0x640c410bb3c00ULL,
    0xc60de6ae1aa00ULL,
    0x5b00d1c763900ULL,
    0xbb860e3b98680ULL,
    0xce46fde625ec0ULL,
    0xf52320bb378e0ULL,
    0xc4bf5093d63d0ULL,
    0x6b9148b800008ULL,
    0x2e25bc7c0000cULL,
    0xbf3d464a0000aULL,
    0x5dc41290000fULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0xb000000000000ULL,
    0xd800000000000ULL,
    0xe400000000000ULL,
    0xb600000000000ULL,
    0x5700000000000ULL,
    0x2880000000000ULL,
    0x8c0000000000ULL,
    0x9ea0000000000ULL,
    0x3ef0000000000ULL,
    0x888000000000ULL,
    0x18c4000000000ULL,
    0x16ae000000000ULL,
    0xb2fb000000000ULL,
    0x8285800000000ULL,
    0x1dca400000000ULL,
    0xdf25600000000ULL,
    0xc5be700000000ULL,
    0x3c67080000000ULL,
    0xb55acc0000000ULL,
    0x77f48a0000000ULL,
    0xeb019f0000000ULL,
    0x3a85808000000ULL,
    0x9ca404000000ULL,
    0x512560e000000ULL,
    0xc6be70b000000ULL,
    0x7ae708d800000ULL,
    0xe9acce400000ULL,
    0x77d48ab600000ULL,
    0x8a319f5700000ULL,
    0x842d80a880000ULL,
    0x273e4048c0000ULL,
    0xd1a3607ea0000ULL,
    0x5271708ef0000ULL,
    0xe64488d088000ULL,
    0xb96f8cfcc4000ULL,
    0x3cda6aa0ae000ULL,
    0xe0beafe5fb000ULL,
    0xe5ea682a05800ULL,
    0x4a10bc550a400ULL,
    0x451582a185600ULL,
    0xc994534b4e700ULL,
    0x97528a6cef080ULL,
    0xeefe9f099ecc0ULL,
    0x208e00b75a8a0ULL,
    0xc4cb00fefa9f0ULL,
    0xf4ad80a880008ULL,
    0x8bfe4048c0004ULL,
    0x1903607ea000eULL,
    0x8b81708ef000bULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0xb000000000000ULL,
    0x7800000000000ULL,
    0x9400000000000ULL,
    0x6a00000000000ULL,
    0xdb00000000000ULL,
    0x6080000000000ULL,
    0xea40000000000ULL,
    0xed60000000000ULL,
    0xe950000000000ULL,
    0x888000000000ULL,
    0x9644000000000ULL,
    0xbb66000000000ULL,
    0x45b000000000ULL,
    0x350f800000000ULL,
    0x398d400000000ULL,
    0x6dc0a00000000ULL,
    0x51a6b00000000ULL,
    0xb371880000000ULL,
    0x493fe40000000ULL,
    0x4c54760000000ULL,
    0x9909250000000ULL,
    0xa78f808000000ULL,
    0x6ccd404000000ULL,
    0x9220a06000000ULL,
    0xadb6b0b000000ULL,
    0x2419887800000ULL,
    0x936be49400000ULL,
    0x185a766a00000ULL,
    0xd30625db00000ULL,
    0xac8e00e080000ULL,
    0xc44f00aa40000ULL,
    0x9461808d60000ULL,
    0xbed2405950000ULL,
    0x7c49207088000ULL,
    0x2060f00244000ULL,
    0x4d6a8d166000ULL,
    0x6f4014df5b000ULL,
    0xaceb5e558f800ULL,
    0x109f71d3cd400ULL,
    0x332bfe00a0a00ULL,
    0xfe39c1f8f6b00ULL,
    0x92da765bf9880ULL,
    0xa246252f7be40ULL,
    0x416e006f32760ULL,
    0x775f00f952250ULL,
    0x98980e080008ULL,
    0x55c640aa40004ULL,
    0xa5a7208d60006ULL,
    0x697ff0595000bULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x3000000000000ULL,
    0x6800000000000ULL,
    0x2c00000000000ULL,
    0x3600000000000ULL,
    0x1300000000000ULL,
    0x6380000000000ULL,
    0x6240000000000ULL,
    0x78a0000000000ULL,
    0x8930000000000ULL,
    0xf88000000000ULL,
    0x344c000000000ULL,
    0xfbaa000000000ULL,
    0xb2b3000000000ULL,
    0x29ce800000000ULL,
    0x56eec00000000ULL,
    0x5799600000000ULL,
    0xcdba300000000ULL,
    0x1c44b80000000ULL,
    0xb7a2e40000000ULL,
    0x14bdea0000000ULL,
    0x62c4230000000ULL,
    0x716e808000000ULL,
    0x2fdec0c000000ULL,
    0x901160a000000ULL,
    0xe5f6303000000ULL,
    0xb9eeb86800000ULL,
    0x3a11e42c00000ULL,
    0x68f36a3600000ULL,
    0x456ae31300000ULL,
    0x3dd7e0e380000ULL,
    0x914f0a240000ULL,
    0xfb7dd8d8a0000ULL,
    0xef28d4b930000ULL,
    0x5971526788000ULL,
    0xde2ac7184c000ULL,
    0xcbf96a4daa000ULL,
    0x8ee9e361b3000ULL,
    0xd391606a4e800ULL,
    0x77b630c4aec00ULL,
    0x94eb8e739600ULL,
    0xaf21e4588a300ULL,
    0x397b6a4dccb80ULL,
    0x4e26e3bceee40ULL,
    0x93fde03a97ea0ULL,
    0xcae7f06137230ULL,
    0xc99358e380008ULL,
    0x52b614a24000cULL,
    0x79c032d8a000aULL,
    0xaeecf7b930003ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x3000000000000ULL,
    0x2800000000000ULL,
    0x400000000000ULL,
    0x4a00000000000ULL,
    0xad00000000000ULL,
    0xce80000000000ULL,
    0xffc0000000000ULL,
    0x4520000000000ULL,
    0x1990000000000ULL,
    0x9288000000000ULL,
    0x79cc000000000ULL,
    0xb622000000000ULL,
    0x2813000000000ULL,
    0x22ca800000000ULL,
    0x43ac400000000ULL,
    0xf256a00000000ULL,
    0x85a1d00000000ULL,
    0xe152680000000ULL,
    0xa425bc0000000ULL,
    0x491ff20000000ULL,
    0xb243c90000000ULL,
    0x436a808000000ULL,
    0xf8fc40c000000ULL,
    0xe37ea02000000ULL,
    0x2e3dd03000000ULL,
    0xe2d8682800000ULL,
    0x456abc0400000ULL,
    0xcbff724a00000ULL,
    0xf2f089ad00000ULL,
    0xae74a04e80000ULL,
    0xf0b2d03fc0000ULL,
    0x518e86520000ULL,
    0x2c49fc2990000ULL,
    0x9c6952ba88000ULL,
    0x8772197dcc000ULL,
    0xb430e87c22000ULL,
    0x77d5fc4513000ULL,
    0x97e352cc4a800ULL,
    0x523d198c6c400ULL,
    0x54d0681f76a00ULL,
    0x9e66bc5831d00ULL,
    0xfe7d7219da680ULL,
    0x8b38940e9bc0ULL,
    0x39162099bdf20ULL,
    0x7a4290a190c90ULL,
    0x5764484e80008ULL,
    0xaaf72c3fc000cULL,
    0x6273ba6520002ULL,
    0xaeb8e52990003ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x7000000000000ULL,
    0x7800000000000ULL,
    0x7400000000000ULL,
    0xf600000000000ULL,
    0x5f00000000000ULL,
    0x7f80000000000ULL,
    0x5d40000000000ULL,
    0xe0e0000000000ULL,
    0xf010000000000ULL,
    0x9988000000000ULL,
    0xea4c000000000ULL,
    0xc362000000000ULL,
    0x2757000000000ULL,
    0xdc6f800000000ULL,
    0xb8db400000000ULL,
    0xd125600000000ULL,
    0x503ef00000000ULL,
    0x2d3a780000000ULL,
    0x4bb1940000000ULL,
    0x6e70ee0000000ULL,
    0xa85cb10000000ULL,
    0x6be7808000000ULL,
    0xc99740c000000ULL,
    0xc3c7602000000ULL,
    0x7129f07000000ULL,
    0xe035f87800000ULL,
    0x753ad47400000ULL,
    0x4fbd8ef600000ULL,
    0xe07e415f00000ULL,
    0x8357f8ff80000ULL,
    0xe26dd49d40000ULL,
    0xcbd20ec0e0000ULL,
    0x5ca5018010000ULL,
    0xdc72986188000ULL,
    0x9953245e4c000ULL,
    0x6f68761562000ULL,
    0x1554950857000ULL,
    0x2d62765bef800ULL,
    0x9c5f95519b400ULL,
    0x7de7f667c5600ULL,
    0xc69fd54f2ef00ULL,
    0xb44f161332780ULL,
    0x206d6538bd940ULL,
    0x82df8e63f2ee0ULL,
    0x2c2941e41bb10ULL,
    0xf6b8787f80008ULL,
    0x28f6945d4000cULL,
    0xfd976ee0e0002ULL,
    0xd5cbf1f010007ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0xd000000000000ULL,
    0xa800000000000ULL,
    0xe400000000000ULL,
    0x6600000000000ULL,
    0x1100000000000ULL,
    0xff80000000000ULL,
    0x30c0000000000ULL,
    0x90a0000000000ULL,
    0x7270000000000ULL,
    0xd188000000000ULL,
    0x75cc000000000ULL,
    0xd12a000000000ULL,
    0xcfbd000000000ULL,
    0x94a2800000000ULL,
    0xa472400000000ULL,
    0x1884600000000ULL,
    0x1640100000000ULL,
    0xcbef780000000ULL,
    0xcc104c0000000ULL,
    0x6e5dea0000000ULL,
    0xabbc770000000ULL,
    0x32aa808000000ULL,
    0x157e40c000000ULL,
    0x370e60a000000ULL,
    0x8e8d10d000000ULL,
    0xbf45f8a800000ULL,
    0xd86e0ce400000ULL,
    0xaed38a6600000ULL,
    0x21f1671100000ULL,
    0xd34f787f80000ULL,
    0x4a604cf0c0000ULL,
    0xd1d5ea30a0000ULL,
    0xfb7077a270000ULL,
    0xd20080f988000ULL,
    0x1f034051cc000ULL,
    0xaa8ce0172a000ULL,
    0x794f500ebd000ULL,
    0x196998c322800ULL,
    0xf9521c70b2400ULL,
    0xf53ef2ee24600ULL,
    0x25e02b7530100ULL,
    0x29121265e7780ULL,
    0xffdf7b491c4c0ULL,
    0xbe738a0fd7ea0ULL,
    0x9381670671770ULL,
    0xa2c778ff80008ULL,
    0xefac4c30c000cULL,
    0xa8ffea90a000aULL,
    0xd0cd77727000dULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0xf000000000000ULL,
    0xe800000000000ULL,
    0x4c00000000000ULL,
    0xe00000000000ULL,
    0x4900000000000ULL,
    0x9380000000000ULL,
    0x81c0000000000ULL,
    0x4960000000000ULL,
    0xdc30000000000ULL,
    0x5188000000000ULL,
    0x86c4000000000ULL,
    0xb3e2000000000ULL,
    0x3e7f000000000ULL,
    0x7126800000000ULL,
    0x5f90c00000000ULL,
    0x305ae00000000ULL,
    0xa037900000000ULL,
    0xd789b80000000ULL,
    0x53c5dc0000000ULL,
    0x3667f60000000ULL,
    0x52bc130000000ULL,
    0xe9ce808000000ULL,
    0x4564c04000000ULL,
    0xf230e02000000ULL,
    0xe88c90f000000ULL,
    0xfd4d38e800000ULL,
    0x7e2a1c4c00000ULL,
    0x791b960e00000ULL,
    0xe41b434900000ULL,
    0x9d9dd81380000ULL,
    0x37568cc1c0000ULL,
    0x5abeae6960000ULL,
    0x35c55f2c30000ULL,
    0x736c4e3988000ULL,
    0xef36cf8ac4000ULL,
    0xd107f61de2000ULL,
    0x778c13c77f000ULL,
    0xe3c680aaa6800ULL,
    0xfe60c02250c00ULL,
    0xeeb2e0bf3ae00ULL,
    0xfc3908907900ULL,
    0x4063b8f381b80ULL,
    0x6fbedc51c1dc0ULL,
    0x2043765165f60ULL,
    0x27a3d37833130ULL,
    0x23dae09380008ULL,
    0x61f79081c0004ULL,
    0xbee9b84960002ULL,
    0x7ff5dcdc3000fULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0xd000000000000ULL,
    0x6800000000000ULL,
    0x8c00000000000ULL,
    0xe600000000000ULL,
    0xbf00000000000ULL,
    0x3d80000000000ULL,
    0x85c0000000000ULL,
    0x59a0000000000ULL,
    0x67d0000000000ULL,
    0x4788000000000ULL,
    0x54c4000000000ULL,
    0x272a000000000ULL,
    0x819d000000000ULL,
    0xc0ee800000000ULL,
    0x3d3cc00000000ULL,
    0xdbbc600000000ULL,
    0x49faf00000000ULL,
    0x6c93580000000ULL,
    0x6b9c0000000ULL,
    0xf07e7a0000000ULL,
    0xb35ccd0000000ULL,
    0x18c6808000000ULL,
    0x2128c04000000ULL,
    0x4e9e60a000000ULL,
    0x4563f0d000000ULL,
    0x5cf7d86800000ULL,
    0xe81a5c8c00000ULL,
    0x77249ae600000ULL,
    0xa99efdbf00000ULL,
    0xece3b8bd80000ULL,
    0xb34acc5c0000ULL,
    0xcb5c2f9a0000ULL,
    0xf87c61b7d0000ULL,
    0xf5142af88000ULL,
    0xe6cda198c4000ULL,
    0xaa2ba2e12a000ULL,
    0x711f91ae9d000ULL,
    0x15a69ab56e800ULL,
    0x61d7fda4fcc00ULL,
    0x888f382c1c600ULL,
    0xd1416c8d2af00ULL,
    0x46e522389b580ULL,
    0xb23351326f9c0ULL,
    0xfe32fabd747a0ULL,
    0xf8390da3d1cd0ULL,
    0x373e603d80008ULL,
    0xb2b3f085c0004ULL,
    0xd37fd859a000aULL,
    0xe0de5c67d000dULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x5000000000000ULL,
    0xb800000000000ULL,
    0x5400000000000ULL,
    0x5e00000000000ULL,
    0xfb00000000000ULL,
    0xbd80000000000ULL,
    0xe640000000000ULL,
    0x8be0000000000ULL,
    0x1290000000000ULL,
    0xa688000000000ULL,
    0xcbcc000000000ULL,
    0xb5a6000000000ULL,
    0x9d75000000000ULL,
    0x5213800000000ULL,
    0xc241400000000ULL,
    0x9defe00000000ULL,
    0x359cb00000000ULL,
    0xf90d580000000ULL,
    0x648ca40000000ULL,
    0x72ce1e0000000ULL,
    0x712e790000000ULL,
    0xdfb5808000000ULL,
    0xcb3440c000000ULL,
    0xf1fc606000000ULL,
    0x5cddf05000000ULL,
    0x6162b8b800000ULL,
    0xe350145400000ULL,
    0x5e23465e00000ULL,
    0xfc32ddfb00000ULL,
    0xb6739e3d80000ULL,
    0x9796392640000ULL,
    0x100fe06be0000ULL,
    0x180cb08290000ULL,
    0x6405587e88000ULL,
    0xb600a4cfcc000ULL,
    0x17081e53a6000ULL,
    0xb78b793275000ULL,
    0x434e003193800ULL,
    0xcd69001f01400ULL,
    0x495d80cb8fe00ULL,
    0xcb2840914cb00ULL,
    0x52b2606c65580ULL,
    0x1b4f0e9d0a40ULL,
    0xf03f383fe01e0ULL,
    0x2c7854dc97790ULL,
    0xea91268580008ULL,
    0x52862d724000cULL,
    0xa5cca635e0006ULL,
    0xa6ae6d7990005ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x9000000000000ULL,
    0xe800000000000ULL,
    0xd400000000000ULL,
    0xf200000000000ULL,
    0xc900000000000ULL,
    0x4380000000000ULL,
    0x3040000000000ULL,
    0x4160000000000ULL,
    0xb7f0000000000ULL,
    0xf688000000000ULL,
    0xf5cc000000000ULL,
    0xba26000000000ULL,
    0x419000000000ULL,
    0xeb6800000000ULL,
    0x5469400000000ULL,
    0x8275200000000ULL,
    0x75cb900000000ULL,
    0x7a2fb80000000ULL,
    0x6416c40000000ULL,
    0x9eb7760000000ULL,
    0xbc624f0000000ULL,
    0x5670808000000ULL,
    0x87c040c000000ULL,
    0xb32ba06000000ULL,
    0x279ed09000000ULL,
    0xaef498e800000ULL,
    0xfd0854d400000ULL,
    0xe1884ef200000ULL,
    0x7144cbc900000ULL,
    0x46e456c380000ULL,
    0x9db0dff040000ULL,
    0xaae9b8a160000ULL,
    0xf3bfc4e7f0000ULL,
    0xb5e9f67e88000ULL,
    0xf3370fb1cc000ULL,
    0x332ba02026000ULL,
    0xe79ed0d919000ULL,
    0xcef498df36800ULL,
    0x6d08543d29400ULL,
    0x9884e6895200ULL,
    0xa544cb267b900ULL,
    0xb4e456bfc7b80ULL,
    0x54b0df2f2ac40ULL,
    0xe969b87199760ULL,
    0xc3ffc42df74f0ULL,
    0xf489f62b80008ULL,
    0x44c70f244000cULL,
    0xc5a3a05360006ULL,
    0x1252d02ef0009ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0x7000000000000ULL,
    0xe800000000000ULL,
    0xb400000000000ULL,
    0xfa00000000000ULL,
    0x900000000000ULL,
    0x3180000000000ULL,
    0xd8c0000000000ULL,
    0x3520000000000ULL,
    0x2590000000000ULL,
    0xda88000000000ULL,
    0xfc44000000000ULL,
    0xb262000000000ULL,
    0x4b77000000000ULL,
    0x1ab6800000000ULL,
    0x5e17400000000ULL,
    0x8341a00000000ULL,
    0x1ce1900000000ULL,
    0x2d38980000000ULL,
    0xf1d74c0000000ULL,
    0xbce5320000000ULL,
    0x1d30290000000ULL,
    0x39dc808000000ULL,
    0x78e4404000000ULL,
    0xf35202000000ULL,
    0x84d1d07000000ULL,
    0xb367b8e800000ULL,
    0xdef59cb400000ULL,
    0x80760afa00000ULL,
    0x4e35f50900000ULL,
    0x3155aab180000ULL,
    0x59a36598c0000ULL,
    0x26dbb29520000ULL,
    0x8663691590000ULL,
    0xf17f209288000ULL,
    0x33b2d07844000ULL,
    0x1f9b388062000ULL,
    0xb381dc8677000ULL,
    0x9dcb2a3936800ULL,
    0xf2a0253bd7400ULL,
    0x225012fde1a00ULL,
    0x7121f9a8b1900ULL,
    0x779b385310980ULL,
    0x4781dcc0c34c0ULL,
    0x47cb2a292f320ULL,
    0x8ba0254b93290ULL,
    0xfbd012d980008ULL,
    0x1de1f96cc0004ULL,
    0xb8bb384f20002ULL,
    0x6b11dc6c90007ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x9000000000000ULL,
    0x6800000000000ULL,
    0x3c00000000000ULL,
    0x8600000000000ULL,
    0xb500000000000ULL,
    0x3680000000000ULL,
    0x4940000000000ULL,
    0xa320000000000ULL,
    0xc070000000000ULL,
    0x9d88000000000ULL,
    0xeecc000000000ULL,
    0xbee2000000000ULL,
    0xdd19000000000ULL,
    0xaf5e800000000ULL,
    0xc3f7c00000000ULL,
    0x224e600000000ULL,
    0x24ac500000000ULL,
    0x4dbee80000000ULL,
    0xe8e0d40000000ULL,
    0xe01b120000000ULL,
    0x15d6f70000000ULL,
    0xf4b4808000000ULL,
    0x6062c0c000000ULL,
    0x6852e02000000ULL,
    0xaa72909000000ULL,
    0x2686086800000ULL,
    0xe147443c00000ULL,
    0xbf219a8600000ULL,
    0xd67f73b500000ULL,
    0x4085fab680000ULL,
    0xe446238940000ULL,
    0x71a7920320000ULL,
    0xcb38379070000ULL,
    0x59a4605588000ULL,
    0x17395082cc000ULL,
    0x6fa26870e2000ULL,
    0x5a3e14c419000ULL,
    0xd23f277de800ULL,
    0xa9716703b7c00ULL,
    0x9d0e08b1ee600ULL,
    0xea8b44d89c500ULL,
    0x7f439a6596e80ULL,
    0xee26731f1cd40ULL,
    0xa2fb7a8851120ULL,
    0x6ec1e31a73f70ULL,
    0x7ee1f25e80008ULL,
    0xfd1867754000cULL,
    0x3f5888a520002ULL,
    0xabf084b570009ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x9000000000000ULL,
    0x2800000000000ULL,
    0x8c00000000000ULL,
    0x1e00000000000ULL,
    0xd100000000000ULL,
    0x9880000000000ULL,
    0x15c0000000000ULL,
    0x5fe0000000000ULL,
    0xaeb0000000000ULL,
    0x65c8000000000ULL,
    0x27ec000000000ULL,
    0x6ab6000000000ULL,
    0x67c1000000000ULL,
    0xc0ee800000000ULL,
    0xaf3ec00000000ULL,
    0xf480e00000000ULL,
    0x5bc3900000000ULL,
    0xc6e7480000000ULL,
    0x2a39bc0000000ULL,
    0x46026e0000000ULL,
    0x2507a30000000ULL,
    0x4280e08000000ULL,
    0xc6c390c000000ULL,
    0x2067486000000ULL,
    0x7ef9bc9000000ULL,
    0xa9626e2800000ULL,
    0x1277a38c00000ULL,
    0x66a8e09e00000ULL,
    0x9e9f901100000ULL,
    0xb79948f880000ULL,
    0x2b14bc85c0000ULL,
    0x5cdaee77e0000ULL,
    0x74386322b0000ULL,
    0x370e80fbc8000ULL,
    0x4d8ec036ec000ULL,
    0xef48e09236000ULL,
    0x3d2f90e201000ULL,
    0x1cd148b70e800ULL,
    0xd438bc8d8ec00ULL,
    0xc70cee8f48e00ULL,
    0xf58963ad2f900ULL,
    0x4b4800b4d1480ULL,
    0xaf2c009838bc0ULL,
    0xd3d600b90cee0ULL,
    0x9db100b489630ULL,
    0x4a4680fbc8008ULL,
    0xbfa2c036ec00cULL,
    0xba1ee09236006ULL,
    0x645e90e201009ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0xb000000000000ULL,
    0xd800000000000ULL,
    0xe400000000000ULL,
    0xe200000000000ULL,
    0x7b00000000000ULL,
    0x5980000000000ULL,
    0xa0c0000000000ULL,
    0x12a0000000000ULL,
    0x20b0000000000ULL,
    0xbcc8000000000ULL,
    0x4ac000000000ULL,
    0xb1b6000000000ULL,
    0x1243000000000ULL,
    0x23e1800000000ULL,
    0x7ed8400000000ULL,
    0xe0dd200000000ULL,
    0x3dde300000000ULL,
    0x2d59d80000000ULL,
    0xc71d2c0000000ULL,
    0x10f21a0000000ULL,
    0x842d530000000ULL,
    0x93fd208000000ULL,
    0x29ae30c000000ULL,
    0xd931d86000000ULL,
    0xcc012cb000000ULL,
    0x7e0c1ad800000ULL,
    0xad0253e400000ULL,
    0xa88aa06200000ULL,
    0xbe4570bb00000ULL,
    0xede5783980000ULL,
    0xbdb5c10c0000ULL,
    0xac56e2caa0000ULL,
    0x619e4fc4b0000ULL,
    0xbbbee2dec8000ULL,
    0x95424fbfac000ULL,
    0x1c60e20836000ULL,
    0xf71d4fc283000ULL,
    0x8ff620941800ULL,
    0x2a0fca68400ULL,
    0xc1f5c28615200ULL,
    0x8aaf7fd672300ULL,
    0x64b0ba1f6fd80ULL,
    0x8ec4239a9e2c0ULL,
    0x17ae58a2339a0ULL,
    0xd4366c9585130ULL,
    0xb486badec8008ULL,
    0xa84723bfac00cULL,
    0x7cefd80836006ULL,
    0xa55e2cc28300bULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0xf000000000000ULL,
    0x5800000000000ULL,
    0x4400000000000ULL,
    0x8600000000000ULL,
    0xdf00000000000ULL,
    0x1f80000000000ULL,
    0xa440000000000ULL,
    0x29e0000000000ULL,
    0xced0000000000ULL,
    0xa848000000000ULL,
    0x3e4000000000ULL,
    0xebd6000000000ULL,
    0x5ac7000000000ULL,
    0xb921800000000ULL,
    0xe2f2400000000ULL,
    0x803f600000000ULL,
    0x8d14700000000ULL,
    0xb1efb80000000ULL,
    0xaadf240000000ULL,
    0xbe4bee0000000ULL,
    0x74e7d50000000ULL,
    0xe85f608000000ULL,
    0x3c84704000000ULL,
    0xc9c7b86000000ULL,
    0xecab24f000000ULL,
    0x93b5ee5800000ULL,
    0x354d54400000ULL,
    0xbd00e00600000ULL,
    0x9685309f00000ULL,
    0xacc7587f80000ULL,
    0x7e2e145440000ULL,
    0xd972b671e0000ULL,
    0x527ac18ad0000ULL,
    0x23f256ae48000ULL,
    0x24bff19ce4000ULL,
    0x20d50e1456000ULL,
    0x4b41e54e87000ULL,
    0x4e6fb828c1800ULL,
    0xbe9f24d822400ULL,
    0xafabee9677600ULL,
    0xe37d5e5f0700ULL,
    0x9e17601bb9b80ULL,
    0xa460708f58240ULL,
    0xbb91b8d70a6e0ULL,
    0xcd2c24d385950ULL,
    0x1cf46eae48008ULL,
    0x8b36959ce4004ULL,
    0xbc97801456006ULL,
    0xd6a5404e8700fULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0x9000000000000ULL,
    0xc800000000000ULL,
    0x7400000000000ULL,
    0xda00000000000ULL,
    0x9f00000000000ULL,
    0x1380000000000ULL,
    0x8040000000000ULL,
    0x4760000000000ULL,
    0x6e10000000000ULL,
    0xce48000000000ULL,
    0xf264000000000ULL,
    0x9a92000000000ULL,
    0x7181000000000ULL,
    0x5348800000000ULL,
    0x82e5400000000ULL,
    0x8754a00000000ULL,
    0x63ad700000000ULL,
    0x3eb2780000000ULL,
    0xc57fa40000000ULL,
    0xa658860000000ULL,
    0xbd25590000000ULL,
    0x667ca08000000ULL,
    0x5bd9704000000ULL,
    0x5868782000000ULL,
    0x3d9aa49000000ULL,
    0x6e0206c800000ULL,
    0x2501197400000ULL,
    0x3c80805a00000ULL,
    0xcbc140df00000ULL,
    0x7b26a03380000ULL,
    0x877c701040000ULL,
    0xe552f88f60000ULL,
    0xb0aee41a10000ULL,
    0xfb36261448000ULL,
    0x2c3d296d64000ULL,
    0xbbc580912000ULL,
    0x71f694b1c1000ULL,
    0x3996de3428800ULL,
    0x8c02cd7cf5400ULL,
    0xb60afe011ca00ULL,
    0xd90afda5c9700ULL,
    0xb28c26de20780ULL,
    0x1ec829fbfea40ULL,
    0x3faed88e90060ULL,
    0x60b6d41b80190ULL,
    0xf878fe9448008ULL,
    0x6dbfd2d64004ULL,
    0x48eca62912002ULL,
    0x90596921c1009ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x1000000000000ULL,
    0x2800000000000ULL,
    0xfc00000000000ULL,
    0x9600000000000ULL,
    0x1300000000000ULL,
    0xe380000000000ULL,
    0x9640000000000ULL,
    0xf60000000000ULL,
    0x2b30000000000ULL,
    0x1448000000000ULL,
    0x5664000000000ULL,
    0x3db6000000000ULL,
    0x4a89000000000ULL,
    0xf8c6800000000ULL,
    0xe5a9c00000000ULL,
    0xff98600000000ULL,
    0x615bb00000000ULL,
    0xeffdf80000000ULL,
    0x47ea040000000ULL,
    0xcaf2c60000000ULL,
    0x87610b0000000ULL,
    0xe730608000000ULL,
    0xda4fb04000000ULL,
    0x8163f86000000ULL,
    0x9c37041000000ULL,
    0xa5ca462800000ULL,
    0x9125cbfc00000ULL,
    0xa858801600000ULL,
    0x9174c05300000ULL,
    0x8520e08380000ULL,
    0xe25f708640000ULL,
    0x6475182760000ULL,
    0x4da174d730000ULL,
    0x4399de8248000ULL,
    0x975d7f4564000ULL,
    0xecf13e5e36000ULL,
    0x8c660f9cc9000ULL,
    0xa0b22617a6800ULL,
    0x1e0e7b9e99c00ULL,
    0xdf0d7823d0600ULL,
    0x2d8ac49b3fb00ULL,
    0x414c260c4bf80ULL,
    0xaee37bf263040ULL,
    0xc47df8efb4460ULL,
    0x7daa045b88cb0ULL,
    0x1b92c60248008ULL,
    0x53510b0564004ULL,
    0xaef8603e36006ULL,
    0xf56bb08cc9001ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0x3000000000000ULL,
    0xa800000000000ULL,
    0x1400000000000ULL,
    0x5a00000000000ULL,
    0xa900000000000ULL,
    0xbc80000000000ULL,
    0x8040000000000ULL,
    0xf3e0000000000ULL,
    0xa050000000000ULL,
    0xb648000000000ULL,
    0xece4000000000ULL,
    0x43d2000000000ULL,
    0xf58b000000000ULL,
    0x6cce800000000ULL,
    0xcba3400000000ULL,
    0xdfb6a00000000ULL,
    0xf018100000000ULL,
    0xbda6880000000ULL,
    0xe0bba40000000ULL,
    0x239cae0000000ULL,
    0x56644d0000000ULL,
    0x749ea08000000ULL,
    0xf1ec104000000ULL,
    0xd55c882000000ULL,
    0x54c4a43000000ULL,
    0x7a82ea800000ULL,
    0x19b80d1400000ULL,
    0x271c80da00000ULL,
    0x5a2840e900000ULL,
    0x6178209c80000ULL,
    0xb6bb50b040000ULL,
    0x2c90285be0000ULL,
    0x2de3b4b450000ULL,
    0x8b5a26ec48000ULL,
    0x3fcfe945e4000ULL,
    0xae2a0e7f52000ULL,
    0x6b7c5d35cb000ULL,
    0xa7b8283f2e800ULL,
    0x1c17b41bf3400ULL,
    0x4ba026e1fea00ULL,
    0x9fb0e938fc100ULL,
    0xd01e8e8c74880ULL,
    0x8da01de830a40ULL,
    0x48ba0809d22e0ULL,
    0x3793e4c4870d0ULL,
    0xc648e6c48008ULL,
    0xdd9f1d05e4004ULL,
    0x4d6e885f52002ULL,
    0x551fa405cb003ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0xb000000000000ULL,
    0x1800000000000ULL,
    0x8400000000000ULL,
    0xee00000000000ULL,
    0x4500000000000ULL,
    0x7e80000000000ULL,
    0xe2c0000000000ULL,
    0x64a0000000000ULL,
    0x5a90000000000ULL,
    0xbc8000000000ULL,
    0x2824000000000ULL,
    0xf756000000000ULL,
    0xae3000000000ULL,
    0xb3f5800000000ULL,
    0x8076400000000ULL,
    0x1039e00000000ULL,
    0x345fd00000000ULL,
    0x8d6ea80000000ULL,
    0x95b84c0000000ULL,
    0x51eda0000000ULL,
    0x8982610000000ULL,
    0x934fe08000000ULL,
    0x83ecd04000000ULL,
    0x4f73286000000ULL,
    0x35ba0cb000000ULL,
    0x95193a1800000ULL,
    0x418ab18400000ULL,
    0xbf4ac86e00000ULL,
    0xf1e5dc0500000ULL,
    0x6077921e80000ULL,
    0xe032fd52c0000ULL,
    0x4c5412fca0000ULL,
    0xb967bd9e90000ULL,
    0x63b87205c8000ULL,
    0xc41e2d9d24000ULL,
    0x19073a71d6000ULL,
    0x348db19c23000ULL,
    0x99c948c155800ULL,
    0xf7209cebe6400ULL,
    0x5ad3f2f371e00ULL,
    0xe7af6d8fbbd00ULL,
    0xbd1d5a1618a80ULL,
    0x9d8721a60b4c0ULL,
    0xb54b80a9035a0ULL,
    0xeae1402c80210ULL,
    0x43f2601dc8008ULL,
    0xf87e901924004ULL,
    0x243cc81fd6006ULL,
    0xc256dc992300bULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0xd000000000000ULL,
    0xf800000000000ULL,
    0x3c00000000000ULL,
    0x2200000000000ULL,
    0x700000000000ULL,
    0xf980000000000ULL,
    0xf40000000000ULL,
    0x55e0000000000ULL,
    0x74b0000000000ULL,
    0xaa48000000000ULL,
    0xeb64000000000ULL,
    0x227a000000000ULL,
    0x20e5000000000ULL,
    0x323b800000000ULL,
    0xc081c00000000ULL,
    0x43cb200000000ULL,
    0xfc25f00000000ULL,
    0x3b91580000000ULL,
    0x5e55540000000ULL,
    0x5b7aee0000000ULL,
    0xcc6cf30000000ULL,
    0x4bf9208000000ULL,
    0x77a4f04000000ULL,
    0x8bd0d8a000000ULL,
    0x6e3194d000000ULL,
    0xd28a4ef800000ULL,
    0xccc8c33c00000ULL,
    0x11a358a200000ULL,
    0xd2d4544700000ULL,
    0x12bb6e5980000ULL,
    0xf34833df40000ULL,
    0x97e9802de0000ULL,
    0x3b0c008b0000ULL,
    0x7bc2a02848000ULL,
    0x2025303c64000ULL,
    0x699bf823fa000ULL,
    0x71546413a5000ULL,
    0x66fb1645db800ULL,
    0xdd2d97b331c00ULL,
    0x3b11b69003200ULL,
    0xfd9ca75801f00ULL,
    0xd7584e6c0b580ULL,
    0xdff9c39a00540ULL,
    0xd1aad81b096e0ULL,
    0x32d4944b89330ULL,
    0x62b1ce5048008ULL,
    0xdb49034064004ULL,
    0x53e87821fa00aULL,
    0x1db1a484a500dULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0xb000000000000ULL,
    0x8800000000000ULL,
    0x8400000000000ULL,
    0x9200000000000ULL,
    0x4d00000000000ULL,
    0x9580000000000ULL,
    0x3cc0000000000ULL,
    0x5020000000000ULL,
    0x9290000000000ULL,
    0x13c8000000000ULL,
    0x20ac000000000ULL,
    0xefde000000000ULL,
    0xd523000000000ULL,
    0xa314800000000ULL,
    0xed0e400000000ULL,
    0x58e200000000ULL,
    0xe4c2500000000ULL,
    0xec2a180000000ULL,
    0xc926c0000000ULL,
    0x48c1920000000ULL,
    0x6a25510000000ULL,
    0xb98208000000ULL,
    0x2c4d50c000000ULL,
    0x5d6098e000000ULL,
    0x3c7f2cb000000ULL,
    0xa47b328800000ULL,
    0x3879418400000ULL,
    0xf674181200000ULL,
    0x95716c8d00000ULL,
    0xd3f5127580000ULL,
    0x21bb118cc0000ULL,
    0x7de005820000ULL,
    0x212300d690000ULL,
    0x59148061c8000ULL,
    0x940e40ddac000ULL,
    0x8a0e20f25e000ULL,
    0x1102506de3000ULL,
    0xbb8a186134800ULL,
    0xefc26c329e400ULL,
    0x9ea99283c6200ULL,
    0xe4d951f8ae500ULL,
    0xa7ae20d3d4180ULL,
    0x4b52508b216c0ULL,
    0x26218181d120ULL,
    0x24fe6c1787110ULL,
    0xed3f9269c8008ULL,
    0xe4965199ac00cULL,
    0xbcc4a0005e00eULL,
    0x902f1050e300bULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0xb000000000000ULL,
    0x4800000000000ULL,
    0x8c00000000000ULL,
    0x3e00000000000ULL,
    0xeb00000000000ULL,
    0xb380000000000ULL,
    0xa1c0000000000ULL,
    0x2f60000000000ULL,
    0x4890000000000ULL,
    0x8248000000000ULL,
    0xd6a4000000000ULL,
    0xf3fe000000000ULL,
    0x80d3000000000ULL,
    0x45e8800000000ULL,
    0xcfd2c00000000ULL,
    0xb46ee00000000ULL,
    0x1315300000000ULL,
    0xff81780000000ULL,
    0x3fce3c0000000ULL,
    0x9465260000000ULL,
    0x312c10000000ULL,
    0xe786608000000ULL,
    0x4bc7f04000000ULL,
    0x6e6f98e000000ULL,
    0x5a1b0cb000000ULL,
    0x81045e4800000ULL,
    0xb28cfd8c00000ULL,
    0x534b46be00000ULL,
    0x9c2131ab00000ULL,
    0x64bff8d380000ULL,
    0xaefbfc51c0000ULL,
    0xf455468760000ULL,
    0x39a2317490000ULL,
    0x527f787448000ULL,
    0xa41d3cf1a4000ULL,
    0xca0da69e7e000ULL,
    0x5100017a13000ULL,
    0xa88801108800ULL,
    0x7742c0ea82c00ULL,
    0x9e26e0c746e00ULL,
    0xf9b130d621300ULL,
    0x7a7f7875b7780ULL,
    0xd81d3c44793c0ULL,
    0x5c0da63313a60ULL,
    0x860001ef83010ULL,
    0xcf0880a7c8008ULL,
    0xb182c0a064004ULL,
    0x3cc6e0191e00eULL,
    0xfbe1300e8300bULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0xf000000000000ULL,
    0xf800000000000ULL,
    0x6400000000000ULL,
    0xa00000000000ULL,
    0x4300000000000ULL,
    0x1080000000000ULL,
    0xb40000000000ULL,
    0x36a0000000000ULL,
    0xfe30000000000ULL,
    0xf3c8000000000ULL,
    0x91ec000000000ULL,
    0x3e96000000000ULL,
    0xd0f7000000000ULL,
    0xc3ab800000000ULL,
    0x93bc400000000ULL,
    0xc901a00000000ULL,
    0x9388b00000000ULL,
    0x7bcec80000000ULL,
    0xcde9540000000ULL,
    0x30987a0000000ULL,
    0x69f49b0000000ULL,
    0x682a208000000ULL,
    0xec74f0c000000ULL,
    0xfeef686000000ULL,
    0x1811e4f000000ULL,
    0x66beb2f800000ULL,
    0xa481cf6400000ULL,
    0xa94c5a8a00000ULL,
    0x79ab6b8300000ULL,
    0x88b0c8f080000ULL,
    0x2d82543b40000ULL,
    0x9acdfaaea0000ULL,
    0x9263db6a30000ULL,
    0x4d5e0081c8000ULL,
    0x811b0076ec000ULL,
    0x9d3d804416000ULL,
    0xb34b4068b7000ULL,
    0xf2aa201d8b800ULL,
    0x6434f002cc400ULL,
    0xb8cf680669a00ULL,
    0x1d61e4bf54b00ULL,
    0x5bd6b2a610c80ULL,
    0xaf5dcf87b2540ULL,
    0x6e125a7b05fa0ULL,
    0x7bb06b148fdb0ULL,
    0x650d487148008ULL,
    0x6589144dac00cULL,
    0xa6c7daeab6006ULL,
    0x6c672b028700fULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0xb000000000000ULL,
    0x3800000000000ULL,
    0x4400000000000ULL,
    0x4a00000000000ULL,
    0x5700000000000ULL,
    0xa680000000000ULL,
    0x3f40000000000ULL,
    0xbda0000000000ULL,
    0xb690000000000ULL,
    0x5dc8000000000ULL,
    0x88e4000000000ULL,
    0x3c36000000000ULL,
    0xfdd3000000000ULL,
    0xd26f800000000ULL,
    0x4d76400000000ULL,
    0x3d71a00000000ULL,
    0x2571f00000000ULL,
    0xb177a80000000ULL,
    0x7372140000000ULL,
    0x58788a0000000ULL,
    0xf0f2b10000000ULL,
    0xd2be208000000ULL,
    0x9e97b04000000ULL,
    0xb1ce086000000ULL,
    0x6ee7e4b000000ULL,
    0xed39223800000ULL,
    0x3a53a54400000ULL,
    0x12a92aca00000ULL,
    0x7413411700000ULL,
    0xf881884680000ULL,
    0xea41a4cf40000ULL,
    0x502082e5a0000ULL,
    0x9156554290000ULL,
    0xfa2082afc8000ULL,
    0x365655dbe4000ULL,
    0x4a08230b6000ULL,
    0xfd16556593000ULL,
    0xcb0082114f800ULL,
    0x58865570a6400ULL,
    0x7a48824f19a00ULL,
    0xb82255f805f00ULL,
    0x5d5e82e409a80ULL,
    0xcc2155da05140ULL,
    0x6f59023f010a0ULL,
    0xbf23152a87f10ULL,
    0x33d6a2e948008ULL,
    0xef65e514a4004ULL,
    0x6cf88ad516006ULL,
    0x2cb2b1270300bULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0xf000000000000ULL,
    0x3800000000000ULL,
    0x3c00000000000ULL,
    0xd600000000000ULL,
    0xbd00000000000ULL,
    0x4c80000000000ULL,
    0xc040000000000ULL,
    0xbe20000000000ULL,
    0xd630000000000ULL,
    0xf8c8000000000ULL,
    0xec64000000000ULL,
    0xdf1e000000000ULL,
    0xf977000000000ULL,
    0x1d6f800000000ULL,
    0x3d99c00000000ULL,
    0x5834600000000ULL,
    0xc9cb500000000ULL,
    0xaeee880000000ULL,
    0x6e53a40000000ULL,
    0xe5d9d20000000ULL,
    0x8a1e3b0000000ULL,
    0xe1fbe08000000ULL,
    0x1f22904000000ULL,
    0x1cb2e8e000000ULL,
    0xad8cf4f000000ULL,
    0xeac15a3800000ULL,
    0x1b6e9f3c00000ULL,
    0xe89bb25600000ULL,
    0xb66bfd00000ULL,
    0x2b8ce82c80000ULL,
    0x7fcbf47040000ULL,
    0xa3e6da6620000ULL,
    0xfad35f1a30000ULL,
    0xe991d296c8000ULL,
    0xda3a3b2d64000ULL,
    0xb6c5e0259e000ULL,
    0x7d65903437000ULL,
    0x8d956837cf800ULL,
    0x803134e7e9c00ULL,
    0x5cb3af0dc600ULL,
    0x40e2cf729f500ULL,
    0xef52ba93b8880ULL,
    0x7f580f4600a40ULL,
    0xf75f5ab508520ULL,
    0x13599fe880fb0ULL,
    0x95432ba48008ULL,
    0x5a5fab5d24004ULL,
    0x97d08843be00eULL,
    0xcd14a42e0700fULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0xd000000000000ULL,
    0x2800000000000ULL,
    0xf400000000000ULL,
    0xe200000000000ULL,
    0x2500000000000ULL,
    0x9280000000000ULL,
    0x6240000000000ULL,
    0xe20000000000ULL,
    0x2b0000000000ULL,
    0x1cc8000000000ULL,
    0xe26c000000000ULL,
    0x679a000000000ULL,
    0x47f5000000000ULL,
    0x1566800000000ULL,
    0x4819400000000ULL,
    0x1b31200000000ULL,
    0x9709d00000000ULL,
    0x5f82e80000000ULL,
    0xa4c0440000000ULL,
    0x5e63120000000ULL,
    0x196930000000ULL,
    0x78f7a08000000ULL,
    0x7ee090c000000ULL,
    0xaedbc8a000000ULL,
    0xb05594d000000ULL,
    0x2c13fa2800000ULL,
    0xb13fd7f400000ULL,
    0x3600326200000ULL,
    0xd70643e500000ULL,
    0x3f89c8b280000ULL,
    0xd4cc947240000ULL,
    0xa66f7a8620000ULL,
    0xdd939726b0000ULL,
    0x6ef79256c8000ULL,
    0xb9e6d3f36c000ULL,
    0x195200371a000ULL,
    0x40990010b5000ULL,
    0x407c8001c6800ULL,
    0xbdac400ce9400ULL,
    0x2877a0c3d9200ULL,
    0x29a090a6d5d00ULL,
    0xba7bc85450e80ULL,
    0xf4a5944619440ULL,
    0xf4fbfab03f920ULL,
    0x80e3d76e8ad30ULL,
    0x3dd232e448008ULL,
    0x35df43812c00cULL,
    0xd1d548b13a00aULL,
    0xbbd0d4360500dULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0xf000000000000ULL,
    0xe800000000000ULL,
    0xac00000000000ULL,
    0xd600000000000ULL,
    0x1f00000000000ULL,
    0x5380000000000ULL,
    0x24c0000000000ULL,
    0x25a0000000000ULL,
    0x3fd0000000000ULL,
    0xf148000000000ULL,
    0x4664000000000ULL,
    0x2df2000000000ULL,
    0x6057000000000ULL,
    0xb382800000000ULL,
    0xb4ccc00000000ULL,
    0x1da0600000000ULL,
    0x8bd0700000000ULL,
    0x6349780000000ULL,
    0x2361ec0000000ULL,
    0xb77cca0000000ULL,
    0x810350000000ULL,
    0xe16ae08000000ULL,
    0x8a78b04000000ULL,
    0xf69b182000000ULL,
    0x3269cf000000ULL,
    0xf99732e800000ULL,
    0x28ad19ac00000ULL,
    0x495e4a5600000ULL,
    0x6f0cf55f00000ULL,
    0xfb8280f380000ULL,
    0xa8ccc094c0000ULL,
    0x3a060eda0000ULL,
    0xc8d07063d0000ULL,
    0xec978cf48000ULL,
    0xb4a1ecf564000ULL,
    0x175ccaa872000ULL,
    0xc00355b97000ULL,
    0x6602e045a2800ULL,
    0xd70cb0efdcc00ULL,
    0xf8118e948600ULL,
    0x1ac59c0264700ULL,
    0x96afb257f3780ULL,
    0xba52d9a952ec0ULL,
    0xca8eaa7f0c4a0ULL,
    0x304745838bf50ULL,
    0x36e918bcc8008ULL,
    0xb4b19c21a4004ULL,
    0xca35b265d2002ULL,
    0x6871d9c84700fULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0xd000000000000ULL,
    0x1800000000000ULL,
    0x400000000000ULL,
    0x4600000000000ULL,
    0x5d00000000000ULL,
    0x6180000000000ULL,
    0x2d40000000000ULL,
    0xfd60000000000ULL,
    0x5d30000000000ULL,
    0x96c8000000000ULL,
    0x8f24000000000ULL,
    0xfad2000000000ULL,
    0xa35000000000ULL,
    0xb04d800000000ULL,
    0xfce6400000000ULL,
    0x807b600000000ULL,
    0xa3a1500000000ULL,
    0xce13d80000000ULL,
    0x2e1cf40000000ULL,
    0x9e1f660000000ULL,
    0x76199b0000000ULL,
    0xba1ee08000000ULL,
    0xe013104000000ULL,
    0xff12b82000000ULL,
    0x859ca4d000000ULL,
    0x945b3e1800000ULL,
    0x25f22f0400000ULL,
    0xa8e566c600000ULL,
    0x9e789b1d00000ULL,
    0xdaa960c180000ULL,
    0x399450bd40000ULL,
    0x465e58c560000ULL,
    0x6fab48930000ULL,
    0x406406c8c8000ULL,
    0x8cb8cbd624000ULL,
    0x538d385d52000ULL,
    0xbe4fe43a75000ULL,
    0xfdedde0cad800ULL,
    0x83f53f5c96400ULL,
    0x45edde73d3600ULL,
    0x17f53f35b5500ULL,
    0x3bedde4409d80ULL,
    0x9ef53f660df40ULL,
    0x46dde0d00e60ULL,
    0xeab53f398adb0ULL,
    0xde8dde8948008ULL,
    0xc7c53f2b64004ULL,
    0xd4a5deb832002ULL,
    0x38913f634500dULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x3000000000000ULL,
    0x6800000000000ULL,
    0x8400000000000ULL,
    0x9a00000000000ULL,
    0xc700000000000ULL,
    0x4c80000000000ULL,
    0x3740000000000ULL,
    0xd460000000000ULL,
    0xe570000000000ULL,
    0x64c8000000000ULL,
    0x83ac000000000ULL,
    0x7856000000000ULL,
    0x38db000000000ULL,
    0xe192800000000ULL,
    0x60fa400000000ULL,
    0xba08a00000000ULL,
    0x5703f00000000ULL,
    0x748f080000000ULL,
    0xeb47140000000ULL,
    0xa266560000000ULL,
    0x3c770f0000000ULL,
    0x754c208000000ULL,
    0x3f62b0c000000ULL,
    0xd7f5286000000ULL,
    0x3e8ea43000000ULL,
    0xb449fe6800000ULL,
    0x62efeb8400000ULL,
    0x253b7e1a00000ULL,
    0x9425ab0700000ULL,
    0xd59bdeac80000ULL,
    0x52fa5bc740000ULL,
    0x990ad65c60000ULL,
    0xb18a4f9170000ULL,
    0xecc80076c8000ULL,
    0xf7ac0030ac000ULL,
    0xea5600a6d6000ULL,
    0x4bdb007c9b000ULL,
    0x5f12808b72800ULL,
    0x14ba40f1ca400ULL,
    0xb8e8a0dc20a00ULL,
    0x4233f0c19ff00ULL,
    0x88a708f0f1080ULL,
    0xbadb148200140ULL,
    0x6a98568b0ad60ULL,
    0x62700f028a4f0ULL,
    0x8840a0b248008ULL,
    0xe4eff073ec00cULL,
    0xf43908e0b6006ULL,
    0x31ac14eaeb003ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0xd000000000000ULL,
    0x3800000000000ULL,
    0xc400000000000ULL,
    0xf600000000000ULL,
    0x9b00000000000ULL,
    0xf780000000000ULL,
    0xaa40000000000ULL,
    0x6660000000000ULL,
    0x3290000000000ULL,
    0x42c8000000000ULL,
    0xadac000000000ULL,
    0x15ba000000000ULL,
    0x9b5000000000ULL,
    0x8bb7800000000ULL,
    0xaeb2400000000ULL,
    0xee3c600000000ULL,
    0xb9f9300000000ULL,
    0xdcd3b80000000ULL,
    0x12a9040000000ULL,
    0xa434760000000ULL,
    0x70fa410000000ULL,
    0x3651e08000000ULL,
    0x3c6e70c000000ULL,
    0x639058a000000ULL,
    0xbc4e74d000000ULL,
    0x4d61ae3800000ULL,
    0x8d1f75c400000ULL,
    0xc481ae7600000ULL,
    0xc1cf755b00000ULL,
    0x8e29aed780000ULL,
    0xd1f375ba40000ULL,
    0xe0dbae7e60000ULL,
    0x80aa75e690000ULL,
    0x19362eacc8000ULL,
    0x247d35e2ac000ULL,
    0xaf95ce0c3a000ULL,
    0x64a45ecf5000ULL,
    0xac6816f457800ULL,
    0x3b93717962400ULL,
    0x84a58d314600ULL,
    0x536b74c385300ULL,
    0xea1e2e7441b80ULL,
    0x10135a160040ULL,
    0x687cea711f60ULL,
    0x84c3457d81010ULL,
    0xbead964348008ULL,
    0x6e38319cec00cULL,
    0x79fbb8045a00aULL,
    0x7cd504516500dULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0xf000000000000ULL,
    0xd800000000000ULL,
    0xf400000000000ULL,
    0xea00000000000ULL,
    0xbd00000000000ULL,
    0x5b80000000000ULL,
    0xddc0000000000ULL,
    0x4d20000000000ULL,
    0xfd50000000000ULL,
    0xbf48000000000ULL,
    0x396c000000000ULL,
    0x84ba000000000ULL,
    0x4eb7000000000ULL,
    0xc3b9800000000ULL,
    0xe031400000000ULL,
    0x39ffa00000000ULL,
    0x46d7500000000ULL,
    0xf286780000000ULL,
    0xfc48bc0000000ULL,
    0xa5e6620000000ULL,
    0x37f2dd0000000ULL,
    0x59dc208000000ULL,
    0x680110c000000ULL,
    0x4c0858a000000ULL,
    0x4e02acf000000ULL,
    0x7f05bad800000ULL,
    0xca8a31f400000ULL,
    0x984dba6a00000ULL,
    0xc7e6317d00000ULL,
    0x56f7ba7b80000ULL,
    0xc45131edc0000ULL,
    0x16ce3ab520000ULL,
    0xda0713950000ULL,
    0x88119aad48000ULL,
    0xb2721406c000ULL,
    0x9e5fe2cd3a000ULL,
    0x13c39dea77000ULL,
    0xf22380c719800ULL,
    0x97d640b9a1400ULL,
    0xd70e200217a00ULL,
    0x268a10e62b500ULL,
    0x2643d8edd4780ULL,
    0x60e8ece203bc0ULL,
    0x68799aa10de20ULL,
    0xb61b213d889d0ULL,
    0x6c2de20ec8008ULL,
    0xd89d59ac00cULL,
    0x918000121a00aULL,
    0x50c000ae2700fULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0x7000000000000ULL,
    0xf800000000000ULL,
    0xec00000000000ULL,
    0xfa00000000000ULL,
    0xeb00000000000ULL,
    0xc280000000000ULL,
    0x5c40000000000ULL,
    0x37e0000000000ULL,
    0x40f0000000000ULL,
    0xd7e8000000000ULL,
    0x50f4000000000ULL,
    0x7fea000000000ULL,
    0x34f3000000000ULL,
    0x91e5800000000ULL,
    0xc9fdc00000000ULL,
    0x426a200000000ULL,
    0xbc33700000000ULL,
    0xeb46080000000ULL,
    0x9766b40000000ULL,
    0x4bbd760000000ULL,
    0x508ebb0000000ULL,
    0xb346088000000ULL,
    0x4b66b44000000ULL,
    0x69bd762000000ULL,
    0x278ebb7000000ULL,
    0x73c6087800000ULL,
    0x1026b4ac00000ULL,
    0x66dd76da00000ULL,
    0xd03ebb9b00000ULL,
    0x514e08ba80000ULL,
    0x5c62b4f040000ULL,
    0xf93f76ede0000ULL,
    0xf4c9bbdbf0000ULL,
    0x68a9886d68000ULL,
    0xf19874a0b4000ULL,
    0x555ad6920a000ULL,
    0xb5f40bef03000ULL,
    0x506020fc8d800ULL,
    0x1330706949c00ULL,
    0xb7cb88d060200ULL,
    0xce2f745330700ULL,
    0x43dd5697cb880ULL,
    0x9fbecbbe2f740ULL,
    0x268d803bdd560ULL,
    0xf249c033becb0ULL,
    0xeae020fc8d808ULL,
    0xe370706949c04ULL,
    0x5a2b88d060202ULL,
    0x15df745330707ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x1000000000000ULL,
    0x2800000000000ULL,
    0x9c00000000000ULL,
    0xe600000000000ULL,
    0x5900000000000ULL,
    0x7c80000000000ULL,
    0x5e40000000000ULL,
    0x35e0000000000ULL,
    0xea30000000000ULL,
    0x1e8000000000ULL,
    0x503c000000000ULL,
    0x1ee2000000000ULL,
    0x65bd000000000ULL,
    0x1420800000000ULL,
    0x9214c00000000ULL,
    0x2dfee00000000ULL,
    0x20c9500000000ULL,
    0xad280000000ULL,
    0x3052b40000000ULL,
    0x4e11760000000ULL,
    0xabf1970000000ULL,
    0xc9cd288000000ULL,
    0x4422b4c000000ULL,
    0xda1976a000000ULL,
    0x1fd971000000ULL,
    0xfec728a800000ULL,
    0xeda3b45c00000ULL,
    0x36dbf64600000ULL,
    0xaf54574900000ULL,
    0xbb9948d480000ULL,
    0x13e240240000ULL,
    0x2e683e73e0000ULL,
    0x55ffb3a330000ULL,
    0xf4cd16d568000ULL,
    0xcaa107527c000ULL,
    0xb75660ed02000ULL,
    0xdf9190068d000ULL,
    0xf339c8e148800ULL,
    0x1d6ae41068c00ULL,
    0xbe76dec8fce00ULL,
    0x1306e36a44500ULL,
    0x3b883e0fe5a80ULL,
    0x6fcfb3353a740ULL,
    0x7d2516146d960ULL,
    0x169d078af5c70ULL,
    0x67b460e148808ULL,
    0x7f2c901068c0cULL,
    0x7d9948c8fce0aULL,
    0x883e246a44501ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0x5000000000000ULL,
    0x3800000000000ULL,
    0xbc00000000000ULL,
    0x7600000000000ULL,
    0x9d00000000000ULL,
    0x2680000000000ULL,
    0x6f40000000000ULL,
    0x5760000000000ULL,
    0xd6f0000000000ULL,
    0x3368000000000ULL,
    0x2cf4000000000ULL,
    0x906a000000000ULL,
    0x4371000000000ULL,
    0x2ba9800000000ULL,
    0x2c5ac00000000ULL,
    0x67bee00000000ULL,
    0x1d0b100000000ULL,
    0x6680880000000ULL,
    0x4f43e40000000ULL,
    0x766fe0000000ULL,
    0xeefa0b0000000ULL,
    0x8f60888000000ULL,
    0x5af3e44000000ULL,
    0xd6efe2000000ULL,
    0x65fe0b5000000ULL,
    0x44e288b800000ULL,
    0x7b36e4fc00000ULL,
    0xb14d7e5600000ULL,
    0x2e65cbcd00000ULL,
    0x4a7de89e80000ULL,
    0xdf23349340000ULL,
    0x4411160160000ULL,
    0xc5583f1bf0000ULL,
    0xa3301eade8000ULL,
    0x3d451bbfb4000ULL,
    0x106a00110a000ULL,
    0x371001881000ULL,
    0xba9802641800ULL,
    0x7c5ac083eec00ULL,
    0x5fbee0eeb4e00ULL,
    0xa10b10a98a100ULL,
    0x1080882ec1080ULL,
    0xd243e4bdad240ULL,
    0x21e6fe81521e0ULL,
    0x81ba0b09301b0ULL,
    0xd800882641808ULL,
    0x8c03e483eec04ULL,
    0x3e06feeeb4e02ULL,
    0x490a0ba98a105ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x5000000000000ULL,
    0x5800000000000ULL,
    0x5400000000000ULL,
    0x2600000000000ULL,
    0x4b00000000000ULL,
    0x580000000000ULL,
    0x95c0000000000ULL,
    0xc4e0000000000ULL,
    0x2df0000000000ULL,
    0x12e8000000000ULL,
    0x4ef4000000000ULL,
    0x2b6e000000000ULL,
    0xa131000000000ULL,
    0x8e8b800000000ULL,
    0xb044400000000ULL,
    0x6121e00000000ULL,
    0xe114f00000000ULL,
    0x331fb80000000ULL,
    0x2e14ac0000000ULL,
    0x894760000000ULL,
    0xc4d0330000000ULL,
    0xbff7b88000000ULL,
    0x6fe0ac4000000ULL,
    0x387a766000000ULL,
    0xbf21335000000ULL,
    0x8e1c38d800000ULL,
    0x7894ec1400000ULL,
    0xacd3964600000ULL,
    0xe3f1c31b00000ULL,
    0x45e580dd80000ULL,
    0x1754081c0000ULL,
    0xd7aa6082e0000ULL,
    0x5550b036f0000ULL,
    0x2c3e584f68000ULL,
    0xd0005c8f34000ULL,
    0x180bcec98e000ULL,
    0x34049fc7c1000ULL,
    0x7603ce19e3800ULL,
    0x13009f2b70400ULL,
    0x5185ce6eafe00ULL,
    0xb3c59f7dd5f00ULL,
    0x8fe04e177c380ULL,
    0x2870df94a4ec0ULL,
    0x872a2edcdb960ULL,
    0x8a106f8bf5c30ULL,
    0x69c7699e3808ULL,
    0xb3d4336b70404ULL,
    0xc071b80eafe06ULL,
    0x9b25ac2dd5f05ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x3000000000000ULL,
    0x9800000000000ULL,
    0x3400000000000ULL,
    0x5200000000000ULL,
    0x4500000000000ULL,
    0x6380000000000ULL,
    0x23c0000000000ULL,
    0xdc20000000000ULL,
    0xc8f0000000000ULL,
    0x628000000000ULL,
    0xd1fc000000000ULL,
    0x3ba2000000000ULL,
    0xe13f000000000ULL,
    0xb0b800000000ULL,
    0x188c400000000ULL,
    0xc346a00000000ULL,
    0xbb64100000000ULL,
    0x899a980000000ULL,
    0x66bd2c0000000ULL,
    0xb2cada0000000ULL,
    0xbdace30000000ULL,
    0xa632988000000ULL,
    0x25812cc000000ULL,
    0xc4c8daa000000ULL,
    0xc2a3e33000000ULL,
    0x8cb1181800000ULL,
    0x33c16cf400000ULL,
    0xb4247af200000ULL,
    0xc4f4f37500000ULL,
    0x502a007b80000ULL,
    0x5ef300d7c0000ULL,
    0x2921802e20000ULL,
    0xf37f40bdf0000ULL,
    0xb1e720fda8000ULL,
    0x6fdb50c63c000ULL,
    0x2e5db8b582000ULL,
    0xb0967c6ccf000ULL,
    0xab3f626ea3800ULL,
    0xba069feab0400ULL,
    0x890ffaa4c4a00ULL,
    0x9588b352ab100ULL,
    0x9cc4a0a4b9180ULL,
    0x56ab105fcd6c0ULL,
    0xeeb918722e7a0ULL,
    0xeecd6ce3f7f30ULL,
    0xe3ae7aeea3808ULL,
    0xb537f32ab040cULL,
    0xc9038004c4a0aULL,
    0xf5804062ab103ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x7000000000000ULL,
    0x9800000000000ULL,
    0xac00000000000ULL,
    0x3200000000000ULL,
    0x2900000000000ULL,
    0x1480000000000ULL,
    0x2c0000000000ULL,
    0xcde0000000000ULL,
    0xadf0000000000ULL,
    0xb3e8000000000ULL,
    0xa6fc000000000ULL,
    0xc662000000000ULL,
    0xf4bb000000000ULL,
    0xf4b800000000ULL,
    0x23a1c00000000ULL,
    0x1ed0a00000000ULL,
    0x9f7500000000ULL,
    0xa5efe80000000ULL,
    0x59fe7c0000000ULL,
    0x8debb60000000ULL,
    0xcdfae30000000ULL,
    0x63e7e88000000ULL,
    0x4ef27cc000000ULL,
    0xf261b6a000000ULL,
    0x6abde37000000ULL,
    0x144e681800000ULL,
    0x1e28bc6c00000ULL,
    0x89a969200000ULL,
    0xc6db735900000ULL,
    0xc5f9200c80000ULL,
    0x47ed906ec0000ULL,
    0x98f4c85fe0000ULL,
    0xad68ecf4f0000ULL,
    0x5134fe3f68000ULL,
    0xb503cf083c000ULL,
    0xde8bb6b982000ULL,
    0x57cae3b04b000ULL,
    0x36fe88823800ULL,
    0xb23e7c379dc00ULL,
    0xf48bb62d52a00ULL,
    0x12cae38cbc500ULL,
    0x85efe8334c680ULL,
    0xe9fe7c99a3bc0ULL,
    0xb5ebb6d3d9160ULL,
    0x11fae36b76b30ULL,
    0xc9e7e80823808ULL,
    0xcbf27cf79dc0cULL,
    0xd4e1b68d52a0aULL,
    0x417de3fcbc507ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x9000000000000ULL,
    0x9800000000000ULL,
    0xb400000000000ULL,
    0xde00000000000ULL,
    0x6100000000000ULL,
    0xca80000000000ULL,
    0x63c0000000000ULL,
    0x3920000000000ULL,
    0xc930000000000ULL,
    0x6b28000000000ULL,
    0x923c000000000ULL,
    0xa6aa000000000ULL,
    0x7e75000000000ULL,
    0x70c3800000000ULL,
    0x38ae400000000ULL,
    0xff76600000000ULL,
    0xa4c500000000ULL,
    0x5364c80000000ULL,
    0xea596c0000000ULL,
    0xa973da0000000ULL,
    0x87413f0000000ULL,
    0xd3ecc88000000ULL,
    0xa6956cc000000ULL,
    0xa3d1da2000000ULL,
    0x53383f9000000ULL,
    0x3c2d481800000ULL,
    0xa5b22c7400000ULL,
    0x6dee3afe00000ULL,
    0xb79f2ff100000ULL,
    0x415460d280000ULL,
    0x8cf55017c0000ULL,
    0xf70548c720000ULL,
    0x678e2c3830000ULL,
    0x73443a39a8000ULL,
    0xedea2f45fc000ULL,
    0x7797e0c18a000ULL,
    0x615b101645000ULL,
    0x1cf328f16b800ULL,
    0x6f027c5952400ULL,
    0xd380f2f8fc600ULL,
    0xad43430909500ULL,
    0x8cec3a168f480ULL,
    0xbd162fe1cb2c0ULL,
    0x29de09a2fba0ULL,
    0x25de10c0b86f0ULL,
    0xa638a8716b808ULL,
    0xb8a03c995240cULL,
    0x3f7492d8fc602ULL,
    0x2a46139909509ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x1000000000000ULL,
    0xb800000000000ULL,
    0x3c00000000000ULL,
    0x8200000000000ULL,
    0x7900000000000ULL,
    0x1d80000000000ULL,
    0xf640000000000ULL,
    0x67a0000000000ULL,
    0x8d30000000000ULL,
    0x82a8000000000ULL,
    0x22b4000000000ULL,
    0xc5ee000000000ULL,
    0xcc95000000000ULL,
    0xb895800000000ULL,
    0xee9ec00000000ULL,
    0xf199a00000000ULL,
    0x3b1f500000000ULL,
    0x93d9780000000ULL,
    0x5abbb40000000ULL,
    0xd9ecc20000000ULL,
    0x3e93470000000ULL,
    0x6997788000000ULL,
    0x771eb44000000ULL,
    0xb9d1426000000ULL,
    0xa7b9871000000ULL,
    0x7a60d83800000ULL,
    0x33d4e47c00000ULL,
    0x6abdbae200000ULL,
    0x11ecf36900000ULL,
    0xaa9dba2580000ULL,
    0x6f9cf38a40000ULL,
    0xb015ba05a0000ULL,
    0x5f58f3a430000ULL,
    0x3573bac728000ULL,
    0xf609f3b8f4000ULL,
    0x2f003a784e000ULL,
    0x2863354a5000ULL,
    0x3cca1afdbd800ULL,
    0xcf66a32f6ac00ULL,
    0x4451429457a00ULL,
    0x1f98799fa500ULL,
    0xc5c0d809c4f80ULL,
    0x92e4e4f8e1740ULL,
    0xd215ba4f13620ULL,
    0x7658f3c5dd170ULL,
    0xf0f3bac5bd808ULL,
    0x2c49f3536ac04ULL,
    0x72a03a7657a06ULL,
    0xcab633f0fa501ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x7000000000000ULL,
    0x8800000000000ULL,
    0x3400000000000ULL,
    0xd600000000000ULL,
    0xe500000000000ULL,
    0x2580000000000ULL,
    0x89c0000000000ULL,
    0xa260000000000ULL,
    0x93b0000000000ULL,
    0xe368000000000ULL,
    0xd834000000000ULL,
    0x53ae000000000ULL,
    0xcdd3000000000ULL,
    0xf2d6800000000ULL,
    0x7858400000000ULL,
    0xc31fe00000000ULL,
    0x630100000000ULL,
    0xc2aab80000000ULL,
    0x5e580c0000000ULL,
    0xee17de0000000ULL,
    0x77b2570000000ULL,
    0xed64b88000000ULL,
    0x913b0c4000000ULL,
    0x6c295e6000000ULL,
    0xcb1e177000000ULL,
    0x7235580800000ULL,
    0x74a81c7400000ULL,
    0xcb5d66b600000ULL,
    0x439a5b9500000ULL,
    0xca7b662d80000ULL,
    0x990d5bfdc0000ULL,
    0xe78be69460000ULL,
    0xaac21b46b0000ULL,
    0x9ae486aee8000ULL,
    0x83fd4b55f4000ULL,
    0x2ac15e4fce000ULL,
    0xdaea17bf63000ULL,
    0xe3fb588a3e800ULL,
    0x5acb1cc8ac400ULL,
    0x52e3e62951e00ULL,
    0xd7f61b7093100ULL,
    0x8cca868af4380ULL,
    0xb7ee4b75444c0ULL,
    0xf277de2c2e3e0ULL,
    0x50257ab15470ULL,
    0x158cb8823e808ULL,
    0x61cf0cbcac404ULL,
    0xe6675e9f51e06ULL,
    0xcdbd17e593107ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x5000000000000ULL,
    0xa800000000000ULL,
    0xe400000000000ULL,
    0x2e00000000000ULL,
    0xc700000000000ULL,
    0xfe80000000000ULL,
    0x22c0000000000ULL,
    0xfae0000000000ULL,
    0xf230000000000ULL,
    0x7be8000000000ULL,
    0xcfb4000000000ULL,
    0x79a2000000000ULL,
    0x2891000000000ULL,
    0xc3f8800000000ULL,
    0x4987400000000ULL,
    0x6446600000000ULL,
    0x342d300000000ULL,
    0x92d2880000000ULL,
    0xc8d29c0000000ULL,
    0x69d0e60000000ULL,
    0x44559f0000000ULL,
    0x4e18888000000ULL,
    0x1d379c4000000ULL,
    0x216a66a000000ULL,
    0x6373df5000000ULL,
    0x144e682800000ULL,
    0x8c29eca400000ULL,
    0x7edc8e8e00000ULL,
    0x52dd739700000ULL,
    0x28d486d680000ULL,
    0x99d9af86c0000ULL,
    0xbc5a80f4e0000ULL,
    0x216402530000ULL,
    0xd73ee08d68000ULL,
    0xc86a705974000ULL,
    0x5af4e80542000ULL,
    0xc80facf9a1000ULL,
    0x540a6e6890800ULL,
    0x76030363f3400ULL,
    0xdb026e9984600ULL,
    0x9c87038c4c300ULL,
    0x2fc86ef022080ULL,
    0xed6203acd1dc0ULL,
    0xe972ee87dc860ULL,
    0x5d4443635daf0ULL,
    0xe5a40ec090808ULL,
    0xa9a3387f3404ULL,
    0x6ef2e6b78460aULL,
    0xe049f4b4c305ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0xb000000000000ULL,
    0x9800000000000ULL,
    0xd400000000000ULL,
    0x1e00000000000ULL,
    0xe500000000000ULL,
    0x6b80000000000ULL,
    0xb940000000000ULL,
    0x56e0000000000ULL,
    0x3370000000000ULL,
    0xed68000000000ULL,
    0x423c000000000ULL,
    0x678a000000000ULL,
    0x9347000000000ULL,
    0x3deb800000000ULL,
    0x95f6400000000ULL,
    0x73a0600000000ULL,
    0x679f100000000ULL,
    0xf91d580000000ULL,
    0xc3dac40000000ULL,
    0x407c560000000ULL,
    0x5fe8e30000000ULL,
    0xe2f6d88000000ULL,
    0x172c84c000000ULL,
    0xfe5c362000000ULL,
    0x37f3b000000ULL,
    0xa08b801800000ULL,
    0x6fc6401400000ULL,
    0x7028603e00000ULL,
    0x72d3105500000ULL,
    0xf5ff58f380000ULL,
    0x23a1c46d40000ULL,
    0x6f9dd648e0000ULL,
    0x519a3d670000ULL,
    0x91dd3806e8000ULL,
    0x6f75d43b7c000ULL,
    0xcf690e116a000ULL,
    0xd53e271037000ULL,
    0x93088ec883800ULL,
    0x228f67c3ca400ULL,
    0x88c36eaa2a600ULL,
    0x3ca63761d8100ULL,
    0xa71e569776d80ULL,
    0xc6d3e34b6c840ULL,
    0xbbf758433c360ULL,
    0xceadc44a07f30ULL,
    0xf81fd63b03808ULL,
    0xee52a3ae8a40cULL,
    0xe834b8e2ca602ULL,
    0xcc8894b7a810bULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x1000000000000ULL,
    0xe800000000000ULL,
    0xc00000000000ULL,
    0x2200000000000ULL,
    0xa300000000000ULL,
    0xd080000000000ULL,
    0x8bc0000000000ULL,
    0x44a0000000000ULL,
    0x13f0000000000ULL,
    0xc28000000000ULL,
    0xac3c000000000ULL,
    0x6e86000000000ULL,
    0x22cd000000000ULL,
    0xdb20800000000ULL,
    0x7ab1c00000000ULL,
    0x8844a00000000ULL,
    0x27e6f00000000ULL,
    0xd891280000000ULL,
    0x657b8c0000000ULL,
    0xdae3c20000000ULL,
    0xb11b430000000ULL,
    0x9931a88000000ULL,
    0xfb0a4cc000000ULL,
    0x48762e000000ULL,
    0xbdcdb31000000ULL,
    0x31a8806800000ULL,
    0xa67dc0cc00000ULL,
    0xda6aa0c200000ULL,
    0x32d7f0b300000ULL,
    0xc197a83880000ULL,
    0x22f74c87c0000ULL,
    0xa7afe266a0000ULL,
    0xe37073b0f0000ULL,
    0x77e2205ca8000ULL,
    0x109a30e7fc000ULL,
    0x997508ca26000ULL,
    0xecbc213d000ULL,
    0xf6164a3f08800ULL,
    0x67b63fda8dc00ULL,
    0xf1cb4244c2a00ULL,
    0x33a683662bf00ULL,
    0xf57b08b331a80ULL,
    0xf2edbc440a4c0ULL,
    0x5d18ca1e07620ULL,
    0xab36ff990db30ULL,
    0xb009620788808ULL,
    0xd80cb35d4dc0cULL,
    0x1406002262a0eULL,
    0xd60d00d6dbf01ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0xd000000000000ULL,
    0x8800000000000ULL,
    0x2400000000000ULL,
    0x5e00000000000ULL,
    0x8500000000000ULL,
    0xb680000000000ULL,
    0x1c0000000000ULL,
    0xf220000000000ULL,
    0x42f0000000000ULL,
    0x6aa8000000000ULL,
    0x5e3c000000000ULL,
    0xa20a000000000ULL,
    0xb701000000000ULL,
    0x698a800000000ULL,
    0xbc4f400000000ULL,
    0x486d600000000ULL,
    0x239a100000000ULL,
    0x85b6880000000ULL,
    0x14c4c0000000ULL,
    0x62ea4a0000000ULL,
    0x205b330000000ULL,
    0xd094088000000ULL,
    0x823f0cc000000ULL,
    0x400d2a2000000ULL,
    0xe00023d000000ULL,
    0xf008000800000ULL,
    0x580c00e400000ULL,
    0xac02007e00000ULL,
    0x7a0d005500000ULL,
    0xdb08803e80000ULL,
    0x33824025c0000ULL,
    0xb745e0ac20000ULL,
    0xf3e850c7f0000ULL,
    0xb0db68dc28000ULL,
    0x28581c5ffc000ULL,
    0x349b22502a000ULL,
    0xfc322ff5f1000ULL,
    0x150daa8322800ULL,
    0xde8e632273400ULL,
    0xd5cfe04a67600ULL,
    0xf42950849b100ULL,
    0x6bf1e8443c080ULL,
    0xa6275c49030c0ULL,
    0x84fe42fc872a0ULL,
    0x63a43fa2c1230ULL,
    0x42b9223da2808ULL,
    0xf0cf2fc7b340cULL,
    0x52ad2ac647602ULL,
    0xc23023936b10dULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x7000000000000ULL,
    0x9800000000000ULL,
    0x9400000000000ULL,
    0x6e00000000000ULL,
    0xa300000000000ULL,
    0x9680000000000ULL,
    0x3e40000000000ULL,
    0x5620000000000ULL,
    0x9170000000000ULL,
    0xbba8000000000ULL,
    0xcdbc000000000ULL,
    0x6dc2000000000ULL,
    0x41eb000000000ULL,
    0xdd93800000000ULL,
    0xf3b6400000000ULL,
    0xe6cb600000000ULL,
    0x7b65700000000ULL,
    0x69d2880000000ULL,
    0xf09f540000000ULL,
    0xd638ca0000000ULL,
    0x60b530000000ULL,
    0x6f03088000000ULL,
    0xcc8214c000000ULL,
    0x83402aa000000ULL,
    0xfba8637000000ULL,
    0xadb2e01800000ULL,
    0xbdc4305400000ULL,
    0xa9e868ce00000ULL,
    0xd19764d300000ULL,
    0x9baa20e80000ULL,
    0x2bcb37aa40000ULL,
    0x4ee82ab820000ULL,
    0xc11463f270000ULL,
    0x98f0e00d28000ULL,
    0x116f3043fc000ULL,
    0x2cdbe803e2000ULL,
    0x191124349b000ULL,
    0x6cf9c2903b800ULL,
    0xaf6247090a400ULL,
    0x67d0a2f389600ULL,
    0x839c3767ce700ULL,
    0xa8b9aa54e1080ULL,
    0x3449231c19140ULL,
    0xc32800657baa0ULL,
    0x90fc0005a2230ULL,
    0xd620086bb808ULL,
    0x9edb00f74a40cULL,
    0xa81b8085a960aULL,
    0x3b7a4046be707ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0xd000000000000ULL,
    0x5800000000000ULL,
    0x5c00000000000ULL,
    0x7a00000000000ULL,
    0xcd00000000000ULL,
    0x8080000000000ULL,
    0x5e40000000000ULL,
    0x4ce0000000000ULL,
    0x5b10000000000ULL,
    0x5b68000000000ULL,
    0x58dc000000000ULL,
    0x3142000000000ULL,
    0x9d61000000000ULL,
    0x5fdf800000000ULL,
    0x54c0c00000000ULL,
    0x97ae200000000ULL,
    0x3373100000000ULL,
    0xa83aa80000000ULL,
    0xa058b40000000ULL,
    0x2307060000000ULL,
    0x538cf50000000ULL,
    0x45cf288000000ULL,
    0xad2574c000000ULL,
    0x34a6a000000ULL,
    0xb45e25d000000ULL,
    0xfd0420d800000ULL,
    0x688e109c00000ULL,
    0x2a4728da00000ULL,
    0xe2e9741d00000ULL,
    0xe81ea6d880000ULL,
    0x30e3250240000ULL,
    0x3119a0b6e0000ULL,
    0x6e6fd05610000ULL,
    0x5456887be8000ULL,
    0x4d0aa4d69c000ULL,
    0x40822e25a2000ULL,
    0xfe44819a71000ULL,
    0x9cee0efeb7800ULL,
    0x31691011cc00ULL,
    0x76b26066c200ULL,
    0x22dee5e052100ULL,
    0xfc4a00c305280ULL,
    0x1ded00e388740ULL,
    0x195806dc1260ULL,
    0x182dc07923e50ULL,
    0xccbba07e37808ULL,
    0x681ed05f5cc0cULL,
    0xf0e108ca8c20aULL,
    0x9116647b4210dULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x1000000000000ULL,
    0xb800000000000ULL,
    0x9400000000000ULL,
    0x1a00000000000ULL,
    0x4b00000000000ULL,
    0xa580000000000ULL,
    0x7bc0000000000ULL,
    0x4860000000000ULL,
    0xd270000000000ULL,
    0xe4e8000000000ULL,
    0xa33c000000000ULL,
    0x60c2000000000ULL,
    0x35ed000000000ULL,
    0x8db1800000000ULL,
    0x1e80400000000ULL,
    0x1646200000000ULL,
    0xafa7f00000000ULL,
    0xbc1af80000000ULL,
    0x4b908c0000000ULL,
    0x27539e0000000ULL,
    0x4cb53b0000000ULL,
    0x8801788000000ULL,
    0xfc01ccc000000ULL,
    0x96063ea000000ULL,
    0xd50f8b1000000ULL,
    0x4c84203800000ULL,
    0x14af05400000ULL,
    0x8c2b78ba00000ULL,
    0xaad0cc5b00000ULL,
    0xdb75be1d80000ULL,
    0xee62cbefc0000ULL,
    0x6f7380d260000ULL,
    0x246d405970000ULL,
    0x3c77a0e168000ULL,
    0x5e7b0c8fc000ULL,
    0xe5bcd890a2000ULL,
    0x92877c739d000ULL,
    0x8841667359800ULL,
    0x46a9b7f6bc400ULL,
    0xc698e65304200ULL,
    0x8fd5f7218af00ULL,
    0x5ffcc659cb780ULL,
    0x732f075760cc0ULL,
    0xc55fbe4dfdbe0ULL,
    0xf3b3cb042ecb0ULL,
    0x878000d6d9808ULL,
    0x64c0008d7c40cULL,
    0x57e0009b6420aULL,
    0xf2b00033faf01ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0x9000000000000ULL,
    0x800000000000ULL,
    0x5c00000000000ULL,
    0x6200000000000ULL,
    0x8100000000000ULL,
    0xed80000000000ULL,
    0x87c0000000000ULL,
    0x6e60000000000ULL,
    0x9e30000000000ULL,
    0x58e8000000000ULL,
    0xf174000000000ULL,
    0x4aca000000000ULL,
    0xa9ed000000000ULL,
    0xe4f2800000000ULL,
    0x2904c00000000ULL,
    0x6182a00000000ULL,
    0xcdcfd00000000ULL,
    0x2361f80000000ULL,
    0x19b0ec0000000ULL,
    0x225fe0000000ULL,
    0x1093bf0000000ULL,
    0xd231788000000ULL,
    0x72ed2c4000000ULL,
    0xc7fde2000000ULL,
    0x5545af9000000ULL,
    0xa728a08800000ULL,
    0x3b12d01c00000ULL,
    0x52fb784200000ULL,
    0xd6002c1100000ULL,
    0x4f0d5ee580000ULL,
    0xb6816fdbc0000ULL,
    0x2f4a008c60000ULL,
    0x322d005f30000ULL,
    0xc892809568000ULL,
    0xa634c0e6b4000ULL,
    0xdceaa02caa000ULL,
    0xe77bd06bdd000ULL,
    0x65cbf8de1a800ULL,
    0xaf6dec5970c00ULL,
    0x53bf7ec6c8a00ULL,
    0x4f237fe3e2d00ULL,
    0x9719d829f3780ULL,
    0x88fffcee842c0ULL,
    0x9304a61b4f5e0ULL,
    0x948583bc286f0ULL,
    0x8e45fe339a808ULL,
    0x4fa3bfdeb0c04ULL,
    0x47597828a8a02ULL,
    0x94592c3dd2d09ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x5000000000000ULL,
    0xb800000000000ULL,
    0xec00000000000ULL,
    0x6600000000000ULL,
    0x2300000000000ULL,
    0xab80000000000ULL,
    0xadc0000000000ULL,
    0x1b60000000000ULL,
    0x1710000000000ULL,
    0x9e8000000000ULL,
    0xc5c000000000ULL,
    0xabca000000000ULL,
    0x8869000000000ULL,
    0x7499800000000ULL,
    0xa023c00000000ULL,
    0x2531e00000000ULL,
    0x15d6f00000000ULL,
    0x6f0dd80000000ULL,
    0x5d8d6c0000000ULL,
    0x16c2ce0000000ULL,
    0xce34d0000000ULL,
    0x64d6588000000ULL,
    0xdd8bacc000000ULL,
    0xd6c8ae2000000ULL,
    0x2ce37d5000000ULL,
    0x34d9e03800000ULL,
    0x658af02c00000ULL,
    0x3ac7d84600000ULL,
    0x4ae46c7300000ULL,
    0x17db4e1380000ULL,
    0xce008d41c0000ULL,
    0x9707b8fd60000ULL,
    0x518d5cf410000ULL,
    0xcd768268000ULL,
    0xc7e211f19c000ULL,
    0x9b592e88aa000ULL,
    0xfa4cbdb379000ULL,
    0x88aa00bb71800ULL,
    0xb379001f7fc00ULL,
    0x3b7180bd7be00ULL,
    0xdf7fc08c7ff00ULL,
    0x9d7be0def4580ULL,
    0xdc7ff025beac0ULL,
    0x66f458f79b2e0ULL,
    0xc9beac9ba9bd0ULL,
    0x919b2e10f1808ULL,
    0xb8a9bdb2bfc0cULL,
    0xbb7180261be02ULL,
    0x1f7fc05b6ff05ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x1000000000000ULL,
    0xd800000000000ULL,
    0x4400000000000ULL,
    0x7e00000000000ULL,
    0x6100000000000ULL,
    0x2380000000000ULL,
    0x7ec0000000000ULL,
    0xf120000000000ULL,
    0x2650000000000ULL,
    0x1fe8000000000ULL,
    0xcf7c000000000ULL,
    0x1dbe000000000ULL,
    0xbe95000000000ULL,
    0x6bcf800000000ULL,
    0xc4af400000000ULL,
    0xd59d600000000ULL,
    0x3f46d00000000ULL,
    0x14e0180000000ULL,
    0x8bf45c0000000ULL,
    0x15f5da0000000ULL,
    0xa4f8210000000ULL,
    0x3f7d788000000ULL,
    0x15b28cc000000ULL,
    0x4295c26000000ULL,
    0x41cc7d1000000ULL,
    0x3a8a25800000ULL,
    0xd31aad8400000ULL,
    0x1c00ba9e00000ULL,
    0xfa02f1b100000ULL,
    0x7f03601b80000ULL,
    0x5283d0eac0000ULL,
    0x8547983720000ULL,
    0xcbe71c1350000ULL,
    0xa976ba9a68000ULL,
    0x58bbf194bc000ULL,
    0xf31ae0311e000ULL,
    0xac05904705000ULL,
    0x520b78c687800ULL,
    0xf30b8c4343400ULL,
    0xb08c42feeb600ULL,
    0xde4a3d2cffd00ULL,
    0xf764428379980ULL,
    0x95363d9fb21c0ULL,
    0xf4da4275993a0ULL,
    0x5aa33d4f44b10ULL,
    0x6495c25cef808ULL,
    0xa4cc7dd7ff40cULL,
    0x3e28a2cff5606ULL,
    0xdcdaad6bfad01ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x1000000000000ULL,
    0xa800000000000ULL,
    0x7c00000000000ULL,
    0x1600000000000ULL,
    0x6d00000000000ULL,
    0x7b80000000000ULL,
    0x6640000000000ULL,
    0xe320000000000ULL,
    0x87d0000000000ULL,
    0xf368000000000ULL,
    0xf9f4000000000ULL,
    0x1732000000000ULL,
    0xa8dd000000000ULL,
    0xcfec800000000ULL,
    0x3f38c00000000ULL,
    0x94d8e00000000ULL,
    0x79e6900000000ULL,
    0x4235980000000ULL,
    0x4755140000000ULL,
    0x63a9ba0000000ULL,
    0xb71c310000000ULL,
    0xad85788000000ULL,
    0xeb47844000000ULL,
    0x28ae22a000000ULL,
    0x5994251000000ULL,
    0xc440422800000ULL,
    0x1423753c00000ULL,
    0x9f53ba3600000ULL,
    0x47a5313d00000ULL,
    0xc513f8f380000ULL,
    0x1286444a40000ULL,
    0x3fc042fd20000ULL,
    0x32637586d0000ULL,
    0xdc73bab6e8000ULL,
    0xd07531ceb4000ULL,
    0x9e7bf8b992000ULL,
    0x977244744d000ULL,
    0x3ef242ac24800ULL,
    0xf7be754b5cc00ULL,
    0x681f3aada2e00ULL,
    0x890df1fe1f900ULL,
    0xe983182403180ULL,
    0x6944d47204d40ULL,
    0x8fafdabf0fda0ULL,
    0x491f61d48f610ULL,
    0x1c84809acc808ULL,
    0x96ccc0c5e8c04ULL,
    0x8beae0b430e0aULL,
    0xbd3b909a52901ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0xf000000000000ULL,
    0xb800000000000ULL,
    0x2400000000000ULL,
    0xe00000000000ULL,
    0xd100000000000ULL,
    0x9680000000000ULL,
    0x5c0000000000ULL,
    0x1260000000000ULL,
    0x69b0000000000ULL,
    0x41a8000000000ULL,
    0x3ed4000000000ULL,
    0x689e000000000ULL,
    0x7fb3000000000ULL,
    0x64a1800000000ULL,
    0x8e5f400000000ULL,
    0xd05a600000000ULL,
    0x6957d00000000ULL,
    0xf3da480000000ULL,
    0x941aec0000000ULL,
    0xc57b3e0000000ULL,
    0xc14e7f0000000ULL,
    0xcca8288000000ULL,
    0xa2593c4000000ULL,
    0x225f766000000ULL,
    0x625793f000000ULL,
    0x25a963800000ULL,
    0xf25c036400000ULL,
    0x4a533eee00000ULL,
    0x6e5a7f6100000ULL,
    0x605628ce80000ULL,
    0xb15a3c91c0000ULL,
    0x27d6f6c460000ULL,
    0x221cd36cb0000ULL,
    0x307ef6e128000ULL,
    0x59c8d38e14000ULL,
    0x1860f6027e000ULL,
    0x26bbd372c3000ULL,
    0x4e2176f9e9800ULL,
    0x31949348fb400ULL,
    0x553316bd0c600ULL,
    0xdb67430480d00ULL,
    0xb3f5e7ecdc80ULL,
    0x626aaf1be2ac0ULL,
    0x91b3e0cbfede0ULL,
    0x5ac907085ef0ULL,
    0xc0d62898c1808ULL,
    0x19a3c86ef404ULL,
    0xcd36f6df72606ULL,
    0x6f6cd38643d0fULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x5000000000000ULL,
    0x2800000000000ULL,
    0x4c00000000000ULL,
    0x4a00000000000ULL,
    0xe500000000000ULL,
    0x7c80000000000ULL,
    0x4540000000000ULL,
    0x8b60000000000ULL,
    0x9050000000000ULL,
    0x7c28000000000ULL,
    0xda34000000000ULL,
    0x76f6000000000ULL,
    0x1c59000000000ULL,
    0x9620800000000ULL,
    0x8f3bc00000000ULL,
    0x7275200000000ULL,
    0x3d11100000000ULL,
    0x1b47280000000ULL,
    0xb065640000000ULL,
    0x97dc0e0000000ULL,
    0xdeef890000000ULL,
    0xa39a088000000ULL,
    0xb700744000000ULL,
    0xed8d26e000000ULL,
    0xf7c3ed5000000ULL,
    0x7d2e86a800000ULL,
    0xe0b03d0c00000ULL,
    0x7cbc0e2a00000ULL,
    0x5ebf89f500000ULL,
    0x17b2083480000ULL,
    0x7134741940000ULL,
    0xf97b260960000ULL,
    0x429aed6950000ULL,
    0xdd8e06e2a8000ULL,
    0xcfcbfd7674000ULL,
    0xf9292eab16000ULL,
    0xb6be993c49000ULL,
    0xfbbd2055e8800ULL,
    0x8b3510dc1fc00ULL,
    0x64792871cb200ULL,
    0x5a1864922c100ULL,
    0x9ec28e9939a80ULL,
    0xeba9491573a40ULL,
    0xf0f1a8389fae0ULL,
    0xf357a4008c590ULL,
    0xefa1ae3740808ULL,
    0xe6f159ea6bc04ULL,
    0x945e003add20eULL,
    0x6a2d00fe65105ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0x5000000000000ULL,
    0x2800000000000ULL,
    0xfc00000000000ULL,
    0xa00000000000ULL,
    0xf900000000000ULL,
    0x8e80000000000ULL,
    0x6bc0000000000ULL,
    0x2ae0000000000ULL,
    0x9a30000000000ULL,
    0xe428000000000ULL,
    0x2454000000000ULL,
    0xe4da000000000ULL,
    0xc819000000000ULL,
    0x137c800000000ULL,
    0xe704c00000000ULL,
    0xe181200000000ULL,
    0x6645d00000000ULL,
    0x4ea0080000000ULL,
    0x8194cc0000000ULL,
    0xc932b60000000ULL,
    0x83a4c70000000ULL,
    0xc91b288000000ULL,
    0x9f81c4000000ULL,
    0x5ac63e2000000ULL,
    0x6860cb5000000ULL,
    0xa3f2bea800000ULL,
    0xb3c00bbc00000ULL,
    0xeee19eaa00000ULL,
    0x6438dbe900000ULL,
    0xbb2f160680000ULL,
    0x71d5d787c0000ULL,
    0x49200a8e0000ULL,
    0xdbd008f30000ULL,
    0x316e8068a8000ULL,
    0x3d79c01a94000ULL,
    0xd00fa062ba000ULL,
    0x680c103ce9000ULL,
    0xdc07a85934800ULL,
    0x5a0cdccba0c00ULL,
    0xd10f1e4513200ULL,
    0x72811b7bf8d00ULL,
    0x61c0b6f7ce880ULL,
    0xd3e9c750ed0c0ULL,
    0x14bda89b3d160ULL,
    0x8fe5dcfea8d70ULL,
    0xebb9e999c808ULL,
    0x7ee1db6d34c04ULL,
    0x2c33968da9202ULL,
    0x372117ae11d05ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0xb000000000000ULL,
    0x3800000000000ULL,
    0xb400000000000ULL,
    0x4600000000000ULL,
    0x4b00000000000ULL,
    0xfc80000000000ULL,
    0x8640000000000ULL,
    0x3a0000000000ULL,
    0xb670000000000ULL,
    0x52e8000000000ULL,
    0x7354000000000ULL,
    0xc3da000000000ULL,
    0xd797000000000ULL,
    0x493d800000000ULL,
    0xc0ce400000000ULL,
    0x64eae00000000ULL,
    0x6055700000000ULL,
    0x1b50680000000ULL,
    0x9fdc740000000ULL,
    0x8d9a620000000ULL,
    0x78391b0000000ULL,
    0xbd40888000000ULL,
    0xa72e044000000ULL,
    0x143f8a2000000ULL,
    0x9f4f2fb000000ULL,
    0x2220ab800000ULL,
    0x9fb16ff400000ULL,
    0x2f80eae600000ULL,
    0x3ec01fbb00000ULL,
    0xdbe2826480000ULL,
    0xfadf6bc240000ULL,
    0x661f60dda0000ULL,
    0x58ff30b970000ULL,
    0x9a888f068000ULL,
    0x6f7a04ba14000ULL,
    0x33658a42fa000ULL,
    0xca982f18a7000ULL,
    0x36bf8a22f5800ULL,
    0x160f2f88aa400ULL,
    0xa3020aaaf8e00ULL,
    0xe0816f04a6700ULL,
    0xfc48ea58ffe80ULL,
    0x82a41f09a1340ULL,
    0xf3f082ef7f020ULL,
    0x252c6b73612b0ULL,
    0x4130e06a9d808ULL,
    0xcc270c6be404ULL,
    0xb6ede80e02e02ULL,
    0xdd5234a70170bULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0xf000000000000ULL,
    0x5800000000000ULL,
    0x9c00000000000ULL,
    0x1e00000000000ULL,
    0x3f00000000000ULL,
    0x8380000000000ULL,
    0x240000000000ULL,
    0x18e0000000000ULL,
    0x1bd0000000000ULL,
    0xe128000000000ULL,
    0xad7c000000000ULL,
    0x412000000000ULL,
    0x48b000000000ULL,
    0x8dc3800000000ULL,
    0xcacc00000000ULL,
    0x83b600000000ULL,
    0xa377b00000000ULL,
    0xf314180000000ULL,
    0x130c340000000ULL,
    0xa583460000000ULL,
    0xf149210000000ULL,
    0x2d6cf88000000ULL,
    0xe29744c000000ULL,
    0xf84c3ea000000ULL,
    0x95e2a5f000000ULL,
    0x4153a6d800000ULL,
    0x33ee515c00000ULL,
    0x7251803e00000ULL,
    0xa667c00f00000ULL,
    0x7b18e07b80000ULL,
    0xe70b706e40000ULL,
    0xdf87785ee0000ULL,
    0xbc4784b8d0000ULL,
    0xd7e55e7ca8000ULL,
    0xc05e15903c000ULL,
    0x7f643e1f72000ULL,
    0xab9ea5dd1b000ULL,
    0x20c1a6540b800ULL,
    0x6625518a00c00ULL,
    0x22f2009501600ULL,
    0x105b00a680b00ULL,
    0x176b809cc5980ULL,
    0xcf90c0482bf40ULL,
    0x52c960e5fba60ULL,
    0x1f2cb0ffd2510ULL,
    0x27f985323808ULL,
    0x8f9cf4747cc0cULL,
    0x32ca26d49360aULL,
    0x4f2591c34bb0fULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x3000000000000ULL,
    0xd800000000000ULL,
    0xfc00000000000ULL,
    0x6a00000000000ULL,
    0xab00000000000ULL,
    0x7180000000000ULL,
    0xfc0000000000ULL,
    0x8320000000000ULL,
    0x33b0000000000ULL,
    0x9568000000000ULL,
    0x5b5c000000000ULL,
    0xd3fe000000000ULL,
    0xc87000000000ULL,
    0x1f47800000000ULL,
    0x66ac00000000ULL,
    0x26d8200000000ULL,
    0xe30f00000000ULL,
    0xe8aa780000000ULL,
    0xef76ec0000000ULL,
    0xcbc89a0000000ULL,
    0xe5265f0000000ULL,
    0x4ab5d88000000ULL,
    0x83ecdcc000000ULL,
    0x971ac26000000ULL,
    0x810433000000ULL,
    0xa79f3a5800000ULL,
    0x1d506f3c00000ULL,
    0x3af1808a00000ULL,
    0x9201c05b00000ULL,
    0xc709a0c980000ULL,
    0x938130c3c0000ULL,
    0xb0cbd83120000ULL,
    0xbcabdc64b0000ULL,
    0x17d428ee8000ULL,
    0xa6ca83ff9c000ULL,
    0xbdaf1aa15e000ULL,
    0xbbfc9ff0f7000ULL,
    0xe885f8e90f800ULL,
    0xe9402c9e86c00ULL,
    0xf76ebad84e200ULL,
    0x2451af95ebf00ULL,
    0x8c78201613f80ULL,
    0xe40f0729b2c0ULL,
    0xf4e27889d73a0ULL,
    0x1c9aec79bc6f0ULL,
    0x24de9aae67808ULL,
    0x413d5fa2dac0cULL,
    0x6f2c584830206ULL,
    0x11b11c01acf03ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0xd000000000000ULL,
    0x3800000000000ULL,
    0x2c00000000000ULL,
    0xe600000000000ULL,
    0xb700000000000ULL,
    0x5980000000000ULL,
    0xea40000000000ULL,
    0xdf20000000000ULL,
    0x17d0000000000ULL,
    0x4ae8000000000ULL,
    0xb5b4000000000ULL,
    0x6b9e000000000ULL,
    0xeac1000000000ULL,
    0x5fe1800000000ULL,
    0xe939c00000000ULL,
    0xc558e00000000ULL,
    0x726300000000ULL,
    0xabdb380000000ULL,
    0xf4e8b40000000ULL,
    0xfeb99a0000000ULL,
    0xec15010000000ULL,
    0x9b8a588000000ULL,
    0x3f43444000000ULL,
    0xa3a4426000000ULL,
    0x91a85d000000ULL,
    0x4f097ab800000ULL,
    0x5587316c00000ULL,
    0xbc4f600600000ULL,
    0x802af02700000ULL,
    0x5a5c580180000ULL,
    0x6aa6441640000ULL,
    0x3b93c20120000ULL,
    0x92c6458cd0000ULL,
    0x13e61a7568000ULL,
    0xdf3dc1a8f4000ULL,
    0x4a5b380d3e000ULL,
    0x72a8b48751000ULL,
    0xa7999a9229800ULL,
    0x9cc501b75dc00ULL,
    0xb0e258ba2ee00ULL,
    0x4cb7448353300ULL,
    0xf11a424024b80ULL,
    0x430b857a50740ULL,
    0x380fa5aa0fa0ULL,
    0xe34af1939af10ULL,
    0xcda98066c1808ULL,
    0x7a1dc049e9c04ULL,
    0xe48ee0d630e06ULL,
    0xc2c33058d230dULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0xb000000000000ULL,
    0x6800000000000ULL,
    0x3c00000000000ULL,
    0xd600000000000ULL,
    0x5100000000000ULL,
    0x1a80000000000ULL,
    0x49c0000000000ULL,
    0xdf20000000000ULL,
    0xead0000000000ULL,
    0xfa68000000000ULL,
    0x5d3c000000000ULL,
    0x9d1a000000000ULL,
    0x884f000000000ULL,
    0x5b68800000000ULL,
    0xcfbac00000000ULL,
    0x78d8e00000000ULL,
    0x5964500000000ULL,
    0xb4b1080000000ULL,
    0xc55dec0000000ULL,
    0xeb20ca0000000ULL,
    0x50d0d90000000ULL,
    0x8569688000000ULL,
    0xf2bf7cc000000ULL,
    0x4c53222000000ULL,
    0xa5a665b000000ULL,
    0xf3102ae800000ULL,
    0xdd4889fc00000ULL,
    0x53e2607600000ULL,
    0xe57d902100000ULL,
    0x6e73685280000ULL,
    0x5bf07cc5c0000ULL,
    0x45bba26120000ULL,
    0xafdca587d0000ULL,
    0xeae8cab6e8000ULL,
    0x3fcd985fc000ULL,
    0xd1bb68f8ba000ULL,
    0x65dc7c5b5f000ULL,
    0xdde9a23620800ULL,
    0x207fa5f456c00ULL,
    0xbef24a21aae00ULL,
    0x2535192117500ULL,
    0xb911081e43880ULL,
    0x2a4decea682c0ULL,
    0x5068ca4530aa0ULL,
    0x3a3cd9e91e490ULL,
    0x469b685248808ULL,
    0x30c7c746ac0cULL,
    0x9981a29830e02ULL,
    0x1043a54d9850bULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0xd000000000000ULL,
    0x5800000000000ULL,
    0x1400000000000ULL,
    0xda00000000000ULL,
    0xf300000000000ULL,
    0x180000000000ULL,
    0x7e40000000000ULL,
    0x2860000000000ULL,
    0x55d0000000000ULL,
    0x21a8000000000ULL,
    0x2efc000000000ULL,
    0x4c9e000000000ULL,
    0x1249000000000ULL,
    0x966f800000000ULL,
    0x94da400000000ULL,
    0x4f2d200000000ULL,
    0xc737f00000000ULL,
    0x27b2f80000000ULL,
    0x477c740000000ULL,
    0x6eda2e0000000ULL,
    0xcc2ce10000000ULL,
    0x2eb8588000000ULL,
    0xc5fdc4c000000ULL,
    0xf913f66000000ULL,
    0x60265d000000ULL,
    0xc5090ed800000ULL,
    0x8c8211d400000ULL,
    0xdecd203a00000ULL,
    0xe8a7f0e300000ULL,
    0xcc7af83980000ULL,
    0xb5074ba40000ULL,
    0x806c2eaa60000ULL,
    0x69d9e1b2d0000ULL,
    0x7a9d87a28000ULL,
    0x9bfe8463bc000ULL,
    0x281956057e000ULL,
    0x5083d5e9d9000ULL,
    0xe8c0d647a7800ULL,
    0x65ac953bf6400ULL,
    0x6cfc76181b200ULL,
    0xcb98251882f00ULL,
    0x19c42e44c3780ULL,
    0x4325e1bbaf340ULL,
    0xa937d8fdf88e0ULL,
    0xbeb7843d11510ULL,
    0x3df6d6840f808ULL,
    0x5d1995220a40cULL,
    0x540df6d705206ULL,
    0x7a0b65938bf0dULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0xb000000000000ULL,
    0xa800000000000ULL,
    0xcc00000000000ULL,
    0x2200000000000ULL,
    0xb100000000000ULL,
    0xbe80000000000ULL,
    0xea40000000000ULL,
    0x9de0000000000ULL,
    0xf310000000000ULL,
    0x4828000000000ULL,
    0x523c000000000ULL,
    0x609e000000000ULL,
    0xe6ef000000000ULL,
    0x9090800000000ULL,
    0xeee9c00000000ULL,
    0x8c9fa00000000ULL,
    0xd4e3500000000ULL,
    0x5992080000000ULL,
    0x8463140000000ULL,
    0x20d2e60000000ULL,
    0x160cdd0000000ULL,
    0x8703288000000ULL,
    0x298684c000000ULL,
    0xbbcfce6000000ULL,
    0xf22559b000000ULL,
    0x473c662800000ULL,
    0x501a1d0c00000ULL,
    0x2fa408c200000ULL,
    0xaaf014c100000ULL,
    0x853c667680000ULL,
    0x911a1d9640000ULL,
    0x59240897e0000ULL,
    0x3cb0144e10000ULL,
    0x92dc66b4a8000ULL,
    0x1f0a1db97c000ULL,
    0x8d8c086bfe000ULL,
    0x35cc14f3bf000ULL,
    0xd122660758800ULL,
    0xe0b51d4ec5c00ULL,
    0xc8d48832a9a00ULL,
    0x7a09d48670500ULL,
    0x750bc6767c880ULL,
    0x80854d7e75d40ULL,
    0x614800e275c60ULL,
    0xf66c00987a4d0ULL,
    0x49d600ed70808ULL,
    0xac83006df9c0cULL,
    0x3346800cb7a06ULL,
    0x8f6ac0fadf50bULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x9000000000000ULL,
    0xd800000000000ULL,
    0x6400000000000ULL,
    0xaa00000000000ULL,
    0xc100000000000ULL,
    0x4780000000000ULL,
    0x8f40000000000ULL,
    0x94a0000000000ULL,
    0xbb30000000000ULL,
    0x4968000000000ULL,
    0xc55c000000000ULL,
    0x34b2000000000ULL,
    0xba2d000000000ULL,
    0x3ffb800000000ULL,
    0x748d400000000ULL,
    0xadc2200000000ULL,
    0x566dd00000000ULL,
    0xf1d1980000000ULL,
    0xf97bc40000000ULL,
    0xdc43620000000ULL,
    0x862b9f0000000ULL,
    0x31fa388000000ULL,
    0xbf8654c000000ULL,
    0xbb435aa000000ULL,
    0x46accb9000000ULL,
    0x8e38e25800000ULL,
    0x7ce6dfa400000ULL,
    0xef18188a00000ULL,
    0x4d9b849100000ULL,
    0x4f5ac23f80000ULL,
    0xa5bb0f7b40000ULL,
    0x85a18066a0000ULL,
    0x44bc40de30000ULL,
    0x922ba004e8000ULL,
    0xb3fd901b1c000ULL,
    0xf280383f92000ULL,
    0x7ac754ea5d000ULL,
    0x1ee2da4833800ULL,
    0x52108bcbe1400ULL,
    0x6413421798200ULL,
    0x3b1b4f665cd00ULL,
    0x6f98204e38180ULL,
    0x925cd0dceb840ULL,
    0xbc38187f12c20ULL,
    0xb9eb8495970f0ULL,
    0x3292c22b5b808ULL,
    0x4bd70f0fbd40cULL,
    0x207b80c4aa20aULL,
    0x5fcd40c331d09ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0xb000000000000ULL,
    0x6800000000000ULL,
    0x2400000000000ULL,
    0xa200000000000ULL,
    0x1500000000000ULL,
    0x4f80000000000ULL,
    0xee40000000000ULL,
    0xb60000000000ULL,
    0x6d70000000000ULL,
    0xb3a8000000000ULL,
    0x21dc000000000ULL,
    0x9cf2000000000ULL,
    0x76ef000000000ULL,
    0x8e30800000000ULL,
    0x1b4b400000000ULL,
    0x94eba00000000ULL,
    0xfb3f900000000ULL,
    0x44cf980000000ULL,
    0xa2af140000000ULL,
    0xbc5d5e0000000ULL,
    0xafb5eb0000000ULL,
    0xa606b88000000ULL,
    0xc704c4c000000ULL,
    0x9281e6a000000ULL,
    0x35c22fb000000ULL,
    0x2f25dee800000ULL,
    0x5712abe400000ULL,
    0x3357188200000ULL,
    0x6938546500000ULL,
    0xf9c4fe8780000ULL,
    0x69257b7a40000ULL,
    0x4019a04160000ULL,
    0xd9d0909c70000ULL,
    0xa0ff18fe28000ULL,
    0x38e4546a9c000ULL,
    0xad36feb012000ULL,
    0x8bca7bd1df000ULL,
    0x4292014f8800ULL,
    0xf39bd082e7400ULL,
    0xd994b85431a00ULL,
    0x389bc4f24c900ULL,
    0xad1966356d180ULL,
    0xaa556f867b540ULL,
    0xbc7e372e7e0ULL,
    0x10823bbb1d3b0ULL,
    0x50c8008550808ULL,
    0xa8ac00763b40cULL,
    0x2d5a002743a0aULL,
    0xf23300dae390bULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x3000000000000ULL,
    0xd800000000000ULL,
    0xf400000000000ULL,
    0x1600000000000ULL,
    0xfd00000000000ULL,
    0xc380000000000ULL,
    0x5340000000000ULL,
    0x8a20000000000ULL,
    0x27b0000000000ULL,
    0x5be8000000000ULL,
    0x1754000000000ULL,
    0x323e000000000ULL,
    0xd5af000000000ULL,
    0xeff800000000ULL,
    0xaec2400000000ULL,
    0x286be00000000ULL,
    0xdc1b100000000ULL,
    0x2c19180000000ULL,
    0xd41a040000000ULL,
    0x701e0a0000000ULL,
    0x8e13170000000ULL,
    0x5f13788000000ULL,
    0x7e9c544000000ULL,
    0xc6db726000000ULL,
    0x7274433000000ULL,
    0xc5098a5800000ULL,
    0x478557b400000ULL,
    0xfd4698f600000ULL,
    0xb328448d00000ULL,
    0x2a3dea7b80000ULL,
    0x1ac079740000ULL,
    0x48fc60c420000ULL,
    0xbbcd506eb0000ULL,
    0xc7ecf8ee68000ULL,
    0x6d5e148914000ULL,
    0x4d3092a39e000ULL,
    0xcd2f53555f000ULL,
    0xbb30924937800ULL,
    0x402f532326400ULL,
    0xc0b092623de00ULL,
    0xd76f533da0100ULL,
    0x849092a2f8980ULL,
    0xf9df530cc7440ULL,
    0xaf89223626a0ULL,
    0x40cb53929e470ULL,
    0x71669284df808ULL,
    0xe194538972404ULL,
    0xae5112f383e06ULL,
    0x7fb2138b4f103ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0xf000000000000ULL,
    0x4800000000000ULL,
    0xe400000000000ULL,
    0xbe00000000000ULL,
    0x5100000000000ULL,
    0xd180000000000ULL,
    0xb7c0000000000ULL,
    0x1f60000000000ULL,
    0x4750000000000ULL,
    0x1628000000000ULL,
    0xaf7c000000000ULL,
    0x485e000000000ULL,
    0xa6ab000000000ULL,
    0xe13e800000000ULL,
    0xf4ff400000000ULL,
    0x894600000000ULL,
    0x54dd00000000ULL,
    0x222db80000000ULL,
    0x9780c0000000ULL,
    0x25543e0000000ULL,
    0x9527310000000ULL,
    0x15f1588000000ULL,
    0x311d9cc000000ULL,
    0xc68d666000000ULL,
    0x3b46adf000000ULL,
    0xb3223ec800000ULL,
    0xb8f0312400000ULL,
    0x6291d85e00000ULL,
    0xc249dc6100000ULL,
    0xb6a786f980000ULL,
    0x99343da3c0000ULL,
    0x38fbe66960000ULL,
    0xa295ed3250000ULL,
    0xa2405e99a8000ULL,
    0x46aae179bc000ULL,
    0xd13ce02ebe000ULL,
    0xdcf590823b000ULL,
    0x1c91587e76800ULL,
    0xf34d9c59d3400ULL,
    0x9725667162600ULL,
    0x66faad0e5ad00ULL,
    0xc39c3e7bad380ULL,
    0x5bcb313abc4c0ULL,
    0xe56758f436de0ULL,
    0x385a9c0b79a10ULL,
    0x2ea5e6565e808ULL,
    0x653eed67af40cULL,
    0xbafede08bc606ULL,
    0x1195a12f31d0fULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x9000000000000ULL,
    0xf800000000000ULL,
    0x9c00000000000ULL,
    0x7600000000000ULL,
    0xd00000000000ULL,
    0x9f80000000000ULL,
    0xc9c0000000000ULL,
    0x9b20000000000ULL,
    0x9810000000000ULL,
    0x7618000000000ULL,
    0x971c000000000ULL,
    0xb696000000000ULL,
    0x865f000000000ULL,
    0x90f0800000000ULL,
    0x2629400000000ULL,
    0x2f96200000000ULL,
    0x7bdaf00000000ULL,
    0x763d080000000ULL,
    0xad82940000000ULL,
    0xfec5a60000000ULL,
    0x27ae670000000ULL,
    0xcf5da68000000ULL,
    0x3572674000000ULL,
    0xcceba62000000ULL,
    0x2a3d67d000000ULL,
    0x3b8326d800000ULL,
    0xc3c8274c00000ULL,
    0xd02306ae00000ULL,
    0x629dd74100000ULL,
    0x44568e3180000ULL,
    0x2ffa0388c0000ULL,
    0xceab08aaa0000ULL,
    0xfadd9410d0000ULL,
    0x27b5265cb8000ULL,
    0x554727c7cc000ULL,
    0x1c6b86ca2e000ULL,
    0x8378979193000ULL,
    0x21eeae02de800ULL,
    0x85b3f3bbba400ULL,
    0x9a4880a348a00ULL,
    0x3ce5405160b00ULL,
    0xa23820bcf5a80ULL,
    0x6f89f07822240ULL,
    0x41c388e6900e0ULL,
    0xcf28d49e5c430ULL,
    0x1a15063cf5a88ULL,
    0x6912d73822244ULL,
    0xef9e0ec6900eaULL,
    0x9bdf434e5c439ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x5000000000000ULL,
    0xd800000000000ULL,
    0x3400000000000ULL,
    0xd600000000000ULL,
    0x8d00000000000ULL,
    0xd380000000000ULL,
    0xea40000000000ULL,
    0xfd60000000000ULL,
    0xca10000000000ULL,
    0x7418000000000ULL,
    0x8514000000000ULL,
    0xc92000000000ULL,
    0xd9d7000000000ULL,
    0x743a800000000ULL,
    0x3ee9c00000000ULL,
    0x585ca00000000ULL,
    0x8d70700000000ULL,
    0x1107480000000ULL,
    0x1982ec0000000ULL,
    0x6d49ba0000000ULL,
    0xc9eddb0000000ULL,
    0x44d1ba8000000ULL,
    0xdfb9dbc000000ULL,
    0xd0a3bae000000ULL,
    0xfb3edb9000000ULL,
    0x26613a3800000ULL,
    0x54931ba400000ULL,
    0x2dd79aee00000ULL,
    0xc2306b2900000ULL,
    0xe3e0523d80000ULL,
    0x53d847c340000ULL,
    0x533dc8c0e0000ULL,
    0x3a6b2c0950000ULL,
    0x5e951a34f8000ULL,
    0xcaddab4c44000ULL,
    0xa6b6f2d86a000ULL,
    0xb52b370593000ULL,
    0xcc72001450800ULL,
    0xd087005f7ac00ULL,
    0x40c280c20c200ULL,
    0x72adc0ab0ab00ULL,
    0x36a0b68b680ULL,
    0x48e37085c85c0ULL,
    0xe557c82d22d20ULL,
    0xd6f82c5875870ULL,
    0x17459a368b688ULL,
    0x6e76b45c85ccULL,
    0xfc5ad2cd22d26ULL,
    0xe37187c875875ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x9000000000000ULL,
    0x4800000000000ULL,
    0x6400000000000ULL,
    0xfa00000000000ULL,
    0x1700000000000ULL,
    0xdd80000000000ULL,
    0xd0c0000000000ULL,
    0x9ba0000000000ULL,
    0x34f0000000000ULL,
    0xebf8000000000ULL,
    0x9274000000000ULL,
    0xd8b2000000000ULL,
    0xc41b000000000ULL,
    0x656f800000000ULL,
    0x3a51c00000000ULL,
    0xc98a600000000ULL,
    0x32c9100000000ULL,
    0xc0a7c80000000ULL,
    0xe771440000000ULL,
    0x9e3b3e0000000ULL,
    0xa759110000000ULL,
    0x1b093e8000000ULL,
    0x738211c000000ULL,
    0x85c6bee000000ULL,
    0xed23d15000000ULL,
    0xefb4dea800000ULL,
    0x299ec13400000ULL,
    0xda1165200000ULL,
    0x1df4852300000ULL,
    0x2b75a88f80000ULL,
    0x503c54f3c0000ULL,
    0x6256f69420000ULL,
    0x2587550730000ULL,
    0xcccf809fd8000ULL,
    0xbda1c0c544000ULL,
    0x65f260ef6a000ULL,
    0xf77d10355f000ULL,
    0x1635c85805800ULL,
    0xa35a44ec0ec00ULL,
    0x710cbefe0fe00ULL,
    0x2c8cd17d07d00ULL,
    0x3c495e0288280ULL,
    0xc7e401a946940ULL,
    0x631cf6516b160ULL,
    0xc0e855e85b850ULL,
    0x369200aa88288ULL,
    0x142b009d4694cULL,
    0xc73780036b166ULL,
    0x7fd5c0cb5b859ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0xf000000000000ULL,
    0x8800000000000ULL,
    0x4400000000000ULL,
    0xa600000000000ULL,
    0x6b00000000000ULL,
    0xcd80000000000ULL,
    0x4740000000000ULL,
    0x69e0000000000ULL,
    0x6230000000000ULL,
    0xa138000000000ULL,
    0x78bc000000000ULL,
    0x1f2000000000ULL,
    0x3f1d000000000ULL,
    0xfaa5800000000ULL,
    0x95d9c00000000ULL,
    0x840fa00000000ULL,
    0x60b100000000ULL,
    0x7b02c80000000ULL,
    0xb58f3c0000000ULL,
    0x8b4a620000000ULL,
    0x8beae10000000ULL,
    0xaf38628000000ULL,
    0x7b7e14000000ULL,
    0xf27de26000000ULL,
    0x2f5e21b000000ULL,
    0x34ca42e800000ULL,
    0x39a931f400000ULL,
    0x4c5a8a4e00000ULL,
    0xfd4b0d9f00000ULL,
    0x38ed688380000ULL,
    0xbeb42cd840000ULL,
    0xdaf0aa6a60000ULL,
    0x9a99ddfa70000ULL,
    0x9e000ab58000ULL,
    0xd2300032cc000ULL,
    0xc9380042aa000ULL,
    0xccbc00f9d1000ULL,
    0x2ff200760f800ULL,
    0x101d00b308c00ULL,
    0x9125801180200ULL,
    0xb999c0dd43d00ULL,
    0x206fa068e2e80ULL,
    0x237b1026bcec0ULL,
    0xb3dac8e6f08a0ULL,
    0xaf033cf09a0d0ULL,
    0x2b806280e2e88ULL,
    0xcc4be1d2bcec4ULL,
    0x546fe2a8f08aeULL,
    0xad73216f9a0dfULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0xd000000000000ULL,
    0xe800000000000ULL,
    0xf400000000000ULL,
    0x4a00000000000ULL,
    0x5100000000000ULL,
    0xae80000000000ULL,
    0xb5c0000000000ULL,
    0xb5a0000000000ULL,
    0x7a50000000000ULL,
    0x6758000000000ULL,
    0xdfdc000000000ULL,
    0xe51a000000000ULL,
    0x3537000000000ULL,
    0xed29800000000ULL,
    0xd09ec00000000ULL,
    0x3f76600000000ULL,
    0x23c1700000000ULL,
    0x7aa8980000000ULL,
    0x7fd4440000000ULL,
    0x1510de0000000ULL,
    0x6d359b0000000ULL,
    0x212ade8000000ULL,
    0x86929b4000000ULL,
    0xd07b5ee000000ULL,
    0x96405b9000000ULL,
    0x30ef3e0800000ULL,
    0xd13a2b6400000ULL,
    0x6f2c264200000ULL,
    0xc59baf3500000ULL,
    0xe3f918ec80000ULL,
    0xdb068480c0000ULL,
    0xdf84bed920000ULL,
    0xab4febba90000ULL,
    0x3869c65e78000ULL,
    0xd3f31ff54c000ULL,
    0xa30e603362000ULL,
    0xa38d70e47b000ULL,
    0xc54a98fc4b800ULL,
    0xcb6f44d1e5c00ULL,
    0xd87b5e47bde00ULL,
    0xf2405bc6e4b00ULL,
    0xf2ef3e4e35780ULL,
    0xa43a2bc2a0f40ULL,
    0x63ac26a3dda60ULL,
    0xd55baf8b196f0ULL,
    0xb2d9184635788ULL,
    0x459684a6a0f44ULL,
    0xa3fcbee1dda66ULL,
    0xbb03ebbe196fdULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0xb000000000000ULL,
    0xf800000000000ULL,
    0x3400000000000ULL,
    0x7600000000000ULL,
    0x4d00000000000ULL,
    0x8880000000000ULL,
    0x93c0000000000ULL,
    0x9e20000000000ULL,
    0x5fd0000000000ULL,
    0x40d8000000000ULL,
    0x9b54000000000ULL,
    0x511a000000000ULL,
    0xde71000000000ULL,
    0x7b4e800000000ULL,
    0x7de5c00000000ULL,
    0xd9fea00000000ULL,
    0x9b0c700000000ULL,
    0x558bf80000000ULL,
    0xb34f440000000ULL,
    0x71e0e60000000ULL,
    0x7bf6fb0000000ULL,
    0x1002e68000000ULL,
    0x6803fbc000000ULL,
    0x9c0e666000000ULL,
    0xa033b7000000ULL,
    0xf704469800000ULL,
    0x878b8b4400000ULL,
    0x20479eee00000ULL,
    0xc8697f0900000ULL,
    0xdab0206680000ULL,
    0x12e9b09ac0000ULL,
    0x1a755878a0000ULL,
    0xd543340510000ULL,
    0x54eb1ed878000ULL,
    0x6f79bf2e44000ULL,
    0x89c200f162000ULL,
    0x125000435000ULL,
    0x4454809c2c800ULL,
    0x6a94c044d0c00ULL,
    0xa43020d552200ULL,
    0xc29b0c81cb00ULL,
    0xecd55890f9d80ULL,
    0xa953345d83f40ULL,
    0x72131e5f413e0ULL,
    0x9ffdbf63e10f0ULL,
    0xee000088f9d88ULL,
    0x90000d983f4cULL,
    0xe68000d1413eeULL,
    0x5ac0001ae10fbULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x7000000000000ULL,
    0x6800000000000ULL,
    0x4400000000000ULL,
    0x3200000000000ULL,
    0x1900000000000ULL,
    0x5d80000000000ULL,
    0x5240000000000ULL,
    0x2b60000000000ULL,
    0x5c10000000000ULL,
    0xd998000000000ULL,
    0x7dc000000000ULL,
    0xcab2000000000ULL,
    0xa5a5000000000ULL,
    0x14bb800000000ULL,
    0x6aa3c00000000ULL,
    0xf232e00000000ULL,
    0x6466700000000ULL,
    0xfa90280000000ULL,
    0x3752cc0000000ULL,
    0x7f7c9a0000000ULL,
    0xf1802b0000000ULL,
    0x64471a8000000ULL,
    0xe063eb4000000ULL,
    0x6895fa6000000ULL,
    0xbe559b3000000ULL,
    0x3afdd20800000ULL,
    0x8fcb577400000ULL,
    0x392b483a00000ULL,
    0x97727c6d00000ULL,
    0xf585d2e780000ULL,
    0xb647577f40000ULL,
    0x896148ace0000ULL,
    0x5d1b7c1350000ULL,
    0xa814527d78000ULL,
    0x239d97608c000ULL,
    0xcada288dca000ULL,
    0xbd3bcca829000ULL,
    0xc2ed1afef1800ULL,
    0x145aebfdcac00ULL,
    0x4ffc7a4023600ULL,
    0x44435bfafcb00ULL,
    0x306cb2afcb480ULL,
    0x9092e7e9227c0ULL,
    0xe25b80ef7dd20ULL,
    0x24f3c0e98b570ULL,
    0xe0cae0484b488ULL,
    0x4faa7096627c4ULL,
    0x81ba28439dd2eULL,
    0xd12bccfadb577ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x7000000000000ULL,
    0x2800000000000ULL,
    0xcc00000000000ULL,
    0x4a00000000000ULL,
    0x6300000000000ULL,
    0x6e80000000000ULL,
    0x2640000000000ULL,
    0x3ee0000000000ULL,
    0xa170000000000ULL,
    0x4bf8000000000ULL,
    0x5bb4000000000ULL,
    0x845a000000000ULL,
    0x94ad000000000ULL,
    0xf597800000000ULL,
    0x198f400000000ULL,
    0x26c1e00000000ULL,
    0x1da2d00000000ULL,
    0xa81fb80000000ULL,
    0xe94c9c0000000ULL,
    0xaa61920000000ULL,
    0x2c37d50000000ULL,
    0xa796128000000ULL,
    0xbe8895c000000ULL,
    0x5e4ff26000000ULL,
    0x4aee45b000000ULL,
    0x7f724a4800000ULL,
    0x86fbd97c00000ULL,
    0xd03e580200000ULL,
    0xe59e4c1f00000ULL,
    0x81862aec80000ULL,
    0x22cf49f940000ULL,
    0xebad80b260000ULL,
    0xa91240e830000ULL,
    0x28ce60b198000ULL,
    0xa8a990cf84000ULL,
    0x579c58b7c2000ULL,
    0x56874c8429000ULL,
    0x724baa4ed5800ULL,
    0x70ed0914e6400ULL,
    0x347be0f274600ULL,
    0x247fd02d74900ULL,
    0xbc703821f3d80ULL,
    0xb877dca8bc0c0ULL,
    0x4e7a72b2d04a0ULL,
    0x4f780556e2d90ULL,
    0x8efe2acd73d88ULL,
    0x8c3b4951fc0ccULL,
    0xf7978000b04aeULL,
    0x68f40bed2d97ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0xd000000000000ULL,
    0x9800000000000ULL,
    0x6c00000000000ULL,
    0x1600000000000ULL,
    0x4500000000000ULL,
    0x5a80000000000ULL,
    0x77c0000000000ULL,
    0x93e0000000000ULL,
    0xc9d0000000000ULL,
    0x558000000000ULL,
    0xf794000000000ULL,
    0x1ef6000000000ULL,
    0x70eb000000000ULL,
    0x7e5a800000000ULL,
    0x2c18400000000ULL,
    0x21b7200000000ULL,
    0xe3cc700000000ULL,
    0xd9e5580000000ULL,
    0xf2d1640000000ULL,
    0x3ed5fa0000000ULL,
    0x38dd570000000ULL,
    0xc5d77a8000000ULL,
    0x235117c000000ULL,
    0xda965aa000000ULL,
    0x6076671000000ULL,
    0xe529823800000ULL,
    0xd2bf437c00000ULL,
    0xec4b582e00000ULL,
    0x4cae643900000ULL,
    0xaaf97af480000ULL,
    0xeaee178ec0000ULL,
    0xdd5adac760000ULL,
    0x7b95275710000ULL,
    0xf8fc227a38000ULL,
    0x7def731c84000ULL,
    0xd0d720eace000ULL,
    0x21dc70456f000ULL,
    0xe15d585814800ULL,
    0x3595649bb7400ULL,
    0xf1fbfa90c3a00ULL,
    0xe16257166b300ULL,
    0x7a1bfac79ef80ULL,
    0x84b25776fe540ULL,
    0x4943fad4e5020ULL,
    0xe626575c5c030ULL,
    0x9535fab31ef88ULL,
    0x8d0d57383e54cULL,
    0x6e8f7ab385022ULL,
    0x2dc5171b4c03dULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0xd000000000000ULL,
    0xb800000000000ULL,
    0x5400000000000ULL,
    0xce00000000000ULL,
    0x9300000000000ULL,
    0xa180000000000ULL,
    0xe340000000000ULL,
    0x7660000000000ULL,
    0x13b0000000000ULL,
    0xc838000000000ULL,
    0x6674000000000ULL,
    0xfa92000000000ULL,
    0x2fef000000000ULL,
    0x4fc800000000ULL,
    0xc05dc00000000ULL,
    0x8ecb200000000ULL,
    0x7f21100000000ULL,
    0x30d1880000000ULL,
    0xd50f7c0000000ULL,
    0xce88ba0000000ULL,
    0xcdd10000000ULL,
    0x4c2c3a8000000ULL,
    0x215411c000000ULL,
    0x5e4d1ae000000ULL,
    0x54ee011000000ULL,
    0x8972125800000ULL,
    0xd913bd4400000ULL,
    0x75ad089600000ULL,
    0xe612bcd700000ULL,
    0xee239ab780000ULL,
    0xe85cc1f440000ULL,
    0xc2c5b221e0000ULL,
    0x552f6df7f0000ULL,
    0x5d7a031d8000ULL,
    0xb8cd01584000ULL,
    0x1642a83d4a000ULL,
    0xc8ea6c3d6b000ULL,
    0x1b73323636800ULL,
    0xb819ad5d76c00ULL,
    0x652a00571da00ULL,
    0xaddb0046a7d00ULL,
    0x878e80f794280ULL,
    0x5c42c0656cac0ULL,
    0x2defa07236920ULL,
    0x7df8d04b7a7d0ULL,
    0x34d0a8c014288ULL,
    0x63056c512caccULL,
    0x698fb2b3d6926ULL,
    0xbf446dac8a7ddULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x3000000000000ULL,
    0xb800000000000ULL,
    0x400000000000ULL,
    0x3e00000000000ULL,
    0x3b00000000000ULL,
    0x2e80000000000ULL,
    0x8040000000000ULL,
    0x5a0000000000ULL,
    0x8df0000000000ULL,
    0x5178000000000ULL,
    0x8834000000000ULL,
    0xb216000000000ULL,
    0x1c25000000000ULL,
    0x6136800000000ULL,
    0xf592c00000000ULL,
    0x1bef200000000ULL,
    0x4355900000000ULL,
    0x6a0bf80000000ULL,
    0x6d0e3c0000000ULL,
    0xb980c60000000ULL,
    0x1cc2c90000000ULL,
    0x3cee468000000ULL,
    0xa7d409c000000ULL,
    0x774f66a000000ULL,
    0x492099f000000ULL,
    0x1cbc1e1800000ULL,
    0xf75d65f400000ULL,
    0x2c0b782600000ULL,
    0x7209fccf00000ULL,
    0x9901668880000ULL,
    0x1f81998f40000ULL,
    0x13c49e2d20000ULL,
    0x946ea5f2b0000ULL,
    0x189cd8e458000ULL,
    0x626fac4e84000ULL,
    0x7f9d3e504e000ULL,
    0x66e9f5ada1000ULL,
    0x72d80081f8800ULL,
    0xcac4001373c00ULL,
    0x6bee00a937a00ULL,
    0x1b5100a996500ULL,
    0x7e008031e4580ULL,
    0xdb07c0ce5c6c0ULL,
    0x3e81a0c38a9e0ULL,
    0x84350f9cfa50ULL,
    0xb9aad83964588ULL,
    0xb7faac811c6ccULL,
    0x5473be4eaa9e2ULL,
    0x9dbf35fb7fa53ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x1000000000000ULL,
    0x3800000000000ULL,
    0xac00000000000ULL,
    0xda00000000000ULL,
    0x3b00000000000ULL,
    0x7380000000000ULL,
    0xa40000000000ULL,
    0xbd60000000000ULL,
    0x9510000000000ULL,
    0x8d98000000000ULL,
    0xac54000000000ULL,
    0x77e000000000ULL,
    0xdd0f000000000ULL,
    0x6a84800000000ULL,
    0x4ec2400000000ULL,
    0xea5e00000000ULL,
    0x2137500000000ULL,
    0x7a6be80000000ULL,
    0x64958c0000000ULL,
    0xa0ddfa0000000ULL,
    0x90b01b0000000ULL,
    0x37277a8000000ULL,
    0xe87d5bc000000ULL,
    0xb8861a2000000ULL,
    0x31c84bd000000ULL,
    0x9328121800000ULL,
    0x767a977c00000ULL,
    0x6d8600c200000ULL,
    0x1f4b004700000ULL,
    0x33e2803180000ULL,
    0x25d9408d40000ULL,
    0xe63f602ce0000ULL,
    0x8bea100850000ULL,
    0x49d2889978000ULL,
    0x9c349c0804000ULL,
    0xa0edf24406000ULL,
    0x25dc7ee0b000ULL,
    0x3a75e8dd02800ULL,
    0xc78a8c6a89400ULL,
    0xac417a4ec7600ULL,
    0xc4665b0eae100ULL,
    0x619c9aa134880ULL,
    0x16550bba6f9c0ULL,
    0x8c71724497720ULL,
    0x868b8770d0870ULL,
    0xf4ce0888b4888ULL,
    0x85a2dc4b2f9ccULL,
    0x7ab612aa7772aULL,
    0xe425973f80871ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x5000000000000ULL,
    0xf800000000000ULL,
    0xe400000000000ULL,
    0x6200000000000ULL,
    0xdf00000000000ULL,
    0x8d80000000000ULL,
    0xfd40000000000ULL,
    0x160000000000ULL,
    0x2bd0000000000ULL,
    0xe558000000000ULL,
    0xd394000000000ULL,
    0xb2b6000000000ULL,
    0x9a83000000000ULL,
    0xdcc4800000000ULL,
    0xf226c00000000ULL,
    0xdbb2e00000000ULL,
    0xe202100000000ULL,
    0x1f01480000000ULL,
    0xad8edc0000000ULL,
    0xad4fea0000000ULL,
    0xf96a270000000ULL,
    0xcfdd6a8000000ULL,
    0x875fe7c000000ULL,
    0xc930aa000000ULL,
    0x3f3f379000000ULL,
    0x67cea25800000ULL,
    0xdda4fb7400000ULL,
    0xd9f2803a00000ULL,
    0x3ee5c0ab00000ULL,
    0x3196603780000ULL,
    0xadb4d09640000ULL,
    0x370ba816e0000ULL,
    0x7188cced90000ULL,
    0xb40a20bb8000ULL,
    0x1463fbda04000ULL,
    0x6558005b0e000ULL,
    0x1394005f87000ULL,
    0x92b600aa4a800ULL,
    0xca8300c0e1c00ULL,
    0x24c480a898600ULL,
    0x1626c0bd33d00ULL,
    0xb9b2e0c8c1280ULL,
    0x3d0210f8290c0ULL,
    0x92814838b8c20ULL,
    0x50cedcb9802b0ULL,
    0xac2feaa741288ULL,
    0xd2ba271a690ccULL,
    0x2a856a1458c22ULL,
    0x54cbe7ff102b5ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x1000000000000ULL,
    0x9800000000000ULL,
    0xd400000000000ULL,
    0x6e00000000000ULL,
    0x1f00000000000ULL,
    0xf80000000000ULL,
    0x4ac0000000000ULL,
    0x3de0000000000ULL,
    0x2b50000000000ULL,
    0x47d8000000000ULL,
    0x709c000000000ULL,
    0x9ab6000000000ULL,
    0x3687000000000ULL,
    0xf646800000000ULL,
    0x72afc00000000ULL,
    0xa573200000000ULL,
    0xdebd00000000ULL,
    0xe35ea80000000ULL,
    0xabd1440000000ULL,
    0xda9b7a0000000ULL,
    0x73babf0000000ULL,
    0xf20bfa8000000ULL,
    0xdd027f4000000ULL,
    0x1a865a2000000ULL,
    0xbc4a6f5000000ULL,
    0x2ba5d2b800000ULL,
    0xe9fbfb8400000ULL,
    0x6aa880d600000ULL,
    0x3174c09b00000ULL,
    0xc3e3a05980000ULL,
    0xec531091c0000ULL,
    0x3c5308c460000ULL,
    0x445954aa90000ULL,
    0x2058f21bb8000ULL,
    0xc65b2b0e0c000ULL,
    0x955ea86f0e000ULL,
    0x20d144678b000ULL,
    0x1b1b7ab6c8800ULL,
    0x367abf0fe4c00ULL,
    0x586bfa965ba00ULL,
    0x68927fad5f100ULL,
    0xebe5a64dd080ULL,
    0xf8866fad12540ULL,
    0xf94bd2dd70720ULL,
    0xe520fb69efeb0ULL,
    0x3bb800855d088ULL,
    0x5e0c00b8d2544ULL,
    0xd70e00cf1072aULL,
    0xe38b00587feb1ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x9000000000000ULL,
    0x2800000000000ULL,
    0x8400000000000ULL,
    0x9a00000000000ULL,
    0xfd00000000000ULL,
    0xd580000000000ULL,
    0xc5c0000000000ULL,
    0x5b60000000000ULL,
    0x3fb0000000000ULL,
    0x9d38000000000ULL,
    0x9874000000000ULL,
    0x3752000000000ULL,
    0x9c4b000000000ULL,
    0xb0a1800000000ULL,
    0xdbd5c00000000ULL,
    0xb602600000000ULL,
    0x2300b00000000ULL,
    0xd285680000000ULL,
    0x7d4e740000000ULL,
    0x6329e20000000ULL,
    0x251f090000000ULL,
    0x63e2628000000ULL,
    0xc7f5c9c000000ULL,
    0xe79382e000000ULL,
    0xf6abb95000000ULL,
    0x40d50ac800000ULL,
    0xc880bdd400000ULL,
    0x4043e05200000ULL,
    0xd6a5702900000ULL,
    0x70df080780000ULL,
    0x108ac42cc0000ULL,
    0x7c468a3ce0000ULL,
    0xe0ae7d8370000ULL,
    0x93d80009d8000ULL,
    0xa204005f04000ULL,
    0x910a00448a000ULL,
    0xab8f006e4f000ULL,
    0x32cb8069ab800ULL,
    0x5beac0645ac00ULL,
    0xabf1e036c9e00ULL,
    0x999e7001ea700ULL,
    0x1a68836f4880ULL,
    0x405b04dc10040ULL,
    0x5cceeaec6f6a0ULL,
    0x44e1cd9f340d0ULL,
    0x4f76e87974888ULL,
    0x7d0b4e4d004cULL,
    0xd00a02628f6a6ULL,
    0x880a7965440d9ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0xb000000000000ULL,
    0x800000000000ULL,
    0x2400000000000ULL,
    0xee00000000000ULL,
    0xcb00000000000ULL,
    0x1a80000000000ULL,
    0xdb40000000000ULL,
    0xd560000000000ULL,
    0xdab0000000000ULL,
    0xf538000000000ULL,
    0x67f4000000000ULL,
    0xf5a000000000ULL,
    0xa9c1000000000ULL,
    0x5a29800000000ULL,
    0x9d7c00000000ULL,
    0x708f200000000ULL,
    0x6e4c900000000ULL,
    0x5cefb80000000ULL,
    0x87754c0000000ULL,
    0x39157a0000000ULL,
    0x692aa10000000ULL,
    0x1f5efa8000000ULL,
    0x31c861c000000ULL,
    0x26225a6000000ULL,
    0x7bd2317000000ULL,
    0x798b426800000ULL,
    0x75cc2d5400000ULL,
    0xb826a08600000ULL,
    0x58db509f00000ULL,
    0xf700981c80000ULL,
    0x4889dc8440000ULL,
    0x8242c229e0000ULL,
    0x76ebedeef0000ULL,
    0x12718054d8000ULL,
    0xe093c06d04000ULL,
    0x8ced20d582000ULL,
    0xff79907fc5000ULL,
    0xf51c387d2b800ULL,
    0x13238c3952c00ULL,
    0x3253da3ec4a00ULL,
    0xc441f162ae500ULL,
    0x9e662e393180ULL,
    0xbef5bd526f1c0ULL,
    0x6cda98fa3c620ULL,
    0x8108dc2374bd0ULL,
    0xff8b421713188ULL,
    0xeacc2d422f1ccULL,
    0xa4a6a035dc62eULL,
    0xdc9b502284bdbULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x7000000000000ULL,
    0x6800000000000ULL,
    0x9c00000000000ULL,
    0x6e00000000000ULL,
    0x9f00000000000ULL,
    0xd380000000000ULL,
    0x1c40000000000ULL,
    0xcea0000000000ULL,
    0xd7f0000000000ULL,
    0xc978000000000ULL,
    0xa7bc000000000ULL,
    0x41da000000000ULL,
    0x134d000000000ULL,
    0x4523800000000ULL,
    0x5fbe400000000ULL,
    0x85d6a00000000ULL,
    0xe94c500000000ULL,
    0x5829e80000000ULL,
    0x1532ec0000000ULL,
    0x4910660000000ULL,
    0x862e290000000ULL,
    0xc231e68000000ULL,
    0x1691694000000ULL,
    0xec66c6e000000ULL,
    0x6792793000000ULL,
    0xe0e00e8800000ULL,
    0xc85f85ac00000ULL,
    0x420ca0e600000ULL,
    0xb901503300000ULL,
    0xc08a68b580000ULL,
    0xb9ccac6f40000ULL,
    0xb9e6c61b20000ULL,
    0x38d279c8b0000ULL,
    0xf3c00e3a58000ULL,
    0xecef85b30c000ULL,
    0xfe54a07582000ULL,
    0x490d504f41000ULL,
    0xe888680b21800ULL,
    0x45cdacd0bf400ULL,
    0xa7e7464e57200ULL,
    0xcfdd390103100ULL,
    0xbc4f2ee486c80ULL,
    0x9ea09573cdfc0ULL,
    0xaff0682cecae0ULL,
    0x4d71acde5ed50ULL,
    0x3dbd465906c88ULL,
    0x2cd039f08dfc4ULL,
    0x31ccae31ccae6ULL,
    0x15eed515eed57ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x5000000000000ULL,
    0xa800000000000ULL,
    0xbc00000000000ULL,
    0x6600000000000ULL,
    0x3b00000000000ULL,
    0x1b80000000000ULL,
    0x66c0000000000ULL,
    0x7460000000000ULL,
    0xfb0000000000ULL,
    0x5178000000000ULL,
    0x111c000000000ULL,
    0xf4aa000000000ULL,
    0xd7000000000ULL,
    0x2541800000000ULL,
    0x76a0400000000ULL,
    0x39d1200000000ULL,
    0x47c3100000000ULL,
    0x12eae80000000ULL,
    0x79f9a40000000ULL,
    0xa05bf20000000ULL,
    0x1804e10000000ULL,
    0x40ad28000000ULL,
    0x1207f14000000ULL,
    0xb1003ae000000ULL,
    0xee8e551000000ULL,
    0xfa43c84800000ULL,
    0x6f26b4ac00000ULL,
    0x261b1aae00000ULL,
    0x312a45d700000ULL,
    0x2910a05580000ULL,
    0xc0a350a1c0000ULL,
    0xeadbc869e0000ULL,
    0x804ab40270000ULL,
    0x42291a9698000ULL,
    0x9e9145c46c000ULL,
    0x8632037b2000ULL,
    0x49b810657b000ULL,
    0x5a7968fb13800ULL,
    0xf292e451ab400ULL,
    0x866152345aa00ULL,
    0xaeb0b18204500ULL,
    0x77f09ab902480ULL,
    0x75d052286f40ULL,
    0x558000844a3a0ULL,
    0xa1c0005029550ULL,
    0x69e0002f9a488ULL,
    0x27000e6eaf44ULL,
    0x969800b3f83a6ULL,
    0xc46c003552555ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x3000000000000ULL,
    0xf800000000000ULL,
    0x6400000000000ULL,
    0xa200000000000ULL,
    0x7300000000000ULL,
    0xca80000000000ULL,
    0x3bc0000000000ULL,
    0x5ca0000000000ULL,
    0x1c70000000000ULL,
    0x33b8000000000ULL,
    0x1514000000000ULL,
    0xce6a000000000ULL,
    0x5d51000000000ULL,
    0x9c8a800000000ULL,
    0x2c6c00000000ULL,
    0xa92de00000000ULL,
    0xe338500000000ULL,
    0x19d6380000000ULL,
    0x2a4a640000000ULL,
    0xc1e2fe0000000ULL,
    0xa51d810000000ULL,
    0xf66f1e8000000ULL,
    0xd955d1c000000ULL,
    0xe81266000000ULL,
    0x89cbb5f000000ULL,
    0x7a9d89800000ULL,
    0x7af7349400000ULL,
    0x367446ba00000ULL,
    0xfcb0252700000ULL,
    0xc992801080000ULL,
    0xeca2c0ecc0000ULL,
    0x247fe0d420000ULL,
    0xb7bd5064b0000ULL,
    0x8716b85d98000ULL,
    0x456da456a4000ULL,
    0xf3dd9e0372000ULL,
    0x547112735000ULL,
    0x2d66c62bd8800ULL,
    0x7fd2e5b143c00ULL,
    0xeb4d60c76d600ULL,
    0x506f9050df900ULL,
    0xf8515807c9580ULL,
    0xaf04f48aa0f40ULL,
    0x2c8126e573260ULL,
    0x3acbb5263eb50ULL,
    0x2d29d85a51588ULL,
    0x713734dc04f4cULL,
    0x92d446e60126eULL,
    0x84c025010bb53ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x1000000000000ULL,
    0xf800000000000ULL,
    0xc00000000000ULL,
    0xca00000000000ULL,
    0x5300000000000ULL,
    0xef80000000000ULL,
    0x7ac0000000000ULL,
    0xde60000000000ULL,
    0x8b10000000000ULL,
    0xc5d8000000000ULL,
    0x3dbc000000000ULL,
    0x9fa6000000000ULL,
    0xeff000000000ULL,
    0x520c800000000ULL,
    0xaf0a400000000ULL,
    0x6d89e00000000ULL,
    0xcdc8500000000ULL,
    0xfe8e80000000ULL,
    0x64dca40000000ULL,
    0x6d30120000000ULL,
    0x70ebcb0000000ULL,
    0x1159f28000000ULL,
    0x1cf39b4000000ULL,
    0x5d091a2000000ULL,
    0xd2833f5000000ULL,
    0x584708d800000ULL,
    0xce2bf45c00000ULL,
    0xa1347a9200000ULL,
    0x5aed2f4f00000ULL,
    0xf258005d80000ULL,
    0x1b7c0065c0000ULL,
    0xd3c6005be0000ULL,
    0xcaef00b2d0000ULL,
    0x4a54800c38000ULL,
    0xb77640c06c000ULL,
    0x9cfe04e1e000ULL,
    0x61e750eb53000ULL,
    0xa9dc68e7f2800ULL,
    0x7bae4e689400ULL,
    0x84a7f27e43600ULL,
    0x5709be72d100ULL,
    0x16c39a75b5880ULL,
    0xe4667f7ba2b40ULL,
    0x901a68b0f71a0ULL,
    0xce55e487003f0ULL,
    0x797372798d888ULL,
    0xd4c6dbbbceb44ULL,
    0xf36c7afee91aaULL,
    0x51912f6c533f1ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x3000000000000ULL,
    0x4800000000000ULL,
    0x9400000000000ULL,
    0xd600000000000ULL,
    0xa100000000000ULL,
    0x6580000000000ULL,
    0x7dc0000000000ULL,
    0x5fe0000000000ULL,
    0xd6b0000000000ULL,
    0x5978000000000ULL,
    0xf994000000000ULL,
    0x1fa2000000000ULL,
    0xb899000000000ULL,
    0x8a29800000000ULL,
    0xed52c00000000ULL,
    0x71cea00000000ULL,
    0xa5e1300000000ULL,
    0x1db3a80000000ULL,
    0xeff9d40000000ULL,
    0xded99a0000000ULL,
    0x6d0e190000000ULL,
    0xff8f3a8000000ULL,
    0x86cb29c000000ULL,
    0xa16692e000000ULL,
    0x65fffdf000000ULL,
    0xfdd488a800000ULL,
    0x1f8a246400000ULL,
    0x76c492fe00000ULL,
    0x8966fd0500000ULL,
    0xc1fd087b80000ULL,
    0x63d8e488c0000ULL,
    0x2a8a328c60000ULL,
    0xc547cd3a70000ULL,
    0x55aea0ab18000ULL,
    0xfb913006e4000ULL,
    0xc8aba8af3a000ULL,
    0x2c1dd406bd000ULL,
    0xea639ae173800ULL,
    0x137319459fc00ULL,
    0xba9cbaeda5200ULL,
    0x5d24e9479af00ULL,
    0x79dbb23aac880ULL,
    0x11810dd31e240ULL,
    0x5bc2005ae6920ULL,
    0xd6e9002d3ffd0ULL,
    0x17318011b4888ULL,
    0xbab6c015fa24cULL,
    0x9374a015dc926ULL,
    0x7a9c30db82fd3ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x9000000000000ULL,
    0x800000000000ULL,
    0x6c00000000000ULL,
    0x7a00000000000ULL,
    0x7700000000000ULL,
    0x7480000000000ULL,
    0x9c0000000000ULL,
    0xabe0000000000ULL,
    0xff90000000000ULL,
    0x5158000000000ULL,
    0xa634000000000ULL,
    0x4c6a000000000ULL,
    0x54db000000000ULL,
    0x1e7f800000000ULL,
    0x61cb400000000ULL,
    0x97e3e00000000ULL,
    0x6d91100000000ULL,
    0xda56180000000ULL,
    0xa0b2e40000000ULL,
    0x5ea60a0000000ULL,
    0xf1be0b0000000ULL,
    0x9f2fea8000000ULL,
    0xeff41bc000000ULL,
    0xc786726000000ULL,
    0xdb4dbf5000000ULL,
    0xd723986800000ULL,
    0xa3f2a43c00000ULL,
    0xcd826a9200000ULL,
    0x34405b8b00000ULL,
    0xc7a8128680000ULL,
    0xbc38efd2c0000ULL,
    0x6b63e0c560000ULL,
    0xc85110d150000ULL,
    0xebb6186638000ULL,
    0xb822e4ac64000ULL,
    0x737e0ac4d2000ULL,
    0x324a0b167f000ULL,
    0x2a5ea8dcd800ULL,
    0x33bf1b2de4400ULL,
    0xfc21f27a96600ULL,
    0x1572fffed1500ULL,
    0xa74a78c172780ULL,
    0x6528b4c94cb40ULL,
    0x58f3f29c21f20ULL,
    0x530dff4572ff0ULL,
    0x4287f8cf4a788ULL,
    0x74ccf45928b4cULL,
    0x306592caf3f2eULL,
    0xe6dcafd80dff9ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x9000000000000ULL,
    0x800000000000ULL,
    0x7c00000000000ULL,
    0x5a00000000000ULL,
    0x3300000000000ULL,
    0xb880000000000ULL,
    0x92c0000000000ULL,
    0x2fe0000000000ULL,
    0xafd0000000000ULL,
    0xdc18000000000ULL,
    0x447c000000000ULL,
    0x3be6000000000ULL,
    0xf9d7000000000ULL,
    0x8d1b800000000ULL,
    0x2bf2400000000ULL,
    0x3fa4e00000000ULL,
    0x51f6500000000ULL,
    0xdca6980000000ULL,
    0x417bd40000000ULL,
    0xa260ba0000000ULL,
    0x3c9d7f0000000ULL,
    0x42ba5a8000000ULL,
    0x2002f4000000ULL,
    0xa701422000000ULL,
    0xae8ebbd000000ULL,
    0x63c6982800000ULL,
    0xd06bd4ac00000ULL,
    0xa398baf200000ULL,
    0x8317fdf00000ULL,
    0x4fc45a6a80000ULL,
    0x626b2f9dc0000ULL,
    0xdc9cc2ed60000ULL,
    0x72bbfbde10000ULL,
    0x9a01f86378000ULL,
    0xd303c4d56c000ULL,
    0x8884c23a1e000ULL,
    0xac7fbcd7b000ULL,
    0x5be7f80065800ULL,
    0x89d4c40b99400ULL,
    0xb51f42e439600ULL,
    0xcff5bb1dc3100ULL,
    0x11a318ad61f80ULL,
    0x44f2947e13c40ULL,
    0xd21da737cc20ULL,
    0x58326f9d6bfb0ULL,
    0xa7c5a26619f88ULL,
    0x2e68eb477fc44ULL,
    0x1e98009b62c2aULL,
    0x35bc005f10fb9ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x5000000000000ULL,
    0xf800000000000ULL,
    0x1c00000000000ULL,
    0x6200000000000ULL,
    0x7700000000000ULL,
    0xf380000000000ULL,
    0x93c0000000000ULL,
    0xcb60000000000ULL,
    0x350000000000ULL,
    0x1998000000000ULL,
    0xf474000000000ULL,
    0x6a000000000ULL,
    0xe2d7000000000ULL,
    0xb55c800000000ULL,
    0x789f400000000ULL,
    0x16f2600000000ULL,
    0x392f900000000ULL,
    0xa4f6e80000000ULL,
    0x762c340000000ULL,
    0xab7bd20000000ULL,
    0xd7ecaf0000000ULL,
    0xef1bb28000000ULL,
    0x3b303fc000000ULL,
    0x743da6000000ULL,
    0x73204b9000000ULL,
    0xf7fce89800000ULL,
    0x1bab348c00000ULL,
    0x7dbf527a00000ULL,
    0x6007ef3b00000ULL,
    0x9003d2e980000ULL,
    0x1808af38c0000ULL,
    0x4c09b23ae0000ULL,
    0x9a033f7790000ULL,
    0x6b0d5ab978000ULL,
    0x918c0be8e4000ULL,
    0xe4c0082892000ULL,
    0x38e8e4eef3000ULL,
    0x90955a252e800ULL,
    0xd2f80bc6fc400ULL,
    0xf72a088124e00ULL,
    0x19ffe498f7d00ULL,
    0x16a9daa420080ULL,
    0xb5374b7478e40ULL,
    0x9a4068406d5a0ULL,
    0xa3a474c2dc0b0ULL,
    0x41b5320558088ULL,
    0xb20c7fd09ce4cULL,
    0x4f073a72ff5aeULL,
    0xf879b872f0b5ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x1000000000000ULL,
    0x4800000000000ULL,
    0xbc00000000000ULL,
    0x200000000000ULL,
    0xdf00000000000ULL,
    0xb880000000000ULL,
    0xb1c0000000000ULL,
    0xc860000000000ULL,
    0x77d0000000000ULL,
    0x8f18000000000ULL,
    0xcefc000000000ULL,
    0xc562000000000ULL,
    0xf85b000000000ULL,
    0xca53800000000ULL,
    0xed52400000000ULL,
    0x51dd600000000ULL,
    0x615100000000ULL,
    0xe771d80000000ULL,
    0x4921240000000ULL,
    0x1278720000000ULL,
    0xc2a5770000000ULL,
    0xb13f128000000ULL,
    0xc807674000000ULL,
    0xfc074a6000000ULL,
    0xe203035000000ULL,
    0xcf0bd82800000ULL,
    0xf08624ec00000ULL,
    0xdc9f2aa00000ULL,
    0xca6c377300000ULL,
    0xa8d1f27280000ULL,
    0x37903792c0000ULL,
    0x7f33f212e0000ULL,
    0xd0b374910000ULL,
    0x8f8072d7f8000ULL,
    0x454977e4ec000ULL,
    0x23a512a81a000ULL,
    0x94b0677277000ULL,
    0xfe4eca12a9800ULL,
    0x2d26435935400ULL,
    0xa47f38040ce00ULL,
    0x43a674e60c500ULL,
    0xc4b4ca2907380ULL,
    0x564143d98a740ULL,
    0x812eb8544eca0ULL,
    0xee7f345e26430ULL,
    0x20a22a56ff388ULL,
    0x7e3a139166744ULL,
    0x3880003654caeULL,
    0xf1c0000f51431ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x3000000000000ULL,
    0xa800000000000ULL,
    0x9400000000000ULL,
    0xde00000000000ULL,
    0x1100000000000ULL,
    0xf180000000000ULL,
    0xb8c0000000000ULL,
    0x9520000000000ULL,
    0xad70000000000ULL,
    0x9438000000000ULL,
    0x71d4000000000ULL,
    0x4d8e000000000ULL,
    0x32c5000000000ULL,
    0xfa23800000000ULL,
    0x7df0c00000000ULL,
    0x7576200000000ULL,
    0xc831b00000000ULL,
    0xabdde80000000ULL,
    0x1a88840000000ULL,
    0xee42460000000ULL,
    0xf962c90000000ULL,
    0x9f17e68000000ULL,
    0xada3b9c000000ULL,
    0xb83c2e2000000ULL,
    0x63da8df000000ULL,
    0x1e83808800000ULL,
    0xa840c06400000ULL,
    0xd46e20d600000ULL,
    0x2495b0b500000ULL,
    0xda6be88780000ULL,
    0xcd99843dc0000ULL,
    0x87efc6baa0000ULL,
    0xa7570904b0000ULL,
    0xe1c2467098000ULL,
    0xa0a2c9a464000ULL,
    0xf3b7e66c96000ULL,
    0x1c13b91e61000ULL,
    0xcf242eab95800ULL,
    0x3a7e8d5ae1c00ULL,
    0xe8b58094dba00ULL,
    0x4291c0f204700ULL,
    0x763a00308480ULL,
    0x7e1070a289f40ULL,
    0x54264822498e0ULL,
    0xa4fcf4bb6bfd0ULL,
    0x80f20ef410488ULL,
    0x36ff3d3b2df4cULL,
    0x13f068f47f8eaULL,
    0xc7d44a1bafd3ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x7000000000000ULL,
    0x8800000000000ULL,
    0x2c00000000000ULL,
    0x6600000000000ULL,
    0x7500000000000ULL,
    0xe380000000000ULL,
    0x2fc0000000000ULL,
    0xbaa0000000000ULL,
    0xeed0000000000ULL,
    0xea98000000000ULL,
    0xf3f4000000000ULL,
    0xd182000000000ULL,
    0x58cd000000000ULL,
    0x629800000000ULL,
    0x419d400000000ULL,
    0x6174200000000ULL,
    0x47c7f00000000ULL,
    0x26a5080000000ULL,
    0x60da940000000ULL,
    0xc390ee0000000ULL,
    0xfe79fb0000000ULL,
    0xa74d4e8000000ULL,
    0x67e34bc000000ULL,
    0xb23c66e000000ULL,
    0xf22e2fb000000ULL,
    0x5391806800000ULL,
    0xc679409c00000ULL,
    0x634e208e00000ULL,
    0x5deef02900000ULL,
    0x2936880d80000ULL,
    0x48aed476c0000ULL,
    0xf9d74e3f20000ULL,
    0x261a4bb410000ULL,
    0xd4b7e633b8000ULL,
    0x766e6ff2e4000ULL,
    0x8af42061ba000ULL,
    0x8407f0f5e9000ULL,
    0x9a0508d533800ULL,
    0x8b0a94b6a4400ULL,
    0x4288ee58dfa00ULL,
    0xe4dfb0797b00ULL,
    0xaa6f4e4478a80ULL,
    0xa4fe4bfc40240ULL,
    0xbd0de63d61c60ULL,
    0x6f876fa8749f0ULL,
    0x59c7a07a40a88ULL,
    0x37a3b0786424cULL,
    0xa95aa863fbc66ULL,
    0x8f5d24e98d9f7ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x9000000000000ULL,
    0xb800000000000ULL,
    0x9c00000000000ULL,
    0xc600000000000ULL,
    0xb500000000000ULL,
    0xab80000000000ULL,
    0x7940000000000ULL,
    0xc60000000000ULL,
    0x78b0000000000ULL,
    0xe278000000000ULL,
    0xc35c000000000ULL,
    0x6586000000000ULL,
    0x3847000000000ULL,
    0xe5e8800000000ULL,
    0x7efb400000000ULL,
    0x8e96200000000ULL,
    0x4022f00000000ULL,
    0x9f53880000000ULL,
    0x438d7c0000000ULL,
    0xbd4b6a0000000ULL,
    0x6668990000000ULL,
    0x23b5ca8000000ULL,
    0xd8f1294000000ULL,
    0x4b90622000000ULL,
    0x63aea5d000000ULL,
    0x5210809800000ULL,
    0xade7404c00000ULL,
    0x2af020de00000ULL,
    0x5c95f0b900000ULL,
    0x872308d580000ULL,
    0x63da3c5040000ULL,
    0x7e434a61e0000ULL,
    0x10e169b4f0000ULL,
    0x7570c2c598000ULL,
    0x67dc1582ac000ULL,
    0xf443a8ab9e000ULL,
    0x7be88c53ab000ULL,
    0x67f0627a16800ULL,
    0xcb1ea589e0400ULL,
    0xa86880f0f8a00ULL,
    0x62bb406f9eb00ULL,
    0x31762039ad280ULL,
    0x4dd2f02114cc0ULL,
    0xf4b88b36ec20ULL,
    0xd1617cf837150ULL,
    0x57356a29b5288ULL,
    0x513399f3f8cc4ULL,
    0x43b4a7910c2aULL,
    0x9fbd691f6c159ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x7000000000000ULL,
    0xe800000000000ULL,
    0xc400000000000ULL,
    0x3e00000000000ULL,
    0x4700000000000ULL,
    0xf480000000000ULL,
    0x83c0000000000ULL,
    0xdc60000000000ULL,
    0xb5d0000000000ULL,
    0x7498000000000ULL,
    0x3834000000000ULL,
    0x2306000000000ULL,
    0x7a89000000000ULL,
    0xccb800000000ULL,
    0x9ce5c00000000ULL,
    0xe011200000000ULL,
    0x2bf3d00000000ULL,
    0x476cd80000000ULL,
    0x935d040000000ULL,
    0x6a57b20000000ULL,
    0x19d3270000000ULL,
    0x4e95128000000ULL,
    0x613137c000000ULL,
    0xe08eeaa000000ULL,
    0xe5c6e3b000000ULL,
    0x9766004800000ULL,
    0xcb59007400000ULL,
    0x665380f600000ULL,
    0x93d1c0f300000ULL,
    0xdf97202280000ULL,
    0x16bad000c0000ULL,
    0xa9c75816e0000ULL,
    0xfd68c47110000ULL,
    0xa5e925c78000ULL,
    0x89d4f70e24000ULL,
    0xf69fca0bfe000ULL,
    0x3d3533376d000ULL,
    0xf28ad8fb55800ULL,
    0x58c4046e58c00ULL,
    0x1ae43207dca00ULL,
    0xfb12e7799f100ULL,
    0xcd7a32fdb6780ULL,
    0x79afe7674b140ULL,
    0xc2b7b2a7aa4a0ULL,
    0xefc327d5bdf30ULL,
    0xc66d12034e788ULL,
    0x9cd537a9af14cULL,
    0x5f10ea1ab44a2ULL,
    0x637be323c0f37ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0xb000000000000ULL,
    0x2800000000000ULL,
    0x1400000000000ULL,
    0x9200000000000ULL,
    0xbd00000000000ULL,
    0xa080000000000ULL,
    0xe40000000000ULL,
    0x94e0000000000ULL,
    0xe650000000000ULL,
    0x5d98000000000ULL,
    0x33bc000000000ULL,
    0x7d46000000000ULL,
    0x5f65000000000ULL,
    0x5f93800000000ULL,
    0x56b0c00000000ULL,
    0x41c6e00000000ULL,
    0x672db00000000ULL,
    0xcc79f80000000ULL,
    0xb960bc0000000ULL,
    0x2094620000000ULL,
    0x733daf0000000ULL,
    0x6307028000000ULL,
    0x5385df4000000ULL,
    0x85cb9a2000000ULL,
    0x8d2813f000000ULL,
    0x5d78e00800000ULL,
    0x7e4b0e400000ULL,
    0x3dd4781a00000ULL,
    0x7c597c1900000ULL,
    0x49f021a80000ULL,
    0x8939dfa740000ULL,
    0x6a0d9a2660000ULL,
    0xd10d131510000ULL,
    0x1e8b6049f8000ULL,
    0xad44702bac000ULL,
    0x276a983c3e000ULL,
    0x7398cc2e89000ULL,
    0x48b8fac54d800ULL,
    0x52c0639369c00ULL,
    0xfcac78d193600ULL,
    0x4db57c9db8700ULL,
    0x3e4102464c980ULL,
    0xfce0dfd0edcc0ULL,
    0x52581acc537a0ULL,
    0x7f98d32c9ca30ULL,
    0xa6be001d34988ULL,
    0xc9c900b801cc4ULL,
    0xc32d80cc0d7aaULL,
    0x7679c00e05a3bULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0xf000000000000ULL,
    0x6800000000000ULL,
    0xb400000000000ULL,
    0xfa00000000000ULL,
    0xcf00000000000ULL,
    0xb980000000000ULL,
    0x67c0000000000ULL,
    0x2760000000000ULL,
    0x3d70000000000ULL,
    0xf838000000000ULL,
    0xeb1c000000000ULL,
    0x61c6000000000ULL,
    0x1661000000000ULL,
    0x79f3800000000ULL,
    0xad7ac00000000ULL,
    0x803e600000000ULL,
    0x671e100000000ULL,
    0xb7c1c80000000ULL,
    0xff66940000000ULL,
    0x4177520000000ULL,
    0x4632bd0000000ULL,
    0xb61cb28000000ULL,
    0xa3476d4000000ULL,
    0x32289a2000000ULL,
    0xf65929b000000ULL,
    0xee6604800000ULL,
    0x22b2100400000ULL,
    0x535fc83200000ULL,
    0x6b948b00000ULL,
    0x70fad22b80000ULL,
    0xc5f57d1cc0000ULL,
    0xf37752e4e0000ULL,
    0x8d32bdd5b0000ULL,
    0x3d9cb246d8000ULL,
    0x4f876d01ac000ULL,
    0x3ec89af69e000ULL,
    0xd7e929c40d000ULL,
    0x923e60520d800ULL,
    0x5c1e109b07c00ULL,
    0x5441c8138be00ULL,
    0xa7a69430c5d00ULL,
    0xb7975242ec280ULL,
    0xa882bd14b2440ULL,
    0x9344b26a50fa0ULL,
    0xba2b6de0e6390ULL,
    0x12569a67b4288ULL,
    0x6ce4290dde444ULL,
    0x31b3e04a2efaaULL,
    0xa4d9d07a5b39fULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x5000000000000ULL,
    0xc800000000000ULL,
    0xec00000000000ULL,
    0x4200000000000ULL,
    0x1f00000000000ULL,
    0x7780000000000ULL,
    0xe5c0000000000ULL,
    0xe860000000000ULL,
    0xa950000000000ULL,
    0x7018000000000ULL,
    0x9c34000000000ULL,
    0x71c2000000000ULL,
    0x1e6f000000000ULL,
    0xb05f800000000ULL,
    0xe69f400000000ULL,
    0x9b72600000000ULL,
    0xf8e9100000000ULL,
    0x8f1da80000000ULL,
    0x7bbf540000000ULL,
    0x3c04e20000000ULL,
    0x4a062f0000000ULL,
    0x930b028000000ULL,
    0x658f7fc000000ULL,
    0x32c34ae000000ULL,
    0x73e27b9000000ULL,
    0xe92602800000ULL,
    0x8779107c00000ULL,
    0x42e5a8ea00000ULL,
    0xe41b54a300000ULL,
    0x6a3ee2fd80000ULL,
    0x68cd2f16c0000ULL,
    0x88ee825de0000ULL,
    0xb71b3f9390000ULL,
    0x6fb4aa0ff8000ULL,
    0xa0f2b40a4000ULL,
    0x330028c1ba000ULL,
    0x558f14570b000ULL,
    0xaac9025b85800ULL,
    0x57e07fc7c4400ULL,
    0xa09cca276fe00ULL,
    0xda7d3bd6d9500ULL,
    0x2a600099d0480ULL,
    0x765000a659040ULL,
    0x6798006f932a0ULL,
    0x29f400a5f46b0ULL,
    0x51a20043a8488ULL,
    0x5b3f008c3d04cULL,
    0x82478019c92a6ULL,
    0x65ab40c26f6b5ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0xd000000000000ULL,
    0xd800000000000ULL,
    0xf400000000000ULL,
    0x2e00000000000ULL,
    0x7300000000000ULL,
    0x1e80000000000ULL,
    0x6740000000000ULL,
    0x9f60000000000ULL,
    0xde70000000000ULL,
    0x7ab8000000000ULL,
    0x2f14000000000ULL,
    0xb7ce000000000ULL,
    0x3b2b000000000ULL,
    0xf79a800000000ULL,
    0x3f87c00000000ULL,
    0xc8cc200000000ULL,
    0xefa0900000000ULL,
    0xb5d9380000000ULL,
    0xe9652c0000000ULL,
    0x997d2a0000000ULL,
    0xea32850000000ULL,
    0xeb5d8a8000000ULL,
    0xee2ad5c000000ULL,
    0x761c122000000ULL,
    0x3c43a91000000ULL,
    0xbdeea0f800000ULL,
    0x1b3350e400000ULL,
    0x9cdb185600000ULL,
    0x6aeebc5700000ULL,
    0x33be92e880000ULL,
    0xdc9069e040000ULL,
    0x150c802fe0000ULL,
    0x2188c00a30000ULL,
    0xd3c0a05b58000ULL,
    0xad28504624000ULL,
    0x99988a16000ULL,
    0x70d7c3e4f000ULL,
    0xf084b214ec800ULL,
    0xb44ff958b8c00ULL,
    0x51e1381618a00ULL,
    0x61312c4c4c500ULL,
    0x11d32ab5ef980ULL,
    0xdf698537327c0ULL,
    0xbe7f0ac6d0320ULL,
    0xab915f7e3390ULL,
    0x271e327e37988ULL,
    0x9bc839b5567ccULL,
    0xe12d18152632aULL,
    0xaa91bc849c39dULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0xf000000000000ULL,
    0x2800000000000ULL,
    0xec00000000000ULL,
    0xca00000000000ULL,
    0x5100000000000ULL,
    0x1780000000000ULL,
    0xf1c0000000000ULL,
    0x6520000000000ULL,
    0xc750000000000ULL,
    0xd218000000000ULL,
    0xcc74000000000ULL,
    0x524a000000000ULL,
    0x5aed000000000ULL,
    0x3573800000000ULL,
    0x69cb400000000ULL,
    0x812ce00000000ULL,
    0xf159700000000ULL,
    0x911fc80000000ULL,
    0x4efdf40000000ULL,
    0x920cf60000000ULL,
    0x55049b0000000ULL,
    0xd181968000000ULL,
    0x9acfabc000000ULL,
    0xbab3e6000000ULL,
    0xcd1d6f3000000ULL,
    0x8cff604800000ULL,
    0x3f0230dc00000ULL,
    0x508b280200000ULL,
    0xb540844d00000ULL,
    0xce613ef580000ULL,
    0xa6306f4cc0000ULL,
    0x3cace038a0000ULL,
    0x619970a790000ULL,
    0x2bbfc840b8000ULL,
    0x646df40ae4000ULL,
    0xc734f6cd72000ULL,
    0xe3209bbdc9000ULL,
    0x8c5396ff21800ULL,
    0xac96ab6e52400ULL,
    0x1e32be9195600ULL,
    0xc8ab2f03bf300ULL,
    0x8f98000860a80ULL,
    0xacb400cd3fc40ULL,
    0xc0ea005227de0ULL,
    0x9c7d006bd41f0ULL,
    0xaa4b807558a88ULL,
    0x8eef40971bc4cULL,
    0xcb7ee0c5f5deeULL,
    0x36c0700c8d1ffULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0xb000000000000ULL,
    0xf800000000000ULL,
    0x3c00000000000ULL,
    0x4e00000000000ULL,
    0x1900000000000ULL,
    0x5680000000000ULL,
    0x7e40000000000ULL,
    0x6520000000000ULL,
    0xa750000000000ULL,
    0xe278000000000ULL,
    0xb52c000000000ULL,
    0xf5e000000000ULL,
    0x3679000000000ULL,
    0x8f28800000000ULL,
    0x9c52400000000ULL,
    0xbfe200000000ULL,
    0xf0edf00000000ULL,
    0xc8b6b80000000ULL,
    0xe14cac0000000ULL,
    0xaea4460000000ULL,
    0x5d9e9f0000000ULL,
    0x1e12fe8000000ULL,
    0xc0d2334000000ULL,
    0x5eb6b82000000ULL,
    0x344cacf000000ULL,
    0xee24465800000ULL,
    0xb6de9f8c00000ULL,
    0x9bb2fe3600000ULL,
    0x3cc2336500000ULL,
    0xc16eb83880000ULL,
    0x4170ac9740000ULL,
    0x30a2466ba0000ULL,
    0xec9b9f5510000ULL,
    0x9c9c7eb158000ULL,
    0x849573777c000ULL,
    0xa89e18d5a6000ULL,
    0xae9a1c1415000ULL,
    0x739c5eebd6800ULL,
    0x571183ff3b400ULL,
    0x7e5820358ea00ULL,
    0x54f8f01bc3b00ULL,
    0xdb603896ee980ULL,
    0x2277ec45b45c0ULL,
    0x552ae62dc47e0ULL,
    0x1f5d2ff3e9730ULL,
    0x7e7c667d38188ULL,
    0x4b266fba8f1c4ULL,
    0xee52c6184adeaULL,
    0x5cf5dfe82ac3bULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x9000000000000ULL,
    0x9800000000000ULL,
    0x3400000000000ULL,
    0xbe00000000000ULL,
    0x5900000000000ULL,
    0xff80000000000ULL,
    0x1fc0000000000ULL,
    0xae60000000000ULL,
    0xb770000000000ULL,
    0x118000000000ULL,
    0xc26c000000000ULL,
    0xdd7e000000000ULL,
    0xd61b000000000ULL,
    0x6cec800000000ULL,
    0x9134c00000000ULL,
    0xedb3a00000000ULL,
    0x92f2f00000000ULL,
    0x81d6a80000000ULL,
    0xce89a40000000ULL,
    0x3c4bea0000000ULL,
    0x93a2390000000ULL,
    0xc21d428000000ULL,
    0x2eb9d4000000ULL,
    0xf036a82000000ULL,
    0xb639a4d000000ULL,
    0xab33ea3800000ULL,
    0x42be39a400000ULL,
    0x387b42a600000ULL,
    0x7b9c9d2d00000ULL,
    0x24286180000ULL,
    0xb7d66496c0000ULL,
    0x7b8cca69e0000ULL,
    0xe9c8090cb0000ULL,
    0xfb664a0978000ULL,
    0x52fbc9581c000ULL,
    0x61df6abde6000ULL,
    0xfe8af982b7000ULL,
    0x3448e25872800ULL,
    0x3fae6d0b9fc00ULL,
    0x4812802827200ULL,
    0xe5efc0cbda300ULL,
    0x56bf20c983080ULL,
    0x567630aacc540ULL,
    0x1a9d087befc20ULL,
    0x5ba754dfb45d0ULL,
    0x8e1b4291f1888ULL,
    0xb8ec9da153944ULL,
    0x1f3c2853c8e2aULL,
    0xbcba64146e6d9ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x5000000000000ULL,
    0xf800000000000ULL,
    0xb400000000000ULL,
    0x1200000000000ULL,
    0x3900000000000ULL,
    0x2d80000000000ULL,
    0x4bc0000000000ULL,
    0xa1e0000000000ULL,
    0xc8f0000000000ULL,
    0xf118000000000ULL,
    0x3dec000000000ULL,
    0xd6fe000000000ULL,
    0xce17000000000ULL,
    0x6b66800000000ULL,
    0x71bac00000000ULL,
    0xbdbd600000000ULL,
    0x5bb4300000000ULL,
    0xd0b3880000000ULL,
    0x943f040000000ULL,
    0xa70920000000ULL,
    0x5450190000000ULL,
    0x2f431a8000000ULL,
    0x2faf1d4000000ULL,
    0xced3882000000ULL,
    0x6e0f041000000ULL,
    0xd708925800000ULL,
    0xba8c19e400000ULL,
    0x51451a6a00000ULL,
    0xa0a41dcd00000ULL,
    0x9053081f80000ULL,
    0xd54ec462c0000ULL,
    0xfaad72d460000ULL,
    0x1555e96730000ULL,
    0xf6cd723af8000ULL,
    0xd665e9381c000ULL,
    0x635723866000ULL,
    0x7379e9913b000ULL,
    0xd9d372e9f8800ULL,
    0x3482e9989dc00ULL,
    0x764bf24c23e00ULL,
    0xb22f294212f00ULL,
    0x8d1012ad68e80ULL,
    0xd3e1d9eab0340ULL,
    0x41fefa213b9a0ULL,
    0xd49aed61f2dd0ULL,
    0x6a25e04490688ULL,
    0x2919f0722df44ULL,
    0x99e8686d187aaULL,
    0x9cf1f423e02d5ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x3000000000000ULL,
    0x9800000000000ULL,
    0x3c00000000000ULL,
    0xe200000000000ULL,
    0xbb00000000000ULL,
    0x6c80000000000ULL,
    0x7a40000000000ULL,
    0xa0a0000000000ULL,
    0x70b0000000000ULL,
    0xcc18000000000ULL,
    0xcea4000000000ULL,
    0x71ba000000000ULL,
    0x479d000000000ULL,
    0xa6e800000000ULL,
    0x8850400000000ULL,
    0xc700e00000000ULL,
    0x2e83100000000ULL,
    0x9141380000000ULL,
    0x642f8c0000000ULL,
    0xaef1be0000000ULL,
    0xb2bbb90000000ULL,
    0xe710868000000ULL,
    0x6a2435c000000ULL,
    0x9ff938e000000ULL,
    0xa13b8cf000000ULL,
    0x1fd3bef800000ULL,
    0x71c2b90c00000ULL,
    0xa46406fa00000ULL,
    0xe959754700000ULL,
    0x7c8f586e80000ULL,
    0x724cdc3140000ULL,
    0x54a8663420000ULL,
    0x6b32506f0000ULL,
    0x311a0096b8000ULL,
    0xc72d00f914000ULL,
    0x3e76805322000ULL,
    0x4af4407879000ULL,
    0xccbae02ff4800ULL,
    0xee1e10f93d400ULL,
    0x15afb843d6600ULL,
    0x2d3fcca3c7500ULL,
    0xa5d15e8763d80ULL,
    0x96c8a9b9d59c0ULL,
    0x1ae9be64c4060ULL,
    0xb01fb9a9e9750ULL,
    0x8caa86a897588ULL,
    0x9ab93540e8dccULL,
    0x8317b82712666ULL,
    0xd42bcc0a2e253ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x1000000000000ULL,
    0x6800000000000ULL,
    0x7400000000000ULL,
    0x7200000000000ULL,
    0x8b00000000000ULL,
    0x7f80000000000ULL,
    0x3140000000000ULL,
    0x4320000000000ULL,
    0x8870000000000ULL,
    0x4958000000000ULL,
    0x722c000000000ULL,
    0x38f2000000000ULL,
    0x6d9f000000000ULL,
    0x874b800000000ULL,
    0xe223c00000000ULL,
    0x10f7600000000ULL,
    0x7990100000000ULL,
    0xe542880000000ULL,
    0x1268c0000000ULL,
    0x1b7fb60000000ULL,
    0x3adc7d0000000ULL,
    0x2d653e8000000ULL,
    0xf6d6f14000000ULL,
    0x636888e000000ULL,
    0xbd58c5000000ULL,
    0x9de6360800000ULL,
    0xd210bd6400000ULL,
    0x9601de9a00000ULL,
    0xd10921bf00000ULL,
    0xe08f60ed80000ULL,
    0x2ccc10ea40000ULL,
    0x91688834a0000ULL,
    0xc0d58cdd30000ULL,
    0x8266361078000ULL,
    0xf350bd055c000ULL,
    0xbd21defc2a000ULL,
    0x2d7921e5f3000ULL,
    0xdbd7606319800ULL,
    0xd5e010668cc00ULL,
    0xd61a8895c4e00ULL,
    0x9c0a8c05efd00ULL,
    0x460db69e1fe80ULL,
    0x99037d98059c0ULL,
    0xe48ebecc04be0ULL,
    0x26c5314e06310ULL,
    0x667e87d06688ULL,
    0xb9599cbe895c4ULL,
    0x4a2ebeb9c05e6ULL,
    0x44f5311be9e11ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0xf000000000000ULL,
    0x5800000000000ULL,
    0x1c00000000000ULL,
    0x6a00000000000ULL,
    0xff00000000000ULL,
    0xe980000000000ULL,
    0x240000000000ULL,
    0x5ea0000000000ULL,
    0xc5f0000000000ULL,
    0x458000000000ULL,
    0x3824000000000ULL,
    0xb63e000000000ULL,
    0x64b5000000000ULL,
    0x397e800000000ULL,
    0xd092400000000ULL,
    0xad4e600000000ULL,
    0xdf2dd00000000ULL,
    0xa3b8280000000ULL,
    0xdcfb5c0000000ULL,
    0x30dcde0000000ULL,
    0xb8e9bd0000000ULL,
    0xdd5af68000000ULL,
    0x2ca7e1c000000ULL,
    0xc6f8a8a000000ULL,
    0x57dc1c3000000ULL,
    0x6d6c3e7800000ULL,
    0x45162dec00000ULL,
    0xd50cbeb200000ULL,
    0xf6816d2300000ULL,
    0x3bc45e2380000ULL,
    0xf4eafdcd40000ULL,
    0xdf54164f20000ULL,
    0xb7ad71ebb0000ULL,
    0xa97060c8f8000ULL,
    0x9898d02ed4000ULL,
    0x3946a849e6000ULL,
    0x1291c4dd1000ULL,
    0x72b2be0a60800ULL,
    0xbc746d9097400ULL,
    0x4e1adecd48e00ULL,
    0xf288bdcf2b900ULL,
    0xadc276abb0480ULL,
    0xb1e4a1a8f78c0ULL,
    0x61d648bedc760ULL,
    0x18668c01e1a10ULL,
    0x839cf6d9d0c88ULL,
    0x96c6e1d460cccULL,
    0xee6028c194962ULL,
    0xd69f5cedca31fULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0xf000000000000ULL,
    0xa800000000000ULL,
    0x3400000000000ULL,
    0x1200000000000ULL,
    0xbd00000000000ULL,
    0xb380000000000ULL,
    0x50c0000000000ULL,
    0x620000000000ULL,
    0x14d0000000000ULL,
    0xd7f8000000000ULL,
    0xbca4000000000ULL,
    0x259a000000000ULL,
    0x5c11000000000ULL,
    0xedd1800000000ULL,
    0x1e7bc00000000ULL,
    0x56f600000000ULL,
    0x7235700000000ULL,
    0xd08280000000ULL,
    0xbb85d40000000ULL,
    0xf4c05e0000000ULL,
    0x4c2ca70000000ULL,
    0x35d2768000000ULL,
    0x427873c000000ULL,
    0x4363a8e000000ULL,
    0x2d3f143000000ULL,
    0xab86bec800000ULL,
    0x6cc617c400000ULL,
    0xb02f3e3a00000ULL,
    0xe3d9d74900000ULL,
    0x457a5e4180000ULL,
    0x79eda7ddc0000ULL,
    0xdc7bf6fda0000ULL,
    0x4067b34010000ULL,
    0xcdb6c88bd8000ULL,
    0x23cb641174000ULL,
    0x8ea7169be2000ULL,
    0xc89c03c975000ULL,
    0xd79a0047eb800ULL,
    0xd111004f7ac00ULL,
    0x965180f8e6e00ULL,
    0x8abbc0d9fab00ULL,
    0xb94f60e7a5480ULL,
    0xefe5705915a40ULL,
    0x7b7028f25bf60ULL,
    0xeae1d4a0b7b30ULL,
    0x64fa5e684ec88ULL,
    0x542da7d26f64cULL,
    0x9dbf630bd166ULL,
    0xf477b3304d03fULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0xb000000000000ULL,
    0x3800000000000ULL,
    0x9400000000000ULL,
    0x2a00000000000ULL,
    0x7700000000000ULL,
    0xc880000000000ULL,
    0x2740000000000ULL,
    0xcf60000000000ULL,
    0x42d0000000000ULL,
    0xeb8000000000ULL,
    0xdee4000000000ULL,
    0x5812000000000ULL,
    0xa51d000000000ULL,
    0x8a9c800000000ULL,
    0xd50c00000000ULL,
    0xf97ae00000000ULL,
    0xf2c7500000000ULL,
    0x77a8380000000ULL,
    0x32739c0000000ULL,
    0x2c42920000000ULL,
    0xf1e7430000000ULL,
    0x7498aa8000000ULL,
    0x7059dfc000000ULL,
    0x16feb86000000ULL,
    0x950a5c7000000ULL,
    0x338ef2d800000ULL,
    0x1c9d32400000ULL,
    0x3d24f29200000ULL,
    0x9e30d32300000ULL,
    0x1daa728280000ULL,
    0x657d132040000ULL,
    0xb4cc125fe0000ULL,
    0x5eaa838190000ULL,
    0x17fecab3d8000ULL,
    0x8c8e4f0f34000ULL,
    0x454c60ec2a000ULL,
    0xf46e90cfb9000ULL,
    0x845c58276e800ULL,
    0x4cf90c9eddc00ULL,
    0x3a0cca68be600ULL,
    0xdf034fa7e3900ULL,
    0x3488e07598d80ULL,
    0x114a5069ddcc0ULL,
    0x3e6cb8603c2a0ULL,
    0x43575c60ad1f0ULL,
    0xbc72728af6588ULL,
    0x894913d3000ccULL,
    0x3a66129a824aeULL,
    0x15383e44e8fbULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x7000000000000ULL,
    0x8800000000000ULL,
    0x8400000000000ULL,
    0xe600000000000ULL,
    0xe500000000000ULL,
    0x4a80000000000ULL,
    0x25c0000000000ULL,
    0xfd60000000000ULL,
    0x1170000000000ULL,
    0xb518000000000ULL,
    0xe4ec000000000ULL,
    0x233e000000000ULL,
    0x8b35000000000ULL,
    0x3f33800000000ULL,
    0xf136c00000000ULL,
    0xe037200000000ULL,
    0xc4b9b00000000ULL,
    0x807b380000000ULL,
    0xd199540000000ULL,
    0x2c7a0000000ULL,
    0x2d3990000000ULL,
    0xd289428000000ULL,
    0xb9cfcd4000000ULL,
    0xc76eb82000000ULL,
    0x6e76943000000ULL,
    0xf096da2800000ULL,
    0xca9e9f400000ULL,
    0xb216daee00000ULL,
    0xed69e92100000ULL,
    0x976da8c80000ULL,
    0x6919e9f0c0000ULL,
    0x7eeeda1fe0000ULL,
    0x2c35e980b0000ULL,
    0x46b0da0678000ULL,
    0x5370e9a49c000ULL,
    0x861b5a92a6000ULL,
    0x636a291b19000ULL,
    0xb8727ae5ed800ULL,
    0x3d96991fb3c00ULL,
    0xb222c293fca00ULL,
    0xf9d50db4d3700ULL,
    0x7107980f8a180ULL,
    0xb48a241f49e40ULL,
    0x1cc66250a2c20ULL,
    0x2dea7d68150d0ULL,
    0x3bb380c267988ULL,
    0x85f6c0f4fa244ULL,
    0x99d7202d5e62aULL,
    0xe109b0fdc67d7ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0xf000000000000ULL,
    0x2800000000000ULL,
    0xc400000000000ULL,
    0x9a00000000000ULL,
    0x9b00000000000ULL,
    0xbf80000000000ULL,
    0x6040000000000ULL,
    0xf820000000000ULL,
    0x3b10000000000ULL,
    0xe238000000000ULL,
    0x4dac000000000ULL,
    0xf85e000000000ULL,
    0x199d000000000ULL,
    0x90f1800000000ULL,
    0xf48c00000000ULL,
    0x15a4e00000000ULL,
    0x5457900000000ULL,
    0xe79b880000000ULL,
    0x61f69c0000000ULL,
    0x3c3d60000000ULL,
    0xe66db0000000ULL,
    0x563e5e8000000ULL,
    0xbfa1474000000ULL,
    0x752082000000ULL,
    0xcc125cb000000ULL,
    0x43b9368800000ULL,
    0x8cec4b3400000ULL,
    0xd4f4563200000ULL,
    0xd54f1b1f00000ULL,
    0x2ead3e0580000ULL,
    0x1bdf174b40000ULL,
    0xafdae04fa0000ULL,
    0x5dda902f50000ULL,
    0xa2d2080818000ULL,
    0x77525cd9bc000ULL,
    0xa4193617e6000ULL,
    0x27bc4b6b71000ULL,
    0xe6ec56350f800ULL,
    0x67f31b9685c00ULL,
    0xaecb3e00cd600ULL,
    0xd4ee17fde3500ULL,
    0x78f5601879680ULL,
    0x2b4f502e800c0ULL,
    0xdfa7687ccfde0ULL,
    0x175d0c9be9870ULL,
    0xb41e5e2576e88ULL,
    0x5fb147cc05cc4ULL,
    0xfaea086e02beaULL,
    0x11fe5cc90ad7fULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x3000000000000ULL,
    0x3800000000000ULL,
    0xdc00000000000ULL,
    0xaa00000000000ULL,
    0x2900000000000ULL,
    0xb280000000000ULL,
    0x83c0000000000ULL,
    0xd660000000000ULL,
    0x6530000000000ULL,
    0x8058000000000ULL,
    0x86e4000000000ULL,
    0xbf2000000000ULL,
    0x42b5000000000ULL,
    0xeb14800000000ULL,
    0x2244400000000ULL,
    0xe626600000000ULL,
    0xb616b00000000ULL,
    0xceccf80000000ULL,
    0xd2ebf40000000ULL,
    0x85feaa0000000ULL,
    0xfdb32d0000000ULL,
    0xea98528000000ULL,
    0x209d9c000000ULL,
    0xdd00786000000ULL,
    0x2c8bb4f000000ULL,
    0xd4cacad800000ULL,
    0x3e09dec00000ULL,
    0xb782a1200000ULL,
    0xe4726d3500000ULL,
    0x2df2b27880000ULL,
    0x9bf295ac0000ULL,
    0x7498e03ce0000ULL,
    0x5503f0caf0000ULL,
    0x88c182438000ULL,
    0x42cc0426d4000ULL,
    0xb0e0b2ab2a000ULL,
    0xa8fa29b291000ULL,
    0x93460ae06800ULL,
    0xd253b06f01400ULL,
    0x93e078098ae00ULL,
    0x237bb4c446f00ULL,
    0xd072ca4d20980ULL,
    0x53f49d199c440ULL,
    0x6eb22a018cd20ULL,
    0x99136d204d990ULL,
    0xe74c32bb26188ULL,
    0xc6aa695a9d04cULL,
    0xc0d8007a0632eULL,
    0x2400210b693ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x1000000000000ULL,
    0xa800000000000ULL,
    0xb400000000000ULL,
    0xe600000000000ULL,
    0x1500000000000ULL,
    0x6380000000000ULL,
    0xf1c0000000000ULL,
    0xc5a0000000000ULL,
    0xedf0000000000ULL,
    0x6b58000000000ULL,
    0x682c000000000ULL,
    0xfd32000000000ULL,
    0x4b7f000000000ULL,
    0x7117800000000ULL,
    0x984bc00000000ULL,
    0x8b66200000000ULL,
    0xc4d2b00000000ULL,
    0x43efa80000000ULL,
    0xf92840000000ULL,
    0x8e09360000000ULL,
    0x810e8d0000000ULL,
    0xf58c9e8000000ULL,
    0x5ccf094000000ULL,
    0xba2028e000000ULL,
    0x4e35445000000ULL,
    0x5dfd16c800000ULL,
    0xf3533da400000ULL,
    0x42cb6ce00000ULL,
    0x173a4de100000ULL,
    0xa47d3e6580000ULL,
    0x559679b4c0000ULL,
    0xf909a0ee20000ULL,
    0xc98570f830000ULL,
    0x7ec38880f8000ULL,
    0xf1233434dc000ULL,
    0x24bb1ebbea000ULL,
    0x9db4c97393000ULL,
    0x343e084c05800ULL,
    0x5afbf49a04c00ULL,
    0x3d8be5709a00ULL,
    0x9362b93885700ULL,
    0xe8d800b343880ULL,
    0xc9ec00f1e3340ULL,
    0xf09200ac9b1e0ULL,
    0x28f003084c90ULL,
    0x544f80b746088ULL,
    0x5167c08fe7f44ULL,
    0xf3d420d592be6ULL,
    0x6b6db0b901b91ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x7000000000000ULL,
    0xa800000000000ULL,
    0x9c00000000000ULL,
    0xea00000000000ULL,
    0xbf00000000000ULL,
    0x5480000000000ULL,
    0x1240000000000ULL,
    0x33a0000000000ULL,
    0xd590000000000ULL,
    0x4738000000000ULL,
    0x2f2c000000000ULL,
    0x6bd2000000000ULL,
    0x5699000000000ULL,
    0xa9b1800000000ULL,
    0x3a69400000000ULL,
    0x48f2600000000ULL,
    0x4f46d00000000ULL,
    0x142ef80000000ULL,
    0xc15f8c0000000ULL,
    0x9dd18e0000000ULL,
    0x4398fb0000000ULL,
    0x2235768000000ULL,
    0xca2774000000ULL,
    0xc11f78e000000ULL,
    0x3576cc3000000ULL,
    0x6c83eec800000ULL,
    0x164e2bec00000ULL,
    0x8da38ec200000ULL,
    0x6c91fb6300000ULL,
    0xeebcf65e80000ULL,
    0x4ae7379d40000ULL,
    0xf4bf182f20000ULL,
    0x1de91c6bd0000ULL,
    0x5c3c965698000ULL,
    0x95a8e7a9bc000ULL,
    0x789860ba6a000ULL,
    0x88b3d008f5000ULL,
    0xc7ed782f43800ULL,
    0x2b3fcc6420400ULL,
    0x2d2a6e695be00ULL,
    0x28db6b01d3900ULL,
    0x981bee2996980ULL,
    0xacf22bdd3c5c0ULL,
    0xc1498eb824f60ULL,
    0x6524fbe35b370ULL,
    0x84df764ed5188ULL,
    0xba1777151c1c4ULL,
    0xfffcf8f37f166ULL,
    0xd7c68cb188a77ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0xd000000000000ULL,
    0x800000000000ULL,
    0x7c00000000000ULL,
    0x7200000000000ULL,
    0xc300000000000ULL,
    0x7380000000000ULL,
    0x5040000000000ULL,
    0x2de0000000000ULL,
    0x4030000000000ULL,
    0xfe58000000000ULL,
    0x5e2c000000000ULL,
    0x7596000000000ULL,
    0xcf87000000000ULL,
    0x4249800000000ULL,
    0x1ee5400000000ULL,
    0xebbde00000000ULL,
    0xda13900000000ULL,
    0x7dc0c80000000ULL,
    0x84a31c0000000ULL,
    0x8154ea0000000ULL,
    0x3fa4650000000ULL,
    0x16dda28000000ULL,
    0x49e2394000000ULL,
    0x2634a8a000000ULL,
    0xc355cc9000000ULL,
    0x44a9c22800000ULL,
    0xe154e9ac00000ULL,
    0xcfa980fa00000ULL,
    0xced540ff00000ULL,
    0x3de5e02180000ULL,
    0x283f904340000ULL,
    0x7256c85660000ULL,
    0xf4241c6c70000ULL,
    0xc29d6aa1b8000ULL,
    0xb20125dd1c000ULL,
    0xa30042784e000ULL,
    0x8381a981eb000ULL,
    0x884c60ba3f800ULL,
    0x59ead00152400ULL,
    0x4e33287fac600ULL,
    0x4f5b8c36dad00ULL,
    0xeeaba299eb280ULL,
    0x5655392e378c0ULL,
    0xb225283f5da20ULL,
    0x2f9c8c76a2390ULL,
    0xa082220254a88ULL,
    0x4bc0796c25cc4ULL,
    0xf1a0c81691c22ULL,
    0xc7d31c2c08e9dULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x3000000000000ULL,
    0x5800000000000ULL,
    0x7400000000000ULL,
    0x5e00000000000ULL,
    0xa100000000000ULL,
    0x2380000000000ULL,
    0x68c0000000000ULL,
    0xd720000000000ULL,
    0x1b50000000000ULL,
    0xdbf8000000000ULL,
    0xd664000000000ULL,
    0xabb2000000000ULL,
    0x2d05000000000ULL,
    0x198a800000000ULL,
    0x1fccc00000000ULL,
    0x49a1a00000000ULL,
    0x221a700000000ULL,
    0xef17680000000ULL,
    0xc695540000000ULL,
    0x815bee0000000ULL,
    0xbcf7ff0000000ULL,
    0xc0e6068000000ULL,
    0x8efe6bc000000ULL,
    0x6be4486000000ULL,
    0x8277e4f000000ULL,
    0xe9a726b800000ULL,
    0x3219db4400000ULL,
    0x6712008600000ULL,
    0xda95001500000ULL,
    0xf352809d80000ULL,
    0x37f8c0f9c0000ULL,
    0x1c6ba0aca0000ULL,
    0x64bb700790000ULL,
    0xf78fe852d8000ULL,
    0x26cc946c34000ULL,
    0xfe28ce53ca000ULL,
    0x24d54f93a1000ULL,
    0xc13acee518800ULL,
    0x8a404fe999c00ULL,
    0x6c684eebd3200ULL,
    0x1cb88f1bb2b00ULL,
    0x5383ee3504c80ULL,
    0x10c3ff4d8a240ULL,
    0x732c0611c6060ULL,
    0x2d5f6b40ae6b0ULL,
    0x56fcc84d9c488ULL,
    0xdfee245dd3e4cULL,
    0x3c740656b526eULL,
    0x78ab6b5c8cdb3ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x3000000000000ULL,
    0x5800000000000ULL,
    0x2400000000000ULL,
    0x5600000000000ULL,
    0x4100000000000ULL,
    0x4e80000000000ULL,
    0x40000000000ULL,
    0xe760000000000ULL,
    0x3370000000000ULL,
    0xc98000000000ULL,
    0xdeac000000000ULL,
    0xabda000000000ULL,
    0x2e45000000000ULL,
    0x1262800000000ULL,
    0xa3f9c00000000ULL,
    0x1dc200000000ULL,
    0x5d48f00000000ULL,
    0xabe8b80000000ULL,
    0x9c3c8c0000000ULL,
    0xf074e20000000ULL,
    0xad12690000000ULL,
    0x2566da8000000ULL,
    0x3c7b254000000ULL,
    0xc714186000000ULL,
    0xf664bc7000000ULL,
    0x55f8fab800000ULL,
    0x90dad51400000ULL,
    0x7bc4208e00000ULL,
    0xd7a4f02500000ULL,
    0x952b8f880000ULL,
    0xd4098c7140000ULL,
    0xae0e62f1e0000ULL,
    0xb507a91730000ULL,
    0x7080fa3df8000ULL,
    0x3d46d5ecdc000ULL,
    0xdbe62089c2000ULL,
    0x243df080a9000ULL,
    0xe47238e6d8800ULL,
    0xa3194caaccc00ULL,
    0x406ac21126a00ULL,
    0x24f399451d300ULL,
    0x8656e2996e980ULL,
    0x5f8b69ee717c0ULL,
    0x66c65a801eda0ULL,
    0x7b2be5d1e7250ULL,
    0x9610b80736188ULL,
    0x70e08c75fdbc4ULL,
    0xf9b6e200d87aeULL,
    0x6dbb69f3ca153ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0x5000000000000ULL,
    0xa800000000000ULL,
    0x3c00000000000ULL,
    0x3e00000000000ULL,
    0x6500000000000ULL,
    0x9280000000000ULL,
    0x4ac0000000000ULL,
    0xfe0000000000ULL,
    0x5290000000000ULL,
    0xd9f8000000000ULL,
    0xd8ac000000000ULL,
    0x8236000000000ULL,
    0x77cf000000000ULL,
    0x196b800000000ULL,
    0x925b400000000ULL,
    0xe11d200000000ULL,
    0xebb3300000000ULL,
    0xda82b80000000ULL,
    0x46cd640000000ULL,
    0xe9ef820000000ULL,
    0xf390bf0000000ULL,
    0xe17eba8000000ULL,
    0xf56a9b4000000ULL,
    0x445a18a000000ULL,
    0x9816141000000ULL,
    0x17359a8800000ULL,
    0x5d46ab6c00000ULL,
    0xe7ab201600000ULL,
    0xcfbc301900000ULL,
    0x4089388c80000ULL,
    0xf9c6247fc0000ULL,
    0xe46aa23560000ULL,
    0xe4df8f2450000ULL,
    0x51d2026818000ULL,
    0x2b54ffaf3c000ULL,
    0x7d901a694e000ULL,
    0x1c7eebf5a3000ULL,
    0x83eb809cbd800ULL,
    0xf49b409b04400ULL,
    0x58fd20978ea00ULL,
    0xb02330a844700ULL,
    0x7fab8bd29980ULL,
    0x8da164c971540ULL,
    0xc8b9828966ba0ULL,
    0xf90fbf5a569b0ULL,
    0xbc8d3a2d14188ULL,
    0xa7cddb6db5144ULL,
    0xf169388b881a2ULL,
    0x8e5624c642eb5ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x1000000000000ULL,
    0xd800000000000ULL,
    0x400000000000ULL,
    0x1600000000000ULL,
    0xe500000000000ULL,
    0x7880000000000ULL,
    0xb040000000000ULL,
    0x560000000000ULL,
    0x5c30000000000ULL,
    0x3fd8000000000ULL,
    0x4aac000000000ULL,
    0xea9a000000000ULL,
    0x7747000000000ULL,
    0xe6e8800000000ULL,
    0x5df3c00000000ULL,
    0x2878200000000ULL,
    0x8cbeb00000000ULL,
    0x39b980000000ULL,
    0x65ceec0000000ULL,
    0x51a3820000000ULL,
    0x1b10dd0000000ULL,
    0x85889a8000000ULL,
    0x6cc1f14000000ULL,
    0x5329386000000ULL,
    0x74589c5000000ULL,
    0xc76aba3800000ULL,
    0xd738411400000ULL,
    0x565a204e00000ULL,
    0x5c65b0a100000ULL,
    0x66b1188e80000ULL,
    0x44962c4540000ULL,
    0xc64922a5e0000ULL,
    0xb06aade870000ULL,
    0x1cbba2acb8000ULL,
    0x9b9e6db39c000ULL,
    0x81cb02cdc2000ULL,
    0x57a31dddab000ULL,
    0x2610bab112800ULL,
    0xf90f412284c00ULL,
    0xca8aa05f48a00ULL,
    0xb34a702ae1700ULL,
    0x50eb3897f9b80ULL,
    0x48f39cdf775c0ULL,
    0x98f83a07309a0ULL,
    0xe0fc812e5df10ULL,
    0x14f280286b388ULL,
    0xcaf4c0f8b39c4ULL,
    0xf3f0a09d983aeULL,
    0x997d70bccc811ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x1000000000000ULL,
    0x2800000000000ULL,
    0x3c00000000000ULL,
    0x9200000000000ULL,
    0xb700000000000ULL,
    0x6080000000000ULL,
    0xdc0000000000ULL,
    0xa820000000000ULL,
    0x310000000000ULL,
    0x2db8000000000ULL,
    0xea64000000000ULL,
    0xe272000000000ULL,
    0xfd47000000000ULL,
    0x4def800000000ULL,
    0x773f400000000ULL,
    0xaca3e00000000ULL,
    0x58dcd00000000ULL,
    0x5498b80000000ULL,
    0x80faf40000000ULL,
    0xaf89ae0000000ULL,
    0x594c7b0000000ULL,
    0xfbe6968000000ULL,
    0xb63dcfc000000ULL,
    0xed26d86000000ULL,
    0x49e64d000000ULL,
    0x88fd76c800000ULL,
    0x63851f2c00000ULL,
    0xf34c603a00000ULL,
    0x58e3904b00000ULL,
    0x78bb581280000ULL,
    0xc5e624aac0000ULL,
    0x7b3116e0a0000ULL,
    0xe6a68f32d0000ULL,
    0xebd7389798000ULL,
    0xb215b49e74000ULL,
    0x94324e4f4a000ULL,
    0x4224ab0ae3000ULL,
    0x80142eafbd800ULL,
    0x13343b7568400ULL,
    0xfaaaf63ef4600ULL,
    0x89de5fa287900ULL,
    0x3d1d8032c9580ULL,
    0xe0b840c4a1240ULL,
    0xe1ec6044de960ULL,
    0xd33903699cf0ULL,
    0xc7a3580ff4d88ULL,
    0xba5224db0964cULL,
    0xc65b16fa8af6eULL,
    0x74558f76ce5f1ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x3000000000000ULL,
    0x9800000000000ULL,
    0xc00000000000ULL,
    0x6e00000000000ULL,
    0x1500000000000ULL,
    0x5480000000000ULL,
    0xa5c0000000000ULL,
    0xd160000000000ULL,
    0x890000000000ULL,
    0x7878000000000ULL,
    0x71a4000000000ULL,
    0x857a000000000ULL,
    0x112d000000000ULL,
    0x12b6800000000ULL,
    0x1347400000000ULL,
    0xcfa9200000000ULL,
    0xf878300000000ULL,
    0xb1afd80000000ULL,
    0xe57c740000000ULL,
    0x2128da0000000ULL,
    0x8ab1370000000ULL,
    0x1f4b828000000ULL,
    0xa1a703c000000ULL,
    0xed7cf8e000000ULL,
    0xe52944f000000ULL,
    0x40b182f800000ULL,
    0xf04a033c00000ULL,
    0x822a787600000ULL,
    0x673e04d900000ULL,
    0xd000a25a80000ULL,
    0x68063380c0000ULL,
    0xf407a09de0000ULL,
    0x520b706150000ULL,
    0xe304f8a718000ULL,
    0x4d8d445c34000ULL,
    0x9f4b823182000ULL,
    0x61a703c949000ULL,
    0x8d7cf8a8ac800ULL,
    0xd52944dffa400ULL,
    0xd8b18291e7a00ULL,
    0xfc4a030f5b700ULL,
    0xec2a78321cf80ULL,
    0x723e04c8b9440ULL,
    0x8480a2f449820ULL,
    0xcdc633282e030ULL,
    0x2567a03830788ULL,
    0x5a9b70ab8304cULL,
    0x9b7cf88e4e226ULL,
    0x3c29449f25733ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0xd000000000000ULL,
    0x3800000000000ULL,
    0x5400000000000ULL,
    0x8a00000000000ULL,
    0x4300000000000ULL,
    0xba80000000000ULL,
    0xf140000000000ULL,
    0x9f20000000000ULL,
    0x8e70000000000ULL,
    0xb8d8000000000ULL,
    0x56c000000000ULL,
    0xa7d6000000000ULL,
    0xe9e7000000000ULL,
    0x39a800000000ULL,
    0xb94cc00000000ULL,
    0x6324e00000000ULL,
    0x487d100000000ULL,
    0xf5dfd80000000ULL,
    0x4ee39c0000000ULL,
    0xfb11960000000ULL,
    0xb7051d0000000ULL,
    0xa082ce8000000ULL,
    0xaa4d414000000ULL,
    0xa1ad38a000000ULL,
    0xcd398c9000000ULL,
    0x30f4ce1800000ULL,
    0xbb9a418400000ULL,
    0xad4fb83200000ULL,
    0xc9294c5700000ULL,
    0xdb7e2e1080000ULL,
    0x775c516240000ULL,
    0xeba4e09da0000ULL,
    0xee3d106b30000ULL,
    0x7a7fd88df8000ULL,
    0xa2d39c181c000ULL,
    0x5e69969d8e000ULL,
    0x99591d49cb000ULL,
    0xaaacce316c800ULL,
    0x8bb641dddbc00ULL,
    0x7b9b8c2e6600ULL,
    0x69be4c951dd00ULL,
    0x68bcaeb60d380ULL,
    0x2d3c91e5098c0ULL,
    0x80f600878cce0ULL,
    0x73970012c6410ULL,
    0x1142808fe1b88ULL,
    0x2f20c0de924c4ULL,
    0x4672e0eacaae2ULL,
    0x4da10bbeb91dULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x7000000000000ULL,
    0xa800000000000ULL,
    0x5c00000000000ULL,
    0x2200000000000ULL,
    0x2b00000000000ULL,
    0xaa80000000000ULL,
    0xd340000000000ULL,
    0x3a20000000000ULL,
    0xd1b0000000000ULL,
    0xf0d8000000000ULL,
    0x774c000000000ULL,
    0x3c2a000000000ULL,
    0xbcb9000000000ULL,
    0xd755800000000ULL,
    0xf383400000000ULL,
    0x2acde00000000ULL,
    0x27e9900000000ULL,
    0x9ed5980000000ULL,
    0xe640dc0000000ULL,
    0xa9ad760000000ULL,
    0xcb70290000000ULL,
    0x9f350e8000000ULL,
    0xc599654000000ULL,
    0x506de06000000ULL,
    0x6219903000000ULL,
    0x94ad984800000ULL,
    0x94fcdc2c00000ULL,
    0x7fff768a00000ULL,
    0x7575297700000ULL,
    0x36328e0880000ULL,
    0xd41f25b840000ULL,
    0xf1a780f0a0000ULL,
    0x7f764032f0000ULL,
    0x1326082f8000ULL,
    0xbc93d08afc000ULL,
    0x79edf846f2000ULL,
    0x47da0cbcf5000ULL,
    0x5fcd0e63ff800ULL,
    0x546565b77a400ULL,
    0xf41fe0ed38600ULL,
    0x21ac90969ad00ULL,
    0x4772189ee0780ULL,
    0x85369c17554c0ULL,
    0x6a9f16538aee0ULL,
    0x2ce3f9bac5f50ULL,
    0xe458f67fe7f88ULL,
    0xd03692ad30c4ULL,
    0x1780eef8408eeULL,
    0xccccf590aa257ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x5000000000000ULL,
    0xc800000000000ULL,
    0x1400000000000ULL,
    0xa200000000000ULL,
    0x6500000000000ULL,
    0x7480000000000ULL,
    0x22c0000000000ULL,
    0x2ce0000000000ULL,
    0x8090000000000ULL,
    0x96b8000000000ULL,
    0x26c4000000000ULL,
    0x26e6000000000ULL,
    0x19f000000000ULL,
    0xd831800000000ULL,
    0xbd09c00000000ULL,
    0xc88d600000000ULL,
    0x64c3700000000ULL,
    0x73e8980000000ULL,
    0x4d18a40000000ULL,
    0x76f3820000000ULL,
    0xefe2b70000000ULL,
    0x9b167a8000000ULL,
    0x41f963c000000ULL,
    0x666d602000000ULL,
    0x1153709000000ULL,
    0xf9d0986800000ULL,
    0xd1ca44400000ULL,
    0x16f5826a00000ULL,
    0x1fedb77100000ULL,
    0x31ffa5680000ULL,
    0x9df4a387c0000ULL,
    0xd066007860000ULL,
    0xd65f003250000ULL,
    0xe85180d258000ULL,
    0x5b59c0e254000ULL,
    0x18d560da5e000ULL,
    0xb39770565b000ULL,
    0x1536982857800ULL,
    0x2d83a4fb56c00ULL,
    0xd0440248dce00ULL,
    0xf124777b9ab00ULL,
    0x31f29a813df80ULL,
    0x3e67d34f8fd40ULL,
    0x6d569895451a0ULL,
    0x1fd3a415a1130ULL,
    0x21c027b32788ULL,
    0x137077568d14cULL,
    0xebac9a07c7faaULL,
    0x683cd33860a35ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0xb000000000000ULL,
    0x7800000000000ULL,
    0x9c00000000000ULL,
    0x6e00000000000ULL,
    0x300000000000ULL,
    0xeb80000000000ULL,
    0xbf40000000000ULL,
    0x8ee0000000000ULL,
    0xf650000000000ULL,
    0x4bf8000000000ULL,
    0xb54c000000000ULL,
    0x3fe2000000000ULL,
    0x10dd000000000ULL,
    0xac34800000000ULL,
    0x1762400000000ULL,
    0x641d200000000ULL,
    0x4d93d00000000ULL,
    0xa7de080000000ULL,
    0x3db10c0000000ULL,
    0x412d3a0000000ULL,
    0x407fdb0000000ULL,
    0xfa0e128000000ULL,
    0xa90d074000000ULL,
    0xca8520e000000ULL,
    0xf1cfd0f000000ULL,
    0x3d24081800000ULL,
    0xde700c2c00000ULL,
    0xe103ba1600000ULL,
    0x6e8c9b9f00000ULL,
    0x63c5b20580000ULL,
    0xe02197fc40000ULL,
    0x4ef2888560000ULL,
    0x29cf4cb910000ULL,
    0x312a1add18000ULL,
    0x187d0b6f1c000ULL,
    0xb6069ae21a000ULL,
    0xf034b7a91000ULL,
    0x2d81baf656800ULL,
    0xe8419b4bff400ULL,
    0xef69323549a00ULL,
    0xb81fd77fe1900ULL,
    0x4395a8f0db280ULL,
    0x14dd9c5c3edc0ULL,
    0xae3a920f69320ULL,
    0x626f47481fd70ULL,
    0xa09800db95a88ULL,
    0xf5c0078dd9c4ULL,
    0x97a00d83a926ULL,
    0xc081004d6f47bULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0xf000000000000ULL,
    0x4800000000000ULL,
    0xe400000000000ULL,
    0xa200000000000ULL,
    0x4f00000000000ULL,
    0x6b80000000000ULL,
    0x6c40000000000ULL,
    0x29a0000000000ULL,
    0xf0f0000000000ULL,
    0x7718000000000ULL,
    0x514c000000000ULL,
    0x152a000000000ULL,
    0x4b31000000000ULL,
    0xccf3800000000ULL,
    0xc916c00000000ULL,
    0xf046600000000ULL,
    0x87abd00000000ULL,
    0xe9f7c80000000ULL,
    0x499dbc0000000ULL,
    0xb588be0000000ULL,
    0x7d47050000000ULL,
    0x1321168000000ULL,
    0x463d694000000ULL,
    0x1874606000000ULL,
    0x86d6d0b000000ULL,
    0x51ae48a800000ULL,
    0xfcfa7c1400000ULL,
    0x211d5eea00000ULL,
    0x44a15ab00000ULL,
    0x9da8be4980000ULL,
    0xaf7056340000ULL,
    0x6419162220000ULL,
    0x34c1692cb0000ULL,
    0x70666076b8000ULL,
    0xe41bd0f5bc000ULL,
    0x74cfc86832000ULL,
    0x9061bc417d000ULL,
    0x141abe5859800ULL,
    0x3cca054567c00ULL,
    0x7460965c95e00ULL,
    0xb616a9dd0d100ULL,
    0x73cb804c89a80ULL,
    0x1feac0b3ca6c0ULL,
    0xda5460bfed760ULL,
    0x5a66d0ca57b90ULL,
    0xef1648e268288ULL,
    0xad467c4311ac4ULL,
    0xb2f5eeb4a96eULL,
    0xfa3715e627a9fULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x5000000000000ULL,
    0x9800000000000ULL,
    0xb400000000000ULL,
    0xa600000000000ULL,
    0x1f00000000000ULL,
    0x6880000000000ULL,
    0x5ac0000000000ULL,
    0x57a0000000000ULL,
    0x5170000000000ULL,
    0xe218000000000ULL,
    0xfcc000000000ULL,
    0xd22e000000000ULL,
    0x2a3f000000000ULL,
    0x50f4800000000ULL,
    0x175ec00000000ULL,
    0x7e27200000000ULL,
    0x7830900000000ULL,
    0x49f9f80000000ULL,
    0x30d8e40000000ULL,
    0xd46e760000000ULL,
    0xc15bbd0000000ULL,
    0xe928ae8000000ULL,
    0x9cbfc94000000ULL,
    0x5131202000000ULL,
    0x4673901000000ULL,
    0x469b783800000ULL,
    0xb70524e400000ULL,
    0xf48bd63e00000ULL,
    0x20c6edab00000ULL,
    0x92acf64e80000ULL,
    0xacf67d05c0000ULL,
    0xdd550e1f20000ULL,
    0xd32e991bb0000ULL,
    0xf9bb780db8000ULL,
    0xfcb524fabc000ULL,
    0xe133d6ae36000ULL,
    0x2e7aeddef3000ULL,
    0x3a9af6545a800ULL,
    0x3d057d8ca1c00ULL,
    0xf98f8e97f3a00ULL,
    0xf14f596bde500ULL,
    0xbfe8d852e6d80ULL,
    0xc91b74e894740ULL,
    0x814d0e64018e0ULL,
    0x37e2997e00590ULL,
    0x4515788b04588ULL,
    0xc34a24de89b44ULL,
    0x16e7567dc42eaULL,
    0x86942ddb2d095ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x5000000000000ULL,
    0x800000000000ULL,
    0x3400000000000ULL,
    0x6e00000000000ULL,
    0xa300000000000ULL,
    0xd980000000000ULL,
    0xc9c0000000000ULL,
    0x23e0000000000ULL,
    0x7ef0000000000ULL,
    0x6ed8000000000ULL,
    0x8ec4000000000ULL,
    0x5c62000000000ULL,
    0xc03b000000000ULL,
    0xaabd800000000ULL,
    0x92f7c00000000ULL,
    0xfcdfa00000000ULL,
    0x97c3d00000000ULL,
    0x18e0280000000ULL,
    0x7b79c40000000ULL,
    0xad16820000000ULL,
    0x682ec10000000ULL,
    0x6c110a8000000ULL,
    0xd0a0d5c000000ULL,
    0x6d5da06000000ULL,
    0x4a08d09000000ULL,
    0xe505a8e800000ULL,
    0xfe8a046400000ULL,
    0x264b226600000ULL,
    0x7526119700000ULL,
    0xde94a23780000ULL,
    0x14ead1aac0000ULL,
    0xb976829a60000ULL,
    0xbc1ec12730000ULL,
    0x18a90a2538000ULL,
    0xb954d55434000ULL,
    0x7407a034ba000ULL,
    0x4e07d049ff000ULL,
    0x130228a95f800ULL,
    0x8182c45c0cc00ULL,
    0xf5cb02ca02200ULL,
    0x79e9012504100ULL,
    0xb3f6aa9e87880ULL,
    0x145705b64e140ULL,
    0x9e87881d2caa0ULL,
    0xb64e147a98050ULL,
    0x9d2caa92e0088ULL,
    0xba98057e76d4cULL,
    0x72e00883948aeULL,
    0x2e76d48663155ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x7000000000000ULL,
    0x1800000000000ULL,
    0xc00000000000ULL,
    0x2200000000000ULL,
    0xc500000000000ULL,
    0x1380000000000ULL,
    0x2a40000000000ULL,
    0x3d20000000000ULL,
    0x6e90000000000ULL,
    0xff8000000000ULL,
    0x1744000000000ULL,
    0x92aa000000000ULL,
    0x1ed1000000000ULL,
    0x8bde800000000ULL,
    0x5055400000000ULL,
    0x7e10e00000000ULL,
    0x53b700000000ULL,
    0x98a9e80000000ULL,
    0x6fdfdc0000000ULL,
    0xa65b160000000ULL,
    0xf5190b0000000ULL,
    0x81ba1e8000000ULL,
    0x7c69a7c000000ULL,
    0x673ae0e000000ULL,
    0xfdaa70b000000ULL,
    0x6c57687800000ULL,
    0xe41a9c7c00000ULL,
    0xdc33f63a00000ULL,
    0xc1267bc900000ULL,
    0x9499f6b180000ULL,
    0xa6f77b2f40000ULL,
    0x56c776cea0000ULL,
    0x65e23bf4d0000ULL,
    0x3c7796cad8000ULL,
    0xed094bc5d4000ULL,
    0xa7867e4752000ULL,
    0x1442977095000ULL,
    0xb22f68d0f4800ULL,
    0xac1e9c1dc4400ULL,
    0x1839f6816e600ULL,
    0xe7277ba8be300ULL,
    0x179f767de1080ULL,
    0x46763b3070ac0ULL,
    0x8405964f00fe0ULL,
    0x860c4ba283d70ULL,
    0x930afee7cd888ULL,
    0x8882d72860eccULL,
    0xc6cb08693c9e6ULL,
    0xcde1accaa8e77ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x5000000000000ULL,
    0xe800000000000ULL,
    0xac00000000000ULL,
    0xae00000000000ULL,
    0xa100000000000ULL,
    0x9080000000000ULL,
    0x54c0000000000ULL,
    0x9a20000000000ULL,
    0x9310000000000ULL,
    0xcf8000000000ULL,
    0xd4c000000000ULL,
    0xb262000000000ULL,
    0x93f3000000000ULL,
    0xf4c3800000000ULL,
    0xea20400000000ULL,
    0x4b16200000000ULL,
    0x18fdf00000000ULL,
    0xe741980000000ULL,
    0x1164840000000ULL,
    0xc750e0000000ULL,
    0x9189030000000ULL,
    0xb440b68000000ULL,
    0x16e3774000000ULL,
    0x1d37a0e000000ULL,
    0x75eeb01000000ULL,
    0xa2b4388800000ULL,
    0x20a934fc00000ULL,
    0x44dab64600000ULL,
    0x395c770d00000ULL,
    0x431620be80000ULL,
    0xa4fdf0b5c0000ULL,
    0xc141986aa0000ULL,
    0x4c648497d0000ULL,
    0xdaf50e7ed8000ULL,
    0xc84903325c000ULL,
    0x10e0b6909a000ULL,
    0x7033777fbf000ULL,
    0x1b6fa03621800ULL,
    0xbf72b03d13400ULL,
    0x860e38adf5a00ULL,
    0x2d06349dcdb00ULL,
    0xe8336e6afb80ULL,
    0x4dc33709d5740ULL,
    0x4ea180e7d6960ULL,
    0xc5d340a6de870ULL,
    0x99d5a02656388ULL,
    0xafddb0fa9a344ULL,
    0x7ad7b89cb9366ULL,
    0x50597449ac375ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x9000000000000ULL,
    0xa800000000000ULL,
    0x2400000000000ULL,
    0x9a00000000000ULL,
    0x100000000000ULL,
    0xe280000000000ULL,
    0x29c0000000000ULL,
    0xcd60000000000ULL,
    0x8b30000000000ULL,
    0x9098000000000ULL,
    0xf44000000000ULL,
    0x2eaa000000000ULL,
    0x8f5f000000000ULL,
    0x4d2b800000000ULL,
    0x8414c00000000ULL,
    0xc985e00000000ULL,
    0x524cb00000000ULL,
    0x7a22b80000000ULL,
    0xe997f40000000ULL,
    0xc1c56a0000000ULL,
    0x496a350000000ULL,
    0xe130328000000ULL,
    0xa99a71c000000ULL,
    0x61ce60e000000ULL,
    0xb968705000000ULL,
    0xd93f58c800000ULL,
    0x259f44b400000ULL,
    0xdfcdd23200000ULL,
    0x2262c12500000ULL,
    0x3abed8f880000ULL,
    0xeed484e8c0000ULL,
    0x3b63b24fe0000ULL,
    0x643ab132f0000ULL,
    0x21198075f8000ULL,
    0x710fc06074000ULL,
    0x1a84604432000ULL,
    0xc5c770111b000ULL,
    0xe36cd82901800ULL,
    0xb83f84068bc00ULL,
    0x571a32d3ce600ULL,
    0x5e05715c68700ULL,
    0xcb05e041bf580ULL,
    0x2b8cb05d5f440ULL,
    0x7f42b8382dd20ULL,
    0xd6a7f43492c10ULL,
    0x635d6a5546d88ULL,
    0x632e354fa084cULL,
    0xb71a327dd1b26ULL,
    0xe05710ce1b19ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x1000000000000ULL,
    0x7800000000000ULL,
    0x1c00000000000ULL,
    0x8600000000000ULL,
    0x2100000000000ULL,
    0x6080000000000ULL,
    0x3c40000000000ULL,
    0x80e0000000000ULL,
    0x9230000000000ULL,
    0xb618000000000ULL,
    0xc48c000000000ULL,
    0x64a000000000ULL,
    0xd7ef000000000ULL,
    0xbbb6800000000ULL,
    0x8ede400000000ULL,
    0xe225a00000000ULL,
    0xb390700000000ULL,
    0xb243180000000ULL,
    0x95e74c0000000ULL,
    0xf0b38a0000000ULL,
    0x21518d0000000ULL,
    0xfbe3b28000000ULL,
    0xf5b8f14000000ULL,
    0x3bd6806000000ULL,
    0x70ae405000000ULL,
    0x4cdda09800000ULL,
    0xe92c700c00000ULL,
    0xfc1118fe00000ULL,
    0xbb844c3d00000ULL,
    0xabcf0ae680000ULL,
    0x6520cd1d40000ULL,
    0x4210926060000ULL,
    0x6686c1ee70000ULL,
    0x5d483856f8000ULL,
    0x657c06bc000ULL,
    0xbe7f322852000ULL,
    0x4ef9b11f63000ULL,
    0x4abda0c3fc800ULL,
    0x365c702431400ULL,
    0x3269185f13200ULL,
    0xdd784c300e300ULL,
    0x657d0ac806b80ULL,
    0xd973cd94073c0ULL,
    0xaf74127208920ULL,
    0xe67b81830ac10ULL,
    0xe2f118bb82388ULL,
    0x44b44cabca7c4ULL,
    0x63570a6529b2eULL,
    0xb0eccd4217f11ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0xb000000000000ULL,
    0x800000000000ULL,
    0xfc00000000000ULL,
    0x5a00000000000ULL,
    0x4100000000000ULL,
    0x8480000000000ULL,
    0xa540000000000ULL,
    0x6a20000000000ULL,
    0x7bb0000000000ULL,
    0xc858000000000ULL,
    0x6884000000000ULL,
    0x874e000000000ULL,
    0xff29000000000ULL,
    0xe93b800000000ULL,
    0x7e17400000000ULL,
    0x3b2e600000000ULL,
    0x873fb00000000ULL,
    0xb91d580000000ULL,
    0x14ad9c0000000ULL,
    0xeffdb60000000ULL,
    0xefa790000000ULL,
    0xfa750e8000000ULL,
    0x773f15c000000ULL,
    0x511b80a000000ULL,
    0x78a7407000000ULL,
    0xdf6602800000ULL,
    0xbbfbb04c00000ULL,
    0xd8f3585200000ULL,
    0xc9749cbd00000ULL,
    0xfebe36de80000ULL,
    0x22d939e440000ULL,
    0xacd6e6ea0000ULL,
    0xc2eda51ef0000ULL,
    0xec53580278000ULL,
    0x96849c6334000ULL,
    0xf846366716000ULL,
    0x24ad39dbad000ULL,
    0x27fb6ebc75800ULL,
    0xd2f0a5fc3e400ULL,
    0x107ed8ac95e00ULL,
    0x3e3edc6d68f00ULL,
    0x299dd64493380ULL,
    0x87ecc901622c0ULL,
    0x26d3d62698ee0ULL,
    0x44c5c97463e50ULL,
    0xb5e856241eb88ULL,
    0xcbd2897a286ccULL,
    0x2463683bb0e2ULL,
    0x15ad39dc5615bULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0xd000000000000ULL,
    0x9800000000000ULL,
    0xc400000000000ULL,
    0x600000000000ULL,
    0xb00000000000ULL,
    0x4f80000000000ULL,
    0x3540000000000ULL,
    0x5260000000000ULL,
    0xb170000000000ULL,
    0x3dd8000000000ULL,
    0xdd84000000000ULL,
    0x604e000000000ULL,
    0xf2ef000000000ULL,
    0x1db4800000000ULL,
    0xc9fdc00000000ULL,
    0xb518200000000ULL,
    0xdfa6d00000000ULL,
    0x4bd7480000000ULL,
    0x5e892c0000000ULL,
    0x53c2b20000000ULL,
    0xd5a9910000000ULL,
    0xdad95a8000000ULL,
    0xf80badc000000ULL,
    0xf40c80a000000ULL,
    0x6e09c01000000ULL,
    0x870e20b800000ULL,
    0x158dd01400000ULL,
    0xfc4dc89e00000ULL,
    0x10ebeccf00000ULL,
    0xc0b6124980000ULL,
    0x1576813e40000ULL,
    0xbd8329de0000ULL,
    0xbe8b514430000ULL,
    0xa3cdfacfb8000ULL,
    0x9da4bd7cf4000ULL,
    0x86d5e86596000ULL,
    0x3a0d3cfb6b000ULL,
    0xf9015ac3fa800ULL,
    0x2a8fad2412c00ULL,
    0xfdc280f92ca00ULL,
    0x72a6c02c1b100ULL,
    0x1f5aa0c52f680ULL,
    0x9c4010de1ffc0ULL,
    0x20ede8a02dfa0ULL,
    0xa8b93c1694bd0ULL,
    0x99775a80ede88ULL,
    0x51d4adb8b93ccULL,
    0x778000a1775a2ULL,
    0xe1400085d4addULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0xb000000000000ULL,
    0x4800000000000ULL,
    0x7400000000000ULL,
    0x3600000000000ULL,
    0xe300000000000ULL,
    0x7e80000000000ULL,
    0x7040000000000ULL,
    0xaf60000000000ULL,
    0xd630000000000ULL,
    0xfd98000000000ULL,
    0x9584000000000ULL,
    0x1ac6000000000ULL,
    0xf921000000000ULL,
    0x625f800000000ULL,
    0x692bc00000000ULL,
    0x5a58200000000ULL,
    0xf52f500000000ULL,
    0xa85ed80000000ULL,
    0x68266c0000000ULL,
    0x41ddb20000000ULL,
    0x50e2750000000ULL,
    0x7dfcca8000000ULL,
    0x573489c000000ULL,
    0x2619802000000ULL,
    0x904ac07000000ULL,
    0x7f67a0e800000ULL,
    0x8e3490c400000ULL,
    0x719ef87e00000ULL,
    0x9f8d3c9700000ULL,
    0xbbc56a4880000ULL,
    0x52a5199340000ULL,
    0x8f9ef851e0000ULL,
    0xc88d3c6670000ULL,
    0x53456af2f8000ULL,
    0x71e519f3b4000ULL,
    0x167ef82f5e000ULL,
    0x1afd3cd8a5000ULL,
    0x37bd6aee99800ULL,
    0xd15119c30ac00ULL,
    0x8fa0f88e87a00ULL,
    0x6183c5844900ULL,
    0xe044eacb66f80ULL,
    0x976bd918393c0ULL,
    0x4a3f58a29b6a0ULL,
    0xf98ac6900190ULL,
    0x884121f87788ULL,
    0xf343e57bc7fccULL,
    0xc1e3b272a2caaULL,
    0x5e7775ff9189bULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x1000000000000ULL,
    0x3800000000000ULL,
    0xc00000000000ULL,
    0x9a00000000000ULL,
    0x8f00000000000ULL,
    0x8a80000000000ULL,
    0xc2c0000000000ULL,
    0xbb60000000000ULL,
    0x1db0000000000ULL,
    0xc998000000000ULL,
    0x530c000000000ULL,
    0x882000000000ULL,
    0x31c7000000000ULL,
    0x83e2800000000ULL,
    0x6473400000000ULL,
    0x6e71600000000ULL,
    0x997d500000000ULL,
    0x7ffa580000000ULL,
    0x373f840000000ULL,
    0x3b5f1a0000000ULL,
    0xa0622d0000000ULL,
    0x3134a28000000ULL,
    0x5654b94000000ULL,
    0xc9e200e000000ULL,
    0xf377005000000ULL,
    0x98fa805800000ULL,
    0xe9bf401c00000ULL,
    0x7f9360a200000ULL,
    0x360a508300000ULL,
    0x2500d81080000ULL,
    0x4d80c44dc0000ULL,
    0x6c4c7a31e0000ULL,
    0xd7a87ddf70000ULL,
    0xbfd47af2f8000ULL,
    0x4ba47d0ebc000ULL,
    0x5dd67a211a000ULL,
    0xa8a37d32cb000ULL,
    0x5d54fa5360800ULL,
    0xdd603d09b4400ULL,
    0x60bd9aaf93e00ULL,
    0x98116d2e0e100ULL,
    0x9d45c2d90b380ULL,
    0x5c29e9bf82d40ULL,
    0x9e98583745420ULL,
    0x8588849b2da90ULL,
    0x8459a3013b88ULL,
    0x19ad6de94a944ULL,
    0xb6dfc22a2ca26ULL,
    0xec22e9db98b91ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0x5000000000000ULL,
    0x5800000000000ULL,
    0x5c00000000000ULL,
    0xae00000000000ULL,
    0x8300000000000ULL,
    0xc480000000000ULL,
    0xd440000000000ULL,
    0x1820000000000ULL,
    0xc750000000000ULL,
    0xd8b8000000000ULL,
    0xdd0c000000000ULL,
    0xf86000000000ULL,
    0x34c7000000000ULL,
    0x6e60800000000ULL,
    0xaa70400000000ULL,
    0x467200000000ULL,
    0xbb76d00000000ULL,
    0x9dee780000000ULL,
    0x20b00c0000000ULL,
    0x9103460000000ULL,
    0xd989370000000ULL,
    0xbbcc9e8000000ULL,
    0x5ce8ab4000000ULL,
    0xa13e00a000000ULL,
    0x76cb001000000ULL,
    0x2b66807800000ULL,
    0x99f7400c00000ULL,
    0xeea7a0f600000ULL,
    0x5e1690df00000ULL,
    0xf711586a80000ULL,
    0x29adc5740000ULL,
    0x1f533edca0000ULL,
    0xc4b23b1310000ULL,
    0x5309584098000ULL,
    0xdc86dc5a5c000ULL,
    0xa84d3ef73e000ULL,
    0xe6293bb9cb000ULL,
    0x1c57d8b9e6800ULL,
    0x403d9c82b7400ULL,
    0xa74c9ee407a00ULL,
    0x94a8abc206900ULL,
    0x371e008509580ULL,
    0x629b005386dc0ULL,
    0x6f5e809acd3e0ULL,
    0xccbb40ed693b0ULL,
    0x5701a06ef7d88ULL,
    0x2e8190d02d9c4ULL,
    0x8549d8a3549e2ULL,
    0xa1a69c5ab4ab5ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0xb000000000000ULL,
    0x1800000000000ULL,
    0xc00000000000ULL,
    0xb200000000000ULL,
    0x900000000000ULL,
    0xe080000000000ULL,
    0x3cc0000000000ULL,
    0xbba0000000000ULL,
    0x6cb0000000000ULL,
    0x8658000000000ULL,
    0x5b04000000000ULL,
    0x3986000000000ULL,
    0xd441000000000ULL,
    0x236a800000000ULL,
    0x7111400000000ULL,
    0x5de3e00000000ULL,
    0x86d7b00000000ULL,
    0xb7cc980000000ULL,
    0x8a2ac40000000ULL,
    0x1cf3f60000000ULL,
    0x33eb10000000ULL,
    0x9d100e8000000ULL,
    0x3fe385c000000ULL,
    0x87de002000000ULL,
    0xf345007000000ULL,
    0x10ec80b800000ULL,
    0x105040bc00000ULL,
    0x340960aa00000ULL,
    0xce06f00500000ULL,
    0x30f785280000ULL,
    0x558d7435c0000ULL,
    0x76476e5b20000ULL,
    0x8260755070000ULL,
    0x859df8bdf8000ULL,
    0xdf2834f7b4000ULL,
    0x867a8e1fde000ULL,
    0x32f2c53f45000ULL,
    0xd03de082ec800ULL,
    0xc092b06950400ULL,
    0xeda0186c89600ULL,
    0xa3ba844ec6f00ULL,
    0xc1da9612af780ULL,
    0x9448413c3d740ULL,
    0x436776229f6e0ULL,
    0x611af12ca4750ULL,
    0xf5e76ec73bf88ULL,
    0x92d0752b1934cULL,
    0x9c5f8a0e80eaULL,
    0x312c34085785bULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x9000000000000ULL,
    0xe800000000000ULL,
    0x7400000000000ULL,
    0xe200000000000ULL,
    0xf00000000000ULL,
    0x2080000000000ULL,
    0x98c0000000000ULL,
    0x10e0000000000ULL,
    0xe670000000000ULL,
    0xb3d8000000000ULL,
    0xda04000000000ULL,
    0x730e000000000ULL,
    0x68b000000000ULL,
    0xdc7800000000ULL,
    0xa369c00000000ULL,
    0xc839600000000ULL,
    0xd6f6d00000000ULL,
    0x316f80000000ULL,
    0x9eed840000000ULL,
    0xe77f820000000ULL,
    0x5252e90000000ULL,
    0x83419a8000000ULL,
    0xaaaf7dc000000ULL,
    0xd15800a000000ULL,
    0x1dc4005000000ULL,
    0x8b6e00c800000ULL,
    0x9c3b00e400000ULL,
    0xa4ff800a00000ULL,
    0xe41dc07b00000ULL,
    0xca6f60c280000ULL,
    0x9db9d097c0000ULL,
    0x4dbf783060000ULL,
    0x45bf447eb0000ULL,
    0x81b962a338000ULL,
    0x1bb9f93c74000ULL,
    0x88b80240d6000ULL,
    0x3e3b291c8f000ULL,
    0x4bf8fadec9800ULL,
    0x7499adf5e2c00ULL,
    0x2aaef88dfee00ULL,
    0x115984519f100ULL,
    0x3dc982e12f980ULL,
    0x1b6de9a31b540ULL,
    0x74301a4ee97a0ULL,
    0xd0f9bdef7f6d0ULL,
    0x610e0165e188ULL,
    0xc56410d94d94cULL,
    0xbd301819a19a2ULL,
    0xd57694f7df7d9ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0x9000000000000ULL,
    0xa800000000000ULL,
    0x4c00000000000ULL,
    0x4e00000000000ULL,
    0x9700000000000ULL,
    0xc580000000000ULL,
    0x7d40000000000ULL,
    0xa760000000000ULL,
    0x3bf0000000000ULL,
    0x5528000000000ULL,
    0xf804000000000ULL,
    0x8402000000000ULL,
    0xb201000000000ULL,
    0xe104800000000ULL,
    0xb685400000000ULL,
    0xbac2600000000ULL,
    0x322700000000ULL,
    0xce14b80000000ULL,
    0xd61e2c0000000ULL,
    0x770fea0000000ULL,
    0xe0933b0000000ULL,
    0x58dadf8000000ULL,
    0xfe2b294000000ULL,
    0x2b80002000000ULL,
    0x3a40001000000ULL,
    0xeae0000800000ULL,
    0x9ab0002400000ULL,
    0x1448002a00000ULL,
    0x18f4001300000ULL,
    0x5aaa001380000ULL,
    0xa0450025c0000ULL,
    0x7e6803160000ULL,
    0x4234401f50000ULL,
    0xa98ee029d8000ULL,
    0x7653300efc000ULL,
    0xa5fcd8154a000ULL,
    0x9f395c3e01000ULL,
    0xdc1dd22100800ULL,
    0x3209572c80400ULL,
    0x7413d5b841200ULL,
    0xab1f226da1500ULL,
    0x78c078eb0980ULL,
    0x11577550c89c0ULL,
    0x787b521b852e0ULL,
    0x967d1701878b0ULL,
    0xd17d35bfc3fa8ULL,
    0x9cfc124f24cecULL,
    0x3db8df8fb6b7eULL,
    0x7cda29594aca5ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x1000000000000ULL,
    0x3800000000000ULL,
    0x8c00000000000ULL,
    0x5a00000000000ULL,
    0x2100000000000ULL,
    0x3b80000000000ULL,
    0x3840000000000ULL,
    0xcbe0000000000ULL,
    0x69f0000000000ULL,
    0x2d98000000000ULL,
    0x2c04000000000ULL,
    0x6a06000000000ULL,
    0xe907000000000ULL,
    0x9f80800000000ULL,
    0xd641c00000000ULL,
    0x3ce4600000000ULL,
    0x2972d00000000ULL,
    0xf59080000000ULL,
    0xe425dc0000000ULL,
    0xf057c20000000ULL,
    0x66895f0000000ULL,
    0xf7efcf8000000ULL,
    0xbddaacc000000ULL,
    0x93e0002000000ULL,
    0x35f0003000000ULL,
    0xaf98003800000ULL,
    0x9104000400000ULL,
    0x3386000e00000ULL,
    0x7c47002300000ULL,
    0x35e0801680000ULL,
    0xa6f1c00840000ULL,
    0xe11c600ee0000ULL,
    0x54c6d00e10000ULL,
    0x83270832f8000ULL,
    0x48d6dc1a7c000ULL,
    0x2849420b66000ULL,
    0x75cb9f0b01000ULL,
    0x3e8d2f9a81800ULL,
    0xabeebcfa41c00ULL,
    0x3fdde807e0200ULL,
    0x2ee6cc0590700ULL,
    0x6c72aa3739180ULL,
    0x3ada530e5cb40ULL,
    0x3b67058dd6420ULL,
    0x43312fda09770ULL,
    0xa1b88d8a95f08ULL,
    0x485233e1e257cULL,
    0x2a8bafab1bf3eULL,
    0x4de87cd566ab3ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0x3000000000000ULL,
    0xc800000000000ULL,
    0xdc00000000000ULL,
    0x4a00000000000ULL,
    0x4f00000000000ULL,
    0x5380000000000ULL,
    0xe2c0000000000ULL,
    0x8660000000000ULL,
    0x10f0000000000ULL,
    0x7ed8000000000ULL,
    0xb404000000000ULL,
    0xe602000000000ULL,
    0xed01000000000ULL,
    0xf081800000000ULL,
    0x3346400000000ULL,
    0xf7a6e00000000ULL,
    0x8f12500000000ULL,
    0xc3ea780000000ULL,
    0x1f3e9c0000000ULL,
    0xa031160000000ULL,
    0xf3bf330000000ULL,
    0xb974078000000ULL,
    0x5b1e36c000000ULL,
    0x9de0002000000ULL,
    0x6e30001000000ULL,
    0x92b8000800000ULL,
    0xdbf4000c00000ULL,
    0x35a003200000ULL,
    0x67c5003700000ULL,
    0xdae3801280000ULL,
    0x81b74013c0000ULL,
    0x2a7f6014e0000ULL,
    0xea901038b0000ULL,
    0x542e982198000ULL,
    0x6dddcc043c000ULL,
    0xed82ee1fb6000ULL,
    0x6bc3ef2d01000ULL,
    0x8e1f1b980800ULL,
    0xcab255fb40400ULL,
    0x17ffff9c20600ULL,
    0x1956eadcd1900ULL,
    0x58cff615e9b80ULL,
    0xc969633fc4940ULL,
    0xeb7c7f8afa9e0ULL,
    0xf811aafccfa70ULL,
    0xe46896288c458ULL,
    0x7bfd73082fcccULL,
    0xdb50e7a03d01eULL,
    0xebcd66f1b78dbULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0xd000000000000ULL,
    0x2800000000000ULL,
    0x3400000000000ULL,
    0x6a00000000000ULL,
    0xa500000000000ULL,
    0xda80000000000ULL,
    0x10c0000000000ULL,
    0xd520000000000ULL,
    0xc690000000000ULL,
    0xfcf8000000000ULL,
    0x204000000000ULL,
    0xf106000000000ULL,
    0xc085000000000ULL,
    0x4dc6800000000ULL,
    0x13a1400000000ULL,
    0x8851a00000000ULL,
    0xe6db500000000ULL,
    0xbb11280000000ULL,
    0xc7b8d40000000ULL,
    0x761860000000ULL,
    0xaf76290000000ULL,
    0xe94a748000000ULL,
    0x3b6cc7c000000ULL,
    0x678002000000ULL,
    0x2c4003000000ULL,
    0xac26002800000ULL,
    0xe215003400000ULL,
    0xf33e800a00000ULL,
    0x80a5400d00000ULL,
    0xc9d7a01a80000ULL,
    0x939e502940000ULL,
    0xf977a836a0000ULL,
    0x249940430000ULL,
    0xa6e8263548000ULL,
    0x8d397931a4000ULL,
    0x5fa55cbf3e000ULL,
    0x3e5513c081000ULL,
    0xbdd9061c41800ULL,
    0x7e96690021400ULL,
    0x80fb54bb71a00ULL,
    0x2c03d7f0e8500ULL,
    0xc606080814680ULL,
    0xa302c404b6d40ULL,
    0xd9810e1c444a0ULL,
    0x1945ad2cae350ULL,
    0xe462dabd78618ULL,
    0x16f63ae2ed8a4ULL,
    0x800df2b59a9d2ULL,
    0x270feee63f31fULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0xd000000000000ULL,
    0xd800000000000ULL,
    0xe400000000000ULL,
    0xbe00000000000ULL,
    0x3700000000000ULL,
    0xdd80000000000ULL,
    0x3d40000000000ULL,
    0xf320000000000ULL,
    0x6bd0000000000ULL,
    0x3c48000000000ULL,
    0xba04000000000ULL,
    0x9906000000000ULL,
    0x5283000000000ULL,
    0xd4c6800000000ULL,
    0xa866c00000000ULL,
    0x4bf7200000000ULL,
    0x341df00000000ULL,
    0x8c0db80000000ULL,
    0xda4ec0000000ULL,
    0x9d14ea0000000ULL,
    0x492a190000000ULL,
    0xad771e8000000ULL,
    0x46de024000000ULL,
    0x9768002000000ULL,
    0xf5d4003000000ULL,
    0x7b4e001800000ULL,
    0xf87003400000ULL,
    0x4840803600000ULL,
    0x23a5c03900000ULL,
    0xd211a02f80000ULL,
    0xc0ab300dc0000ULL,
    0x2632983760000ULL,
    0xbefd1c0f50000ULL,
    0x7b3f523cc8000ULL,
    0x7dddf51af4000ULL,
    0xd8ed748f12000ULL,
    0x1d96db6e81000ULL,
    0xe8ee3e8641800ULL,
    0xd594f264a0c00ULL,
    0xb4ed380d31a00ULL,
    0x5f912c2e19b00ULL,
    0xe5ed4a3cfdc80ULL,
    0x51152900077c0ULL,
    0xbb2b86ba836e0ULL,
    0xa8741e77a93b0ULL,
    0xfe5fd21fa53a8ULL,
    0xc2a83520da864ULL,
    0x8b34d4b8f5c7aULL,
    0x8a79eb7013809ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x9000000000000ULL,
    0x2800000000000ULL,
    0x8400000000000ULL,
    0xda00000000000ULL,
    0x2300000000000ULL,
    0x3180000000000ULL,
    0xcec0000000000ULL,
    0x2aa0000000000ULL,
    0x9610000000000ULL,
    0x4b58000000000ULL,
    0xae04000000000ULL,
    0xa106000000000ULL,
    0xe81000000000ULL,
    0x1944800000000ULL,
    0xb161400000000ULL,
    0xf034200000000ULL,
    0xdb0ed00000000ULL,
    0x13bd180000000ULL,
    0x4cf38c0000000ULL,
    0x96a9760000000ULL,
    0x4e28d50000000ULL,
    0x7a6b708000000ULL,
    0xb8c3ac000000ULL,
    0x33f8002000000ULL,
    0xcf14003000000ULL,
    0x9de000800000ULL,
    0x5945002400000ULL,
    0x5162800a00000ULL,
    0x4030402100000ULL,
    0x6308a03680000ULL,
    0xbfbb9008c0000ULL,
    0x12f7380c60000ULL,
    0x6fa85c33b0000ULL,
    0x5caeee0aa8000ULL,
    0x852f192584000ULL,
    0xefeca692d6000ULL,
    0x8f4e7feb81000ULL,
    0x1258c88841800ULL,
    0xec8526f3a0400ULL,
    0x5642ce2e51200ULL,
    0xfee5c93858500ULL,
    0x57f7bebe0d080ULL,
    0xcb2cf3f3c3b40ULL,
    0xfeed3e986f460ULL,
    0x39c8b3cafce30ULL,
    0xa71b9eb74a5d8ULL,
    0x3e623fcfa354ULL,
    0x5f7626ba52dc2ULL,
    0x376a3fe1d70ebULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x9000000000000ULL,
    0x3800000000000ULL,
    0x8400000000000ULL,
    0x5600000000000ULL,
    0x2700000000000ULL,
    0x2b80000000000ULL,
    0xc7c0000000000ULL,
    0x4f60000000000ULL,
    0xd990000000000ULL,
    0xdfb8000000000ULL,
    0x7704000000000ULL,
    0xf382000000000ULL,
    0x73c5000000000ULL,
    0xb164800000000ULL,
    0x4291c00000000ULL,
    0x263c200000000ULL,
    0xc1c6b00000000ULL,
    0xb063380000000ULL,
    0x46145c0000000ULL,
    0xe67abe0000000ULL,
    0xa367bb0000000ULL,
    0xd390ec8000000ULL,
    0x1ab94dc000000ULL,
    0x8582002000000ULL,
    0x84c5001000000ULL,
    0x2e4802800000ULL,
    0x9151c02400000ULL,
    0x75c200e00000ULL,
    0xbb56b02100000ULL,
    0x125b381580000ULL,
    0xd1d05c09c0000ULL,
    0x7118be0ae0000ULL,
    0xcef2bb31f0000ULL,
    0xf22c6c93d8000ULL,
    0xf6bc8df664000ULL,
    0x8f842017ee000ULL,
    0x41c2b00dc1000ULL,
    0xf0613814e0800ULL,
    0xe6115c38f1400ULL,
    0x767e3e2259200ULL,
    0x9b667b31a4700ULL,
    0x5794cc9c0f080ULL,
    0x4cbbfdf9b1ac0ULL,
    0xa2833806f8ce0ULL,
    0xaf445c3075170ULL,
    0xc522be0246af8ULL,
    0xde33bb3abdeecULL,
    0xdecaec8d0a3b2ULL,
    0x64e84dfa6f537ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x1000000000000ULL,
    0xf800000000000ULL,
    0x3c00000000000ULL,
    0x5a00000000000ULL,
    0x1b00000000000ULL,
    0xa880000000000ULL,
    0x1c40000000000ULL,
    0x7b60000000000ULL,
    0x8110000000000ULL,
    0x4f08000000000ULL,
    0xab04000000000ULL,
    0x8086000000000ULL,
    0xf841000000000ULL,
    0xd60800000000ULL,
    0x3817c00000000ULL,
    0xc089e00000000ULL,
    0x45c6d00000000ULL,
    0xfca6d80000000ULL,
    0xaab4440000000ULL,
    0xdf38620000000ULL,
    0xa7781b0000000ULL,
    0x6a1fe88000000ULL,
    0x720ba84000000ULL,
    0xa286002000000ULL,
    0x1f41003000000ULL,
    0xdfe0800800000ULL,
    0x2f57c00400000ULL,
    0xeb69e03e00000ULL,
    0xe496d00f00000ULL,
    0x92ced81680000ULL,
    0x9ba04406c0000ULL,
    0xb836622a20000ULL,
    0xe87d1b0710000ULL,
    0x9c99689ed8000ULL,
    0x334d686044000ULL,
    0x20676033c2000ULL,
    0xc994101ac1000ULL,
    0x6349b82821800ULL,
    0x3864543a10400ULL,
    0xc597da3d58200ULL,
    0xd14d4f0105f00ULL,
    0xe760b2a6a2780ULL,
    0xb152757b1b40ULL,
    0x8c0952b509b60ULL,
    0x2f83f75dbd110ULL,
    0x3ec78a8116188ULL,
    0xa423b37d9a06cULL,
    0x7ef1e89f45fa2ULL,
    0x705ea84d43ea1ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x9000000000000ULL,
    0x2800000000000ULL,
    0x3c00000000000ULL,
    0xd200000000000ULL,
    0x7b00000000000ULL,
    0xef80000000000ULL,
    0x4840000000000ULL,
    0xc920000000000ULL,
    0x8810000000000ULL,
    0x90a8000000000ULL,
    0xa304000000000ULL,
    0x8b82000000000ULL,
    0xbe45000000000ULL,
    0xe424800000000ULL,
    0xda91400000000ULL,
    0xa269e00000000ULL,
    0x64e2900000000ULL,
    0x1671d80000000ULL,
    0xc81a7c0000000ULL,
    0xdefac20000000ULL,
    0x2389090000000ULL,
    0x2c16a08000000ULL,
    0x86a9954000000ULL,
    0xbe02002000000ULL,
    0x6105001000000ULL,
    0x9884802800000ULL,
    0xcdc1402400000ULL,
    0xee61e00a00000ULL,
    0x40b6900f00000ULL,
    0xf9fbd83480000ULL,
    0x6e0b7c1ec0000ULL,
    0x754423be0000ULL,
    0x2409491210000ULL,
    0xb851c0b248000ULL,
    0xad8b456204000ULL,
    0xf514b8042a000ULL,
    0xa2dac38c1000ULL,
    0x9dc0fa0ae0800ULL,
    0x2664e50b91400ULL,
    0x4cb13ab309200ULL,
    0x93ffa079a4500ULL,
    0x10d82bc1a780ULL,
    0x6d60c57f8a40ULL,
    0xc54f78b67c760ULL,
    0xe5f7e954169f0ULL,
    0x825ac207f6b08ULL,
    0xe4d90911e6424ULL,
    0xe81ea0b9afa82ULL,
    0xefd957cab655ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0xb000000000000ULL,
    0xf800000000000ULL,
    0xbc00000000000ULL,
    0xc200000000000ULL,
    0x5700000000000ULL,
    0xc080000000000ULL,
    0x30c0000000000ULL,
    0x8220000000000ULL,
    0x28b0000000000ULL,
    0x6638000000000ULL,
    0xcb04000000000ULL,
    0x7286000000000ULL,
    0x3fc5000000000ULL,
    0x4ea5800000000ULL,
    0x2277c00000000ULL,
    0xf1de00000000ULL,
    0xe132100000000ULL,
    0x737cb80000000ULL,
    0xb667040000000ULL,
    0x2452060000000ULL,
    0xf9aed10000000ULL,
    0xa20d258000000ULL,
    0xd7f8e1c000000ULL,
    0x88a6002000000ULL,
    0x6b75003000000ULL,
    0x4a9d802800000ULL,
    0xe73c02c00000ULL,
    0x451be03e00000ULL,
    0x5237102f00000ULL,
    0x7df9383080000ULL,
    0xeba0c415c0000ULL,
    0x8df7e63020000ULL,
    0xe358c10c30000ULL,
    0x21d79da088000ULL,
    0x76eae5ca2c000ULL,
    0x846986398e000ULL,
    0x7ba81102c1000ULL,
    0x950b45b4a1800ULL,
    0x77c31e3f1400ULL,
    0xf064d80da9600ULL,
    0xad52d4179df00ULL,
    0x1c2b5e1b47780ULL,
    0xfd4fc5018c840ULL,
    0x199d9b92ff2e0ULL,
    0xd0f034cea9c10ULL,
    0xf0daa3b91c818ULL,
    0xf91f0d187b44ULL,
    0xe10ec5892d496ULL,
    0x417bf1d70f387ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x7000000000000ULL,
    0x8800000000000ULL,
    0xc00000000000ULL,
    0xca00000000000ULL,
    0x3700000000000ULL,
    0x2b80000000000ULL,
    0x9d40000000000ULL,
    0xd2e0000000000ULL,
    0x56b0000000000ULL,
    0x55c8000000000ULL,
    0xeb04000000000ULL,
    0x3982000000000ULL,
    0x3e43000000000ULL,
    0xc763800000000ULL,
    0xb2f4400000000ULL,
    0x5da8600000000ULL,
    0xf672500000000ULL,
    0x3f6bb80000000ULL,
    0xe7d65c0000000ULL,
    0xb23d6a0000000ULL,
    0xb62dd70000000ULL,
    0x4b37558000000ULL,
    0xfd89be4000000ULL,
    0x4962002000000ULL,
    0x63f3001000000ULL,
    0x9b2b801800000ULL,
    0x8fb0401c00000ULL,
    0xdf4a602200000ULL,
    0x38c1500300000ULL,
    0x9ea0383280000ULL,
    0x42d61c0dc0000ULL,
    0x7abf0a0ae0000ULL,
    0x5ee8872750000ULL,
    0xd956db4b8000ULL,
    0x2b5ca255ac000ULL,
    0xdde8a3572000ULL,
    0x441fc72ac1000ULL,
    0x4c3e8d9660800ULL,
    0xef2ab25390c00ULL,
    0x81b55233d8e00ULL,
    0x4e4fcb3fbd100ULL,
    0x9e425fbdea180ULL,
    0x9766396c5c940ULL,
    0x2af6ed873aee0ULL,
    0xa9a8e24da5970ULL,
    0xb876ea12b75a8ULL,
    0xce6d9739e775cULL,
    0x315535b75fd56ULL,
    0x33fcee7df36f9ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x5000000000000ULL,
    0x3800000000000ULL,
    0x5400000000000ULL,
    0x1200000000000ULL,
    0xed00000000000ULL,
    0x9c80000000000ULL,
    0x8940000000000ULL,
    0x8a60000000000ULL,
    0x750000000000ULL,
    0xc138000000000ULL,
    0x9104000000000ULL,
    0x8286000000000ULL,
    0xd245000000000ULL,
    0x81e2800000000ULL,
    0x9391c00000000ULL,
    0x189aa00000000ULL,
    0x6a74900000000ULL,
    0xbf09680000000ULL,
    0x90ede40000000ULL,
    0x507cca0000000ULL,
    0xdf62930000000ULL,
    0xfd31a8000000ULL,
    0xfa78d9c000000ULL,
    0xa666002000000ULL,
    0x2155003000000ULL,
    0xce3a802800000ULL,
    0x8885c01400000ULL,
    0xfb44a00e00000ULL,
    0x9765901500000ULL,
    0xf3d5e80480000ULL,
    0x247d243b40000ULL,
    0x5d62ea2720000ULL,
    0x7ad2c32250000ULL,
    0x62fa52a298000ULL,
    0x5246dc1d4000ULL,
    0x123702104e000ULL,
    0x47efe71441000ULL,
    0x2df8b888a1800ULL,
    0x7ca6aee091400ULL,
    0x9bf5508e78a00ULL,
    0x6acf8ac1e4700ULL,
    0x33c9ba8aa6a80ULL,
    0x8d4c49c5dd240ULL,
    0x210f680ee25a0ULL,
    0xbe8e4376b790ULL,
    0xfbfe4a1407328ULL,
    0x1ba3530c4ca4cULL,
    0xee71ba9e1ac6aULL,
    0x550849d6cf367ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x9000000000000ULL,
    0x4800000000000ULL,
    0x1400000000000ULL,
    0x6e00000000000ULL,
    0xc900000000000ULL,
    0xf380000000000ULL,
    0xd4c0000000000ULL,
    0x89e0000000000ULL,
    0xbb10000000000ULL,
    0x7eb8000000000ULL,
    0xe504000000000ULL,
    0x1182000000000ULL,
    0x4fc3000000000ULL,
    0x5964800000000ULL,
    0x7352400000000ULL,
    0xd18a00000000ULL,
    0x9eb7700000000ULL,
    0x400c480000000ULL,
    0x15089c0000000ULL,
    0xbc8c260000000ULL,
    0x3f4b0f0000000ULL,
    0x542cf88000000ULL,
    0x947b45c000000ULL,
    0xcde2002000000ULL,
    0xbd13001000000ULL,
    0x53bc801800000ULL,
    0xa086402400000ULL,
    0x5042a01200000ULL,
    0x4fa0700500000ULL,
    0x91b2c81b80000ULL,
    0xbe8ddc3240000ULL,
    0x744a063ce0000ULL,
    0xaca93f3530000ULL,
    0xd83e90a278000ULL,
    0x9845e9eec4000ULL,
    0x1ba64e3fae000ULL,
    0x9fb1a32941000ULL,
    0xe78ab69c60800ULL,
    0xcfcae6f7f0c00ULL,
    0x6c68b6a459200ULL,
    0x3fd9e6c9d4900ULL,
    0xea5436a0c6280ULL,
    0x969fa6e1eddc0ULL,
    0xae769686e3120ULL,
    0x7fefd6c172270ULL,
    0x3b1c5ebcdb098ULL,
    0x4bb60ae256c3cULL,
    0xa98c5887c53e2ULL,
    0xf6c835ea2fd17ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x9000000000000ULL,
    0xf800000000000ULL,
    0x4c00000000000ULL,
    0x7600000000000ULL,
    0x700000000000ULL,
    0xb580000000000ULL,
    0x5f40000000000ULL,
    0x91e0000000000ULL,
    0x8090000000000ULL,
    0xb298000000000ULL,
    0xb104000000000ULL,
    0x5282000000000ULL,
    0xdac5000000000ULL,
    0xa6a4800000000ULL,
    0xa577c00000000ULL,
    0x80a600000000ULL,
    0x729fb00000000ULL,
    0x5106380000000ULL,
    0x6282ac0000000ULL,
    0xb2c37a0000000ULL,
    0x12a7cf0000000ULL,
    0x9f71a48000000ULL,
    0x790c44c000000ULL,
    0xc01a002000000ULL,
    0xbbc1001000000ULL,
    0xac26802800000ULL,
    0xa3b2c02400000ULL,
    0x20aee03e00000ULL,
    0x9ce8701300000ULL,
    0x9a8c581d80000ULL,
    0x485d1c01c0000ULL,
    0xc7a5422d60000ULL,
    0xaff56317d0000ULL,
    0xecadea478000ULL,
    0x5a3f8be024000ULL,
    0xbf71a48ca6000ULL,
    0xa90c44fc41000ULL,
    0x981a001ca0800ULL,
    0x67c10002b1400ULL,
    0x2226803fa9200ULL,
    0xe8b2c01e5df00ULL,
    0xe32ee02182980ULL,
    0xc4a8700e67ec0ULL,
    0xbeec5824a18e0ULL,
    0x978d1c0eb0ab0ULL,
    0xe4dd4225a8de8ULL,
    0x9e6163335df3cULL,
    0xeed0deaf02692ULL,
    0x31fe8bd226113ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0xf000000000000ULL,
    0xb800000000000ULL,
    0xfc00000000000ULL,
    0x2600000000000ULL,
    0xe300000000000ULL,
    0xc180000000000ULL,
    0xcec0000000000ULL,
    0x3ce0000000000ULL,
    0x4190000000000ULL,
    0xe978000000000ULL,
    0xb504000000000ULL,
    0x5a86000000000ULL,
    0x9343000000000ULL,
    0x2427800000000ULL,
    0x2675c00000000ULL,
    0x956fe00000000ULL,
    0xb4bd300000000ULL,
    0x3065180000000ULL,
    0x49d30c0000000ULL,
    0x90daf60000000ULL,
    0x8bb7a70000000ULL,
    0xa80e2c8000000ULL,
    0x5bee9bc000000ULL,
    0x15fe002000000ULL,
    0x547003000000ULL,
    0xdf21801800000ULL,
    0x8bf6c03c00000ULL,
    0x35a8602e00000ULL,
    0x2f58f03f00000ULL,
    0x6a72f80980000ULL,
    0xab6a3c38c0000ULL,
    0x3bb9ee3060000ULL,
    0x9fe7ab33b0000ULL,
    0x20135a8f38000ULL,
    0xb7bcfcd064000ULL,
    0xc1e7cc9a5e000ULL,
    0x5f10abdd41000ULL,
    0xa03c982ea1800ULL,
    0x5421cc28d0c00ULL,
    0x5e74963f09e00ULL,
    0x96c570a9d700ULL,
    0x62bb5482dbf80ULL,
    0x6b6167eaef4c0ULL,
    0x74500e15f9460ULL,
    0x78199b2904c30ULL,
    0x5451c2836ebd8ULL,
    0x281a30fd39e9cULL,
    0x7c52da91658b2ULL,
    0x9c1a3ce4dea6fULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x5000000000000ULL,
    0xb800000000000ULL,
    0x6400000000000ULL,
    0x7a00000000000ULL,
    0xf500000000000ULL,
    0xb580000000000ULL,
    0xd7c0000000000ULL,
    0x7860000000000ULL,
    0xdff0000000000ULL,
    0xca58000000000ULL,
    0x6b04000000000ULL,
    0xfa86000000000ULL,
    0xb741000000000ULL,
    0x4a22800000000ULL,
    0xc855c00000000ULL,
    0x9cb200000000ULL,
    0x4afd00000000ULL,
    0xaedda80000000ULL,
    0x9346ac0000000ULL,
    0xd0233e0000000ULL,
    0x4d55830000000ULL,
    0x544a9f8000000ULL,
    0xf6f62c000000ULL,
    0xc8be002000000ULL,
    0xc3b5003000000ULL,
    0x5afc800800000ULL,
    0x4410c01400000ULL,
    0x16fa02e00000ULL,
    0x1fbb101900000ULL,
    0x9734081e80000ULL,
    0xaabcbc3d40000ULL,
    0xc2b5b62d60000ULL,
    0xd7cff35f0000ULL,
    0x52d4099e18000ULL,
    0xe8c4df7fc000ULL,
    0x868fa19296000ULL,
    0xea8be1eac1000ULL,
    0x3c8e1f96a1800ULL,
    0x3f8ba2c9d0400ULL,
    0xd90fa01488a00ULL,
    0x504b100f15700ULL,
    0xc56c083af2c80ULL,
    0xf5b8bc316bf40ULL,
    0xfa33b636576a0ULL,
    0x2b3dff3561ab0ULL,
    0xd7768999f0cf8ULL,
    0xe4198dec1960cULL,
    0x42a481b4fca7eULL,
    0xe61431eb16d8bULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x1000000000000ULL,
    0x2800000000000ULL,
    0x6c00000000000ULL,
    0xa200000000000ULL,
    0x5500000000000ULL,
    0x8980000000000ULL,
    0xc40000000000ULL,
    0x1d60000000000ULL,
    0xcdb0000000000ULL,
    0x2558000000000ULL,
    0x7304000000000ULL,
    0xf282000000000ULL,
    0xc2c5000000000ULL,
    0xf5a0800000000ULL,
    0x1111400000000ULL,
    0x37cb600000000ULL,
    0x7189100000000ULL,
    0xb5eca80000000ULL,
    0xe3df4c0000000ULL,
    0xa7c3e20000000ULL,
    0x4262b0000000ULL,
    0xf951cd8000000ULL,
    0xf4ae9ac000000ULL,
    0x633a002000000ULL,
    0x2031001000000ULL,
    0xb71a802800000ULL,
    0x1160400400000ULL,
    0x9fb1e00a00000ULL,
    0xe859501b00000ULL,
    0xae85482880000ULL,
    0x18c21c1540000ULL,
    0x44a4aa2260000ULL,
    0x4691370310000ULL,
    0xe48de78758000ULL,
    0xdc6aedf36c000ULL,
    0x5f9e87a956000ULL,
    0x82a7fdccc1000ULL,
    0x8d902fb4a0800ULL,
    0x120db1e4b1400ULL,
    0x70ab4dbf68200ULL,
    0x4d3edacb44500ULL,
    0x6733e02772d80ULL,
    0x539c500622440ULL,
    0xd0a5c8059b2a0ULL,
    0x40935c31a7d30ULL,
    0xcf8fca2e48f88ULL,
    0x9ae8273f358acULL,
    0xcb594fbaba736ULL,
    0xd401a1c4d6a6bULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x7000000000000ULL,
    0xb800000000000ULL,
    0xd400000000000ULL,
    0xaa00000000000ULL,
    0x6b00000000000ULL,
    0xff80000000000ULL,
    0xc2c0000000000ULL,
    0x9e20000000000ULL,
    0x4450000000000ULL,
    0xf598000000000ULL,
    0xaf84000000000ULL,
    0x4ac2000000000ULL,
    0x5225000000000ULL,
    0x4a53800000000ULL,
    0x8c9dc00000000ULL,
    0xef02a00000000ULL,
    0xdd87500000000ULL,
    0x65c6580000000ULL,
    0x6fa47c0000000ULL,
    0xff93d60000000ULL,
    0x2b3a510000000ULL,
    0x7c93728000000ULL,
    0x88bef4c000000ULL,
    0xd853802000000ULL,
    0x739dc01000000ULL,
    0x1a82a02800000ULL,
    0x447501c00000ULL,
    0xbc66582e00000ULL,
    0x3d347c3500000ULL,
    0x3e2bd62a80000ULL,
    0xabee511ac0000ULL,
    0x3c4972bfe0000ULL,
    0xb7dff4f0b0000ULL,
    0x46e2000788000ULL,
    0xe975000114000ULL,
    0x4a4b801566000ULL,
    0xfad9c037e1000ULL,
    0x7c60a03cb0800ULL,
    0xdd32502189400ULL,
    0xee2dd83814e00ULL,
    0x63edbc39e7700ULL,
    0x504b760420a80ULL,
    0xc9dc0107d1d40ULL,
    0x87e4aabef9960ULL,
    0x7df248cafd1f0ULL,
    0x7709762282f58ULL,
    0xa63901312f944ULL,
    0xa6172aa5945caULL,
    0x6cff88eaa6fd3ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x1000000000000ULL,
    0x4800000000000ULL,
    0x5400000000000ULL,
    0x9600000000000ULL,
    0xdb00000000000ULL,
    0x1d80000000000ULL,
    0x7940000000000ULL,
    0xd960000000000ULL,
    0xf050000000000ULL,
    0x22a8000000000ULL,
    0xb584000000000ULL,
    0xfd46000000000ULL,
    0x6763000000000ULL,
    0x6f50800000000ULL,
    0xe12a400000000ULL,
    0x43c6a00000000ULL,
    0xafa2b00000000ULL,
    0x3575d80000000ULL,
    0x89186c0000000ULL,
    0xddbd8a0000000ULL,
    0x454e6b0000000ULL,
    0x8d12328000000ULL,
    0x85ca4d4000000ULL,
    0xbad0802000000ULL,
    0xc6a403000000ULL,
    0x6ca6a01800000ULL,
    0x94f2b00400000ULL,
    0x425dd81200000ULL,
    0x11dc6c1500000ULL,
    0x6f9b8a2580000ULL,
    0x97d6b36c0000ULL,
    0xdd6ab28760000ULL,
    0xa8240d5e50000ULL,
    0xdd30201658000ULL,
    0x34fbf00c14000ULL,
    0x142bf810aa000ULL,
    0x49449c2961000ULL,
    0x2160f22d51800ULL,
    0x9c53b70cd8c00ULL,
    0xb8ace0be54200ULL,
    0xe4850a4e8a900ULL,
    0xf9c118b791a80ULL,
    0x4ea29645b8ac0ULL,
    0x9f16a8305760ULL,
    0xacdb616a521b0ULL,
    0x311b2a15c5628ULL,
    0x11bcdb1d329acULL,
    0xaf4feab3950caULL,
    0x8416215f6a535ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x1000000000000ULL,
    0x6800000000000ULL,
    0xa400000000000ULL,
    0x2600000000000ULL,
    0x8f00000000000ULL,
    0x9280000000000ULL,
    0x61c0000000000ULL,
    0xfce0000000000ULL,
    0x6ff0000000000ULL,
    0x8978000000000ULL,
    0xa684000000000ULL,
    0xefc6000000000ULL,
    0x77e5000000000ULL,
    0xcb70800000000ULL,
    0xfbb400000000ULL,
    0x6ce1200000000ULL,
    0xc7f7300000000ULL,
    0x8d79780000000ULL,
    0x9080140000000ULL,
    0x8c64e0000000ULL,
    0x4167c70000000ULL,
    0x8cb2cf8000000ULL,
    0x7c5b73c000000ULL,
    0x9190802000000ULL,
    0x2f4b403000000ULL,
    0xd719202800000ULL,
    0x10b3300400000ULL,
    0xf65f781a00000ULL,
    0x2c95142900000ULL,
    0x6ccece0980000ULL,
    0x67588723c0000ULL,
    0x9d15efa4a0000ULL,
    0xad8943d870000ULL,
    0x2b79781f38000ULL,
    0xdf80142bfc000ULL,
    0x3a464e0a5e000ULL,
    0x30a7c72da1000ULL,
    0x1852cfa1f1800ULL,
    0xb7ab73f4f9400ULL,
    0x3ee8801b5c200ULL,
    0x6cf40102ed00ULL,
    0xaa5f201798480ULL,
    0x696302d8dcc0ULL,
    0xc1cff806665e0ULL,
    0x4cde5416dc050ULL,
    0x8957ee29ef938ULL,
    0x62bb71a38f1cULL,
    0xffaa97bc7d33eULL,
    0x4aec57da9f9cfULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0xf000000000000ULL,
    0xa800000000000ULL,
    0x3400000000000ULL,
    0x2a00000000000ULL,
    0xc300000000000ULL,
    0x6b80000000000ULL,
    0x6740000000000ULL,
    0x4160000000000ULL,
    0x8330000000000ULL,
    0x4928000000000ULL,
    0xf84000000000ULL,
    0x3546000000000ULL,
    0xe67000000000ULL,
    0xaeb7800000000ULL,
    0x5b6d400000000ULL,
    0xf865a00000000ULL,
    0x53b7500000000ULL,
    0xc9e9180000000ULL,
    0x6fa0dc0000000ULL,
    0x82107a0000000ULL,
    0x72fcab0000000ULL,
    0xddec98000000ULL,
    0xef0b114000000ULL,
    0xdd7802000000ULL,
    0x1f5d403000000ULL,
    0xb8cda03800000ULL,
    0x3c73503c00000ULL,
    0x544f182a00000ULL,
    0x72b7dc0d00000ULL,
    0x656ffa0a80000ULL,
    0x165eb30c0000ULL,
    0xa335699ae0000ULL,
    0x592f4159d0000ULL,
    0x5787183058000ULL,
    0xa943dc10cc000ULL,
    0x1061fa2a4a000ULL,
    0x47b6eb3fe1000ULL,
    0xf3ece9a751800ULL,
    0xf4a1014e99c00ULL,
    0x759338012de00ULL,
    0xbbecc161b500ULL,
    0xa5bac21cf9680ULL,
    0xc4bc27313dd40ULL,
    0x48382b8822460ULL,
    0x36fe267624370ULL,
    0x4fda93984e1e8ULL,
    0xf80aaa5f9e2acULL,
    0xbc52718cc6326ULL,
    0x131c9d6d8b045ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0x3000000000000ULL,
    0xe800000000000ULL,
    0xcc00000000000ULL,
    0x5e00000000000ULL,
    0x3900000000000ULL,
    0x4380000000000ULL,
    0x8fc0000000000ULL,
    0x75e0000000000ULL,
    0x6890000000000ULL,
    0x10e8000000000ULL,
    0x9784000000000ULL,
    0x95c2000000000ULL,
    0xcee1000000000ULL,
    0x9411800000000ULL,
    0xc1af400000000ULL,
    0xbc22600000000ULL,
    0x6070f00000000ULL,
    0xb9f8c80000000ULL,
    0xb7af9c0000000ULL,
    0x29253e0000000ULL,
    0x6df6cf0000000ULL,
    0xd739348000000ULL,
    0xa5cb8f4000000ULL,
    0x5c71802000000ULL,
    0x6fff401000000ULL,
    0x52aa600800000ULL,
    0xeca4f00c00000ULL,
    0xff32c83a00000ULL,
    0x735a9c3300000ULL,
    0x259ebe1780000ULL,
    0x43fc8f0e40000ULL,
    0x5ca8d490e0000ULL,
    0x2da53f63f0000ULL,
    0xa8b2a83d78000ULL,
    0x869b6c0a24000ULL,
    0xfb7ff60c3a000ULL,
    0xfe85329e1000ULL,
    0xb9058a9f70800ULL,
    0x3860040b8400ULL,
    0xafc0d49284600ULL,
    0x45e13f6e2bd00ULL,
    0x8090a817e8980ULL,
    0xdcea6c27ec3c0ULL,
    0xc986760106320ULL,
    0xacc31308cfe70ULL,
    0x8d65eaa3f34f8ULL,
    0x1bd7f043dcb3cULL,
    0xb4499cb7decd2ULL,
    0xd4b1e3677aa3dULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x1000000000000ULL,
    0x4800000000000ULL,
    0x3400000000000ULL,
    0xe200000000000ULL,
    0xaf00000000000ULL,
    0xdf80000000000ULL,
    0x1cc0000000000ULL,
    0x5220000000000ULL,
    0xfed0000000000ULL,
    0xbaa8000000000ULL,
    0x7d84000000000ULL,
    0xd3c6000000000ULL,
    0x3da5000000000ULL,
    0xba10800000000ULL,
    0x948a400000000ULL,
    0x5555a00000000ULL,
    0x2469100000000ULL,
    0x30a4780000000ULL,
    0xaa907c0000000ULL,
    0xe7cfa60000000ULL,
    0x43b7b10000000ULL,
    0xf49ca68000000ULL,
    0xa2d80d4000000ULL,
    0x20b8802000000ULL,
    0x390e403000000ULL,
    0x6e93a02800000ULL,
    0x3dcc100400000ULL,
    0x20b4f81200000ULL,
    0xa51a3c0d00000ULL,
    0x8f1a063880000ULL,
    0xd41ea12bc0000ULL,
    0x4998deb7e0000ULL,
    0xea58714730000ULL,
    0x2fff263488000ULL,
    0xf9edf10fb4000ULL,
    0xf3610686aa000ULL,
    0xdf351d5b61000ULL,
    0x69daf806f1800ULL,
    0x353b3c3269400ULL,
    0xecc863e04200ULL,
    0x5931e10ae2900ULL,
    0xcddfeb0b5680ULL,
    0xc1bb21432a440ULL,
    0x778efe00211e0ULL,
    0xc4d49d0ed01f0ULL,
    0xa9aad888b9e98ULL,
    0xd402d04cbcec4ULL,
    0x9201f8af5ea9aULL,
    0x570080656b435ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0xb000000000000ULL,
    0x8800000000000ULL,
    0xa400000000000ULL,
    0x4a00000000000ULL,
    0x5f00000000000ULL,
    0x9480000000000ULL,
    0x90c0000000000ULL,
    0x71e0000000000ULL,
    0x89f0000000000ULL,
    0x4a98000000000ULL,
    0x9a84000000000ULL,
    0x55c2000000000ULL,
    0xa261000000000ULL,
    0x11b5800000000ULL,
    0xcdbc400000000ULL,
    0xd391200000000ULL,
    0x1728500000000ULL,
    0x293ff80000000ULL,
    0xab57240000000ULL,
    0x52cbc60000000ULL,
    0xd2ce2f0000000ULL,
    0x92c9df8000000ULL,
    0xb2ceccc000000ULL,
    0x2cd802000000ULL,
    0x8ac8401000000ULL,
    0x2ecb200800000ULL,
    0x64cd502c00000ULL,
    0x3bc8782200000ULL,
    0xaf4a642900000ULL,
    0x3f8f661280000ULL,
    0x4e6a3f17c0000ULL,
    0xc79f07a520000ULL,
    0x8d05b8e430000ULL,
    0x1783be3c78000ULL,
    0x42444b327c000ULL,
    0xe026b99aa6000ULL,
    0xf194f3caa1000ULL,
    0x3c2a879770800ULL,
    0xefb9f8d198400ULL,
    0xf8929e3eed600ULL,
    0xd1ac1b18af100ULL,
    0x7af941bbc4480ULL,
    0x2833d7e4fa140ULL,
    0xfaf94186b7fe0ULL,
    0x6833d7e669c90ULL,
    0xdaf94199b4f18ULL,
    0xd833d7dde28bcULL,
    0x52f941829af7eULL,
    0x7c33d7d767f33ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x3000000000000ULL,
    0xb800000000000ULL,
    0x2c00000000000ULL,
    0x2e00000000000ULL,
    0xe700000000000ULL,
    0x2e80000000000ULL,
    0xa6c0000000000ULL,
    0x58e0000000000ULL,
    0x61b0000000000ULL,
    0xf8c8000000000ULL,
    0x5c84000000000ULL,
    0xb7c6000000000ULL,
    0x2d65000000000ULL,
    0x4ff1800000000ULL,
    0x75edc00000000ULL,
    0x4955600000000ULL,
    0x417f700000000ULL,
    0x184e380000000ULL,
    0x4d42f40000000ULL,
    0xe9a3f60000000ULL,
    0x4e17270000000ULL,
    0x55de3d8000000ULL,
    0xadd85e4000000ULL,
    0xe1d9802000000ULL,
    0x5fd9c03000000ULL,
    0x30db602800000ULL,
    0x8a5e700c00000ULL,
    0x2e99b82e00000ULL,
    0xbf7a340b00000ULL,
    0x174f160b80000ULL,
    0x67c19739c0000ULL,
    0xc563658ba0000ULL,
    0x4bf0da69b0000ULL,
    0xffedce3638000ULL,
    0x1455d3286c000ULL,
    0x8afdcb9632000ULL,
    0x590f795b21000ULL,
    0x7ae7bda3f1800ULL,
    0x58b19e7059400ULL,
    0x294ae0107c600ULL,
    0xc8c3b018bb700ULL,
    0xdfe4d81ff5580ULL,
    0xdf31443eefdc0ULL,
    0xd60f2e35ab8e0ULL,
    0x90626339fcbd0ULL,
    0xd47713847afd8ULL,
    0x1caf3d54d4c9cULL,
    0xdaf713851e0f6ULL,
    0x4a6f3d61f3579ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x3000000000000ULL,
    0x8800000000000ULL,
    0xec00000000000ULL,
    0x1a00000000000ULL,
    0xb500000000000ULL,
    0x4680000000000ULL,
    0xf7c0000000000ULL,
    0xe320000000000ULL,
    0x1c90000000000ULL,
    0x3578000000000ULL,
    0x8884000000000ULL,
    0x7cc2000000000ULL,
    0x6a7000000000ULL,
    0x32d1800000000ULL,
    0x5a1c400000000ULL,
    0x2a73600000000ULL,
    0x5bcad00000000ULL,
    0xf1eea80000000ULL,
    0xa9fdb40000000ULL,
    0x6a42fe0000000ULL,
    0x964f90000000ULL,
    0x55f2f48000000ULL,
    0x808ea3c000000ULL,
    0x3809802000000ULL,
    0xccc8401000000ULL,
    0x2669603800000ULL,
    0xeb9d00c00000ULL,
    0xe1a5282200000ULL,
    0x8d52f43b00000ULL,
    0x215a1e0680000ULL,
    0x3391692d40000ULL,
    0x86fcbc91a0000ULL,
    0xd9c287fdf0000ULL,
    0x58273618c8000ULL,
    0x71179d1724000ULL,
    0xf73ca2b55e000ULL,
    0xfde0eeee21000ULL,
    0x6b300a9d30800ULL,
    0x672a5aeaa9c00ULL,
    0x325b749234600ULL,
    0x2216e3e7c7100ULL,
    0x6b8e0213cd80ULL,
    0x4da5900c02b40ULL,
    0x7756481833aa0ULL,
    0xa45824371b6d0ULL,
    0xfd14b622eebf8ULL,
    0x9d3cdd0bc83e4ULL,
    0x20e642a5a43d2ULL,
    0xf1b27ef61e68fULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x5000000000000ULL,
    0xf800000000000ULL,
    0xec00000000000ULL,
    0xa200000000000ULL,
    0xcd00000000000ULL,
    0x7a80000000000ULL,
    0x8640000000000ULL,
    0x8320000000000ULL,
    0x3e50000000000ULL,
    0x38b8000000000ULL,
    0x6784000000000ULL,
    0xc4c6000000000ULL,
    0x8963000000000ULL,
    0x4f72800000000ULL,
    0x33efc00000000ULL,
    0xc9bb600000000ULL,
    0x8707100000000ULL,
    0x383680000000ULL,
    0x82c2540000000ULL,
    0xc261720000000ULL,
    0x1ef4b90000000ULL,
    0xb42b828000000ULL,
    0x355ebdc000000ULL,
    0xa9b4802000000ULL,
    0xb78cc03000000ULL,
    0x9c49e01800000ULL,
    0x62a8d01400000ULL,
    0xb118083e00000ULL,
    0xd795443b00000ULL,
    0x5b5a1a2880000ULL,
    0x36b2ed3340000ULL,
    0xc80cf09ea0000ULL,
    0x248904e190000ULL,
    0xd1cd8280c8000ULL,
    0x8f6dbdff94000ULL,
    0xc4fe00362e000ULL,
    0x35a7003de1000ULL,
    0xea14801731800ULL,
    0xbe9cc00d58c00ULL,
    0x6751e0055ca00ULL,
    0xcc3cd004bbf00ULL,
    0xeec608044ed80ULL,
    0xa062443311c40ULL,
    0xb3f69a3e88da0ULL,
    0x9eaa2d0eb4950ULL,
    0x4b1b109e7e5c8ULL,
    0xc696d4d1c82e4ULL,
    0x2bd90ab21560aULL,
    0x69f039c6ee6f7ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x5000000000000ULL,
    0x8800000000000ULL,
    0x3400000000000ULL,
    0x1200000000000ULL,
    0x4f00000000000ULL,
    0x880000000000ULL,
    0x2e40000000000ULL,
    0xa0000000000ULL,
    0x8a30000000000ULL,
    0xc3b8000000000ULL,
    0x6f84000000000ULL,
    0x62c6000000000ULL,
    0x4e7000000000ULL,
    0x2992800000000ULL,
    0xef0c400000000ULL,
    0xeb7da00000000ULL,
    0x5862900000000ULL,
    0x85d3780000000ULL,
    0xc8adc40000000ULL,
    0xdcbb20000000ULL,
    0x2f9fe50000000ULL,
    0x91f0618000000ULL,
    0x3adf75c000000ULL,
    0xabd4802000000ULL,
    0x61ab403000000ULL,
    0xb84f203800000ULL,
    0x165ed01400000ULL,
    0x3f96d82200000ULL,
    0xaa0b540d00000ULL,
    0xf0feca0480000ULL,
    0x8a52113c0000ULL,
    0x7e31538220000ULL,
    0x31b8d0cb90000ULL,
    0x708741a028000ULL,
    0xe245a5d28c000ULL,
    0x1ea45828ee000ULL,
    0x3b37143fe1000ULL,
    0x2a3b6a02b1800ULL,
    0x2043b11839c00ULL,
    0x19a42bace4a00ULL,
    0xe7b214e503100ULL,
    0x467e739c7f680ULL,
    0xe7e600fe48a40ULL,
    0xaf1199bb7cde0ULL,
    0x184ef1ff37710ULL,
    0x665a9209b4ec8ULL,
    0x792351b8af94ULL,
    0x460a3992a3986ULL,
    0x5efb61deaf1d7ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0xd000000000000ULL,
    0x3800000000000ULL,
    0xd400000000000ULL,
    0x7a00000000000ULL,
    0x9100000000000ULL,
    0x680000000000ULL,
    0x4740000000000ULL,
    0x9660000000000ULL,
    0x3b30000000000ULL,
    0x5ba8000000000ULL,
    0x1f84000000000ULL,
    0xbdc6000000000ULL,
    0xa727000000000ULL,
    0x4256800000000ULL,
    0xb519c00000000ULL,
    0x40eaa00000000ULL,
    0xfe1d00000000ULL,
    0x61f5880000000ULL,
    0x1509b40000000ULL,
    0xcf117a0000000ULL,
    0x9a7dd30000000ULL,
    0x715fa98000000ULL,
    0x6d09054000000ULL,
    0x3b10802000000ULL,
    0xd07ec03000000ULL,
    0x85c203800000ULL,
    0x8788103400000ULL,
    0xd257280e00000ULL,
    0xad1c643500000ULL,
    0xa4eaf21e80000ULL,
    0x9de7672440000ULL,
    0x1cf65381a0000ULL,
    0xbd8e1651d0000ULL,
    0x6355098598000ULL,
    0x9b98d57ecc000ULL,
    0xbad080eea000ULL,
    0xe7837403e1000ULL,
    0x89c35a1971800ULL,
    0xd26c328c9c00ULL,
    0xeb50018015a00ULL,
    0x679fa17c06700ULL,
    0x7da8522f1aa80ULL,
    0x882b70668740ULL,
    0x5c45db8445620ULL,
    0x9e0a26e5e6d0ULL,
    0x46f2f3aeb65e8ULL,
    0x1c8cc66ab274cULL,
    0x8dd001a34c6a6ULL,
    0x30dfa1552a815ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x3000000000000ULL,
    0xf800000000000ULL,
    0x4c00000000000ULL,
    0x8a00000000000ULL,
    0xd900000000000ULL,
    0x1780000000000ULL,
    0x6e40000000000ULL,
    0xeca0000000000ULL,
    0x2a10000000000ULL,
    0x8b18000000000ULL,
    0x6a84000000000ULL,
    0xd7c2000000000ULL,
    0xb5e7000000000ULL,
    0x631800000000ULL,
    0x3fcfc00000000ULL,
    0x6bfe600000000ULL,
    0x5132500000000ULL,
    0x8f4bc80000000ULL,
    0xed3a3c0000000ULL,
    0xa753320000000ULL,
    0x113fc50000000ULL,
    0x9555e08000000ULL,
    0x643a80c000000ULL,
    0x38d3802000000ULL,
    0x2b78c01000000ULL,
    0x8ff7e03800000ULL,
    0xe529900c00000ULL,
    0x314fa83e00000ULL,
    0xb23b6c1300000ULL,
    0x3d37a2280000ULL,
    0x81f9393640000ULL,
    0xf8333285e0000ULL,
    0x80cbd5db90000ULL,
    0xff78489b28000ULL,
    0x39f6ecda84000ULL,
    0xae297a3ac6000ULL,
    0x83ca3906a1000ULL,
    0xb9f8b2b3f0800ULL,
    0x143715f279c00ULL,
    0xdacda8bd0c600ULL,
    0xee787cfab3f00ULL,
    0x9a7752259f980ULL,
    0x66e95259c940ULL,
    0x3c6da89b1af20ULL,
    0x5d687cf55a8f0ULL,
    0xe6ef520cbacc8ULL,
    0x32aa95212af14ULL,
    0xff0fa8ad03f82ULL,
    0x8e9f7ccf06603ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0x1000000000000ULL,
    0xc800000000000ULL,
    0x2400000000000ULL,
    0x2e00000000000ULL,
    0xe100000000000ULL,
    0xc080000000000ULL,
    0x9d40000000000ULL,
    0x4b60000000000ULL,
    0xea30000000000ULL,
    0x8488000000000ULL,
    0x8f84000000000ULL,
    0xfcc2000000000ULL,
    0x36a1000000000ULL,
    0x2c10800000000ULL,
    0xedde400000000ULL,
    0xc53d200000000ULL,
    0xd9cf700000000ULL,
    0xa4e0080000000ULL,
    0x26f5840000000ULL,
    0x6a2b2a0000000ULL,
    0x4f91bb0000000ULL,
    0x1b1b418000000ULL,
    0x3c9e7c4000000ULL,
    0xd45a802000000ULL,
    0x14fb401000000ULL,
    0x35efa00800000ULL,
    0x12b0300400000ULL,
    0x85cda83200000ULL,
    0x36e4b40900000ULL,
    0x25f6020b80000ULL,
    0x51ab4f3840000ULL,
    0x155063b020000ULL,
    0xc8ba436750000ULL,
    0xee0aebb2d8000ULL,
    0x8dc4876a8c000ULL,
    0x7e26618922000ULL,
    0xb5510c77e1000ULL,
    0x98ba882530800ULL,
    0x60ec410a8400ULL,
    0xb9c48a3a84200ULL,
    0x98218b0e37900ULL,
    0x7056e9b8ef480ULL,
    0x763ac86063dc0ULL,
    0x7a4c822040020ULL,
    0x32200f3c21610ULL,
    0xef57c39150ca8ULL,
    0xbfbe7369d96ecULL,
    0x138d43980c506ULL,
    0x2053342e2df1ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x9000000000000ULL,
    0x2800000000000ULL,
    0x9400000000000ULL,
    0x3e00000000000ULL,
    0xed00000000000ULL,
    0xd780000000000ULL,
    0x13c0000000000ULL,
    0xbe20000000000ULL,
    0x1cb0000000000ULL,
    0x4ed8000000000ULL,
    0x6484000000000ULL,
    0x5946000000000ULL,
    0xe261000000000ULL,
    0x9d54800000000ULL,
    0x6e49400000000ULL,
    0x71e8a00000000ULL,
    0x779bf00000000ULL,
    0xf6e4680000000ULL,
    0x5c153c0000000ULL,
    0xa02c5e0000000ULL,
    0x6eb8910000000ULL,
    0x5ed6f58000000ULL,
    0x838f4ec000000ULL,
    0x2ca802000000ULL,
    0x2cac403000000ULL,
    0x83fa200800000ULL,
    0x12b3b02400000ULL,
    0xdbd8480a00000ULL,
    0x2f078c2500000ULL,
    0x7080960f80000ULL,
    0xa7465d3b40000ULL,
    0x2f66c3b5e0000ULL,
    0xdad6e3c4f0000ULL,
    0x558e2b8f88000ULL,
    0x5bce9ff72c000ULL,
    0x552cd5bbb6000ULL,
    0x553cfecd21000ULL,
    0xef12c83451800ULL,
    0xeaabcc0998400ULL,
    0x32fab62ad5200ULL,
    0xdf35ed21d2500ULL,
    0xa31e8bac1a280ULL,
    0x17a16fc756fc0ULL,
    0x276bd88511a0ULL,
    0x977cc2df994f0ULL,
    0xd3f41609d5178ULL,
    0x15bf1d1553244ULL,
    0x305663bfda3d6ULL,
    0x59c913c77693bULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x3000000000000ULL,
    0x4800000000000ULL,
    0xac00000000000ULL,
    0xd200000000000ULL,
    0xb300000000000ULL,
    0x280000000000ULL,
    0x3840000000000ULL,
    0x63e0000000000ULL,
    0x6f10000000000ULL,
    0x98e8000000000ULL,
    0x3384000000000ULL,
    0x31c6000000000ULL,
    0x5d27000000000ULL,
    0x7ab1800000000ULL,
    0xbd1a400000000ULL,
    0xd9f9600000000ULL,
    0x726c900000000ULL,
    0xb7c0980000000ULL,
    0x1820940000000ULL,
    0x5535020000000ULL,
    0xd6ddbf0000000ULL,
    0x7bdec88000000ULL,
    0xe858af4000000ULL,
    0xc99f802000000ULL,
    0xcb9403000000ULL,
    0xa20ee03800000ULL,
    0x2911d00c00000ULL,
    0x3de8781200000ULL,
    0x2c06442b00000ULL,
    0x1204fa3480000ULL,
    0x5305bb2cc0000ULL,
    0x32855280a0000ULL,
    0x7046844e10000ULL,
    0xcfe3cab8f8000ULL,
    0xbd11106bc4000ULL,
    0x2bef48be3a000ULL,
    0x3102ef70e1000ULL,
    0x986e00671800ULL,
    0x3ec5d00049c00ULL,
    0x15a678002c600ULL,
    0x25f5442486900ULL,
    0xea7b7a105e580ULL,
    0x43acfb154b240ULL,
    0xeae3b28128260ULL,
    0x6293547f1c250ULL,
    0xe82db28b2f408ULL,
    0xf20545c826fcULL,
    0x9b232b444322ULL,
    0x5f9914467aebdULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x1000000000000ULL,
    0xe800000000000ULL,
    0xb400000000000ULL,
    0x3a00000000000ULL,
    0x9f00000000000ULL,
    0x8580000000000ULL,
    0x3dc0000000000ULL,
    0x38e0000000000ULL,
    0x34f0000000000ULL,
    0x7a28000000000ULL,
    0x7884000000000ULL,
    0x4b42000000000ULL,
    0x96a3000000000ULL,
    0xd8d0800000000ULL,
    0xabf400000000ULL,
    0x9f19a00000000ULL,
    0x6c4fd00000000ULL,
    0x8e31f80000000ULL,
    0xcb4dac0000000ULL,
    0x77b12e0000000ULL,
    0x889a70000000ULL,
    0x1255978000000ULL,
    0x7af9d94000000ULL,
    0x5e3a802000000ULL,
    0xa258401000000ULL,
    0x3eb201800000ULL,
    0xc263900400000ULL,
    0xdcb0d83a00000ULL,
    0xf7093c2d00000ULL,
    0xd093760e80000ULL,
    0xd79cdb27c0000ULL,
    0xbf0fc1a160000ULL,
    0x5495924f70000ULL,
    0x759d19ae38000ULL,
    0x6c0fae5d3c000ULL,
    0xb716efa68a000ULL,
    0x5958354a21000ULL,
    0x746a8e10d0800ULL,
    0xa4a5771ca8c00ULL,
    0xa3d4ef9ab4200ULL,
    0x3d3b354c6fd00ULL,
    0x99da0e1226680ULL,
    0x32a370ea3f40ULL,
    0xac054f9a547e0ULL,
    0x3600e5535f6b0ULL,
    0x9901f6363e4b8ULL,
    0x84809b234f69cULL,
    0xf546e19077e5eULL,
    0xaba5024bcbb65ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x7000000000000ULL,
    0xc800000000000ULL,
    0x5400000000000ULL,
    0xf200000000000ULL,
    0x3900000000000ULL,
    0xe980000000000ULL,
    0x44c0000000000ULL,
    0x59e0000000000ULL,
    0x5f10000000000ULL,
    0xe4b8000000000ULL,
    0xb684000000000ULL,
    0x4642000000000ULL,
    0xdda3000000000ULL,
    0x13b3800000000ULL,
    0x3a8e400000000ULL,
    0xf2cea00000000ULL,
    0x8069900000000ULL,
    0x195cc80000000ULL,
    0x9391cc0000000ULL,
    0xaffee60000000ULL,
    0xa2af0000000ULL,
    0xe030088000000ULL,
    0x34e9dc000000ULL,
    0x8a9802000000ULL,
    0x3eb9401000000ULL,
    0xeb87201800000ULL,
    0xf5c0d01c00000ULL,
    0x8463e83200000ULL,
    0x99d51c1500000ULL,
    0x4c5f0e3c80000ULL,
    0x5414b30e40000ULL,
    0x143c86ba60000ULL,
    0xbc46ed130000ULL,
    0xe363a6b678000ULL,
    0x4750bec7c4000ULL,
    0xe1a4e812e000ULL,
    0xa3b2a2e1a1000ULL,
    0xd28cc09b90800ULL,
    0xb6cf51ee68c00ULL,
    0xca6f66326ce00ULL,
    0xbc5fef19e3900ULL,
    0xdc15289053a80ULL,
    0x203d4df66a640ULL,
    0x89c1e804cf320ULL,
    0x12661c2950730ULL,
    0xfad48e1a49b98ULL,
    0xb8def3393dabcULL,
    0xc350268eaa822ULL,
    0x641efec9ee677ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x3000000000000ULL,
    0x5800000000000ULL,
    0x8c00000000000ULL,
    0xee00000000000ULL,
    0x7b00000000000ULL,
    0x2880000000000ULL,
    0xf4c0000000000ULL,
    0x9460000000000ULL,
    0xe270000000000ULL,
    0x8628000000000ULL,
    0xe984000000000ULL,
    0x546000000000ULL,
    0xfd21000000000ULL,
    0xe151800000000ULL,
    0x747ac00000000ULL,
    0x6178600000000ULL,
    0xf2fd700000000ULL,
    0xeb8d80000000ULL,
    0x5e1bc40000000ULL,
    0x700fe60000000ULL,
    0x9850830000000ULL,
    0x19f8438000000ULL,
    0x8e3ab94000000ULL,
    0x5edf802000000ULL,
    0xb66fc03000000ULL,
    0xb727e00800000ULL,
    0x4052b00c00000ULL,
    0x55ff381600000ULL,
    0x4039742300000ULL,
    0x15d8de3b80000ULL,
    0xc6edf71ec0000ULL,
    0xcfe69d8a20000ULL,
    0x3a364e7d30000ULL,
    0xcc889d8518000ULL,
    0xee934e489c000ULL,
    0x89f1d898a000ULL,
    0x57c88e4661000ULL,
    0xd0b6fdbf51800ULL,
    0x5d4f3e6048400ULL,
    0x517645bdd4600ULL,
    0x8aa98a5cdeb00ULL,
    0x7417b97fe180ULL,
    0xb822cd404f5c0ULL,
    0xfad6de2916360ULL,
    0x4c38f713eaf10ULL,
    0x3bd91db731f98ULL,
    0x9de98e681920cULL,
    0xd7677d841d90eULL,
    0x96f5fe6ecbee5ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0x7000000000000ULL,
    0x7800000000000ULL,
    0x6400000000000ULL,
    0xf200000000000ULL,
    0xeb00000000000ULL,
    0xc80000000000ULL,
    0x79c0000000000ULL,
    0x6d20000000000ULL,
    0x6fb0000000000ULL,
    0x3dc8000000000ULL,
    0xb984000000000ULL,
    0x1042000000000ULL,
    0x3561000000000ULL,
    0x66d3800000000ULL,
    0xbd1bc00000000ULL,
    0x659f200000000ULL,
    0xf659900000000ULL,
    0x4478580000000ULL,
    0xdd4ce40000000ULL,
    0x6e448e0000000ULL,
    0x2063090000000ULL,
    0x3f568d8000000ULL,
    0xbd5a464000000ULL,
    0x78f9802000000ULL,
    0xfc8ec01000000ULL,
    0x1766a00800000ULL,
    0xc5d7501c00000ULL,
    0x8d9ef81e00000ULL,
    0xfa5bb41900000ULL,
    0xfa7a763c80000ULL,
    0xa848bd3ac0000ULL,
    0x67c4fb8320000ULL,
    0x2826fb5e70000ULL,
    0x3e377bbb48000ULL,
    0x218d3b4bec000ULL,
    0x32e05ba772000ULL,
    0x390ab6261000ULL,
    0x81fa03b210800ULL,
    0xb0d4f5858400ULL,
    0x4a250d9334e00ULL,
    0xbd31864086f00ULL,
    0x610ea010c7c80ULL,
    0xd523500c26640ULL,
    0x6bb4f823f6160ULL,
    0x9fceb40d0f390ULL,
    0x5a83f62e0b238ULL,
    0xc67d0025c24ULL,
    0xdaa25ba05f236ULL,
    0x12f1ab7333d19ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0xb000000000000ULL,
    0x1800000000000ULL,
    0x1c00000000000ULL,
    0x2200000000000ULL,
    0x8700000000000ULL,
    0xac80000000000ULL,
    0x5840000000000ULL,
    0x2fe0000000000ULL,
    0xfab0000000000ULL,
    0x5068000000000ULL,
    0x7044000000000ULL,
    0x6be2000000000ULL,
    0xe4b1000000000ULL,
    0x456d800000000ULL,
    0x43c4c00000000ULL,
    0x8322e00000000ULL,
    0xb110100000000ULL,
    0x1739b80000000ULL,
    0x4599a40000000ULL,
    0xfb4c220000000ULL,
    0x85576f0000000ULL,
    0x62dd6d8000000ULL,
    0xb42fa74000000ULL,
    0x8da2e02000000ULL,
    0x2e50101000000ULL,
    0xb459b80800000ULL,
    0x5769a42c00000ULL,
    0x9cc4220600000ULL,
    0x13a36f0700000ULL,
    0x7b576d8880000ULL,
    0xa7daa761c0000ULL,
    0xfad600b20000ULL,
    0xd165d00610000ULL,
    0x5df6d803f8000ULL,
    0x5f0d7412ac000ULL,
    0x58b77a121a000ULL,
    0x976edb1b11000ULL,
    0xfcc0f79278800ULL,
    0x83a56c58ec400ULL,
    0xd351af9a7b600ULL,
    0xa3d9d856e1300ULL,
    0x31abb58330b80ULL,
    0x7462d36ee8040ULL,
    0x76759a3fd46e0ULL,
    0xabcecb3677690ULL,
    0x2f114fa2ab888ULL,
    0x4238c852b99bcULL,
    0x561f8d8c4c3b6ULL,
    0xa38fb75d2ad9dULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0xf000000000000ULL,
    0xd800000000000ULL,
    0x3400000000000ULL,
    0xc200000000000ULL,
    0x7b00000000000ULL,
    0x2080000000000ULL,
    0xa8c0000000000ULL,
    0x76e0000000000ULL,
    0x5050000000000ULL,
    0xccf8000000000ULL,
    0xfcc4000000000ULL,
    0x84e6000000000ULL,
    0x1357000000000ULL,
    0x287f800000000ULL,
    0x4e02c00000000ULL,
    0xbd07a00000000ULL,
    0xa181100000000ULL,
    0x3744580000000ULL,
    0xe4a7c40000000ULL,
    0xc174e60000000ULL,
    0x8cda70000000ULL,
    0xb3ad5a8000000ULL,
    0xe2bd63c000000ULL,
    0x93e7a02000000ULL,
    0x5d1103000000ULL,
    0xd9bc583800000ULL,
    0x9363c43c00000ULL,
    0xbd12e63600000ULL,
    0x875aa70d00000ULL,
    0x2f32dab080000ULL,
    0x87efa3dec0000ULL,
    0xc298002820000ULL,
    0xf054001a30000ULL,
    0x1cfe0025b8000ULL,
    0x34c3002814000ULL,
    0x98e180053e000ULL,
    0x3d51c03231000ULL,
    0xa57e2011b9800ULL,
    0xd784d01a15c00ULL,
    0x4e4478023fe00ULL,
    0x5f201439b0b00ULL,
    0xb9311e32f9e80ULL,
    0xeec733c74440ULL,
    0xa11a64beef160ULL,
    0xbc11c0c618f10ULL,
    0xd8dfbcb164b98ULL,
    0x5d77c4f6e6a9cULL,
    0xe6cd7abef4b6aULL,
    0xdeaab3e72fe8fULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x3000000000000ULL,
    0x3800000000000ULL,
    0x400000000000ULL,
    0x8e00000000000ULL,
    0x1300000000000ULL,
    0xa280000000000ULL,
    0xbf40000000000ULL,
    0x2a20000000000ULL,
    0x4ad0000000000ULL,
    0x5448000000000ULL,
    0x2344000000000ULL,
    0xb026000000000ULL,
    0x3fd7000000000ULL,
    0xe9c9800000000ULL,
    0x8c85c00000000ULL,
    0xbc46200000000ULL,
    0x60a3700000000ULL,
    0xf991180000000ULL,
    0xcc6cd40000000ULL,
    0xf091da0000000ULL,
    0xdbeb210000000ULL,
    0x1251ce8000000ULL,
    0x6e08364000000ULL,
    0x6ce6202000000ULL,
    0x6133703000000ULL,
    0xd1f9183800000ULL,
    0x82f8d40c00000ULL,
    0x7fda0e00000ULL,
    0x6f38210100000ULL,
    0x4d1e4ea380000ULL,
    0x3bcaf644c0000ULL,
    0xe5818008a0000ULL,
    0x5bc1c01fd0000ULL,
    0x5a60203288000ULL,
    0x7874701eb4000ULL,
    0x4d8981b12000ULL,
    0xe8a91409d1000ULL,
    0x4a77fa0f89800ULL,
    0x5dd8510b35c00ULL,
    0x3728d692d2600ULL,
    0x74b0e24cf1700ULL,
    0x5239fa0599880ULL,
    0xec9b513a9cdc0ULL,
    0xce0f569376460ULL,
    0x7ce62277ca350ULL,
    0x89305a3e2df68ULL,
    0xddfae1080f084ULL,
    0x30f9eea56613aULL,
    0x99784670637d9ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x1000000000000ULL,
    0xf800000000000ULL,
    0x9400000000000ULL,
    0x1600000000000ULL,
    0x4700000000000ULL,
    0x5480000000000ULL,
    0x46c0000000000ULL,
    0xa60000000000ULL,
    0xed90000000000ULL,
    0xdd58000000000ULL,
    0x1ac4000000000ULL,
    0xa066000000000ULL,
    0x7095000000000ULL,
    0x5cd8800000000ULL,
    0xa183c00000000ULL,
    0x6b42a00000000ULL,
    0x9325b00000000ULL,
    0x67b2b80000000ULL,
    0xd56d640000000ULL,
    0xa7ea960000000ULL,
    0x8e2ae30000000ULL,
    0x1cca548000000ULL,
    0x259bcec000000ULL,
    0x5ba2a02000000ULL,
    0x2b75b03000000ULL,
    0x520ab82800000ULL,
    0x33f9640400000ULL,
    0x7c34963e00000ULL,
    0xdb2be32500000ULL,
    0x214cd48580000ULL,
    0x44d90ed1c0000ULL,
    0x4586803520000ULL,
    0x3542c021b0000ULL,
    0xa824202a98000ULL,
    0x4937703f64000ULL,
    0x56ae980956000ULL,
    0xa80e1423b1000ULL,
    0x36fa0e2d99800ULL,
    0xd9b5f70de5400ULL,
    0x9e6eda8216200ULL,
    0xc168f9f9d0f00ULL,
    0x71ee5ab848a80ULL,
    0x692f39efad6c0ULL,
    0x584afaa6baae0ULL,
    0x9b5f89c7ea590ULL,
    0xc5c0c2b7e3258ULL,
    0xd0e12deeaff8cULL,
    0xc850f4a384b52ULL,
    0x7dba7ee1c603bULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0xf000000000000ULL,
    0x8800000000000ULL,
    0x7400000000000ULL,
    0xa600000000000ULL,
    0x4100000000000ULL,
    0x8980000000000ULL,
    0xa9c0000000000ULL,
    0xdaa0000000000ULL,
    0xfa70000000000ULL,
    0xf228000000000ULL,
    0xcfc4000000000ULL,
    0xbba2000000000ULL,
    0xe3f3000000000ULL,
    0x23ef800000000ULL,
    0xe960400000000ULL,
    0x93d1a00000000ULL,
    0xf6de300000000ULL,
    0x24a9880000000ULL,
    0x72860c0000000ULL,
    0x347ee0000000ULL,
    0xf5e7650000000ULL,
    0xc5961b8000000ULL,
    0xdcbc3d4000000ULL,
    0x81f9a02000000ULL,
    0x891a301000000ULL,
    0x770b881800000ULL,
    0x15750c3c00000ULL,
    0xea86e2200000ULL,
    0x2987251d00000ULL,
    0x79c7bba980000ULL,
    0xc2a20d5040000ULL,
    0xf670280260000ULL,
    0xa82c3c3a70000ULL,
    0x5cc4662ea8000ULL,
    0xd52669029c000ULL,
    0x82b4759e8a000ULL,
    0xd90c186ef1000ULL,
    0x60739ba768800ULL,
    0x412b7d78bcc00ULL,
    0x314580129be00ULL,
    0xa2e7403c28100ULL,
    0xe51420285c680ULL,
    0x78f970222b8c0ULL,
    0xdc9da83e20620ULL,
    0x9ccf7c2210830ULL,
    0x50d24625d97b8ULL,
    0xc05c193fb5194ULL,
    0x29ee5dad5666eULL,
    0x226724599b1f5ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x1000000000000ULL,
    0xa800000000000ULL,
    0x2c00000000000ULL,
    0x5200000000000ULL,
    0x5f00000000000ULL,
    0x7680000000000ULL,
    0x5a40000000000ULL,
    0xe360000000000ULL,
    0xadf0000000000ULL,
    0x4a78000000000ULL,
    0x7044000000000ULL,
    0x1862000000000ULL,
    0xd573000000000ULL,
    0xa538800000000ULL,
    0x3ea1400000000ULL,
    0xe753600000000ULL,
    0x2b29900000000ULL,
    0xb26e780000000ULL,
    0xed88f40000000ULL,
    0xb13eb20000000ULL,
    0xa8a00b0000000ULL,
    0xa653578000000ULL,
    0x40ae47c000000ULL,
    0x69ab602000000ULL,
    0xe2d901000000ULL,
    0xf7ec781800000ULL,
    0xf34bf40400000ULL,
    0x471e322a00000ULL,
    0x38b54b0b00000ULL,
    0x379a379480000ULL,
    0xcbf0d7d7c0000ULL,
    0xf37f983da0000ULL,
    0xffc7240690000ULL,
    0xada12a20d8000ULL,
    0x93d72f2f7c000ULL,
    0xe66a7db89e000ULL,
    0x1b8d68d711000ULL,
    0xe03b1db298800ULL,
    0x6b27f8f29cc00ULL,
    0x5195e58cee200ULL,
    0xf10a4ccd38500ULL,
    0x707a37930cd80ULL,
    0x2340d7feb6640ULL,
    0x4ce79838859e0ULL,
    0x6833242fb33d0ULL,
    0xb4db2a11772c8ULL,
    0xb7102f1124c2cULL,
    0x4348fd9b22f5eULL,
    0xdf1b28feafc1fULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0xb000000000000ULL,
    0xe800000000000ULL,
    0xe400000000000ULL,
    0xde00000000000ULL,
    0xbb00000000000ULL,
    0xe880000000000ULL,
    0x2440000000000ULL,
    0x4ba0000000000ULL,
    0x7c30000000000ULL,
    0xfd68000000000ULL,
    0xc244000000000ULL,
    0x8ca6000000000ULL,
    0xa6b7000000000ULL,
    0xe82d800000000ULL,
    0xec63400000000ULL,
    0x6351200000000ULL,
    0x2b9f00000000ULL,
    0x82bc580000000ULL,
    0x42ba040000000ULL,
    0xa2bb020000000ULL,
    0x12bc2d0000000ULL,
    0xfab9f98000000ULL,
    0x1eb84f4000000ULL,
    0xc0b9202000000ULL,
    0x7bbdf03000000ULL,
    0x933a583800000ULL,
    0xb77d042c00000ULL,
    0xfcde823a00000ULL,
    0x80eb6d3900000ULL,
    0x7d86d9b780000ULL,
    0xbfc2bf6ec0000ULL,
    0x3366f81a20000ULL,
    0x95d7b43910000ULL,
    0x7dfbfa2ae8000ULL,
    0x919c99330c000ULL,
    0xf2cf83855a000ULL,
    0xf077964991000ULL,
    0x72cf83b4a9800ULL,
    0x307796776dc00ULL,
    0x92cf83982b600ULL,
    0x8077966e08d00ULL,
    0x7acf83a83c480ULL,
    0x6477967aa27c0ULL,
    0xa4cf838a75160ULL,
    0xdf77966bff810ULL,
    0x4c4f83a427408ULL,
    0xfb37966fd2cb4ULL,
    0x7ef83b9ed1e6ULL,
    0x870796616ac3dULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x3000000000000ULL,
    0x9800000000000ULL,
    0x3c00000000000ULL,
    0x6e00000000000ULL,
    0x5300000000000ULL,
    0xb280000000000ULL,
    0xfa40000000000ULL,
    0x5060000000000ULL,
    0x5ed0000000000ULL,
    0xcc08000000000ULL,
    0x8044000000000ULL,
    0x8962000000000ULL,
    0x8d53000000000ULL,
    0x89c9800000000ULL,
    0x53e0c00000000ULL,
    0xf313e00000000ULL,
    0xdba8700000000ULL,
    0x9837180000000ULL,
    0x7a9b540000000ULL,
    0x4129320000000ULL,
    0x8676730000000ULL,
    0x18fdae8000000ULL,
    0x12fc944000000ULL,
    0x33fbe02000000ULL,
    0xec7c701000000ULL,
    0x5fbd181800000ULL,
    0xe31c540c00000ULL,
    0x45eab22600000ULL,
    0xba51b30f00000ULL,
    0x494dce9b80000ULL,
    0xc4a32454c0000ULL,
    0xeaf4980ca0000ULL,
    0x69bc942e90000ULL,
    0xac19520c18000ULL,
    0xc969c31bb4000ULL,
    0xbb12d69502000ULL,
    0xfac706f11000ULL,
    0x3237aa19d8800ULL,
    0x4b9de72794c00ULL,
    0x56af7c96d2600ULL,
    0xa1b6976668300ULL,
    0x6e5b56aedcf80ULL,
    0xb50cb07e5e1c0ULL,
    0x43c44a368fc60ULL,
    0x4a5973677d50ULL,
    0xcaf064a0b2cc8ULL,
    0x39b9c37f595ccULL,
    0x41864add50baULL,
    0x6d6dc34c33151ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x5000000000000ULL,
    0xe800000000000ULL,
    0x8c00000000000ULL,
    0x9200000000000ULL,
    0x1700000000000ULL,
    0x2680000000000ULL,
    0x9ac0000000000ULL,
    0xbe60000000000ULL,
    0x6bd0000000000ULL,
    0xfe88000000000ULL,
    0x5cc4000000000ULL,
    0xef66000000000ULL,
    0xdc51000000000ULL,
    0xf3ca800000000ULL,
    0xbfe3400000000ULL,
    0x8f92600000000ULL,
    0xce2d900000000ULL,
    0x2f76380000000ULL,
    0x9b38740000000ULL,
    0x519db60000000ULL,
    0x7929e30000000ULL,
    0x99f7a68000000ULL,
    0xc9ff204000000ULL,
    0x33fa602000000ULL,
    0x68f9903000000ULL,
    0xfc78380800000ULL,
    0x21bd741400000ULL,
    0x5159363a00000ULL,
    0x2c4fa32300000ULL,
    0xfea146a480000ULL,
    0xdeb4f045c0000ULL,
    0xe9dab829a0000ULL,
    0xf38a3416b0000ULL,
    0x5145562798000ULL,
    0x5927330ef4000ULL,
    0xdbf3fe85a2000ULL,
    0xf6fac47431000ULL,
    0xb979ee3f59800ULL,
    0x303c0702d4400ULL,
    0xbd1c28bd52a00ULL,
    0xe0eeb75d48d00ULL,
    0xa71070967c980ULL,
    0xd9ef537a7f640ULL,
    0x5c95feb8ff8e0ULL,
    0x66abc4503f1d0ULL,
    0xf8b36e341eed8ULL,
    0xc8df4708ee38cULL,
    0xfc0e48a39749aULL,
    0x38032775b3181ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x5000000000000ULL,
    0x9800000000000ULL,
    0x5c00000000000ULL,
    0xe00000000000ULL,
    0xc500000000000ULL,
    0xe080000000000ULL,
    0x5440000000000ULL,
    0x59a0000000000ULL,
    0xb690000000000ULL,
    0x9d8000000000ULL,
    0x4144000000000ULL,
    0x6122000000000ULL,
    0x1ed5000000000ULL,
    0xe7a800000000ULL,
    0xaad0c00000000ULL,
    0xd478e00000000ULL,
    0x5d1700000000ULL,
    0xf3fea80000000ULL,
    0xe212c40000000ULL,
    0x8798c20000000ULL,
    0xb7e77d0000000ULL,
    0xf031fc8000000ULL,
    0xf0cefac000000ULL,
    0x3b5ae02000000ULL,
    0x9e04701000000ULL,
    0xbd04282800000ULL,
    0x4c82041400000ULL,
    0x9240222600000ULL,
    0x58a60d1700000ULL,
    0x417548380000ULL,
    0x96983ef140000ULL,
    0x3d60221820000ULL,
    0x63760d0510000ULL,
    0x1aef54be68000ULL,
    0xa00c3ef9a4000ULL,
    0x74ba220476000ULL,
    0x82370d1751000ULL,
    0x2bcfd4b3c8800ULL,
    0x26ddfee2f5400ULL,
    0x26c2423dbea00ULL,
    0x26e7bd38a4300ULL,
    0x3ab11c88f6380ULL,
    0xc38b8ac9905c0ULL,
    0x817e4800a9aa0ULL,
    0x9d57b43ac5b10ULL,
    0xbbc6a0446b08ULL,
    0x7db4b922a89f4ULL,
    0x3009bea3c4df2ULL,
    0xcb847c4c68ebULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x9000000000000ULL,
    0x3800000000000ULL,
    0xfc00000000000ULL,
    0xea00000000000ULL,
    0x6100000000000ULL,
    0x3080000000000ULL,
    0xcb40000000000ULL,
    0xf0a0000000000ULL,
    0xb010000000000ULL,
    0x3158000000000ULL,
    0x7244000000000ULL,
    0xcc26000000000ULL,
    0x9955000000000ULL,
    0xf4fc800000000ULL,
    0xdcd5c00000000ULL,
    0x4139e00000000ULL,
    0xa036500000000ULL,
    0x1209880000000ULL,
    0x7fb9440000000ULL,
    0x4c773a0000000ULL,
    0xc12a150000000ULL,
    0x396ce88000000ULL,
    0xa4481ec000000ULL,
    0xa59fe02000000ULL,
    0x5e23503000000ULL,
    0x6455082800000ULL,
    0x1e7c842400000ULL,
    0xde96da0e00000ULL,
    0x4518453f00000ULL,
    0xcd6360ba80000ULL,
    0x58f45ad840000ULL,
    0xec6c5a2c20000ULL,
    0x4ac88502d0000ULL,
    0x11de009428000ULL,
    0x4103cac804000ULL,
    0x6082322256000ULL,
    0x5346911391000ULL,
    0x9ca232a189800ULL,
    0x62145bda15400ULL,
    0xac5a809f1f200ULL,
    0xa8c20acae5700ULL,
    0x6665d21ee6780ULL,
    0x5971c10849940ULL,
    0x8fa93aa2f4620ULL,
    0x1d29dfeaaf510ULL,
    0x836eda88bc4e8ULL,
    0x5d4e8fed5bc54ULL,
    0xf91dd281921a2ULL,
    0x47670bfc2677bULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0xb000000000000ULL,
    0xf800000000000ULL,
    0x1c00000000000ULL,
    0x3200000000000ULL,
    0xeb00000000000ULL,
    0x7380000000000ULL,
    0x2140000000000ULL,
    0x7de0000000000ULL,
    0x55b0000000000ULL,
    0x3088000000000ULL,
    0x4244000000000ULL,
    0x8a62000000000ULL,
    0xcaf1000000000ULL,
    0xdc6d800000000ULL,
    0x6b73c00000000ULL,
    0xc62ae00000000ULL,
    0xd14900000000ULL,
    0xe6d8d80000000ULL,
    0x96795c0000000ULL,
    0x342a6a0000000ULL,
    0x8612bf0000000ULL,
    0x55b958000000ULL,
    0xff3cc84000000ULL,
    0xadc8e02000000ULL,
    0xfda5901000000ULL,
    0xecd5580800000ULL,
    0x25fa9c2c00000ULL,
    0x75688a3e00000ULL,
    0x6bf22f0700000ULL,
    0x18e94d8c80000ULL,
    0x2bb0947ac0000ULL,
    0xc18d0a3ce0000ULL,
    0xaec5ef1850000ULL,
    0xbea1ad9778000ULL,
    0xab5504796c000ULL,
    0x42b8521222000ULL,
    0x858f730791000ULL,
    0x70c127a618800ULL,
    0xbfa32b647c400ULL,
    0x9fd31fb5fb600ULL,
    0xda7ee7458cf00ULL,
    0x2e29ad8a72b80ULL,
    0x19110450e9240ULL,
    0x10da523f74360ULL,
    0xe37e73065f570ULL,
    0x66aca78a6a1a8ULL,
    0x23d0eb5794efcULL,
    0x1879ffb40f856ULL,
    0x1d2a775012c21ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x5000000000000ULL,
    0x9800000000000ULL,
    0x1c00000000000ULL,
    0x5e00000000000ULL,
    0xab00000000000ULL,
    0x8580000000000ULL,
    0x3cc0000000000ULL,
    0xa660000000000ULL,
    0x2370000000000ULL,
    0xbc88000000000ULL,
    0xd3c4000000000ULL,
    0xc1e2000000000ULL,
    0x5ab7000000000ULL,
    0xfc6a800000000ULL,
    0xcdf0c00000000ULL,
    0xa5cae00000000ULL,
    0xf961f00000000ULL,
    0x8cf5d80000000ULL,
    0x414fec0000000ULL,
    0xd127860000000ULL,
    0x2ad1030000000ULL,
    0x101ba38000000ULL,
    0xe6fdb84000000ULL,
    0x27c8e02000000ULL,
    0xac66f01000000ULL,
    0x1277583800000ULL,
    0x300b2c1400000ULL,
    0xcf87662600000ULL,
    0xedc3f30700000ULL,
    0x7ae6fb9780000ULL,
    0xa735946ac0000ULL,
    0x8caf060160000ULL,
    0xad96c31f30000ULL,
    0x31bbc39198000ULL,
    0x9e6c885cdc000ULL,
    0xc8f7d82922000ULL,
    0xa348ec23f1000ULL,
    0x9425061ff8800ULL,
    0xcc55c3286dc00ULL,
    0x2d5b43b87aa00ULL,
    0x3e5f487b4c300ULL,
    0x57ddb8376ab80ULL,
    0x1d1adc0c447c0ULL,
    0xc47abe157f760ULL,
    0xb8881f3f92fb0ULL,
    0xd1c37d8ba9618ULL,
    0xd4e39753c580cULL,
    0x243625a3be48eULL,
    0xdd2fbb44f25e1ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x1000000000000ULL,
    0x3800000000000ULL,
    0xc400000000000ULL,
    0x6e00000000000ULL,
    0x5900000000000ULL,
    0x3680000000000ULL,
    0xb7c0000000000ULL,
    0xb5e0000000000ULL,
    0xc790000000000ULL,
    0xc2f8000000000ULL,
    0x62c4000000000ULL,
    0xe162000000000ULL,
    0xb55000000000ULL,
    0x9a98800000000ULL,
    0xef15c00000000ULL,
    0xe43c200000000ULL,
    0xada2700000000ULL,
    0x1330480000000ULL,
    0xb74d740000000ULL,
    0xfa4f1e0000000ULL,
    0x7ac91f0000000ULL,
    0xe009d48000000ULL,
    0x256f53c000000ULL,
    0xf03e202000000ULL,
    0x1ba7701000000ULL,
    0x3e30c82800000ULL,
    0xc7ccb40400000ULL,
    0xe8893e0e00000ULL,
    0x53aa6f3100000ULL,
    0xa75b1c9b80000ULL,
    0x3df6e7d640000ULL,
    0xd42f9e2da0000ULL,
    0x3a18df3df0000ULL,
    0x25d7f48578000ULL,
    0xb95823f5e4000ULL,
    0xacf6e81ebe000ULL,
    0xaeafc439b1000ULL,
    0xfdbf60bd8800ULL,
    0x5b33db1095400ULL,
    0xbb4aa2a506200ULL,
    0xd84948e735700ULL,
    0xa1c8a2aff7080ULL,
    0x1d8c48dccc9c0ULL,
    0x572822b1d2120ULL,
    0xf39d88cc925d0ULL,
    0xb19602adb3478ULL,
    0xffaf8c88307cULL,
    0xa246cab39a552ULL,
    0xdba64cd96fa4fULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0x7000000000000ULL,
    0x800000000000ULL,
    0xf400000000000ULL,
    0x1200000000000ULL,
    0x6700000000000ULL,
    0x180000000000ULL,
    0xe840000000000ULL,
    0xb920000000000ULL,
    0xb6f0000000000ULL,
    0x5c68000000000ULL,
    0x4d44000000000ULL,
    0xe7a2000000000ULL,
    0x8331000000000ULL,
    0x9b0b800000000ULL,
    0x3f94400000000ULL,
    0x9fbda00000000ULL,
    0x69dd900000000ULL,
    0x78eb80000000ULL,
    0x55574c0000000ULL,
    0x8558620000000ULL,
    0x654b990000000ULL,
    0xbbb4ef8000000ULL,
    0x9bce9f4000000ULL,
    0xbe77a02000000ULL,
    0x74a8901000000ULL,
    0x48a7380800000ULL,
    0x16b20c1c00000ULL,
    0x314e420200000ULL,
    0x99b2493d00000ULL,
    0xd4cff78480000ULL,
    0x3bf04359c0000ULL,
    0x86eb7a2060000ULL,
    0x6281452a10000ULL,
    0xb3c235a648000ULL,
    0xe2624a71bc000ULL,
    0x6c532db51a000ULL,
    0x6dd9967e51000ULL,
    0x5d8e779568800ULL,
    0xe65103750c400ULL,
    0xe6df5a0ca2e00ULL,
    0xe2099504f5100ULL,
    0xf712ad8727680ULL,
    0xd778d64f0b640ULL,
    0x3c3a57b019ae0ULL,
    0x8e99d348d4d30ULL,
    0x1b2fc21a16988ULL,
    0x61e3093bf2a64ULL,
    0xfb13d7bb1ddbeULL,
    0x797c934cebb7dULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0xd000000000000ULL,
    0x8800000000000ULL,
    0x5400000000000ULL,
    0x9600000000000ULL,
    0x3100000000000ULL,
    0x7f80000000000ULL,
    0xfec0000000000ULL,
    0x9120000000000ULL,
    0x8550000000000ULL,
    0x24c8000000000ULL,
    0xbdc4000000000ULL,
    0xf1a2000000000ULL,
    0x9915000000000ULL,
    0xaeae800000000ULL,
    0x2c70400000000ULL,
    0x4d98a00000000ULL,
    0xa30db00000000ULL,
    0xe761080000000ULL,
    0x6c30bc0000000ULL,
    0x45fed60000000ULL,
    0x35bef90000000ULL,
    0xc5dd428000000ULL,
    0x5f6fca4000000ULL,
    0x37d2a02000000ULL,
    0xf78cb01000000ULL,
    0x5d25882800000ULL,
    0x2f51fc3400000ULL,
    0xa7caf62200000ULL,
    0x3d46091500000ULL,
    0x9de26aa580000ULL,
    0x4b76864c40000ULL,
    0xe31fde3fe0000ULL,
    0x524e452fb0000ULL,
    0xd083948c48000ULL,
    0xa441335554000ULL,
    0x2667e28b32000ULL,
    0xbb77a6a71000ULL,
    0xc73d2811e8800ULL,
    0xb69c4c0e05400ULL,
    0x6f8bfe3e4ba00ULL,
    0x6126b515ac100ULL,
    0x9d54bcb0ae280ULL,
    0x58cc7f50d76c0ULL,
    0xafc09caa8a420ULL,
    0xdea48f578d2f0ULL,
    0x8397b49ebf358ULL,
    0xb9e9c351cefe4ULL,
    0x7290ca9da6f0aULL,
    0x266a3663e2e29ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x3000000000000ULL,
    0x6800000000000ULL,
    0x3c00000000000ULL,
    0x5200000000000ULL,
    0xf700000000000ULL,
    0x6980000000000ULL,
    0x6640000000000ULL,
    0x9160000000000ULL,
    0x20b0000000000ULL,
    0x5258000000000ULL,
    0xf744000000000ULL,
    0xb1e6000000000ULL,
    0xf271000000000ULL,
    0x5ff9800000000ULL,
    0x4f57400000000ULL,
    0xad2fe00000000ULL,
    0x2a3f900000000ULL,
    0x9374380000000ULL,
    0x377f0c0000000ULL,
    0x9196520000000ULL,
    0x9a8adb0000000ULL,
    0x59291d8000000ULL,
    0xb4392ec000000ULL,
    0x7e71e02000000ULL,
    0xa5fa903000000ULL,
    0xa453b80800000ULL,
    0xa6ad4c0c00000ULL,
    0xd37e321a00000ULL,
    0x57970b0f00000ULL,
    0x238d459480000ULL,
    0xa5aff2fdc0000ULL,
    0x24fdea3a60000ULL,
    0xdcd3972990000ULL,
    0x20692fac58000ULL,
    0xb0db25c42c000ULL,
    0x4a8325ae96000ULL,
    0xa1c322c2d1000ULL,
    0x72203210f9800ULL,
    0x1f520b3d5c400ULL,
    0x152ac59f9e600ULL,
    0x6e3db2c945d00ULL,
    0xa5758a2193f80ULL,
    0xc67e470063e40ULL,
    0x611577b6ab0e0ULL,
    0x3049f9d85ec30ULL,
    0x30892f8c24148ULL,
    0xa2b25f482f6cULL,
    0xfbbb258dfa276ULL,
    0xb13722cae69bbULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x7000000000000ULL,
    0xa800000000000ULL,
    0xec00000000000ULL,
    0xb600000000000ULL,
    0x9500000000000ULL,
    0xef80000000000ULL,
    0x61c0000000000ULL,
    0x5520000000000ULL,
    0x9070000000000ULL,
    0xc348000000000ULL,
    0x36c4000000000ULL,
    0xfda6000000000ULL,
    0x4137000000000ULL,
    0xe32b800000000ULL,
    0xacd1400000000ULL,
    0x2ff9600000000ULL,
    0x332eb00000000ULL,
    0x54d5280000000ULL,
    0xfbfb3c0000000ULL,
    0xb12cee0000000ULL,
    0x33d3d90000000ULL,
    0xdb7b0b8000000ULL,
    0x1c6b364000000ULL,
    0x7db7602000000ULL,
    0x906db03000000ULL,
    0x7bb0a83800000ULL,
    0x4d697c1c00000ULL,
    0x8300e2a00000ULL,
    0x32af293b00000ULL,
    0x2412c3ad80000ULL,
    0xfb5cfa6540000ULL,
    0x139a461be0000ULL,
    0x773da52870000ULL,
    0x1f8885ad48000ULL,
    0xa0615f781c000ULL,
    0x5a12c3bad2000ULL,
    0x325cfa46b1000ULL,
    0x21a460ae9800ULL,
    0x1ffda5190dc00ULL,
    0xbb2885912ae00ULL,
    0x28d15f5444500ULL,
    0x95fac3b936580ULL,
    0x6028fa4697ac0ULL,
    0x8654462b874a0ULL,
    0x99bea5227fcf0ULL,
    0x33cd05af8abb8ULL,
    0x63831f47d5364ULL,
    0x67c6238c0e22eULL,
    0x88240a6bc39d9ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0xb000000000000ULL,
    0xd800000000000ULL,
    0xd400000000000ULL,
    0x2a00000000000ULL,
    0xd300000000000ULL,
    0x6280000000000ULL,
    0xcbc0000000000ULL,
    0x59e0000000000ULL,
    0x6450000000000ULL,
    0x7f8000000000ULL,
    0x8944000000000ULL,
    0x6222000000000ULL,
    0x45b5000000000ULL,
    0x7ad800000000ULL,
    0x7cbac00000000ULL,
    0xec60a00000000ULL,
    0x6f16500000000ULL,
    0x5ade180000000ULL,
    0x4074540000000ULL,
    0x3f4c3e0000000ULL,
    0xdd6c3f0000000ULL,
    0xd8df6a8000000ULL,
    0x7f7073c000000ULL,
    0xb3cd202000000ULL,
    0x87ac901000000ULL,
    0x3cbeb82800000ULL,
    0x4c62042c00000ULL,
    0xdf12263600000ULL,
    0x82d86b3500000ULL,
    0x9473548a80000ULL,
    0x154c4cf4c0000ULL,
    0xe6a4ab8a0000ULL,
    0xba58e3e2f0000ULL,
    0xb4b1981e78000ULL,
    0xea2b942514000ULL,
    0xe3f91e1ffe000ULL,
    0x3b44af3b51000ULL,
    0xc523d2a408800ULL,
    0xbd3777d0ad400ULL,
    0xc76a8633cb600ULL,
    0x93da3b091eb00ULL,
    0x69f74c9dc0280ULL,
    0xe20918dc21940ULL,
    0xd549f49731860ULL,
    0xee6b1cce58150ULL,
    0xaa5bd294258f8ULL,
    0xdcb377cca74fcULL,
    0xe6288609f43aaULL,
    0x1dff3b2a6fecfULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x3000000000000ULL,
    0x4800000000000ULL,
    0x8400000000000ULL,
    0x7600000000000ULL,
    0x300000000000ULL,
    0xa180000000000ULL,
    0x40000000000ULL,
    0xca0000000000ULL,
    0x46f0000000000ULL,
    0xfd48000000000ULL,
    0x85c4000000000ULL,
    0x6ae2000000000ULL,
    0x5153000000000ULL,
    0xe639800000000ULL,
    0xc2ce400000000ULL,
    0x1282200000000ULL,
    0xa9c2b00000000ULL,
    0xe8e2980000000ULL,
    0xc56cc0000000ULL,
    0xf0be620000000ULL,
    0x5d0bf50000000ULL,
    0x99679f8000000ULL,
    0x3413fe4000000ULL,
    0x501ba02000000ULL,
    0xd9fcf01000000ULL,
    0x5928b81800000ULL,
    0x97507c0c00000ULL,
    0xed3efa1200000ULL,
    0x874e392100000ULL,
    0x54c07d9d80000ULL,
    0xee664b40c0000ULL,
    0x8b961f8860000ULL,
    0x8759be5010000ULL,
    0x7adb803b28000ULL,
    0xd09d400dbc000ULL,
    0x353ba03552000ULL,
    0x5b4cf00c71000ULL,
    0xbec0b81538800ULL,
    0x67647c3594c00ULL,
    0x9314fa0c6e600ULL,
    0xd799393063900ULL,
    0xa2bbfdafe8880ULL,
    0x380b0b7bdcac0ULL,
    0x23e5bfa642a60ULL,
    0x69d14e63d8b30ULL,
    0xe6f93821c5188ULL,
    0x62aa3c3e673d4ULL,
    0x3616da0f6f07eULL,
    0x4d1b8904e3af9ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x1000000000000ULL,
    0xe800000000000ULL,
    0x1400000000000ULL,
    0x2200000000000ULL,
    0x8d00000000000ULL,
    0x1980000000000ULL,
    0xf7c0000000000ULL,
    0x6920000000000ULL,
    0x1470000000000ULL,
    0x7898000000000ULL,
    0xaa44000000000ULL,
    0xf4e6000000000ULL,
    0x9453000000000ULL,
    0xaf68800000000ULL,
    0x541b400000000ULL,
    0x1802a00000000ULL,
    0x2c04100000000ULL,
    0xbe07e80000000ULL,
    0xab070c0000000ULL,
    0x5e805e0000000ULL,
    0x7742f90000000ULL,
    0xa565db8000000ULL,
    0x79760c000000ULL,
    0x1c4a202000000ULL,
    0x316f503000000ULL,
    0x4f1d481800000ULL,
    0xde871c0400000ULL,
    0xb741b63a00000ULL,
    0xc566f50500000ULL,
    0x1795058880000ULL,
    0xf44ad9e340000ULL,
    0x256b5ba660000ULL,
    0x6d1f20cdf0000ULL,
    0x5380002248000ULL,
    0xaec000311c000ULL,
    0x32a0003c26000ULL,
    0x7eb0002b91000ULL,
    0xe038000fb9800ULL,
    0x5df4000354c00ULL,
    0xc75e00253a200ULL,
    0xa767000bb6d00ULL,
    0x3a96801a28a80ULL,
    0x9dcc4033ed040ULL,
    0x2aac202beffa0ULL,
    0xf83c50054cc30ULL,
    0x71f5c834bf978ULL,
    0x795c5c12557e4ULL,
    0xc63163fbad6eULL,
    0x6412e531f7c83ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x5000000000000ULL,
    0x5800000000000ULL,
    0x4c00000000000ULL,
    0x2e00000000000ULL,
    0x5900000000000ULL,
    0x5780000000000ULL,
    0x2b40000000000ULL,
    0x14a0000000000ULL,
    0xb410000000000ULL,
    0x3ac8000000000ULL,
    0x32c4000000000ULL,
    0xd6e6000000000ULL,
    0xdf31000000000ULL,
    0xe19a800000000ULL,
    0x26aec00000000ULL,
    0x6b30600000000ULL,
    0x139e700000000ULL,
    0x29ad480000000ULL,
    0x79b0fc0000000ULL,
    0x195efa0000000ULL,
    0x34c350000000ULL,
    0xa084588000000ULL,
    0xe5c6024000000ULL,
    0x4862e02000000ULL,
    0xdbf4b03000000ULL,
    0xc27b280800000ULL,
    0xf01f8c1400000ULL,
    0xf0e9321600000ULL,
    0x6212091300000ULL,
    0xbfcac28b80000ULL,
    0x3344475640000ULL,
    0xb8a3f0b5e0000ULL,
    0xea164e7ad0000ULL,
    0x6bc9322d28000ULL,
    0x7142090904000ULL,
    0x9fa2c290b2000ULL,
    0xbc90474bb1000ULL,
    0x5b0df08839800ULL,
    0x60a34e428c400ULL,
    0x6615b20e06a00ULL,
    0x65cdc9313bb00ULL,
    0x7840229404180ULL,
    0x9024f764339c0ULL,
    0xdbd6d8bc71520ULL,
    0x61acc24a993f0ULL,
    0x8db4800b3c3e8ULL,
    0xb5bc0033e4d4ULL,
    0x7c4ce02b36362ULL,
    0xba01b027c2709ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0xf000000000000ULL,
    0x6800000000000ULL,
    0xcc00000000000ULL,
    0xae00000000000ULL,
    0x2700000000000ULL,
    0xf780000000000ULL,
    0x98c0000000000ULL,
    0xa7a0000000000ULL,
    0x5fb0000000000ULL,
    0xdba8000000000ULL,
    0x944000000000ULL,
    0x6462000000000ULL,
    0xe991000000000ULL,
    0x7df800000000ULL,
    0x44cf400000000ULL,
    0x4150600000000ULL,
    0xa87e700000000ULL,
    0x77bb80000000ULL,
    0xacfd7c0000000ULL,
    0x223ee60000000ULL,
    0xf69ead0000000ULL,
    0x54ad758000000ULL,
    0x52c5f94000000ULL,
    0x82a7e02000000ULL,
    0xf135301000000ULL,
    0xbe9d80800000ULL,
    0x65a20c3c00000ULL,
    0x66b2de1a00000ULL,
    0x4328913300000ULL,
    0x5a01f3ab80000ULL,
    0x9d042449c0000ULL,
    0xfa86ad9de0000ULL,
    0xda46f57630000ULL,
    0x29e2be01e8000ULL,
    0x7c56e13bec000ULL,
    0xe2fa4ba4ea000ULL,
    0x9539584d51000ULL,
    0xb9184b8898800ULL,
    0x98685850a4400ULL,
    0xff67cbbf97e00ULL,
    0x98171852c3d00ULL,
    0x541fabb65c180ULL,
    0x4aed6844c39c0ULL,
    0xc92613875cee0ULL,
    0xeff11468425f0ULL,
    0x674f75831d398ULL,
    0x9394f97562eb4ULL,
    0x6ad860004c3d6ULL,
    0xd64a7018faee5ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0xb000000000000ULL,
    0x6800000000000ULL,
    0xdc00000000000ULL,
    0x9600000000000ULL,
    0xb900000000000ULL,
    0x1c80000000000ULL,
    0xf40000000000ULL,
    0xefa0000000000ULL,
    0x8030000000000ULL,
    0xba68000000000ULL,
    0xddc4000000000ULL,
    0xade2000000000ULL,
    0x5913000000000ULL,
    0xaa1d800000000ULL,
    0x458f400000000ULL,
    0x3fd0e00000000ULL,
    0x387db00000000ULL,
    0xf85f480000000ULL,
    0x64a8240000000ULL,
    0x4ba0da0000000ULL,
    0x3231ad0000000ULL,
    0xf168b98000000ULL,
    0xea44df4000000ULL,
    0x2525602000000ULL,
    0x5676f01000000ULL,
    0xf94da81800000ULL,
    0x3ab6942c00000ULL,
    0x242a121a00000ULL,
    0x92e2c93700000ULL,
    0x49283a580000ULL,
    0xdddfc26e40000ULL,
    0x376d11a720000ULL,
    0xcb464b53d0000ULL,
    0xeda57203e8000ULL,
    0xa333391c0c000ULL,
    0x51e8abac9a000ULL,
    0xc301166c71000ULL,
    0x1b8063b4f8800ULL,
    0x16c1725f04c00ULL,
    0xda67d9b027600ULL,
    0xb1d52f40f3d00ULL,
    0x157f48113c380ULL,
    0x7ed82426c36c0ULL,
    0x9ce8da0ce5d20ULL,
    0xb585ad3b17090ULL,
    0xebc2b9afaab68ULL,
    0x84e3df7729ab4ULL,
    0xfd92e004edce6ULL,
    0xa15eb0202a27dULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x5000000000000ULL,
    0x3800000000000ULL,
    0xd400000000000ULL,
    0x1600000000000ULL,
    0xd900000000000ULL,
    0x6a80000000000ULL,
    0xe940000000000ULL,
    0x7320000000000ULL,
    0xe170000000000ULL,
    0xa1b8000000000ULL,
    0x71c4000000000ULL,
    0xdd62000000000ULL,
    0x3dd5000000000ULL,
    0x690a800000000ULL,
    0x691dc00000000ULL,
    0x4f70a00000000ULL,
    0xecbfb00000000ULL,
    0xad45480000000ULL,
    0xbd22140000000ULL,
    0x1c752a0000000ULL,
    0xb53f090000000ULL,
    0xad84b38000000ULL,
    0x6c431c000000ULL,
    0xfae2202000000ULL,
    0x816701000000ULL,
    0x7a6fe82800000ULL,
    0xa9cca41400000ULL,
    0x32f8e20e00000ULL,
    0x59e5dd3500000ULL,
    0x3993b98580000ULL,
    0x96ad48f640000ULL,
    0xd0297bbaa0000ULL,
    0x1b6ee5ea50000ULL,
    0x574d2a14c8000ULL,
    0x6dbb093c5c000ULL,
    0xa3c6b38e6e000ULL,
    0x8a6131fd71000ULL,
    0xa50a01cd8800ULL,
    0xc4cfb01c35400ULL,
    0xfe7d482d62a00ULL,
    0xa1a6140257700ULL,
    0x9c372a1bb4280ULL,
    0x649a090c23ec0ULL,
    0x19b6339a77520ULL,
    0x2e5df1fd25850ULL,
    0x715080228bca8ULL,
    0xd14cc0141b824ULL,
    0x6cb82032b30ceULL,
    0xed477038df3c7ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x5000000000000ULL,
    0x8800000000000ULL,
    0xd400000000000ULL,
    0xce00000000000ULL,
    0xfb00000000000ULL,
    0xb880000000000ULL,
    0xc340000000000ULL,
    0xa4e0000000000ULL,
    0xe850000000000ULL,
    0x8ab8000000000ULL,
    0x69c4000000000ULL,
    0x46a6000000000ULL,
    0xa133000000000ULL,
    0xb22a800000000ULL,
    0xb458400000000ULL,
    0x7494a00000000ULL,
    0xef9b700000000ULL,
    0xe332580000000ULL,
    0x1b2d040000000ULL,
    0x8ddbfa0000000ULL,
    0x6a55770000000ULL,
    0x43bfaa8000000ULL,
    0x4569c000000ULL,
    0xd066202000000ULL,
    0xd917303000000ULL,
    0x9f58f81800000ULL,
    0x8411741400000ULL,
    0x98dd222200000ULL,
    0xd9d7333500000ULL,
    0x807c70b380000ULL,
    0x6be02efec0000ULL,
    0xed5f28e20000ULL,
    0x5afc6dc0d0000ULL,
    0xf1a3da1138000ULL,
    0x2bb5471e14000ULL,
    0xa06bd298ae000ULL,
    0x453f5dfb71000ULL,
    0x4005222029800ULL,
    0xa00333138cc00ULL,
    0x300270a92aa00ULL,
    0xd8072ef706100ULL,
    0x5c0172983d280ULL,
    0x1a032df422dc0ULL,
    0x3503fa38da960ULL,
    0x4381773c6e410ULL,
    0x7bc1aa84517e8ULL,
    0x67a269f9789dcULL,
    0x4cb2a03574caaULL,
    0x62e870049f8a7ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0xd000000000000ULL,
    0x800000000000ULL,
    0x9c00000000000ULL,
    0x3200000000000ULL,
    0xeb00000000000ULL,
    0xa080000000000ULL,
    0xc140000000000ULL,
    0x1f60000000000ULL,
    0xc270000000000ULL,
    0xc7e8000000000ULL,
    0x37c4000000000ULL,
    0x8326000000000ULL,
    0x9095000000000ULL,
    0xf15e800000000ULL,
    0x5f8c400000000ULL,
    0x7f36e00000000ULL,
    0x5a8a900000000ULL,
    0x66b0d80000000ULL,
    0xa04dc40000000ULL,
    0xc013aa0000000ULL,
    0x281d0b0000000ULL,
    0x74e99b8000000ULL,
    0xc344034000000ULL,
    0x4c60602000000ULL,
    0x86f2d03000000ULL,
    0x70a8382800000ULL,
    0x65a6543400000ULL,
    0xa4d3f20200000ULL,
    0xefbd8f2700000ULL,
    0x533c518c80000ULL,
    0x607ed87ac0000ULL,
    0x341f438820000ULL,
    0x86ecc74050000ULL,
    0x88454a0fd8000ULL,
    0x3ce79b349c000ULL,
    0x4fb1439bfa000ULL,
    0xf3cdc75ef1000ULL,
    0x95d5ca0e49800ULL,
    0x883adb09e5400ULL,
    0x78ff23b0f7a00ULL,
    0x115e176973100ULL,
    0xef8d721235b80ULL,
    0x731cf016ea40ULL,
    0x1e8ab18b0e360ULL,
    0xc0b4485bbe710ULL,
    0xe54f9bab176a8ULL,
    0xb99103448302cULL,
    0xa2dee002fc46eULL,
    0xa4e900d4b50dULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x3000000000000ULL,
    0xf800000000000ULL,
    0x1400000000000ULL,
    0x3200000000000ULL,
    0x1d00000000000ULL,
    0xa280000000000ULL,
    0x6040000000000ULL,
    0xa420000000000ULL,
    0x7f0000000000ULL,
    0x9308000000000ULL,
    0xffc4000000000ULL,
    0xf6e2000000000ULL,
    0xeb97000000000ULL,
    0xecd9800000000ULL,
    0xb53bc00000000ULL,
    0xa12ea00000000ULL,
    0x6f30900000000ULL,
    0x2e6c680000000ULL,
    0xd490540000000ULL,
    0x3b5fe20000000ULL,
    0x4bf8d10000000ULL,
    0x8b4e678000000ULL,
    0xfe6344000000ULL,
    0x2315202000000ULL,
    0x559c501000000ULL,
    0x499b483800000ULL,
    0x379b040c00000ULL,
    0xdc9d2a3e00000ULL,
    0x9918150500000ULL,
    0xaadded8c80000ULL,
    0xea3eb14740000ULL,
    0x6aca588a0000ULL,
    0x89f6b54810000ULL,
    0x200a0fb108000ULL,
    0x7e42605dfc000ULL,
    0x3f20c202c2000ULL,
    0x5a778126f1000ULL,
    0x84ceafb738800ULL,
    0x7521f074a5c00ULL,
    0x13772a0116600ULL,
    0xf44b15271ef00ULL,
    0x38666d9d63a80ULL,
    0xedd2714960240ULL,
    0x87fb85b0f11a0ULL,
    0x3d4de54639150ULL,
    0x8e0c7aa25788ULL,
    0x4096a44d56f44ULL,
    0x4959480e3f79eULL,
    0xb6fc042ab3bd1ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0xf000000000000ULL,
    0x7800000000000ULL,
    0x6c00000000000ULL,
    0x1e00000000000ULL,
    0x5500000000000ULL,
    0x7780000000000ULL,
    0x3cc0000000000ULL,
    0xcc20000000000ULL,
    0xd910000000000ULL,
    0x51e8000000000ULL,
    0xce44000000000ULL,
    0x4f62000000000ULL,
    0x9df5000000000ULL,
    0xc6df800000000ULL,
    0x75bfc00000000ULL,
    0x9e4d600000000ULL,
    0x4993f00000000ULL,
    0xb1aa280000000ULL,
    0x4c26fc0000000ULL,
    0x9914c60000000ULL,
    0xf1eb310000000ULL,
    0x3e44708000000ULL,
    0x3762ab4000000ULL,
    0xf1f0e02000000ULL,
    0xd8d9301000000ULL,
    0x20b8c82800000ULL,
    0xe9cacc3c00000ULL,
    0x75538e1e00000ULL,
    0x7d8e3d1b00000ULL,
    0x95329e8780000ULL,
    0xc8fb665540000ULL,
    0x3faa56bde0000ULL,
    0x7121aa5f30000ULL,
    0xaa91d8bb08000ULL,
    0x372b975a44000ULL,
    0xad6146027a000ULL,
    0xbef5f10491000ULL,
    0xa05c90a258800ULL,
    0xc4ff9b553d400ULL,
    0x31aa2815d7e00ULL,
    0xc26fc0c1ff00ULL,
    0x3914c626fb580ULL,
    0x1eb310250fc0ULL,
    0x46447088f88a0ULL,
    0x5b62ab42ecbf0ULL,
    0xeff0e0356fb18ULL,
    0x8dd9301b928c4ULL,
    0x5738c80c647c2ULL,
    0xd50acc376b1adULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x3000000000000ULL,
    0x4800000000000ULL,
    0x4c00000000000ULL,
    0xe200000000000ULL,
    0xd00000000000ULL,
    0x4480000000000ULL,
    0x2940000000000ULL,
    0x320000000000ULL,
    0xb8d0000000000ULL,
    0xebe8000000000ULL,
    0xc8c4000000000ULL,
    0xd2e6000000000ULL,
    0x58b3000000000ULL,
    0x2119800000000ULL,
    0x757e400000000ULL,
    0x9988600000000ULL,
    0xe736100000000ULL,
    0x37dce80000000ULL,
    0xa09ee40000000ULL,
    0x94baea0000000ULL,
    0x31ee290000000ULL,
    0x61c05e8000000ULL,
    0x6864c34000000ULL,
    0xe6f7e02000000ULL,
    0x6fbb503000000ULL,
    0xe6d081800000ULL,
    0xb706b40c00000ULL,
    0xdd86621200000ULL,
    0xdbc2dd1300000ULL,
    0xf1605cb880000ULL,
    0x14770e4340000ULL,
    0x9dfcd4b120000ULL,
    0xa2cbfa7a50000ULL,
    0xc114d6b8c8000ULL,
    0xb78c375234000ULL,
    0xc831e210fa000ULL,
    0x1e5b9d1d31000ULL,
    0xfd5fbc8639800ULL,
    0xf6d85e4a6cc00ULL,
    0xc61fdc93e6600ULL,
    0xd0fa4e774f900ULL,
    0x464d34b70a180ULL,
    0xb853aa62e9840ULL,
    0xcca85e8ce53a0ULL,
    0x74e0c35172b90ULL,
    0x5bb1e039253a8ULL,
    0xda98502a124a4ULL,
    0x6dbc883dd5f7aULL,
    0xf36cf4354b60dULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x3000000000000ULL,
    0x5800000000000ULL,
    0x5400000000000ULL,
    0x600000000000ULL,
    0x6100000000000ULL,
    0xd080000000000ULL,
    0x2dc0000000000ULL,
    0x96a0000000000ULL,
    0x59d0000000000ULL,
    0x7b8000000000ULL,
    0x8844000000000ULL,
    0x8de6000000000ULL,
    0x93b1000000000ULL,
    0x7049800000000ULL,
    0xf7eec00000000ULL,
    0xc6b8a00000000ULL,
    0xa8c3300000000ULL,
    0xd825880000000ULL,
    0x6114c40000000ULL,
    0x77988e0000000ULL,
    0xc550e50000000ULL,
    0x987d568000000ULL,
    0x69e081c000000ULL,
    0xdb7202000000ULL,
    0x654cf03000000ULL,
    0x116ca80800000ULL,
    0xd27d340c00000ULL,
    0xbae3a61600000ULL,
    0xaa36111500000ULL,
    0x9109d08180000ULL,
    0x768a60d840000ULL,
    0x62ca589420000ULL,
    0x152fa4fb70000ULL,
    0xcd9b568da8000ULL,
    0x6e5181ea74000ULL,
    0x5bfea03fee000ULL,
    0xc3a2300b11000ULL,
    0x5f54083cf9800ULL,
    0x37e0425ac400ULL,
    0xf2662e3fb2600ULL,
    0xf3f2d53bcbb00ULL,
    0x31a95ea1a6280ULL,
    0x165e85ef74cc0ULL,
    0xe1f10e066f620ULL,
    0xb6ae251750310ULL,
    0xb7ddf692d9a38ULL,
    0x74b7b1eddd794ULL,
    0x1cca82e9ab5aULL,
    0x2aad34047ed07ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x3000000000000ULL,
    0x8800000000000ULL,
    0x5400000000000ULL,
    0xfa00000000000ULL,
    0x3700000000000ULL,
    0x2180000000000ULL,
    0x60c0000000000ULL,
    0x3020000000000ULL,
    0x9130000000000ULL,
    0x1bb8000000000ULL,
    0x9244000000000ULL,
    0x4362000000000ULL,
    0x42d7000000000ULL,
    0x5129800000000ULL,
    0xc708400000000ULL,
    0x8f3ca00000000ULL,
    0x9806d00000000ULL,
    0x4c05380000000ULL,
    0xf603cc0000000ULL,
    0x2104660000000ULL,
    0x3080b10000000ULL,
    0xd840418000000ULL,
    0xbc67b9c000000ULL,
    0xd757202000000ULL,
    0xfbe9901000000ULL,
    0x4828183800000ULL,
    0x6b895c0c00000ULL,
    0x197ffe2200000ULL,
    0xd962ad1500000ULL,
    0x5d09fbe80000ULL,
    0x18a884cdc0000ULL,
    0xc3cda7a860000ULL,
    0xcd1f48c830000ULL,
    0x6a33c19408000ULL,
    0x8c3cf9f84c000ULL,
    0x3380003cee000ULL,
    0x73c0002d91000ULL,
    0x83a0003458800ULL,
    0xa2f0000475c00ULL,
    0x78180000aa600ULL,
    0xb4003132100ULL,
    0xb37a001927280ULL,
    0x16630017bdb40ULL,
    0x18538011874e0ULL,
    0xe66b40256df30ULL,
    0xb6ef20127f998ULL,
    0x1ead901c48ec4ULL,
    0xcaca18346cf06ULL,
    0x799e5c2aff3e7ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x5000000000000ULL,
    0xe800000000000ULL,
    0x2c00000000000ULL,
    0xce00000000000ULL,
    0xdf00000000000ULL,
    0x7480000000000ULL,
    0xa040000000000ULL,
    0x10a0000000000ULL,
    0x19f0000000000ULL,
    0x2888000000000ULL,
    0x4fc4000000000ULL,
    0xe666000000000ULL,
    0x1815000000000ULL,
    0xda5a800000000ULL,
    0x427b400000000ULL,
    0x1dcb600000000ULL,
    0x76e1700000000ULL,
    0xca57780000000ULL,
    0x93fb640000000ULL,
    0x8c0da20000000ULL,
    0xc782d50000000ULL,
    0x7ac2278000000ULL,
    0x9fe5e84000000ULL,
    0xc5d7e02000000ULL,
    0x553f303000000ULL,
    0x95ee982800000ULL,
    0xa155541400000ULL,
    0x7d7fba3a00000ULL,
    0x5949c10b00000ULL,
    0xcea47db380000ULL,
    0x4ef21977c0000ULL,
    0x800985bd20000ULL,
    0x99823d5810000ULL,
    0xedc7478c28000ULL,
    0x976598627c000ULL,
    0x4394183822000ULL,
    0xb69e143cf1000ULL,
    0x369cda1819800ULL,
    0xf69cb12ec5400ULL,
    0x569d05a236a00ULL,
    0x6987d444ed00ULL,
    0xee98a78dfad80ULL,
    0xc29ea874145c0ULL,
    0xc9c8029bfde0ULL,
    0xd39e403d63d90ULL,
    0xa719e00690e88ULL,
    0x75e303d68f54ULL,
    0x17fa18121da9eULL,
    0xe0f141e53ea1ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0xb000000000000ULL,
    0x800000000000ULL,
    0x2400000000000ULL,
    0xa00000000000ULL,
    0xbd00000000000ULL,
    0x7580000000000ULL,
    0xfbc0000000000ULL,
    0xaa60000000000ULL,
    0xf910000000000ULL,
    0x1bc8000000000ULL,
    0x3f44000000000ULL,
    0x1a26000000000ULL,
    0xc7b3000000000ULL,
    0x1c3d800000000ULL,
    0x75dc400000000ULL,
    0xfc0b200000000ULL,
    0x7321500000000ULL,
    0x1035680000000ULL,
    0xaefd6c0000000ULL,
    0x183f3e0000000ULL,
    0x6fde630000000ULL,
    0x990a508000000ULL,
    0x9aa24a4000000ULL,
    0xcdf0a02000000ULL,
    0x979e103000000ULL,
    0x23abc81800000ULL,
    0x47547c2c00000ULL,
    0x826f760200000ULL,
    0x28355f0900000ULL,
    0x42fb868280000ULL,
    0x563e056f40000ULL,
    0x68db6ebd60000ULL,
    0x598b294ef0000ULL,
    0x30e1709298000ULL,
    0x96531a6244000ULL,
    0x79edc83cf2000ULL,
    0xb4f77c1ad1000ULL,
    0x981af61e09800ULL,
    0xd6d1f3bacc00ULL,
    0xcb6a69aef600ULL,
    0x82bc5545c7100ULL,
    0x9b86aa7ac80ULL,
    0xfb2e05433c540ULL,
    0x11136e8d075a0ULL,
    0x4fcf2978da5b0ULL,
    0x5d477096ec4f8ULL,
    0x33201a4e8e58cULL,
    0xb0304819b6742ULL,
    0x7efb3c3fa2429ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x9000000000000ULL,
    0xb800000000000ULL,
    0x4c00000000000ULL,
    0x2600000000000ULL,
    0xb700000000000ULL,
    0x8680000000000ULL,
    0x64c0000000000ULL,
    0xcd60000000000ULL,
    0xde70000000000ULL,
    0xa228000000000ULL,
    0x7144000000000ULL,
    0xdd26000000000ULL,
    0xdad7000000000ULL,
    0x8ebc800000000ULL,
    0xac59c00000000ULL,
    0x4b68600000000ULL,
    0x9064300000000ULL,
    0x9f0380000000ULL,
    0x176a740000000ULL,
    0xce64060000000ULL,
    0x12f6fb0000000ULL,
    0x27ef1b8000000ULL,
    0xa5a52d4000000ULL,
    0x1512e02000000ULL,
    0xbb5af03000000ULL,
    0x7decd83800000ULL,
    0x3ca3842400000ULL,
    0xa0925e2e00000ULL,
    0x1b1bbf1300000ULL,
    0xb149a58980000ULL,
    0x7433626dc0000ULL,
    0xaf8b1d81a0000ULL,
    0x5053d66930000ULL,
    0xec7dfbab58000ULL,
    0xa63fdd639c000ULL,
    0x3b9e381e8a000ULL,
    0xa289741b51000ULL,
    0xdfd68628c9800ULL,
    0x853c3b2c75c00ULL,
    0x871dfba58f200ULL,
    0xf4fdd4ce6700ULL,
    0xff363829a2180ULL,
    0x270d7417750c0ULL,
    0x779086000e0e0ULL,
    0xcd9b3b13279d0ULL,
    0x8d897bb102818ULL,
    0x65521d4ac57ecULL,
    0xeff8581c1766eULL,
    0x97e44355bfb5ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x3000000000000ULL,
    0xe800000000000ULL,
    0xb400000000000ULL,
    0x2200000000000ULL,
    0x4500000000000ULL,
    0xed80000000000ULL,
    0x2540000000000ULL,
    0xa160000000000ULL,
    0xa810000000000ULL,
    0xee48000000000ULL,
    0x9bc4000000000ULL,
    0xcea6000000000ULL,
    0x64b7000000000ULL,
    0x1ff9800000000ULL,
    0xb1bb400000000ULL,
    0x65fa00000000ULL,
    0x558c100000000ULL,
    0x8566a80000000ULL,
    0x7210ac0000000ULL,
    0x274d4a0000000ULL,
    0x38437b0000000ULL,
    0xd0e2988000000ULL,
    0xfb51864000000ULL,
    0x1828202000000ULL,
    0x7354503000000ULL,
    0x5c2e883800000ULL,
    0x5954fc0c00000ULL,
    0x9d2bc23a00000ULL,
    0x7ed3872d00000ULL,
    0x496f5a8880000ULL,
    0x1035015140000ULL,
    0x813efa9b60000ULL,
    0xb29a117950000ULL,
    0x97afd2b058000ULL,
    0x3312fd5604000ULL,
    0xc0cab89992000ULL,
    0xc05d677f1000ULL,
    0x8e06a81929800ULL,
    0xdb00ac196dc00ULL,
    0xe854a361e600ULL,
    0x47c77b157ed00ULL,
    0x98a498a02fe80ULL,
    0xe3b6864a77040ULL,
    0x8779a02173aa0ULL,
    0x917b1038612b0ULL,
    0x367f282ad0d28ULL,
    0x7efbec1e981ecULL,
    0x863aea29a5462ULL,
    0xea1b6b2a62719ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x3000000000000ULL,
    0xd800000000000ULL,
    0x9400000000000ULL,
    0x5200000000000ULL,
    0x4900000000000ULL,
    0x7e80000000000ULL,
    0xfa40000000000ULL,
    0x35e0000000000ULL,
    0x4570000000000ULL,
    0xf678000000000ULL,
    0x5bc4000000000ULL,
    0x8226000000000ULL,
    0x1157000000000ULL,
    0xf429800000000ULL,
    0xe46ac00000000ULL,
    0xfc8ea00000000ULL,
    0xad7f900000000ULL,
    0x4c46c80000000ULL,
    0xd6e5b40000000ULL,
    0x36f3320000000ULL,
    0xc8b8df0000000ULL,
    0x9164938000000ULL,
    0x4a363fc000000ULL,
    0x4319202000000ULL,
    0x5bf6503000000ULL,
    0xfc3fe83800000ULL,
    0x5623e40c00000ULL,
    0x6354da3600000ULL,
    0x6d2f3b2500000ULL,
    0x72ee499480000ULL,
    0x4aca04d240000ULL,
    0x5e98e9bfa0000ULL,
    0x123194ce90000ULL,
    0x1718219578000ULL,
    0xe9f320ed5c000ULL,
    0x853a93939e000ULL,
    0xf0a53fcff1000ULL,
    0xd16a01a09800ULL,
    0xacb900f15c00ULL,
    0x7e98c8382a600ULL,
    0xc236b43ccab00ULL,
    0xff1cb20f7ba80ULL,
    0xa5f51f33d3e40ULL,
    0x433bb3a8d7b20ULL,
    0xeba76fdec46d0ULL,
    0x3a974822734c8ULL,
    0x8e0b743f46f7cULL,
    0xb13b92313cc4eULL,
    0xb2a04f246ffffULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x5000000000000ULL,
    0x1800000000000ULL,
    0x1c00000000000ULL,
    0xae00000000000ULL,
    0x8f00000000000ULL,
    0x9080000000000ULL,
    0x7bc0000000000ULL,
    0x4ee0000000000ULL,
    0xbc30000000000ULL,
    0xc038000000000ULL,
    0x1e44000000000ULL,
    0xc0a2000000000ULL,
    0xc497000000000ULL,
    0xa8aa800000000ULL,
    0x50ecc00000000ULL,
    0x1b4ee00000000ULL,
    0xfd5c700000000ULL,
    0xf37f80000000ULL,
    0xebbc40000000ULL,
    0x42827e0000000ULL,
    0x4ac7a70000000ULL,
    0xa963c98000000ULL,
    0x1b71edc000000ULL,
    0x431e602000000ULL,
    0x7f93b01000000ULL,
    0x8229983800000ULL,
    0xee28741400000ULL,
    0xa82be60600000ULL,
    0x932fd30700000ULL,
    0xf9a82fab80000ULL,
    0xa76e3ee3c0000ULL,
    0x440e4f8420000ULL,
    0x32798ecef0000ULL,
    0xd8e5d78bb8000ULL,
    0xdf36faeb0c000ULL,
    0x56bcb1ae0e000ULL,
    0xbe81e9c491000ULL,
    0xb4c07e05a8800ULL,
    0x3e60a711e5c00ULL,
    0x97f1499b8aa00ULL,
    0x96d92dfa0b300ULL,
    0xbe72803ccbb80ULL,
    0xae98c03a6b1c0ULL,
    0x55d4e017dbfe0ULL,
    0xf88f700203f10ULL,
    0xefbf78211e1f8ULL,
    0xfd000412f929cULL,
    0x11861e386cd26ULL,
    0xd44717289f8b7ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0xd000000000000ULL,
    0x2800000000000ULL,
    0xb400000000000ULL,
    0x2200000000000ULL,
    0xa700000000000ULL,
    0xb80000000000ULL,
    0xf3c0000000000ULL,
    0x6420000000000ULL,
    0x7b70000000000ULL,
    0xd588000000000ULL,
    0x7424000000000ULL,
    0x3372000000000ULL,
    0x9189000000000ULL,
    0xae22800000000ULL,
    0x873400000000ULL,
    0xc0ca00000000ULL,
    0xd8e3900000000ULL,
    0xc0d6780000000ULL,
    0x8f3cfc0000000ULL,
    0x9a8c0e0000000ULL,
    0xaba1590000000ULL,
    0x12b5278000000ULL,
    0xaaafa24000000ULL,
    0x42d6782000000ULL,
    0xb83cfc1000000ULL,
    0x990c0e0800000ULL,
    0x3c61593400000ULL,
    0x7c95278a00000ULL,
    0xc2dfa26d00000ULL,
    0xbede782880000ULL,
    0x98d8fc39c0000ULL,
    0xc5de0e0ae0000ULL,
    0x25585908f0000ULL,
    0x631fa79308000ULL,
    0xc5f8e273dc000ULL,
    0x5428d81de2000ULL,
    0xa5966c24c9000ULL,
    0x9858f6063c800ULL,
    0x339ee52c92400ULL,
    0x5bbd89b880a00ULL,
    0xbec96b71c0d00ULL,
    0x8a47279ee1280ULL,
    0x58e6a252f1e40ULL,
    0x80d4f816091e0ULL,
    0xaf3fbc1f5d7f0ULL,
    0x4a88ae1623a38ULL,
    0x83a6c92f28864ULL,
    0xa6b15fb04c61eULL,
    0x88aa5e455a0c9ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0xb000000000000ULL,
    0x3800000000000ULL,
    0x5400000000000ULL,
    0x4e00000000000ULL,
    0x1700000000000ULL,
    0x6a80000000000ULL,
    0x6b40000000000ULL,
    0xa2a0000000000ULL,
    0x80b0000000000ULL,
    0x628000000000ULL,
    0xdaa4000000000ULL,
    0x34b6000000000ULL,
    0xd829000000000ULL,
    0x45a1800000000ULL,
    0x3237c00000000ULL,
    0xa96ba00000000ULL,
    0xbe03f00000000ULL,
    0xcf07780000000ULL,
    0xae80f40000000ULL,
    0xad44aa0000000ULL,
    0xd9a46d0000000ULL,
    0xf035f18000000ULL,
    0x34691b4000000ULL,
    0x587782000000ULL,
    0xb5c0f43000000ULL,
    0x17e4aa0800000ULL,
    0xbd146d2c00000ULL,
    0x801df18e00000ULL,
    0xadcd1b5500000ULL,
    0x15b1783380000ULL,
    0x11a9f435c0000ULL,
    0x9a652a12a0000ULL,
    0x64d3ad36d0000ULL,
    0x8dfe51a6a8000ULL,
    0x49daeb752c000ULL,
    0xe82800320a000ULL,
    0xbda4000369000ULL,
    0x4636001f8d800ULL,
    0x57690000da400ULL,
    0x91018037c0600ULL,
    0xf187c039a1f00ULL,
    0x8bc3a03850e80ULL,
    0x18e7f01ce9fc0ULL,
    0x339178244c5e0ULL,
    0x9d59f4077a7d0ULL,
    0x4c6d2a12914a8ULL,
    0xb187ad1ac8eb4ULL,
    0x6bc05197dd946ULL,
    0x88e7eb5433badULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0xf000000000000ULL,
    0x1800000000000ULL,
    0xe400000000000ULL,
    0xf200000000000ULL,
    0x8500000000000ULL,
    0xe80000000000ULL,
    0xb1c0000000000ULL,
    0xf520000000000ULL,
    0x9c10000000000ULL,
    0x5e8000000000ULL,
    0x3d24000000000ULL,
    0x3016000000000ULL,
    0x9beb000000000ULL,
    0x4623800000000ULL,
    0xb596c00000000ULL,
    0xb7ac200000000ULL,
    0x7b44100000000ULL,
    0xe6e2e80000000ULL,
    0x6434540000000ULL,
    0x9b7d9e0000000ULL,
    0x870f410000000ULL,
    0x6b11b48000000ULL,
    0x4e6f314000000ULL,
    0xe262e82000000ULL,
    0x84f4543000000ULL,
    0xeadd9e1800000ULL,
    0x3bdf413c00000ULL,
    0x7f59b48600000ULL,
    0x3f9b317900000ULL,
    0xde3ce81c80000ULL,
    0x8aeb541140000ULL,
    0x62a01e1ba0000ULL,
    0x556811070000ULL,
    0x4e0814bb48000ULL,
    0xcb96e15e04000ULL,
    0xfcafa01dfa000ULL,
    0x86c2d01e09000ULL,
    0xdea6c817a5800ULL,
    0xb35444368ac00ULL,
    0xa909762ac0e00ULL,
    0xa810153361b00ULL,
    0xbfefaa9011080ULL,
    0xd426b070d8040ULL,
    0xc0977c961d3a0ULL,
    0xa12b756387d50ULL,
    0x2e839e321f878ULL,
    0xe1c04127a2604ULL,
    0x7d2434a855652ULL,
    0x9012f14703c85ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x5000000000000ULL,
    0x5800000000000ULL,
    0xdc00000000000ULL,
    0xe600000000000ULL,
    0x8900000000000ULL,
    0x7480000000000ULL,
    0xa840000000000ULL,
    0x7b20000000000ULL,
    0xb210000000000ULL,
    0xb8b8000000000ULL,
    0x4724000000000ULL,
    0x4412000000000ULL,
    0x9bb000000000ULL,
    0xbfa6800000000ULL,
    0x5250c00000000ULL,
    0x279de00000000ULL,
    0x9f31b00000000ULL,
    0xcbac880000000ULL,
    0x6f1a440000000ULL,
    0xc176f20000000ULL,
    0x18c510000000ULL,
    0x258d548000000ULL,
    0x6f89f7c000000ULL,
    0x688c882000000ULL,
    0x410a441000000ULL,
    0xffcef21800000ULL,
    0x9fa8511400000ULL,
    0x4d1f549600000ULL,
    0x1272f7f700000ULL,
    0x4a0a081980000ULL,
    0x284a843240000ULL,
    0x146b120520000ULL,
    0xeffde13e10000ULL,
    0xb981dc88c8000ULL,
    0xc6c3b3db84000ULL,
    0x8c627a37ae000ULL,
    0x3cb2152389000ULL,
    0x5269a69424800ULL,
    0x16fea6fc7ec00ULL,
    0xa5075c8721a00ULL,
    0xba8373df10300ULL,
    0x95479a2649780ULL,
    0x3da7a510456c0ULL,
    0xf1572eb0cfa20ULL,
    0x41fe2d0b8510ULL,
    0x46f72e8efc1c8ULL,
    0xd24fe2fd33244ULL,
    0x5b6f2eb20a2d2ULL,
    0x227be2e1b711fULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0xf000000000000ULL,
    0xe800000000000ULL,
    0xb400000000000ULL,
    0x200000000000ULL,
    0xf100000000000ULL,
    0xa480000000000ULL,
    0x50c0000000000ULL,
    0x73a0000000000ULL,
    0xb050000000000ULL,
    0x6818000000000ULL,
    0xb7a4000000000ULL,
    0x1a52000000000ULL,
    0xcd1f000000000ULL,
    0xe123800000000ULL,
    0x5395400000000ULL,
    0xae3aa00000000ULL,
    0x3b3900000000ULL,
    0xb92ac80000000ULL,
    0xd4b840000000ULL,
    0x213b160000000ULL,
    0xb032550000000ULL,
    0x466f868000000ULL,
    0xd7aa16c000000ULL,
    0x488ac82000000ULL,
    0xc1b841000000ULL,
    0xda3163800000ULL,
    0xa756553c00000ULL,
    0xc79d86ba00000ULL,
    0x1ee516ed00000ULL,
    0xc3b1482080000ULL,
    0x192ac42c40000ULL,
    0x1d4bb61120000ULL,
    0x393ac52830000ULL,
    0xec34cea6e8000ULL,
    0xf06bd2c114000ULL,
    0x24a8fe3a86000ULL,
    0x1d0f0101a9000ULL,
    0xf85cf897b4800ULL,
    0x2ec457db77c00ULL,
    0x64a690bea0e00ULL,
    0x1fd743c5f1500ULL,
    0xc15ecea908a80ULL,
    0x6e40d2fd45e40ULL,
    0xce617e23fe320ULL,
    0x3171412525210ULL,
    0x8b8fd8ae6e258ULL,
    0x119987f9bdc54ULL,
    0x5de77893b349aULL,
    0x9e3517cd9f61bULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x7000000000000ULL,
    0x6800000000000ULL,
    0x7c00000000000ULL,
    0xa200000000000ULL,
    0x6900000000000ULL,
    0x6380000000000ULL,
    0x2440000000000ULL,
    0x1860000000000ULL,
    0x5550000000000ULL,
    0x9ff8000000000ULL,
    0x5c64000000000ULL,
    0xd352000000000ULL,
    0xe0fd000000000ULL,
    0xf8e7800000000ULL,
    0x3791400000000ULL,
    0xaa5ee00000000ULL,
    0x5012900000000ULL,
    0xa81a080000000ULL,
    0x4771fc0000000ULL,
    0x31cdb20000000ULL,
    0x4049cb0000000ULL,
    0x850fd68000000ULL,
    0x52e88dc000000ULL,
    0x99fa082000000ULL,
    0x6361fc1000000ULL,
    0xd7d5b22800000ULL,
    0x743dcb1c00000ULL,
    0xda45d69a00000ULL,
    0xe3618ddf00000ULL,
    0x97d7880880000ULL,
    0xd439bc0a40000ULL,
    0xaa46d230e0000ULL,
    0x8b671b1510000ULL,
    0xebd4be9c18000ULL,
    0x763ea1ca54000ULL,
    0xc341522f7e000ULL,
    0xe8e65b1d59000ULL,
    0xcf925e8434800ULL,
    0x6e5831ed2f400ULL,
    0x96115a0221e00ULL,
    0x771ea717b0500ULL,
    0x93f26c8de9b80ULL,
    0xbd09bac55da40ULL,
    0x76edecbc32020ULL,
    0x8ffcfaeff33f0ULL,
    0xa4610c94d28c8ULL,
    0x17536adee222cULL,
    0x26fc84a6ca4daULL,
    0x27e3d6cdb7877ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0xb000000000000ULL,
    0x1800000000000ULL,
    0xdc00000000000ULL,
    0x1600000000000ULL,
    0x1f00000000000ULL,
    0x3a80000000000ULL,
    0x55c0000000000ULL,
    0x9e20000000000ULL,
    0x72d0000000000ULL,
    0x4c98000000000ULL,
    0x1024000000000ULL,
    0x71d6000000000ULL,
    0x801f000000000ULL,
    0xeae1800000000ULL,
    0xcd76c00000000ULL,
    0x7b09e00000000ULL,
    0x2e59300000000ULL,
    0xb082380000000ULL,
    0x7cc6340000000ULL,
    0xeba09e0000000ULL,
    0xb591490000000ULL,
    0x437c628000000ULL,
    0x36d29ac000000ULL,
    0x469a382000000ULL,
    0xf922343000000ULL,
    0xe4569e3800000ULL,
    0xf75e492c00000ULL,
    0xfd05e28600000ULL,
    0x37805af700000ULL,
    0x5a45d82580000ULL,
    0x48640437c0000ULL,
    0x84b52636a0000ULL,
    0x132ebd3970000ULL,
    0xf38c9ca188000ULL,
    0xde9823ebb4000ULL,
    0xe52382b6a6000ULL,
    0x1254aaf3c9000ULL,
    0x5859800ad5800ULL,
    0xdf82c02977c00ULL,
    0xbe47e02330600ULL,
    0xd2623034e9b00ULL,
    0x25b5b80e64780ULL,
    0xf2aff43f5f4c0ULL,
    0x56c8fe3b750e0ULL,
    0x1c7eb92d864d0ULL,
    0x2c57baa978478ULL,
    0x435d9ed7fde24ULL,
    0xcf009e1ab360aULL,
    0x5281492e9feabULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x7000000000000ULL,
    0xe800000000000ULL,
    0xe400000000000ULL,
    0x7a00000000000ULL,
    0xb300000000000ULL,
    0xd680000000000ULL,
    0x93c0000000000ULL,
    0x1620000000000ULL,
    0x7990000000000ULL,
    0x4378000000000ULL,
    0x2424000000000ULL,
    0x7e92000000000ULL,
    0x17fb000000000ULL,
    0x78e7800000000ULL,
    0xc835400000000ULL,
    0xd0ac200000000ULL,
    0x323c500000000ULL,
    0x63c4d80000000ULL,
    0xbe20940000000ULL,
    0xfd97ce0000000ULL,
    0x4979e90000000ULL,
    0x7f21188000000ULL,
    0x4c1075c000000ULL,
    0xfe3cd82000000ULL,
    0xddc4941000000ULL,
    0x6725ce1800000ULL,
    0x12e91c00000ULL,
    0x3e98ba00000ULL,
    0x64c135f900000ULL,
    0xeaa2f83e80000ULL,
    0xa153c43cc0000ULL,
    0xffde962da0000ULL,
    0xb8733d38f0000ULL,
    0x6cf76bf88000ULL,
    0x55cb8ce764000ULL,
    0xb34ab8ae5e000ULL,
    0xa88965f5c9000ULL,
    0x2aac201204800ULL,
    0xc13c502d0ec00ULL,
    0xd544d839b1e00ULL,
    0x5de0940969500ULL,
    0x3b7ce0075080ULL,
    0xd4e9e91046140ULL,
    0x465918ac75b60ULL,
    0xdb3475e246e50ULL,
    0x562ed83174138ULL,
    0x59ff940ac72a4ULL,
    0x9e24e26b54e2ULL,
    0xb1b7a914e6097ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0xb000000000000ULL,
    0xb800000000000ULL,
    0xc400000000000ULL,
    0xca00000000000ULL,
    0x8900000000000ULL,
    0xa980000000000ULL,
    0x50c0000000000ULL,
    0x8160000000000ULL,
    0x6d50000000000ULL,
    0xf1c8000000000ULL,
    0xf64000000000ULL,
    0xee56000000000ULL,
    0x714d000000000ULL,
    0x4621800000000ULL,
    0x87f3c00000000ULL,
    0x597b200000000ULL,
    0x10bfd00000000ULL,
    0xf05b880000000ULL,
    0x11cc6c0000000ULL,
    0xdf66560000000ULL,
    0x4653030000000ULL,
    0xbd4d468000000ULL,
    0xf021384000000ULL,
    0xf3882000000ULL,
    0xb3f86c3000000ULL,
    0x60f8562800000ULL,
    0x887a032c00000ULL,
    0xad3ac6ae00000ULL,
    0xc29ff87100000ULL,
    0xd5a9281280000ULL,
    0xadb47c1240000ULL,
    0x6058fe0260000ULL,
    0xd9c9bf3830000ULL,
    0x367188e58000ULL,
    0xf850976a54000ULL,
    0x464a38aef2000ULL,
    0x14a2475199000ULL,
    0x33b03099f5800ULL,
    0xeb5deb5463400ULL,
    0x254d4697d0600ULL,
    0x44213857a8f00ULL,
    0xd2f3883eacc80ULL,
    0x4ef86c08b6f40ULL,
    0xbb78561963620ULL,
    0x95ba0333505b0ULL,
    0x4fdac6b0e9f58ULL,
    0x760ff86c4c30cULL,
    0xc81281dc799aULL,
    0x9f407c26daba1ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0xd000000000000ULL,
    0xa800000000000ULL,
    0x8c00000000000ULL,
    0x6e00000000000ULL,
    0x4f00000000000ULL,
    0x980000000000ULL,
    0x4340000000000ULL,
    0x83e0000000000ULL,
    0xa5b0000000000ULL,
    0xdd58000000000ULL,
    0x11e4000000000ULL,
    0x3cb6000000000ULL,
    0x9fd9000000000ULL,
    0x6922800000000ULL,
    0x7513400000000ULL,
    0x730d600000000ULL,
    0x3509f00000000ULL,
    0x360d380000000ULL,
    0x718f2c0000000ULL,
    0xadccea0000000ULL,
    0x8faea70000000ULL,
    0xe559c18000000ULL,
    0xd5e320c000000ULL,
    0x2eb5382000000ULL,
    0xc6db2c3000000ULL,
    0xba2ea0800000ULL,
    0xddd3a73400000ULL,
    0x92ad41aa00000ULL,
    0x55d960e300000ULL,
    0x422d83b80000ULL,
    0x7d959c23c0000ULL,
    0xa6ccb20a60000ULL,
    0x54287b24d0000ULL,
    0xdf18138af8000ULL,
    0xe482abca6c000ULL,
    0x8bc0138cd6000ULL,
    0x7626abe7b9000ULL,
    0x149613a54d800ULL,
    0x9c4fabf326400ULL,
    0x8ec93b8b0a00ULL,
    0x74b8ebd328d00ULL,
    0x2957f3b215580ULL,
    0x91681bfdfb7c0ULL,
    0x7ff84b994ece0ULL,
    0xd6b477df858b0ULL,
    0x22d9c18a239a8ULL,
    0xc9a320f3d379cULL,
    0x2cd53829db286ULL,
    0x7c2b2c313fb43ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0xb000000000000ULL,
    0x4800000000000ULL,
    0x2400000000000ULL,
    0xbe00000000000ULL,
    0xa700000000000ULL,
    0xda80000000000ULL,
    0x5a40000000000ULL,
    0x9420000000000ULL,
    0xff30000000000ULL,
    0x12d8000000000ULL,
    0xd624000000000ULL,
    0x9a36000000000ULL,
    0x6d5b000000000ULL,
    0x93e1800000000ULL,
    0xfbd4400000000ULL,
    0xbb8a200000000ULL,
    0x73ec700000000ULL,
    0x73fd780000000ULL,
    0xe96f40000000ULL,
    0x712fa20000000ULL,
    0xb899590000000ULL,
    0xaa05cd8000000ULL,
    0x9101d4c000000ULL,
    0x3985782000000ULL,
    0x8ec2f43000000ULL,
    0x2161a21800000ULL,
    0x9596592c00000ULL,
    0x9aa4d9200000ULL,
    0xf7da94c900000ULL,
    0x69a0d80f80000ULL,
    0xbff5c419c0000ULL,
    0xbcb97a2ea0000ULL,
    0xd379d3a90000ULL,
    0x3fdd37b708000ULL,
    0x8da209f6cc000ULL,
    0x61f26f8b36000ULL,
    0xabbc8dec49000ULL,
    0x9fb6b5a82d800ULL,
    0x419820d1c6c00ULL,
    0xa7855a2bf0600ULL,
    0x39c0ed1439100ULL,
    0x63e1cf8fd4880ULL,
    0x13d0bde5b21c0ULL,
    0x4f8fed9152de0ULL,
    0x35eda4dea37d0ULL,
    0xb8f8003c9b888ULL,
    0x4e14000c4f464ULL,
    0x326e00197dfb6ULL,
    0x513f00016e693ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0x7000000000000ULL,
    0xf800000000000ULL,
    0xf400000000000ULL,
    0x9a00000000000ULL,
    0x4100000000000ULL,
    0xf480000000000ULL,
    0xa440000000000ULL,
    0x5660000000000ULL,
    0x9770000000000ULL,
    0x8198000000000ULL,
    0xd764000000000ULL,
    0x3f2000000000ULL,
    0x75d9000000000ULL,
    0x907800000000ULL,
    0x9885c00000000ULL,
    0x9a46a00000000ULL,
    0x567500000000ULL,
    0x2ef5c80000000ULL,
    0xbf58040000000ULL,
    0xfe45f20000000ULL,
    0x7762bb0000000ULL,
    0x33f21f8000000ULL,
    0xaddaaec000000ULL,
    0x8d07c82000000ULL,
    0xfa81041000000ULL,
    0x2f42720800000ULL,
    0x6be77b1c00000ULL,
    0xcbb4bfbe00000ULL,
    0x1dbdfefd00000ULL,
    0xcd72000680000ULL,
    0xa099000040000ULL,
    0x73e7803520000ULL,
    0x2fb5c03510000ULL,
    0x2fbea02b98000ULL,
    0xf0735018dc000ULL,
    0xc21fc806e6000ULL,
    0xf8a5042599000ULL,
    0x5650723ddc800ULL,
    0xa90e7b3466400ULL,
    0x774b3f97d9e00ULL,
    0x702c3ec3fd700ULL,
    0xbbdea026f7a80ULL,
    0xe203502480d40ULL,
    0xf507c80341f20ULL,
    0x4e81042ea0410ULL,
    0x95427203d09c8ULL,
    0x5ae77b06f9decULL,
    0xc734bf8ced2feULL,
    0x4dfdfefa6f7fbULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x7000000000000ULL,
    0xa800000000000ULL,
    0x9400000000000ULL,
    0xae00000000000ULL,
    0xbf00000000000ULL,
    0x9b80000000000ULL,
    0x7140000000000ULL,
    0xfba0000000000ULL,
    0x33d0000000000ULL,
    0x51d8000000000ULL,
    0xdca4000000000ULL,
    0xf456000000000ULL,
    0xca9d000000000ULL,
    0xee07800000000ULL,
    0xdf03400000000ULL,
    0x4b81a00000000ULL,
    0xa946f00000000ULL,
    0xc7a0b80000000ULL,
    0x9d07c0000000ULL,
    0x40defa0000000ULL,
    0xf826250000000ULL,
    0x1e93428000000ULL,
    0x407c04c000000ULL,
    0x2676b82000000ULL,
    0xbd0d7c3000000ULL,
    0xc6f97a2800000ULL,
    0x81b5651c00000ULL,
    0xf96ae2aa00000ULL,
    0x2d4ef4e500000ULL,
    0x71d8000b80000ULL,
    0x6ca4001fc0000ULL,
    0xfc56000ee0000ULL,
    0x2e9d000050000ULL,
    0xe8078014e8000ULL,
    0xf4034029f4000ULL,
    0x7e01a03ff6000ULL,
    0x6706f018e9000ULL,
    0xa780b81bf5800ULL,
    0x4b407c2ef7400ULL,
    0xeaa6fa0569e00ULL,
    0x1752253b34d00ULL,
    0xbb1d428696680ULL,
    0x564504dd78bc0ULL,
    0x3c27382cfdae0ULL,
    0xa8933c00d35f0ULL,
    0x637f5a03b65e8ULL,
    0xf7f0d515c9594ULL,
    0x754bfabf44b8aULL,
    0x8dd878df4ebd3ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x9000000000000ULL,
    0x8800000000000ULL,
    0xbc00000000000ULL,
    0x4600000000000ULL,
    0x6500000000000ULL,
    0x280000000000ULL,
    0xcb40000000000ULL,
    0x90a0000000000ULL,
    0x4ff0000000000ULL,
    0xe628000000000ULL,
    0xcda4000000000ULL,
    0xa972000000000ULL,
    0xff6d000000000ULL,
    0x5200800000000ULL,
    0x4f06400000000ULL,
    0x980e00000000ULL,
    0x80c6b00000000ULL,
    0x9767680000000ULL,
    0xcd15f40000000ULL,
    0x7dfc6a0000000ULL,
    0xca3bad0000000ULL,
    0x10dc6b8000000ULL,
    0x1f0a6b4000000ULL,
    0x7295682000000ULL,
    0x6038f41000000ULL,
    0x5bdcea2800000ULL,
    0xf48ded2400000ULL,
    0xe5548ba200000ULL,
    0x6ad8db6f00000ULL,
    0x7c08003180000ULL,
    0xb514000940000ULL,
    0x39fa0028a0000ULL,
    0x88390016d0000ULL,
    0x97da800628000ULL,
    0xa8f403cfc000ULL,
    0x245260280a000ULL,
    0x1a5df02a29000ULL,
    0x284f082afc800ULL,
    0x431040d0b400ULL,
    0xdac9e230a8200ULL,
    0x3775e9003d900ULL,
    0x4e6fe9bbea380ULL,
    0x9a86725358ac0ULL,
    0xbf4789af855a0ULL,
    0xcaa2825c9e3d0ULL,
    0xfcf20183ff3a8ULL,
    0x9acc6554f7b4ULL,
    0xb86183ac5722eULL,
    0xb490df7cf336dULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x3000000000000ULL,
    0x5800000000000ULL,
    0x8c00000000000ULL,
    0xe200000000000ULL,
    0xc700000000000ULL,
    0xb880000000000ULL,
    0xb440000000000ULL,
    0x70a0000000000ULL,
    0x5bf0000000000ULL,
    0xf3c8000000000ULL,
    0x43a4000000000ULL,
    0xfd72000000000ULL,
    0x9a8d000000000ULL,
    0xf085800000000ULL,
    0x1040c00000000ULL,
    0xe6a1600000000ULL,
    0xc2f6900000000ULL,
    0x364cf80000000ULL,
    0x465a40000000ULL,
    0x6310b20000000ULL,
    0xc298bd0000000ULL,
    0x909a9b8000000ULL,
    0x4f9efc4000000ULL,
    0xdb1ef82000000ULL,
    0xbd58a41000000ULL,
    0x52fd322800000ULL,
    0x3d8c7d0c00000ULL,
    0x9801fb9600000ULL,
    0x6c016c6300000ULL,
    0x7205801880000ULL,
    0xaf00c021c0000ULL,
    0x6c81600620000ULL,
    0xda46902110000ULL,
    0x55a4f80a28000ULL,
    0x2471a435fc000ULL,
    0xff0ab20472000ULL,
    0x8741bd2129000ULL,
    0xd6251b917c800ULL,
    0x32b73c4bb3400ULL,
    0x40e8180009600ULL,
    0xae93f402ec300ULL,
    0x815d2a2d5a580ULL,
    0xa8fb892c54a40ULL,
    0xd68ed1a4cfbe0ULL,
    0xf287e544ba290ULL,
    0x4746d1bc654c8ULL,
    0x3623e555761f4ULL,
    0xa2b4d1bbaefeeULL,
    0x28eee5524a1b1ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x5000000000000ULL,
    0x4800000000000ULL,
    0xf400000000000ULL,
    0xa600000000000ULL,
    0x9d00000000000ULL,
    0xc380000000000ULL,
    0xb8c0000000000ULL,
    0xf4a0000000000ULL,
    0x84b0000000000ULL,
    0x87a8000000000ULL,
    0xe5a4000000000ULL,
    0xed36000000000ULL,
    0xc869000000000ULL,
    0x586800000000ULL,
    0x95c4400000000ULL,
    0xf26a00000000ULL,
    0xd077b00000000ULL,
    0x690ea80000000ULL,
    0xae15bc0000000ULL,
    0x921ef60000000ULL,
    0xcb8e4d0000000ULL,
    0x6752b98000000ULL,
    0x957cbb4000000ULL,
    0xfd18a82000000ULL,
    0xa30cbc3000000ULL,
    0xe910760800000ULL,
    0xbe9e0d1400000ULL,
    0xdbca199200000ULL,
    0x3db60b7d00000ULL,
    0x6a2e800980000ULL,
    0x1460401740000ULL,
    0x2c10a038e0000ULL,
    0x211eb03a30000ULL,
    0x4108282f28000ULL,
    0xea11fc1c2c000ULL,
    0xc1856086a000ULL,
    0xba89fd1e29000ULL,
    0xbed4118bad800ULL,
    0xe2bd075c2a400ULL,
    0xf1385e1c49a00ULL,
    0xc1fff1345d100ULL,
    0xe15a4faa23a80ULL,
    0x93ebf65974ec0ULL,
    0xc14491930e2a0ULL,
    0x136047549f2f0ULL,
    0xe0907e24661d8ULL,
    0x41580114d2834ULL,
    0x3ec47b0fd066ULL,
    0xa944fa5672c2dULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0xb000000000000ULL,
    0x9800000000000ULL,
    0x4c00000000000ULL,
    0xde00000000000ULL,
    0xe100000000000ULL,
    0xbf80000000000ULL,
    0x36c0000000000ULL,
    0x7ca0000000000ULL,
    0x2cd0000000000ULL,
    0xea88000000000ULL,
    0xc3a4000000000ULL,
    0xb256000000000ULL,
    0xc3cd000000000ULL,
    0x39c1800000000ULL,
    0x7a22c00000000ULL,
    0x4997600000000ULL,
    0xceeb700000000ULL,
    0xead7c80000000ULL,
    0x87899c0000000ULL,
    0x226460000000ULL,
    0xd5976d0000000ULL,
    0x98ed5a8000000ULL,
    0x6fd5024000000ULL,
    0x3209c82000000ULL,
    0x47e09c3000000ULL,
    0x29b1c62800000ULL,
    0xdc78ad2c00000ULL,
    0x70bbbaa600000ULL,
    0x971cb25300000ULL,
    0x4f49601780000ULL,
    0xef82700840000ULL,
    0x7ec04807e0000ULL,
    0xb8a65c21b0000ULL,
    0x96d0a63928000ULL,
    0x18edd1834000ULL,
    0xf25f28d22000ULL,
    0x413ee48a9000ULL,
    0xd72e462375800ULL,
    0xe0f36d0d43400ULL,
    0xf61b5ab958600ULL,
    0x30c80279bcb00ULL,
    0x7940482ec7d80ULL,
    0xb2665c2053dc0ULL,
    0xc70a609a0720ULL,
    0x305edd0551270ULL,
    0x1c2df28719f18ULL,
    0x5c77ee755d6b4ULL,
    0x7858463cf68eaULL,
    0xd82e6d2b3b9c9ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0xb000000000000ULL,
    0x6800000000000ULL,
    0xfc00000000000ULL,
    0x4600000000000ULL,
    0x7f00000000000ULL,
    0x6880000000000ULL,
    0xcfc0000000000ULL,
    0x3ea0000000000ULL,
    0xbc90000000000ULL,
    0x6d98000000000ULL,
    0x67a4000000000ULL,
    0xfb16000000000ULL,
    0x32d9000000000ULL,
    0xb2c1800000000ULL,
    0xab25400000000ULL,
    0x26d6e00000000ULL,
    0xe97fb00000000ULL,
    0xefd4b80000000ULL,
    0x76faa40000000ULL,
    0x24914e0000000ULL,
    0x19998d0000000ULL,
    0x4da0e08000000ULL,
    0x1a1172c000000ULL,
    0xb15ab82000000ULL,
    0xaf87a43000000ULL,
    0x6346ce0800000ULL,
    0xb365cd2c00000ULL,
    0x9f37809a00000ULL,
    0x148b82ff00000ULL,
    0x6878e03180000ULL,
    0x3c52b02fc0000ULL,
    0x93bb381220000ULL,
    0xc8f2e41ff0000ULL,
    0x5e282e15a8000ULL,
    0xfeee7d1024000ULL,
    0xb0cd388ae6000ULL,
    0x779c26c629000ULL,
    0x2ea62e04e5800ULL,
    0xa4937d0f46400ULL,
    0xd99ab8ab18600ULL,
    0x6da066e9ed500ULL,
    0xaa114e28d3b80ULL,
    0xd9598d2cb6ec0ULL,
    0x5380e09cb0ae0ULL,
    0x254172e2c8e90ULL,
    0xcc62b805b4338ULL,
    0xf7b3a4105f334ULL,
    0xdb48ce0cf5802ULL,
    0x56d8cd203fb0bULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x9000000000000ULL,
    0xe800000000000ULL,
    0x1c00000000000ULL,
    0x1600000000000ULL,
    0xa300000000000ULL,
    0x2880000000000ULL,
    0x8cc0000000000ULL,
    0xb4a0000000000ULL,
    0xc8f0000000000ULL,
    0xc748000000000ULL,
    0xd1a4000000000ULL,
    0x8b76000000000ULL,
    0xf0f000000000ULL,
    0x87c0800000000ULL,
    0xa021400000000ULL,
    0x2237e00000000ULL,
    0xa8ec300000000ULL,
    0xc5d6580000000ULL,
    0xcaffa40000000ULL,
    0xdf0fd60000000ULL,
    0x4fc63d0000000ULL,
    0xcc21438000000ULL,
    0x4c313c4000000ULL,
    0xffe8582000000ULL,
    0xe754a43000000ULL,
    0xf339563800000ULL,
    0xe0287d2400000ULL,
    0x237623ba00000ULL,
    0x330c4c4700000ULL,
    0xe1c1e02580000ULL,
    0x7b233018c0000ULL,
    0xfeb6d83220000ULL,
    0x2e2ee40730000ULL,
    0xc470361728000ULL,
    0x898e0d353c000ULL,
    0xbc011bb452000ULL,
    0xa601985ca9000ULL,
    0x3b070e08fd800ULL,
    0x4c83d910f3c00ULL,
    0x6ec7f5b4d8200ULL,
    0x1da1717e34500ULL,
    0x557623a35ff80ULL,
    0xc00c4c69520c0ULL,
    0xc141e00e28160ULL,
    0x7be3300dbc290ULL,
    0xb416d81e13d58ULL,
    0x59dee43bc9df4ULL,
    0x3db836292da8eULL,
    0x77ea0d24cb431ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0xb000000000000ULL,
    0xc800000000000ULL,
    0xc00000000000ULL,
    0x4e00000000000ULL,
    0xc300000000000ULL,
    0xf580000000000ULL,
    0xb40000000000ULL,
    0x68e0000000000ULL,
    0xfb50000000000ULL,
    0x9918000000000ULL,
    0xa9e4000000000ULL,
    0xa3d6000000000ULL,
    0xf4df000000000ULL,
    0x47c1800000000ULL,
    0xff20400000000ULL,
    0xbc77600000000ULL,
    0x16ff00000000ULL,
    0x5a8c580000000ULL,
    0xbc5dcc0000000ULL,
    0x72072a0000000ULL,
    0x8501df0000000ULL,
    0xda84b68000000ULL,
    0xc732c000000ULL,
    0x68a2582000000ULL,
    0x6a36cc3000000ULL,
    0x2708aa3800000ULL,
    0x9b1a9f2c00000ULL,
    0x4e456b200000ULL,
    0xc55782c300000ULL,
    0x7218e03380000ULL,
    0xe064b000c0000ULL,
    0x2e94b80560000ULL,
    0x53397c2ed0000ULL,
    0x713922838000ULL,
    0xae78a33dd4000ULL,
    0x88f724b5c6000ULL,
    0x52af91dab9000ULL,
    0x5fad7cb595800ULL,
    0xa92d5dcfe7c00ULL,
    0xb7ebd693c8600ULL,
    0x644cc2dd1c100ULL,
    0x3ff800235bd80ULL,
    0x51b4003522fc0ULL,
    0x2f4e0027d6960ULL,
    0xe67b000de0b30ULL,
    0x44f7801191aa8ULL,
    0xfcaf402f9867cULL,
    0x2caee02d64f5aULL,
    0x94abb00cae30bULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0xf000000000000ULL,
    0x6800000000000ULL,
    0x1400000000000ULL,
    0x8600000000000ULL,
    0x8f00000000000ULL,
    0x3a80000000000ULL,
    0x7e40000000000ULL,
    0xa020000000000ULL,
    0xe5f0000000000ULL,
    0xb1f8000000000ULL,
    0xeaa4000000000ULL,
    0x33b6000000000ULL,
    0xe5df000000000ULL,
    0x7953800000000ULL,
    0x654d400000000ULL,
    0x21fba00000000ULL,
    0xb2a1b00000000ULL,
    0xafb6380000000ULL,
    0x87d9f40000000ULL,
    0x1857020000000ULL,
    0xc4cc990000000ULL,
    0xe3396b8000000ULL,
    0xe3c3b5c000000ULL,
    0xd0e5b82000000ULL,
    0xad94b43000000ULL,
    0xe32ca23800000ULL,
    0xf82d293c00000ULL,
    0x84af539a00000ULL,
    0x95ea41c500000ULL,
    0xff4aba0180000ULL,
    0xcfc2d13c0000ULL,
    0x923c9b6a0000ULL,
    0x80719ce390000ULL,
    0x8d396b9208000ULL,
    0xb8c3b5cc7c000ULL,
    0x8c65b815fe000ULL,
    0xacd4b41569000ULL,
    0x118ca2204d800ULL,
    0x779d291fe7c00ULL,
    0x1377538ddce00ULL,
    0x15be41c6ef500ULL,
    0x4784ba2b20e80ULL,
    0x7dc72d1a516c0ULL,
    0xe3e649b9a80e0ULL,
    0xe513dcc26dbd0ULL,
    0x64694ba637208ULL,
    0x858b45deb5764ULL,
    0x319e2029a332eULL,
    0x7c73f03846417ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x9000000000000ULL,
    0x4800000000000ULL,
    0x4c00000000000ULL,
    0x2a00000000000ULL,
    0xdd00000000000ULL,
    0x4980000000000ULL,
    0xbec0000000000ULL,
    0x5560000000000ULL,
    0x8a30000000000ULL,
    0x1268000000000ULL,
    0xf4e4000000000ULL,
    0xc8f6000000000ULL,
    0x550f000000000ULL,
    0x37d0800000000ULL,
    0xbd1c400000000ULL,
    0xa429600000000ULL,
    0x14c7d00000000ULL,
    0x4865a80000000ULL,
    0x23b3ac0000000ULL,
    0x3caa660000000ULL,
    0xe980630000000ULL,
    0xec32d8000000ULL,
    0x6d65dd4000000ULL,
    0x1e35282000000ULL,
    0x3c6fec3000000ULL,
    0x4fe3063800000ULL,
    0x7677b32400000ULL,
    0x7f4e859200000ULL,
    0x95f2715300000ULL,
    0xdc894e2a80000ULL,
    0x69108f0740000ULL,
    0x7878abaa60000ULL,
    0x661a2e4bb0000ULL,
    0x4aaccda758000ULL,
    0x96814d418c000ULL,
    0x364160161a000ULL,
    0x2023d01e79000ULL,
    0x6093a80a5d800ULL,
    0xe6bcac0df3c00ULL,
    0x437ae6002c200ULL,
    0x189c23298b100ULL,
    0x80ea4db570580ULL,
    0xa4a20d60f8f40ULL,
    0x1fd080071cea0ULL,
    0xa11c4020932b0ULL,
    0x2629602b1cb98ULL,
    0x15c7d02e9208cULL,
    0x63e5a80e1d136ULL,
    0xc73ac2512435ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x5000000000000ULL,
    0xa800000000000ULL,
    0xbc00000000000ULL,
    0x6a00000000000ULL,
    0x6d00000000000ULL,
    0x9580000000000ULL,
    0xc9c0000000000ULL,
    0x9020000000000ULL,
    0x4b90000000000ULL,
    0xf8c8000000000ULL,
    0x1da4000000000ULL,
    0x8652000000000ULL,
    0x76eb000000000ULL,
    0xbd36800000000ULL,
    0x441f400000000ULL,
    0xe60ae00000000ULL,
    0x9d07d00000000ULL,
    0x4d87280000000ULL,
    0xedc0cc0000000ULL,
    0xbe22de0000000ULL,
    0x5897490000000ULL,
    0xd648408000000ULL,
    0x46e5b04000000ULL,
    0x2731a82000000ULL,
    0xf11f8c1000000ULL,
    0x57883e1800000ULL,
    0x7ac0991400000ULL,
    0xcea768aa00000ULL,
    0x88d17c6f00000ULL,
    0x1da9763a80000ULL,
    0xe457c50b40000ULL,
    0xd7ecfebd60000ULL,
    0xdab5696670000ULL,
    0xa4d8a0ae08000ULL,
    0x9dad606de4000ULL,
    0xa452001cb2000ULL,
    0xb7eb001829000ULL,
    0x8ab68036f4800ULL,
    0xcdf4014cac00ULL,
    0x21aae03bc5a00ULL,
    0xce57d037a3d00ULL,
    0xdaef283850b80ULL,
    0x1f34cc0918f40ULL,
    0xc518de339d4a0ULL,
    0xb18849065ef30ULL,
    0x85c4c09aff178ULL,
    0x2225f052af024ULL,
    0x297c833b6282ULL,
    0x43481c3c2b581ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0xb000000000000ULL,
    0x4800000000000ULL,
    0x7c00000000000ULL,
    0x5a00000000000ULL,
    0x2b00000000000ULL,
    0xfc80000000000ULL,
    0xa1c0000000000ULL,
    0x8ce0000000000ULL,
    0xa790000000000ULL,
    0x99a8000000000ULL,
    0x8c64000000000ULL,
    0x9c56000000000ULL,
    0xde4f000000000ULL,
    0x6771800000000ULL,
    0xec3c400000000ULL,
    0xa2c8e00000000ULL,
    0x6b5500000000ULL,
    0x80da180000000ULL,
    0xb55a840000000ULL,
    0xd71a1e0000000ULL,
    0x70b99f0000000ULL,
    0x730b688000000ULL,
    0x22508b4000000ULL,
    0xeb4b982000000ULL,
    0x3ef6c43000000ULL,
    0xc7afe3800000ULL,
    0x4a68cf2c00000ULL,
    0x2787709200000ULL,
    0x35450f5f00000ULL,
    0x120063680000ULL,
    0x89731b3ac0000ULL,
    0x2139768720000ULL,
    0xcf4d144470000ULL,
    0xc0f6f09138000ULL,
    0x19794f46e4000ULL,
    0x43e8e628ea000ULL,
    0x3fc64b35d9000ULL,
    0xe9e36eb235800ULL,
    0x617906ce3c00ULL,
    0x4decee9e64600ULL,
    0x42c0d0772b100ULL,
    0xcc638ebf78380ULL,
    0xbc56c05c04540ULL,
    0x8e48f6913b060ULL,
    0x9f71545851610ULL,
    0xd83e10b5c8e78ULL,
    0x84cc1f641c77cULL,
    0x77b2fe16af622ULL,
    0x575ccf3c03b6dULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0xf000000000000ULL,
    0xf800000000000ULL,
    0xa400000000000ULL,
    0x7e00000000000ULL,
    0x7100000000000ULL,
    0xc780000000000ULL,
    0xb5c0000000000ULL,
    0x5420000000000ULL,
    0xa1b0000000000ULL,
    0xa458000000000ULL,
    0xe7a4000000000ULL,
    0x2272000000000ULL,
    0x7d7d000000000ULL,
    0xab93800000000ULL,
    0xc4edc00000000ULL,
    0xdc7c200000000ULL,
    0x2412700000000ULL,
    0x8d2b480000000ULL,
    0xa25d9c0000000ULL,
    0x72a01e0000000ULL,
    0x3bf4c90000000ULL,
    0x49bf618000000ULL,
    0xc034b4c000000ULL,
    0x7498c82000000ULL,
    0x52005c1000000ULL,
    0x13043e2800000ULL,
    0xcc82b93c00000ULL,
    0x8d4629be00000ULL,
    0xaf6428e900000ULL,
    0x23d3563f80000ULL,
    0x9a0d550c40000ULL,
    0xc76d7f99e0000ULL,
    0x7bd7dd170000ULL,
    0xa934298b08000ULL,
    0x471928d16c000ULL,
    0x91c0d63e96000ULL,
    0x6a209509a9000ULL,
    0x70b15faf7c800ULL,
    0x93df0de72f400ULL,
    0xaa6761be6ce00ULL,
    0xd250b4fc17700ULL,
    0xa2cac83869080ULL,
    0x7ecd5c2ddd9c0ULL,
    0xe4cfbe193e520ULL,
    0x4bcb7927d4270ULL,
    0xd4809abd2e78ULL,
    0x870b58db03424ULL,
    0xc2eb9e0a9a506ULL,
    0x497d093e8ff13ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0xd000000000000ULL,
    0x8800000000000ULL,
    0xd400000000000ULL,
    0x4600000000000ULL,
    0x6300000000000ULL,
    0x1c80000000000ULL,
    0x3cc0000000000ULL,
    0xb4e0000000000ULL,
    0x77f0000000000ULL,
    0x5878000000000ULL,
    0xa464000000000ULL,
    0x1132000000000ULL,
    0x3d99000000000ULL,
    0x3a12800000000ULL,
    0x820e400000000ULL,
    0xd95ba00000000ULL,
    0x92f2b00000000ULL,
    0x47fc580000000ULL,
    0x7425c40000000ULL,
    0xc113160000000ULL,
    0xa28d5f0000000ULL,
    0x879d4b8000000ULL,
    0x5b104dc000000ULL,
    0x138ed82000000ULL,
    0x9e1b841000000ULL,
    0xc850b60800000ULL,
    0xf2bef3400000ULL,
    0xb5cb13a200000ULL,
    0x153889f500000ULL,
    0xe7c54e3180000ULL,
    0x44659b08c0000ULL,
    0xa136dd8f20000ULL,
    0x459e52fb30000ULL,
    0xb610b3af38000ULL,
    0x980a39f8fc000ULL,
    0x2859162f9e000ULL,
    0xab705f15d9000ULL,
    0x4bdcba96c800ULL,
    0xe0870dc156400ULL,
    0x3ec7f8303ca00ULL,
    0x39e77400bf900ULL,
    0xc774e3ee8e80ULL,
    0xb63c9b2e55ac0ULL,
    0x9b445d9dab960ULL,
    0x88a012f5a3310ULL,
    0x4dd313b466658ULL,
    0x6e6c89f405c7cULL,
    0x7c6f4e2ac33aeULL,
    0x19689b3f37ff7ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0xb000000000000ULL,
    0xb800000000000ULL,
    0xcc00000000000ULL,
    0x1a00000000000ULL,
    0x900000000000ULL,
    0x1880000000000ULL,
    0x7040000000000ULL,
    0x7ca0000000000ULL,
    0xc010000000000ULL,
    0x89b8000000000ULL,
    0x8624000000000ULL,
    0x5556000000000ULL,
    0xa79f000000000ULL,
    0x3771800000000ULL,
    0xcccbc00000000ULL,
    0x47ed600000000ULL,
    0x843f500000000ULL,
    0x3ce0880000000ULL,
    0xc4b2240000000ULL,
    0x65ac120000000ULL,
    0xa5998d0000000ULL,
    0x6277b48000000ULL,
    0x264837c000000ULL,
    0xfaa9082000000ULL,
    0x8e1de43000000ULL,
    0x53b7723800000ULL,
    0x3a29dd2c00000ULL,
    0x425ebcae00000ULL,
    0x6d15d3f300000ULL,
    0x8f3e7a2680000ULL,
    0x7164393240000ULL,
    0x5e71cebe20000ULL,
    0xa4480ef010000ULL,
    0x6faec69128000ULL,
    0x849aeaf304000ULL,
    0x5ef034bcee000ULL,
    0x880cf7ffc9000ULL,
    0xe10de82575800ULL,
    0x898d741af7c00ULL,
    0xa1cc9a0274600ULL,
    0xa16ba91e76f00ULL,
    0xc37ba69d35580ULL,
    0x8fc1baedd6d40ULL,
    0xb66bca5e5a20ULL,
    0x2771d3c69f490ULL,
    0xe4c87a37d1648ULL,
    0x63eb390bc9934ULL,
    0x5a384eb775352ULL,
    0x5be7cecff719fULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x7000000000000ULL,
    0xb800000000000ULL,
    0x8400000000000ULL,
    0xb200000000000ULL,
    0x2900000000000ULL,
    0xcf80000000000ULL,
    0xd40000000000ULL,
    0x5720000000000ULL,
    0x4590000000000ULL,
    0x2e88000000000ULL,
    0xb2a4000000000ULL,
    0x55d6000000000ULL,
    0x1c2d000000000ULL,
    0x2777800000000ULL,
    0xe9fbc00000000ULL,
    0x4b5d200000000ULL,
    0x768c100000000ULL,
    0x26a3880000000ULL,
    0x8fd2dc0000000ULL,
    0x792eba0000000ULL,
    0x66f5910000000ULL,
    0xfbbe208000000ULL,
    0x48f8e64000000ULL,
    0xd8dc082000000ULL,
    0x9dcd1c3000000ULL,
    0x22859a2800000ULL,
    0x10c4811c00000ULL,
    0xa36228ae00000ULL,
    0x1535fa6100000ULL,
    0x5a59920c80000ULL,
    0xfd099d3a40000ULL,
    0x39e7b29be0000ULL,
    0x81f17b5f50000ULL,
    0x4b3bba9bc8000ULL,
    0xc13c674064000ULL,
    0xac3e20af22000ULL,
    0x71b8e64ae9000ULL,
    0x25fc080095800ULL,
    0x55d1c095b400ULL,
    0xc98d9a3695e00ULL,
    0x220811c5af00ULL,
    0xdc1428a815480ULL,
    0x68c8fa591a040ULL,
    0xcb06123675620ULL,
    0xee865d0c8bf70ULL,
    0x5ec492921c4e8ULL,
    0x1c646b415e944ULL,
    0x31b1b2a927402ULL,
    0x99c7b645b7d9ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x7000000000000ULL,
    0x800000000000ULL,
    0x3400000000000ULL,
    0x3a00000000000ULL,
    0xd00000000000ULL,
    0x7f80000000000ULL,
    0xbb40000000000ULL,
    0x9a0000000000ULL,
    0xd870000000000ULL,
    0x3708000000000ULL,
    0xb824000000000ULL,
    0x7432000000000ULL,
    0x5c2b000000000ULL,
    0xdc97800000000ULL,
    0xcdda400000000ULL,
    0x3bdea00000000ULL,
    0x70dc500000000ULL,
    0x6c5d280000000ULL,
    0xef9cdc0000000ULL,
    0x27faca0000000ULL,
    0x6ef450000000ULL,
    0x61738f8000000ULL,
    0x328eba4000000ULL,
    0x6e62a82000000ULL,
    0x72129c1000000ULL,
    0x371e6a1800000ULL,
    0xd63c151c00000ULL,
    0x978b278200000ULL,
    0x75e3264d00000ULL,
    0xeb51422e80000ULL,
    0x7fbbc91340000ULL,
    0x77ce6d87e0000ULL,
    0x18c22372d0000ULL,
    0x8ce66da068000ULL,
    0x8ed6236b1c000ULL,
    0xd9fc6dbb42000ULL,
    0x79e9236149000ULL,
    0x47f1edb8ec800ULL,
    0xbc4c6378dac00ULL,
    0xd982cd81cde00ULL,
    0xe84573472a900ULL,
    0x5924c5a855a80ULL,
    0x5db4bf5eae140ULL,
    0xfc6a07af13ca0ULL,
    0xd1b1367661f70ULL,
    0xda68ca1a11528ULL,
    0xc2b4450648414ULL,
    0xeaec0f8f6dcbeULL,
    0x3770fa631b7a9ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x7000000000000ULL,
    0x6800000000000ULL,
    0x3c00000000000ULL,
    0xba00000000000ULL,
    0xbf00000000000ULL,
    0x9a80000000000ULL,
    0xd940000000000ULL,
    0x5c60000000000ULL,
    0x4110000000000ULL,
    0x5f68000000000ULL,
    0xa8e4000000000ULL,
    0x6156000000000ULL,
    0xfc8b000000000ULL,
    0x6537800000000ULL,
    0x499d400000000ULL,
    0xac5ee00000000ULL,
    0xfc7c500000000ULL,
    0xbc8fb80000000ULL,
    0xc537b40000000ULL,
    0x599eda0000000ULL,
    0xb4593b0000000ULL,
    0xa8782c8000000ULL,
    0x3a8fb94000000ULL,
    0xc030382000000ULL,
    0x7c1ef43000000ULL,
    0xf79e3a1800000ULL,
    0x2d5a6b1c00000ULL,
    0x27fe149a00000ULL,
    0xde4a4d4f00000ULL,
    0x8b91820e80000ULL,
    0x3e2ddf1fc0000ULL,
    0xb080cebea0000ULL,
    0xbe43766a50000ULL,
    0xf2e1aead18000ULL,
    0x6e56666f44000ULL,
    0x6e0ef6815a000ULL,
    0xf0728269f9000ULL,
    0xc7fe149cf5800ULL,
    0x6e4a4d6a72c00ULL,
    0x83918202d5e00ULL,
    0x722ddf0ee3500ULL,
    0x6280ceb6edb80ULL,
    0x3d43765fb6140ULL,
    0xd261ae924e6e0ULL,
    0x8166678bb2d0ULL,
    0xa8eef6bfc8568ULL,
    0x682282709c1ecULL,
    0xc4f6149d3e332ULL,
    0x87be4d61b33a5ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0xd000000000000ULL,
    0x2800000000000ULL,
    0x4c00000000000ULL,
    0xda00000000000ULL,
    0xd300000000000ULL,
    0xad80000000000ULL,
    0xd1c0000000000ULL,
    0x6fa0000000000ULL,
    0xb830000000000ULL,
    0xf1b8000000000ULL,
    0x9c24000000000ULL,
    0x9cf6000000000ULL,
    0x629d000000000ULL,
    0x3f52800000000ULL,
    0xc0af400000000ULL,
    0xbdeb600000000ULL,
    0x210a500000000ULL,
    0xd8d8d80000000ULL,
    0x60368c0000000ULL,
    0x85bc9e0000000ULL,
    0x8221450000000ULL,
    0x9f5dd8000000ULL,
    0xee1f6bc000000ULL,
    0xdc12582000000ULL,
    0x94dcc3000000ULL,
    0x68b9fe2800000ULL,
    0xaaa2153400000ULL,
    0xdcb1858a00000ULL,
    0xfeffa7d300000ULL,
    0x5fc1261680000ULL,
    0xb2a49904c0000ULL,
    0x8b51b8360000ULL,
    0x30fae2c070000ULL,
    0xe2c2fbb1e8000ULL,
    0x7226f2cd0c000ULL,
    0x31f5c382ee000ULL,
    0x2a186ed7c9000ULL,
    0x9a10658e5d800ULL,
    0x284eb7fbd7400ULL,
    0x5a3c9e20bca00ULL,
    0xce1453de7d00ULL,
    0xb1d5ddacf4d80ULL,
    0x84ef6bc8fb940ULL,
    0xc78a583d03b60ULL,
    0xb099cc0d16e30ULL,
    0xb057fe3cdd878ULL,
    0x3f2b152d16814ULL,
    0x232d058cdc2f6ULL,
    0x1129e7c5170efULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0xd000000000000ULL,
    0xd800000000000ULL,
    0xc00000000000ULL,
    0xee00000000000ULL,
    0x9d00000000000ULL,
    0xf280000000000ULL,
    0x18c0000000000ULL,
    0xd4e0000000000ULL,
    0xf370000000000ULL,
    0x11e8000000000ULL,
    0xdb64000000000ULL,
    0x2936000000000ULL,
    0xf5c9000000000ULL,
    0xf8f2800000000ULL,
    0xf1a8c00000000ULL,
    0x4045600000000ULL,
    0x8b27f00000000ULL,
    0x5a13280000000ULL,
    0x73d9740000000ULL,
    0xbd2d760000000ULL,
    0xdd802f0000000ULL,
    0x81407f8000000ULL,
    0x8fa3214000000ULL,
    0xf3d7a82000000ULL,
    0x6bb8b43000000ULL,
    0x139a960800000ULL,
    0xe60f1f3400000ULL,
    0x5f9637b600000ULL,
    0xfe9da54300000ULL,
    0xdc89f61b80000ULL,
    0xb351ef1740000ULL,
    0x187f9fb4a0000ULL,
    0x84f8117230000ULL,
    0xc13fe02338000ULL,
    0xc75b300fdc000ULL,
    0xfce84837fa000ULL,
    0xe1e3842599000ULL,
    0xc5f2de00ed800ULL,
    0x132c9b3842400ULL,
    0xa084e9b084a00ULL,
    0x83c13e67f6300ULL,
    0x9f651f88cb580ULL,
    0xf334d16220fc0ULL,
    0x7acc8001f14a0ULL,
    0x7175c019581d0ULL,
    0x52e9e02b0dfd8ULL,
    0x9ce2300ad33bcULL,
    0xc772c8378cc7eULL,
    0x3ef441813745ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0xb000000000000ULL,
    0x800000000000ULL,
    0x5c00000000000ULL,
    0xf600000000000ULL,
    0x6900000000000ULL,
    0xf80000000000ULL,
    0x59c0000000000ULL,
    0x2260000000000ULL,
    0x6ef0000000000ULL,
    0x7328000000000ULL,
    0xb4e4000000000ULL,
    0x10b6000000000ULL,
    0x48f000000000ULL,
    0xb671800000000ULL,
    0x306e400000000ULL,
    0x66c1e00000000ULL,
    0xd4e4300000000ULL,
    0x60b4080000000ULL,
    0xec8f1c0000000ULL,
    0x5a713e0000000ULL,
    0xce6ebb0000000ULL,
    0x53c7bb8000000ULL,
    0x2d619f4000000ULL,
    0x5073882000000ULL,
    0xc16e5c3000000ULL,
    0x6d415e3800000ULL,
    0x9f24cb2c00000ULL,
    0x89d2538200000ULL,
    0x4efab35700000ULL,
    0xe01ebe1d80000ULL,
    0x67abfb2a40000ULL,
    0x59a1dbbbe0000ULL,
    0x4f94ef7a70000ULL,
    0x6d5fe02a98000ULL,
    0x488f303cbc000ULL,
    0xd87388194a000ULL,
    0x5d6e5c1b79000ULL,
    0x7b415e05cd800ULL,
    0x4624cb0053c00ULL,
    0x8e52539884600ULL,
    0x4b3ab34de7900ULL,
    0x347ebe269a780ULL,
    0x605bfb3e700c0ULL,
    0x2509dbac98820ULL,
    0xa2b0ef4dbc070ULL,
    0x5f89e005ca2f8ULL,
    0x22f03035b93ecULL,
    0x1d2a080cec16eULL,
    0xd9e41c0902abdULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x5000000000000ULL,
    0xd800000000000ULL,
    0x2c00000000000ULL,
    0xfa00000000000ULL,
    0x300000000000ULL,
    0xce80000000000ULL,
    0x31c0000000000ULL,
    0xff60000000000ULL,
    0xb4f0000000000ULL,
    0x5c08000000000ULL,
    0xae4000000000ULL,
    0xf7b6000000000ULL,
    0xd0ab000000000ULL,
    0x3e76800000000ULL,
    0xf3c8c00000000ULL,
    0x9886600000000ULL,
    0x8c3500000000ULL,
    0x52e5d80000000ULL,
    0x1bb5940000000ULL,
    0x4aa89e0000000ULL,
    0x6d72830000000ULL,
    0xe54a038000000ULL,
    0x8544764000000ULL,
    0xda5582000000ULL,
    0xe516543000000ULL,
    0x89387e1800000ULL,
    0x7189131400000ULL,
    0x65a1bbb600000ULL,
    0x8116b24b00000ULL,
    0xe73e1e1e80000ULL,
    0xf48a4330c0000ULL,
    0x8a2463aba0000ULL,
    0x5153265870000ULL,
    0x1d1e8029d8000ULL,
    0x8ddcc0163c000ULL,
    0x5338603182000ULL,
    0x828c501679000ULL,
    0x432558384d800ULL,
    0x14d654335ac00ULL,
    0x16587e0ec5a00ULL,
    0x957913110e300ULL,
    0xe1a9bb8283980ULL,
    0xa7f2b24cf9d40ULL,
    0xea881e368cf60ULL,
    0x2721432ffba50ULL,
    0x7ad2e39235878ULL,
    0x935be6711790cULL,
    0x7af8e0349e98eULL,
    0x31ef902c4b099ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x3000000000000ULL,
    0x7800000000000ULL,
    0xc400000000000ULL,
    0xf200000000000ULL,
    0x9f00000000000ULL,
    0x7480000000000ULL,
    0x87c0000000000ULL,
    0x1820000000000ULL,
    0xfa70000000000ULL,
    0xa08000000000ULL,
    0x3ba4000000000ULL,
    0x7536000000000ULL,
    0xc3eb000000000ULL,
    0x84f5800000000ULL,
    0x16cdc00000000ULL,
    0xc501200000000ULL,
    0xa780100000000ULL,
    0xdd44380000000ULL,
    0x6e4040000000ULL,
    0x83d06e0000000ULL,
    0x583a190000000ULL,
    0x28cfe78000000ULL,
    0xb402964000000ULL,
    0x2a07b82000000ULL,
    0xb02c43000000ULL,
    0xce84ce1800000ULL,
    0xa4c7c90c00000ULL,
    0x5aa2ff9e00000ULL,
    0x10b2827100000ULL,
    0xf9adee1c80000ULL,
    0x3293d917c0000ULL,
    0xe0d8c78520000ULL,
    0x1a19866df0000ULL,
    0x1be003808000ULL,
    0xe48f003f9c000ULL,
    0xf63802602000ULL,
    0x796c02529000ULL,
    0x5f5ca01e6d800ULL,
    0x3359d0200ac00ULL,
    0x8d5b181bb5600ULL,
    0x3c5b141cef700ULL,
    0xd1dfd62ee2480ULL,
    0x379cdd06f9040ULL,
    0x87fd29ac148e0ULL,
    0x64ee5f4fdfc10ULL,
    0x9470c7a34b7b8ULL,
    0x330d866d54f64ULL,
    0xa20001e3e31eULL,
    0x957000081a619ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x5000000000000ULL,
    0x4800000000000ULL,
    0xbc00000000000ULL,
    0xae00000000000ULL,
    0x100000000000ULL,
    0x1980000000000ULL,
    0xfcc0000000000ULL,
    0xc760000000000ULL,
    0x8bf0000000000ULL,
    0xca18000000000ULL,
    0x67e4000000000ULL,
    0xeab2000000000ULL,
    0x9bbb000000000ULL,
    0x2076800000000ULL,
    0xe9d8400000000ULL,
    0xc002e00000000ULL,
    0x2005f00000000ULL,
    0x3001480000000ULL,
    0x1807ac0000000ULL,
    0xf400d60000000ULL,
    0x1203d30000000ULL,
    0xaf01e38000000ULL,
    0x1881bec000000ULL,
    0xe545c82000000ULL,
    0x3ba4ec1000000ULL,
    0x4c94b61800000ULL,
    0x41ee631400000ULL,
    0xadfa4b9200000ULL,
    0x8d57e2ef00000ULL,
    0x710e560b80000ULL,
    0xbbcf931040000ULL,
    0xc9a9039e60000ULL,
    0x29db4eeb30000ULL,
    0xe0000003d8000ULL,
    0x1000001dfc000ULL,
    0x2800000106000ULL,
    0xec00000db9000ULL,
    0xe600002ecc800ULL,
    0xbd000036dec00ULL,
    0xb780001245a00ULL,
    0xfdc00018ca100ULL,
    0xdee00004e6b80ULL,
    0x7730002ec87c0ULL,
    0xd78000774d20ULL,
    0xec140002132b0ULL,
    0x20aa00079b958ULL,
    0xfc5f00270fe4cULL,
    0xcac480216c40eULL,
    0x72634028cfd3bULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x9000000000000ULL,
    0x800000000000ULL,
    0x8400000000000ULL,
    0xae00000000000ULL,
    0x8900000000000ULL,
    0xea80000000000ULL,
    0xbb40000000000ULL,
    0xb0a0000000000ULL,
    0x3250000000000ULL,
    0xd508000000000ULL,
    0x6724000000000ULL,
    0x7596000000000ULL,
    0xabef000000000ULL,
    0xbd50800000000ULL,
    0x828e400000000ULL,
    0xe0e7200000000ULL,
    0xeb77f00000000ULL,
    0xe19b080000000ULL,
    0x424bf40000000ULL,
    0x4d82ea0000000ULL,
    0x18c4ed0000000ULL,
    0x160368000000ULL,
    0xa9b3fa4000000ULL,
    0x5ffd882000000ULL,
    0x47ab43000000ULL,
    0x69bd4a3800000ULL,
    0x30595d2400000ULL,
    0x89aa1e8200000ULL,
    0x2f70fe6100000ULL,
    0x6f9cea0b80000ULL,
    0xbb4fed1240000ULL,
    0x3f06b682a0000ULL,
    0x2f82ba4ad0000ULL,
    0x9bc2280e28000ULL,
    0xbce7041d94000ULL,
    0xe9776226c2000ULL,
    0x329a591f89000ULL,
    0x17cb7ca5c5800ULL,
    0x1945a7652bc00ULL,
    0xd3a71688fc200ULL,
    0x1fd40a7e77900ULL,
    0x9dce802fdbc80ULL,
    0x8e454019c4fc0ULL,
    0xc821a0332b420ULL,
    0x5216b033fd3d0ULL,
    0xb42ca820f69a8ULL,
    0xafb2443c1bab4ULL,
    0xe2fec2342445aULL,
    0x38f8e936dac29ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0xd000000000000ULL,
    0x9800000000000ULL,
    0xb400000000000ULL,
    0xbe00000000000ULL,
    0xe300000000000ULL,
    0xe80000000000ULL,
    0xa940000000000ULL,
    0x9f60000000000ULL,
    0xd430000000000ULL,
    0x8b18000000000ULL,
    0x2ee4000000000ULL,
    0xf1f6000000000ULL,
    0xec39000000000ULL,
    0x5232800000000ULL,
    0xcc1ac00000000ULL,
    0x2660a00000000ULL,
    0xdfb5700000000ULL,
    0x5bdad80000000ULL,
    0x7847540000000ULL,
    0x68e27a0000000ULL,
    0x96f7430000000ULL,
    0x34bda58000000ULL,
    0xe476cac000000ULL,
    0xcffe582000000ULL,
    0xb214943000000ULL,
    0x98485a0800000ULL,
    0xe5ccf33400000ULL,
    0x3a09dda600000ULL,
    0x4829eeed00000ULL,
    0xf57a7a0f80000ULL,
    0x65534308c0000ULL,
    0xc42ba58ba0000ULL,
    0xef7fcade50000ULL,
    0x8054d821d8000ULL,
    0x4daa54280c000ULL,
    0x6ebefa0546000ULL,
    0xe170830779000ULL,
    0xb6798599dd800ULL,
    0x7bd07afc5e400ULL,
    0xd56ea03cd4a00ULL,
    0x1418700ecab00ULL,
    0x72665820fe280ULL,
    0x91b09422045c0ULL,
    0xf0de5a2b53360ULL,
    0x5ac5f33d13950ULL,
    0xcba35d83f23e8ULL,
    0x54972ee5c260cULL,
    0xd0cda1b6ac16ULL,
    0xc8af332faeaebULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x5000000000000ULL,
    0x3800000000000ULL,
    0xfc00000000000ULL,
    0x4200000000000ULL,
    0x4700000000000ULL,
    0xdd80000000000ULL,
    0x8c40000000000ULL,
    0xa3e0000000000ULL,
    0xbfd0000000000ULL,
    0xd8f8000000000ULL,
    0x1b64000000000ULL,
    0xb912000000000ULL,
    0xf2df000000000ULL,
    0x2716800000000ULL,
    0x7dbc00000000ULL,
    0x3594e00000000ULL,
    0xc21a900000000ULL,
    0x9c30f80000000ULL,
    0x27298c0000000ULL,
    0x239cb20000000ULL,
    0xf274470000000ULL,
    0x73cdc28000000ULL,
    0x29cefdc000000ULL,
    0x62cc782000000ULL,
    0x75494c1000000ULL,
    0x2a0cd23800000ULL,
    0xd26a171400000ULL,
    0x18ff5a8e00000ULL,
    0xbb6621ff00000ULL,
    0x914d23080000ULL,
    0x9ade1701c0000ULL,
    0xe3155a8f60000ULL,
    0xb9dd21f710000ULL,
    0x30905206f8000ULL,
    0x589ad700f4000ULL,
    0xcdf73a9ebe000ULL,
    0x88c71c319000ULL,
    0x3fac4a3724800ULL,
    0x955dcb30a7c00ULL,
    0xb0517089bda00ULL,
    0x8bbabaebc2f00ULL,
    0x2901baa23b380ULL,
    0xa087b1fa4fa40ULL,
    0xac0aa2930be0ULL,
    0xe0235b0f49a30ULL,
    0xef7388b67c8c8ULL,
    0xe54c36f3a2e1cULL,
    0xb20b88a9aac8aULL,
    0x9e6836d776db7ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0xd000000000000ULL,
    0x4800000000000ULL,
    0x9400000000000ULL,
    0x2e00000000000ULL,
    0x4500000000000ULL,
    0x680000000000ULL,
    0x67c0000000000ULL,
    0xb8e0000000000ULL,
    0x4ad0000000000ULL,
    0x1ae8000000000ULL,
    0xe564000000000ULL,
    0x9692000000000ULL,
    0xef49000000000ULL,
    0x5292800000000ULL,
    0xc948400000000ULL,
    0xa391a00000000ULL,
    0x31cdf00000000ULL,
    0xc955680000000ULL,
    0x1ba8140000000ULL,
    0xca450e0000000ULL,
    0xfca7cf0000000ULL,
    0x6370528000000ULL,
    0x171be14000000ULL,
    0xd1bde82000000ULL,
    0x99cd541000000ULL,
    0xed542e0800000ULL,
    0x8dab7f3400000ULL,
    0x83461a9200000ULL,
    0x826456500000ULL,
    0xfbb42e2b80000ULL,
    0xc27b7f0140000ULL,
    0xbf2e1a89a0000ULL,
    0x5a82456df0000ULL,
    0x9dc62e1c38000ULL,
    0xf3e27f27b4000ULL,
    0xd9549a853a000ULL,
    0x33ae055c19000ULL,
    0xae458e1604800ULL,
    0x4aa68f1722400ULL,
    0xfa7372b91ca00ULL,
    0xab9e5145a6100ULL,
    0xdd79201dfe680ULL,
    0x62a8b019da7c0ULL,
    0xc6c4483a49da0ULL,
    0x4864a40acc450ULL,
    0x941346332fe38ULL,
    0xce8a6b08d2e3cULL,
    0xeb7194b024fcaULL,
    0xe319ca7193c45ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0xd000000000000ULL,
    0xd800000000000ULL,
    0x5400000000000ULL,
    0x1a00000000000ULL,
    0xe900000000000ULL,
    0x3480000000000ULL,
    0xc240000000000ULL,
    0x2b20000000000ULL,
    0x98b0000000000ULL,
    0x2288000000000ULL,
    0x14a4000000000ULL,
    0xa376000000000ULL,
    0x8d6b000000000ULL,
    0xd072800000000ULL,
    0x90e8c00000000ULL,
    0x46b5a00000000ULL,
    0xa988500000000ULL,
    0x2d26880000000ULL,
    0x47b3840000000ULL,
    0x10b020000000ULL,
    0x1966310000000ULL,
    0x1b95718000000ULL,
    0x8639ee4000000ULL,
    0x702a082000000ULL,
    0xc8d4443000000ULL,
    0xbd9a221800000ULL,
    0x58dda13400000ULL,
    0x747cd9b600000ULL,
    0x930efa5500000ULL,
    0xbc64222680000ULL,
    0x112a10a40000ULL,
    0x6778599520000ULL,
    0x5e8d3a4490000ULL,
    0xf2a3021cc8000ULL,
    0x6c7231032c000ULL,
    0x16eb719622000ULL,
    0x59b6ee4b69000ULL,
    0xea0e8833fd800ULL,
    0xf0e78436cac00ULL,
    0x2755022054a00ULL,
    0x5e59310c56300ULL,
    0xa339f1a22f680ULL,
    0xaaae2e4adb140ULL,
    0x4993280fdc220ULL,
    0x433bd41eda210ULL,
    0xbaad8a29dc608ULL,
    0xf195b523dabc4ULL,
    0xc73e73835db46ULL,
    0x78afdf5b9aaf9ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0xb000000000000ULL,
    0xb800000000000ULL,
    0x3400000000000ULL,
    0x2a00000000000ULL,
    0x9300000000000ULL,
    0x6e80000000000ULL,
    0x8940000000000ULL,
    0x920000000000ULL,
    0xaa90000000000ULL,
    0xc438000000000ULL,
    0x9aa4000000000ULL,
    0xec52000000000ULL,
    0xdddf000000000ULL,
    0xfcd1800000000ULL,
    0x1d9fc00000000ULL,
    0x5072a00000000ULL,
    0xd4ced00000000ULL,
    0x862a580000000ULL,
    0x4ad9540000000ULL,
    0x4051da0000000ULL,
    0xd3ddf10000000ULL,
    0xadd4308000000ULL,
    0xdc1d13c000000ULL,
    0x11b1d82000000ULL,
    0xd9ad941000000ULL,
    0xf218fa3800000ULL,
    0x50b7e12c00000ULL,
    0xf02f48ae00000ULL,
    0x8fda57cd00000ULL,
    0xfbd17a2a80000ULL,
    0x91c2134c0000ULL,
    0x4237e8a3a0000ULL,
    0x3f6f87ce50000ULL,
    0xbbf8a20c48000ULL,
    0x3ec5b537a4000ULL,
    0x8de512838e000ULL,
    0x1c7366ee69000ULL,
    0x6acc6aaeb4800ULL,
    0x6f2b22c827c00ULL,
    0xbf5d48affc600ULL,
    0x2b9557f503f00ULL,
    0x4db8fa08b2a80ULL,
    0xb767e100cab40ULL,
    0x4f37488456160ULL,
    0xa8ee57caa5950ULL,
    0x2f3b7a010e168ULL,
    0x6027210ea98c4ULL,
    0x1f1468af15242ULL,
    0x4fff47f57730fULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x7000000000000ULL,
    0xc800000000000ULL,
    0x6c00000000000ULL,
    0x1e00000000000ULL,
    0x2d00000000000ULL,
    0x7180000000000ULL,
    0x9c0000000000ULL,
    0x960000000000ULL,
    0x4a70000000000ULL,
    0x6f58000000000ULL,
    0xc0a4000000000ULL,
    0xe312000000000ULL,
    0xb52f000000000ULL,
    0x17ff800000000ULL,
    0x87b0400000000ULL,
    0x243e600000000ULL,
    0x91d0700000000ULL,
    0xcccea80000000ULL,
    0xdbcdac0000000ULL,
    0xb54e5e0000000ULL,
    0x1e0e930000000ULL,
    0x3229578000000ULL,
    0xc17c88c000000ULL,
    0x88f0c82000000ULL,
    0x7a1ddc1000000ULL,
    0x5180f63800000ULL,
    0xd9c33f1c00000ULL,
    0x516709b200000ULL,
    0x9e721bdb00000ULL,
    0xd5599fa780000ULL,
    0x9fa154db40000ULL,
    0xa1903e0460000ULL,
    0xe06ee30e70000ULL,
    0x66dfff8858000ULL,
    0xcd6524d59c000ULL,
    0x874960e56000ULL,
    0x74584f3069000ULL,
    0x8024219b24800ULL,
    0x4d50f7f87bc00ULL,
    0xf48e2189c7e00ULL,
    0x3b6bf7fa00100ULL,
    0x865ba18f01980ULL,
    0xf320b7c1811c0ULL,
    0xf1d041a6412a0ULL,
    0xfccb87fee1ab0ULL,
    0xf3cd09bfb0f78ULL,
    0xa9491bc5f874cULL,
    0xc80c1faa4c2deULL,
    0x732a14dbde2e3ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x7000000000000ULL,
    0x6800000000000ULL,
    0xc400000000000ULL,
    0xc600000000000ULL,
    0xa700000000000ULL,
    0x7180000000000ULL,
    0x340000000000ULL,
    0x2c20000000000ULL,
    0x4170000000000ULL,
    0xfc58000000000ULL,
    0xf64000000000ULL,
    0x5d52000000000ULL,
    0x752d000000000ULL,
    0x473f800000000ULL,
    0xfc35400000000ULL,
    0x4b79200000000ULL,
    0x8594b00000000ULL,
    0x1f4ff80000000ULL,
    0xeaefec0000000ULL,
    0x8cdd8a0000000ULL,
    0x4aa2290000000ULL,
    0xbbb61f8000000ULL,
    0xc73f84c000000ULL,
    0xbc36d82000000ULL,
    0xeb7b5c1000000ULL,
    0xf592722800000ULL,
    0x774dc51c00000ULL,
    0x2eeb959a00000ULL,
    0x4addadf100000ULL,
    0xeda0c79180000ULL,
    0xca34d8f9c0000ULL,
    0xc47caa1460000ULL,
    0x9012990cd0000ULL,
    0xaa0be7b908000ULL,
    0x9cd68fd5c000ULL,
    0x782cd23496000ULL,
    0x73b8350b19000ULL,
    0x3ff74d92b4800ULL,
    0xaa9ff1e85b400ULL,
    0x360735bca7e00ULL,
    0x8f055dce81500ULL,
    0x15839f9f40480ULL,
    0xb543c4d7202c0ULL,
    0xe3227821f17e0ULL,
    0xf4f7ac19f9bb0ULL,
    0x391b2a2d24028ULL,
    0x8443d924729a4ULL,
    0x6da0c7a50a2feULL,
    0x8a34d8f46e9d3ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0xd000000000000ULL,
    0xf800000000000ULL,
    0x2400000000000ULL,
    0x3600000000000ULL,
    0x700000000000ULL,
    0xe680000000000ULL,
    0xb840000000000ULL,
    0xc2e0000000000ULL,
    0xcab0000000000ULL,
    0x1a8000000000ULL,
    0x2a4000000000ULL,
    0x6c52000000000ULL,
    0x9d1b000000000ULL,
    0xd40a800000000ULL,
    0x7071c00000000ULL,
    0x6d08200000000ULL,
    0xbdf0300000000ULL,
    0x69cb780000000ULL,
    0xfa56d40000000ULL,
    0x6a19d20000000ULL,
    0x7a8f5f0000000ULL,
    0xc430f98000000ULL,
    0x45ed8b4000000ULL,
    0x6243582000000ULL,
    0xbfe6e41000000ULL,
    0xa132aa1800000ULL,
    0x9a698b3400000ULL,
    0x57812bbe00000ULL,
    0x19c6d44900000ULL,
    0xfc21a1ad80000ULL,
    0x60106f51c0000ULL,
    0xf1fb7201a0000ULL,
    0xedbeaf0a10000ULL,
    0x595ba196b8000ULL,
    0xf4ef6f4fac000ULL,
    0xc3c3f213ea000ULL,
    0x81246f1869000ULL,
    0xb9101b734800ULL,
    0x6a3a9f7c96c00ULL,
    0xb89aaa221aa00ULL,
    0x2ccd8b19a0700ULL,
    0x95d32bbe10080ULL,
    0x77ddd468b90c0ULL,
    0xab21a6ac5e0ULL,
    0x8b21af6e6a750ULL,
    0x8e935231a8548ULL,
    0x25be9f329567cULL,
    0x1558d98086966ULL,
    0x7eedbb71a21edULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x1000000000000ULL,
    0xa800000000000ULL,
    0xa400000000000ULL,
    0xc200000000000ULL,
    0xa500000000000ULL,
    0x5580000000000ULL,
    0xcd40000000000ULL,
    0x4960000000000ULL,
    0x8590000000000ULL,
    0x47a8000000000ULL,
    0x9024000000000ULL,
    0x76f6000000000ULL,
    0x4b39000000000ULL,
    0xf40c800000000ULL,
    0xe497400000000ULL,
    0x202a200000000ULL,
    0x6063900000000ULL,
    0x7616e80000000ULL,
    0xcdebcc0000000ULL,
    0x39c1da0000000ULL,
    0xc3a2330000000ULL,
    0x2cb7888000000ULL,
    0x6ad86b4000000ULL,
    0xf55cc82000000ULL,
    0xe9185c3000000ULL,
    0xbfff320800000ULL,
    0xe62dff0400000ULL,
    0xd76052aa00000ULL,
    0xe93586900000ULL,
    0xe12fc09080000ULL,
    0xd7e3775940000ULL,
    0xe57da3d60000ULL,
    0x790b330750000ULL,
    0xd51308b058000ULL,
    0xf6b2b4c64000ULL,
    0x9c00e82b6a000ULL,
    0xe02cc1449000ULL,
    0xe3055a305d800ULL,
    0x2281730cde400ULL,
    0x95c3a8903b200ULL,
    0x75a6fb4211d00ULL,
    0xc3b0a01b38880ULL,
    0x2e5dd00435e40ULL,
    0x798480cb23a0ULL,
    0x6c3b1c32edb30ULL,
    0xe48b121696d68ULL,
    0x4c536f13671ccULL,
    0x1c0c3a9f4e4a2ULL,
    0xa096d476c22edULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0xb000000000000ULL,
    0x8800000000000ULL,
    0xa400000000000ULL,
    0x3a00000000000ULL,
    0xbb00000000000ULL,
    0x2b80000000000ULL,
    0x95c0000000000ULL,
    0xb760000000000ULL,
    0x5730000000000ULL,
    0xb958000000000ULL,
    0xdea4000000000ULL,
    0xa656000000000ULL,
    0xd369000000000ULL,
    0x5179800000000ULL,
    0x6bb6400000000ULL,
    0x591a200000000ULL,
    0x5d01500000000ULL,
    0x6682180000000ULL,
    0xb413c0000000ULL,
    0xb025de0000000ULL,
    0xc915f30000000ULL,
    0x794b1d8000000ULL,
    0x936de8c000000ULL,
    0xb178382000000ULL,
    0xfbb06c3000000ULL,
    0x611fc60800000ULL,
    0x7100cf2c00000ULL,
    0xf880c3a200000ULL,
    0x8a451be900000ULL,
    0x20a4a5ae80000ULL,
    0x7756c4dec0000ULL,
    0x5bea5e22e0000ULL,
    0x733ab33970000ULL,
    0x5f10bd87d8000ULL,
    0x9c4ef8d0cc000ULL,
    0x19ee0022d6000ULL,
    0x43d000069000ULL,
    0x7a978025f5800ULL,
    0xb08b40136a400ULL,
    0x120da01166600ULL,
    0x734a100351900ULL,
    0x606fb81b48880ULL,
    0x1efb2c1be5540ULL,
    0xe472661483060ULL,
    0xe57adf24d30f0ULL,
    0xa9b77bbc1a978ULL,
    0xee1a37c9beaccULL,
    0x5880c3921c2f6ULL,
    0xfa451beedfbe3ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0x9000000000000ULL,
    0x4800000000000ULL,
    0xc400000000000ULL,
    0xb200000000000ULL,
    0xcd00000000000ULL,
    0xcc80000000000ULL,
    0x7140000000000ULL,
    0x7a0000000000ULL,
    0x7830000000000ULL,
    0x2748000000000ULL,
    0x94e4000000000ULL,
    0x9a92000000000ULL,
    0xe7f9000000000ULL,
    0xa8e8800000000ULL,
    0x48d4400000000ULL,
    0xbfdd200000000ULL,
    0x661c100000000ULL,
    0x72fea80000000ULL,
    0xa86d040000000ULL,
    0x6f93ba0000000ULL,
    0x577e050000000ULL,
    0x57ae2d8000000ULL,
    0x2c77a44000000ULL,
    0xf86b882000000ULL,
    0x4795141000000ULL,
    0x237f120800000ULL,
    0x3daa012400000ULL,
    0x6d75179200000ULL,
    0x42ede17100000ULL,
    0x49d0858c80000ULL,
    0x255aa06340000ULL,
    0xf858321b20000ULL,
    0x3cdb112850000ULL,
    0xa9993f9be8000ULL,
    0x8c39a54b0c000ULL,
    0x710c9f9752000ULL,
    0x5ec1f57779000ULL,
    0x967179104800ULL,
    0x5954e162ee400ULL,
    0xa1805a2f2200ULL,
    0xf4fee05569100ULL,
    0x2f6d12314d480ULL,
    0x72130114f2040ULL,
    0xd4bd97b6692a0ULL,
    0x9a49a14ccc010ULL,
    0xe065a5bb324e8ULL,
    0xd7d2b06e08d14ULL,
    0x4e5c9a2fbce36ULL,
    0x23db15208afd1ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x3000000000000ULL,
    0x4800000000000ULL,
    0xac00000000000ULL,
    0xb200000000000ULL,
    0x8f00000000000ULL,
    0xd780000000000ULL,
    0x14c0000000000ULL,
    0x9b60000000000ULL,
    0x7030000000000ULL,
    0x7078000000000ULL,
    0x35a4000000000ULL,
    0xe856000000000ULL,
    0xb5cf000000000ULL,
    0xa61d800000000ULL,
    0x7510400000000ULL,
    0x276c600000000ULL,
    0xc5cf100000000ULL,
    0xce1db80000000ULL,
    0x9149c0000000ULL,
    0xed68d60000000ULL,
    0xaecdf30000000ULL,
    0x79de58000000ULL,
    0x20d229c000000ULL,
    0x2e89d82000000ULL,
    0x1dbf8c3000000ULL,
    0xf8436e3800000ULL,
    0xfe266f0c00000ULL,
    0xc690b39200000ULL,
    0xedab9aeb00000ULL,
    0x83ae5d8c80000ULL,
    0xd6adb5d3c0000ULL,
    0xf22a8e2de0000ULL,
    0xfb6d3f3930000ULL,
    0x1fcf6b8cd8000ULL,
    0x3d1b16fb0c000ULL,
    0x1490b3829e000ULL,
    0x92ab9af5a9000ULL,
    0xfc2e5dbb75800ULL,
    0x5e6db5f783c00ULL,
    0x934a8e30bf600ULL,
    0xa85d3f1378100ULL,
    0xa376bb59d180ULL,
    0x937f16e4d6c40ULL,
    0xb026b3beecee0ULL,
    0x43949adfafe70ULL,
    0xb12bdd8f70d58ULL,
    0x6ee9f5dd78accULL,
    0x2c08ee249d016ULL,
    0xedf92f27565e7ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0xd000000000000ULL,
    0x1800000000000ULL,
    0x6400000000000ULL,
    0x7600000000000ULL,
    0xdb00000000000ULL,
    0x1580000000000ULL,
    0x37c0000000000ULL,
    0x63a0000000000ULL,
    0xa5b0000000000ULL,
    0xbbf8000000000ULL,
    0x6a64000000000ULL,
    0xa116000000000ULL,
    0xb9cd000000000ULL,
    0x9b5a800000000ULL,
    0x7e52c00000000ULL,
    0xfb28200000000ULL,
    0xbb0c300000000ULL,
    0x927a980000000ULL,
    0x2fa44c0000000ULL,
    0x1fb4ae0000000ULL,
    0x1afd350000000ULL,
    0x7ee2398000000ULL,
    0x52529dc000000ULL,
    0x312ab82000000ULL,
    0xd20c7c3000000ULL,
    0xfaf8362800000ULL,
    0xcee4793400000ULL,
    0x3a54178600000ULL,
    0x9d2968d900000ULL,
    0xd80ea1bd80000ULL,
    0x33fbd1c6c0000ULL,
    0x7664960d60000ULL,
    0xc3138909f0000ULL,
    0xdcca2fb6e8000ULL,
    0x29ded4c46c000ULL,
    0x4e1237957e000ULL,
    0x24c58c559000ULL,
    0xb398b9b8a5800ULL,
    0xae705dd143400ULL,
    0xaa5a98355ea00ULL,
    0x12d44c2608b00ULL,
    0x1c6cae3b5c080ULL,
    0x8de93506f60c0ULL,
    0x7c2c39bcc5260ULL,
    0xac8b9ddd33530ULL,
    0xb0be3829760b8ULL,
    0x3687bc1504bd4ULL,
    0xf644961cd2266ULL,
    0x4a63892fc61b7ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0xf000000000000ULL,
    0x3800000000000ULL,
    0xdc00000000000ULL,
    0x8200000000000ULL,
    0xcf00000000000ULL,
    0x6a80000000000ULL,
    0x4dc0000000000ULL,
    0xa0e0000000000ULL,
    0x4f50000000000ULL,
    0xca18000000000ULL,
    0xc324000000000ULL,
    0xdab2000000000ULL,
    0x5ccd000000000ULL,
    0x5c7b800000000ULL,
    0x3b7c00000000ULL,
    0xdf49e00000000ULL,
    0x4a3a900000000ULL,
    0x3916380000000ULL,
    0xe0bb740000000ULL,
    0x94d61e0000000ULL,
    0x105b2f0000000ULL,
    0x1381768000000ULL,
    0x3e401ac000000ULL,
    0x8ea7d82000000ULL,
    0xa9f5e41000000ULL,
    0x77ea262800000ULL,
    0xd2c95b3c00000ULL,
    0x997ee88e00000ULL,
    0xe231f5f700000ULL,
    0x560cce8080000ULL,
    0xd21caee3c0000ULL,
    0xaf202612a0000ULL,
    0xc0b05b3f70000ULL,
    0xbfcf688e38000ULL,
    0x8cff35d8d4000ULL,
    0x5d74aebc06000ULL,
    0x9728fee409000ULL,
    0x87ae7e048c800ULL,
    0x396f7f1b83400ULL,
    0x210f2e8386e00ULL,
    0x249f3ecb49f00ULL,
    0xc0e79e23ec780ULL,
    0x5f55ef2553a40ULL,
    0xa21916984f0e0ULL,
    0xd7244ac3649d0ULL,
    0xbcb180181fe78ULL,
    0xcdcec0346c7bcULL,
    0x7bf8603612c5aULL,
    0xebf450312e52bULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0xb000000000000ULL,
    0xa800000000000ULL,
    0xe400000000000ULL,
    0x3e00000000000ULL,
    0xb700000000000ULL,
    0xaf80000000000ULL,
    0xd640000000000ULL,
    0x71e0000000000ULL,
    0x6930000000000ULL,
    0xdf98000000000ULL,
    0x75a4000000000ULL,
    0xe5d6000000000ULL,
    0x682f000000000ULL,
    0x98f9800000000ULL,
    0xea57400000000ULL,
    0x2e6e200000000ULL,
    0x111f700000000ULL,
    0x7f67780000000ULL,
    0x83f61c0000000ULL,
    0x9bae20000000ULL,
    0xbc33070000000ULL,
    0x251fed8000000ULL,
    0x9960e2c000000ULL,
    0x98f1582000000ULL,
    0xcc3d6c3000000ULL,
    0x4b739a3800000ULL,
    0xa87e1b2c00000ULL,
    0xb7928faa00000ULL,
    0x57cfa5f900000ULL,
    0xecf15af80000ULL,
    0xce4abeddc0000ULL,
    0x1b8a1a33e0000ULL,
    0xd6295b2990000ULL,
    0xeffcaf8e78000ULL,
    0xa5d0d5cf4c000ULL,
    0x48286db266000ULL,
    0xc8fca2f9a9000ULL,
    0xf250f80515800ULL,
    0x626a5c1e5bc00ULL,
    0xcb1b4203a6600ULL,
    0xf664370049d00ULL,
    0x9b77358585880ULL,
    0x707aced7a2dc0ULL,
    0x1b94e2152a5e0ULL,
    0x3dc8070fcf470ULL,
    0x2fc86d92bd588ULL,
    0x32cca2cc4ed1cULL,
    0x5c48f8057c136ULL,
    0xc68e5c16af34bULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0xb000000000000ULL,
    0xd800000000000ULL,
    0x400000000000ULL,
    0x2a00000000000ULL,
    0x2f00000000000ULL,
    0xc180000000000ULL,
    0x5fc0000000000ULL,
    0xc720000000000ULL,
    0x730000000000ULL,
    0x76e8000000000ULL,
    0x9ee4000000000ULL,
    0x7916000000000ULL,
    0xa15d000000000ULL,
    0x1b49800000000ULL,
    0x4d94c00000000ULL,
    0xa81b200000000ULL,
    0x562dd00000000ULL,
    0x9040380000000ULL,
    0xede3ec0000000ULL,
    0x56930e0000000ULL,
    0x5b9d510000000ULL,
    0x82edad8000000ULL,
    0xce4354000000ULL,
    0x4213182000000ULL,
    0x22da3c3000000ULL,
    0xb78d362800000ULL,
    0x6537bd2c00000ULL,
    0xf5e923b600000ULL,
    0x964a44100000ULL,
    0x97d215aa80000ULL,
    0x7afe197bc0000ULL,
    0xa93ab63860000ULL,
    0x481a7d0bf0000ULL,
    0x862d83afc8000ULL,
    0x5840b46ccc000ULL,
    0x81e08d813a000ULL,
    0xa094e55d79000ULL,
    0x5a9aa02ca5800ULL,
    0x466d102867400ULL,
    0xbda518197a600ULL,
    0x1b773c2859300ULL,
    0xbd0cb63af4c80ULL,
    0x1777d393e740ULL,
    0x8a0c039d0f8e0ULL,
    0x64f07468a6bb0ULL,
    0x4fcdadac9b238ULL,
    0x54d4354be9244ULL,
    0x8d7b18281dc36ULL,
    0x57fe3c3fa2495ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x1000000000000ULL,
    0x6800000000000ULL,
    0x5c00000000000ULL,
    0xae00000000000ULL,
    0xad00000000000ULL,
    0x5a80000000000ULL,
    0x9ac0000000000ULL,
    0xcea0000000000ULL,
    0xf5b0000000000ULL,
    0xbdc8000000000ULL,
    0x9964000000000ULL,
    0x9196000000000ULL,
    0x8ab9000000000ULL,
    0xce0c800000000ULL,
    0x6741400000000ULL,
    0xf9e5e00000000ULL,
    0x8454f00000000ULL,
    0x559ea80000000ULL,
    0x1aff740000000ULL,
    0x1269460000000ULL,
    0x30556d0000000ULL,
    0x679f918000000ULL,
    0x39fd2c4000000ULL,
    0xf5ed482000000ULL,
    0x9812843000000ULL,
    0x6ffb6e0800000ULL,
    0xaceb590400000ULL,
    0x1093379a00000ULL,
    0xe63cb15700000ULL,
    0xfdcc718b80000ULL,
    0x7960dc5b40000ULL,
    0xa197603ea0000ULL,
    0xf2b8b012b0000ULL,
    0xfa09c821a8000ULL,
    0x9547c42e6c000ULL,
    0xfae08e1ef2000ULL,
    0x73d2a91a19000ULL,
    0x95df1f9945800ULL,
    0x4e9f856f5e400ULL,
    0x297a57b68b200ULL,
    0x782901720c500ULL,
    0x4337398aa3780ULL,
    0x310b584e203c0ULL,
    0xeec08e2c702a0ULL,
    0xdca2a921489d0ULL,
    0xc6b71faafcf18ULL,
    0x324b854f2b4b4ULL,
    0x6d2457933dbc6ULL,
    0x37f4015c4a271ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x5000000000000ULL,
    0x8800000000000ULL,
    0xac00000000000ULL,
    0x4a00000000000ULL,
    0x3d00000000000ULL,
    0x9980000000000ULL,
    0x9b40000000000ULL,
    0xdf20000000000ULL,
    0x370000000000ULL,
    0x398000000000ULL,
    0x3164000000000ULL,
    0x49d2000000000ULL,
    0x61af000000000ULL,
    0x8de800000000ULL,
    0xc642400000000ULL,
    0x56a0600000000ULL,
    0xf037d00000000ULL,
    0x20bf280000000ULL,
    0xf011ec0000000ULL,
    0xdb49ea0000000ULL,
    0x834e410000000ULL,
    0xe749bf8000000ULL,
    0xe14d4ac000000ULL,
    0xc64d482000000ULL,
    0xeac93c1000000ULL,
    0x4408423800000ULL,
    0x4a6ded1400000ULL,
    0xab3835a200000ULL,
    0x3250dbeb00000ULL,
    0x9be9dfb280000ULL,
    0x3c7a9adf40000ULL,
    0x1772603e60000ULL,
    0x7d98d022d0000ULL,
    0x8261a82dc8000ULL,
    0x5b53ac3fdc000ULL,
    0x9c698a3066000ULL,
    0x4439912819000ULL,
    0x52d697a694800ULL,
    0x2f2ca6f1fbc00ULL,
    0x871ca2339fa00ULL,
    0xc3a37d079c900ULL,
    0x35b3fd9a86180ULL,
    0xc9ffa7e488f40ULL,
    0x6633fd98bd4a0ULL,
    0x2fbfa7d336bb0ULL,
    0xc093fdac115a8ULL,
    0xe78fa7c268c04ULL,
    0x942bfdb22dd7eULL,
    0x799ba7fc1e36bULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0xf000000000000ULL,
    0xc800000000000ULL,
    0xf400000000000ULL,
    0xf600000000000ULL,
    0xf00000000000ULL,
    0x7680000000000ULL,
    0xa7c0000000000ULL,
    0xb820000000000ULL,
    0x1d30000000000ULL,
    0x3b98000000000ULL,
    0xa8e4000000000ULL,
    0x2f96000000000ULL,
    0x636f000000000ULL,
    0x225b800000000ULL,
    0x2bc4400000000ULL,
    0x5226a00000000ULL,
    0x37300000000ULL,
    0x8c19b80000000ULL,
    0x4aa6540000000ULL,
    0x44f32e0000000ULL,
    0x98bd090000000ULL,
    0xc550a58000000ULL,
    0x74cf16c000000ULL,
    0xf129182000000ULL,
    0x413e643000000ULL,
    0xc411163800000ULL,
    0xb32f1d3c00000ULL,
    0x983d2bb200000ULL,
    0xad912ffd00000ULL,
    0x5a6e059d80000ULL,
    0xbbdc26f3c0000ULL,
    0xa86a005a0000ULL,
    0x85c73025f0000ULL,
    0x5121b82408000ULL,
    0x5cb254064c000ULL,
    0xd6dd2e0166000ULL,
    0xb5060914f9000ULL,
    0x738525abc5800ULL,
    0x3c4056f2ebc00ULL,
    0x6062381b3ee00ULL,
    0xb35214144d100ULL,
    0xbbcd8e0c67a80ULL,
    0x67ae391178cc0ULL,
    0x16ff1d9405ee0ULL,
    0xb43642dd4b550ULL,
    0x5a19b60fcfab8ULL,
    0x55a32d07c5924ULL,
    0xa711388eb616ULL,
    0x3783bc23f19bULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x5000000000000ULL,
    0xe800000000000ULL,
    0xe400000000000ULL,
    0x9600000000000ULL,
    0xed00000000000ULL,
    0x2a80000000000ULL,
    0xaec0000000000ULL,
    0x13e0000000000ULL,
    0xdf90000000000ULL,
    0x9518000000000ULL,
    0xdc24000000000ULL,
    0xd4f2000000000ULL,
    0x7f4f000000000ULL,
    0xcd5e800000000ULL,
    0xbb01400000000ULL,
    0x6782200000000ULL,
    0x3441300000000ULL,
    0x522a80000000ULL,
    0xc071340000000ULL,
    0x388ee60000000ULL,
    0x323f470000000ULL,
    0xcf56c08000000ULL,
    0x2ffd8ac000000ULL,
    0xf32882000000ULL,
    0xba2f041000000ULL,
    0x960ace3800000ULL,
    0x1afb331400000ULL,
    0x39b006ba00000ULL,
    0x6ee8fdf900000ULL,
    0x4aea608580000ULL,
    0x7cedfaeb40000ULL,
    0x21ea0012a0000ULL,
    0xb36b002fb0000ULL,
    0x11ac8006f8000ULL,
    0x704e401ae4000ULL,
    0xd4dca03ac6000ULL,
    0x8640703549000ULL,
    0xde20881a1c800ULL,
    0xb7f0040f23c00ULL,
    0x4cc4e3d0fa00ULL,
    0x831e733294500ULL,
    0x712026b85e880ULL,
    0x1e76cdcdfd4c0ULL,
    0x818e48b1322a0ULL,
    0x36b98ec8c68d0ULL,
    0x8094c61048998ULL,
    0x649a77399c41cULL,
    0x566689b62982ULL,
    0xfb53bec52f7ebULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0xb000000000000ULL,
    0xc800000000000ULL,
    0x4c00000000000ULL,
    0x6600000000000ULL,
    0x100000000000ULL,
    0x4980000000000ULL,
    0x7c0000000000ULL,
    0x6fe0000000000ULL,
    0xa390000000000ULL,
    0x1388000000000ULL,
    0xd24000000000ULL,
    0x7ff2000000000ULL,
    0x88d9000000000ULL,
    0xdc9800000000ULL,
    0x7d00400000000ULL,
    0xa781600000000ULL,
    0x6ac7b00000000ULL,
    0xf063c80000000ULL,
    0x6d566c0000000ULL,
    0x79e96e0000000ULL,
    0xcf74470000000ULL,
    0x29d588000000ULL,
    0x6fefee4000000ULL,
    0x6670a82000000ULL,
    0x9718dc1000000ULL,
    0x762b260800000ULL,
    0x8c966b2c00000ULL,
    0x570f56b200000ULL,
    0x561195300000ULL,
    0xa6d5b8b980000ULL,
    0xc5281e5040000ULL,
    0xf612003a60000ULL,
    0x6a49003df0000ULL,
    0x77c18021f8000ULL,
    0xc7e44017e4000ULL,
    0x7f93602f62000ULL,
    0xd8eb01009000ULL,
    0x882248141c800ULL,
    0x1c722c2386400ULL,
    0xe81a0e0aea600ULL,
    0x2aaaf73654100ULL,
    0x90d710b6fa580ULL,
    0xdc29c2711cec0ULL,
    0xab90a60706720ULL,
    0x3f8f2b2a2adb0ULL,
    0xfb27b68af4bb8ULL,
    0x6f6e962ab41cULL,
    0x455f10b8356e2ULL,
    0x200dc25d0a079ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x5000000000000ULL,
    0xe800000000000ULL,
    0x3c00000000000ULL,
    0xe600000000000ULL,
    0xaf00000000000ULL,
    0xc580000000000ULL,
    0x61c0000000000ULL,
    0x8ea0000000000ULL,
    0x7230000000000ULL,
    0x24e8000000000ULL,
    0xa464000000000ULL,
    0x9b16000000000ULL,
    0x4a1f000000000ULL,
    0xeeae800000000ULL,
    0x4805400000000ULL,
    0x4c00e00000000ULL,
    0xbe02b00000000ULL,
    0x2b00b80000000ULL,
    0xf7808c0000000ULL,
    0x14c5de0000000ULL,
    0x2263d0000000ULL,
    0x7970c58000000ULL,
    0xe0c054000000ULL,
    0x3936582000000ULL,
    0x436d3c3000000ULL,
    0xb8a3e63800000ULL,
    0xf537f11400000ULL,
    0x3d6bfbba00000ULL,
    0x73a3884f00000ULL,
    0x52b6a59980000ULL,
    0xc1aff55bc0000ULL,
    0x4d80002960000ULL,
    0xcdc0003c70000ULL,
    0x60a00021a8000ULL,
    0xb13000078c000ULL,
    0xef68000aba000ULL,
    0x56a4000dd9000ULL,
    0x3636002e25800ULL,
    0xf6ef002137c00ULL,
    0x8166802963a00ULL,
    0xff914016fd500ULL,
    0x7d5ee03992380ULL,
    0x2249b01a15ac0ULL,
    0x7a5038253fae0ULL,
    0x51fecc067ee30ULL,
    0x2d7dbe185f578ULL,
    0xbe3ecd000f1f4ULL,
    0xf0de1db6f7a96ULL,
    0xf8b797e02fd5ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x7000000000000ULL,
    0x8800000000000ULL,
    0x1c00000000000ULL,
    0x1600000000000ULL,
    0xc100000000000ULL,
    0x2c80000000000ULL,
    0x3cc0000000000ULL,
    0x4620000000000ULL,
    0xecb0000000000ULL,
    0x8e38000000000ULL,
    0xede4000000000ULL,
    0x2716000000000ULL,
    0xa2cd000000000ULL,
    0xe13f800000000ULL,
    0xf466400000000ULL,
    0xed53e00000000ULL,
    0xf72e300000000ULL,
    0x322dc80000000ULL,
    0x8cafc40000000ULL,
    0x236eb60000000ULL,
    0x7ac8090000000ULL,
    0xc538c98000000ULL,
    0xd664d3c000000ULL,
    0x5650282000000ULL,
    0x84a8f43000000ULL,
    0xff6afe2800000ULL,
    0xcccc8d1c00000ULL,
    0x743a1fa200000ULL,
    0x72e4aac700000ULL,
    0x7696c9a580000ULL,
    0xd48dd3c040000ULL,
    0xd2d9a80320000ULL,
    0x6e73b42330000ULL,
    0xa51e9e1b88000ULL,
    0x13d0fd202c000ULL,
    0x38ea37840e000ULL,
    0xbb8c5ecc39000ULL,
    0xcb5c37a765800ULL,
    0xa4315ee7c3400ULL,
    0xf0fbb7aae7e00ULL,
    0xc0c31ee505900ULL,
    0x402657a352f80ULL,
    0x75b42ed69e8c0ULL,
    0x46ba1f8940f20ULL,
    0x5324aaeba1b10ULL,
    0xaa36c99df1cd8ULL,
    0xb5fdd3df68d24ULL,
    0xbe41a8077d2a6ULL,
    0x4fe7b41a1728fULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0xb000000000000ULL,
    0x3800000000000ULL,
    0xe400000000000ULL,
    0xe00000000000ULL,
    0x7d00000000000ULL,
    0xc980000000000ULL,
    0xecc0000000000ULL,
    0x9da0000000000ULL,
    0x1990000000000ULL,
    0xfc98000000000ULL,
    0x1664000000000ULL,
    0xe6b6000000000ULL,
    0xc949000000000ULL,
    0xd419800000000ULL,
    0x3923c00000000ULL,
    0x74d0200000000ULL,
    0x71fcf00000000ULL,
    0xc853a80000000ULL,
    0x48beac0000000ULL,
    0x7335360000000ULL,
    0xf8cf50000000ULL,
    0x1ab9a88000000ULL,
    0x24366ec000000ULL,
    0x950d882000000ULL,
    0xf2ff5c3000000ULL,
    0xa4d11e0800000ULL,
    0x19fc992c00000ULL,
    0x84533e8e00000ULL,
    0x2abcabf900000ULL,
    0xdc3628a380000ULL,
    0x510caeef40000ULL,
    0x4cfc281a60000ULL,
    0xe1d46c2730000ULL,
    0x347c962168000ULL,
    0x6693c51364000ULL,
    0xca1a20b2a6000ULL,
    0xc2432e3d9000ULL,
    0x415316284d800ULL,
    0xc739052622400ULL,
    0x1ef380a80e600ULL,
    0x1ab02df1cf00ULL,
    0xa4e89e2b7a080ULL,
    0x158f5916823c0ULL,
    0xb1bb1ebf1f6a0ULL,
    0xe4b45bd6a4eb0ULL,
    0x364b808c06ad8ULL,
    0x229f02cdc98d4ULL,
    0x3669e2274022ULL,
    0x6332591e1e57bULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0xd000000000000ULL,
    0xa800000000000ULL,
    0xfc00000000000ULL,
    0xe600000000000ULL,
    0xe900000000000ULL,
    0x7380000000000ULL,
    0xe640000000000ULL,
    0xda60000000000ULL,
    0xe330000000000ULL,
    0x4eb8000000000ULL,
    0x4724000000000ULL,
    0x29d2000000000ULL,
    0x3f4d000000000ULL,
    0x833a800000000ULL,
    0x8c63400000000ULL,
    0x9230e00000000ULL,
    0x193cb00000000ULL,
    0xc360880000000ULL,
    0xa8b33c0000000ULL,
    0x5cfae20000000ULL,
    0x57442b0000000ULL,
    0x6de48d8000000ULL,
    0x17743bc000000ULL,
    0xb7da682000000ULL,
    0x70968c1000000ULL,
    0xe7aaea2800000ULL,
    0xd1cd573400000ULL,
    0x9cfe0faa00000ULL,
    0xb746e0ff00000ULL,
    0x1de60d9980000ULL,
    0x6f737bea40000ULL,
    0xe3d88814e0000ULL,
    0x6a973c1d90000ULL,
    0xe8a8e23498000ULL,
    0x4b492b33cc000ULL,
    0x93e0d802e000ULL,
    0x8b677bd489000ULL,
    0x24b2880f14800ULL,
    0xc2fe3c1c03400ULL,
    0xea406222b6a00ULL,
    0x4676b1644d00ULL,
    0xfe346dabba380ULL,
    0xf7388bd04a2c0ULL,
    0x662e03082a20ULL,
    0x9531b01e768f0ULL,
    0xafba080964988ULL,
    0x18a07c348a9acULL,
    0x81920203a3bb6ULL,
    0xf02c9b2746f2fULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0xb000000000000ULL,
    0x1800000000000ULL,
    0x6c00000000000ULL,
    0x1e00000000000ULL,
    0x5b00000000000ULL,
    0xfc80000000000ULL,
    0x93c0000000000ULL,
    0xb560000000000ULL,
    0xf290000000000ULL,
    0x5da8000000000ULL,
    0x224000000000ULL,
    0x5832000000000ULL,
    0x145d000000000ULL,
    0x5e19800000000ULL,
    0x8f3ec00000000ULL,
    0xaf88600000000ULL,
    0xe216700000000ULL,
    0x9068980000000ULL,
    0x4c40c40000000ULL,
    0xe6204e0000000ULL,
    0xc231230000000ULL,
    0x855cb88000000ULL,
    0x3b9f7f4000000ULL,
    0xbd79782000000ULL,
    0x42a8741000000ULL,
    0xd4a0b62800000ULL,
    0x42f7972c00000ULL,
    0xa8bc6e8600000ULL,
    0x80ca985b00000ULL,
    0x64b78ea780000ULL,
    0x679b2846c0000ULL,
    0xfb7cf6b720000ULL,
    0xd5ae5c58f0000ULL,
    0x8625c0a358000ULL,
    0x92370b5ba4000ULL,
    0x8d59ce1eea000ULL,
    0xff9fe33149000ULL,
    0xd77cd880ac800ULL,
    0x6bad0f4027400ULL,
    0x6d23e0247e600ULL,
    0x76b5b0265bb00ULL,
    0x7299780170180ULL,
    0x54f8741a989c0ULL,
    0x7ee8b63104a60ULL,
    0xca839715da710ULL,
    0xfcc66e85b0f38ULL,
    0x9be3987cb9b8cULL,
    0x94540e8375d62ULL,
    0x574ce864c3b3dULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0xb000000000000ULL,
    0xa800000000000ULL,
    0x2400000000000ULL,
    0xda00000000000ULL,
    0x9900000000000ULL,
    0x9e80000000000ULL,
    0x8540000000000ULL,
    0x4a20000000000ULL,
    0xf7f0000000000ULL,
    0x5768000000000ULL,
    0x45e4000000000ULL,
    0xa92000000000ULL,
    0x37bb000000000ULL,
    0x11f9800000000ULL,
    0xac5b400000000ULL,
    0x886c200000000ULL,
    0x8466500000000ULL,
    0xe55080000000ULL,
    0x195e140000000ULL,
    0x78ef1a0000000ULL,
    0x3a22290000000ULL,
    0x7ff1738000000ULL,
    0xa36efd4000000ULL,
    0x87e0a82000000ULL,
    0x1f93041000000ULL,
    0x573e321800000ULL,
    0xd7be6d2c00000ULL,
    0xe1f961aa00000ULL,
    0x6459c04900000ULL,
    0x1c6f419680000ULL,
    0xf660907640000ULL,
    0xb351c99fa0000ULL,
    0x5ddec45d50000ULL,
    0x64ab738088000ULL,
    0xee81fd48fc000ULL,
    0xd4328315a000ULL,
    0xbe27440239000ULL,
    0x35f1922184800ULL,
    0x426c7d2ffec00ULL,
    0x2563c9add6600ULL,
    0xccd5c458fad00ULL,
    0x7a1af39469080ULL,
    0xfdcebd5a8c940ULL,
    0x34550819c3c20ULL,
    0x705e143a6c450ULL,
    0x2e6f1a2db3268ULL,
    0x2b622921f59a4ULL,
    0x47d173b267b4eULL,
    0xe99efd51033b5ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0xd000000000000ULL,
    0x4800000000000ULL,
    0xe400000000000ULL,
    0xf200000000000ULL,
    0xf500000000000ULL,
    0x6d80000000000ULL,
    0xd8c0000000000ULL,
    0x78e0000000000ULL,
    0x3170000000000ULL,
    0xddb8000000000ULL,
    0xf1a4000000000ULL,
    0x6f56000000000ULL,
    0xc72b000000000ULL,
    0xefea800000000ULL,
    0xaf08400000000ULL,
    0x827e200000000ULL,
    0xd1c0100000000ULL,
    0x8b66680000000ULL,
    0x6ab38c0000000ULL,
    0x1fdab60000000ULL,
    0xc8929f0000000ULL,
    0x9b4bff8000000ULL,
    0x55dc7fc000000ULL,
    0xe192c82000000ULL,
    0x18cbdc3000000ULL,
    0xf61afe1800000ULL,
    0x5ff5033400000ULL,
    0x7ff9219200000ULL,
    0xe1026cf900000ULL,
    0xa787019c80000ULL,
    0x31c27ccd40000ULL,
    0x9b6169a360000ULL,
    0x42b1f0f230000ULL,
    0x2bdbdfb438000ULL,
    0x72936ff15c000ULL,
    0x8a482021ee000ULL,
    0xca5b103c29000ULL,
    0xcc54e83635800ULL,
    0xdafcc37bac00ULL,
    0x1faa961022a00ULL,
    0xfaad8f15ee100ULL,
    0xbf2917ae29880ULL,
    0x53e8b3cf35040ULL,
    0x910ade2b3a1a0ULL,
    0xb17a131d63230ULL,
    0xf343c9968f8d8ULL,
    0x2f22a0ec1977cULL,
    0x551117a30c57eULL,
    0x7b8cb3ce66cbfULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0x9000000000000ULL,
    0xe800000000000ULL,
    0x5400000000000ULL,
    0xc600000000000ULL,
    0x2300000000000ULL,
    0xbb80000000000ULL,
    0xefc0000000000ULL,
    0x2920000000000ULL,
    0xff70000000000ULL,
    0xe018000000000ULL,
    0xcb64000000000ULL,
    0x292000000000ULL,
    0x81c9000000000ULL,
    0xd1c8800000000ULL,
    0x59c9400000000ULL,
    0xbdcda00000000ULL,
    0x3cdb00000000ULL,
    0x9ccdd80000000ULL,
    0xb54bbc0000000ULL,
    0xbf8f2e0000000ULL,
    0xe28010000000ULL,
    0xa51b6f8000000ULL,
    0x83e4eac000000ULL,
    0x9ed0f82000000ULL,
    0x832b4c1000000ULL,
    0x299d560800000ULL,
    0x31a70d2400000ULL,
    0xeb3119ba00000ULL,
    0x6fe17d500000ULL,
    0x8d31199180000ULL,
    0xf5fe17d8c0000ULL,
    0xfeb11986e0000ULL,
    0xde3e17cff0000ULL,
    0xf991199848000ULL,
    0x564e17dedc000ULL,
    0x6409199b86000ULL,
    0x51ea17db19000ULL,
    0xf43b198dc4800ULL,
    0xc09317f242400ULL,
    0xeccb99b35a200ULL,
    0xad4e57fb9e500ULL,
    0xb38c39905d680ULL,
    0xe42ee7dfc66c0ULL,
    0xfc1b6198b9f60ULL,
    0x89651bd215af0ULL,
    0x2f916fa41b6b8ULL,
    0xdd49eaeabf104ULL,
    0xab8a780dcd13eULL,
    0xe82b0c093f46bULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0x9000000000000ULL,
    0x5800000000000ULL,
    0x4400000000000ULL,
    0x2200000000000ULL,
    0x6100000000000ULL,
    0x2c80000000000ULL,
    0x21c0000000000ULL,
    0x4ee0000000000ULL,
    0xee10000000000ULL,
    0x65a8000000000ULL,
    0xd9a4000000000ULL,
    0x5432000000000ULL,
    0x23d9000000000ULL,
    0x9ed8800000000ULL,
    0xb45cc00000000ULL,
    0x669d200000000ULL,
    0xadfa900000000ULL,
    0x52aa480000000ULL,
    0x3e22040000000ULL,
    0x4777e0000000ULL,
    0x967d0f0000000ULL,
    0x4ec6c8000000ULL,
    0x7887bf4000000ULL,
    0x1bc7e82000000ULL,
    0x4be0541000000ULL,
    0x7092160800000ULL,
    0x7d6c9b2400000ULL,
    0xffc1da9600000ULL,
    0xb9e0745100000ULL,
    0x6993daa880000ULL,
    0x85e9744840000ULL,
    0xa4035aa320000ULL,
    0xd201b47c70000ULL,
    0x89047aadb8000ULL,
    0xa086245e84000ULL,
    0x1fc4b2afea000ULL,
    0x49e1e04b29000ULL,
    0x81966ca8ac800ULL,
    0x9eabf7dc6400ULL,
    0x9a056809ae200ULL,
    0xd5019423a3300ULL,
    0xe685b60ed5480ULL,
    0xccc3cb03a3a40ULL,
    0x5c66329ed4120ULL,
    0xc8d0204ba3c10ULL,
    0x44c9cc9ad57f8ULL,
    0x5bf1ef4da333cULL,
    0x72388003d4f32ULL,
    0x7b4cc021233bdULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0xf000000000000ULL,
    0xa800000000000ULL,
    0xcc00000000000ULL,
    0xb600000000000ULL,
    0xf900000000000ULL,
    0xe580000000000ULL,
    0xc840000000000ULL,
    0x5ea0000000000ULL,
    0x9310000000000ULL,
    0x3f88000000000ULL,
    0x3d64000000000ULL,
    0x28f2000000000ULL,
    0xe5b9000000000ULL,
    0x2abb800000000ULL,
    0x763b400000000ULL,
    0x7bf9600000000ULL,
    0x1d1d300000000ULL,
    0x78aa080000000ULL,
    0x18348c0000000ULL,
    0xacdc520000000ULL,
    0x40492d0000000ULL,
    0x68836c8000000ULL,
    0x6fc2ca4000000ULL,
    0x6de0e82000000ULL,
    0xf336fc1000000ULL,
    0xaa5d3a0800000ULL,
    0xf289913c00000ULL,
    0xbae6b6aa00000ULL,
    0xebb02b7300000ULL,
    0x2d9cb68d80000ULL,
    0x736d2b6e40000ULL,
    0xfd5369160000ULL,
    0x10ef6b5e10000ULL,
    0xf697d695a8000ULL,
    0xb7c91b7bc4000ULL,
    0x43c4bea062000ULL,
    0x4be0a76e19000ULL,
    0x7232e49cdc800ULL,
    0xdbdd066a3e400ULL,
    0xe8cdda0be6e00ULL,
    0x6746e12a1ad00ULL,
    0xd2265eb054580ULL,
    0xc6d6d76f8a4c0ULL,
    0x3d698c92bc020ULL,
    0x22d0ba7bae630ULL,
    0x769800f0f748ULL,
    0x4dd2403f3fdb4ULL,
    0xebeae00766e32ULL,
    0xc812702eda6e9ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x9000000000000ULL,
    0xb800000000000ULL,
    0x7400000000000ULL,
    0x9a00000000000ULL,
    0x3500000000000ULL,
    0xc780000000000ULL,
    0xbfc0000000000ULL,
    0xe320000000000ULL,
    0x87b0000000000ULL,
    0x32e8000000000ULL,
    0xa564000000000ULL,
    0xac56000000000ULL,
    0xe0fd000000000ULL,
    0xda78800000000ULL,
    0x9e3fc00000000ULL,
    0xa4dca00000000ULL,
    0x334f500000000ULL,
    0x2297e80000000ULL,
    0x165fdc0000000ULL,
    0x2b0ace0000000ULL,
    0x4e72810000000ULL,
    0x5aca198000000ULL,
    0x52510d4000000ULL,
    0x37fbc82000000ULL,
    0xfcfb4c3000000ULL,
    0xec7f862800000ULL,
    0x753b0d2400000ULL,
    0xe459bfae00000ULL,
    0xb20e905d00000ULL,
    0x57f73f8680000ULL,
    0x620c507d40000ULL,
    0x8ff31fb9e0000ULL,
    0x260cc07bf0000ULL,
    0x3df0579ec8000ULL,
    0xdf084c68ec000ULL,
    0x1473718c3a000ULL,
    0xcfcc116d19000ULL,
    0x5d5261a75800ULL,
    0x30395d138f400ULL,
    0x6bded79f36200ULL,
    0xf1ca8c5dd3f00ULL,
    0x72d7518425280ULL,
    0x86bc814bd6d40ULL,
    0xa19e6e08a27a0ULL,
    0x5429d103adb70ULL,
    0x3fc3f194db138ULL,
    0x2327d15269104ULL,
    0x27b7863efc0e6ULL,
    0xa2ef0d2f02275ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x5000000000000ULL,
    0xe800000000000ULL,
    0x1400000000000ULL,
    0x5600000000000ULL,
    0x7900000000000ULL,
    0x880000000000ULL,
    0xd6c0000000000ULL,
    0xb8e0000000000ULL,
    0xec90000000000ULL,
    0xcf88000000000ULL,
    0xca4000000000ULL,
    0x99b2000000000ULL,
    0x8c7b000000000ULL,
    0x30fe800000000ULL,
    0xc039400000000ULL,
    0xd9dda00000000ULL,
    0x91cd300000000ULL,
    0x2283080000000ULL,
    0xadc4240000000ULL,
    0xff62660000000ULL,
    0x1bd1df0000000ULL,
    0x4129b88000000ULL,
    0x9a15564000000ULL,
    0x5448282000000ULL,
    0xdac4541000000ULL,
    0x62e6ce1800000ULL,
    0xf97cb1400000ULL,
    0x440c56ba00000ULL,
    0x1e6ed4500000ULL,
    0xc412d6b580000ULL,
    0x294fad4e40000ULL,
    0xc4776ba20000ULL,
    0x89269d71b0000ULL,
    0x1f67eac38000ULL,
    0x1359b97a24000ULL,
    0x280a98a462000ULL,
    0x8be1265c69000ULL,
    0xcf168033cc800ULL,
    0xb6cd4009eec00ULL,
    0x5707a017a7a00ULL,
    0xad823031da500ULL,
    0xac4788060d680ULL,
    0xf92264328e4c0ULL,
    0xd9f34624b6420ULL,
    0xbf5eaf1b92c90ULL,
    0x8209908a71b98ULL,
    0xb0e5025859e7cULL,
    0xe894e631b4262ULL,
    0x118c9f39eb899ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x7000000000000ULL,
    0x3800000000000ULL,
    0xf400000000000ULL,
    0x5a00000000000ULL,
    0x6d00000000000ULL,
    0xb980000000000ULL,
    0xd040000000000ULL,
    0xb60000000000ULL,
    0x990000000000ULL,
    0x8e48000000000ULL,
    0x4a4000000000ULL,
    0x69b2000000000ULL,
    0x963b000000000ULL,
    0xadbf800000000ULL,
    0xd4ffc00000000ULL,
    0x641aa00000000ULL,
    0x54cc500000000ULL,
    0xa64280000000ULL,
    0x4e112c0000000ULL,
    0x410ab20000000ULL,
    0x6740030000000ULL,
    0x9fe0588000000ULL,
    0x52244000000ULL,
    0x2569082000000ULL,
    0x3e56bc1000000ULL,
    0x1a6e3a1800000ULL,
    0x46d27f1c00000ULL,
    0xadab428e00000ULL,
    0x92f3cb7d00000ULL,
    0x8fdcc2b680000ULL,
    0x26e80b4b40000ULL,
    0xb314629660000ULL,
    0xf08f5b7810000ULL,
    0x1b07cab4d8000ULL,
    0x4a85b77364000ULL,
    0x6c5d88312000ULL,
    0x8ba2e46b69000ULL,
    0x93628148c800ULL,
    0xc5fa2c3bdec00ULL,
    0x6b9d320757e00ULL,
    0x578bc3390bf00ULL,
    0xc780f88eaca80ULL,
    0x8f4174442e140ULL,
    0x3e0a0215f8a0ULL,
    0x8653500a178b0ULL,
    0xae69a8366bcc8ULL,
    0x7cd5ec223c30cULL,
    0xb0af9220b7de2ULL,
    0x1373933bdbad1ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0xb000000000000ULL,
    0x3800000000000ULL,
    0xdc00000000000ULL,
    0xa200000000000ULL,
    0x7b00000000000ULL,
    0xc280000000000ULL,
    0x22c0000000000ULL,
    0xf1a0000000000ULL,
    0x37b0000000000ULL,
    0x37e8000000000ULL,
    0xaae4000000000ULL,
    0x652000000000ULL,
    0x33b000000000ULL,
    0xd319800000000ULL,
    0x48efc00000000ULL,
    0xe663e00000000ULL,
    0xa591900000000ULL,
    0x271c980000000ULL,
    0x9ee8b40000000ULL,
    0xb65260000000ULL,
    0xea16a50000000ULL,
    0xfa5fe18000000ULL,
    0x8a0d254000000ULL,
    0xf434f82000000ULL,
    0x80ade41000000ULL,
    0x4103de1800000ULL,
    0xf580412c00000ULL,
    0xaa45bf8e00000ULL,
    0xfc62a47700000ULL,
    0x4292a78880000ULL,
    0x279ed04ec0000ULL,
    0x772de188a0000ULL,
    0x462574b0000ULL,
    0x2365780a68000ULL,
    0x9e162406ec000ULL,
    0x6c5a3e337a000ULL,
    0x70ed12f79000ULL,
    0xbb2a797b4800ULL,
    0x65eed061bec00ULL,
    0x89e5e1b08e600ULL,
    0xa8d22559a7f00ULL,
    0xbbff7800aaf80ULL,
    0x85b9243a81640ULL,
    0x1fd9be2fc1a60ULL,
    0x884e111b21ed0ULL,
    0x3c52c79cf1a98ULL,
    0x343f806b09994ULL,
    0x5b99198a7de06ULL,
    0x452bc15f621d5ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0xf000000000000ULL,
    0xc800000000000ULL,
    0x4400000000000ULL,
    0xba00000000000ULL,
    0xa500000000000ULL,
    0xfb80000000000ULL,
    0xb340000000000ULL,
    0xc220000000000ULL,
    0x5c30000000000ULL,
    0x32d8000000000ULL,
    0x67e4000000000ULL,
    0x52d6000000000ULL,
    0x458f000000000ULL,
    0x9e2b800000000ULL,
    0x685c400000000ULL,
    0xb527200000000ULL,
    0x96b3500000000ULL,
    0x181be80000000ULL,
    0xcf803c0000000ULL,
    0x1422a0000000ULL,
    0xc323c90000000ULL,
    0xedb2458000000ULL,
    0xec98b8c000000ULL,
    0x1a41482000000ULL,
    0x7a02c3000000ULL,
    0x1075623800000ULL,
    0x5e7ce53c00000ULL,
    0xbb14a7b200000ULL,
    0x556c1dd100000ULL,
    0x67ccf8e80000ULL,
    0x71461d940000ULL,
    0x836fc5a6e0000ULL,
    0xad7bf8e0d0000ULL,
    0x2b95e81a88000ULL,
    0x2aab3c0a0c000ULL,
    0x9d9faa2836000ULL,
    0xa3c0891db9000ULL,
    0x7de6e5b6d5800ULL,
    0x27d3a8c5f3c00ULL,
    0x660b802762e00ULL,
    0x516c40388b100ULL,
    0x9c7f201797c80ULL,
    0xb217503b89d40ULL,
    0x40ede81c8d7a0ULL,
    0x923f3c3d76cf0ULL,
    0x17b1aa1159ea8ULL,
    0x699b890b05224ULL,
    0xf1c3659bfa396ULL,
    0x8ce4e8f92e2a3ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0xd000000000000ULL,
    0x6800000000000ULL,
    0xfc00000000000ULL,
    0x1a00000000000ULL,
    0xe100000000000ULL,
    0xb280000000000ULL,
    0x8ec0000000000ULL,
    0x420000000000ULL,
    0xfe90000000000ULL,
    0x7698000000000ULL,
    0xa564000000000ULL,
    0x9cf2000000000ULL,
    0xc3e9000000000ULL,
    0x4bca800000000ULL,
    0x575d400000000ULL,
    0x74c0e00000000ULL,
    0x5525500000000ULL,
    0xd413c80000000ULL,
    0xbc5fb40000000ULL,
    0x2f44060000000ULL,
    0x6562190000000ULL,
    0xfcf4b88000000ULL,
    0x33ebdec000000ULL,
    0xf3cba82000000ULL,
    0xc35ea41000000ULL,
    0x92c5ae0800000ULL,
    0xae21bd3400000ULL,
    0x8791969a00000ULL,
    0x801a23ff00000ULL,
    0xa5a25ea680000ULL,
    0x9fd597e840000ULL,
    0x74fe5884a0000ULL,
    0xe0138ec7b0000ULL,
    0xca58e03308000ULL,
    0x9c415024a4000ULL,
    0x1ae1c80926000ULL,
    0xb2b6b41a19000ULL,
    0xa40e86171c800ULL,
    0xa1ff59140a400ULL,
    0x249458b9daa00ULL,
    0xf79e8ef183500ULL,
    0xe7e0600d3e380ULL,
    0xaa35103004540ULL,
    0x53cba80696720ULL,
    0x535ea43d10ad0ULL,
    0xdac5ae39b9218ULL,
    0x8221bd2a2c964ULL,
    0xf591969143362ULL,
    0x9d1a23c4deb3bULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0xb000000000000ULL,
    0x800000000000ULL,
    0x7c00000000000ULL,
    0xd600000000000ULL,
    0x9100000000000ULL,
    0xcb80000000000ULL,
    0xf040000000000ULL,
    0x3ea0000000000ULL,
    0xbab0000000000ULL,
    0x338000000000ULL,
    0xd064000000000ULL,
    0x5dd2000000000ULL,
    0x2c6b000000000ULL,
    0x6bc9800000000ULL,
    0x96fe400000000ULL,
    0xdb86e00000000ULL,
    0x6842300000000ULL,
    0x9aa2480000000ULL,
    0xa8b07c0000000ULL,
    0x303a920000000ULL,
    0x20e42d0000000ULL,
    0x2113b18000000ULL,
    0xb80e4fc000000ULL,
    0xd41f282000000ULL,
    0xe1970c1000000ULL,
    0x8ccfba1800000ULL,
    0x5c7c212c00000ULL,
    0x38478b8200000ULL,
    0x62a72edf00000ULL,
    0xbcb7c39580000ULL,
    0x2a3c52f440000ULL,
    0x6fe4d18ae0000ULL,
    0x7963fc010000ULL,
    0x55c98035a8000ULL,
    0x8bfe400dac000ULL,
    0xae06e02f4e000ULL,
    0xc502302359000ULL,
    0xb182481214800ULL,
    0xf407c0c4ac00ULL,
    0x102292123a600ULL,
    0x2b702d1343900ULL,
    0x8ad9b18b67b80ULL,
    0xef14ffcb58c0ULL,
    0xdf9ca81eba120ULL,
    0x31d64c2b83df0ULL,
    0x626ada1946448ULL,
    0x5ecf513e855b4ULL,
    0x4f78a3b123b46ULL,
    0x18c022c5b64ffULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x1000000000000ULL,
    0xb800000000000ULL,
    0xfc00000000000ULL,
    0x6200000000000ULL,
    0xc100000000000ULL,
    0x5680000000000ULL,
    0x4640000000000ULL,
    0x320000000000ULL,
    0x9a10000000000ULL,
    0xb938000000000ULL,
    0x90e4000000000ULL,
    0xf8f2000000000ULL,
    0x78cf000000000ULL,
    0xa2ac800000000ULL,
    0x6e1bc00000000ULL,
    0x6cf6e00000000ULL,
    0xfece900000000ULL,
    0xda8480000000ULL,
    0x339e140000000ULL,
    0xf932020000000ULL,
    0x732f610000000ULL,
    0x71dd3c8000000ULL,
    0x8417e7c000000ULL,
    0x5a38282000000ULL,
    0xe760441000000ULL,
    0xf8322a3800000ULL,
    0x85ab250400000ULL,
    0xc79d16ae00000ULL,
    0x2f33c2ff00000ULL,
    0x8429beb880000ULL,
    0xc05846e040000ULL,
    0xcbd5748da0000ULL,
    0xead9f3c590000ULL,
    0xaf922a36c8000ULL,
    0xc8fb250d84000ULL,
    0x730516a0ce000ULL,
    0x8f87c2ef79000ULL,
    0x1cc3bebd1c800ULL,
    0x8f6346d0e3c00ULL,
    0x1c33f4bd43200ULL,
    0xeba933c8d2f00ULL,
    0xcc9a4a161bb80ULL,
    0xfcb175079ea40ULL,
    0xaef3e9d50920ULL,
    0x263886db29450ULL,
    0xc5651485b5208ULL,
    0xd937a3f397e84ULL,
    0xc32a020435572ULL,
    0x39db6108576dfULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x1000000000000ULL,
    0x800000000000ULL,
    0x400000000000ULL,
    0xaa00000000000ULL,
    0x4d00000000000ULL,
    0x8880000000000ULL,
    0xad40000000000ULL,
    0x2ba0000000000ULL,
    0x4d70000000000ULL,
    0x8cb8000000000ULL,
    0x3964000000000ULL,
    0xa612000000000ULL,
    0x3baf000000000ULL,
    0xcc4c800000000ULL,
    0x341e400000000ULL,
    0x4391200000000ULL,
    0xae68d00000000ULL,
    0xb2a9a80000000ULL,
    0x4ecaa40000000ULL,
    0x24595a0000000ULL,
    0xf8b7c50000000ULL,
    0x425cd78000000ULL,
    0xbbb4c3c000000ULL,
    0xddde082000000ULL,
    0xcb77341000000ULL,
    0xdfbf523800000ULL,
    0xaee4f10400000ULL,
    0xd2d1858200000ULL,
    0x93cf32c100000ULL,
    0xe4db0d8a80000ULL,
    0xb1f246c340000ULL,
    0xd3ff7fba20000ULL,
    0xb3c567ff50000ULL,
    0xdde1d210e8000ULL,
    0xf555b1065c000ULL,
    0x1f0c25b3ae000ULL,
    0x50b9a2d819000ULL,
    0x3f63858324800ULL,
    0xb51032e7fbc00ULL,
    0x4c2f8da95b200ULL,
    0xa88806f24b900ULL,
    0x947c5f8102480ULL,
    0x6f02b7c8cf340ULL,
    0x8184fa1c68ea0ULL,
    0x6fc155061c690ULL,
    0xdbe45f820ff68ULL,
    0xe656b7ce88a14ULL,
    0x688efa3aacddeULL,
    0x347a553cd754fULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0xb000000000000ULL,
    0x3800000000000ULL,
    0xf400000000000ULL,
    0x1200000000000ULL,
    0x7900000000000ULL,
    0xc80000000000ULL,
    0x5940000000000ULL,
    0xb460000000000ULL,
    0x1950000000000ULL,
    0xf498000000000ULL,
    0x62a4000000000ULL,
    0x1df2000000000ULL,
    0xc26d000000000ULL,
    0x7549800000000ULL,
    0x8d7fc00000000ULL,
    0x9a34a00000000ULL,
    0xb64a100000000ULL,
    0xc4fe880000000ULL,
    0xb1f5840000000ULL,
    0x746b3a0000000ULL,
    0x364ddb0000000ULL,
    0x84f9b68000000ULL,
    0x11f3a2c000000ULL,
    0xc469a82000000ULL,
    0xe49541000000ULL,
    0x70fa922800000ULL,
    0x3f08f2c00000ULL,
    0xbd69248e00000ULL,
    0x2ca2dfd00000ULL,
    0x29bb0ca480000ULL,
    0xb791b9ce40000ULL,
    0xa43cbe8b20000ULL,
    0xf654e6ea50000ULL,
    0x4b1fb22b18000ULL,
    0xaa615f0754000ULL,
    0x66510c9fa6000ULL,
    0x8318b9d7e9000ULL,
    0xc6673eaedc800ULL,
    0x305626d58b400ULL,
    0xd01a923fea600ULL,
    0x47e08f111bf00ULL,
    0x7791249393280ULL,
    0x443e2df43f840ULL,
    0xe6510c8cfd220ULL,
    0xc318b9f15b210ULL,
    0x66673eb5b22e8ULL,
    0x805626f2eec6cULL,
    0xe81a9235a5a5aULL,
    0xb3e08f2b2edcbULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0xd000000000000ULL,
    0x5800000000000ULL,
    0xd400000000000ULL,
    0x1600000000000ULL,
    0xcf00000000000ULL,
    0x4880000000000ULL,
    0x34c0000000000ULL,
    0xd4e0000000000ULL,
    0x4390000000000ULL,
    0x4228000000000ULL,
    0x55a4000000000ULL,
    0x1a32000000000ULL,
    0xda1f000000000ULL,
    0xb6ba800000000ULL,
    0xfb0cc00000000ULL,
    0x557a00000000ULL,
    0x87cb300000000ULL,
    0xfdb1380000000ULL,
    0x365aa40000000ULL,
    0xee9e760000000ULL,
    0x687e4f0000000ULL,
    0x4aed508000000ULL,
    0x8b46ab4000000ULL,
    0xeca6182000000ULL,
    0xdb6541000000ULL,
    0x1e586e3800000ULL,
    0x52981b3400000ULL,
    0x227d3e9600000ULL,
    0x1feab07500000ULL,
    0xcec126a580000ULL,
    0x49e7e463c0000ULL,
    0x6a11c88a20000ULL,
    0xf56c3f6930000ULL,
    0xb301d63b38000ULL,
    0xa2817f01e4000ULL,
    0x51c668bb0a000ULL,
    0x19670f67a9000ULL,
    0x6ad0ee272c800ULL,
    0xe78bdb2d77c00ULL,
    0x67901eb736a00ULL,
    0x7c2d4064d7300ULL,
    0x26a7be80c7e80ULL,
    0x18b6704c4fcc0ULL,
    0xbbde8681d2ce0ULL,
    0x27d8d4695c690ULL,
    0x1ddaf09c2fbd8ULL,
    0x20dd9b5b0263cULL,
    0x395f2006749c2ULL,
    0x618f0394396dULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0xb000000000000ULL,
    0xd800000000000ULL,
    0x5c00000000000ULL,
    0x2600000000000ULL,
    0x900000000000ULL,
    0x9480000000000ULL,
    0x45c0000000000ULL,
    0xb920000000000ULL,
    0x8e10000000000ULL,
    0xc798000000000ULL,
    0x4364000000000ULL,
    0xd572000000000ULL,
    0x6eeb000000000ULL,
    0xdb89800000000ULL,
    0x6ff8c00000000ULL,
    0x1197e00000000ULL,
    0xf5ddb00000000ULL,
    0xc04080000000ULL,
    0xe07040000000ULL,
    0xed043e0000000ULL,
    0x5e83d10000000ULL,
    0xb2c76c8000000ULL,
    0x78a21ec000000ULL,
    0x7950682000000ULL,
    0x327d741000000ULL,
    0xe0d4561800000ULL,
    0xd93ea52c00000ULL,
    0x53333ab600000ULL,
    0xc38cbbd700000ULL,
    0x13fb52a980000ULL,
    0xe795cfd240000ULL,
    0x94dd049d20000ULL,
    0x1c806aed70000ULL,
    0x31c7be2048000ULL,
    0x7b24110884000ULL,
    0x4d130c9666000ULL,
    0xa4186ee999000ULL,
    0xc720000ffc800ULL,
    0x9b10000f8ac00ULL,
    0x1518002c0a600ULL,
    0xbfa400074a300ULL,
    0x20d20008ebf80ULL,
    0xf93b00085a6c0ULL,
    0x8331802073820ULL,
    0xab8cc02926010ULL,
    0x97fde02c39ef8ULL,
    0x9d92b0164d044ULL,
    0xbbdf880522c32ULL,
    0x8104c4009f1bbULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x5000000000000ULL,
    0x7800000000000ULL,
    0xb400000000000ULL,
    0x600000000000ULL,
    0x2900000000000ULL,
    0x9880000000000ULL,
    0x15c0000000000ULL,
    0xe2e0000000000ULL,
    0xd850000000000ULL,
    0xa728000000000ULL,
    0xf854000000000ULL,
    0x572e000000000ULL,
    0xb057000000000ULL,
    0xcb2c800000000ULL,
    0x7a54c00000000ULL,
    0x5029200000000ULL,
    0xcdd4f00000000ULL,
    0xf468680000000ULL,
    0xa270340000000ULL,
    0xdb18c60000000ULL,
    0x3fef230000000ULL,
    0x5c32048000000ULL,
    0x37b81a4000000ULL,
    0x4318c62000000ULL,
    0x1bef233000000ULL,
    0x4232049800000ULL,
    0xfab81a5400000ULL,
    0xa598c63e00000ULL,
    0x932f231d00000ULL,
    0x3e52049980000ULL,
    0x1e281a5e40000ULL,
    0x78d0c61820000ULL,
    0xa6eb231870000ULL,
    0x2cb404a138000ULL,
    0x8e7b1a6854000ULL,
    0x43fa4631ea000ULL,
    0x94bce32665000ULL,
    0xe09fa4b4f3800ULL,
    0x89ac2a4441c00ULL,
    0x2c978e0321200ULL,
    0x814ce738f0300ULL,
    0x9fc62aa0f9c80ULL,
    0xd9e7cd7734fc0ULL,
    0x5fd524be3b3a0ULL,
    0x2b6bea506c3d0ULL,
    0x5bf42e363ff98ULL,
    0xca5fd708cf34cULL,
    0x2cde29137bb2ULL,
    0xfd84c979823b9ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0xd000000000000ULL,
    0x4800000000000ULL,
    0x9400000000000ULL,
    0x9e00000000000ULL,
    0x7d00000000000ULL,
    0x8180000000000ULL,
    0x8c40000000000ULL,
    0x87e0000000000ULL,
    0xffb0000000000ULL,
    0x18c8000000000ULL,
    0xe7b4000000000ULL,
    0x4ce000000000ULL,
    0x8db7000000000ULL,
    0x37c8800000000ULL,
    0x3935400000000ULL,
    0xae0c200000000ULL,
    0xac91b00000000ULL,
    0xab5fc80000000ULL,
    0xca6dbc0000000ULL,
    0xd867aa0000000ULL,
    0xaef3830000000ULL,
    0xaea9578000000ULL,
    0xc44c54000000ULL,
    0x47e7aa2000000ULL,
    0x9fb3833000000ULL,
    0xc8c9579800000ULL,
    0xafb4c57400000ULL,
    0x90cfaa3200000ULL,
    0x13b7831500000ULL,
    0x4acf57bf80000ULL,
    0xb8b7c56b40000ULL,
    0x22492a1260000ULL,
    0x2b75c33610000ULL,
    0x54ebf79e78000ULL,
    0xd2a33554ac000ULL,
    0x3fd2c21452000ULL,
    0xaa3dcf0ffd000ULL,
    0x231d959f4b800ULL,
    0x3b8a0a77c1c00ULL,
    0x7ed4bf99a0200ULL,
    0x31bfc941b0500ULL,
    0x645f4814c8880ULL,
    0x4ecfc2ce5ac0ULL,
    0x5aa58a0b77d20ULL,
    0xcbd533372b3f0ULL,
    0xe43e1f88d1628ULL,
    0x161c3966594ccULL,
    0x2e0c202d5d87eULL,
    0x6c91b00a7a0e5ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x7000000000000ULL,
    0xf800000000000ULL,
    0xdc00000000000ULL,
    0xe00000000000ULL,
    0x9100000000000ULL,
    0xad80000000000ULL,
    0xe840000000000ULL,
    0x49a0000000000ULL,
    0xadf0000000000ULL,
    0xb888000000000ULL,
    0xc5f4000000000ULL,
    0x8c8e000000000ULL,
    0x3ff1000000000ULL,
    0x478d800000000ULL,
    0x2976c00000000ULL,
    0x414b600000000ULL,
    0xba16b00000000ULL,
    0x71dfe80000000ULL,
    0xa30bdc0000000ULL,
    0xb4aa0000000ULL,
    0xb6ab910000000ULL,
    0x6342c58000000ULL,
    0x3f20d54000000ULL,
    0x7b34aa2000000ULL,
    0xa3eb913000000ULL,
    0xd162c5a800000ULL,
    0x4790d55c00000ULL,
    0xd19caa1e00000ULL,
    0x6eaf910700000ULL,
    0xf44c5ab80000ULL,
    0x6925d57840000ULL,
    0x46372a3560000ULL,
    0xf86c513d10000ULL,
    0x742425b9e8000ULL,
    0xadb0a5533c000ULL,
    0x528221b42000ULL,
    0x3202fd0c6d000ULL,
    0x8f07879acb800ULL,
    0x1481985cc0400ULL,
    0x11c7458aa1600ULL,
    0x8be2154630b00ULL,
    0xa751ca2a99580ULL,
    0x27fc210245ec0ULL,
    0xa9b8ad9ed69a0ULL,
    0x4519c942f2470ULL,
    0xbf6d603cb4728ULL,
    0x24a3b004ef084ULL,
    0xbe74683b862b6ULL,
    0x99c81c1e7a725ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0xf000000000000ULL,
    0x1800000000000ULL,
    0x6400000000000ULL,
    0x200000000000ULL,
    0xb500000000000ULL,
    0x680000000000ULL,
    0x3cc0000000000ULL,
    0x51a0000000000ULL,
    0x8bb0000000000ULL,
    0xe8a8000000000ULL,
    0x2fb4000000000ULL,
    0x4aaa000000000ULL,
    0x8ab3000000000ULL,
    0xa42d800000000ULL,
    0xca73c00000000ULL,
    0x938ea00000000ULL,
    0xf6c3d00000000ULL,
    0xc8a3080000000ULL,
    0xe337e40000000ULL,
    0xef68ee0000000ULL,
    0xb396690000000ULL,
    0x2859338000000ULL,
    0xbefeec4000000ULL,
    0xdec8ee2000000ULL,
    0x8826691000000ULL,
    0x38f133b800000ULL,
    0x54aec7c00000ULL,
    0x8e62ee2600000ULL,
    0xd395690900000ULL,
    0x985cb3b880000ULL,
    0x46f92c5140000ULL,
    0x4acc4e27a0000ULL,
    0x9226b90630000ULL,
    0xe9f7bbace8000ULL,
    0x1cac873ac000ULL,
    0x7a6a01d8a000ULL,
    0x84b7d00ddd000ULL,
    0x2f29083e42800ULL,
    0xfff4e41100c00ULL,
    0xeecd6e1481600ULL,
    0x3021a92f41f00ULL,
    0x4cf593a2a1280ULL,
    0xef4a3c50b0340ULL,
    0x47646600a9a20ULL,
    0xb3154d1e8c090ULL,
    0x1398fda1fb138ULL,
    0xa4db956d15ae4ULL,
    0xfb39f58d1feeeULL,
    0x17eb716703b21ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x5000000000000ULL,
    0x8800000000000ULL,
    0xd400000000000ULL,
    0x8200000000000ULL,
    0x700000000000ULL,
    0x1080000000000ULL,
    0x91c0000000000ULL,
    0xaa60000000000ULL,
    0x5210000000000ULL,
    0x4878000000000ULL,
    0x8e14000000000ULL,
    0xde7e000000000ULL,
    0xab11000000000ULL,
    0x99fc800000000ULL,
    0xa255400000000ULL,
    0x765a200000000ULL,
    0xd821500000000ULL,
    0x6b32180000000ULL,
    0xecdd40000000ULL,
    0xaa9c960000000ULL,
    0xd1c7870000000ULL,
    0xca63868000000ULL,
    0xa21404c000000ULL,
    0x907c962000000ULL,
    0xd217873000000ULL,
    0x887b86a800000ULL,
    0x2e1004d400000ULL,
    0x8e7a960200000ULL,
    0x2312870500000ULL,
    0x4df9068880000ULL,
    0x205444d5c0000ULL,
    0x715c360620000ULL,
    0xc8a6972170000ULL,
    0xfaf13ea218000ULL,
    0xa4a8c0c144000ULL,
    0xf88ab8143e000ULL,
    0x99b8c402f5000ULL,
    0x44702e1587800ULL,
    0x7c6a432b80400ULL,
    0x3b69289241200ULL,
    0x4bee07da60500ULL,
    0x2a2d1e8011080ULL,
    0x584c90f988140ULL,
    0x565a20228da60ULL,
    0x48215008d3250ULL,
    0x43321820362d8ULL,
    0x8acdd41d39f5cULL,
    0xa09c961eb547aULL,
    0x2c78714e6243ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x7000000000000ULL,
    0xd800000000000ULL,
    0xbc00000000000ULL,
    0xc200000000000ULL,
    0xc900000000000ULL,
    0x5d80000000000ULL,
    0x5040000000000ULL,
    0x7e0000000000ULL,
    0x5eb0000000000ULL,
    0xf768000000000ULL,
    0xab4000000000ULL,
    0xf16e000000000ULL,
    0xadb7000000000ULL,
    0xfed800000000ULL,
    0xd71c00000000ULL,
    0x7bc8600000000ULL,
    0xf67d00000000ULL,
    0x4176280000000ULL,
    0xa1c93c0000000ULL,
    0x1a66aa0000000ULL,
    0xaef4030000000ULL,
    0xe088df8000000ULL,
    0xfc04f84000000ULL,
    0x6206aa2000000ULL,
    0xd904033000000ULL,
    0xf580df9800000ULL,
    0x3440f85c00000ULL,
    0x79e0aa1600000ULL,
    0x55b7031f00000ULL,
    0x63eb5fa880000ULL,
    0x772386e40000ULL,
    0xa6cb4a0160000ULL,
    0xf4e6130b10000ULL,
    0xa63097a978000ULL,
    0xf0a91479ec000ULL,
    0x8015a83cba000ULL,
    0x53bffc09bd000ULL,
    0xe32b4a1523800ULL,
    0xa356131281c00ULL,
    0x6cd8979f41600ULL,
    0xda5d147ae1700ULL,
    0xae9ba833d1980ULL,
    0x1cb8fc3d58340ULL,
    0xd9aeca211cea0ULL,
    0x6d93d321933f0ULL,
    0xbbfef793c8328ULL,
    0x28cdc47ba534cULL,
    0xe7e00006deddeULL,
    0xeeb00014c2011ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x5000000000000ULL,
    0xb800000000000ULL,
    0x2400000000000ULL,
    0x600000000000ULL,
    0xa500000000000ULL,
    0x1e80000000000ULL,
    0x4c0000000000ULL,
    0xdfa0000000000ULL,
    0xec70000000000ULL,
    0x5ee8000000000ULL,
    0xc074000000000ULL,
    0xd4ea000000000ULL,
    0x9f77000000000ULL,
    0x1d68800000000ULL,
    0x9e32c00000000ULL,
    0x5989a00000000ULL,
    0xb1a2f00000000ULL,
    0x9574880000000ULL,
    0x26e040000000ULL,
    0x37b2ae0000000ULL,
    0x8c9f90000000ULL,
    0x4d444d8000000ULL,
    0x9ee44e4000000ULL,
    0xc892ae2000000ULL,
    0x2179f91000000ULL,
    0xb48c4d9800000ULL,
    0x43204e5400000ULL,
    0x3bb0ae0e00000ULL,
    0xb2caf91900000ULL,
    0xfa46cd9980000ULL,
    0xcb618e7d40000ULL,
    0xebd38e09a0000ULL,
    0xc699c91830000ULL,
    0x209965ae68000ULL,
    0x9598ba465c000ULL,
    0x531c881e1a000ULL,
    0x23da04282d000ULL,
    0x4278ae1b52800ULL,
    0x2f0ef92181c00ULL,
    0x6964cdb940200ULL,
    0x8d28e5fa1b00ULL,
    0x1d190e3530e80ULL,
    0x6ad80909e97c0ULL,
    0xf6fa45aa1d020ULL,
    0x44cb8a423a310ULL,
    0x974320175c438ULL,
    0x79e3302b9b024ULL,
    0x2517a83f6c116ULL,
    0x263d340df3229ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0xd000000000000ULL,
    0x7800000000000ULL,
    0xac00000000000ULL,
    0xfa00000000000ULL,
    0xbf00000000000ULL,
    0x2180000000000ULL,
    0x4440000000000ULL,
    0xc1e0000000000ULL,
    0x8b30000000000ULL,
    0xa428000000000ULL,
    0xd134000000000ULL,
    0xb2e000000000ULL,
    0xa8b5000000000ULL,
    0x3368800000000ULL,
    0xeb56c00000000ULL,
    0xab5de00000000ULL,
    0x94f9100000000ULL,
    0x812c180000000ULL,
    0x7fb61c0000000ULL,
    0xe6eb3a0000000ULL,
    0x2910930000000ULL,
    0x57bda38000000ULL,
    0x2d4e524000000ULL,
    0xbac33a2000000ULL,
    0x9424933000000ULL,
    0x8693a38800000ULL,
    0xeafb527400000ULL,
    0xd02bba3e00000ULL,
    0x9732531b00000ULL,
    0x162e43b680000ULL,
    0x4a32425bc0000ULL,
    0xd4afa23660000ULL,
    0x7df04f0a10000ULL,
    0x3a0b7986f8000ULL,
    0x40a7d1790c000ULL,
    0x1452819f6a000ULL,
    0x6adcdd7e5d000ULL,
    0x20bba3a433800ULL,
    0xe8cf526321400ULL,
    0x2085ba1bb0200ULL,
    0x14c7533088b00ULL,
    0xbd26c3b0e4f80ULL,
    0xc214825d1f040ULL,
    0xe03a420d7b260ULL,
    0xc0d5f34a5370ULL,
    0x35a1619f3e368ULL,
    0x2d0cd6d4b20cULL,
    0xb1f3b966c4eeULL,
    0x8b1f8e72faa39ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0xd000000000000ULL,
    0xc800000000000ULL,
    0xd400000000000ULL,
    0xd600000000000ULL,
    0x2100000000000ULL,
    0x9580000000000ULL,
    0x3e40000000000ULL,
    0xb860000000000ULL,
    0x8b90000000000ULL,
    0x1c58000000000ULL,
    0x6994000000000ULL,
    0x5b5a000000000ULL,
    0xe515000000000ULL,
    0x3c9c800000000ULL,
    0xa933400000000ULL,
    0x2c6a200000000ULL,
    0x5c7df00000000ULL,
    0xd367280000000ULL,
    0x7d175c0000000ULL,
    0x6099da0000000ULL,
    0x8b331f0000000ULL,
    0xb6e468000000ULL,
    0x20fc9dc000000ULL,
    0xaca1da2000000ULL,
    0x2d371f1000000ULL,
    0x726c468800000ULL,
    0x897d9df400000ULL,
    0x40e75a1200000ULL,
    0xaa515f2500000ULL,
    0x997ae6bd80000ULL,
    0xe8e32dfc40000ULL,
    0x8e52523760000ULL,
    0x577ff32a90000ULL,
    0xd5e6149398000ULL,
    0x19d66edea4000ULL,
    0x9e3b4eb076000ULL,
    0xd90231f0f5000ULL,
    0x398528254e800ULL,
    0x4465c37e1400ULL,
    0x83675a1751200ULL,
    0xf5115f3eb9d00ULL,
    0x949ae6b454080ULL,
    0x8d332df1fe3c0ULL,
    0xe26a520c08ea0ULL,
    0x617bf338bc070ULL,
    0x44e41486927e8ULL,
    0xb4576ed5e2fbcULL,
    0x6c7dce822b7baULL,
    0xab6471e0b7207ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x1000000000000ULL,
    0xb800000000000ULL,
    0x9400000000000ULL,
    0xaa00000000000ULL,
    0x1100000000000ULL,
    0x6780000000000ULL,
    0xa0c0000000000ULL,
    0x5320000000000ULL,
    0xb750000000000ULL,
    0xa278000000000ULL,
    0x1154000000000ULL,
    0x5d7e000000000ULL,
    0xd5d1000000000ULL,
    0xf3e800000000ULL,
    0x53b4c00000000ULL,
    0xce8a200000000ULL,
    0xd839900000000ULL,
    0x7b36a80000000ULL,
    0x2c8ac0000000ULL,
    0xf558ae0000000ULL,
    0x7403b50000000ULL,
    0xda02548000000ULL,
    0x1900c6c000000ULL,
    0x5b80ae2000000ULL,
    0x26c7b53000000ULL,
    0x7c2454a800000ULL,
    0x6bd5c6c400000ULL,
    0x74382e0e00000ULL,
    0x8536751500000ULL,
    0x19cef48280000ULL,
    0x93d996c040000ULL,
    0xb422617e0000ULL,
    0xbde7893d30000ULL,
    0x5774d29648000ULL,
    0x5faa1fed94000ULL,
    0xf268f4bf7e000ULL,
    0x90cc96f965000ULL,
    0xb05aa62117800ULL,
    0x19864928e0400ULL,
    0x7bc672b4b1a00ULL,
    0x95a24fd988300ULL,
    0xd814fc94b5080ULL,
    0x7d986affee240ULL,
    0xcb20000efc0a0ULL,
    0xf35000087a1b0ULL,
    0x1078001283238ULL,
    0x8454003a9ec94ULL,
    0x28fe0013549f2ULL,
    0xf011001ade2abULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x7000000000000ULL,
    0xc800000000000ULL,
    0xe400000000000ULL,
    0x7600000000000ULL,
    0x2900000000000ULL,
    0x780000000000ULL,
    0xbbc0000000000ULL,
    0x5de0000000000ULL,
    0x6d50000000000ULL,
    0xdc68000000000ULL,
    0x2454000000000ULL,
    0xebea000000000ULL,
    0xb793000000000ULL,
    0x2209800000000ULL,
    0x64c5400000000ULL,
    0x3366a00000000ULL,
    0x3112f00000000ULL,
    0x4a4de80000000ULL,
    0xdce1cc0000000ULL,
    0xbed1b60000000ULL,
    0x39ae630000000ULL,
    0xc4b07c8000000ULL,
    0x3f38704000000ULL,
    0x1d3bb62000000ULL,
    0x2a3d631000000ULL,
    0x70b9fcb800000ULL,
    0x2fd305c00000ULL,
    0xe1dd161200000ULL,
    0x44ef932900000ULL,
    0x111414a580000ULL,
    0x9a4cfc5640000ULL,
    0x84e4a013e0000ULL,
    0xe2d5f007f0000ULL,
    0x63ae6832f8000ULL,
    0x7fb78c0d14000ULL,
    0x67be9604fa000ULL,
    0x8879d31ee5000ULL,
    0xcb9b34b002800ULL,
    0xfbcb4c7cf0c00ULL,
    0xee27e81e78600ULL,
    0x74b2cc2ed4500ULL,
    0x573836195b280ULL,
    0x693b2326f47c0ULL,
    0xe43edc9f0b1a0ULL,
    0x75be805e1c230ULL,
    0x977c5e2417458ULL,
    0x51faf358be4cULL,
    0x3789ca92dd052ULL,
    0xc0021353373f1ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x1000000000000ULL,
    0x6800000000000ULL,
    0x6400000000000ULL,
    0xfe00000000000ULL,
    0x5d00000000000ULL,
    0x8c80000000000ULL,
    0x9940000000000ULL,
    0x6d60000000000ULL,
    0x8af0000000000ULL,
    0xc648000000000ULL,
    0xe3f4000000000ULL,
    0x7cce000000000ULL,
    0x33b7000000000ULL,
    0x1b2e800000000ULL,
    0x7104400000000ULL,
    0xa685a00000000ULL,
    0x2247b00000000ULL,
    0xa0e1480000000ULL,
    0x6d30d40000000ULL,
    0xf56d020000000ULL,
    0x2be4ff0000000ULL,
    0x78b4758000000ULL,
    0x6eaa3d4000000ULL,
    0xfac3022000000ULL,
    0x1fa3ff3000000ULL,
    0x2152f59800000ULL,
    0x111a7d4400000ULL,
    0xdbe8a23a00000ULL,
    0xbda34f2900000ULL,
    0x2e553da780000ULL,
    0x2a9ae95340000ULL,
    0x152e001920000ULL,
    0x9407000f50000ULL,
    0x4606803cd8000ULL,
    0x31004031fc000ULL,
    0x683a008b2000ULL,
    0x5244b007ad000ULL,
    0xd8e1c83beb800ULL,
    0x6133943911c00ULL,
    0x6f6e221479a00ULL,
    0x88e30f02ec100ULL,
    0xa9369dadcae80ULL,
    0x7b6e5966c02c0ULL,
    0xee7c83f61f20ULL,
    0xf830940ff0250ULL,
    0x6deea213c9a88ULL,
    0x34a04f0a8513cULL,
    0x44d5bdaadeef6ULL,
    0xf2d9a945a7aa5ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x3000000000000ULL,
    0xe800000000000ULL,
    0xdc00000000000ULL,
    0x9e00000000000ULL,
    0xf900000000000ULL,
    0x1580000000000ULL,
    0x4f40000000000ULL,
    0x42a0000000000ULL,
    0x3e30000000000ULL,
    0x3e38000000000ULL,
    0xb34000000000ULL,
    0x2dba000000000ULL,
    0x2971000000000ULL,
    0x89b800000000ULL,
    0xd706400000000ULL,
    0x4485600000000ULL,
    0x26c6b00000000ULL,
    0xa3e0a80000000ULL,
    0x6d931c0000000ULL,
    0xc98b520000000ULL,
    0xe44a490000000ULL,
    0x9d2a438000000ULL,
    0x2f7848c000000ULL,
    0x5091522000000ULL,
    0x960b491000000ULL,
    0x8009c3a800000ULL,
    0x750a08cc00000ULL,
    0x868e321a00000ULL,
    0x34ccf92700000ULL,
    0xc9eaeb8f80000ULL,
    0x39b54f240000ULL,
    0xd82001f60000ULL,
    0x9b450034d0000ULL,
    0x90a1801f28000ULL,
    0x8137403dcc000ULL,
    0xe6bee030ee000ULL,
    0x13f0f0261d000ULL,
    0x475dc83c46800ULL,
    0xb961ac3b90400ULL,
    0x5251fa08c8e00ULL,
    0xefe85524dc900ULL,
    0x1e9a918ae7d80ULL,
    0x220441cc61ec0ULL,
    0xb706718550ca0ULL,
    0x9481b1fc68570ULL,
    0x5ec239a02d0c8ULL,
    0xa7e35de6ff7e4ULL,
    0xc79723bf945aeULL,
    0x728af8ce7b453ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0xf000000000000ULL,
    0x8800000000000ULL,
    0xc400000000000ULL,
    0x9e00000000000ULL,
    0x1f00000000000ULL,
    0x6080000000000ULL,
    0x3a40000000000ULL,
    0xb3a0000000000ULL,
    0xa370000000000ULL,
    0x1998000000000ULL,
    0x2074000000000ULL,
    0xfb1e000000000ULL,
    0x4737000000000ULL,
    0x1539800000000ULL,
    0x7383400000000ULL,
    0xa0c7a00000000ULL,
    0x98e3b00000000ULL,
    0x1751580000000ULL,
    0xac2bb40000000ULL,
    0xea0b0a0000000ULL,
    0x4ab8690000000ULL,
    0x7945318000000ULL,
    0x3124d5c000000ULL,
    0x34350a2000000ULL,
    0x7fbf693000000ULL,
    0xd0c4b19800000ULL,
    0xd0e395fc00000ULL,
    0xb354aa0200000ULL,
    0xc22fd90100000ULL,
    0x7d0a69bf80000ULL,
    0xee3861fbc0000ULL,
    0xdd07801a20000ULL,
    0x9d84400f90000ULL,
    0xf7c6201368000ULL,
    0x5c64f0131c000ULL,
    0x4310f83c46000ULL,
    0x888b04378d000ULL,
    0xedfdd235af800ULL,
    0xf7679d3ed1c00ULL,
    0xf5901b9b08600ULL,
    0x9cc4cda6dd00ULL,
    0x50dec39a1e680ULL,
    0xf957b8ef292c0ULL,
    0xfb2de9befc360ULL,
    0x2e8c21f3f73d0ULL,
    0x1ef9a03674aa8ULL,
    0x5de4b0185b364ULL,
    0x36d0d8034b7a6ULL,
    0x89ecf43163087ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0xf000000000000ULL,
    0xc800000000000ULL,
    0xc00000000000ULL,
    0xf600000000000ULL,
    0x9100000000000ULL,
    0xbc80000000000ULL,
    0x240000000000ULL,
    0x38e0000000000ULL,
    0x4a70000000000ULL,
    0x7b88000000000ULL,
    0xfd74000000000ULL,
    0x2e0a000000000ULL,
    0x27b1000000000ULL,
    0x1ead800000000ULL,
    0xfa27400000000ULL,
    0xed5e00000000ULL,
    0x341cf00000000ULL,
    0x760f680000000ULL,
    0xf3b2140000000ULL,
    0x7cabfa0000000ULL,
    0xa925130000000ULL,
    0x1155098000000ULL,
    0xe1dcdf4000000ULL,
    0x9729fa2000000ULL,
    0xaee0131000000ULL,
    0xcb7289a800000ULL,
    0x5f0a9f7c00000ULL,
    0xcb319a1200000ULL,
    0x24eba31300000ULL,
    0x6c0019580000ULL,
    0xbea07b5840000ULL,
    0x2897083d20000ULL,
    0xa6f9a41390000ULL,
    0x6379721bb8000ULL,
    0x61bff70adc000ULL,
    0xc51b9b83c2000ULL,
    0xda8ad87ccd000ULL,
    0x69f289983a800ULL,
    0x704a9f6f30400ULL,
    0xd1519a3e69600ULL,
    0x1dba32d44d00ULL,
    0xc728019c0ff80ULL,
    0x96e47b69777c0ULL,
    0xf75082b4aba0ULL,
    0xa50ca40a78550ULL,
    0xac36f22dbd068ULL,
    0x96db7367238cULL,
    0xb801fb8d65f86ULL,
    0x8404686b1e62dULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x3000000000000ULL,
    0x7800000000000ULL,
    0x4c00000000000ULL,
    0x5200000000000ULL,
    0xe700000000000ULL,
    0x2880000000000ULL,
    0x6240000000000ULL,
    0x60000000000ULL,
    0x130000000000ULL,
    0x4b48000000000ULL,
    0xec34000000000ULL,
    0x38ce000000000ULL,
    0x2cf1000000000ULL,
    0xc1ef800000000ULL,
    0x2f22c00000000ULL,
    0x42d5e00000000ULL,
    0xf2bc500000000ULL,
    0x1258d80000000ULL,
    0x852a140000000ULL,
    0x70014a0000000ULL,
    0x1801570000000ULL,
    0xdc03638000000ULL,
    0x1a033d4000000ULL,
    0xd3074a2000000ULL,
    0x3684573000000ULL,
    0xd742e3a800000ULL,
    0xcfe0fd4c00000ULL,
    0x4bf52a3e00000ULL,
    0x296ec72300000ULL,
    0xed61dbbc80000ULL,
    0x72b7b975c0000ULL,
    0x8b8b383420000ULL,
    0x1513443b90000ULL,
    0x3b18123c98000ULL,
    0xafc883358c000ULL,
    0x1c704986f2000ULL,
    0x7fa8fa709d000ULL,
    0x354711baab800ULL,
    0x90e02e42b0400ULL,
    0x8f73bba089e00ULL,
    0x292d295455b00ULL,
    0x720000089ef80ULL,
    0x17000018df540ULL,
    0xf0800004bfd60ULL,
    0x1e4000374f350ULL,
    0x2a60000226aa8ULL,
    0xaa300003c301cULL,
    0x31c8001d550eeULL,
    0x6974000d1efa5ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x1000000000000ULL,
    0xd800000000000ULL,
    0xac00000000000ULL,
    0xe200000000000ULL,
    0xb300000000000ULL,
    0x380000000000ULL,
    0xd540000000000ULL,
    0x7660000000000ULL,
    0xaab0000000000ULL,
    0x948000000000ULL,
    0x93b4000000000ULL,
    0xfdca000000000ULL,
    0xa377000000000ULL,
    0x6bea800000000ULL,
    0x5921c00000000ULL,
    0xe3d7e00000000ULL,
    0x327ad00000000ULL,
    0x34bc780000000ULL,
    0x6f9fcc0000000ULL,
    0x6f4b520000000ULL,
    0xe6b13f0000000ULL,
    0xbb49278000000ULL,
    0x98b7c54000000ULL,
    0x4249522000000ULL,
    0x4c323f1000000ULL,
    0x289a79800000ULL,
    0x1211054400000ULL,
    0x8cdc321600000ULL,
    0xd42d2f3b00000ULL,
    0xb6803fa080000ULL,
    0xb3c71968c0000ULL,
    0x3da39816e0000ULL,
    0x4b111c0e50000ULL,
    0x685d2a3d18000ULL,
    0x3ce9f3026c000ULL,
    0x8ca0f5b4b2000ULL,
    0xab933a7abd000ULL,
    0x69d95ba6a800ULL,
    0x23c82a7eb1c00ULL,
    0x6a760da048a00ULL,
    0x176d3653f5700ULL,
    0x7de127941f780ULL,
    0x2bf3c571ef740ULL,
    0x412b522307be0ULL,
    0xa0013f3a82830ULL,
    0x3001278a35ac8ULL,
    0xa803c56b7f3bcULL,
    0x6403520afff7eULL,
    0x96053f23be725ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0xb000000000000ULL,
    0xe800000000000ULL,
    0x9c00000000000ULL,
    0x6a00000000000ULL,
    0xbf00000000000ULL,
    0xdd80000000000ULL,
    0xac40000000000ULL,
    0x4220000000000ULL,
    0xd010000000000ULL,
    0xe838000000000ULL,
    0x5914000000000ULL,
    0x80ba000000000ULL,
    0x7d5000000000ULL,
    0xeb5f800000000ULL,
    0x4da2400000000ULL,
    0x6753600000000ULL,
    0xf99d100000000ULL,
    0x3440980000000ULL,
    0x5620fc0000000ULL,
    0xb6157a0000000ULL,
    0x653a2d0000000ULL,
    0x4f955a8000000ULL,
    0x77d5cc000000ULL,
    0x3cb77a2000000ULL,
    0x1beb2d1000000ULL,
    0x448da8800000ULL,
    0x381e1cec00000ULL,
    0xb2019a1a00000ULL,
    0x8b017d3700000ULL,
    0xb84a29280000ULL,
    0xc941b0c3c0000ULL,
    0xc8a7182d60000ULL,
    0x3dd6bc1c10000ULL,
    0x6c5c1a0208000ULL,
    0x74223d37c4000ULL,
    0x651242b76e000ULL,
    0x1abbe0da55000ULL,
    0x70d3600a26800ULL,
    0x1add100a31400ULL,
    0x63e0983fb9e00ULL,
    0x670fc023d900ULL,
    0x9e0d7a1372580ULL,
    0xcf3e2d2c96040ULL,
    0x90975a9749c60ULL,
    0x4afc5cff65af0ULL,
    0xc8f2fa031f068ULL,
    0x2dcc6d1dcc8f4ULL,
    0x225c3abcaa90aULL,
    0x5254cdf3bf83ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x5000000000000ULL,
    0x1800000000000ULL,
    0x7400000000000ULL,
    0x2600000000000ULL,
    0x4300000000000ULL,
    0xdc80000000000ULL,
    0x1c40000000000ULL,
    0x76a0000000000ULL,
    0xad10000000000ULL,
    0x8248000000000ULL,
    0x6c14000000000ULL,
    0xe3ce000000000ULL,
    0x7bd3000000000ULL,
    0x23ac800000000ULL,
    0xe723c00000000ULL,
    0xd2d7200000000ULL,
    0x9e2ef00000000ULL,
    0xeae7380000000ULL,
    0x1bb1140000000ULL,
    0xcf5e5a0000000ULL,
    0xbe5ae10000000ULL,
    0x97dd528000000ULL,
    0xec1fe34000000ULL,
    0x7e785a2000000ULL,
    0x878de13000000ULL,
    0xe977d2b800000ULL,
    0x50bb235400000ULL,
    0x26dfa2600000ULL,
    0x5c43d12d00000ULL,
    0x56a34ab180000ULL,
    0x1d130744c0000ULL,
    0xca4db81120000ULL,
    0x15d42a10000ULL,
    0xb1cbfa2c28000ULL,
    0x1ed4d12f84000ULL,
    0xbc29ca91b2000ULL,
    0x27e7c74115000ULL,
    0xb830180cdb800ULL,
    0x459fe41570c00ULL,
    0xc5b9622759200ULL,
    0xf5ebf531ddf00ULL,
    0x40830897ee480ULL,
    0x2645024f3b7c0ULL,
    0xcfa508bb40ee0ULL,
    0x28920244e1b50ULL,
    0x4b8f8890b1de8ULL,
    0xcb76c275f9c44ULL,
    0x9dba28940dbaaULL,
    0xa1e8f256674ddULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0xb000000000000ULL,
    0x5800000000000ULL,
    0xdc00000000000ULL,
    0xaa00000000000ULL,
    0xa900000000000ULL,
    0x6b80000000000ULL,
    0xcbc0000000000ULL,
    0x6460000000000ULL,
    0x9290000000000ULL,
    0x7bf8000000000ULL,
    0xe594000000000ULL,
    0xf77e000000000ULL,
    0x8ad1000000000ULL,
    0xd85b800000000ULL,
    0xf163c00000000ULL,
    0x8315600000000ULL,
    0x513a900000000ULL,
    0xde72280000000ULL,
    0x802acc0000000ULL,
    0x4a4cf60000000ULL,
    0xc7daaf0000000ULL,
    0x74a2428000000ULL,
    0x2873c0c000000ULL,
    0x432af62000000ULL,
    0x28cfaf3000000ULL,
    0xd79fc2a800000ULL,
    0x830500ec00000ULL,
    0x282163600000ULL,
    0x43ff0700000ULL,
    0x1fa50a8280000ULL,
    0xaef39cc640000ULL,
    0x356c282ce0000ULL,
    0x346bcc35f0000ULL,
    0xbbef761b98000ULL,
    0x162d6f22e4000ULL,
    0x994922921e000ULL,
    0x4d5850fc95000ULL,
    0xe0e35e2e47800ULL,
    0xa9d6a31c50400ULL,
    0x6ade549a08e00ULL,
    0xa9213fdbcdf00ULL,
    0x40b47cb202d80ULL,
    0x55cff3d55ee40ULL,
    0x421e8abdf46a0ULL,
    0xdfc05cd377430ULL,
    0x3a61480b69e58ULL,
    0xb5955c1efc4fcULL,
    0x7f7b5e113afaaULL,
    0x1ed2a303aab33ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x9000000000000ULL,
    0x2800000000000ULL,
    0xb400000000000ULL,
    0xde00000000000ULL,
    0x500000000000ULL,
    0xd180000000000ULL,
    0x5dc0000000000ULL,
    0x25e0000000000ULL,
    0x6bd0000000000ULL,
    0x8c48000000000ULL,
    0xaa54000000000ULL,
    0xb98a000000000ULL,
    0xdbb3000000000ULL,
    0x9c5e800000000ULL,
    0x7afa400000000ULL,
    0x538f200000000ULL,
    0x40b6b00000000ULL,
    0xa8dc080000000ULL,
    0x66bebc0000000ULL,
    0x3aca60000000ULL,
    0xba84b30000000ULL,
    0x9143488000000ULL,
    0x45a7d94000000ULL,
    0xc1f2262000000ULL,
    0x857ef31000000ULL,
    0xf34c68b800000ULL,
    0xc8d1696400000ULL,
    0x64ce2e2a00000ULL,
    0x3c104f3d00000ULL,
    0xa2a8ce8f80000ULL,
    0xdd01da6540000ULL,
    0x9d87669e60000ULL,
    0xffc4966a70000ULL,
    0xdae468a6f8000ULL,
    0x4955696fb4000ULL,
    0xb10c2e0572000ULL,
    0xddf74f24e5000ULL,
    0xaf7c4ea29a800ULL,
    0xc8489a6458c00ULL,
    0x8c56c6ade5a00ULL,
    0xc088665f1b900ULL,
    0xf03740a819480ULL,
    0x329d655e056c0ULL,
    0x3f9c80012aa20ULL,
    0x6a1d4039003f0ULL,
    0xb1dba01580618ULL,
    0x9d3ff0304140cULL,
    0x656da82de0f02ULL,
    0xdbe24c3131095ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0xf000000000000ULL,
    0xe800000000000ULL,
    0xac00000000000ULL,
    0x9e00000000000ULL,
    0x1300000000000ULL,
    0xb80000000000ULL,
    0x6840000000000ULL,
    0x2fa0000000000ULL,
    0x21d0000000000ULL,
    0x99d8000000000ULL,
    0x3a54000000000ULL,
    0x899e000000000ULL,
    0x1f1000000000ULL,
    0x8249800000000ULL,
    0x512e400000000ULL,
    0x9298e00000000ULL,
    0x3674b00000000ULL,
    0xcc09780000000ULL,
    0xd98d6c0000000ULL,
    0x62cc7a0000000ULL,
    0xe6e8f10000000ULL,
    0x5f7bc48000000ULL,
    0x10647c000000ULL,
    0xb685fa2000000ULL,
    0x38c6b13000000ULL,
    0x106324a800000ULL,
    0x1032f7fc00000ULL,
    0x28ac821a00000ULL,
    0x17dbdd1b00000ULL,
    0x51575e8f80000ULL,
    0x961e06f8c0000ULL,
    0x43b14698e0000ULL,
    0x64e89ac110000ULL,
    0x5a7d24a468000ULL,
    0xe583f7c0b4000ULL,
    0x5345021696000ULL,
    0x28259d3385000ULL,
    0x2797be9c0f800ULL,
    0x4d7eb6dbc8400ULL,
    0xbc063eb984600ULL,
    0xe604f6df0e900ULL,
    0x700dea049b80ULL,
    0x218146d7456c0ULL,
    0xa140268eee3e0ULL,
    0x5226ad9d9cb0ULL,
    0xcf14bca66ca68ULL,
    0xc6be2bd17a504ULL,
    0x57e600173f4f2ULL,
    0x76750015501afULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0xf000000000000ULL,
    0x1800000000000ULL,
    0x7c00000000000ULL,
    0xea00000000000ULL,
    0x2700000000000ULL,
    0x3a80000000000ULL,
    0x4c40000000000ULL,
    0x9960000000000ULL,
    0x4c70000000000ULL,
    0x478000000000ULL,
    0xeef4000000000ULL,
    0x743a000000000ULL,
    0xfd97000000000ULL,
    0xef4d800000000ULL,
    0xdb6fc00000000ULL,
    0x31fa600000000ULL,
    0xdc32900000000ULL,
    0xa71c580000000ULL,
    0xd86c40000000ULL,
    0xdec5fa0000000ULL,
    0xd1226f0000000ULL,
    0xb312098000000ULL,
    0x9d0b94c000000ULL,
    0x8b087a2000000ULL,
    0x60daf1000000ULL,
    0x7b88699800000ULL,
    0xfd4904fc00000ULL,
    0x306c222600000ULL,
    0x997f6b0f00000ULL,
    0x3b7793a280000ULL,
    0xf6fc6bf5c0000ULL,
    0x56b3aba8a0000ULL,
    0x935b3fdc10000ULL,
    0x18e589a4d8000ULL,
    0x60b354f6dc000ULL,
    0x8e5f9a31be000ULL,
    0x8d60ff1bad000ULL,
    0x8276519fd6800ULL,
    0xd57950c6b9c00ULL,
    0xe9778028ed600ULL,
    0x3df8c018b6f00ULL,
    0x6e37e01b08180ULL,
    0x9c1d503da5640ULL,
    0x2d06383df2760ULL,
    0xad8454110b410ULL,
    0xec1a23b07668ULL,
    0x5920ab1d40ffcULL,
    0x2715f3ac60746ULL,
    0x130afbc530643ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x9000000000000ULL,
    0x2800000000000ULL,
    0xbc00000000000ULL,
    0xae00000000000ULL,
    0xef00000000000ULL,
    0x5a80000000000ULL,
    0x5840000000000ULL,
    0xc320000000000ULL,
    0xcf10000000000ULL,
    0x3c08000000000ULL,
    0xed94000000000ULL,
    0x104a000000000ULL,
    0xcb1000000000ULL,
    0x265e800000000ULL,
    0x1138400000000ULL,
    0xdb0f600000000ULL,
    0xdb17300000000ULL,
    0x6e09180000000ULL,
    0xc93640000000ULL,
    0x35cf9a0000000ULL,
    0x26741d0000000ULL,
    0x13dd28000000ULL,
    0xb30f654000000ULL,
    0xc7111a2000000ULL,
    0x500c5d1000000ULL,
    0xcb92b2a800000ULL,
    0xd348556400000ULL,
    0xd030022a00000ULL,
    0x2d1b393f00000ULL,
    0x269f288380000ULL,
    0xa359485fc0000ULL,
    0x7eb950bca0000ULL,
    0x14cd1c6910000ULL,
    0xe3f7d29348000ULL,
    0x1bfe657c04000ULL,
    0x2c6f9a1ba2000ULL,
    0xf1241d3675000ULL,
    0x5e15d2bd5a800ULL,
    0x18b654028400ULL,
    0xc3531a11b5a00ULL,
    0xd295d2dfb100ULL,
    0x5386329739580ULL,
    0x21c1154ffd8c0ULL,
    0x77e1e2117fe60ULL,
    0xbf744926dbc90ULL,
    0x50b95083e8be8ULL,
    0xbbcd1c6b158b4ULL,
    0x1977d2a5ea12aULL,
    0xd3be657af0505ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x1000000000000ULL,
    0x1800000000000ULL,
    0x3c00000000000ULL,
    0x6a00000000000ULL,
    0xdd00000000000ULL,
    0xdc80000000000ULL,
    0xf6c0000000000ULL,
    0xf9a0000000000ULL,
    0x9e10000000000ULL,
    0xfbd8000000000ULL,
    0x2e94000000000ULL,
    0xdf1e000000000ULL,
    0x4637000000000ULL,
    0xff8e800000000ULL,
    0xb22fc00000000ULL,
    0xa23b600000000ULL,
    0xb2e2900000000ULL,
    0xe7f2880000000ULL,
    0xd7aef40000000ULL,
    0x7e7cfe0000000ULL,
    0x7a81590000000ULL,
    0x89c21e8000000ULL,
    0xbc20cfc000000ULL,
    0xf2527e2000000ULL,
    0x5bbe993000000ULL,
    0x74a17e9800000ULL,
    0xfa965fc400000ULL,
    0x411ef62600000ULL,
    0xb5376d3f00000ULL,
    0xb80b008280000ULL,
    0x376cc6f340000ULL,
    0x90d9889120000ULL,
    0x951232c2b0000ULL,
    0x505d769ce8000ULL,
    0xb9d76be4c4000ULL,
    0x1cf96837d6000ULL,
    0xcf44a40d15000ULL,
    0x5fe3960d2f800ULL,
    0x9376fd0a49c00ULL,
    0x756908aab5a00ULL,
    0xd9daf2e2def00ULL,
    0x779096ac81580ULL,
    0x259e3be041640ULL,
    0xff68009a1020ULL,
    0x23abc03cf14d0ULL,
    0x507d601e48678ULL,
    0xe1819004b4324ULL,
    0xfa420831de05aULL,
    0x7766341400befULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0xb000000000000ULL,
    0x7800000000000ULL,
    0xe400000000000ULL,
    0xde00000000000ULL,
    0x8b00000000000ULL,
    0x4480000000000ULL,
    0xdcc0000000000ULL,
    0xeb20000000000ULL,
    0xb070000000000ULL,
    0xb0e8000000000ULL,
    0x8f4000000000ULL,
    0xa62a000000000ULL,
    0x2ed3000000000ULL,
    0x8ddf800000000ULL,
    0xa078c00000000ULL,
    0xddcca00000000ULL,
    0xc784300000000ULL,
    0xa443f80000000ULL,
    0x5de5940000000ULL,
    0xc653de0000000ULL,
    0x531f6d0000000ULL,
    0x1a5aed8000000ULL,
    0xcc3c524000000ULL,
    0x1c2c5e2000000ULL,
    0x3bd7ad1000000ULL,
    0xa25e4db800000ULL,
    0x883c626c00000ULL,
    0x922da63e00000ULL,
    0x78d5392900000ULL,
    0x7ad8138f80000ULL,
    0x6ef8cf4ec0000ULL,
    0x2c0c6baf20000ULL,
    0x7219b5e30000ULL,
    0x5271159548000ULL,
    0x51edc672dc000ULL,
    0xd175803b1a000ULL,
    0x296bc0300d000ULL,
    0x67b32002c2800ULL,
    0x5f4cf01068c00ULL,
    0x84475837ede00ULL,
    0x4de5a406d3300ULL,
    0xee52260291a80ULL,
    0x7f1df903b9cc0ULL,
    0x585cb38db51e0ULL,
    0x7d38ff6676550ULL,
    0xdad93999f5f8ULL,
    0x28930f50b3174ULL,
    0xd13f4b9141256ULL,
    0xfad6b79e1819ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x5000000000000ULL,
    0xa800000000000ULL,
    0x2c00000000000ULL,
    0xa00000000000ULL,
    0xd00000000000ULL,
    0xd80000000000ULL,
    0xf340000000000ULL,
    0x4960000000000ULL,
    0x5330000000000ULL,
    0x2ae8000000000ULL,
    0x6ab4000000000ULL,
    0x67ae000000000ULL,
    0x50d1000000000ULL,
    0xea1c800000000ULL,
    0x7fc400000000ULL,
    0x1c09e00000000ULL,
    0x83c2100000000ULL,
    0x8fa0880000000ULL,
    0xcd12fc0000000ULL,
    0x46b9520000000ULL,
    0xbc6a570000000ULL,
    0xb765b8000000ULL,
    0xa908484000000ULL,
    0x6a45d22000000ULL,
    0xaae6173000000ULL,
    0x7b77bba800000ULL,
    0x910e585400000ULL,
    0x4e435a0a00000ULL,
    0xdce1eb3b00000ULL,
    0xd47469aa80000ULL,
    0xbd8d4f5740000ULL,
    0xba86618960000ULL,
    0x6bc2f347d0000ULL,
    0xc3a25398d8000ULL,
    0x3712f4738c000ULL,
    0xb3bb602bda000ULL,
    0x35ef50097d000ULL,
    0xde35e80b33800ULL,
    0xe76cac1cb8400ULL,
    0x39f03a1bdd200ULL,
    0x7ecabb2fc2100ULL,
    0xabe7818d51f80ULL,
    0xecf4e35f98c40ULL,
    0x674cdba2ed020ULL,
    0x76a108700aaf0ULL,
    0xde96b21fa5ac8ULL,
    0x96fd4731bf51cULL,
    0x838c538ae314eULL,
    0x983f44960fd1ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0xb000000000000ULL,
    0xe800000000000ULL,
    0xcc00000000000ULL,
    0xba00000000000ULL,
    0x1d00000000000ULL,
    0x6c80000000000ULL,
    0x3740000000000ULL,
    0x6e0000000000ULL,
    0x9ad0000000000ULL,
    0x3dd8000000000ULL,
    0xcc54000000000ULL,
    0x579a000000000ULL,
    0x4633000000000ULL,
    0x4a0f800000000ULL,
    0x950c400000000ULL,
    0xd08de00000000ULL,
    0x454b900000000ULL,
    0x47ea080000000ULL,
    0x345d740000000ULL,
    0xa394f20000000ULL,
    0xa83f230000000ULL,
    0xe907f48000000ULL,
    0x28125c000000ULL,
    0x5443722000000ULL,
    0xb167631000000ULL,
    0x8e1014b800000ULL,
    0xb1f9b5ec00000ULL,
    0xb1a6fa1a00000ULL,
    0xdc36572300000ULL,
    0x4709069680000ULL,
    0x418d06eb40000ULL,
    0x73cb068120000ULL,
    0xddaa06eed0000ULL,
    0xb63e86b738000ULL,
    0xc20546ddf4000ULL,
    0x2904e6b656000ULL,
    0xa28696f1c5000ULL,
    0x4410e98de800ULL,
    0xe96772ff78c00ULL,
    0xaa12748a55e00ULL,
    0xc7fe65d3c6100ULL,
    0x16a11237ddf80ULL,
    0xadb0b323fa240ULL,
    0x1ccffcba17620ULL,
    0x702b51e8654d0ULL,
    0xeffa00284ec48ULL,
    0x7aa30016e0eccULL,
    0x47b7802fb01f2ULL,
    0x59c8400a49c47ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0xd000000000000ULL,
    0x1800000000000ULL,
    0x2c00000000000ULL,
    0x6200000000000ULL,
    0x4b00000000000ULL,
    0xbd80000000000ULL,
    0x5cc0000000000ULL,
    0xb420000000000ULL,
    0x3190000000000ULL,
    0xee88000000000ULL,
    0x7e14000000000ULL,
    0x414e000000000ULL,
    0xebb7000000000ULL,
    0x8618800000000ULL,
    0xce1fc00000000ULL,
    0x3a1de00000000ULL,
    0x141ad00000000ULL,
    0xed1cb80000000ULL,
    0x399bc0000000ULL,
    0xcede9e0000000ULL,
    0x443d7d0000000ULL,
    0x8a8c028000000ULL,
    0xe810514000000ULL,
    0x244e1e2000000ULL,
    0xaf36bd3000000ULL,
    0x345fe29800000ULL,
    0xb77d817400000ULL,
    0x816a262600000ULL,
    0x3420c13b00000ULL,
    0xf1949c8080000ULL,
    0x8e8e2c66c0000ULL,
    0xae149c8960000ULL,
    0x594e2c6c30000ULL,
    0xc7b49c8d88000ULL,
    0xe41e2c5aa4000ULL,
    0x851c9caac2000ULL,
    0x879a2c47b5000ULL,
    0x48da9c9bdb800ULL,
    0x59392c6b49c00ULL,
    0x320c1c93c4200ULL,
    0x2051ec66f2f00ULL,
    0x3a297cba3cf80ULL,
    0xcbc4fc797f740ULL,
    0x3a024858b0e0ULL,
    0xa253906a709f0ULL,
    0x612c02b2295f8ULL,
    0xe405177f52b4ULL,
    0xa3661e377b8eaULL,
    0x6c72bd2a994b5ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0xd000000000000ULL,
    0x9800000000000ULL,
    0xb400000000000ULL,
    0xb200000000000ULL,
    0xf900000000000ULL,
    0x2d80000000000ULL,
    0xa240000000000ULL,
    0xd3e0000000000ULL,
    0x3930000000000ULL,
    0xaf98000000000ULL,
    0x9eb4000000000ULL,
    0xd0da000000000ULL,
    0x6ad5000000000ULL,
    0xd6ac800000000ULL,
    0x1129c00000000ULL,
    0x9e6d200000000ULL,
    0x220e500000000ULL,
    0x87be80000000ULL,
    0x7581bc0000000ULL,
    0x76463a0000000ULL,
    0x91e4830000000ULL,
    0x8831638000000ULL,
    0xae19b7c000000ULL,
    0x3af2ba2000000ULL,
    0x4839431000000ULL,
    0x8766438800000ULL,
    0xf6f2e7f400000ULL,
    0xfe3dd20600000ULL,
    0xa4653f3d00000ULL,
    0xde7759a480000ULL,
    0xeffd34ca40000ULL,
    0x2ac3d98d60000ULL,
    0x5220f4d590000ULL,
    0xf94f9b078000ULL,
    0x47cba4d40c000ULL,
    0x54db91ae86000ULL,
    0xf0d7d8c63d000ULL,
    0xf3aa8ba24e800ULL,
    0x72a80be3b9400ULL,
    0x5b2c8037ad200ULL,
    0x2369c03c37700ULL,
    0xf58d202eb5c80ULL,
    0x7f3e5013aad40ULL,
    0x8de3e8294bda0ULL,
    0xa635bc0b1b1f0ULL,
    0x391c3a36c2468ULL,
    0xa07183097ef4cULL,
    0xa0fde3b5f102eULL,
    0x244077e96832fULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x7000000000000ULL,
    0x3800000000000ULL,
    0x7400000000000ULL,
    0x200000000000ULL,
    0x4d00000000000ULL,
    0x9c80000000000ULL,
    0xdfc0000000000ULL,
    0x40e0000000000ULL,
    0x3030000000000ULL,
    0x938000000000ULL,
    0x82b4000000000ULL,
    0x7dfe000000000ULL,
    0x79d5000000000ULL,
    0x7f8d800000000ULL,
    0x3d4cc00000000ULL,
    0x692a200000000ULL,
    0xeadad00000000ULL,
    0xa501480000000ULL,
    0x6081b40000000ULL,
    0xb1c4760000000ULL,
    0xbe7130000000ULL,
    0xdbb7678000000ULL,
    0x737f72c000000ULL,
    0x8311f62000000ULL,
    0x9fefd33000000ULL,
    0x9cbb478800000ULL,
    0x1bf4a2dc00000ULL,
    0x8bdb3e2e00000ULL,
    0xdf83a72d00000ULL,
    0x9846918880000ULL,
    0x1ca0a1cf40000ULL,
    0x3692b18920000ULL,
    0x76af71daf0000ULL,
    0x529e79b8b8000ULL,
    0xc9a205f34c000ULL,
    0x6e102f836e000ULL,
    0xb36fc6e65d000ULL,
    0x5b7e0029c7800ULL,
    0x5f15003039400ULL,
    0x81ed803c0d600ULL,
    0xefbcc00a4e300ULL,
    0x8472203cad080ULL,
    0xf39ed0117ff40ULL,
    0x9327480375320ULL,
    0xe6d0b41f625d0ULL,
    0x260ff61c12158ULL,
    0x120ad33d6b30cULL,
    0xf00ec78d476beULL,
    0xed0c62f978c1bULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0xf000000000000ULL,
    0x2800000000000ULL,
    0xc00000000000ULL,
    0x200000000000ULL,
    0x3900000000000ULL,
    0xa580000000000ULL,
    0x1b40000000000ULL,
    0x3ca0000000000ULL,
    0xb250000000000ULL,
    0xd578000000000ULL,
    0x61d4000000000ULL,
    0xe13e000000000ULL,
    0xc7f5000000000ULL,
    0x2aa9800000000ULL,
    0x83ec400000000ULL,
    0x4e4de00000000ULL,
    0x859a500000000ULL,
    0x91a5280000000ULL,
    0xd1d4fc0000000ULL,
    0x293eb20000000ULL,
    0x1bf6790000000ULL,
    0xf0abb08000000ULL,
    0x9eeedac000000ULL,
    0xe5cf322000000ULL,
    0xa5de393000000ULL,
    0x3180508800000ULL,
    0xdd458afc00000ULL,
    0xdba59a2a00000ULL,
    0xf4d7853300000ULL,
    0x76bc828880000ULL,
    0xedb4e3f240000ULL,
    0x4f89628360000ULL,
    0xfab3f5d0000ULL,
    0x92924aa7a8000ULL,
    0xf19b4feed4000ULL,
    0x87a578be3e000ULL,
    0xeed176d1a5000ULL,
    0x4bbb2815e7800ULL,
    0xb631fc1c29400ULL,
    0x47cf321414600ULL,
    0xacde390f1e100ULL,
    0x9c00508714f80ULL,
    0x3a058af79fd40ULL,
    0xcd059a1d552a0ULL,
    0x73878518ff2f0ULL,
    0x44482ba85548ULL,
    0xae20e3d8574a4ULL,
    0x379762bad0462ULL,
    0x6e1fb3c529d9bULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0xf000000000000ULL,
    0x8800000000000ULL,
    0xc00000000000ULL,
    0x4600000000000ULL,
    0x6300000000000ULL,
    0x7a80000000000ULL,
    0xf2c0000000000ULL,
    0x68e0000000000ULL,
    0x9cd0000000000ULL,
    0x5798000000000ULL,
    0x554000000000ULL,
    0x9fda000000000ULL,
    0xbf75000000000ULL,
    0x9bed800000000ULL,
    0xfc39400000000ULL,
    0xc521e00000000ULL,
    0x20b5700000000ULL,
    0x868df80000000ULL,
    0x7eae240000000ULL,
    0x139eae0000000ULL,
    0x2f55c30000000ULL,
    0x6aded88000000ULL,
    0xdef7f7c000000ULL,
    0x97a92e2000000ULL,
    0x2c19831000000ULL,
    0x1412b88800000ULL,
    0xf27bc7fc00000ULL,
    0x5c05360200000ULL,
    0x7e02d71300000ULL,
    0xc701ee9980000ULL,
    0xc08020e4c0000ULL,
    0x5fc5409ca0000ULL,
    0x7d60e3efb0000ULL,
    0x52961823b8000ULL,
    0xaebe5413f4000ULL,
    0x8be6d62146000ULL,
    0xa656a702e5000ULL,
    0x855b968e4e800ULL,
    0x9db244d329400ULL,
    0x8b0f8e9c3d600ULL,
    0xe4ed10ca2b500ULL,
    0xd8bed8ba26f80ULL,
    0xe7f7d0741c0ULL,
    0xd12e02861e0ULL,
    0x499d8329c4d90ULL,
    0x1250b8bc3f538ULL,
    0x275ac7cab06ccULL,
    0x64b2b63739282ULL,
    0xac8e970fb564fULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x3000000000000ULL,
    0x4800000000000ULL,
    0x9400000000000ULL,
    0x7200000000000ULL,
    0xfb00000000000ULL,
    0xa280000000000ULL,
    0x4f40000000000ULL,
    0x4220000000000ULL,
    0x5210000000000ULL,
    0xc758000000000ULL,
    0x394000000000ULL,
    0x1e9e000000000ULL,
    0x2cf7000000000ULL,
    0x8daf800000000ULL,
    0xc73d400000000ULL,
    0xe027200000000ULL,
    0x1114d00000000ULL,
    0xd9d9f80000000ULL,
    0x9ad1440000000ULL,
    0x9dbd420000000ULL,
    0xb367350000000ULL,
    0xd533228000000ULL,
    0x32cfa7c000000ULL,
    0x4c0cc22000000ULL,
    0xe7ed753000000ULL,
    0xd29b829800000ULL,
    0x12f637cc00000ULL,
    0x88aa1a3200000ULL,
    0xbce11500000ULL,
    0x58e1388480000ULL,
    0xa3f746f2c0000ULL,
    0xad2bfa9aa0000ULL,
    0x5b7933c6d0000ULL,
    0xa481f83408000ULL,
    0x3645441644000ULL,
    0x33a3421376000ULL,
    0x1bd0353a35000ULL,
    0xf03ca299af800ULL,
    0x7ca2e7c479c00ULL,
    0x5b53e2069de00ULL,
    0x5c7da52c3a500ULL,
    0x70047a9f86480ULL,
    0xe80473c42cf40ULL,
    0xc406d806439e0ULL,
    0xa0194161a010ULL,
    0x2702ba2d97188ULL,
    0x4485711184394ULL,
    0xc647e09d56d6aULL,
    0x1ba6d2e62528fULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0xf000000000000ULL,
    0xc800000000000ULL,
    0xec00000000000ULL,
    0x200000000000ULL,
    0x7700000000000ULL,
    0x2f80000000000ULL,
    0x3c0000000000ULL,
    0x6360000000000ULL,
    0x9470000000000ULL,
    0xc9f8000000000ULL,
    0x14f4000000000ULL,
    0x51ba000000000ULL,
    0x8255000000000ULL,
    0x7ad800000000ULL,
    0xa15b400000000ULL,
    0x6fe6e00000000ULL,
    0xde35500000000ULL,
    0x105a580000000ULL,
    0x4964ac0000000ULL,
    0x9f70860000000ULL,
    0xfc7c170000000ULL,
    0xb434958000000ULL,
    0x3b5bd0c000000ULL,
    0x8ce7062000000ULL,
    0xf7b2571000000ULL,
    0x7a9ff58800000ULL,
    0xb885c0fc00000ULL,
    0xbc43be1200000ULL,
    0x78a7ab2b00000ULL,
    0x23172b8880000ULL,
    0x7b8c7be1c0000ULL,
    0x44082d99e0000ULL,
    0x1fca2cebf0000ULL,
    0x88add83058000ULL,
    0xcadaec14dc000ULL,
    0x5223e6039e000ULL,
    0xf0560702cd000ULL,
    0xf8aa2dbe36800ULL,
    0x42db2ce349400ULL,
    0x9e225818f5600ULL,
    0x250ac205bd00ULL,
    0x47aa8614af380ULL,
    0x8159170ef4140ULL,
    0x9fe1159d5bf60ULL,
    0x163490e12efb0ULL,
    0xfc5be63ab5198ULL,
    0x4b620720fa11cULL,
    0xe8702dbf7e536ULL,
    0xd3fe2ce8bc4f3ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x5000000000000ULL,
    0x800000000000ULL,
    0xc400000000000ULL,
    0xea00000000000ULL,
    0x1500000000000ULL,
    0x1780000000000ULL,
    0x2cc0000000000ULL,
    0x6be0000000000ULL,
    0x550000000000ULL,
    0x3428000000000ULL,
    0xf3d4000000000ULL,
    0x5d6e000000000ULL,
    0x1df5000000000ULL,
    0x525c800000000ULL,
    0x334d400000000ULL,
    0xd2c6a00000000ULL,
    0x5ce0100000000ULL,
    0xe3d5080000000ULL,
    0xb56d2c0000000ULL,
    0xa9f3ae0000000ULL,
    0xe05c930000000ULL,
    0xea4bb48000000ULL,
    0xeb426a4000000ULL,
    0x8f212e2000000ULL,
    0x8ab4d33000000ULL,
    0x8b79948800000ULL,
    0xdafb3a5400000ULL,
    0x7d3c862200000ULL,
    0x865cef0100000ULL,
    0x314bb2b280000ULL,
    0x73c3c55140000ULL,
    0xf9643ca7e0000ULL,
    0x1613064a30000ULL,
    0xe70ea00878000ULL,
    0x7f64102014000ULL,
    0xbd130802ea000ULL,
    0x278c2c12c5000ULL,
    0xc5212e3523800ULL,
    0xfb4d33269400ULL,
    0xb4f994a6fd200ULL,
    0x623b3a7e56500ULL,
    0xf4dc861cf2280ULL,
    0x520cef2a21440ULL,
    0xf8e3b2b390620ULL,
    0xb9d7c548291b0ULL,
    0xd86a3ca69cc38ULL,
    0x22760655a760cULL,
    0xea9a20132b0f2ULL,
    0xbaad503d65c19ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x3000000000000ULL,
    0x4800000000000ULL,
    0x9400000000000ULL,
    0x2600000000000ULL,
    0xdd00000000000ULL,
    0xe380000000000ULL,
    0xf340000000000ULL,
    0x4760000000000ULL,
    0x5930000000000ULL,
    0x1988000000000ULL,
    0x1bb4000000000ULL,
    0xab4e000000000ULL,
    0xcc93000000000ULL,
    0x679f800000000ULL,
    0x66e9400000000ULL,
    0xbe87200000000ULL,
    0xd0c2700000000ULL,
    0x5424c80000000ULL,
    0x2e55ec0000000ULL,
    0x8bf920000000ULL,
    0x963cb70000000ULL,
    0x96f88b8000000ULL,
    0xbade034000000ULL,
    0x488e122000000ULL,
    0xf236f73000000ULL,
    0x9f082bb800000ULL,
    0x3771334c00000ULL,
    0x9d6bfa3200000ULL,
    0x61c66b1500000ULL,
    0x8da2f1b180000ULL,
    0x5212287b40000ULL,
    0x675c438ae0000ULL,
    0x4acbef69d0000ULL,
    0x4cd1800058000ULL,
    0x6a7a401d0c000ULL,
    0x3918a01482000ULL,
    0x862b30133d000ULL,
    0xa2a3e8208b800ULL,
    0x6a979c3728c00ULL,
    0x7a9b5a2ee5e00ULL,
    0x65695b14c7500ULL,
    0x7dc719ac4a480ULL,
    0xdfa2b46d885c0ULL,
    0x991699bb54d20ULL,
    0x11d8f4728e2b0ULL,
    0xce0e39993fac8ULL,
    0xdef3c4587671cULL,
    0xa92dd1898370eULL,
    0x9a245856bc6bdULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0xf000000000000ULL,
    0x8800000000000ULL,
    0x2400000000000ULL,
    0x8600000000000ULL,
    0xd500000000000ULL,
    0x3f80000000000ULL,
    0xddc0000000000ULL,
    0xa260000000000ULL,
    0xb610000000000ULL,
    0xe8d8000000000ULL,
    0xa094000000000ULL,
    0x909a000000000ULL,
    0x35000000000ULL,
    0x3c6d800000000ULL,
    0x67b9400000000ULL,
    0xc500a00000000ULL,
    0x2783700000000ULL,
    0xa1c1080000000ULL,
    0x78660c0000000ULL,
    0x4915260000000ULL,
    0xa059ff0000000ULL,
    0x11d5c68000000ULL,
    0x5bf01c000000ULL,
    0xf602a62000000ULL,
    0x1d05bf1000000ULL,
    0x3b80e68800000ULL,
    0xabc131fc00000ULL,
    0xff610e0200000ULL,
    0xad91c31900000ULL,
    0xb31b48a980000ULL,
    0xd7f682c940000ULL,
    0x190ece8de0000ULL,
    0x352c0dee70000ULL,
    0x3e9a002118000ULL,
    0x41350034c4000ULL,
    0x2ded801fd6000ULL,
    0xbb79402a55000ULL,
    0x56e0a00f3e800ULL,
    0xbd537011c9400ULL,
    0x52f9081b4d600ULL,
    0x66220c33fb500ULL,
    0xacb726321ea80ULL,
    0x6b28ff13199c0ULL,
    0xf79a46b5c5220ULL,
    0x74b741c256d30ULL,
    0x772d861d15e18ULL,
    0xfd9e8f19dee3cULL,
    0xf3b6ce8f38d3aULL,
    0x93a80dfa95537ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0xd000000000000ULL,
    0xd800000000000ULL,
    0x6c00000000000ULL,
    0x5200000000000ULL,
    0x2b00000000000ULL,
    0x5580000000000ULL,
    0x9bc0000000000ULL,
    0x5660000000000ULL,
    0x1870000000000ULL,
    0x98a8000000000ULL,
    0x74f4000000000ULL,
    0x9dee000000000ULL,
    0x1cd5000000000ULL,
    0x4038800000000ULL,
    0x7e6bc00000000ULL,
    0x8a17e00000000ULL,
    0x76db500000000ULL,
    0x159b80000000ULL,
    0x799a7c0000000ULL,
    0xee7b260000000ULL,
    0x83cc6f0000000ULL,
    0xec04958000000ULL,
    0x9201a24000000ULL,
    0xb05a62000000ULL,
    0x8586af3000000ULL,
    0x43c5f58800000ULL,
    0x3a64327400000ULL,
    0x4a737e1600000ULL,
    0xb3ac432b00000ULL,
    0x21708b9c80000ULL,
    0x629717ec0000ULL,
    0x4ab5758360000ULL,
    0x584bf24df0000ULL,
    0xe6c29e2918000ULL,
    0xfee61308dc000ULL,
    0xeb37b38d4a000ULL,
    0x1d89cd54cd000ULL,
    0x39a733b063800ULL,
    0x90160d60e9400ULL,
    0x9ded39fc4200ULL,
    0x9ad85d6a97f00ULL,
    0x935feb9b06780ULL,
    0x7299e1656f940ULL,
    0x6bfb2da96a4e0ULL,
    0xc00ade4f1d6f0ULL,
    0xd6600007aab18ULL,
    0xd87000147d8fcULL,
    0xb8a800265aeb6ULL,
    0xa4f4002765479ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0xd000000000000ULL,
    0x8800000000000ULL,
    0x4400000000000ULL,
    0xf600000000000ULL,
    0xef00000000000ULL,
    0x4780000000000ULL,
    0x38c0000000000ULL,
    0x8fe0000000000ULL,
    0x2070000000000ULL,
    0xcc78000000000ULL,
    0x96f4000000000ULL,
    0x283e000000000ULL,
    0xe855000000000ULL,
    0x4c68800000000ULL,
    0xf639400000000ULL,
    0x5356a00000000ULL,
    0x55ecf00000000ULL,
    0xb5fed80000000ULL,
    0xe5354c0000000ULL,
    0xe65fde0000000ULL,
    0x47e0530000000ULL,
    0x8474cd8000000ULL,
    0xca7838c000000ULL,
    0x21f15e2000000ULL,
    0xa3b8133000000ULL,
    0x6294ed8800000ULL,
    0xda8888f400000ULL,
    0x7ec9a60200000ULL,
    0xe06cef2100000ULL,
    0x743d4bb580000ULL,
    0x325467cfc0000ULL,
    0xe16ced93e0000ULL,
    0xf0bc88ef30000ULL,
    0xf17a63678000ULL,
    0x1749ef37dc000ULL,
    0x3badcb88fe000ULL,
    0x2e5927ce8d000ULL,
    0xe3e44d9677800ULL,
    0x827578e8c9400ULL,
    0x7d79fe2464200ULL,
    0xaa71e329c3500ULL,
    0x297ab586c2280ULL,
    0xf47084cc427c0ULL,
    0x527ed81103960ULL,
    0xcdf54c33a2030ULL,
    0xc1bfde3033df8ULL,
    0xf390531adb68cULL,
    0x360ccd856f256ULL,
    0xf78c38db644d3ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x5000000000000ULL,
    0x3800000000000ULL,
    0xfc00000000000ULL,
    0xc200000000000ULL,
    0x2700000000000ULL,
    0x3280000000000ULL,
    0x8ac0000000000ULL,
    0x8420000000000ULL,
    0x17d0000000000ULL,
    0xf698000000000ULL,
    0x4454000000000ULL,
    0x77de000000000ULL,
    0x2d33000000000ULL,
    0x136c800000000ULL,
    0x341ac00000000ULL,
    0x8697600000000ULL,
    0x87fed00000000ULL,
    0x6ce7580000000ULL,
    0xc4f2c40000000ULL,
    0x5bcc4e0000000ULL,
    0xac0ac50000000ULL,
    0xb1a8008000000ULL,
    0x5439d9c000000ULL,
    0x1f46ce2000000ULL,
    0xfc67053000000ULL,
    0xf935e0b800000ULL,
    0x356ac9d400000ULL,
    0x9d1c762e00000ULL,
    0x3916d10f00000ULL,
    0xdcbb168880000ULL,
    0x6e85d8ddc0000ULL,
    0x38c480a2a0000ULL,
    0x2b2319edb0000ULL,
    0xb151ae0988000ULL,
    0x7a59d52834000ULL,
    0xd972b88706000ULL,
    0xb7880dd8a5000ULL,
    0x44e838227f800ULL,
    0x6b58140878c00ULL,
    0x5af5163d5d200ULL,
    0xcecb012363b00ULL,
    0x3188ce9ffa580ULL,
    0x9de9dcf2f7740ULL,
    0x5cd9ae93ccf60ULL,
    0x95b00cd11b010ULL,
    0xcaac7683a74b8ULL,
    0xd4bb08d614c54ULL,
    0x3a83d89977762ULL,
    0xdec1ddfc8cb77ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x1000000000000ULL,
    0x1800000000000ULL,
    0x6c00000000000ULL,
    0xaa00000000000ULL,
    0x8100000000000ULL,
    0x5080000000000ULL,
    0xdac0000000000ULL,
    0xf320000000000ULL,
    0xdd50000000000ULL,
    0x15b8000000000ULL,
    0xf2d4000000000ULL,
    0x8fe000000000ULL,
    0x18b1000000000ULL,
    0x51ce800000000ULL,
    0x1b39c00000000ULL,
    0xaf11e00000000ULL,
    0x205e900000000ULL,
    0xdea6e80000000ULL,
    0x2511940000000ULL,
    0x715c7e0000000ULL,
    0x3627ad0000000ULL,
    0x83d7a48000000ULL,
    0x307fd8c000000ULL,
    0x674fe2000000ULL,
    0x6ceb6d3000000ULL,
    0x996ec4a800000ULL,
    0xad2d88c400000ULL,
    0x73cb762600000ULL,
    0x2e38a92b00000ULL,
    0x9995328280000ULL,
    0xc19de1e440000ULL,
    0xe40124b220000ULL,
    0x1e0218ddb0000ULL,
    0xe7031e1e48000ULL,
    0x6b80fd2314000ULL,
    0x1340acbf4e000ULL,
    0x1560dcd505000ULL,
    0x5eb6683277800ULL,
    0xbac9543a38400ULL,
    0x6abb1e07bda00ULL,
    0x3554fd288b700ULL,
    0x11beac8713f80ULL,
    0x9cd1dcd4dfe40ULL,
    0x47f8e810fc1a0ULL,
    0x173094142b150ULL,
    0x9c8afe0ce2e78ULL,
    0x495a6d0db70f4ULL,
    0x8a2044bbd8732ULL,
    0x91d448e9eda33ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x5000000000000ULL,
    0xa800000000000ULL,
    0xec00000000000ULL,
    0x3200000000000ULL,
    0xb700000000000ULL,
    0x1180000000000ULL,
    0x640000000000ULL,
    0x7b60000000000ULL,
    0x5b30000000000ULL,
    0x5a8000000000ULL,
    0x1d74000000000ULL,
    0xdece000000000ULL,
    0x7647000000000ULL,
    0x2364800000000ULL,
    0x2f36400000000ULL,
    0x23ade00000000ULL,
    0xdc70d00000000ULL,
    0xa64cd80000000ULL,
    0xe4861c0000000ULL,
    0xf8c10a0000000ULL,
    0x18a5170000000ULL,
    0x170b8000000ULL,
    0xe4ff264000000ULL,
    0x3b6cea2000000ULL,
    0x54d5c73000000ULL,
    0x6e5bd39800000ULL,
    0xbc793a5400000ULL,
    0x59ade00a00000ULL,
    0x1770d00b00000ULL,
    0x4dccd81480000ULL,
    0xe9c61c39c0000ULL,
    0x8210a2e60000ULL,
    0x1ed5173a90000ULL,
    0x5d5f0b9258000ULL,
    0x13fb267b0c000ULL,
    0x8aeaea250a000ULL,
    0x6296c736cd000ULL,
    0xed3953b16b800ULL,
    0xa34c7a5f5dc00ULL,
    0x82028003b3200ULL,
    0x8f05400790900ULL,
    0x3587602bd8f80ULL,
    0x884190134df40ULL,
    0x5665b80f2a160ULL,
    0x11b08c087c170ULL,
    0x20683224833a8ULL,
    0xd757db0a3971cULL,
    0xef1cd9ac9cf4eULL,
    0x2e9f2d46d34e9ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0xd000000000000ULL,
    0x800000000000ULL,
    0x3c00000000000ULL,
    0xfe00000000000ULL,
    0xed00000000000ULL,
    0xae80000000000ULL,
    0x5440000000000ULL,
    0xba60000000000ULL,
    0x94f0000000000ULL,
    0xf418000000000ULL,
    0xf0b4000000000ULL,
    0xf67e000000000ULL,
    0x2041000000000ULL,
    0x1860800000000ULL,
    0xf7f5400000000ULL,
    0x6f9f600000000ULL,
    0x3e73b00000000ULL,
    0xda58880000000ULL,
    0x1dd3840000000ULL,
    0x3b0d4a0000000ULL,
    0x999e70000000ULL,
    0x8773658000000ULL,
    0xc6dec3c000000ULL,
    0x82922a2000000ULL,
    0xf6ea573000000ULL,
    0xa5abeda800000ULL,
    0x8e4d47f400000ULL,
    0x5b7f602200000ULL,
    0xeec3b03f00000ULL,
    0x3c20881780000ULL,
    0x9597840f40000ULL,
    0xcf6b4a29a0000ULL,
    0x86ce71a10000ULL,
    0x39ede59118000ULL,
    0xa82a83de7c000ULL,
    0xe18dca36a6000ULL,
    0xffdca7193d000ULL,
    0x5e1405bb07800ULL,
    0xc9a973d92c400ULL,
    0xb84ca2191e200ULL,
    0x2a7cd33ed0500ULL,
    0x6e4027b1f8580ULL,
    0x8d64e0c8ccac0ULL,
    0xbd75e5b92e020ULL,
    0xf1de83d099b10ULL,
    0xab13ca0c3c8a8ULL,
    0xf32da7178695cULL,
    0xfe0c85abecfb6ULL,
    0x8b1833e4fe51fULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x5000000000000ULL,
    0xf800000000000ULL,
    0x1400000000000ULL,
    0xda00000000000ULL,
    0x3300000000000ULL,
    0xcc80000000000ULL,
    0xb740000000000ULL,
    0xae60000000000ULL,
    0xc870000000000ULL,
    0xbd08000000000ULL,
    0xf734000000000ULL,
    0x6f6e000000000ULL,
    0xa941000000000ULL,
    0x7f64800000000ULL,
    0x83f2c00000000ULL,
    0x4cca200000000ULL,
    0x2515100000000ULL,
    0xd1ff380000000ULL,
    0xb179b40000000ULL,
    0xa83ca20000000ULL,
    0x1f5bd70000000ULL,
    0x80aed98000000ULL,
    0xaa640b4000000ULL,
    0x8a76822000000ULL,
    0x6a0ec73000000ULL,
    0x49b1e1a800000ULL,
    0x72dbf5400000ULL,
    0x5a2201e00000ULL,
    0xe951103500000ULL,
    0x6f19381e80000ULL,
    0x84cb418c0000ULL,
    0xee56220d20000ULL,
    0xe9981728d0000ULL,
    0xd408799d18000ULL,
    0xc8b7db7edc000ULL,
    0xb4ad9a3c62000ULL,
    0xe06363201d000ULL,
    0xe176fb9843800ULL,
    0xe28d1c4c4c400ULL,
    0xdcf27bae9b200ULL,
    0x8e4fdc6831b00ULL,
    0xdb505bb669080ULL,
    0xd01ecc4bd5040ULL,
    0xfac963ae86ee0ULL,
    0x1812784072dd0ULL,
    0x547f419225a08ULL,
    0xa9ba6f514fb1cULL,
    0x859f3808b6786ULL,
    0xda09b43b1a6fdULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x7000000000000ULL,
    0x6800000000000ULL,
    0x8c00000000000ULL,
    0xe200000000000ULL,
    0x1900000000000ULL,
    0x8380000000000ULL,
    0x6140000000000ULL,
    0x2560000000000ULL,
    0x9d90000000000ULL,
    0x37b8000000000ULL,
    0xf0d4000000000ULL,
    0xb0da000000000ULL,
    0xd441000000000ULL,
    0x74e1800000000ULL,
    0x2dd6400000000ULL,
    0x6d5fe00000000ULL,
    0x8600500000000ULL,
    0x3706a80000000ULL,
    0xd8860c0000000ULL,
    0x8bc0420000000ULL,
    0xafa6770000000ULL,
    0x55b3868000000ULL,
    0x6d4f86c000000ULL,
    0x43ffa22000000ULL,
    0xf436271000000ULL,
    0xf50d2ea800000ULL,
    0x351d8adc00000ULL,
    0x10e5e03a00000ULL,
    0x3d1503300000ULL,
    0x365f281080000ULL,
    0x6c844c1a40000ULL,
    0xbdc5a23ae0000ULL,
    0x10a7273b50000ULL,
    0xd134aeb1d8000ULL,
    0x1c8fcae124000ULL,
    0x1158000d0e000ULL,
    0x4c04003465000ULL,
    0x202000d6e800ULL,
    0xc905000e74400ULL,
    0x9b83800ad6600ULL,
    0x8543401440900ULL,
    0x4b64600fe1780ULL,
    0x66971012d0540ULL,
    0xad38c83019ca0ULL,
    0x12101c2504130ULL,
    0xf4f90a30ffe88ULL,
    0x6cb02b2d0d89cULL,
    0xdecd6c95434baULL,
    0xeabbfdd14762bULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0xb000000000000ULL,
    0x7800000000000ULL,
    0xbc00000000000ULL,
    0xc200000000000ULL,
    0x4900000000000ULL,
    0x1b80000000000ULL,
    0x12c0000000000ULL,
    0xe20000000000ULL,
    0xa870000000000ULL,
    0x1ff8000000000ULL,
    0x3eb4000000000ULL,
    0x4fde000000000ULL,
    0x4dc3000000000ULL,
    0xcaa3800000000ULL,
    0xbe34c00000000ULL,
    0xe798600000000ULL,
    0xdea1d00000000ULL,
    0xc831a80000000ULL,
    0x4899cc0000000ULL,
    0x42235e0000000ULL,
    0x32756d0000000ULL,
    0xbaff358000000ULL,
    0x2f371ec000000ULL,
    0xd01b3e2000000ULL,
    0x2664bd3000000ULL,
    0xfb169db800000ULL,
    0xfd6ad2ec00000ULL,
    0x781e603e00000ULL,
    0x9266d01f00000ULL,
    0x1d14280880000ULL,
    0x7a6a0c3e40000ULL,
    0x909ebe18e0000ULL,
    0x6e277d2bb0000ULL,
    0xd8737db308000ULL,
    0x87fcc2f85c000ULL,
    0x32b428211e000ULL,
    0xf5da0c3b1d000ULL,
    0xb8c6be287f800ULL,
    0x13237d156cc00ULL,
    0xe5f57dab56e00ULL,
    0xf23bc2cf20300ULL,
    0x6411a83a91980ULL,
    0xd9e9cc0698b40ULL,
    0xde5b5e3e448a0ULL,
    0x12016d151b430ULL,
    0x410135b4e6cf8ULL,
    0x3f841efe292f4ULL,
    0xdcc0be0bcda76ULL,
    0xfd247d3406b4bULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x1000000000000ULL,
    0x1800000000000ULL,
    0x3400000000000ULL,
    0x8a00000000000ULL,
    0xd300000000000ULL,
    0x9080000000000ULL,
    0x78c0000000000ULL,
    0xa6e0000000000ULL,
    0x3130000000000ULL,
    0x1528000000000ULL,
    0xc5f4000000000ULL,
    0xddce000000000ULL,
    0x95c5000000000ULL,
    0xaf66800000000ULL,
    0x2a71c00000000ULL,
    0x4b89200000000ULL,
    0x32e0900000000ULL,
    0x6b31380000000ULL,
    0xfe29d40000000ULL,
    0x7171de0000000ULL,
    0x370f730000000ULL,
    0xd426ef8000000ULL,
    0x84d74e4000000ULL,
    0x9498fe2000000ULL,
    0xb81fe33000000ULL,
    0xa6dfd78800000ULL,
    0x4d3a9a4400000ULL,
    0xa58f202600000ULL,
    0x93e1903d00000ULL,
    0x2cb1b82a80000ULL,
    0x94691430c0000ULL,
    0x50507e2220000ULL,
    0x8e5b231330000ULL,
    0xd1f8778b38000ULL,
    0xb16fca788c000ULL,
    0x55d138016a000ULL,
    0x3b19d41f4d000ULL,
    0xce59de16cb800ULL,
    0x31fb732d3d400ULL,
    0x8168efa893a00ULL,
    0x5dd24e76e1700ULL,
    0x171e7e2711c80ULL,
    0x705e232d09640ULL,
    0x68fef79d35ee0ULL,
    0xc2ee0a6f26050ULL,
    0xb5901801063f8ULL,
    0xc93d443037f8cULL,
    0xe78ee6000ff5eULL,
    0x4ce3a71f02a69ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x3000000000000ULL,
    0x8800000000000ULL,
    0x1c00000000000ULL,
    0x4a00000000000ULL,
    0x4d00000000000ULL,
    0xfc80000000000ULL,
    0x2240000000000ULL,
    0x8b20000000000ULL,
    0x1590000000000ULL,
    0x5cf8000000000ULL,
    0xadd4000000000ULL,
    0x62da000000000ULL,
    0xb0c7000000000ULL,
    0x7a63800000000ULL,
    0x1937400000000ULL,
    0xa0a9600000000ULL,
    0x61ca100000000ULL,
    0x937c880000000ULL,
    0x7810b40000000ULL,
    0xe83bfa0000000ULL,
    0x19b17d0000000ULL,
    0xb8ee9e8000000ULL,
    0x4fef4ec000000ULL,
    0x566a9a2000000ULL,
    0xc4af6d1000000ULL,
    0x9fc8169800000ULL,
    0xd878facc00000ULL,
    0x3b92e00200000ULL,
    0xeff9501700000ULL,
    0x1a57e80a80000ULL,
    0x319a41f40000ULL,
    0x3c26f21d20000ULL,
    0x6c15890f90000ULL,
    0xfe3d84b048000ULL,
    0x7eb063d624000ULL,
    0x39686c881e000ULL,
    0x192ac7f3e5000ULL,
    0xe30f1e827e800ULL,
    0x101b0ef555c00ULL,
    0x9ba27a13a6e00ULL,
    0xd5d13d3638d00ULL,
    0xd6dc7e981cd80ULL,
    0xb6c61eec03440ULL,
    0xc5657215e7c20ULL,
    0x3cb2c91499fd0ULL,
    0x286ce4854ca68ULL,
    0xcfae73ccaadb4ULL,
    0xbc4ee4823285aULL,
    0xefbd73fc7efebULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0xd000000000000ULL,
    0x1800000000000ULL,
    0x2c00000000000ULL,
    0xbe00000000000ULL,
    0xc700000000000ULL,
    0xe280000000000ULL,
    0x1b40000000000ULL,
    0x3be0000000000ULL,
    0xe8d0000000000ULL,
    0x778000000000ULL,
    0x3194000000000ULL,
    0x1d9a000000000ULL,
    0xf0c5000000000ULL,
    0x8d24800000000ULL,
    0x3ef1c00000000ULL,
    0x8d0fe00000000ULL,
    0x84d9300000000ULL,
    0xca21580000000ULL,
    0x9c71e40000000ULL,
    0xb649620000000ULL,
    0x6f3c8b0000000ULL,
    0x3af03c8000000ULL,
    0xb70e74c000000ULL,
    0x39de822000000ULL,
    0xb5a1bb1000000ULL,
    0x28b3648800000ULL,
    0x216e90f400000ULL,
    0x3cc9602600000ULL,
    0xd079f01b00000ULL,
    0xab10382780000ULL,
    0xdadc1405c0000ULL,
    0xbd235a3ea0000ULL,
    0x96f59f0dd0000ULL,
    0x490fe6a178000ULL,
    0xdede2bcbf4000ULL,
    0x872484997e000ULL,
    0x2bf3a0dab5000ULL,
    0x368a38219e800ULL,
    0x6a19142205400ULL,
    0x1007da2c97200ULL,
    0x78045f3cd9700ULL,
    0xdc00068da5780ULL,
    0x76071be7c70c0ULL,
    0xf305dca6e1760ULL,
    0x708244cfb0090ULL,
    0x62435a1089a08ULL,
    0x1e659f221d6ecULL,
    0x1117e6bd12592ULL,
    0x27da2bc38ee43ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0xf000000000000ULL,
    0x9800000000000ULL,
    0xd400000000000ULL,
    0x600000000000ULL,
    0x9100000000000ULL,
    0xb380000000000ULL,
    0xd7c0000000000ULL,
    0x2b60000000000ULL,
    0xef90000000000ULL,
    0x5f18000000000ULL,
    0x3a54000000000ULL,
    0x2b7a000000000ULL,
    0xab43000000000ULL,
    0xaa25800000000ULL,
    0xb6b3c00000000ULL,
    0xb529200000000ULL,
    0x5e38f00000000ULL,
    0xa464280000000ULL,
    0x5910ac0000000ULL,
    0xdd5ab60000000ULL,
    0xa7f3870000000ULL,
    0xc409a28000000ULL,
    0x180e33c000000ULL,
    0xe20b962000000ULL,
    0xd90f771000000ULL,
    0xd98f8ab800000ULL,
    0xb2c99ffc00000ULL,
    0xb8eea00600000ULL,
    0x1e5c302500000ULL,
    0xc372883980000ULL,
    0xd1489c1840000ULL,
    0xa72a3e0ae0000ULL,
    0x693c1b00f0000ULL,
    0x96e41c8b58000ULL,
    0x5556e8dfa4000ULL,
    0x6df92a9b26000ULL,
    0xb101afeb65000ULL,
    0xe386281806800ULL,
    0x5fc7ac3d34c00ULL,
    0x976536234f600ULL,
    0xa593472a39f00ULL,
    0x1c1d028014c80ULL,
    0x1ed103ec1efc0ULL,
    0xde3c9e0ef06a0ULL,
    0xe4642b3a58db0ULL,
    0xb914948424e58ULL,
    0x2d5974cc66ddcULL,
    0x3ff494830562aULL,
    0x100974c036a7fULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0xf000000000000ULL,
    0xc800000000000ULL,
    0xfc00000000000ULL,
    0xfe00000000000ULL,
    0x8100000000000ULL,
    0x3e80000000000ULL,
    0x30c0000000000ULL,
    0x1360000000000ULL,
    0x8a30000000000ULL,
    0xfec8000000000ULL,
    0xf0f4000000000ULL,
    0x2eaa000000000ULL,
    0xdb43000000000ULL,
    0xaf25800000000ULL,
    0xfe91400000000ULL,
    0xd418600000000ULL,
    0xbc4db00000000ULL,
    0x7e35e80000000ULL,
    0x5ccb040000000ULL,
    0x9ff10e0000000ULL,
    0xa92aaf0000000ULL,
    0xe107778000000ULL,
    0x8e82fd4000000ULL,
    0x18c16e2000000ULL,
    0x1f631f1000000ULL,
    0xbc309fb800000ULL,
    0x83cef97c00000ULL,
    0x3077e01200000ULL,
    0x9f6ff02f00000ULL,
    0xf6a0080780000ULL,
    0x15d3f41c40000ULL,
    0x133e863da0000ULL,
    0xaedb1b3330000ULL,
    0x6c2c11bb58000ULL,
    0x55811642cc000ULL,
    0xdd42f79012000ULL,
    0xba23bd600d000ULL,
    0xd2110e1772800ULL,
    0xa3daaf385cc00ULL,
    0x24af779e7b600ULL,
    0xf846fd4099500ULL,
    0xfea36e132c980ULL,
    0x49d41f1683ac0ULL,
    0xfd3f1fbc641a0ULL,
    0x17dcb978e6910ULL,
    0x66aa000b825b8ULL,
    0x67430004e5c7cULL,
    0xb125801b26a7eULL,
    0x8f914036637e5ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0xd000000000000ULL,
    0x4800000000000ULL,
    0xc400000000000ULL,
    0xf200000000000ULL,
    0x7300000000000ULL,
    0x2480000000000ULL,
    0x1dc0000000000ULL,
    0xe760000000000ULL,
    0x2d70000000000ULL,
    0x178000000000ULL,
    0x5eb4000000000ULL,
    0x4b1a000000000ULL,
    0x2243000000000ULL,
    0x6a24800000000ULL,
    0x5dd5400000000ULL,
    0xe468a00000000ULL,
    0x2839d00000000ULL,
    0x4c13b80000000ULL,
    0x750bb40000000ULL,
    0x644ef60000000ULL,
    0xcaecdf0000000ULL,
    0x5afce58000000ULL,
    0x11f100c000000ULL,
    0xd0be562000000ULL,
    0x6fd10f1000000ULL,
    0x376d5db800000ULL,
    0x3cbdb4f400000ULL,
    0xc9d6203200000ULL,
    0x1e6f902100000ULL,
    0x7f3f980480000ULL,
    0x4a972428c0000ULL,
    0x53cdee1b20000ULL,
    0x63aabb3670000ULL,
    0x85bab8558000ULL,
    0xcfe56bd79c000ULL,
    0x46b0c5a97e000ULL,
    0x871d90c0dd000ULL,
    0xf4454e331e800ULL,
    0x3b236b27ccc00ULL,
    0x425013b0d7200ULL,
    0x192adfc5d8500ULL,
    0x209c33a55ca80ULL,
    0xf5064fff5eb40ULL,
    0x7d872ba42dce0ULL,
    0x26442bf587bd0ULL,
    0x3822659af1958ULL,
    0x1ed740e19943cULL,
    0x58ea760abdd76ULL,
    0xb9f99f0c0fad3ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0xd000000000000ULL,
    0x6800000000000ULL,
    0x2c00000000000ULL,
    0x8e00000000000ULL,
    0x700000000000ULL,
    0x1680000000000ULL,
    0x93c0000000000ULL,
    0x10a0000000000ULL,
    0x9670000000000ULL,
    0xadd8000000000ULL,
    0xffb4000000000ULL,
    0x607e000000000ULL,
    0xd247000000000ULL,
    0x3de0800000000ULL,
    0x5910400000000ULL,
    0x750fe00000000ULL,
    0xab1b300000000ULL,
    0x893580000000ULL,
    0x5049c40000000ULL,
    0x987d260000000ULL,
    0x3647f10000000ULL,
    0x2fe70d8000000ULL,
    0x68157bc000000ULL,
    0x208ac62000000ULL,
    0x8c58c13000000ULL,
    0x2f2559800000ULL,
    0xc71fbff400000ULL,
    0x2691603a00000ULL,
    0xe74c703b00000ULL,
    0x36fc383b80000ULL,
    0xe182b435c0000ULL,
    0x9d419e1fa0000ULL,
    0x7765052ff0000ULL,
    0x9cd173a7a8000ULL,
    0xf6af4ee45c000ULL,
    0xe1eeed8ed6000ULL,
    0x938d4beb1d000ULL,
    0x20df1e2437800ULL,
    0xec3245150dc00ULL,
    0xdc3e13a60e200ULL,
    0xf8a43ed6a9100ULL,
    0x7a72559cdc780ULL,
    0x43dfbfe4970c0ULL,
    0x28b160137cf60ULL,
    0x1efc702366610ULL,
    0x6d843838d4b18ULL,
    0xa346b4193b304ULL,
    0xc8679e1f03156ULL,
    0xce56051ea62ffULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0xd000000000000ULL,
    0xb800000000000ULL,
    0x7400000000000ULL,
    0xae00000000000ULL,
    0x5900000000000ULL,
    0xfa80000000000ULL,
    0x11c0000000000ULL,
    0xdbe0000000000ULL,
    0x45f0000000000ULL,
    0x1578000000000ULL,
    0xd934000000000ULL,
    0xa1a000000000ULL,
    0x4c05000000000ULL,
    0x9a04800000000ULL,
    0xd704c00000000ULL,
    0x7385200000000ULL,
    0x5340b00000000ULL,
    0xbe21680000000ULL,
    0x3012a40000000ULL,
    0x98a460000000ULL,
    0x36cd0b0000000ULL,
    0xc2eca18000000ULL,
    0x9df974c000000ULL,
    0x93f5662000000ULL,
    0x5878bb1000000ULL,
    0x7db1498800000ULL,
    0x2adb10f400000ULL,
    0xa160000e00000ULL,
    0x1430000d00000ULL,
    0xee98002380000ULL,
    0x4cc4002240000ULL,
    0xa7620010a0000ULL,
    0xe131001970000ULL,
    0x3e1e801d78000ULL,
    0xc201c0073c000ULL,
    0x1301a03bfe000ULL,
    0x958470323d000ULL,
    0x164448347e800ULL,
    0x26a214027d400ULL,
    0xa2d32e23df200ULL,
    0xdfebaf038c300ULL,
    0xc17ce79e67c80ULL,
    0xe7317fc7d16c0ULL,
    0xcb1d47a9097a0ULL,
    0x12850fe9c5990ULL,
    0x9dc10fb683d98ULL,
    0x21e31bfd636ecULL,
    0x62f0219933726ULL,
    0xef9b4d27af43ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x7000000000000ULL,
    0x6800000000000ULL,
    0x1c00000000000ULL,
    0x1a00000000000ULL,
    0xb700000000000ULL,
    0x1a80000000000ULL,
    0xedc0000000000ULL,
    0xeaa0000000000ULL,
    0xf970000000000ULL,
    0xd398000000000ULL,
    0x4fb4000000000ULL,
    0x11ba000000000ULL,
    0x1003000000000ULL,
    0x5801800000000ULL,
    0x9404400000000ULL,
    0x7603600000000ULL,
    0xc503900000000ULL,
    0xb185580000000ULL,
    0xed40040000000ULL,
    0xb062d60000000ULL,
    0x957810000000ULL,
    0xc728a58000000ULL,
    0x768dc9c000000ULL,
    0xa77bb62000000ULL,
    0xd227111000000ULL,
    0x7b47db800000ULL,
    0xddbd8ddc00000ULL,
    0xf200003a00000ULL,
    0xeb00001700000ULL,
    0xe080003e80000ULL,
    0x2ac00031c0000ULL,
    0x9820001ca0000ULL,
    0x8b0003c70000ULL,
    0x2338003c28000ULL,
    0x1c400139c000ULL,
    0xd8a2003246000ULL,
    0xb27700289d000ULL,
    0xa31b803ec6800ULL,
    0x7d77403a5cc00ULL,
    0xfd9ae022e6600ULL,
    0x1eb3d036ec100ULL,
    0xd63c3819ee580ULL,
    0x3840943540240ULL,
    0x59e60e3a61360ULL,
    0x7013c51e51110ULL,
    0x14913b1986d8ULL,
    0xbad9d8f315044ULL,
    0xd1d64bbdab7f6ULL,
    0x49eadcf6f3737ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0xb000000000000ULL,
    0x3800000000000ULL,
    0x400000000000ULL,
    0x3600000000000ULL,
    0x2f00000000000ULL,
    0x1e80000000000ULL,
    0x540000000000ULL,
    0x72e0000000000ULL,
    0x3c10000000000ULL,
    0x2218000000000ULL,
    0xaa54000000000ULL,
    0xbc7e000000000ULL,
    0x6a03000000000ULL,
    0x6d03800000000ULL,
    0xdf86c00000000ULL,
    0x80c5a00000000ULL,
    0x6720700000000ULL,
    0x60b1580000000ULL,
    0x4469440000000ULL,
    0x9e1d520000000ULL,
    0x5851630000000ULL,
    0x4578ca8000000ULL,
    0xeb8407c000000ULL,
    0x4ec6f22000000ULL,
    0xac22133000000ULL,
    0xf83212b800000ULL,
    0x562f83ec00000ULL,
    0xf678002e00000ULL,
    0x5704003100000ULL,
    0x3a86003580000ULL,
    0x63470027c0000ULL,
    0xd5e58009a0000ULL,
    0x1e91c00050000ULL,
    0x1558201138000ULL,
    0xc1b5b004c4000ULL,
    0xb1ef780f26000ULL,
    0x53dbf42bc5000ULL,
    0xb0f7aa33a7800ULL,
    0x2d0b571584c00ULL,
    0xf4cf4093c6e00ULL,
    0x826ee0dd74b00ULL,
    0xa918caaf2ee80ULL,
    0x12d407f348dc0ULL,
    0xfe3ef21b6cb60ULL,
    0x8a66133afbe10ULL,
    0x5e5412b1b63c8ULL,
    0x927883e2dc44cULL,
    0x1105802af264aULL,
    0xcd81c0113b50fULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x5000000000000ULL,
    0x800000000000ULL,
    0x6c00000000000ULL,
    0x200000000000ULL,
    0x500000000000ULL,
    0x1f80000000000ULL,
    0x2740000000000ULL,
    0xa220000000000ULL,
    0x4190000000000ULL,
    0xb828000000000ULL,
    0x41d4000000000ULL,
    0x908e000000000ULL,
    0x9081000000000ULL,
    0x91c4800000000ULL,
    0x38e5400000000ULL,
    0x91f1e00000000ULL,
    0x4c18500000000ULL,
    0xf32f480000000ULL,
    0xc952ec0000000ULL,
    0x54a120000000ULL,
    0x36666d0000000ULL,
    0x5f37f68000000ULL,
    0xa7ef04000000ULL,
    0x341df22000000ULL,
    0x72b3d3000000ULL,
    0xf523ea800000ULL,
    0x3e485c5400000ULL,
    0x26e2802200000ULL,
    0xef0402b00000ULL,
    0x929b602880000ULL,
    0xf5ec101540000ULL,
    0x43322805e0000ULL,
    0x907bfc12d0000ULL,
    0xf51aba2808000ULL,
    0x26add11124000ULL,
    0x27162ca9ea000ULL,
    0xeaef3159a5000ULL,
    0x5db1f6acab800ULL,
    0x36bbf04444400ULL,
    0x2f7f72027b200ULL,
    0xbb9b7d3a4c500ULL,
    0x88695eaa5ff80ULL,
    0x91744c7826540ULL,
    0x75d8a83a3af20ULL,
    0xf7cfbc162deb0ULL,
    0x52a7da0a4efc8ULL,
    0x2054c1020f8f4ULL,
    0xd8ce84866e2faULL,
    0xb4208d727f071ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x9000000000000ULL,
    0x9800000000000ULL,
    0x8400000000000ULL,
    0x2200000000000ULL,
    0x8500000000000ULL,
    0xd480000000000ULL,
    0xc740000000000ULL,
    0xd720000000000ULL,
    0x990000000000ULL,
    0x3b8000000000ULL,
    0x51d4000000000ULL,
    0xb11e000000000ULL,
    0x8183000000000ULL,
    0xabc2800000000ULL,
    0xe463c00000000ULL,
    0xf4b0a00000000ULL,
    0x932dd00000000ULL,
    0x20ec080000000ULL,
    0x808db40000000ULL,
    0xb63f120000000ULL,
    0x30119d0000000ULL,
    0x5c7f368000000ULL,
    0x9fb1c4c000000ULL,
    0xdca9b22000000ULL,
    0x602b4d3000000ULL,
    0xeb6fbeb800000ULL,
    0xe24cb0e400000ULL,
    0x58dc800600000ULL,
    0xb0e0c01100000ULL,
    0xf3f2203080000ULL,
    0xa40e100540000ULL,
    0xb97ca81320000ULL,
    0x1b306410d0000ULL,
    0x63eb1a3d48000ULL,
    0xa308292324000ULL,
    0x58fe24b5ce000ULL,
    0xe0f359e5a5000ULL,
    0xff8c04b98f800ULL,
    0x43bd49d204c00ULL,
    0x71d0acb21ea00ULL,
    0xc11d2df96df00ULL,
    0x8983b6af6ba80ULL,
    0xb7c104f1abb40ULL,
    0x426392144ba20ULL,
    0x53b15d0d7b9d0ULL,
    0xc2ad16b303ec8ULL,
    0x332fd4fd5f134ULL,
    0x90ed1a114ccfaULL,
    0x688f29043b1c3ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x7000000000000ULL,
    0x6800000000000ULL,
    0x9400000000000ULL,
    0x200000000000ULL,
    0xd700000000000ULL,
    0xfe80000000000ULL,
    0xfac0000000000ULL,
    0x7a0000000000ULL,
    0x9310000000000ULL,
    0xeab8000000000ULL,
    0xe4d4000000000ULL,
    0x989e000000000ULL,
    0xf587000000000ULL,
    0x4245800000000ULL,
    0x5060400000000ULL,
    0x3137200000000ULL,
    0x83eb500000000ULL,
    0xb20e180000000ULL,
    0xc37de40000000ULL,
    0xc7f06e0000000ULL,
    0xba49490000000ULL,
    0x1c8e8000000ULL,
    0x724108c000000ULL,
    0x98614e2000000ULL,
    0xb531193000000ULL,
    0x99e9169800000ULL,
    0x990bacdc00000ULL,
    0xabfb803a00000ULL,
    0xe837401500000ULL,
    0x946aa01880000ULL,
    0x974f1029c0000ULL,
    0x659f3825a0000ULL,
    0xe805b41bb0000ULL,
    0x5405f60168000ULL,
    0x6203ed1104000ULL,
    0xa70640850e000ULL,
    0x968751c785000ULL,
    0x6ec2f887cf800ULL,
    0x5a5a5e9a5c00ULL,
    0x4415ae923f600ULL,
    0x143d58c12d100ULL,
    0x1e12d6086a480ULL,
    0x9f38bd149b140ULL,
    0x669058be92e60ULL,
    0xa8feb5e807690ULL,
    0xb4b496b891d38ULL,
    0xa9afecd018864ULL,
    0x766aa02a4ca5aULL,
    0xf04f102ffb3b3ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x1000000000000ULL,
    0xe800000000000ULL,
    0x4c00000000000ULL,
    0x3e00000000000ULL,
    0x4f00000000000ULL,
    0x6380000000000ULL,
    0x8ac0000000000ULL,
    0x9720000000000ULL,
    0x6430000000000ULL,
    0xbe48000000000ULL,
    0x3f4000000000ULL,
    0x73ea000000000ULL,
    0x7d83000000000ULL,
    0x75c2800000000ULL,
    0xeca0400000000ULL,
    0x5af2e00000000ULL,
    0xb36eb00000000ULL,
    0x5ac4180000000ULL,
    0xdf20ec0000000ULL,
    0xd8312e0000000ULL,
    0x784f250000000ULL,
    0xe8f4378000000ULL,
    0x62692b4000000ULL,
    0x8641ce2000000ULL,
    0xce66951000000ULL,
    0x61d0afb800000ULL,
    0xf95e874400000ULL,
    0x438a801a00000ULL,
    0xf354400300000ULL,
    0x1f18e03780000ULL,
    0xddedb017c0000ULL,
    0x9a869822e0000ULL,
    0xba40ac31b0000ULL,
    0x4863ce2a48000ULL,
    0x6ad1950acc000ULL,
    0xf8d82fb772000ULL,
    0x504dc7624d000ULL,
    0x4f2e01932800ULL,
    0xac6eb0166cc00ULL,
    0x3144180ae2a00ULL,
    0x9e0ec3fd5100ULL,
    0x99112e3046380ULL,
    0x1f7f2520bb6c0ULL,
    0xb3c378441a60ULL,
    0xa45d2b5f202b0ULL,
    0x10bce1850f38ULL,
    0x5d15950078654ULL,
    0x3d7a2fb1440beULL,
    0x723ac7725e71dULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x1000000000000ULL,
    0x2800000000000ULL,
    0x7c00000000000ULL,
    0xde00000000000ULL,
    0x7f00000000000ULL,
    0xa680000000000ULL,
    0x6b40000000000ULL,
    0xe8e0000000000ULL,
    0xf550000000000ULL,
    0xa918000000000ULL,
    0x2b14000000000ULL,
    0xda7e000000000ULL,
    0x8285000000000ULL,
    0x1146800000000ULL,
    0x2de0400000000ULL,
    0xb6d3600000000ULL,
    0x91dfb00000000ULL,
    0xd334180000000ULL,
    0xab0dc40000000ULL,
    0x84eda20000000ULL,
    0x4338f30000000ULL,
    0x366b08000000ULL,
    0x71966fc000000ULL,
    0xaf38c22000000ULL,
    0x3566433000000ULL,
    0x5292288800000ULL,
    0xc7baebc400000ULL,
    0x926802a00000ULL,
    0x60f0402f00000ULL,
    0x87ab603f80000ULL,
    0x37dbb01bc0000ULL,
    0x18321823a0000ULL,
    0x9f8cc405d0000ULL,
    0x76ad220db8000ULL,
    0x2659b32294000ULL,
    0x99f55083e6000ULL,
    0xfa289fd015000ULL,
    0x401f3a2ca7800ULL,
    0x7e95772df5400ULL,
    0xd1b872a617a00ULL,
    0x3a212cc5bd100ULL,
    0x20726ab12b580ULL,
    0xc7e9e8ebd6ac0ULL,
    0xdbb948af1ca60ULL,
    0x27215bca7b610ULL,
    0x7f498072fb08ULL,
    0x652c840569d0cULL,
    0xd69e423bacaa2ULL,
    0x2dd6030f32eafULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x5000000000000ULL,
    0x2800000000000ULL,
    0x1400000000000ULL,
    0xf600000000000ULL,
    0xbf00000000000ULL,
    0x1780000000000ULL,
    0xf840000000000ULL,
    0x21a0000000000ULL,
    0xfd30000000000ULL,
    0x41f8000000000ULL,
    0x92f4000000000ULL,
    0xd81a000000000ULL,
    0xae63000000000ULL,
    0x34d0800000000ULL,
    0x556e400000000ULL,
    0x6a3e200000000ULL,
    0xd510f00000000ULL,
    0x4f88580000000ULL,
    0xa32e8c0000000ULL,
    0x889ffa0000000ULL,
    0x3da1510000000ULL,
    0xef30bb8000000ULL,
    0x90fd8ac000000ULL,
    0x56715a2000000ULL,
    0xfddfe11000000ULL,
    0x2a86c3b800000ULL,
    0xb6c3f6d400000ULL,
    0xb966f82a00000ULL,
    0x77503c1500000ULL,
    0xbb29820580000ULL,
    0xa49f2d3bc0000ULL,
    0x17a7198fe0000ULL,
    0xe23257fb10000ULL,
    0xe67e1b95e8000ULL,
    0x12b33ac08c000ULL,
    0xc5bf220d9e000ULL,
    0xb1559d1ead000ULL,
    0x3c2b618c6e800ULL,
    0x6f1f2bc5d4c00ULL,
    0x5de1398aca200ULL,
    0xa296a7cb26900ULL,
    0xa7cc438ce9080ULL,
    0x4a8eb6cb0cfc0ULL,
    0x31a858015e360ULL,
    0xa25e8c3dcc330ULL,
    0xd6c7fa2f3e768ULL,
    0xa965511f1d684ULL,
    0xbf52bbbc36b8eULL,
    0xff2a8ad70101bULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0xf000000000000ULL,
    0x800000000000ULL,
    0x2400000000000ULL,
    0xae00000000000ULL,
    0x500000000000ULL,
    0x1780000000000ULL,
    0x73c0000000000ULL,
    0x6c20000000000ULL,
    0x7150000000000ULL,
    0xe5e8000000000ULL,
    0x3d14000000000ULL,
    0x6e0a000000000ULL,
    0x2661000000000ULL,
    0x2bb5800000000ULL,
    0x4f1d400000000ULL,
    0x2a6aa00000000ULL,
    0xd2d3300000000ULL,
    0x202e080000000ULL,
    0x28334c0000000ULL,
    0x7ade760000000ULL,
    0x374bbd0000000ULL,
    0xe205c48000000ULL,
    0x9f06564000000ULL,
    0xe481562000000ULL,
    0xbd45cd1000000ULL,
    0x8a616ca800000ULL,
    0xe1b62a7c00000ULL,
    0x4419282200000ULL,
    0xc8e93c1900000ULL,
    0xbe90de0380000ULL,
    0x1bcac13d40000ULL,
    0x9b403a87e0000ULL,
    0xeb63e755f0000ULL,
    0xf830449088000ULL,
    0xc2db164d14000ULL,
    0xbb4bf6349a000ULL,
    0x9806fd3fb5000ULL,
    0x3c0764aa8a800ULL,
    0xd2016660cc400ULL,
    0x77055e3a17600ULL,
    0x90878104c2500ULL,
    0xeb429a9778280ULL,
    0xa364d75c9c8c0ULL,
    0x7c344cbe0ee20ULL,
    0x9cd95a406f830ULL,
    0xb6480015df358ULL,
    0xab84000737234ULL,
    0xe1c2003d92732ULL,
    0xbb250002e0069ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x3000000000000ULL,
    0xb800000000000ULL,
    0xfc00000000000ULL,
    0xf600000000000ULL,
    0x5300000000000ULL,
    0xff80000000000ULL,
    0xc240000000000ULL,
    0x7e0000000000ULL,
    0x5050000000000ULL,
    0x8dc8000000000ULL,
    0xd194000000000ULL,
    0x5e6e000000000ULL,
    0xc525000000000ULL,
    0xf477800000000ULL,
    0x1f3cc00000000ULL,
    0x766a600000000ULL,
    0x7120700000000ULL,
    0x6672780000000ULL,
    0x7638cc0000000ULL,
    0x94ecca0000000ULL,
    0xe3e7e30000000ULL,
    0xaa53c08000000ULL,
    0xb0c9f94000000ULL,
    0xb1112a2000000ULL,
    0x2dab533000000ULL,
    0xaf83d88800000ULL,
    0xaa45454c00000ULL,
    0x53e1980e00000ULL,
    0xd2517c0f00000ULL,
    0x6ccb523580000ULL,
    0x77179f18c0000ULL,
    0xc6a91291e0000ULL,
    0xac03a64f90000ULL,
    0x9e03d89c78000ULL,
    0x7054570d4000ULL,
    0x7d81983492000ULL,
    0x23417c38f5000ULL,
    0xa163523063800ULL,
    0xc8939f165d400ULL,
    0xe4ef128defe00ULL,
    0xbbe2a6586a300ULL,
    0x465258a861180ULL,
    0xcec88579515c0ULL,
    0xa6127832997e0ULL,
    0xd828cc02c5030ULL,
    0xc8c4ca3c2baa8ULL,
    0x123e337c0e4cULL,
    0x3e75c09461ee2ULL,
    0x9a38f95f500d5ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x7000000000000ULL,
    0xd800000000000ULL,
    0x6400000000000ULL,
    0x3e00000000000ULL,
    0x4100000000000ULL,
    0xdc80000000000ULL,
    0x8440000000000ULL,
    0xe2e0000000000ULL,
    0x7650000000000ULL,
    0xa18000000000ULL,
    0xaa94000000000ULL,
    0xe2be000000000ULL,
    0xc727000000000ULL,
    0x5675800000000ULL,
    0x5edc00000000ULL,
    0xd9bca00000000ULL,
    0xb4a5300000000ULL,
    0x87b4280000000ULL,
    0x73cf940000000ULL,
    0x4b4f6a0000000ULL,
    0x310e130000000ULL,
    0xf2ec408000000ULL,
    0x283e3fc000000ULL,
    0x7e664a2000000ULL,
    0x5216e33000000ULL,
    0xf8fcc89800000ULL,
    0x74c09bdc00000ULL,
    0x54a3081600000ULL,
    0x37b0642900000ULL,
    0xcbca621780000ULL,
    0x5f4d770c40000ULL,
    0xd70da28120000ULL,
    0xd7e988f810000ULL,
    0xcabac89738000ULL,
    0xbb239bfdd4000ULL,
    0x6c70880da6000ULL,
    0xaeea427b5000ULL,
    0x9c3d422e17800ULL,
    0x886287295dc00ULL,
    0xdf10aaae9b600ULL,
    0xa67eece29e700ULL,
    0xeb852a9660a80ULL,
    0x15c32cddb08c0ULL,
    0x58218a83e86a0ULL,
    0x7bf21ccd0c950ULL,
    0xe52ba29082f28ULL,
    0xab1a88e35bc8cULL,
    0xc61148a6ff9a2ULL,
    0xdef95be8d0aafULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x5000000000000ULL,
    0x5800000000000ULL,
    0x4c00000000000ULL,
    0xe00000000000ULL,
    0x500000000000ULL,
    0xc680000000000ULL,
    0xcac0000000000ULL,
    0x5e60000000000ULL,
    0xb430000000000ULL,
    0x83c8000000000ULL,
    0x474000000000ULL,
    0x316e000000000ULL,
    0x4f23000000000ULL,
    0x8a14800000000ULL,
    0x1d5dc00000000ULL,
    0x60ece00000000ULL,
    0xd060b00000000ULL,
    0x7133480000000ULL,
    0xa54bc40000000ULL,
    0x9eb23e0000000ULL,
    0x370a670000000ULL,
    0xb712e78000000ULL,
    0x7da354000000ULL,
    0x1c2a5e2000000ULL,
    0x9707173000000ULL,
    0x55854fb800000ULL,
    0xa545415400000ULL,
    0xc25283600000ULL,
    0x7d95b42300000ULL,
    0xe319163b80000ULL,
    0xf74cd31540000ULL,
    0xedb771a7a0000ULL,
    0x88f2661b0000ULL,
    0xbd57cfb418000ULL,
    0x827f815c4c000ULL,
    0x72fb480952000ULL,
    0x613fc417ad000ULL,
    0x4fdc3e35c3800ULL,
    0x28296739c4c00ULL,
    0x65066797f7200ULL,
    0x5687f5540a700ULL,
    0x72c6be0640b80ULL,
    0x4267a72420ec0ULL,
    0xe23607a0f1f20ULL,
    0xcace8565b9810ULL,
    0xccf7163efdb78ULL,
    0xfeafd336cbb5cULL,
    0xd7c3f1a6a1ebeULL,
    0xf4e2e66f31bc5ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0xd000000000000ULL,
    0x4800000000000ULL,
    0x5400000000000ULL,
    0x1a00000000000ULL,
    0x700000000000ULL,
    0x8780000000000ULL,
    0x86c0000000000ULL,
    0xdd20000000000ULL,
    0xcab0000000000ULL,
    0xa668000000000ULL,
    0xb7f4000000000ULL,
    0x838e000000000ULL,
    0x565000000000ULL,
    0xa3d0800000000ULL,
    0x13bb400000000ULL,
    0x8548200000000ULL,
    0x1840900000000ULL,
    0x4965980000000ULL,
    0x65d36c0000000ULL,
    0x7ab8ce0000000ULL,
    0xcfce350000000ULL,
    0x5602138000000ULL,
    0xc104324000000ULL,
    0xee806e2000000ULL,
    0xcc45e53000000ULL,
    0x9367ab8800000ULL,
    0x42d3ce7400000ULL,
    0x2d3b383200000ULL,
    0x109bc2500000ULL,
    0xdf23f60e80000ULL,
    0x11b78935c0000ULL,
    0x4fe9e5b3e0000ULL,
    0xfc37bb74b0000ULL,
    0x962f8b91c8000ULL,
    0x9a935e436c000ULL,
    0x445ea0207a000ULL,
    0xb4dad0084d000ULL,
    0xed9b380dab800ULL,
    0x8a79bc12f5400ULL,
    0x3ebf615ee200ULL,
    0x3a33893dd3d00ULL,
    0xff2fe5a6d1880ULL,
    0xd016bb6739640ULL,
    0xa190b8c05460ULL,
    0x3cb91e7e860b0ULL,
    0x66c800092e3b8ULL,
    0x3c84002eb2a94ULL,
    0x5f460014a062eULL,
    0x2ee1002491979ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x1000000000000ULL,
    0xf800000000000ULL,
    0x3400000000000ULL,
    0x5e00000000000ULL,
    0x8300000000000ULL,
    0x5a80000000000ULL,
    0x7240000000000ULL,
    0xc2e0000000000ULL,
    0xa670000000000ULL,
    0xcfe8000000000ULL,
    0x10b4000000000ULL,
    0x5c4a000000000ULL,
    0xdea3000000000ULL,
    0xaf92800000000ULL,
    0xf18c00000000ULL,
    0x2f1d200000000ULL,
    0x9f1b300000000ULL,
    0x971cb80000000ULL,
    0x4b19a40000000ULL,
    0xd919ca0000000ULL,
    0x301b230000000ULL,
    0xb79bb18000000ULL,
    0x1c59604000000ULL,
    0xf67e6a2000000ULL,
    0xe0acd31000000ULL,
    0x4bd029b800000ULL,
    0x32f8f44400000ULL,
    0xb1e9981e00000ULL,
    0x23b6941d00000ULL,
    0xecf722f80000ULL,
    0x70e18724c0000ULL,
    0xff70fba8a0000ULL,
    0x406a835190000ULL,
    0x6770fb8738000ULL,
    0x246a83595c000ULL,
    0x2170fbbd5a000ULL,
    0x836a834cbd000ULL,
    0xddf0fb81aa800ULL,
    0x462a834734c00ULL,
    0x1b90fba99ea00ULL,
    0x111a837e2b300ULL,
    0x4c18fbbbf5c80ULL,
    0xd59e83753e0c0ULL,
    0x1d5afb99bb8e0ULL,
    0xbdf9835dcc590ULL,
    0x216a7b99e33a8ULL,
    0x7cf643632104cULL,
    0xfdafdbbb51426ULL,
    0x3256b36a99f11ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x7000000000000ULL,
    0xe800000000000ULL,
    0xdc00000000000ULL,
    0x3200000000000ULL,
    0xcb00000000000ULL,
    0xd180000000000ULL,
    0x16c0000000000ULL,
    0x36a0000000000ULL,
    0x4870000000000ULL,
    0xb1d8000000000ULL,
    0x4d34000000000ULL,
    0x72be000000000ULL,
    0x5e67000000000ULL,
    0xdfd5800000000ULL,
    0xb72c400000000ULL,
    0xa5a9600000000ULL,
    0xeecd00000000ULL,
    0x9489b80000000ULL,
    0x8d5d9c0000000ULL,
    0x7f732e0000000ULL,
    0x8258190000000ULL,
    0x68f6458000000ULL,
    0xd19fd3c000000ULL,
    0x6d7ce2000000ULL,
    0x7dac893000000ULL,
    0x9ae89d9800000ULL,
    0x6a899fdc00000ULL,
    0xec58d81a00000ULL,
    0x51f54c0700000ULL,
    0xab1c961480000ULL,
    0xb196852ec0000ULL,
    0xb5ceeb8e60000ULL,
    0x383c8af2b0000ULL,
    0xa1256ba128000ULL,
    0xdbb7cad0dc000ULL,
    0xbff98ba016000ULL,
    0x91075afafd000ULL,
    0x681539307800ULL,
    0x954216de85c00ULL,
    0x9b65c59503600ULL,
    0x475093d746100ULL,
    0x336d2e0f25d80ULL,
    0xf84f193852f40ULL,
    0xbcfbc5859f0e0ULL,
    0x4c8793c0f0770ULL,
    0xda40ae3588938ULL,
    0x2ce759120c324ULL,
    0x494a5a28e7f6ULL,
    0xc54843ea8853fULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0xd000000000000ULL,
    0xe800000000000ULL,
    0x4c00000000000ULL,
    0x8e00000000000ULL,
    0xd900000000000ULL,
    0xa880000000000ULL,
    0x5240000000000ULL,
    0x3ea0000000000ULL,
    0x3ab0000000000ULL,
    0x44e8000000000ULL,
    0x3274000000000ULL,
    0x70a000000000ULL,
    0x83e7000000000ULL,
    0x9194800000000ULL,
    0x269c400000000ULL,
    0x9d78e00000000ULL,
    0xa8ed300000000ULL,
    0x4c71a80000000ULL,
    0x860eb40000000ULL,
    0x5f629a0000000ULL,
    0xe9d5110000000ULL,
    0x339178000000ULL,
    0x58498a4000000ULL,
    0xcfc6fa2000000ULL,
    0xba60611000000ULL,
    0xd7525f9800000ULL,
    0x9c790e7400000ULL,
    0x346b481a00000ULL,
    0x5430840300000ULL,
    0x73adb23b80000ULL,
    0x7250e50240000ULL,
    0xc2ffed9020000ULL,
    0x7b29eb4790000ULL,
    0xd014a58c28000ULL,
    0xa4596f68ec000ULL,
    0x359917831a000ULL,
    0xbef98a7c0d000ULL,
    0x8d2efa0c6a800ULL,
    0xcd14611955c00ULL,
    0x1ed85fb4df200ULL,
    0xd8de0e547a100ULL,
    0xbddfc8353cb80ULL,
    0xc35cc42b128c0ULL,
    0x3c1d5229714a0ULL,
    0x8039d53058bd0ULL,
    0xf3cc45be349e8ULL,
    0x76045f55ef084ULL,
    0x5d00bf8f02afeULL,
    0xda833e73190f9ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x1000000000000ULL,
    0x800000000000ULL,
    0x6c00000000000ULL,
    0x2200000000000ULL,
    0xc900000000000ULL,
    0x3080000000000ULL,
    0x4740000000000ULL,
    0x9ea0000000000ULL,
    0xfcb0000000000ULL,
    0x44f8000000000ULL,
    0x7d74000000000ULL,
    0x221a000000000ULL,
    0xd0e7000000000ULL,
    0x7292800000000ULL,
    0x8f0b400000000ULL,
    0xbf2fe00000000ULL,
    0xc7df500000000ULL,
    0xf800280000000ULL,
    0x3401140000000ULL,
    0x2607b20000000ULL,
    0x9706d10000000ULL,
    0xd387ef8000000ULL,
    0xd2c2eac000000ULL,
    0xcb62d22000000ULL,
    0xec56c11000000ULL,
    0x166a279800000ULL,
    0x827faec400000ULL,
    0x8535c82200000ULL,
    0x7339440b00000ULL,
    0xc4951a1080000ULL,
    0x500c853640000ULL,
    0x60afbd8e20000ULL,
    0x271b6bcad0000ULL,
    0xf265158f28000ULL,
    0x84d53fdd6c000ULL,
    0x552f47a51e000ULL,
    0x42dfbeda8d000ULL,
    0x9a8000152e800ULL,
    0xa240000415c00ULL,
    0xec20001f1aa00ULL,
    0x62f00011dfd00ULL,
    0xe2d80021ed780ULL,
    0xaa84003d5e140ULL,
    0xda420001acaa0ULL,
    0x982300327e950ULL,
    0x24f0801cfc148ULL,
    0x65d8402597604ULL,
    0x71076034f171eULL,
    0x6483102df83fbULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0x1000000000000ULL,
    0x1800000000000ULL,
    0xa400000000000ULL,
    0x1a00000000000ULL,
    0xc700000000000ULL,
    0x4680000000000ULL,
    0x2040000000000ULL,
    0xbd60000000000ULL,
    0xc390000000000ULL,
    0xba88000000000ULL,
    0xc254000000000ULL,
    0x312a000000000ULL,
    0xa4e5000000000ULL,
    0x4152800000000ULL,
    0x1da9c00000000ULL,
    0x6ba1a00000000ULL,
    0x16b2100000000ULL,
    0x587a180000000ULL,
    0x154e640000000ULL,
    0x8cf1fa0000000ULL,
    0x7219ff0000000ULL,
    0xa85a4e8000000ULL,
    0xa238474000000ULL,
    0xf28da2000000ULL,
    0x39e72f1000000ULL,
    0xe0d3768800000ULL,
    0x6b6df34400000ULL,
    0xee82982600000ULL,
    0xcc42a43900000ULL,
    0x3b62da0e80000ULL,
    0xaa922f35c0000ULL,
    0x3909f697a0000ULL,
    0xc790336110000ULL,
    0xf0893809d8000ULL,
    0x3d55b41124000ULL,
    0xc3aa423702000ULL,
    0x86a58b3c85000ULL,
    0x9f31aca512800ULL,
    0x82bfdc70dd400ULL,
    0x366b6e9876a00ULL,
    0x2f0297563f700ULL,
    0x8a83e22f02e80ULL,
    0xb6439b3085c40ULL,
    0xcc61b4a712260ULL,
    0xe414b85fdde90ULL,
    0xa54814b7f6168ULL,
    0xc4f2a8617ffbcULL,
    0xee180c8f6295aULL,
    0x659cc6934c8dULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x9000000000000ULL,
    0x1800000000000ULL,
    0x4400000000000ULL,
    0xee00000000000ULL,
    0x2900000000000ULL,
    0x8780000000000ULL,
    0xe940000000000ULL,
    0x6da0000000000ULL,
    0x2bd0000000000ULL,
    0x44a8000000000ULL,
    0x5414000000000ULL,
    0x33ce000000000ULL,
    0xfd27000000000ULL,
    0xd412800000000ULL,
    0xf3cbc00000000ULL,
    0x9d22a00000000ULL,
    0x4411b00000000ULL,
    0xebc8680000000ULL,
    0xd923cc0000000ULL,
    0xaa10c20000000ULL,
    0xc2ce710000000ULL,
    0x5ea1e48000000ULL,
    0x4356c04000000ULL,
    0xaf6ee22000000ULL,
    0x7573013000000ULL,
    0x7f9ac9800000ULL,
    0xfb7f7c6400000ULL,
    0x46bce82600000ULL,
    0xfadb0c2100000ULL,
    0x2f6ee22380000ULL,
    0xb573012e40000ULL,
    0x67f9aca7e0000ULL,
    0x6b7f7c6b50000ULL,
    0x5ebce800e8000ULL,
    0xbedb0c30b4000ULL,
    0xc16ee228ca000ULL,
    0x9c73010b55000ULL,
    0xe079ac919b800ULL,
    0x823f7c64bdc00ULL,
    0x331ce83faea00ULL,
    0x950b0c13b7f00ULL,
    0x85c6e2125b280ULL,
    0xc86701301dac0ULL,
    0xd3b7ac929eba0ULL,
    0x7f187c514e030ULL,
    0xe70e680766988ULL,
    0x66c0cc0ef2f04ULL,
    0x18e4421849e32ULL,
    0x8c76b10784831ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0x7000000000000ULL,
    0x7800000000000ULL,
    0xbc00000000000ULL,
    0x600000000000ULL,
    0xc300000000000ULL,
    0x3980000000000ULL,
    0xcd40000000000ULL,
    0x5aa0000000000ULL,
    0x34b0000000000ULL,
    0xbdb8000000000ULL,
    0xcb74000000000ULL,
    0xb7da000000000ULL,
    0x8225000000000ULL,
    0xa971800000000ULL,
    0xfedac00000000ULL,
    0x26a2600000000ULL,
    0x52b1f00000000ULL,
    0x2ebaf80000000ULL,
    0xfaf67c0000000ULL,
    0xbe99b20000000ULL,
    0x6283f90000000ULL,
    0x58c67f8000000ULL,
    0xb9e3e0c000000ULL,
    0x1910522000000ULL,
    0x728dc91000000ULL,
    0xc28f678800000ULL,
    0xda8eacdc00000ULL,
    0x3689783e00000ULL,
    0x388dbc3f00000ULL,
    0x3f88520980000ULL,
    0xbc09c92cc0000ULL,
    0xb44d679060000ULL,
    0x146facdc50000ULL,
    0xd41af83728000ULL,
    0xfe467c2dec000ULL,
    0x5b21b2290e000ULL,
    0x65f7f91d8d000ULL,
    0x911c7fa55e800ULL,
    0x44c6e0c2a5400ULL,
    0x8fe1d224b2600ULL,
    0x8217092dabb00ULL,
    0x870d07a23e180ULL,
    0x71cf5cdb753c0ULL,
    0xff2b80095ade0ULL,
    0x3dbfc033272f0ULL,
    0x8b73e000e0f48ULL,
    0x97db301211824ULL,
    0xf220982009a1eULL,
    0xd1738c2c1c273ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0xf000000000000ULL,
    0x8800000000000ULL,
    0x8400000000000ULL,
    0xaa00000000000ULL,
    0x4100000000000ULL,
    0x9480000000000ULL,
    0x8ec0000000000ULL,
    0x8c60000000000ULL,
    0xab70000000000ULL,
    0xb2f8000000000ULL,
    0xa434000000000ULL,
    0x36de000000000ULL,
    0xe0e1000000000ULL,
    0xe9b1800000000ULL,
    0xb099400000000ULL,
    0x1447a00000000ULL,
    0xd9a7100000000ULL,
    0xda93280000000ULL,
    0x77ce740000000ULL,
    0x366e3e0000000ULL,
    0x70fee70000000ULL,
    0xf1337d8000000ULL,
    0xd05f7cc000000ULL,
    0xd3261e2000000ULL,
    0x5751b73000000ULL,
    0xfa2e75a800000ULL,
    0x555b58fc00000ULL,
    0x8da2a80200000ULL,
    0xc897341100000ULL,
    0x9ac99e0280000ULL,
    0x7ce9f72c40000ULL,
    0x9d38558720000ULL,
    0x2cd508c2b0000ULL,
    0xcb6e202998000ULL,
    0x227a500a9c000ULL,
    0x40f288219e000ULL,
    0x5bbc6436bd000ULL,
    0x2f12960caf800ULL,
    0x5d88d333e4400ULL,
    0x1ccb63bc52600ULL,
    0x23efcbd56b500ULL,
    0xcab9eb8d86680ULL,
    0x393afdde1840ULL,
    0x7f4b7da7d0aa0ULL,
    0x4eab7cd709cd0ULL,
    0xeb981e0e34678ULL,
    0x29c0b72e5b7dcULL,
    0x17e7f5a7df956ULL,
    0xa3618dc9c023ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0xb000000000000ULL,
    0xd800000000000ULL,
    0x3c00000000000ULL,
    0x4a00000000000ULL,
    0xeb00000000000ULL,
    0xcf80000000000ULL,
    0x4940000000000ULL,
    0xb3e0000000000ULL,
    0xab30000000000ULL,
    0x8258000000000ULL,
    0xe2f4000000000ULL,
    0x217a000000000ULL,
    0x261000000000ULL,
    0xf777800000000ULL,
    0xab3bc00000000ULL,
    0x3a00600000000ULL,
    0xd306900000000ULL,
    0xe383b80000000ULL,
    0x6b41ac0000000ULL,
    0xbce3d20000000ULL,
    0x12b2030000000ULL,
    0x6a1d438000000ULL,
    0x7592d5c000000ULL,
    0xc8e322000000ULL,
    0x7a9e531000000ULL,
    0xd511ba800000ULL,
    0xa32a29ec00000ULL,
    0x58cc381600000ULL,
    0xe7fe6c1f00000ULL,
    0x6ba1b23a80000ULL,
    0xa4519316c0000ULL,
    0x33ab7b85e0000ULL,
    0x600db9dd50000ULL,
    0xe858001e78000ULL,
    0xf9f400000c000ULL,
    0x96fa003b76000ULL,
    0xc7210006ed000ULL,
    0xd6978012a6800ULL,
    0xd70bc02554400ULL,
    0x3dd8600fcbe00ULL,
    0x93b29028b3f00ULL,
    0xbe99b8353e980ULL,
    0x8b50ac2609e40ULL,
    0x7a2c5229c50e0ULL,
    0xf04dc31ad29b0ULL,
    0xf33f23812eec8ULL,
    0x460145c8d024cULL,
    0x39000a0a393eeULL,
    0xb8853f172c9e7ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x7000000000000ULL,
    0x800000000000ULL,
    0xdc00000000000ULL,
    0x8e00000000000ULL,
    0x2300000000000ULL,
    0x9980000000000ULL,
    0x2c0000000000ULL,
    0x3220000000000ULL,
    0x7590000000000ULL,
    0x1d28000000000ULL,
    0xbbd4000000000ULL,
    0x834e000000000ULL,
    0xd523000000000ULL,
    0x615800000000ULL,
    0x86ef400000000ULL,
    0x1171600000000ULL,
    0xc89a300000000ULL,
    0x9e6cf80000000ULL,
    0xef313c0000000ULL,
    0x7ef84e0000000ULL,
    0xbc9b3d0000000ULL,
    0x9c6e0a8000000ULL,
    0xda33c04000000ULL,
    0x607aae2000000ULL,
    0x7dd94d3000000ULL,
    0xdd8812b800000ULL,
    0xa9048c5c00000ULL,
    0xb082f82200000ULL,
    0x72423c0700000ULL,
    0xa065ce1b80000ULL,
    0xa5f07d14c0000ULL,
    0xb0d96aa460000ULL,
    0xd70ef077b0000ULL,
    0xda45d60f08000ULL,
    0x2c603125a4000ULL,
    0xb3f2bc992a000ULL,
    0x37ddc17245000ULL,
    0x148aea8e5b800ULL,
    0xa986b06f2cc00ULL,
    0x2ac7363d4f600ULL,
    0x7e22412b8ed00ULL,
    0x8394a4b8efd80ULL,
    0xea2a8d6cde4c0ULL,
    0x7052bcab165e0ULL,
    0x2c8dc148d39f0ULL,
    0x5d82ea81484b8ULL,
    0xe8c2b05785434ULL,
    0xab213610bb3caULL,
    0xed15413edc7f1ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0xb000000000000ULL,
    0xa800000000000ULL,
    0x9400000000000ULL,
    0x600000000000ULL,
    0xb100000000000ULL,
    0x3b80000000000ULL,
    0x54c0000000000ULL,
    0x45e0000000000ULL,
    0xf970000000000ULL,
    0x6b68000000000ULL,
    0x1534000000000ULL,
    0x86ce000000000ULL,
    0xffe5000000000ULL,
    0x1a73800000000ULL,
    0xc7ec400000000ULL,
    0x7b75200000000ULL,
    0x46b700000000ULL,
    0x83b4280000000ULL,
    0xcb8a6c0000000ULL,
    0xf1c76e0000000ULL,
    0xb864d30000000ULL,
    0x3cb11d8000000ULL,
    0xa50ddc4000000ULL,
    0x1087ce2000000ULL,
    0x3c42e33000000ULL,
    0x15a5958800000ULL,
    0x46d1806c00000ULL,
    0x16bc280a00000ULL,
    0xb30e6c1500000ULL,
    0x79816e0980000ULL,
    0x1bc5d30040000ULL,
    0x63649da4e0000ULL,
    0x1c309c7030000ULL,
    0xf14f6e30f8000ULL,
    0xb120d3221c000ULL,
    0xcc971d9c3a000ULL,
    0x1a1cdc7c7d000ULL,
    0x5a5a4e3acb800ULL,
    0x3dfba314a5400ULL,
    0x5c2b3595c6e00ULL,
    0xd812b074f6100ULL,
    0x385b203b8ec80ULL,
    0xc2fe703ed39c0ULL,
    0xd2afa83e89ea0ULL,
    0xa9522c3d058b0ULL,
    0xa47c4e1c96938ULL,
    0xd7eaa31a7ee8cULL,
    0xa376b59e8acd6ULL,
    0x186bf07644ac1ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x9000000000000ULL,
    0x8800000000000ULL,
    0x4400000000000ULL,
    0xc200000000000ULL,
    0x7700000000000ULL,
    0x9680000000000ULL,
    0x2a40000000000ULL,
    0x13a0000000000ULL,
    0xcc30000000000ULL,
    0x46a8000000000ULL,
    0x79f4000000000ULL,
    0xc0ce000000000ULL,
    0x3a7000000000ULL,
    0x8432800000000ULL,
    0x62af400000000ULL,
    0x2bf2a00000000ULL,
    0x3fcc500000000ULL,
    0xd126980000000ULL,
    0x6c70240000000ULL,
    0x60daa0000000ULL,
    0x7146890000000ULL,
    0x5323638000000ULL,
    0xbb70304000000ULL,
    0x608b8a2000000ULL,
    0x4306993000000ULL,
    0x8c83db9800000ULL,
    0xf140046400000ULL,
    0x9326980200000ULL,
    0xdb70242100000ULL,
    0xf08daa2880000ULL,
    0xcb068939c0000ULL,
    0xc8836387a0000ULL,
    0x3340305b90000ULL,
    0xe4238a1468000ULL,
    0x4df2991ecc000ULL,
    0xdacddbac0a000ULL,
    0xd8a70470ed000ULL,
    0x4b41836db800ULL,
    0x75ef6412e5c00ULL,
    0x9dd70a1826a00ULL,
    0x8d3ed93f16d00ULL,
    0xd96bfbbd6f280ULL,
    0x5c9714548ad40ULL,
    0x661ca0012d060ULL,
    0x5e1b501d7bd90ULL,
    0xa21c182775c28ULL,
    0x5c1b64234fb64ULL,
    0xb5190a365afeeULL,
    0x5a99d91725c51ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x9000000000000ULL,
    0xe800000000000ULL,
    0xc00000000000ULL,
    0xde00000000000ULL,
    0x6500000000000ULL,
    0xb180000000000ULL,
    0xd940000000000ULL,
    0x2ee0000000000ULL,
    0xa310000000000ULL,
    0xe688000000000ULL,
    0x3df4000000000ULL,
    0x9d9e000000000ULL,
    0xcf7f000000000ULL,
    0xa6e800000000ULL,
    0xde6400000000ULL,
    0xc391e00000000ULL,
    0xd44e300000000ULL,
    0xed54880000000ULL,
    0xf2ea5c0000000ULL,
    0x8b24720000000ULL,
    0x4933a30000000ULL,
    0x9c39368000000ULL,
    0x4b8de54000000ULL,
    0xb070fa2000000ULL,
    0x82d9ff3000000ULL,
    0xf09d449800000ULL,
    0x22fe466400000ULL,
    0x8529cc9a00000ULL,
    0xda041a7300000ULL,
    0xe705be8f80000ULL,
    0x8283b94d40000ULL,
    0x91c2882e60000ULL,
    0x70215c2150000ULL,
    0x3db4f21e38000ULL,
    0x4fae31684000ULL,
    0xc42e569842000ULL,
    0xd98195636d000ULL,
    0x154392173f800ULL,
    0x90e693040bc00ULL,
    0x56153e84e1a00ULL,
    0xbf0af97690900ULL,
    0xe8b5e83f99f80ULL,
    0x6d7d2c12754c0ULL,
    0x96f9a088b020ULL,
    0x5d618f3e21c70ULL,
    0xe9502ca1b1448ULL,
    0x70ee2a62a934cULL,
    0xb82736b21cb7aULL,
    0x1b2e559b7f25ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x9000000000000ULL,
    0x3800000000000ULL,
    0x5400000000000ULL,
    0xf600000000000ULL,
    0x6300000000000ULL,
    0xab80000000000ULL,
    0xad40000000000ULL,
    0xf0e0000000000ULL,
    0x6450000000000ULL,
    0x99d8000000000ULL,
    0x40b4000000000ULL,
    0xcb8e000000000ULL,
    0x1a69000000000ULL,
    0xb0be800000000ULL,
    0x44a6c00000000ULL,
    0xe35200000000ULL,
    0x664ff00000000ULL,
    0xb048f80000000ULL,
    0x834b8c0000000ULL,
    0xb0cc620000000ULL,
    0xd98df30000000ULL,
    0xe76a4c8000000ULL,
    0xb43b9fc000000ULL,
    0x70649a2000000ULL,
    0xfe967f3000000ULL,
    0x6e7e2ea800000ULL,
    0xbd026ce400000ULL,
    0x6480d6ae00000ULL,
    0x4c4e0e500000ULL,
    0x58a434b580000ULL,
    0x6432d3ccc0000ULL,
    0xaf4bd82ce0000ULL,
    0x72c97c2a50000ULL,
    0x7c8c1a27b8000ULL,
    0x87edbf30d4000ULL,
    0xdefb8ebf16000ULL,
    0x8fc25cf6bd000ULL,
    0xff238eb9bb800ULL,
    0x5b765cdc1e400ULL,
    0x62ad8e9481a00ULL,
    0xb21f5ce740b00ULL,
    0x41930ead20c80ULL,
    0xff99cd730bc0ULL,
    0x49462eaf281e0ULL,
    0x6ee66cfe8c130ULL,
    0xcb56d6a012708ULL,
    0x59e0cad370cULL,
    0x40f4b49732452ULL,
    0xa7ed13eee248fULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x5000000000000ULL,
    0x6800000000000ULL,
    0x7c00000000000ULL,
    0xc600000000000ULL,
    0x1100000000000ULL,
    0x2580000000000ULL,
    0x6040000000000ULL,
    0xc060000000000ULL,
    0x6110000000000ULL,
    0xdd28000000000ULL,
    0x4d74000000000ULL,
    0x323a000000000ULL,
    0xcd5f000000000ULL,
    0xa4cc800000000ULL,
    0x9a26400000000ULL,
    0x3670600000000ULL,
    0xe8bcf00000000ULL,
    0x859ea80000000ULL,
    0xb769bc0000000ULL,
    0x22135a0000000ULL,
    0x13aa170000000ULL,
    0xbfb76e8000000ULL,
    0xf69ae44000000ULL,
    0x41edf22000000ULL,
    0xc4d3ab1000000ULL,
    0x6d0c349800000ULL,
    0xe404f35400000ULL,
    0xa2009cba00000ULL,
    0xf3064f4f00000ULL,
    0xb685468980000ULL,
    0x86c5184040000ULL,
    0x2ea6c82b60000ULL,
    0x33b14c0310000ULL,
    0x289ff20398000ULL,
    0x74e8ab1704000ULL,
    0x6352b495aa000ULL,
    0xce49b3500d000ULL,
    0xaae67ca476800ULL,
    0x51d3ff6743c00ULL,
    0xba8f0e9f01200ULL,
    0x1f42147180900ULL,
    0xa8e15a2440980ULL,
    0xd2d1171961fc0ULL,
    0x5409ee80100a0ULL,
    0xdd87a464193f0ULL,
    0x54431222456e8ULL,
    0x4a621b384be9cULL,
    0x8e147cbadd49aULL,
    0xfda8ff5cce7a1ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x5000000000000ULL,
    0xf800000000000ULL,
    0x8c00000000000ULL,
    0xd600000000000ULL,
    0xb00000000000ULL,
    0xcb80000000000ULL,
    0xfec0000000000ULL,
    0xa4a0000000000ULL,
    0xe090000000000ULL,
    0xe118000000000ULL,
    0x7834000000000ULL,
    0xbf8e000000000ULL,
    0x862f000000000ULL,
    0x638800000000ULL,
    0xe266c00000000ULL,
    0x6833e00000000ULL,
    0xe788f00000000ULL,
    0x3a2d780000000ULL,
    0x78394c0000000ULL,
    0x9d647e0000000ULL,
    0xf9b2110000000ULL,
    0xc448b68000000ULL,
    0x5e0ea7c000000ULL,
    0xade9062000000ULL,
    0x261b5d3000000ULL,
    0xc5b4c89800000ULL,
    0x7a48b6d400000ULL,
    0x410fb09e00000ULL,
    0x6c6afad300000ULL,
    0xfddd4e8d80000ULL,
    0x2d912be6c0000ULL,
    0x799e9834e0000ULL,
    0xf171bc38b0000ULL,
    0x9be9063aa8000ULL,
    0xbd1b5d0de4000ULL,
    0x9634c88126000ULL,
    0x5888b6c07d000ULL,
    0xcbafb0a1ab800ULL,
    0xbfafad4dfc00ULL,
    0x1454e9a00200ULL,
    0xa0652bc500b00ULL,
    0xa930982281780ULL,
    0x690ebc3940fc0ULL,
    0xd869860b20fe0ULL,
    0xc7d99d2cd1230ULL,
    0xa09128aa58478ULL,
    0x411b46c0ecc84ULL,
    0x483448aa53abaULL,
    0x178a76fda276fULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0xd000000000000ULL,
    0x8800000000000ULL,
    0x8400000000000ULL,
    0xc600000000000ULL,
    0xf500000000000ULL,
    0xc880000000000ULL,
    0xef40000000000ULL,
    0x13a0000000000ULL,
    0x79d0000000000ULL,
    0x3118000000000ULL,
    0x9674000000000ULL,
    0xf2ce000000000ULL,
    0x286f000000000ULL,
    0x433c800000000ULL,
    0xc265400000000ULL,
    0xe837a00000000ULL,
    0xffeff00000000ULL,
    0xa3fd480000000ULL,
    0xfd02140000000ULL,
    0x8c87c20000000ULL,
    0x4942c10000000ULL,
    0x36a7988000000ULL,
    0x39504bc000000ULL,
    0x5a5a8a2000000ULL,
    0x43d0d53000000ULL,
    0x7e185a9800000ULL,
    0xd1f68af400000ULL,
    0x3a0b128200000ULL,
    0x230b9ed100000ULL,
    0xb988508980000ULL,
    0x8dc81ff940000ULL,
    0xf7ee682820000ULL,
    0xe7fca41ed0000ULL,
    0x5b032a0f68000ULL,
    0xa980253634000ULL,
    0x9c192ade6000ULL,
    0x5de5dec20d000ULL,
    0xecf5709bfb800ULL,
    0xd689afe2ffc00ULL,
    0xba4e001241200ULL,
    0x72f0034a0500ULL,
    0x309c803410680ULL,
    0x6bb5401b093c0ULL,
    0x512fa01b45f20ULL,
    0xed9bf03c1f150ULL,
    0x97334836f0b88ULL,
    0x206d1411b9dc4ULL,
    0x73b42395c7c2ULL,
    0x6467811bd23bfULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0xb000000000000ULL,
    0xd800000000000ULL,
    0x3c00000000000ULL,
    0x1600000000000ULL,
    0x6d00000000000ULL,
    0xd680000000000ULL,
    0x4cc0000000000ULL,
    0xeee0000000000ULL,
    0xa8d0000000000ULL,
    0x1ae8000000000ULL,
    0xd034000000000ULL,
    0x1f3e000000000ULL,
    0x3c5d000000000ULL,
    0x33cf800000000ULL,
    0x1585c00000000ULL,
    0x9b43600000000ULL,
    0x2aa2f00000000ULL,
    0x33f1c80000000ULL,
    0x7859240000000ULL,
    0x69cc5e0000000ULL,
    0x96801b0000000ULL,
    0xacc5fc8000000ULL,
    0x7ee7f24000000ULL,
    0xc0d5962000000ULL,
    0xfeed3f3000000ULL,
    0xfa37a28800000ULL,
    0x643ae96c00000ULL,
    0x87dfea9600000ULL,
    0xa98f0d7f00000ULL,
    0xb7a154ad80000ULL,
    0xdd75264740000ULL,
    0x9899802ba0000ULL,
    0xf92cc00030000ULL,
    0xb752e00038000ULL,
    0x4aaa301274000ULL,
    0x991528009a000ULL,
    0x8a8a14337d000ULL,
    0xf020f60c57800ULL,
    0x7136cf2d53400ULL,
    0xe7bfea8451e00ULL,
    0xb19f0d4868700ULL,
    0x75a954bc1d580ULL,
    0x7891266b86fc0ULL,
    0x93cf80297a120ULL,
    0x6585c03c6d790ULL,
    0x634360099faf8ULL,
    0xa6a2f0067e8acULL,
    0xfdf1c83e6e352ULL,
    0x2959241a26799ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0xd000000000000ULL,
    0x6800000000000ULL,
    0x8c00000000000ULL,
    0x6e00000000000ULL,
    0xff00000000000ULL,
    0x9b80000000000ULL,
    0xef40000000000ULL,
    0xe160000000000ULL,
    0xa710000000000ULL,
    0xa258000000000ULL,
    0xd874000000000ULL,
    0x24a000000000ULL,
    0xa5a9000000000ULL,
    0x778800000000ULL,
    0xbf80400000000ULL,
    0xed45e00000000ULL,
    0x63b00000000ULL,
    0x7b96580000000ULL,
    0x32988c0000000ULL,
    0x3453920000000ULL,
    0xd53d5f0000000ULL,
    0xc460668000000ULL,
    0x9953fc000000ULL,
    0x6b9dca2000000ULL,
    0xcd1d31000000ULL,
    0xa7f9f4a800000ULL,
    0xb94160f400000ULL,
    0xba652cba00000ULL,
    0x7e94acf300000ULL,
    0xc19de9380000ULL,
    0x359703dbc0000ULL,
    0x5d988034e0000ULL,
    0x67d0403cd0000ULL,
    0x667de011d8000ULL,
    0x2307b00104000ULL,
    0xdd84580ff6000ULL,
    0x3c458c110d000ULL,
    0xc4e11205aa800ULL,
    0xdf541f04be400ULL,
    0x54bd06b7f0200ULL,
    0xfe26cfcbe9100ULL,
    0xbe76720b0df80ULL,
    0x414eef26abac0ULL,
    0x482e3e9f3f360ULL,
    0x2339b3c831730ULL,
    0x4f64580d093c8ULL,
    0xb8158c00ddebcULL,
    0x49d91226f2d7aULL,
    0x8f301f2afb90fULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0xb000000000000ULL,
    0x9800000000000ULL,
    0xc00000000000ULL,
    0xb200000000000ULL,
    0x2500000000000ULL,
    0x6980000000000ULL,
    0xc3c0000000000ULL,
    0xa960000000000ULL,
    0xdef0000000000ULL,
    0xdef8000000000ULL,
    0xd194000000000ULL,
    0xdb0a000000000ULL,
    0xd1ed000000000ULL,
    0x35db800000000ULL,
    0x91c3c00000000ULL,
    0x5c66e00000000ULL,
    0xbf75d00000000ULL,
    0x3938080000000ULL,
    0x5ef67c0000000ULL,
    0x9ef8c60000000ULL,
    0xf197bf0000000ULL,
    0x6b0d0d8000000ULL,
    0x49ef2ec000000ULL,
    0x39d8ce2000000ULL,
    0x23c5c31000000ULL,
    0x7967cb8800000ULL,
    0xd6f191ec00000ULL,
    0xfafc438600000ULL,
    0xf7902dd300000ULL,
    0x4008658480000ULL,
    0x2f6f42f540000ULL,
    0xba9ee01460000ULL,
    0x92e1d00ff0000ULL,
    0xe8320828d8000ULL,
    0x161b7c11fc000ULL,
    0xe8a346275e000ULL,
    0x8a947f0ed5000ULL,
    0x458bedaa7a800ULL,
    0xceaafefa77400ULL,
    0x1ef8c62af0e00ULL,
    0xb197bf0759f00ULL,
    0x4b0d0db43d380ULL,
    0xf9ef2ef47f340ULL,
    0xa1d8ce0444620ULL,
    0x2fc5c320d32f0ULL,
    0xcb67cbaf93e98ULL,
    0xf3f191e6f32bcULL,
    0x937c439282196ULL,
    0x34502ded9bd0bULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x5000000000000ULL,
    0xa800000000000ULL,
    0xc400000000000ULL,
    0x9e00000000000ULL,
    0x1100000000000ULL,
    0xfe80000000000ULL,
    0x52c0000000000ULL,
    0x16e0000000000ULL,
    0xef70000000000ULL,
    0x1ab8000000000ULL,
    0x7894000000000ULL,
    0x434a000000000ULL,
    0x4e9000000000ULL,
    0x4b3c800000000ULL,
    0xd5d6400000000ULL,
    0xf1eba00000000ULL,
    0x3bba300000000ULL,
    0x9e17680000000ULL,
    0x8d8f640000000ULL,
    0xb00b4e0000000ULL,
    0x474afb0000000ULL,
    0x7aeaf18000000ULL,
    0xaa3e50c000000ULL,
    0xd356262000000ULL,
    0xcf2c9f1000000ULL,
    0x775d3fa800000ULL,
    0xfe62ebd400000ULL,
    0x78b7778a00000ULL,
    0x64d8ffe100000ULL,
    0x402471af80000ULL,
    0x879510c040000ULL,
    0x14cb061da0000ULL,
    0x64a9ef21b0000ULL,
    0x51d77a038000ULL,
    0xb41ffda9c000ULL,
    0x2fa0f1948e000ULL,
    0x6bd750efd5000ULL,
    0xf0eaa6054a800ULL,
    0xcd3adf2e16400ULL,
    0x58d69fac79200ULL,
    0xad68dbe13c900ULL,
    0x8a781f823e680ULL,
    0x3d739bcf6dcc0ULL,
    0x41bd3fb3167a0ULL,
    0x112ebddf9090ULL,
    0x6a0f778a7d9b8ULL,
    0x884cfff11fe2cULL,
    0x356e71911cae6ULL,
    0x567c10e6ce513ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x5000000000000ULL,
    0xe800000000000ULL,
    0x4c00000000000ULL,
    0xaa00000000000ULL,
    0x6d00000000000ULL,
    0x3480000000000ULL,
    0x82c0000000000ULL,
    0x69a0000000000ULL,
    0xd390000000000ULL,
    0xe9a8000000000ULL,
    0xe734000000000ULL,
    0x76be000000000ULL,
    0xc85b000000000ULL,
    0x4e28800000000ULL,
    0x4272400000000ULL,
    0x7a59e00000000ULL,
    0xf72b900000000ULL,
    0xc8f6c80000000ULL,
    0xcb98d40000000ULL,
    0xc909ce0000000ULL,
    0x2623110000000ULL,
    0x3ad4668000000ULL,
    0x4f4b024000000ULL,
    0xb541062000000ULL,
    0xc4e0c53000000ULL,
    0xc37528b800000ULL,
    0x94da535400000ULL,
    0x40ec809a00000ULL,
    0x61d0576300000ULL,
    0x94cae6b280000ULL,
    0xc206427f40000ULL,
    0xe106662f20000ULL,
    0x7e861517b0000ULL,
    0xbfc480b2e8000ULL,
    0xb5245768a4000ULL,
    0x1d54e687ca000ULL,
    0x2a0d42613d000ULL,
    0x59a6e63867800ULL,
    0xab90551902c00ULL,
    0xadab60bca8200ULL,
    0x5130c77a05900ULL,
    0x59bcae93bbf80ULL,
    0xddd8d67ab5240ULL,
    0x52684839d2120ULL,
    0xc415943651650ULL,
    0xf4eeae37b9ab8ULL,
    0x4fd5c1059c704ULL,
    0xafcdce8116f3aULL,
    0x898106490b819ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0x7000000000000ULL,
    0xc800000000000ULL,
    0x4400000000000ULL,
    0xfa00000000000ULL,
    0x8300000000000ULL,
    0x1a80000000000ULL,
    0xbd40000000000ULL,
    0x1fa0000000000ULL,
    0xbad0000000000ULL,
    0x5bd8000000000ULL,
    0x4e74000000000ULL,
    0x8f8a000000000ULL,
    0xbaed000000000ULL,
    0x695d800000000ULL,
    0xa731400000000ULL,
    0xf22aa00000000ULL,
    0x7f3f100000000ULL,
    0x5e05f80000000ULL,
    0x6900640000000ULL,
    0x186820000000ULL,
    0x5bc6210000000ULL,
    0xd4e0908000000ULL,
    0x9872edc000000ULL,
    0x82897a2000000ULL,
    0x316b451000000ULL,
    0x799b928800000ULL,
    0x2d558cdc00000ULL,
    0x2d1b4a9200000ULL,
    0x6112b8c100000ULL,
    0xcf3d109680000ULL,
    0xf603adecc0000ULL,
    0x7d03da1ca0000ULL,
    0x4384553250000ULL,
    0x54c66a8368000ULL,
    0x7061e8c374000ULL,
    0x5c37c8bcd6000ULL,
    0x4a999dd0d000ULL,
    0x2c7800342a800ULL,
    0x80a400039f400ULL,
    0xc6520037e9600ULL,
    0x43990036b5500ULL,
    0xce578002f6280ULL,
    0x679c403d9d840ULL,
    0x64572000e29e0ULL,
    0x5c9e50013a090ULL,
    0xf2d7580416e88ULL,
    0x5fdb740fad5c4ULL,
    0x94717a157a922ULL,
    0x7c8f453776367ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x9000000000000ULL,
    0x9800000000000ULL,
    0x5c00000000000ULL,
    0xd200000000000ULL,
    0x2700000000000ULL,
    0xaf80000000000ULL,
    0xa940000000000ULL,
    0x1a60000000000ULL,
    0x1910000000000ULL,
    0xfd38000000000ULL,
    0x3874000000000ULL,
    0x39ae000000000ULL,
    0xbb0f000000000ULL,
    0xbc3e800000000ULL,
    0xf6f5c00000000ULL,
    0x6e6b600000000ULL,
    0x9ea9d00000000ULL,
    0xd489980000000ULL,
    0x757ccc0000000ULL,
    0x7c95820000000ULL,
    0xef7f470000000ULL,
    0x3f94668000000ULL,
    0x3efd3cc000000ULL,
    0x6bd21a2000000ULL,
    0x681c8b3000000ULL,
    0xfa07649800000ULL,
    0xd303bbe400000ULL,
    0x49831c8600000ULL,
    0x84767e700000ULL,
    0x84e2668c80000ULL,
    0xb6d63cddc0000ULL,
    0x149a9a35e0000ULL,
    0x1ac24b2950000ULL,
    0xc124848c18000ULL,
    0xd474abfc84000ULL,
    0x43a964a62e000ULL,
    0xa80cbbca8d000ULL,
    0x95bd9caf93800ULL,
    0x6eb2a7df17c00ULL,
    0x728906a339a00ULL,
    0x747fecdcb4700ULL,
    0x12130206a7580ULL,
    0x48be870bf0b40ULL,
    0x1231068a68460ULL,
    0x924becd0ac830ULL,
    0x665d023a23988ULL,
    0x8fe1870ddf15cULL,
    0x35786b0e407aULL,
    0x3eda2cc73e783ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x1000000000000ULL,
    0x2800000000000ULL,
    0x2c00000000000ULL,
    0x2200000000000ULL,
    0x300000000000ULL,
    0xca80000000000ULL,
    0x7540000000000ULL,
    0xc420000000000ULL,
    0xb310000000000ULL,
    0x61e8000000000ULL,
    0xa834000000000ULL,
    0x627e000000000ULL,
    0xb99000000000ULL,
    0xf2ea800000000ULL,
    0x8ab6400000000ULL,
    0x9b3ae00000000ULL,
    0xfdb9d00000000ULL,
    0x6afab80000000ULL,
    0xdd8640000000ULL,
    0x644c420000000ULL,
    0x58e7bd0000000ULL,
    0x18f3de8000000ULL,
    0xeb9c604000000ULL,
    0x82e8fa2000000ULL,
    0x12b6d93000000ULL,
    0x8f3d1ca800000ULL,
    0xdbb99d4400000ULL,
    0x67ffc4aa00000ULL,
    0xe65a697b00000ULL,
    0xd88dde8080000ULL,
    0x23056074c0000ULL,
    0x1a827a30a0000ULL,
    0xfd40992250000ULL,
    0xf827fc9b88000ULL,
    0xb9104d6304000ULL,
    0x4eed7c885a000ULL,
    0x40b60d4c9d000ULL,
    0x143f9c9bb7800ULL,
    0x53bdd47b2400ULL,
    0x34bb24a568a00ULL,
    0x2f7ab94634900ULL,
    0x801de69da3380ULL,
    0xfe2b444481340ULL,
    0xc954d81ec18e0ULL,
    0x9d4ef42ba0c90ULL,
    0xe5669a32d0888ULL,
    0x31304937484b4ULL,
    0x6fffc49fa441aULL,
    0x1a5a69740be51ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0xd000000000000ULL,
    0x7800000000000ULL,
    0x1400000000000ULL,
    0xea00000000000ULL,
    0xb300000000000ULL,
    0x4580000000000ULL,
    0x2440000000000ULL,
    0x3ba0000000000ULL,
    0x4710000000000ULL,
    0x4f48000000000ULL,
    0x93b4000000000ULL,
    0x5bda000000000ULL,
    0xadbf000000000ULL,
    0x2b48800000000ULL,
    0xf1b6c00000000ULL,
    0x34df200000000ULL,
    0xbe3d100000000ULL,
    0x3a0e780000000ULL,
    0xc2931c0000000ULL,
    0x4b0cca0000000ULL,
    0x1813790000000ULL,
    0xb4cb4e8000000ULL,
    0x8ef3994000000ULL,
    0x46f8b22000000ULL,
    0xf36f651000000ULL,
    0x6fe7049800000ULL,
    0xf4b2207400000ULL,
    0xd45edcbe00000ULL,
    0x8afaec5500000ULL,
    0xfd6b4e8280000ULL,
    0xfee39948c0000ULL,
    0xbe30b23760000ULL,
    0x339b652810000ULL,
    0xd81d04b268000ULL,
    0x9d5d204c04000ULL,
    0x247e5c8632000ULL,
    0x38a82c543d000ULL,
    0xa3066e8bfe800ULL,
    0x1d85897b7bc00ULL,
    0x80444a2088200ULL,
    0x79a5b92154b00ULL,
    0x98146eba7b480ULL,
    0xf4ce896c09840ULL,
    0xeef6ca14953e0ULL,
    0x96fc79339bb70ULL,
    0x8b6bcebed85a8ULL,
    0x7be1597e9dea4ULL,
    0x1eb592160ea5aULL,
    0x67597529c3d55ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x9000000000000ULL,
    0x2800000000000ULL,
    0x5400000000000ULL,
    0x1200000000000ULL,
    0x5d00000000000ULL,
    0x6980000000000ULL,
    0xf0c0000000000ULL,
    0x96e0000000000ULL,
    0xd0f0000000000ULL,
    0x9978000000000ULL,
    0x6914000000000ULL,
    0xad0a000000000ULL,
    0xa12b000000000ULL,
    0x663a800000000ULL,
    0x7030400000000ULL,
    0x879b200000000ULL,
    0x9de6500000000ULL,
    0x9e77880000000ULL,
    0xe93f3c0000000ULL,
    0xe4b7de0000000ULL,
    0x6edec30000000ULL,
    0x43c1058000000ULL,
    0xa462a6c000000ULL,
    0xe6b2562000000ULL,
    0x5bdeff1000000ULL,
    0x9e465bb800000ULL,
    0xd6a725e400000ULL,
    0x552f3aa00000ULL,
    0xb6aa49c500000ULL,
    0xe5f8a59c80000ULL,
    0x7450b6e340000ULL,
    0x112cfe0860000ULL,
    0x7e38931d30000ULL,
    0x7c368d9338000ULL,
    0x799d9ad27c000ULL,
    0xaee58812be000ULL,
    0xecf03c3435000ULL,
    0x3f7f5e281a800ULL,
    0xb611831306c00ULL,
    0xb18aa58a08a00ULL,
    0x6c6fb6db45100ULL,
    0x121c7e2dc2480ULL,
    0x6b23d3260a540ULL,
    0xa7972d916fc20ULL,
    0x9d4b8acc7c1f0ULL,
    0xcc892025bf1f8ULL,
    0x35e95039b4f4cULL,
    0xbadf0815dbcb6ULL,
    0x11c07c0127e2bULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0x9000000000000ULL,
    0x6800000000000ULL,
    0xac00000000000ULL,
    0x2200000000000ULL,
    0x3500000000000ULL,
    0x2880000000000ULL,
    0xc640000000000ULL,
    0xc460000000000ULL,
    0x9db0000000000ULL,
    0x7318000000000ULL,
    0xa6d4000000000ULL,
    0x1f2a000000000ULL,
    0x390d000000000ULL,
    0x1eda800000000ULL,
    0x3f74400000000ULL,
    0xa33ae00000000ULL,
    0x1203d00000000ULL,
    0x8d01080000000ULL,
    0xcc87740000000ULL,
    0xd8476a0000000ULL,
    0xbb649f0000000ULL,
    0x2c37538000000ULL,
    0xbfdbddc000000ULL,
    0x91f4622000000ULL,
    0x6e7aeb1000000ULL,
    0x11e0b98800000ULL,
    0xf7602e400000ULL,
    0x1b3b51ba00000ULL,
    0xf602a6fb00000ULL,
    0x930533a080000ULL,
    0xb3854df940000ULL,
    0x69c70a3820000ULL,
    0x77a30f2e90000ULL,
    0x1b14bbab98000ULL,
    0xce8b79e52c000ULL,
    0xb918002466000ULL,
    0x7fd4002e65000ULL,
    0x35aa003c72800ULL,
    0x5a4d0031ff400ULL,
    0x9a3a803a48a00ULL,
    0xc884401b94100ULL,
    0x3642e00a5a380ULL,
    0x1c67d0095ab40ULL,
    0xc9b30835da620ULL,
    0x951e742a9a8d0ULL,
    0x1dd7ea2fbb428ULL,
    0x20addf0cab83cULL,
    0xe2cf339bf38eeULL,
    0x34784dfe3fce7ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0xd000000000000ULL,
    0xc800000000000ULL,
    0x5400000000000ULL,
    0xa00000000000ULL,
    0x3b00000000000ULL,
    0xf480000000000ULL,
    0xf6c0000000000ULL,
    0xf2a0000000000ULL,
    0xab0000000000ULL,
    0xbbc8000000000ULL,
    0x2114000000000ULL,
    0x5afe000000000ULL,
    0xea9f000000000ULL,
    0x88c800000000ULL,
    0x2af7400000000ULL,
    0xc0a9200000000ULL,
    0x8f87900000000ULL,
    0xa245b80000000ULL,
    0xb460140000000ULL,
    0xe0121e0000000ULL,
    0x2d7ff90000000ULL,
    0xc4df3f8000000ULL,
    0x4ae8094000000ULL,
    0x7fe1a62000000ULL,
    0xe054ed3000000ULL,
    0x261fa19800000ULL,
    0x124fb07400000ULL,
    0xfe53399200000ULL,
    0xb718346500000ULL,
    0x6dcc9fba80000ULL,
    0xe413d94ac0000ULL,
    0x2f7fbe3720000ULL,
    0xcbdb292cb0000ULL,
    0x646da79428000ULL,
    0x7a208d6d6c000ULL,
    0xb272800352000ULL,
    0xd068401e35000ULL,
    0x6025a00db7800ULL,
    0x2170d03f7bc00ULL,
    0xa0ec981f59200ULL,
    0x54e78428e4d00ULL,
    0xbcd7a6364fc80ULL,
    0x54dfed1d6f240ULL,
    0x22ed21afdfce0ULL,
    0x9be7f068f7150ULL,
    0xf25699801a6f8ULL,
    0x8118e46a080a4ULL,
    0xb8c807bd5dc9eULL,
    0x39905d5abb335ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x7000000000000ULL,
    0x800000000000ULL,
    0x9c00000000000ULL,
    0xb200000000000ULL,
    0xab00000000000ULL,
    0xc980000000000ULL,
    0x74c0000000000ULL,
    0xdce0000000000ULL,
    0xd5f0000000000ULL,
    0x5738000000000ULL,
    0xc14000000000ULL,
    0x924e000000000ULL,
    0x2d6f000000000ULL,
    0x8ff9800000000ULL,
    0xcaf1400000000ULL,
    0x60ba600000000ULL,
    0x79d1500000000ULL,
    0xc82c780000000ULL,
    0x63d87c0000000ULL,
    0xf5e60e0000000ULL,
    0x1f75230000000ULL,
    0x667a7d8000000ULL,
    0x6e33e4c000000ULL,
    0xa45c762000000ULL,
    0x48265f3000000ULL,
    0xb913f39800000ULL,
    0xeacc87dc00000ULL,
    0xb72beba200000ULL,
    0x245aabd700000ULL,
    0x88201d9480000ULL,
    0xd912b4c6c0000ULL,
    0x9ac80e0860000ULL,
    0xbf2a231630000ULL,
    0xb85bfd81b8000ULL,
    0x3a26a4e4bc000ULL,
    0x721016292e000ULL,
    0x534c0f23f5000ULL,
    0xcbe80b954b800ULL,
    0x64babbd5d7c00ULL,
    0xefd6059168600ULL,
    0x252b98cef5500ULL,
    0x5f5a780acb180ULL,
    0x59a37c2596940ULL,
    0x49d18e08c8fe0ULL,
    0x602b6304248f0ULL,
    0xefd99dbb82fb8ULL,
    0x3fe3f4d8f28ccULL,
    0x20726e3b6b796ULL,
    0x81fb732b47e23ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x9000000000000ULL,
    0x9800000000000ULL,
    0xc400000000000ULL,
    0xb600000000000ULL,
    0x7d00000000000ULL,
    0x5180000000000ULL,
    0xfd40000000000ULL,
    0xb20000000000ULL,
    0xb210000000000ULL,
    0xd408000000000ULL,
    0x1634000000000ULL,
    0x4c9a000000000ULL,
    0x7bff000000000ULL,
    0x314a800000000ULL,
    0x9911c00000000ULL,
    0x288ba00000000ULL,
    0x42f2f00000000ULL,
    0xeeff880000000ULL,
    0xeccadc0000000ULL,
    0xee55120000000ULL,
    0xbca94d0000000ULL,
    0xf266be8000000ULL,
    0x2f346f4000000ULL,
    0xeb189a2000000ULL,
    0x9bb8911000000ULL,
    0xfbeb2c9800000ULL,
    0x4e47e26400000ULL,
    0x33a5048600000ULL,
    0x50d0ce6100000ULL,
    0xb6d1e9580000ULL,
    0xd0869f6b40000ULL,
    0x6ec7120a60000ULL,
    0x55624d3a50000ULL,
    0x59b63e9148000ULL,
    0x20daaf66c4000ULL,
    0x3b59ba0ae2000ULL,
    0x791ba1049d000ULL,
    0x80bf04b00e800ULL,
    0x2f6fce766bc00ULL,
    0xb6879ea9f8a00ULL,
    0xebc75f511d700ULL,
    0x50e4b23b4e680ULL,
    0x8af4bd0c0a7c0ULL,
    0x92fbb6bba9c20ULL,
    0x6ecb736c54070ULL,
    0x2d5428078b8c8ULL,
    0xcc282c15e95f4ULL,
    0x2ca29a15b405aULL,
    0x125791079a60dULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x9000000000000ULL,
    0x4800000000000ULL,
    0x2c00000000000ULL,
    0x1e00000000000ULL,
    0xf100000000000ULL,
    0x1580000000000ULL,
    0x4a40000000000ULL,
    0xd6e0000000000ULL,
    0x6050000000000ULL,
    0x38e8000000000ULL,
    0x25b4000000000ULL,
    0xa3a000000000ULL,
    0xaf99000000000ULL,
    0x60aa800000000ULL,
    0xcc51400000000ULL,
    0x66eae00000000ULL,
    0x74b7300000000ULL,
    0x8fba280000000ULL,
    0xadda7c0000000ULL,
    0x9a4eca0000000ULL,
    0xb200230000000ULL,
    0xaf04948000000ULL,
    0x4486be4000000ULL,
    0xcfc6e22000000ULL,
    0xd4a75f1000000ULL,
    0x9ab2dea800000ULL,
    0x46badd6400000ULL,
    0xec5816b200000ULL,
    0x3a0e915b00000ULL,
    0xefe6748f80000ULL,
    0x19d58e4840000ULL,
    0xccaeca1f60000ULL,
    0x9250232d90000ULL,
    0x37ec948838000ULL,
    0xf132be4b54000ULL,
    0x8dfce23eda000ULL,
    0x573e5f3cbd000ULL,
    0xe4185e9dd6800ULL,
    0x7beb9d7922400ULL,
    0x9f32f694c8a00ULL,
    0x4f9a16bfd500ULL,
    0xb6bc5caf36380ULL,
    0xd45ff26ff28c0ULL,
    0x6e08002810aa0ULL,
    0x5e40017798f0ULL,
    0x92d2002db52a8ULL,
    0x1a2d00220bd4cULL,
    0x2290801765b72ULL,
    0x4fc84038d3ac9ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0xf000000000000ULL,
    0xe800000000000ULL,
    0x5c00000000000ULL,
    0xce00000000000ULL,
    0xef00000000000ULL,
    0x5f80000000000ULL,
    0x840000000000ULL,
    0x8260000000000ULL,
    0xe410000000000ULL,
    0xcd98000000000ULL,
    0xa9f4000000000ULL,
    0xf9ce000000000ULL,
    0xb20b000000000ULL,
    0xd62d800000000ULL,
    0x4f5a400000000ULL,
    0x2150600000000ULL,
    0xf97fb00000000ULL,
    0xb926580000000ULL,
    0x37f0ac0000000ULL,
    0x2ecbea0000000ULL,
    0x498e870000000ULL,
    0x5469d68000000ULL,
    0x583859c000000ULL,
    0xe7c0322000000ULL,
    0x42246b3000000ULL,
    0x2a725cb800000ULL,
    0xff896efc00000ULL,
    0x3f6fbc9a00000ULL,
    0x9dbc9ee700000ULL,
    0x628184ab80000ULL,
    0x56c782f7c0000ULL,
    0x2aa236b5e0000ULL,
    0x29b2a9d910000ULL,
    0x17ad8a3118000ULL,
    0x901e3719c4000ULL,
    0x58b40e9506000ULL,
    0x9f2db5f8ad000ULL,
    0x63d838208b800ULL,
    0x58941c0b56c00ULL,
    0x6c58323a15600ULL,
    0x68d06b057f900ULL,
    0x4a3c5c8839980ULL,
    0x6c26ed4b42c0ULL,
    0x12a23ca5cf760ULL,
    0x8db6deea117b0ULL,
    0x9da9e4b498028ULL,
    0x51c32f7051dcULL,
    0x7a326eba671baULL,
    0xe9ed05f8fd817ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x9000000000000ULL,
    0xa800000000000ULL,
    0xcc00000000000ULL,
    0xf600000000000ULL,
    0x3700000000000ULL,
    0x6f80000000000ULL,
    0xa140000000000ULL,
    0xb6e0000000000ULL,
    0xfb50000000000ULL,
    0xb818000000000ULL,
    0x9a34000000000ULL,
    0x460e000000000ULL,
    0xcecf000000000ULL,
    0x766e800000000ULL,
    0xc05c400000000ULL,
    0x2053e00000000ULL,
    0x119b700000000ULL,
    0x5471180000000ULL,
    0x6b6d6c0000000ULL,
    0x6df220000000ULL,
    0x7590230000000ULL,
    0xfbfe48000000ULL,
    0x278259c000000ULL,
    0x3d40ba2000000ULL,
    0x88e10f3000000ULL,
    0x9053269800000ULL,
    0x89990ae400000ULL,
    0xc076468a00000ULL,
    0x696a3ac300000ULL,
    0xa3dabe8580000ULL,
    0x171326d9c0000ULL,
    0x7a0489e0000ULL,
    0x68a229cf50000ULL,
    0xbe31220238000ULL,
    0xdc0f231414000ULL,
    0xffc964ba66000ULL,
    0x16ea19d41d000ULL,
    0x6a9d5a105b800ULL,
    0xdf57f2bf7c00ULL,
    0x9d2cbea045a00ULL,
    0x4fb826e9de100ULL,
    0x8782848bc9780ULL,
    0xcd4569c4dc1c0ULL,
    0xb0e2421f3a660ULL,
    0xf4571318e68b0ULL,
    0xb39d1c825d108ULL,
    0x17445c37b04cULL,
    0x31ee8008c7672ULL,
    0x6d1c4024edc17ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x7000000000000ULL,
    0x1800000000000ULL,
    0xa400000000000ULL,
    0x3600000000000ULL,
    0xeb00000000000ULL,
    0xc380000000000ULL,
    0x4bc0000000000ULL,
    0xfca0000000000ULL,
    0xc730000000000ULL,
    0xedb8000000000ULL,
    0xac14000000000ULL,
    0xf4a000000000ULL,
    0x5209000000000ULL,
    0xe1ed800000000ULL,
    0x83bc00000000ULL,
    0x84d5a00000000ULL,
    0x5c6df00000000ULL,
    0x24f8380000000ULL,
    0x91f7cc0000000ULL,
    0xd99e560000000ULL,
    0x3360b10000000ULL,
    0x3d95d38000000ULL,
    0x798b72c000000ULL,
    0x562bee2000000ULL,
    0xc69cbd1000000ULL,
    0xeee625a800000ULL,
    0x815233dc00000ULL,
    0xa4ac05a600000ULL,
    0x1fd903f900000ULL,
    0x5b061d8580000ULL,
    0x3b81fff6c0000ULL,
    0x3fc053bee0000ULL,
    0xa2a4b2f7f0000ULL,
    0x90344e3ca8000ULL,
    0xbc384d2e0c000ULL,
    0x3ad39da80e000ULL,
    0xdb6e3ff635000ULL,
    0x1d7ff3a79a800ULL,
    0xbb3042f47e400ULL,
    0x9fb9f6095d600ULL,
    0xa110413cf7f00ULL,
    0x4fca6bb841e80ULL,
    0x664e7efea03c0ULL,
    0xc48d981d51ee0ULL,
    0xeeaa3c2bf8430ULL,
    0x86de6e02f51d8ULL,
    0x95837d127ae04ULL,
    0x30c185950ff2eULL,
    0xf722c3f1b4e3bULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0x9000000000000ULL,
    0x2800000000000ULL,
    0xc400000000000ULL,
    0x6200000000000ULL,
    0x1d00000000000ULL,
    0xbc80000000000ULL,
    0x3ec0000000000ULL,
    0xebe0000000000ULL,
    0x3f90000000000ULL,
    0x28a8000000000ULL,
    0xdcf4000000000ULL,
    0x93fa000000000ULL,
    0x5ebd000000000ULL,
    0xd21a800000000ULL,
    0x482e400000000ULL,
    0xbc35a00000000ULL,
    0xcb1dd00000000ULL,
    0xf6ae080000000ULL,
    0x2ff3140000000ULL,
    0x247e6e0000000ULL,
    0x1bfee30000000ULL,
    0x4abdd68000000ULL,
    0xb81a804000000ULL,
    0x12ae62000000ULL,
    0x4ab3b71000000ULL,
    0x2cde188800000ULL,
    0xc3cdb36400000ULL,
    0x33a338aa00000ULL,
    0x5bb7236100000ULL,
    0xc65810b080000ULL,
    0x1a0aa77340000ULL,
    0x5c7568d20000ULL,
    0x6864c04ab0000ULL,
    0x80d7460078000ULL,
    0xd10a670da4000ULL,
    0x1e4210bf8a000ULL,
    0xab27a76acd000ULL,
    0xf775d683a6800ULL,
    0xa8be8071bb400ULL,
    0xe518e61bf4a00ULL,
    0x9daab71622900ULL,
    0xe476989601e80ULL,
    0xef3af34701340ULL,
    0x385e18af81a20ULL,
    0x790db350c1150ULL,
    0x9a4338a3e0d38ULL,
    0xe927237a511ccULL,
    0x7a7010a7a9bfaULL,
    0x3c3ea757cdc11ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x3000000000000ULL,
    0x6800000000000ULL,
    0xa400000000000ULL,
    0x3600000000000ULL,
    0x2f00000000000ULL,
    0x6f80000000000ULL,
    0x5c0000000000ULL,
    0x40a0000000000ULL,
    0xc9b0000000000ULL,
    0xd258000000000ULL,
    0x8a94000000000ULL,
    0x9c2a000000000ULL,
    0x396f000000000ULL,
    0x638f800000000ULL,
    0xe75e400000000ULL,
    0x2811a00000000ULL,
    0xe76a700000000ULL,
    0xa889980000000ULL,
    0xdedb2c0000000ULL,
    0x32d3860000000ULL,
    0xa04c110000000ULL,
    0xc0f8178000000ULL,
    0x7a275dc000000ULL,
    0x5ef59e2000000ULL,
    0x81b97d1000000ULL,
    0x76c2319800000ULL,
    0xc5253ccc00000ULL,
    0x497611ba00000ULL,
    0x187e0cf900000ULL,
    0xfc61a9b580000ULL,
    0xd99110d7c0000ULL,
    0x49aa17b9e0000ULL,
    0xe1ac5df470000ULL,
    0x65a81e3fa8000ULL,
    0x3ac3d0cac000ULL,
    0x74ae11a0f6000ULL,
    0xd72a0ccd15000ULL,
    0x40eba99b42800ULL,
    0x194e10cf87c00ULL,
    0x907d97923de00ULL,
    0x28661dffae900ULL,
    0xe793be3050e80ULL,
    0xf2a94d13385c0ULL,
    0xd02809bef5060ULL,
    0xeb6f60fe339b0ULL,
    0x1a898fa1afe98ULL,
    0x97d871f750c84ULL,
    0x2a541811b96beULL,
    0x60e6c03b5d07ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x1000000000000ULL,
    0xf800000000000ULL,
    0x6400000000000ULL,
    0x5e00000000000ULL,
    0x900000000000ULL,
    0xff80000000000ULL,
    0x9bc0000000000ULL,
    0xffe0000000000ULL,
    0x4ef0000000000ULL,
    0x2f38000000000ULL,
    0x294000000000ULL,
    0x980a000000000ULL,
    0x114b000000000ULL,
    0x94ee800000000ULL,
    0x573ec00000000ULL,
    0x2692a00000000ULL,
    0x2608b00000000ULL,
    0x84f280000000ULL,
    0x936f6c0000000ULL,
    0xa8fb860000000ULL,
    0x87701b0000000ULL,
    0x61f9ad8000000ULL,
    0xd8f28cc000000ULL,
    0xa3a2e2000000ULL,
    0xcf11b71000000ULL,
    0xd8c88bb800000ULL,
    0xda2e27c400000ULL,
    0x8d5eab9e00000ULL,
    0xb4a357c900000ULL,
    0xf855a38f80000ULL,
    0x446e4bd640000ULL,
    0x1e79ad99e0000ULL,
    0x3328cebf0000ULL,
    0x15da2e0e78000ULL,
    0x91e1b71cfc000ULL,
    0xff08ba5ae000ULL,
    0xbcba27f915000ULL,
    0x4b54abaf9a800ULL,
    0xace857fa5ec00ULL,
    0x933b23a16da00ULL,
    0x88908bf666b00ULL,
    0xc70b0d8270280ULL,
    0x6bca3cf539ec0ULL,
    0x32ad06049cea0ULL,
    0x1adb291fab0ULL,
    0x3f010d850d698ULL,
    0x2a813cc0d65acULL,
    0xbe43861968296ULL,
    0x23241b34f4243ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0xf000000000000ULL,
    0x7800000000000ULL,
    0x5c00000000000ULL,
    0x6a00000000000ULL,
    0x100000000000ULL,
    0x8280000000000ULL,
    0x94c0000000000ULL,
    0xaa0000000000ULL,
    0xf10000000000ULL,
    0xdc38000000000ULL,
    0xd34000000000ULL,
    0xf6ea000000000ULL,
    0x412f000000000ULL,
    0xcc09800000000ULL,
    0x735ec00000000ULL,
    0xd200600000000ULL,
    0x7d06100000000ULL,
    0x7885a80000000ULL,
    0x1dc1e40000000ULL,
    0xac26de0000000ULL,
    0xadd5f90000000ULL,
    0xbd9b928000000ULL,
    0x81a20ec000000ULL,
    0x3c92f62000000ULL,
    0xd27edd1000000ULL,
    0x3f572c9800000ULL,
    0xe15ee7fc00000ULL,
    0xcf054cbe00000ULL,
    0xf583f7c700000ULL,
    0x1d4364a280000ULL,
    0xede3d3ec40000ULL,
    0x6bf45a86a0000ULL,
    0x114afade30000ULL,
    0xbeb8003e28000ULL,
    0x29f4003884000ULL,
    0xe44a000b2e000ULL,
    0xe23f000d3d000ULL,
    0x231801b32800ULL,
    0x236ac021ffc00ULL,
    0xcc6a603c84600ULL,
    0xa9e910392eb00ULL,
    0x3cac281c3c980ULL,
    0xf54f242ab3440ULL,
    0xa8bebe253f8a0ULL,
    0xd2f7e90b65090ULL,
    0xefcc3aa63f4f8ULL,
    0xd078eafbe58a4ULL,
    0xaa57a82b7f76aULL,
    0x4ddae424c50ebULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0xb000000000000ULL,
    0x8800000000000ULL,
    0x1400000000000ULL,
    0xa200000000000ULL,
    0x4900000000000ULL,
    0x4a80000000000ULL,
    0xc340000000000ULL,
    0xfe60000000000ULL,
    0xc5b0000000000ULL,
    0x84b8000000000ULL,
    0xab54000000000ULL,
    0xf74e000000000ULL,
    0xfd0f000000000ULL,
    0x89ef800000000ULL,
    0xef1d400000000ULL,
    0x25c4200000000ULL,
    0xc321d00000000ULL,
    0xa4d0280000000ULL,
    0x508e240000000ULL,
    0x6729a20000000ULL,
    0x3fb85f0000000ULL,
    0x50d43b8000000ULL,
    0x828d50c000000ULL,
    0xc62e0a2000000ULL,
    0xd13f3b3000000ULL,
    0xb997b99800000ULL,
    0x21ebdfec00000ULL,
    0xeb1d998200000ULL,
    0xdfc50ff500000ULL,
    0xa622319080000ULL,
    0xd0566bce40000ULL,
    0x6ccfb388a0000ULL,
    0x38cfe4e9d0000ULL,
    0x3acba00d18000ULL,
    0xa3cc903a2c000ULL,
    0xd14c08210e000ULL,
    0x8e0bf42145000ULL,
    0xc66f8a1a6b800ULL,
    0xe8dd7b29bfc00ULL,
    0x6fe41986ede00ULL,
    0x4d734fc2ee500ULL,
    0x871f9198b4880ULL,
    0x41c1fbd4e2b40ULL,
    0x89223b902a6a0ULL,
    0x49d650d71e190ULL,
    0x300f8a343d008ULL,
    0xf96d7b0877f3cULL,
    0x295c19b9586ceULL,
    0x1f274ffb8c393ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x7000000000000ULL,
    0xe800000000000ULL,
    0xec00000000000ULL,
    0x6200000000000ULL,
    0x4f00000000000ULL,
    0xc680000000000ULL,
    0xe140000000000ULL,
    0x8a20000000000ULL,
    0x88f0000000000ULL,
    0xc428000000000ULL,
    0xea54000000000ULL,
    0xd09e000000000ULL,
    0x55db000000000ULL,
    0xe1f9800000000ULL,
    0x4c0a400000000ULL,
    0x9da1e00000000ULL,
    0xda36d00000000ULL,
    0xc2ced80000000ULL,
    0x3142840000000ULL,
    0x3220420000000ULL,
    0x1cf36d0000000ULL,
    0xd22f918000000ULL,
    0xc352764000000ULL,
    0xd71f1a2000000ULL,
    0x5f1fa93000000ULL,
    0x31833b800000ULL,
    0x6918cb5c00000ULL,
    0xba19d39a00000ULL,
    0xf69e1b4b00000ULL,
    0xb4df0b8080000ULL,
    0x9a789f7fc0000ULL,
    0xbcc94993a0000ULL,
    0x3444f26f50000ULL,
    0xb7a1581808000ULL,
    0x2937c426fc000ULL,
    0x1e4e221a2a000ULL,
    0xeb00fd3605000ULL,
    0x188729858f800ULL,
    0xb4476267dac00ULL,
    0x77a1e022dc600ULL,
    0xc936d0103b900ULL,
    0x6e4ed8096df80ULL,
    0x302841f02740ULL,
    0xf480421568560ULL,
    0xd6436d298df10ULL,
    0x38a7918e33888ULL,
    0xfb6765e903f4ULL,
    0x8f091a3ea9ca6ULL,
    0x8920a9042dd89ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0xb000000000000ULL,
    0x6800000000000ULL,
    0x6c00000000000ULL,
    0x3200000000000ULL,
    0xad00000000000ULL,
    0x3580000000000ULL,
    0x1240000000000ULL,
    0x9e20000000000ULL,
    0x2490000000000ULL,
    0xa418000000000ULL,
    0x5934000000000ULL,
    0x11ce000000000ULL,
    0xc18f000000000ULL,
    0x3aaf800000000ULL,
    0x97ba400000000ULL,
    0xcbe7e00000000ULL,
    0xa5f2500000000ULL,
    0xfb2bc80000000ULL,
    0x13f99c0000000ULL,
    0x76c64a0000000ULL,
    0xf3e7c50000000ULL,
    0xd1f2628000000ULL,
    0xad2b47c000000ULL,
    0x50fa022000000ULL,
    0xb440193000000ULL,
    0x1525c89800000ULL,
    0x5a15d2ec00000ULL,
    0xa8da28ba00000ULL,
    0x7bd382eb00000ULL,
    0x7fbfe0b480000ULL,
    0x67e51ef740000ULL,
    0xf7f62aaf60000ULL,
    0xe6289bc390000ULL,
    0x4e7ba80908000ULL,
    0x8858c2564000ULL,
    0x5fc4622ae6000ULL,
    0x5863090e9d000ULL,
    0x3cb060b81b800ULL,
    0x1b8f5ecd97c00ULL,
    0x3ba9caa1c5e00ULL,
    0xf03ecbe557900ULL,
    0xc4a6600d64780ULL,
    0x6657101ee6540ULL,
    0xa1fba8389c920ULL,
    0x1bc58c391a370ULL,
    0xa664621a160a8ULL,
    0x73b3092605354ULL,
    0x5b0860b377f2aULL,
    0x186b5efc9572fULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0xf000000000000ULL,
    0xe800000000000ULL,
    0x5c00000000000ULL,
    0x9200000000000ULL,
    0xe500000000000ULL,
    0x7580000000000ULL,
    0xddc0000000000ULL,
    0xb7a0000000000ULL,
    0xfe90000000000ULL,
    0x50f8000000000ULL,
    0xa9b4000000000ULL,
    0xae2a000000000ULL,
    0x2f2b000000000ULL,
    0x2ca9800000000ULL,
    0x226e400000000ULL,
    0xd34c600000000ULL,
    0x469d500000000ULL,
    0x2284080000000ULL,
    0x1d401c0000000ULL,
    0xe7e0760000000ULL,
    0xd0f7890000000ULL,
    0x3fccae8000000ULL,
    0x2cdf20c000000ULL,
    0x55e7fe2000000ULL,
    0x65f2d51000000ULL,
    0xb24938b800000ULL,
    0xb51bb9fc00000ULL,
    0xc443389a00000ULL,
    0xb060b9c700000ULL,
    0xe032b8bc80000ULL,
    0x51eaf9d540000ULL,
    0x758cd8bf60000ULL,
    0xbb8a9cc70000ULL,
    0xd55350ab68000ULL,
    0x7459f5fde4000ULL,
    0xf1a4c68fde000ULL,
    0x65926cdf5d000ULL,
    0x5a7b801d82800ULL,
    0x48f140015ec00ULL,
    0xcbcfe0091c600ULL,
    0x2d8103862900ULL,
    0xd2e1e8256f980ULL,
    0x1d730c1694940ULL,
    0x46081e2837e20ULL,
    0x4d7ac51ff8570ULL,
    0x6870d0893de58ULL,
    0x6b8cb5c472e64ULL,
    0xc4b9268af7d1aULL,
    0xe1d57cdb58cb3ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x9000000000000ULL,
    0x8800000000000ULL,
    0x3c00000000000ULL,
    0xa600000000000ULL,
    0xad00000000000ULL,
    0x6780000000000ULL,
    0xdbc0000000000ULL,
    0xd4a0000000000ULL,
    0x5e50000000000ULL,
    0x58000000000ULL,
    0x7074000000000ULL,
    0xda4a000000000ULL,
    0x3b4f000000000ULL,
    0xa2ca800000000ULL,
    0x9400000000ULL,
    0xb928600000000ULL,
    0xbfb8f00000000ULL,
    0x9dc1480000000ULL,
    0xa9a62c0000000ULL,
    0xd1d4a60000000ULL,
    0x779ce10000000ULL,
    0x8ad6e88000000ULL,
    0x1518fdc000000ULL,
    0xfa956e2000000ULL,
    0xa47c8d1000000ULL,
    0x6960ae9800000ULL,
    0x7f5ace400000ULL,
    0xc98aae8200000ULL,
    0xb3eaacdf00000ULL,
    0xca982e9180000ULL,
    0x2557ecdf40000ULL,
    0x92da4e83e0000ULL,
    0x18301ccdf0000ULL,
    0xdf298686a8000ULL,
    0x32bb70c7d4000ULL,
    0xa4740aa76000ULL,
    0x6a6461faad000ULL,
    0xb1706029da800ULL,
    0xb3ccf03ff7c00ULL,
    0x818b4817eca00ULL,
    0xafe92c3d3b500ULL,
    0x9c9e263f86980ULL,
    0x9055a13804fc0ULL,
    0x415e88bc0e720ULL,
    0x59f00df2811b0ULL,
    0x8c2608c1118ULL,
    0xa66ea111a1944ULL,
    0xb65e089891d02ULL,
    0x15764de199187ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x5000000000000ULL,
    0x2800000000000ULL,
    0x9400000000000ULL,
    0x8200000000000ULL,
    0xa100000000000ULL,
    0x1380000000000ULL,
    0x6940000000000ULL,
    0x9020000000000ULL,
    0x7d70000000000ULL,
    0xa758000000000ULL,
    0x6bd4000000000ULL,
    0x52ea000000000ULL,
    0x8cef000000000ULL,
    0x2bec800000000ULL,
    0x536c400000000ULL,
    0x4cab200000000ULL,
    0xc4ad00000000ULL,
    0xbd5f680000000ULL,
    0x66d6ec0000000ULL,
    0x1f6c320000000ULL,
    0x2ad650000000ULL,
    0xa348458000000ULL,
    0x61db95c000000ULL,
    0x8315da2000000ULL,
    0x4288c91000000ULL,
    0xb63bd79800000ULL,
    0x328460d400000ULL,
    0x3ac3d7aa00000ULL,
    0x996060f500000ULL,
    0xbd51d79880000ULL,
    0xf22b60ec40000ULL,
    0x588f57b6e0000ULL,
    0xbb3c20fb50000ULL,
    0x7f02f7b688000ULL,
    0xb485b0d61c000ULL,
    0x11c23fbfb6000ULL,
    0x8fe1ccc9e5000ULL,
    0x3d9045a6d2800ULL,
    0x164f95ef77c00ULL,
    0xb05fda1145200ULL,
    0x2b57c90262100ULL,
    0x912f57bc2e480ULL,
    0x8a0c20e690740ULL,
    0x91faf7b2a87a0ULL,
    0xae61b0ecec6b0ULL,
    0xcdd03f9b0e648ULL,
    0x49eaccc7e03d4ULL,
    0xe26ec5b1d0a36ULL,
    0x1728d5cbc83a7ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0xb000000000000ULL,
    0xb800000000000ULL,
    0x9400000000000ULL,
    0xa00000000000ULL,
    0xb00000000000ULL,
    0x480000000000ULL,
    0x7cc0000000000ULL,
    0x220000000000ULL,
    0x9d0000000000ULL,
    0xb398000000000ULL,
    0xe074000000000ULL,
    0xd00a000000000ULL,
    0xe20b000000000ULL,
    0x3d0b800000000ULL,
    0xd38cc00000000ULL,
    0x1448200000000ULL,
    0xaae9100000000ULL,
    0x4bfdb80000000ULL,
    0xf045940000000ULL,
    0x12e20e0000000ULL,
    0x75f3dd0000000ULL,
    0xb4f648000000ULL,
    0xe46b27c000000ULL,
    0xdc3e362000000ULL,
    0x46e1891000000ULL,
    0xdff6cab800000ULL,
    0x50492aec00000ULL,
    0xe8eeca8e00000ULL,
    0x8cfd2af500000ULL,
    0xdac4ca9a80000ULL,
    0xd7262afec0000ULL,
    0xec574ab720000ULL,
    0x70deeac630000ULL,
    0x22156ab408000ULL,
    0x333cfad9b4000ULL,
    0x5063529946000ULL,
    0x6c35aefced000ULL,
    0x54e97c812a800ULL,
    0xbaff63fe06c00ULL,
    0xa7c3a0168ce00ULL,
    0x4ea5d00a7a300ULL,
    0xb9159808de880ULL,
    0x9fbc843ca1840ULL,
    0x50a7b628710e0ULL,
    0xf8124932e9950ULL,
    0x703f6a9524eb8ULL,
    0x98e7fadc3e434ULL,
    0x3ef0d2a330df2ULL,
    0xefcd6ed68918fULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0xd000000000000ULL,
    0xc800000000000ULL,
    0x2400000000000ULL,
    0x6200000000000ULL,
    0x700000000000ULL,
    0x1380000000000ULL,
    0xec40000000000ULL,
    0xa8a0000000000ULL,
    0x6df0000000000ULL,
    0x2d08000000000ULL,
    0x5dd4000000000ULL,
    0xe93e000000000ULL,
    0x793b000000000ULL,
    0x913c800000000ULL,
    0x853b400000000ULL,
    0xff3aa00000000ULL,
    0x143ed00000000ULL,
    0x41bcd80000000ULL,
    0xc8ff6c0000000ULL,
    0x74d8aa0000000ULL,
    0xe6ea110000000ULL,
    0x8f03598000000ULL,
    0x17801b4000000ULL,
    0xbe46f22000000ULL,
    0xb7a53d3000000ULL,
    0x9275d3b800000ULL,
    0x874b9a7400000ULL,
    0x9075d39200000ULL,
    0x904b9a7900000ULL,
    0xabf5d38080000ULL,
    0x880b9a45c0000ULL,
    0xa955d3aee0000ULL,
    0xc6fb9a7610000ULL,
    0xf5ddd398a8000ULL,
    0x706f9a57bc000ULL,
    0xa7c3d3bd22000ULL,
    0x88e49a60a5000ULL,
    0xb35753a607800ULL,
    0x3dfbda72e2c00ULL,
    0x885bf3b345200ULL,
    0xd2a0a5a97d00ULL,
    0xb1e5ab928b280ULL,
    0x39d5266098740ULL,
    0xab3b219965960ULL,
    0x4e3aa776e6cb0ULL,
    0x9abe002bf2228ULL,
    0x857b00386c204ULL,
    0x119c80256be86ULL,
    0x1ccb40060979dULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x3000000000000ULL,
    0xa800000000000ULL,
    0x3c00000000000ULL,
    0xe200000000000ULL,
    0x5100000000000ULL,
    0x8480000000000ULL,
    0xd140000000000ULL,
    0x29a0000000000ULL,
    0xe290000000000ULL,
    0xbfa8000000000ULL,
    0xb4000000000ULL,
    0x5bfa000000000ULL,
    0x279000000000ULL,
    0x5dbf800000000ULL,
    0x685e400000000ULL,
    0xf5eb600000000ULL,
    0x8090d00000000ULL,
    0xaea8a80000000ULL,
    0x2437140000000ULL,
    0xbabc320000000ULL,
    0x83dd510000000ULL,
    0x832e428000000ULL,
    0x35f5c64000000ULL,
    0xa4591a2000000ULL,
    0x5fe9051000000ULL,
    0x7d9490a800000ULL,
    0x502b074c00000ULL,
    0x3071108a00000ULL,
    0xc99c475f00000ULL,
    0x30df0b080000ULL,
    0xc0a6d74840000ULL,
    0x8214388320000ULL,
    0xb8e8136750000ULL,
    0x96172290e8000ULL,
    0x26e8167fe4000ULL,
    0x851432144a000ULL,
    0xc36951333d000ULL,
    0x78d4428736800ULL,
    0x78cc65b2a400ULL,
    0x51e69a214de00ULL,
    0xbb7451d8e900ULL,
    0x6a7ff0bfa6580ULL,
    0x81bbd77423740ULL,
    0x1a59b8a4994a0ULL,
    0x3ceb53405d150ULL,
    0x9011c28746b48ULL,
    0xa1eb866a93b04ULL,
    0xbe927a1b4002aULL,
    0x8da9d519a0509ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0xb000000000000ULL,
    0x6800000000000ULL,
    0x6c00000000000ULL,
    0x9200000000000ULL,
    0x6d00000000000ULL,
    0x9480000000000ULL,
    0x51c0000000000ULL,
    0x2560000000000ULL,
    0xcb50000000000ULL,
    0xd968000000000ULL,
    0x1b4000000000ULL,
    0x847e000000000ULL,
    0xe7fd000000000ULL,
    0x73bf800000000ULL,
    0xf998400000000ULL,
    0x9f6de00000000ULL,
    0xaab1500000000ULL,
    0x7bf9c80000000ULL,
    0x69b8940000000ULL,
    0x689ad60000000ULL,
    0x41e9570000000ULL,
    0x9272688000000ULL,
    0x341ff24000000ULL,
    0xc2a9e2000000ULL,
    0x6d10833000000ULL,
    0x4e4cde8800000ULL,
    0xbbc6b56c00000ULL,
    0x3c655eba00000ULL,
    0xe9d7f56b00000ULL,
    0xaba93e8c80000ULL,
    0x2753e54740000ULL,
    0x8b6a969720000ULL,
    0x4cb6615370000ULL,
    0xa0fa689fd8000ULL,
    0xde3bf26e94000ULL,
    0x3adc9e05fa000ULL,
    0xa0c983085d000ULL,
    0x2b055ebbe7800ULL,
    0x3f87f5731b400ULL,
    0xae413e984de00ULL,
    0xab27e568ef100ULL,
    0xd074969066f80ULL,
    0x611b6172da140ULL,
    0xcade88b2c120ULL,
    0x1ad7b27c3e750ULL,
    0x902f7e298fad8ULL,
    0x7715d313b651cULL,
    0xdf4b1685b3f02ULL,
    0x6543214201dd9ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0xd000000000000ULL,
    0x9800000000000ULL,
    0x9c00000000000ULL,
    0xf600000000000ULL,
    0x4900000000000ULL,
    0x2080000000000ULL,
    0x140000000000ULL,
    0x84a0000000000ULL,
    0x88b0000000000ULL,
    0x9df8000000000ULL,
    0xa794000000000ULL,
    0x1f8a000000000ULL,
    0x440f000000000ULL,
    0x66c8800000000ULL,
    0xcca9c00000000ULL,
    0xe07f600000000ULL,
    0x5450f00000000ULL,
    0x96de80000000ULL,
    0x9f9f140000000ULL,
    0x1f45520000000ULL,
    0x39a1f90000000ULL,
    0xea31d38000000ULL,
    0xf7be7cc000000ULL,
    0xb8b23a2000000ULL,
    0x95fc2d1000000ULL,
    0xc391619800000ULL,
    0xa58db5f400000ULL,
    0x630be18600000ULL,
    0x934f75f700000ULL,
    0x1b6e018580000ULL,
    0x2c9d45f640000ULL,
    0x78c6099620000ULL,
    0x1d6061c350000ULL,
    0x21535382a8000ULL,
    0x2fe8bcf36c000ULL,
    0xffddda0cde000ULL,
    0x6f611d38f5000ULL,
    0x4251e9ad6a800ULL,
    0xd06951f23fc00ULL,
    0x4719dbac44200ULL,
    0x520358ddf3700ULL,
    0xd30760340b580ULL,
    0xb784f039cefc0ULL,
    0xbcc7e82c7dda0ULL,
    0x5760141d57750ULL,
    0x2e55d23c482c8ULL,
    0xe6c3907dcf24ULL,
    0xda1cb38c4676eULL,
    0x80858cd6c0d63ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x1000000000000ULL,
    0x5800000000000ULL,
    0x7c00000000000ULL,
    0x2a00000000000ULL,
    0x7300000000000ULL,
    0xe280000000000ULL,
    0xd640000000000ULL,
    0x58e0000000000ULL,
    0x1ef0000000000ULL,
    0x1128000000000ULL,
    0x3054000000000ULL,
    0x673a000000000ULL,
    0x178f000000000ULL,
    0x7246800000000ULL,
    0x4ee3c00000000ULL,
    0x27f0600000000ULL,
    0x90ab100000000ULL,
    0x5c96b80000000ULL,
    0x959fa40000000ULL,
    0x7b9b7a0000000ULL,
    0xe98cb0000000ULL,
    0x8d1e918000000ULL,
    0xa6da9c4000000ULL,
    0xb8fda22000000ULL,
    0x27ac7f1000000ULL,
    0xb813539800000ULL,
    0x22ddf34400000ULL,
    0xdef849b600000ULL,
    0x56ae284f00000ULL,
    0x1d90603280000ULL,
    0x181b1008c0000ULL,
    0x755eb836a0000ULL,
    0xab3ba42e90000ULL,
    0x55897a0ab8000ULL,
    0x5543cb047c000ULL,
    0xb26211b66a000ULL,
    0x8cb65c6545000ULL,
    0xfcb421756800ULL,
    0x2fa4af27cfc00ULL,
    0x9b958b96e3a00ULL,
    0x3919475c11f00ULL,
    0xe8dd8ba278980ULL,
    0xfdfd4762dc040ULL,
    0x8c2f8ba0fa8e0ULL,
    0xa7d6477bfcd90ULL,
    0x32fb0b9d2b668ULL,
    0x64ae874aa406cULL,
    0x7297eb8f26126ULL,
    0xc0995778878a1ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x7000000000000ULL,
    0x7800000000000ULL,
    0x7400000000000ULL,
    0x9e00000000000ULL,
    0x6700000000000ULL,
    0x1780000000000ULL,
    0xb240000000000ULL,
    0xd8e0000000000ULL,
    0xc310000000000ULL,
    0xc588000000000ULL,
    0x91b4000000000ULL,
    0x8a7e000000000ULL,
    0x992b000000000ULL,
    0xb141800000000ULL,
    0x9962c00000000ULL,
    0xfa57200000000ULL,
    0x90ecb00000000ULL,
    0x61e7580000000ULL,
    0x9391ec0000000ULL,
    0xf04d5a0000000ULL,
    0xf312c30000000ULL,
    0x9d8ef68000000ULL,
    0x75b5d94000000ULL,
    0x1c7d222000000ULL,
    0xf22f9f3000000ULL,
    0x4cc4f4b800000ULL,
    0xd226f65c00000ULL,
    0x52368ebe00000ULL,
    0xf63c856d00000ULL,
    0xcec9203f80000ULL,
    0x19d7b035c0000ULL,
    0x7caed823e0000ULL,
    0x3e072c2d90000ULL,
    0x37047a0fb8000ULL,
    0xff85733404000ULL,
    0xce402e9302000ULL,
    0x4ae2f5513d000ULL,
    0x4e11583147800ULL,
    0x2b0eec0a1ec00ULL,
    0x5372da130a600ULL,
    0xf75b032ef1b00ULL,
    0x309856b368480ULL,
    0x6f3ba97b1cec0ULL,
    0xe4d5a1136360ULL,
    0x2412c30d360b0ULL,
    0x120ef69336fe8ULL,
    0xc3f5d94e372ccULL,
    0x229d2209b7a3aULL,
    0x223f9f0076215ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0x5000000000000ULL,
    0xe800000000000ULL,
    0x2400000000000ULL,
    0xc200000000000ULL,
    0x2100000000000ULL,
    0xeb80000000000ULL,
    0xb040000000000ULL,
    0x2920000000000ULL,
    0x5dd0000000000ULL,
    0x2a28000000000ULL,
    0xcb4000000000ULL,
    0x6ada000000000ULL,
    0xf149000000000ULL,
    0x1944800000000ULL,
    0x56a0400000000ULL,
    0x3796a00000000ULL,
    0xbe0bd00000000ULL,
    0xb4e3680000000ULL,
    0x37b26c0000000ULL,
    0xdc5f9a0000000ULL,
    0x54899d0000000ULL,
    0xff21708000000ULL,
    0xe6d3ba4000000ULL,
    0xdcaa522000000ULL,
    0x970211000000ULL,
    0xdcbd82a800000ULL,
    0xa9384b5400000ULL,
    0xd67cb89a00000ULL,
    0x23de065900000ULL,
    0x7ecca03880000ULL,
    0xcb02d00c40000ULL,
    0xe87e828e0000ULL,
    0x69c22c3110000ULL,
    0x613a00c8000ULL,
    0x53764d1634000ULL,
    0x21b81880ea000ULL,
    0xecb8d6677d000ULL,
    0xf139480a1e800ULL,
    0xea7dfc1736400ULL,
    0x7dd8522e93200ULL,
    0x51cd2115f1100ULL,
    0xe78302a7d9280ULL,
    0xb6410b59fdb40ULL,
    0x3a2698a15f7a0ULL,
    0x2f51967c56cb0ULL,
    0xbdeb680e436e8ULL,
    0x73d66c0718834ULL,
    0xfd2d9a075d2e2ULL,
    0x4c349d11ae819ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x1000000000000ULL,
    0xa800000000000ULL,
    0x2400000000000ULL,
    0xde00000000000ULL,
    0xd100000000000ULL,
    0x2380000000000ULL,
    0xbc0000000000ULL,
    0x3d60000000000ULL,
    0x85f0000000000ULL,
    0x3828000000000ULL,
    0x754000000000ULL,
    0x36be000000000ULL,
    0x2f8f000000000ULL,
    0xe442800000000ULL,
    0x6ca0400000000ULL,
    0xc792a00000000ULL,
    0xf75b300000000ULL,
    0x9b3ee80000000ULL,
    0xfd4ccc0000000ULL,
    0xaea1260000000ULL,
    0x8493ff0000000ULL,
    0x9fdbad8000000ULL,
    0xac78944000000ULL,
    0x916d6e2000000ULL,
    0x1a74033000000ULL,
    0xd1ec639800000ULL,
    0xc933a74400000ULL,
    0x3c9e58a00000ULL,
    0xbce0687900000ULL,
    0xdd30200f80000ULL,
    0xc5cb700040000ULL,
    0x91e4483ae0000ULL,
    0xbcb3fc0ff0000ULL,
    0x4d09ce12d8000ULL,
    0xa404331c3c000ULL,
    0x1e060bb16a000ULL,
    0xb1042b7765000ULL,
    0x3386e3aa17800ULL,
    0xa3c7e7586fc00ULL,
    0x1965458042a00ULL,
    0x5bf4584f81100ULL,
    0xe92c482041280ULL,
    0x24d7fc0ae00c0ULL,
    0x3d7fce17f09a0ULL,
    0x12ef3316d8e30ULL,
    0x61b28bb63c418ULL,
    0x548f6b786a23cULL,
    0xc0c0c3a0e5f96ULL,
    0xc1e7974e57da1ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x3000000000000ULL,
    0x5800000000000ULL,
    0x9c00000000000ULL,
    0x2a00000000000ULL,
    0x8700000000000ULL,
    0xde80000000000ULL,
    0x40c0000000000ULL,
    0x4be0000000000ULL,
    0xee30000000000ULL,
    0xaa48000000000ULL,
    0x7f14000000000ULL,
    0x109e000000000ULL,
    0x19ef000000000ULL,
    0x9f03800000000ULL,
    0xe287c00000000ULL,
    0x3ac6600000000ULL,
    0xa4e2100000000ULL,
    0xf4b2180000000ULL,
    0x5c8b440000000ULL,
    0x99f36e0000000ULL,
    0xa72e930000000ULL,
    0x2de4838000000ULL,
    0xeb328b4000000ULL,
    0x57cf162000000ULL,
    0x6753c73000000ULL,
    0xeebbf59800000ULL,
    0x79b85c4c00000ULL,
    0x6f3b7bb600000ULL,
    0xbbf81f5700000ULL,
    0x2e1e003280000ULL,
    0xa92f001dc0000ULL,
    0xece38039a0000ULL,
    0xa0b7c03b30000ULL,
    0xe28e600e78000ULL,
    0xc0f6103d4c000ULL,
    0x10ac1817b2000ULL,
    0x82a4442e35000ULL,
    0x9390ee217f800ULL,
    0xeb59532dc7c00ULL,
    0xf68ae39faae00ULL,
    0xdef49b5ce8f00ULL,
    0x19ab0e0004180ULL,
    0x5d23830086440ULL,
    0xf8d51b86cbe60ULL,
    0x25fe0f65f8e10ULL,
    0xe71a18390da38ULL,
    0x16af442f52d0cULL,
    0xb7a56e2a643eeULL,
    0x3615932916f7dULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x9000000000000ULL,
    0x5800000000000ULL,
    0x6400000000000ULL,
    0xe200000000000ULL,
    0xfb00000000000ULL,
    0xc580000000000ULL,
    0x4f40000000000ULL,
    0x27a0000000000ULL,
    0x5b0000000000ULL,
    0x3dd8000000000ULL,
    0x3f54000000000ULL,
    0x8cca000000000ULL,
    0x8ebb000000000ULL,
    0x8f02800000000ULL,
    0x3f87c00000000ULL,
    0x3040a00000000ULL,
    0x9021500000000ULL,
    0xe9f6380000000ULL,
    0xbbfa1c0000000ULL,
    0x97a6b20000000ULL,
    0x6db2c90000000ULL,
    0x71db7b8000000ULL,
    0x715229c000000ULL,
    0xa9c82a2000000ULL,
    0x363d851000000ULL,
    0x1cc1f1b800000ULL,
    0x69e1fce400000ULL,
    0x989763b600000ULL,
    0xc0aaa5c900000ULL,
    0xc96a002080000ULL,
    0x300b000ac0000ULL,
    0x975a801f60000ULL,
    0xdf93c02ed0000ULL,
    0xc32aa02768000ULL,
    0x7f2a5026ac000ULL,
    0xb92cb80696000ULL,
    0x4029dc22c5000ULL,
    0xeeac121bba800ULL,
    0x3c68993112c00ULL,
    0x308fc3a55ea00ULL,
    0xf09ff5c158f00ULL,
    0x33f6380054a80ULL,
    0xf4fa1c1873940ULL,
    0x826b2028fae0ULL,
    0x2df2c926b1b70ULL,
    0x29fb7b9c39248ULL,
    0xa4a229e985164ULL,
    0x94302a329b78eULL,
    0xb899853862597ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x9000000000000ULL,
    0x1800000000000ULL,
    0x5400000000000ULL,
    0xce00000000000ULL,
    0x8500000000000ULL,
    0xc280000000000ULL,
    0xebc0000000000ULL,
    0x9a60000000000ULL,
    0x6d50000000000ULL,
    0xdcb8000000000ULL,
    0x1af4000000000ULL,
    0x28e000000000ULL,
    0x439d000000000ULL,
    0xec06800000000ULL,
    0xca07c00000000ULL,
    0x7307200000000ULL,
    0x8382300000000ULL,
    0xff46480000000ULL,
    0xa0a2c40000000ULL,
    0xfbb5060000000ULL,
    0xdf2eef0000000ULL,
    0x9eae208000000ULL,
    0x9eef68c000000ULL,
    0x7cc6e2000000ULL,
    0xd83a1b3000000ULL,
    0xf8336e8800000ULL,
    0xe06e43e400000ULL,
    0x1e09c8a600000ULL,
    0xf5585ce500000ULL,
    0xc0e0001b80000ULL,
    0x1290003540000ULL,
    0xa8d8003ea0000ULL,
    0x62a4000bf0000ULL,
    0x4b6001318000ULL,
    0xe6a9002f14000ULL,
    0xbae880340e000ULL,
    0x61cac01d0d000ULL,
    0x8139a0169b800ULL,
    0xb8b1f03143400ULL,
    0x14af682ab7a00ULL,
    0xdedf42f68f00ULL,
    0x344dce2b4c480ULL,
    0xaf7feb36bacc0ULL,
    0x1492068473b20ULL,
    0x81deb7ca4e010ULL,
    0x8a2286b92d298ULL,
    0x2c7077d5aac7cULL,
    0x774d26acbbd22ULL,
    0x64f887fb73e73ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x7000000000000ULL,
    0x800000000000ULL,
    0x2c00000000000ULL,
    0xa00000000000ULL,
    0xf00000000000ULL,
    0xf880000000000ULL,
    0x7740000000000ULL,
    0x3be0000000000ULL,
    0xc070000000000ULL,
    0xd9c8000000000ULL,
    0x1ed4000000000ULL,
    0x395a000000000ULL,
    0xb1ef000000000ULL,
    0xd005800000000ULL,
    0x5801400000000ULL,
    0x3401e00000000ULL,
    0x5e03900000000ULL,
    0x2101580000000ULL,
    0xd186f40000000ULL,
    0x8ac3920000000ULL,
    0xbb26630000000ULL,
    0x74527d8000000ULL,
    0x551cab4000000ULL,
    0x3c8b2a2000000ULL,
    0x3e37071000000ULL,
    0x4faab79800000ULL,
    0x46633c5c00000ULL,
    0xb745a200000ULL,
    0xde88f5b00000ULL,
    0xe200003a80000ULL,
    0x1300000fc0000ULL,
    0x9a80002420000ULL,
    0x2440000ad0000ULL,
    0xc160000e78000ULL,
    0x94300038dc000ULL,
    0x10a8000ad2000ULL,
    0xa6e40019a5000ULL,
    0x23f2003e8e800ULL,
    0x180b0001b7c00ULL,
    0xb77800c8b600ULL,
    0x374a4021a9500ULL,
    0x496603524f80ULL,
    0xa939d03c4e240ULL,
    0xfc5f383217b60ULL,
    0x666b240e1a2d0ULL,
    0x4fc6aa1bb1fc8ULL,
    0x6ca2472f492ccULL,
    0xeb91579854b16ULL,
    0x61bfac76a673dULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x3000000000000ULL,
    0x7800000000000ULL,
    0x9c00000000000ULL,
    0xd200000000000ULL,
    0x8300000000000ULL,
    0xed80000000000ULL,
    0x7440000000000ULL,
    0x16a0000000000ULL,
    0x3610000000000ULL,
    0x7728000000000ULL,
    0x9af4000000000ULL,
    0x469a000000000ULL,
    0xd54f000000000ULL,
    0x287800000000ULL,
    0x13c2c00000000ULL,
    0x2de6600000000ULL,
    0x5734d00000000ULL,
    0x527b380000000ULL,
    0x58f91c0000000ULL,
    0xcf3f2a0000000ULL,
    0x9cdec10000000ULL,
    0xe2e9fe8000000ULL,
    0x4217ee4000000ULL,
    0x512a722000000ULL,
    0x7ff70d1000000ULL,
    0x2e1fec9800000ULL,
    0xf98b334c00000ULL,
    0x40e126be00000ULL,
    0xfbb3e27700000ULL,
    0x60bd800c80000ULL,
    0x39dc03cc0000ULL,
    0xadc9e03d60000ULL,
    0x642103610000ULL,
    0x85a7582f28000ULL,
    0xf392cc0a44000ULL,
    0xd76b92122a000ULL,
    0xba511d1b6d000ULL,
    0xbd8ab4af6e800ULL,
    0x1ee2ff65c7c00ULL,
    0x82b734b8c3e00ULL,
    0xda3f3f7fc9b00ULL,
    0xac5ed4bf15180ULL,
    0x22d2f5a23f40ULL,
    0x9a718ca399ae0ULL,
    0xde5be35c9d370ULL,
    0x91281eaa97b28ULL,
    0x5ff1fe6dca344ULL,
    0x7e1f2a0ebd29aULL,
    0xb18ec115a6889ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x9000000000000ULL,
    0x9800000000000ULL,
    0xfc00000000000ULL,
    0xf600000000000ULL,
    0x8300000000000ULL,
    0xcf80000000000ULL,
    0x8340000000000ULL,
    0x3920000000000ULL,
    0x9a70000000000ULL,
    0x61f8000000000ULL,
    0x7a14000000000ULL,
    0x8faa000000000ULL,
    0x411b000000000ULL,
    0x2682800000000ULL,
    0xe9c1c00000000ULL,
    0x8ee4600000000ULL,
    0x8397f00000000ULL,
    0x2fef380000000ULL,
    0xc7ba2c0000000ULL,
    0x37b1b20000000ULL,
    0xd51ead0000000ULL,
    0x6481358000000ULL,
    0x18c49cc000000ULL,
    0x5862ea2000000ULL,
    0x2257711000000ULL,
    0x250dbfb800000ULL,
    0xde2f1de400000ULL,
    0xf55aed8600000ULL,
    0xa22780ef00000ULL,
    0xe9f0802580000ULL,
    0xf4bec014c0000ULL,
    0x5034e02de0000ULL,
    0x4259303bd0000ULL,
    0x5fa3d815c8000ULL,
    0x93b71c395c000ULL,
    0x7f186a161e000ULL,
    0x6182b11e95000ULL,
    0x5c43df9e42800ULL,
    0x70a3edd60ac00ULL,
    0x923755bf96a00ULL,
    0xf35c6cd269700ULL,
    0x692552002d980ULL,
    0xa2779d1a263c0ULL,
    0xedfaedbfb1ee0ULL,
    0x841780c0d83b0ULL,
    0x68a8801c75d48ULL,
    0x849ac02012274ULL,
    0xd0c6e007029b6ULL,
    0x9c6630332a503ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0xf000000000000ULL,
    0xc800000000000ULL,
    0x8c00000000000ULL,
    0xf600000000000ULL,
    0x2d00000000000ULL,
    0xaa80000000000ULL,
    0xc940000000000ULL,
    0x3ca0000000000ULL,
    0xfd10000000000ULL,
    0xdcc8000000000ULL,
    0x75f4000000000ULL,
    0xaffe000000000ULL,
    0xc96b000000000ULL,
    0x7865800000000ULL,
    0x7177400000000ULL,
    0x3fbce00000000ULL,
    0xd4a700000000ULL,
    0xeb31480000000ULL,
    0x289f840000000ULL,
    0x759c120000000ULL,
    0xd71e190000000ULL,
    0x725bd68000000ULL,
    0x48f8194000000ULL,
    0x50efba2000000ULL,
    0xaaa0ed3000000ULL,
    0xe0130cb800000ULL,
    0x5e4ec47c00000ULL,
    0xc0b49e9200000ULL,
    0xad5c9d5300000ULL,
    0x957e282580000ULL,
    0xf82db40740000ULL,
    0xe0c23a20a0000ULL,
    0x663ad2d50000ULL,
    0xf071ec80a8000ULL,
    0x733fb45704000ULL,
    0xd108568012000ULL,
    0x391059546d000ULL,
    0x66c8da1677800ULL,
    0x4ef6dd334ec00ULL,
    0xd87b24ac03600ULL,
    0x62ac706164d00ULL,
    0x18524bca2b80ULL,
    0x46c77074355c0ULL,
    0x3360a4800ab20ULL,
    0xef0305130f10ULL,
    0xf87c4483195c8ULL,
    0x72aa4048dcca4ULL,
    0x39850c862f9faULL,
    0x2c1c45d327b5ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0x5000000000000ULL,
    0xe800000000000ULL,
    0x2400000000000ULL,
    0x5e00000000000ULL,
    0xe300000000000ULL,
    0x1980000000000ULL,
    0xd8c0000000000ULL,
    0xea20000000000ULL,
    0x6390000000000ULL,
    0x46f8000000000ULL,
    0xda74000000000ULL,
    0xb2ca000000000ULL,
    0x59dd000000000ULL,
    0x7764800000000ULL,
    0xa374400000000ULL,
    0x264aa00000000ULL,
    0xe39b300000000ULL,
    0xc007780000000ULL,
    0x60001c0000000ULL,
    0x7000ae0000000ULL,
    0xb805450000000ULL,
    0xcc03768000000ULL,
    0x7a0070c000000ULL,
    0xbd07762000000ULL,
    0xfa83691000000ULL,
    0xc140208800000ULL,
    0x32e169d400000ULL,
    0x89b60e9a00000ULL,
    0x25696cd900000ULL,
    0x9c89583f80000ULL,
    0x68bf6c3cc0000ULL,
    0xeb15763460000ULL,
    0x2eba692b30000ULL,
    0xd416a09708000ULL,
    0x853c29e924000ULL,
    0xc5d22ea05e000ULL,
    0x239b1ce86d000ULL,
    0xa00000385a800ULL,
    0x1000003ca3400ULL,
    0xc8000004ef200ULL,
    0x7400001ba4100ULL,
    0xb60000191e280ULL,
    0xc7000029cc8c0ULL,
    0x478000108a7e0ULL,
    0x3bc000285a570ULL,
    0xf3a00034a3a38ULL,
    0xbb500010ee8d4ULL,
    0xacd80021a5abaULL,
    0xb9e400101fd73ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0xf000000000000ULL,
    0xf800000000000ULL,
    0x2400000000000ULL,
    0x8e00000000000ULL,
    0x7500000000000ULL,
    0x8e80000000000ULL,
    0xb1c0000000000ULL,
    0x68a0000000000ULL,
    0x59b0000000000ULL,
    0xc418000000000ULL,
    0x2dd4000000000ULL,
    0xf8a000000000ULL,
    0x67bb000000000ULL,
    0xd7e1800000000ULL,
    0xc0d2c00000000ULL,
    0x1509a00000000ULL,
    0x4078300000000ULL,
    0x1e43480000000ULL,
    0x61e4240000000ULL,
    0x31d2d60000000ULL,
    0x58cd90000000ULL,
    0x8cb9d78000000ULL,
    0x2463bbc000000ULL,
    0x23923e2000000ULL,
    0x666bcd1000000ULL,
    0x8a69c9b800000ULL,
    0x786986fc00000ULL,
    0xb7689f9e00000ULL,
    0xcae89fd900000ULL,
    0x5cab683b80000ULL,
    0xa14ed43140000ULL,
    0xda983e25a0000ULL,
    0xd410cd1970000ULL,
    0x5b284987a8000ULL,
    0x640b46c22c000ULL,
    0x10f93f9126000ULL,
    0x3284afea45000ULL,
    0xabc220226a800ULL,
    0x8ba1f00ff2c00ULL,
    0x76336818d6600ULL,
    0x8d5ad4182db00ULL,
    0xa5b23e2a26e80ULL,
    0x3e1bcd16c5cc0ULL,
    0x3ed1c9b1aa320ULL,
    0xd80d86c093790ULL,
    0xafa9fa546bd8ULL,
    0xd1879fcb558a4ULL,
    0x8440e812d2cfeULL,
    0xc2e7143066ebfULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x1000000000000ULL,
    0x2800000000000ULL,
    0x4c00000000000ULL,
    0x9e00000000000ULL,
    0x1900000000000ULL,
    0x9680000000000ULL,
    0x67c0000000000ULL,
    0xe9e0000000000ULL,
    0x2850000000000ULL,
    0x6598000000000ULL,
    0x2774000000000ULL,
    0x86ae000000000ULL,
    0xd77d000000000ULL,
    0xf6a2800000000ULL,
    0x6776400000000ULL,
    0x66abe00000000ULL,
    0xe779300000000ULL,
    0xcea1e80000000ULL,
    0x375240000000ULL,
    0xb4ae860000000ULL,
    0x607ef30000000ULL,
    0x4127e88000000ULL,
    0xf236cdc000000ULL,
    0x3a8a8e2000000ULL,
    0xa1cfe73000000ULL,
    0xcea068800000ULL,
    0xb0db5ac400000ULL,
    0x9b5000aa00000ULL,
    0xf01ae9e300000ULL,
    0x2d30880f80000ULL,
    0x210e543240000ULL,
    0x9a8a8e27a0000ULL,
    0x71cfe70ef0000ULL,
    0x4ea0697f8000ULL,
    0xecdb5adf54000ULL,
    0x2d5000bb46000ULL,
    0xa51ae9e66d000ULL,
    0x25b0881673800ULL,
    0x5fce54123b400ULL,
    0xe5ea8e1cb6a00ULL,
    0x3e5fe70d14900ULL,
    0x8892068ce7780ULL,
    0xe3ff5ad09c0c0ULL,
    0xce66008d8b5a0ULL,
    0x5513e9c36f990ULL,
    0x55bc083ef1f98ULL,
    0xefc5141ff860cULL,
    0x75e3ee1b55782ULL,
    0xbe50971147b67ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x3000000000000ULL,
    0x8800000000000ULL,
    0xcc00000000000ULL,
    0xc600000000000ULL,
    0xb900000000000ULL,
    0xdf80000000000ULL,
    0xac0000000000ULL,
    0x4160000000000ULL,
    0xdb0000000000ULL,
    0xd68000000000ULL,
    0x4314000000000ULL,
    0x303e000000000ULL,
    0x2c0d000000000ULL,
    0x9ea3800000000ULL,
    0xa553400000000ULL,
    0x1b1ee00000000ULL,
    0x2c9ff00000000ULL,
    0x3a5de80000000ULL,
    0x253dac0000000ULL,
    0xe5892e0000000ULL,
    0xb567ff0000000ULL,
    0x4fb2678000000ULL,
    0x9e6ea64000000ULL,
    0xd394262000000ULL,
    0xd478a33000000ULL,
    0x742d218800000ULL,
    0x1eb3b54c00000ULL,
    0x5def8f8200000ULL,
    0x87530a4300000ULL,
    0x581d081980000ULL,
    0x241f5c1240000ULL,
    0xaa1f461de0000ULL,
    0xff1d133db0000ULL,
    0xd69ba983d8000ULL,
    0xed5ba95e2c000ULL,
    0xbfb829a53a000ULL,
    0x7ec8e94c35000ULL,
    0x8bc6c983b7800ULL,
    0x1ae71976df400ULL,
    0x2d7321beaae00ULL,
    0x30eb575fdd00ULL,
    0xa0240fb212380ULL,
    0x24144a71a1bc0ULL,
    0xe2bde829501a0ULL,
    0x5b4dac08e8fb0ULL,
    0x56012e2435138ULL,
    0xc103ff1fb6d3cULL,
    0xbb8467acde5beULL,
    0x30c7a669aa3e9ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0xd000000000000ULL,
    0xe800000000000ULL,
    0x3400000000000ULL,
    0x6600000000000ULL,
    0x5d00000000000ULL,
    0x380000000000ULL,
    0xf8c0000000000ULL,
    0x5ea0000000000ULL,
    0xbc90000000000ULL,
    0xd688000000000ULL,
    0xdbf4000000000ULL,
    0x853e000000000ULL,
    0x822d000000000ULL,
    0xb064800000000ULL,
    0x4730400000000ULL,
    0x959e200000000ULL,
    0x77bef00000000ULL,
    0xd36e080000000ULL,
    0xd1018c0000000ULL,
    0x79879e0000000ULL,
    0xd7c0c10000000ULL,
    0xb6225e8000000ULL,
    0xf2d6574000000ULL,
    0x4769b62000000ULL,
    0xa702bd3000000ULL,
    0xec87488800000ULL,
    0x30435a7400000ULL,
    0xc0e4569a00000ULL,
    0xc573db7d00000ULL,
    0x9e78283180000ULL,
    0xd44b7c1340000ULL,
    0x6a579632e0000ULL,
    0xf12c4d0730000ULL,
    0xcae140b428000ULL,
    0x1276d67564000ULL,
    0x8afdc88cc2000ULL,
    0x180e1a6f8d000ULL,
    0x28b6f69e07800ULL,
    0xe7596b759f400ULL,
    0x3e1e001c13200ULL,
    0x5b7d000115100ULL,
    0x1bcc801a0a080ULL,
    0x8944025d9fc0ULL,
    0x7088201aed220ULL,
    0xa6f7f02177330ULL,
    0x56bc8819d74f8ULL,
    0x92e8cc3f879c4ULL,
    0xdac33e1ede9daULL,
    0x9da37132f34adULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0xf000000000000ULL,
    0x3800000000000ULL,
    0x6400000000000ULL,
    0x9600000000000ULL,
    0x1100000000000ULL,
    0x4d80000000000ULL,
    0xf540000000000ULL,
    0x99e0000000000ULL,
    0x4cd0000000000ULL,
    0x3e58000000000ULL,
    0x1d74000000000ULL,
    0x2cea000000000ULL,
    0x19bf000000000ULL,
    0xaca1800000000ULL,
    0xf530c00000000ULL,
    0xe28fa00000000ULL,
    0xeb2ef00000000ULL,
    0x6d9c680000000ULL,
    0xc750fc0000000ULL,
    0x321d120000000ULL,
    0x5176b0000000ULL,
    0xaf78c08000000ULL,
    0x6503c7c000000ULL,
    0x5384da2000000ULL,
    0xd846671000000ULL,
    0xd6603a9800000ULL,
    0x69090fc00000ULL,
    0x9f3ca8ae00000ULL,
    0x7f673bc900000ULL,
    0x6f13c81d80000ULL,
    0x9c7e0c2840000ULL,
    0x7817a0560000ULL,
    0x5647971850000ULL,
    0x3365d28df8000ULL,
    0x1514acce74000ULL,
    0x277c1a9976000ULL,
    0x5905a0ee4d000ULL,
    0x5184e08622800ULL,
    0x6746f7c40bc00ULL,
    0xeee49234c6600ULL,
    0x2853ab1c25300ULL,
    0xe29d608f8f680ULL,
    0xe7d237dab97c0ULL,
    0xe8d9322395fa0ULL,
    0x26b65b3ae7cf0ULL,
    0x7aca889794cc8ULL,
    0x5d4d0bd0e656cULL,
    0x9b0a001c94c22ULL,
    0x606f00326672fULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x3000000000000ULL,
    0xd800000000000ULL,
    0xb400000000000ULL,
    0x8e00000000000ULL,
    0x4900000000000ULL,
    0x7080000000000ULL,
    0xbec0000000000ULL,
    0x2f20000000000ULL,
    0x4730000000000ULL,
    0x5978000000000ULL,
    0x19d4000000000ULL,
    0x34ee000000000ULL,
    0xbbd9000000000ULL,
    0x7ea3800000000ULL,
    0x2575c00000000ULL,
    0x5299200000000ULL,
    0x86c7300000000ULL,
    0xcb27280000000ULL,
    0x8137540000000ULL,
    0x4c7a4e0000000ULL,
    0x8b52750000000ULL,
    0xf92feb8000000ULL,
    0x237b34c000000ULL,
    0xbed2462000000ULL,
    0x9d6f113000000ULL,
    0x9d9f0da800000ULL,
    0x8342d5cc00000ULL,
    0x7765439600000ULL,
    0x8bd0a0dd00000ULL,
    0xffeaa82b80000ULL,
    0x285b942e40000ULL,
    0x9fe0ee0220000ULL,
    0xe110850eb0000ULL,
    0xcec9e39e48000ULL,
    0xce6f50ee8c000ULL,
    0xda192009fe000ULL,
    0x7c07300b85000ULL,
    0x12072832d3800ULL,
    0xb07541c8a400ULL,
    0x33824e343ee00ULL,
    0xd1467533e4700ULL,
    0x1c61ebac43c80ULL,
    0x285234db728c0ULL,
    0xc6a9c61c7aaa0ULL,
    0x583ed11856e50ULL,
    0x8db02dbbd83b8ULL,
    0xe0b8e5d7f4214ULL,
    0xaf77eb987a78eULL,
    0x8d9f34d257d43ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x1000000000000ULL,
    0x800000000000ULL,
    0x9c00000000000ULL,
    0x8a00000000000ULL,
    0x7100000000000ULL,
    0xe80000000000ULL,
    0x5cc0000000000ULL,
    0x8360000000000ULL,
    0x3190000000000ULL,
    0x7528000000000ULL,
    0x5134000000000ULL,
    0x865a000000000ULL,
    0x50cf000000000ULL,
    0x9066800000000ULL,
    0x8211400000000ULL,
    0xc56f600000000ULL,
    0x7390900000000ULL,
    0xb82d280000000ULL,
    0xa5b7c40000000ULL,
    0xb39fbe0000000ULL,
    0x4928a70000000ULL,
    0xeb317e8000000ULL,
    0x8f58444000000ULL,
    0xda4ff62000000ULL,
    0xd2a4f31000000ULL,
    0x6677689800000ULL,
    0x17d674400000ULL,
    0x25fad6a200000ULL,
    0x383ec07700000ULL,
    0xcddf281a80000ULL,
    0x248cc40840000ULL,
    0xccc33e19a0000ULL,
    0xcb66e73430000ULL,
    0xcd909e8058000ULL,
    0xef2d947724000ULL,
    0x2837be1c6a000ULL,
    0x14dca70f3d000ULL,
    0x860b7e9aee800ULL,
    0x6207444b67c00ULL,
    0xbd01763b8ba00ULL,
    0xec81b30fad500ULL,
    0xa1c208b707580ULL,
    0xfe2f744dae40ULL,
    0x80517e8a246a0ULL,
    0x72c8447dea610ULL,
    0x4d67f603fd978ULL,
    0x7e90f32a0e5dcULL,
    0x6cad68a176cdaULL,
    0xe072677622c41ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0xd000000000000ULL,
    0xb800000000000ULL,
    0xf400000000000ULL,
    0x3600000000000ULL,
    0xb700000000000ULL,
    0x9980000000000ULL,
    0x6bc0000000000ULL,
    0xa820000000000ULL,
    0xac50000000000ULL,
    0x7df8000000000ULL,
    0x92b4000000000ULL,
    0xbd0a000000000ULL,
    0x1c5f000000000ULL,
    0xad20800000000ULL,
    0xfcd4c00000000ULL,
    0xc4ba200000000ULL,
    0x62d6f00000000ULL,
    0x1fbdd80000000ULL,
    0x8955dc0000000ULL,
    0x9d7bd60000000ULL,
    0x43f6f50000000ULL,
    0x169d08000000ULL,
    0x7cee80c000000ULL,
    0xb92e2e2000000ULL,
    0xe20ed91000000ULL,
    0x89dd5e9800000ULL,
    0x64e269f400000ULL,
    0x5f4888e00000ULL,
    0xfe6f9ced00000ULL,
    0x196fd83580000ULL,
    0x78eedc09c0000ULL,
    0x8729561060000ULL,
    0xc9093513f0000ULL,
    0x6a59708988000ULL,
    0x7a23b0fbd4000ULL,
    0xb55156149e000ULL,
    0x177d35039d000ULL,
    0x3ef370bb2a800ULL,
    0x85ecb0c2f3c00ULL,
    0x43a9d6103e200ULL,
    0x964df51d8c300ULL,
    0x953b509492080ULL,
    0xb51140e2cf7c0ULL,
    0x7d9e8e2b85d60ULL,
    0x3803e92d87870ULL,
    0xb4022682b05d8ULL,
    0x560185c5a9314ULL,
    0x6702a681858a2ULL,
    0x218545f6866b3ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x5000000000000ULL,
    0x2800000000000ULL,
    0xec00000000000ULL,
    0xea00000000000ULL,
    0xc500000000000ULL,
    0x9780000000000ULL,
    0xb440000000000ULL,
    0x6da0000000000ULL,
    0x2d30000000000ULL,
    0x3208000000000ULL,
    0x354000000000ULL,
    0x56de000000000ULL,
    0xb9cb000000000ULL,
    0xf6b0800000000ULL,
    0x1c48400000000ULL,
    0x33f6e00000000ULL,
    0x786a900000000ULL,
    0x1183080000000ULL,
    0x5b400c0000000ULL,
    0xdf229a0000000ULL,
    0x5ef4190000000ULL,
    0xc3ee678000000ULL,
    0xafc2174000000ULL,
    0xa3e7f22000000ULL,
    0x4d96c53000000ULL,
    0x34b915b800000ULL,
    0x471c925400000ULL,
    0x112807aa00000ULL,
    0xbfa0c74b00000ULL,
    0xc321a2280000ULL,
    0x138c591540000ULL,
    0xe0108797e0000ULL,
    0xadfc874210000ULL,
    0xb13afa0be8000ULL,
    0x325dc9310c000ULL,
    0xd0b0fabe2000ULL,
    0x59d0cb4885000ULL,
    0x291880013f800ULL,
    0xf22c40032ec00ULL,
    0xb720e028c6200ULL,
    0x92f59029cb100ULL,
    0x99ed883a28380ULL,
    0x12c34c26ad640ULL,
    0xf064fa0d93620ULL,
    0xffd6c905bcd30ULL,
    0x761b8faffb3e8ULL,
    0x38a88b6370b24ULL,
    0xe66016b963eULL,
    0x6512d03604e2dULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x1000000000000ULL,
    0xd800000000000ULL,
    0x8400000000000ULL,
    0xc600000000000ULL,
    0xed00000000000ULL,
    0xf280000000000ULL,
    0xb1c0000000000ULL,
    0x5320000000000ULL,
    0xc050000000000ULL,
    0x9f88000000000ULL,
    0x4034000000000ULL,
    0xa53e000000000ULL,
    0x68c9000000000ULL,
    0x6cd2800000000ULL,
    0x274dc00000000ULL,
    0x9795a00000000ULL,
    0xf1ae700000000ULL,
    0xae4880000000ULL,
    0x1f73040000000ULL,
    0x65df160000000ULL,
    0x60bac50000000ULL,
    0xe48ee88000000ULL,
    0xe7b7a34000000ULL,
    0xd27cbe2000000ULL,
    0x842a713000000ULL,
    0x4ea0d6a800000ULL,
    0xc810124400000ULL,
    0xd2e9c89600000ULL,
    0x5804135100000ULL,
    0x4405963980000ULL,
    0x6603050f40000ULL,
    0xfd0548a2a0000ULL,
    0x2a80d34970000ULL,
    0x35c2b63348000ULL,
    0x9520b51a54000ULL,
    0x2d546082c2000ULL,
    0x6d0da7433d000ULL,
    0xf1f1281727800ULL,
    0xf61d741756400ULL,
    0xa89b9e319ea00ULL,
    0xf359c1168a700ULL,
    0x6779fea1e8e80ULL,
    0x32a9667b24dc0ULL,
    0x996456b58a020ULL,
    0x6630d26f69f10ULL,
    0x3838e8b4e40d8ULL,
    0xf24aa365eb5d4ULL,
    0x91103e1df8702ULL,
    0xee6eb13d7cf5dULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x1000000000000ULL,
    0x6800000000000ULL,
    0x2400000000000ULL,
    0xce00000000000ULL,
    0xc900000000000ULL,
    0xb80000000000ULL,
    0xedc0000000000ULL,
    0xfda0000000000ULL,
    0xa50000000000ULL,
    0x4168000000000ULL,
    0xf9b4000000000ULL,
    0x3f5a000000000ULL,
    0xe12f000000000ULL,
    0x54d6800000000ULL,
    0x52a400000000ULL,
    0xbad6a00000000ULL,
    0xbc2fb00000000ULL,
    0xc953280000000ULL,
    0x1ded8c0000000ULL,
    0xdef3160000000ULL,
    0x10ba590000000ULL,
    0x5d1d508000000ULL,
    0xf4b604000000ULL,
    0x72201e2000000ULL,
    0x1992251000000ULL,
    0x6dcbce9800000ULL,
    0xa463054400000ULL,
    0x11f570ba00000ULL,
    0xc63a905900000ULL,
    0x6d5f960b80000ULL,
    0x8a2f192640000ULL,
    0xc557080e0000ULL,
    0x9c6a907670000ULL,
    0x24379636e8000ULL,
    0x479b1929d4000ULL,
    0x950f70b93a000ULL,
    0x904590735d000ULL,
    0xb56116085e800ULL,
    0x66715918afc00ULL,
    0xd9f9d09187a00ULL,
    0xcbfa204bf3900ULL,
    0xc0fa3e09d9280ULL,
    0x8878d50b5d2c0ULL,
    0x7938c6bc5fea0ULL,
    0xc3db794aae330ULL,
    0xf66beea486cd8ULL,
    0x6336f57672ea4ULL,
    0xe518f8b098b62ULL,
    0x634cac773d971ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0xd000000000000ULL,
    0x2800000000000ULL,
    0x7400000000000ULL,
    0x6e00000000000ULL,
    0x5500000000000ULL,
    0x6e80000000000ULL,
    0xa940000000000ULL,
    0x4c60000000000ULL,
    0xe1d0000000000ULL,
    0x8eb8000000000ULL,
    0xa274000000000ULL,
    0x4e4e000000000ULL,
    0xb779000000000ULL,
    0x5a54800000000ULL,
    0x897a400000000ULL,
    0xe754200000000ULL,
    0x33fab00000000ULL,
    0xf011480000000ULL,
    0x29b240000000ULL,
    0xb44d20000000ULL,
    0x4b609f0000000ULL,
    0xb056008000000ULL,
    0x8a7cd4c000000ULL,
    0x20d53a2000000ULL,
    0x3e3b4b3000000ULL,
    0x637baa800000ULL,
    0xe0addff400000ULL,
    0xcdeea0aa00000ULL,
    0xd78824ed00000ULL,
    0x9f5e521380000ULL,
    0xb563df1140000ULL,
    0xad56a0b9a0000ULL,
    0xe0fc24c350000ULL,
    0x1f90522298000ULL,
    0x7b5adf0034000ULL,
    0x9362208b8e000ULL,
    0xfc5664e38d000ULL,
    0x187c72312b800ULL,
    0xbfd46f12fa400ULL,
    0x43bd6895a3200ULL,
    0xe0f440d3f7900ULL,
    0x50c203848880ULL,
    0x9c1eb00eedec0ULL,
    0x9a0748199af20ULL,
    0xfb06241612190ULL,
    0x9b86521f9f1c8ULL,
    0x17c7df23b51bcULL,
    0xcd20a0b2cf5a2ULL,
    0xd9b124ee2d103ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0x1000000000000ULL,
    0x3800000000000ULL,
    0xf400000000000ULL,
    0x1200000000000ULL,
    0xe900000000000ULL,
    0x8280000000000ULL,
    0x8c40000000000ULL,
    0x7720000000000ULL,
    0xfb70000000000ULL,
    0x4c58000000000ULL,
    0xbe94000000000ULL,
    0xe24a000000000ULL,
    0x799d000000000ULL,
    0x4e76800000000ULL,
    0x50dac00000000ULL,
    0x1dd2200000000ULL,
    0xfcebd00000000ULL,
    0x5d2c280000000ULL,
    0x8fcda40000000ULL,
    0xfc5d7a0000000ULL,
    0xd690c50000000ULL,
    0xe4d7d8000000ULL,
    0x8f9911c000000ULL,
    0x8d75f22000000ULL,
    0xcf5c711000000ULL,
    0x1160f8800000ULL,
    0xee8ba0c400000ULL,
    0x53fbddae00000ULL,
    0xb4a101ed00000ULL,
    0x79b77a2c80000ULL,
    0x713dc52e40000ULL,
    0xd9c3fda6a0000ULL,
    0x6e7d1da10000ULL,
    0x7195d23748000ULL,
    0xfbcea1299c000ULL,
    0xae5ea7bf36000ULL,
    0x1f95c4f2f5000ULL,
    0x9cc807abfa800ULL,
    0x3bddd4eeab400ULL,
    0xe528fb1c3a00ULL,
    0x262860eb0fb00ULL,
    0xa44d7daa50080ULL,
    0xd29911c4e8b40ULL,
    0x3df5f2030c2a0ULL,
    0xba1c71043e990ULL,
    0xccb60f9ac8768ULL,
    0x6dbba0d15d754ULL,
    0x7a83ddbcd65d6ULL,
    0x184501ebc4997ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0xd000000000000ULL,
    0x800000000000ULL,
    0x4400000000000ULL,
    0xce00000000000ULL,
    0x4700000000000ULL,
    0x6f80000000000ULL,
    0x3540000000000ULL,
    0x6820000000000ULL,
    0x6d30000000000ULL,
    0xdab8000000000ULL,
    0x11d4000000000ULL,
    0x6dee000000000ULL,
    0xc1ff000000000ULL,
    0x2ef4800000000ULL,
    0x75d400000000ULL,
    0xba03a00000000ULL,
    0x9106b00000000ULL,
    0x483580000000ULL,
    0xc1ac0000000ULL,
    0xdc65a20000000ULL,
    0x6990250000000ULL,
    0x234fcf8000000ULL,
    0xd10a06c000000ULL,
    0x16a9da2000000ULL,
    0x2ede793000000ULL,
    0x4c44959800000ULL,
    0x38a23ff400000ULL,
    0xcbf46fa200000ULL,
    0xd5d8b6e100000ULL,
    0xd1c4820b80000ULL,
    0x78e0d515c0000ULL,
    0xd955b781e0000ULL,
    0x272f5ae850000ULL,
    0xf498000b88000ULL,
    0xbfe4002b8c000ULL,
    0x76d60006ce000ULL,
    0x726b002ce5000ULL,
    0x4cba801893800ULL,
    0xdad2403763c00ULL,
    0xe86f20149b200ULL,
    0xadbff00f2e500ULL,
    0x6656f818b5680ULL,
    0x74ac1c1d1b6c0ULL,
    0xf3dc7a0bee760ULL,
    0xc2c3c92ad4fb0ULL,
    0xb1654da48aa08ULL,
    0x3f15d3fb87f54ULL,
    0xe688ed9c084deULL,
    0xafec63d04c86bULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0xf000000000000ULL,
    0xc800000000000ULL,
    0xd400000000000ULL,
    0x7200000000000ULL,
    0xbb00000000000ULL,
    0xc80000000000ULL,
    0xadc0000000000ULL,
    0x96e0000000000ULL,
    0xff90000000000ULL,
    0x59e8000000000ULL,
    0xa34000000000ULL,
    0x8e5e000000000ULL,
    0xb229000000000ULL,
    0xc5d5800000000ULL,
    0x5e4d400000000ULL,
    0xa680200000000ULL,
    0x9ac4500000000ULL,
    0xa460380000000ULL,
    0x7752d40000000ULL,
    0x168d660000000ULL,
    0x49e3ab0000000ULL,
    0x2917668000000ULL,
    0xcb2bce4000000ULL,
    0xda50fe2000000ULL,
    0x7b0c6f3000000ULL,
    0xd7a418a800000ULL,
    0x54b7e17c00000ULL,
    0xa89f469200000ULL,
    0x404b9e4500000ULL,
    0xb386c61480000ULL,
    0x2b43bb22c0000ULL,
    0x3c22fe9920000ULL,
    0x33f00a6270000ULL,
    0xabd802b38000ULL,
    0xa6b9401424000ULL,
    0xa8be2021da000ULL,
    0xe5bd503b3d000ULL,
    0x183db8370f800ULL,
    0x1e7b940d1e400ULL,
    0x8fdb461e37600ULL,
    0x826afb043a500ULL,
    0x574de9f6d880ULL,
    0x8795a63c6540ULL,
    0xeede383e42ee0ULL,
    0xb1ebd42929a50ULL,
    0xee30e6230c318ULL,
    0x945aeb1dd7aecULL,
    0x2d29469b6a5faULL,
    0x73569e5025129ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x1000000000000ULL,
    0x3800000000000ULL,
    0x7c00000000000ULL,
    0xae00000000000ULL,
    0x8100000000000ULL,
    0xf680000000000ULL,
    0x81c0000000000ULL,
    0xc260000000000ULL,
    0x4830000000000ULL,
    0x90e8000000000ULL,
    0x2314000000000ULL,
    0x727a000000000ULL,
    0x6b2b000000000ULL,
    0xca76800000000ULL,
    0x7fccc00000000ULL,
    0xb380600000000ULL,
    0xe546300000000ULL,
    0x8ca1280000000ULL,
    0xedd1a40000000ULL,
    0x979cb60000000ULL,
    0x8c5a4f0000000ULL,
    0x753a8b8000000ULL,
    0x408b924000000ULL,
    0xe4237e2000000ULL,
    0x65151b1000000ULL,
    0x177d75b800000ULL,
    0xbfad494400000ULL,
    0x4cb2ebae00000ULL,
    0x8e29a24f00000ULL,
    0x5ef0563380000ULL,
    0x190bbf3440000ULL,
    0x5265438ba0000ULL,
    0x3034c67b70000ULL,
    0xcec803518000ULL,
    0x9d17c03d4c000ULL,
    0xcb7ee00a1a000ULL,
    0xe1aef00cf5000ULL,
    0xe5b3481fa6800ULL,
    0x3ca89437b6c00ULL,
    0xd311e0dbfa00ULL,
    0xf46c2b257a300ULL,
    0x6dd0dda9e4980ULL,
    0xd79b2d4b2e4c0ULL,
    0x6c58bd9db36a0ULL,
    0x65391d7c41990ULL,
    0x788b9587a0958ULL,
    0x9827b959712fcULL,
    0xcb13a3981870eULL,
    0x967e3643cdc19ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0xf000000000000ULL,
    0xa800000000000ULL,
    0x4400000000000ULL,
    0x2e00000000000ULL,
    0x1d00000000000ULL,
    0x980000000000ULL,
    0x3fc0000000000ULL,
    0x73e0000000000ULL,
    0x6ff0000000000ULL,
    0x60a8000000000ULL,
    0xdc54000000000ULL,
    0xf27a000000000ULL,
    0xe36d000000000ULL,
    0xddb1800000000ULL,
    0x628e400000000ULL,
    0xd40a00000000ULL,
    0xaca1b00000000ULL,
    0x8c56880000000ULL,
    0xea7c9c0000000ULL,
    0x2f69260000000ULL,
    0x47b71b0000000ULL,
    0xf988bd8000000ULL,
    0x5dc30c4000000ULL,
    0xb4e68e2000000ULL,
    0xdd70771000000ULL,
    0xffedb38800000ULL,
    0x1ff43b7c00000ULL,
    0x88a81d8a00000ULL,
    0xb852bc4100000ULL,
    0x2c78062380000ULL,
    0x5668eb2b40000ULL,
    0x903695a060000ULL,
    0x734a2062f0000ULL,
    0x63a3201d78000ULL,
    0xcad6f01dbc000ULL,
    0xd33da819ca000ULL,
    0x45ce6c03a5000ULL,
    0xb2e68e0806800ULL,
    0xc470773dd7400ULL,
    0xf86db3b83e600ULL,
    0xcd343b730a900ULL,
    0x5ac81d8584a80ULL,
    0xac62bc7b162c0ULL,
    0x1130061c1f420ULL,
    0xf8cceb2d1bf70ULL,
    0xb649585cc018ULL,
    0x73b32078733acULL,
    0x3f88a02339256ULL,
    0x24c5b0385cc81ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x9000000000000ULL,
    0x8800000000000ULL,
    0x8400000000000ULL,
    0xbe00000000000ULL,
    0x8100000000000ULL,
    0x5780000000000ULL,
    0x7340000000000ULL,
    0x23e0000000000ULL,
    0xa490000000000ULL,
    0x48a8000000000ULL,
    0xa5b4000000000ULL,
    0x819a000000000ULL,
    0x7fef000000000ULL,
    0x1852800000000ULL,
    0x540d400000000ULL,
    0x78c7a00000000ULL,
    0xc2a7300000000ULL,
    0xcc77680000000ULL,
    0x9cbfec0000000ULL,
    0x44da220000000ULL,
    0x190d8b0000000ULL,
    0x3544f28000000ULL,
    0x7ee1484000000ULL,
    0x21106a2000000ULL,
    0x10ec171000000ULL,
    0x66d4189800000ULL,
    0x4cb1f6400000ULL,
    0x8e63528200000ULL,
    0xc8d6787100000ULL,
    0x4dcf021780000ULL,
    0x3de7fb1440000ULL,
    0x95943aafe0000ULL,
    0x67299459d0000ULL,
    0x4af5202578000ULL,
    0x107a703864000ULL,
    0x6078c8304a000ULL,
    0x387cdc31fd000ULL,
    0x547f4a1f7e800ULL,
    0xfe79670b0fc00ULL,
    0x497e50b346a00ULL,
    0x1bfa83750a500ULL,
    0x813bb8999d680ULL,
    0x50982f4aef0c0ULL,
    0x806e3aa597fa0ULL,
    0x1f169470f36b0ULL,
    0xd1efa00139c08ULL,
    0x5153301f84fecULL,
    0xe78d68159b8eaULL,
    0x2580ec3285a51ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x7000000000000ULL,
    0xb800000000000ULL,
    0x4c00000000000ULL,
    0x7e00000000000ULL,
    0xd100000000000ULL,
    0x7c80000000000ULL,
    0x91c0000000000ULL,
    0xaba0000000000ULL,
    0x7f70000000000ULL,
    0x4588000000000ULL,
    0x2b94000000000ULL,
    0x1f9e000000000ULL,
    0xf49000000000ULL,
    0xdfb1800000000ULL,
    0x82aec00000000ULL,
    0xad20e00000000ULL,
    0x75b3b00000000ULL,
    0xd1ac280000000ULL,
    0x66a5f40000000ULL,
    0x75f2360000000ULL,
    0x514f510000000ULL,
    0xbeb0e18000000ULL,
    0xe62eb74000000ULL,
    0xe77e2000000ULL,
    0x1813d53000000ULL,
    0x33d81fa800000ULL,
    0x21aaa25c00000ULL,
    0x1ea6018e00000ULL,
    0x99f0076300000ULL,
    0x5f4cd61780000ULL,
    0xd7b5e11840000ULL,
    0xd6ad499920000ULL,
    0xef25836b70000ULL,
    0x62b5a83b68000ULL,
    0x302f34089c000ULL,
    0xf5e4d639c2000ULL,
    0x9e91e106d5000ULL,
    0xf91b499c2f800ULL,
    0x1588836b7e400ULL,
    0x23922833e6600ULL,
    0x4b9cf431d2b00ULL,
    0x4d4bb60aedb80ULL,
    0xc8b5912c2bac0ULL,
    0x632e018088ea0ULL,
    0x3e6407760c8d0ULL,
    0x9ed2d62f3ad58ULL,
    0x79fce12731884ULL,
    0xcd9cc980488a6ULL,
    0xb04b4346ec7cdULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x5000000000000ULL,
    0x2800000000000ULL,
    0x4c00000000000ULL,
    0x9e00000000000ULL,
    0xf100000000000ULL,
    0xe580000000000ULL,
    0x58c0000000000ULL,
    0xb5e0000000000ULL,
    0xcf10000000000ULL,
    0x71b8000000000ULL,
    0xc5b4000000000ULL,
    0xd48e000000000ULL,
    0xf67f000000000ULL,
    0xdcd0800000000ULL,
    0xa2dc400000000ULL,
    0xe8e7e00000000ULL,
    0x2491300000000ULL,
    0x907fa80000000ULL,
    0x89d73c0000000ULL,
    0xf55efe0000000ULL,
    0x8f206b0000000ULL,
    0xadf3e28000000ULL,
    0xae292cc000000ULL,
    0x8b4e362000000ULL,
    0xbb1e273000000ULL,
    0x83549800000ULL,
    0xb7444bd400000ULL,
    0xd62202aa00000ULL,
    0xc4731ce300000ULL,
    0x8ef1e1f80000ULL,
    0x9faa5b1840000ULL,
    0xb98acaab60000ULL,
    0x65f950d130000ULL,
    0x5911a820f8000ULL,
    0x3cb83c2c84000ULL,
    0xa6367e1a8e000ULL,
    0x49482b0f1d000ULL,
    0x5c1a02ab3b800ULL,
    0x68071ccb6bc00ULL,
    0xec011e01a2200ULL,
    0xae055b265e100ULL,
    0x89024ab214780ULL,
    0x818110c7e68c0ULL,
    0x8ac04821704a0ULL,
    0xdae20c27991f0ULL,
    0xdb975613b4678ULL,
    0xccfc571b7646cULL,
    0x28939cb3196aaULL,
    0xae7a07f874083ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x9000000000000ULL,
    0xa800000000000ULL,
    0xa400000000000ULL,
    0xc200000000000ULL,
    0x7700000000000ULL,
    0x4080000000000ULL,
    0xc040000000000ULL,
    0xc0a0000000000ULL,
    0xda70000000000ULL,
    0xf1e8000000000ULL,
    0x2514000000000ULL,
    0x1ffa000000000ULL,
    0x846b000000000ULL,
    0x92d2800000000ULL,
    0xbf98400000000ULL,
    0xcefaa00000000ULL,
    0xd1e9d00000000ULL,
    0x1512d80000000ULL,
    0xc7f8b40000000ULL,
    0x18696a0000000ULL,
    0x5cd5590000000ULL,
    0xae99a58000000ULL,
    0x3b78804000000ULL,
    0x2629922000000ULL,
    0x55777d1000000ULL,
    0x1d6a37b800000ULL,
    0xf354fd6400000ULL,
    0x5259258a00000ULL,
    0x659fc07900000ULL,
    0x85fbb22880000ULL,
    0x2f6ded29c0000ULL,
    0xfc50cf8220000ULL,
    0xfeddd97d10000ULL,
    0x53d8378aa8000ULL,
    0x585bfd525c000ULL,
    0x6699a584da000ULL,
    0x4f78805095000ULL,
    0xac299215f6800ULL,
    0x16777d3a96c00ULL,
    0x37ea378a66a00ULL,
    0xe014fd40ff100ULL,
    0x107925a29a280ULL,
    0x8afc048f5b40ULL,
    0xf433b22e86960ULL,
    0x1049ed104efd0ULL,
    0xd2e2cf9f62528ULL,
    0x85d2d94e60324ULL,
    0x2f18b7ac70f76ULL,
    0x46bcbd7159b91ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0xb000000000000ULL,
    0x4800000000000ULL,
    0x7400000000000ULL,
    0x4600000000000ULL,
    0xff00000000000ULL,
    0x4680000000000ULL,
    0xea40000000000ULL,
    0xdc60000000000ULL,
    0x290000000000ULL,
    0x2b88000000000ULL,
    0x9934000000000ULL,
    0xefba000000000ULL,
    0xd10b000000000ULL,
    0x173800000000ULL,
    0x6adf400000000ULL,
    0xda1d200000000ULL,
    0xce3bf00000000ULL,
    0xb1cf180000000ULL,
    0xad57240000000ULL,
    0xc9285a0000000ULL,
    0x44844f0000000ULL,
    0x5b41228000000ULL,
    0xf1e3c54000000ULL,
    0x5853e22000000ULL,
    0xaaacdb1000000ULL,
    0x7540c0b800000ULL,
    0x6ae01e6c00000ULL,
    0x40d2a2b200000ULL,
    0x33ec854d00000ULL,
    0x95a6c20980000ULL,
    0x4f332b03c0000ULL,
    0x48bdd8bba0000ULL,
    0xfb883a4b90000ULL,
    0x2133789498000ULL,
    0x33bc8a7264000ULL,
    0x53094092c2000ULL,
    0xf0745e5f1d000ULL,
    0xa75c029756800ULL,
    0x30d8356f76c00ULL,
    0x71cfa2626e00ULL,
    0x29bbff229ed00ULL,
    0x6e089aadabc80ULL,
    0xa7f45155d13c0ULL,
    0x309b8012f9a60ULL,
    0x4e7b400d54d90ULL,
    0xb8af20014bbe8ULL,
    0xdc44f037a13fcULL,
    0xcb6698099046aULL,
    0x6013641198045ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x1000000000000ULL,
    0x6800000000000ULL,
    0xcc00000000000ULL,
    0x7a00000000000ULL,
    0x9d00000000000ULL,
    0x5880000000000ULL,
    0xd3c0000000000ULL,
    0xe4a0000000000ULL,
    0xdd30000000000ULL,
    0x8e8000000000ULL,
    0x53d4000000000ULL,
    0x983e000000000ULL,
    0x786b000000000ULL,
    0x6c12800000000ULL,
    0xf69a400000000ULL,
    0x405de00000000ULL,
    0x987a100000000ULL,
    0xc08cc80000000ULL,
    0xdbc2f40000000ULL,
    0xf8a3660000000ULL,
    0x2f33a90000000ULL,
    0x49ecc38000000ULL,
    0x1957e44000000ULL,
    0x1afece2000000ULL,
    0xbe4a0d3000000ULL,
    0xffe40db800000ULL,
    0x4252e94400000ULL,
    0x1d7e43ba00000ULL,
    0xec0da44300000ULL,
    0x36032e0680000ULL,
    0x27001d1340000ULL,
    0x2580c5b420000ULL,
    0x9b441d43f0000ULL,
    0x5f63259da8000ULL,
    0xf5950d530c000ULL,
    0xafdd6d929a000ULL,
    0xc63db97345000ULL,
    0x936beb8b07800ULL,
    0x3390005aa6c00ULL,
    0xf0dde03c96a00ULL,
    0x47ba103e5f900ULL,
    0xbe2cc81e82f80ULL,
    0x8bf2f40841440ULL,
    0xc0cb6626a0120ULL,
    0x6327a902b0ed0ULL,
    0x4f72c38689018ULL,
    0x210ce4607dfe4ULL,
    0x26844e1972faeULL,
    0xc8c44d2fe8001ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x2000000000000ULL,
    0xf000000000000ULL,
    0xa800000000000ULL,
    0x3400000000000ULL,
    0x1200000000000ULL,
    0x3700000000000ULL,
    0xc680000000000ULL,
    0x4c0000000000ULL,
    0xbae0000000000ULL,
    0x4e70000000000ULL,
    0xe218000000000ULL,
    0x1dd4000000000ULL,
    0xb2ca000000000ULL,
    0xa9d000000000ULL,
    0xb811800000000ULL,
    0x63ae400000000ULL,
    0x75ab200000000ULL,
    0x98ac500000000ULL,
    0x8d2a580000000ULL,
    0x56f840000000ULL,
    0x104cce0000000ULL,
    0x45e3b0000000ULL,
    0x89f0918000000ULL,
    0x3d5ba9c000000ULL,
    0x1e76362000000ULL,
    0xfa1eaf1000000ULL,
    0xa1d4a78800000ULL,
    0x64cc06fc00000ULL,
    0x8799118a00000ULL,
    0x7d91e9dd00000ULL,
    0xb3ef162c80000ULL,
    0xfc8bff21c0000ULL,
    0xaabd7f93a0000ULL,
    0x2584c2f030000ULL,
    0x40457fa038000ULL,
    0xf120c2c35c000ULL,
    0x5e177fa5a6000ULL,
    0x26a9c2e785000ULL,
    0x542cffb1aa800ULL,
    0x2ea82f10b400ULL,
    0xaf0e5fbeba600ULL,
    0xd7fc92e0c2900ULL,
    0x992527be7e480ULL,
    0xa1246ce09540ULL,
    0xe4aa31b864760ULL,
    0x3b29b9e57b310ULL,
    0x586f4e16639b8ULL,
    0x8dc97b06ce0acULL,
    0x481831b1f0fa6ULL,
    0x26d0b9c3985f7ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x7000000000000ULL,
    0xc800000000000ULL,
    0x9400000000000ULL,
    0x6a00000000000ULL,
    0xed00000000000ULL,
    0x9f80000000000ULL,
    0x3140000000000ULL,
    0x21a0000000000ULL,
    0x4b50000000000ULL,
    0x2e68000000000ULL,
    0x1334000000000ULL,
    0x1f5a000000000ULL,
    0x356b000000000ULL,
    0x3fb5800000000ULL,
    0xa69b400000000ULL,
    0xef0c200000000ULL,
    0xa780900000000ULL,
    0x2d40880000000ULL,
    0x3fa78c0000000ULL,
    0xbc50720000000ULL,
    0x94e8790000000ULL,
    0x29f4dc8000000ULL,
    0x65bfcc4000000ULL,
    0xb29b5a2000000ULL,
    0xc50b251000000ULL,
    0xaa8786b800000ULL,
    0xc2c0e95c00000ULL,
    0xc6e6dc9200000ULL,
    0x9f0cc7500000ULL,
    0xb5bcda0280000ULL,
    0xea9f653740000ULL,
    0xe90c26ade0000ULL,
    0x9c84397550000ULL,
    0xd1c5f480e8000ULL,
    0xde67905c94000ULL,
    0x4a35802efa000ULL,
    0x3adb403fdd000ULL,
    0xb12c20225e800ULL,
    0xad90902adec00ULL,
    0xea8888249f600ULL,
    0xf3c38c21ffd00ULL,
    0xe762720aef880ULL,
    0x5fb7791767e40ULL,
    0x969b5cace3c20ULL,
    0xc70f8c7591f30ULL,
    0x4382fa38c8748ULL,
    0x8f40f52365ea4ULL,
    0x46a32e8ea29d2ULL,
    0x49d3f56af1f41ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xa000000000000ULL,
    0xf000000000000ULL,
    0xb800000000000ULL,
    0x4400000000000ULL,
    0x4600000000000ULL,
    0xf700000000000ULL,
    0xa180000000000ULL,
    0xc9c0000000000ULL,
    0x1d20000000000ULL,
    0xe610000000000ULL,
    0x89b8000000000ULL,
    0x4a74000000000ULL,
    0xa1ca000000000ULL,
    0x4ab9000000000ULL,
    0x55f1800000000ULL,
    0x7b0ac00000000ULL,
    0x401ca00000000ULL,
    0x3526700000000ULL,
    0xa17580000000ULL,
    0x63bf9c0000000ULL,
    0xf775860000000ULL,
    0x4d4fbd0000000ULL,
    0xd7fd628000000ULL,
    0x9196e2c000000ULL,
    0x1f7dfe2000000ULL,
    0x5ad1911000000ULL,
    0xc4189ca800000ULL,
    0x932373fc00000ULL,
    0xad17628e00000ULL,
    0x8a3fe2c100000ULL,
    0xc2b47e1980000ULL,
    0x526f5111c0000ULL,
    0x80ee3cae60000ULL,
    0x4eac03df70000ULL,
    0x3d49ba98c8000ULL,
    0x2ffebec544000ULL,
    0x759758138e000ULL,
    0xa97f9c312d000ULL,
    0x15d586015a800ULL,
    0x219fbd345a400ULL,
    0x1ce5628fda600ULL,
    0x4732e2d91bb00ULL,
    0xcdaffe03fba80ULL,
    0x82cc9112cadc0ULL,
    0x53b1cb8a3360ULL,
    0xc734b3e377170ULL,
    0x8da8429380298ULL,
    0x22ce52eac1c34ULL,
    0xf53c0634e126aULL,
    0x7f317d203083bULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x7000000000000ULL,
    0x4800000000000ULL,
    0xec00000000000ULL,
    0xaa00000000000ULL,
    0x6900000000000ULL,
    0xf680000000000ULL,
    0xbec0000000000ULL,
    0xcce0000000000ULL,
    0x1870000000000ULL,
    0x2d58000000000ULL,
    0x13d4000000000ULL,
    0x228a000000000ULL,
    0x935f000000000ULL,
    0x54d5800000000ULL,
    0xeb0b400000000ULL,
    0x201be00000000ULL,
    0x1d72900000000ULL,
    0x31df680000000ULL,
    0xa411040000000ULL,
    0x68e82e0000000ULL,
    0x7de8bb0000000ULL,
    0x596d318000000ULL,
    0x4aaba3c000000ULL,
    0x46cb262000000ULL,
    0x6b7b6f1000000ULL,
    0xf946179800000ULL,
    0x10a0ccdc00000ULL,
    0x45531b200000ULL,
    0xa6cfa3eb00000ULL,
    0x5b79261280000ULL,
    0xd1406f1640000ULL,
    0x8ca197b7a0000ULL,
    0xe6508cc8b0000ULL,
    0x23c951abb8000ULL,
    0x7fd73f75c000ULL,
    0x6822e2476000ULL,
    0xb6c7bb3d05000ULL,
    0x40e0b18c3a800ULL,
    0xc274e3ea7bc00ULL,
    0xc5ac635db600ULL,
    0x956ff096bd00ULL,
    0x364cff84d2780ULL,
    0x36ba88ce8e640ULL,
    0xba26ffad783a0ULL,
    0x789588f5bd510ULL,
    0xff2b7fade7938ULL,
    0x278ac8f64d5acULL,
    0x8fda9f867eee6ULL,
    0xe31758c460cdfULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x6000000000000ULL,
    0x9000000000000ULL,
    0x7800000000000ULL,
    0x8400000000000ULL,
    0xa00000000000ULL,
    0xfd00000000000ULL,
    0x4080000000000ULL,
    0x9c40000000000ULL,
    0xbee0000000000ULL,
    0xae90000000000ULL,
    0xbd48000000000ULL,
    0xcfb4000000000ULL,
    0xaefe000000000ULL,
    0xdf4f000000000ULL,
    0xeb6800000000ULL,
    0x7ec00000000ULL,
    0x240fa00000000ULL,
    0x75d5100000000ULL,
    0xf62d080000000ULL,
    0xb1e5f40000000ULL,
    0x57121a0000000ULL,
    0xb8cfb0000000ULL,
    0x8017628000000ULL,
    0x860e874000000ULL,
    0xd4d0322000000ULL,
    0xc8a9df3000000ULL,
    0x32a7509800000ULL,
    0xa877586400000ULL,
    0xf7df62be00000ULL,
    0xe8fa875100000ULL,
    0xe44e323a80000ULL,
    0xb536df2b40000ULL,
    0x47b9d09620000ULL,
    0x4d2d986210000ULL,
    0xca66c29338000ULL,
    0x70d49745e4000ULL,
    0xf2abba05f2000ULL,
    0x47a2eb3fbd000ULL,
    0x84f2ea9227800ULL,
    0x9d9ab37e67c00ULL,
    0x251b083fc7a00ULL,
    0xfd5ef43616b00ULL,
    0x29ba9a074e680ULL,
    0xea2d3b251b840ULL,
    0x6fe642b401620ULL,
    0xb8115776010d0ULL,
    0xa20c9a3d00ce8ULL,
    0x2ed63b0880cacULL,
    0xddaec29840f2aULL,
    0x8e209757a158dULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0x2000000000000ULL,
    0x1000000000000ULL,
    0x3800000000000ULL,
    0xbc00000000000ULL,
    0x2a00000000000ULL,
    0xa100000000000ULL,
    0x7580000000000ULL,
    0x14c0000000000ULL,
    0x31a0000000000ULL,
    0xdeb0000000000ULL,
    0xba08000000000ULL,
    0x2154000000000ULL,
    0xd35e000000000ULL,
    0x860d000000000ULL,
    0xcb52800000000ULL,
    0x525ec00000000ULL,
    0xe388600000000ULL,
    0xe792100000000ULL,
    0xdffe280000000ULL,
    0x173a9c0000000ULL,
    0xfc9fbe0000000ULL,
    0x8b28090000000ULL,
    0xd0a2cf8000000ULL,
    0x4b36e34000000ULL,
    0x9ecd762000000ULL,
    0x38f7453000000ULL,
    0x89efb98800000ULL,
    0xaa01a64400000ULL,
    0x6102cfae00000ULL,
    0x5586e35f00000ULL,
    0x4c5762280000ULL,
    0x9a3451c40000ULL,
    0x62b1b99b60000ULL,
    0x900ca66e30000ULL,
    0x80504fa8e8000ULL,
    0xa6d82340ec000ULL,
    0x92cd161162000ULL,
    0xfaf1551125000ULL,
    0x8cef91a3df800ULL,
    0x59863a781f400ULL,
    0xc6c7f1b4bea00ULL,
    0xca42a5c2eb00ULL,
    0x9131d99d57980ULL,
    0x37cab64942c40ULL,
    0xd9706786f4aa0ULL,
    0x332fbf5946570ULL,
    0xaca0283b7b578ULL,
    0x41379c0300364ULL,
    0x2fcd3e3080a1eULL,
    0x7576c90141dbdULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0xb000000000000ULL,
    0x1800000000000ULL,
    0xa400000000000ULL,
    0x3200000000000ULL,
    0x7500000000000ULL,
    0xbb80000000000ULL,
    0xc2c0000000000ULL,
    0xa220000000000ULL,
    0xe830000000000ULL,
    0xfda8000000000ULL,
    0xd854000000000ULL,
    0xa5fe000000000ULL,
    0xbdab000000000ULL,
    0xf857800000000ULL,
    0xf5f9c00000000ULL,
    0x15aba00000000ULL,
    0x4456d00000000ULL,
    0x63ff480000000ULL,
    0x52afec0000000ULL,
    0x8ad36e0000000ULL,
    0x1abf850000000ULL,
    0x324ebb8000000ULL,
    0xc0c1924000000ULL,
    0xf26062000000ULL,
    0x17b0793000000ULL,
    0xbd68bdb800000ULL,
    0x1771eb6c00000ULL,
    0x524ebba600000ULL,
    0xb0c1925900000ULL,
    0xf726061480000ULL,
    0x3b0790140000ULL,
    0x9768bd90e0000ULL,
    0xc671eb75b0000ULL,
    0xdbcebb8208000ULL,
    0x701927e4c000ULL,
    0xee8606050a000ULL,
    0x29407907e5000ULL,
    0xc8e0bd9117800ULL,
    0xf615eb60d6c00ULL,
    0x8398bb8377e00ULL,
    0x62fe927527700ULL,
    0xb32f86291f680ULL,
    0x6112b9399a740ULL,
    0x251c9db7fdb20ULL,
    0x47bafb49034b0ULL,
    0xf5cc53a4a9d38ULL,
    0x7407ae629d254ULL,
    0x5a03a03d7314eULL,
    0x2902d01d01eb9ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0x7000000000000ULL,
    0xf800000000000ULL,
    0x4c00000000000ULL,
    0xce00000000000ULL,
    0xad00000000000ULL,
    0xed80000000000ULL,
    0x2f40000000000ULL,
    0xfe60000000000ULL,
    0xb690000000000ULL,
    0x2298000000000ULL,
    0x829c000000000ULL,
    0xd29e000000000ULL,
    0x3a9d000000000ULL,
    0xfe9e800000000ULL,
    0x8499400000000ULL,
    0xab9b200000000ULL,
    0x251d500000000ULL,
    0x4ad8380000000ULL,
    0x767f540000000ULL,
    0x11ce2e0000000ULL,
    0x7ba1dd0000000ULL,
    0x6d30698000000ULL,
    0x1fab7d4000000ULL,
    0x753069a000000ULL,
    0x63ab7d5000000ULL,
    0x233069b800000ULL,
    0xf2ab7d4c00000ULL,
    0xf8b0698600000ULL,
    0x3ceb7d5f00000ULL,
    0x255069b580000ULL,
    0x83b7d7440000ULL,
    0x1428698ee0000ULL,
    0x13777d7f90000ULL,
    0x1a4e69b178000ULL,
    0x1de67d5234000ULL,
    0x14d6e9b9de000ULL,
    0x217e3d7293000ULL,
    0x934d498d79800ULL,
    0xba672d7c34400ULL,
    0x8c90d1b2de200ULL,
    0x6d9c695d12100ULL,
    0x7c1de79838e80ULL,
    0x455fb05455440ULL,
    0x4a3b980a8ee60ULL,
    0x572a4409ca910ULL,
    0x43f5b62efd6d8ULL,
    0x508b990722e64ULL,
    0x78c5dfadb177eULL,
    0xde20e45cc8391ULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0xe000000000000ULL,
    0x3000000000000ULL,
    0xc800000000000ULL,
    0x1c00000000000ULL,
    0xba00000000000ULL,
    0xff00000000000ULL,
    0x9980000000000ULL,
    0x1c40000000000ULL,
    0xeca0000000000ULL,
    0x8b90000000000ULL,
    0xd838000000000ULL,
    0x703c000000000ULL,
    0x1c3e000000000ULL,
    0x8e39000000000ULL,
    0x5d38800000000ULL,
    0xb6bec00000000ULL,
    0x49fe200000000ULL,
    0x86dbf00000000ULL,
    0xee0c080000000ULL,
    0x4310c40000000ULL,
    0xa4fc260000000ULL,
    0x8c5d430000000ULL,
    0xf9cc1f8000000ULL,
    0x60f45e4000000ULL,
    0x284c1fa000000ULL,
    0x20b45e5000000ULL,
    0x9eec1f9800000ULL,
    0x64245e5c00000ULL,
    0x17541faa00000ULL,
    0x14585e5b00000ULL,
    0x5dca1f8480000ULL,
    0xeef15e64c0000ULL,
    0x414a9fa2e0000ULL,
    0x34339e63d0000ULL,
    0xf82abf99c8000ULL,
    0xb7416e4134000ULL,
    0x932637afc6000ULL,
    0x32d36a5d3b000ULL,
    0x621a31a8c9800ULL,
    0xb66cd97eb5400ULL,
    0x28e2a63f87a00ULL,
    0x233683131af00ULL,
    0xedacbf8df8280ULL,
    0x9046e62ac0c0ULL,
    0x6480b7ae7b2a0ULL,
    0x4ec4aa6e683d0ULL,
    0xff64918d44238ULL,
    0xf675e9467f6dcULL,
    0xc58e8e2fb7246ULL,
    0x1c54b726827a5ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0xf000000000000ULL,
    0x4800000000000ULL,
    0xe400000000000ULL,
    0x9e00000000000ULL,
    0x8f00000000000ULL,
    0x5280000000000ULL,
    0x140000000000ULL,
    0xada0000000000ULL,
    0xc10000000000ULL,
    0x15a8000000000ULL,
    0x2dac000000000ULL,
    0x41aa000000000ULL,
    0x9baf000000000ULL,
    0x7aa8800000000ULL,
    0xef2ac00000000ULL,
    0x58ede00000000ULL,
    0x6a09100000000ULL,
    0x44bd680000000ULL,
    0xf87fc0000000ULL,
    0x36c3f60000000ULL,
    0xf7609b0000000ULL,
    0x2175fb8000000ULL,
    0xd5dad6c000000ULL,
    0x6df5fba000000ULL,
    0x9b9ad6f000000ULL,
    0x32d5fb8800000ULL,
    0x66cad6cc00000ULL,
    0xc2ddfb9a00000ULL,
    0xa376d6f500000ULL,
    0x8dffbbd80000ULL,
    0x9a75d6d6c0000ULL,
    0x615d7ba920000ULL,
    0xefb016d690000ULL,
    0xeeb81b8248000ULL,
    0x6683c6d594000ULL,
    0xe740938722000ULL,
    0x2ea12adeff000ULL,
    0xd4940d9748800ULL,
    0x4de94df814c00ULL,
    0xb98a8009e2a00ULL,
    0x8079c003de700ULL,
    0xade7603fd9d80ULL,
    0xa430d0295c340ULL,
    0xb67a0806f6820ULL,
    0x56e72c16bdcb0ULL,
    0x70b1fe19467f8ULL,
    0x643bb71265edcULL,
    0x9bc605b69b016ULL,
    0x88e261c4d3587ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xa000000000000ULL,
    0x1000000000000ULL,
    0xe800000000000ULL,
    0xb400000000000ULL,
    0xb600000000000ULL,
    0x3100000000000ULL,
    0x5e80000000000ULL,
    0x7340000000000ULL,
    0x36e0000000000ULL,
    0x5030000000000ULL,
    0xf4d8000000000ULL,
    0xb0dc000000000ULL,
    0x9eda000000000ULL,
    0x43df000000000ULL,
    0xe75f800000000ULL,
    0x4f18c00000000ULL,
    0x147d600000000ULL,
    0xee88d00000000ULL,
    0x3071580000000ULL,
    0xcbbfac0000000ULL,
    0xb42e360000000ULL,
    0xd524810000000ULL,
    0xb897808000000ULL,
    0x6e89e64000000ULL,
    0xf07780a000000ULL,
    0x6bb9e67000000ULL,
    0xa42f808800000ULL,
    0x3d25e67400000ULL,
    0xc9580b200000ULL,
    0xd88ae65900000ULL,
    0xc172009f80000ULL,
    0x353e265540000ULL,
    0xd76d608820000ULL,
    0xbc5f64990000ULL,
    0x5ca1b88598000ULL,
    0x2c519a5d9c000ULL,
    0x71af6eb8ae000ULL,
    0xabe60b71ab000ULL,
    0x94b1561f18800ULL,
    0xec9f51215cc00ULL,
    0x13bb5886cf600ULL,
    0x382d8a429af00ULL,
    0x9f21568bd0380ULL,
    0x9b92774d38c40ULL,
    0x5f0bb815cc6e0ULL,
    0x58b3bc16d72f0ULL,
    0xc6980e0f47e38ULL,
    0x80bcfd32de0f4ULL,
    0xf1af6eb34203aULL,
    0x6be60b7dec76dULL,
    0x8000000000000ULL,
    0x4000000000000ULL,
    0x6000000000000ULL,
    0xd000000000000ULL,
    0x5800000000000ULL,
    0xf400000000000ULL,
    0x5200000000000ULL,
    0xe700000000000ULL,
    0xba80000000000ULL,
    0xadc0000000000ULL,
    0x3160000000000ULL,
    0x3930000000000ULL,
    0xa888000000000ULL,
    0xaa8c000000000ULL,
    0x558e000000000ULL,
    0x7b0d000000000ULL,
    0x54cb800000000ULL,
    0xdaa9400000000ULL,
    0xad1ee00000000ULL,
    0xfa54700000000ULL,
    0x86bf480000000ULL,
    0x50849c0000000ULL,
    0x2ec4f20000000ULL,
    0xe1e2f90000000ULL,
    0x57f4708000000ULL,
    0x296ad4c000000ULL,
    0x2d7c70a000000ULL,
    0x24e6d4d000000ULL,
    0xa27270b800000ULL,
    0x222bd4e400000ULL,
    0x9fd9f0ae00000ULL,
    0x35b294d900000ULL,
    0xc84f10ba80000ULL,
    0x826ae4e0c0000ULL,
    0xa1fe589420000ULL,
    0x42378cbb0000ULL,
    0xea912a9878000ULL,
    0x658c1c5fc000ULL,
    0xb8f3ba325a000ULL,
    0x7fea652f5f000ULL,
    0x46be828739800ULL,
    0x70852de19c400ULL,
    0x9ec3802a0b600ULL,
    0x69e5403336100ULL,
    0xfbf0e02f4cd80ULL,
    0x8f697014a30c0ULL,
    0x987cc814630a0ULL,
    0x7961dc30422b0ULL,
    0xb5341233f2368ULL,
    0xbe8b89278a954ULL,
    0x9788b890772aaULL,
    0xa40b08f12c207ULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0xb000000000000ULL,
    0x2800000000000ULL,
    0xcc00000000000ULL,
    0x8600000000000ULL,
    0x3500000000000ULL,
    0xf180000000000ULL,
    0x17c0000000000ULL,
    0xf2e0000000000ULL,
    0xf70000000000ULL,
    0xb0a8000000000ULL,
    0x26ac000000000ULL,
    0xabaa000000000ULL,
    0xee2d000000000ULL,
    0x2be8800000000ULL,
    0x8e09c00000000ULL,
    0xfffa00000000ULL,
    0xea13900000000ULL,
    0xed1e380000000ULL,
    0x5d63b40000000ULL,
    0xe9b60a0000000ULL,
    0xa9cd1d0000000ULL,
    0x151aa68000000ULL,
    0xc96383c000000ULL,
    0x6bb2a6a000000ULL,
    0x66cf83f000000ULL,
    0x7f98a69800000ULL,
    0xd62283dc00000ULL,
    0xf910269200000ULL,
    0xb99b43ef00000ULL,
    0xc32786b380000ULL,
    0x5894d3e240000ULL,
    0x365bbe8fe0000ULL,
    0xd5c667e7b0000ULL,
    0x1de734b358000ULL,
    0x35f3bae46c000ULL,
    0x37e8b21f72000ULL,
    0x500b692dc7000ULL,
    0x3ef90c9598800ULL,
    0xe1900ee64c400ULL,
    0x61deb80762a00ULL,
    0xa7067419ce300ULL,
    0x8683aa169d480ULL,
    0xc9438d0c4ad40ULL,
    0x3fa41ebe5ac60ULL,
    0xcad5f7c952390ULL,
    0xe1790cb3d7448ULL,
    0xcf500ee8917e4ULL,
    0x4beb82fc9ed2ULL,
    0x3ab6743da59ebULL,
    0x8000000000000ULL,
    0xc000000000000ULL,
    0xe000000000000ULL,
    0x5000000000000ULL,
    0x2800000000000ULL,
    0xe400000000000ULL,
    0x5a00000000000U