# Introduction

With the growth of technology and the complexity of computer programs, programming languages and related technologies have turned to multitasking approaches.

Each programming language took a different approach, depending on its discretion. JavaScript, meanwhile, picked the asynchronous method to avoid many complications.

However, asynchronous programming has always been challenging, and therefore, with increasing complexity, humans need to control the situation by defining some patterns.

So far, many patterns have been created and one of the most basic of which is **promise**.

In a simple word, promise is one of the asynchronous patterns which is also used in JavaScript. It came to solve or facilitate some problems and quirks that programmers had struggled in asynchronous programming.

If you are not familiar with callback and its general problems, you should take a look at [this article](https://medium.com/javascript-in-plain-english/the-practical-problems-with-callbacks-in-javascript-5dd4209c20d) (which is about the practical problems with callbacks in JavaScript) to have an overall insight about the topic before starting.

Here in this book, we want to just focus on the core ideas behind promise. To achieve that, we are going to implement the promise pattern together, step by step, and slowly.

> “If we desire to reach the further peaks of knowledge with confidence and comfort, we need to spend enough time to make sure of every step we take.”

And as all programmers believe that the best way to fully understand a concept is to implement it yourself from scratch.

Also, there is a famous quote from [Richard Feynman](https://en.wikipedia.org/wiki/Richard_Feynman) (American physicist) who said:

> “What I cannot **create**, I do not **understand**”
