# Understanding the Core Ideas of Promise by Implementing it in JavaScript

## Implement promise from scratch (in an evolutionary way) to grasp its core ideas

<p align="center">
  <a href="https://leanpub.com/understanding-the-core-ideas-of-promise-by-implementing-it-in-javascript/">
    <img src="/book/assets/book-cover.png" width="50%" />
  </a>
</p>

In this book you will understand the main ideas of the promise pattern in JavaScript in an evolutionary way, which means at first you would start with nothing and try to meet the needs and improve them slowly.

You would touch everything with your mind.

After reading this book you will be able to implement a promise framework from scratch.

Because of learning the basic concepts in this pattern you might even can see other capabilities there and decide to design a new pattern or evolve a special idea in this pattern.

***

### Read if for free

You can read the entire book for free via the links below and also download all of the examples.

#### Table of Contents

- [Introduction](/book/Introduction.md)
- [Start the journey from the simple callback pattern to promise](/book/Chapter-0.md)
- [Start with a simple variable](/book/Chapter-1.md) *download the example [here](https://github.com/Babak-Gholamzadeh/implement-promise/archive/v0.1.zip)*
- [Initialize with an object instead of undefined](/book/Chapter-2.md) *download the example [here](https://github.com/Babak-Gholamzadeh/implement-promise/archive/v0.2.zip)*
- [Define done method on the object](/book/Chapter-3.md) *download the example [here](https://github.com/Babak-Gholamzadeh/implement-promise/archive/v0.3.zip)*
- [Send the callback to the object](/book/Chapter-4.md) *download the example [here](https://github.com/Babak-Gholamzadeh/implement-promise/archive/v0.4.zip)*
- [Define resolve method](/book/Chapter-5.md) *download the example [here](https://github.com/Babak-Gholamzadeh/implement-promise/archive/v0.5.zip)*
- [Refactor the code](/book/Chapter-6.md) *download the example [here](https://github.com/Babak-Gholamzadeh/implement-promise/archive/v0.6.zip)*
- [Handle the errors](/book/Chapter-7.md) *download the example [here](https://github.com/Babak-Gholamzadeh/implement-promise/archive/v0.7.zip)*
- [Modularize the code](/book/Chapter-8.md) *download the example [here](https://github.com/Babak-Gholamzadeh/implement-promise/archive/v0.8.zip)*
- [Register callbacks after resolving](/book/Chapter-9.md) *download the example [here](https://github.com/Babak-Gholamzadeh/implement-promise/archive/v0.9.zip)*
- [Eliminate nesting by chainable object](/book/Chapter-10.md) *download the example [here](https://github.com/Babak-Gholamzadeh/implement-promise/archive/v0.10.zip)*
- [Eliminate nesting of thenable object](/book/Chapter-11.md) *download the example [here](https://github.com/Babak-Gholamzadeh/implement-promise/archive/v0.11.zip)*
- [Register several callbacks before resolving](/book/Chapter-12.md) *download the example [here](https://github.com/Babak-Gholamzadeh/implement-promise/archive/v0.12.zip)*
- [Implement catch method](/book/Chapter-13.md) *download the example [here](https://github.com/Babak-Gholamzadeh/implement-promise/archive/v0.13.zip)*
- [Implement resolve and reject as static functions](/book/Chapter-14.md) *download the example [here](https://github.com/Babak-Gholamzadeh/implement-promise/archive/v0.14.zip)*
- [Conclusion](/book/Conclusion.md) *download the final example [here](https://github.com/Babak-Gholamzadeh/implement-promise/archive/v1.0.zip)*

### Paid version

If you read the book and feel that was kind of useful for you, you can buy a paid version of this book to support me on [Leanpub](https://leanpub.com/understanding-the-core-ideas-of-promise-by-implementing-it-in-javascript/), and pay as much as you think it's worth it.

In the paid version you have access:

- PDF
- EPUB
- MOBI
- WEB

version of this book.

