"""This module defines the joint constrains on the hand agent and the android agent."""
hand_agent_joints_constraints = {
    "hand_r": {"swing2_limit": 170.0, "swing1_limit": 170.0, "twist_limit": 170.0},
    "thumb_01_r": {"swing2_limit": 35.0, "swing1_limit": 30.0, "twist_limit": 2.0},
    "index_01_r": {"swing2_limit": 45.0, "swing1_limit": 10, "twist_limit": 2.0},
    "middle_01_r": {"swing2_limit": 45.0, "swing1_limit": 10.0, "twist_limit": 2.0},
    "ring_01_r": {"swing2_limit": 45.0, "swing1_limit": 10.0, "twist_limit": 2.0},
    "pinky_01_r": {"swing2_limit": 45.0, "swing1_limit": 10, "twist_limit": 2.0},
    "thumb_02_r": {"swing2_limit": 45.0, "swing1_limit": 2.0, "twist_limit": 2.0},
    "index_02_r": {"swing2_limit": 60.0, "swing1_limit": 0.0, "twist_limit": 2.0},
    "middle_02_r": {"swing2_limit": 60.0, "swing1_limit": 0.0, "twist_limit": 2.0},
    "ring_02_r": {"swing2_limit": 60.0, "swing1_limit": 0.0, "twist_limit": 2.0},
    "pinky_02_r": {"swing2_limit": 60.0, "swing1_limit": 0.0, "twist_limit": 2.0},
    "thumb_03_r": {"swing2_limit": 45.0, "swing1_limit": 0.0, "twist_limit": 0.0},
    "index_03_r": {"swing2_limit": 40.0, "swing1_limit": 0.0, "twist_limit": 0.0},
    "middle_03_r": {"swing2_limit": 40.0, "swing1_limit": 0.0, "twist_limit": 0.0},
    "ring_03_r": {"swing2_limit": 40.0, "swing1_limit": 0.0, "twist_limit": 0.0},
    "pinky_03_r": {"swing2_limit": 40.0, "swing1_limit": 0.0, "twist_limit": 0.0},
}

android_agent_joints_constraints = {
    "head": {"swing2_limit": 25, "swing1_limit": 15, "twist_limit": 25},
    "neck_01": {"swing2_limit": 0, "swing1_limit": 25, "twist_limit": 0},
    "spine_02": {"swing2_limit": 15, "swing1_limit": 5, "twist_limit": 25},
    "spine_01": {"swing2_limit": 10, "swing1_limit": 35, "twist_limit": 20},
    "upperarm_l": {"swing2_limit": 68.0275, "swing1_limit": 90, "twist_limit": 50},
    "lowerarm_l": {"swing2_limit": 0, "swing1_limit": 60, "twist_limit": 0},
    "hand_l": {"swing2_limit": 35, "swing1_limit": 70, "twist_limit": 70},
    "upperarm_r": {"swing2_limit": 68.0275, "swing1_limit": 90, "twist_limit": 50},
    "lowerarm_r": {"swing2_limit": 0, "swing1_limit": 60, "twist_limit": 0},
    "hand_r": {"swing2_limit": 35, "swing1_limit": 70, "twist_limit": 70},
    "thigh_l": {"swing2_limit": 20, "swing1_limit": 40, "twist_limit": 60},
    "calf_l": {"swing2_limit": 1, "swing1_limit": 65, "twist_limit": 1},
    "foot_l": {"swing2_limit": 25, "swing1_limit": 40, "twist_limit": 2},
    "ball_l": {"swing2_limit": 10, "swing1_limit": 10, "twist_limit": 15},
    "thigh_r": {"swing2_limit": 20, "swing1_limit": 40, "twist_limit": 60},
    "calf_r": {"swing2_limit": 1, "swing1_limit": 65, "twist_limit": 1},
    "foot_r": {"swing2_limit": 25, "swing1_limit": 40, "twist_limit": 2},
    "ball_r": {"swing2_limit": 10, "swing1_limit": 10, "twist_limit": 15},
    "thumb_01_l": {"swing2_limit": 30, "swing1_limit": 35, "twist_limit": 2},
    "index_01_l": {"swing2_limit": 10, "swing1_limit": 45, "twist_limit": 2},
    "middle_01_l": {"swing2_limit": 10, "swing1_limit": 45, "twist_limit": 2},
    "ring_01_l": {"swing2_limit": 10, "swing1_limit": 45, "twist_limit": 2},
    "pinky_01_l": {"swing2_limit": 10, "swing1_limit": 45, "twist_limit": 2},
    "thumb_01_r": {"swing2_limit": 30, "swing1_limit": 35, "twist_limit": 2},
    "index_01_r": {"swing2_limit": 10, "swing1_limit": 45, "twist_limit": 2},
    "middle_01_r": {"swing2_limit": 10, "swing1_limit": 45, "twist_limit": 2},
    "ring_01_r": {"swing2_limit": 10, "swing1_limit": 45, "twist_limit": 2},
    "pinky_01_r": {"swing2_limit": 10, "swing1_limit": 45, "twist_limit": 2},
    "thumb_02_l": {"swing2_limit": 2, "swing1_limit": 45, "twist_limit": 2},
    "index_02_l": {"swing2_limit": 0, "swing1_limit": 60, "twist_limit": 2},
    "middle_02_l": {"swing2_limit": 0, "swing1_limit": 60, "twist_limit": 2},
    "ring_02_l": {"swing2_limit": 0, "swing1_limit": 60, "twist_limit": 2},
    "pinky_02_l": {"swing2_limit": 0, "swing1_limit": 60, "twist_limit": 2},
    "thumb_02_r": {"swing2_limit": 2, "swing1_limit": 45, "twist_limit": 2},
    "index_02_r": {"swing2_limit": 0, "swing1_limit": 60, "twist_limit": 2},
    "middle_02_r": {"swing2_limit": 0, "swing1_limit": 60, "twist_limit": 2},
    "ring_02_r": {"swing2_limit": 0, "swing1_limit": 60, "twist_limit": 2},
    "pinky_02_r": {"swing2_limit": 0, "swing1_limit": 60, "twist_limit": 2},
    "thumb_03_l": {"swing2_limit": 0, "swing1_limit": 45, "twist_limit": 0},
    "index_03_l": {"swing2_limit": 0, "swing1_limit": 40, "twist_limit": 0},
    "middle_03_l": {"swing2_limit": 0, "swing1_limit": 40, "twist_limit": 0},
    "ring_03_l": {"swing2_limit": 0, "swing1_limit": 40, "twist_limit": 0},
    "pinky_03_l": {"swing2_limit": 0, "swing1_limit": 40, "twist_limit": 0},
    "thumb_03_r": {"swing2_limit": 0, "swing1_limit": 45, "twist_limit": 0},
    "index_03_r": {"swing2_limit": 0, "swing1_limit": 40, "twist_limit": 0},
    "middle_03_r": {"swing2_limit": 0, "swing1_limit": 40, "twist_limit": 0},
    "ring_03_r": {"swing2_limit": 0, "swing1_limit": 40, "twist_limit": 0},
    "pinky_03_r": {"swing2_limit": 0, "swing1_limit": 40, "twist_limit": 0},
}
