export const recipes = [
  {
    id: 1,
    title: "Tandoori Chicken",
    description:
      "Tandoori Chicken is a delicious and popular Indian dish that has gained international acclaim for its flavorful and aromatic characteristics. This dish is a traditional part of Indian cuisine and is loved by food enthusiasts worldwide. The preparation of Tandoori Chicken involves marinating chicken pieces in a blend of yogurt and a plethora of spices, including cumin, coriander, turmeric, paprika, garlic, ginger, and chili powder.",
    image:
      "https://images.pexels.com/photos/106343/pexels-photo-106343.jpeg?auto=compress&cs=tinysrgb&w=1080&dpr=1",
    cookingTime: 30,
    calories: 3857.68,
    ingredients: [
      "1/8 teaspoon saffron powder, or 1/4 teaspoon saffron threads",
      "1 tablespoon boiling water",
      "4 skinless chicken thighs",
      "4 skinless chicken legs",
      "3/4 teaspoon coarse salt",
      "1 teaspoon ground cumin",
      "1 teaspoon ground coriander",
      "1 teaspoon ground cinnamon",
      "1/2 teaspoon paprika (I used pimente d'Espelette)",
      "1/2 teaspoon turmeric",
      "1 to 1 1/2 teaspoons chili powder, depending on how hot you want it",
      "10 turns fresh ground black pepper",
      "1 cup whole milk plain yogurt",
      "juice of one fresh lime",
      "1 tablespoon finely-minced fresh ginger",
      "2 cloves garlic, peeled and finely minced",
    ],
    cookingInstructions: [
      "In a small bowl, mix saffron powder (or saffron threads) with boiling water and let it steep for 5 minutes.",
      "In a large mixing bowl, combine the chicken thighs and legs with all the dry spices and yogurt.",
      "Add the saffron mixture, lime juice, minced ginger, and garlic to the bowl and mix well to coat the chicken evenly.",
      "Cover the bowl with plastic wrap and let the chicken marinate in the refrigerator for at least 2 hours, preferably overnight.",
      "Preheat the oven to 450°F (230°C).",
      "Place the marinated chicken on a baking tray and bake for 20-25 minutes or until the chicken is fully cooked and slightly charred.",
      "Serve hot with naan or rice and your favorite chutney.",
    ],
  },
  {
    id: 2,
    title: "Chicken Biryani",
    description:
      "Chicken Biryani is a delectable and aromatic Indian rice dish that has gained immense popularity worldwide. It is a flavorful one-pot meal, combining succulent pieces of chicken with fragrant, long-grain Basmati rice, and an assortment of aromatic spices. The dish is a harmonious blend of rich flavors and textures, making it a favorite among biryani enthusiasts.",
    image:
      "https://images.unsplash.com/photo-1631515243349-e0cb75fb8d3a?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=1188&q=80",
    cookingTime: 60,
    calories: 4980.92,
    ingredients: [
      "2 cups basmati rice, soaked for 30 minutes",
      "1 lb (500g) chicken, cut into pieces",
      "1 cup plain yogurt",
      "2 large onions, thinly sliced",
      "2 tomatoes, chopped",
      "1/4 cup vegetable oil or ghee",
      "1/4 cup milk",
      "1/4 cup warm water",
      "1/2 teaspoon saffron strands",
      "1/4 teaspoon turmeric powder",
      "1 tablespoon biryani masala",
      "1 tablespoon ginger-garlic paste",
      "1 tablespoon chopped mint leaves",
      "1 tablespoon chopped cilantro",
      "4 cups water",
      "Salt to taste",
    ],
    cookingInstructions: [
      "In a large pot, bring 4 cups of water to a boil and add soaked rice. Cook the rice until it's 70% cooked, then drain the water and set the rice aside.",
      "In a separate bowl, mix saffron strands with warm milk and set it aside.",
      "In a deep, heavy-bottomed pan, heat oil or ghee over medium heat. Add sliced onions and fry until golden brown. Remove half of the fried onions and set them aside for garnishing.",
      "To the remaining onions in the pan, add chopped tomatoes, ginger-garlic paste, and sauté until the tomatoes become soft.",
      "Add chicken pieces and cook until they turn white. Then add yogurt, biryani masala, turmeric powder, chopped mint, and cilantro. Mix well and cook until the chicken is almost cooked through.",
      "Layer the partially cooked rice over the chicken in the pan. Drizzle the saffron milk and warm water over the rice.",
      "Cover the pan with a tight-fitting lid and cook on low heat for 20-25 minutes, allowing the flavors to meld together.",
      "Garnish with the reserved fried onions before serving. Serve hot with raita or salad.",
    ],
  },
  {
    id: 3,
    title: "Palak Paneer",
    description: "",
    image:
      "https://images.unsplash.com/photo-1589647363585-f4a7d3877b10?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=1172&q=80",
    cookingTime: 40,
    calories: 1572.31,
    ingredients: [
      "1 lb (500g) paneer, cubed",
      "2 bunches of fresh spinach, washed and chopped",
      "1 large onion, finely chopped",
      "2 tomatoes, pureed",
      "1/2 cup heavy cream",
      "2 tablespoons vegetable oil or ghee",
      "1 tablespoon ginger-garlic paste",
      "1 teaspoon cumin seeds",
      "1 teaspoon garam masala",
      "1 teaspoon turmeric powder",
      "1/2 teaspoon red chili powder",
      "1/4 teaspoon asafoetida (hing)",
      "Salt to taste",
    ],
    cookingInstructions: [
      "Blanch the chopped spinach in boiling water for 2 minutes. Drain and immediately transfer it to a bowl of ice water. This helps retain the vibrant green color. Blend the blanched spinach into a smooth puree.",
      "In a large pan, heat oil or ghee over medium heat. Add cumin seeds and asafoetida.",
      "Add chopped onions and sauté until they become translucent.",
      "Add ginger-garlic paste and cook until the raw smell disappears.",
      "Add tomato puree, turmeric powder, red chili powder, and salt. Cook until the oil starts to separate from the masala.",
      "Add the spinach puree to the masala and mix well. Cook for a few minutes.",
      "Stir in the heavy cream and let it simmer for another 5 minutes.",
      "Add cubed paneer to the spinach gravy and gently mix to coat the paneer with the sauce.",
      "Sprinkle garam masala over the top and cook for a few more minutes until the flavors meld together.",
      "Serve hot with naan or rice.",
    ],
  },
  {
    id: 4,
    title: "Chole (Chickpea Curry)",
    image:
      "https://images.unsplash.com/photo-1560260330-727f7f5c0277?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=1170&q=80",
    cookingTime: 40,
    calories: 987.54,
    ingredients: [
      "1 can (15 ounces) chickpeas (garbanzo beans), drained and rinsed",
      "1 large onion, finely chopped",
      "2 tomatoes, finely chopped",
      "1/4 cup tomato puree",
      "2 tablespoons vegetable oil",
      "1 tablespoon ginger-garlic paste",
      "1 green chili, slit (optional)",
      "1 teaspoon cumin seeds",
      "1 teaspoon coriander powder",
      "1/2 teaspoon turmeric powder",
      "1/2 teaspoon red chili powder",
      "1 teaspoon garam masala",
      "1 teaspoon dry mango powder (amchur)",
      "1/2 teaspoon ground cumin",
      "1/2 teaspoon ground cinnamon",
      "Salt to taste",
      "Fresh cilantro, chopped, for garnish",
    ],
    cookingInstructions: [
      "Heat oil in a pan over medium heat. Add cumin seeds and let them splutter.",
      "Add chopped onions and sauté until they turn golden brown.",
      "Add ginger-garlic paste and sauté until the raw smell disappears.",
      "Add chopped tomatoes and cook until they become soft and mushy.",
      "Add tomato puree, turmeric powder, red chili powder, ground cumin, ground cinnamon, and salt. Mix well and cook until the oil starts to separate from the masala.",
      "Add the drained and rinsed chickpeas to the masala. Stir well to coat the chickpeas with the spices.",
      "Add slit green chili (if using) and a little water to adjust the consistency of the curry.",
      "Let the curry simmer for about 15 minutes on low heat, allowing the flavors to blend together.",
      "Add garam masala and dry mango powder (amchur) and stir well. Cook for a few more minutes.",
      "Garnish with freshly chopped cilantro before serving.",
      "Serve hot with steamed rice, naan, or chapati.",
    ],
  },
  {
    id: 5,
    title: "Samosa",
    image:
      "https://images.unsplash.com/photo-1601050690597-df0568f70950?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=1170&q=80",
    cookingTime: 50,
    calories: 380.72,
    ingredients: [
      "For the dough:",
      "2 cups all-purpose flour",
      "1/4 cup vegetable oil",
      "1/2 teaspoon salt",
      "Water (as needed)",
      "For the filling:",
      "2 large potatoes, boiled and mashed",
      "1/2 cup green peas, boiled",
      "1 tablespoon vegetable oil",
      "1 teaspoon cumin seeds",
      "1 teaspoon coriander powder",
      "1/2 teaspoon turmeric powder",
      "1/2 teaspoon red chili powder",
      "1 teaspoon garam masala",
      "1 tablespoon ginger-garlic paste",
      "Salt to taste",
      "Vegetable oil, for deep frying",
    ],
    cookingInstructions: [
      "In a large mixing bowl, combine all-purpose flour, vegetable oil, and salt. Mix well.",
      "Gradually add water and knead the mixture into a smooth, firm dough. Cover it with a damp cloth and let it rest for 30 minutes.",
      "In a separate pan, heat 1 tablespoon of vegetable oil over medium heat. Add cumin seeds and let them splutter.",
      "Add ginger-garlic paste and sauté until the raw smell disappears.",
      "Add boiled green peas and mashed potatoes to the pan. Stir in coriander powder, turmeric powder, red chili powder, garam masala, and salt. Mix well to combine all the spices with the filling.",
      "Cook the filling for a few minutes, allowing the flavors to meld together. Remove it from heat and let it cool.",
      "Divide the rested dough into small balls. Roll each ball into a thin circular shape to form the samosa shell.",
      "Cut the circular dough in half to form two semi-circles.",
      "Take one semi-circle, moisten the straight edge with water, and shape it into a cone. Seal the cone by pressing the moistened edges together.",
      "Fill the cone with the prepared filling and seal the top edge using water to make sure it's tightly closed.",
      "Heat vegetable oil in a deep frying pan over medium heat. Once the oil is hot, fry the samosas in batches until they turn golden brown and crispy.",
      "Remove the fried samosas and place them on a paper towel to drain excess oil.",
      "Serve hot with tamarind chutney or mint chutney.",
    ],
  },
  {
    id: 6,
    title: "Butter Chicken (Murgh Makhani)",
    image:
      "https://images.unsplash.com/photo-1603894584373-5ac82b2ae398?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=1170&q=80",
    cookingTime: 45,
    calories: 1950.89,
    ingredients: [
      "1 lb (500g) boneless, skinless chicken thighs, cut into bite-sized pieces",
      "1 cup tomato puree",
      "1/2 cup heavy cream",
      "1/4 cup plain yogurt",
      "3 tablespoons butter",
      "1 tablespoon vegetable oil",
      "1 tablespoon ginger-garlic paste",
      "1 teaspoon garam masala",
      "1 teaspoon paprika",
      "1/2 teaspoon turmeric powder",
      "1/2 teaspoon ground cumin",
      "1/2 teaspoon ground coriander",
      "1/2 teaspoon red chili powder",
      "1/4 teaspoon cinnamon powder",
      "Salt to taste",
      "Fresh cilantro, chopped, for garnish",
    ],
    cookingInstructions: [
      "In a large pan, heat vegetable oil and 2 tablespoons of butter over medium heat.",
      "Add ginger-garlic paste and sauté until the raw smell disappears.",
      "Add chicken pieces and cook until they are browned on all sides.",
      "Add garam masala, paprika, turmeric powder, ground cumin, ground coriander, red chili powder, cinnamon powder, and salt. Mix well and cook for a few minutes.",
      "Stir in tomato puree and simmer for 10-15 minutes, allowing the chicken to cook thoroughly and the flavors to meld together.",
      "Add heavy cream and yogurt to the pan, stirring well to combine.",
      "Let the curry simmer for another 5 minutes on low heat.",
      "Stir in the remaining tablespoon of butter to add richness to the dish.",
      "Garnish with freshly chopped cilantro before serving.",
      "Serve hot with naan or steamed rice.",
    ],
  },
  {
    id: 8,
    title: "Rasgulla",
    description:
      "Rasgulla is a popular Indian sweet delicacy made from chhena (Indian cottage cheese) dough that is kneaded, rolled into balls, and then boiled in a sugar syrup until it becomes soft and spongy. Originating from the state of West Bengal, India, rasgullas are often served chilled and are characterized by their light, airy texture and mildly sweet taste. They are a common dessert at festive occasions and celebrations across India and other parts of South Asia.",
    image:
      "https://github.com/sourabhsikarwar/Scene-Movie-Platform/assets/56786344/1cbb0cc0-f722-4df9-90a3-8b48b74c64e9",
    cookingTime: 40,
    calories: 237.45,
    ingredients: [
      "4 cups whole milk",
      "1/4 cup lemon juice",
      "1 cup sugar",
      "4 cups water",
      "1/2 teaspoon rose water (optional)",
      "A few saffron strands (optional)",
      "Pistachios or almonds, chopped, for garnish",
    ],
    cookingInstructions: [
      "In a large pot, bring the milk to a boil. Once it starts boiling, reduce the heat to low and add lemon juice.",
      "Stir the milk gently until it curdles and the whey separates from the solids.",
      "Turn off the heat and let it sit for a minute.",
      "Line a colander with a muslin cloth or cheesecloth. Pour the curdled milk through the cloth to strain the whey.",
      "Gather the cloth and rinse the curdled milk under cold running water. This helps to remove any lemony flavor.",
      "Squeeze out the excess water and hang the cloth for about 30 minutes to drain the remaining whey from the solids.",
      "Remove the drained solids (chenna) from the cloth and knead it on a clean surface until it becomes smooth and soft.",
      "Divide the chenna into small, smooth balls and set them aside.",
      "In a separate pot, combine sugar, water, rose water (if using), and saffron strands (if using). Bring the mixture to a boil to make the sugar syrup.",
      "Carefully drop the chenna balls into the boiling sugar syrup.",
      "Cover the pot and let the rasgullas cook on medium heat for about 15 minutes.",
      "Turn off the heat and let the rasgullas cool in the syrup.",
      "Garnish with chopped pistachios or almonds before serving.",
      "Serve the rasgullas chilled for a delightful dessert.",
    ],
  },
  {
    id: 9,
    title: "Chicken Korma",
    image:
      "https://images.pexels.com/photos/6113813/pexels-photo-6113813.jpeg?auto=compress&cs=tinysrgb&w=1080&dpr=1",
    cookingTime: 50,
    calories: 2580.16,
    ingredients: [
      "1 lb (500g) boneless, skinless chicken, cut into bite-sized pieces",
      "1 cup plain yogurt",
      "1 large onion, finely chopped",
      "2 tomatoes, pureed",
      "1/2 cup cashew nuts, soaked in water",
      "1/4 cup vegetable oil or ghee",
      "1 tablespoon ginger-garlic paste",
      "1 teaspoon garam masala",
      "1 teaspoon ground coriander",
      "1/2 teaspoon ground cumin",
      "1/2 teaspoon turmeric powder",
      "1/2 teaspoon red chili powder",
      "1/4 teaspoon ground cardamom",
      "1/4 teaspoon ground cinnamon",
      "1/4 teaspoon ground cloves",
      "1/4 teaspoon ground nutmeg",
      "1 cup water or chicken broth",
      "1/4 cup heavy cream",
      "Salt to taste",
      "Fresh cilantro, chopped, for garnish",
    ],
    cookingInstructions: [
      "In a blender, grind soaked cashew nuts into a smooth paste, adding a little water if necessary. Set aside.",
      "In a large pan, heat vegetable oil or ghee over medium heat. Add chopped onions and sauté until they become translucent.",
      "Add ginger-garlic paste and cook until the raw smell disappears.",
      "Add chicken pieces and cook until they are lightly browned on all sides.",
      "Stir in ground coriander, ground cumin, turmeric powder, red chili powder, ground cardamom, ground cinnamon, ground cloves, and ground nutmeg. Mix well and cook for a few minutes.",
      "Add pureed tomatoes and cook until the oil starts to separate from the masala.",
      "Add yogurt and cashew nut paste to the pan, stirring well to combine. Cook for a few more minutes.",
      "Pour water or chicken broth into the pan and bring the mixture to a gentle simmer.",
      "Cover the pan and let the chicken cook on low heat until it becomes tender and fully cooked.",
      "Stir in heavy cream to add richness to the korma.",
      "Season with salt to taste and let the curry simmer for a few more minutes.",
      "Garnish with freshly chopped cilantro before serving.",
      "Serve hot with naan or steamed rice.",
    ],
  },
  {
    id: 10,
    title: "Dal Makhani",
    image:
      "https://images.pexels.com/photos/12737916/pexels-photo-12737916.jpeg?auto=compress&cs=tinysrgb&w=1080&dpr=1",
    cookingTime: 60,
    calories: 1530.42,
    ingredients: [
      "1 cup whole black lentils (urad dal)",
      "1/4 cup red kidney beans (rajma)",
      "4 cups water",
      "1 large onion, finely chopped",
      "2 tomatoes, pureed",
      "1/2 cup heavy cream",
      "3 tablespoons butter",
      "1 tablespoon ginger-garlic paste",
      "1 teaspoon cumin seeds",
      "1 teaspoon garam masala",
      "1/2 teaspoon turmeric powder",
      "1/2 teaspoon red chili powder",
      "1/4 teaspoon ground cinnamon",
      "1/4 teaspoon ground cardamom",
      "Salt to taste",
      "Fresh cilantro, chopped, for garnish",
    ],
    cookingInstructions: [
      "Rinse the black lentils (urad dal) and red kidney beans (rajma) under cold running water.",
      "In a large pot, combine the lentils, kidney beans, and water. Bring the mixture to a boil.",
      "Reduce the heat to low, cover the pot, and let the lentils and beans cook until they become soft and tender. This may take around 45 minutes to 1 hour.",
      "In a separate pan, heat butter over medium heat. Add cumin seeds and let them splutter.",
      "Add chopped onions and sauté until they become translucent.",
      "Add ginger-garlic paste and sauté until the raw smell disappears.",
      "Stir in pureed tomatoes and cook until the oil starts to separate from the masala.",
      "Add garam masala, turmeric powder, red chili powder, ground cinnamon, and ground cardamom. Mix well and cook for a few minutes.",
      "Add the cooked lentils and kidney beans to the masala, along with any remaining cooking water. Stir everything together.",
      "Simmer the dal on low heat for about 15-20 minutes, allowing the flavors to meld together.",
      "Stir in heavy cream to add richness to the dal.",
      "Season with salt to taste and let it simmer for a few more minutes.",
      "Garnish with freshly chopped cilantro before serving.",
      "Serve hot with naan or steamed rice.",
    ],
  },
  {
    id: 11,
    title: "Paneer Tikka Masala",
    image:
      "https://images.pexels.com/photos/9609838/pexels-photo-9609838.jpeg?auto=compress&cs=tinysrgb&w=1260&h=750&dpr=1",
    cookingTime: 40,
    calories: 1845.22,
    ingredients: [
      "1 lb (500g) paneer, cubed",
      "1 cup plain yogurt",
      "1 large onion, finely chopped",
      "2 tomatoes, pureed",
      "1/2 cup heavy cream",
      "3 tablespoons vegetable oil or ghee",
      "1 tablespoon ginger-garlic paste",
      "1 teaspoon garam masala",
      "1 teaspoon ground coriander",
      "1/2 teaspoon turmeric powder",
      "1/2 teaspoon red chili powder",
      "1/4 teaspoon ground cinnamon",
      "1/4 teaspoon ground cardamom",
      "1/4 teaspoon ground cloves",
      "1 teaspoon kasuri methi (dried fenugreek leaves)",
      "Salt to taste",
      "Fresh cilantro, chopped, for garnish",
    ],
    cookingInstructions: [
      "In a large bowl, combine cubed paneer and plain yogurt. Mix well to coat the paneer pieces with yogurt.",
      "Cover the bowl with plastic wrap and let the paneer marinate in the refrigerator for at least 30 minutes.",
      "Preheat the oven to 400°F (200°C). Line a baking tray with aluminum foil and lightly grease it.",
      "Place the marinated paneer on the prepared baking tray and bake for 15-20 minutes or until the paneer pieces develop a light golden crust.",
      "In a separate pan, heat vegetable oil or ghee over medium heat.",
      "Add chopped onions and sauté until they become translucent.",
      "Add ginger-garlic paste and sauté until the raw smell disappears.",
      "Stir in pureed tomatoes and cook until the oil starts to separate from the masala.",
      "Add garam masala, ground coriander, turmeric powder, red chili powder, ground cinnamon, ground cardamom, ground cloves, and kasuri methi. Mix well and cook for a few minutes.",
      "Add the baked paneer pieces to the pan and mix them with the masala.",
      "Stir in heavy cream and let the curry simmer for a few minutes, allowing the flavors to meld together.",
      "Season with salt to taste and adjust the consistency with a little water if needed.",
      "Garnish with freshly chopped cilantro before serving.",
      "Serve hot with naan or steamed rice.",
    ],
  },
  {
    id: 13,
    title: "Spaghetti Carbonara",
    description:
      "Spaghetti Carbonara is a classic and beloved Italian pasta dish that has captured the hearts and palates of food enthusiasts worldwide. This indulgent and creamy recipe originates from Rome and is a testament to the simplicity and elegance of Italian cuisine.",
    image:
      "https://images.unsplash.com/photo-1588013273468-315fd88ea34c?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=1169&q=80",
    cookingTime: 25,
    calories: 930.7,
    ingredients: [
      "12 oz (340g) spaghetti",
      "4 oz (115g) pancetta or guanciale, diced",
      "3 large eggs",
      "1 cup grated Pecorino Romano cheese",
      "1/2 cup grated Parmesan cheese",
      "3 cloves garlic, minced",
      "Salt and freshly ground black pepper to taste",
      "Fresh parsley, chopped, for garnish",
    ],
    cookingInstructions: [
      "Cook the spaghetti in a large pot of boiling salted water until al dente. Drain, reserving 1/2 cup of pasta water, and set aside.",
      "In a large skillet, cook diced pancetta or guanciale over medium heat until crispy. Remove from heat and set aside.",
      "In a bowl, whisk together eggs, grated Pecorino Romano cheese, grated Parmesan cheese, minced garlic, and a generous amount of black pepper.",
      "Add the cooked spaghetti and crispy pancetta or guanciale to the egg mixture. Toss everything together to coat the pasta.",
      "If the pasta seems too dry, add some of the reserved pasta water gradually until you achieve a creamy consistency.",
      "Season with salt to taste.",
      "Garnish with freshly chopped parsley before serving.",
      "Serve immediately with additional grated cheese on top.",
    ],
  },
  {
    id: 18,
    title: "Orange Chicken",
    image:
      "https://images.pexels.com/photos/12916862/pexels-photo-12916862.jpeg?auto=compress&cs=tinysrgb&w=1080&dpr=1",
    cookingTime: 40,
    calories: 1245.6,
    ingredients: [
      "1 lb (500g) boneless, skinless chicken thighs, cut into bite-sized pieces",
      "1/2 cup orange juice",
      "2 tablespoons soy sauce",
      "2 tablespoons hoisin sauce",
      "2 tablespoons rice vinegar",
      "2 tablespoons brown sugar",
      "1 tablespoon vegetable oil",
      "2 cloves garlic, minced",
      "1 teaspoon grated fresh ginger",
      "2 tablespoons cornstarch, dissolved in 2 tablespoons water",
      "1 tablespoon sesame oil",
      "Zest of 1 orange",
      "Sesame seeds and sliced green onions, for garnish",
      "Steamed rice, for serving",
    ],
    cookingInstructions: [
      "In a bowl, whisk together orange juice, soy sauce, hoisin sauce, rice vinegar, and brown sugar to make the sauce.",
      "In a large skillet or wok, heat vegetable oil over medium-high heat.",
      "Add minced garlic and grated ginger to the skillet. Cook until fragrant.",
      "Add the chicken pieces to the skillet and cook until they are lightly browned.",
      "Pour the prepared sauce over the chicken and mix well to coat the pieces.",
      "Simmer the chicken in the sauce until it is cooked through and the sauce thickens slightly.",
      "Stir in the dissolved cornstarch to thicken the sauce further.",
      "Drizzle sesame oil over the chicken and add orange zest. Mix well.",
      "Remove the skillet from the heat.",
      "Garnish with sesame seeds and sliced green onions before serving.",
      "Serve hot over steamed rice.",
    ],
  },
  {
    id: 19,
    title: "Sushi Rolls",
    image:
      "https://images.unsplash.com/photo-1553621042-f6e147245754?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=1025&q=80",
    cookingTime: 60,
    calories: 720.25,
    ingredients: [
      "2 cups sushi rice",
      "4 nori (seaweed) sheets",
      "1/2 lb (225g) fresh raw fish (salmon, tuna, etc.), thinly sliced",
      "1 avocado, thinly sliced",
      "1 cucumber, julienned",
      "Soy sauce, for dipping",
      "Wasabi and pickled ginger, for serving",
    ],
    cookingInstructions: [
      "Prepare sushi rice according to the package instructions. Let it cool slightly.",
      "Place a bamboo sushi rolling mat on a clean surface, and cover it with plastic wrap.",
      "Lay a nori sheet, shiny side down, on the mat.",
      "With wet fingers, spread a thin layer of sushi rice over the nori, leaving a small border at the top edge.",
      "Place slices of raw fish, avocado, and cucumber in a row on the rice, near the bottom edge of the nori.",
      "Start rolling the sushi using the bamboo mat, gently pressing it together.",
      "Once rolled, moisten the top border of the nori to seal the roll.",
      "Slice the sushi roll into bite-sized pieces using a sharp knife.",
      "Serve with soy sauce, wasabi, and pickled ginger.",
    ],
  },
  {
    id: 21,
    title: "Classic Lasagna",
    image:
      "https://images.pexels.com/photos/4079520/pexels-photo-4079520.jpeg?auto=compress&cs=tinysrgb&w=1080&dpr=1",
    cookingTime: 90,
    calories: 1450.8,
    ingredients: [
      "9 lasagna noodles, cooked according to package instructions",
      "1 lb (500g) ground beef",
      "1 large onion, chopped",
      "4 cloves garlic, minced",
      "1 can (28 oz) crushed tomatoes",
      "1 can (14 oz) tomato sauce",
      "1/2 cup water",
      "2 teaspoons dried basil",
      "1 teaspoon dried oregano",
      "1/2 teaspoon sugar",
      "Salt and freshly ground black pepper to taste",
      "1 cup ricotta cheese",
      "2 cups shredded mozzarella cheese",
      "1 cup grated Parmesan cheese",
      "Fresh parsley, chopped, for garnish",
    ],
    cookingInstructions: [
      "Preheat the oven to 375°F (190°C). Grease a large baking dish.",
      "In a large skillet, cook ground beef over medium-high heat until browned. Drain excess fat.",
      "Add chopped onions and minced garlic to the skillet. Sauté until the onions become translucent.",
      "Stir in crushed tomatoes, tomato sauce, water, dried basil, dried oregano, sugar, salt, and black pepper. Let the sauce simmer for about 15 minutes.",
      "In the prepared baking dish, spread a small amount of the sauce on the bottom.",
      "Layer three cooked lasagna noodles over the sauce.",
      "Spread a layer of the ricotta cheese over the noodles.",
      "Sprinkle a layer of shredded mozzarella and grated Parmesan cheese over the ricotta.",
      "Repeat the layers, starting with the sauce and ending with the cheeses, until all ingredients are used.",
      "Cover the baking dish with foil and bake in the preheated oven for 40 minutes.",
      "Remove the foil and bake for an additional 15 minutes or until the cheese turns golden and bubbly.",
      "Garnish with freshly chopped parsley before serving.",
      "Let the lasagna rest for a few minutes before slicing and serving.",
    ],
  },
  {
    id: 22,
    title: "Masala Dosa",
    image:
      "https://images.unsplash.com/photo-1668236543090-82eba5ee5976?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=1170&q=80",
    cookingTime: 45,
    calories: 540.7,
    ingredients: [
      "1 cup dosa rice",
      "1/4 cup urad dal (black gram dal)",
      "1/4 cup cooked rice",
      "1/2 teaspoon fenugreek seeds",
      "Salt to taste",
      "1 large potato, boiled and mashed",
      "1 tablespoon vegetable oil",
      "1 teaspoon mustard seeds",
      "1 teaspoon cumin seeds",
      "1/2 teaspoon turmeric powder",
      "1/2 teaspoon red chili powder",
      "1/4 cup chopped onions",
      "1/4 cup chopped tomatoes",
      "2 green chilies, chopped",
      "A few curry leaves",
      "Fresh cilantro, chopped, for garnish",
      "Coconut chutney and sambar, for serving",
    ],
    cookingInstructions: [
      "Wash and soak dosa rice, urad dal, and fenugreek seeds in water separately for at least 4 hours or overnight.",
      "Drain the water from each soaked ingredient and grind them together with cooked rice and some water to form a smooth batter.",
      "Add salt to the batter and mix well. Let the batter ferment in a warm place for 8-10 hours or until it doubles in volume.",
      "In a small pan, heat vegetable oil over medium heat. Add mustard seeds and cumin seeds.",
      "Once the seeds start to splutter, add chopped onions, green chilies, and curry leaves. Sauté until the onions become translucent.",
      "Add turmeric powder and red chili powder to the pan. Mix well.",
      "Add the boiled and mashed potato to the pan and mix it with the spices. Cook for a few minutes to let the flavors meld together. Remove from heat.",
      "Heat a non-stick or cast-iron skillet over medium heat. Pour a ladleful of the dosa batter onto the center of the skillet.",
      "Using the back of the ladle, spread the batter in a circular motion to form a thin and even dosa.",
      "Drizzle a little oil around the edges of the dosa and cook until the bottom turns golden brown and crispy.",
      "Place a spoonful of the prepared potato masala on one side of the dosa and fold it over to cover the filling.",
      "Remove the dosa from the skillet and serve hot with coconut chutney and sambar.",
      "Garnish with freshly chopped cilantro before serving.",
    ],
  },
  {
    id: 23,
    title: "Margherita Pizza",
    image:
      "https://images.unsplash.com/photo-1595854341625-f33ee10dbf94?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=1170&q=80",
    cookingTime: 20,
    calories: 980.9,
    ingredients: [
      "1 lb (450g) pizza dough",
      "1/2 cup pizza sauce",
      "1 1/2 cups shredded mozzarella cheese",
      "1 large tomato, thinly sliced",
      "Fresh basil leaves",
      "2 tablespoons olive oil",
      "Salt and freshly ground black pepper to taste",
      "Red pepper flakes (optional)",
    ],
    cookingInstructions: [
      "Preheat the oven to the highest temperature setting (usually 500°F or 260°C).",
      "Roll out the pizza dough on a floured surface to your desired thickness.",
      "Transfer the rolled-out dough to a pizza stone or a baking sheet lined with parchment paper.",
      "Spread pizza sauce evenly over the dough, leaving a small border around the edges.",
      "Sprinkle shredded mozzarella cheese over the sauce.",
      "Place tomato slices and fresh basil leaves on top of the cheese.",
      "Drizzle olive oil over the pizza and season with salt and freshly ground black pepper.",
      "If you prefer some heat, add a pinch of red pepper flakes.",
      "Bake the pizza in the preheated oven for 12-15 minutes or until the crust is golden and the cheese is bubbly and slightly browned.",
      "Remove the pizza from the oven and let it cool slightly before slicing.",
      "Serve hot and enjoy the classic Margherita pizza!",
    ],
  },
  {
    id: 24,
    title: "Classic Hamburger",
    image:
      "https://images.unsplash.com/photo-1550317138-10000687a72b?ixlib=rb-4.0.3&ixid=M3wxMjA3fDB8MHxwaG90by1wYWdlfHx8fGVufDB8fHx8fA%3D%3D&auto=format&fit=crop&w=1220&q=80",
    cookingTime: 20,
    calories: 670.4,
    ingredients: [
      "1 lb (450g) ground beef (80% lean, 20% fat)",
      "4 hamburger buns",
      "4 slices of cheese (American, cheddar, or your favorite)",
      "Lettuce leaves",
      "Sliced tomatoes",
      "Sliced onions",
      "Pickles",
      "Ketchup and mustard",
      "Salt and freshly ground black pepper to taste",
    ],
    cookingInstructions: [
      "Divide the ground beef into 4 equal portions and shape them into patties.",
      "Season the patties with salt and freshly ground black pepper.",
      "Preheat the grill or stovetop griddle to medium-high heat.",
      "Place the patties on the grill or griddle and cook for about 4-5 minutes per side or until they reach your desired level of doneness.",
      "In the last minute of cooking, add a slice of cheese on top of each patty to melt.",
      "Toast the hamburger buns on the grill or in a toaster.",
      "Assemble the hamburgers by placing a lettuce leaf and a cooked patty with melted cheese on the bottom half of each bun.",
      "Add sliced tomatoes, onions, and pickles.",
      "Squeeze ketchup and mustard on top of the vegetables.",
      "Cover with the top half of the bun to complete the classic hamburger.",
      "Serve hot and enjoy the deliciousness of a classic American burger!",
    ],
  },
  {
    id: 25,
    title: "Homemade Donuts",
    image:
      "https://images.pexels.com/photos/1191639/pexels-photo-1191639.jpeg?auto=compress&cs=tinysrgb&w=1080&dpr=1",
    cookingTime: 60,
    calories: 450.2,
    ingredients: [
      "2 1/4 cups all-purpose flour",
      "1/2 cup granulated sugar",
      "2 teaspoons baking powder",
      "1/2 teaspoon salt",
      "1/2 cup milk",
      "1/4 cup unsalted butter, melted",
      "1 large egg",
      "1 teaspoon vanilla extract",
      "Vegetable oil, for frying",
      "Powdered sugar, for dusting",
    ],
    cookingInstructions: [
      "In a large mixing bowl, whisk together the all-purpose flour, granulated sugar, baking powder, and salt.",
      "In a separate bowl, whisk together the milk, melted unsalted butter, egg, and vanilla extract.",
      "Gradually add the wet ingredients to the dry ingredients, stirring until just combined. Do not overmix.",
      "Cover the bowl with plastic wrap and refrigerate the dough for at least 30 minutes.",
      "On a floured surface, roll out the chilled dough to about 1/2-inch thickness.",
      "Using a donut cutter or a glass, cut out donut shapes and use a smaller cutter or a bottle cap to cut out the donut holes in the center.",
      "Heat vegetable oil in a deep pot or a deep fryer to 350°F (175°C).",
      "Carefully lower the donuts into the hot oil, frying a few at a time, but not overcrowding the pot.",
      "Fry the donuts for 1-2 minutes per side or until they are golden brown and cooked through.",
      "Use a slotted spoon to remove the donuts from the oil and place them on a paper towel-lined plate to drain excess oil.",
      "While the donuts are still warm, dust them with powdered sugar.",
      "Enjoy these delicious homemade donuts with your favorite coffee or tea!",
    ],
  },
];
