# Atlas Render Plugin
### Contributing guideline
## Overview
Hello contibutor! Thank you for your interest in our system :)
You can check out the documentation in the wiki section of this repository. But keep in mind, the information appears there with a significant delay and not all.
If you want to stay up to date with the latest news, read the source.
We describe all functions, components and classes at a high level and it will not be difficult for you to figure out the details.
## Contributing rules
We have some rules to follow when writing code. Here they are:
* Describe all functions, components, classes, variables, etc. using typescript and JSDocs.
* Description in JSDocs must contain a detailed description, type decorators, for example, @function or @interface. Also write authorship after the @author decorator. We encourage writing examples after the @example decorator.
* Add copyright to the beginning of the file and indicate your authorship. Here is the copyright pattern:
```
Copyright (c) $today.year. This code created and belongs to Pathfinder render manager project. 
Owner and project architect: Danil Andreev | danssg08@gmail.com |  https://github.com/DanilAndreev
File creator: $username
Project: $project.name
File last modified: $file.lastModified
All rights reserved.
```
* Name variables, functions and everything that you write as intuitively as possible so that there is no confusion and misunderstanding.
* Use CamelStyle in your code.
* If possible, link to documentation in JSDocs using @see.
* Name your commits this way: ```[module_name] (issue #issue_tag) Commit description.```.
* In the pull request, describe the changes in detail, write your credentials and add labels to the request. You can request a review from any of the reviewers.
* We are happy to put you outside collaborators if you can help us.
* Smile more often, we have a very friendly team :)
## Contacts
You can send your questions to this email: atlas.render.farm@gmail.com
## Good luck
Thak you for reading this guide. Good luck!
