<base target="_blank">
<!---<script src='https://cdn.jsdelivr.net/gh/eddymens/markdown-external-link-script@v2.0.0/main.min.js'></script>
--->
<h1 align="center">
<b>Awesome OSINT For Everything</b> <img src="https://awesome.re/badge-flat.svg"/></h1>

<p align="center">
A list of osint tools, websites for pentration testing, Reverse Searching, Red team Oprations, information gathering, bugbounty and almost cover everything in single file.
</p>


<!---<p align="center">
	<a href="https://github.com/astrosp/osint-tools#PRODUCTIVITY" target="_blank">Productivity</a>
	<a href="https://github.com/astrosp/osint-tools#FILE UPLOAD" target="_blank">File Upload</a>
	<a href="https://github.com/astrosp/osint-tools#TOOLSET" target="_blank">Toolset</a></p>
--->
## Index
 [AI](#ai) ⁕ [Breaches & Leaks](#breaches-and-leaks) ⁕ [Recon](#recon) ⁕ [Productivity](#productivity) ⁕ [File Upload](#file-upload) ⁕ [Toolset](#toolset) ⁕ [Top Search Engines](#search-engines) ⁕ [Whois](#whois) ⁕ [Source Codes](#source-codes) ⁕ [Domain / IP / DNS](#domain--ip--dns) ⁕ [Malware](#malware) ⁕ [Dataset](#dataset) ⁕ [Geo](#geo) ⁕ [IoT](#iot) ⁕ [Darknet](#darknet) ⁕ [Cryptocurrency](#cryptocurrency) ⁕ [Username](#username) ⁕ [Email](#email) ⁕ [Phone](#phone) ⁕ [Whatsapp](#whatsapp) ⁕ [Social Media](#social-media) ⁕ [Facebook](#facebook) ⁕ [Twitter](#twitter) ⁕ [Youtube](#youtube) ⁕ [Instagram](#instagram) ⁕ [Reddit](#reddit) ⁕ [LinkedIn](#linkedin) ⁕ [Google](#google) ⁕ [Discord](#discord) ⁕ [Twitch](#twitch) ⁕ [Telegram](#telegram) ⁕ [Snapchat](#snapchat) ⁕ [TikTok](#tiktok) ⁕ [Steam](#steam) ⁕ [Search Engine](#search-engines) ⁕ [News](#news) ⁕ [Clubhouse](#clubhouse) ⁕ [Bot](#bot) ⁕ [Analysis](#analytics) ⁕ [Blog](#blog) ⁕ [Throwaway Contact](#throwaway-contact) ⁕ [ID Generator](#id-generator) ⁕ [Emulator](#emulator) ⁕ [Hash Recovery](#hash-recovery) ⁕ [Downloader](#downloader) ⁕ [Privacy / Security](#privacy--security) ⁕ [Secure Communication](#secure-communication) ⁕ [Resources](#resources) ⁕ [Threat Intel](#threat-intel) ⁕ [Identity Resolution](#identity-resolution) ⁕ [People](#people) ⁕ [Google CSE](#google-cse) ⁕ [Radio](#radio) ⁕ [Open Directory](#open-directory) ⁕ [Maps](#maps) ⁕ [Data Dump](#data-dump) ⁕ [Informant](#informant) ⁕ [Public Record](#public-records) ⁕ [Government](#government) ⁕ [Image and Audio](#images-and-audio)


#### <i>Some of other OSINT tools List</i>

- [osinttools.io](https://osinttools.io/) - Discover and compare the top OSINT tools in one place.
## Breaches and Leaks

- [greynoise](https://viz.greynoise.io/) - Search for IPs, Tags, CVEs, vpn, dns...
- [Dehashed](https://www.dehashed.com/) - You can search for your email if its leak in some databases of anything..
- [HaveIbeenPwned?](https://haveibeenpwned.com/) - check if your email address is in a data breach
- [ScamSearch](https://scamsearch.io/) - search to find phone, email, profile if is tobe a scammer.
- [Intelligence X](https://intelx.io/) - Intelligence X is a search engine and data archive. · The search works with selectors, i.e. specific search terms such as email addresses, domains, URLs, IPs...
- [spycloud](https://portal.spycloud.com/endpoint/enriched-stats/[YOUR-MAIL]) - put your mail in YOUR-MAIL.
- [weleakinfo](https://weleakinfo.io/) - We Leak Info - Leaked Dehashed Databases, search for leaks.
- [breachdirectory](https://breachdirectory.org/) - CHECK IF YOUR EMAIL OR USERNAME WAS COMPROMISED
- [leakcheck](https://leakcheck.io/) - Find out if your credentials have been compromised
- [Findemail.io](https://findemail.io/) - Find email addresses for given company.
  
## Basic OSINT
Data Leak, scam, username, domain, social
- [Lampyre](https://lampyre.io/) - Data analysis & osint tool, obtain, visualize and analyze data in one place to see what other's can't.
- [OffshoreLeaks](https://offshoreleaks.icij.org/) - find out who's behind offshore companies.
- [WorldWide OSINT Map](http://cybdetective.com/osintmap/) - gather basic info around the world.
- [WhatsMyName](https://whatsmyname.app/) - This tool allow to enumerate usernames across many websites.
- [os-surveillance](https://os-surveillance.io/) - Gather real-time intelligence from Social media, Cameras, Internet of Things or Crimes and Amber Alerts
In addition search for Wifi networks and look for planes, vessels, trains and city traffic
- [Chiasmodon](https://github.com/chiasmod0n/chiasmodon) - Chiasmodon is an OSINT tool designed to assist in the process of gathering information about a target domain. Its primary functionality revolves around searching for domain-related data, including domain emails, domain credentials, CIDRs , ASNs , and subdomains, the tool also allows users to search Google Play application ID.
- [Tookie-osint](https://github.com/alfredredbird/tookie-osint) - Tookie is a advanced OSINT information gathering tool that finds social media accounts based on inputs.
- [dangerzone](https://github.com/freedomofpress/dangerzone) - Take potentially dangerous PDFs, office documents, or images and convert them to safe PDFs
- [COMB](https://www.proxynova.com/tools/comb/) - the largest dataset of leaked credentials (emails, usernames, and passwords)
- [Face Detection and comparison](https://6mzld2.csb.app/) - compare two uploaded faces
- [Prospeo](https://prospeo.io/) - Find business email addresses for outreach, find mobile, domain search, email verifier.
 <br>

## AI
AI tools/Site
- [Decktopus](https://www.decktopus.com/) - Create beautiful & professional presentations in just minutes.
- [Monica](https://monica.im/) - Monica is a ChatGPT copilot in Chrome, who can help you: Summarize articles, Translate text, Define words
- [Poised](https://www.poised.com/) - It's a personal communication coach that gives real-time feedback to help you speak with more energy, clarity, & confidence.
- [StockimgAI](https://stockimg.ai/) - This AI tool helps you create beautiful images for your brand, such as: Logos, Wallpaper, Book covers.
- [ChatPDF](https://www.chatpdf.com/) - Upload a PDF and ask it questions. It's simple, straightforward, and great to learn information from
- [SheetplusAI](https://sheetplus.ai/) - Excel & Google spreadsheets are incredibly tedious work. Luckily, this AI tool will write the formulas for you. Sheets+ can save you 80% of your time by translating text into formulas.
- [10web](https://10web.io/) - Fill out a short questionnaire about your business, and 10Web will build an entire Wordpress website for you.
- [AgentGPT](https://agentgpt.reworkd.ai/) - AutoGPT's are all the rage right now, and this is among the best ones out there. ive your agent a goal and it'll autonomously give itself tasks, browse the web, and execute it for you.
- [LonardoAI](https://leonardo.ai/) - Leonardo.ai is a website for a company that offers AI-powered image and video editing tools. The website is designed with a sleek and modern look, featuring a black and white color scheme with pops of orange.
- [Adobe FireFly](https://firefly.adobe.com/) - A tool from adobe to generate Images from text prompt with added customization.
- [Groq](https://groq.com/) - Fastest LLM Model
- [YouLearn](https://www.youlearn.ai/) - Learn from an AI tutor that understands your pdfs, videos, and slides.
<br>

[⇧ Top](#index)

## Recon
Tools for Image/Audio/Video/Doc reconnaissance

- [FOCA](https://github.com/ElevenPaths/FOCA) - Tool to find metadata and hidden information in the documents.
- [FaceCheck](https://facecheck.id/) - Upload a face of a person of interest and discover their social media profiles, appearances in blogs, video, and news websites.
- [Osmedeus](https://github.com/j3ssie/osmedeus) - Osmedeus is a Workflow Engine for Offensive Security. It was designed to build a foundation with the capability and flexibility that allows you to build your own reconnaissance system and run it on a large number of targets.
- [log4j-scan](https://github.com/fullhunt/log4j-scan) - A fully automated, accurate, and extensive scanner for finding log4j RCE CVE-2021-44228
- [Odin](https://search.odin.io/) - A Internet Scanning, Thread hunting tool. Can used for domain, ip, port, cve...
<br>

[⇧ Top](#index)
## PRODUCTIVITY

- [it-tools](https://it-tools.tech/) - Collection of handy online tools for developers
- [unfurl](https://dfir.blog/unfurl/) - Break down url into pieces and find out what each thing do.
- [Wolfram|Alpha](https://www.wolframalpha.com/) - solve mathematical Equations
- [Cryptpad.fr](https://cryptpad.fr/) - Flagship instance of CryptPad, the end-to-end encrypted and open-source collaboration suite. Administered by the CryptPad development team.
- [Recontool.org](https://recontool.org/) - Recon tools
- [MindMup 2](https://app.mindmup.com/map/new) - Create MindMap online
- [Dotspotter](https://www.forensicdots.de/) - Discover the tracking dots on a scanned document. Upload an image (600 dpi) of your print out. Dottspotter will try to detect the yellow dot code (MIC)
- [Encrypted Pastebin](https://defuse.ca/pastebin.htm) - Pre-Internet Encryption for Text
- [PrivateBin](https://privatebin.net/) - PrivateBin is a minimalist, open source online pastebin where the server has zero knowledge of pasted data
- [Bin.disroot.org](https://bin.disroot.org/) - same as PrivateBin
- [~~Framadrop~~](https://framadrop.org/en/) - <font color=red>site closed</font>
- [Pad.riseup.net](https://pad.riseup.net/) - Etherpad is a software libre web application that allows for real-time group collaboration of text documents. Riseup does not store IP addresses, we require https, and pads are automatically destroyed after 60 days of inactivity
- [EtherCalc](https://ethercalc.net/) -
EtherCalc is a web spreadsheet.
- [Proofread Bot](https://proofreadbot.com/) - Proofread Bot gives you unlimited simple punctuation, style and grammar checks. For advanced checks (including plagiarism, comma splices, tenses....)
- [Write.as](https://write.as/) - Write.as is the easiest way to publish your writing on the web
- [Cryptee](https://crypt.ee/) - A private home for all your digital belongings
- [dudle](https://dudle.inf.tu-dresden.de/anonymous/) - Create Poll
- [Airborn.io](https://www.airborn.io/) - Create encrypted documents
- [ZOOM URL Generator](https://skyzh.github.io/zoom-url-generator/) - Create Zoom meeting url
- [Tor2web](https://www.tor2web.org/) - Tor is a software project that lets you anonymously browse the Internet. Tor2web is a project to let Internet users access Tor Onion Services without using Tor Browser
- [archive.is](https://archive.is/) - Archive.today is a time capsule for web pages!
It takes a 'snapshot' of a webpage that will always be online even if the original page disappears
- [Wayback Machine](https://web.archive.org/) - Internet archive of everything
- [waybackpy](https://pypi.org/project/waybackpy/) - Python package that interfaces with the Internet Archive's Wayback Machine APIs. Archive pages and retrieve archived pages easily.
- [CachedPages](http://www.cachedpages.com/) - A cached page is a snapshot or a version of a web page saved at a specific time and stored by a web server as a backup copy.
- [Google Cached Pages of Any Website](https://cachedview.com/) - The Google Cache Browser for any page on Internet
- [Oldweb.today](http://oldweb.today/) - see old web browser
- [Unpaywall](https://unpaywall.org/products/extension) - Read research papers for free paywall on millions of peer-reviewed journal articles. It's fast, free, and legal
- [DeepL](https://www.deepl.com/translator) - DeepL translate
- [Project CSV](https://projectcsv.github.io/) - view/modify csv files
- [CSV to HTML](https://codepen.io/RYJASM/pen/LVEWgV) - convert csv file to html
- [Monaco Editor](https://microsoft.github.io/monaco-editor/playground.html) - Online IDE
- [Online FlowChart Editor](https://mermaid-js.github.io/mermaid-live-editor/) - Generation of diagrams like flowcharts or sequence diagrams from text in a similar manner as markdown
- [Markdown Editor](https://markdown-editor.github.io/) - Markdown editor
- [SQL Editor](https://www.mycompiler.io/new/sql) - sql editor
- [SQLite Viewer](https://inloop.github.io/sqlite-viewer/) - drop sqlite file and view content, sqlite viewer
- [OCR Text Extractor](https://osint.sh/ocr/) - OCR text extractor from png, jpeg, webp and pdf
- [Wetranscriber](https://www.wetranscriber.com/) - A free, simple and efficient transcription platform for individuals or teams
- [Tophonetics.com](https://tophonetics.com/) - This online converter of English text to IPA phonetic transcription will translate your English text into its phonetic transcription using the International Phonetic Alphabet.
- [Google Translate](https://translate.google.com/) - Google Translator
- [Multi Translate](https://translate.mix.pink/)
- [Yandex.Translate](https://translate.yandex.com/) - translator from yandex
- [Bing Microsoft Translator](https://www.bing.com/translator) - translator from microsoft
- [Reverso](https://www.reverso.net/text_translation.aspx?lang=EN) - Enjoy cutting-edge AI-powered translation from Reverso in 25+ languages
including Arabic, Chinese, Italian, Portuguese, Dutch, Hebrew, Turkish, and Polish
- [Translate](https://www.translatedict.com/) -
- [text to speech online](https://www.naturalreaders.com/online/) - text to speech translator online
- [TTSReader](https://ttsreader.com/) - Read out loud webpages, texts, pdf's and ebooks with natural sounding voices
- [Online Sequencer](https://onlinesequencer.net/) - is an online music sequencer. Make tunes in your browser and share them with friends
- [FetchRSS](https://fetchrss.com/) - generate RSS out of anything
- [Sci-hub](https://sci-hub.st/) - the first pirate website in the world to provide mass and public access to tens of millions of research papers
- [Libgen.fun](https://libgen.fun/) - Free Book site to download
- [Z-lib.org](https://zlibrary24tuxziyiyfr7zd46ytefdqbqd2axkmxm4o5374ptpc52fad.onion.pet/) - The world's largest ebook library
- [PDF Drive](https://www.pdfdrive.com/) - PDF Drive is your search engine for PDF files.
- [arXiv.org](https://arxiv.org/) - arXiv is a free distribution service and an open-access archive for 2,142,712 scholarly articles in the fields of physics, mathematics, computer science, quantitative biology, quantitative finance, statistics, electrical engineering and systems science, and economics
- [bioRxiv.org](https://www.biorxiv.org/) - The preprint server for biology
- [Project Gutenberg](https://www.gutenberg.org/) - Gutenberg is a library of over 60,000 free eBooks
- [Trantor.is](https://trantor.is/) - There are 1479512 books on the library.
- [Shadowlibraries.github.io](https://shadowlibraries.github.io/) - A Pirate Library Archive
- [Editor.typely.com](https://editor.typely.com/) - Free online proofreading and essay editor
<br>

[⇧ Top](#index)

 ## OSINT Challenge
 - [billingcat](https://challenge.bellingcat.com/) - Test your open source research skills with these challenges.

 ## Whatsapp

 - [checkleaked](https://whatsapp.checkleaked.cc) - check whatsapp user profile without saving contact number and some other info.

 ## FILE UPLOAD

- [MEGA](https://mega.io/) - Secure Cloud Storage and Communication Privacy by Design Get 20GB of storage for free.
- [transfer.sh](https://transfer.sh/) -
- [Upload | Disroot](https://disroot.org/en/services/upload) - Lufi - Encrypted temporary file upload service
- [Chibisafe.moe](https://chibisafe.moe/) - Blazing fast file uploader. For real A modern and self-hosted file upload service that can handle anything you throw at it
- [Bunker.is](https://bunker.is/) -
- [Send](https://send.actionsack.com/) - Send lets you share files with end-to-end encryption and a link that automatically expires upload upto 2GB
- [Zz.fo](https://zz.fo/) -
- [Upload files to IPFS from Browser](https://anarkrypto.github.io/upload-files-to-ipfs-from-browser-panel/public/) - decentralize file shearing
- [BlackHole](https://blackhole.run/) - BlackHole is a file transfer application built on top of blockchain for the new internet. You can share any super security file with ease and be sure the data is yours forever. You can use BlackHole for free, with no storage or bandwidth limit, but for files bigger than 512 MB
<br>

[⇧ Top](#index)
## TOOLSET

- [shell.how](https://www.shell.how/) - This website provides a comprehensive overview of a command's functionality, including detailed explanations of its constituent fragments. 
- [bgp.tools](https://bgp.tools/) - BGP.tools is a website that provides a collection of tools and utilities related to the Border Gateway Protocol (BGP), which is the protocol used for routing Internet traffic between autonomous systems (ASes).
- [Seekr](https://github.com/seekr-osint/seekr) - All-In-One OSINT tool with neat web interface
- [CyberChef](https://gchq.github.io/CyberChef/) - Ecode/Decode strings
- [Dencode.com](https://dencode.com/) - DenCode is a web application for encoding and decoding values.
- [mitaka](https://github.com/ninoseki/mitaka) - A browser extension for OSINT search
- [pywhat](https://pypi.org/project/pywhat/) - The easiest way to identify anything
- [theHarvester](https://pypi.org/project/theHarvester/) - theHarvester is a very simple, yet effective tool designed to be used in the early stages of a penetration test. Use it for open source intelligence gathering and helping to determine a company's external threat landscape on the internet. The tool gathers emails, names, subdomains, IPs, and URLs using multiple public data sources
- [Online Tools](https://emn178.github.io/online-tools/) - A tool to encode,decode,hash,file hash etc.
- [Graphviz Online](https://dreampuf.github.io/GraphvizOnline/) - create svg graph
- [CodePen](https://codepen.io/) - CodePen is a social development environment. At its heart, it allows you to write code in the browser, and see the results of it as you build. A useful and liberating online code editor for developers of any skill, and particularly empowering for people learning to code. We focus primarily on front-end languages like HTML, CSS, JavaScript, and preprocessing syntaxes that turn into those things.
- [Diceware Generator](https://www.rempe.us/diceware/#eff) - Diceware is used to generate cryptographically strong passphrases. Don't let that frighten you away though, a passphrase is just a password made of words you can remember.
- [Checkphish.ai](https://checkphish.ai/) - Free URL scanner to detect phishing and fraudulent sites
- [x86 and x64 Intel Assembler](https://defuse.ca/online-x86-assembler.htm) - This tool takes x86 or x64 assembly instructions and converts them to their binary representation (machine code). It can also go the other way, taking a hexadecimal string of machine code and transforming it into a human-readable representation of the instructions. It uses GCC and objdump behind the scenes.
- [Big Number Calculator](https://defuse.ca/big-number-calculator.htm) - Online big number calculator.
- [Text and File Hash Calculator](https://defuse.ca/checksums.htm) - This page lets you hash ASCII text or a file with many different hash algorithms. Checksums are commonly used to verify the integrety of data. The most common use is to verify that a file has been downloaded without error. The data you enter here is 100% private, neither the data nor hash values are ever recorded.
- [HTML Sanitizer Tool](https://defuse.ca/html-sanitize.htm) - This tool will take your text and convert all the special characters to their proper HTML codes, so you can paste text with special characters or HTML code onto your website. It has been carefully designed so that the HTML produced by this tool looks and behaves exactly like the original text does in a text editor
- [URL Decoder/Encoder](https://meyerweb.com/eric/tools/dencoder/) - encode/decode URL in url form.
- [ODA - The Online Disassembler](https://onlinedisassembler.com/odaweb/) - A lightweight, online service for when you don’t have the time, resources, or requirements to use a heavier-weight alternative. Explore executables by dissecting its sections, strings, symbols, raw hex and machine level instructions.
- [Disasm.pro](https://disasm.pro/) - A realtime assembler/disassembler (formerly known as disasm.ninja)
- [Fotor](https://www.fotor.com/photo-editor-app/editor/basic) - Online image editor remove bg, crop, edit...
- [Decompiler.com](http://www.decompiler.com/) - online decompiler for java, apk, lua ....
- [Google Colaboratory](https://colab.research.google.com/notebooks/intro.ipynb) - Colab, or "Colaboratory", allows you to write and execute Python in your browser, with Zero configuration required Access to GPUs free of charge Easy sharing.
- [Compiler Explorer](https://godbolt.org/) - Run compilers interactively from your web browser and interact with the assembly
- [HTML editor](https://onlinehtmleditor.dev/) - Online HTML editor
- [Online Color Picker](https://colorpicker.me/) - Online color picker in HSL, Hex code, RGB, HSV
- [Convert text to image file](https://text2image.com/en/) - Generate online free an image from text (words) you supply. Then download your image file or link to it on our system. You can have text up to 500 characters; size (width/height): between 10 and 1500 pixels; format: one of several popular formats - GIF, JPEG or PNG; font: the size of your letters in a range from 6pt to 54pt (6 point to 54 point); colors: the forecolor (color of the letters in your text) and backcolor (background color behind the letters)
- [relational algebra calculator](https://dbis-uibk.github.io/relax/calc/local/uibk/local/0) - If you want to learn SQL you take a database system and try some queries. But if you want to learn relational algebra what do you use? Pen and paper? The relational algebra calculator helps you learn relational algebra (RelAlg) by executing it.
- [Data Structure : Infix Postfix Prefix - Converter & Evaluator](https://raj457036.github.io/Simple-Tools/prefixAndPostfixConvertor.html) - This is a simple infix to prefix or postfix Converter.
- [RSA encryption, decryption and prime calculator](https://canihavesomecoffee.github.io/js-rsa-tool/) - RSA encryption, decryption and prime calculator
- [Tools.digitalmethods.net](https://tools.digitalmethods.net/beta/searchEngineScraper/) - The Search Engine Scraper allows you to scrape the search results for a given search query, and has as output a list of results the search engine returned for the query
- [Steganography Online](https://stylesuxx.github.io/steganography/) - Steganography is a process which can encode message in image. In this site just upload a image then enter a text and hit encode to encode message.
- [Torrent to Magnet](https://nutbread.github.io/t2m/) - Convert .torrent file to magnet URI's just drop the file
- [Anonymous YouTube Playlists](https://neverducky.github.io/anonymous-youtube-playlists/) - A simple tool for generating a YouTube playlist that isn't tied to an account
- [Vega Editor](https://vega.github.io/editor/#/) - create pie, charts and more through your browser
- [DISA Code Template Generator](https://duncanford.github.io/disa-code-generator) - To purpose of this generator is to quickly create the content for all the separate five files you need to create a template DISA integration. Almost everything can be keyed from a single name: the name of the plugin
- [Canary Tokens](http://canarytokens.org/generate) -You'll be familiar with web bugs, the transparent images which track when someone opens an email. They work by embedding a unique URL in a page's image tag, and monitoring incoming GET requests. Canarytokens helps track activity and actions on your network.
- [explainshell.com](https://explainshell.com/) - write down a command-line to see the help text that matches each argument
- [ShowTheDocs](http://showthedocs.com/) - showthedocs is a documentation browser that finds the relevant docs for your code. It works by parsing the code and connecting parts of it to their explanation in the docs
- [osint-cli-tool-skeleton](https://pypi.org/project/osint-cli-tool-skeleton/) - OSINT cli tool skeleton
- [Wifispc.com](https://wifispc.com/) - Free map of Wi-Fi passwords anywhere you go!
- [Wiman](https://www.wiman.me/) - Seamless connections to millions mobile Free WiFi hotspots.
<br>

[⇧ Top](#index)

## THROWAWAY CONTACT/Temporary contact

- [10minutemail.com](https://10minutemail.com/) - Disposable mail for 10 min.
- [AnonAddy](https://anonaddy.com/) - Anonymous Email Forwarding Create Unlimited Email Aliases For Free and best part Its OpenSource
- [SimpleLogin](https://simplelogin.io/) - Receive and send emails anonymously
- [MailDrop](https://maildrop.cc/) - Save your inbox from spam. Use Maildrop when you don't want to give out your real address No signup required - Maildrop is free for anyone to use when you need a quick, disposable email address.
- [Send text free](https://globfone.com/send-text/) - Send text online without worrying about phone bills. Free SMS to hundreds of GSM operators worldwide
- [SendaText](https://www.sendatext.co/) - SENDaTEXT allows you to send free text and SMS from your computer or smartphone. All you need to use SENDaTEXT is a standard web browser and internet. You can now send free text online from your computer or smartphone. No need to sign up. No need to make any payment. Send a text now!
- [Free Fax](https://faxzero.com/) -Send faxes for free to anywhere in the U.S. and Canada Or, Send an International Fax
- [Receive SMS Online](http://receive-sms-online.com/) - On this site you will find some numbers you can send SMS text messages to and the messages will show up on the web.
- [Receive-sms-now.com](http://receive-sms-now.com/) -
- [Receive SMS Online](https://hs3x.com/) - receive sms online
- [Receive SMS Online for FREE](http://freesmsverification.com/) - Free SMS Verification Receive SMS Online Verify your SMS received from any place in the World. The messages will show up on the webpage.
- [Smstome.com](https://smstome.com/) - Virtual Temporary and Disposable Phone Numbers
- [Amazon SNS](https://aws.amazon.com/sns/) - Amazon Simple Notification Service (SNS) sends notifications two ways, A2A and A2P. A2A provides high-throughput, push-based, many-to-many messaging between distributed systems, microservices, and event-driven serverless applications. These applications include Amazon Simple Queue Service (SQS), Amazon Kinesis Data Firehose, AWS Lambda, and other HTTPS endpoints. A2P functionality lets you send messages to your customers with SMS texts, push notifications, and email. 
- [Twilio](https://www.twilio.com/) - api for sms services
<br>

[⇧ Top](#index)
## ID GENERATOR

- [Username Generator](https://www.lastpass.com/features/username-generator) - Random username generator tool
- [Fake Name Generator](https://www.fakenamegenerator.com/) - Randomly Generated Identity
- [Resume Generator](https://thisresumedoesnotexist.com/) - With this AI resume generator, we wanted you to try and see best resumes you can ever think of building. The AI often goes haywire when writing a resume content - both credit and criticism goes to TextgenRNN.
- [International Name Generator](https://www.behindthename.com/random/) - random name generator
- [Windows Phone IMEI Generator](https://wpimeigenerator.github.io/) - Windows Phone IMEI Generator
- [IMEI Number Generator](https://dyrk.org/tools/imei/) - fake IMEI number generator
- [US SSN / Driver License / State ID / Passport / Tax ID Generator](https://www.elfqrin.com/usssndriverlicenseidgen.php) - US SSN / Driver License (DL) / State ID / Passport / Tax ID Generator
- [Washington State Driver’s License Generator](https://mmarvick.github.io/wa-drivers-license/) - Washington State Driver's License Generator
- [Fake Drivers License Generator](https://fakeinfo.net/drivers-license-generator) - Get a false authorized Driver's License to fool your college friends and gain popularity using the Fake Driver License Generator. Use this tool for legal purposes only until you get an original one
- [This Rental Does Not Exist](https://thisrentaldoesnotexist.com/) - Rental Does not Exist
- [Face Photo Generator](https://thispersondoesnotexist.com/) - random Photo generator
- [Random Face Generator](https://fakeinfo.net/random-face-generator) - Want to make your profile more attractive to boost your account reach? Then try our Random Face Generator Tool. It lets you select your favorite image among the variety of options
- [Credit Card Generator](https://www.fakenamegenerator.com/credit-card-validator.php) - Fake credit card number generator
- [PIC/CIC Code Database](https://www.allredtech.com/) - A PIC or CIC code is a 4-digit prefix that identifies a long distance carrier in North America or the Caribbean to a LEC. The LEC uses the code to properly route the call.
- [SIN Generator](https://www.fakenamegenerator.com/social-insurance-number.php) - Canadian Social Insurance Number (SIN)
- [ABA Generator](https://www.fakenamegenerator.com/aba-validator.php) - ABA/Routing Number Validator
- [VIN Generator](https://www.fakenamegenerator.com/vehicle-identification-number.php) - Vehicle Identification Number
- [NINO Generator](https://www.fakenamegenerator.com/national-insurance-number.php) - UK National Insurance Number (NINO)
- [SSN Generator](https://www.fakenamegenerator.com/social-security-number.php) - US Social Security Number (SSN)
- [IID Generator by Georgy Bunin](https://georgybu.github.io/IID_Generator/) - Israel ID generator and validator
- [GUID/UUID and short GUID generator](https://richardkundl.github.io/shortguid/) - GUID/UUID and short GUID generator
- [Nano ID CC](https://zelark.github.io/nano-id-cc/) - Nano ID is a library for generating random IDs. Likewise UUID, there is a probability of duplicate IDs. However, this probability is extremely small.
- [Generate SA ID Numbers](https://chris927.github.io/generate-sa-idnumbers/) - Generate (Fake) South-African ID Numbers
- [Decoding Social Security Numbers](https://stevemorse.org/ssn/ssn.html) - Decoding Social Security Numbers in One Step
- [Encoding and Decoding Driver’s License Numbers](https://stevemorse.org/dl/dl.html) - Encoding and Decoding Driver's License Numbers in One Step
- [Dating Profile Generator](https://www.dating-profile-generator.org.uk/) - The aim of Dating Profile Generator is to help you fill that all-important free text field on online dating sites. Give us a feel for the kind of person that you are, and we'll write a description of you in the tone we think you'd take if you bothered to write it yourself
- [Fake Identity ID Random Name Generator](https://www.elfqrin.com/fakeid.php) - Generate a random character with a fake name for games, novels, or alter ego avatars of yourself. Create a new virtual disposable identity instantly. Note that characters are not totally random: they are statistically adjusted, so that you can generate a credible population of realistic virtual people.
- [Fake Company Name Generator](https://fakeinfo.net/company-name-generator) - Random Company Name Generator tool is designed to gratify the entrepreneur's needs. Generate catchy brand names within seconds for your new startups using our tool.
- [Twitter Profile Generator](https://fakeinfo.net/fake-twitter-profile-generator) - If you want to have an attractive profile to gain more followers, then use our Fake Twitter Profile Generator tool. It lets you create a fake Twitter profile with a false number of followers and posts.
- [Fake Tiktok Profile Generator](https://fakeinfo.net/fake-tiktok-profile-generator) - Who doesn't love to have a huge number of followers and posts on the popular social media platform TikTok? Everybody loves to. One may create a fake TikTok profile with a higher follower count using our Fake Tiktok Profile Generator tool.
- [Fake Youtube Channel Generator](https://fakeinfo.net/fake-youtube-channel-generator) - d you ever wish to become a YouTuber with a large number of subscribers? Well, dreams do come true. By using the Fake Youtube Channel Generator tool, you may create a fake youtube channel with an attractive channel name and several subscribers.
- [Resume Builder](https://vinaysomawat.github.io/Resume-Builder/) - simple resume builder
- [Fake Generator Tools](https://fauxid.com/tools) - Here are a list of tools that can help you create fake identities, fake emails, fake credit cards, fake driver's license, and a fake company.
<br>

[⇧ Top](#index)
## EMULATOR

- [Kasm](https://kasmweb.com/) - Streaming containerized apps and desktops to end-users. The Workspaces platform provides enterprise-class orchestration, data loss prevention, and web streaming technology to enable the delivery of containerized workloads to your browser.
- [Bluestacks](https://www.bluestacks.com/) - Android emulator
- [Genymotion](https://www.genymotion.com/) - Android Virtual Devices for all your team, project, development & testing needs
- [PrimeOS](https://www.primeos.in/) - PrimeOS, the ideal Android based OS for mobile games on PC/Laptop
- [BigNox](https://www.bignox.com/) - NoxPlayer, the perfect Android emulator to play mobile games on PC
- [Memuplay.com](https://www.memuplay.com/) - The most powerful android emulator enjoy ultimate mobile gaming experience on PC
- [Ldplayer.net](https://www.ldplayer.net/) - Your Best Partner for Mobile Games
<br>

[⇧ Top](#index)

## HASH RECOVERY

- [CrackStation](https://crackstation.net/) - CrackStation uses massive pre-computed lookup tables to crack password hashes. These tables store a mapping between the hash of a password, and the correct password for that hash. The hash values are indexed so that it is possible to quickly search the database for a given hash.
- [Hashmob Community](https://hashmob.net/search) - We want to elevate password research and recovery to new heights. Passwords chosen by users are fundamentally flawed, and the best way to make users choose better passwords is showing them that Cryptographic methods - regardless of strength - are not enough to protect them. Their passwords themselves must be strong enough to withstand even the most rigorous of attacks. HashMob wants to provide a platform for users to collaborate together so that password research can be improved upon and trends can be discovered. We aggregate data and publish statistics, wordlists, rules, resources, tutorials, guides, and other things that researchers and penetration testers can use to further improve themselves
- [Hashes.com](https://hashes.com/en/decrypt/hash) - Hashes.com is a hash lookup service. This allows you to input an MD5, SHA-1, Vbulletin, Invision Power Board, MyBB, Bcrypt, Wordpress, SHA-256, SHA-512, MYSQL5 etc hash and search for its corresponding plaintext ("found") in our database of already-cracked hashes
- [Online Password Hash Crack](https://www.onlinehashcrack.com/) - Cloud-based service that attempts to recover passwords (hashes, WPA dumps, Office, PDF, iTunes Backup, Archives) obtained in a legal way (pentest, audit,..).
- [Md5 Decrypt & Encrypt](https://md5decrypt.net/en/) - encrypt decrypt md5 hashes
- [MD5 reverse lookup](https://md5.gromweb.com/) - MD5 conversion and reverse lookup
- [Ultimate Hashing](https://md5hashing.net/) - [En|De]crypt Hash — Generate hash out of the string and lookup (unhash) for hash value in our pre-computed hash-tables
- ~[Hashes.org](https://hashes.org/search.php)~ <font color="red">Dead!</font>
<br>

[⇧ Top](#index)
 ## DOWNLOADER

- [yt-dlp](https://github.com/yt-dlp/yt-dlp) - Command-line program to download videos from YouTube.com and other video sites
- [Media-downloader.net](https://media-downloader.net/) -
- [Imgur Album Downloader](https://dschep.github.io/imgur-album-downloader/#/) - A Pure client-side webapp to download entire or parts of Imgur albums.
- [Export Comments](https://exportcomments.com/) - Easily exports all comments from your social media posts to Excel file.
- [Image Extractor](https://extract.pics/) - Extract Images From any public website by using a virtual browser
- [Loader.to](https://loader.to/) - YouTube MP3 Playlist Downloader Online
- [Commentexporter.com](https://www.commentexporter.com/) - Export and save facebook comment to your computer. Nested comment supported.
Enter your "Post URL" to export
- [Twitch Tools](https://twitch-tools.rootonline.de/followerlist_viewer.php) - This tool lets you view the followers on any Twitch account.
- [Link Gopher](https://sites.google.com/site/linkgopher/) - Link Gopher is a simple extension to extract links from Firefox or Google Chrome. It extracts all links from web page (including embedded links), sorts them, removes duplicates, and displays them in a new tab for copy and paste into other systems. Also, Link Gopher does the same for unique domains.
- [Page Links Extractor Tool](https://shadowcrypt.net/tools/pagelinks) - Pagelink Extractor scans the entire web page and lists down all hyperlinks on the website. It is useful for research purpose and uses regex to extract the link. It will be regularly updated.
- [Online Tool to Extract Links from any Web Page](https://hackertarget.com/extract-links/) - This tool will parse the html of a website and extract links from the page. The hrefs or "page links" are displayed in plain text for easy copying or review.
<br>

[⇧ Top](#index)
## PRIVACY / SECURITY

- [The Hitchhiker’s Guide to Online Anonymity](https://anonymousplanet.org/guide.html) - The Hitchhiker’s Guide to Online Anonymity
- [Privacy Guides](https://privacyguides.org/) - The guide to restoring your online privacy.
- [Surveillance Self-Defense](https://ssd.eff.org/) - Surveillance Self-Defense Tips, Tools and How-tos for Safer Online Communications
- [Consumer Reports Security Planner](https://securityplanner.consumerreports.org/) - Keep Your Data Secure With a Personalized Plan
Cut down on data collection and protect your sensitive personal information, health data, and geolocation. Answer a few simple questions to get customized recommendations to help you
- [Security in a Box](https://securityinabox.org/en/) - digital security tools and tactics
- [PRISM Break](https://prism-break.org/en/) - opt out of global data survelliance programs like PRISM, XKeyscore and Tempora
- [Security First - Umbrella](https://secfirst.org/umbrella/) - Umbrella is the only security handbook you'll ever need in a free, open source app. It's up-to-date information you can trust. And it's always in your pocket
- [Matweb.info](https://matweb.info/) - Remove Metadata The file you see is just the tip of the iceberg. Remove the hidden metadata with MAT2
- [Metacleaner.com](https://metacleaner.com/) - MetaCleaner helps you stay anonymous Clean your files MetaData online
- [Image Scrubber](https://everestpipkin.github.io/image-scrubber/) - This is a tool for anonymizing photographs taken at protests. It will remove identifying metadata (Exif data) from photographs, and also allow you to selectively blur parts of the image to cover faces and other identifiable information
- [View Exif data online, remove Exif online](http://www.verexif.com/en/) - View and remove Exif online
- [Bitcoinprivacy.guide](https://bitcoinprivacy.guide/) - Bitcoin privacy guide a beginners guide to Bitcoin privacy
- [LocalBitcoins](https://localbitcoins.com/) - Buy and Sell Bitcoin Everywhere
- [Localmonero.co](https://localmonero.co/) - Buy Monero.Sell Monero.Cash or online.Anywhere.
- [Paxful](https://paxful.com/) - Trade Bitcoin with Paxful.
- [Speech Jammer](https://mynoise.net/NoiseMachines/audioJammerNoiseGenerator.php) - Audio jammers are popular tools used during confidential meetings. They produce a unique sound for masking and protecting conversations from external listening devices, such as a smartphone running an audio recording app, hidden in one of your guests' pocket
- [Stutterbox](https://www.stutterbox.co.uk/) - A speech jammer is a device that inhibits a user from speaking in coherent sentences due to the user hearing their own voice played back to them with a slight delay.
- [StegOnline](https://stegonline.georgeom.net/upload) - A web-based, enhanced and open-source port of StegSolve. Upload any image file, and the relevant options will be displayed.
- [WhatsMyName](https://whatsmyname.app/) - This tool allows you to enumerate usernames across many websites, just enter username and this tool show you how many websites have that username.
- [ScamSearch](https://scamsearch.io/) - Find your scammer online & report them. Don't let them get away. Search by Profile Picture, Email, Username, Pseudo Name, Phone Number, crypto address or website
<br>

[⇧ Top](#index)
 ## SECURE COMMUNICATION

- [Signal](https://signal.org/) - Signal is a simple, powerful, and secure messenger like whatsapp but opensource
- [Element](https://element.io/) - Secure communication and collaboration
- [Briar](https://briarproject.org/) - Peer-to-peer encrypted messaging and forums
- [Jami.net](https://jami.net/) - Share, freely and privately
- [Jitsi Meet](https://meet.jit.si/) - start and join meetings for free No account needed
- [Rocket.Chat](https://rocket.chat/) - We use communication platforms on a daily basis to collaborate with colleagues, other companies, customers and communities. Most of them give you very little in terms of control and customizations; except Rocket.Chat.
- [Wire](https://wire.com/en/) - Modern day communication meets the most advanced security and superior user experience. Protect your privacy and data like never before.
START FOR FREE
- [Telegram](https://www.telegram.org/) - Telegram is a cloud-based mobile and desktop messaging app with a focus on security and speed.
- [Brave Talk](https://talk.brave.com/) - unlinited private video calls, right in your browser. No app required
- [The Tor Project](https://www.torproject.org/download/) - Protect yourself against tracking, surveillance, and censorship.
- [Brave Browser](https://brave.com/) - Browse privately. Search privately. And ditch Big Tech.
- [Psiphon](https://www.psiphon.ca/) - Secure and high-performance, Psiphon provides open access to the uncensored internet for millions of people around the world
- [ProtonVPN](https://protonvpn.com/) - High-speed Swiss VPN that safeguards your privacy.
- [hide.me VPN](https://hide.me/en/) - hide.me VPN is trusted by more than 25 million users globally because of its simplicity, privacy features & speed.
- [AdGuard VPN](https://adguard-vpn.com/en/welcome.html) - Use any browser or app and never worry about your anonymity again. The entire world is at your fingertips with AdGuard VPN.
- [I2P](https://geti2p.net/en/download) - The Invisible Internet Project (I2P) is a fully encrypted private network layer that has been developed with privacy and security by design in order to provide protection for your activity, location and your identity. The software ships with a router that connects you to the network and applications for sharing, communicating and building.
- [VPN Services](https://privacyguides.org/providers/vpn/) - Find a no-logging VPN operator who isn’t out to sell or read your web traffic.
- [Browser Recommendations](https://privacyguides.org/browsers/) - These are our currently recommended desktop web browsers and configurations for standard/non-anonymous browsing. If you need to browse the internet anonymously, you should use Tor instead. In general, we recommend keeping your browser extensions to a minimum; they have privileged access within your browser, require you to trust the developer, can make you stand out, and weaken site isolation.
<br>

[⇧ Top](#index)
 ## RESOURCES

- [The Ultimate OSINT Collection](https://start.me/p/DPYPMz/the-ultimate-osint-collection) - This page is for anyone who loves open source investigating, and feels overwhelmed by the amount of resources and information out there. This is my personal one-stop shop for the best OSINT content available online, and I hope it helps you find new ways to learn from some amazing people
- [OSINT Resources in Canada](https://start.me/p/aLe0vp/osint-resources-in-canada) - OSINT Resources in Canada. This is a free resource dedicated to open source tools located in the different provinces and territories in Canada
- [FAROS OSINT Resources](https://start.me/p/1kvvxN/faros-osint-resources) - Financial Open Source Intellige
- [TI](https://start.me/p/rxRbpo/ti) - collection of CTI resources. originally created this to track valuable investigation resources (mostly OSINT)
- [TOOLKIT](https://start.me/p/W1AXYo/toolkit) - toolkit for osint
- [Trouble Fake](https://start.me/p/QRQb0O/trouble-fake) -
- [OSINT Is A State Of Mind](https://medium.com/secjuice/osint-as-a-mindset-7d42ad72113d) - Dutch guy with Open Source Intelligence & Analysis skills • Osint • Security Awareness • Opsec
- [sinwindie/OSINT](https://github.com/sinwindie/OSINT) - Collections of tools and methods created to aid in OSINT collection
- [New Online Investigation (OSINT) Resources – IntelTechniques Blog](https://inteltechniques.com/blog/2019/04/09/new-online-investigation-osint-resources/) - New Online Investigation (OSINT) Resources
- [Technisette](https://www.technisette.com/p/home) - Here you'll find my collected tutorials, tools, databases, addons, search engines and more to help you with your Open Source Intelligence (OSINT) research. 
- [OSINT Framework](https://osintframework.com/) - OSINT framework focused on gathering information from free tools or resources. The intention is to help people find free OSINT resources. Some of the sites included might require registration or offer more data for $$$, but you should be able to get at least a portion of the available information for no cost.
- [jivoi/awesome-osint](https://github.com/jivoi/awesome-osint) - A curated list of amazingly awesome OSINT
- [Google Dork Cheatsheet](https://github.com/robyfirnandoyusuf/Google-Dork-Cheatsheet) - google dorks cheatsheet
- [START CARING STOP SHARING](https://medium.com/@Dutchosintguy/start-caring-stop-sharing-9c108d957b2c) - An Open Source Intelligence perspective on the online sharing behavior of humans as effect of COVID19 pandemic to enable better Security Awareness.
- [Osint Curious OSINT Resource List](https://docs.google.com/document/d/14li22wAG2Wh2y0UhgBjbqEvZJCDsNZY8vpUAJ_jJ5X8/edit) - OSINT Curious Project Resource List! Below you can find links to all the blog posts and 10 Minute Tips that we’ve created to help share knowledge and skills with the OSINT Community. The list is regularly updated as we create new content but you can also find us at OSINTCurio.us
- [OSINT Tools](https://www.osinttechniques.com/osint-tools.html) - OSINT Tools
- [OSINT tools for investigating websites](https://www.aware-online.com/en/osint-tools/website-tools/) -
- [Shodan Cheat Sheet](https://thedarksource.com/shodan-cheat-sheet/) -
- [Week in OSINT](https://sector035.nl/articles/category:week-in-osint)
- [Osint.team](https://osint.team/)
- [QueryTool](https://github.com/oryon-osint/querytool) - Querytool is an OSINT framework based on Google Spreadsheets. With this tool you can perform complex search of terms, people, email addresses, files and many more.
- [Investigating the source code of a website](https://www.aware-online.com/en/osint-tutorials/investigating-the-source-code-of-a-website/) - The source code of a website can be seen as the readable text written by a programmer in a programming language. Simply said, the source code consists of a variety of code lines, which together ensure that a website ‘ works ‘ and that a website looks a certain way.
- [Find open FTP Servers](https://www.aware-online.com/en/osint-tutorials/find-open-ftp-servers/) - find an open ftp server osint
- ~~[Choose your wallet](https://bitcoin.org/en/choose-your-wallet)~~
- [10 Minute Tips](https://osintcurio.us/10-minute-tips/) - a library of OSINT tips, tricks, tools, and techniques.
- ~~[Webint Master](https://webintmaster.com/)~~
- ~~[DFIR Diva](https://dfirdiva.com/hooked-on-osint/)~~
- [Boolean Strings | Tools](https://booleanstrings.com/tools/) - 150+ Top Sourcing / #OSINT Tools
- [osintme.com](https://www.osintme.com/) - 3 years an OSINT blog
- ~~[Jake Creps](https://jakecreps.com/)~~
- ~~[reKnowledge](https://www.reknowledge.tech/)~~
- [Bellingcat’s Online Investigation Toolkit](https://docs.google.com/spreadsheets/d/18rtqh8EG2q1xBo2cLNyhIDuK9jrPGwYr9DI2UncoqJQ/edit#gid=930747607) - This toolkit includes satellite and mapping services, tools for verifying photos and videos, websites to archive web pages, and much more.
- [@Ivan30394639 OSINT tools collection](https://cipher387.github.io/osint_stuff_tool_collection/) - different services, techniques, tricks and notes about OSINT and more. I collect all the links from my tweets in this collection (already 1000+ services for a wide variety of purposes).
- [The Top 132 Osint Open Source Projects](https://awesomeopensource.com/projects/osint) - The Top 1,309 Osint Open Source Projects
- [30 best OSINT extensions for Google Chrome – osintme.com](https://www.osintme.com/index.php/2021/06/30/30-best-osint-extensions-for-google-chrome/) - 30 best OSINT extensions for Google Chrome
- ~~[Where Can I Find… - Free DFIR Related Training](https://freetraining.dfirdiva.com/where-can-i-find)~~
- [Awesome Deblurring](https://github.com/subeeshvasu/Awesome-Deblurring) - A curated list of resources for Image and Video Deblurring
- [OSINT.SH](https://osint.sh/) - All in one Information Gathering Tools
- [OSINT Techniques](https://www.osinttechniques.com/) - Resources for Open Source Intelligence and Social Media Investigations.
- ~~[OSINT aka Atvirųjų šaltinių žvalgyba](https://blog.parakomanai.lt/osint-387e80bdc901)~~
- [CTI & OSINT Online Resources](https://docs.google.com/spreadsheets/d/1klugQqw6POlBtuzon8S0b18-gpsDwX-5OYRrB7TyNEw/edit#gid=0) -
- [Emsisoft Decryptor for Avaddon](https://www.emsisoft.com/ransomware-decryption-tools/avaddon) - Use our free ransomware decryption tools to unlock your files without paying the ransom
- [hwosint (@harrywald80)](https://twitter.com/harrywald80) - follow this twitter account for daily osint updates
- [Awesomelists.top](http://awesomelists.top/) - AwesomeSearch makes you find what you want in awesome lists more quickly.
- [GitHub Awesome Search](https://github.motakasoft.com/awesome/) - github awesome repo's
- [Ph055a OSINT_Collection](https://github.com/Ph055a/OSINT_Collection) - Maintained collection of OSINT related resources. (All Free & Actionable)
- [MetaOSINT](https://metaosint.github.io/) - A tool to quickly identify relevant, publicly-available open source intelligence ("OSINT") tools and resources, saving valuable time during investigations, research, and analysis.
- [Osint.support](https://osint.support/) - Open Source Intelligence (OSINT) is the collection and analysis of information that is gathered from public, or open, sources. OSINT is primarily used in national security, law enforcement, and business intelligence functions and is of value to analysts who use non-sensitive intelligence in answering classified, unclassified, or proprietary intelligence requirements across the previous intelligence disciplines
- ~~[Sprp77/My-Google-CSE](https://github.com/Sprp77/My-Google-CSE/blob/master/List%201)~~
- ~~[How to Build an OSINT Super Machine for People Surveillance and Sourcing](https://outline.com/GZbkZA)~~
- [How to find anyone with an advanced LinkedIn People Search](https://nubela.co/blog/how-to-find-anyone-with-an-advanced-linkedin-people-search/) - How To Find Anyone With An Advanced LinkedIn People Search
- [Calls Node Status](https://www.broadcastify.com/calls/status/) - Current Active Call Ingest Nodes
- [Free WiFi Search Engine](http://instabridge.com/free-wifi/) - Search WiFi spots worldwide
<br>

[⇧ Top](#index)

## WEATHER

- [OpenWeatherMap](https://openweathermap.org/) - Weather forecasts, nowcasts and history in a fast and elegant way
- [Weather History & Data Archive](https://www.wunderground.com/history) - Find historical weather by searching for a city, zip code, or airport code. Include a date for which you would like to see weather history
- [World Temperatures — Weather Around The World](https://www.timeanddate.com/weather/) - World Temperatures Weather Around The World
- [AccuWeather](https://www.accuweather.com/) - Weather around the world
<br>

[⇧ Top](#index)

## World clock

- Los Angeles (United States): 3:16
- Houston (United States): 5:16
- New York (United States): 6:16
- London (United Kingdom): 11:16
- Berlin (Germany): 12:16
- Cairo (Egypt): 12:16
- Tehran (Iran): 14:46
- New Delhi (India): 15:46
- Hong Kong: 18:16
- Japan: 19:16
- Sydney (Australia): 20:16
<br>

[⇧ Top](#index)
 ## THREAT INTEL

- [Threatbutt](https://threatbutt.com/map/) - Threatbutt Internet Hacking Attack Attribution Map
- [Cyberthreat Real-Time Map](https://cybermap.kaspersky.com/) - cyberthreat real-time attack map of the world
- [Live Cyber Attack Threat Map](https://www.checkpoint.com/ThreatPortal/livemap.html) - Live cyber threat map
- [Digital Attack Map](https://www.digitalattackmap.com/) - Live Global DDoS Attack
- [Cyber Threat Map](https://www.fireeye.com/cyber-map/threat-map.html) -
- [Bitdefender Threat Map](https://threatmap.bitdefender.com/) - cyberthreat realtime map
- [Cyber Threat Intelligence](https://pulsedive.com/) - Frictionless threat intelligence solutions for growing teams
- [Cisco Talos Intelligence Group](https://talosintelligence.com/) - Gather Intelligence for IPs, Domain, network of file
- [Fortinet Threat Map](https://threatmap.fortiguard.com/) -
- [FortiGuard](http://www.fortiguard.com/) - AI-Powered Threat Intelligence for an Evolving Digital World.
- [Hunt](https://www.hunt.io/) - Hunt is a threat hunting tool with good open directory counter intelligence and IOC hunting that detects and neutralizes malicious activities.
- [ThreatMiner](https://www.threatminer.org/) - ThreatMiner is a threat intelligence portal designed to enable analysts to research under a single interface.
- [cymon](https://cymon.io/) -
- [intelowlproject/IntelOwl](https://github.com/intelowlproject/IntelOwl) - manage your Threat Intelligence at scale
- ~~[Visualizing Global Internet Performance](https://www.akamai.com/us/en/solutions/intelligent-platform/visualizing-akamai/real-time-web-monitor.jsp)~~
- [THREAT MAP by LookingGlass](https://map.lookingglasscyber.com/)
- [NETSCOUT Cyber Threat Horizon](https://horizon.netscout.com/) - NETSCOUT Cyber Threat Horizon (Horizon) is a global cybersecurity situational awareness platform that provides organizations with highly contextualized visibility into 'over the horizon' threat activity on the landscape.
- [APTnotes](https://github.com/aptnotes/data) - APTnotes is a repository of publicly-available papers and blogs (sorted by year) related to malicious campaigns/activity/software that have been associated with vendor-defined APT (Advanced Persistent Threat) groups and/or tool-sets.
- [Hudson Rock Free Cybercrime Intelligence Tools](https://www.hudsonrock.com/threat-intelligence-cybercrime-tools) - Check if a specific domain or email address was compromised by Infostealer infections.
<br>

[⇧ Top](#index)

 ## OTHER

- [https://cryptome.wikileaks.org/](https://cryptome.wikileaks.org/) - WikiLeaks is a multi-national media organization and associated library. It was founded by its publisher Julian Assange in 2006.
- [Nextstrain](https://nextstrain.org/) - Real-time tracking of pathogen evolution ; pathogen genome data

## IDENTITY RESOLUTION

- [Clearbit](https://dashboard.clearbit.com/lookup) - Clearbit is the first HubSpot Native Data Provider.
Enrich your records, score and route instantly
- [FullContact API](https://dashboard.fullcontact.com/login) - We provide the data + intelligence you need in your platforms to accurately identify people and optimize experiences—while putting privacy and security first
- [Aeroleads.com](https://aeroleads.com/) - Search database of 500 Million Business Emails, 120M Personal Emails and 20M Phone Numbers
<br>

[⇧ Top](#index)

## UNIFIED SEARCH

- [SynapsInt](https://synapsint.com/) - Synapsint is a 100% free service, the data that is presented for each search is the result of consulting different intelligence services, search engines, datasets, etc.
You will find a lot of information related to a domain, a IP Address or to an ASN. Information like metatags, web site records, ISP, virus analysis, open ports, vulnerabilities, subdomains, location, network, WHOIS, DNS records, technologies used, pastes, social media accounts, blacklisted IP, links and other stuff, also you can know if an URL belongs to a phishing site.
- [InfoTracer](https://infotracer.com/) - Instant Public Records Search Contact Info, Criminal Records, Arrests, Assets, Social Profiles & More
- [MetaDefender](https://metadefender.opswat.com/) - Find threats in File, url, ip addr, hash ....
- [Username Search](https://usersearch.org/) - Find someone by username or email on Social Networks, Dating Sites, Forums, Crypto Forums, Chat Sites and Blogs. 600+ sites Supported! Largest Reverse User Search Online
- [SpyTox](https://www.spytox.com/) - Find people, personal info & phone numbers
- [Effect Group](https://effectgroup.io/) - Open Source Research Platform: Our open Source Research Platform allows journalists, lawyers, private investigators and more to find information on people that is openly available on the web
- [osrframework](https://pypi.org/project/osrframework/) - OSRFramework, the Open Sources Research Framework is a AGPLv3+ project by i3visio focused on providing API and tools to perform more accurate online researches.
- [Google Custom Search](https://cse.google.com/cse?cx=017648920863780530960:lddgpbzqgoi) - google custom search engine
- [OSINT Search Engine](https://cse.google.com/cse/publicurl?cx=006290531980334157382:qcaf4enph7i) - custom search engine
- [LinkScope](https://github.com/AccentuSoft/LinkScope_Client) - LinkScope allows you to perform online investigations by representing information as discrete pieces of data, called Entities.
- [IOA](https://www.io-archive.org/) - The Information Operation Archive hosts publicly available and rigorously attributed datapoints from known Information Operations on social media platforms.
<br>

[⇧ Top](#index)
## PEOPLE

- [IDCrawl](https://www.idcrawl.com/) - People Search a friend, relative, yourself, or someone else you may know (US ONLY).
- [WebMii](https://webmii.com/) - people search engine
- [TruePeopleSearch](https://www.truepeoplesearch.com/) - people search
- [Free People Search](https://www.peoplefinder.com/) - Police Records, Background Checks, Social Media, Photos, Assets, Contact Information and Much More! (us only)
- [Yandex People Search](https://yandex.ru/people) - Yandex people search engine
- ~~[FamilyTree](https://www.familytreenow.com/)~~ - 404
- [fastpeoplesearch](https://fastpeoplesearch.com/) - Find a person by name, phone number, or street address.
- ~~[TruePeopleSearch](https://truepeoplesearch.com/)~~ - 404
- [People Search](http://itools.com/search/people-search) - Use the best people search tools to find someone's contact information. Find a person's street address, phone number or email address.
- [People Search Engine](https://cse.google.com/cse?cx=14db36e158cd791c0) - people search engine
- [Dating Sites Search Engine](https://cse.google.com/cse?cx=c7b340447e1e12653) - custom dating sites search engine
- [192](https://www.192.com/) - Search for People, Businesses & Places in the UK
- [International](https://www.infobel.com/) - Find a business or an individual in the world
- [People search Tool](https://www.aware-online.com/en/osint-tools/people-search-tool/) - A custom OSINT tool can help you to effectively search for people on the internet.
- [PeekYou](https://www.peekyou.com/) - PeekYou is a free people search engine site that places people at the center of the Internet. It lets you discover the people most important and relevant to your life.
- [White Pages](https://www.whitepages.com/) - Find people, contact info & background checks
- [New Canada 411](https://www.canada411.ca/) - people search for canada
- [411](http://411.com/) - people search for canada
- [TruthFinder](https://www.truthfinder.com/) - Social Media, Photos, Police Records, Background Checks, Civil Judgments, Contact Information and Much More! (US)
- [zaba search](https://www.zabasearch.com/) - Free People Search and Public Information Search Engine! (US)
- [Thats them](https://thatsthem.com/) - Free People Search Engine Find Addresses, Phones, Emails, and Much More
- [People search](https://radaris.com/) - Fast People Search Contact Information & Public Records
- [Free People Search](http://www.yasni.com/) -
- [Gofindwho.com](https://gofindwho.com/) - 404
- [xlek](https://xlek.com/) - USA Data Search Search Public Data Instantly
- [Ufind.name](https://ufind.name/) - free people search
<br>

[⇧ Top](#index)
## USERNAME

- [WhatsMyName Web](https://whatsmyname.app/) - username search
- [Username Checker](https://analyzeid.com/username/) - Social media username checker. Gather information on the taken username and get a summary of who the person is.
- [Username Search](https://www.idcrawl.com/username) - Uncover social media profiles and real people behind a username
- [maigret](https://pypi.org/project/maigret/) - Maigret collect a dossier on a person by username only, checking for accounts on a huge number of sites and gathering all the available information from web pages
- [sherlock](https://github.com/sherlock-project/sherlock) - Hunt down social media accounts by username across social networks
- [socialscan](https://pypi.org/project/socialscan/) - socialscan offers accurate and fast checks for email address and username usage on online platforms.
- [socid-extractor](https://pypi.org/project/socid-extractor/) - Extract information about a user from profile webpages / API responses and save it in machine-readable format.
- [social-analyzer](https://pypi.org/project/social-analyzer/) - Social-Analyzer - API, CLI & Web App for analyzing & finding a person’s profile across social media websites. It includes different string analysis and detection modules, you can choose which combination of modules to use during the investigation process.
- [KnowEm](https://knowem.com/) - KnowEm allows you to check for the use of your brand, product, personal name or username instantly on over 500 popular and emerging social media websites
- [Check Usernames](https://checkusernames.com/) - Check the use of your brand or username on 160 Social Networks
- [Username Checker](https://checkuser.org/) - Check Your Desired Usernames Across 70+ Popular Social Network Sites
- [Namechk](https://namechk.com/) - With Namechk, you can check the availability of a username or domain name within seconds
- [Lullar Com](https://com.lullar.com/) - Profile search by email, username or first name
- ~~[OSINT Toolkit](https://one-plus.github.io/EmailUsername)~~
- [Username search tool](https://www.aware-online.com/en/osint-tools/username-search-tool/) - username search with customization
- [snoop](https://github.com/snooppr/snoop) - Snoop Project One of the most promising OSINT tools to search for nicknames. Over 4000+ sites (THE BEST ONE)
<br>

[⇧ Top](#index)

 ## EMAIL

- [Email Lookup](https://epieos.com/) - The ultimate OSINT tool for email and phone reverse lookup
- [holehe](https://pypi.org/project/holehe/) - holehe allows you to check if the mail is used on different sites like twitter, instagram , snapchat and will retrieve information on sites with the forgotten password function.
- ~~[Infoga](http://github.com/m4ll0k/Infoga)~~ - 404
- ~~[Trumail](https://trumail.io/)~~ - Purchase by emailable.
- [Email Verifier](https://hunter.io/email-verifier) - Verify any email address with the most complete email checker.
- [Reverse Whois](https://osint.sh/reversewhois/) - Allow you to find domain names owned by an email address
- [Email Dossier](https://centralops.net/co/emaildossier.aspx) - check if email address is valid or not.
- [Email Format](https://www.email-format.com/) - find the email address formats in use at thousands of companies.
- [Email Header Analyzer](https://mxtoolbox.com/EmailHeaders.aspx) - Email headers are present on every email you receive via the Internet and can provide valuable diagnostic information like hop delays, anti-spam results and more. If you need help getting copies of your email headers
- [E-mail search tool](https://www.aware-online.com/osint-tools/e-mail-search-tool/) - Email search tool - Research on email addresses
- [Proofy](https://proofy.io/) - Email address verifier, or email checker, is a tool that can clean your email list from temporary or invalid emails.
- [Email Permutator](http://metricsparrow.com/toolkit/email-permutator/) - create unique email address of given info
- [Phonebook.cz](https://phonebook.cz/) - Phonebook lists all domains, email addresses, or URLs for the given input domain.
You are searching 121 billion records.
- [Email Breach Analysis](https://www.hotsheet.com/inoitsu/) - Use this free service to check if an email address is in any hacked data from known database breaches. Get a summary of what specific information may be at risk, critical personal identity alerts, a relative exposure rating and more. Results are shown immediately - no verification, upgrades or extra steps are required.
- [Emailrep.io](https://emailrep.io/) - check email reputation
- ~~[Email Finder](https://osint.sh/email/)~~ - 404
- [EmailHarvester](https://pypi.org/project/EmailHarvester/) - A tool to retrieve Domain email addresses from Search Engines
- [h8mail](https://pypi.org/project/h8mail/) - Email OSINT and password breach hunting. Use h8mail to find passwords through different breach and reconnaissance services, or using your local data
- [WhatBreach](https://github.com/Ekultek/WhatBreach) - OSINT tool to find breached emails, databases, pastes, and relevant information
- [email2phonenumber](https://github.com/martinvigo/email2phonenumber) - A OSINT tool to obtain a target's phone number just by having his email address
- [buster](https://github.com/sham00n/buster) - An advanced tool for email reconnaissance
- [Anymailfinder.com](https://anymailfinder.com/) - Find the email address of a person by entering their name and the company name or domain.
- [SimpleMail](https://www.simplemail.dev/) - A simple API to send transactional emails to users, without needing to worry about SMTP, templates, etc..
- [Protonmail](https://proton.me/mail) - Proton Mail is a Swiss end-to-end encrypted email service
- [Tuta](https://tuta.com/) - Tuta is the world's most secure email service, easy to use and private by design.
- [Predicta Search](https://predictasearch.com) - Get the digital footprint from an email or phone number
<br>

[⇧ Top](#index)
## PHONE

- [PhoneInfoga](https://sundowndev.github.io/phoneinfoga/) - PhoneInfoga is one of the most advanced tools to scan international phone numbers. It allows you to first gather standard information such as country, area, carrier and line type on any international phone number, then search for footprints on search engines to try to find the VoIP provider or identify the owner.
- [Phonerator](https://www.martinvigo.com/tools/phonerator/) - An advanced valid phone number generator.
- [Reverse Phone Lookup](https://www.idcrawl.com/phone) - Find out who's behind the phone: Reverse phone lookup made easy
- [Nuwber](https://nuwber.com/) - to find phone numbers, addresses, police records, social profiles and much more.
- [ignorant](https://pypi.org/project/ignorant/) - ignorant allows you to check if a phone is used on different sites like snapchat.
- [Validnumber.com](https://validnumber.com/) - Valid Number offers a free reverse phone lookup service to let you identify a caller associated with any 10-digit phone number from the US and Canada.
- [NumLookup](https://www.numlookup.com/) - NumLookup can be used to perform a completely free reverse phone lookup for any phone number
- [Reverse Phone Lookup](https://www.reversephonecheck.com/) - Look up names, addresses, phone numbers, or emails and anonymously discover information about yourself, family, friends, or old schoolmates.
- [Phone Number Lookup Tool](https://shadowcrypt.net/tools/phone) - Phone Number Lookup will check if the given number is valid.
- [SYNC.me](https://sync.me/) - you can search a number here. truecaller alternative
- [OpenCelliD](https://opencellid.org/) - The world's largest Open Database of Cell Towers
- ~~[Find GSM base stations cell id coordinates](https://cellidfinder.com/)~~ - DEAD
- [Moriarty-Project](https://github.com/AzizKpln/Moriarty-Project) - Moriarty Project is a powerful web based phone number investigation tool. It has 6 features and it allows you to choose either all features, or the features you like
- [Phone Scoop](https://www.phonescoop.com/phones/) - Search for phones by specs and features
- [GSM Arena](https://www.gsmarena.com/) - NEWS about Mobile phones, updates, launches etc
- [Oldphonebook.com](http://www.oldphonebook.com/) - search a large selection from the past 20 years of USA phone listing
- [carrier lookup](https://www.carrierlookup.com/) - Look Up A Cell Phone Carrier Right Now For Free!
- [Free Reverse Phone Lookup](https://spydialer.com/default.aspx) - free reverse lookup search and more
<br>

[⇧ Top](#index)
# SOCIAL MEDIA

- [Who posted what?](https://whopostedwhat.com/) - whopostedwhat.com is a non public Facebook keyword search for people who work in the public interest. It allows you to search keywords on specific dates.
- [SOCMINT](https://start.me/p/Wp1kpe/socmint) - some of the best tools
- [SocialMap](https://vincos.it/world-map-of-social-networks/) - World map of social media.
- [Vimeo search tool](https://www.aware-online.com/en/osint-tools/vimeo-search-tool/) - on Vimeo . Quickly search for videos, people, channels and groups
- [Kribrum.io](https://kribrum.io/) - NOTE: IF YOU FIND OUT IST'S WORKING LET ME KNOW-
- [Social Search Engine](https://www.socialsearchengine.org/) - Search social information from multiple social networking sites including Facebook, Twitter, Steemit, Google Plus, Blogspot, LinkedIn and more at same time.
- [Instagram, Reddit & Snapchat](https://one-plus.github.io/Instagram) - search people, posts ...
- [Google to search profiles on Dribbble](https://recruitin.net/dribbble.php) - Dribbble is good for finding front end developers, graphic designers, illustrators, typographers, logo designers, and other creative types.
<br>

[⇧ Top](#index)
 ## FACEBOOK

- [Facebook Search Engine](https://cse.google.com/cse?cx=95ae46262a5f2958e)
- [Facebook Photo Search Engine](https://cse.google.com/cse/publicurl?cx=013991603413798772546:jyvyp2ppxma)
- [Facebook Scraped Data search](http://4wbwa6vcpvcr3vvf4qkhppgy56urmjcj2vagu2iqgp3z656xcmfdbiqd.onion.to/) - search in facebook scaped data (if onion[.]to is not working open in tor browser without .to) OR [Click Here](https://fr.4everproxy.com/secure/zHLV62xyZZROpM~9TGrMISNsG3Yk6QS167xKdMmQ1tMKKloKw3TsCdU~fpQ7gOsk1m7t39p1sYlsg9ThAyYdCAeYqI1pOWMT39tWTRf5i4I-)
- ~~[Facebook Search](https://www.social-searcher.com/facebook-search/)~~ - 404
- [Facebook Video Downloader](https://fbdown.github.io/) - Download Facebook Videos and Save them directly from facebook to your computer or mobile for Free without Software
- [Have I Been Zucked?](https://haveibeenzuckered.com/) - Check if your telephone number is present within the Facebook data breach.
- ~~[Facebook Profile Directory](https://www.facebook.com/directory/)~~ - 404
- [Find My Facebook ID](https://commentpicker.com/find-facebook-id.php) - Find your Facebook ID for your Facebook profile, group or page.
<br>

[⇧ Top](#index)
 ## TWITTER

- [BirdHunt](https://birdhunt.co/) - BirdHunt will show you all tweets within the chosen geographic location
- [Nitter](https://github.com/zedeus/nitter/) - Alternative Twitter front-end
- [Twitter Search Engine](https://cse.google.com/cse?cx=5857bab69c8b8e37e) - custom search engine for twitter
- [Twitter Photo Search](https://cse.google.com/cse/publicurl?cx=006290531980334157382:_ltcjq0robu) - custom search engine for twitter
- [twint](https://pypi.org/project/twint/) - Twint is an advanced Twitter scraping tool written in Python that allows for scraping Tweets from Twitter profiles without using Twitter's API.
- [Tweet Archive Search](https://cse.google.com/cse/publicurl?cx=005797772976587943970:kffjgylvzwu) - custom search engine for twitter
- [Twitter Advanced Search](https://twitter.com/search-advanced) - search with additional filters
- [Twitter search tool](https://www.aware-online.com/en/osint-tools/twitter-search-tool/) - create advanced search queries within Twitter. In addition, we refer you to useful tools that allow you to analyze and monitoran account on Twitter
- [Google to search profiles on Twitter](https://recruitin.net/twitter.php) - Easily use Google to search profiles on X (Twitter)
- [Search Twitter Bios and Profiles](https://followerwonk.com/bio) - 404
- [The one million tweet map](https://onemilliontweetmap.com/) - create map of tweets from hashtag, username, keywords.
- [Tweet Binder](https://www.tweetbinder.com/) - Free Twitter Hashtag Analytics of up to 200 posts from the last 7 days.
- [Thread Reader](https://threadreaderapp.com/) - Thread Reader helps you read and share Twitter threads easily!
- ~~[Search Twitter Users](https://pushshift.io/twitter-user-search/)~~ - 404
- [Getdewey.co](https://getdewey.co/) - Save your favorite X (Twitter) and Bluesky bookmarks in one place
- [geosocial footprint](http://geosocialfootprint.com/) - GeoSocial Footprint: A geosocial footprint is the combined bits of location information that a user divulges through social media, which ultimately forms the users location "footprint". For Twitter.com users, this footprint is created from GPS enabled tweets, social check-ins, natural language location searching (geocoding), and profile harvesting.
- [Twitter Analytics](https://foller.me/) - Looking for someone in the United States? Our free people search engine finds social media profiles, public records, and more!
- [getdaytrends](https://getdaytrends.com/) - Twitter trends worldwide
- [Twitter Trending Hashtags and Topics](https://www.trendsmap.com/) - Trendsmap has been providing unique and powerful analytical and visualisation tools to analyse Twitter data. With the demise of Twitter, we are now providing access to over ten years historical data
- [Socialbearing](https://socialbearing.com/) - Insights & analytics for tweets & timelines
- [SocialData API](https://socialdata.tools/) - SocialData is an unofficial Twitter API that allows scraping tweets, user profiles, lists and Twitter spaces without using Twitter's API.
<br>

[⇧ Top](#index)
## YOUTUBE

- [yt-dlp](https://pypi.org/project/yt-dlp/) - Youtube downloader with additional features.
- [Location Search](https://mattw.io/youtube-geofind/location) - Search YouTube by location for geotagged videos. Find videos near you or anywhere in the world.
- [YouTube Metadata Bulk](https://mattw.io/youtube-metadata/bulk) - Metadata bulk grabs details about multiple YouTube videos, a playlist's videos, or a channel's public videos.
- [Hadzy.com](https://hadzy.com/) - Search, sort and analyze youtube comments
- [Youtube channel ID](https://commentpicker.com/youtube-channel-id.php) - Find YouTube Channel ID, and related channel information and statistics.
- [Extract Meta Data YouTube](https://citizenevidence.amnestyusa.org/) - Youtube DataViewer
- [Youtube Geo Search Tool](https://youtube.github.io/geo-search-tool/search.html) - a simple model of how News organizations could use Google APIs to help find citizen journalism on YouTube. It uses YouTube and Google APIs to generate location based search results which are stack ranked by upload time.
- [Yout](https://yout.com/) - search for something in the search bar, click your video, and then record it as a Mp3 (Audio), you can toggle to Mp4 (Video), or Gif (Image) if you want those instead.
- [YouTube Comment Finder](https://ytcomment.kmcat.uk/) - Search for a video, channel or VideoID
- [Youtube, Periscope, Twitch & Dailymotion](https://one-plus.github.io/Youtube) - general search tool for youtube
- [Unlistedvideos.com](https://unlistedvideos.com/) - A website for submitting, searching for, and watching unlisted YouTube videos.
- [Youtube Comments Downloader](https://youtubecommentsdownloader.com/) - Effortlessly export comments from YouTube videos, live streams, shorts, and community posts. Perfect for YouTubers, social media managers, researchers [PAID]
- [ActiveTK](https://www.activetk.jp/tools/yt-not-well-known) - This web application allows you to search for Youtube videos by
the number of views or likes.
- [youtubetranscript](https://youtubetranscript.com/) - Extremely fast free online service for converting YouTube videos to text. Not perfect quality, but quite acceptable and very fast.

<br>

[⇧ Top](#index)
## REDDIT

- [Reveddit.com](https://www.reveddit.com/) - Reveal Reddit's secretly removed content. Search by username or subreddit
- ~~[Karma Decay](http://karmadecay.com/)~~ - 404
- [redditsfinder](https://pypi.org/project/redditsfinder/) - Archive a reddit user's post history. Formatted overview of a profile, JSON containing every post, and picture downloads.
- [SocialGrep](https://www.socialgrep.com/search) - Search reddit posts and comments. Advanced filters via date, score, subreddit, keywords, website urls and more. All searches can be exported via csv or json.
- [Redective](https://www.redective.com/) - Redective works in realtime by querying reddit each time you do a search
- [Reddit_Persona](https://github.com/n2itn/reddit_persona) - A Python module to extract personality insights, sentiment & keywords from reddit accounts.
- [Reddit Downloader](https://redditdownloader.github.io/) - Download media from reddit like image, audio, video.
- [Reddit Search Engine](https://cse.google.com/cse?cx=0728740ab68a619ba) - custom google search for reddit
- [Reddit Search Engine](https://cse.google.com/cse/publicurl?cx=017261104271573007538:bbzhlah6n4o) - custom google search for reddit
- [Reddit User Analyser](https://reddit-user-analyser.netlify.app/) - Analyse a Reddit user by username
- ~~[reddit search](https://www.redditsearch.io/)~~ - 500
- [RedditMetis](https://redditmetis.com/) - See statistics for your Reddit account
- [Search Reddit Comments by User](https://www.redditcommentsearch.com/) - Search through comments of a particular reddit user. Just enter the username and a search query
- ~~[Reddit Investigator](https://www.redditinvestigator.com/)~~ - 404
- [Pushshift API Guide](https://github.com/pushshift/api) - The pushshift.io Reddit API was designed and created by the /r/datasets mod team to help provide enhanced functionality and search capabilities for searching Reddit comments and submissions.
<br>

[⇧ Top](#index)
## LINKEDIN

- [LinkedIn Search](https://recruitin.net/) - Easily use Google to search profiles on LinkedIn
- [LinkedIn Search Engine](https://cse.google.com/cse?cx=daaf18e804f81bed0) - custom google search for linkedin
- [LinkedIn Email Reverse Lookup](https://osint.support/chrome-extensions/2019/09/03/linkedin-email-reverse-lookup.html) - chrome extention for linkedin Simply provide an email address which is of interest to you and click Search. If a match is found the name, profile id, username will be returned as well as the profile image if one exists.
- [Proxycurl](https://nubela.co/proxycurl/) - Pull rich data about people and companies

## GOOGLE

- [Google Finder](https://tools.epieos.com/google-account.php) - Find out google info like name by email id
- [Google Social Search](https://www.social-searcher.com/google-social-search/) - Top Social Networks Search Results Dashboard
- [Google+ & LinkedIn](https://one-plus.github.io/G+Link) - search by fields
- [GHunt](https://github.com/mxrch/GHunt) - Offensive Google framework.
- [Google+ Photo Custom Search](https://cse.google.com/cse/publicurl?cx=006205189065513216365:uo99tr1fxjq) - custom google search
<br>

[⇧ Top](#index)

## DISCORD

- ~~[Discord User Search](https://discordhub.com/user/search)~~ - 502
- [Discord Me](https://discord.me/) - Public Discord Servers and Bots
- [Discord History Tracker](https://dht.chylex.com/) - Discord History Tracker lets you save chat history in your servers, groups, and private conversations, and view it offline.
- [DiscordOSINT](https://github.com/atoncehussein/DiscordOSINT) - This repository contains useful resources to conduct research and OSINT investigations on Discord accounts ,servers and bots
- [DiscordServers](https://discordservers.com/) - Public Discord servers you may like
- [DISBOARD](https://disboard.org/) - Disboard is the place where you can list/find Discord servers.
- [Discord ID Lookup](https://discord.id/) - Unofficial discord lookup
- [Discord Bots](https://discordbotlist.com/) - Find the best Discord Bots, Apps and Servers with our Discord Bot List, including the top music and economy apps.
- [Discord Bots](https://top.gg/) - Explore millions of Discord Bots
- [Discord Bots](https://discord.bots.gg/) - This site is a list of publicly available Discord bots, intended to accompany the Discord Bots, Discord server. The bots presented here are created and maintained by community members and serve all kinds of purposes
<br>

[⇧ Top](#index)

## TWITCH

- [TwitchTracker](https://twitchtracker.com/) - track info about twitch user
- [Twitch Payout Search](https://sizeof.cat/project/twitch-payout-search/) - Twitch Payout Search
- [Search for a Twitch channel](https://sullygnome.com/channelsearch) - Search for a Twitch channel (stats for past 7 days)
- [Searchstream.live](https://searchstream.live/) - twitch live stream filter search
- [Username Availability](https://cactus.tools/twitch/username) - search for Twitch Username Availability
- [Check channel badges](https://cactus.tools/twitch/badges) - Check channel badges
- [Twitch Following](https://cactus.tools/twitch/following) - Check the Twitch channels someone is following
- [All Twitch Streamers Search](https://twitchstats.net/allstreamers) - All Twitch Streamers You can search any twitch streamers/channels here...
- [Twitchmetrics.net](https://www.twitchmetrics.net/) - This website gives a meaningful insights about Twitch activity to subs and plebs alike
<br>

[⇧ Top](#index)

## INSTAGRAM

- [InstaHunt](https://instahunt.co/) - InstaHunt shows you Instagram places and posts surrounding the chosen geographic location
- [Instagram Deep Photo Search Engine](https://cse.google.com/cse?cx=017261104271573007538:ffk_jpt64gy) - custom instagram deep photo search
- [Instagram analyzer and viewer](https://gramho.com/) - Reviwu is a platform for reviewing influencers, i.e., popular Instagram, YouTube, TikTok and OnlyFans content creators. Today, many influencers delete and block everything that does not suit them, which creates a false image of everyone liking and supporting them. Reviwu allows you to give your honest opinion and to review the chosen influencer in a neutral place without fear of censorship
- [Find Instagram User ID](https://codeofaninja.com/tools/find-instagram-user-id/) - Find Instagram User ID
- [Instagram User ID](https://commentpicker.com/instagram-user-id.php) - Find any Instagram User ID by Instagram username.
- [instalooter](https://pypi.org/project/instalooter/) - InstaLooter is a program that can download any picture or video associated from an Instagram profile, without any API access
- [instaloader](https://pypi.org/project/instaloader/) - Download pictures (or videos) along with their captions and other metadata from Instagram.
- [osi.ig](https://github.com/th3unkn0n/osi.ig) - Information Gathering Instagram.
- [Osintgram](https://github.com/Datalux/Osintgram) - Osintgram is a OSINT tool on Instagram. It offers an interactive shell to perform analysis on Instagram account of any users by its nickname
- [SoIG](https://github.com/yezz123/SoIG) - OSINT Tool gets a range of information from an Instagram account
- [yesitsme](https://github.com/blackeko/yesitsme) - Simple OSINT script to find Instagram profiles by name and e-mail/phone
<br>

[⇧ Top](#index)

## TELEGRAM

- [Telegago](https://cse.google.com/cse?&cx=006368593537057042503:efxu7xprihg#gsc.tab=0) - custom google search for telegram
- [Telegram Search](https://cse.google.com/cse?cx=004805129374225513871:p8lhfo0g3hg) - custom google search for telegram
- [Telegram Search. Search for posts](https://tgstat.com/search) - TGStat offers a full range of possibilities for a comprehensive search of posts and messages in Telegram
- [Lyzem Blog](https://lyzem.com/) - search telegram posts
- [Telegram Channels List](https://tlgrm.eu/channels) - Discover interesting channels for your Telegram
- [Readergram.com](https://readergram.com/) - Here you can find channels, chats and groups for every taste and preference
- [Find Telegram Channels/Bots/Groups](https://xtea.io/ts_en.html) - search for telegram group, channels, bots
- [Telegram Group: Find Telegram Channels, Bots & Groups](https://www.telegram-group.com/en/) - Telegram Channels, Groups, and Bots
- [TelegramDB.org](https://telegramdb.org/) - TelegramDB is a service that allows you to search for channels, groups and their members.
- [Global Telegram Database](https://t.me/s/privatelinks) - Telegram Database: channels, groups and users
- [Nekogram X](https://f-droid.org/packages/nekox.messenger/) - NekoX is an third-party Telegram client, based on Telegram-FOSS with features added.
<br>

[⇧ Top](#index)
## SNAPCHAT

- [Snap Map](https://map.snapchat.com/) - World map of snap just tap on location and watch
- ~~[Snapdex](https://snapdex.com/)~~ - 404
- ~~[Snapchat User Search](https://sovip.io/)~~ - 503
- [SnapScraper](https://rhematt.github.io/Snap-Scraper/) - SnapScraper is an open source intelligence tool which enables users to download media uploaded to Snapchat’s Snap Map using a set of latitude and longitiude co-ordinates.
- [snapmap-archiver](https://pypi.org/project/snapmap-archiver/) - Download all Snapmaps content from a specific location.
<br>

## TIKTOK

- [TIKTOK Search Engine](https://cse.google.com/cse?cx=011444696387487602669:aqf7d9w73om) - custom search for tiktok
- [TikTok User Search](https://vidnice.com/search/) - Make a TikTok search to find some users or hashtags.
- [TikTok downloader](https://tiktokd.com/) - 522
- [Hashtags for Likes](https://hashtagsforlikes.co/) - Tool for finding the best hashtags for TikTok posts.
- [HypeAuditor](https://hypeauditor.com/) - Tool for analyzing the authenticity of TikTok influencers.
- [Influence Grid](https://www.influencegrid.com/) - Tool for finding TikTok influencers.
- [InstaFollowers](https://www.instafollowers.co/) - Tool for finding TikTok user IDs.
- [Mavekite.com](https://mavekite.com/) - Tool for managing and analyzing TikTok campaigns.
- [OSINT Combine TikTok Quick Search](https://osintcombine.com/) - Quick search tool for TikTok profiles.
- [Savefrom.net](https://savefrom.net/) - Tool for downloading TikTok videos.
- [Sinwindie TikTok Bookmarklet Tools](https://sinwindie.com/) - Bookmarklet tools for TikTok OSINT.
- [Snaptik.app](https://snaptik.app/) - Tool for downloading TikTok videos.
- [Socid_extractor](https://socidextractor.com/) - Tool for extracting social media IDs.
- [Tikbuddy](https://tikbuddy.com/) - Tool for analyzing TikTok profiles and content.
- [TikTok API](https://developers.tiktok.com/) - API for interacting with TikTok.
- [TikTok Creative Center Statistics](https://www.tiktok.com/business/creativecenter) - Tool for finding trending hashtags and content on TikTok.
- [TikTok Downloader](https://tiktokdownloader.org/) - Tool for downloading TikTok videos.
- [TikTok Hashtags](https://www.tiktok.com/hashtag/) - Tool for generating TikTok hashtags.
- [TikTok Scraper](https://tiktokscraper.com/) - Tool for scraping TikTok profiles and videos.
- [TikTok Timestamp](https://www.tiktoktimestamper.com/) - Tool for analyzing timestamps on TikTok videos.
- [TikView](https://www.tikview.com/) - Tool for searching TikTok profiles and content.
- [tikvstock](https://tikvstock.com/) - Tool for stock and analyzing TikTok videos.
- [Tokvid](https://tokvid.com/) - Tool for downloading TikTok videos.
- [TubeHi](https://www.tubehi.com/) - Tool for analyzing TikTok and YouTube content.

Let me know if you'd like any changes!
<br>

[⇧ Top](#index)
## STEAM

- [Steam Community :: Search](https://steamcommunity.com/search/users/) - Search the Steam Community by alias.
- [Steam ID Finder](https://steamidfinder.com/lookup/) - Lookup and convert your Steam Hex, SteamID, SteamID3, SteamID64, Custom URL and Community ID
- [steamdb.info/calculator](https://steamdb.info/calculator/) - Lookup a SteamID and calculate the value of any Steam account
<br>

## CLUBHOUSE

- [Clubhouse Database](https://clubhousedb.com/) - Clubhouse Database - User Search & Analytics
- [Rooms of Clubhouse](https://roomsofclubhouse.com/) - Search open and scheduled Rooms in the Clubhouse App
- ~~[ClubSearch – search Clubhouse rooms](https://clubsearch.io/)~~ - 404
<br>

[⇧ Top](#index)

## BOT

- [Bot Sentinel Dashboard ‹ Bot Sentinel](https://botsentinel.com/) - Bot Sentinel to help fight disinformation and targeted harassment. We believe Twitter users should be able to engage in healthy online discourse without inauthentic accounts, toxic trolls, foreign countries, and organized groups manipulating the conversation.
- [Botometer by OSoMe](https://botometer.osome.iu.edu/) - a centralized place to share annotated datasets of Twitter social bots. We also provide list of available tools on bot detection.
- [FollowerAudit](https://www.followeraudit.com/) - Check fake followers and analyze the followers of any X (Twitter) account
- [Twitter Bot Checker](https://circleboom.com/twitter-management-tool/twitter-circle-tool/twitter-bot-checker) - Find Twitter bots and check your friends and followers' authenticity, and be safe!
<br>

[⇧ Top](#index)
## ANALYTICS

- [SEO Resources Search Engine](https://cse.google.com/cse/publicurl?cx=005797772976587943970:i7q6z1kjm1w) - custom google search
- [Hashatit](https://www.hashatit.com/) - Everywhere on social media, content is being generated at unheard of speeds. Hashtags help you navigate the ever-expanding internet, and HASHATIT keeps you on top of hashtags.
- [Social Mentions](https://www.social-searcher.com/media-monitoring/) - Maintaining an excellent reputation is crucial for any company, no matter its size. Start your mentions monitoring right now and grow safely.
- [Social Trends](https://www.social-searcher.com/social-trends/) - Find top social posts, statuses, photos and videos, which were recently published about specific topic.
- [Semrush](https://www.semrush.com/) - Do SEO, content marketing, competitor research, PPC and social media marketing from just one platform.
- [Network Tool](https://osome.iu.edu/tools/networks/#/) - The Network Tool generates an interactive network to explore how information spreads across Twitter using the OSoMe data archive. You may search the archive using a single hashtag or comma-separated list of hashtags. The timespan between start and end dates cannot exceed 30 days.
- [Trends Tool](https://osome.iu.edu/tools/trends/#/) - Analyze the volume of tweets with a given hashtag or URL over a given period of time using OSoMe data.
<br>

[⇧ Top](#index)
## BLOG

- [Blogs Search Engine](https://cse.google.com/cse?cx=013991603413798772546:8c1g6f0frp8#gsc.tab=0) - custom google search for blog posts
- [WordPress Content Snatcher](https://cse.google.com/cse/publicurl?cx=011081986282915606282:w8bndhohpi0) - custom google search wordpress content
- [WordPress Custom Search](https://cse.google.com/cse?cx=011081986282915606282:w8bndhohpi0) - wordpress custom sesarch
- [OSINT Blogs Search Engine](https://cse.google.com/cse?cx=fd4729049350a76d0) - custom google search for blogs
<br>

[⇧ Top](#index)
## NEWS

- [News Search Engine](https://cse.google.com/cse?cx=013991603413798772546:fvmtax6anhd) - custom google search for news only results
- [Mailing List Archives Search Engine](https://cse.google.com/cse/publicurl?cx=013991603413798772546:sipriovnbxq) - custom google search for mailing list archives of news
- [Google News](https://news.google.com/) - google news feed around the world
- [News Search](https://upstract.com/search) - Upstract is the ultimate attempt in delivering the entire Internet on a single page search the news
- [Welcome to Dealstrap!](http://correctsearch.com/) - Find Breaking news around the world
- [Beautiful News](https://informationisbeautiful.net/beautifulnews/) - A collection of good news, positive trends, uplifting statistics and facts — all beautifully visualized by Information is Beautiful.
- [GoodGopher.com](https://goodgopher.com/) - GoodGopher is the world's first privacy-protected search engine that filters our corporate propaganda and government disinformation for those searching for information and news on liberty, natural healing, central banks, food freedom, advanced science and a multitude of other topics no longer allowed in NSA-controlled search engines.
- [Newsnow](https://www.newsnow.co.uk/) - NewsNow: The Independent News Discovery Platform for UK,US,CA
- ~~[Mereku.com](https://mereku.com/)~~ - 404
- [Newspapers.com](https://www.newspapers.com/) - The largest online newspaper archive, established in 2012. Used by millions for genealogy and family history, historical research, crime investigations, journalism, and entertainment. Search for obituaries, marriage announcements, birth announcements, social pages, national and local news articles, sports, advertisements, entertainment, fashion and lifestyle pages, comics, and more.
- [Talkwalker](https://www.talkwalker.com/alerts) - Best free and easy alternative to Google Alerts Talkwalker Alerts monitors every single mention of your brand, products, and keywords across the internet - including news platforms, blogs, forums, websites, and even Twitter (X).
- [Google Alerts](https://www.google.com/alerts) - Monitor the web for interesting new content create an email alert about any topic in mind
- [Hoaxy: How claims spread online](https://hoaxy.osome.iu.edu/) - Visualize the spread of information on Twitter
- [Snopes](https://www.snopes.com/?s=) - The definitive fact-checking site and reference source for urban legends, folklore, myths, rumors, and misinformation.
- [ReviewMeta](https://reviewmeta.com/) - ReviewMeta analyzes Amazon product reviews and filters out reviews that our algorithm detects may be unnatural.
- [Verification Handbook](https://datajournalism.com/read/handbook/verification-1) - Need to learn new data skills, increase your data journalism knowledge or advance your career?
- [Truth or Fiction](https://www.truthorfiction.com/) - Truth or Fiction? – Seeking truth, exposing fiction
- [Debunking False Stories Archives](https://www.factcheck.org/fake-news/) - FactCheck.org is one of several organizations working with Facebook to debunk misinformation shared on the social media network
- [Fact-Checking](https://reporterslab.org/fact-checking/) - The Reporters’ Lab is a center for journalism research in the Sanford School of Public Policy at Duke University. Our core projects focus on fact-checking, but we also do occasional research about trust in the news media and other topics.
<br>

[⇧ Top](#index)
## SEARCH ENGINES

- [Google Advanced Search](https://www.google.com/advanced_search) - its like filter particular information according to needs
- [Bing](https://www.bing.com/) - microsoft's Bing search engine
- [Yandex](https://yandex.com/) - Yandex search engine
- [MetaGer: Privacy Protected Search](https://metager3.de/en/) - MetaGer is different from other search engines. This is reflected not only in our public good orientation and focus on privacy, Possibility of creating a personal blacklist Function of the search in the search Advertising-free search possible Integration of search engine projects like YaCy The only German search engine that combines results from several large web indexes
- [Duck Duck Go](https://duckduckgo.com/) - Search and browse more privately with the DuckDuckGo. Unlike Chrome and other browsers, we don't track you
- [Search Engines Index](https://www.searchenginesindex.com/) - Search Engines in all countries in the world
- [carrot2](https://search.carrot2.org/#/search/web) - Carrot2 organizes your search results into topics. With an instant overview of what's available, you will quickly find what you're looking for
- [Qwant](https://www.qwant.com/) - The search engine that respects your privacy
- [Startpage](https://startpage.com/) - A safer way to search and browse online without personal data collection, tracking or targeting.
- [Mailing List Search](https://cse.google.com/cse/publicurl?cx=013991603413798772546:sipriovnbxq) - custom google mailing list search
- [swisscows](https://swisscows.com/) - anonymous search engine protects the privacy of our users when searching and from inappropriate content when finding it. We do not use cookies or other tracking technologies, with us each search query remains anonymous and each user a guest without a user profile.
- [Crossref](https://search.crossref.org/) - Search the metadata of journal articles, books, standards, datasets & more
- [Brave](https://search.brave.com/) - Brave search engine
- [Mojeek](https://www.mojeek.com/) - Mojeek is a growing independent search engine which does not track you.
- [Yahoo Search](https://search.yahoo.com/) - Yahoo search engine
- [Baidu](https://www.baidu.com/) - chaina's search engine
- [Ecosia](https://www.ecosia.org/) - a search engine used its revenue to plant trees around the World
- [Dogpile](https://www.dogpile.com/) - Dogpile is a metasearch engine for information on the World Wide Web that fetches results from Google, Yahoo!, Yandex, Bing, and other popular search engines, including those from audio and video content providers such as Yahoo
- [Zoo Search](https://www.metacrawler.com/) - Metacrawler is a type of search engine that aggregates results from multiple sources, such as other search engines and specialized web directories, and presents them in a unified format.
- [App Store and iTunes search engine](https://fnd.io/) - Experience the App Store and iTunes Anywhere
- [Ask](https://www.search.ask.com/) - a search engine cum news feed
- [ZorexEye](http://zorexeye.com/) - ZorexEye is a search engine that helps you find direct download links for premium apps, software, books and other files for free with the help of AI and Google's Database.
- [keys.openpgp.org](https://keys.openpgp.org/) - The keys.openpgp.org server is a public service for the distribution and discovery of OpenPGP-compatible keys, commonly referred to as a "keyserver".
- [MIT PGP Key Server](https://pgp.mit.edu/) - pgp key server by MIT
- ~~[Ipfs-search.com](https://ipfs-search.com/#/search)~~ - Temporary Suspended
- [Debate.cards](http://debate.cards/) - Search engine for finding and downloading debate evidence
- [Argumentsearch.com](http://argumentsearch.com/) - allows to search for natural-language arguments in large document collections. Neural networks find and summarize the pros and cons of your topic in real time
- [Meganzsearch.com](https://www.meganzsearch.com/) - Mega.nz File Search Engine Search File. Search Movies. Search Music. Search Application. Search Document. More Search
- [Engine.presearch.org](https://engine.presearch.org/) - Presearch is a community-powered, decentralized search engine that provides better results while protecting your privacy and rewarding you when you search.
- [Blockscan.com](https://blockscan.com/) - Blockscan, the search engine for the decentralized web
- [Publc.com](https://publc.com/) - PUBLC is more open and collaborative search engine enhanced by cutting edge AI technology, that empowers its users and revolutionizes the way people share, discover and monetize the content of the web
- [CachedViews.com](https://cachedviews.com/) - Cached view of any page on Internet through multiple cached sources.
- [MAC Address Lookup](https://maclookup.app/) - Find the vendor name of a device by entering an OUI or a MAC address
- [sploitus](https://sploitus.com/) - Sploitus is a everyday tool that helps security researchers find exploits and tools.
- [Vulmon](https://vulmon.com/) - Search anything related to vulnerabilities on Vulmon, from products to vulnerability types. Start your journey to free vulnerability intelligence.
- [Vulnerability & Exploit Database](https://www.rapid7.com/db/) - Technical details for over 180,000 vulnerabilities and 4,000 exploits are available for security professionals and researchers to review.
- [Google Hacking Database](https://www.exploit-db.com/google-hacking-database) - The Exploit Database is a CVE compliant archive of public exploits and corresponding vulnerable software, developed for use by penetration testers and vulnerability researchers.
- [Google & Bing](https://one-plus.github.io/GoogleBing) - Google has a large library of search operators that can help with internet-based research, below is just a selection of them.
- [Boardreader - Forum Search](https://boardreader.com/) - connecting communities through search
- [Libgen.rs](http://libgen.rs/) - largest Book library FREE
- [Stacksearch](https://stacksear.ch/) - 404
- [SearchTempest](https://www.searchtempest.com/) - All of Facebook Marketplace, craigslist & more in one search.
- [2lingual](https://2lingual.com/) - 2lingual makes it easy to Google Search in 2 languages. Get Google Search Results alongside Google Cross Language Search Results. In addition, a Query Translation Option can be activated or deactivated for Google Cross Language Searches.
- [Milled](https://milled.com/search) - The search engine for ecommerce emails
- [btdig](https://btdig.com/) - BTDigg is the BitTorrent DHT search engine.
- [Osint Open Source Projects](https://awesomeopensource.com/projects/osint) - The Top 23 Osint Open Source Projects
- [Monster Crawler Search](http://monstercrawler.com/) - Monster Crawler combines the power of all the leading search engines together in one search box to deliver the best combined results. This is what we call metasearch. The process is more efficient and yields many more relevant results.
- [Arabo.com](http://arabo.com/) - The Arab Middle East Search Engine & Directory
- [Google Scholar](https://scholar.google.com/) - Google Scholar provides a simple way to broadly search for scholarly literature. From one place, you can search across many disciplines and sources: articles, theses, books, abstracts and court opinions, from academic publishers, professional societies, online repositories, universities and other web sites. Google Scholar helps you find relevant work across the world of scholarly research.
- [Million Short](https://millionshort.com/) - web search engine that allows you to filter and refine your search results set. Million Short makes it easy to discover sites that just don't make it to the top of the search engine results for whatever reason – whether it be poor SEO, new site, small marketing budget, or competitive keywords. The Million Short technology gives users access to the wealth of untapped information on the web.
- [BeVigil](https://bevigil.com/) - Instantly find the risk score of any app The internet's first and only security search engine for mobile apps
- [WordPress.com](https://en.search.wordpress.com/) - search millions of blogs
- [Octosearch.dootech.com](https://octosearch.dootech.com/) - Helps you search the repositories starred by people you follow on Github
- [Search craigslist](http://searchcraigslist.org/) - All of Craigslist pages with simple click Searchcraigslist is a classified ad search engine for Craigslist nationwid
- [Public AWS S3 & Azure Search](https://buckets.grayhatwarfare.com/) - Search Public Buckets
- [Public Buckets](https://osint.sh/buckets/) - Find public buckets on AWS S3 & Azure Blob by a keyword
- [Search Atlas](https://searchatlas.org/) - Visualizing Divergent Search Results Across Geopolitical Borders
- [Dorki](https://dorki.io) - A partially free online tool that allows to collect search results from different search engines (Alexandria, Yahoo, Wikispecies, Yep, Wiby etc) and export them to JSON/TXT.
- [Hackxy](https://hackxy.io/) - cybersecurity search engine for ctf write and bugbounty reports
<br>

[⇧ Top](#index)
## GOOGLE CSE
    custom made google search engine for perticular fields

- [Homepage Search Engine](https://cse.google.com/cse?cx=005797772976587943970:3tu7im1-rdg#gsc.tab=0)
- [Amazon Cloud Search Engine](https://cse.google.com/cse?cx=005797772976587943970:g-6ohngosio#gsc.tab=0)
- [Google CSE instances Search Engine](https://cse.google.com/cse?cx=009462381166450434430:vggeu3dhhgg#gsc.tab=0)
- [Robots.txt Search Engine](https://cse.google.com/cse?cx=013991603413798772546:zu7epjqvunu)
- [Short URL Search Engine](https://cse.google.com/cse?cx=017261104271573007538:magh-vr6t6g#gsc.tab=0)
- [Wikispaces Search Engine](https://cse.google.com/cse/publicurl?cx=005797772976587943970:afbre9pr2ly)
- [Dog Bites Search Engine](https://cse.google.com/cse?cx=partner-pub-8216357153102971:3267723418)
- [Google Domain Hacker](https://cse.google.com/cse/publicurl?cx=005797772976587943970:ca2hiy6hmri)
- [Google Drive Folder Search Engine](https://cse.google.com/cse/publicurl?cx=013991603413798772546:nwzqlcysx_w)
- [Chrome Extension Archive Search Engine](https://cse.google.com/cse/publicurl?cx=000501358716561852263:h-5uyshsclq)
- [Github with Awesome-List Search Engine](https://cse.google.com/cse/publicurl?cx=017261104271573007538:fqn_jyftcdq)
- [Better Chrome Web Store Search Engine](https://cse.google.com/cse/publicurl?cx=006205189065513216365:pn3lumi80ne)
- [App Store Custom Search Engine](https://cse.google.com/cse/publicurl?cx=006205189065513216365:aqogom-kfne)
- [Google.com Hack Attack](https://cse.google.com/cse/publicurl?cx=017648920863780530960:lddgpbzqgoi)
- [Search by FileType](https://cse.google.com/cse/publicurl?cx=013991603413798772546:mu-oio3a980)
- [Search Engine Finder](https://cse.google.com/cse?cx=016621447308871563343:nyvaorurd5l)
- [Mindmap Search Engine](http://cse.google.com/cse?cx=013991603413798772546:gj6rx9spox8#gsc.tab=0)
<br>

[⇧ Top](#index)
## IMAGES and Audio

### Image

- [Google Images](https://images.google.com/) - Google image search
- [Yandex Images](https://yandex.com/images/) - Yandex Image search
- [Bing Images](https://www.bing.com/images) - Bing Image search
- [See it, search it](https://www.bing.com/visualsearch) - Bing visualsearch, search whats on a image
- [Images Search Engine](https://cse.google.com/cse?cx=281566d4e61dcc05d) - custom google image search engine
- [miniPaint](https://viliusle.github.io/miniPaint/) - Online paint and image editor
- [PimEyes](https://pimeyes.com/en/) - Face Search Engine Reverse Image Search
- [TinEye](https://tineye.com/) - Reverse Image Search Find where images appear online
- [Findclone](https://findclone.ru/) - Let's help you find your double.
- [Image Raider](https://infringement.report/api/raider-reverse-image-search/) - Image Raider is our reverse image search tool for completing individual searches. When you upload an image to this page, we'll scour the internet to find its source and all of the other pages where it has been posted.
- [same.energy](https://same.energy/) - Same Energy is a visual search engine. You can use it to find beautiful art, photography, decoration ideas, or anything else.
- [Baidu](https://image.baidu.com/) - chaina's Baidu Image search engine
- [Yahoo Image Search](https://images.search.yahoo.com/images)- Yahoo Image Search engine
- [Photo Album Finder](https://cse.google.com/cse/publicurl?cx=013991603413798772546:bldnx392j6u) - custom google search photo album finder
- [MyHeritage Photo Enhancer](https://www.myheritage.com/photo-enhancer) - Upgrade your photos automatically with the world’s best machine learning technology. Faces will become more pronouncer! It enhance blury photos
- [SVG Editor](https://svg-edit.github.io/svgedit/) - SVGEdit is a fast, web-based, JavaScript-driven SVG drawing editor that works in any modern browser.
- [Neural network image super-resolution and enhancement](https://letsenhance.io/) - Make your pics high resolution - HD, 4k and beyond. Enlarge and sharpen photos for printing and web in a single click.
- [Pixsy](https://www.pixsy.com/) - Find and fight image theft Take back control of your images. See where & how your images are being used online!
- [FotoForensics](https://fotoforensics.com/) - FotoForensics provides budding researchers and professional investigators access to cutting-edge tools for digital photo forensics.
- [image identify](https://www.imageidentify.com/) - The Wolfram Language Image Identification Project
- [EXIF Data Viewer](http://exifdata.com/) - EXIF is short for Exchangeable Image File, a format that is a standard for storing interchange information in digital photography image files using JPEG compression. Almost all new digital cameras use the EXIF annotation, storing information on the image such as shutter speed, exposure compensation, F number, what metering system was used, if a flash was used, ISO number, date and time the image was taken, whitebalance, auxiliary lenses that were used and resolution. Some images may even store GPS information so you can easily see where the images were taken!
- [Background Removal Tool](https://photoscissors.com/) - Remove a background and replace it with a transparent, solid color or background image with just a few clicks!
- [Museo](https://museo.app/) - Museo is a visual search engine that connects you with the Art Institute of Chicago, the Rijksmuseum, the Harvard Art Museums, the Minneapolis Institute of Art, the The Cleveland Museum of Art, and the New York Public Library Digital Collection
- [Diff Checker](https://www.diffchecker.com/image-diff/) - Find the difference between pictures or other images!
Enter two images and the difference will show up below
- [Forensically](https://29a.ch/photo-forensics/#forensic-magnifier) - Forensically is a set of free tools for digital image forensics. It includes clone detection, error level analysis, meta data extraction and more.
- [Pictriev](http://pictriev.com/) - Find look-alike celebrities on the web using the face recognition.
- [WhatTheFont](https://www.myfonts.com/WhatTheFont/) - Instant font identification powered by the world’s largest collection of fonts, Identify font in given image
- [Sogou](https://pic.sogou.com/) -
- [Pixabay](https://pixabay.com/images/search/) - Free Image gallery
- [picarta.ai](https://www.picarta.ai/) - find where a photo has been taken using AI
- []

### Music

- [Free Music Search](http://musgle.com/) - To see Musgle in action just type a song title, or the artist name, or both in a search bar and hit 'Enter' - you will be redirected to the Google page with relevant search results
- [Search for Music Using Your Voice](https://www.midomi.com/) - Search for Music Using Your Voice by Singing or Humming, View Music Videos, Join Fan Clubs, Share with Friends, Be Discovered and Much More For Free!
- [Listen Notes](https://www.listennotes.com/) - Search the whole Internet's podcasts. Curate your own podcast playlists. Listen on your favorite podcast player apps.
- [Discover Podcasts Here!](https://podsearch.com/) - PodSearch is the easiest way to discover podcasts on your favorite topics. Listen to short show samples, learn more about the show and hosts
<br>

[⇧ Top](#index)
## LICENSE PLATE/VIN/VEHICLE

- [Plate Recognizer](https://platerecognizer.com/) - Automatic License Plate Recognition software that works in all environments, optimized for your location
- [License Plates of the World](http://www.worldlicenseplates.com/) - License plates of the world
- [VIN decoder](http://www.vindecoderz.com/) - VIN decoder is intended to provide detailed information about a vehicle's history, specifications, and ownership based on its unique 17-character identifier.
- [Poctra.com](https://poctra.com/) - Poctra is salvage car auction archive from US and EU markets.
- [FAXVIN](https://www.faxvin.com/) - Vehicle History Reports
- [AutoCheck](https://www.autocheck.com/) - FREE Vehicle Search: Enter a VIN or Plate
- [VINCheck®](https://www.nicb.org/vincheck) - NICB's VINCheck is a free lookup service provided to the public to assist in determining if a vehicle may have a record of an insurance theft claim, and has not been recovered, or has ever been reported as a salvage vehicle by participating NICB member insurance companies.
- [Nomerogram.ru](https://www.nomerogram.ru/) - In Numberogram, you can break the car for free on the state room. Vin is not needed. We are looking for photos of cars in social networks and the Internet, in addition to the photo we know runs and prices, we find on the public. taxi number, dtp and accidents.
- [🚗License Plates in Canada 🇨🇦](https://www.google.com/maps/d/viewer?mid=1zXYL2BF2MByEduLzYN5brVnli9J3cIlv)
- [Vehical Info](https://www.vehicleinfo.in/) - 404
- [CarInfo](https://www.carinfo.app/) - Get Your Vehicle Details by RC
<br>

[⇧ Top](#index)
## FLIGHT TRACKER

- [FlightAirMap](https://www.flightairmap.com/) - Real or virtual flights are displayed in real-time on a 2D or 3D map. Airports are also available on map. Statistics for pilots and/or owners are generated.
- [ADS-B Exchange](https://globe.adsbexchange.com/) - ADS-B Exchange - track aircraft live
- [Icarus.flights](https://icarus.flights/) - Icarus Flights is a tool for analyzing uncensored aircraft activity data and tracing global aircraft ownership records
- [FlightAware](https://flightaware.com/) - As the leader in providing advanced, accurate, actionable data and insights that inform every aviation decision, FlightAware is Central to Aviation
- [Flightradar24](https://www.flightradar24.com/) - Live Flight Tracker - Real-Time Flight Tracker Map
- [Live Air Traffic Control](https://www.liveatc.net/) - Live Air traffic form thir headsets
- [Planespotters.net](https://www.planespotters.net/) - Aviation Photos, Airline Fleets and more
- [Skyscanner](https://www.skyscanner.com/) - Millions of cheap flights, hotels & cars. One simple search.
- [RadarBox](https://www.radarbox.com/) - RadarBox is a flight tracking company that displays aircraft & flight information in real-time on a map. RadarBox offers flight data such as latitude and longitude positions, origins and destinations, flight numbers, aircraft types, altitudes, headings and speeds
- [FlightAirMap](https://www.flightairmap.com/) - Real or virtual flights are displayed in real-time on a 2D or 3D map. Airports are also available on map. Statistics for pilots and/or owners are generated.
<br>

[⇧ Top](#index)
## MARITIME

- [Marine Traffic](https://www.marinetraffic.com/) - seaways / marine live map
- [VesselFinder](https://www.vesselfinder.com/) - Free AIS Ship Tracker - VesselFinder
- [OSINT on the Ocean](https://wondersmithrae.medium.com/osint-on-the-ocean-maritime-intelligence-gathering-techniques-2ee39e554fe1) - Article on Maritime Intelligence Gathering
<br>

[⇧ Top](#index)
## OPEN DIRECTORY

- [FilePhish](https://neonpangolin.github.io/FilePhish/) - A simple Google query builder for document file discovery
- [Open Directory Finder](https://odfinder.github.io/) - This small Program allows you to find open directories on the web. This program uses Google advance search. Can find any video, audio or other files
- [Opendirsearch.abifog.com](https://opendirsearch.abifog.com/) - Find open directories with this tool. It uses google's engine for the actual search.
- [Archive-it.org](https://archive-it.org/) - a digital library of Internet sites and other cultural artifacts in digital form. Like a paper library, we provide free access to researchers, historians, scholars, people with print disabilities, and the general public
- [Odcrawler.xyz](https://odcrawler.xyz/) - A search engine for open directories. Find millions of publicly available files!
- [Google Docs CSE](https://cse.google.com/cse/publicurl?cx=013991603413798772546:rse-4irjrn8#gsc.tab=0) - custom google search engine for documents search
- [Documents Search Engine](https://cse.google.com/cse?cx=e6756edc507bcfa91) - custom google search
- [Cybersec Documents Search Engine](https://cse.google.com/cse?cx=013991603413798772546:ekjmizm8vus#gsc.tab=0) - custom google search
- [GoogleDrive Search Engine](https://cse.google.com/cse?cx=c64ba311eb8c31896) - custom google search
- [SlideShare Search Engine](https://cse.google.com/cse?cx=465eeeb114c7f523f) - custom google search
- [Document Search](https://one-plus.github.io/DocumentSearch) - To use the document search tools, please insert a name or company into the relevant boxes
- [Pdfsearch.io](https://www.pdfsearch.io/) - Document Search Engine - browse more than 18 million document
- [awesome-public-datasets](https://github.com/awesomedata/awesome-public-datasets) - A topic-centric list of HQ open datasets.
- [Drivesearch.kwebpia.net](http://drivesearch.kwebpia.net/) - You can quickly and easily search for videos, lyrics, songs, knowledge, medical, science associated with the file. Supports the following topics: Google Drvie, Google Docs, All web search, Video, Lyrics, Knowledge, Movie, Health, Medical, Science, Pandora, Last.fm, SoundCloud...
- [Filepursuit.com](https://filepursuit.com/) - Search the web for files, videos, audios, eBooks & much more
- [Open Directory Search](http://eyeofjustice.com/od/) - Open Directory Search Portal
- [LENDX](http://lendx.org/) - All over the world, people like you and me connect their computers to the internet. Some of those users allow their computers to operate as servers (for hosting their websites and such). Those websites have folders that contain the images, documents and text that makeup the website's content. These folders are the directory of the website. In that directory, those users can store any files and any data they wish to put there. Lendx simply allows you to access this data.
- [Direct Download Almost Anything](https://ewasion.github.io/opendirectory-finder/) - Get direct download links for almost anything.
<br>

[⇧ Top](#index)
## DATASET

- [Datasetsearch.research.google.com](https://datasetsearch.research.google.com/) - Dataset Search is a search engine for datasets. Using a simple keyword search, users can discover datasets hosted in thousands of repositories across the Web.
- [Databasd](https://databasd.com/search) - is a search engine to find open datasets. The search technology leverages alien artifical intelligence (AAI) to conduct predictive bloackchain data analysis
- [Data.gov](https://www.data.gov/) - Here you will find data, tools, and resources to conduct research, develop web and mobile applications, design data visualizations, and more.
- [data.world](https://data.world/) - The Data Catalog Platform
- [BigQuery public datasets](https://cloud.google.com/bigquery/public-data/) - A public dataset is any dataset that is stored in BigQuery and made available to the general public through the Google Cloud Public Dataset Program
- [DSC Data Science Search Engine](https://www.datasciencecentral.com/page/search) - Data Science Central is the industry’s leading online resource for data practitioners. From Statistics and Analytics to Machine Learning and AI, Data Science Central provides a community experience that includes a rich editorial platform, social interaction, forum-based support, and the latest information on technology, tools, trends, and careers
- [Datasetlist.com](https://www.datasetlist.com/) - A list of machine learning datasets from across the web.
- [Search Datasets](https://datahub.io/search) - Build elegant data-driven sites with markdown & deploy in seconds.
- [Opensanctions.org](https://opensanctions.org/) - OpenSanctions helps investigators find leads, allows companies to manage risk and enables technologists to build data-driven products
- [Kaggle](https://www.kaggle.com/search?q=) - Join over 17M+ machine learners to share, stress test, and stay up-to-date on all the latest ML techniques and technologies. Discover a huge repository of community-published models, data & code for your next project
<br>

[⇧ Top](#index)
## SOURCE CODES

- [Pastes Search Engine](https://cse.google.com/cse?cx=661713d0371832a02) - custom google search
- [Pastes Search Engine 2](https://cse.google.com/cse?cx=006896442834264595052:fawrl1rug9e) - custom google search
- [GitHub Search Engine](https://cse.google.com/cse?cx=1b053c8ec746d6611) - custom google search
- [Source Code Search Engine](https://publicwww.com/) - Find any alphanumeric snippet, signature or keyword in the web pages HTML, JS and CSS code.
- [Google to search profiles on GitHub](https://recruitin.net/github.php) - Easily use Google to search profiles on GitHub
- [Grep.app](https://grep.app/) - grep.app searches code from over a half million public repositories on GitHub.
- [NerdyData](https://www.nerdydata.com/) - NerdyData will help you find which websites use certain SaaS technologies.
- [Paste Search](https://psbdmp.ws/) - Leaks monitor The biggest archive of {paste} dumps
- [GitHub Code Search](https://github.com/search) - github code search
- [Bitbucket Repo Search](https://bitbucket.org/repo/all/) - find code in bitbucket
- [Shhgit](https://github.com/eth0izzle/shhgit) - Find secrets in your code. Secrets detection for your GitHub, GitLab and Bitbucket repositories
- [git-hound](https://github.com/tillson/git-hound) - Reconnaissance tool for GitHub code search. Scans for exposed API keys across all of GitHub, not just known repos and orgs.
- [Webfinery | Source Code Search](https://webfinery.com/search) - Search the source code of the web
- [Online IDE and Paste Search Engine](https://redhuntlabs.com/online-ide-search) - This Custom Search Tool by @RedHuntLabs Team looks for keywords/strings in following Online IDEs, Paste(s) sites and Code Sharing Platforms.
- [searchcode](https://searchcode.com/) - Search 75 billion lines of code from 40 million projects
- [Sourcegraph](https://about.sourcegraph.com/) - Sourcegraph allows developers to rapidly search, write, and understand code by bringing insights from their entire codebase right into the editor
- [Awesome Open Source](https://awesomeopensource.com/) - Find And Compare Open Source Projects
- [Zen](https://github.com/s0md3v/Zen) - Find emails of Github users
- [GitDorker](https://github.com/obheda12/GitDorker) - A Python program to scrape secrets from GitHub through usage of a large repository of dorks.
<br>

[⇧ Top](#index)
## WHOIS

- [WHOIS Service](https://whoismind.com/) - search any ip address
- [Whois Search](https://webwhois.verisign.com/webwhois-ui/index.jsp?language=en_US) - Verisign’s Whois tool allows users to look up records in the registry database for all registered .com, .net, .name, .cc and .edu domain names.
- [Who.is](https://who.is/) - WHOIS Search, Domain Name, Website, and IP Tools
- [Whoxy](https://www.whoxy.com/) - whoxy domain search engine
- [Whois History](https://osint.sh/whoishistory/) - Lets you see all the historical WHOIS records of a domain name
<br>

[⇧ Top](#index)
## DOMAIN / IP / DNS
### URL's

- [domain digger](https://digger.tools/) - Find all dns recoreds, whois data, ssl/tls certificate history, subdomain and more
- [dnslytics](https://dnslytics.com/) - search for domain IPv4, IPv6 or Provider
- [dnstwist](https://dnstwist.it) - scan phishing domain
- [SecurityTrails](https://securitytrails.com/) - search for domain, IPs, keyword or Hostname
- [Shodan](https://shodan.io/) - Shodan is a search engine that lets users search for various types of servers connected to the internet using a variety of filters. Some have also described it as a search engine of service banners, which are metadata that the server sends back to the client.
- [Internetdb.shodan.io](https://internetdb.shodan.io/) - The InternetDB API provides a fast way to see the open ports for an IP address. It gives a quick, at-a-glance view of the type of device that is running behind an IP address to help you make decisions based on the open ports.
- [GreyNoise Intelligence](https://www.greynoise.io/viz/) - GreyNoise identifies internet scanners and common business activity in your security events so you can make confident decisions, faster. Whether you use our Visualizer, API, or integrate GreyNoise data into your security tools, find what's important in your security logs and get back to business.
- [FOFA](https://fofa.so/) -
- [zoomeye](https://www.zoomeye.org/) - ZoomEye is a freemium online tool aimed to help aid cybersecurity in the areas of reconnaissance and threat evaluation.
- [Censys](https://censys.io/domain) - is a web-based search platform for assessing attack surface for Internet connected devices. The tool can be used not only to identify Internet connected assets and Internet of Things/Industrial Internet of Things (IoT/IIoT), but Internet-connected industrial control systems and platforms.
- [ViewDNS.info](https://viewdns.info/) - Reverse IP Lookup Find all sites hosted on a given server. Domain / IP. Reverse Whois Lookup Find domain names owned by an individual or company.
- [Internet Census 2012](http://census2012.sourceforge.net/paper.html) - Overview of 180 Billion service probe records from May to December 2012.
- [ONYPHE](https://www.onyphe.io/) - ONYPHE is an Attack Surface Management & Attack Surface Discovery solution built as a Cyber Defense Search Engine. We scan the entire Internet and Dark Web for exposed assets and crawl the links just like a Web search engine. Our data is searchable with a Web form or directly from our numerous APIs.
- [IPLeak](https://ipleak.net/) -
- [Robtex](https://www.robtex.com) - Robtex is used for various kinds of research of IP numbers, Domain names, etc
- [Wappalyzer](https://www.wappalyzer.com/lookup/) - Instantly reveal the technology stack of any website, such as CMS, ecommerce platform or payment processor, as well as company and contact details.
- [photon](https://pypi.org/project/photon/) - Incredibly fast crawler designed for OSINT.
- [Technology Lookup](https://osint.sh/stack/) - Technology stack checker tool. Check out the technologies used on any website.
- [BuiltWith Technology Lookup](https://builtwith.com/) - Find out what websites are Built With
- [OSINT.SH](https://osint.sh/) - All in one Information Gathering Tools
- [Nmap Checker Tool](https://shadowcrypt.net/tools/nmap) - Online Free Hacking Tools - ShadowCrypt
- [Free online network tools](https://centralops.net/co/) - Free online network tools - traceroute, nslookup, dig, whois lookup, ping - IPv6
- [Google Transparency Report](https://transparencyreport.google.com/https/certificates) - HTTPS encryption on the web report
- [Certificate Search](https://osint.sh/crt/) - Find information about the target assets from their SSL certificate
- [CRT](https://crt.sh/) - certificate search
- [LeakIX](https://leakix.net/) - This project goes around the Internet and finds services to index them.
- [URL and website scanner](https://urlscan.io/) - urlscan.io is a free service to scan and analyse websites. When a URL is submitted to urlscan.io, an automated process will browse to the URL like a regular user and record the activity that this page navigation creates.
- [dnsdumpster](https://dnsdumpster.com/) - DNSdumpster.com is a FREE domain research tool that can discover hosts related to a domain. Finding visible hosts from the attackers perspective is an important part of the security assessment process.
- [Domain Codex](https://www.domaincodex.com/search.php) - private investigation search, legal and case research, IP & Digital piracy..
- [SimilarWeb](https://www.similarweb.com/) - SimilarWeb is a tool that estimates the total amount of traffic different websites get. It allows you to see competitors' top traffic sources, broken down into six major categories, including referring sites, social traffic, and top search keywords
- [IP search - Network Entity Reputation Database](https://nerd.cesnet.cz/nerd/ips/) - The NERD system gathers data about sources of cyber threats from a number of sources and builds a constantly-updated database of the known malicious network entities (currently only IP addresses).
- [Reverse Domain](https://osint.sh/domain/) - Allow you to find domain names by a keyword
- [IANA — Root Zone Database](https://www.iana.org/domains/root/db) - The Root Zone Database represents the delegation details of top-level domains, including gTLDs such as .com, and country-code TLDs such as .uk. As the manager of the DNS root zone, we are responsible for coordinating these delegations in accordance with our policies and procedures.
- [Punkspider](https://punkspider.org/) - Searching for vulnerable websites is coming back soon! Are you new to web security and have no idea what the heck we're talking about
- [metabigor](https://github.com/j3ssie/metabigor) - OSINT tools and more but without API key
- [urldna](https://urldna.io) - Gather info about URL: ssl cert, ip, header, metadat ...
- [Check-The-Sum](https://check-the-sum.fr/) - Database of IP addresses, domains and malicious files collected from a network of honeypots
<br>

[⇧ Top](#index)
## MALWARE

- [Malpedia](https://malpedia.caad.fkie.fraunhofer.de/) - Malpedia is to provide a resource for rapid identification and actionable context when investigating malware. Openness to curated contributions shall ensure an accountable level of quality in order to foster meaningful and reproducible research.
- [Interactive Online Malware Analysis Sandbox](https://app.any.run/) - check malware for free. With our online malware analysis tools you can research malicious files and URLs and get result with incredible
- [Free Automated Malware Analysis Service](https://hybrid-analysis.com/) - This is a free malware analysis service for the community that detects and analyzes unknown threats using a unique Hybrid Analysis technology.
- [VirusTotal](https://www.virustotal.com/gui/) - Analyse suspicious files, domains, IPs and URLs to detect malware and other breaches, automatically share them with the security community.
- [Maltiverse](https://maltiverse.com/search) - We are here to help companies to adopt quality Threat Intelligence in a simple, quick and effective way
- [Malware News Search](https://cse.google.com/cse?cx=003248445720253387346:turlh5vi4xc) - custom google search for malware news
- [AlienVault Open Threat Exchange](https://otx.alienvault.com/) - The World's First Truly Open Threat Intelligence Community · Gain FREE access to over 20 million threat indicators contributed daily
- [Jotti’s malware scan](https://virusscan.jotti.org/) - Jotti's malware scan is a free service that lets you scan suspicious files with several anti-virus programs. You can submit up to 5 files at the same time. There is a 250MB limit per file. Please be aware that no security solution offers 100% protection, not even when it uses several anti-virus engines
- [IObit Cloud](https://cloud.iobit.com/index.php) - IObit Cloud is an advanced automated threat analysis system. We use the latest Cloud Computing technology and Heuristic Analyzing mechanic to analyze the behavior of spyware, adware, trojans, keyloggers, bots, worms, hijackers and other security-related risks in a fully automated mode.
- [theZoo](https://github.com/ytisf/theZoo) - A repository of LIVE malwares for your own joy and pleasure. theZoo is a project created to make the possibility of malware analysis open and available to the public.
- [Vx-underground.org](https://vx-underground.org/) - vx-underground also known as VXUG, is an educational website about malware and cybersecurity. It claims to have the largest online repository of malware.
- [aptnotes/data](https://github.com/aptnotes/data) - APTnotes is a repository of publicly-available papers and blogs (sorted by year) related to malicious campaigns/activity/software that have been associated with vendor-defined APT (Advanced Persistent Threat) groups and/or tool-sets.
- [exploit-database-papers](https://github.com/offensive-security/exploitdb-papers) - The legacy Exploit Database paper repository
<br>

[⇧ Top](#index)
## IoT

- [Webcam Search Engine](https://cse.google.com/cse?cx=013991603413798772546:gjcdtyiytey#gsc.tab=0) - custom google search for webcams search
- [Insecam](http://www.insecam.org/) - Live cameras directory
- [Camhacker.com](https://www.camhacker.com/) - Finds thousands of public live webcam streams and unprotected security cameras from all over the world.
- [EarthCam](https://www.earthcam.com/) - Providing a virtual window to the world, viewers can freely explore the globe from unparalleled vantage points, such as the torch balcony of the Statue of Liberty, which has been closed to the public since 1916. EarthCam.com derives revenue from advertising and licensing of its proprietary webcam content.
- [Airport Webcams](https://airportwebcams.net/) - LIVE Airport Webcams From Around The World
- [The Webcam Network](http://www.the-webcam-network.com/) - Most webcam-directories offer listings of places where webcams are located
- [Webcams Abroad live images](https://www.webcamsabroad.com/) - Webcams Abroad is a fast growing international directory with webcams all over the world.
- [WEBCAM LIVE](https://www.whatsupcams.com/en/) - search live webcams
- [city-webcams.com](https://city-webcams.com/) - local webcams and live streaming from around the world
- [thingful](http://www.thingful.net/) - Thingful.net is a search engine for the Internet of Things, providing a unique geographical index of real-time data from connected objects around the world, including energy, radiation, weather, and air quality devices as well as seismographs, iBeacons, ships, aircraft and even animal trackers.
- [Live World Webcam](http://liveworldwebcam.net/) - LiveWorldWebcam.net, search engine of thousands of live webcams from around the world!
- [Webcamtaxi](https://www.webcamtaxi.com/en/) - Webcamtaxi is a platform for live streaming HD webcams from around the globe that will give you the opportunity to travel live online and discover new and distant places. If you are passionate about travelling, we are the right choice for you.
- [Explorecams.com](https://explorecams.com/) - search engine allows you to search through thousands of images that people took on a specific digital cameras and compatible lenses, so you know what to expect from your next gear purchase.
- [Opentopia](http://www.opentopia.com/) - free live webcams
- [WorldCam](https://worldcam.eu/) - webcams form around the world
- [Hawaii Traffic Cameras](http://goakamai.org/home) - hawaii tarffic cameras
- [Toronto area Live Traffic Cams](https://gtaupdate.com/traffic/)
- [Lake County Fire Cameras](https://www.arcgis.com/apps/webappviewer/index.html?id=0f7aa08cc4b74fc6a0c4308d4eace6b3)
- [VDOT Traffic Cams](https://www.arcgis.com/apps/dashboards/a0d3fb34cda44f5b8b10be1b245f24a3)
- [Lubbock Live Traffic Cameras](https://www.arcgis.com/apps/webappviewer/index.html?id=affe50ac55824c7a8c757d3980787e31)
- [Hong Kong Traffic Data & Cams](https://www.arcgis.com/apps/dashboards/47be6372a0434beaba99ae9c9f1d598d)
- [Baton Rouge Traffic Cams](https://www.arcgis.com/apps/webappviewer/index.html?id=0ec05ffb0d2d4735a969e8f31f820a7b)
<br>

[⇧ Top](#index)
## RADIO

- [Broadcastify](https://www.broadcastify.com/listen/) - Broadcastify - Listen Live to Police, Fire, EMS, Aviation, and Rail Audio Feeds
- [RadioReference](https://www.radioreference.com/apps/db/) - radioreference database search by city, name, system, frequency...
- [Feeds.talonvoice.com](https://feeds.talonvoice.com/) - This a website transcribing scanner feeds to text in real-time, in response to recent events
- [Automated transcription for radio stations](https://sonix.ai/radio-stations) - Convert your radio shows or podcast episodes to text and publish these transcripts to get more traffic with Sonix: The world’s most advanced audio transcription platform.
- [WiGLE: Wireless Network Mapping](https://wigle.net/) - all the networks found by everyone
- [Ham Radio QRZ Callsign Database Search](https://www.qrz.com/lookup) - radio database search
- [Radio-Locator](https://radio-locator.com/) - the most trusted AM and FM radio station search engine on the internet. We have links to over 17,100 radio stations' web pages and over 12,800 stations' audio streams from radio stations in the U.S. and around the world.
- [RadioID Database](https://database.radioid.net/database/search#!) - radio database
- [Radio-Sherlock](http://dxmaps.com/search.html) - Your professional and amateur radio search engine
- [Radiocells.org](https://radiocells.org/) - 404
- [@murph_live](https://twitter.com/murph_live) - Murph is a police scanner transcriber tool. See real-time scanner conversation.
- [Radio Garden](http://radio.garden/search) - live radio aroud the world (The Best)
<br>

[⇧ Top](#index)

## RESOLVERS

- [PSN Resolver](https://playstationresolver.xyz/) -
- [Cloudflare Resolver](http://www.skypeipresolver.net/cloudflare.php)
- [Cloudflare Resolver Tool](https://shadowcrypt.net/tools/cloudflare)
- [Discord Resolver](https://www.leaked.site/index.php?resolver/discord.0/)
- [Xboxresolver.com](https://xboxresolver.com/)

## REAL ESTATE

- [PrimeLocation](https://www.primelocation.com/) - find homes to buy or rent
- [Realtor](https://www.realtor.com/) - find estate by school, address or zip
- [rehold](https://rehold.com/) - Rehold Has the Most Extensive Database and Reverse Address Directory in the USA
- [Zillow](https://www.zillow.com/) - Recommendations are based on your location and search activity, such as the homes you've viewed and saved and the filters you've used. We use this information to bring similar homes to your attention
- [Zoopla](https://www.zoopla.co.uk/) - Find homes to buy or rent and check house prices
- [homemetry](https://homemetry.com/) - Homemetry is an all-in-one real estate information site that provides a comprehensive overview of homes for sale, apartments for rent, markets, trends and neighborhood insights to help you make the right decisions on exactly what, when and where to buy, sell or rent.
- [Explore Canada’s Real Estate Market](https://www.remax.ca/find-real-estate) - Explore Canada's Real Estate Market
<br>

[⇧ Top](#index)
## [CAN] CORPORATION

- [RJSC Connect](https://rjsc.novascotia.ca/) - Search the Registry of Joint Stock Companies
- [FederalCorporation](https://federalcorporation.ca/) - Find Federal Corporations in Canada
- [Corporate Affairs Registry Database](https://www.pxw2.snb.ca/card_online/cardsearch.aspx) - Corporate Affairs Registry Database
- [MRAS Business Registry Search](https://beta.canadasbusinessregistries.ca/search) - canada's business registries
- [Alberta Business Search](https://albertacorporations.com/) - Search for a company by name, or browse the newest companies registered in Alberta, Canada
- [LeoList](https://www.leolist.cc/) - LeoList to buy, sell, or trade almost anything! Personals, escorts, cars, real estate, jobs, services, vacation rentals and more virtually anywhere
- [Rental in Canada](https://www.n49.com/search/rental/1/canada/) - rental in canada
- [Business Directory | OCC](https://occ.ca/business-directory/) - The Ontario Chamber of Commerce (OCC) is the indispensable partner of business and Canada’s largest, most influential provincial chamber.
- [Rechercher par entreprise](https://www.pes.rbq.gouv.qc.ca/RegistreLicences/Recherche?mode=Entreprise) - Register of RBQ Licence Holders
- [Services en ligne](https://www.pes.ctq.gouv.qc.ca/pes/faces/dossierclient/recherche.jsp) - Consultation of a dossier
- [Online Services PEI Business / Corporate Registry](https://www.princeedwardisland.ca/en/feature/pei-business-corporate-registry-original#/service/LegacyBusiness/LegacyBusinessSearch) - PEI Business / Corporate Registry Original
- [XBRL Voluntary Filing Program](https://www.sedar.com/issuers/issuers_en.htm) - File, disclose and search for issuer information in Canada’s capital markets
<br>

[⇧ Top](#index)

## MAPS

- [Google Maps](https://www.google.com/maps) - google map
- [Bing Maps](https://www.bing.com/maps) - microsoft bing map
- [Yandex.Maps](https://yandex.com/maps/) - yandex map
- [Mapillary](https://www.mapillary.com/app/) - Access street-level imagery and map data from all over the world. Fill in the gaps by capturing coverage yourself.
- [Geonarrative.com](https://geonarrative.usgs.gov/landsat-collection/) - Explore remote-sensing satellites that have orbited our Earth for 50 years.
- [Waze](https://www.waze.com/live-map) - Navigation and map
- [百度地图](https://map.baidu.com/) - baidu map
- [DigitalGlobe](https://discover.digitalglobe.com/) - 404
- [MapQuest](https://www.mapquest.com/) - find driving directions, maps, live traffic updates and road conditions. Find nearby businesses, restaurants and hotels. Explore!
- [OpenStreetMap](https://www.openstreetmap.org/) - OpenStreetMap is a free, open geographic database updated and maintained by a community of volunteers via open collaboration. Contributors collect data from surveys, trace from aerial imagery and also import from other freely licensed geodata sources.
- [ArcGIS Wildfire Map](https://www.arcgis.com/home/webmap/viewer.html?webmap=df8bcc10430f48878b01c96e907a1fc3#!) - This is a map of US wildfire locations (active/recent) and other sources of information related to wildfires.
- [Living Atlas of the World | ArcGIS](https://livingatlas.arcgis.com/en/browse/) - ArcGIS Living Atlas of the World
- [FIRMS](https://firms.modaps.eosdis.nasa.gov/map/) - Global Fire information for Resource management system
- [COVID-19 Map](https://coronavirus.jhu.edu/map.html) - covid-19 cases world map
- [Ukraine Interactive map](https://liveuamap.com/) - Live Universal Awareness Map, is an internet service to monitor and indicate activities on online geographic maps, particularly of locations with ongoing armed conflict in ukraine russia
- [Israel-Palestine](https://israelpalestine.liveuamap.com/) - Live Universal Awareness Map, is an internet service to monitor and indicate activities on online geographic maps, particularly of locations with ongoing armed conflict in israel palestine
- [Satellites.pro](https://satellites.pro/) - satellite world map
- [Military bases around the world. - uMap](https://umap.openstreetmap.fr/en/map/military-bases-around-the-world_510207) - Militarty bases around the world
- [Wikimapia](http://wikimapia.org/) - Wikimapia is an online editable map - you can describe any place on Earth. Or just surf the map discovering tonns of already marked places
- [Map of Syrian Civil War](https://syria.liveuamap.com/) - syrian civil war map
- [Windy](https://www.windy.com/-Webcams/webcams) - wind map weather forecast
- [Gpx File Editor](https://gpx.studio/) - gpx.studio is a free online GPX viewer and editor which allows visualize multiple traces, edit traces, edit waypoints and more.
- [fgdc_gp_demos’s public fiddles](https://jsfiddle.net/user/fgdc_gp_demos/fiddles/) -
- [KartaView](https://kartaview.org/map/) - Collect and share street level imagery from around the world to an open repository, available to everyone.
- [Google Map Search Engine](https://cse.google.com/cse?cx=013991603413798772546:mofb1uoaebi) - custom google search for google search
- [Power Plants in the United States](https://www.arcgis.com/apps/dashboards/201fc98c0d74482d8b3acb0c4cc47f16) - map of power plants in the United States using data from the U.S. Energy Information Administration and U.S. Environmental Protection Agency
- [UK Onshore Oil and Gas Activity](https://www.arcgis.com/apps/webappviewer/index.html?id=29c31fa4b00248418e545d222e57ddaa) - 404
- [Walmart Store Status](https://www.arcgis.com/apps/dashboards/4e573c79e1224081805165d25b4f33c7) - walmart store location map
- [MODIS Wildfire](https://www.arcgis.com/apps/dashboards/bf5df3a49a624521844a2e5e1ec7df05) - a Live Feeds layer showing Thermal activity detected by the MODIS sensors on the NASA Aqua and Terra satellites during the last 48 hours.
- [Earthquake Watch](https://www.arcgis.com/apps/dashboards/c8af9c5411814584b460cc87cb7c3780) - Earthquake watch
- [Earth](https://earth.nullschool.net/#current) - live wind
- [US Labor Strike Map](https://www.google.com/maps/d/viewer?mid=1hE1nDR-Ff_sVgOS67IteJSxGZlvqIP3k) - US labor strike map
- [Active Agency Map](https://www.google.com/maps/d/viewer?mid=1eYVDPh5itXq5acDT9b0BVeQwmESBa4cB) - The following is a list of public safety agencies that have joined Neighbors by Ring. This map is updated regularly.
- [Ukraine Live Cams](https://nagix.github.io/ukraine-livecams) - Live cams from Ukraine
- [Live map of London Underground trains](https://traintimes.org.uk/map/tube/) - Live london underground train map
- [TfL JamCams](https://www.tfljamcams.net/) - Trafic cams from London
- [atlas.co](https://app.atlas.co) - a tool for visualising geodata
- [felt](https://felt.com) - create map-based visualizations
- [TradeMap](https://www.trademap.org/Index.aspx) - Trade map of world by counties (import/export)
<br>

[⇧ Top](#index)
## GEO

- [GeoSpy](https://geospy.web.app/) - Photo location prediction using AI
- [GEOINT](https://start.me/p/W1kDAj/geoint) - every tools you need for geographical data gathering
- [GeoNames](https://www.geonames.org/) - The GeoNames geographical database covers all countries and contains over eleven million placenames that are available for download free of charge.
- [Geoseer.net](https://www.geoseer.net/) - Search over 3.5 million distinct spatial GIS WMS, WCS, WMTS datasests hosted on over 40k live services from around the world.
- [GeoINT Search](https://cse.google.com/cse?cx=015328649639895072395:sbv3zyxzmji#gsc.tab=0) - coustom google search for geographical related search queries.
- [GeoIP Tracker tool](https://shadowcrypt.net/tools/geoip) - Got an intruder in your network? Want to know where the intruder is from? Use this tool. Geo IP tracker uses geographical location technology and utilizes public records to track down the location of the IP address. It may not be accurate, but it will give you idea of IP addresses whereabouts.
- [Earth Engine Dataset](https://developers.google.com/earth-engine/datasets/) - Earth Engine's public data archive includes more than forty years of historical imagery and scientific datasets, updated and expanded daily.
- [GeoPlatform Portal](https://www.geoplatform.gov/) - The Geospatial Platform is a cross-agency collaborative effort and Shared Service that embodies the principles and spirit of Open Government, emphasizing government-to-citizen communication, accountability, and transparency.
- [FAO Map Catalog](https://data.apps.fao.org/map/catalog/srv/eng/catalog.search#/home)
- [geocreepy](http://www.geocreepy.com/) - A Geolocation OSINT Tool. Offers geolocation information gathering through social networking platforms.
- [US Crisis Monitor](https://acleddata.com/special-projects/us-crisis-monitor/) - The United States Crisis Monitor provides in-depth coverage of demonstration and political violence trends across the US
- [Toronto Live](https://apps.esri.ca/torontolive/) - toronto live ; like public schools, traffic, bike share, ttc.
- [Residential Fire Fatalities in Indiana](https://www.arcgis.com/apps/dashboards/4d1289ab105145a1b1f80c1ad3cf19fb)
- [geoprotests API](https://rapidapi.com/gisfromscratch/api/geoprotests/) - Query protests worldwide and visualize them using spatial aggregations.
- [geoint-py](https://github.com/gisfromscratch/geoint-py) - A bunch of geospatial intelligence workflows implemented using Python
<br>

[⇧ Top](#index)
## CRYPTOCURRENCY

- [Cryptocurrency Alerting](https://cryptocurrencyalerting.com/) - Real-time customizable price alert for cryptocurrencies, coins, stocks with many way to receive alert email, telegram, discord.
- [Bitcoin Explorer](https://blockchair.com/bitcoin) - Bitcoin's blockchain is a publicly accessible ledger that records all transactions made with the cryptocurrency Bitcoin. It utilizes a decentralized network of computers (nodes) to maintain a chronological series of data blocks that are secured using cryptographic principles, ensuring the integrity and verifiability of each transaction.
- [Ethereum Block Explorer](https://etherscan.io/) - Etherscan is the leading block explorer and search, API & analytics platform for Ethereum
- [Flowscan.org](https://flowscan.org/)
- [Bitcoin Forums Search Engine](https://cse.google.com/cse?cx=f49f9d5e679b15787) - custom google search for bitcoin
- [Blockchain Explorer](https://www.blockchain.com/explorer) - Blockchain.com is a cryptocurrency financial services company. The company began as the first Bitcoin blockchain explorer in 2011 and later created a cryptocurrency wallet that accounted for 28% of bitcoin transactions between 2012 and 2020
- [Blockcypher](https://live.blockcypher.com/) - Find info that other block explorers don't have, search the block chain.
- [Addresschecker.eu](http://addresschecker.eu/)
- [Coinwink.com](https://coinwink.com/) - Track important price changes of your favorite cryptocurrencies with the help of Coinwink crypto alerts

<br>

[⇧ Top](#index)
## DARKNET

- [Danex.io](http://danex.io/) - Dark web search Engine tool.
- [OnionLinksV3](https://github.com/01Kevin01/OnionLinksV3) - List of onion site (Forum,Chats,Markets)
- [Dark Tracer](https://darktracer.io/) - 404
- [ransomwatch 👀 🦅 ](https://ransomwatch.telemetry.ltd/#/INDEX) - the transparent ransomware claim tracker
- [Ransomware Darknet websites](https://sizeof.cat/post/ransomware-darknet-websites/) - ransomware darknet websites
- [Ahmia — Search Tor Hidden Services](https://ahmia.fi/) - Ahmia searches hidden services on the Tor network. To access these hidden services, you need the Tor browser bundle
- [Onion search engine](https://onionsearchengine.com/) - onion search engine
- [onionsearch](https://pypi.org/project/onionsearch/) - OnionSearch is a script that scrapes urls on different .onion search engines.
- [Tor2Web: Tor Hidden Services Gateway](https://tor2web.onionsearchengine.com/) - access onion sites through regular web
- [Ransomware Group Sites](http://ransomwr3tsydeii4q43vazm7wofla5ujdajquitomtd47cxjtfgwyyd.onion.pet/) - ransomware group sites
- [Blockpath.com](https://blockpath.com/) - bitcoin accounting simplified
- [Onions - Darknetlive](https://darknetlive.com/onions/) - massive list of onion service links
- [Darkweb Forums](https://darknetlive.com/forums/)
- [Onion.pet](http://onion.pet) - Onion.pet acts as a proxy between the Tor Darknet, also known as hidden services, and you on the regular, or clearnet
- [Tool | path](https://learnmeabitcoin.com/tools/path/) - search bitcoin transaction, block, address.
- [ProPublica](https://p53lf57qovyuvwsc6xnrppyply3vtqm7l6pcobkmyqsiofyeznfu5uqd.onion/) - ProPublica is a popular online publication that won five Pulitzer in 2016. It aims to expose abuses of power and betrayal of public trust through investigative journalism.
- [Sci-Hub](http://scihub22266oqcxt.onion/) - Sci-Hub is a massive database that eliminates the barriers to getting scientific knowledge. It contains millions of scientific research documents from around the world. The site seeks to liberate information by making it free to individuals and institutions.
- [Hidden Answers](http://answerszuvs3gg2l64e6hmnryudl5zgrmwm3vh65hzszdghblddvfiqd.onion/) -
- Access Onion site through visible web: 1. [tor2web](https://tor2web.activetk.jp/)
										 1. [browserling](https://www.browserling.com/)
										 2. [4everproxy](https://www.4everproxy.com/tor-proxy)
<br>

[⇧ Top](#index)
## DATA DUMP

- [Have I been pwned](https://haveibeenpwned.com/) - check if your email address is in a data breach
- ~~[DeepSearch](http://xjypo5vzgmo7jca6b322dnqbsdnp3amd24ybx26x5nxbusccjkm4pwid.onion.pet/)~~
- [Personal Data Leak Checker](https://cybernews.com/personal-data-leak-check/) - Find out if your email, phone number or related personal information might have fallen into the wrong hands.
- [DDoSecrets](https://ddosecrets.com/wiki/Special:AllPages) - Distributed Denial of Secrets (DDoSecrets) is a non-profit journalist organization focused on publishing, archiving and analyzing public interest information, creating news coverage from around the world. DDoSecrets specializes in large datasets that have been leaked or hacked, and in verifying and researching the data while protecting sources
- [Leakedpassword.com](https://leakedpassword.com/) - Find out if a password hack has exposed your password to the world.
- [DeHashed](https://dehashed.com/) - Have you been compromised? DeHashed provides free deep-web scans and protection against credential leaks
- [Snusbase](https://www.snusbase.com/) - Enhance the security of your personal accounts, as well as those of your employees and loved ones, by proactively monitoring the exposure of your online identities.
- [Ashley Madison hacked email checker](https://ashley.cynic.al/) - Was your profile compromised in the Ashley Madison hack
- [Search Ashley Madison Leaked Data](http://checkashleymadison.com/) - Search Ashley Madison Leaked Data
- [Sony Archives](https://wikileaks.org/sony/emails/) - You will find this data in there .onion site
<br>

[⇧ Top](#index)
## EXTREMIST / FAR-RIGHT

- [Unicorn Riot: Discord Leaks](https://discordleaks.unicornriot.ninja/discord/) - Unicorn Riot obtained hundreds of thousands of messages from white supremacist and neo-nazi Discord chat servers after Charlottesville. Unicorn Riot Discord Leaks opens far-right activity centers to public scrutiny through data journalism.
- [Data | DDoSecrets Search](https://search.ddosecrets.com/data/) - DDoSecrets is a non-profit journalist organization focused on publishing, archiving and analyzing public interest information, creating news coverage from around the world. DDoSecrets specializes in large datasets that have been leaked or hacked, and in verifying and researching the data while protecting sources. Founded in 2018, it has published over 100 million files from nearly 60 countries, worked with hundreds of outlets and half a dozen cross-border collaborations.
- [Adatascientist](https://adatascienti.st) - exploring how money and ideas move around
- [Parler Capitol Videos](https://projects.propublica.org/parler-capitol-videos/) - What Parler Saw During the Attack on the Capitol
- [Project Whispers](https://whispers.ddosecrets.com/) - whispers data leak
- [4chansearch.org](https://4chansearch.org/) - news search
- [archived.moe](https://archived.moe/) - archive data
- [Extremist Profiles](https://www.splcenter.org/fighting-hate/extremist-files/individual) - extremist file
- [Database of suspected terrorists](https://www.nsatt.org/) - NSAT&T is an independent, non-government organization and is in no way affiliated with any branch of any government or any company that provides telephone or telegraph communications services
- [TSA No-Fly List](https://www.no-fly-list.com/) - No fly list
- [RAND](http://rand.org) - RAND is a research organization that develops solutions to public policy challenges to help make communities throughout the world safer and more secure, healthier and more prosperous.
- [Global Terrorism Database](https://www.start.umd.edu/gtd/access/) - The Global Terrorism Database™ (GTD) is an open-source database including information on terrorist events around the world from 1970 through 2020 (with annual updates planned for the future). Unlike many other event databases, the GTD includes systematic data on domestic as well as international terrorist incidents that have occurred during this time period and now includes more than 200,000 cases.
- [Sanctions List Search](https://sanctionssearch.ofac.treas.gov/) - Sanctions List Search
- [Trump Twitter Archive](https://www.thetrumparchive.com/) - trump twitter archive
- [OFAC Sanctioned Search Engine](https://cse.google.com/cse?cx=e96467889fb82b9b0) - custom google search for OFAC Sanction search
- [INFORMNAPALM](https://informnapalm.org/db/russian-aggression/#lang=en&page=m_unit) - InformNapalm volunteer intelligence community presents its interactive database, mapping Russian aggression against Ukraine as well as Georgia and Syria. More than 2000 OSINT investigations performed by InformNapalm
- [gogettr](https://pypi.org/project/gogettr/) - Extraction tool for GETTR, a "non-bias [sic] social network."
- [FBI Most Wanted Search Engine](https://cse.google.com/cse?cx=1ee952e6584aa91f9) - custom google search engine for FBI most wanted list
- [Interpol Most Wanted Search Engine](https://cse.google.com/cse?cx=b1746754c83012613) - costom google search for Interpol most wanted list
- [Europol Most Wanted Search Engine](https://cse.google.com/cse?cx=f08e8dc2172da1ba8) - custom google search for Europol most wnated list
<br>

[⇧ Top](#index)

## FINANCE

- [Greylist Trace](https://greylisttrace.com/) - enterprise risk management and asset tracing
- [Tradint Research Tool](https://tradint.io/) - This tool enables users to conduct a full-scale Tradint (Trade Intelligence) investigation using the best tools and methods.
- [analytics-engine](https://github.com/mashiox/analytics-engine) - An environment of open source services used for market analysis
- [Ppp.adatascienti.st](https://ppp.adatascienti.st/) - ppp load search
- [CoVi Analytics](https://www.covianalytics.com/) - At CoVi Analytics, we create easy-to-use tools (Apps) specifically for the operations team to help streamline operations, enhance efficiency, and empower growth through tech-driven solutions that simplify business activities, automate operations and deliver greater insights
- [Search Our PPP Loan Database](https://ppp.directory/search) - ppp load database search
- [Search for Investment Fund Documents](https://www.sedar.com/search/search_form_mf_en.htm) - File, disclose and search for issuer information in Canada’s capital markets
<br>

[⇧ Top](#index)
## BUSINESS

- [Companies & Orgs Search Engine](https://cse.google.com/cse?cx=72ea9d8cfefc142d3) - custom google search for companies and organization search
- [AllPeople](https://allpeople.com/) - AllPeople is the largest free directory of business contacts for America. Find leads for companies including name, position, email, address, phone number and more!
- [Corporation Wiki](https://www.corporationwiki.com/) - Corporation Wiki exists to provide corporate transparency and historical data on companies. This allows officers to be held accountable for the actions they take through their corporations
- [PA PPP Database](https://public.flourish.studio/visualisation/3105919/) - loan database
- [Companies House](https://www.gov.uk/government/organisations/companies-house) - UK gov companies houses
- [Global Brownbook](https://www.brownbook.net/) - global business listing database
- [list-org](https://www.list-org.com/) - Basic information about any Russian legal entity or entrepreneur
- [OpenCorporates](https://opencorporates.com/) - Fresh, standardized, auditable information direct from official primary sources across 140+ jurisdictions — all underpinned by our Legal-Entity Data Principles and world-leading expertise in legal-entity data.
- [ICIJ Offshore Leaks Database](https://offshoreleaks.icij.org/) - Find out who’s behind more than 810,000 offshore companies, foundations and trusts from the Pandora Papers, Paradise Papers, Bahamas Leaks, Panama Papers and Offshore Leaks investigations.
- [XRefer](https://www.xrefer.com/) - Find top rated verified local companies
- [Startup Tracker](https://startuptracker.io/home) - Discover and track startups from MVP to IPO
- [Shopsearchengine.com](http://shopsearchengine.com/) - shopsearchengine.com the internets premiere shopping site, find it fast.
- [LA County CA Restaurant Health Violations](https://b2.caspio.com/dp.asp?AppKey=22341000af0b9c98ebf047f1b9f2)
- [Kansas Restaurant Inspections](https://b2.caspio.com/dp/a1a31000af3bac4c5e434987a857)
- [Lexington-Fayette County KY Health Department Restaurant Inspections](https://b2.caspio.com/dp.asp?AppKey=c8521000c641ab80b6d2448e89d9)
- [FL Energy Money in Politics](https://b2.caspio.com/dp.asp?AppKey=c73210001174b8c2a8d444768f5c)
- [ValidFleetList (unknown Sail Boat database)](https://c0eru285.caspio.com/dp/0dc330002829dcc1ad864b5bb094)
- [Viking Rifle Series Shooter Live Results](https://vikingrifleseries.caspio.com/dp/c8ac5000f29041f935cf42b6a641)
<br>

[⇧ Top](#index)
## POLICE / LE / FED

- [Openoversight](https://openoversight.com/) - OpenOversight: A public, searchable database of law enforcement officers.
- [The Philadelphia Police Misconduct Database](https://datawrapper.dwcdn.net/3GbVI/1/) - Philadelphia Police database
- [NYPD Misconduct Complaint Database](https://nyclu.shinyapps.io/CCRB_combo/) - NYPD Database
- [Maine County Law Enforcement Discipline Chart](https://public.flourish.studio/visualisation/4443849/?utm_source=showcase&utm_campaign=visualisation/4443849) - Search 5 years of Maine county law enforcement discipline
- [Arizona LE Database - ABC15](https://datawrapper.dwcdn.net/kkg90/6/) - List of Arizona law enforcement officials with credibility, honesty issues, compiled by ABC15.
- [Police Complaint Lookup](http://complaints.cuapb.org/) - Police complaint lookup
- [Boston Police Internal Affairs Cases, 2010-2020](https://apps.bostonglobe.com/graphics/2020/law-enforcement/index.html?initialWidth=1029&childId=police-embed&parentTitle=Database%3A%20Search%2010%20years%27%20worth%20of%20Boston%20Police%20Department%20disciplinary%20action&parentUrl=https%3A%2F%2Fwww.bostonglobe.com%2F2020%2F11%2F24%2Fmetro%2Fheres-searchable-database-boston-police-department-internal-investigations-disciplinary-actions-more%2F) - Full Disclosure: Boston Police Internal Affairs Cases, 2010-2020
- [Police Decertifcations Search and Report](https://c0acu882.caspio.com/dp/07da6000e467ebc2a444430c9c1d) - Search for decertified officers
- [EFF Atlas of Surveillance](https://atlasofsurveillance.org/) - Search our database of police tech — enter a city, county, state or agency in the United States.
- [Clearview AI US taxpayer-funded entities](https://datawrapper.dwcdn.net/VOOIE/16/) - search for US taxpayer-funded entities that have used or tried Clearview AI as of February 2020 based on internal data.
- [Oregon DPSST Professional Standards Cases Database](https://www.oregon.gov/dpsst/CJ/Pages/Cases.aspx)
- [Plain View Project](https://www.plainviewproject.org/data) - a research project that has identified thousands of Facebook posts and comments by current and former police officers.
- [wikileaks](https://wikileaks.org) - WikiLeaks specializes in the analysis and publication of large datasets of censored or otherwise restricted official materials involving war, spying and corruption
- [RCMP Death Search](https://c0cqk108.caspio.com/dp/9156100036f195cdf0934662917c) - The RCMP National Grave Discovery Database
- [Policecrime.bgsu.edu](https://policecrime.bgsu.edu/) - The Henry A. Wallace Police Crime Database
- [Citizens Police Data Project](https://beta.cpdp.co/) - collects and publishes information
about police misconduct in Chicago
- [Fatal Encounters](https://fatalencounters.org/people-search/) - This database contains records of people who’ve been killed through interactions with law enforcement since Jan. 1, 2000.
- [The NYPD Files](https://projects.propublica.org/nypd-ccrb/) - Search Thousands of Civilian Complaints Against New York City Police Officers
- [Open Data Policing](https://opendatapolicing.com/) - Search all known North Carolina traffic stops
- [Police Surveillance in Chicago](https://redshiftzero.github.io/policesurveillance/)
- [Mappingpoliceviolence.org](https://mappingpoliceviolence.org/) - Police Surveillance in Chicago
- [Police Protest Videos](https://projects.propublica.org/protest-police-videos/) - We Tracked What Happens to Police After They Use Force on Protesters
- [GeorgeFloyd Protest police brutality videos](https://docs.google.com/spreadsheets/u/1/d/1YmZeSxpz52qT-10tkCjWOwOGkQqle7Wd1P7ZM1wMW0E/htmlview?pru=AAABcql6DI8*mIHYeMnoj9XWUp3Svb_KZA#) - GeorgeFloyd Protest - police brutality videos on Twitter
- [Police Body-Worn Camera Footage Access Map](https://www.rcfp.org/resources/bodycams/) - Access to police body-worn camera video
- [Civilian Office of Police Accountability](https://www.chicagocopa.org/data-cases/case-portal/) - case portal
- [Project Comport - IMPD/BPD/WPD [Datasets]](https://www.projectcomport.org/)
- [How many untested r@pe kits does your city police department or county sheriff’s office have?](https://datawrapper.dwcdn.net/uOdaT/4/) - How many untested r@pe kits does your city police department or county sheriff's office have?
- [Gun Dealer Inspections | The Trace](https://projects.thetrace.org/inspections/)
- [Secret Surveillance Catalogue](https://theintercept.com/surveillance-catalogue/) - A Secret Catalogue of Government Gear for Spying on Your Cellphone
- [Chicago Police Department Demographics](https://public.flourish.studio/visualisation/1089756/) - Demographic Composition of Chicago Police Department Compared to Population
- [George Floyd - Where black people are most disproportionately killed by police](https://public.flourish.studio/visualisation/2646234/) - George Floyd - Where black people are most disproportionately killed by police
- [Iowa Cities police budgets](https://public.flourish.studio/visualisation/3168834/) - Amount of General Fund Budgets allocated to police in cities in Iowa
- [TGCG Members Page](https://c2ffn114.caspio.com/dp/e6a74000833e44e23c324a10987c)
- [LELU](https://github.com/the-legal-aid-society/LELU) - Data from Legal Aid Society's Law Enforcement Lookup
<br>

[⇧ Top](#index)
## INFORMANT

- [WhosaRat.com](https://whosarat.com/) - Largest online database of Police informants and corrupt Police/Agents
- [Snitch List](https://web.archive.org/web/20200115091633/http://sniitch.com/all/)- Your public blog diary where you can write about anything and anyone. You are anonymous to the world but yet your blogs matter.(archive of Sniitch) for site [click Here](https://sniitch.com/)
- [Goldensnitches](https://goldensnitches.com/) - 500

## RESIDENT DATABASE

- [Michigan Resident Database](https://www.michiganresidentdatabase.com/) - Michigan residents public records search
- [Ohio Resident Database](https://www.ohioresidentdatabase.com/) - Ohio residents public records search
- [Florida Residents Directory](https://www.floridaresidentsdirectory.com/) - public recored search for Florida
- [North Carolina Resident Database](https://northcarolinaresidentdatabase.com/) - North corolina public record search
- [NY Rent Regulated Building Search](https://apps.hcr.ny.gov/BuildingSearch/) - Rent regulated building search from New York state division of housing and community
<br>

[⇧ Top](#index)
## PUBLIC RECORDS

- [JudyRecords](https://www.judyrecords.com/) - 740 million US court cases
- [CourtListener](https://www.courtlistener.com/) - Search millions of legal decisions by case name, topic, or citation.
- [Public Access to Court Electronic Records](https://pacer.uscourts.gov/) - public access to court electronic records
- [Parallelsearch case law](https://parallelsearch.casetext.com/) - Find a case by phrase
- [Canadian Legal Information Institute](https://www.canlii.org/en/)
- [Supreme Court of Canada - Cases](https://www.scc-csc.ca/case-dossier/index-eng.aspx)
- [Offender Tracking Information System (OTIS)](https://mdocweb.state.mi.us/OTIS2/otis2.aspx)
- [New York State Prison Records](https://stevemorse.org/prison/prison.html)
- [Texas Public Records Search](https://publicrecords.searchsystems.net/United_States_Free_Public_Records_by_State/Texas_Public_Records/)
- [Arrest Bookings Search and Report](https://b2.caspio.com/dp/a1a3100009b7083c53a9405f8c6b)
- [Credibly Accused](https://projects.propublica.org/credibly-accused/)
- [Sortedbybirthdate](https://sortedbybirthdate.com/)
- [NJParcels.com](http://njparcels.com/property/)
- [Social Security Death Master File](https://ssdmf.info/)
- [SortedByName.com](https://sortedbyname.com/)
- [Sortedbybirthdate.com](https://sortedbybirthdate.com/)
- [Cemetery.directory](https://cemetery.directory/)
- [Social Security Death Index](https://stevemorse.org/ssdi/ssdi.html)
- [FamilySearch’s United States Record Collections](https://stevemorse.org/fhl/websitesunitedstates.html)
- [Chicago Cook County Genealogy](https://stevemorse.org/vital/cook.html)
- [BoatInfoWorld](https://www.boatinfoworld.com/)
- [Street Name Changes](https://stevemorse.org/census/changes.html)
- [Brooklyn Genealogy](http://bklyn-genealogy-info.stevemorse.org/index.html)
- [Little Rock AR Crime Search](https://b2.caspio.com/dp.asp?AppKey=88321000961d92fc4ed343f38a0e)
- [New England Facts](https://newenglandfacts.com/)
- [Michigan State Records](https://michigan.staterecords.org/)
- [Cancelthesefunerals.com](http://cancelthesefunerals.com/)
- [Independent fundamental Baptist sexual misconduct database](https://datawrapper.dwcdn.net/UyECh/20/)
- [York County PA 2017 Write in Report](https://b2.caspio.com/dp/0a9210000bece9f2f50642ff9cac)
- [PA teacher salary average](https://b2.caspio.com/dp/0a921000a059622d4771466aab79)
- [High schools that received NRA grants 2010-2016](https://b4.caspio.com/dp/55073000c492127ebd8d4a03a06a)
- [Corrections Books Approval Search](https://b2.caspio.com/dp/0a921000cae47f9702f44d2bb94b)
- [Wisconsin Fox River Veterans’ Grave Registration Database](https://c3cqk813.caspio.com/dp/b201500011643c5f4c7f4bfba7d1)
- [OH marijuana docs](https://c0eru132.caspio.com/dp/95d310003d6c2e38182a48ef9bb2)
- [FAFSA Search and Report](https://c0dcb948.caspio.com/dp/726780004ccd83a96316450caead)
- [AL Local Surety Association Directory](https://c0gaf106.caspio.com/dp/2d4e1000c7506b7686a540d3b10f)
- [Ohio obituaries, death & marriage Search](https://c0abe732.caspio.com/dp/679e5000cbc8c6a587bb42efa9ef)
- [SECO Verification of Course Attendance 2018](https://c0esh132.caspio.com/dp/9040200005c29c35a74342e2b357)
- [IUS The Horizon Search and Report](https://c0acy802.caspio.com/dp/cf3b6000f61f1e0724984cb28f5c)
- [Katrina Spending Search](https://b2.caspio.com/dp/a4321000cb4905373d1946e5b33f)
- [AR College University 2017 Salaries](https://b2.caspio.com/dp.asp?AppKey=883210005c5e51279b424364aab2)
- [The Weapons ID Database](http://www.smallarmssurvey.org/weapons-and-markets/tools/weapons-id-database.html)
<br>

[⇧ Top](#index)
## GOVERNMENT

- [data.occrp.org](https://data.occrp.org/)
- [The Pegasus Project | OCCRP](https://cdn.occrp.org/projects/project-p/#/)
- [COP26 registered attendees](https://datawrapper.dwcdn.net/UCUWs/3/)
- [MuckRock](https://www.muckrock.com/)
- [GovSalaries](https://govsalaries.com/)
- [Openpayrolls.com](https://openpayrolls.com/)
- [SeeThroughNY :: Pensions](https://www.seethroughny.net/pensions)
- [Scotussearch.com](https://www.scotussearch.com/)
- [Nonprofit Explorer](https://projects.propublica.org/nonprofits/)
- [Coronavirus Bailouts](https://projects.propublica.org/coronavirus/bailouts/)
- [Nursing Home Inspect](https://projects.propublica.org/nursing-homes/)
- [Macron Campaign Emails](https://wikileaks.org//macron-emails/)
- [DNC email database](https://wikileaks.org//dnc-emails/)
- [GI Files](https://search.wikileaks.org/gifiles/)
- [AKP email database/](https://wikileaks.org//akp-emails/)
- [LittleSis](https://littlesis.org/)
- [Lexington KY Employee Salaries 2021](https://c0ect130.caspio.com/dp/c852100055664d756c6e441aa963)
- [Greater Sacramento Area Public Salaries](https://b2.caspio.com/dp/c48210000605c38aa22f4080a1be)
- [Illinois Public Salaries](https://c0ctb111.caspio.com/dp/1a7210001e4dbabdb7204962bc03)
- [St. Louis County salaries fiscal 2020](https://c0bkr141.caspio.com/dp/936b1000d0c132c8cbbb4f0c8c1f)
- [Milwaukee Wisconsin City Employee Salaries 2019](https://c0ebl104.caspio.com/dp/eab010008ed5ca97d7404269bf89)
- [Texas Local Superintendent Salaries Search and Report](https://b3.caspio.com/dp/5a5b1000b41b35162a3844b4b7ec)
- [Baytown TX Employee Directory](https://c0ctb134.caspio.com/dp/c5f5200097e7aef4edb54e09bd5e)
- [MA Middlesex County City employee salary 2019](https://c0eib112.caspio.com/dp/6ee01000497ba7e2d63b46229a99)
- [KY State Salary 2019](https://c0ect130.caspio.com/dp/c8521000065e102da08c40e696ad)
- [UKY Salaries 2019](https://c0ect130.caspio.com/dp/c8521000eca729c2125e46c487fd)
- [Mobile AL Salaries Search and Report](https://b2.caspio.com/dp/362210004ae292fb5cf34f0fb079)
- [NC State Government Salaries Search and Report](https://b2.caspio.com/dp/96073000345d59bc5b1744109afe)
- [NC State Employee Overtime 2018 Search and Report](https://c0eib112.caspio.com/dp/6ee01000325ae85bbfe24ade9bea)
- [PA 2017 Certificate Actions (Education)](https://b2.caspio.com/dp/0a9210006dbe656876084f9b9f59)
- [First Philadelphia Preparatory Charter School Staff Public Release 2017](https://b2.caspio.com/dp/0a921000842668d3d3e644d2bd8f)
- [PA School Districts Deeds user-facing web search](https://b2.caspio.com/dp/0a92100000938817df46468fa2a0)
- [PA Perry County 2017 Compensation Search and Report](https://b2.caspio.com/dp/0a921000e05cf4b592b245aeae20)
- [Gettysburg PA Adams County 2017 Payroll Search and Report](https://b2.caspio.com/dp/0a9210006f0ddf22afd8417f9711)
- [Lebanon County PA 2017 Search and Report](https://b2.caspio.com/dp/0a9210001cc98f2f21004ce4a3d4)
- [Dauphin County PA 2017 Compensation](https://b2.caspio.com/dp/0a921000a2f20d556db84221a92c)
- [York City PA Compensation](https://b2.caspio.com/dp/0a92100001903125816c4d34a37a)
- [York County VA 2017 Public Salaries](https://b2.caspio.com/dp/0a921000b12e238357df42e7affc)
- [OH Court Costs](https://b2.caspio.com/dp/95d31000da9841d5980644c98761)
- [German Gov Employee Database (Unknown)](https://c0acz339.caspio.com/dp/E171600054612b9f79fb4ddf8f2b)
- [Brazilian Address CEP Search and Report](https://c2abn462.caspio.com/dp/6c2d80006c6adb825b3b45079cb8)
- [Darpan NGO Search](https://c7ect427.caspio.com/dp/c45e900062d54a7f263942979465)
- [UNC System employees with the biggest paychecks](https://c0dzk127.caspio.com/dp/b95b1000e0821c125a8a43cd9cc1)
- [HEALTHCARE EDUCATION PROVIDERS](https://c3dug085.caspio.com/dp/1fec4000740ace75fdb94ec5bca5)
- [Cal Poly Email Search](https://c0acw966.caspio.com/dp/5dbe60009c7190a3b0bb407eaea0)
- [Dutchess and Ulster bridge safety ratings 2015](https://b2.caspio.com/dp.asp?AppKey=996f1000109b0cd3b24b408daf60)
- [Lou Barletta 2017 Donors](https://b2.caspio.com/dp/0a9210001cdd2eaac90941488478)
- [Worcester MA Employee Gross Pay](https://c0acu481.caspio.com/dp/e0536000108787410ed749fdb240)
<br>

[⇧ Top](#index)
## ONLYFANS

- [Onlysearch.co](https://onlysearch.co/)
- [OnlyFinder](https://onlyfinder.com/)
- [Search OnlyFans profiles](https://hubite.com/onlyfans-search/)
<br>

<a href="https://www.buymeacoffee.com/astrosp" target="_blank"><img src="https://cdn.buymeacoffee.com/buttons/v2/default-yellow.png" alt="Buy Me A Coffee" style="height: 45px !important;width: 157px !important;" ></a>

[Top](#index)
