export function getSearchInputPlaceholder(language) {
  switch (language) {
    case 'en':
      return 'Search your country';
    case 'ru':
      return 'Поиск по стране';
    case 'pl':
      return 'Wyszukiwanie według kraju';
    case 'ua':
      return 'Пошук по країні';
    case 'cz':
      return 'Vyhledávání podle země';
    case 'by':
      return 'Шукайце сваю краіну';
    case 'pt':
      return 'Pesquise seu país';
    case 'es':
      return 'Busque su país';
    case 'ro':
      return 'Căutați țara dvs.';
    case 'bg':
      return 'Търсене във вашата страна';
    case 'de':
      return 'Suche nach Land';
    case 'fr':
      return 'Recherchez votre pays';
    case 'nl':
      return 'Zoek uw land';
    case 'it':
      return 'Cerca il tuo paese';
    case 'cn':
      return '搜索您的国家';
    case 'ee':
      return 'Otsi oma riiki';
    case 'jp':
      return 'あなたの国を検索してください';
    case 'he':
      return 'חפש במדינה שלך';
    case 'ar':
      return 'إبحث عن بلدك';
    case 'tr':
      return 'Ülke arayın';
  }
}

export function getPhoneNumberInputPlaceholder(language) {
  switch (language) {
    case 'en':
      return 'Insert your phone number';
    case 'ru':
      return 'Вставьте свой номер телефона';
    case 'pl':
      return 'Wprowadź swój numer telefonu';
    case 'ua':
      return 'Введіть свій номер телефону';
    case 'cz':
      return 'Vložte své telefonní číslo';
    case 'by':
      return 'Увядзіце свой нумар тэлефона';
    case 'pt':
      return 'Insira seu número de telefone';
    case 'es':
      return 'Introduzca su número de teléfono';
    case 'ro':
      return 'Introduceți numărul dvs. de telefon';
    case 'bg':
      return 'Въведете телефонния си номер';
    case 'de':
      return 'Geben Sie Ihre Rufnummer ein';
    case 'fr':
      return 'Insérez votre numéro de téléphone';
    case 'nl':
      return 'Voer uw telefoonnummer in';
    case 'it':
      return 'Inserire il numero di telefono';
    case 'cn':
      return '输入电话号码';
    case 'ee':
      return 'Sisestage oma telefoninumber';
    case 'jp':
      return '電話番号を入力してください';
    case 'he':
      return 'הכנס את מספר הטלפון שלך';
    case 'ar':
      return 'أدخل رقم الهاتف';
    case 'tr':
      return 'Telefon numarası girin';
  }
}

export function getCountryNotFoundMessage(language) {
  switch (language) {
    case 'en':
      return 'Sorry, country not found :(';
    case 'ru':
      return 'Извините, страна не найдена';
    case 'pl':
      return 'Przepraszamy, nie znaleziono kraju';
    case 'ua':
      return 'Вибачте, країну не знайдено';
    case 'cz':
      return 'Omlouváme se, země nebyla nalezena';
    case 'by':
      return 'На жаль, краіна не знойдзена';
    case 'pt':
      return 'Desculpe, país não encontrado :(';
    case 'es':
      return 'Lo sentimos, no se ha encontrado el país';
    case 'ro':
      return 'Ne pare rău, țara nu a fost găsită';
    case 'bg':
      return 'Съжаляваме, страната не е намерена';
    case 'de':
      return 'Entschuldigung, Land nicht gefunden';
    case 'fr':
      return "Désolé, le pays n'a pas été trouvé";
    case 'nl':
      return 'Sorry, land niet gevonden';
    case 'it':
      return 'Spiacente, paese non trovato';
    case 'cn':
      return '抱歉，未找到国家';
    case 'ee':
      return 'Vabandust, riiki ei leitud';
    case 'jp':
      return '国が見つかりません';
    case 'he':
      return 'מצטערים, המדינה לא נמצאה';
    case 'ar':
      return 'عذراً، لم يتم العثور على البلد';
    case 'tr':
      return 'Herhangi bir ülke bulunamadı';
  }
}
