//! 
//! Definitions of the possible error codes (errorno.h)
//! 

pub const EPERM: usize = (-1 as isize) as usize; /* Operation not permitted */
pub const ENOENT: usize = (-2 as isize) as usize; /* No such file or directory */
pub const ESRCH: usize = (-3 as isize) as usize; /* No such process */
pub const EINTR: usize = (-4 as isize) as usize; /* Interrupted system call */
pub const EIO: usize = (-5 as isize) as usize; /* I/O error */
pub const ENXIO: usize = (-6 as isize) as usize; /* No such device or address */
pub const E2BIG: usize = (-7 as isize) as usize; /* Arg list too long */
pub const ENOEXEC: usize = (-8 as isize) as usize; /* Exec format error */
pub const EBADF: usize = (-9 as isize) as usize; /* Bad file number */
pub const ECHILD: usize = (-10 as isize) as usize; /* No child processes */
pub const EAGAIN: usize = (-11 as isize) as usize; /* Try again */
pub const ENOMEM: usize = (-12 as isize) as usize; /* Out of memory */
pub const EACCES: usize = (-13 as isize) as usize; /* Permission denied */
pub const EFAULT: usize = (-14 as isize) as usize; /* Bad address */
pub const ENOTBLK: usize = (-15 as isize) as usize; /* Block device required */
pub const EBUSY: usize = (-16 as isize) as usize; /* Device or resource busy */
pub const EEXIST: usize = (-17 as isize) as usize; /* File exists */
pub const EXDEV: usize = (-18 as isize) as usize; /* Cross-device link */
pub const ENODEV: usize = (-19 as isize) as usize; /* No such device */
pub const ENOTDIR: usize = (-20 as isize) as usize; /* Not a directory */
pub const EISDIR: usize = (-21 as isize) as usize; /* Is a directory */
pub const EINVAL: usize = (-22 as isize) as usize; /* Invalid argument */
pub const ENFILE: usize = (-23 as isize) as usize; /* File table overflow */
pub const EMFILE: usize = (-24 as isize) as usize; /* Too many open files */
pub const ENOTTY: usize = (-25 as isize) as usize; /* Not a typewriter */
pub const ETXTBSY: usize = (-26 as isize) as usize; /* Text file busy */
pub const EFBIG: usize = (-27 as isize) as usize; /* File too large */
pub const ENOSPC: usize = (-28 as isize) as usize; /* No space left on device */
pub const ESPIPE: usize = (-29 as isize) as usize; /* Illegal seek */
pub const EROFS: usize = (-30 as isize) as usize; /* Read-only file system */
pub const EMLINK: usize = (-31 as isize) as usize; /* Too many links */
pub const EPIPE: usize = (-32 as isize) as usize; /* Broken pipe */
pub const EDOM: usize = (-33 as isize) as usize; /* Math argument out of domain of func */
pub const ERANGE: usize = (-34 as isize) as usize; /* Math result not representable */
pub const EDEADLK: usize = (-35 as isize) as usize; /* Resource deadlock would occur */
pub const ENAMETOOLONG: usize = (-36 as isize) as usize; /* File name too long */
pub const ENOLCK: usize = (-37 as isize) as usize; /* No record locks available */
pub const ENOSYS: usize = (-38 as isize) as usize; /* Function not implemented */
pub const ENOTEMPTY: usize = (-39 as isize) as usize; /* Directory not empty */
pub const ELOOP: usize = (-40 as isize) as usize; /* Too many symbolic links encountered */
pub const EWOULDBLOCK: usize = (-41 as isize) as usize; /* Operation would block */
pub const ENOMSG: usize = (-42 as isize) as usize; /* No message of desired type */
pub const EIDRM: usize = (-43 as isize) as usize; /* Identifier removed */
pub const ECHRNG: usize = (-44 as isize) as usize; /* Channel number out of range */
pub const EL2NSYNC: usize = (-45 as isize) as usize; /* Level 2 not synchronized */
pub const EL3HLT: usize = (-46 as isize) as usize; /* Level 3 halted */
pub const EL3RST: usize = (-47 as isize) as usize; /* Level 3 reset */
pub const ELNRNG: usize = (-48 as isize) as usize; /* Link number out of range */
pub const EUNATCH: usize = (-49 as isize) as usize; /* Protocol driver not attached */
pub const ENOCSI: usize = (-50 as isize) as usize; /* No CSI structure available */
pub const EL2HLT: usize = (-51 as isize) as usize; /* Level 2 halted */
pub const EBADE: usize = (-52 as isize) as usize; /* Invalid exchange */
pub const EBADR: usize = (-53 as isize) as usize; /* Invalid request descriptor */
pub const EXFULL: usize = (-54 as isize) as usize; /* Exchange full */
pub const ENOANO: usize = (-55 as isize) as usize; /* No anode */
pub const EBADRQC: usize = (-56 as isize) as usize; /* Invalid request code */
pub const EBADSLT: usize = (-57 as isize) as usize; /* Invalid slot */
pub const EDEADLOCK: usize = (-58 as isize) as usize; /* File locking deadlock error */
pub const EBFONT: usize = (-59 as isize) as usize; /* Bad font file format */
pub const ENOSTR: usize = (-60 as isize) as usize; /* Device not a stream */
pub const ENODATA: usize = (-61 as isize) as usize; /* No data available */
pub const ETIME: usize = (-62 as isize) as usize; /* Timer expired */
pub const ENOSR: usize = (-63 as isize) as usize; /* Out of streams resources */
pub const ENONET: usize = (-64 as isize) as usize; /* Machine is not on the network */
pub const ENOPKG: usize = (-65 as isize) as usize; /* Package not installed */
pub const EREMOTE: usize = (-66 as isize) as usize; /* Object is remote */
pub const ENOLINK: usize = (-67 as isize) as usize; /* Link has been severed */
pub const EADV: usize = (-68 as isize) as usize; /* Advertise error */
pub const ESRMNT: usize = (-69 as isize) as usize; /* Srmount error */
pub const ECOMM: usize = (-70 as isize) as usize; /* Communication error on send */
pub const EPROTO: usize = (-71 as isize) as usize; /* Protocol error */
pub const EMULTIHOP: usize = (-72 as isize) as usize; /* Multihop attempted */
pub const EDOTDOT: usize = (-73 as isize) as usize; /* RFS specific error */
pub const EBADMSG: usize = (-74 as isize) as usize; /* Not a data message */
pub const EOVERFLOW: usize = (-75 as isize) as usize; /* Value too large for defined data type */
pub const ENOTUNIQ: usize = (-76 as isize) as usize; /* Name not unique on network */
pub const EBADFD: usize = (-77 as isize) as usize; /* File descriptor in bad state */
pub const EREMCHG: usize = (-78 as isize) as usize; /* Remote address changed */
pub const ELIBACC: usize = (-79 as isize) as usize; /* Can not access a needed shared library */
pub const ELIBBAD: usize = (-80 as isize) as usize; /* Accessing a corrupted shared library */
pub const ELIBSCN: usize = (-81 as isize) as usize; /* .lib section in a.out corrupted */
pub const ELIBMAX: usize = (-82 as isize) as usize; /* Attempting to link in too many shared libraries */
pub const ELIBEXEC: usize = (-83 as isize) as usize; /* Cannot exec a shared library directly */
pub const EILSEQ: usize = (-84 as isize) as usize; /* Illegal byte sequence */
pub const ERESTART: usize = (-85 as isize) as usize; /* Interrupted system call should be restarted */
pub const ESTRPIPE: usize = (-86 as isize) as usize; /* Streams pipe error */
pub const EUSERS: usize = (-87 as isize) as usize; /* Too many users */
pub const ENOTSOCK: usize = (-88 as isize) as usize; /* Socket operation on non-socket */
pub const EDESTADDRREQ: usize = (-89 as isize) as usize; /* Destination address required */
pub const EMSGSIZE: usize = (-90 as isize) as usize; /* Message too long */
pub const EPROTOTYPE: usize = (-91 as isize) as usize; /* Protocol wrong type for socket */
pub const ENOPROTOOPT: usize = (-92 as isize) as usize; /* Protocol not available */
pub const EPROTONOSUPPORT: usize = (-93 as isize) as usize; /* Protocol not supported */
pub const ESOCKTNOSUPPORT: usize = (-94 as isize) as usize; /* Socket type not supported */
pub const EOPNOTSUPP: usize = (-95 as isize) as usize; /* Operation not supported on transport endpoint */
pub const EPFNOSUPPORT: usize = (-96 as isize) as usize; /* Protocol family not supported */
pub const EAFNOSUPPORT: usize = (-97 as isize) as usize; /* Address family not supported by protocol */
pub const EADDRINUSE: usize = (-98 as isize) as usize; /* Address already in use */
pub const EADDRNOTAVAIL: usize = (-99 as isize) as usize; /* Cannot assign requested address */
pub const ENETDOWN: usize = (-100 as isize) as usize; /* Network is down */
pub const ENETUNREACH: usize = (-101 as isize) as usize; /* Network is unreachable */
pub const ENETRESET: usize = (-102 as isize) as usize; /* Network dropped connection because of reset */
pub const ECONNABORTED: usize = (-103 as isize) as usize; /* Software caused connection abort */
pub const ECONNRESET: usize = (-104 as isize) as usize; /* Connection reset by peer */
pub const ENOBUFS: usize = (-105 as isize) as usize; /* No buffer space available */
pub const EISCONN: usize = (-106 as isize) as usize; /* Transport endpoint is already connected */
pub const ENOTCONN: usize = (-107 as isize) as usize; /* Transport endpoint is not connected */
pub const ESHUTDOWN: usize = (-108 as isize) as usize; /* Cannot send after transport endpoint shutdown */
pub const ETOOMANYREFS: usize = (-109 as isize) as usize; /* Too many references: cannot splice */
pub const ETIMEDOUT: usize = (-110 as isize) as usize; /* Connection timed out */
pub const ECONNREFUSED: usize = (-111 as isize) as usize; /* Connection refused */
pub const EHOSTDOWN: usize = (-112 as isize) as usize; /* Host is down */
pub const EHOSTUNREACH: usize = (-113 as isize) as usize; /* No route to host */
pub const EALREADY: usize = (-114 as isize) as usize; /* Operation already in progress */
pub const EINPROGRESS: usize = (-115 as isize) as usize; /* Operation now in progress */
pub const ESTALE: usize = (-116 as isize) as usize; /* Stale NFS file handle */
pub const EUCLEAN: usize = (-117 as isize) as usize; /* Structure needs cleaning */
pub const ENOTNAM: usize = (-118 as isize) as usize; /* Not a XENIX named type file */
pub const ENAVAIL: usize = (-119 as isize) as usize; /* No XENIX semaphores available */
pub const EISNAM: usize = (-120 as isize) as usize; /* Is a named type file */
pub const EREMOTEIO: usize = (-121 as isize) as usize; /* Remote I/O error */

pub const ENOIOCTLCMD: usize = (-515 as isize) as usize; /* No ioctl command */