###  CVE-2019-1215

#### Describe

An elevation of privilege vulnerability exists in the way that ws2ifsl.sys (Winsock) handles objects in memory, aka 'Windows Elevation of Privilege Vulnerability'. This CVE ID is unique from CVE-2019-1253, CVE-2019-1278, CVE-2019-1303.

#### ImpactVersion

| Product             | CPU Architecture | Version | Update | Tested |
| ------------------- | ---------------- | ------- | ------ | ------ |
| Windows 7           | x86/x64          |         | SP1    |        |
| Windows Rt          |                  |         |        |        |
| Windows 8.1         | x86/x64          |         |        |        |
| Windows 10          | x86/x64          |         |        |        |
| Windows 10          | x86/x64          | 1607    |        |        |
| Windows 10          | x86/x64          | 1703    |        |        |
| Windows 10          | x86/x64          | 1709    |        |        |
| Windows 10          | x86/x64/arm64    | 1803    |        |        |
| Windows 10          | x86/x64/arm64    | 1809    |        |        |
| Windows 10          | x86/x64/arm64    | 1903    |        |        |
| Windows Server 2008 | x86/x64          | R2      | SP1    |        |
| Windows Server 2008 | x86/x64          |         | SP2    |        |
| Windows Server 2012 |                  | R2      |        |        |
| Windows Server 2012 |                  |         |        |        |
| Windows Server 2016 |                  |         |        |        |
| Windows Server 2019 |                  |         |        |        |
| Windows Server      |                  | 1803    |        |        |
| Windows Server      |                  | 1903    |        |        |

#### Patch

```
https://portal.msrc.microsoft.com/en-US/security-guidance/advisory/CVE-2019-1215
```

#### Utilization

The vulnerability does not test, the root directory is stored in the network collection **[CVE number] .zip** EXP or POC, code status unknown

#### ProjectSource

- [bluefrostsecurity](https://github.com/bluefrostsecurity/CVE-2019-1215)

#### Analyse

- https://labs.bluefrostsecurity.de/blog/2020/01/07/cve-2019-1215-analysis-of-a-use-after-free-in-ws2ifsl/ 
- https://bbs.pediy.com/thread-257435.htm 
- https://www.freebuf.com/vuls/226167.html
- https://www.163.com/dy/article/FQBEHKLS0511CJ6O.html
- https://saturn35.com/2020/01/09/20200109-1/ 
- https://day.fujieace.com/security-research/600.html



