###  CVE-2018-0824

#### Describe

The Credential Security Support Provider protocol (CredSSP) in Microsoft Windows Server 2008 SP2 and R2 SP1, Windows 7 SP1, Windows 8.1 and RT 8.1, Windows Server 2012 and R2, Windows 10 Gold, 1511, 1607, 1703, and 1709 Windows Server 2016 and Windows Server, version 1709 allows a remote code execution vulnerability due to how CredSSP validates request during the authentication process, aka "CredSSP Remote Code Execution Vulnerability".

#### ImpactVersion

| Product             | CPU Architecture | Version | Update | Tested |
| ------------------- | ---------------- | ------- | ------ | ------ |
| Windows 7           | x86/x64          |         | SP1    |        |
| Windows Rt          |                  |         |        |        |
| Windows 8.1         | x86/x64          |         |        |        |
| Windows 10          | x86/x64          |         |        |        |
| Windows 10          | x86/x64          | 1511    |        |        |
| Windows 10          | x86/x64          | 1607    |        |        |
| Windows 10          | x86/x64          | 1703    |        |        |
| Windows 10          | x86/x64          | 1709    |        |        |
| Windows 10          | x86/x64          | 1803    |        |        |
| Windows 10          | x86/x64/arm64    | 1809    |        |        |
| Windows 10          | x86/x64/arm64    | 1903    |        |        |
| Windows 10          | x86/x64/arm64    | 1909    |        |        |
| Windows Server 2008 | x86/x64          | R2      | SP1    |        |
| Windows Server 2008 | x86/x64          |         | SP2    |        |
| Windows Server 2012 |                  | R2      |        |        |
| Windows Server 2012 |                  |         |        |        |
| Windows Server 2016 |                  |         |        |        |
| Windows Server 2019 |                  |         |        |        |
| Windows Server      |                  | 1709    |        |        |
| Windows Server      |                  | 1803    |        |        |
| Windows Server      |                  | 1909    |        |        |

#### Patch

```
https://portal.msrc.microsoft.com/en-US/security-guidance/advisory/CVE-2018-0886
```

#### Utilization

The vulnerability does not test, the root directory is stored in the network collection **[CVE number] .zip** EXP or POC, code status unknown

#### ProjectSource

- [preempt](https://github.com/preempt/credssp)

#### Analyse

- https://www.anquanke.com/post/id/101158
