### CVE-2021-40449

#### 描述

Win32k 特权提升漏洞

#### 影响版本

| Product             | CPU Architecture | Version | Update | Tested   |
| ------------------- | ---------------- | ------- | ------ | -------- |
| Windows 11          | x64/AMD64        |         |        | &#10005; |
| Windows 10          | x86/x64          |         |        |          |
| Windows 10          | x86/x64          | 1607    |        | &#10004; |
| Windows 10          | x86/x64/AMD64    | 1809    |        | &#10004; |
| Windows 10          | x86/x64/AMD64    | 1909    |        |          |
| Windows 10          | x86/x64/AMD64    | 2004    |        |          |
| Windows 10          | x86/x64/AMD64    | 20H2    |        |          |
| Windows 10          | x86/x64/AMD64    | 21H1    |        |          |
| Windows 7           | x86/x64          |         | SP1    |          |
| Windows 8.1         | x86/x64          |         |        |          |
| Windows Rt 8.1      |                  |         |        |          |
| Windows Server 2008 | x86/x64          |         | SP2    |          |
| Windows Server 2008 | x64              | R2      | SP1    |          |
| Windows Server 2012 |                  |         |        |          |
| Windows Server 2012 |                  | R2      |        |          |
| Windows Server 2016 |                  |         |        |          |
| Windows Server 2019 |                  |         |        |          |
| Windows Server 2022 |                  |         |        |          |
| Windows Server      |                  | 2004    |        |          |
| Windows Server      |                  | 20H2    |        |          |

#### 修复补丁

```
https://portal.msrc.microsoft.com/en-US/security-guidance/advisory/CVE-2021-40449
```

#### 利用方式

编译环境

- VS2019（V120）X64 Release（CVE-2021-40449_1607_x64
- VS2019（V142）X64 Release（CallbackHell

> 推荐使用CallbackHell的代码进行提权

测试系统Windows 10 1607 X64（演示使用的是CVE-2021-40449_1607_x64文件中的代码进行编译

![image-20210911115757383](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2021-40449_Windows_10_1607_X64.gif)

#### 参考项目

- [KaLendsi](https://github.com/KaLendsi/CVE-2021-40449-Exploit)
- [ly4k]( https://github.com/ly4k/CallbackHell.git)

#### 分析文章

- [在野定向攻击所用Windows本地提权漏洞复现和分析](https://mp.weixin.qq.com/s/AcFS0Yn9SDuYxFnzbBqhkQ)
