## CVE-2020-16898

#### Describe

A remote code execution vulnerability exists when the Windows TCP/IP stack improperly handles ICMPv6 Router Advertisement packets, aka 'Windows TCP/IP Remote Code Execution Vulnerability'.


#### ImpactVersion

| Product             | Version       | Update | Edition | Tested             |
| :------------------ | :------------ | ------ | ------- | ------------------ |
| Windows 10          | X86/x64/ARM64 | 1709   |         | &#10004; |
| Windows 10          | X86/x64/ARM64 | 1803   |         |                    |
| Windows 10          | X86/x64/ARM64 | 1809   |         |                    |
| Windows 10          | X86/x64/ARM64 | 1903   |         |                    |
| Windows 10          | X86/x64/ARM64 | 1909   |         |                    |
| Windows 10          | X86/x64/ARM64 | 2004   |         |                    |
| Windows Server 2019 |               |        |         |                    |
| Windows Server      |               | 1903   |         |                    |
| Windows Server      |               | 1909   |         |                    |
| Windows Server      |               | 2004   |         |                    |

#### Patch

```
https://portal.msrc.microsoft.com/en-US/security-guidance/advisory/CVE-2020-16898
```

#### Utilization

At present, only the blue screen POC is public, and the amount is calculated as a CVE-2020-16899. You need to open IPv6 in the virtual machine before using it.

Test Machine Windows 10 1709 x64 as shown

![2](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2020-16898_ipv6_open.png)

Then the IPv6 address in the CVE-2020-16898.py script is then modified

![image-20201023092109185](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2020-16898_py.png)

Finally use commands `Pip install scapy`, install dependency bag, then use it directly to use blue screen

![4](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2020-16898_win_10_1709.gif)

#### Analyze
- https://www.anquanke.com/post/id/220862
- https://bestwing.me/CVE-2020-15898-analysis.html
- http://www.v4ler1an.com/2020/10/cve-2020-16898/
- https://cert.360.cn/report/detail?id=771d8ddc2d703071d5761b6a2b139793

#### ProjectSource

- Blue screen script:[momika233](https://github.com/momika233/CVE-2020-16898-exp)

