## CVE-2020-16898

#### 描述

CVE-2020-16898被称为“坏邻居”漏洞。Windows TCP/IP协议栈在处理 ICMPv6 路由广告包时，存在此远程代码执行漏洞。由于使用选项类型25和偶数长度字段对ICMPv6路由器播发数据包的处理不当，导致存在此漏洞。攻击者可通过向受影响主机发送特制ICMPv6路由广告包来利用此漏洞，成功利用此漏洞的攻击者可在目标服务器或客户端上执行任意代码。

#### 影响版本

| Product             | Version       | Update | Edition | Tested             |
| :------------------ | :------------ | ------ | ------- | ------------------ |
| Windows 10          | X86/x64/ARM64 | 1709   |         | &#10004; |
| Windows 10          | X86/x64/ARM64 | 1803   |         |                    |
| Windows 10          | X86/x64/ARM64 | 1809   |         |                    |
| Windows 10          | X86/x64/ARM64 | 1903   |         |                    |
| Windows 10          | X86/x64/ARM64 | 1909   |         |                    |
| Windows 10          | X86/x64/ARM64 | 2004   |         |                    |
| Windows Server 2019 |               |        |         |                    |
| Windows Server      |               | 1903   |         |                    |
| Windows Server      |               | 1909   |         |                    |
| Windows Server      |               | 2004   |         |                    |

#### 修复补丁

```
https://portal.msrc.microsoft.com/en-US/security-guidance/advisory/CVE-2020-16898
```

#### 利用方式

目前只公开蓝屏POC，充其量就算个CVE-2020-16899，利用前需要在虚拟机中开启IPV6，

测试机器Windows 10 1709 x64如图所示

![2](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2020-16898_ipv6_open.png)

接着把CVE-2020-16898.py脚本中的IPV6地址修改下

![image-20201023092109185](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2020-16898_py.png)

最后使用命令`pip install scapy`，安装依赖包，接着直接利用即可蓝屏

![4](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2020-16898_win_10_1709.gif)

#### 分析文章
- https://www.anquanke.com/post/id/220862
- https://bestwing.me/CVE-2020-15898-analysis.html
- http://www.v4ler1an.com/2020/10/cve-2020-16898/
- https://cert.360.cn/report/detail?id=771d8ddc2d703071d5761b6a2b139793

#### 脚本来源

- 蓝屏脚本：[momika233](https://github.com/momika233/CVE-2020-16898-exp)

