## CVE-2020-1337

#### Describe

An elevation of privilege vulnerability exists when the Windows Print Spooler service improperly allows arbitrary writing to the file system, aka 'Windows Print Spooler Elevation of Privilege Vulnerability'.

#### ImpactVersion

| Product             | Version       | Update | Edition | Tested             |
| :------------------ | :------------ | ------ | ------- | ------------------ |
| Windows 7 | X86/x64 |  | SP1 |  |
| Windows 8.1 | X86/x64 |  |  |  |
| Windows 10 | X86/x64 |  |  |  |
| Windows 10          | X86/x64 | 1607 |         |          |
| Windows 10          | X86/x64/ARM64 | 1709 |         |                    |
| Windows 10 | X86/x64/ARM64 | 1803 | | |
| Windows 10 | X86/x64/ARM64 | 1809 | | |
| Windows 10          | X86/x64/ARM64 | 1903   |         |                    |
| Windows 10          | X86/x64/ARM64 | 1909   |         | &#10004; |
| Windows 10          | X86/x64/ARM64 | 2004   |         |                    |
| Windows Server 2008 | X86/x64 |  | SP2 | |
| Windows Server 2008 | x64 | R2 | SP1 | |
| Windows Server 2012 |  |  | | |
| Windows Server 2012 |  | R2 | | |
| Windows Server 2016 |               |        |         |                    |
| Windows Server 2019 | | | | |
| Windows Server      |               | 1903   |         |                    |
| Windows Server      |               | 1909   |         |                    |
| Windows Server      |               | 2004   |         |                    |

#### Patch

```
https://portal.msrc.microsoft.com/en-US/security-guidance/advisory/CVE-2020-1337
```

#### Utilization

CompilerEnvironment

- VS2019（V142）X64 Release
- VS2019（V142）X64 Debug

The first way:

You need to use the administrator privilege to put the **phoneinfo.dll** file in the `C:\Windows\System32` directory, then execute the **Wertrigger.exe** file

The second way:

Sailay1996 wrote a PS1 script, but there is a limit to restart the machine. First, use the PS1 script to execute, and then restart it. **PhoneInfo.dll** is already in `C:\windows\system32` Need to run **Wertrigger.exe** file

Test Machine Windows 10 1909 x64 as shown

![CVE-2020-1337_windos_10_1909_x64](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2020-1337_windos_10_1909_x64.gif)

#### Analyze
- https://bbs.pediy.com/thread-261557.htm

#### ProjectSource

- [sailay1996](https://github.com/sailay1996/cve-2020-1337-poc)

