### CVE-2020-1054

#### Describe

An elevation of privilege vulnerability exists in Windows when the Windows kernel-mode driver fails to properly handle objects in memory, aka 'Win32k Elevation of Privilege Vulnerability'.

#### ImpactVersion

| Product             | CPU Architecture | Version | Update | Tested             |
| ------------------- | ---------------- | ------- | ------ | ------------------ |
| Windows 10          | x64/x86/ARM64 | 1803 |        |                    |
| Windows 10          | x64/x86/ARM64 | 1909 |        |                    |
| Windows 10          | x64/x86/ARM64 | 1903   |        |  |
| Windows 10          | x64/x86    | 1607  |        |  |
| Windows 10          | x64/x86/ARM64 | 1709 |        |                    |
| Windows 10 | x64/x86/ARM64 | 1809 | | |
| Windows 10          | x64/x86    |         |        |                    |
| Windows Server 2019 |                  |         |        |                    |
| Windows Server      |                  | 1803 |        |                    |
| Windows Server      |                  | 1909 |        |                    |
| Windows Server      |                  | 1903 |        |                    |
| Windows Server 2016 | |  | | |
| Windows 8.1 | x64/x86 |  | | |
| Windows 7 | x64/x86 |  | SP1 | &#10004; |
| Windows Server 2012 |  |  |  | |
| Windows Server 2012 | | R2 | | |
| Windows Server 2008 | x64 | R2 | SP1 | |
| Windows Server 2008 | x64/x86          |  | SP2 | |
| Windows RT 8.1 | |  | | |

#### Patch

```
https://portal.msrc.microsoft.com/en-US/security-guidance/advisory/CVE-2020-1054
```

#### Utilization

CompilerEnvironment

- cargo 1.51.0 (43b129a20 2021-03-16)

First download [cargo](https://www.rust-lang.org/learn/get-started), then compile the code

```
cargo build --release
```

There are two points here to pay attention:

- In the analysis article, if your system has patch installed a KB, you need to replace 200 lines of code to 199, and vice versa.
- The second need to use PowerShell to perform exe，And need to have `winlogon.exe` This process is running，The location of this process is in the `C:\Windows\System32` directory

Then run directly in Windows 7 SP1 X64

![CVE-2020-1054](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2020-1054_windows_7_x64.gif)

#### Analyze
- https://www.anquanke.com/post/id/209329
- https://mp.weixin.qq.com/s?__biz=MjM5NTc2MDYxMw==&mid=2458334073&idx=1&sn=d8ffd415a148aac507b0173eb906badb&chksm=b18003f386f78ae5c76971e993f42409a0c22fd52468949bf08436469e7456f4cc836ab9ba71&scene=21
- https://bbs.pediy.com/thread-260884.htm

#### ProjectSource

- [0xeb-bp](https://github.com/0xeb-bp/cve-2020-1054)