### CVE-2020-1054

#### 描述

当Windows内核模式驱动程序无法正确处理内存中的对象（也称为“ Win32k特权提升漏洞”）时，Windows中存在一个特权提升漏洞。

#### 影响版本

| Product             | CPU Architecture | Version | Update | Tested             |
| ------------------- | ---------------- | ------- | ------ | ------------------ |
| Windows 10          | x64/x86/ARM64 | 1803 |        |                    |
| Windows 10          | x64/x86/ARM64 | 1909 |        |                    |
| Windows 10          | x64/x86/ARM64 | 1903   |        |  |
| Windows 10          | x64/x86    | 1607  |        |  |
| Windows 10          | x64/x86/ARM64 | 1709 |        |                    |
| Windows 10 | x64/x86/ARM64 | 1809 | | |
| Windows 10          | x64/x86    |         |        |                    |
| Windows Server 2019 |                  |         |        |                    |
| Windows Server      |                  | 1803 |        |                    |
| Windows Server      |                  | 1909 |        |                    |
| Windows Server      |                  | 1903 |        |                    |
| Windows Server 2016 | |  | | |
| Windows 8.1 | x64/x86 |  | | |
| Windows 7 | x64/x86 |  | SP1 | &#10004; |
| Windows Server 2012 |  |  |  | |
| Windows Server 2012 | | R2 | | |
| Windows Server 2008 | x64 | R2 | SP1 | |
| Windows Server 2008 | x64/x86          |  | SP2 | |
| Windows RT 8.1 | |  | | |

#### 修复补丁

```
https://portal.msrc.microsoft.com/en-US/security-guidance/advisory/CVE-2020-1054
```

#### 利用方式

编译环境

- cargo 1.51.0 (43b129a20 2021-03-16)

先要下载[cargo](https://www.rust-lang.org/learn/get-started)，然后编译代码

```
cargo build --release
```

这里有两点需要注意：

- 作者在分析文章中说，如果你的系统有安装某个KB的补丁，需要把200行的代码替换成199行的，反之亦然
- 第二需要使用powershell来执行exe，并且需要有`winlogon.exe`这个进程运行着，这个进程的位置在`c:\Windows\System32`目录下

接着直接在Windows 7 SP1 X64下运行即可 

![CVE-2020-1054](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2020-1054_windows_7_x64.gif)

#### 分析文章
- https://www.anquanke.com/post/id/209329
- https://mp.weixin.qq.com/s?__biz=MjM5NTc2MDYxMw==&mid=2458334073&idx=1&sn=d8ffd415a148aac507b0173eb906badb&chksm=b18003f386f78ae5c76971e993f42409a0c22fd52468949bf08436469e7456f4cc836ab9ba71&scene=21
- https://bbs.pediy.com/thread-260884.htm

#### 代码来源

- [0xeb-bp](https://github.com/0xeb-bp/cve-2020-1054)