## CVE-2020-1015

#### Describe

An elevation of privilege vulnerability exists in the way that the User-Mode Power Service (UMPS) handles objects in memory, aka 'Windows Elevation of Privilege Vulnerability'. 

#### ImpactVersion

| Product             | Version       | Update | Edition | Tested             |
| :------------------ | :------------ | ------ | ------- | ------------------ |
| Windows 7 | X86/x64 |  | SP1 |  |
| Windows 8.1 | X86/x64 |  |  |  |
| Windows 10 | X86/x64 |  |  |  |
| Windows 10          | X86/x64 | 1607 |         |          |
| Windows 10          | X86/x64/ARM64 | 1709 |         |                    |
| Windows 10 | X86/x64/ARM64 | 1803 | | |
| Windows 10 | X86/x64/ARM64 | 1809 | | |
| Windows 10          | X86/x64/ARM64 | 1903   |         |                    |
| Windows 10          | X86/x64/ARM64 | 1909   |         | &#10004; |
| Windows Server 2008 | x64 | R2 | SP1 | |
| Windows Server 2012 |  |  | | |
| Windows Server 2012 |  | R2 | | |
| Windows Server 2016 |               |        |         |                    |
| Windows Server 2019 | | | | |
| Windows Server      |               | 1803   |         |                    |
| Windows Server      |               | 1903   |         |                    |
| Windows Server      |               | 1909 |         |                    |

#### Patch

```
https://portal.msrc.microsoft.com/en-US/security-guidance/advisory/CVE-2020-1015
```

#### Utilization

> Compilation method of original text

1. Create an empty C++ project in Visual Studio.
2. Add `cve_2020_1015.cpp` and `Source.idl` to the project as source files.
3. Compile `Source.idl`. This will generate three files: `Source_c.c`, `Source_h.h` and `Source_s.c`.
4. Add the first two as source files to the project.
5. Add `rpcrt4.lib` as an additional dependency to the project
6. Build!

> Compilation mode in this project (directly compiled)

- VS2019（V142）X86 Release

Test Machine Windows 10 1909 x64, will make CPUs to lead blue screen

![](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2020-1015_win10_1909_x64_poc.gif)

#### Analyze
- https://0xeb-bp.com/blog/2020/05/12/cve-2020-1015-analysis.html
- https://www.anquanke.com/post/id/217526

#### ProjectSource

- [0xeb-bp](https://github.com/0xeb-bp/cve-2020-1015)

