### CVE-2020-0796

#### Describe

A remote code execution vulnerability exists in the way that the Microsoft Server Message Block 3.1.1 (SMBv3) protocol handles certain requests, aka 'Windows SMBv3 Client/Server Remote Code Execution Vulnerability'.


#### ImpactVersion

| Product        | CPU Architecture | Version | Update | Tested             |
| -------------- | ---------------- | ------- | ------ | ------------------ |
| Windows 10     | x64/x86/ARM64    | 1909    |        |                    |
| Windows 10     | x64/x86/ARM64    | 1903    |        | &#10004; |
| Windows Server |                  | 1903    |        |                    |
| Windows Server |                  | 1909    |        |                    |

#### Patch

```
https://portal.msrc.microsoft.com/en-US/security-guidance/advisory/CVE-2020-0796
```

#### Utilization

This is a little chicken-specific Windows10 has a Windows Server

CompilerEnvironment

- VS2019（V142）X64 Debug

Environment download, this is Windows 10 1903 x64

```
ed2k://|file|cn_windows_10_business_editions_version_1903_x64_dvd_e001dd2c.iso|4815527936|47D4C57E638DF8BF74C59261E2CE702D|/
```

View MD5 value

```
Get-FileHash -Path c:/windows/system32/drivers/srv2.sys
```

![image-20200810115258497](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2020-0796_powershell.png)

Then directly gif map

![1](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2020-0796_win10_1903_x64.gif)

#### Analyze
- https://paper.seebug.org/1168/
- https://www.freebuf.com/column/230770.html
- https://jcxp.github.io/2020/03/31/CVE-2020-0796-SMB%E6%BC%8F%E6%B4%9E%E5%88%86%E6%9E%90/
- https://www.cnblogs.com/potatsoSec/p/12484973.html
- https://blog.csdn.net/RatOnSea/article/details/106399450
- https://blogs.360.cn/post/CVE-2020-0796.html
- https://zhuanlan.zhihu.com/p/133460472

#### ProjectSource

- [@danigargu](https://github.com/danigargu/CVE-2020-0796)

