### CVE-2020-0796

#### 描述

该漏洞无需授权验证即可被远程利用，可能形成蠕虫级漏洞。目前利用方式是提权

#### 影响版本

| Product        | CPU Architecture | Version | Update | Tested             |
| -------------- | ---------------- | ------- | ------ | ------------------ |
| Windows 10     | x64/x86/ARM64    | 1909    |        |                    |
| Windows 10     | x64/x86/ARM64    | 1903    |        | &#10004; |
| Windows Server |                  | 1903    |        |                    |
| Windows Server |                  | 1909    |        |                    |

#### 修复补丁

```
https://portal.msrc.microsoft.com/en-US/security-guidance/advisory/CVE-2020-0796
```

#### 利用方式

这个有点鸡肋特定的windows10 才行还有一个Windows Server

编译方式

- VS2019（V142）X64 Debug

环境下载，这边用的是windows 10 1903 x64

```
ed2k://|file|cn_windows_10_business_editions_version_1903_x64_dvd_e001dd2c.iso|4815527936|47D4C57E638DF8BF74C59261E2CE702D|/
```

查看MD5值

```
Get-FileHash -Path c:/windows/system32/drivers/srv2.sys
```

![image-20200810115258497](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2020-0796_powershell.png)

然后就直接上GIF图了

![1](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2020-0796_win10_1903_x64.gif)

#### 分析文章
- https://paper.seebug.org/1168/
- https://www.freebuf.com/column/230770.html
- https://jcxp.github.io/2020/03/31/CVE-2020-0796-SMB%E6%BC%8F%E6%B4%9E%E5%88%86%E6%9E%90/
- https://www.cnblogs.com/potatsoSec/p/12484973.html
- https://blog.csdn.net/RatOnSea/article/details/106399450
- https://blogs.360.cn/post/CVE-2020-0796.html
- https://zhuanlan.zhihu.com/p/133460472

#### 项目来源

- [@danigargu](https://github.com/danigargu/CVE-2020-0796)

