### CVE-2020-0787

#### Describe

An elevation of privilege vulnerability exists when the Windows Background Intelligent Transfer Service (BITS) improperly handles symbolic links, aka 'Windows Background Intelligent Transfer Service Elevation of Privilege Vulnerability'.

#### ImpactVersion

| Product             | CPU Architecture | Version | Update | Tested             |
| ------------------- | ---------------- | ------- | ------ | ------------------ |
| Windows 10          | x64/x86/ARM64    | 1909    |        |                    |
| Windows 10          | x64/x86/ARM64    | 1903    |        |                    |
| Windows 10          | x64/x86/ARM64    | 1809    |        |                    |
| Windows 10          | x64/x86/ARM64    | 1803    |        |                    |
| Windows 10          | x64/x86/ARM64    | 1709    |        |                    |
| Windows 10          | x64/x86          | 1607    |        |                    |
| Windows 10          | x64/x86          |         |        |                    |
| Windows 7           | x64/x86          |         | SP1    | &#10004; |
| Windows 8.1         | x64/x86          |         |        |                    |
| Windows RT 8.1      |                  |         |        |                    |
| Windows Server 2008 | x64/x86          | R2      | SP1    |                    |
| Windows Server 2008 | x64/x86          |         | SP2    |                    |
| Windows Server 2012 |                  |         |        |                    |
| Windows Server 2012 |                  | R2      |        |                    |
| Windows Server 2016 |                  |         |        |                    |
| Windows Server 2019 |                  |         |        |                    |
| Windows Server      |                  | 1903    |        |                    |
| Windows Server      |                  | 1909    |        |                    |
| Windows Server      |                  | 1803    |        |                    |

#### Patch

```
https://portal.msrc.microsoft.com/en-US/security-guidance/advisory/CVE-2020-0787
```

#### Utilization

CompilerEnvironment

- VS2019 （V120）X64 Debug

Compile a good file

```
BitsArbitraryFileMoveExploit.exe
```

Test system Windows 7 SP1 x64，Direct GIF map

![1](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2020-0787_win7_sp1_x64.gif)

#### Analyze
- https://f5.pm/go-28382.html
- https://itm4n.github.io/cve-2020-0787-windows-bits-eop/
- https://xz.aliyun.com/t/7935


#### ProjectSource

[@cbwang505](https://github.com/cbwang505/CVE-2020-0787-EXP-ALL-WINDOWS-VERSION)



