### CVE-2020-0787

#### 描述

当Windows Background Intelligent Transfer Service（BITS）未能正确地处理符号链接时，存在权限提升漏洞。成功利用此漏洞的攻击者可以覆盖导致提升状态的目标文件。要利用此漏洞，攻击者首先必须登录到系统。然后，攻击者可以运行巧尽心思构建的应用程序，利用此漏洞并控制受影响的系统。

#### 影响版本

| Product             | CPU Architecture | Version | Update | Tested             |
| ------------------- | ---------------- | ------- | ------ | ------------------ |
| Windows 10          | x64/x86/ARM64    | 1909    |        |                    |
| Windows 10          | x64/x86/ARM64    | 1903    |        |                    |
| Windows 10          | x64/x86/ARM64    | 1809    |        |                    |
| Windows 10          | x64/x86/ARM64    | 1803    |        |                    |
| Windows 10          | x64/x86/ARM64    | 1709    |        |                    |
| Windows 10          | x64/x86          | 1607    |        |                    |
| Windows 10          | x64/x86          |         |        |                    |
| Windows 7           | x64/x86          |         | SP1    | &#10004; |
| Windows 8.1         | x64/x86          |         |        |                    |
| Windows RT 8.1      |                  |         |        |                    |
| Windows Server 2008 | x64/x86          | R2      | SP1    |                    |
| Windows Server 2008 | x64/x86          |         | SP2    |                    |
| Windows Server 2012 |                  |         |        |                    |
| Windows Server 2012 |                  | R2      |        |                    |
| Windows Server 2016 |                  |         |        |                    |
| Windows Server 2019 |                  |         |        |                    |
| Windows Server      |                  | 1903    |        |                    |
| Windows Server      |                  | 1909    |        |                    |
| Windows Server      |                  | 1803    |        |                    |

#### 修复补丁

```
https://portal.msrc.microsoft.com/en-US/security-guidance/advisory/CVE-2020-0787
```

#### 利用方式

编译环境

- VS2019 （V120）X64 Debug

编译好的文件

```
BitsArbitraryFileMoveExploit.exe
```

测试系统Windows 7 SP1 x64，直接上GIF图

![1](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2020-0787_win7_sp1_x64.gif)

#### 分析文章
- https://f5.pm/go-28382.html
- https://itm4n.github.io/cve-2020-0787-windows-bits-eop/
- https://xz.aliyun.com/t/7935


#### 项目来源

[@cbwang505](https://github.com/cbwang505/CVE-2020-0787-EXP-ALL-WINDOWS-VERSION)



