## CVE-2020-0683

#### Describe

An elevation of privilege vulnerability exists in the Windows Installer when MSI packages process symbolic links, aka 'Windows Installer Elevation of Privilege Vulnerability'. 

#### ImpactVersion

| Product             | Version       | Update | Edition | Tested             |
| :------------------ | :------------ | ------ | ------- | ------------------ |
| Windows 7 | X86/x64 |  | SP1 |  |
| Windows 8.1 | X86/x64 |  |  |  |
| Windows 10 | X86/x64 |  |  |  |
| Windows 10          | X86/x64 | 1607 |         |          |
| Windows 10          | X86/x64/ARM64 | 1709 |         |                    |
| Windows 10 | X86/x64/ARM64 | 1803 | | |
| Windows 10 | X86/x64/ARM64 | 1809 | | |
| Windows 10          | X86/x64/ARM64 | 1903   |         |                    |
| Windows 10          | X86/x64/ARM64 | 1909   |         | &#10004; |
| Windows Server 2008 | X86/x64 |  | SP2 |  |
| Windows Server 2008 | x64 | R2 | SP1 | |
| Windows Server 2012 |  |  | | |
| Windows Server 2012 |  | R2 | | |
| Windows Server 2016 |               |        |         |                    |
| Windows Server 2019 | | | | |
| Windows Server      |               | 1803   |         |                    |
| Windows Server      |               | 1903   |         |                    |
| Windows Server      |               | 1909 |         |                    |

#### Patch

```
https://portal.msrc.microsoft.com/en-US/security-guidance/advisory/CVE-2020-0683
```

#### Utilization

CompilerEnvironment

- VS2019（V141）X64 Debug
- VS2019（V141）X64 Release

Test Machine Windows 10 1909 x64, only written information on the specified file in the source code, if you need to get the permissions of a program, you need to modify the source code yourself.

![](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2020-0683_win10_1909_x64.gif)

#### Analyze

- [MSI_EoP_New.pdf](./MSI_EoP_New.pdf)

#### ProjectSource

- [padovah4ck](https://github.com/padovah4ck/CVE-2020-0683)

