## CVE-2020-0683

#### 描述

Windows Installer在MSI包处理符号链接时，在Windows Installer中存在权限漏洞的提升

#### 影响版本

| Product             | Version       | Update | Edition | Tested             |
| :------------------ | :------------ | ------ | ------- | ------------------ |
| Windows 7 | X86/x64 |  | SP1 |  |
| Windows 8.1 | X86/x64 |  |  |  |
| Windows 10 | X86/x64 |  |  |  |
| Windows 10          | X86/x64 | 1607 |         |          |
| Windows 10          | X86/x64/ARM64 | 1709 |         |                    |
| Windows 10 | X86/x64/ARM64 | 1803 | | |
| Windows 10 | X86/x64/ARM64 | 1809 | | |
| Windows 10          | X86/x64/ARM64 | 1903   |         |                    |
| Windows 10          | X86/x64/ARM64 | 1909   |         | &#10004; |
| Windows Server 2008 | X86/x64 |  | SP2 |  |
| Windows Server 2008 | x64 | R2 | SP1 | |
| Windows Server 2012 |  |  | | |
| Windows Server 2012 |  | R2 | | |
| Windows Server 2016 |               |        |         |                    |
| Windows Server 2019 | | | | |
| Windows Server      |               | 1803   |         |                    |
| Windows Server      |               | 1903   |         |                    |
| Windows Server      |               | 1909 |         |                    |

#### 修复补丁

```
https://portal.msrc.microsoft.com/en-US/security-guidance/advisory/CVE-2020-0683
```

#### 利用方式

编译方式

- VS2019（V141）X64 Debug
- VS2019（V141）X64 Release

测试机器Windows 10 1909 X64，源码中只对指定文件进行写入信息，如果需要获取某项程序的权限，需要自行修改源码

![](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2020-0683_win10_1909_x64.gif)

#### 分析文章
- [MSI_EoP_New.pdf](./MSI_EoP_New.pdf)

#### 脚本来源

- [padovah4ck](https://github.com/padovah4ck/CVE-2020-0683)

