### CVE-2020-0668

#### Describe

An elevation of privilege vulnerability exists in the way that the Windows Kernel handles objects in memory, aka 'Windows Kernel Elevation of Privilege Vulnerability'. 

#### ImpactVersion

| Product             | CPU Architecture | Version | Update | Tested             |
| ------------------- | ---------------- | ------- | ------ | ------------------ |
| Windows 10          | x64/x86/ARM64    | 1909    |        |  |
| Windows 10          | x64/x86/ARM64    | 1903 |        |  |
| Windows 10          | x64/x86/ARM64    | 1809  |        |                    |
| Windows 10 | x64/x86/ARM64 | 1803 | | |
| Windows 10 | x64/x86/ARM64 | 1709 | | &#10004; |
| Windows 10 | x64/x86 | 1607 | | |
| Windows 10          | x64/x86    |         |        |                    |
| Windows 8.1 | x64/x86 | | | |
| Windows RT 8.1 |  | | | |
| Windows 7 | x64/x86 | | SP1 | |
| Windows Server 2019 |                  |         |        |                    |
| Windows Server 2016 | | | | |
| Windows Server 2012 | | R2 | | |
| Windows Server 2012 | | | | |
| Windows Server 2008 | x64/x86 |  | SP2 | |
| Windows Server 2008 | x64 | R2 | SP1 | |
| Windows Server      |                  | 1909 |        |                    |
| Windows Server      |                  | 1903 |        |                    |
| Windows Server | | 1803 | | |

#### Patch

```
https://portal.msrc.microsoft.com/en-US/security-guidance/advisory/CVE-2020-0668
```

#### Utilization

CompilerEnvironment

- VS2019（.NET Framework 4.7.2）Any CPU Debug

The exp is a file migration operation using rights, if you want to use CMD, you need to modify the code, test the machine Windows 10 1709 x64，The moving map is moved to the `C:\Windows\System32` directory, **Test.dll** can be any file. Put the **ntapidotNet.dll** file in the same level when using EXE

![](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2020-0668_Windows_10_1709_X64.gif)

> Use https://github.com/itm4n/UsoDllLoader (Windows >= 1903) OR https://github.com/xct/diaghub (Windows < 1903) for privilege escalation.

#### Analyze

- https://www.anquanke.com/post/id/199011
- https://www.freebuf.com/vuls/227557.html
- https://itm4n.github.io/cve-2020-0668-windows-service-tracing-eop/


#### ProjectSource

- [RedCursorSecurityConsulting](https://github.com/RedCursorSecurityConsulting/CVE-2020-0668)