### CVE-2020-0668

#### 描述

Windows内核处理内存中对象的方式存在权限漏洞的提升

#### 影响版本

| Product             | CPU Architecture | Version | Update | Tested             |
| ------------------- | ---------------- | ------- | ------ | ------------------ |
| Windows 10          | x64/x86/ARM64    | 1909    |        |  |
| Windows 10          | x64/x86/ARM64    | 1903 |        |  |
| Windows 10          | x64/x86/ARM64    | 1809  |        |                    |
| Windows 10 | x64/x86/ARM64 | 1803 | | |
| Windows 10 | x64/x86/ARM64 | 1709 | | &#10004; |
| Windows 10 | x64/x86 | 1607 | | |
| Windows 10          | x64/x86    |         |        |                    |
| Windows 8.1 | x64/x86 | | | |
| Windows RT 8.1 |  | | | |
| Windows 7 | x64/x86 | | SP1 | |
| Windows Server 2019 |                  |         |        |                    |
| Windows Server 2016 | | | | |
| Windows Server 2012 | | R2 | | |
| Windows Server 2012 | | | | |
| Windows Server 2008 | x64/x86 |  | SP2 | |
| Windows Server 2008 | x64 | R2 | SP1 | |
| Windows Server      |                  | 1909 |        |                    |
| Windows Server      |                  | 1903 |        |                    |
| Windows Server | | 1803 | | |

#### 修复补丁

```
https://portal.msrc.microsoft.com/en-US/security-guidance/advisory/CVE-2020-0668
```

#### 利用方式

编译环境

- VS2019（.NET Framework 4.7.2）Any CPU Debug

该EXP是使用提权进行文件迁移操作，如果想使用cmd需要自己修改代码，测试机器Windows 10 1709 X64，动图中是把**test.dll**移动到 `C:\Windows\System32`目录下，**test.dll**可以是任意文件。使用exe时需要把**NtApiDotNet.dll**文件放到同级目录

![](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2020-0668_Windows_10_1709_X64.gif)

> Use https://github.com/itm4n/UsoDllLoader (Windows >= 1903) OR https://github.com/xct/diaghub (Windows < 1903) for privilege escalation.

#### 分析文章

- https://www.anquanke.com/post/id/199011
- https://www.freebuf.com/vuls/227557.html
- https://itm4n.github.io/cve-2020-0668-windows-service-tracing-eop/


#### 代码来源

- [RedCursorSecurityConsulting](https://github.com/RedCursorSecurityConsulting/CVE-2020-0668)