### CVE-2019-1458

#### Describe

An elevation of privilege vulnerability exists in Windows when the Win32k component fails to properly handle objects in memory, aka 'Win32k Elevation of Privilege Vulnerability'.


#### ImpactVersion

| Product             | CPU Architecture | Version | Update | Tested             |
| ------------------- | ---------------- | ------- | ------ | ------------------ |
| Windows 10          | x64/x86          | 1607    |        |                    |
| Windows 10          | x64/x86          |         |        |                    |
| Windows 7           | x64/x86          |         | SP1    | &#10004; |
| Windows 8.1         | x64/x86          |         |        |                    |
| Windows RT 8.1      |                  |         |        |                    |
| Windows Server 2008 | x64/x86          | R2      | SP1    |                    |
| Windows Server 2008 | x64/x86          |         | SP2    |                    |
| Windows Server 2012 |                  |         |        |                    |
| Windows Server 2012 |                  | R2      |        |                    |
| Windows Server 2016 |                  |         |        |                    |

#### Patch

```
https://portal.msrc.microsoft.com/en-US/security-guidance/advisory/CVE-2019-1458
```

#### Utilization

CompilerEnvironment

- VS2019（V120）X64 Release

Compile a good file

```
cve-2019-1458.exe
```

Test system Windows 7 SP1 x64 ，Direct GIF map

![11](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2019-1458_win7_sp1_x64.gif)

#### Analyze
- https://github.com/piotrflorczyk/cve-2019-1458_POC
- https://bbs.pediy.com/thread-260268.htm
- https://thunderjie.github.io/2020/03/21/CVE-2019-1458-%E4%BB%8E-%E6%BC%8F%E6%B4%9E%E6%8A%A5%E5%91%8A-%E5%88%B0POC%E7%9A%84%E7%BC%96%E5%86%99%E8%BF%87%E7%A8%8B/