### CVE-2019-1388

#### Describe

An elevation of privilege vulnerability exists in the Windows Certificate Dialog when it does not properly enforce user privileges, aka 'Windows Certificate Dialog Elevation of Privilege Vulnerability'.

#### ImpactVersion

| Product             | CPU Architecture | Version | Update | Tested             |
| ------------------- | ---------------- | ------- | ------ | ------------------ |
| Windows 10          | x64/x86/ARM64    | 1903    |        |                    |
| Windows 10          | x64/x86/ARM64    | 1809    |        |                    |
| Windows 10          | x64/x86/ARM64    | 1803    |        |                    |
| Windows 10          | x64/x86/ARM64    | 1709    |        |                    |
| Windows 10          | x64/x86          | 1607    |        |                    |
| Windows 10          | x64/x86          |         |        |                    |
| Windows 7           | x64/x86          |         | SP1    | &#10004; |
| Windows 8.1         | x64/x86          |         |        |                    |
| Windows RT 8.1      |                  |         |        |                    |
| Windows Server 2008 | x64/x86          | R2      | SP1    |                    |
| Windows Server 2008 | x64/x86          |         | SP2    |                    |
| Windows Server 2012 |                  |         |        |                    |
| Windows Server 2012 |                  | R2      |        |                    |
| Windows Server 2016 |                  |         |        |                    |
| Windows Server 2019 |                  |         |        |                    |
| Windows Server      |                  | 1903    |        |                    |
| Windows Server      |                  | 1803    |        |                    |

#### Patch

```
https://portal.msrc.microsoft.com/en-US/security-guidance/advisory/CVE-2019-1388
```

#### Utilization

It's just a GIF map directly, use the file location.

```
https://github.com/Ascotbe/WindowsKernelExploits/blob/master/CVE-2019-1388/HHUPD.EXE
```

Test system Windows 7 SP1 x64

![1](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2019-1388_win7_sp1_x64.gif)

#### Analyze
- http://blog.leanote.com/post/snowming/38069f423c76
- https://mp.weixin.qq.com/s/q4UICIVwC4HX-ytvWo8Dvw