### CVE-2019-1388

#### 描述

该漏洞位于Windows的UAC（User Account Control，用户帐户控制）机制中。默认情况下，Windows会在一个单独的桌面上显示所有的UAC提示——Secure Desktop。这些提示是由名为consent.exe的可执行文件产生的，该可执行文件以NT AUTHORITY\SYSTEM权限运行，完整性级别为System。因为用户可以与该UI交互，因此必须对UI进行严格限制。否则，低权限的用户可能可以通过UI操作的循环路由以SYSTEM权限执行操作。即使隔离状态的看似无害的UI特征都可能会成为引发任意控制的动作链的第一步。事实上，UAC对话框已被精简，仅包含最少的可单击选项。

#### 影响版本

| Product             | CPU Architecture | Version | Update | Tested             |
| ------------------- | ---------------- | ------- | ------ | ------------------ |
| Windows 10          | x64/x86/ARM64    | 1903    |        |                    |
| Windows 10          | x64/x86/ARM64    | 1809    |        |                    |
| Windows 10          | x64/x86/ARM64    | 1803    |        |                    |
| Windows 10          | x64/x86/ARM64    | 1709    |        |                    |
| Windows 10          | x64/x86          | 1607    |        |                    |
| Windows 10          | x64/x86          |         |        |                    |
| Windows 7           | x64/x86          |         | SP1    | &#10004; |
| Windows 8.1         | x64/x86          |         |        |                    |
| Windows RT 8.1      |                  |         |        |                    |
| Windows Server 2008 | x64/x86          | R2      | SP1    |                    |
| Windows Server 2008 | x64/x86          |         | SP2    |                    |
| Windows Server 2012 |                  |         |        |                    |
| Windows Server 2012 |                  | R2      |        |                    |
| Windows Server 2016 |                  |         |        |                    |
| Windows Server 2019 |                  |         |        |                    |
| Windows Server      |                  | 1903    |        |                    |
| Windows Server      |                  | 1803    |        |                    |

#### 修复补丁

```
https://portal.msrc.microsoft.com/en-US/security-guidance/advisory/CVE-2019-1388
```

#### 利用方式

这边直接贴一个GIF图就好了，利用文件位置

```
https://github.com/Ascotbe/WindowsKernelExploits/blob/master/CVE-2019-1388/HHUPD.EXE
```

测试系统Windows 7 SP1 x64

![1](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2019-1388_win7_sp1_x64.gif)

#### 分析文章
- http://blog.leanote.com/post/snowming/38069f423c76
- https://mp.weixin.qq.com/s/q4UICIVwC4HX-ytvWo8Dvw