### CVE-2019-0623

#### Describe

An elevation of privilege vulnerability exists in Windows when the Win32k component fails to properly handle objects in memory, aka 'Win32k Elevation of Privilege Vulnerability'.


#### ImpactVersion

| Product             | CPU Architecture | Version | Update | Tested             |
| ------------------- | ---------------- | ------- | ------ | ------------------ |
| Windows 10          | x64/x86/ARM64    | 1803 |        |                    |
| Windows 10          | x64/x86/ARM64    | 1709 |        |  |
| Windows 10          | x64/x86    | 1703 |        |  |
| Windows 10 | x64/x86 | 1607 | | |
| Windows 10          | x64/x86    |         |        |                    |
| Windows 8.1 | x64/x86 | | | |
| Windows RT 8.1 |  | | | |
| Windows 7 | x64/x86 | | SP1 | &#10004; |
| Windows Server 2016 | | | | |
| Windows Server 2012 | | R2 | | |
| Windows Server 2012 | | | | |
| Windows Server 2008 | x64/x86 | | SP2 | |
| Windows Server 2008 | x64 | R2 | SP1 | |
| Windows Server      |                  | 1803 |        |                    |
| Windows Server      |                  | 1709 |        |                    |

#### Patch

```
https://portal.msrc.microsoft.com/en-US/security-guidance/advisory/CVE-2019-0623
```

#### Utilization

CompilerEnvironment

- VS2019（V142）X86 Debug

POC is only valid for the X86 machine, the test machine is Windows 7 SP1 X86

![](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2019-0623_win_7_sp1_x86.gif)



#### Analyze
- https://paper.seebug.org/832/



#### ProjectSource

- [DreamoneOnly](https://github.com/DreamoneOnly/CVE-2019-0623-32-exp)