### CVE-2018-8639

#### Describe

An elevation of privilege vulnerability exists in Windows when the Win32k component fails to properly handle objects in memory, aka "Win32k Elevation of Privilege Vulnerability." 

#### ImpactVersion

| Product             | CPU Architecture | Version | Update | Tested |
| ------------------- | ---------------- | ------- | ------ | ------ |
| Windows 10          | x86/x64          |         |        |        |
| Windows 10          | x86/x64          | 1607    |        |        |
| Windows 10          | x86/x64          | 1703    |        |        |
| Windows 10          | x86/x64/ARM64    | 1709    |        |        |
| Windows 10          | x86/x64/ARM64    | 1803    |        |        |
| Windows 10          | x86/x64/ARM64    | 1809    |        |        |
| Windows 7           | x86/x64          |         | SP1    |        |
| Windows 8.1         | x86/x64          |         |        |        |
| Windows Rt 8.1      |                  |         |        |        |
| Windows Server 2008 | x86/x64          |         | SP2    |        |
| Windows Server 2008 | x86/x64          | R2      | SP1    |        |
| Windows Server 2012 |                  |         |        |        |
| Windows Server 2012 |                  | R2      |        |        |
| Windows Server 2016 |                  |         |        |        |
| Windows Server 2019 |                  |         |        |        |
| Windows Server      |                  | 1803    |        |        |
| Windows Server      |                  | 1709    |        |        |

#### Patch

```
https://portal.msrc.microsoft.com/en-US/security-guidance/advisory/CVE-2018-8639
```

#### Utilization

CompilerEnvironment

- VS2019（V140）X64 Release

Windows 2008 R2 SP1 X64 test passed EXP, directly on GIF map

![2](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2018-8639_win2008_r2_sp1_x64.gif)



CompilerEnvironment

- VS2019 (V120) X64 Debug, need to install the following package as support

  ```
  https://www.microsoft.com/zh-cn/download/confirmation.aspx?id=40770
  ```

Windows 7 SP1 X64 test via EXP, on GIF map

![3](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2018-8639_win7_sp1_x64.gif)

#### Analyze
- https://www.anquanke.com/post/id/183358
- https://bbs.pediy.com/thread-251400.htm
- https://bbs.pediy.com/thread-254305.htm