## CVE-2018-8453

#### Describe

An elevation of privilege vulnerability exists in Windows when the Win32k component fails to properly handle objects in memory, aka "Win32k Elevation of Privilege Vulnerability."

#### ImpactVersion

| Product             | CPU Architecture | Version | Update | Tested             |
| ------------------- | ---------------- | ------- | ------ | ------------------ |
| Windows 10          | x86/x64          |         |        |                    |
| Windows 10          | x86/x64          | 1607    |        |                    |
| Windows 10          | x86/x64          | 1703    |        |                    |
| Windows 10          | x86/x64          | 1709    |        | &#10004; |
| Windows 10          | x86/x64          | 1803    |        |                    |
| Windows 10          | x86/x64          | 1809    |        |                    |
| Windows 7           | x86/x64          |         | SP1    |                    |
| Windows 8.1         | x86/x64          |         |        |                    |
| Windows Rt 8.1      |                  |         |        |                    |
| Windows Server 2008 | x86/x64          |         | SP2    |                    |
| Windows Server 2008 | x86/x64          | R2      | SP1    |                    |
| Windows Server 2012 |                  |         |        |                    |
| Windows Server 2012 |                  | R2      |        |                    |
| Windows Server 2016 |                  |         |        |                    |
| Windows Server 2019 |                  |         |        |                    |
| Windows Server      |                  | 1709    |        |                    |
| Windows Server      |                  | 1803    |        |                    |

#### Patch

```
https://portal.msrc.microsoft.com/en-US/security-guidance/advisory/CVE-2018-8453
```

#### Utilization

CompilerEnvironment

- VS2019 （V140）X64 Release

Test system Windows 10 1709 x64

![CVE-2018-8453](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2018-8453_win10_1709_x64.gif)

#### Analyze
- https://github.com/thepwnrip/leHACK-Analysis-of-CVE-2018-8453
- https://www.anquanke.com/post/id/162894
- https://paper.seebug.org/784/
- https://paper.seebug.org/798/
- https://bbs.pediy.com/thread-249021.htm
- https://www.jianshu.com/p/082bd9992b57
- https://www.whsgwl.net/blog/CVE-2018-8453_0.html
- https://www.whsgwl.net/blog/CVE-2018-8453_1.html

#### ProjectSource

- [ze0r](https://github.com/ze0r/cve-2018-8453-exp)