## CVE-2018-8453

#### 描述

Microsoft Windows中存在提权漏洞，该漏洞源于Win32k组件没有正确的处理内存对象。本地攻击者可通过登录系统并运行特制的应用程序，利用该漏洞在内核模式下以提升的权限执行代码。

#### 影响版本

| Product             | CPU Architecture | Version | Update | Tested             |
| ------------------- | ---------------- | ------- | ------ | ------------------ |
| Windows 10          | x86/x64          |         |        |                    |
| Windows 10          | x86/x64          | 1607    |        |                    |
| Windows 10          | x86/x64          | 1703    |        |                    |
| Windows 10          | x86/x64          | 1709    |        | &#10004; |
| Windows 10          | x86/x64          | 1803    |        |                    |
| Windows 10          | x86/x64          | 1809    |        |                    |
| Windows 7           | x86/x64          |         | SP1    |                    |
| Windows 8.1         | x86/x64          |         |        |                    |
| Windows Rt 8.1      |                  |         |        |                    |
| Windows Server 2008 | x86/x64          |         | SP2    |                    |
| Windows Server 2008 | x86/x64          | R2      | SP1    |                    |
| Windows Server 2012 |                  |         |        |                    |
| Windows Server 2012 |                  | R2      |        |                    |
| Windows Server 2016 |                  |         |        |                    |
| Windows Server 2019 |                  |         |        |                    |
| Windows Server      |                  | 1709    |        |                    |
| Windows Server      |                  | 1803    |        |                    |

#### 修复补丁

```
https://portal.msrc.microsoft.com/en-US/security-guidance/advisory/CVE-2018-8453
```

#### 利用方式

编译环境

- VS2019 （V140）X64 Release

测试系统Windows 10 1709 x64

![CVE-2018-8453](https://raw.github.com/Ascotbe/Image/master/Kernelhub/CVE-2018-8453_win10_1709_x64.gif)

#### 分析文章
- https://github.com/thepwnrip/leHACK-Analysis-of-CVE-2018-8453
- https://www.anquanke.com/post/id/162894
- https://paper.seebug.org/784/
- https://paper.seebug.org/798/
- https://bbs.pediy.com/thread-249021.htm
- https://www.jianshu.com/p/082bd9992b57
- https://www.whsgwl.net/blog/CVE-2018-8453_0.html
- https://www.whsgwl.net/blog/CVE-2018-8453_1.html

#### 项目来源

- [ze0r](https://github.com/ze0r/cve-2018-8453-exp)